############################################################################
#
#  Program:         SuperLU_DIST
#
#  Module:          make.inc
#
#  Purpose:         Top-level Definitions
#
#  Creation date:   March 1, 2016	version 5.0.0
#
#  Modified:	    
#		    
#
############################################################################
#
#  The name of the libraries to be created/linked to
#
VERSION		= 5.1.2
SuperLUroot	= /home/xiaoye/Dropbox/Codes/SuperLU/SuperLU_DIST_${VERSION}
DSUPERLULIB   	= $(SuperLUroot)/lib/libsuperlu_dist.a

# BLASDEF 	= -DUSE_VENDOR_BLAS

PARMETIS_DIR	:= ${HOME}/lib/static/64-bit/parmetis-4.0.3
I_PARMETIS := -I${PARMETIS_DIR}/include -I${PARMETIS_DIR}/metis/include
METISLIB := -L${PARMETIS_DIR}/build/Linux-x86_64/libmetis -lmetis
PARMETISLIB := -L${PARMETIS_DIR}/build/Linux-x86_64/libparmetis -lparmetis

LIBS		= $(DSUPERLULIB) /usr/lib/libf77blas.so /usr/lib/libatlas.so \
		${PARMETISLIB} ${METISLIB}

#
#  The archiver and the flag(s) to use when building archive (library)
#  If your system has no ranlib, set RANLIB = echo.
#
ARCH         = /usr/bin/ar
ARCHFLAGS    = cr
RANLIB       = /usr/bin/ranlib

CC           = /home/xiaoye/mpich-install/bin/mpicc
CFLAGS 	     = -DNDEBUG -DUSE_VENDOR_BLAS -DAdd_ -DDEBUGlevel=0 -DPRNTlevel=1 -std=c99 -fPIC -g ${I_PARMETIS}
CFLAGS       += -D_LONGINT
# CFLAGS       +=  
NOOPTS       = -O0
FORTRAN	     = /usr/bin/gfortran

LOADER       = $(CC)
LOADOPTS     = -Wl,-rpath=/home/xiaoye/Dropbox/Codes/SuperLU/SuperLU_DIST_${VERSION}/lib -g # -Wl,-Bdynamic
