############################################################################
#
#  Program:         SuperLU_DIST
#
#  Module:          make.inc
#
#  Purpose:         Top-level Definitions
#
#  Creation date:   February 4, 1999   version alpha
#
#  Modified:	    September 1, 1999  version 1.0
#                   March 15, 2003     version 2.0
#		    November 1, 2007   version 2.1
#		    September 1, 2011  version 3.0
#		    December 31, 2015  version 4.3
#
############################################################################
#
#  The machine (platform) identifier to append to the library names
#
## Cori at NERSC
PLAT		= _xc40

#
#  The name of the libraries to be created/linked to
#
DSuperLUroot 	= ${HOME}/Release_Codes/SuperLU_DIST_4.3
DSUPERLULIB   	= $(DSuperLUroot)/lib/libsuperlu_dist_4.3.a
#
BLASDEF	     	= -DUSE_VENDOR_BLAS
BLASLIB	        =
#
############################################################################
## parmetis 4.x.x, 32-bit integer
 PARMETIS_DIR	:= ${HOME}/Edison/lib/parmetis-4.0.3
## parmetis 4.x.x, 64-bit integer
# PARMETIS_DIR	:= ${HOME}/Edison/lib/parmetis-4.0.3_64
PARMETIS_DIR	=/project/projectdirs/mp127/parmetis-4.0.3-g
METISLIB := -L${PARMETIS_DIR}/build/Linux-x86_64/libmetis -lmetis
PARMETISLIB := -L${PARMETIS_DIR}/build/Linux-x86_64/libparmetis -lparmetis
I_PARMETIS := -I${PARMETIS_DIR}/include -I${PARMETIS_DIR}/metis/include
############################################################################

# Define the required Fortran libraries, if you use C compiler to link
# FLIBS	 	= -lpgf90 -lpgf90_rpm1  ## for PGI compiler
#FLIBS	 	= -lifport -lifcore     ## for Intel compiler

# Define all the libraries
LIBS	     	= $(DSUPERLULIB) $(BLASLIB) $(PARMETISLIB) $(METISLIB) $(FLIBS)

#
#  The archiver and the flag(s) to use when building archive (library)
#  If your system has no ranlib, set RANLIB = echo.
#
ARCH         	= ar
ARCHFLAGS    	= cr
RANLIB       	= ranlib

############################################################################
# C compiler setup
CC           	= cc
# CFLAGS should be set to be the C flags that include optimization
CFLAGS          = -fast -m64 -std=c99 -Wall -openmp \
		$(I_PARMETIS) -DDEBUGlevel=0 -DPRNTlevel=0 -DPROFlevel=0 \
# uncomment the following to use 64-bit integer
# CFLAGS 		+= -D_LONGINT

# NOOPTS should be set to be the C flags that turn off any optimization
NOOPTS		= -O0 -std=c99
############################################################################
# FORTRAN compiler setup
FORTRAN         = ftn
F90FLAGS	= -fast #-Mipa=fast,safe
# uncomment the following to use 64-bit integer
# F90FLAGS	+= -i8
############################################################################
LOADER	        = $(CC)
LOADOPTS	= -openmp
############################################################################
#  C preprocessor defs for compilation (-DNoChange, -DAdd_, or -DUpCase)
#
#  Need follow the convention of how C calls a Fortran routine.
#
CDEFS        = -DAdd_
