/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   Copyright (c) 2012-2015 The plumed team
   (see the PEOPLE file at the root of the distribution for a list of names)

   See http://www.plumed-code.org for more information.

   This file is part of plumed, version 2.

   plumed is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   plumed is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with plumed.  If not, see <http://www.gnu.org/licenses/>.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
#include "MetricRegister.h"
#include "ArgumentOnlyDistance.h"

namespace PLMD {

class EuclideanDistance : public ArgumentOnlyDistance {
public:
  EuclideanDistance( const ReferenceConfigurationOptions& ro );
  bool pcaIsEnabledForThisReference(){ return true; }
  void setupPCAStorage( ReferenceValuePack& mypack ){ mypack.switchOnPCAOption(); }
};

PLUMED_REGISTER_METRIC(EuclideanDistance,"EUCLIDEAN")

EuclideanDistance::EuclideanDistance( const ReferenceConfigurationOptions& ro ):
ReferenceConfiguration(ro),
ArgumentOnlyDistance(ro)
{
}

}
