#!/usr/bin/env python3

from pyscf import gto
from pyscf import mcscf

import os, sys

sys.path.append('./')
from model import set_model


if __name__ == '__main__':
    if len(sys.argv) == 4:
        n_atoms = int(sys.argv[1])
        n_states = int(sys.argv[2])
        curr_state = int(sys.argv[3])
    else:
        print(f'Expeted input to be:')
        print(f'{sys.argv[0]} n_atoms n_states curr_state')

    update_chk = True

    # Read molecule
    mol = gto.M(atom='geom.xyz', 
                basis='6-31g*',
                spin=0,
                unit='Bohr')

    mycas = set_model(mol)
    if os.path.isfile('casscf.chk'):
        _, init_guess = mcscf.chkfile.load_mcscf('casscf.chk')
        mo = mcscf.project_init_guess(mycas, init_guess['mo_coeff'])

        mycas.kernel(mo)
    else:
        mycas.kernel()

    if update_chk:
        mcscf.chkfile.dump_mcscf(mycas, 'casscf.chk')

    txt = ''
    for s in range(n_states):
        txt += f'{mycas.e_states[s]}\n'
    with open('epot', 'w') as f:
        f.write(txt)

    mc_grad = mycas.nuc_grad_method()
    g = mc_grad.kernel(state=curr_state - 1)
    with open('grad', 'w') as f:
        for a in range(n_atoms):
            f.write(f'{g[a,0]} \t {g[a,1]} \t {g[a,2]}\n')

