#!/usr/bin/env python3

from pyscf import dft, mcpdft

import numpy as np

def set_model(mol):
    myhf = dft.RKS(mol, xc='pbe,pbe')
    myhf.verbose = 0
    myhf.run()

    # Setting CASSCF
    n_states = 2
    ncas, nelecas = (6,6)
    weights = np.ones(n_states)/n_states
    mycas = mcpdft.CASSCF(myhf, 'tpbe', ncas, nelecas).multi_state(weights, 'lin')
    mycas.fix_spin_(ss=0)
    mycas.verbose = 0

    return mycas
