//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//  
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.


#ifndef MCL_TESTMACROS_H_
#define MCL_TESTMACROS_H_

#if defined(_WIN32) || defined(_WIN64)
#define ADD_ENV_VAR(NAME, VALUE) { if (_putenv(NAME "=" VALUE) != 0) throw std::runtime_error("Could_not_set_env_var!"); }
#else 
#define ADD_ENV_VAR(NAME, VALUE) { if (setenv(NAME, VALUE, 1) != 0) throw std::runtime_error("Could_not_set_env_var!"); }
#endif

#if defined(_WIN32) || defined(_WIN64)
#define SET_ENV_CONTROL(CONTROL, VALUE) { if (_putenv(CONTROL.name() "=" VALUE) != 0) throw std::runtime_error("Could_not_set_env_var!"); }
#else 
#define SET_ENV_CONTROL(CONTROL, VALUE) { if (setenv(CONTROL.name(), VALUE, 1) != 0) throw std::runtime_error("Could_not_set_env_var!"); }
#endif

#endif // MCL_TESTMACROS_H_
