//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MCL_TRANSPORT_MPIPORTTRANSPORT_H_
#define MCL_TRANSPORT_MPIPORTTRANSPORT_H_

#include "mpi_mpmd_transport.h"

namespace mcl {

/// MPI-based transport layer implementation using intercommunicators obtained
/// by connecting independently launched programs.
class MpiPortTransport : public MpiMpmdTransport {
  
  
  public:
    explicit MpiPortTransport(void *args) : MpiMpmdTransport(args), timeout_(0) { }
    ~MpiPortTransport() override = default;

    int Initialize(void *args) override;


  private:
    /// Main initialization function, which is defined separately for timing its
    /// execution and which is terminated in the case of a timeout.
    ///   \return Error code.
    int InnerInitialize();
    
    
    int timeout_;   ///< Timeout in milliseconds.

};

} // namespace mcl

#endif // MCL_TRANSPORT_MPIPORTTRANSPORT_H_
