//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MCL_TRANSPORT_MPIMPMDTRANSPORT_H_
#define MCL_TRANSPORT_MPIMPMDTRANSPORT_H_

#include <vector>

#include "mpi.h"

#include "transport.h"

namespace mcl {

/// MPI-based transport layer implementation using intercommunicators obtained
/// by splitting the joint MPI_COMM_WORLD communicator (MPMD launch).
class MpiMpmdTransport : public Transport {

  public:
    explicit MpiMpmdTransport(void *args) : Transport(),
                                            world_comm_(*static_cast<MPI_Comm *>(args)),
                                            local_comm_(*static_cast<MPI_Comm *>(args)),
                                            intercomm_(MPI_COMM_NULL) { }
    ~MpiMpmdTransport() override = default;

    virtual int Initialize(void *args) override;
    int Finalize() override { return 0; };
    int Abort(int error_code) override;
    int Send(void *data, int length, int data_type, int tag, int destination) override;
    int Receive(void *data, int length, int data_type, int tag, int source) override;
    int ProbeSize(int data_type, int source) override;

  protected:
    MPI_Comm world_comm_;   ///< World communicator including all processes of all programs.
    MPI_Comm local_comm_;   ///< Local communicator for communication within a single program.
    MPI_Comm intercomm_;    ///< Intercommunicator between different programs.

};

} // namespace mcl

#endif // MCL_TRANSPORT_MPIMPMDTRANSPORT_H_
