//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MCL_ERRORCODES_H_
#define MCL_ERRORCODES_H_

#include "preproc_constants.inc"

namespace mcl {

/// Correct termination of a function [0].
constexpr int kSuccess = PP_SUCCESS;

/// MCL is not initialized.
constexpr int kMclNotInit = PP_MCL_NOT_INIT;

/// MCL is already initialized.
constexpr int kMclAlreadyInit = PP_MCL_ALREADY_INIT;

/// MPI Port transport initialization timed out.
constexpr int kErrMpiTimeout = PP_MPI_TIMEOUT;

/// MPI failed during initialization.
constexpr int kErrMpiInitFail = PP_MPI_INIT_FAIL;

/// MPI communication failed.
constexpr int kErrMpiCommFail = PP_MPI_COMM_FAIL;

/// Required file is not available.
constexpr int kErrFileMissing = PP_FILE_MISSING;

/// Nonexisting endpoint was invoked.
constexpr int kErrEndpointNotFound = PP_ENDPOINT_NOT_FOUND;

/// Missing required environment variable (or invalid value).
constexpr int kErrInvalidEnvVar = PP_INVALID_ENVVAR;

/// Unknown data type requested.
constexpr int kErrUnknownType = PP_UNKNOWN_TYPE;

/// Mismatch between the Stub transport call and logged information.
constexpr int kErrLogMismatch = PP_LOG_MISMATCH;

} // namespace mcl

#endif // MCL_ERRORCODES_H_
