//    MCL: MiMiC Communication Library
//    Copyright (C) 2015-2025  The MiMiC Authors (see CONTRIBUTORS file for details).
//
//    This file is part of MCL.
//
//    MCL is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation, either version 3 of
//    the License, or (at your option) any later version.
//
//    MCL is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MCL_DATATYPES_H_
#define MCL_DATATYPES_H_

#include "preproc_constants.inc"

namespace mcl {

// contains data types supported by the library

constexpr int kTypeChar = PP_TYPE_CHAR;

constexpr int kTypeInt = PP_TYPE_INT;

constexpr int kTypeLongInt = PP_TYPE_LONG_INT;

constexpr int kTypeFloat = PP_TYPE_FLOAT;

constexpr int kTypeDouble = PP_TYPE_DOUBLE;

int TypeSizeInBytes (int data_type);

} // namespace mcl

#endif // MCL_DATATYPES_H_
