#!/usr/bin/env bash

if [[ $1 == "unary_simple" ]]; then
  export PREC_LIST="F32_F32_F32";
  if [[ ${LIBXSMM_TARGET} == "hsw" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32 F16_F16_F32 F32_F16_F32 F16_F32_F32 F64_F64_F64";
  fi
  if [[ ${LIBXSMM_TARGET} == "neov1" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32";
  fi
  if [[ ${LIBXSMM_TARGET} == "clx" ||  ${LIBXSMM_TARGET} == "cpx" ||  ${LIBXSMM_TARGET} == "spr" || ${LIBXSMM_TARGET} == "avx512_vl256_clx" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32 F16_F16_F32 F32_F16_F32 F16_F32_F32 BF8_BF8_F32 F32_BF8_F32 BF8_F32_F32 HF8_HF8_F32 F32_HF8_F32 HF8_F32_F32 F64_F64_F64";
  fi
fi

if [[ $1 == "unary_no_simple" ]]; then
  export PREC_LIST="F32_F32_F32";
  if [[ ${LIBXSMM_TARGET} == "hsw" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32 F16_F16_F32 F32_F16_F32 F16_F32_F32";
  fi
  if [[ ${LIBXSMM_TARGET} == "neov1" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32";
  fi
  if [[ ${LIBXSMM_TARGET} == "clx" ||  ${LIBXSMM_TARGET} == "cpx" ||  ${LIBXSMM_TARGET} == "spr" || ${LIBXSMM_TARGET} == "avx512_vl256_clx" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32 F16_F16_F32 F32_F16_F32 F16_F32_F32 BF8_BF8_F32 F32_BF8_F32 BF8_F32_F32 HF8_HF8_F32 F32_HF8_F32 HF8_F32_F32";
  fi
fi

if [[ $1 == "unary_copy" ]]; then
  export PREC_LIST="F32_F32_F32";
  if [[ ${LIBXSMM_TARGET} == "hsw" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_BF16 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32 F16_F16_F16 F16_F16_F32 F32_F16_F32 F16_F32_F32 F64_F64_F64";
  fi
  if [[ ${LIBXSMM_TARGET} == "neov1" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_BF16 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32";
  fi
  if [[ ${LIBXSMM_TARGET} == "clx" ||  ${LIBXSMM_TARGET} == "cpx" ||  ${LIBXSMM_TARGET} == "spr" || ${LIBXSMM_TARGET} == "avx512_vl256_clx" ]]; then
    export PREC_LIST="F32_F32_F32 BF16_BF16_BF16 BF16_BF16_F32 F32_BF16_F32 BF16_F32_F32 F16_F16_F16 F16_F16_F32 F32_F16_F32 F16_F32_F32 BF8_BF8_BF8 BF8_BF8_F32 F32_BF8_F32 BF8_F32_F32 HF8_HF8_HF8 HF8_HF8_F32 F32_HF8_F32 HF8_F32_F32 F64_F64_F64";
  fi
fi

if [[ $1 == "unary_reduce" ]]; then
  export PREC_LIST="F32";
  if [[ ${LIBXSMM_TARGET} == "hsw" ]]; then
  export PREC_LIST="F32 BF16 F16 F64";
  fi
  if [[ ${LIBXSMM_TARGET} == "neov1" ]]; then
  export PREC_LIST="F32 BF16";
  fi
  if [[ ${LIBXSMM_TARGET} == "clx" ||  ${LIBXSMM_TARGET} == "cpx" ||  ${LIBXSMM_TARGET} == "spr" || ${LIBXSMM_TARGET} == "avx512_vl256_clx" ]]; then
  export PREC_LIST="F32 BF16 F16 BF8 HF8 F64";
  fi
fi

if [[ $1 == "unary_reduce_colsidx" ]]; then
  export PREC_LIST="F32";
  if [[ ${LIBXSMM_TARGET} == "hsw" ]]; then
  export PREC_LIST="F32 BF16 F16";
  fi
  if [[ ${LIBXSMM_TARGET} == "neov1" ]]; then
  export PREC_LIST="F32 BF16";
  fi
  if [[ ${LIBXSMM_TARGET} == "clx" ||  ${LIBXSMM_TARGET} == "cpx" ||  ${LIBXSMM_TARGET} == "spr" || ${LIBXSMM_TARGET} == "avx512_vl256_clx" ]]; then
  export PREC_LIST="F32 BF16 F16 BF8 HF8";
  fi
fi

if [[ $1 == "binary_simple" ]]; then
  export PREC_LIST="F32_F32_F32_F32";
  if [[ ${LIBXSMM_TARGET} == "hsw" ]]; then
    export PREC_LIST="F32_F32_F32_F32 F32_F32_BF16_F32 F32_BF16_F32_F32 F32_BF16_BF16_F32 BF16_F32_F32_F32 BF16_F32_BF16_F32 BF16_BF16_F32_F32 BF16_BF16_BF16_F32 F32_F32_F16_F32 F32_F16_F32_F32 F32_F16_F16_F32 F16_F32_F32_F32 F16_F32_F16_F32 F16_F16_F32_F32 F16_F16_F16_F32 F64_F64_F64_F64";
  fi
  if [[ ${LIBXSMM_TARGET} == "neov1" ]]; then
    export PREC_LIST="F32_F32_F32_F32 F32_F32_BF16_F32 F32_BF16_F32_F32 F32_BF16_BF16_F32 BF16_F32_F32_F32 BF16_F32_BF16_F32 BF16_BF16_F32_F32 BF16_BF16_BF16_F32";
  fi
  if [[ ${LIBXSMM_TARGET} == "clx" ||  ${LIBXSMM_TARGET} == "cpx" ||  ${LIBXSMM_TARGET} == "spr" || ${LIBXSMM_TARGET} == "avx512_vl256_clx" ]]; then
    export PREC_LIST="F32_F32_F32_F32 F32_F32_BF16_F32 F32_BF16_F32_F32 F32_BF16_BF16_F32 BF16_F32_F32_F32 BF16_F32_BF16_F32 BF16_BF16_F32_F32 BF16_BF16_BF16_F32 F32_F32_F16_F32 F32_F16_F32_F32 F32_F16_F16_F32 F16_F32_F32_F32 F16_F32_F16_F32 F16_F16_F32_F32 F16_F16_F16_F32 F32_F32_BF8_F32 F32_BF8_F32_F32 F32_BF8_BF8_F32 BF8_F32_F32_F32 BF8_F32_BF8_F32 BF8_BF8_F32_F32 BF8_BF8_BF8_F32 F32_F32_HF8_F32 F32_HF8_F32_F32 F32_HF8_HF8_F32 HF8_F32_F32_F32 HF8_F32_HF8_F32 HF8_HF8_F32_F32 HF8_HF8_HF8_F32 F64_F64_F64_F64";
  fi
fi

if [[ ${LIBXSMM_TARGET} == "snb" ]]; then
    exit 0;
fi
if [[ ${LIBXSMM_TARGET} == "wsm" ]]; then
    exit 0;
fi

