#ifndef GIMMIK_H
#define GIMMIK_H

#include <libxsmm_utils.h>
#include <libxsmm.h>

#define N 40
#define LDB 40
#define LDC 40

LIBXSMM_INLINE
void gimmik_p1_hex_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.366025403784439*b[i + 0*ldb] + -0.3660254037844387*b[i + 4*ldb]);
        c[i + 1*ldc] = (1.366025403784439*b[i + 1*ldb] + -0.3660254037844387*b[i + 5*ldb]);
        c[i + 2*ldc] = (1.366025403784439*b[i + 2*ldb] + -0.3660254037844387*b[i + 6*ldb]);
        c[i + 3*ldc] = (1.366025403784439*b[i + 3*ldb] + -0.3660254037844387*b[i + 7*ldb]);
        c[i + 4*ldc] = (1.366025403784439*b[i + 0*ldb] + -0.3660254037844387*b[i + 2*ldb]);
        c[i + 5*ldc] = (1.366025403784439*b[i + 1*ldb] + -0.3660254037844387*b[i + 3*ldb]);
        c[i + 6*ldc] = (1.366025403784439*b[i + 4*ldb] + -0.3660254037844387*b[i + 6*ldb]);
        c[i + 7*ldc] = (1.366025403784439*b[i + 5*ldb] + -0.3660254037844387*b[i + 7*ldb]);
        c[i + 8*ldc] = (-0.3660254037844387*b[i + 0*ldb] + 1.366025403784439*b[i + 1*ldb]);
        c[i + 9*ldc] = (-0.3660254037844387*b[i + 2*ldb] + 1.366025403784439*b[i + 3*ldb]);
        c[i + 10*ldc] = (-0.3660254037844387*b[i + 4*ldb] + 1.366025403784439*b[i + 5*ldb]);
        c[i + 11*ldc] = (-0.3660254037844387*b[i + 6*ldb] + 1.366025403784439*b[i + 7*ldb]);
        c[i + 12*ldc] = (-0.3660254037844387*b[i + 0*ldb] + 1.366025403784439*b[i + 2*ldb]);
        c[i + 13*ldc] = (-0.3660254037844387*b[i + 1*ldb] + 1.366025403784439*b[i + 3*ldb]);
        c[i + 14*ldc] = (-0.3660254037844387*b[i + 4*ldb] + 1.366025403784439*b[i + 6*ldb]);
        c[i + 15*ldc] = (-0.3660254037844387*b[i + 5*ldb] + 1.366025403784439*b[i + 7*ldb]);
        c[i + 16*ldc] = (1.366025403784439*b[i + 0*ldb] + -0.3660254037844387*b[i + 1*ldb]);
        c[i + 17*ldc] = (1.366025403784439*b[i + 2*ldb] + -0.3660254037844387*b[i + 3*ldb]);
        c[i + 18*ldc] = (1.366025403784439*b[i + 4*ldb] + -0.3660254037844387*b[i + 5*ldb]);
        c[i + 19*ldc] = (1.366025403784439*b[i + 6*ldb] + -0.3660254037844387*b[i + 7*ldb]);
        c[i + 20*ldc] = (-0.3660254037844387*b[i + 0*ldb] + 1.366025403784439*b[i + 4*ldb]);
        c[i + 21*ldc] = (-0.3660254037844387*b[i + 1*ldb] + 1.366025403784439*b[i + 5*ldb]);
        c[i + 22*ldc] = (-0.3660254037844387*b[i + 2*ldb] + 1.366025403784439*b[i + 6*ldb]);
        c[i + 23*ldc] = (-0.3660254037844387*b[i + 3*ldb] + 1.366025403784439*b[i + 7*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_hex_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (1.366025403784439*b[i + 0*ldb] + 1.366025403784439*b[i + 4*ldb] + -0.3660254037844384*b[i + 8*ldb] + -0.3660254037844384*b[i + 12*ldb] + 1.366025403784439*b[i + 16*ldb] + -0.3660254037844384*b[i + 20*ldb]);
        c[i + 1*ldc] += (1.366025403784439*b[i + 1*ldb] + 1.366025403784439*b[i + 5*ldb] + 1.366025403784439*b[i + 8*ldb] + -0.3660254037844384*b[i + 13*ldb] + -0.3660254037844384*b[i + 16*ldb] + -0.3660254037844384*b[i + 21*ldb]);
        c[i + 2*ldc] += (1.366025403784439*b[i + 2*ldb] + -0.3660254037844384*b[i + 4*ldb] + -0.3660254037844384*b[i + 9*ldb] + 1.366025403784439*b[i + 12*ldb] + 1.366025403784439*b[i + 17*ldb] + -0.3660254037844384*b[i + 22*ldb]);
        c[i + 3*ldc] += (1.366025403784439*b[i + 3*ldb] + -0.3660254037844384*b[i + 5*ldb] + 1.366025403784439*b[i + 9*ldb] + 1.366025403784439*b[i + 13*ldb] + -0.3660254037844384*b[i + 17*ldb] + -0.3660254037844384*b[i + 23*ldb]);
        c[i + 4*ldc] += (-0.3660254037844384*b[i + 0*ldb] + 1.366025403784439*b[i + 6*ldb] + -0.3660254037844384*b[i + 10*ldb] + -0.3660254037844384*b[i + 14*ldb] + 1.366025403784439*b[i + 18*ldb] + 1.366025403784439*b[i + 20*ldb]);
        c[i + 5*ldc] += (-0.3660254037844384*b[i + 1*ldb] + 1.366025403784439*b[i + 7*ldb] + 1.366025403784439*b[i + 10*ldb] + -0.3660254037844384*b[i + 15*ldb] + -0.3660254037844384*b[i + 18*ldb] + 1.366025403784439*b[i + 21*ldb]);
        c[i + 6*ldc] += (-0.3660254037844384*b[i + 2*ldb] + -0.3660254037844384*b[i + 6*ldb] + -0.3660254037844384*b[i + 11*ldb] + 1.366025403784439*b[i + 14*ldb] + 1.366025403784439*b[i + 19*ldb] + 1.366025403784439*b[i + 22*ldb]);
        c[i + 7*ldc] += (-0.3660254037844384*b[i + 3*ldb] + -0.3660254037844384*b[i + 7*ldb] + 1.366025403784439*b[i + 11*ldb] + 1.366025403784439*b[i + 15*ldb] + -0.3660254037844384*b[i + 19*ldb] + 1.366025403784439*b[i + 23*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_hex_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (-0.3660254037844384*b[i + 8*ldb] + -1.366025403784439*b[i + 16*ldb]);
        c[i + 1*ldc] += (1.366025403784439*b[i + 8*ldb] + 0.3660254037844384*b[i + 16*ldb]);
        c[i + 2*ldc] += (-0.3660254037844384*b[i + 9*ldb] + -1.366025403784439*b[i + 17*ldb]);
        c[i + 3*ldc] += (1.366025403784439*b[i + 9*ldb] + 0.3660254037844384*b[i + 17*ldb]);
        c[i + 4*ldc] += (-0.3660254037844384*b[i + 10*ldb] + -1.366025403784439*b[i + 18*ldb]);
        c[i + 5*ldc] += (1.366025403784439*b[i + 10*ldb] + 0.3660254037844384*b[i + 18*ldb]);
        c[i + 6*ldc] += (-0.3660254037844384*b[i + 11*ldb] + -1.366025403784439*b[i + 19*ldb]);
        c[i + 7*ldc] += (1.366025403784439*b[i + 11*ldb] + 0.3660254037844384*b[i + 19*ldb]);
        c[i + 8*ldc] += (-1.366025403784439*b[i + 4*ldb] + -0.3660254037844384*b[i + 12*ldb]);
        c[i + 9*ldc] += (-1.366025403784439*b[i + 5*ldb] + -0.3660254037844384*b[i + 13*ldb]);
        c[i + 10*ldc] += (0.3660254037844384*b[i + 4*ldb] + 1.366025403784439*b[i + 12*ldb]);
        c[i + 11*ldc] += (0.3660254037844384*b[i + 5*ldb] + 1.366025403784439*b[i + 13*ldb]);
        c[i + 12*ldc] += (-1.366025403784439*b[i + 6*ldb] + -0.3660254037844384*b[i + 14*ldb]);
        c[i + 13*ldc] += (-1.366025403784439*b[i + 7*ldb] + -0.3660254037844384*b[i + 15*ldb]);
        c[i + 14*ldc] += (0.3660254037844384*b[i + 6*ldb] + 1.366025403784439*b[i + 14*ldb]);
        c[i + 15*ldc] += (0.3660254037844384*b[i + 7*ldb] + 1.366025403784439*b[i + 15*ldb]);
        c[i + 16*ldc] += (-1.366025403784439*b[i + 0*ldb] + -0.3660254037844384*b[i + 20*ldb]);
        c[i + 17*ldc] += (-1.366025403784439*b[i + 1*ldb] + -0.3660254037844384*b[i + 21*ldb]);
        c[i + 18*ldc] += (-1.366025403784439*b[i + 2*ldb] + -0.3660254037844384*b[i + 22*ldb]);
        c[i + 19*ldc] += (-1.366025403784439*b[i + 3*ldb] + -0.3660254037844384*b[i + 23*ldb]);
        c[i + 20*ldc] += (0.3660254037844384*b[i + 0*ldb] + 1.366025403784439*b[i + 20*ldb]);
        c[i + 21*ldc] += (0.3660254037844384*b[i + 1*ldb] + 1.366025403784439*b[i + 21*ldb]);
        c[i + 22*ldc] += (0.3660254037844384*b[i + 2*ldb] + 1.366025403784439*b[i + 22*ldb]);
        c[i + 23*ldc] += (0.3660254037844384*b[i + 3*ldb] + 1.366025403784439*b[i + 23*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_hex_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (0.8660254037844384*b[i + 0*ldb] + 0.8660254037844384*b[i + 1*ldb]);
        c[i + 1*ldc] = (-0.8660254037844384*b[i + 0*ldb] + -0.8660254037844384*b[i + 1*ldb]);
        c[i + 2*ldc] = (0.8660254037844384*b[i + 2*ldb] + 0.8660254037844384*b[i + 3*ldb]);
        c[i + 3*ldc] = (-0.8660254037844384*b[i + 2*ldb] + -0.8660254037844384*b[i + 3*ldb]);
        c[i + 4*ldc] = (0.8660254037844384*b[i + 4*ldb] + 0.8660254037844384*b[i + 5*ldb]);
        c[i + 5*ldc] = (-0.8660254037844384*b[i + 4*ldb] + -0.8660254037844384*b[i + 5*ldb]);
        c[i + 6*ldc] = (0.8660254037844384*b[i + 6*ldb] + 0.8660254037844384*b[i + 7*ldb]);
        c[i + 7*ldc] = (-0.8660254037844384*b[i + 6*ldb] + -0.8660254037844384*b[i + 7*ldb]);
        c[i + 8*ldc] = (0.8660254037844384*b[i + 0*ldb] + 0.8660254037844384*b[i + 2*ldb]);
        c[i + 9*ldc] = (0.8660254037844384*b[i + 1*ldb] + 0.8660254037844384*b[i + 3*ldb]);
        c[i + 10*ldc] = (-0.8660254037844384*b[i + 0*ldb] + -0.8660254037844384*b[i + 2*ldb]);
        c[i + 11*ldc] = (-0.8660254037844384*b[i + 1*ldb] + -0.8660254037844384*b[i + 3*ldb]);
        c[i + 12*ldc] = (0.8660254037844384*b[i + 4*ldb] + 0.8660254037844384*b[i + 6*ldb]);
        c[i + 13*ldc] = (0.8660254037844384*b[i + 5*ldb] + 0.8660254037844384*b[i + 7*ldb]);
        c[i + 14*ldc] = (-0.8660254037844384*b[i + 4*ldb] + -0.8660254037844384*b[i + 6*ldb]);
        c[i + 15*ldc] = (-0.8660254037844384*b[i + 5*ldb] + -0.8660254037844384*b[i + 7*ldb]);
        c[i + 16*ldc] = (0.8660254037844384*b[i + 0*ldb] + 0.8660254037844384*b[i + 4*ldb]);
        c[i + 17*ldc] = (0.8660254037844384*b[i + 1*ldb] + 0.8660254037844384*b[i + 5*ldb]);
        c[i + 18*ldc] = (0.8660254037844384*b[i + 2*ldb] + 0.8660254037844384*b[i + 6*ldb]);
        c[i + 19*ldc] = (0.8660254037844384*b[i + 3*ldb] + 0.8660254037844384*b[i + 7*ldb]);
        c[i + 20*ldc] = (-0.8660254037844384*b[i + 0*ldb] + -0.8660254037844384*b[i + 4*ldb]);
        c[i + 21*ldc] = (-0.8660254037844384*b[i + 1*ldb] + -0.8660254037844384*b[i + 5*ldb]);
        c[i + 22*ldc] = (-0.8660254037844384*b[i + 2*ldb] + -0.8660254037844384*b[i + 6*ldb]);
        c[i + 23*ldc] = (-0.8660254037844384*b[i + 3*ldb] + -0.8660254037844384*b[i + 7*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_hex_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (0.8660254037844384*b[i + 0*ldb] + 0.8660254037844384*b[i + 1*ldb] + 0.8660254037844384*b[i + 8*ldb] + 0.8660254037844384*b[i + 10*ldb] + 0.8660254037844384*b[i + 16*ldb] + 0.8660254037844384*b[i + 20*ldb]);
        c[i + 1*ldc] = (-0.8660254037844384*b[i + 0*ldb] + -0.8660254037844384*b[i + 1*ldb] + 0.8660254037844384*b[i + 9*ldb] + 0.8660254037844384*b[i + 11*ldb] + 0.8660254037844384*b[i + 17*ldb] + 0.8660254037844384*b[i + 21*ldb]);
        c[i + 2*ldc] = (0.8660254037844384*b[i + 2*ldb] + 0.8660254037844384*b[i + 3*ldb] + -0.8660254037844384*b[i + 8*ldb] + -0.8660254037844384*b[i + 10*ldb] + 0.8660254037844384*b[i + 18*ldb] + 0.8660254037844384*b[i + 22*ldb]);
        c[i + 3*ldc] = (-0.8660254037844384*b[i + 2*ldb] + -0.8660254037844384*b[i + 3*ldb] + -0.8660254037844384*b[i + 9*ldb] + -0.8660254037844384*b[i + 11*ldb] + 0.8660254037844384*b[i + 19*ldb] + 0.8660254037844384*b[i + 23*ldb]);
        c[i + 4*ldc] = (0.8660254037844384*b[i + 4*ldb] + 0.8660254037844384*b[i + 5*ldb] + 0.8660254037844384*b[i + 12*ldb] + 0.8660254037844384*b[i + 14*ldb] + -0.8660254037844384*b[i + 16*ldb] + -0.8660254037844384*b[i + 20*ldb]);
        c[i + 5*ldc] = (-0.8660254037844384*b[i + 4*ldb] + -0.8660254037844384*b[i + 5*ldb] + 0.8660254037844384*b[i + 13*ldb] + 0.8660254037844384*b[i + 15*ldb] + -0.8660254037844384*b[i + 17*ldb] + -0.8660254037844384*b[i + 21*ldb]);
        c[i + 6*ldc] = (0.8660254037844384*b[i + 6*ldb] + 0.8660254037844384*b[i + 7*ldb] + -0.8660254037844384*b[i + 12*ldb] + -0.8660254037844384*b[i + 14*ldb] + -0.8660254037844384*b[i + 18*ldb] + -0.8660254037844384*b[i + 22*ldb]);
        c[i + 7*ldc] = (-0.8660254037844384*b[i + 6*ldb] + -0.8660254037844384*b[i + 7*ldb] + -0.8660254037844384*b[i + 13*ldb] + -0.8660254037844384*b[i + 15*ldb] + -0.8660254037844384*b[i + 19*ldb] + -0.8660254037844384*b[i + 23*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_pri_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.366025403784439*b[i + 0*ldb] + -0.3660254037844387*b[i + 3*ldb]);
        c[i + 1*ldc] = (1.366025403784439*b[i + 1*ldb] + -0.3660254037844387*b[i + 4*ldb]);
        c[i + 2*ldc] = (1.366025403784439*b[i + 2*ldb] + -0.3660254037844387*b[i + 5*ldb]);
        c[i + 3*ldc] = (-0.3660254037844387*b[i + 0*ldb] + 1.366025403784439*b[i + 3*ldb]);
        c[i + 4*ldc] = (-0.3660254037844387*b[i + 1*ldb] + 1.366025403784439*b[i + 4*ldb]);
        c[i + 5*ldc] = (-0.3660254037844387*b[i + 2*ldb] + 1.366025403784439*b[i + 5*ldb]);
        c[i + 6*ldc] = (-0.3333333333333348*b[i + 0*ldb] + 0.08931639747704039*b[i + 1*ldb] + 1.244016935856294*b[i + 2*ldb]);
        c[i + 7*ldc] = (-0.3333333333333348*b[i + 0*ldb] + 1.244016935856294*b[i + 1*ldb] + 0.08931639747704039*b[i + 2*ldb]);
        c[i + 8*ldc] = (-0.3333333333333348*b[i + 3*ldb] + 0.08931639747704039*b[i + 4*ldb] + 1.244016935856294*b[i + 5*ldb]);
        c[i + 9*ldc] = (-0.3333333333333348*b[i + 3*ldb] + 1.244016935856294*b[i + 4*ldb] + 0.08931639747704039*b[i + 5*ldb]);
        c[i + 10*ldc] = (0.08931639747704039*b[i + 0*ldb] + 1.244016935856294*b[i + 1*ldb] + -0.3333333333333348*b[i + 2*ldb]);
        c[i + 11*ldc] = (1.244016935856294*b[i + 0*ldb] + 0.08931639747704039*b[i + 1*ldb] + -0.3333333333333348*b[i + 2*ldb]);
        c[i + 12*ldc] = (0.08931639747704039*b[i + 3*ldb] + 1.244016935856294*b[i + 4*ldb] + -0.3333333333333348*b[i + 5*ldb]);
        c[i + 13*ldc] = (1.244016935856294*b[i + 3*ldb] + 0.08931639747704039*b[i + 4*ldb] + -0.3333333333333348*b[i + 5*ldb]);
        c[i + 14*ldc] = (0.08931639747704039*b[i + 0*ldb] + -0.3333333333333348*b[i + 1*ldb] + 1.244016935856294*b[i + 2*ldb]);
        c[i + 15*ldc] = (1.244016935856294*b[i + 0*ldb] + -0.3333333333333348*b[i + 1*ldb] + 0.08931639747704039*b[i + 2*ldb]);
        c[i + 16*ldc] = (0.08931639747704039*b[i + 3*ldb] + -0.3333333333333348*b[i + 4*ldb] + 1.244016935856294*b[i + 5*ldb]);
        c[i + 17*ldc] = (1.244016935856294*b[i + 3*ldb] + -0.3333333333333348*b[i + 4*ldb] + 0.08931639747704039*b[i + 5*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_pri_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (1.366025403784428*b[i + 0*ldb] + -0.3660254037844356*b[i + 3*ldb] + -0.4999999999999978*b[i + 6*ldb] + -0.4999999999999978*b[i + 7*ldb] + 0.1339745962155623*b[i + 10*ldb] + 1.866025403784436*b[i + 11*ldb] + 0.1339745962155623*b[i + 14*ldb] + 1.866025403784436*b[i + 15*ldb]);
        c[i + 1*ldc] += (1.366025403784428*b[i + 1*ldb] + -0.3660254037844356*b[i + 4*ldb] + 0.1339745962155623*b[i + 6*ldb] + 1.866025403784436*b[i + 7*ldb] + 1.866025403784436*b[i + 10*ldb] + 0.1339745962155623*b[i + 11*ldb] + -0.4999999999999978*b[i + 14*ldb] + -0.4999999999999978*b[i + 15*ldb]);
        c[i + 2*ldc] += (1.366025403784428*b[i + 2*ldb] + -0.3660254037844356*b[i + 5*ldb] + 1.866025403784436*b[i + 6*ldb] + 0.1339745962155623*b[i + 7*ldb] + -0.4999999999999978*b[i + 10*ldb] + -0.4999999999999978*b[i + 11*ldb] + 1.866025403784436*b[i + 14*ldb] + 0.1339745962155623*b[i + 15*ldb]);
        c[i + 3*ldc] += (-0.3660254037844356*b[i + 0*ldb] + 1.366025403784428*b[i + 3*ldb] + -0.4999999999999978*b[i + 8*ldb] + -0.4999999999999978*b[i + 9*ldb] + 0.1339745962155623*b[i + 12*ldb] + 1.866025403784436*b[i + 13*ldb] + 0.1339745962155623*b[i + 16*ldb] + 1.866025403784436*b[i + 17*ldb]);
        c[i + 4*ldc] += (-0.3660254037844356*b[i + 1*ldb] + 1.366025403784428*b[i + 4*ldb] + 0.1339745962155623*b[i + 8*ldb] + 1.866025403784436*b[i + 9*ldb] + 1.866025403784436*b[i + 12*ldb] + 0.1339745962155623*b[i + 13*ldb] + -0.4999999999999978*b[i + 16*ldb] + -0.4999999999999978*b[i + 17*ldb]);
        c[i + 5*ldc] += (-0.3660254037844356*b[i + 2*ldb] + 1.366025403784428*b[i + 5*ldb] + 1.866025403784436*b[i + 8*ldb] + 0.1339745962155623*b[i + 9*ldb] + -0.4999999999999978*b[i + 12*ldb] + -0.4999999999999978*b[i + 13*ldb] + 1.866025403784436*b[i + 16*ldb] + 0.1339745962155623*b[i + 17*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_pri_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (0.1339745962155623*b[i + 10*ldb] + 1.866025403784436*b[i + 11*ldb] + -0.1339745962155623*b[i + 14*ldb] + -1.866025403784436*b[i + 15*ldb]);
        c[i + 1*ldc] += (1.866025403784436*b[i + 10*ldb] + 0.1339745962155623*b[i + 11*ldb] + 0.4999999999999978*b[i + 14*ldb] + 0.4999999999999978*b[i + 15*ldb]);
        c[i + 2*ldc] += (-0.4999999999999978*b[i + 10*ldb] + -0.4999999999999978*b[i + 11*ldb] + -1.866025403784436*b[i + 14*ldb] + -0.1339745962155623*b[i + 15*ldb]);
        c[i + 3*ldc] += (0.1339745962155623*b[i + 12*ldb] + 1.866025403784436*b[i + 13*ldb] + -0.1339745962155623*b[i + 16*ldb] + -1.866025403784436*b[i + 17*ldb]);
        c[i + 4*ldc] += (1.866025403784436*b[i + 12*ldb] + 0.1339745962155623*b[i + 13*ldb] + 0.4999999999999978*b[i + 16*ldb] + 0.4999999999999978*b[i + 17*ldb]);
        c[i + 5*ldc] += (-0.4999999999999978*b[i + 12*ldb] + -0.4999999999999978*b[i + 13*ldb] + -1.866025403784436*b[i + 16*ldb] + -0.1339745962155623*b[i + 17*ldb]);
        c[i + 6*ldc] += (0.4999999999999978*b[i + 6*ldb] + 0.4999999999999978*b[i + 7*ldb] + 0.1339745962155623*b[i + 10*ldb] + 1.866025403784436*b[i + 11*ldb]);
        c[i + 7*ldc] += (-0.1339745962155623*b[i + 6*ldb] + -1.866025403784436*b[i + 7*ldb] + 1.866025403784436*b[i + 10*ldb] + 0.1339745962155623*b[i + 11*ldb]);
        c[i + 8*ldc] += (-1.866025403784436*b[i + 6*ldb] + -0.1339745962155623*b[i + 7*ldb] + -0.4999999999999978*b[i + 10*ldb] + -0.4999999999999978*b[i + 11*ldb]);
        c[i + 9*ldc] += (0.4999999999999978*b[i + 8*ldb] + 0.4999999999999978*b[i + 9*ldb] + 0.1339745962155623*b[i + 12*ldb] + 1.866025403784436*b[i + 13*ldb]);
        c[i + 10*ldc] += (-0.1339745962155623*b[i + 8*ldb] + -1.866025403784436*b[i + 9*ldb] + 1.866025403784436*b[i + 12*ldb] + 0.1339745962155623*b[i + 13*ldb]);
        c[i + 11*ldc] += (-1.866025403784436*b[i + 8*ldb] + -0.1339745962155623*b[i + 9*ldb] + -0.4999999999999978*b[i + 12*ldb] + -0.4999999999999978*b[i + 13*ldb]);
        c[i + 12*ldc] += (-1.366025403784428*b[i + 0*ldb] + -0.3660254037844356*b[i + 3*ldb]);
        c[i + 13*ldc] += (-1.366025403784428*b[i + 1*ldb] + -0.3660254037844356*b[i + 4*ldb]);
        c[i + 14*ldc] += (-1.366025403784428*b[i + 2*ldb] + -0.3660254037844356*b[i + 5*ldb]);
        c[i + 15*ldc] += (0.3660254037844356*b[i + 0*ldb] + 1.366025403784428*b[i + 3*ldb]);
        c[i + 16*ldc] += (0.3660254037844356*b[i + 1*ldb] + 1.366025403784428*b[i + 4*ldb]);
        c[i + 17*ldc] += (0.3660254037844356*b[i + 2*ldb] + 1.366025403784428*b[i + 5*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_pri_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = 0.0;
        c[i + 1*ldc] = (-0.9999999999999977*b[i + 0*ldb] + -0.9999999999999977*b[i + 1*ldb] + -0.9999999999999977*b[i + 2*ldb]);
        c[i + 2*ldc] = (0.9999999999999977*b[i + 0*ldb] + 0.9999999999999977*b[i + 1*ldb] + 0.9999999999999977*b[i + 2*ldb]);
        c[i + 3*ldc] = 0.0;
        c[i + 4*ldc] = (-0.9999999999999977*b[i + 3*ldb] + -0.9999999999999977*b[i + 4*ldb] + -0.9999999999999977*b[i + 5*ldb]);
        c[i + 5*ldc] = (0.9999999999999977*b[i + 3*ldb] + 0.9999999999999977*b[i + 4*ldb] + 0.9999999999999977*b[i + 5*ldb]);
        c[i + 6*ldc] = (-0.9999999999999977*b[i + 0*ldb] + -0.9999999999999977*b[i + 1*ldb] + -0.9999999999999977*b[i + 2*ldb]);
        c[i + 7*ldc] = 0.0;
        c[i + 8*ldc] = (0.9999999999999977*b[i + 0*ldb] + 0.9999999999999977*b[i + 1*ldb] + 0.9999999999999977*b[i + 2*ldb]);
        c[i + 9*ldc] = (-0.9999999999999977*b[i + 3*ldb] + -0.9999999999999977*b[i + 4*ldb] + -0.9999999999999977*b[i + 5*ldb]);
        c[i + 10*ldc] = 0.0;
        c[i + 11*ldc] = (0.9999999999999977*b[i + 3*ldb] + 0.9999999999999977*b[i + 4*ldb] + 0.9999999999999977*b[i + 5*ldb]);
        c[i + 12*ldc] = (0.8660254037844322*b[i + 0*ldb] + 0.8660254037844322*b[i + 3*ldb]);
        c[i + 13*ldc] = (0.8660254037844322*b[i + 1*ldb] + 0.8660254037844322*b[i + 4*ldb]);
        c[i + 14*ldc] = (0.8660254037844322*b[i + 2*ldb] + 0.8660254037844322*b[i + 5*ldb]);
        c[i + 15*ldc] = (-0.8660254037844322*b[i + 0*ldb] + -0.8660254037844322*b[i + 3*ldb]);
        c[i + 16*ldc] = (-0.8660254037844322*b[i + 1*ldb] + -0.8660254037844322*b[i + 4*ldb]);
        c[i + 17*ldc] = (-0.8660254037844322*b[i + 2*ldb] + -0.8660254037844322*b[i + 5*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p1_pri_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (-0.9999999999999977*b[i + 6*ldb] + -0.9999999999999977*b[i + 7*ldb] + -0.9999999999999977*b[i + 8*ldb] + 0.8660254037844322*b[i + 12*ldb] + 0.8660254037844322*b[i + 15*ldb]);
        c[i + 1*ldc] = (-0.9999999999999977*b[i + 0*ldb] + -0.9999999999999977*b[i + 1*ldb] + -0.9999999999999977*b[i + 2*ldb] + 0.8660254037844322*b[i + 13*ldb] + 0.8660254037844322*b[i + 16*ldb]);
        c[i + 2*ldc] = (0.9999999999999977*b[i + 0*ldb] + 0.9999999999999977*b[i + 1*ldb] + 0.9999999999999977*b[i + 2*ldb] + 0.9999999999999977*b[i + 6*ldb] + 0.9999999999999977*b[i + 7*ldb] + 0.9999999999999977*b[i + 8*ldb] + 0.8660254037844322*b[i + 14*ldb] + 0.8660254037844322*b[i + 17*ldb]);
        c[i + 3*ldc] = (-0.9999999999999977*b[i + 9*ldb] + -0.9999999999999977*b[i + 10*ldb] + -0.9999999999999977*b[i + 11*ldb] + -0.8660254037844322*b[i + 12*ldb] + -0.8660254037844322*b[i + 15*ldb]);
        c[i + 4*ldc] = (-0.9999999999999977*b[i + 3*ldb] + -0.9999999999999977*b[i + 4*ldb] + -0.9999999999999977*b[i + 5*ldb] + -0.8660254037844322*b[i + 13*ldb] + -0.8660254037844322*b[i + 16*ldb]);
        c[i + 5*ldc] = (0.9999999999999977*b[i + 3*ldb] + 0.9999999999999977*b[i + 4*ldb] + 0.9999999999999977*b[i + 5*ldb] + 0.9999999999999977*b[i + 9*ldb] + 0.9999999999999977*b[i + 10*ldb] + 0.9999999999999977*b[i + 11*ldb] + -0.8660254037844322*b[i + 14*ldb] + -0.8660254037844322*b[i + 17*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_hex_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.478830557701236*b[i + 0*ldb] + -0.6666666666666665*b[i + 9*ldb] + 0.1878361089654305*b[i + 18*ldb]);
        c[i + 1*ldc] = (1.478830557701236*b[i + 1*ldb] + -0.6666666666666665*b[i + 10*ldb] + 0.1878361089654305*b[i + 19*ldb]);
        c[i + 2*ldc] = (1.478830557701236*b[i + 2*ldb] + -0.6666666666666665*b[i + 11*ldb] + 0.1878361089654305*b[i + 20*ldb]);
        c[i + 3*ldc] = (1.478830557701236*b[i + 3*ldb] + -0.6666666666666665*b[i + 12*ldb] + 0.1878361089654305*b[i + 21*ldb]);
        c[i + 4*ldc] = (1.478830557701236*b[i + 4*ldb] + -0.6666666666666665*b[i + 13*ldb] + 0.1878361089654305*b[i + 22*ldb]);
        c[i + 5*ldc] = (1.478830557701236*b[i + 5*ldb] + -0.6666666666666665*b[i + 14*ldb] + 0.1878361089654305*b[i + 23*ldb]);
        c[i + 6*ldc] = (1.478830557701236*b[i + 6*ldb] + -0.6666666666666665*b[i + 15*ldb] + 0.1878361089654305*b[i + 24*ldb]);
        c[i + 7*ldc] = (1.478830557701236*b[i + 7*ldb] + -0.6666666666666665*b[i + 16*ldb] + 0.1878361089654305*b[i + 25*ldb]);
        c[i + 8*ldc] = (1.478830557701236*b[i + 8*ldb] + -0.6666666666666665*b[i + 17*ldb] + 0.1878361089654305*b[i + 26*ldb]);
        c[i + 9*ldc] = (1.478830557701236*b[i + 0*ldb] + -0.6666666666666665*b[i + 3*ldb] + 0.1878361089654305*b[i + 6*ldb]);
        c[i + 10*ldc] = (1.478830557701236*b[i + 1*ldb] + -0.6666666666666665*b[i + 4*ldb] + 0.1878361089654305*b[i + 7*ldb]);
        c[i + 11*ldc] = (1.478830557701236*b[i + 2*ldb] + -0.6666666666666665*b[i + 5*ldb] + 0.1878361089654305*b[i + 8*ldb]);
        c[i + 12*ldc] = (1.478830557701236*b[i + 9*ldb] + -0.6666666666666665*b[i + 12*ldb] + 0.1878361089654305*b[i + 15*ldb]);
        c[i + 13*ldc] = (1.478830557701236*b[i + 10*ldb] + -0.6666666666666665*b[i + 13*ldb] + 0.1878361089654305*b[i + 16*ldb]);
        c[i + 14*ldc] = (1.478830557701236*b[i + 11*ldb] + -0.6666666666666665*b[i + 14*ldb] + 0.1878361089654305*b[i + 17*ldb]);
        c[i + 15*ldc] = (1.478830557701236*b[i + 18*ldb] + -0.6666666666666665*b[i + 21*ldb] + 0.1878361089654305*b[i + 24*ldb]);
        c[i + 16*ldc] = (1.478830557701236*b[i + 19*ldb] + -0.6666666666666665*b[i + 22*ldb] + 0.1878361089654305*b[i + 25*ldb]);
        c[i + 17*ldc] = (1.478830557701236*b[i + 20*ldb] + -0.6666666666666665*b[i + 23*ldb] + 0.1878361089654305*b[i + 26*ldb]);
        c[i + 18*ldc] = (0.1878361089654305*b[i + 0*ldb] + -0.6666666666666665*b[i + 1*ldb] + 1.478830557701236*b[i + 2*ldb]);
        c[i + 19*ldc] = (0.1878361089654305*b[i + 3*ldb] + -0.6666666666666665*b[i + 4*ldb] + 1.478830557701236*b[i + 5*ldb]);
        c[i + 20*ldc] = (0.1878361089654305*b[i + 6*ldb] + -0.6666666666666665*b[i + 7*ldb] + 1.478830557701236*b[i + 8*ldb]);
        c[i + 21*ldc] = (0.1878361089654305*b[i + 9*ldb] + -0.6666666666666665*b[i + 10*ldb] + 1.478830557701236*b[i + 11*ldb]);
        c[i + 22*ldc] = (0.1878361089654305*b[i + 12*ldb] + -0.6666666666666665*b[i + 13*ldb] + 1.478830557701236*b[i + 14*ldb]);
        c[i + 23*ldc] = (0.1878361089654305*b[i + 15*ldb] + -0.6666666666666665*b[i + 16*ldb] + 1.478830557701236*b[i + 17*ldb]);
        c[i + 24*ldc] = (0.1878361089654305*b[i + 18*ldb] + -0.6666666666666665*b[i + 19*ldb] + 1.478830557701236*b[i + 20*ldb]);
        c[i + 25*ldc] = (0.1878361089654305*b[i + 21*ldb] + -0.6666666666666665*b[i + 22*ldb] + 1.478830557701236*b[i + 23*ldb]);
        c[i + 26*ldc] = (0.1878361089654305*b[i + 24*ldb] + -0.6666666666666665*b[i + 25*ldb] + 1.478830557701236*b[i + 26*ldb]);
        c[i + 27*ldc] = (0.1878361089654305*b[i + 0*ldb] + -0.6666666666666665*b[i + 3*ldb] + 1.478830557701236*b[i + 6*ldb]);
        c[i + 28*ldc] = (0.1878361089654305*b[i + 1*ldb] + -0.6666666666666665*b[i + 4*ldb] + 1.478830557701236*b[i + 7*ldb]);
        c[i + 29*ldc] = (0.1878361089654305*b[i + 2*ldb] + -0.6666666666666665*b[i + 5*ldb] + 1.478830557701236*b[i + 8*ldb]);
        c[i + 30*ldc] = (0.1878361089654305*b[i + 9*ldb] + -0.6666666666666665*b[i + 12*ldb] + 1.478830557701236*b[i + 15*ldb]);
        c[i + 31*ldc] = (0.1878361089654305*b[i + 10*ldb] + -0.6666666666666665*b[i + 13*ldb] + 1.478830557701236*b[i + 16*ldb]);
        c[i + 32*ldc] = (0.1878361089654305*b[i + 11*ldb] + -0.6666666666666665*b[i + 14*ldb] + 1.478830557701236*b[i + 17*ldb]);
        c[i + 33*ldc] = (0.1878361089654305*b[i + 18*ldb] + -0.6666666666666665*b[i + 21*ldb] + 1.478830557701236*b[i + 24*ldb]);
        c[i + 34*ldc] = (0.1878361089654305*b[i + 19*ldb] + -0.6666666666666665*b[i + 22*ldb] + 1.478830557701236*b[i + 25*ldb]);
        c[i + 35*ldc] = (0.1878361089654305*b[i + 20*ldb] + -0.6666666666666665*b[i + 23*ldb] + 1.478830557701236*b[i + 26*ldb]);
        c[i + 36*ldc] = (1.478830557701236*b[i + 0*ldb] + -0.6666666666666665*b[i + 1*ldb] + 0.1878361089654305*b[i + 2*ldb]);
        c[i + 37*ldc] = (1.478830557701236*b[i + 3*ldb] + -0.6666666666666665*b[i + 4*ldb] + 0.1878361089654305*b[i + 5*ldb]);
        c[i + 38*ldc] = (1.478830557701236*b[i + 6*ldb] + -0.6666666666666665*b[i + 7*ldb] + 0.1878361089654305*b[i + 8*ldb]);
        c[i + 39*ldc] = (1.478830557701236*b[i + 9*ldb] + -0.6666666666666665*b[i + 10*ldb] + 0.1878361089654305*b[i + 11*ldb]);
        c[i + 40*ldc] = (1.478830557701236*b[i + 12*ldb] + -0.6666666666666665*b[i + 13*ldb] + 0.1878361089654305*b[i + 14*ldb]);
        c[i + 41*ldc] = (1.478830557701236*b[i + 15*ldb] + -0.6666666666666665*b[i + 16*ldb] + 0.1878361089654305*b[i + 17*ldb]);
        c[i + 42*ldc] = (1.478830557701236*b[i + 18*ldb] + -0.6666666666666665*b[i + 19*ldb] + 0.1878361089654305*b[i + 20*ldb]);
        c[i + 43*ldc] = (1.478830557701236*b[i + 21*ldb] + -0.6666666666666665*b[i + 22*ldb] + 0.1878361089654305*b[i + 23*ldb]);
        c[i + 44*ldc] = (1.478830557701236*b[i + 24*ldb] + -0.6666666666666665*b[i + 25*ldb] + 0.1878361089654305*b[i + 26*ldb]);
        c[i + 45*ldc] = (0.1878361089654305*b[i + 0*ldb] + -0.6666666666666665*b[i + 9*ldb] + 1.478830557701236*b[i + 18*ldb]);
        c[i + 46*ldc] = (0.1878361089654305*b[i + 1*ldb] + -0.6666666666666665*b[i + 10*ldb] + 1.478830557701236*b[i + 19*ldb]);
        c[i + 47*ldc] = (0.1878361089654305*b[i + 2*ldb] + -0.6666666666666665*b[i + 11*ldb] + 1.478830557701236*b[i + 20*ldb]);
        c[i + 48*ldc] = (0.1878361089654305*b[i + 3*ldb] + -0.6666666666666665*b[i + 12*ldb] + 1.478830557701236*b[i + 21*ldb]);
        c[i + 49*ldc] = (0.1878361089654305*b[i + 4*ldb] + -0.6666666666666665*b[i + 13*ldb] + 1.478830557701236*b[i + 22*ldb]);
        c[i + 50*ldc] = (0.1878361089654305*b[i + 5*ldb] + -0.6666666666666665*b[i + 14*ldb] + 1.478830557701236*b[i + 23*ldb]);
        c[i + 51*ldc] = (0.1878361089654305*b[i + 6*ldb] + -0.6666666666666665*b[i + 15*ldb] + 1.478830557701236*b[i + 24*ldb]);
        c[i + 52*ldc] = (0.1878361089654305*b[i + 7*ldb] + -0.6666666666666665*b[i + 16*ldb] + 1.478830557701236*b[i + 25*ldb]);
        c[i + 53*ldc] = (0.1878361089654305*b[i + 8*ldb] + -0.6666666666666665*b[i + 17*ldb] + 1.478830557701236*b[i + 26*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_hex_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (2.661895003862226*b[i + 0*ldb] + 2.661895003862226*b[i + 9*ldb] + 0.3381049961377754*b[i + 18*ldb] + 0.3381049961377754*b[i + 27*ldb] + 2.661895003862226*b[i + 36*ldb] + 0.3381049961377754*b[i + 45*ldb]);
        c[i + 1*ldc] += (2.661895003862226*b[i + 1*ldb] + 2.661895003862226*b[i + 10*ldb] + -0.7500000000000001*b[i + 18*ldb] + 0.3381049961377754*b[i + 28*ldb] + -0.7500000000000001*b[i + 36*ldb] + 0.3381049961377754*b[i + 46*ldb]);
        c[i + 2*ldc] += (2.661895003862226*b[i + 2*ldb] + 2.661895003862226*b[i + 11*ldb] + 2.661895003862226*b[i + 18*ldb] + 0.3381049961377754*b[i + 29*ldb] + 0.3381049961377754*b[i + 36*ldb] + 0.3381049961377754*b[i + 47*ldb]);
        c[i + 3*ldc] += (2.661895003862226*b[i + 3*ldb] + -0.7500000000000001*b[i + 9*ldb] + 0.3381049961377754*b[i + 19*ldb] + -0.7500000000000001*b[i + 27*ldb] + 2.661895003862226*b[i + 37*ldb] + 0.3381049961377754*b[i + 48*ldb]);
        c[i + 4*ldc] += (2.661895003862226*b[i + 4*ldb] + -0.7500000000000001*b[i + 10*ldb] + -0.7500000000000001*b[i + 19*ldb] + -0.7500000000000001*b[i + 28*ldb] + -0.7500000000000001*b[i + 37*ldb] + 0.3381049961377754*b[i + 49*ldb]);
        c[i + 5*ldc] += (2.661895003862226*b[i + 5*ldb] + -0.7500000000000001*b[i + 11*ldb] + 2.661895003862226*b[i + 19*ldb] + -0.7500000000000001*b[i + 29*ldb] + 0.3381049961377754*b[i + 37*ldb] + 0.3381049961377754*b[i + 50*ldb]);
        c[i + 6*ldc] += (2.661895003862226*b[i + 6*ldb] + 0.3381049961377754*b[i + 9*ldb] + 0.3381049961377754*b[i + 20*ldb] + 2.661895003862226*b[i + 27*ldb] + 2.661895003862226*b[i + 38*ldb] + 0.3381049961377754*b[i + 51*ldb]);
        c[i + 7*ldc] += (2.661895003862226*b[i + 7*ldb] + 0.3381049961377754*b[i + 10*ldb] + -0.7500000000000001*b[i + 20*ldb] + 2.661895003862226*b[i + 28*ldb] + -0.7500000000000001*b[i + 38*ldb] + 0.3381049961377754*b[i + 52*ldb]);
        c[i + 8*ldc] += (2.661895003862226*b[i + 8*ldb] + 0.3381049961377754*b[i + 11*ldb] + 2.661895003862226*b[i + 20*ldb] + 2.661895003862226*b[i + 29*ldb] + 0.3381049961377754*b[i + 38*ldb] + 0.3381049961377754*b[i + 53*ldb]);
        c[i + 9*ldc] += (-0.7500000000000001*b[i + 0*ldb] + 2.661895003862226*b[i + 12*ldb] + 0.3381049961377754*b[i + 21*ldb] + 0.3381049961377754*b[i + 30*ldb] + 2.661895003862226*b[i + 39*ldb] + -0.7500000000000001*b[i + 45*ldb]);
        c[i + 10*ldc] += (-0.7500000000000001*b[i + 1*ldb] + 2.661895003862226*b[i + 13*ldb] + -0.7500000000000001*b[i + 21*ldb] + 0.3381049961377754*b[i + 31*ldb] + -0.7500000000000001*b[i + 39*ldb] + -0.7500000000000001*b[i + 46*ldb]);
        c[i + 11*ldc] += (-0.7500000000000001*b[i + 2*ldb] + 2.661895003862226*b[i + 14*ldb] + 2.661895003862226*b[i + 21*ldb] + 0.3381049961377754*b[i + 32*ldb] + 0.3381049961377754*b[i + 39*ldb] + -0.7500000000000001*b[i + 47*ldb]);
        c[i + 12*ldc] += (-0.7500000000000001*b[i + 3*ldb] + -0.7500000000000001*b[i + 12*ldb] + 0.3381049961377754*b[i + 22*ldb] + -0.7500000000000001*b[i + 30*ldb] + 2.661895003862226*b[i + 40*ldb] + -0.7500000000000001*b[i + 48*ldb]);
        c[i + 13*ldc] += (-0.7500000000000001*b[i + 4*ldb] + -0.7500000000000001*b[i + 13*ldb] + -0.7500000000000001*b[i + 22*ldb] + -0.7500000000000001*b[i + 31*ldb] + -0.7500000000000001*b[i + 40*ldb] + -0.7500000000000001*b[i + 49*ldb]);
        c[i + 14*ldc] += (-0.7500000000000001*b[i + 5*ldb] + -0.7500000000000001*b[i + 14*ldb] + 2.661895003862226*b[i + 22*ldb] + -0.7500000000000001*b[i + 32*ldb] + 0.3381049961377754*b[i + 40*ldb] + -0.7500000000000001*b[i + 50*ldb]);
        c[i + 15*ldc] += (-0.7500000000000001*b[i + 6*ldb] + 0.3381049961377754*b[i + 12*ldb] + 0.3381049961377754*b[i + 23*ldb] + 2.661895003862226*b[i + 30*ldb] + 2.661895003862226*b[i + 41*ldb] + -0.7500000000000001*b[i + 51*ldb]);
        c[i + 16*ldc] += (-0.7500000000000001*b[i + 7*ldb] + 0.3381049961377754*b[i + 13*ldb] + -0.7500000000000001*b[i + 23*ldb] + 2.661895003862226*b[i + 31*ldb] + -0.7500000000000001*b[i + 41*ldb] + -0.7500000000000001*b[i + 52*ldb]);
        c[i + 17*ldc] += (-0.7500000000000001*b[i + 8*ldb] + 0.3381049961377754*b[i + 14*ldb] + 2.661895003862226*b[i + 23*ldb] + 2.661895003862226*b[i + 32*ldb] + 0.3381049961377754*b[i + 41*ldb] + -0.7500000000000001*b[i + 53*ldb]);
        c[i + 18*ldc] += (0.3381049961377754*b[i + 0*ldb] + 2.661895003862226*b[i + 15*ldb] + 0.3381049961377754*b[i + 24*ldb] + 0.3381049961377754*b[i + 33*ldb] + 2.661895003862226*b[i + 42*ldb] + 2.661895003862226*b[i + 45*ldb]);
        c[i + 19*ldc] += (0.3381049961377754*b[i + 1*ldb] + 2.661895003862226*b[i + 16*ldb] + -0.7500000000000001*b[i + 24*ldb] + 0.3381049961377754*b[i + 34*ldb] + -0.7500000000000001*b[i + 42*ldb] + 2.661895003862226*b[i + 46*ldb]);
        c[i + 20*ldc] += (0.3381049961377754*b[i + 2*ldb] + 2.661895003862226*b[i + 17*ldb] + 2.661895003862226*b[i + 24*ldb] + 0.3381049961377754*b[i + 35*ldb] + 0.3381049961377754*b[i + 42*ldb] + 2.661895003862226*b[i + 47*ldb]);
        c[i + 21*ldc] += (0.3381049961377754*b[i + 3*ldb] + -0.7500000000000001*b[i + 15*ldb] + 0.3381049961377754*b[i + 25*ldb] + -0.7500000000000001*b[i + 33*ldb] + 2.661895003862226*b[i + 43*ldb] + 2.661895003862226*b[i + 48*ldb]);
        c[i + 22*ldc] += (0.3381049961377754*b[i + 4*ldb] + -0.7500000000000001*b[i + 16*ldb] + -0.7500000000000001*b[i + 25*ldb] + -0.7500000000000001*b[i + 34*ldb] + -0.7500000000000001*b[i + 43*ldb] + 2.661895003862226*b[i + 49*ldb]);
        c[i + 23*ldc] += (0.3381049961377754*b[i + 5*ldb] + -0.7500000000000001*b[i + 17*ldb] + 2.661895003862226*b[i + 25*ldb] + -0.7500000000000001*b[i + 35*ldb] + 0.3381049961377754*b[i + 43*ldb] + 2.661895003862226*b[i + 50*ldb]);
        c[i + 24*ldc] += (0.3381049961377754*b[i + 6*ldb] + 0.3381049961377754*b[i + 15*ldb] + 0.3381049961377754*b[i + 26*ldb] + 2.661895003862226*b[i + 33*ldb] + 2.661895003862226*b[i + 44*ldb] + 2.661895003862226*b[i + 51*ldb]);
        c[i + 25*ldc] += (0.3381049961377754*b[i + 7*ldb] + 0.3381049961377754*b[i + 16*ldb] + -0.7500000000000001*b[i + 26*ldb] + 2.661895003862226*b[i + 34*ldb] + -0.7500000000000001*b[i + 44*ldb] + 2.661895003862226*b[i + 52*ldb]);
        c[i + 26*ldc] += (0.3381049961377754*b[i + 8*ldb] + 0.3381049961377754*b[i + 17*ldb] + 2.661895003862226*b[i + 26*ldb] + 2.661895003862226*b[i + 35*ldb] + 0.3381049961377754*b[i + 44*ldb] + 2.661895003862226*b[i + 53*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_hex_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (0.3381049961377754*b[i + 18*ldb] + -2.661895003862226*b[i + 36*ldb]);
        c[i + 1*ldc] += (-0.7500000000000001*b[i + 18*ldb] + 0.7500000000000001*b[i + 36*ldb]);
        c[i + 2*ldc] += (2.661895003862226*b[i + 18*ldb] + -0.3381049961377754*b[i + 36*ldb]);
        c[i + 3*ldc] += (0.3381049961377754*b[i + 19*ldb] + -2.661895003862226*b[i + 37*ldb]);
        c[i + 4*ldc] += (-0.7500000000000001*b[i + 19*ldb] + 0.7500000000000001*b[i + 37*ldb]);
        c[i + 5*ldc] += (2.661895003862226*b[i + 19*ldb] + -0.3381049961377754*b[i + 37*ldb]);
        c[i + 6*ldc] += (0.3381049961377754*b[i + 20*ldb] + -2.661895003862226*b[i + 38*ldb]);
        c[i + 7*ldc] += (-0.7500000000000001*b[i + 20*ldb] + 0.7500000000000001*b[i + 38*ldb]);
        c[i + 8*ldc] += (2.661895003862226*b[i + 20*ldb] + -0.3381049961377754*b[i + 38*ldb]);
        c[i + 9*ldc] += (0.3381049961377754*b[i + 21*ldb] + -2.661895003862226*b[i + 39*ldb]);
        c[i + 10*ldc] += (-0.7500000000000001*b[i + 21*ldb] + 0.7500000000000001*b[i + 39*ldb]);
        c[i + 11*ldc] += (2.661895003862226*b[i + 21*ldb] + -0.3381049961377754*b[i + 39*ldb]);
        c[i + 12*ldc] += (0.3381049961377754*b[i + 22*ldb] + -2.661895003862226*b[i + 40*ldb]);
        c[i + 13*ldc] += (-0.7500000000000001*b[i + 22*ldb] + 0.7500000000000001*b[i + 40*ldb]);
        c[i + 14*ldc] += (2.661895003862226*b[i + 22*ldb] + -0.3381049961377754*b[i + 40*ldb]);
        c[i + 15*ldc] += (0.3381049961377754*b[i + 23*ldb] + -2.661895003862226*b[i + 41*ldb]);
        c[i + 16*ldc] += (-0.7500000000000001*b[i + 23*ldb] + 0.7500000000000001*b[i + 41*ldb]);
        c[i + 17*ldc] += (2.661895003862226*b[i + 23*ldb] + -0.3381049961377754*b[i + 41*ldb]);
        c[i + 18*ldc] += (0.3381049961377754*b[i + 24*ldb] + -2.661895003862226*b[i + 42*ldb]);
        c[i + 19*ldc] += (-0.7500000000000001*b[i + 24*ldb] + 0.7500000000000001*b[i + 42*ldb]);
        c[i + 20*ldc] += (2.661895003862226*b[i + 24*ldb] + -0.3381049961377754*b[i + 42*ldb]);
        c[i + 21*ldc] += (0.3381049961377754*b[i + 25*ldb] + -2.661895003862226*b[i + 43*ldb]);
        c[i + 22*ldc] += (-0.7500000000000001*b[i + 25*ldb] + 0.7500000000000001*b[i + 43*ldb]);
        c[i + 23*ldc] += (2.661895003862226*b[i + 25*ldb] + -0.3381049961377754*b[i + 43*ldb]);
        c[i + 24*ldc] += (0.3381049961377754*b[i + 26*ldb] + -2.661895003862226*b[i + 44*ldb]);
        c[i + 25*ldc] += (-0.7500000000000001*b[i + 26*ldb] + 0.7500000000000001*b[i + 44*ldb]);
        c[i + 26*ldc] += (2.661895003862226*b[i + 26*ldb] + -0.3381049961377754*b[i + 44*ldb]);
        c[i + 27*ldc] += (-2.661895003862226*b[i + 9*ldb] + 0.3381049961377754*b[i + 27*ldb]);
        c[i + 28*ldc] += (-2.661895003862226*b[i + 10*ldb] + 0.3381049961377754*b[i + 28*ldb]);
        c[i + 29*ldc] += (-2.661895003862226*b[i + 11*ldb] + 0.3381049961377754*b[i + 29*ldb]);
        c[i + 30*ldc] += (0.7500000000000001*b[i + 9*ldb] + -0.7500000000000001*b[i + 27*ldb]);
        c[i + 31*ldc] += (0.7500000000000001*b[i + 10*ldb] + -0.7500000000000001*b[i + 28*ldb]);
        c[i + 32*ldc] += (0.7500000000000001*b[i + 11*ldb] + -0.7500000000000001*b[i + 29*ldb]);
        c[i + 33*ldc] += (-0.3381049961377754*b[i + 9*ldb] + 2.661895003862226*b[i + 27*ldb]);
        c[i + 34*ldc] += (-0.3381049961377754*b[i + 10*ldb] + 2.661895003862226*b[i + 28*ldb]);
        c[i + 35*ldc] += (-0.3381049961377754*b[i + 11*ldb] + 2.661895003862226*b[i + 29*ldb]);
        c[i + 36*ldc] += (-2.661895003862226*b[i + 12*ldb] + 0.3381049961377754*b[i + 30*ldb]);
        c[i + 37*ldc] += (-2.661895003862226*b[i + 13*ldb] + 0.3381049961377754*b[i + 31*ldb]);
        c[i + 38*ldc] += (-2.661895003862226*b[i + 14*ldb] + 0.3381049961377754*b[i + 32*ldb]);
        c[i + 39*ldc] += (0.7500000000000001*b[i + 12*ldb] + -0.7500000000000001*b[i + 30*ldb]);
        c[i + 40*ldc] += (0.7500000000000001*b[i + 13*ldb] + -0.7500000000000001*b[i + 31*ldb]);
        c[i + 41*ldc] += (0.7500000000000001*b[i + 14*ldb] + -0.7500000000000001*b[i + 32*ldb]);
        c[i + 42*ldc] += (-0.3381049961377754*b[i + 12*ldb] + 2.661895003862226*b[i + 30*ldb]);
        c[i + 43*ldc] += (-0.3381049961377754*b[i + 13*ldb] + 2.661895003862226*b[i + 31*ldb]);
        c[i + 44*ldc] += (-0.3381049961377754*b[i + 14*ldb] + 2.661895003862226*b[i + 32*ldb]);
        c[i + 45*ldc] += (-2.661895003862226*b[i + 15*ldb] + 0.3381049961377754*b[i + 33*ldb]);
        c[i + 46*ldc] += (-2.661895003862226*b[i + 16*ldb] + 0.3381049961377754*b[i + 34*ldb]);
        c[i + 47*ldc] += (-2.661895003862226*b[i + 17*ldb] + 0.3381049961377754*b[i + 35*ldb]);
        c[i + 48*ldc] += (0.7500000000000001*b[i + 15*ldb] + -0.7500000000000001*b[i + 33*ldb]);
        c[i + 49*ldc] += (0.7500000000000001*b[i + 16*ldb] + -0.7500000000000001*b[i + 34*ldb]);
        c[i + 50*ldc] += (0.7500000000000001*b[i + 17*ldb] + -0.7500000000000001*b[i + 35*ldb]);
        c[i + 51*ldc] += (-0.3381049961377754*b[i + 15*ldb] + 2.661895003862226*b[i + 33*ldb]);
        c[i + 52*ldc] += (-0.3381049961377754*b[i + 16*ldb] + 2.661895003862226*b[i + 34*ldb]);
        c[i + 53*ldc] += (-0.3381049961377754*b[i + 17*ldb] + 2.661895003862226*b[i + 35*ldb]);
        c[i + 54*ldc] += (-2.661895003862226*b[i + 0*ldb] + 0.3381049961377754*b[i + 45*ldb]);
        c[i + 55*ldc] += (-2.661895003862226*b[i + 1*ldb] + 0.3381049961377754*b[i + 46*ldb]);
        c[i + 56*ldc] += (-2.661895003862226*b[i + 2*ldb] + 0.3381049961377754*b[i + 47*ldb]);
        c[i + 57*ldc] += (-2.661895003862226*b[i + 3*ldb] + 0.3381049961377754*b[i + 48*ldb]);
        c[i + 58*ldc] += (-2.661895003862226*b[i + 4*ldb] + 0.3381049961377754*b[i + 49*ldb]);
        c[i + 59*ldc] += (-2.661895003862226*b[i + 5*ldb] + 0.3381049961377754*b[i + 50*ldb]);
        c[i + 60*ldc] += (-2.661895003862226*b[i + 6*ldb] + 0.3381049961377754*b[i + 51*ldb]);
        c[i + 61*ldc] += (-2.661895003862226*b[i + 7*ldb] + 0.3381049961377754*b[i + 52*ldb]);
        c[i + 62*ldc] += (-2.661895003862226*b[i + 8*ldb] + 0.3381049961377754*b[i + 53*ldb]);
        c[i + 63*ldc] += (0.7500000000000001*b[i + 0*ldb] + -0.7500000000000001*b[i + 45*ldb]);
        c[i + 64*ldc] += (0.7500000000000001*b[i + 1*ldb] + -0.7500000000000001*b[i + 46*ldb]);
        c[i + 65*ldc] += (0.7500000000000001*b[i + 2*ldb] + -0.7500000000000001*b[i + 47*ldb]);
        c[i + 66*ldc] += (0.7500000000000001*b[i + 3*ldb] + -0.7500000000000001*b[i + 48*ldb]);
        c[i + 67*ldc] += (0.7500000000000001*b[i + 4*ldb] + -0.7500000000000001*b[i + 49*ldb]);
        c[i + 68*ldc] += (0.7500000000000001*b[i + 5*ldb] + -0.7500000000000001*b[i + 50*ldb]);
        c[i + 69*ldc] += (0.7500000000000001*b[i + 6*ldb] + -0.7500000000000001*b[i + 51*ldb]);
        c[i + 70*ldc] += (0.7500000000000001*b[i + 7*ldb] + -0.7500000000000001*b[i + 52*ldb]);
        c[i + 71*ldc] += (0.7500000000000001*b[i + 8*ldb] + -0.7500000000000001*b[i + 53*ldb]);
        c[i + 72*ldc] += (-0.3381049961377754*b[i + 0*ldb] + 2.661895003862226*b[i + 45*ldb]);
        c[i + 73*ldc] += (-0.3381049961377754*b[i + 1*ldb] + 2.661895003862226*b[i + 46*ldb]);
        c[i + 74*ldc] += (-0.3381049961377754*b[i + 2*ldb] + 2.661895003862226*b[i + 47*ldb]);
        c[i + 75*ldc] += (-0.3381049961377754*b[i + 3*ldb] + 2.661895003862226*b[i + 48*ldb]);
        c[i + 76*ldc] += (-0.3381049961377754*b[i + 4*ldb] + 2.661895003862226*b[i + 49*ldb]);
        c[i + 77*ldc] += (-0.3381049961377754*b[i + 5*ldb] + 2.661895003862226*b[i + 50*ldb]);
        c[i + 78*ldc] += (-0.3381049961377754*b[i + 6*ldb] + 2.661895003862226*b[i + 51*ldb]);
        c[i + 79*ldc] += (-0.3381049961377754*b[i + 7*ldb] + 2.661895003862226*b[i + 52*ldb]);
        c[i + 80*ldc] += (-0.3381049961377754*b[i + 8*ldb] + 2.661895003862226*b[i + 53*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_hex_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.936491673103709*b[i + 0*ldb] + 1.032795558988645*b[i + 1*ldb] + -0.6454972243679037*b[i + 2*ldb]);
        c[i + 1*ldc] = (-1.613743060919757*b[i + 0*ldb] + 1.613743060919757*b[i + 2*ldb]);
        c[i + 2*ldc] = (0.6454972243679037*b[i + 0*ldb] + -1.032795558988645*b[i + 1*ldb] + -1.936491673103709*b[i + 2*ldb]);
        c[i + 3*ldc] = (1.936491673103709*b[i + 3*ldb] + 1.032795558988645*b[i + 4*ldb] + -0.6454972243679037*b[i + 5*ldb]);
        c[i + 4*ldc] = (-1.613743060919757*b[i + 3*ldb] + 1.613743060919757*b[i + 5*ldb]);
        c[i + 5*ldc] = (0.6454972243679037*b[i + 3*ldb] + -1.032795558988645*b[i + 4*ldb] + -1.936491673103709*b[i + 5*ldb]);
        c[i + 6*ldc] = (1.936491673103709*b[i + 6*ldb] + 1.032795558988645*b[i + 7*ldb] + -0.6454972243679037*b[i + 8*ldb]);
        c[i + 7*ldc] = (-1.613743060919757*b[i + 6*ldb] + 1.613743060919757*b[i + 8*ldb]);
        c[i + 8*ldc] = (0.6454972243679037*b[i + 6*ldb] + -1.032795558988645*b[i + 7*ldb] + -1.936491673103709*b[i + 8*ldb]);
        c[i + 9*ldc] = (1.936491673103709*b[i + 9*ldb] + 1.032795558988645*b[i + 10*ldb] + -0.6454972243679037*b[i + 11*ldb]);
        c[i + 10*ldc] = (-1.613743060919757*b[i + 9*ldb] + 1.613743060919757*b[i + 11*ldb]);
        c[i + 11*ldc] = (0.6454972243679037*b[i + 9*ldb] + -1.032795558988645*b[i + 10*ldb] + -1.936491673103709*b[i + 11*ldb]);
        c[i + 12*ldc] = (1.936491673103709*b[i + 12*ldb] + 1.032795558988645*b[i + 13*ldb] + -0.6454972243679037*b[i + 14*ldb]);
        c[i + 13*ldc] = (-1.613743060919757*b[i + 12*ldb] + 1.613743060919757*b[i + 14*ldb]);
        c[i + 14*ldc] = (0.6454972243679037*b[i + 12*ldb] + -1.032795558988645*b[i + 13*ldb] + -1.936491673103709*b[i + 14*ldb]);
        c[i + 15*ldc] = (1.936491673103709*b[i + 15*ldb] + 1.032795558988645*b[i + 16*ldb] + -0.6454972243679037*b[i + 17*ldb]);
        c[i + 16*ldc] = (-1.613743060919757*b[i + 15*ldb] + 1.613743060919757*b[i + 17*ldb]);
        c[i + 17*ldc] = (0.6454972243679037*b[i + 15*ldb] + -1.032795558988645*b[i + 16*ldb] + -1.936491673103709*b[i + 17*ldb]);
        c[i + 18*ldc] = (1.936491673103709*b[i + 18*ldb] + 1.032795558988645*b[i + 19*ldb] + -0.6454972243679037*b[i + 20*ldb]);
        c[i + 19*ldc] = (-1.613743060919757*b[i + 18*ldb] + 1.613743060919757*b[i + 20*ldb]);
        c[i + 20*ldc] = (0.6454972243679037*b[i + 18*ldb] + -1.032795558988645*b[i + 19*ldb] + -1.936491673103709*b[i + 20*ldb]);
        c[i + 21*ldc] = (1.936491673103709*b[i + 21*ldb] + 1.032795558988645*b[i + 22*ldb] + -0.6454972243679037*b[i + 23*ldb]);
        c[i + 22*ldc] = (-1.613743060919757*b[i + 21*ldb] + 1.613743060919757*b[i + 23*ldb]);
        c[i + 23*ldc] = (0.6454972243679037*b[i + 21*ldb] + -1.032795558988645*b[i + 22*ldb] + -1.936491673103709*b[i + 23*ldb]);
        c[i + 24*ldc] = (1.936491673103709*b[i + 24*ldb] + 1.032795558988645*b[i + 25*ldb] + -0.6454972243679037*b[i + 26*ldb]);
        c[i + 25*ldc] = (-1.613743060919757*b[i + 24*ldb] + 1.613743060919757*b[i + 26*ldb]);
        c[i + 26*ldc] = (0.6454972243679037*b[i + 24*ldb] + -1.032795558988645*b[i + 25*ldb] + -1.936491673103709*b[i + 26*ldb]);
        c[i + 27*ldc] = (1.936491673103709*b[i + 0*ldb] + 1.032795558988645*b[i + 3*ldb] + -0.6454972243679037*b[i + 6*ldb]);
        c[i + 28*ldc] = (1.936491673103709*b[i + 1*ldb] + 1.032795558988645*b[i + 4*ldb] + -0.6454972243679037*b[i + 7*ldb]);
        c[i + 29*ldc] = (1.936491673103709*b[i + 2*ldb] + 1.032795558988645*b[i + 5*ldb] + -0.6454972243679037*b[i + 8*ldb]);
        c[i + 30*ldc] = (-1.613743060919757*b[i + 0*ldb] + 1.613743060919757*b[i + 6*ldb]);
        c[i + 31*ldc] = (-1.613743060919757*b[i + 1*ldb] + 1.613743060919757*b[i + 7*ldb]);
        c[i + 32*ldc] = (-1.613743060919757*b[i + 2*ldb] + 1.613743060919757*b[i + 8*ldb]);
        c[i + 33*ldc] = (0.6454972243679037*b[i + 0*ldb] + -1.032795558988645*b[i + 3*ldb] + -1.936491673103709*b[i + 6*ldb]);
        c[i + 34*ldc] = (0.6454972243679037*b[i + 1*ldb] + -1.032795558988645*b[i + 4*ldb] + -1.936491673103709*b[i + 7*ldb]);
        c[i + 35*ldc] = (0.6454972243679037*b[i + 2*ldb] + -1.032795558988645*b[i + 5*ldb] + -1.936491673103709*b[i + 8*ldb]);
        c[i + 36*ldc] = (1.936491673103709*b[i + 9*ldb] + 1.032795558988645*b[i + 12*ldb] + -0.6454972243679037*b[i + 15*ldb]);
        c[i + 37*ldc] = (1.936491673103709*b[i + 10*ldb] + 1.032795558988645*b[i + 13*ldb] + -0.6454972243679037*b[i + 16*ldb]);
        c[i + 38*ldc] = (1.936491673103709*b[i + 11*ldb] + 1.032795558988645*b[i + 14*ldb] + -0.6454972243679037*b[i + 17*ldb]);
        c[i + 39*ldc] = (-1.613743060919757*b[i + 9*ldb] + 1.613743060919757*b[i + 15*ldb]);
        c[i + 40*ldc] = (-1.613743060919757*b[i + 10*ldb] + 1.613743060919757*b[i + 16*ldb]);
        c[i + 41*ldc] = (-1.613743060919757*b[i + 11*ldb] + 1.613743060919757*b[i + 17*ldb]);
        c[i + 42*ldc] = (0.6454972243679037*b[i + 9*ldb] + -1.032795558988645*b[i + 12*ldb] + -1.936491673103709*b[i + 15*ldb]);
        c[i + 43*ldc] = (0.6454972243679037*b[i + 10*ldb] + -1.032795558988645*b[i + 13*ldb] + -1.936491673103709*b[i + 16*ldb]);
        c[i + 44*ldc] = (0.6454972243679037*b[i + 11*ldb] + -1.032795558988645*b[i + 14*ldb] + -1.936491673103709*b[i + 17*ldb]);
        c[i + 45*ldc] = (1.936491673103709*b[i + 18*ldb] + 1.032795558988645*b[i + 21*ldb] + -0.6454972243679037*b[i + 24*ldb]);
        c[i + 46*ldc] = (1.936491673103709*b[i + 19*ldb] + 1.032795558988645*b[i + 22*ldb] + -0.6454972243679037*b[i + 25*ldb]);
        c[i + 47*ldc] = (1.936491673103709*b[i + 20*ldb] + 1.032795558988645*b[i + 23*ldb] + -0.6454972243679037*b[i + 26*ldb]);
        c[i + 48*ldc] = (-1.613743060919757*b[i + 18*ldb] + 1.613743060919757*b[i + 24*ldb]);
        c[i + 49*ldc] = (-1.613743060919757*b[i + 19*ldb] + 1.613743060919757*b[i + 25*ldb]);
        c[i + 50*ldc] = (-1.613743060919757*b[i + 20*ldb] + 1.613743060919757*b[i + 26*ldb]);
        c[i + 51*ldc] = (0.6454972243679037*b[i + 18*ldb] + -1.032795558988645*b[i + 21*ldb] + -1.936491673103709*b[i + 24*ldb]);
        c[i + 52*ldc] = (0.6454972243679037*b[i + 19*ldb] + -1.032795558988645*b[i + 22*ldb] + -1.936491673103709*b[i + 25*ldb]);
        c[i + 53*ldc] = (0.6454972243679037*b[i + 20*ldb] + -1.032795558988645*b[i + 23*ldb] + -1.936491673103709*b[i + 26*ldb]);
        c[i + 54*ldc] = (1.936491673103709*b[i + 0*ldb] + 1.032795558988645*b[i + 9*ldb] + -0.6454972243679037*b[i + 18*ldb]);
        c[i + 55*ldc] = (1.936491673103709*b[i + 1*ldb] + 1.032795558988645*b[i + 10*ldb] + -0.6454972243679037*b[i + 19*ldb]);
        c[i + 56*ldc] = (1.936491673103709*b[i + 2*ldb] + 1.032795558988645*b[i + 11*ldb] + -0.6454972243679037*b[i + 20*ldb]);
        c[i + 57*ldc] = (1.936491673103709*b[i + 3*ldb] + 1.032795558988645*b[i + 12*ldb] + -0.6454972243679037*b[i + 21*ldb]);
        c[i + 58*ldc] = (1.936491673103709*b[i + 4*ldb] + 1.032795558988645*b[i + 13*ldb] + -0.6454972243679037*b[i + 22*ldb]);
        c[i + 59*ldc] = (1.936491673103709*b[i + 5*ldb] + 1.032795558988645*b[i + 14*ldb] + -0.6454972243679037*b[i + 23*ldb]);
        c[i + 60*ldc] = (1.936491673103709*b[i + 6*ldb] + 1.032795558988645*b[i + 15*ldb] + -0.6454972243679037*b[i + 24*ldb]);
        c[i + 61*ldc] = (1.936491673103709*b[i + 7*ldb] + 1.032795558988645*b[i + 16*ldb] + -0.6454972243679037*b[i + 25*ldb]);
        c[i + 62*ldc] = (1.936491673103709*b[i + 8*ldb] + 1.032795558988645*b[i + 17*ldb] + -0.6454972243679037*b[i + 26*ldb]);
        c[i + 63*ldc] = (-1.613743060919757*b[i + 0*ldb] + 1.613743060919757*b[i + 18*ldb]);
        c[i + 64*ldc] = (-1.613743060919757*b[i + 1*ldb] + 1.613743060919757*b[i + 19*ldb]);
        c[i + 65*ldc] = (-1.613743060919757*b[i + 2*ldb] + 1.613743060919757*b[i + 20*ldb]);
        c[i + 66*ldc] = (-1.613743060919757*b[i + 3*ldb] + 1.613743060919757*b[i + 21*ldb]);
        c[i + 67*ldc] = (-1.613743060919757*b[i + 4*ldb] + 1.613743060919757*b[i + 22*ldb]);
        c[i + 68*ldc] = (-1.613743060919757*b[i + 5*ldb] + 1.613743060919757*b[i + 23*ldb]);
        c[i + 69*ldc] = (-1.613743060919757*b[i + 6*ldb] + 1.613743060919757*b[i + 24*ldb]);
        c[i + 70*ldc] = (-1.613743060919757*b[i + 7*ldb] + 1.613743060919757*b[i + 25*ldb]);
        c[i + 71*ldc] = (-1.613743060919757*b[i + 8*ldb] + 1.613743060919757*b[i + 26*ldb]);
        c[i + 72*ldc] = (0.6454972243679037*b[i + 0*ldb] + -1.032795558988645*b[i + 9*ldb] + -1.936491673103709*b[i + 18*ldb]);
        c[i + 73*ldc] = (0.6454972243679037*b[i + 1*ldb] + -1.032795558988645*b[i + 10*ldb] + -1.936491673103709*b[i + 19*ldb]);
        c[i + 74*ldc] = (0.6454972243679037*b[i + 2*ldb] + -1.032795558988645*b[i + 11*ldb] + -1.936491673103709*b[i + 20*ldb]);
        c[i + 75*ldc] = (0.6454972243679037*b[i + 3*ldb] + -1.032795558988645*b[i + 12*ldb] + -1.936491673103709*b[i + 21*ldb]);
        c[i + 76*ldc] = (0.6454972243679037*b[i + 4*ldb] + -1.032795558988645*b[i + 13*ldb] + -1.936491673103709*b[i + 22*ldb]);
        c[i + 77*ldc] = (0.6454972243679037*b[i + 5*ldb] + -1.032795558988645*b[i + 14*ldb] + -1.936491673103709*b[i + 23*ldb]);
        c[i + 78*ldc] = (0.6454972243679037*b[i + 6*ldb] + -1.032795558988645*b[i + 15*ldb] + -1.936491673103709*b[i + 24*ldb]);
        c[i + 79*ldc] = (0.6454972243679037*b[i + 7*ldb] + -1.032795558988645*b[i + 16*ldb] + -1.936491673103709*b[i + 25*ldb]);
        c[i + 80*ldc] = (0.6454972243679037*b[i + 8*ldb] + -1.032795558988645*b[i + 17*ldb] + -1.936491673103709*b[i + 26*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_hex_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.936491673103709*b[i + 0*ldb] + 1.032795558988645*b[i + 1*ldb] + -0.6454972243679037*b[i + 2*ldb] + 1.936491673103709*b[i + 27*ldb] + 1.032795558988645*b[i + 30*ldb] + -0.6454972243679037*b[i + 33*ldb] + 1.936491673103709*b[i + 54*ldb] + 1.032795558988645*b[i + 63*ldb] + -0.6454972243679037*b[i + 72*ldb]);
        c[i + 1*ldc] = (-1.613743060919757*b[i + 0*ldb] + 1.613743060919757*b[i + 2*ldb] + 1.936491673103709*b[i + 28*ldb] + 1.032795558988645*b[i + 31*ldb] + -0.6454972243679037*b[i + 34*ldb] + 1.936491673103709*b[i + 55*ldb] + 1.032795558988645*b[i + 64*ldb] + -0.6454972243679037*b[i + 73*ldb]);
        c[i + 2*ldc] = (0.6454972243679037*b[i + 0*ldb] + -1.032795558988645*b[i + 1*ldb] + -1.936491673103709*b[i + 2*ldb] + 1.936491673103709*b[i + 29*ldb] + 1.032795558988645*b[i + 32*ldb] + -0.6454972243679037*b[i + 35*ldb] + 1.936491673103709*b[i + 56*ldb] + 1.032795558988645*b[i + 65*ldb] + -0.6454972243679037*b[i + 74*ldb]);
        c[i + 3*ldc] = (1.936491673103709*b[i + 3*ldb] + 1.032795558988645*b[i + 4*ldb] + -0.6454972243679037*b[i + 5*ldb] + -1.613743060919757*b[i + 27*ldb] + 1.613743060919757*b[i + 33*ldb] + 1.936491673103709*b[i + 57*ldb] + 1.032795558988645*b[i + 66*ldb] + -0.6454972243679037*b[i + 75*ldb]);
        c[i + 4*ldc] = (-1.613743060919757*b[i + 3*ldb] + 1.613743060919757*b[i + 5*ldb] + -1.613743060919757*b[i + 28*ldb] + 1.613743060919757*b[i + 34*ldb] + 1.936491673103709*b[i + 58*ldb] + 1.032795558988645*b[i + 67*ldb] + -0.6454972243679037*b[i + 76*ldb]);
        c[i + 5*ldc] = (0.6454972243679037*b[i + 3*ldb] + -1.032795558988645*b[i + 4*ldb] + -1.936491673103709*b[i + 5*ldb] + -1.613743060919757*b[i + 29*ldb] + 1.613743060919757*b[i + 35*ldb] + 1.936491673103709*b[i + 59*ldb] + 1.032795558988645*b[i + 68*ldb] + -0.6454972243679037*b[i + 77*ldb]);
        c[i + 6*ldc] = (1.936491673103709*b[i + 6*ldb] + 1.032795558988645*b[i + 7*ldb] + -0.6454972243679037*b[i + 8*ldb] + 0.6454972243679037*b[i + 27*ldb] + -1.032795558988645*b[i + 30*ldb] + -1.936491673103709*b[i + 33*ldb] + 1.936491673103709*b[i + 60*ldb] + 1.032795558988645*b[i + 69*ldb] + -0.6454972243679037*b[i + 78*ldb]);
        c[i + 7*ldc] = (-1.613743060919757*b[i + 6*ldb] + 1.613743060919757*b[i + 8*ldb] + 0.6454972243679037*b[i + 28*ldb] + -1.032795558988645*b[i + 31*ldb] + -1.936491673103709*b[i + 34*ldb] + 1.936491673103709*b[i + 61*ldb] + 1.032795558988645*b[i + 70*ldb] + -0.6454972243679037*b[i + 79*ldb]);
        c[i + 8*ldc] = (0.6454972243679037*b[i + 6*ldb] + -1.032795558988645*b[i + 7*ldb] + -1.936491673103709*b[i + 8*ldb] + 0.6454972243679037*b[i + 29*ldb] + -1.032795558988645*b[i + 32*ldb] + -1.936491673103709*b[i + 35*ldb] + 1.936491673103709*b[i + 62*ldb] + 1.032795558988645*b[i + 71*ldb] + -0.6454972243679037*b[i + 80*ldb]);
        c[i + 9*ldc] = (1.936491673103709*b[i + 9*ldb] + 1.032795558988645*b[i + 10*ldb] + -0.6454972243679037*b[i + 11*ldb] + 1.936491673103709*b[i + 36*ldb] + 1.032795558988645*b[i + 39*ldb] + -0.6454972243679037*b[i + 42*ldb] + -1.613743060919757*b[i + 54*ldb] + 1.613743060919757*b[i + 72*ldb]);
        c[i + 10*ldc] = (-1.613743060919757*b[i + 9*ldb] + 1.613743060919757*b[i + 11*ldb] + 1.936491673103709*b[i + 37*ldb] + 1.032795558988645*b[i + 40*ldb] + -0.6454972243679037*b[i + 43*ldb] + -1.613743060919757*b[i + 55*ldb] + 1.613743060919757*b[i + 73*ldb]);
        c[i + 11*ldc] = (0.6454972243679037*b[i + 9*ldb] + -1.032795558988645*b[i + 10*ldb] + -1.936491673103709*b[i + 11*ldb] + 1.936491673103709*b[i + 38*ldb] + 1.032795558988645*b[i + 41*ldb] + -0.6454972243679037*b[i + 44*ldb] + -1.613743060919757*b[i + 56*ldb] + 1.613743060919757*b[i + 74*ldb]);
        c[i + 12*ldc] = (1.936491673103709*b[i + 12*ldb] + 1.032795558988645*b[i + 13*ldb] + -0.6454972243679037*b[i + 14*ldb] + -1.613743060919757*b[i + 36*ldb] + 1.613743060919757*b[i + 42*ldb] + -1.613743060919757*b[i + 57*ldb] + 1.613743060919757*b[i + 75*ldb]);
        c[i + 13*ldc] = (-1.613743060919757*b[i + 12*ldb] + 1.613743060919757*b[i + 14*ldb] + -1.613743060919757*b[i + 37*ldb] + 1.613743060919757*b[i + 43*ldb] + -1.613743060919757*b[i + 58*ldb] + 1.613743060919757*b[i + 76*ldb]);
        c[i + 14*ldc] = (0.6454972243679037*b[i + 12*ldb] + -1.032795558988645*b[i + 13*ldb] + -1.936491673103709*b[i + 14*ldb] + -1.613743060919757*b[i + 38*ldb] + 1.613743060919757*b[i + 44*ldb] + -1.613743060919757*b[i + 59*ldb] + 1.613743060919757*b[i + 77*ldb]);
        c[i + 15*ldc] = (1.936491673103709*b[i + 15*ldb] + 1.032795558988645*b[i + 16*ldb] + -0.6454972243679037*b[i + 17*ldb] + 0.6454972243679037*b[i + 36*ldb] + -1.032795558988645*b[i + 39*ldb] + -1.936491673103709*b[i + 42*ldb] + -1.613743060919757*b[i + 60*ldb] + 1.613743060919757*b[i + 78*ldb]);
        c[i + 16*ldc] = (-1.613743060919757*b[i + 15*ldb] + 1.613743060919757*b[i + 17*ldb] + 0.6454972243679037*b[i + 37*ldb] + -1.032795558988645*b[i + 40*ldb] + -1.936491673103709*b[i + 43*ldb] + -1.613743060919757*b[i + 61*ldb] + 1.613743060919757*b[i + 79*ldb]);
        c[i + 17*ldc] = (0.6454972243679037*b[i + 15*ldb] + -1.032795558988645*b[i + 16*ldb] + -1.936491673103709*b[i + 17*ldb] + 0.6454972243679037*b[i + 38*ldb] + -1.032795558988645*b[i + 41*ldb] + -1.936491673103709*b[i + 44*ldb] + -1.613743060919757*b[i + 62*ldb] + 1.613743060919757*b[i + 80*ldb]);
        c[i + 18*ldc] = (1.936491673103709*b[i + 18*ldb] + 1.032795558988645*b[i + 19*ldb] + -0.6454972243679037*b[i + 20*ldb] + 1.936491673103709*b[i + 45*ldb] + 1.032795558988645*b[i + 48*ldb] + -0.6454972243679037*b[i + 51*ldb] + 0.6454972243679037*b[i + 54*ldb] + -1.032795558988645*b[i + 63*ldb] + -1.936491673103709*b[i + 72*ldb]);
        c[i + 19*ldc] = (-1.613743060919757*b[i + 18*ldb] + 1.613743060919757*b[i + 20*ldb] + 1.936491673103709*b[i + 46*ldb] + 1.032795558988645*b[i + 49*ldb] + -0.6454972243679037*b[i + 52*ldb] + 0.6454972243679037*b[i + 55*ldb] + -1.032795558988645*b[i + 64*ldb] + -1.936491673103709*b[i + 73*ldb]);
        c[i + 20*ldc] = (0.6454972243679037*b[i + 18*ldb] + -1.032795558988645*b[i + 19*ldb] + -1.936491673103709*b[i + 20*ldb] + 1.936491673103709*b[i + 47*ldb] + 1.032795558988645*b[i + 50*ldb] + -0.6454972243679037*b[i + 53*ldb] + 0.6454972243679037*b[i + 56*ldb] + -1.032795558988645*b[i + 65*ldb] + -1.936491673103709*b[i + 74*ldb]);
        c[i + 21*ldc] = (1.936491673103709*b[i + 21*ldb] + 1.032795558988645*b[i + 22*ldb] + -0.6454972243679037*b[i + 23*ldb] + -1.613743060919757*b[i + 45*ldb] + 1.613743060919757*b[i + 51*ldb] + 0.6454972243679037*b[i + 57*ldb] + -1.032795558988645*b[i + 66*ldb] + -1.936491673103709*b[i + 75*ldb]);
        c[i + 22*ldc] = (-1.613743060919757*b[i + 21*ldb] + 1.613743060919757*b[i + 23*ldb] + -1.613743060919757*b[i + 46*ldb] + 1.613743060919757*b[i + 52*ldb] + 0.6454972243679037*b[i + 58*ldb] + -1.032795558988645*b[i + 67*ldb] + -1.936491673103709*b[i + 76*ldb]);
        c[i + 23*ldc] = (0.6454972243679037*b[i + 21*ldb] + -1.032795558988645*b[i + 22*ldb] + -1.936491673103709*b[i + 23*ldb] + -1.613743060919757*b[i + 47*ldb] + 1.613743060919757*b[i + 53*ldb] + 0.6454972243679037*b[i + 59*ldb] + -1.032795558988645*b[i + 68*ldb] + -1.936491673103709*b[i + 77*ldb]);
        c[i + 24*ldc] = (1.936491673103709*b[i + 24*ldb] + 1.032795558988645*b[i + 25*ldb] + -0.6454972243679037*b[i + 26*ldb] + 0.6454972243679037*b[i + 45*ldb] + -1.032795558988645*b[i + 48*ldb] + -1.936491673103709*b[i + 51*ldb] + 0.6454972243679037*b[i + 60*ldb] + -1.032795558988645*b[i + 69*ldb] + -1.936491673103709*b[i + 78*ldb]);
        c[i + 25*ldc] = (-1.613743060919757*b[i + 24*ldb] + 1.613743060919757*b[i + 26*ldb] + 0.6454972243679037*b[i + 46*ldb] + -1.032795558988645*b[i + 49*ldb] + -1.936491673103709*b[i + 52*ldb] + 0.6454972243679037*b[i + 61*ldb] + -1.032795558988645*b[i + 70*ldb] + -1.936491673103709*b[i + 79*ldb]);
        c[i + 26*ldc] = (0.6454972243679037*b[i + 24*ldb] + -1.032795558988645*b[i + 25*ldb] + -1.936491673103709*b[i + 26*ldb] + 0.6454972243679037*b[i + 47*ldb] + -1.032795558988645*b[i + 50*ldb] + -1.936491673103709*b[i + 53*ldb] + 0.6454972243679037*b[i + 62*ldb] + -1.032795558988645*b[i + 71*ldb] + -1.936491673103709*b[i + 80*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_pri_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.478830557701236*b[i + 0*ldb] + -0.6666666666666666*b[i + 6*ldb] + 0.1878361089654305*b[i + 12*ldb]);
        c[i + 1*ldc] = (1.478830557701236*b[i + 1*ldb] + -0.6666666666666666*b[i + 7*ldb] + 0.1878361089654305*b[i + 13*ldb]);
        c[i + 2*ldc] = (1.478830557701236*b[i + 2*ldb] + -0.6666666666666666*b[i + 8*ldb] + 0.1878361089654305*b[i + 14*ldb]);
        c[i + 3*ldc] = (1.478830557701236*b[i + 3*ldb] + -0.6666666666666666*b[i + 9*ldb] + 0.1878361089654305*b[i + 15*ldb]);
        c[i + 4*ldc] = (1.478830557701236*b[i + 4*ldb] + -0.6666666666666666*b[i + 10*ldb] + 0.1878361089654305*b[i + 16*ldb]);
        c[i + 5*ldc] = (1.478830557701236*b[i + 5*ldb] + -0.6666666666666666*b[i + 11*ldb] + 0.1878361089654305*b[i + 17*ldb]);
        c[i + 6*ldc] = (0.1878361089654305*b[i + 0*ldb] + -0.6666666666666666*b[i + 6*ldb] + 1.478830557701236*b[i + 12*ldb]);
        c[i + 7*ldc] = (0.1878361089654305*b[i + 1*ldb] + -0.6666666666666666*b[i + 7*ldb] + 1.478830557701236*b[i + 13*ldb]);
        c[i + 8*ldc] = (0.1878361089654305*b[i + 2*ldb] + -0.6666666666666666*b[i + 8*ldb] + 1.478830557701236*b[i + 14*ldb]);
        c[i + 9*ldc] = (0.1878361089654305*b[i + 3*ldb] + -0.6666666666666666*b[i + 9*ldb] + 1.478830557701236*b[i + 15*ldb]);
        c[i + 10*ldc] = (0.1878361089654305*b[i + 4*ldb] + -0.6666666666666666*b[i + 10*ldb] + 1.478830557701236*b[i + 16*ldb]);
        c[i + 11*ldc] = (0.1878361089654305*b[i + 5*ldb] + -0.6666666666666666*b[i + 11*ldb] + 1.478830557701236*b[i + 17*ldb]);
        c[i + 12*ldc] = (0.155156984740978*b[i + 0*ldb] + -0.03837513050400164*b[i + 1*ldb] + 1.305627307150833*b[i + 2*ldb] + 0.1610707812758249*b[i + 3*ldb] + -0.5879845890563387*b[i + 4*ldb] + 0.004504646392704818*b[i + 5*ldb]);
        c[i + 13*ldc] = (0.1800530807344952*b[i + 0*ldb] + 0.07490107511575278*b[i + 1*ldb] + 0.07490107511575278*b[i + 2*ldb] + 1.360516334307621*b[i + 3*ldb] + -0.345185782636811*b[i + 4*ldb] + -0.345185782636811*b[i + 5*ldb]);
        c[i + 14*ldc] = (0.155156984740978*b[i + 0*ldb] + 1.305627307150833*b[i + 1*ldb] + -0.03837513050400164*b[i + 2*ldb] + 0.1610707812758249*b[i + 3*ldb] + 0.004504646392704818*b[i + 4*ldb] + -0.5879845890563387*b[i + 5*ldb]);
        c[i + 15*ldc] = (0.155156984740978*b[i + 6*ldb] + -0.03837513050400164*b[i + 7*ldb] + 1.305627307150833*b[i + 8*ldb] + 0.1610707812758249*b[i + 9*ldb] + -0.5879845890563387*b[i + 10*ldb] + 0.004504646392704818*b[i + 11*ldb]);
        c[i + 16*ldc] = (0.1800530807344952*b[i + 6*ldb] + 0.07490107511575278*b[i + 7*ldb] + 0.07490107511575278*b[i + 8*ldb] + 1.360516334307621*b[i + 9*ldb] + -0.345185782636811*b[i + 10*ldb] + -0.345185782636811*b[i + 11*ldb]);
        c[i + 17*ldc] = (0.155156984740978*b[i + 6*ldb] + 1.305627307150833*b[i + 7*ldb] + -0.03837513050400164*b[i + 8*ldb] + 0.1610707812758249*b[i + 9*ldb] + 0.004504646392704818*b[i + 10*ldb] + -0.5879845890563387*b[i + 11*ldb]);
        c[i + 18*ldc] = (0.155156984740978*b[i + 12*ldb] + -0.03837513050400164*b[i + 13*ldb] + 1.305627307150833*b[i + 14*ldb] + 0.1610707812758249*b[i + 15*ldb] + -0.5879845890563387*b[i + 16*ldb] + 0.004504646392704818*b[i + 17*ldb]);
        c[i + 19*ldc] = (0.1800530807344952*b[i + 12*ldb] + 0.07490107511575278*b[i + 13*ldb] + 0.07490107511575278*b[i + 14*ldb] + 1.360516334307621*b[i + 15*ldb] + -0.345185782636811*b[i + 16*ldb] + -0.345185782636811*b[i + 17*ldb]);
        c[i + 20*ldc] = (0.155156984740978*b[i + 12*ldb] + 1.305627307150833*b[i + 13*ldb] + -0.03837513050400164*b[i + 14*ldb] + 0.1610707812758249*b[i + 15*ldb] + 0.004504646392704818*b[i + 16*ldb] + -0.5879845890563387*b[i + 17*ldb]);
        c[i + 21*ldc] = (-0.03837513050400164*b[i + 0*ldb] + 1.305627307150833*b[i + 1*ldb] + 0.155156984740978*b[i + 2*ldb] + -0.5879845890563387*b[i + 3*ldb] + 0.004504646392704818*b[i + 4*ldb] + 0.1610707812758249*b[i + 5*ldb]);
        c[i + 22*ldc] = (0.07490107511575278*b[i + 0*ldb] + 0.07490107511575278*b[i + 1*ldb] + 0.1800530807344952*b[i + 2*ldb] + -0.345185782636811*b[i + 3*ldb] + -0.345185782636811*b[i + 4*ldb] + 1.360516334307621*b[i + 5*ldb]);
        c[i + 23*ldc] = (1.305627307150833*b[i + 0*ldb] + -0.03837513050400164*b[i + 1*ldb] + 0.155156984740978*b[i + 2*ldb] + 0.004504646392704818*b[i + 3*ldb] + -0.5879845890563387*b[i + 4*ldb] + 0.1610707812758249*b[i + 5*ldb]);
        c[i + 24*ldc] = (-0.03837513050400164*b[i + 6*ldb] + 1.305627307150833*b[i + 7*ldb] + 0.155156984740978*b[i + 8*ldb] + -0.5879845890563387*b[i + 9*ldb] + 0.004504646392704818*b[i + 10*ldb] + 0.1610707812758249*b[i + 11*ldb]);
        c[i + 25*ldc] = (0.07490107511575278*b[i + 6*ldb] + 0.07490107511575278*b[i + 7*ldb] + 0.1800530807344952*b[i + 8*ldb] + -0.345185782636811*b[i + 9*ldb] + -0.345185782636811*b[i + 10*ldb] + 1.360516334307621*b[i + 11*ldb]);
        c[i + 26*ldc] = (1.305627307150833*b[i + 6*ldb] + -0.03837513050400164*b[i + 7*ldb] + 0.155156984740978*b[i + 8*ldb] + 0.004504646392704818*b[i + 9*ldb] + -0.5879845890563387*b[i + 10*ldb] + 0.1610707812758249*b[i + 11*ldb]);
        c[i + 27*ldc] = (-0.03837513050400164*b[i + 12*ldb] + 1.305627307150833*b[i + 13*ldb] + 0.155156984740978*b[i + 14*ldb] + -0.5879845890563387*b[i + 15*ldb] + 0.004504646392704818*b[i + 16*ldb] + 0.1610707812758249*b[i + 17*ldb]);
        c[i + 28*ldc] = (0.07490107511575278*b[i + 12*ldb] + 0.07490107511575278*b[i + 13*ldb] + 0.1800530807344952*b[i + 14*ldb] + -0.345185782636811*b[i + 15*ldb] + -0.345185782636811*b[i + 16*ldb] + 1.360516334307621*b[i + 17*ldb]);
        c[i + 29*ldc] = (1.305627307150833*b[i + 12*ldb] + -0.03837513050400164*b[i + 13*ldb] + 0.155156984740978*b[i + 14*ldb] + 0.004504646392704818*b[i + 15*ldb] + -0.5879845890563387*b[i + 16*ldb] + 0.1610707812758249*b[i + 17*ldb]);
        c[i + 30*ldc] = (-0.03837513050400164*b[i + 0*ldb] + 0.155156984740978*b[i + 1*ldb] + 1.305627307150833*b[i + 2*ldb] + -0.5879845890563387*b[i + 3*ldb] + 0.1610707812758249*b[i + 4*ldb] + 0.004504646392704818*b[i + 5*ldb]);
        c[i + 31*ldc] = (0.07490107511575278*b[i + 0*ldb] + 0.1800530807344952*b[i + 1*ldb] + 0.07490107511575278*b[i + 2*ldb] + -0.345185782636811*b[i + 3*ldb] + 1.360516334307621*b[i + 4*ldb] + -0.345185782636811*b[i + 5*ldb]);
        c[i + 32*ldc] = (1.305627307150833*b[i + 0*ldb] + 0.155156984740978*b[i + 1*ldb] + -0.03837513050400164*b[i + 2*ldb] + 0.004504646392704818*b[i + 3*ldb] + 0.1610707812758249*b[i + 4*ldb] + -0.5879845890563387*b[i + 5*ldb]);
        c[i + 33*ldc] = (-0.03837513050400164*b[i + 6*ldb] + 0.155156984740978*b[i + 7*ldb] + 1.305627307150833*b[i + 8*ldb] + -0.5879845890563387*b[i + 9*ldb] + 0.1610707812758249*b[i + 10*ldb] + 0.004504646392704818*b[i + 11*ldb]);
        c[i + 34*ldc] = (0.07490107511575278*b[i + 6*ldb] + 0.1800530807344952*b[i + 7*ldb] + 0.07490107511575278*b[i + 8*ldb] + -0.345185782636811*b[i + 9*ldb] + 1.360516334307621*b[i + 10*ldb] + -0.345185782636811*b[i + 11*ldb]);
        c[i + 35*ldc] = (1.305627307150833*b[i + 6*ldb] + 0.155156984740978*b[i + 7*ldb] + -0.03837513050400164*b[i + 8*ldb] + 0.004504646392704818*b[i + 9*ldb] + 0.1610707812758249*b[i + 10*ldb] + -0.5879845890563387*b[i + 11*ldb]);
        c[i + 36*ldc] = (-0.03837513050400164*b[i + 12*ldb] + 0.155156984740978*b[i + 13*ldb] + 1.305627307150833*b[i + 14*ldb] + -0.5879845890563387*b[i + 15*ldb] + 0.1610707812758249*b[i + 16*ldb] + 0.004504646392704818*b[i + 17*ldb]);
        c[i + 37*ldc] = (0.07490107511575278*b[i + 12*ldb] + 0.1800530807344952*b[i + 13*ldb] + 0.07490107511575278*b[i + 14*ldb] + -0.345185782636811*b[i + 15*ldb] + 1.360516334307621*b[i + 16*ldb] + -0.345185782636811*b[i + 17*ldb]);
        c[i + 38*ldc] = (1.305627307150833*b[i + 12*ldb] + 0.155156984740978*b[i + 13*ldb] + -0.03837513050400164*b[i + 14*ldb] + 0.004504646392704818*b[i + 15*ldb] + 0.1610707812758249*b[i + 16*ldb] + -0.5879845890563387*b[i + 17*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_pri_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (2.661895003862189*b[i + 0*ldb] + 0.3381049961377708*b[i + 6*ldb] + 0.3919825279273307*b[i + 12*ldb] + 0.7278064792531951*b[i + 13*ldb] + 0.3919825279273307*b[i + 14*ldb] + -0.09694942634794133*b[i + 21*ldb] + 0.3027634270400692*b[i + 22*ldb] + 3.298485680438136*b[i + 23*ldb] + -0.09694942634794133*b[i + 30*ldb] + 0.3027634270400692*b[i + 31*ldb] + 3.298485680438136*b[i + 32*ldb]);
        c[i + 1*ldc] += (2.661895003862189*b[i + 1*ldb] + 0.3381049961377708*b[i + 7*ldb] + -0.09694942634794133*b[i + 12*ldb] + 0.3027634270400692*b[i + 13*ldb] + 3.298485680438136*b[i + 14*ldb] + 3.298485680438136*b[i + 21*ldb] + 0.3027634270400692*b[i + 22*ldb] + -0.09694942634794133*b[i + 23*ldb] + 0.3919825279273307*b[i + 30*ldb] + 0.7278064792531951*b[i + 31*ldb] + 0.3919825279273307*b[i + 32*ldb]);
        c[i + 2*ldc] += (2.661895003862189*b[i + 2*ldb] + 0.3381049961377708*b[i + 8*ldb] + 3.298485680438136*b[i + 12*ldb] + 0.3027634270400692*b[i + 13*ldb] + -0.09694942634794133*b[i + 14*ldb] + 0.3919825279273307*b[i + 21*ldb] + 0.7278064792531951*b[i + 22*ldb] + 0.3919825279273307*b[i + 23*ldb] + 3.298485680438136*b[i + 30*ldb] + 0.3027634270400692*b[i + 31*ldb] + -0.09694942634794133*b[i + 32*ldb]);
        c[i + 3*ldc] += (2.661895003862189*b[i + 3*ldb] + 0.3381049961377708*b[i + 9*ldb] + 0.2002935145740354*b[i + 12*ldb] + 2.706910301921164*b[i + 13*ldb] + 0.2002935145740354*b[i + 14*ldb] + -0.7311661303469743*b[i + 21*ldb] + -0.6867884842939154*b[i + 22*ldb] + 0.005601583668738606*b[i + 23*ldb] + -0.7311661303469743*b[i + 30*ldb] + -0.6867884842939154*b[i + 31*ldb] + 0.005601583668738606*b[i + 32*ldb]);
        c[i + 4*ldc] += (2.661895003862189*b[i + 4*ldb] + 0.3381049961377708*b[i + 10*ldb] + -0.7311661303469743*b[i + 12*ldb] + -0.6867884842939154*b[i + 13*ldb] + 0.005601583668738606*b[i + 14*ldb] + 0.005601583668738606*b[i + 21*ldb] + -0.6867884842939154*b[i + 22*ldb] + -0.7311661303469743*b[i + 23*ldb] + 0.2002935145740354*b[i + 30*ldb] + 2.706910301921164*b[i + 31*ldb] + 0.2002935145740354*b[i + 32*ldb]);
        c[i + 5*ldc] += (2.661895003862189*b[i + 5*ldb] + 0.3381049961377708*b[i + 11*ldb] + 0.005601583668738606*b[i + 12*ldb] + -0.6867884842939154*b[i + 13*ldb] + -0.7311661303469743*b[i + 14*ldb] + 0.2002935145740354*b[i + 21*ldb] + 2.706910301921164*b[i + 22*ldb] + 0.2002935145740354*b[i + 23*ldb] + 0.005601583668738606*b[i + 30*ldb] + -0.6867884842939154*b[i + 31*ldb] + -0.7311661303469743*b[i + 32*ldb]);
        c[i + 6*ldc] += (-0.7499999999999898*b[i + 0*ldb] + -0.7499999999999898*b[i + 6*ldb] + 0.3919825279273307*b[i + 15*ldb] + 0.7278064792531951*b[i + 16*ldb] + 0.3919825279273307*b[i + 17*ldb] + -0.09694942634794133*b[i + 24*ldb] + 0.3027634270400692*b[i + 25*ldb] + 3.298485680438136*b[i + 26*ldb] + -0.09694942634794133*b[i + 33*ldb] + 0.3027634270400692*b[i + 34*ldb] + 3.298485680438136*b[i + 35*ldb]);
        c[i + 7*ldc] += (-0.7499999999999898*b[i + 1*ldb] + -0.7499999999999898*b[i + 7*ldb] + -0.09694942634794133*b[i + 15*ldb] + 0.3027634270400692*b[i + 16*ldb] + 3.298485680438136*b[i + 17*ldb] + 3.298485680438136*b[i + 24*ldb] + 0.3027634270400692*b[i + 25*ldb] + -0.09694942634794133*b[i + 26*ldb] + 0.3919825279273307*b[i + 33*ldb] + 0.7278064792531951*b[i + 34*ldb] + 0.3919825279273307*b[i + 35*ldb]);
        c[i + 8*ldc] += (-0.7499999999999898*b[i + 2*ldb] + -0.7499999999999898*b[i + 8*ldb] + 3.298485680438136*b[i + 15*ldb] + 0.3027634270400692*b[i + 16*ldb] + -0.09694942634794133*b[i + 17*ldb] + 0.3919825279273307*b[i + 24*ldb] + 0.7278064792531951*b[i + 25*ldb] + 0.3919825279273307*b[i + 26*ldb] + 3.298485680438136*b[i + 33*ldb] + 0.3027634270400692*b[i + 34*ldb] + -0.09694942634794133*b[i + 35*ldb]);
        c[i + 9*ldc] += (-0.7499999999999898*b[i + 3*ldb] + -0.7499999999999898*b[i + 9*ldb] + 0.2002935145740354*b[i + 15*ldb] + 2.706910301921164*b[i + 16*ldb] + 0.2002935145740354*b[i + 17*ldb] + -0.7311661303469743*b[i + 24*ldb] + -0.6867884842939154*b[i + 25*ldb] + 0.005601583668738606*b[i + 26*ldb] + -0.7311661303469743*b[i + 33*ldb] + -0.6867884842939154*b[i + 34*ldb] + 0.005601583668738606*b[i + 35*ldb]);
        c[i + 10*ldc] += (-0.7499999999999898*b[i + 4*ldb] + -0.7499999999999898*b[i + 10*ldb] + -0.7311661303469743*b[i + 15*ldb] + -0.6867884842939154*b[i + 16*ldb] + 0.005601583668738606*b[i + 17*ldb] + 0.005601583668738606*b[i + 24*ldb] + -0.6867884842939154*b[i + 25*ldb] + -0.7311661303469743*b[i + 26*ldb] + 0.2002935145740354*b[i + 33*ldb] + 2.706910301921164*b[i + 34*ldb] + 0.2002935145740354*b[i + 35*ldb]);
        c[i + 11*ldc] += (-0.7499999999999898*b[i + 5*ldb] + -0.7499999999999898*b[i + 11*ldb] + 0.005601583668738606*b[i + 15*ldb] + -0.6867884842939154*b[i + 16*ldb] + -0.7311661303469743*b[i + 17*ldb] + 0.2002935145740354*b[i + 24*ldb] + 2.706910301921164*b[i + 25*ldb] + 0.2002935145740354*b[i + 26*ldb] + 0.005601583668738606*b[i + 33*ldb] + -0.6867884842939154*b[i + 34*ldb] + -0.7311661303469743*b[i + 35*ldb]);
        c[i + 12*ldc] += (0.3381049961377708*b[i + 0*ldb] + 2.661895003862189*b[i + 6*ldb] + 0.3919825279273307*b[i + 18*ldb] + 0.7278064792531951*b[i + 19*ldb] + 0.3919825279273307*b[i + 20*ldb] + -0.09694942634794133*b[i + 27*ldb] + 0.3027634270400692*b[i + 28*ldb] + 3.298485680438136*b[i + 29*ldb] + -0.09694942634794133*b[i + 36*ldb] + 0.3027634270400692*b[i + 37*ldb] + 3.298485680438136*b[i + 38*ldb]);
        c[i + 13*ldc] += (0.3381049961377708*b[i + 1*ldb] + 2.661895003862189*b[i + 7*ldb] + -0.09694942634794133*b[i + 18*ldb] + 0.3027634270400692*b[i + 19*ldb] + 3.298485680438136*b[i + 20*ldb] + 3.298485680438136*b[i + 27*ldb] + 0.3027634270400692*b[i + 28*ldb] + -0.09694942634794133*b[i + 29*ldb] + 0.3919825279273307*b[i + 36*ldb] + 0.7278064792531951*b[i + 37*ldb] + 0.3919825279273307*b[i + 38*ldb]);
        c[i + 14*ldc] += (0.3381049961377708*b[i + 2*ldb] + 2.661895003862189*b[i + 8*ldb] + 3.298485680438136*b[i + 18*ldb] + 0.3027634270400692*b[i + 19*ldb] + -0.09694942634794133*b[i + 20*ldb] + 0.3919825279273307*b[i + 27*ldb] + 0.7278064792531951*b[i + 28*ldb] + 0.3919825279273307*b[i + 29*ldb] + 3.298485680438136*b[i + 36*ldb] + 0.3027634270400692*b[i + 37*ldb] + -0.09694942634794133*b[i + 38*ldb]);
        c[i + 15*ldc] += (0.3381049961377708*b[i + 3*ldb] + 2.661895003862189*b[i + 9*ldb] + 0.2002935145740354*b[i + 18*ldb] + 2.706910301921164*b[i + 19*ldb] + 0.2002935145740354*b[i + 20*ldb] + -0.7311661303469743*b[i + 27*ldb] + -0.6867884842939154*b[i + 28*ldb] + 0.005601583668738606*b[i + 29*ldb] + -0.7311661303469743*b[i + 36*ldb] + -0.6867884842939154*b[i + 37*ldb] + 0.005601583668738606*b[i + 38*ldb]);
        c[i + 16*ldc] += (0.3381049961377708*b[i + 4*ldb] + 2.661895003862189*b[i + 10*ldb] + -0.7311661303469743*b[i + 18*ldb] + -0.6867884842939154*b[i + 19*ldb] + 0.005601583668738606*b[i + 20*ldb] + 0.005601583668738606*b[i + 27*ldb] + -0.6867884842939154*b[i + 28*ldb] + -0.7311661303469743*b[i + 29*ldb] + 0.2002935145740354*b[i + 36*ldb] + 2.706910301921164*b[i + 37*ldb] + 0.2002935145740354*b[i + 38*ldb]);
        c[i + 17*ldc] += (0.3381049961377708*b[i + 5*ldb] + 2.661895003862189*b[i + 11*ldb] + 0.005601583668738606*b[i + 18*ldb] + -0.6867884842939154*b[i + 19*ldb] + -0.7311661303469743*b[i + 20*ldb] + 0.2002935145740354*b[i + 27*ldb] + 2.706910301921164*b[i + 28*ldb] + 0.2002935145740354*b[i + 29*ldb] + 0.005601583668738606*b[i + 36*ldb] + -0.6867884842939154*b[i + 37*ldb] + -0.7311661303469743*b[i + 38*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_pri_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (-0.09694942634794133*b[i + 21*ldb] + 0.3027634270400692*b[i + 22*ldb] + 3.298485680438136*b[i + 23*ldb] + 0.09694942634794133*b[i + 30*ldb] + -0.3027634270400692*b[i + 31*ldb] + -3.298485680438136*b[i + 32*ldb]);
        c[i + 1*ldc] += (3.298485680438136*b[i + 21*ldb] + 0.3027634270400692*b[i + 22*ldb] + -0.09694942634794133*b[i + 23*ldb] + -0.3919825279273307*b[i + 30*ldb] + -0.7278064792531951*b[i + 31*ldb] + -0.3919825279273307*b[i + 32*ldb]);
        c[i + 2*ldc] += (0.3919825279273307*b[i + 21*ldb] + 0.7278064792531951*b[i + 22*ldb] + 0.3919825279273307*b[i + 23*ldb] + -3.298485680438136*b[i + 30*ldb] + -0.3027634270400692*b[i + 31*ldb] + 0.09694942634794133*b[i + 32*ldb]);
        c[i + 3*ldc] += (-0.7311661303469743*b[i + 21*ldb] + -0.6867884842939154*b[i + 22*ldb] + 0.005601583668738612*b[i + 23*ldb] + 0.7311661303469743*b[i + 30*ldb] + 0.6867884842939154*b[i + 31*ldb] + -0.005601583668738612*b[i + 32*ldb]);
        c[i + 4*ldc] += (0.005601583668738612*b[i + 21*ldb] + -0.6867884842939154*b[i + 22*ldb] + -0.7311661303469743*b[i + 23*ldb] + -0.2002935145740354*b[i + 30*ldb] + -2.706910301921164*b[i + 31*ldb] + -0.2002935145740354*b[i + 32*ldb]);
        c[i + 5*ldc] += (0.2002935145740354*b[i + 21*ldb] + 2.706910301921164*b[i + 22*ldb] + 0.2002935145740354*b[i + 23*ldb] + -0.005601583668738612*b[i + 30*ldb] + 0.6867884842939154*b[i + 31*ldb] + 0.7311661303469743*b[i + 32*ldb]);
        c[i + 6*ldc] += (-0.09694942634794133*b[i + 24*ldb] + 0.3027634270400692*b[i + 25*ldb] + 3.298485680438136*b[i + 26*ldb] + 0.09694942634794133*b[i + 33*ldb] + -0.3027634270400692*b[i + 34*ldb] + -3.298485680438136*b[i + 35*ldb]);
        c[i + 7*ldc] += (3.298485680438136*b[i + 24*ldb] + 0.3027634270400692*b[i + 25*ldb] + -0.09694942634794133*b[i + 26*ldb] + -0.3919825279273307*b[i + 33*ldb] + -0.7278064792531951*b[i + 34*ldb] + -0.3919825279273307*b[i + 35*ldb]);
        c[i + 8*ldc] += (0.3919825279273307*b[i + 24*ldb] + 0.7278064792531951*b[i + 25*ldb] + 0.3919825279273307*b[i + 26*ldb] + -3.298485680438136*b[i + 33*ldb] + -0.3027634270400692*b[i + 34*ldb] + 0.09694942634794133*b[i + 35*ldb]);
        c[i + 9*ldc] += (-0.7311661303469743*b[i + 24*ldb] + -0.6867884842939154*b[i + 25*ldb] + 0.005601583668738612*b[i + 26*ldb] + 0.7311661303469743*b[i + 33*ldb] + 0.6867884842939154*b[i + 34*ldb] + -0.005601583668738612*b[i + 35*ldb]);
        c[i + 10*ldc] += (0.005601583668738612*b[i + 24*ldb] + -0.6867884842939154*b[i + 25*ldb] + -0.7311661303469743*b[i + 26*ldb] + -0.2002935145740354*b[i + 33*ldb] + -2.706910301921164*b[i + 34*ldb] + -0.2002935145740354*b[i + 35*ldb]);
        c[i + 11*ldc] += (0.2002935145740354*b[i + 24*ldb] + 2.706910301921164*b[i + 25*ldb] + 0.2002935145740354*b[i + 26*ldb] + -0.005601583668738612*b[i + 33*ldb] + 0.6867884842939154*b[i + 34*ldb] + 0.7311661303469743*b[i + 35*ldb]);
        c[i + 12*ldc] += (-0.09694942634794133*b[i + 27*ldb] + 0.3027634270400692*b[i + 28*ldb] + 3.298485680438136*b[i + 29*ldb] + 0.09694942634794133*b[i + 36*ldb] + -0.3027634270400692*b[i + 37*ldb] + -3.298485680438136*b[i + 38*ldb]);
        c[i + 13*ldc] += (3.298485680438136*b[i + 27*ldb] + 0.3027634270400692*b[i + 28*ldb] + -0.09694942634794133*b[i + 29*ldb] + -0.3919825279273307*b[i + 36*ldb] + -0.7278064792531951*b[i + 37*ldb] + -0.3919825279273307*b[i + 38*ldb]);
        c[i + 14*ldc] += (0.3919825279273307*b[i + 27*ldb] + 0.7278064792531951*b[i + 28*ldb] + 0.3919825279273307*b[i + 29*ldb] + -3.298485680438136*b[i + 36*ldb] + -0.3027634270400692*b[i + 37*ldb] + 0.09694942634794133*b[i + 38*ldb]);
        c[i + 15*ldc] += (-0.7311661303469743*b[i + 27*ldb] + -0.6867884842939154*b[i + 28*ldb] + 0.005601583668738612*b[i + 29*ldb] + 0.7311661303469743*b[i + 36*ldb] + 0.6867884842939154*b[i + 37*ldb] + -0.005601583668738612*b[i + 38*ldb]);
        c[i + 16*ldc] += (0.005601583668738612*b[i + 27*ldb] + -0.6867884842939154*b[i + 28*ldb] + -0.7311661303469743*b[i + 29*ldb] + -0.2002935145740354*b[i + 36*ldb] + -2.706910301921164*b[i + 37*ldb] + -0.2002935145740354*b[i + 38*ldb]);
        c[i + 17*ldc] += (0.2002935145740354*b[i + 27*ldb] + 2.706910301921164*b[i + 28*ldb] + 0.2002935145740354*b[i + 29*ldb] + -0.005601583668738612*b[i + 36*ldb] + 0.6867884842939154*b[i + 37*ldb] + 0.7311661303469743*b[i + 38*ldb]);
        c[i + 18*ldc] += (-0.3919825279273307*b[i + 12*ldb] + -0.7278064792531951*b[i + 13*ldb] + -0.3919825279273307*b[i + 14*ldb] + -0.09694942634794133*b[i + 21*ldb] + 0.3027634270400692*b[i + 22*ldb] + 3.298485680438136*b[i + 23*ldb]);
        c[i + 19*ldc] += (0.09694942634794133*b[i + 12*ldb] + -0.3027634270400692*b[i + 13*ldb] + -3.298485680438136*b[i + 14*ldb] + 3.298485680438136*b[i + 21*ldb] + 0.3027634270400692*b[i + 22*ldb] + -0.09694942634794133*b[i + 23*ldb]);
        c[i + 20*ldc] += (-3.298485680438136*b[i + 12*ldb] + -0.3027634270400692*b[i + 13*ldb] + 0.09694942634794133*b[i + 14*ldb] + 0.3919825279273307*b[i + 21*ldb] + 0.7278064792531951*b[i + 22*ldb] + 0.3919825279273307*b[i + 23*ldb]);
        c[i + 21*ldc] += (-0.2002935145740354*b[i + 12*ldb] + -2.706910301921164*b[i + 13*ldb] + -0.2002935145740354*b[i + 14*ldb] + -0.7311661303469743*b[i + 21*ldb] + -0.6867884842939154*b[i + 22*ldb] + 0.005601583668738612*b[i + 23*ldb]);
        c[i + 22*ldc] += (0.7311661303469743*b[i + 12*ldb] + 0.6867884842939154*b[i + 13*ldb] + -0.005601583668738612*b[i + 14*ldb] + 0.005601583668738612*b[i + 21*ldb] + -0.6867884842939154*b[i + 22*ldb] + -0.7311661303469743*b[i + 23*ldb]);
        c[i + 23*ldc] += (-0.005601583668738612*b[i + 12*ldb] + 0.6867884842939154*b[i + 13*ldb] + 0.7311661303469743*b[i + 14*ldb] + 0.2002935145740354*b[i + 21*ldb] + 2.706910301921164*b[i + 22*ldb] + 0.2002935145740354*b[i + 23*ldb]);
        c[i + 24*ldc] += (-0.3919825279273307*b[i + 15*ldb] + -0.7278064792531951*b[i + 16*ldb] + -0.3919825279273307*b[i + 17*ldb] + -0.09694942634794133*b[i + 24*ldb] + 0.3027634270400692*b[i + 25*ldb] + 3.298485680438136*b[i + 26*ldb]);
        c[i + 25*ldc] += (0.09694942634794133*b[i + 15*ldb] + -0.3027634270400692*b[i + 16*ldb] + -3.298485680438136*b[i + 17*ldb] + 3.298485680438136*b[i + 24*ldb] + 0.3027634270400692*b[i + 25*ldb] + -0.09694942634794133*b[i + 26*ldb]);
        c[i + 26*ldc] += (-3.298485680438136*b[i + 15*ldb] + -0.3027634270400692*b[i + 16*ldb] + 0.09694942634794133*b[i + 17*ldb] + 0.3919825279273307*b[i + 24*ldb] + 0.7278064792531951*b[i + 25*ldb] + 0.3919825279273307*b[i + 26*ldb]);
        c[i + 27*ldc] += (-0.2002935145740354*b[i + 15*ldb] + -2.706910301921164*b[i + 16*ldb] + -0.2002935145740354*b[i + 17*ldb] + -0.7311661303469743*b[i + 24*ldb] + -0.6867884842939154*b[i + 25*ldb] + 0.005601583668738612*b[i + 26*ldb]);
        c[i + 28*ldc] += (0.7311661303469743*b[i + 15*ldb] + 0.6867884842939154*b[i + 16*ldb] + -0.005601583668738612*b[i + 17*ldb] + 0.005601583668738612*b[i + 24*ldb] + -0.6867884842939154*b[i + 25*ldb] + -0.7311661303469743*b[i + 26*ldb]);
        c[i + 29*ldc] += (-0.005601583668738612*b[i + 15*ldb] + 0.6867884842939154*b[i + 16*ldb] + 0.7311661303469743*b[i + 17*ldb] + 0.2002935145740354*b[i + 24*ldb] + 2.706910301921164*b[i + 25*ldb] + 0.2002935145740354*b[i + 26*ldb]);
        c[i + 30*ldc] += (-0.3919825279273307*b[i + 18*ldb] + -0.7278064792531951*b[i + 19*ldb] + -0.3919825279273307*b[i + 20*ldb] + -0.09694942634794133*b[i + 27*ldb] + 0.3027634270400692*b[i + 28*ldb] + 3.298485680438136*b[i + 29*ldb]);
        c[i + 31*ldc] += (0.09694942634794133*b[i + 18*ldb] + -0.3027634270400692*b[i + 19*ldb] + -3.298485680438136*b[i + 20*ldb] + 3.298485680438136*b[i + 27*ldb] + 0.3027634270400692*b[i + 28*ldb] + -0.09694942634794133*b[i + 29*ldb]);
        c[i + 32*ldc] += (-3.298485680438136*b[i + 18*ldb] + -0.3027634270400692*b[i + 19*ldb] + 0.09694942634794133*b[i + 20*ldb] + 0.3919825279273307*b[i + 27*ldb] + 0.7278064792531951*b[i + 28*ldb] + 0.3919825279273307*b[i + 29*ldb]);
        c[i + 33*ldc] += (-0.2002935145740354*b[i + 18*ldb] + -2.706910301921164*b[i + 19*ldb] + -0.2002935145740354*b[i + 20*ldb] + -0.7311661303469743*b[i + 27*ldb] + -0.6867884842939154*b[i + 28*ldb] + 0.005601583668738612*b[i + 29*ldb]);
        c[i + 34*ldc] += (0.7311661303469743*b[i + 18*ldb] + 0.6867884842939154*b[i + 19*ldb] + -0.005601583668738612*b[i + 20*ldb] + 0.005601583668738612*b[i + 27*ldb] + -0.6867884842939154*b[i + 28*ldb] + -0.7311661303469743*b[i + 29*ldb]);
        c[i + 35*ldc] += (-0.005601583668738612*b[i + 18*ldb] + 0.6867884842939154*b[i + 19*ldb] + 0.7311661303469743*b[i + 20*ldb] + 0.2002935145740354*b[i + 27*ldb] + 2.706910301921164*b[i + 28*ldb] + 0.2002935145740354*b[i + 29*ldb]);
        c[i + 36*ldc] += (-2.661895003862189*b[i + 0*ldb] + 0.3381049961377708*b[i + 6*ldb]);
        c[i + 37*ldc] += (-2.661895003862189*b[i + 1*ldb] + 0.3381049961377708*b[i + 7*ldb]);
        c[i + 38*ldc] += (-2.661895003862189*b[i + 2*ldb] + 0.3381049961377708*b[i + 8*ldb]);
        c[i + 39*ldc] += (-2.661895003862189*b[i + 3*ldb] + 0.3381049961377708*b[i + 9*ldb]);
        c[i + 40*ldc] += (-2.661895003862189*b[i + 4*ldb] + 0.3381049961377708*b[i + 10*ldb]);
        c[i + 41*ldc] += (-2.661895003862189*b[i + 5*ldb] + 0.3381049961377708*b[i + 11*ldb]);
        c[i + 42*ldc] += (0.7499999999999898*b[i + 0*ldb] + -0.7499999999999898*b[i + 6*ldb]);
        c[i + 43*ldc] += (0.7499999999999898*b[i + 1*ldb] + -0.7499999999999898*b[i + 7*ldb]);
        c[i + 44*ldc] += (0.7499999999999898*b[i + 2*ldb] + -0.7499999999999898*b[i + 8*ldb]);
        c[i + 45*ldc] += (0.7499999999999898*b[i + 3*ldb] + -0.7499999999999898*b[i + 9*ldb]);
        c[i + 46*ldc] += (0.7499999999999898*b[i + 4*ldb] + -0.7499999999999898*b[i + 10*ldb]);
        c[i + 47*ldc] += (0.7499999999999898*b[i + 5*ldb] + -0.7499999999999898*b[i + 11*ldb]);
        c[i + 48*ldc] += (-0.3381049961377708*b[i + 0*ldb] + 2.661895003862189*b[i + 6*ldb]);
        c[i + 49*ldc] += (-0.3381049961377708*b[i + 1*ldb] + 2.661895003862189*b[i + 7*ldb]);
        c[i + 50*ldc] += (-0.3381049961377708*b[i + 2*ldb] + 2.661895003862189*b[i + 8*ldb]);
        c[i + 51*ldc] += (-0.3381049961377708*b[i + 3*ldb] + 2.661895003862189*b[i + 9*ldb]);
        c[i + 52*ldc] += (-0.3381049961377708*b[i + 4*ldb] + 2.661895003862189*b[i + 10*ldb]);
        c[i + 53*ldc] += (-0.3381049961377708*b[i + 5*ldb] + 2.661895003862189*b[i + 11*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_pri_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (0.06018808462247194*b[i + 1*ldb] + -0.06018808462247194*b[i + 2*ldb] + -0.05696044256955535*b[i + 4*ldb] + 0.05696044256955535*b[i + 5*ldb]);
        c[i + 1*ldc] = (0.7215484455871217*b[i + 0*ldb] + -2.040154638364251*b[i + 1*ldb] + 0.6613603609646496*b[i + 2*ldb] + -1.335282314209765*b[i + 3*ldb] + 1.278321871640128*b[i + 4*ldb] + -1.278321871640128*b[i + 5*ldb]);
        c[i + 2*ldc] = (-0.7215484455871217*b[i + 0*ldb] + -0.6613603609646496*b[i + 1*ldb] + 2.040154638364251*b[i + 2*ldb] + 1.335282314209765*b[i + 3*ldb] + 1.278321871640128*b[i + 4*ldb] + -1.278321871640128*b[i + 5*ldb]);
        c[i + 3*ldc] = (1.427297665304626*b[i + 1*ldb] + -1.427297665304626*b[i + 2*ldb] + -1.350757499664479*b[i + 4*ldb] + 1.350757499664479*b[i + 5*ldb]);
        c[i + 4*ldc] = (1.490896285102879*b[i + 0*ldb] + -0.06359861979823023*b[i + 1*ldb] + 0.06359861979823023*b[i + 2*ldb] + 0.06902096945487268*b[i + 3*ldb] + 1.540154638364237*b[i + 4*ldb] + 1.419778469119352*b[i + 5*ldb]);
        c[i + 5*ldc] = (-1.490896285102879*b[i + 0*ldb] + -0.06359861979823023*b[i + 1*ldb] + 0.06359861979823023*b[i + 2*ldb] + -0.06902096945487268*b[i + 3*ldb] + -1.419778469119352*b[i + 4*ldb] + -1.540154638364237*b[i + 5*ldb]);
        c[i + 6*ldc] = (0.06018808462247194*b[i + 7*ldb] + -0.06018808462247194*b[i + 8*ldb] + -0.05696044256955535*b[i + 10*ldb] + 0.05696044256955535*b[i + 11*ldb]);
        c[i + 7*ldc] = (0.7215484455871217*b[i + 6*ldb] + -2.040154638364251*b[i + 7*ldb] + 0.6613603609646496*b[i + 8*ldb] + -1.335282314209765*b[i + 9*ldb] + 1.278321871640128*b[i + 10*ldb] + -1.278321871640128*b[i + 11*ldb]);
        c[i + 8*ldc] = (-0.7215484455871217*b[i + 6*ldb] + -0.6613603609646496*b[i + 7*ldb] + 2.040154638364251*b[i + 8*ldb] + 1.335282314209765*b[i + 9*ldb] + 1.278321871640128*b[i + 10*ldb] + -1.278321871640128*b[i + 11*ldb]);
        c[i + 9*ldc] = (1.427297665304626*b[i + 7*ldb] + -1.427297665304626*b[i + 8*ldb] + -1.350757499664479*b[i + 10*ldb] + 1.350757499664479*b[i + 11*ldb]);
        c[i + 10*ldc] = (1.490896285102879*b[i + 6*ldb] + -0.06359861979823023*b[i + 7*ldb] + 0.06359861979823023*b[i + 8*ldb] + 0.06902096945487268*b[i + 9*ldb] + 1.540154638364237*b[i + 10*ldb] + 1.419778469119352*b[i + 11*ldb]);
        c[i + 11*ldc] = (-1.490896285102879*b[i + 6*ldb] + -0.06359861979823023*b[i + 7*ldb] + 0.06359861979823023*b[i + 8*ldb] + -0.06902096945487268*b[i + 9*ldb] + -1.419778469119352*b[i + 10*ldb] + -1.540154638364237*b[i + 11*ldb]);
        c[i + 12*ldc] = (0.06018808462247194*b[i + 13*ldb] + -0.06018808462247194*b[i + 14*ldb] + -0.05696044256955535*b[i + 16*ldb] + 0.05696044256955535*b[i + 17*ldb]);
        c[i + 13*ldc] = (0.7215484455871217*b[i + 12*ldb] + -2.040154638364251*b[i + 13*ldb] + 0.6613603609646496*b[i + 14*ldb] + -1.335282314209765*b[i + 15*ldb] + 1.278321871640128*b[i + 16*ldb] + -1.278321871640128*b[i + 17*ldb]);
        c[i + 14*ldc] = (-0.7215484455871217*b[i + 12*ldb] + -0.6613603609646496*b[i + 13*ldb] + 2.040154638364251*b[i + 14*ldb] + 1.335282314209765*b[i + 15*ldb] + 1.278321871640128*b[i + 16*ldb] + -1.278321871640128*b[i + 17*ldb]);
        c[i + 15*ldc] = (1.427297665304626*b[i + 13*ldb] + -1.427297665304626*b[i + 14*ldb] + -1.350757499664479*b[i + 16*ldb] + 1.350757499664479*b[i + 17*ldb]);
        c[i + 16*ldc] = (1.490896285102879*b[i + 12*ldb] + -0.06359861979823023*b[i + 13*ldb] + 0.06359861979823023*b[i + 14*ldb] + 0.06902096945487268*b[i + 15*ldb] + 1.540154638364237*b[i + 16*ldb] + 1.419778469119352*b[i + 17*ldb]);
        c[i + 17*ldc] = (-1.490896285102879*b[i + 12*ldb] + -0.06359861979823023*b[i + 13*ldb] + 0.06359861979823023*b[i + 14*ldb] + -0.06902096945487268*b[i + 15*ldb] + -1.419778469119352*b[i + 16*ldb] + -1.540154638364237*b[i + 17*ldb]);
        c[i + 18*ldc] = (-2.040154638364251*b[i + 0*ldb] + 0.7215484455871217*b[i + 1*ldb] + 0.6613603609646496*b[i + 2*ldb] + 1.278321871640128*b[i + 3*ldb] + -1.335282314209765*b[i + 4*ldb] + -1.278321871640128*b[i + 5*ldb]);
        c[i + 19*ldc] = (0.06018808462247194*b[i + 0*ldb] + -0.06018808462247194*b[i + 2*ldb] + -0.05696044256955535*b[i + 3*ldb] + 0.05696044256955535*b[i + 5*ldb]);
        c[i + 20*ldc] = (-0.6613603609646496*b[i + 0*ldb] + -0.7215484455871217*b[i + 1*ldb] + 2.040154638364251*b[i + 2*ldb] + 1.278321871640128*b[i + 3*ldb] + 1.335282314209765*b[i + 4*ldb] + -1.278321871640128*b[i + 5*ldb]);
        c[i + 21*ldc] = (-0.06359861979823023*b[i + 0*ldb] + 1.490896285102879*b[i + 1*ldb] + 0.06359861979823023*b[i + 2*ldb] + 1.540154638364237*b[i + 3*ldb] + 0.06902096945487268*b[i + 4*ldb] + 1.419778469119352*b[i + 5*ldb]);
        c[i + 22*ldc] = (1.427297665304626*b[i + 0*ldb] + -1.427297665304626*b[i + 2*ldb] + -1.350757499664479*b[i + 3*ldb] + 1.350757499664479*b[i + 5*ldb]);
        c[i + 23*ldc] = (-0.06359861979823023*b[i + 0*ldb] + -1.490896285102879*b[i + 1*ldb] + 0.06359861979823023*b[i + 2*ldb] + -1.419778469119352*b[i + 3*ldb] + -0.06902096945487268*b[i + 4*ldb] + -1.540154638364237*b[i + 5*ldb]);
        c[i + 24*ldc] = (-2.040154638364251*b[i + 6*ldb] + 0.7215484455871217*b[i + 7*ldb] + 0.6613603609646496*b[i + 8*ldb] + 1.278321871640128*b[i + 9*ldb] + -1.335282314209765*b[i + 10*ldb] + -1.278321871640128*b[i + 11*ldb]);
        c[i + 25*ldc] = (0.06018808462247194*b[i + 6*ldb] + -0.06018808462247194*b[i + 8*ldb] + -0.05696044256955535*b[i + 9*ldb] + 0.05696044256955535*b[i + 11*ldb]);
        c[i + 26*ldc] = (-0.6613603609646496*b[i + 6*ldb] + -0.7215484455871217*b[i + 7*ldb] + 2.040154638364251*b[i + 8*ldb] + 1.278321871640128*b[i + 9*ldb] + 1.335282314209765*b[i + 10*ldb] + -1.278321871640128*b[i + 11*ldb]);
        c[i + 27*ldc] = (-0.06359861979823023*b[i + 6*ldb] + 1.490896285102879*b[i + 7*ldb] + 0.06359861979823023*b[i + 8*ldb] + 1.540154638364237*b[i + 9*ldb] + 0.06902096945487268*b[i + 10*ldb] + 1.419778469119352*b[i + 11*ldb]);
        c[i + 28*ldc] = (1.427297665304626*b[i + 6*ldb] + -1.427297665304626*b[i + 8*ldb] + -1.350757499664479*b[i + 9*ldb] + 1.350757499664479*b[i + 11*ldb]);
        c[i + 29*ldc] = (-0.06359861979823023*b[i + 6*ldb] + -1.490896285102879*b[i + 7*ldb] + 0.06359861979823023*b[i + 8*ldb] + -1.419778469119352*b[i + 9*ldb] + -0.06902096945487268*b[i + 10*ldb] + -1.540154638364237*b[i + 11*ldb]);
        c[i + 30*ldc] = (-2.040154638364251*b[i + 12*ldb] + 0.7215484455871217*b[i + 13*ldb] + 0.6613603609646496*b[i + 14*ldb] + 1.278321871640128*b[i + 15*ldb] + -1.335282314209765*b[i + 16*ldb] + -1.278321871640128*b[i + 17*ldb]);
        c[i + 31*ldc] = (0.06018808462247194*b[i + 12*ldb] + -0.06018808462247194*b[i + 14*ldb] + -0.05696044256955535*b[i + 15*ldb] + 0.05696044256955535*b[i + 17*ldb]);
        c[i + 32*ldc] = (-0.6613603609646496*b[i + 12*ldb] + -0.7215484455871217*b[i + 13*ldb] + 2.040154638364251*b[i + 14*ldb] + 1.278321871640128*b[i + 15*ldb] + 1.335282314209765*b[i + 16*ldb] + -1.278321871640128*b[i + 17*ldb]);
        c[i + 33*ldc] = (-0.06359861979823023*b[i + 12*ldb] + 1.490896285102879*b[i + 13*ldb] + 0.06359861979823023*b[i + 14*ldb] + 1.540154638364237*b[i + 15*ldb] + 0.06902096945487268*b[i + 16*ldb] + 1.419778469119352*b[i + 17*ldb]);
        c[i + 34*ldc] = (1.427297665304626*b[i + 12*ldb] + -1.427297665304626*b[i + 14*ldb] + -1.350757499664479*b[i + 15*ldb] + 1.350757499664479*b[i + 17*ldb]);
        c[i + 35*ldc] = (-0.06359861979823023*b[i + 12*ldb] + -1.490896285102879*b[i + 13*ldb] + 0.06359861979823023*b[i + 14*ldb] + -1.419778469119352*b[i + 15*ldb] + -0.06902096945487268*b[i + 16*ldb] + -1.540154638364237*b[i + 17*ldb]);
        c[i + 36*ldc] = (1.936491673103655*b[i + 0*ldb] + 1.032795558988666*b[i + 6*ldb] + -0.6454972243679038*b[i + 12*ldb]);
        c[i + 37*ldc] = (1.936491673103655*b[i + 1*ldb] + 1.032795558988666*b[i + 7*ldb] + -0.6454972243679038*b[i + 13*ldb]);
        c[i + 38*ldc] = (1.936491673103655*b[i + 2*ldb] + 1.032795558988666*b[i + 8*ldb] + -0.6454972243679038*b[i + 14*ldb]);
        c[i + 39*ldc] = (1.936491673103655*b[i + 3*ldb] + 1.032795558988666*b[i + 9*ldb] + -0.6454972243679038*b[i + 15*ldb]);
        c[i + 40*ldc] = (1.936491673103655*b[i + 4*ldb] + 1.032795558988666*b[i + 10*ldb] + -0.6454972243679038*b[i + 16*ldb]);
        c[i + 41*ldc] = (1.936491673103655*b[i + 5*ldb] + 1.032795558988666*b[i + 11*ldb] + -0.6454972243679038*b[i + 17*ldb]);
        c[i + 42*ldc] = (-1.613743060919744*b[i + 0*ldb] + 1.613743060919744*b[i + 12*ldb]);
        c[i + 43*ldc] = (-1.613743060919744*b[i + 1*ldb] + 1.613743060919744*b[i + 13*ldb]);
        c[i + 44*ldc] = (-1.613743060919744*b[i + 2*ldb] + 1.613743060919744*b[i + 14*ldb]);
        c[i + 45*ldc] = (-1.613743060919744*b[i + 3*ldb] + 1.613743060919744*b[i + 15*ldb]);
        c[i + 46*ldc] = (-1.613743060919744*b[i + 4*ldb] + 1.613743060919744*b[i + 16*ldb]);
        c[i + 47*ldc] = (-1.613743060919744*b[i + 5*ldb] + 1.613743060919744*b[i + 17*ldb]);
        c[i + 48*ldc] = (0.6454972243679038*b[i + 0*ldb] + -1.032795558988666*b[i + 6*ldb] + -1.936491673103655*b[i + 12*ldb]);
        c[i + 49*ldc] = (0.6454972243679038*b[i + 1*ldb] + -1.032795558988666*b[i + 7*ldb] + -1.936491673103655*b[i + 13*ldb]);
        c[i + 50*ldc] = (0.6454972243679038*b[i + 2*ldb] + -1.032795558988666*b[i + 8*ldb] + -1.936491673103655*b[i + 14*ldb]);
        c[i + 51*ldc] = (0.6454972243679038*b[i + 3*ldb] + -1.032795558988666*b[i + 9*ldb] + -1.936491673103655*b[i + 15*ldb]);
        c[i + 52*ldc] = (0.6454972243679038*b[i + 4*ldb] + -1.032795558988666*b[i + 10*ldb] + -1.936491673103655*b[i + 16*ldb]);
        c[i + 53*ldc] = (0.6454972243679038*b[i + 5*ldb] + -1.032795558988666*b[i + 11*ldb] + -1.936491673103655*b[i + 17*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p2_pri_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (0.06018808462247194*b[i + 1*ldb] + -0.06018808462247194*b[i + 2*ldb] + -0.05696044256955535*b[i + 4*ldb] + 0.05696044256955535*b[i + 5*ldb] + -2.040154638364251*b[i + 18*ldb] + 0.7215484455871217*b[i + 19*ldb] + 0.6613603609646496*b[i + 20*ldb] + 1.278321871640128*b[i + 21*ldb] + -1.335282314209765*b[i + 22*ldb] + -1.278321871640128*b[i + 23*ldb] + 1.936491673103655*b[i + 36*ldb] + 1.032795558988666*b[i + 42*ldb] + -0.6454972243679038*b[i + 48*ldb]);
        c[i + 1*ldc] = (0.7215484455871217*b[i + 0*ldb] + -2.040154638364251*b[i + 1*ldb] + 0.6613603609646496*b[i + 2*ldb] + -1.335282314209765*b[i + 3*ldb] + 1.278321871640128*b[i + 4*ldb] + -1.278321871640128*b[i + 5*ldb] + 0.06018808462247194*b[i + 18*ldb] + -0.06018808462247194*b[i + 20*ldb] + -0.05696044256955535*b[i + 21*ldb] + 0.05696044256955535*b[i + 23*ldb] + 1.936491673103655*b[i + 37*ldb] + 1.032795558988666*b[i + 43*ldb] + -0.6454972243679038*b[i + 49*ldb]);
        c[i + 2*ldc] = (-0.7215484455871217*b[i + 0*ldb] + -0.6613603609646496*b[i + 1*ldb] + 2.040154638364251*b[i + 2*ldb] + 1.335282314209765*b[i + 3*ldb] + 1.278321871640128*b[i + 4*ldb] + -1.278321871640128*b[i + 5*ldb] + -0.6613603609646496*b[i + 18*ldb] + -0.7215484455871217*b[i + 19*ldb] + 2.040154638364251*b[i + 20*ldb] + 1.278321871640128*b[i + 21*ldb] + 1.335282314209765*b[i + 22*ldb] + -1.278321871640128*b[i + 23*ldb] + 1.936491673103655*b[i + 38*ldb] + 1.032795558988666*b[i + 44*ldb] + -0.6454972243679038*b[i + 50*ldb]);
        c[i + 3*ldc] = (1.427297665304626*b[i + 1*ldb] + -1.427297665304626*b[i + 2*ldb] + -1.350757499664479*b[i + 4*ldb] + 1.350757499664479*b[i + 5*ldb] + -0.06359861979823023*b[i + 18*ldb] + 1.490896285102879*b[i + 19*ldb] + 0.06359861979823023*b[i + 20*ldb] + 1.540154638364237*b[i + 21*ldb] + 0.06902096945487268*b[i + 22*ldb] + 1.419778469119352*b[i + 23*ldb] + 1.936491673103655*b[i + 39*ldb] + 1.032795558988666*b[i + 45*ldb] + -0.6454972243679038*b[i + 51*ldb]);
        c[i + 4*ldc] = (1.490896285102879*b[i + 0*ldb] + -0.06359861979823023*b[i + 1*ldb] + 0.06359861979823023*b[i + 2*ldb] + 0.06902096945487268*b[i + 3*ldb] + 1.540154638364237*b[i + 4*ldb] + 1.419778469119352*b[i + 5*ldb] + 1.427297665304626*b[i + 18*ldb] + -1.427297665304626*b[i + 20*ldb] + -1.350757499664479*b[i + 21*ldb] + 1.350757499664479*b[i + 23*ldb] + 1.936491673103655*b[i + 40*ldb] + 1.032795558988666*b[i + 46*ldb] + -0.6454972243679038*b[i + 52*ldb]);
        c[i + 5*ldc] = (-1.490896285102879*b[i + 0*ldb] + -0.06359861979823023*b[i + 1*ldb] + 0.06359861979823023*b[i + 2*ldb] + -0.06902096945487268*b[i + 3*ldb] + -1.419778469119352*b[i + 4*ldb] + -1.540154638364237*b[i + 5*ldb] + -0.06359861979823023*b[i + 18*ldb] + -1.490896285102879*b[i + 19*ldb] + 0.06359861979823023*b[i + 20*ldb] + -1.419778469119352*b[i + 21*ldb] + -0.06902096945487268*b[i + 22*ldb] + -1.540154638364237*b[i + 23*ldb] + 1.936491673103655*b[i + 41*ldb] + 1.032795558988666*b[i + 47*ldb] + -0.6454972243679038*b[i + 53*ldb]);
        c[i + 6*ldc] = (0.06018808462247194*b[i + 7*ldb] + -0.06018808462247194*b[i + 8*ldb] + -0.05696044256955535*b[i + 10*ldb] + 0.05696044256955535*b[i + 11*ldb] + -2.040154638364251*b[i + 24*ldb] + 0.7215484455871217*b[i + 25*ldb] + 0.6613603609646496*b[i + 26*ldb] + 1.278321871640128*b[i + 27*ldb] + -1.335282314209765*b[i + 28*ldb] + -1.278321871640128*b[i + 29*ldb] + -1.613743060919744*b[i + 36*ldb] + 1.613743060919744*b[i + 48*ldb]);
        c[i + 7*ldc] = (0.7215484455871217*b[i + 6*ldb] + -2.040154638364251*b[i + 7*ldb] + 0.6613603609646496*b[i + 8*ldb] + -1.335282314209765*b[i + 9*ldb] + 1.278321871640128*b[i + 10*ldb] + -1.278321871640128*b[i + 11*ldb] + 0.06018808462247194*b[i + 24*ldb] + -0.06018808462247194*b[i + 26*ldb] + -0.05696044256955535*b[i + 27*ldb] + 0.05696044256955535*b[i + 29*ldb] + -1.613743060919744*b[i + 37*ldb] + 1.613743060919744*b[i + 49*ldb]);
        c[i + 8*ldc] = (-0.7215484455871217*b[i + 6*ldb] + -0.6613603609646496*b[i + 7*ldb] + 2.040154638364251*b[i + 8*ldb] + 1.335282314209765*b[i + 9*ldb] + 1.278321871640128*b[i + 10*ldb] + -1.278321871640128*b[i + 11*ldb] + -0.6613603609646496*b[i + 24*ldb] + -0.7215484455871217*b[i + 25*ldb] + 2.040154638364251*b[i + 26*ldb] + 1.278321871640128*b[i + 27*ldb] + 1.335282314209765*b[i + 28*ldb] + -1.278321871640128*b[i + 29*ldb] + -1.613743060919744*b[i + 38*ldb] + 1.613743060919744*b[i + 50*ldb]);
        c[i + 9*ldc] = (1.427297665304626*b[i + 7*ldb] + -1.427297665304626*b[i + 8*ldb] + -1.350757499664479*b[i + 10*ldb] + 1.350757499664479*b[i + 11*ldb] + -0.06359861979823023*b[i + 24*ldb] + 1.490896285102879*b[i + 25*ldb] + 0.06359861979823023*b[i + 26*ldb] + 1.540154638364237*b[i + 27*ldb] + 0.06902096945487268*b[i + 28*ldb] + 1.419778469119352*b[i + 29*ldb] + -1.613743060919744*b[i + 39*ldb] + 1.613743060919744*b[i + 51*ldb]);
        c[i + 10*ldc] = (1.490896285102879*b[i + 6*ldb] + -0.06359861979823023*b[i + 7*ldb] + 0.06359861979823023*b[i + 8*ldb] + 0.06902096945487268*b[i + 9*ldb] + 1.540154638364237*b[i + 10*ldb] + 1.419778469119352*b[i + 11*ldb] + 1.427297665304626*b[i + 24*ldb] + -1.427297665304626*b[i + 26*ldb] + -1.350757499664479*b[i + 27*ldb] + 1.350757499664479*b[i + 29*ldb] + -1.613743060919744*b[i + 40*ldb] + 1.613743060919744*b[i + 52*ldb]);
        c[i + 11*ldc] = (-1.490896285102879*b[i + 6*ldb] + -0.06359861979823023*b[i + 7*ldb] + 0.06359861979823023*b[i + 8*ldb] + -0.06902096945487268*b[i + 9*ldb] + -1.419778469119352*b[i + 10*ldb] + -1.540154638364237*b[i + 11*ldb] + -0.06359861979823023*b[i + 24*ldb] + -1.490896285102879*b[i + 25*ldb] + 0.06359861979823023*b[i + 26*ldb] + -1.419778469119352*b[i + 27*ldb] + -0.06902096945487268*b[i + 28*ldb] + -1.540154638364237*b[i + 29*ldb] + -1.613743060919744*b[i + 41*ldb] + 1.613743060919744*b[i + 53*ldb]);
        c[i + 12*ldc] = (0.06018808462247194*b[i + 13*ldb] + -0.06018808462247194*b[i + 14*ldb] + -0.05696044256955535*b[i + 16*ldb] + 0.05696044256955535*b[i + 17*ldb] + -2.040154638364251*b[i + 30*ldb] + 0.7215484455871217*b[i + 31*ldb] + 0.6613603609646496*b[i + 32*ldb] + 1.278321871640128*b[i + 33*ldb] + -1.335282314209765*b[i + 34*ldb] + -1.278321871640128*b[i + 35*ldb] + 0.6454972243679038*b[i + 36*ldb] + -1.032795558988666*b[i + 42*ldb] + -1.936491673103655*b[i + 48*ldb]);
        c[i + 13*ldc] = (0.7215484455871217*b[i + 12*ldb] + -2.040154638364251*b[i + 13*ldb] + 0.6613603609646496*b[i + 14*ldb] + -1.335282314209765*b[i + 15*ldb] + 1.278321871640128*b[i + 16*ldb] + -1.278321871640128*b[i + 17*ldb] + 0.06018808462247194*b[i + 30*ldb] + -0.06018808462247194*b[i + 32*ldb] + -0.05696044256955535*b[i + 33*ldb] + 0.05696044256955535*b[i + 35*ldb] + 0.6454972243679038*b[i + 37*ldb] + -1.032795558988666*b[i + 43*ldb] + -1.936491673103655*b[i + 49*ldb]);
        c[i + 14*ldc] = (-0.7215484455871217*b[i + 12*ldb] + -0.6613603609646496*b[i + 13*ldb] + 2.040154638364251*b[i + 14*ldb] + 1.335282314209765*b[i + 15*ldb] + 1.278321871640128*b[i + 16*ldb] + -1.278321871640128*b[i + 17*ldb] + -0.6613603609646496*b[i + 30*ldb] + -0.7215484455871217*b[i + 31*ldb] + 2.040154638364251*b[i + 32*ldb] + 1.278321871640128*b[i + 33*ldb] + 1.335282314209765*b[i + 34*ldb] + -1.278321871640128*b[i + 35*ldb] + 0.6454972243679038*b[i + 38*ldb] + -1.032795558988666*b[i + 44*ldb] + -1.936491673103655*b[i + 50*ldb]);
        c[i + 15*ldc] = (1.427297665304626*b[i + 13*ldb] + -1.427297665304626*b[i + 14*ldb] + -1.350757499664479*b[i + 16*ldb] + 1.350757499664479*b[i + 17*ldb] + -0.06359861979823023*b[i + 30*ldb] + 1.490896285102879*b[i + 31*ldb] + 0.06359861979823023*b[i + 32*ldb] + 1.540154638364237*b[i + 33*ldb] + 0.06902096945487268*b[i + 34*ldb] + 1.419778469119352*b[i + 35*ldb] + 0.6454972243679038*b[i + 39*ldb] + -1.032795558988666*b[i + 45*ldb] + -1.936491673103655*b[i + 51*ldb]);
        c[i + 16*ldc] = (1.490896285102879*b[i + 12*ldb] + -0.06359861979823023*b[i + 13*ldb] + 0.06359861979823023*b[i + 14*ldb] + 0.06902096945487268*b[i + 15*ldb] + 1.540154638364237*b[i + 16*ldb] + 1.419778469119352*b[i + 17*ldb] + 1.427297665304626*b[i + 30*ldb] + -1.427297665304626*b[i + 32*ldb] + -1.350757499664479*b[i + 33*ldb] + 1.350757499664479*b[i + 35*ldb] + 0.6454972243679038*b[i + 40*ldb] + -1.032795558988666*b[i + 46*ldb] + -1.936491673103655*b[i + 52*ldb]);
        c[i + 17*ldc] = (-1.490896285102879*b[i + 12*ldb] + -0.06359861979823023*b[i + 13*ldb] + 0.06359861979823023*b[i + 14*ldb] + -0.06902096945487268*b[i + 15*ldb] + -1.419778469119352*b[i + 16*ldb] + -1.540154638364237*b[i + 17*ldb] + -0.06359861979823023*b[i + 30*ldb] + -1.490896285102879*b[i + 31*ldb] + 0.06359861979823023*b[i + 32*ldb] + -1.419778469119352*b[i + 33*ldb] + -0.06902096945487268*b[i + 34*ldb] + -1.540154638364237*b[i + 35*ldb] + 0.6454972243679038*b[i + 41*ldb] + -1.032795558988666*b[i + 47*ldb] + -1.936491673103655*b[i + 53*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_hex_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.526788125457267*b[i + 0*ldb] + -0.8136324494869274*b[i + 16*ldb] + 0.4007615203116505*b[i + 32*ldb] + -0.11391719628199*b[i + 48*ldb]);
        c[i + 1*ldc] = (1.526788125457267*b[i + 1*ldb] + -0.8136324494869274*b[i + 17*ldb] + 0.4007615203116505*b[i + 33*ldb] + -0.11391719628199*b[i + 49*ldb]);
        c[i + 2*ldc] = (1.526788125457267*b[i + 2*ldb] + -0.8136324494869274*b[i + 18*ldb] + 0.4007615203116505*b[i + 34*ldb] + -0.11391719628199*b[i + 50*ldb]);
        c[i + 3*ldc] = (1.526788125457267*b[i + 3*ldb] + -0.8136324494869274*b[i + 19*ldb] + 0.4007615203116505*b[i + 35*ldb] + -0.11391719628199*b[i + 51*ldb]);
        c[i + 4*ldc] = (1.526788125457267*b[i + 4*ldb] + -0.8136324494869274*b[i + 20*ldb] + 0.4007615203116505*b[i + 36*ldb] + -0.11391719628199*b[i + 52*ldb]);
        c[i + 5*ldc] = (1.526788125457267*b[i + 5*ldb] + -0.8136324494869274*b[i + 21*ldb] + 0.4007615203116505*b[i + 37*ldb] + -0.11391719628199*b[i + 53*ldb]);
        c[i + 6*ldc] = (1.526788125457267*b[i + 6*ldb] + -0.8136324494869274*b[i + 22*ldb] + 0.4007615203116505*b[i + 38*ldb] + -0.11391719628199*b[i + 54*ldb]);
        c[i + 7*ldc] = (1.526788125457267*b[i + 7*ldb] + -0.8136324494869274*b[i + 23*ldb] + 0.4007615203116505*b[i + 39*ldb] + -0.11391719628199*b[i + 55*ldb]);
        c[i + 8*ldc] = (1.526788125457267*b[i + 8*ldb] + -0.8136324494869274*b[i + 24*ldb] + 0.4007615203116505*b[i + 40*ldb] + -0.11391719628199*b[i + 56*ldb]);
        c[i + 9*ldc] = (1.526788125457267*b[i + 9*ldb] + -0.8136324494869274*b[i + 25*ldb] + 0.4007615203116505*b[i + 41*ldb] + -0.11391719628199*b[i + 57*ldb]);
        c[i + 10*ldc] = (1.526788125457267*b[i + 10*ldb] + -0.8136324494869274*b[i + 26*ldb] + 0.4007615203116505*b[i + 42*ldb] + -0.11391719628199*b[i + 58*ldb]);
        c[i + 11*ldc] = (1.526788125457267*b[i + 11*ldb] + -0.8136324494869274*b[i + 27*ldb] + 0.4007615203116505*b[i + 43*ldb] + -0.11391719628199*b[i + 59*ldb]);
        c[i + 12*ldc] = (1.526788125457267*b[i + 12*ldb] + -0.8136324494869274*b[i + 28*ldb] + 0.4007615203116505*b[i + 44*ldb] + -0.11391719628199*b[i + 60*ldb]);
        c[i + 13*ldc] = (1.526788125457267*b[i + 13*ldb] + -0.8136324494869274*b[i + 29*ldb] + 0.4007615203116505*b[i + 45*ldb] + -0.11391719628199*b[i + 61*ldb]);
        c[i + 14*ldc] = (1.526788125457267*b[i + 14*ldb] + -0.8136324494869274*b[i + 30*ldb] + 0.4007615203116505*b[i + 46*ldb] + -0.11391719628199*b[i + 62*ldb]);
        c[i + 15*ldc] = (1.526788125457267*b[i + 15*ldb] + -0.8136324494869274*b[i + 31*ldb] + 0.4007615203116505*b[i + 47*ldb] + -0.11391719628199*b[i + 63*ldb]);
        c[i + 16*ldc] = (1.526788125457267*b[i + 0*ldb] + -0.8136324494869274*b[i + 4*ldb] + 0.4007615203116505*b[i + 8*ldb] + -0.11391719628199*b[i + 12*ldb]);
        c[i + 17*ldc] = (1.526788125457267*b[i + 1*ldb] + -0.8136324494869274*b[i + 5*ldb] + 0.4007615203116505*b[i + 9*ldb] + -0.11391719628199*b[i + 13*ldb]);
        c[i + 18*ldc] = (1.526788125457267*b[i + 2*ldb] + -0.8136324494869274*b[i + 6*ldb] + 0.4007615203116505*b[i + 10*ldb] + -0.11391719628199*b[i + 14*ldb]);
        c[i + 19*ldc] = (1.526788125457267*b[i + 3*ldb] + -0.8136324494869274*b[i + 7*ldb] + 0.4007615203116505*b[i + 11*ldb] + -0.11391719628199*b[i + 15*ldb]);
        c[i + 20*ldc] = (1.526788125457267*b[i + 16*ldb] + -0.8136324494869274*b[i + 20*ldb] + 0.4007615203116505*b[i + 24*ldb] + -0.11391719628199*b[i + 28*ldb]);
        c[i + 21*ldc] = (1.526788125457267*b[i + 17*ldb] + -0.8136324494869274*b[i + 21*ldb] + 0.4007615203116505*b[i + 25*ldb] + -0.11391719628199*b[i + 29*ldb]);
        c[i + 22*ldc] = (1.526788125457267*b[i + 18*ldb] + -0.8136324494869274*b[i + 22*ldb] + 0.4007615203116505*b[i + 26*ldb] + -0.11391719628199*b[i + 30*ldb]);
        c[i + 23*ldc] = (1.526788125457267*b[i + 19*ldb] + -0.8136324494869274*b[i + 23*ldb] + 0.4007615203116505*b[i + 27*ldb] + -0.11391719628199*b[i + 31*ldb]);
        c[i + 24*ldc] = (1.526788125457267*b[i + 32*ldb] + -0.8136324494869274*b[i + 36*ldb] + 0.4007615203116505*b[i + 40*ldb] + -0.11391719628199*b[i + 44*ldb]);
        c[i + 25*ldc] = (1.526788125457267*b[i + 33*ldb] + -0.8136324494869274*b[i + 37*ldb] + 0.4007615203116505*b[i + 41*ldb] + -0.11391719628199*b[i + 45*ldb]);
        c[i + 26*ldc] = (1.526788125457267*b[i + 34*ldb] + -0.8136324494869274*b[i + 38*ldb] + 0.4007615203116505*b[i + 42*ldb] + -0.11391719628199*b[i + 46*ldb]);
        c[i + 27*ldc] = (1.526788125457267*b[i + 35*ldb] + -0.8136324494869274*b[i + 39*ldb] + 0.4007615203116505*b[i + 43*ldb] + -0.11391719628199*b[i + 47*ldb]);
        c[i + 28*ldc] = (1.526788125457267*b[i + 48*ldb] + -0.8136324494869274*b[i + 52*ldb] + 0.4007615203116505*b[i + 56*ldb] + -0.11391719628199*b[i + 60*ldb]);
        c[i + 29*ldc] = (1.526788125457267*b[i + 49*ldb] + -0.8136324494869274*b[i + 53*ldb] + 0.4007615203116505*b[i + 57*ldb] + -0.11391719628199*b[i + 61*ldb]);
        c[i + 30*ldc] = (1.526788125457267*b[i + 50*ldb] + -0.8136324494869274*b[i + 54*ldb] + 0.4007615203116505*b[i + 58*ldb] + -0.11391719628199*b[i + 62*ldb]);
        c[i + 31*ldc] = (1.526788125457267*b[i + 51*ldb] + -0.8136324494869274*b[i + 55*ldb] + 0.4007615203116505*b[i + 59*ldb] + -0.11391719628199*b[i + 63*ldb]);
        c[i + 32*ldc] = (-0.11391719628199*b[i + 0*ldb] + 0.4007615203116505*b[i + 1*ldb] + -0.8136324494869274*b[i + 2*ldb] + 1.526788125457267*b[i + 3*ldb]);
        c[i + 33*ldc] = (-0.11391719628199*b[i + 4*ldb] + 0.4007615203116505*b[i + 5*ldb] + -0.8136324494869274*b[i + 6*ldb] + 1.526788125457267*b[i + 7*ldb]);
        c[i + 34*ldc] = (-0.11391719628199*b[i + 8*ldb] + 0.4007615203116505*b[i + 9*ldb] + -0.8136324494869274*b[i + 10*ldb] + 1.526788125457267*b[i + 11*ldb]);
        c[i + 35*ldc] = (-0.11391719628199*b[i + 12*ldb] + 0.4007615203116505*b[i + 13*ldb] + -0.8136324494869274*b[i + 14*ldb] + 1.526788125457267*b[i + 15*ldb]);
        c[i + 36*ldc] = (-0.11391719628199*b[i + 16*ldb] + 0.4007615203116505*b[i + 17*ldb] + -0.8136324494869274*b[i + 18*ldb] + 1.526788125457267*b[i + 19*ldb]);
        c[i + 37*ldc] = (-0.11391719628199*b[i + 20*ldb] + 0.4007615203116505*b[i + 21*ldb] + -0.8136324494869274*b[i + 22*ldb] + 1.526788125457267*b[i + 23*ldb]);
        c[i + 38*ldc] = (-0.11391719628199*b[i + 24*ldb] + 0.4007615203116505*b[i + 25*ldb] + -0.8136324494869274*b[i + 26*ldb] + 1.526788125457267*b[i + 27*ldb]);
        c[i + 39*ldc] = (-0.11391719628199*b[i + 28*ldb] + 0.4007615203116505*b[i + 29*ldb] + -0.8136324494869274*b[i + 30*ldb] + 1.526788125457267*b[i + 31*ldb]);
        c[i + 40*ldc] = (-0.11391719628199*b[i + 32*ldb] + 0.4007615203116505*b[i + 33*ldb] + -0.8136324494869274*b[i + 34*ldb] + 1.526788125457267*b[i + 35*ldb]);
        c[i + 41*ldc] = (-0.11391719628199*b[i + 36*ldb] + 0.4007615203116505*b[i + 37*ldb] + -0.8136324494869274*b[i + 38*ldb] + 1.526788125457267*b[i + 39*ldb]);
        c[i + 42*ldc] = (-0.11391719628199*b[i + 40*ldb] + 0.4007615203116505*b[i + 41*ldb] + -0.8136324494869274*b[i + 42*ldb] + 1.526788125457267*b[i + 43*ldb]);
        c[i + 43*ldc] = (-0.11391719628199*b[i + 44*ldb] + 0.4007615203116505*b[i + 45*ldb] + -0.8136324494869274*b[i + 46*ldb] + 1.526788125457267*b[i + 47*ldb]);
        c[i + 44*ldc] = (-0.11391719628199*b[i + 48*ldb] + 0.4007615203116505*b[i + 49*ldb] + -0.8136324494869274*b[i + 50*ldb] + 1.526788125457267*b[i + 51*ldb]);
        c[i + 45*ldc] = (-0.11391719628199*b[i + 52*ldb] + 0.4007615203116505*b[i + 53*ldb] + -0.8136324494869274*b[i + 54*ldb] + 1.526788125457267*b[i + 55*ldb]);
        c[i + 46*ldc] = (-0.11391719628199*b[i + 56*ldb] + 0.4007615203116505*b[i + 57*ldb] + -0.8136324494869274*b[i + 58*ldb] + 1.526788125457267*b[i + 59*ldb]);
        c[i + 47*ldc] = (-0.11391719628199*b[i + 60*ldb] + 0.4007615203116505*b[i + 61*ldb] + -0.8136324494869274*b[i + 62*ldb] + 1.526788125457267*b[i + 63*ldb]);
        c[i + 48*ldc] = (-0.11391719628199*b[i + 0*ldb] + 0.4007615203116505*b[i + 4*ldb] + -0.8136324494869274*b[i + 8*ldb] + 1.526788125457267*b[i + 12*ldb]);
        c[i + 49*ldc] = (-0.11391719628199*b[i + 1*ldb] + 0.4007615203116505*b[i + 5*ldb] + -0.8136324494869274*b[i + 9*ldb] + 1.526788125457267*b[i + 13*ldb]);
        c[i + 50*ldc] = (-0.11391719628199*b[i + 2*ldb] + 0.4007615203116505*b[i + 6*ldb] + -0.8136324494869274*b[i + 10*ldb] + 1.526788125457267*b[i + 14*ldb]);
        c[i + 51*ldc] = (-0.11391719628199*b[i + 3*ldb] + 0.4007615203116505*b[i + 7*ldb] + -0.8136324494869274*b[i + 11*ldb] + 1.526788125457267*b[i + 15*ldb]);
        c[i + 52*ldc] = (-0.11391719628199*b[i + 16*ldb] + 0.4007615203116505*b[i + 20*ldb] + -0.8136324494869274*b[i + 24*ldb] + 1.526788125457267*b[i + 28*ldb]);
        c[i + 53*ldc] = (-0.11391719628199*b[i + 17*ldb] + 0.4007615203116505*b[i + 21*ldb] + -0.8136324494869274*b[i + 25*ldb] + 1.526788125457267*b[i + 29*ldb]);
        c[i + 54*ldc] = (-0.11391719628199*b[i + 18*ldb] + 0.4007615203116505*b[i + 22*ldb] + -0.8136324494869274*b[i + 26*ldb] + 1.526788125457267*b[i + 30*ldb]);
        c[i + 55*ldc] = (-0.11391719628199*b[i + 19*ldb] + 0.4007615203116505*b[i + 23*ldb] + -0.8136324494869274*b[i + 27*ldb] + 1.526788125457267*b[i + 31*ldb]);
        c[i + 56*ldc] = (-0.11391719628199*b[i + 32*ldb] + 0.4007615203116505*b[i + 36*ldb] + -0.8136324494869274*b[i + 40*ldb] + 1.526788125457267*b[i + 44*ldb]);
        c[i + 57*ldc] = (-0.11391719628199*b[i + 33*ldb] + 0.4007615203116505*b[i + 37*ldb] + -0.8136324494869274*b[i + 41*ldb] + 1.526788125457267*b[i + 45*ldb]);
        c[i + 58*ldc] = (-0.11391719628199*b[i + 34*ldb] + 0.4007615203116505*b[i + 38*ldb] + -0.8136324494869274*b[i + 42*ldb] + 1.526788125457267*b[i + 46*ldb]);
        c[i + 59*ldc] = (-0.11391719628199*b[i + 35*ldb] + 0.4007615203116505*b[i + 39*ldb] + -0.8136324494869274*b[i + 43*ldb] + 1.526788125457267*b[i + 47*ldb]);
        c[i + 60*ldc] = (-0.11391719628199*b[i + 48*ldb] + 0.4007615203116505*b[i + 52*ldb] + -0.8136324494869274*b[i + 56*ldb] + 1.526788125457267*b[i + 60*ldb]);
        c[i + 61*ldc] = (-0.11391719628199*b[i + 49*ldb] + 0.4007615203116505*b[i + 53*ldb] + -0.8136324494869274*b[i + 57*ldb] + 1.526788125457267*b[i + 61*ldb]);
        c[i + 62*ldc] = (-0.11391719628199*b[i + 50*ldb] + 0.4007615203116505*b[i + 54*ldb] + -0.8136324494869274*b[i + 58*ldb] + 1.526788125457267*b[i + 62*ldb]);
        c[i + 63*ldc] = (-0.11391719628199*b[i + 51*ldb] + 0.4007615203116505*b[i + 55*ldb] + -0.8136324494869274*b[i + 59*ldb] + 1.526788125457267*b[i + 63*ldb]);
        c[i + 64*ldc] = (1.526788125457267*b[i + 0*ldb] + -0.8136324494869274*b[i + 1*ldb] + 0.4007615203116505*b[i + 2*ldb] + -0.11391719628199*b[i + 3*ldb]);
        c[i + 65*ldc] = (1.526788125457267*b[i + 4*ldb] + -0.8136324494869274*b[i + 5*ldb] + 0.4007615203116505*b[i + 6*ldb] + -0.11391719628199*b[i + 7*ldb]);
        c[i + 66*ldc] = (1.526788125457267*b[i + 8*ldb] + -0.8136324494869274*b[i + 9*ldb] + 0.4007615203116505*b[i + 10*ldb] + -0.11391719628199*b[i + 11*ldb]);
        c[i + 67*ldc] = (1.526788125457267*b[i + 12*ldb] + -0.8136324494869274*b[i + 13*ldb] + 0.4007615203116505*b[i + 14*ldb] + -0.11391719628199*b[i + 15*ldb]);
        c[i + 68*ldc] = (1.526788125457267*b[i + 16*ldb] + -0.8136324494869274*b[i + 17*ldb] + 0.4007615203116505*b[i + 18*ldb] + -0.11391719628199*b[i + 19*ldb]);
        c[i + 69*ldc] = (1.526788125457267*b[i + 20*ldb] + -0.8136324494869274*b[i + 21*ldb] + 0.4007615203116505*b[i + 22*ldb] + -0.11391719628199*b[i + 23*ldb]);
        c[i + 70*ldc] = (1.526788125457267*b[i + 24*ldb] + -0.8136324494869274*b[i + 25*ldb] + 0.4007615203116505*b[i + 26*ldb] + -0.11391719628199*b[i + 27*ldb]);
        c[i + 71*ldc] = (1.526788125457267*b[i + 28*ldb] + -0.8136324494869274*b[i + 29*ldb] + 0.4007615203116505*b[i + 30*ldb] + -0.11391719628199*b[i + 31*ldb]);
        c[i + 72*ldc] = (1.526788125457267*b[i + 32*ldb] + -0.8136324494869274*b[i + 33*ldb] + 0.4007615203116505*b[i + 34*ldb] + -0.11391719628199*b[i + 35*ldb]);
        c[i + 73*ldc] = (1.526788125457267*b[i + 36*ldb] + -0.8136324494869274*b[i + 37*ldb] + 0.4007615203116505*b[i + 38*ldb] + -0.11391719628199*b[i + 39*ldb]);
        c[i + 74*ldc] = (1.526788125457267*b[i + 40*ldb] + -0.8136324494869274*b[i + 41*ldb] + 0.4007615203116505*b[i + 42*ldb] + -0.11391719628199*b[i + 43*ldb]);
        c[i + 75*ldc] = (1.526788125457267*b[i + 44*ldb] + -0.8136324494869274*b[i + 45*ldb] + 0.4007615203116505*b[i + 46*ldb] + -0.11391719628199*b[i + 47*ldb]);
        c[i + 76*ldc] = (1.526788125457267*b[i + 48*ldb] + -0.8136324494869274*b[i + 49*ldb] + 0.4007615203116505*b[i + 50*ldb] + -0.11391719628199*b[i + 51*ldb]);
        c[i + 77*ldc] = (1.526788125457267*b[i + 52*ldb] + -0.8136324494869274*b[i + 53*ldb] + 0.4007615203116505*b[i + 54*ldb] + -0.11391719628199*b[i + 55*ldb]);
        c[i + 78*ldc] = (1.526788125457267*b[i + 56*ldb] + -0.8136324494869274*b[i + 57*ldb] + 0.4007615203116505*b[i + 58*ldb] + -0.11391719628199*b[i + 59*ldb]);
        c[i + 79*ldc] = (1.526788125457267*b[i + 60*ldb] + -0.8136324494869274*b[i + 61*ldb] + 0.4007615203116505*b[i + 62*ldb] + -0.11391719628199*b[i + 63*ldb]);
        c[i + 80*ldc] = (-0.11391719628199*b[i + 0*ldb] + 0.4007615203116505*b[i + 16*ldb] + -0.8136324494869274*b[i + 32*ldb] + 1.526788125457267*b[i + 48*ldb]);
        c[i + 81*ldc] = (-0.11391719628199*b[i + 1*ldb] + 0.4007615203116505*b[i + 17*ldb] + -0.8136324494869274*b[i + 33*ldb] + 1.526788125457267*b[i + 49*ldb]);
        c[i + 82*ldc] = (-0.11391719628199*b[i + 2*ldb] + 0.4007615203116505*b[i + 18*ldb] + -0.8136324494869274*b[i + 34*ldb] + 1.526788125457267*b[i + 50*ldb]);
        c[i + 83*ldc] = (-0.11391719628199*b[i + 3*ldb] + 0.4007615203116505*b[i + 19*ldb] + -0.8136324494869274*b[i + 35*ldb] + 1.526788125457267*b[i + 51*ldb]);
        c[i + 84*ldc] = (-0.11391719628199*b[i + 4*ldb] + 0.4007615203116505*b[i + 20*ldb] + -0.8136324494869274*b[i + 36*ldb] + 1.526788125457267*b[i + 52*ldb]);
        c[i + 85*ldc] = (-0.11391719628199*b[i + 5*ldb] + 0.4007615203116505*b[i + 21*ldb] + -0.8136324494869274*b[i + 37*ldb] + 1.526788125457267*b[i + 53*ldb]);
        c[i + 86*ldc] = (-0.11391719628199*b[i + 6*ldb] + 0.4007615203116505*b[i + 22*ldb] + -0.8136324494869274*b[i + 38*ldb] + 1.526788125457267*b[i + 54*ldb]);
        c[i + 87*ldc] = (-0.11391719628199*b[i + 7*ldb] + 0.4007615203116505*b[i + 23*ldb] + -0.8136324494869274*b[i + 39*ldb] + 1.526788125457267*b[i + 55*ldb]);
        c[i + 88*ldc] = (-0.11391719628199*b[i + 8*ldb] + 0.4007615203116505*b[i + 24*ldb] + -0.8136324494869274*b[i + 40*ldb] + 1.526788125457267*b[i + 56*ldb]);
        c[i + 89*ldc] = (-0.11391719628199*b[i + 9*ldb] + 0.4007615203116505*b[i + 25*ldb] + -0.8136324494869274*b[i + 41*ldb] + 1.526788125457267*b[i + 57*ldb]);
        c[i + 90*ldc] = (-0.11391719628199*b[i + 10*ldb] + 0.4007615203116505*b[i + 26*ldb] + -0.8136324494869274*b[i + 42*ldb] + 1.526788125457267*b[i + 58*ldb]);
        c[i + 91*ldc] = (-0.11391719628199*b[i + 11*ldb] + 0.4007615203116505*b[i + 27*ldb] + -0.8136324494869274*b[i + 43*ldb] + 1.526788125457267*b[i + 59*ldb]);
        c[i + 92*ldc] = (-0.11391719628199*b[i + 12*ldb] + 0.4007615203116505*b[i + 28*ldb] + -0.8136324494869274*b[i + 44*ldb] + 1.526788125457267*b[i + 60*ldb]);
        c[i + 93*ldc] = (-0.11391719628199*b[i + 13*ldb] + 0.4007615203116505*b[i + 29*ldb] + -0.8136324494869274*b[i + 45*ldb] + 1.526788125457267*b[i + 61*ldb]);
        c[i + 94*ldc] = (-0.11391719628199*b[i + 14*ldb] + 0.4007615203116505*b[i + 30*ldb] + -0.8136324494869274*b[i + 46*ldb] + 1.526788125457267*b[i + 62*ldb]);
        c[i + 95*ldc] = (-0.11391719628199*b[i + 15*ldb] + 0.4007615203116505*b[i + 31*ldb] + -0.8136324494869274*b[i + 47*ldb] + 1.526788125457267*b[i + 63*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_hex_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (4.389152966531085*b[i + 0*ldb] + 4.389152966531085*b[i + 16*ldb] + -0.3274848629375152*b[i + 32*ldb] + -0.3274848629375152*b[i + 48*ldb] + 4.389152966531085*b[i + 64*ldb] + -0.3274848629375152*b[i + 80*ldb]);
        c[i + 1*ldc] += (4.389152966531085*b[i + 1*ldb] + 4.389152966531085*b[i + 17*ldb] + 0.6145280959667937*b[i + 32*ldb] + -0.3274848629375152*b[i + 49*ldb] + -1.247624770988934*b[i + 64*ldb] + -0.3274848629375152*b[i + 81*ldb]);
        c[i + 2*ldc] += (4.389152966531085*b[i + 2*ldb] + 4.389152966531085*b[i + 18*ldb] + -1.247624770988934*b[i + 32*ldb] + -0.3274848629375152*b[i + 50*ldb] + 0.6145280959667937*b[i + 64*ldb] + -0.3274848629375152*b[i + 82*ldb]);
        c[i + 3*ldc] += (4.389152966531085*b[i + 3*ldb] + 4.389152966531085*b[i + 19*ldb] + 4.389152966531085*b[i + 32*ldb] + -0.3274848629375152*b[i + 51*ldb] + -0.3274848629375152*b[i + 64*ldb] + -0.3274848629375152*b[i + 83*ldb]);
        c[i + 4*ldc] += (4.389152966531085*b[i + 4*ldb] + -1.247624770988934*b[i + 16*ldb] + -0.3274848629375152*b[i + 33*ldb] + 0.6145280959667937*b[i + 48*ldb] + 4.389152966531085*b[i + 65*ldb] + -0.3274848629375152*b[i + 84*ldb]);
        c[i + 5*ldc] += (4.389152966531085*b[i + 5*ldb] + -1.247624770988934*b[i + 17*ldb] + 0.6145280959667937*b[i + 33*ldb] + 0.6145280959667937*b[i + 49*ldb] + -1.247624770988934*b[i + 65*ldb] + -0.3274848629375152*b[i + 85*ldb]);
        c[i + 6*ldc] += (4.389152966531085*b[i + 6*ldb] + -1.247624770988934*b[i + 18*ldb] + -1.247624770988934*b[i + 33*ldb] + 0.6145280959667937*b[i + 50*ldb] + 0.6145280959667937*b[i + 65*ldb] + -0.3274848629375152*b[i + 86*ldb]);
        c[i + 7*ldc] += (4.389152966531085*b[i + 7*ldb] + -1.247624770988934*b[i + 19*ldb] + 4.389152966531085*b[i + 33*ldb] + 0.6145280959667937*b[i + 51*ldb] + -0.3274848629375152*b[i + 65*ldb] + -0.3274848629375152*b[i + 87*ldb]);
        c[i + 8*ldc] += (4.389152966531085*b[i + 8*ldb] + 0.6145280959667937*b[i + 16*ldb] + -0.3274848629375152*b[i + 34*ldb] + -1.247624770988934*b[i + 48*ldb] + 4.389152966531085*b[i + 66*ldb] + -0.3274848629375152*b[i + 88*ldb]);
        c[i + 9*ldc] += (4.389152966531085*b[i + 9*ldb] + 0.6145280959667937*b[i + 17*ldb] + 0.6145280959667937*b[i + 34*ldb] + -1.247624770988934*b[i + 49*ldb] + -1.247624770988934*b[i + 66*ldb] + -0.3274848629375152*b[i + 89*ldb]);
        c[i + 10*ldc] += (4.389152966531085*b[i + 10*ldb] + 0.6145280959667937*b[i + 18*ldb] + -1.247624770988934*b[i + 34*ldb] + -1.247624770988934*b[i + 50*ldb] + 0.6145280959667937*b[i + 66*ldb] + -0.3274848629375152*b[i + 90*ldb]);
        c[i + 11*ldc] += (4.389152966531085*b[i + 11*ldb] + 0.6145280959667937*b[i + 19*ldb] + 4.389152966531085*b[i + 34*ldb] + -1.247624770988934*b[i + 51*ldb] + -0.3274848629375152*b[i + 66*ldb] + -0.3274848629375152*b[i + 91*ldb]);
        c[i + 12*ldc] += (4.389152966531085*b[i + 12*ldb] + -0.3274848629375152*b[i + 16*ldb] + -0.3274848629375152*b[i + 35*ldb] + 4.389152966531085*b[i + 48*ldb] + 4.389152966531085*b[i + 67*ldb] + -0.3274848629375152*b[i + 92*ldb]);
        c[i + 13*ldc] += (4.389152966531085*b[i + 13*ldb] + -0.3274848629375152*b[i + 17*ldb] + 0.6145280959667937*b[i + 35*ldb] + 4.389152966531085*b[i + 49*ldb] + -1.247624770988934*b[i + 67*ldb] + -0.3274848629375152*b[i + 93*ldb]);
        c[i + 14*ldc] += (4.389152966531085*b[i + 14*ldb] + -0.3274848629375152*b[i + 18*ldb] + -1.247624770988934*b[i + 35*ldb] + 4.389152966531085*b[i + 50*ldb] + 0.6145280959667937*b[i + 67*ldb] + -0.3274848629375152*b[i + 94*ldb]);
        c[i + 15*ldc] += (4.389152966531085*b[i + 15*ldb] + -0.3274848629375152*b[i + 19*ldb] + 4.389152966531085*b[i + 35*ldb] + 4.389152966531085*b[i + 51*ldb] + -0.3274848629375152*b[i + 67*ldb] + -0.3274848629375152*b[i + 95*ldb]);
        c[i + 16*ldc] += (-1.247624770988934*b[i + 0*ldb] + 4.389152966531085*b[i + 20*ldb] + -0.3274848629375152*b[i + 36*ldb] + -0.3274848629375152*b[i + 52*ldb] + 4.389152966531085*b[i + 68*ldb] + 0.6145280959667937*b[i + 80*ldb]);
        c[i + 17*ldc] += (-1.247624770988934*b[i + 1*ldb] + 4.389152966531085*b[i + 21*ldb] + 0.6145280959667937*b[i + 36*ldb] + -0.3274848629375152*b[i + 53*ldb] + -1.247624770988934*b[i + 68*ldb] + 0.6145280959667937*b[i + 81*ldb]);
        c[i + 18*ldc] += (-1.247624770988934*b[i + 2*ldb] + 4.389152966531085*b[i + 22*ldb] + -1.247624770988934*b[i + 36*ldb] + -0.3274848629375152*b[i + 54*ldb] + 0.6145280959667937*b[i + 68*ldb] + 0.6145280959667937*b[i + 82*ldb]);
        c[i + 19*ldc] += (-1.247624770988934*b[i + 3*ldb] + 4.389152966531085*b[i + 23*ldb] + 4.389152966531085*b[i + 36*ldb] + -0.3274848629375152*b[i + 55*ldb] + -0.3274848629375152*b[i + 68*ldb] + 0.6145280959667937*b[i + 83*ldb]);
        c[i + 20*ldc] += (-1.247624770988934*b[i + 4*ldb] + -1.247624770988934*b[i + 20*ldb] + -0.3274848629375152*b[i + 37*ldb] + 0.6145280959667937*b[i + 52*ldb] + 4.389152966531085*b[i + 69*ldb] + 0.6145280959667937*b[i + 84*ldb]);
        c[i + 21*ldc] += (-1.247624770988934*b[i + 5*ldb] + -1.247624770988934*b[i + 21*ldb] + 0.6145280959667937*b[i + 37*ldb] + 0.6145280959667937*b[i + 53*ldb] + -1.247624770988934*b[i + 69*ldb] + 0.6145280959667937*b[i + 85*ldb]);
        c[i + 22*ldc] += (-1.247624770988934*b[i + 6*ldb] + -1.247624770988934*b[i + 22*ldb] + -1.247624770988934*b[i + 37*ldb] + 0.6145280959667937*b[i + 54*ldb] + 0.6145280959667937*b[i + 69*ldb] + 0.6145280959667937*b[i + 86*ldb]);
        c[i + 23*ldc] += (-1.247624770988934*b[i + 7*ldb] + -1.247624770988934*b[i + 23*ldb] + 4.389152966531085*b[i + 37*ldb] + 0.6145280959667937*b[i + 55*ldb] + -0.3274848629375152*b[i + 69*ldb] + 0.6145280959667937*b[i + 87*ldb]);
        c[i + 24*ldc] += (-1.247624770988934*b[i + 8*ldb] + 0.6145280959667937*b[i + 20*ldb] + -0.3274848629375152*b[i + 38*ldb] + -1.247624770988934*b[i + 52*ldb] + 4.389152966531085*b[i + 70*ldb] + 0.6145280959667937*b[i + 88*ldb]);
        c[i + 25*ldc] += (-1.247624770988934*b[i + 9*ldb] + 0.6145280959667937*b[i + 21*ldb] + 0.6145280959667937*b[i + 38*ldb] + -1.247624770988934*b[i + 53*ldb] + -1.247624770988934*b[i + 70*ldb] + 0.6145280959667937*b[i + 89*ldb]);
        c[i + 26*ldc] += (-1.247624770988934*b[i + 10*ldb] + 0.6145280959667937*b[i + 22*ldb] + -1.247624770988934*b[i + 38*ldb] + -1.247624770988934*b[i + 54*ldb] + 0.6145280959667937*b[i + 70*ldb] + 0.6145280959667937*b[i + 90*ldb]);
        c[i + 27*ldc] += (-1.247624770988934*b[i + 11*ldb] + 0.6145280959667937*b[i + 23*ldb] + 4.389152966531085*b[i + 38*ldb] + -1.247624770988934*b[i + 55*ldb] + -0.3274848629375152*b[i + 70*ldb] + 0.6145280959667937*b[i + 91*ldb]);
        c[i + 28*ldc] += (-1.247624770988934*b[i + 12*ldb] + -0.3274848629375152*b[i + 20*ldb] + -0.3274848629375152*b[i + 39*ldb] + 4.389152966531085*b[i + 52*ldb] + 4.389152966531085*b[i + 71*ldb] + 0.6145280959667937*b[i + 92*ldb]);
        c[i + 29*ldc] += (-1.247624770988934*b[i + 13*ldb] + -0.3274848629375152*b[i + 21*ldb] + 0.6145280959667937*b[i + 39*ldb] + 4.389152966531085*b[i + 53*ldb] + -1.247624770988934*b[i + 71*ldb] + 0.6145280959667937*b[i + 93*ldb]);
        c[i + 30*ldc] += (-1.247624770988934*b[i + 14*ldb] + -0.3274848629375152*b[i + 22*ldb] + -1.247624770988934*b[i + 39*ldb] + 4.389152966531085*b[i + 54*ldb] + 0.6145280959667937*b[i + 71*ldb] + 0.6145280959667937*b[i + 94*ldb]);
        c[i + 31*ldc] += (-1.247624770988934*b[i + 15*ldb] + -0.3274848629375152*b[i + 23*ldb] + 4.389152966531085*b[i + 39*ldb] + 4.389152966531085*b[i + 55*ldb] + -0.3274848629375152*b[i + 71*ldb] + 0.6145280959667937*b[i + 95*ldb]);
        c[i + 32*ldc] += (0.6145280959667937*b[i + 0*ldb] + 4.389152966531085*b[i + 24*ldb] + -0.3274848629375152*b[i + 40*ldb] + -0.3274848629375152*b[i + 56*ldb] + 4.389152966531085*b[i + 72*ldb] + -1.247624770988934*b[i + 80*ldb]);
        c[i + 33*ldc] += (0.6145280959667937*b[i + 1*ldb] + 4.389152966531085*b[i + 25*ldb] + 0.6145280959667937*b[i + 40*ldb] + -0.3274848629375152*b[i + 57*ldb] + -1.247624770988934*b[i + 72*ldb] + -1.247624770988934*b[i + 81*ldb]);
        c[i + 34*ldc] += (0.6145280959667937*b[i + 2*ldb] + 4.389152966531085*b[i + 26*ldb] + -1.247624770988934*b[i + 40*ldb] + -0.3274848629375152*b[i + 58*ldb] + 0.6145280959667937*b[i + 72*ldb] + -1.247624770988934*b[i + 82*ldb]);
        c[i + 35*ldc] += (0.6145280959667937*b[i + 3*ldb] + 4.389152966531085*b[i + 27*ldb] + 4.389152966531085*b[i + 40*ldb] + -0.3274848629375152*b[i + 59*ldb] + -0.3274848629375152*b[i + 72*ldb] + -1.247624770988934*b[i + 83*ldb]);
        c[i + 36*ldc] += (0.6145280959667937*b[i + 4*ldb] + -1.247624770988934*b[i + 24*ldb] + -0.3274848629375152*b[i + 41*ldb] + 0.6145280959667937*b[i + 56*ldb] + 4.389152966531085*b[i + 73*ldb] + -1.247624770988934*b[i + 84*ldb]);
        c[i + 37*ldc] += (0.6145280959667937*b[i + 5*ldb] + -1.247624770988934*b[i + 25*ldb] + 0.6145280959667937*b[i + 41*ldb] + 0.6145280959667937*b[i + 57*ldb] + -1.247624770988934*b[i + 73*ldb] + -1.247624770988934*b[i + 85*ldb]);
        c[i + 38*ldc] += (0.6145280959667937*b[i + 6*ldb] + -1.247624770988934*b[i + 26*ldb] + -1.247624770988934*b[i + 41*ldb] + 0.6145280959667937*b[i + 58*ldb] + 0.6145280959667937*b[i + 73*ldb] + -1.247624770988934*b[i + 86*ldb]);
        c[i + 39*ldc] += (0.6145280959667937*b[i + 7*ldb] + -1.247624770988934*b[i + 27*ldb] + 4.389152966531085*b[i + 41*ldb] + 0.6145280959667937*b[i + 59*ldb] + -0.3274848629375152*b[i + 73*ldb] + -1.247624770988934*b[i + 87*ldb]);
        c[i + 40*ldc] += (0.6145280959667937*b[i + 8*ldb] + 0.6145280959667937*b[i + 24*ldb] + -0.3274848629375152*b[i + 42*ldb] + -1.247624770988934*b[i + 56*ldb] + 4.389152966531085*b[i + 74*ldb] + -1.247624770988934*b[i + 88*ldb]);
        c[i + 41*ldc] += (0.6145280959667937*b[i + 9*ldb] + 0.6145280959667937*b[i + 25*ldb] + 0.6145280959667937*b[i + 42*ldb] + -1.247624770988934*b[i + 57*ldb] + -1.247624770988934*b[i + 74*ldb] + -1.247624770988934*b[i + 89*ldb]);
        c[i + 42*ldc] += (0.6145280959667937*b[i + 10*ldb] + 0.6145280959667937*b[i + 26*ldb] + -1.247624770988934*b[i + 42*ldb] + -1.247624770988934*b[i + 58*ldb] + 0.6145280959667937*b[i + 74*ldb] + -1.247624770988934*b[i + 90*ldb]);
        c[i + 43*ldc] += (0.6145280959667937*b[i + 11*ldb] + 0.6145280959667937*b[i + 27*ldb] + 4.389152966531085*b[i + 42*ldb] + -1.247624770988934*b[i + 59*ldb] + -0.3274848629375152*b[i + 74*ldb] + -1.247624770988934*b[i + 91*ldb]);
        c[i + 44*ldc] += (0.6145280959667937*b[i + 12*ldb] + -0.3274848629375152*b[i + 24*ldb] + -0.3274848629375152*b[i + 43*ldb] + 4.389152966531085*b[i + 56*ldb] + 4.389152966531085*b[i + 75*ldb] + -1.247624770988934*b[i + 92*ldb]);
        c[i + 45*ldc] += (0.6145280959667937*b[i + 13*ldb] + -0.3274848629375152*b[i + 25*ldb] + 0.6145280959667937*b[i + 43*ldb] + 4.389152966531085*b[i + 57*ldb] + -1.247624770988934*b[i + 75*ldb] + -1.247624770988934*b[i + 93*ldb]);
        c[i + 46*ldc] += (0.6145280959667937*b[i + 14*ldb] + -0.3274848629375152*b[i + 26*ldb] + -1.247624770988934*b[i + 43*ldb] + 4.389152966531085*b[i + 58*ldb] + 0.6145280959667937*b[i + 75*ldb] + -1.247624770988934*b[i + 94*ldb]);
        c[i + 47*ldc] += (0.6145280959667937*b[i + 15*ldb] + -0.3274848629375152*b[i + 27*ldb] + 4.389152966531085*b[i + 43*ldb] + 4.389152966531085*b[i + 59*ldb] + -0.3274848629375152*b[i + 75*ldb] + -1.247624770988934*b[i + 95*ldb]);
        c[i + 48*ldc] += (-0.3274848629375152*b[i + 0*ldb] + 4.389152966531085*b[i + 28*ldb] + -0.3274848629375152*b[i + 44*ldb] + -0.3274848629375152*b[i + 60*ldb] + 4.389152966531085*b[i + 76*ldb] + 4.389152966531085*b[i + 80*ldb]);
        c[i + 49*ldc] += (-0.3274848629375152*b[i + 1*ldb] + 4.389152966531085*b[i + 29*ldb] + 0.6145280959667937*b[i + 44*ldb] + -0.3274848629375152*b[i + 61*ldb] + -1.247624770988934*b[i + 76*ldb] + 4.389152966531085*b[i + 81*ldb]);
        c[i + 50*ldc] += (-0.3274848629375152*b[i + 2*ldb] + 4.389152966531085*b[i + 30*ldb] + -1.247624770988934*b[i + 44*ldb] + -0.3274848629375152*b[i + 62*ldb] + 0.6145280959667937*b[i + 76*ldb] + 4.389152966531085*b[i + 82*ldb]);
        c[i + 51*ldc] += (-0.3274848629375152*b[i + 3*ldb] + 4.389152966531085*b[i + 31*ldb] + 4.389152966531085*b[i + 44*ldb] + -0.3274848629375152*b[i + 63*ldb] + -0.3274848629375152*b[i + 76*ldb] + 4.389152966531085*b[i + 83*ldb]);
        c[i + 52*ldc] += (-0.3274848629375152*b[i + 4*ldb] + -1.247624770988934*b[i + 28*ldb] + -0.3274848629375152*b[i + 45*ldb] + 0.6145280959667937*b[i + 60*ldb] + 4.389152966531085*b[i + 77*ldb] + 4.389152966531085*b[i + 84*ldb]);
        c[i + 53*ldc] += (-0.3274848629375152*b[i + 5*ldb] + -1.247624770988934*b[i + 29*ldb] + 0.6145280959667937*b[i + 45*ldb] + 0.6145280959667937*b[i + 61*ldb] + -1.247624770988934*b[i + 77*ldb] + 4.389152966531085*b[i + 85*ldb]);
        c[i + 54*ldc] += (-0.3274848629375152*b[i + 6*ldb] + -1.247624770988934*b[i + 30*ldb] + -1.247624770988934*b[i + 45*ldb] + 0.6145280959667937*b[i + 62*ldb] + 0.6145280959667937*b[i + 77*ldb] + 4.389152966531085*b[i + 86*ldb]);
        c[i + 55*ldc] += (-0.3274848629375152*b[i + 7*ldb] + -1.247624770988934*b[i + 31*ldb] + 4.389152966531085*b[i + 45*ldb] + 0.6145280959667937*b[i + 63*ldb] + -0.3274848629375152*b[i + 77*ldb] + 4.389152966531085*b[i + 87*ldb]);
        c[i + 56*ldc] += (-0.3274848629375152*b[i + 8*ldb] + 0.6145280959667937*b[i + 28*ldb] + -0.3274848629375152*b[i + 46*ldb] + -1.247624770988934*b[i + 60*ldb] + 4.389152966531085*b[i + 78*ldb] + 4.389152966531085*b[i + 88*ldb]);
        c[i + 57*ldc] += (-0.3274848629375152*b[i + 9*ldb] + 0.6145280959667937*b[i + 29*ldb] + 0.6145280959667937*b[i + 46*ldb] + -1.247624770988934*b[i + 61*ldb] + -1.247624770988934*b[i + 78*ldb] + 4.389152966531085*b[i + 89*ldb]);
        c[i + 58*ldc] += (-0.3274848629375152*b[i + 10*ldb] + 0.6145280959667937*b[i + 30*ldb] + -1.247624770988934*b[i + 46*ldb] + -1.247624770988934*b[i + 62*ldb] + 0.6145280959667937*b[i + 78*ldb] + 4.389152966531085*b[i + 90*ldb]);
        c[i + 59*ldc] += (-0.3274848629375152*b[i + 11*ldb] + 0.6145280959667937*b[i + 31*ldb] + 4.389152966531085*b[i + 46*ldb] + -1.247624770988934*b[i + 63*ldb] + -0.3274848629375152*b[i + 78*ldb] + 4.389152966531085*b[i + 91*ldb]);
        c[i + 60*ldc] += (-0.3274848629375152*b[i + 12*ldb] + -0.3274848629375152*b[i + 28*ldb] + -0.3274848629375152*b[i + 47*ldb] + 4.389152966531085*b[i + 60*ldb] + 4.389152966531085*b[i + 79*ldb] + 4.389152966531085*b[i + 92*ldb]);
        c[i + 61*ldc] += (-0.3274848629375152*b[i + 13*ldb] + -0.3274848629375152*b[i + 29*ldb] + 0.6145280959667937*b[i + 47*ldb] + 4.389152966531085*b[i + 61*ldb] + -1.247624770988934*b[i + 79*ldb] + 4.389152966531085*b[i + 93*ldb]);
        c[i + 62*ldc] += (-0.3274848629375152*b[i + 14*ldb] + -0.3274848629375152*b[i + 30*ldb] + -1.247624770988934*b[i + 47*ldb] + 4.389152966531085*b[i + 62*ldb] + 0.6145280959667937*b[i + 79*ldb] + 4.389152966531085*b[i + 94*ldb]);
        c[i + 63*ldc] += (-0.3274848629375152*b[i + 15*ldb] + -0.3274848629375152*b[i + 31*ldb] + 4.389152966531085*b[i + 47*ldb] + 4.389152966531085*b[i + 63*ldb] + -0.3274848629375152*b[i + 79*ldb] + 4.389152966531085*b[i + 95*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_hex_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (-0.3274848629375152*b[i + 32*ldb] + -4.389152966531085*b[i + 64*ldb]);
        c[i + 1*ldc] += (0.6145280959667937*b[i + 32*ldb] + 1.247624770988934*b[i + 64*ldb]);
        c[i + 2*ldc] += (-1.247624770988934*b[i + 32*ldb] + -0.6145280959667937*b[i + 64*ldb]);
        c[i + 3*ldc] += (4.389152966531085*b[i + 32*ldb] + 0.3274848629375152*b[i + 64*ldb]);
        c[i + 4*ldc] += (-0.3274848629375152*b[i + 33*ldb] + -4.389152966531085*b[i + 65*ldb]);
        c[i + 5*ldc] += (0.6145280959667937*b[i + 33*ldb] + 1.247624770988934*b[i + 65*ldb]);
        c[i + 6*ldc] += (-1.247624770988934*b[i + 33*ldb] + -0.6145280959667937*b[i + 65*ldb]);
        c[i + 7*ldc] += (4.389152966531085*b[i + 33*ldb] + 0.3274848629375152*b[i + 65*ldb]);
        c[i + 8*ldc] += (-0.3274848629375152*b[i + 34*ldb] + -4.389152966531085*b[i + 66*ldb]);
        c[i + 9*ldc] += (0.6145280959667937*b[i + 34*ldb] + 1.247624770988934*b[i + 66*ldb]);
        c[i + 10*ldc] += (-1.247624770988934*b[i + 34*ldb] + -0.6145280959667937*b[i + 66*ldb]);
        c[i + 11*ldc] += (4.389152966531085*b[i + 34*ldb] + 0.3274848629375152*b[i + 66*ldb]);
        c[i + 12*ldc] += (-0.3274848629375152*b[i + 35*ldb] + -4.389152966531085*b[i + 67*ldb]);
        c[i + 13*ldc] += (0.6145280959667937*b[i + 35*ldb] + 1.247624770988934*b[i + 67*ldb]);
        c[i + 14*ldc] += (-1.247624770988934*b[i + 35*ldb] + -0.6145280959667937*b[i + 67*ldb]);
        c[i + 15*ldc] += (4.389152966531085*b[i + 35*ldb] + 0.3274848629375152*b[i + 67*ldb]);
        c[i + 16*ldc] += (-0.3274848629375152*b[i + 36*ldb] + -4.389152966531085*b[i + 68*ldb]);
        c[i + 17*ldc] += (0.6145280959667937*b[i + 36*ldb] + 1.247624770988934*b[i + 68*ldb]);
        c[i + 18*ldc] += (-1.247624770988934*b[i + 36*ldb] + -0.6145280959667937*b[i + 68*ldb]);
        c[i + 19*ldc] += (4.389152966531085*b[i + 36*ldb] + 0.3274848629375152*b[i + 68*ldb]);
        c[i + 20*ldc] += (-0.3274848629375152*b[i + 37*ldb] + -4.389152966531085*b[i + 69*ldb]);
        c[i + 21*ldc] += (0.6145280959667937*b[i + 37*ldb] + 1.247624770988934*b[i + 69*ldb]);
        c[i + 22*ldc] += (-1.247624770988934*b[i + 37*ldb] + -0.6145280959667937*b[i + 69*ldb]);
        c[i + 23*ldc] += (4.389152966531085*b[i + 37*ldb] + 0.3274848629375152*b[i + 69*ldb]);
        c[i + 24*ldc] += (-0.3274848629375152*b[i + 38*ldb] + -4.389152966531085*b[i + 70*ldb]);
        c[i + 25*ldc] += (0.6145280959667937*b[i + 38*ldb] + 1.247624770988934*b[i + 70*ldb]);
        c[i + 26*ldc] += (-1.247624770988934*b[i + 38*ldb] + -0.6145280959667937*b[i + 70*ldb]);
        c[i + 27*ldc] += (4.389152966531085*b[i + 38*ldb] + 0.3274848629375152*b[i + 70*ldb]);
        c[i + 28*ldc] += (-0.3274848629375152*b[i + 39*ldb] + -4.389152966531085*b[i + 71*ldb]);
        c[i + 29*ldc] += (0.6145280959667937*b[i + 39*ldb] + 1.247624770988934*b[i + 71*ldb]);
        c[i + 30*ldc] += (-1.247624770988934*b[i + 39*ldb] + -0.6145280959667937*b[i + 71*ldb]);
        c[i + 31*ldc] += (4.389152966531085*b[i + 39*ldb] + 0.3274848629375152*b[i + 71*ldb]);
        c[i + 32*ldc] += (-0.3274848629375152*b[i + 40*ldb] + -4.389152966531085*b[i + 72*ldb]);
        c[i + 33*ldc] += (0.6145280959667937*b[i + 40*ldb] + 1.247624770988934*b[i + 72*ldb]);
        c[i + 34*ldc] += (-1.247624770988934*b[i + 40*ldb] + -0.6145280959667937*b[i + 72*ldb]);
        c[i + 35*ldc] += (4.389152966531085*b[i + 40*ldb] + 0.3274848629375152*b[i + 72*ldb]);
        c[i + 36*ldc] += (-0.3274848629375152*b[i + 41*ldb] + -4.389152966531085*b[i + 73*ldb]);
        c[i + 37*ldc] += (0.6145280959667937*b[i + 41*ldb] + 1.247624770988934*b[i + 73*ldb]);
        c[i + 38*ldc] += (-1.247624770988934*b[i + 41*ldb] + -0.6145280959667937*b[i + 73*ldb]);
        c[i + 39*ldc] += (4.389152966531085*b[i + 41*ldb] + 0.3274848629375152*b[i + 73*ldb]);
        c[i + 40*ldc] += (-0.3274848629375152*b[i + 42*ldb] + -4.389152966531085*b[i + 74*ldb]);
        c[i + 41*ldc] += (0.6145280959667937*b[i + 42*ldb] + 1.247624770988934*b[i + 74*ldb]);
        c[i + 42*ldc] += (-1.247624770988934*b[i + 42*ldb] + -0.6145280959667937*b[i + 74*ldb]);
        c[i + 43*ldc] += (4.389152966531085*b[i + 42*ldb] + 0.3274848629375152*b[i + 74*ldb]);
        c[i + 44*ldc] += (-0.3274848629375152*b[i + 43*ldb] + -4.389152966531085*b[i + 75*ldb]);
        c[i + 45*ldc] += (0.6145280959667937*b[i + 43*ldb] + 1.247624770988934*b[i + 75*ldb]);
        c[i + 46*ldc] += (-1.247624770988934*b[i + 43*ldb] + -0.6145280959667937*b[i + 75*ldb]);
        c[i + 47*ldc] += (4.389152966531085*b[i + 43*ldb] + 0.3274848629375152*b[i + 75*ldb]);
        c[i + 48*ldc] += (-0.3274848629375152*b[i + 44*ldb] + -4.389152966531085*b[i + 76*ldb]);
        c[i + 49*ldc] += (0.6145280959667937*b[i + 44*ldb] + 1.247624770988934*b[i + 76*ldb]);
        c[i + 50*ldc] += (-1.247624770988934*b[i + 44*ldb] + -0.6145280959667937*b[i + 76*ldb]);
        c[i + 51*ldc] += (4.389152966531085*b[i + 44*ldb] + 0.3274848629375152*b[i + 76*ldb]);
        c[i + 52*ldc] += (-0.3274848629375152*b[i + 45*ldb] + -4.389152966531085*b[i + 77*ldb]);
        c[i + 53*ldc] += (0.6145280959667937*b[i + 45*ldb] + 1.247624770988934*b[i + 77*ldb]);
        c[i + 54*ldc] += (-1.247624770988934*b[i + 45*ldb] + -0.6145280959667937*b[i + 77*ldb]);
        c[i + 55*ldc] += (4.389152966531085*b[i + 45*ldb] + 0.3274848629375152*b[i + 77*ldb]);
        c[i + 56*ldc] += (-0.3274848629375152*b[i + 46*ldb] + -4.389152966531085*b[i + 78*ldb]);
        c[i + 57*ldc] += (0.6145280959667937*b[i + 46*ldb] + 1.247624770988934*b[i + 78*ldb]);
        c[i + 58*ldc] += (-1.247624770988934*b[i + 46*ldb] + -0.6145280959667937*b[i + 78*ldb]);
        c[i + 59*ldc] += (4.389152966531085*b[i + 46*ldb] + 0.3274848629375152*b[i + 78*ldb]);
        c[i + 60*ldc] += (-0.3274848629375152*b[i + 47*ldb] + -4.389152966531085*b[i + 79*ldb]);
        c[i + 61*ldc] += (0.6145280959667937*b[i + 47*ldb] + 1.247624770988934*b[i + 79*ldb]);
        c[i + 62*ldc] += (-1.247624770988934*b[i + 47*ldb] + -0.6145280959667937*b[i + 79*ldb]);
        c[i + 63*ldc] += (4.389152966531085*b[i + 47*ldb] + 0.3274848629375152*b[i + 79*ldb]);
        c[i + 64*ldc] += (-4.389152966531085*b[i + 16*ldb] + -0.3274848629375152*b[i + 48*ldb]);
        c[i + 65*ldc] += (-4.389152966531085*b[i + 17*ldb] + -0.3274848629375152*b[i + 49*ldb]);
        c[i + 66*ldc] += (-4.389152966531085*b[i + 18*ldb] + -0.3274848629375152*b[i + 50*ldb]);
        c[i + 67*ldc] += (-4.389152966531085*b[i + 19*ldb] + -0.3274848629375152*b[i + 51*ldb]);
        c[i + 68*ldc] += (1.247624770988934*b[i + 16*ldb] + 0.6145280959667937*b[i + 48*ldb]);
        c[i + 69*ldc] += (1.247624770988934*b[i + 17*ldb] + 0.6145280959667937*b[i + 49*ldb]);
        c[i + 70*ldc] += (1.247624770988934*b[i + 18*ldb] + 0.6145280959667937*b[i + 50*ldb]);
        c[i + 71*ldc] += (1.247624770988934*b[i + 19*ldb] + 0.6145280959667937*b[i + 51*ldb]);
        c[i + 72*ldc] += (-0.6145280959667937*b[i + 16*ldb] + -1.247624770988934*b[i + 48*ldb]);
        c[i + 73*ldc] += (-0.6145280959667937*b[i + 17*ldb] + -1.247624770988934*b[i + 49*ldb]);
        c[i + 74*ldc] += (-0.6145280959667937*b[i + 18*ldb] + -1.247624770988934*b[i + 50*ldb]);
        c[i + 75*ldc] += (-0.6145280959667937*b[i + 19*ldb] + -1.247624770988934*b[i + 51*ldb]);
        c[i + 76*ldc] += (0.3274848629375152*b[i + 16*ldb] + 4.389152966531085*b[i + 48*ldb]);
        c[i + 77*ldc] += (0.3274848629375152*b[i + 17*ldb] + 4.389152966531085*b[i + 49*ldb]);
        c[i + 78*ldc] += (0.3274848629375152*b[i + 18*ldb] + 4.389152966531085*b[i + 50*ldb]);
        c[i + 79*ldc] += (0.3274848629375152*b[i + 19*ldb] + 4.389152966531085*b[i + 51*ldb]);
        c[i + 80*ldc] += (-4.389152966531085*b[i + 20*ldb] + -0.3274848629375152*b[i + 52*ldb]);
        c[i + 81*ldc] += (-4.389152966531085*b[i + 21*ldb] + -0.3274848629375152*b[i + 53*ldb]);
        c[i + 82*ldc] += (-4.389152966531085*b[i + 22*ldb] + -0.3274848629375152*b[i + 54*ldb]);
        c[i + 83*ldc] += (-4.389152966531085*b[i + 23*ldb] + -0.3274848629375152*b[i + 55*ldb]);
        c[i + 84*ldc] += (1.247624770988934*b[i + 20*ldb] + 0.6145280959667937*b[i + 52*ldb]);
        c[i + 85*ldc] += (1.247624770988934*b[i + 21*ldb] + 0.6145280959667937*b[i + 53*ldb]);
        c[i + 86*ldc] += (1.247624770988934*b[i + 22*ldb] + 0.6145280959667937*b[i + 54*ldb]);
        c[i + 87*ldc] += (1.247624770988934*b[i + 23*ldb] + 0.6145280959667937*b[i + 55*ldb]);
        c[i + 88*ldc] += (-0.6145280959667937*b[i + 20*ldb] + -1.247624770988934*b[i + 52*ldb]);
        c[i + 89*ldc] += (-0.6145280959667937*b[i + 21*ldb] + -1.247624770988934*b[i + 53*ldb]);
        c[i + 90*ldc] += (-0.6145280959667937*b[i + 22*ldb] + -1.247624770988934*b[i + 54*ldb]);
        c[i + 91*ldc] += (-0.6145280959667937*b[i + 23*ldb] + -1.247624770988934*b[i + 55*ldb]);
        c[i + 92*ldc] += (0.3274848629375152*b[i + 20*ldb] + 4.389152966531085*b[i + 52*ldb]);
        c[i + 93*ldc] += (0.3274848629375152*b[i + 21*ldb] + 4.389152966531085*b[i + 53*ldb]);
        c[i + 94*ldc] += (0.3274848629375152*b[i + 22*ldb] + 4.389152966531085*b[i + 54*ldb]);
        c[i + 95*ldc] += (0.3274848629375152*b[i + 23*ldb] + 4.389152966531085*b[i + 55*ldb]);
        c[i + 96*ldc] += (-4.389152966531085*b[i + 24*ldb] + -0.3274848629375152*b[i + 56*ldb]);
        c[i + 97*ldc] += (-4.389152966531085*b[i + 25*ldb] + -0.3274848629375152*b[i + 57*ldb]);
        c[i + 98*ldc] += (-4.389152966531085*b[i + 26*ldb] + -0.3274848629375152*b[i + 58*ldb]);
        c[i + 99*ldc] += (-4.389152966531085*b[i + 27*ldb] + -0.3274848629375152*b[i + 59*ldb]);
        c[i + 100*ldc] += (1.247624770988934*b[i + 24*ldb] + 0.6145280959667937*b[i + 56*ldb]);
        c[i + 101*ldc] += (1.247624770988934*b[i + 25*ldb] + 0.6145280959667937*b[i + 57*ldb]);
        c[i + 102*ldc] += (1.247624770988934*b[i + 26*ldb] + 0.6145280959667937*b[i + 58*ldb]);
        c[i + 103*ldc] += (1.247624770988934*b[i + 27*ldb] + 0.6145280959667937*b[i + 59*ldb]);
        c[i + 104*ldc] += (-0.6145280959667937*b[i + 24*ldb] + -1.247624770988934*b[i + 56*ldb]);
        c[i + 105*ldc] += (-0.6145280959667937*b[i + 25*ldb] + -1.247624770988934*b[i + 57*ldb]);
        c[i + 106*ldc] += (-0.6145280959667937*b[i + 26*ldb] + -1.247624770988934*b[i + 58*ldb]);
        c[i + 107*ldc] += (-0.6145280959667937*b[i + 27*ldb] + -1.247624770988934*b[i + 59*ldb]);
        c[i + 108*ldc] += (0.3274848629375152*b[i + 24*ldb] + 4.389152966531085*b[i + 56*ldb]);
        c[i + 109*ldc] += (0.3274848629375152*b[i + 25*ldb] + 4.389152966531085*b[i + 57*ldb]);
        c[i + 110*ldc] += (0.3274848629375152*b[i + 26*ldb] + 4.389152966531085*b[i + 58*ldb]);
        c[i + 111*ldc] += (0.3274848629375152*b[i + 27*ldb] + 4.389152966531085*b[i + 59*ldb]);
        c[i + 112*ldc] += (-4.389152966531085*b[i + 28*ldb] + -0.3274848629375152*b[i + 60*ldb]);
        c[i + 113*ldc] += (-4.389152966531085*b[i + 29*ldb] + -0.3274848629375152*b[i + 61*ldb]);
        c[i + 114*ldc] += (-4.389152966531085*b[i + 30*ldb] + -0.3274848629375152*b[i + 62*ldb]);
        c[i + 115*ldc] += (-4.389152966531085*b[i + 31*ldb] + -0.3274848629375152*b[i + 63*ldb]);
        c[i + 116*ldc] += (1.247624770988934*b[i + 28*ldb] + 0.6145280959667937*b[i + 60*ldb]);
        c[i + 117*ldc] += (1.247624770988934*b[i + 29*ldb] + 0.6145280959667937*b[i + 61*ldb]);
        c[i + 118*ldc] += (1.247624770988934*b[i + 30*ldb] + 0.6145280959667937*b[i + 62*ldb]);
        c[i + 119*ldc] += (1.247624770988934*b[i + 31*ldb] + 0.6145280959667937*b[i + 63*ldb]);
        c[i + 120*ldc] += (-0.6145280959667937*b[i + 28*ldb] + -1.247624770988934*b[i + 60*ldb]);
        c[i + 121*ldc] += (-0.6145280959667937*b[i + 29*ldb] + -1.247624770988934*b[i + 61*ldb]);
        c[i + 122*ldc] += (-0.6145280959667937*b[i + 30*ldb] + -1.247624770988934*b[i + 62*ldb]);
        c[i + 123*ldc] += (-0.6145280959667937*b[i + 31*ldb] + -1.247624770988934*b[i + 63*ldb]);
        c[i + 124*ldc] += (0.3274848629375152*b[i + 28*ldb] + 4.389152966531085*b[i + 60*ldb]);
        c[i + 125*ldc] += (0.3274848629375152*b[i + 29*ldb] + 4.389152966531085*b[i + 61*ldb]);
        c[i + 126*ldc] += (0.3274848629375152*b[i + 30*ldb] + 4.389152966531085*b[i + 62*ldb]);
        c[i + 127*ldc] += (0.3274848629375152*b[i + 31*ldb] + 4.389152966531085*b[i + 63*ldb]);
        c[i + 128*ldc] += (-4.389152966531085*b[i + 0*ldb] + -0.3274848629375152*b[i + 80*ldb]);
        c[i + 129*ldc] += (-4.389152966531085*b[i + 1*ldb] + -0.3274848629375152*b[i + 81*ldb]);
        c[i + 130*ldc] += (-4.389152966531085*b[i + 2*ldb] + -0.3274848629375152*b[i + 82*ldb]);
        c[i + 131*ldc] += (-4.389152966531085*b[i + 3*ldb] + -0.3274848629375152*b[i + 83*ldb]);
        c[i + 132*ldc] += (-4.389152966531085*b[i + 4*ldb] + -0.3274848629375152*b[i + 84*ldb]);
        c[i + 133*ldc] += (-4.389152966531085*b[i + 5*ldb] + -0.3274848629375152*b[i + 85*ldb]);
        c[i + 134*ldc] += (-4.389152966531085*b[i + 6*ldb] + -0.3274848629375152*b[i + 86*ldb]);
        c[i + 135*ldc] += (-4.389152966531085*b[i + 7*ldb] + -0.3274848629375152*b[i + 87*ldb]);
        c[i + 136*ldc] += (-4.389152966531085*b[i + 8*ldb] + -0.3274848629375152*b[i + 88*ldb]);
        c[i + 137*ldc] += (-4.389152966531085*b[i + 9*ldb] + -0.3274848629375152*b[i + 89*ldb]);
        c[i + 138*ldc] += (-4.389152966531085*b[i + 10*ldb] + -0.3274848629375152*b[i + 90*ldb]);
        c[i + 139*ldc] += (-4.389152966531085*b[i + 11*ldb] + -0.3274848629375152*b[i + 91*ldb]);
        c[i + 140*ldc] += (-4.389152966531085*b[i + 12*ldb] + -0.3274848629375152*b[i + 92*ldb]);
        c[i + 141*ldc] += (-4.389152966531085*b[i + 13*ldb] + -0.3274848629375152*b[i + 93*ldb]);
        c[i + 142*ldc] += (-4.389152966531085*b[i + 14*ldb] + -0.3274848629375152*b[i + 94*ldb]);
        c[i + 143*ldc] += (-4.389152966531085*b[i + 15*ldb] + -0.3274848629375152*b[i + 95*ldb]);
        c[i + 144*ldc] += (1.247624770988934*b[i + 0*ldb] + 0.6145280959667937*b[i + 80*ldb]);
        c[i + 145*ldc] += (1.247624770988934*b[i + 1*ldb] + 0.6145280959667937*b[i + 81*ldb]);
        c[i + 146*ldc] += (1.247624770988934*b[i + 2*ldb] + 0.6145280959667937*b[i + 82*ldb]);
        c[i + 147*ldc] += (1.247624770988934*b[i + 3*ldb] + 0.6145280959667937*b[i + 83*ldb]);
        c[i + 148*ldc] += (1.247624770988934*b[i + 4*ldb] + 0.6145280959667937*b[i + 84*ldb]);
        c[i + 149*ldc] += (1.247624770988934*b[i + 5*ldb] + 0.6145280959667937*b[i + 85*ldb]);
        c[i + 150*ldc] += (1.247624770988934*b[i + 6*ldb] + 0.6145280959667937*b[i + 86*ldb]);
        c[i + 151*ldc] += (1.247624770988934*b[i + 7*ldb] + 0.6145280959667937*b[i + 87*ldb]);
        c[i + 152*ldc] += (1.247624770988934*b[i + 8*ldb] + 0.6145280959667937*b[i + 88*ldb]);
        c[i + 153*ldc] += (1.247624770988934*b[i + 9*ldb] + 0.6145280959667937*b[i + 89*ldb]);
        c[i + 154*ldc] += (1.247624770988934*b[i + 10*ldb] + 0.6145280959667937*b[i + 90*ldb]);
        c[i + 155*ldc] += (1.247624770988934*b[i + 11*ldb] + 0.6145280959667937*b[i + 91*ldb]);
        c[i + 156*ldc] += (1.247624770988934*b[i + 12*ldb] + 0.6145280959667937*b[i + 92*ldb]);
        c[i + 157*ldc] += (1.247624770988934*b[i + 13*ldb] + 0.6145280959667937*b[i + 93*ldb]);
        c[i + 158*ldc] += (1.247624770988934*b[i + 14*ldb] + 0.6145280959667937*b[i + 94*ldb]);
        c[i + 159*ldc] += (1.247624770988934*b[i + 15*ldb] + 0.6145280959667937*b[i + 95*ldb]);
        c[i + 160*ldc] += (-0.6145280959667937*b[i + 0*ldb] + -1.247624770988934*b[i + 80*ldb]);
        c[i + 161*ldc] += (-0.6145280959667937*b[i + 1*ldb] + -1.247624770988934*b[i + 81*ldb]);
        c[i + 162*ldc] += (-0.6145280959667937*b[i + 2*ldb] + -1.247624770988934*b[i + 82*ldb]);
        c[i + 163*ldc] += (-0.6145280959667937*b[i + 3*ldb] + -1.247624770988934*b[i + 83*ldb]);
        c[i + 164*ldc] += (-0.6145280959667937*b[i + 4*ldb] + -1.247624770988934*b[i + 84*ldb]);
        c[i + 165*ldc] += (-0.6145280959667937*b[i + 5*ldb] + -1.247624770988934*b[i + 85*ldb]);
        c[i + 166*ldc] += (-0.6145280959667937*b[i + 6*ldb] + -1.247624770988934*b[i + 86*ldb]);
        c[i + 167*ldc] += (-0.6145280959667937*b[i + 7*ldb] + -1.247624770988934*b[i + 87*ldb]);
        c[i + 168*ldc] += (-0.6145280959667937*b[i + 8*ldb] + -1.247624770988934*b[i + 88*ldb]);
        c[i + 169*ldc] += (-0.6145280959667937*b[i + 9*ldb] + -1.247624770988934*b[i + 89*ldb]);
        c[i + 170*ldc] += (-0.6145280959667937*b[i + 10*ldb] + -1.247624770988934*b[i + 90*ldb]);
        c[i + 171*ldc] += (-0.6145280959667937*b[i + 11*ldb] + -1.247624770988934*b[i + 91*ldb]);
        c[i + 172*ldc] += (-0.6145280959667937*b[i + 12*ldb] + -1.247624770988934*b[i + 92*ldb]);
        c[i + 173*ldc] += (-0.6145280959667937*b[i + 13*ldb] + -1.247624770988934*b[i + 93*ldb]);
        c[i + 174*ldc] += (-0.6145280959667937*b[i + 14*ldb] + -1.247624770988934*b[i + 94*ldb]);
        c[i + 175*ldc] += (-0.6145280959667937*b[i + 15*ldb] + -1.247624770988934*b[i + 95*ldb]);
        c[i + 176*ldc] += (0.3274848629375152*b[i + 0*ldb] + 4.389152966531085*b[i + 80*ldb]);
        c[i + 177*ldc] += (0.3274848629375152*b[i + 1*ldb] + 4.389152966531085*b[i + 81*ldb]);
        c[i + 178*ldc] += (0.3274848629375152*b[i + 2*ldb] + 4.389152966531085*b[i + 82*ldb]);
        c[i + 179*ldc] += (0.3274848629375152*b[i + 3*ldb] + 4.389152966531085*b[i + 83*ldb]);
        c[i + 180*ldc] += (0.3274848629375152*b[i + 4*ldb] + 4.389152966531085*b[i + 84*ldb]);
        c[i + 181*ldc] += (0.3274848629375152*b[i + 5*ldb] + 4.389152966531085*b[i + 85*ldb]);
        c[i + 182*ldc] += (0.3274848629375152*b[i + 6*ldb] + 4.389152966531085*b[i + 86*ldb]);
        c[i + 183*ldc] += (0.3274848629375152*b[i + 7*ldb] + 4.389152966531085*b[i + 87*ldb]);
        c[i + 184*ldc] += (0.3274848629375152*b[i + 8*ldb] + 4.389152966531085*b[i + 88*ldb]);
        c[i + 185*ldc] += (0.3274848629375152*b[i + 9*ldb] + 4.389152966531085*b[i + 89*ldb]);
        c[i + 186*ldc] += (0.3274848629375152*b[i + 10*ldb] + 4.389152966531085*b[i + 90*ldb]);
        c[i + 187*ldc] += (0.3274848629375152*b[i + 11*ldb] + 4.389152966531085*b[i + 91*ldb]);
        c[i + 188*ldc] += (0.3274848629375152*b[i + 12*ldb] + 4.389152966531085*b[i + 92*ldb]);
        c[i + 189*ldc] += (0.3274848629375152*b[i + 13*ldb] + 4.389152966531085*b[i + 93*ldb]);
        c[i + 190*ldc] += (0.3274848629375152*b[i + 14*ldb] + 4.389152966531085*b[i + 94*ldb]);
        c[i + 191*ldc] += (0.3274848629375152*b[i + 15*ldb] + 4.389152966531085*b[i + 95*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_hex_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (3.332000236352281*b[i + 0*ldb] + 1.420240467903588*b[i + 1*ldb] + -0.6162310439495322*b[i + 2*ldb] + 0.5806281691622632*b[i + 3*ldb]);
        c[i + 1*ldc] = (-2.592410982442434*b[i + 0*ldb] + 0.3844143922232085*b[i + 1*ldb] + 1.470670231280717*b[i + 2*ldb] + -1.124826508017219*b[i + 3*ldb]);
        c[i + 2*ldc] = (1.124826508017219*b[i + 0*ldb] + -1.470670231280717*b[i + 1*ldb] + -0.3844143922232085*b[i + 2*ldb] + 2.592410982442434*b[i + 3*ldb]);
        c[i + 3*ldc] = (-0.5806281691622632*b[i + 0*ldb] + 0.6162310439495322*b[i + 1*ldb] + -1.420240467903588*b[i + 2*ldb] + -3.332000236352281*b[i + 3*ldb]);
        c[i + 4*ldc] = (3.332000236352281*b[i + 4*ldb] + 1.420240467903588*b[i + 5*ldb] + -0.6162310439495322*b[i + 6*ldb] + 0.5806281691622632*b[i + 7*ldb]);
        c[i + 5*ldc] = (-2.592410982442434*b[i + 4*ldb] + 0.3844143922232085*b[i + 5*ldb] + 1.470670231280717*b[i + 6*ldb] + -1.124826508017219*b[i + 7*ldb]);
        c[i + 6*ldc] = (1.124826508017219*b[i + 4*ldb] + -1.470670231280717*b[i + 5*ldb] + -0.3844143922232085*b[i + 6*ldb] + 2.592410982442434*b[i + 7*ldb]);
        c[i + 7*ldc] = (-0.5806281691622632*b[i + 4*ldb] + 0.6162310439495322*b[i + 5*ldb] + -1.420240467903588*b[i + 6*ldb] + -3.332000236352281*b[i + 7*ldb]);
        c[i + 8*ldc] = (3.332000236352281*b[i + 8*ldb] + 1.420240467903588*b[i + 9*ldb] + -0.6162310439495322*b[i + 10*ldb] + 0.5806281691622632*b[i + 11*ldb]);
        c[i + 9*ldc] = (-2.592410982442434*b[i + 8*ldb] + 0.3844143922232085*b[i + 9*ldb] + 1.470670231280717*b[i + 10*ldb] + -1.124826508017219*b[i + 11*ldb]);
        c[i + 10*ldc] = (1.124826508017219*b[i + 8*ldb] + -1.470670231280717*b[i + 9*ldb] + -0.3844143922232085*b[i + 10*ldb] + 2.592410982442434*b[i + 11*ldb]);
        c[i + 11*ldc] = (-0.5806281691622632*b[i + 8*ldb] + 0.6162310439495322*b[i + 9*ldb] + -1.420240467903588*b[i + 10*ldb] + -3.332000236352281*b[i + 11*ldb]);
        c[i + 12*ldc] = (3.332000236352281*b[i + 12*ldb] + 1.420240467903588*b[i + 13*ldb] + -0.6162310439495322*b[i + 14*ldb] + 0.5806281691622632*b[i + 15*ldb]);
        c[i + 13*ldc] = (-2.592410982442434*b[i + 12*ldb] + 0.3844143922232085*b[i + 13*ldb] + 1.470670231280717*b[i + 14*ldb] + -1.124826508017219*b[i + 15*ldb]);
        c[i + 14*ldc] = (1.124826508017219*b[i + 12*ldb] + -1.470670231280717*b[i + 13*ldb] + -0.3844143922232085*b[i + 14*ldb] + 2.592410982442434*b[i + 15*ldb]);
        c[i + 15*ldc] = (-0.5806281691622632*b[i + 12*ldb] + 0.6162310439495322*b[i + 13*ldb] + -1.420240467903588*b[i + 14*ldb] + -3.332000236352281*b[i + 15*ldb]);
        c[i + 16*ldc] = (3.332000236352281*b[i + 16*ldb] + 1.420240467903588*b[i + 17*ldb] + -0.6162310439495322*b[i + 18*ldb] + 0.5806281691622632*b[i + 19*ldb]);
        c[i + 17*ldc] = (-2.592410982442434*b[i + 16*ldb] + 0.3844143922232085*b[i + 17*ldb] + 1.470670231280717*b[i + 18*ldb] + -1.124826508017219*b[i + 19*ldb]);
        c[i + 18*ldc] = (1.124826508017219*b[i + 16*ldb] + -1.470670231280717*b[i + 17*ldb] + -0.3844143922232085*b[i + 18*ldb] + 2.592410982442434*b[i + 19*ldb]);
        c[i + 19*ldc] = (-0.5806281691622632*b[i + 16*ldb] + 0.6162310439495322*b[i + 17*ldb] + -1.420240467903588*b[i + 18*ldb] + -3.332000236352281*b[i + 19*ldb]);
        c[i + 20*ldc] = (3.332000236352281*b[i + 20*ldb] + 1.420240467903588*b[i + 21*ldb] + -0.6162310439495322*b[i + 22*ldb] + 0.5806281691622632*b[i + 23*ldb]);
        c[i + 21*ldc] = (-2.592410982442434*b[i + 20*ldb] + 0.3844143922232085*b[i + 21*ldb] + 1.470670231280717*b[i + 22*ldb] + -1.124826508017219*b[i + 23*ldb]);
        c[i + 22*ldc] = (1.124826508017219*b[i + 20*ldb] + -1.470670231280717*b[i + 21*ldb] + -0.3844143922232085*b[i + 22*ldb] + 2.592410982442434*b[i + 23*ldb]);
        c[i + 23*ldc] = (-0.5806281691622632*b[i + 20*ldb] + 0.6162310439495322*b[i + 21*ldb] + -1.420240467903588*b[i + 22*ldb] + -3.332000236352281*b[i + 23*ldb]);
        c[i + 24*ldc] = (3.332000236352281*b[i + 24*ldb] + 1.420240467903588*b[i + 25*ldb] + -0.6162310439495322*b[i + 26*ldb] + 0.5806281691622632*b[i + 27*ldb]);
        c[i + 25*ldc] = (-2.592410982442434*b[i + 24*ldb] + 0.3844143922232085*b[i + 25*ldb] + 1.470670231280717*b[i + 26*ldb] + -1.124826508017219*b[i + 27*ldb]);
        c[i + 26*ldc] = (1.124826508017219*b[i + 24*ldb] + -1.470670231280717*b[i + 25*ldb] + -0.3844143922232085*b[i + 26*ldb] + 2.592410982442434*b[i + 27*ldb]);
        c[i + 27*ldc] = (-0.5806281691622632*b[i + 24*ldb] + 0.6162310439495322*b[i + 25*ldb] + -1.420240467903588*b[i + 26*ldb] + -3.332000236352281*b[i + 27*ldb]);
        c[i + 28*ldc] = (3.332000236352281*b[i + 28*ldb] + 1.420240467903588*b[i + 29*ldb] + -0.6162310439495322*b[i + 30*ldb] + 0.5806281691622632*b[i + 31*ldb]);
        c[i + 29*ldc] = (-2.592410982442434*b[i + 28*ldb] + 0.3844143922232085*b[i + 29*ldb] + 1.470670231280717*b[i + 30*ldb] + -1.124826508017219*b[i + 31*ldb]);
        c[i + 30*ldc] = (1.124826508017219*b[i + 28*ldb] + -1.470670231280717*b[i + 29*ldb] + -0.3844143922232085*b[i + 30*ldb] + 2.592410982442434*b[i + 31*ldb]);
        c[i + 31*ldc] = (-0.5806281691622632*b[i + 28*ldb] + 0.6162310439495322*b[i + 29*ldb] + -1.420240467903588*b[i + 30*ldb] + -3.332000236352281*b[i + 31*ldb]);
        c[i + 32*ldc] = (3.332000236352281*b[i + 32*ldb] + 1.420240467903588*b[i + 33*ldb] + -0.6162310439495322*b[i + 34*ldb] + 0.5806281691622632*b[i + 35*ldb]);
        c[i + 33*ldc] = (-2.592410982442434*b[i + 32*ldb] + 0.3844143922232085*b[i + 33*ldb] + 1.470670231280717*b[i + 34*ldb] + -1.124826508017219*b[i + 35*ldb]);
        c[i + 34*ldc] = (1.124826508017219*b[i + 32*ldb] + -1.470670231280717*b[i + 33*ldb] + -0.3844143922232085*b[i + 34*ldb] + 2.592410982442434*b[i + 35*ldb]);
        c[i + 35*ldc] = (-0.5806281691622632*b[i + 32*ldb] + 0.6162310439495322*b[i + 33*ldb] + -1.420240467903588*b[i + 34*ldb] + -3.332000236352281*b[i + 35*ldb]);
        c[i + 36*ldc] = (3.332000236352281*b[i + 36*ldb] + 1.420240467903588*b[i + 37*ldb] + -0.6162310439495322*b[i + 38*ldb] + 0.5806281691622632*b[i + 39*ldb]);
        c[i + 37*ldc] = (-2.592410982442434*b[i + 36*ldb] + 0.3844143922232085*b[i + 37*ldb] + 1.470670231280717*b[i + 38*ldb] + -1.124826508017219*b[i + 39*ldb]);
        c[i + 38*ldc] = (1.124826508017219*b[i + 36*ldb] + -1.470670231280717*b[i + 37*ldb] + -0.3844143922232085*b[i + 38*ldb] + 2.592410982442434*b[i + 39*ldb]);
        c[i + 39*ldc] = (-0.5806281691622632*b[i + 36*ldb] + 0.6162310439495322*b[i + 37*ldb] + -1.420240467903588*b[i + 38*ldb] + -3.332000236352281*b[i + 39*ldb]);
        c[i + 40*ldc] = (3.332000236352281*b[i + 40*ldb] + 1.420240467903588*b[i + 41*ldb] + -0.6162310439495322*b[i + 42*ldb] + 0.5806281691622632*b[i + 43*ldb]);
        c[i + 41*ldc] = (-2.592410982442434*b[i + 40*ldb] + 0.3844143922232085*b[i + 41*ldb] + 1.470670231280717*b[i + 42*ldb] + -1.124826508017219*b[i + 43*ldb]);
        c[i + 42*ldc] = (1.124826508017219*b[i + 40*ldb] + -1.470670231280717*b[i + 41*ldb] + -0.3844143922232085*b[i + 42*ldb] + 2.592410982442434*b[i + 43*ldb]);
        c[i + 43*ldc] = (-0.5806281691622632*b[i + 40*ldb] + 0.6162310439495322*b[i + 41*ldb] + -1.420240467903588*b[i + 42*ldb] + -3.332000236352281*b[i + 43*ldb]);
        c[i + 44*ldc] = (3.332000236352281*b[i + 44*ldb] + 1.420240467903588*b[i + 45*ldb] + -0.6162310439495322*b[i + 46*ldb] + 0.5806281691622632*b[i + 47*ldb]);
        c[i + 45*ldc] = (-2.592410982442434*b[i + 44*ldb] + 0.3844143922232085*b[i + 45*ldb] + 1.470670231280717*b[i + 46*ldb] + -1.124826508017219*b[i + 47*ldb]);
        c[i + 46*ldc] = (1.124826508017219*b[i + 44*ldb] + -1.470670231280717*b[i + 45*ldb] + -0.3844143922232085*b[i + 46*ldb] + 2.592410982442434*b[i + 47*ldb]);
        c[i + 47*ldc] = (-0.5806281691622632*b[i + 44*ldb] + 0.6162310439495322*b[i + 45*ldb] + -1.420240467903588*b[i + 46*ldb] + -3.332000236352281*b[i + 47*ldb]);
        c[i + 48*ldc] = (3.332000236352281*b[i + 48*ldb] + 1.420240467903588*b[i + 49*ldb] + -0.6162310439495322*b[i + 50*ldb] + 0.5806281691622632*b[i + 51*ldb]);
        c[i + 49*ldc] = (-2.592410982442434*b[i + 48*ldb] + 0.3844143922232085*b[i + 49*ldb] + 1.470670231280717*b[i + 50*ldb] + -1.124826508017219*b[i + 51*ldb]);
        c[i + 50*ldc] = (1.124826508017219*b[i + 48*ldb] + -1.470670231280717*b[i + 49*ldb] + -0.3844143922232085*b[i + 50*ldb] + 2.592410982442434*b[i + 51*ldb]);
        c[i + 51*ldc] = (-0.5806281691622632*b[i + 48*ldb] + 0.6162310439495322*b[i + 49*ldb] + -1.420240467903588*b[i + 50*ldb] + -3.332000236352281*b[i + 51*ldb]);
        c[i + 52*ldc] = (3.332000236352281*b[i + 52*ldb] + 1.420240467903588*b[i + 53*ldb] + -0.6162310439495322*b[i + 54*ldb] + 0.5806281691622632*b[i + 55*ldb]);
        c[i + 53*ldc] = (-2.592410982442434*b[i + 52*ldb] + 0.3844143922232085*b[i + 53*ldb] + 1.470670231280717*b[i + 54*ldb] + -1.124826508017219*b[i + 55*ldb]);
        c[i + 54*ldc] = (1.124826508017219*b[i + 52*ldb] + -1.470670231280717*b[i + 53*ldb] + -0.3844143922232085*b[i + 54*ldb] + 2.592410982442434*b[i + 55*ldb]);
        c[i + 55*ldc] = (-0.5806281691622632*b[i + 52*ldb] + 0.6162310439495322*b[i + 53*ldb] + -1.420240467903588*b[i + 54*ldb] + -3.332000236352281*b[i + 55*ldb]);
        c[i + 56*ldc] = (3.332000236352281*b[i + 56*ldb] + 1.420240467903588*b[i + 57*ldb] + -0.6162310439495322*b[i + 58*ldb] + 0.5806281691622632*b[i + 59*ldb]);
        c[i + 57*ldc] = (-2.592410982442434*b[i + 56*ldb] + 0.3844143922232085*b[i + 57*ldb] + 1.470670231280717*b[i + 58*ldb] + -1.124826508017219*b[i + 59*ldb]);
        c[i + 58*ldc] = (1.124826508017219*b[i + 56*ldb] + -1.470670231280717*b[i + 57*ldb] + -0.3844143922232085*b[i + 58*ldb] + 2.592410982442434*b[i + 59*ldb]);
        c[i + 59*ldc] = (-0.5806281691622632*b[i + 56*ldb] + 0.6162310439495322*b[i + 57*ldb] + -1.420240467903588*b[i + 58*ldb] + -3.332000236352281*b[i + 59*ldb]);
        c[i + 60*ldc] = (3.332000236352281*b[i + 60*ldb] + 1.420240467903588*b[i + 61*ldb] + -0.6162310439495322*b[i + 62*ldb] + 0.5806281691622632*b[i + 63*ldb]);
        c[i + 61*ldc] = (-2.592410982442434*b[i + 60*ldb] + 0.3844143922232085*b[i + 61*ldb] + 1.470670231280717*b[i + 62*ldb] + -1.124826508017219*b[i + 63*ldb]);
        c[i + 62*ldc] = (1.124826508017219*b[i + 60*ldb] + -1.470670231280717*b[i + 61*ldb] + -0.3844143922232085*b[i + 62*ldb] + 2.592410982442434*b[i + 63*ldb]);
        c[i + 63*ldc] = (-0.5806281691622632*b[i + 60*ldb] + 0.6162310439495322*b[i + 61*ldb] + -1.420240467903588*b[i + 62*ldb] + -3.332000236352281*b[i + 63*ldb]);
        c[i + 64*ldc] = (3.332000236352281*b[i + 0*ldb] + 1.420240467903588*b[i + 4*ldb] + -0.6162310439495322*b[i + 8*ldb] + 0.5806281691622632*b[i + 12*ldb]);
        c[i + 65*ldc] = (3.332000236352281*b[i + 1*ldb] + 1.420240467903588*b[i + 5*ldb] + -0.6162310439495322*b[i + 9*ldb] + 0.5806281691622632*b[i + 13*ldb]);
        c[i + 66*ldc] = (3.332000236352281*b[i + 2*ldb] + 1.420240467903588*b[i + 6*ldb] + -0.6162310439495322*b[i + 10*ldb] + 0.5806281691622632*b[i + 14*ldb]);
        c[i + 67*ldc] = (3.332000236352281*b[i + 3*ldb] + 1.420240467903588*b[i + 7*ldb] + -0.6162310439495322*b[i + 11*ldb] + 0.5806281691622632*b[i + 15*ldb]);
        c[i + 68*ldc] = (-2.592410982442434*b[i + 0*ldb] + 0.3844143922232085*b[i + 4*ldb] + 1.470670231280717*b[i + 8*ldb] + -1.124826508017219*b[i + 12*ldb]);
        c[i + 69*ldc] = (-2.592410982442434*b[i + 1*ldb] + 0.3844143922232085*b[i + 5*ldb] + 1.470670231280717*b[i + 9*ldb] + -1.124826508017219*b[i + 13*ldb]);
        c[i + 70*ldc] = (-2.592410982442434*b[i + 2*ldb] + 0.3844143922232085*b[i + 6*ldb] + 1.470670231280717*b[i + 10*ldb] + -1.124826508017219*b[i + 14*ldb]);
        c[i + 71*ldc] = (-2.592410982442434*b[i + 3*ldb] + 0.3844143922232085*b[i + 7*ldb] + 1.470670231280717*b[i + 11*ldb] + -1.124826508017219*b[i + 15*ldb]);
        c[i + 72*ldc] = (1.124826508017219*b[i + 0*ldb] + -1.470670231280717*b[i + 4*ldb] + -0.3844143922232085*b[i + 8*ldb] + 2.592410982442434*b[i + 12*ldb]);
        c[i + 73*ldc] = (1.124826508017219*b[i + 1*ldb] + -1.470670231280717*b[i + 5*ldb] + -0.3844143922232085*b[i + 9*ldb] + 2.592410982442434*b[i + 13*ldb]);
        c[i + 74*ldc] = (1.124826508017219*b[i + 2*ldb] + -1.470670231280717*b[i + 6*ldb] + -0.3844143922232085*b[i + 10*ldb] + 2.592410982442434*b[i + 14*ldb]);
        c[i + 75*ldc] = (1.124826508017219*b[i + 3*ldb] + -1.470670231280717*b[i + 7*ldb] + -0.3844143922232085*b[i + 11*ldb] + 2.592410982442434*b[i + 15*ldb]);
        c[i + 76*ldc] = (-0.5806281691622632*b[i + 0*ldb] + 0.6162310439495322*b[i + 4*ldb] + -1.420240467903588*b[i + 8*ldb] + -3.332000236352281*b[i + 12*ldb]);
        c[i + 77*ldc] = (-0.5806281691622632*b[i + 1*ldb] + 0.6162310439495322*b[i + 5*ldb] + -1.420240467903588*b[i + 9*ldb] + -3.332000236352281*b[i + 13*ldb]);
        c[i + 78*ldc] = (-0.5806281691622632*b[i + 2*ldb] + 0.6162310439495322*b[i + 6*ldb] + -1.420240467903588*b[i + 10*ldb] + -3.332000236352281*b[i + 14*ldb]);
        c[i + 79*ldc] = (-0.5806281691622632*b[i + 3*ldb] + 0.6162310439495322*b[i + 7*ldb] + -1.420240467903588*b[i + 11*ldb] + -3.332000236352281*b[i + 15*ldb]);
        c[i + 80*ldc] = (3.332000236352281*b[i + 16*ldb] + 1.420240467903588*b[i + 20*ldb] + -0.6162310439495322*b[i + 24*ldb] + 0.5806281691622632*b[i + 28*ldb]);
        c[i + 81*ldc] = (3.332000236352281*b[i + 17*ldb] + 1.420240467903588*b[i + 21*ldb] + -0.6162310439495322*b[i + 25*ldb] + 0.5806281691622632*b[i + 29*ldb]);
        c[i + 82*ldc] = (3.332000236352281*b[i + 18*ldb] + 1.420240467903588*b[i + 22*ldb] + -0.6162310439495322*b[i + 26*ldb] + 0.5806281691622632*b[i + 30*ldb]);
        c[i + 83*ldc] = (3.332000236352281*b[i + 19*ldb] + 1.420240467903588*b[i + 23*ldb] + -0.6162310439495322*b[i + 27*ldb] + 0.5806281691622632*b[i + 31*ldb]);
        c[i + 84*ldc] = (-2.592410982442434*b[i + 16*ldb] + 0.3844143922232085*b[i + 20*ldb] + 1.470670231280717*b[i + 24*ldb] + -1.124826508017219*b[i + 28*ldb]);
        c[i + 85*ldc] = (-2.592410982442434*b[i + 17*ldb] + 0.3844143922232085*b[i + 21*ldb] + 1.470670231280717*b[i + 25*ldb] + -1.124826508017219*b[i + 29*ldb]);
        c[i + 86*ldc] = (-2.592410982442434*b[i + 18*ldb] + 0.3844143922232085*b[i + 22*ldb] + 1.470670231280717*b[i + 26*ldb] + -1.124826508017219*b[i + 30*ldb]);
        c[i + 87*ldc] = (-2.592410982442434*b[i + 19*ldb] + 0.3844143922232085*b[i + 23*ldb] + 1.470670231280717*b[i + 27*ldb] + -1.124826508017219*b[i + 31*ldb]);
        c[i + 88*ldc] = (1.124826508017219*b[i + 16*ldb] + -1.470670231280717*b[i + 20*ldb] + -0.3844143922232085*b[i + 24*ldb] + 2.592410982442434*b[i + 28*ldb]);
        c[i + 89*ldc] = (1.124826508017219*b[i + 17*ldb] + -1.470670231280717*b[i + 21*ldb] + -0.3844143922232085*b[i + 25*ldb] + 2.592410982442434*b[i + 29*ldb]);
        c[i + 90*ldc] = (1.124826508017219*b[i + 18*ldb] + -1.470670231280717*b[i + 22*ldb] + -0.3844143922232085*b[i + 26*ldb] + 2.592410982442434*b[i + 30*ldb]);
        c[i + 91*ldc] = (1.124826508017219*b[i + 19*ldb] + -1.470670231280717*b[i + 23*ldb] + -0.3844143922232085*b[i + 27*ldb] + 2.592410982442434*b[i + 31*ldb]);
        c[i + 92*ldc] = (-0.5806281691622632*b[i + 16*ldb] + 0.6162310439495322*b[i + 20*ldb] + -1.420240467903588*b[i + 24*ldb] + -3.332000236352281*b[i + 28*ldb]);
        c[i + 93*ldc] = (-0.5806281691622632*b[i + 17*ldb] + 0.6162310439495322*b[i + 21*ldb] + -1.420240467903588*b[i + 25*ldb] + -3.332000236352281*b[i + 29*ldb]);
        c[i + 94*ldc] = (-0.5806281691622632*b[i + 18*ldb] + 0.6162310439495322*b[i + 22*ldb] + -1.420240467903588*b[i + 26*ldb] + -3.332000236352281*b[i + 30*ldb]);
        c[i + 95*ldc] = (-0.5806281691622632*b[i + 19*ldb] + 0.6162310439495322*b[i + 23*ldb] + -1.420240467903588*b[i + 27*ldb] + -3.332000236352281*b[i + 31*ldb]);
        c[i + 96*ldc] = (3.332000236352281*b[i + 32*ldb] + 1.420240467903588*b[i + 36*ldb] + -0.6162310439495322*b[i + 40*ldb] + 0.5806281691622632*b[i + 44*ldb]);
        c[i + 97*ldc] = (3.332000236352281*b[i + 33*ldb] + 1.420240467903588*b[i + 37*ldb] + -0.6162310439495322*b[i + 41*ldb] + 0.5806281691622632*b[i + 45*ldb]);
        c[i + 98*ldc] = (3.332000236352281*b[i + 34*ldb] + 1.420240467903588*b[i + 38*ldb] + -0.6162310439495322*b[i + 42*ldb] + 0.5806281691622632*b[i + 46*ldb]);
        c[i + 99*ldc] = (3.332000236352281*b[i + 35*ldb] + 1.420240467903588*b[i + 39*ldb] + -0.6162310439495322*b[i + 43*ldb] + 0.5806281691622632*b[i + 47*ldb]);
        c[i + 100*ldc] = (-2.592410982442434*b[i + 32*ldb] + 0.3844143922232085*b[i + 36*ldb] + 1.470670231280717*b[i + 40*ldb] + -1.124826508017219*b[i + 44*ldb]);
        c[i + 101*ldc] = (-2.592410982442434*b[i + 33*ldb] + 0.3844143922232085*b[i + 37*ldb] + 1.470670231280717*b[i + 41*ldb] + -1.124826508017219*b[i + 45*ldb]);
        c[i + 102*ldc] = (-2.592410982442434*b[i + 34*ldb] + 0.3844143922232085*b[i + 38*ldb] + 1.470670231280717*b[i + 42*ldb] + -1.124826508017219*b[i + 46*ldb]);
        c[i + 103*ldc] = (-2.592410982442434*b[i + 35*ldb] + 0.3844143922232085*b[i + 39*ldb] + 1.470670231280717*b[i + 43*ldb] + -1.124826508017219*b[i + 47*ldb]);
        c[i + 104*ldc] = (1.124826508017219*b[i + 32*ldb] + -1.470670231280717*b[i + 36*ldb] + -0.3844143922232085*b[i + 40*ldb] + 2.592410982442434*b[i + 44*ldb]);
        c[i + 105*ldc] = (1.124826508017219*b[i + 33*ldb] + -1.470670231280717*b[i + 37*ldb] + -0.3844143922232085*b[i + 41*ldb] + 2.592410982442434*b[i + 45*ldb]);
        c[i + 106*ldc] = (1.124826508017219*b[i + 34*ldb] + -1.470670231280717*b[i + 38*ldb] + -0.3844143922232085*b[i + 42*ldb] + 2.592410982442434*b[i + 46*ldb]);
        c[i + 107*ldc] = (1.124826508017219*b[i + 35*ldb] + -1.470670231280717*b[i + 39*ldb] + -0.3844143922232085*b[i + 43*ldb] + 2.592410982442434*b[i + 47*ldb]);
        c[i + 108*ldc] = (-0.5806281691622632*b[i + 32*ldb] + 0.6162310439495322*b[i + 36*ldb] + -1.420240467903588*b[i + 40*ldb] + -3.332000236352281*b[i + 44*ldb]);
        c[i + 109*ldc] = (-0.5806281691622632*b[i + 33*ldb] + 0.6162310439495322*b[i + 37*ldb] + -1.420240467903588*b[i + 41*ldb] + -3.332000236352281*b[i + 45*ldb]);
        c[i + 110*ldc] = (-0.5806281691622632*b[i + 34*ldb] + 0.6162310439495322*b[i + 38*ldb] + -1.420240467903588*b[i + 42*ldb] + -3.332000236352281*b[i + 46*ldb]);
        c[i + 111*ldc] = (-0.5806281691622632*b[i + 35*ldb] + 0.6162310439495322*b[i + 39*ldb] + -1.420240467903588*b[i + 43*ldb] + -3.332000236352281*b[i + 47*ldb]);
        c[i + 112*ldc] = (3.332000236352281*b[i + 48*ldb] + 1.420240467903588*b[i + 52*ldb] + -0.6162310439495322*b[i + 56*ldb] + 0.5806281691622632*b[i + 60*ldb]);
        c[i + 113*ldc] = (3.332000236352281*b[i + 49*ldb] + 1.420240467903588*b[i + 53*ldb] + -0.6162310439495322*b[i + 57*ldb] + 0.5806281691622632*b[i + 61*ldb]);
        c[i + 114*ldc] = (3.332000236352281*b[i + 50*ldb] + 1.420240467903588*b[i + 54*ldb] + -0.6162310439495322*b[i + 58*ldb] + 0.5806281691622632*b[i + 62*ldb]);
        c[i + 115*ldc] = (3.332000236352281*b[i + 51*ldb] + 1.420240467903588*b[i + 55*ldb] + -0.6162310439495322*b[i + 59*ldb] + 0.5806281691622632*b[i + 63*ldb]);
        c[i + 116*ldc] = (-2.592410982442434*b[i + 48*ldb] + 0.3844143922232085*b[i + 52*ldb] + 1.470670231280717*b[i + 56*ldb] + -1.124826508017219*b[i + 60*ldb]);
        c[i + 117*ldc] = (-2.592410982442434*b[i + 49*ldb] + 0.3844143922232085*b[i + 53*ldb] + 1.470670231280717*b[i + 57*ldb] + -1.124826508017219*b[i + 61*ldb]);
        c[i + 118*ldc] = (-2.592410982442434*b[i + 50*ldb] + 0.3844143922232085*b[i + 54*ldb] + 1.470670231280717*b[i + 58*ldb] + -1.124826508017219*b[i + 62*ldb]);
        c[i + 119*ldc] = (-2.592410982442434*b[i + 51*ldb] + 0.3844143922232085*b[i + 55*ldb] + 1.470670231280717*b[i + 59*ldb] + -1.124826508017219*b[i + 63*ldb]);
        c[i + 120*ldc] = (1.124826508017219*b[i + 48*ldb] + -1.470670231280717*b[i + 52*ldb] + -0.3844143922232085*b[i + 56*ldb] + 2.592410982442434*b[i + 60*ldb]);
        c[i + 121*ldc] = (1.124826508017219*b[i + 49*ldb] + -1.470670231280717*b[i + 53*ldb] + -0.3844143922232085*b[i + 57*ldb] + 2.592410982442434*b[i + 61*ldb]);
        c[i + 122*ldc] = (1.124826508017219*b[i + 50*ldb] + -1.470670231280717*b[i + 54*ldb] + -0.3844143922232085*b[i + 58*ldb] + 2.592410982442434*b[i + 62*ldb]);
        c[i + 123*ldc] = (1.124826508017219*b[i + 51*ldb] + -1.470670231280717*b[i + 55*ldb] + -0.3844143922232085*b[i + 59*ldb] + 2.592410982442434*b[i + 63*ldb]);
        c[i + 124*ldc] = (-0.5806281691622632*b[i + 48*ldb] + 0.6162310439495322*b[i + 52*ldb] + -1.420240467903588*b[i + 56*ldb] + -3.332000236352281*b[i + 60*ldb]);
        c[i + 125*ldc] = (-0.5806281691622632*b[i + 49*ldb] + 0.6162310439495322*b[i + 53*ldb] + -1.420240467903588*b[i + 57*ldb] + -3.332000236352281*b[i + 61*ldb]);
        c[i + 126*ldc] = (-0.5806281691622632*b[i + 50*ldb] + 0.6162310439495322*b[i + 54*ldb] + -1.420240467903588*b[i + 58*ldb] + -3.332000236352281*b[i + 62*ldb]);
        c[i + 127*ldc] = (-0.5806281691622632*b[i + 51*ldb] + 0.6162310439495322*b[i + 55*ldb] + -1.420240467903588*b[i + 59*ldb] + -3.332000236352281*b[i + 63*ldb]);
        c[i + 128*ldc] = (3.332000236352281*b[i + 0*ldb] + 1.420240467903588*b[i + 16*ldb] + -0.6162310439495322*b[i + 32*ldb] + 0.5806281691622632*b[i + 48*ldb]);
        c[i + 129*ldc] = (3.332000236352281*b[i + 1*ldb] + 1.420240467903588*b[i + 17*ldb] + -0.6162310439495322*b[i + 33*ldb] + 0.5806281691622632*b[i + 49*ldb]);
        c[i + 130*ldc] = (3.332000236352281*b[i + 2*ldb] + 1.420240467903588*b[i + 18*ldb] + -0.6162310439495322*b[i + 34*ldb] + 0.5806281691622632*b[i + 50*ldb]);
        c[i + 131*ldc] = (3.332000236352281*b[i + 3*ldb] + 1.420240467903588*b[i + 19*ldb] + -0.6162310439495322*b[i + 35*ldb] + 0.5806281691622632*b[i + 51*ldb]);
        c[i + 132*ldc] = (3.332000236352281*b[i + 4*ldb] + 1.420240467903588*b[i + 20*ldb] + -0.6162310439495322*b[i + 36*ldb] + 0.5806281691622632*b[i + 52*ldb]);
        c[i + 133*ldc] = (3.332000236352281*b[i + 5*ldb] + 1.420240467903588*b[i + 21*ldb] + -0.6162310439495322*b[i + 37*ldb] + 0.5806281691622632*b[i + 53*ldb]);
        c[i + 134*ldc] = (3.332000236352281*b[i + 6*ldb] + 1.420240467903588*b[i + 22*ldb] + -0.6162310439495322*b[i + 38*ldb] + 0.5806281691622632*b[i + 54*ldb]);
        c[i + 135*ldc] = (3.332000236352281*b[i + 7*ldb] + 1.420240467903588*b[i + 23*ldb] + -0.6162310439495322*b[i + 39*ldb] + 0.5806281691622632*b[i + 55*ldb]);
        c[i + 136*ldc] = (3.332000236352281*b[i + 8*ldb] + 1.420240467903588*b[i + 24*ldb] + -0.6162310439495322*b[i + 40*ldb] + 0.5806281691622632*b[i + 56*ldb]);
        c[i + 137*ldc] = (3.332000236352281*b[i + 9*ldb] + 1.420240467903588*b[i + 25*ldb] + -0.6162310439495322*b[i + 41*ldb] + 0.5806281691622632*b[i + 57*ldb]);
        c[i + 138*ldc] = (3.332000236352281*b[i + 10*ldb] + 1.420240467903588*b[i + 26*ldb] + -0.6162310439495322*b[i + 42*ldb] + 0.5806281691622632*b[i + 58*ldb]);
        c[i + 139*ldc] = (3.332000236352281*b[i + 11*ldb] + 1.420240467903588*b[i + 27*ldb] + -0.6162310439495322*b[i + 43*ldb] + 0.5806281691622632*b[i + 59*ldb]);
        c[i + 140*ldc] = (3.332000236352281*b[i + 12*ldb] + 1.420240467903588*b[i + 28*ldb] + -0.6162310439495322*b[i + 44*ldb] + 0.5806281691622632*b[i + 60*ldb]);
        c[i + 141*ldc] = (3.332000236352281*b[i + 13*ldb] + 1.420240467903588*b[i + 29*ldb] + -0.6162310439495322*b[i + 45*ldb] + 0.5806281691622632*b[i + 61*ldb]);
        c[i + 142*ldc] = (3.332000236352281*b[i + 14*ldb] + 1.420240467903588*b[i + 30*ldb] + -0.6162310439495322*b[i + 46*ldb] + 0.5806281691622632*b[i + 62*ldb]);
        c[i + 143*ldc] = (3.332000236352281*b[i + 15*ldb] + 1.420240467903588*b[i + 31*ldb] + -0.6162310439495322*b[i + 47*ldb] + 0.5806281691622632*b[i + 63*ldb]);
        c[i + 144*ldc] = (-2.592410982442434*b[i + 0*ldb] + 0.3844143922232085*b[i + 16*ldb] + 1.470670231280717*b[i + 32*ldb] + -1.124826508017219*b[i + 48*ldb]);
        c[i + 145*ldc] = (-2.592410982442434*b[i + 1*ldb] + 0.3844143922232085*b[i + 17*ldb] + 1.470670231280717*b[i + 33*ldb] + -1.124826508017219*b[i + 49*ldb]);
        c[i + 146*ldc] = (-2.592410982442434*b[i + 2*ldb] + 0.3844143922232085*b[i + 18*ldb] + 1.470670231280717*b[i + 34*ldb] + -1.124826508017219*b[i + 50*ldb]);
        c[i + 147*ldc] = (-2.592410982442434*b[i + 3*ldb] + 0.3844143922232085*b[i + 19*ldb] + 1.470670231280717*b[i + 35*ldb] + -1.124826508017219*b[i + 51*ldb]);
        c[i + 148*ldc] = (-2.592410982442434*b[i + 4*ldb] + 0.3844143922232085*b[i + 20*ldb] + 1.470670231280717*b[i + 36*ldb] + -1.124826508017219*b[i + 52*ldb]);
        c[i + 149*ldc] = (-2.592410982442434*b[i + 5*ldb] + 0.3844143922232085*b[i + 21*ldb] + 1.470670231280717*b[i + 37*ldb] + -1.124826508017219*b[i + 53*ldb]);
        c[i + 150*ldc] = (-2.592410982442434*b[i + 6*ldb] + 0.3844143922232085*b[i + 22*ldb] + 1.470670231280717*b[i + 38*ldb] + -1.124826508017219*b[i + 54*ldb]);
        c[i + 151*ldc] = (-2.592410982442434*b[i + 7*ldb] + 0.3844143922232085*b[i + 23*ldb] + 1.470670231280717*b[i + 39*ldb] + -1.124826508017219*b[i + 55*ldb]);
        c[i + 152*ldc] = (-2.592410982442434*b[i + 8*ldb] + 0.3844143922232085*b[i + 24*ldb] + 1.470670231280717*b[i + 40*ldb] + -1.124826508017219*b[i + 56*ldb]);
        c[i + 153*ldc] = (-2.592410982442434*b[i + 9*ldb] + 0.3844143922232085*b[i + 25*ldb] + 1.470670231280717*b[i + 41*ldb] + -1.124826508017219*b[i + 57*ldb]);
        c[i + 154*ldc] = (-2.592410982442434*b[i + 10*ldb] + 0.3844143922232085*b[i + 26*ldb] + 1.470670231280717*b[i + 42*ldb] + -1.124826508017219*b[i + 58*ldb]);
        c[i + 155*ldc] = (-2.592410982442434*b[i + 11*ldb] + 0.3844143922232085*b[i + 27*ldb] + 1.470670231280717*b[i + 43*ldb] + -1.124826508017219*b[i + 59*ldb]);
        c[i + 156*ldc] = (-2.592410982442434*b[i + 12*ldb] + 0.3844143922232085*b[i + 28*ldb] + 1.470670231280717*b[i + 44*ldb] + -1.124826508017219*b[i + 60*ldb]);
        c[i + 157*ldc] = (-2.592410982442434*b[i + 13*ldb] + 0.3844143922232085*b[i + 29*ldb] + 1.470670231280717*b[i + 45*ldb] + -1.124826508017219*b[i + 61*ldb]);
        c[i + 158*ldc] = (-2.592410982442434*b[i + 14*ldb] + 0.3844143922232085*b[i + 30*ldb] + 1.470670231280717*b[i + 46*ldb] + -1.124826508017219*b[i + 62*ldb]);
        c[i + 159*ldc] = (-2.592410982442434*b[i + 15*ldb] + 0.3844143922232085*b[i + 31*ldb] + 1.470670231280717*b[i + 47*ldb] + -1.124826508017219*b[i + 63*ldb]);
        c[i + 160*ldc] = (1.124826508017219*b[i + 0*ldb] + -1.470670231280717*b[i + 16*ldb] + -0.3844143922232085*b[i + 32*ldb] + 2.592410982442434*b[i + 48*ldb]);
        c[i + 161*ldc] = (1.124826508017219*b[i + 1*ldb] + -1.470670231280717*b[i + 17*ldb] + -0.3844143922232085*b[i + 33*ldb] + 2.592410982442434*b[i + 49*ldb]);
        c[i + 162*ldc] = (1.124826508017219*b[i + 2*ldb] + -1.470670231280717*b[i + 18*ldb] + -0.3844143922232085*b[i + 34*ldb] + 2.592410982442434*b[i + 50*ldb]);
        c[i + 163*ldc] = (1.124826508017219*b[i + 3*ldb] + -1.470670231280717*b[i + 19*ldb] + -0.3844143922232085*b[i + 35*ldb] + 2.592410982442434*b[i + 51*ldb]);
        c[i + 164*ldc] = (1.124826508017219*b[i + 4*ldb] + -1.470670231280717*b[i + 20*ldb] + -0.3844143922232085*b[i + 36*ldb] + 2.592410982442434*b[i + 52*ldb]);
        c[i + 165*ldc] = (1.124826508017219*b[i + 5*ldb] + -1.470670231280717*b[i + 21*ldb] + -0.3844143922232085*b[i + 37*ldb] + 2.592410982442434*b[i + 53*ldb]);
        c[i + 166*ldc] = (1.124826508017219*b[i + 6*ldb] + -1.470670231280717*b[i + 22*ldb] + -0.3844143922232085*b[i + 38*ldb] + 2.592410982442434*b[i + 54*ldb]);
        c[i + 167*ldc] = (1.124826508017219*b[i + 7*ldb] + -1.470670231280717*b[i + 23*ldb] + -0.3844143922232085*b[i + 39*ldb] + 2.592410982442434*b[i + 55*ldb]);
        c[i + 168*ldc] = (1.124826508017219*b[i + 8*ldb] + -1.470670231280717*b[i + 24*ldb] + -0.3844143922232085*b[i + 40*ldb] + 2.592410982442434*b[i + 56*ldb]);
        c[i + 169*ldc] = (1.124826508017219*b[i + 9*ldb] + -1.470670231280717*b[i + 25*ldb] + -0.3844143922232085*b[i + 41*ldb] + 2.592410982442434*b[i + 57*ldb]);
        c[i + 170*ldc] = (1.124826508017219*b[i + 10*ldb] + -1.470670231280717*b[i + 26*ldb] + -0.3844143922232085*b[i + 42*ldb] + 2.592410982442434*b[i + 58*ldb]);
        c[i + 171*ldc] = (1.124826508017219*b[i + 11*ldb] + -1.470670231280717*b[i + 27*ldb] + -0.3844143922232085*b[i + 43*ldb] + 2.592410982442434*b[i + 59*ldb]);
        c[i + 172*ldc] = (1.124826508017219*b[i + 12*ldb] + -1.470670231280717*b[i + 28*ldb] + -0.3844143922232085*b[i + 44*ldb] + 2.592410982442434*b[i + 60*ldb]);
        c[i + 173*ldc] = (1.124826508017219*b[i + 13*ldb] + -1.470670231280717*b[i + 29*ldb] + -0.3844143922232085*b[i + 45*ldb] + 2.592410982442434*b[i + 61*ldb]);
        c[i + 174*ldc] = (1.124826508017219*b[i + 14*ldb] + -1.470670231280717*b[i + 30*ldb] + -0.3844143922232085*b[i + 46*ldb] + 2.592410982442434*b[i + 62*ldb]);
        c[i + 175*ldc] = (1.124826508017219*b[i + 15*ldb] + -1.470670231280717*b[i + 31*ldb] + -0.3844143922232085*b[i + 47*ldb] + 2.592410982442434*b[i + 63*ldb]);
        c[i + 176*ldc] = (-0.5806281691622632*b[i + 0*ldb] + 0.6162310439495322*b[i + 16*ldb] + -1.420240467903588*b[i + 32*ldb] + -3.332000236352281*b[i + 48*ldb]);
        c[i + 177*ldc] = (-0.5806281691622632*b[i + 1*ldb] + 0.6162310439495322*b[i + 17*ldb] + -1.420240467903588*b[i + 33*ldb] + -3.332000236352281*b[i + 49*ldb]);
        c[i + 178*ldc] = (-0.5806281691622632*b[i + 2*ldb] + 0.6162310439495322*b[i + 18*ldb] + -1.420240467903588*b[i + 34*ldb] + -3.332000236352281*b[i + 50*ldb]);
        c[i + 179*ldc] = (-0.5806281691622632*b[i + 3*ldb] + 0.6162310439495322*b[i + 19*ldb] + -1.420240467903588*b[i + 35*ldb] + -3.332000236352281*b[i + 51*ldb]);
        c[i + 180*ldc] = (-0.5806281691622632*b[i + 4*ldb] + 0.6162310439495322*b[i + 20*ldb] + -1.420240467903588*b[i + 36*ldb] + -3.332000236352281*b[i + 52*ldb]);
        c[i + 181*ldc] = (-0.5806281691622632*b[i + 5*ldb] + 0.6162310439495322*b[i + 21*ldb] + -1.420240467903588*b[i + 37*ldb] + -3.332000236352281*b[i + 53*ldb]);
        c[i + 182*ldc] = (-0.5806281691622632*b[i + 6*ldb] + 0.6162310439495322*b[i + 22*ldb] + -1.420240467903588*b[i + 38*ldb] + -3.332000236352281*b[i + 54*ldb]);
        c[i + 183*ldc] = (-0.5806281691622632*b[i + 7*ldb] + 0.6162310439495322*b[i + 23*ldb] + -1.420240467903588*b[i + 39*ldb] + -3.332000236352281*b[i + 55*ldb]);
        c[i + 184*ldc] = (-0.5806281691622632*b[i + 8*ldb] + 0.6162310439495322*b[i + 24*ldb] + -1.420240467903588*b[i + 40*ldb] + -3.332000236352281*b[i + 56*ldb]);
        c[i + 185*ldc] = (-0.5806281691622632*b[i + 9*ldb] + 0.6162310439495322*b[i + 25*ldb] + -1.420240467903588*b[i + 41*ldb] + -3.332000236352281*b[i + 57*ldb]);
        c[i + 186*ldc] = (-0.5806281691622632*b[i + 10*ldb] + 0.6162310439495322*b[i + 26*ldb] + -1.420240467903588*b[i + 42*ldb] + -3.332000236352281*b[i + 58*ldb]);
        c[i + 187*ldc] = (-0.5806281691622632*b[i + 11*ldb] + 0.6162310439495322*b[i + 27*ldb] + -1.420240467903588*b[i + 43*ldb] + -3.332000236352281*b[i + 59*ldb]);
        c[i + 188*ldc] = (-0.5806281691622632*b[i + 12*ldb] + 0.6162310439495322*b[i + 28*ldb] + -1.420240467903588*b[i + 44*ldb] + -3.332000236352281*b[i + 60*ldb]);
        c[i + 189*ldc] = (-0.5806281691622632*b[i + 13*ldb] + 0.6162310439495322*b[i + 29*ldb] + -1.420240467903588*b[i + 45*ldb] + -3.332000236352281*b[i + 61*ldb]);
        c[i + 190*ldc] = (-0.5806281691622632*b[i + 14*ldb] + 0.6162310439495322*b[i + 30*ldb] + -1.420240467903588*b[i + 46*ldb] + -3.332000236352281*b[i + 62*ldb]);
        c[i + 191*ldc] = (-0.5806281691622632*b[i + 15*ldb] + 0.6162310439495322*b[i + 31*ldb] + -1.420240467903588*b[i + 47*ldb] + -3.332000236352281*b[i + 63*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_hex_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (3.332000236352281*b[i + 0*ldb] + 1.420240467903588*b[i + 1*ldb] + -0.6162310439495322*b[i + 2*ldb] + 0.5806281691622632*b[i + 3*ldb] + 3.332000236352281*b[i + 64*ldb] + 1.420240467903588*b[i + 68*ldb] + -0.6162310439495322*b[i + 72*ldb] + 0.5806281691622632*b[i + 76*ldb] + 3.332000236352281*b[i + 128*ldb] + 1.420240467903588*b[i + 144*ldb] + -0.6162310439495322*b[i + 160*ldb] + 0.5806281691622632*b[i + 176*ldb]);
        c[i + 1*ldc] = (-2.592410982442434*b[i + 0*ldb] + 0.3844143922232085*b[i + 1*ldb] + 1.470670231280717*b[i + 2*ldb] + -1.124826508017219*b[i + 3*ldb] + 3.332000236352281*b[i + 65*ldb] + 1.420240467903588*b[i + 69*ldb] + -0.6162310439495322*b[i + 73*ldb] + 0.5806281691622632*b[i + 77*ldb] + 3.332000236352281*b[i + 129*ldb] + 1.420240467903588*b[i + 145*ldb] + -0.6162310439495322*b[i + 161*ldb] + 0.5806281691622632*b[i + 177*ldb]);
        c[i + 2*ldc] = (1.124826508017219*b[i + 0*ldb] + -1.470670231280717*b[i + 1*ldb] + -0.3844143922232085*b[i + 2*ldb] + 2.592410982442434*b[i + 3*ldb] + 3.332000236352281*b[i + 66*ldb] + 1.420240467903588*b[i + 70*ldb] + -0.6162310439495322*b[i + 74*ldb] + 0.5806281691622632*b[i + 78*ldb] + 3.332000236352281*b[i + 130*ldb] + 1.420240467903588*b[i + 146*ldb] + -0.6162310439495322*b[i + 162*ldb] + 0.5806281691622632*b[i + 178*ldb]);
        c[i + 3*ldc] = (-0.5806281691622632*b[i + 0*ldb] + 0.6162310439495322*b[i + 1*ldb] + -1.420240467903588*b[i + 2*ldb] + -3.332000236352281*b[i + 3*ldb] + 3.332000236352281*b[i + 67*ldb] + 1.420240467903588*b[i + 71*ldb] + -0.6162310439495322*b[i + 75*ldb] + 0.5806281691622632*b[i + 79*ldb] + 3.332000236352281*b[i + 131*ldb] + 1.420240467903588*b[i + 147*ldb] + -0.6162310439495322*b[i + 163*ldb] + 0.5806281691622632*b[i + 179*ldb]);
        c[i + 4*ldc] = (3.332000236352281*b[i + 4*ldb] + 1.420240467903588*b[i + 5*ldb] + -0.6162310439495322*b[i + 6*ldb] + 0.5806281691622632*b[i + 7*ldb] + -2.592410982442434*b[i + 64*ldb] + 0.3844143922232085*b[i + 68*ldb] + 1.470670231280717*b[i + 72*ldb] + -1.124826508017219*b[i + 76*ldb] + 3.332000236352281*b[i + 132*ldb] + 1.420240467903588*b[i + 148*ldb] + -0.6162310439495322*b[i + 164*ldb] + 0.5806281691622632*b[i + 180*ldb]);
        c[i + 5*ldc] = (-2.592410982442434*b[i + 4*ldb] + 0.3844143922232085*b[i + 5*ldb] + 1.470670231280717*b[i + 6*ldb] + -1.124826508017219*b[i + 7*ldb] + -2.592410982442434*b[i + 65*ldb] + 0.3844143922232085*b[i + 69*ldb] + 1.470670231280717*b[i + 73*ldb] + -1.124826508017219*b[i + 77*ldb] + 3.332000236352281*b[i + 133*ldb] + 1.420240467903588*b[i + 149*ldb] + -0.6162310439495322*b[i + 165*ldb] + 0.5806281691622632*b[i + 181*ldb]);
        c[i + 6*ldc] = (1.124826508017219*b[i + 4*ldb] + -1.470670231280717*b[i + 5*ldb] + -0.3844143922232085*b[i + 6*ldb] + 2.592410982442434*b[i + 7*ldb] + -2.592410982442434*b[i + 66*ldb] + 0.3844143922232085*b[i + 70*ldb] + 1.470670231280717*b[i + 74*ldb] + -1.124826508017219*b[i + 78*ldb] + 3.332000236352281*b[i + 134*ldb] + 1.420240467903588*b[i + 150*ldb] + -0.6162310439495322*b[i + 166*ldb] + 0.5806281691622632*b[i + 182*ldb]);
        c[i + 7*ldc] = (-0.5806281691622632*b[i + 4*ldb] + 0.6162310439495322*b[i + 5*ldb] + -1.420240467903588*b[i + 6*ldb] + -3.332000236352281*b[i + 7*ldb] + -2.592410982442434*b[i + 67*ldb] + 0.3844143922232085*b[i + 71*ldb] + 1.470670231280717*b[i + 75*ldb] + -1.124826508017219*b[i + 79*ldb] + 3.332000236352281*b[i + 135*ldb] + 1.420240467903588*b[i + 151*ldb] + -0.6162310439495322*b[i + 167*ldb] + 0.5806281691622632*b[i + 183*ldb]);
        c[i + 8*ldc] = (3.332000236352281*b[i + 8*ldb] + 1.420240467903588*b[i + 9*ldb] + -0.6162310439495322*b[i + 10*ldb] + 0.5806281691622632*b[i + 11*ldb] + 1.124826508017219*b[i + 64*ldb] + -1.470670231280717*b[i + 68*ldb] + -0.3844143922232085*b[i + 72*ldb] + 2.592410982442434*b[i + 76*ldb] + 3.332000236352281*b[i + 136*ldb] + 1.420240467903588*b[i + 152*ldb] + -0.6162310439495322*b[i + 168*ldb] + 0.5806281691622632*b[i + 184*ldb]);
        c[i + 9*ldc] = (-2.592410982442434*b[i + 8*ldb] + 0.3844143922232085*b[i + 9*ldb] + 1.470670231280717*b[i + 10*ldb] + -1.124826508017219*b[i + 11*ldb] + 1.124826508017219*b[i + 65*ldb] + -1.470670231280717*b[i + 69*ldb] + -0.3844143922232085*b[i + 73*ldb] + 2.592410982442434*b[i + 77*ldb] + 3.332000236352281*b[i + 137*ldb] + 1.420240467903588*b[i + 153*ldb] + -0.6162310439495322*b[i + 169*ldb] + 0.5806281691622632*b[i + 185*ldb]);
        c[i + 10*ldc] = (1.124826508017219*b[i + 8*ldb] + -1.470670231280717*b[i + 9*ldb] + -0.3844143922232085*b[i + 10*ldb] + 2.592410982442434*b[i + 11*ldb] + 1.124826508017219*b[i + 66*ldb] + -1.470670231280717*b[i + 70*ldb] + -0.3844143922232085*b[i + 74*ldb] + 2.592410982442434*b[i + 78*ldb] + 3.332000236352281*b[i + 138*ldb] + 1.420240467903588*b[i + 154*ldb] + -0.6162310439495322*b[i + 170*ldb] + 0.5806281691622632*b[i + 186*ldb]);
        c[i + 11*ldc] = (-0.5806281691622632*b[i + 8*ldb] + 0.6162310439495322*b[i + 9*ldb] + -1.420240467903588*b[i + 10*ldb] + -3.332000236352281*b[i + 11*ldb] + 1.124826508017219*b[i + 67*ldb] + -1.470670231280717*b[i + 71*ldb] + -0.3844143922232085*b[i + 75*ldb] + 2.592410982442434*b[i + 79*ldb] + 3.332000236352281*b[i + 139*ldb] + 1.420240467903588*b[i + 155*ldb] + -0.6162310439495322*b[i + 171*ldb] + 0.5806281691622632*b[i + 187*ldb]);
        c[i + 12*ldc] = (3.332000236352281*b[i + 12*ldb] + 1.420240467903588*b[i + 13*ldb] + -0.6162310439495322*b[i + 14*ldb] + 0.5806281691622632*b[i + 15*ldb] + -0.5806281691622632*b[i + 64*ldb] + 0.6162310439495322*b[i + 68*ldb] + -1.420240467903588*b[i + 72*ldb] + -3.332000236352281*b[i + 76*ldb] + 3.332000236352281*b[i + 140*ldb] + 1.420240467903588*b[i + 156*ldb] + -0.6162310439495322*b[i + 172*ldb] + 0.5806281691622632*b[i + 188*ldb]);
        c[i + 13*ldc] = (-2.592410982442434*b[i + 12*ldb] + 0.3844143922232085*b[i + 13*ldb] + 1.470670231280717*b[i + 14*ldb] + -1.124826508017219*b[i + 15*ldb] + -0.5806281691622632*b[i + 65*ldb] + 0.6162310439495322*b[i + 69*ldb] + -1.420240467903588*b[i + 73*ldb] + -3.332000236352281*b[i + 77*ldb] + 3.332000236352281*b[i + 141*ldb] + 1.420240467903588*b[i + 157*ldb] + -0.6162310439495322*b[i + 173*ldb] + 0.5806281691622632*b[i + 189*ldb]);
        c[i + 14*ldc] = (1.124826508017219*b[i + 12*ldb] + -1.470670231280717*b[i + 13*ldb] + -0.3844143922232085*b[i + 14*ldb] + 2.592410982442434*b[i + 15*ldb] + -0.5806281691622632*b[i + 66*ldb] + 0.6162310439495322*b[i + 70*ldb] + -1.420240467903588*b[i + 74*ldb] + -3.332000236352281*b[i + 78*ldb] + 3.332000236352281*b[i + 142*ldb] + 1.420240467903588*b[i + 158*ldb] + -0.6162310439495322*b[i + 174*ldb] + 0.5806281691622632*b[i + 190*ldb]);
        c[i + 15*ldc] = (-0.5806281691622632*b[i + 12*ldb] + 0.6162310439495322*b[i + 13*ldb] + -1.420240467903588*b[i + 14*ldb] + -3.332000236352281*b[i + 15*ldb] + -0.5806281691622632*b[i + 67*ldb] + 0.6162310439495322*b[i + 71*ldb] + -1.420240467903588*b[i + 75*ldb] + -3.332000236352281*b[i + 79*ldb] + 3.332000236352281*b[i + 143*ldb] + 1.420240467903588*b[i + 159*ldb] + -0.6162310439495322*b[i + 175*ldb] + 0.5806281691622632*b[i + 191*ldb]);
        c[i + 16*ldc] = (3.332000236352281*b[i + 16*ldb] + 1.420240467903588*b[i + 17*ldb] + -0.6162310439495322*b[i + 18*ldb] + 0.5806281691622632*b[i + 19*ldb] + 3.332000236352281*b[i + 80*ldb] + 1.420240467903588*b[i + 84*ldb] + -0.6162310439495322*b[i + 88*ldb] + 0.5806281691622632*b[i + 92*ldb] + -2.592410982442434*b[i + 128*ldb] + 0.3844143922232085*b[i + 144*ldb] + 1.470670231280717*b[i + 160*ldb] + -1.124826508017219*b[i + 176*ldb]);
        c[i + 17*ldc] = (-2.592410982442434*b[i + 16*ldb] + 0.3844143922232085*b[i + 17*ldb] + 1.470670231280717*b[i + 18*ldb] + -1.124826508017219*b[i + 19*ldb] + 3.332000236352281*b[i + 81*ldb] + 1.420240467903588*b[i + 85*ldb] + -0.6162310439495322*b[i + 89*ldb] + 0.5806281691622632*b[i + 93*ldb] + -2.592410982442434*b[i + 129*ldb] + 0.3844143922232085*b[i + 145*ldb] + 1.470670231280717*b[i + 161*ldb] + -1.124826508017219*b[i + 177*ldb]);
        c[i + 18*ldc] = (1.124826508017219*b[i + 16*ldb] + -1.470670231280717*b[i + 17*ldb] + -0.3844143922232085*b[i + 18*ldb] + 2.592410982442434*b[i + 19*ldb] + 3.332000236352281*b[i + 82*ldb] + 1.420240467903588*b[i + 86*ldb] + -0.6162310439495322*b[i + 90*ldb] + 0.5806281691622632*b[i + 94*ldb] + -2.592410982442434*b[i + 130*ldb] + 0.3844143922232085*b[i + 146*ldb] + 1.470670231280717*b[i + 162*ldb] + -1.124826508017219*b[i + 178*ldb]);
        c[i + 19*ldc] = (-0.5806281691622632*b[i + 16*ldb] + 0.6162310439495322*b[i + 17*ldb] + -1.420240467903588*b[i + 18*ldb] + -3.332000236352281*b[i + 19*ldb] + 3.332000236352281*b[i + 83*ldb] + 1.420240467903588*b[i + 87*ldb] + -0.6162310439495322*b[i + 91*ldb] + 0.5806281691622632*b[i + 95*ldb] + -2.592410982442434*b[i + 131*ldb] + 0.3844143922232085*b[i + 147*ldb] + 1.470670231280717*b[i + 163*ldb] + -1.124826508017219*b[i + 179*ldb]);
        c[i + 20*ldc] = (3.332000236352281*b[i + 20*ldb] + 1.420240467903588*b[i + 21*ldb] + -0.6162310439495322*b[i + 22*ldb] + 0.5806281691622632*b[i + 23*ldb] + -2.592410982442434*b[i + 80*ldb] + 0.3844143922232085*b[i + 84*ldb] + 1.470670231280717*b[i + 88*ldb] + -1.124826508017219*b[i + 92*ldb] + -2.592410982442434*b[i + 132*ldb] + 0.3844143922232085*b[i + 148*ldb] + 1.470670231280717*b[i + 164*ldb] + -1.124826508017219*b[i + 180*ldb]);
        c[i + 21*ldc] = (-2.592410982442434*b[i + 20*ldb] + 0.3844143922232085*b[i + 21*ldb] + 1.470670231280717*b[i + 22*ldb] + -1.124826508017219*b[i + 23*ldb] + -2.592410982442434*b[i + 81*ldb] + 0.3844143922232085*b[i + 85*ldb] + 1.470670231280717*b[i + 89*ldb] + -1.124826508017219*b[i + 93*ldb] + -2.592410982442434*b[i + 133*ldb] + 0.3844143922232085*b[i + 149*ldb] + 1.470670231280717*b[i + 165*ldb] + -1.124826508017219*b[i + 181*ldb]);
        c[i + 22*ldc] = (1.124826508017219*b[i + 20*ldb] + -1.470670231280717*b[i + 21*ldb] + -0.3844143922232085*b[i + 22*ldb] + 2.592410982442434*b[i + 23*ldb] + -2.592410982442434*b[i + 82*ldb] + 0.3844143922232085*b[i + 86*ldb] + 1.470670231280717*b[i + 90*ldb] + -1.124826508017219*b[i + 94*ldb] + -2.592410982442434*b[i + 134*ldb] + 0.3844143922232085*b[i + 150*ldb] + 1.470670231280717*b[i + 166*ldb] + -1.124826508017219*b[i + 182*ldb]);
        c[i + 23*ldc] = (-0.5806281691622632*b[i + 20*ldb] + 0.6162310439495322*b[i + 21*ldb] + -1.420240467903588*b[i + 22*ldb] + -3.332000236352281*b[i + 23*ldb] + -2.592410982442434*b[i + 83*ldb] + 0.3844143922232085*b[i + 87*ldb] + 1.470670231280717*b[i + 91*ldb] + -1.124826508017219*b[i + 95*ldb] + -2.592410982442434*b[i + 135*ldb] + 0.3844143922232085*b[i + 151*ldb] + 1.470670231280717*b[i + 167*ldb] + -1.124826508017219*b[i + 183*ldb]);
        c[i + 24*ldc] = (3.332000236352281*b[i + 24*ldb] + 1.420240467903588*b[i + 25*ldb] + -0.6162310439495322*b[i + 26*ldb] + 0.5806281691622632*b[i + 27*ldb] + 1.124826508017219*b[i + 80*ldb] + -1.470670231280717*b[i + 84*ldb] + -0.3844143922232085*b[i + 88*ldb] + 2.592410982442434*b[i + 92*ldb] + -2.592410982442434*b[i + 136*ldb] + 0.3844143922232085*b[i + 152*ldb] + 1.470670231280717*b[i + 168*ldb] + -1.124826508017219*b[i + 184*ldb]);
        c[i + 25*ldc] = (-2.592410982442434*b[i + 24*ldb] + 0.3844143922232085*b[i + 25*ldb] + 1.470670231280717*b[i + 26*ldb] + -1.124826508017219*b[i + 27*ldb] + 1.124826508017219*b[i + 81*ldb] + -1.470670231280717*b[i + 85*ldb] + -0.3844143922232085*b[i + 89*ldb] + 2.592410982442434*b[i + 93*ldb] + -2.592410982442434*b[i + 137*ldb] + 0.3844143922232085*b[i + 153*ldb] + 1.470670231280717*b[i + 169*ldb] + -1.124826508017219*b[i + 185*ldb]);
        c[i + 26*ldc] = (1.124826508017219*b[i + 24*ldb] + -1.470670231280717*b[i + 25*ldb] + -0.3844143922232085*b[i + 26*ldb] + 2.592410982442434*b[i + 27*ldb] + 1.124826508017219*b[i + 82*ldb] + -1.470670231280717*b[i + 86*ldb] + -0.3844143922232085*b[i + 90*ldb] + 2.592410982442434*b[i + 94*ldb] + -2.592410982442434*b[i + 138*ldb] + 0.3844143922232085*b[i + 154*ldb] + 1.470670231280717*b[i + 170*ldb] + -1.124826508017219*b[i + 186*ldb]);
        c[i + 27*ldc] = (-0.5806281691622632*b[i + 24*ldb] + 0.6162310439495322*b[i + 25*ldb] + -1.420240467903588*b[i + 26*ldb] + -3.332000236352281*b[i + 27*ldb] + 1.124826508017219*b[i + 83*ldb] + -1.470670231280717*b[i + 87*ldb] + -0.3844143922232085*b[i + 91*ldb] + 2.592410982442434*b[i + 95*ldb] + -2.592410982442434*b[i + 139*ldb] + 0.3844143922232085*b[i + 155*ldb] + 1.470670231280717*b[i + 171*ldb] + -1.124826508017219*b[i + 187*ldb]);
        c[i + 28*ldc] = (3.332000236352281*b[i + 28*ldb] + 1.420240467903588*b[i + 29*ldb] + -0.6162310439495322*b[i + 30*ldb] + 0.5806281691622632*b[i + 31*ldb] + -0.5806281691622632*b[i + 80*ldb] + 0.6162310439495322*b[i + 84*ldb] + -1.420240467903588*b[i + 88*ldb] + -3.332000236352281*b[i + 92*ldb] + -2.592410982442434*b[i + 140*ldb] + 0.3844143922232085*b[i + 156*ldb] + 1.470670231280717*b[i + 172*ldb] + -1.124826508017219*b[i + 188*ldb]);
        c[i + 29*ldc] = (-2.592410982442434*b[i + 28*ldb] + 0.3844143922232085*b[i + 29*ldb] + 1.470670231280717*b[i + 30*ldb] + -1.124826508017219*b[i + 31*ldb] + -0.5806281691622632*b[i + 81*ldb] + 0.6162310439495322*b[i + 85*ldb] + -1.420240467903588*b[i + 89*ldb] + -3.332000236352281*b[i + 93*ldb] + -2.592410982442434*b[i + 141*ldb] + 0.3844143922232085*b[i + 157*ldb] + 1.470670231280717*b[i + 173*ldb] + -1.124826508017219*b[i + 189*ldb]);
        c[i + 30*ldc] = (1.124826508017219*b[i + 28*ldb] + -1.470670231280717*b[i + 29*ldb] + -0.3844143922232085*b[i + 30*ldb] + 2.592410982442434*b[i + 31*ldb] + -0.5806281691622632*b[i + 82*ldb] + 0.6162310439495322*b[i + 86*ldb] + -1.420240467903588*b[i + 90*ldb] + -3.332000236352281*b[i + 94*ldb] + -2.592410982442434*b[i + 142*ldb] + 0.3844143922232085*b[i + 158*ldb] + 1.470670231280717*b[i + 174*ldb] + -1.124826508017219*b[i + 190*ldb]);
        c[i + 31*ldc] = (-0.5806281691622632*b[i + 28*ldb] + 0.6162310439495322*b[i + 29*ldb] + -1.420240467903588*b[i + 30*ldb] + -3.332000236352281*b[i + 31*ldb] + -0.5806281691622632*b[i + 83*ldb] + 0.6162310439495322*b[i + 87*ldb] + -1.420240467903588*b[i + 91*ldb] + -3.332000236352281*b[i + 95*ldb] + -2.592410982442434*b[i + 143*ldb] + 0.3844143922232085*b[i + 159*ldb] + 1.470670231280717*b[i + 175*ldb] + -1.124826508017219*b[i + 191*ldb]);
        c[i + 32*ldc] = (3.332000236352281*b[i + 32*ldb] + 1.420240467903588*b[i + 33*ldb] + -0.6162310439495322*b[i + 34*ldb] + 0.5806281691622632*b[i + 35*ldb] + 3.332000236352281*b[i + 96*ldb] + 1.420240467903588*b[i + 100*ldb] + -0.6162310439495322*b[i + 104*ldb] + 0.5806281691622632*b[i + 108*ldb] + 1.124826508017219*b[i + 128*ldb] + -1.470670231280717*b[i + 144*ldb] + -0.3844143922232085*b[i + 160*ldb] + 2.592410982442434*b[i + 176*ldb]);
        c[i + 33*ldc] = (-2.592410982442434*b[i + 32*ldb] + 0.3844143922232085*b[i + 33*ldb] + 1.470670231280717*b[i + 34*ldb] + -1.124826508017219*b[i + 35*ldb] + 3.332000236352281*b[i + 97*ldb] + 1.420240467903588*b[i + 101*ldb] + -0.6162310439495322*b[i + 105*ldb] + 0.5806281691622632*b[i + 109*ldb] + 1.124826508017219*b[i + 129*ldb] + -1.470670231280717*b[i + 145*ldb] + -0.3844143922232085*b[i + 161*ldb] + 2.592410982442434*b[i + 177*ldb]);
        c[i + 34*ldc] = (1.124826508017219*b[i + 32*ldb] + -1.470670231280717*b[i + 33*ldb] + -0.3844143922232085*b[i + 34*ldb] + 2.592410982442434*b[i + 35*ldb] + 3.332000236352281*b[i + 98*ldb] + 1.420240467903588*b[i + 102*ldb] + -0.6162310439495322*b[i + 106*ldb] + 0.5806281691622632*b[i + 110*ldb] + 1.124826508017219*b[i + 130*ldb] + -1.470670231280717*b[i + 146*ldb] + -0.3844143922232085*b[i + 162*ldb] + 2.592410982442434*b[i + 178*ldb]);
        c[i + 35*ldc] = (-0.5806281691622632*b[i + 32*ldb] + 0.6162310439495322*b[i + 33*ldb] + -1.420240467903588*b[i + 34*ldb] + -3.332000236352281*b[i + 35*ldb] + 3.332000236352281*b[i + 99*ldb] + 1.420240467903588*b[i + 103*ldb] + -0.6162310439495322*b[i + 107*ldb] + 0.5806281691622632*b[i + 111*ldb] + 1.124826508017219*b[i + 131*ldb] + -1.470670231280717*b[i + 147*ldb] + -0.3844143922232085*b[i + 163*ldb] + 2.592410982442434*b[i + 179*ldb]);
        c[i + 36*ldc] = (3.332000236352281*b[i + 36*ldb] + 1.420240467903588*b[i + 37*ldb] + -0.6162310439495322*b[i + 38*ldb] + 0.5806281691622632*b[i + 39*ldb] + -2.592410982442434*b[i + 96*ldb] + 0.3844143922232085*b[i + 100*ldb] + 1.470670231280717*b[i + 104*ldb] + -1.124826508017219*b[i + 108*ldb] + 1.124826508017219*b[i + 132*ldb] + -1.470670231280717*b[i + 148*ldb] + -0.3844143922232085*b[i + 164*ldb] + 2.592410982442434*b[i + 180*ldb]);
        c[i + 37*ldc] = (-2.592410982442434*b[i + 36*ldb] + 0.3844143922232085*b[i + 37*ldb] + 1.470670231280717*b[i + 38*ldb] + -1.124826508017219*b[i + 39*ldb] + -2.592410982442434*b[i + 97*ldb] + 0.3844143922232085*b[i + 101*ldb] + 1.470670231280717*b[i + 105*ldb] + -1.124826508017219*b[i + 109*ldb] + 1.124826508017219*b[i + 133*ldb] + -1.470670231280717*b[i + 149*ldb] + -0.3844143922232085*b[i + 165*ldb] + 2.592410982442434*b[i + 181*ldb]);
        c[i + 38*ldc] = (1.124826508017219*b[i + 36*ldb] + -1.470670231280717*b[i + 37*ldb] + -0.3844143922232085*b[i + 38*ldb] + 2.592410982442434*b[i + 39*ldb] + -2.592410982442434*b[i + 98*ldb] + 0.3844143922232085*b[i + 102*ldb] + 1.470670231280717*b[i + 106*ldb] + -1.124826508017219*b[i + 110*ldb] + 1.124826508017219*b[i + 134*ldb] + -1.470670231280717*b[i + 150*ldb] + -0.3844143922232085*b[i + 166*ldb] + 2.592410982442434*b[i + 182*ldb]);
        c[i + 39*ldc] = (-0.5806281691622632*b[i + 36*ldb] + 0.6162310439495322*b[i + 37*ldb] + -1.420240467903588*b[i + 38*ldb] + -3.332000236352281*b[i + 39*ldb] + -2.592410982442434*b[i + 99*ldb] + 0.3844143922232085*b[i + 103*ldb] + 1.470670231280717*b[i + 107*ldb] + -1.124826508017219*b[i + 111*ldb] + 1.124826508017219*b[i + 135*ldb] + -1.470670231280717*b[i + 151*ldb] + -0.3844143922232085*b[i + 167*ldb] + 2.592410982442434*b[i + 183*ldb]);
        c[i + 40*ldc] = (3.332000236352281*b[i + 40*ldb] + 1.420240467903588*b[i + 41*ldb] + -0.6162310439495322*b[i + 42*ldb] + 0.5806281691622632*b[i + 43*ldb] + 1.124826508017219*b[i + 96*ldb] + -1.470670231280717*b[i + 100*ldb] + -0.3844143922232085*b[i + 104*ldb] + 2.592410982442434*b[i + 108*ldb] + 1.124826508017219*b[i + 136*ldb] + -1.470670231280717*b[i + 152*ldb] + -0.3844143922232085*b[i + 168*ldb] + 2.592410982442434*b[i + 184*ldb]);
        c[i + 41*ldc] = (-2.592410982442434*b[i + 40*ldb] + 0.3844143922232085*b[i + 41*ldb] + 1.470670231280717*b[i + 42*ldb] + -1.124826508017219*b[i + 43*ldb] + 1.124826508017219*b[i + 97*ldb] + -1.470670231280717*b[i + 101*ldb] + -0.3844143922232085*b[i + 105*ldb] + 2.592410982442434*b[i + 109*ldb] + 1.124826508017219*b[i + 137*ldb] + -1.470670231280717*b[i + 153*ldb] + -0.3844143922232085*b[i + 169*ldb] + 2.592410982442434*b[i + 185*ldb]);
        c[i + 42*ldc] = (1.124826508017219*b[i + 40*ldb] + -1.470670231280717*b[i + 41*ldb] + -0.3844143922232085*b[i + 42*ldb] + 2.592410982442434*b[i + 43*ldb] + 1.124826508017219*b[i + 98*ldb] + -1.470670231280717*b[i + 102*ldb] + -0.3844143922232085*b[i + 106*ldb] + 2.592410982442434*b[i + 110*ldb] + 1.124826508017219*b[i + 138*ldb] + -1.470670231280717*b[i + 154*ldb] + -0.3844143922232085*b[i + 170*ldb] + 2.592410982442434*b[i + 186*ldb]);
        c[i + 43*ldc] = (-0.5806281691622632*b[i + 40*ldb] + 0.6162310439495322*b[i + 41*ldb] + -1.420240467903588*b[i + 42*ldb] + -3.332000236352281*b[i + 43*ldb] + 1.124826508017219*b[i + 99*ldb] + -1.470670231280717*b[i + 103*ldb] + -0.3844143922232085*b[i + 107*ldb] + 2.592410982442434*b[i + 111*ldb] + 1.124826508017219*b[i + 139*ldb] + -1.470670231280717*b[i + 155*ldb] + -0.3844143922232085*b[i + 171*ldb] + 2.592410982442434*b[i + 187*ldb]);
        c[i + 44*ldc] = (3.332000236352281*b[i + 44*ldb] + 1.420240467903588*b[i + 45*ldb] + -0.6162310439495322*b[i + 46*ldb] + 0.5806281691622632*b[i + 47*ldb] + -0.5806281691622632*b[i + 96*ldb] + 0.6162310439495322*b[i + 100*ldb] + -1.420240467903588*b[i + 104*ldb] + -3.332000236352281*b[i + 108*ldb] + 1.124826508017219*b[i + 140*ldb] + -1.470670231280717*b[i + 156*ldb] + -0.3844143922232085*b[i + 172*ldb] + 2.592410982442434*b[i + 188*ldb]);
        c[i + 45*ldc] = (-2.592410982442434*b[i + 44*ldb] + 0.3844143922232085*b[i + 45*ldb] + 1.470670231280717*b[i + 46*ldb] + -1.124826508017219*b[i + 47*ldb] + -0.5806281691622632*b[i + 97*ldb] + 0.6162310439495322*b[i + 101*ldb] + -1.420240467903588*b[i + 105*ldb] + -3.332000236352281*b[i + 109*ldb] + 1.124826508017219*b[i + 141*ldb] + -1.470670231280717*b[i + 157*ldb] + -0.3844143922232085*b[i + 173*ldb] + 2.592410982442434*b[i + 189*ldb]);
        c[i + 46*ldc] = (1.124826508017219*b[i + 44*ldb] + -1.470670231280717*b[i + 45*ldb] + -0.3844143922232085*b[i + 46*ldb] + 2.592410982442434*b[i + 47*ldb] + -0.5806281691622632*b[i + 98*ldb] + 0.6162310439495322*b[i + 102*ldb] + -1.420240467903588*b[i + 106*ldb] + -3.332000236352281*b[i + 110*ldb] + 1.124826508017219*b[i + 142*ldb] + -1.470670231280717*b[i + 158*ldb] + -0.3844143922232085*b[i + 174*ldb] + 2.592410982442434*b[i + 190*ldb]);
        c[i + 47*ldc] = (-0.5806281691622632*b[i + 44*ldb] + 0.6162310439495322*b[i + 45*ldb] + -1.420240467903588*b[i + 46*ldb] + -3.332000236352281*b[i + 47*ldb] + -0.5806281691622632*b[i + 99*ldb] + 0.6162310439495322*b[i + 103*ldb] + -1.420240467903588*b[i + 107*ldb] + -3.332000236352281*b[i + 111*ldb] + 1.124826508017219*b[i + 143*ldb] + -1.470670231280717*b[i + 159*ldb] + -0.3844143922232085*b[i + 175*ldb] + 2.592410982442434*b[i + 191*ldb]);
        c[i + 48*ldc] = (3.332000236352281*b[i + 48*ldb] + 1.420240467903588*b[i + 49*ldb] + -0.6162310439495322*b[i + 50*ldb] + 0.5806281691622632*b[i + 51*ldb] + 3.332000236352281*b[i + 112*ldb] + 1.420240467903588*b[i + 116*ldb] + -0.6162310439495322*b[i + 120*ldb] + 0.5806281691622632*b[i + 124*ldb] + -0.5806281691622632*b[i + 128*ldb] + 0.6162310439495322*b[i + 144*ldb] + -1.420240467903588*b[i + 160*ldb] + -3.332000236352281*b[i + 176*ldb]);
        c[i + 49*ldc] = (-2.592410982442434*b[i + 48*ldb] + 0.3844143922232085*b[i + 49*ldb] + 1.470670231280717*b[i + 50*ldb] + -1.124826508017219*b[i + 51*ldb] + 3.332000236352281*b[i + 113*ldb] + 1.420240467903588*b[i + 117*ldb] + -0.6162310439495322*b[i + 121*ldb] + 0.5806281691622632*b[i + 125*ldb] + -0.5806281691622632*b[i + 129*ldb] + 0.6162310439495322*b[i + 145*ldb] + -1.420240467903588*b[i + 161*ldb] + -3.332000236352281*b[i + 177*ldb]);
        c[i + 50*ldc] = (1.124826508017219*b[i + 48*ldb] + -1.470670231280717*b[i + 49*ldb] + -0.3844143922232085*b[i + 50*ldb] + 2.592410982442434*b[i + 51*ldb] + 3.332000236352281*b[i + 114*ldb] + 1.420240467903588*b[i + 118*ldb] + -0.6162310439495322*b[i + 122*ldb] + 0.5806281691622632*b[i + 126*ldb] + -0.5806281691622632*b[i + 130*ldb] + 0.6162310439495322*b[i + 146*ldb] + -1.420240467903588*b[i + 162*ldb] + -3.332000236352281*b[i + 178*ldb]);
        c[i + 51*ldc] = (-0.5806281691622632*b[i + 48*ldb] + 0.6162310439495322*b[i + 49*ldb] + -1.420240467903588*b[i + 50*ldb] + -3.332000236352281*b[i + 51*ldb] + 3.332000236352281*b[i + 115*ldb] + 1.420240467903588*b[i + 119*ldb] + -0.6162310439495322*b[i + 123*ldb] + 0.5806281691622632*b[i + 127*ldb] + -0.5806281691622632*b[i + 131*ldb] + 0.6162310439495322*b[i + 147*ldb] + -1.420240467903588*b[i + 163*ldb] + -3.332000236352281*b[i + 179*ldb]);
        c[i + 52*ldc] = (3.332000236352281*b[i + 52*ldb] + 1.420240467903588*b[i + 53*ldb] + -0.6162310439495322*b[i + 54*ldb] + 0.5806281691622632*b[i + 55*ldb] + -2.592410982442434*b[i + 112*ldb] + 0.3844143922232085*b[i + 116*ldb] + 1.470670231280717*b[i + 120*ldb] + -1.124826508017219*b[i + 124*ldb] + -0.5806281691622632*b[i + 132*ldb] + 0.6162310439495322*b[i + 148*ldb] + -1.420240467903588*b[i + 164*ldb] + -3.332000236352281*b[i + 180*ldb]);
        c[i + 53*ldc] = (-2.592410982442434*b[i + 52*ldb] + 0.3844143922232085*b[i + 53*ldb] + 1.470670231280717*b[i + 54*ldb] + -1.124826508017219*b[i + 55*ldb] + -2.592410982442434*b[i + 113*ldb] + 0.3844143922232085*b[i + 117*ldb] + 1.470670231280717*b[i + 121*ldb] + -1.124826508017219*b[i + 125*ldb] + -0.5806281691622632*b[i + 133*ldb] + 0.6162310439495322*b[i + 149*ldb] + -1.420240467903588*b[i + 165*ldb] + -3.332000236352281*b[i + 181*ldb]);
        c[i + 54*ldc] = (1.124826508017219*b[i + 52*ldb] + -1.470670231280717*b[i + 53*ldb] + -0.3844143922232085*b[i + 54*ldb] + 2.592410982442434*b[i + 55*ldb] + -2.592410982442434*b[i + 114*ldb] + 0.3844143922232085*b[i + 118*ldb] + 1.470670231280717*b[i + 122*ldb] + -1.124826508017219*b[i + 126*ldb] + -0.5806281691622632*b[i + 134*ldb] + 0.6162310439495322*b[i + 150*ldb] + -1.420240467903588*b[i + 166*ldb] + -3.332000236352281*b[i + 182*ldb]);
        c[i + 55*ldc] = (-0.5806281691622632*b[i + 52*ldb] + 0.6162310439495322*b[i + 53*ldb] + -1.420240467903588*b[i + 54*ldb] + -3.332000236352281*b[i + 55*ldb] + -2.592410982442434*b[i + 115*ldb] + 0.3844143922232085*b[i + 119*ldb] + 1.470670231280717*b[i + 123*ldb] + -1.124826508017219*b[i + 127*ldb] + -0.5806281691622632*b[i + 135*ldb] + 0.6162310439495322*b[i + 151*ldb] + -1.420240467903588*b[i + 167*ldb] + -3.332000236352281*b[i + 183*ldb]);
        c[i + 56*ldc] = (3.332000236352281*b[i + 56*ldb] + 1.420240467903588*b[i + 57*ldb] + -0.6162310439495322*b[i + 58*ldb] + 0.5806281691622632*b[i + 59*ldb] + 1.124826508017219*b[i + 112*ldb] + -1.470670231280717*b[i + 116*ldb] + -0.3844143922232085*b[i + 120*ldb] + 2.592410982442434*b[i + 124*ldb] + -0.5806281691622632*b[i + 136*ldb] + 0.6162310439495322*b[i + 152*ldb] + -1.420240467903588*b[i + 168*ldb] + -3.332000236352281*b[i + 184*ldb]);
        c[i + 57*ldc] = (-2.592410982442434*b[i + 56*ldb] + 0.3844143922232085*b[i + 57*ldb] + 1.470670231280717*b[i + 58*ldb] + -1.124826508017219*b[i + 59*ldb] + 1.124826508017219*b[i + 113*ldb] + -1.470670231280717*b[i + 117*ldb] + -0.3844143922232085*b[i + 121*ldb] + 2.592410982442434*b[i + 125*ldb] + -0.5806281691622632*b[i + 137*ldb] + 0.6162310439495322*b[i + 153*ldb] + -1.420240467903588*b[i + 169*ldb] + -3.332000236352281*b[i + 185*ldb]);
        c[i + 58*ldc] = (1.124826508017219*b[i + 56*ldb] + -1.470670231280717*b[i + 57*ldb] + -0.3844143922232085*b[i + 58*ldb] + 2.592410982442434*b[i + 59*ldb] + 1.124826508017219*b[i + 114*ldb] + -1.470670231280717*b[i + 118*ldb] + -0.3844143922232085*b[i + 122*ldb] + 2.592410982442434*b[i + 126*ldb] + -0.5806281691622632*b[i + 138*ldb] + 0.6162310439495322*b[i + 154*ldb] + -1.420240467903588*b[i + 170*ldb] + -3.332000236352281*b[i + 186*ldb]);
        c[i + 59*ldc] = (-0.5806281691622632*b[i + 56*ldb] + 0.6162310439495322*b[i + 57*ldb] + -1.420240467903588*b[i + 58*ldb] + -3.332000236352281*b[i + 59*ldb] + 1.124826508017219*b[i + 115*ldb] + -1.470670231280717*b[i + 119*ldb] + -0.3844143922232085*b[i + 123*ldb] + 2.592410982442434*b[i + 127*ldb] + -0.5806281691622632*b[i + 139*ldb] + 0.6162310439495322*b[i + 155*ldb] + -1.420240467903588*b[i + 171*ldb] + -3.332000236352281*b[i + 187*ldb]);
        c[i + 60*ldc] = (3.332000236352281*b[i + 60*ldb] + 1.420240467903588*b[i + 61*ldb] + -0.6162310439495322*b[i + 62*ldb] + 0.5806281691622632*b[i + 63*ldb] + -0.5806281691622632*b[i + 112*ldb] + 0.6162310439495322*b[i + 116*ldb] + -1.420240467903588*b[i + 120*ldb] + -3.332000236352281*b[i + 124*ldb] + -0.5806281691622632*b[i + 140*ldb] + 0.6162310439495322*b[i + 156*ldb] + -1.420240467903588*b[i + 172*ldb] + -3.332000236352281*b[i + 188*ldb]);
        c[i + 61*ldc] = (-2.592410982442434*b[i + 60*ldb] + 0.3844143922232085*b[i + 61*ldb] + 1.470670231280717*b[i + 62*ldb] + -1.124826508017219*b[i + 63*ldb] + -0.5806281691622632*b[i + 113*ldb] + 0.6162310439495322*b[i + 117*ldb] + -1.420240467903588*b[i + 121*ldb] + -3.332000236352281*b[i + 125*ldb] + -0.5806281691622632*b[i + 141*ldb] + 0.6162310439495322*b[i + 157*ldb] + -1.420240467903588*b[i + 173*ldb] + -3.332000236352281*b[i + 189*ldb]);
        c[i + 62*ldc] = (1.124826508017219*b[i + 60*ldb] + -1.470670231280717*b[i + 61*ldb] + -0.3844143922232085*b[i + 62*ldb] + 2.592410982442434*b[i + 63*ldb] + -0.5806281691622632*b[i + 114*ldb] + 0.6162310439495322*b[i + 118*ldb] + -1.420240467903588*b[i + 122*ldb] + -3.332000236352281*b[i + 126*ldb] + -0.5806281691622632*b[i + 142*ldb] + 0.6162310439495322*b[i + 158*ldb] + -1.420240467903588*b[i + 174*ldb] + -3.332000236352281*b[i + 190*ldb]);
        c[i + 63*ldc] = (-0.5806281691622632*b[i + 60*ldb] + 0.6162310439495322*b[i + 61*ldb] + -1.420240467903588*b[i + 62*ldb] + -3.332000236352281*b[i + 63*ldb] + -0.5806281691622632*b[i + 115*ldb] + 0.6162310439495322*b[i + 119*ldb] + -1.420240467903588*b[i + 123*ldb] + -3.332000236352281*b[i + 127*ldb] + -0.5806281691622632*b[i + 143*ldb] + 0.6162310439495322*b[i + 159*ldb] + -1.420240467903588*b[i + 175*ldb] + -3.332000236352281*b[i + 191*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_pri_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.526788125457267*b[i + 0*ldb] + -0.8136324494869274*b[i + 10*ldb] + 0.4007615203116506*b[i + 20*ldb] + -0.1139171962819901*b[i + 30*ldb]);
        c[i + 1*ldc] = (1.526788125457267*b[i + 1*ldb] + -0.8136324494869274*b[i + 11*ldb] + 0.4007615203116506*b[i + 21*ldb] + -0.1139171962819901*b[i + 31*ldb]);
        c[i + 2*ldc] = (1.526788125457267*b[i + 2*ldb] + -0.8136324494869274*b[i + 12*ldb] + 0.4007615203116506*b[i + 22*ldb] + -0.1139171962819901*b[i + 32*ldb]);
        c[i + 3*ldc] = (1.526788125457267*b[i + 3*ldb] + -0.8136324494869274*b[i + 13*ldb] + 0.4007615203116506*b[i + 23*ldb] + -0.1139171962819901*b[i + 33*ldb]);
        c[i + 4*ldc] = (1.526788125457267*b[i + 4*ldb] + -0.8136324494869274*b[i + 14*ldb] + 0.4007615203116506*b[i + 24*ldb] + -0.1139171962819901*b[i + 34*ldb]);
        c[i + 5*ldc] = (1.526788125457267*b[i + 5*ldb] + -0.8136324494869274*b[i + 15*ldb] + 0.4007615203116506*b[i + 25*ldb] + -0.1139171962819901*b[i + 35*ldb]);
        c[i + 6*ldc] = (1.526788125457267*b[i + 6*ldb] + -0.8136324494869274*b[i + 16*ldb] + 0.4007615203116506*b[i + 26*ldb] + -0.1139171962819901*b[i + 36*ldb]);
        c[i + 7*ldc] = (1.526788125457267*b[i + 7*ldb] + -0.8136324494869274*b[i + 17*ldb] + 0.4007615203116506*b[i + 27*ldb] + -0.1139171962819901*b[i + 37*ldb]);
        c[i + 8*ldc] = (1.526788125457267*b[i + 8*ldb] + -0.8136324494869274*b[i + 18*ldb] + 0.4007615203116506*b[i + 28*ldb] + -0.1139171962819901*b[i + 38*ldb]);
        c[i + 9*ldc] = (1.526788125457267*b[i + 9*ldb] + -0.8136324494869274*b[i + 19*ldb] + 0.4007615203116506*b[i + 29*ldb] + -0.1139171962819901*b[i + 39*ldb]);
        c[i + 10*ldc] = (-0.1139171962819901*b[i + 0*ldb] + 0.4007615203116506*b[i + 10*ldb] + -0.8136324494869274*b[i + 20*ldb] + 1.526788125457267*b[i + 30*ldb]);
        c[i + 11*ldc] = (-0.1139171962819901*b[i + 1*ldb] + 0.4007615203116506*b[i + 11*ldb] + -0.8136324494869274*b[i + 21*ldb] + 1.526788125457267*b[i + 31*ldb]);
        c[i + 12*ldc] = (-0.1139171962819901*b[i + 2*ldb] + 0.4007615203116506*b[i + 12*ldb] + -0.8136324494869274*b[i + 22*ldb] + 1.526788125457267*b[i + 32*ldb]);
        c[i + 13*ldc] = (-0.1139171962819901*b[i + 3*ldb] + 0.4007615203116506*b[i + 13*ldb] + -0.8136324494869274*b[i + 23*ldb] + 1.526788125457267*b[i + 33*ldb]);
        c[i + 14*ldc] = (-0.1139171962819901*b[i + 4*ldb] + 0.4007615203116506*b[i + 14*ldb] + -0.8136324494869274*b[i + 24*ldb] + 1.526788125457267*b[i + 34*ldb]);
        c[i + 15*ldc] = (-0.1139171962819901*b[i + 5*ldb] + 0.4007615203116506*b[i + 15*ldb] + -0.8136324494869274*b[i + 25*ldb] + 1.526788125457267*b[i + 35*ldb]);
        c[i + 16*ldc] = (-0.1139171962819901*b[i + 6*ldb] + 0.4007615203116506*b[i + 16*ldb] + -0.8136324494869274*b[i + 26*ldb] + 1.526788125457267*b[i + 36*ldb]);
        c[i + 17*ldc] = (-0.1139171962819901*b[i + 7*ldb] + 0.4007615203116506*b[i + 17*ldb] + -0.8136324494869274*b[i + 27*ldb] + 1.526788125457267*b[i + 37*ldb]);
        c[i + 18*ldc] = (-0.1139171962819901*b[i + 8*ldb] + 0.4007615203116506*b[i + 18*ldb] + -0.8136324494869274*b[i + 28*ldb] + 1.526788125457267*b[i + 38*ldb]);
        c[i + 19*ldc] = (-0.1139171962819901*b[i + 9*ldb] + 0.4007615203116506*b[i + 19*ldb] + -0.8136324494869274*b[i + 29*ldb] + 1.526788125457267*b[i + 39*ldb]);
        c[i + 20*ldc] = (-0.00931763715572317*b[i + 0*ldb] + -0.08480139426291668*b[i + 1*ldb] + 0.0190921505595041*b[i + 2*ldb] + 1.3076436072264*b[i + 3*ldb] + 0.01069077635493623*b[i + 4*ldb] + -0.668898792282742*b[i + 5*ldb] + 0.20558978371198*b[i + 6*ldb] + -0.08035417718870008*b[i + 7*ldb] + 0.3139569161048014*b[i + 8*ldb] + -0.01360123306753975*b[i + 9*ldb]);
        c[i + 21*ldc] = (-0.6000294893938931*b[i + 0*ldb] + -0.1208050050634916*b[i + 1*ldb] + -0.03774132900735336*b[i + 2*ldb] + 0.04783219882870976*b[i + 3*ldb] + 0.02376128253747421*b[i + 4*ldb] + -0.3142121016181042*b[i + 5*ldb] + 1.402532525197397*b[i + 6*ldb] + 0.1516896732159436*b[i + 7*ldb] + 0.3025928817647563*b[i + 8*ldb] + 0.1443793635385614*b[i + 9*ldb]);
        c[i + 22*ldc] = (-0.6000294893938931*b[i + 0*ldb] + -0.1208050050634916*b[i + 1*ldb] + 0.04783219882870976*b[i + 2*ldb] + -0.03774132900735336*b[i + 3*ldb] + -0.3142121016181042*b[i + 4*ldb] + 0.02376128253747421*b[i + 5*ldb] + 0.1516896732159436*b[i + 6*ldb] + 1.402532525197397*b[i + 7*ldb] + 0.1443793635385614*b[i + 8*ldb] + 0.3025928817647563*b[i + 9*ldb]);
        c[i + 23*ldc] = (-0.00931763715572317*b[i + 0*ldb] + -0.08480139426291668*b[i + 1*ldb] + 1.3076436072264*b[i + 2*ldb] + 0.0190921505595041*b[i + 3*ldb] + -0.668898792282742*b[i + 4*ldb] + 0.01069077635493623*b[i + 5*ldb] + -0.08035417718870008*b[i + 6*ldb] + 0.20558978371198*b[i + 7*ldb] + -0.01360123306753975*b[i + 8*ldb] + 0.3139569161048014*b[i + 9*ldb]);
        c[i + 24*ldc] = (-0.00931763715572317*b[i + 10*ldb] + -0.08480139426291668*b[i + 11*ldb] + 0.0190921505595041*b[i + 12*ldb] + 1.3076436072264*b[i + 13*ldb] + 0.01069077635493623*b[i + 14*ldb] + -0.668898792282742*b[i + 15*ldb] + 0.20558978371198*b[i + 16*ldb] + -0.08035417718870008*b[i + 17*ldb] + 0.3139569161048014*b[i + 18*ldb] + -0.01360123306753975*b[i + 19*ldb]);
        c[i + 25*ldc] = (-0.6000294893938931*b[i + 10*ldb] + -0.1208050050634916*b[i + 11*ldb] + -0.03774132900735336*b[i + 12*ldb] + 0.04783219882870976*b[i + 13*ldb] + 0.02376128253747421*b[i + 14*ldb] + -0.3142121016181042*b[i + 15*ldb] + 1.402532525197397*b[i + 16*ldb] + 0.1516896732159436*b[i + 17*ldb] + 0.3025928817647563*b[i + 18*ldb] + 0.1443793635385614*b[i + 19*ldb]);
        c[i + 26*ldc] = (-0.6000294893938931*b[i + 10*ldb] + -0.1208050050634916*b[i + 11*ldb] + 0.04783219882870976*b[i + 12*ldb] + -0.03774132900735336*b[i + 13*ldb] + -0.3142121016181042*b[i + 14*ldb] + 0.02376128253747421*b[i + 15*ldb] + 0.1516896732159436*b[i + 16*ldb] + 1.402532525197397*b[i + 17*ldb] + 0.1443793635385614*b[i + 18*ldb] + 0.3025928817647563*b[i + 19*ldb]);
        c[i + 27*ldc] = (-0.00931763715572317*b[i + 10*ldb] + -0.08480139426291668*b[i + 11*ldb] + 1.3076436072264*b[i + 12*ldb] + 0.0190921505595041*b[i + 13*ldb] + -0.668898792282742*b[i + 14*ldb] + 0.01069077635493623*b[i + 15*ldb] + -0.08035417718870008*b[i + 16*ldb] + 0.20558978371198*b[i + 17*ldb] + -0.01360123306753975*b[i + 18*ldb] + 0.3139569161048014*b[i + 19*ldb]);
        c[i + 28*ldc] = (-0.00931763715572317*b[i + 20*ldb] + -0.08480139426291668*b[i + 21*ldb] + 0.0190921505595041*b[i + 22*ldb] + 1.3076436072264*b[i + 23*ldb] + 0.01069077635493623*b[i + 24*ldb] + -0.668898792282742*b[i + 25*ldb] + 0.20558978371198*b[i + 26*ldb] + -0.08035417718870008*b[i + 27*ldb] + 0.3139569161048014*b[i + 28*ldb] + -0.01360123306753975*b[i + 29*ldb]);
        c[i + 29*ldc] = (-0.6000294893938931*b[i + 20*ldb] + -0.1208050050634916*b[i + 21*ldb] + -0.03774132900735336*b[i + 22*ldb] + 0.04783219882870976*b[i + 23*ldb] + 0.02376128253747421*b[i + 24*ldb] + -0.3142121016181042*b[i + 25*ldb] + 1.402532525197397*b[i + 26*ldb] + 0.1516896732159436*b[i + 27*ldb] + 0.3025928817647563*b[i + 28*ldb] + 0.1443793635385614*b[i + 29*ldb]);
        c[i + 30*ldc] = (-0.6000294893938931*b[i + 20*ldb] + -0.1208050050634916*b[i + 21*ldb] + 0.04783219882870976*b[i + 22*ldb] + -0.03774132900735336*b[i + 23*ldb] + -0.3142121016181042*b[i + 24*ldb] + 0.02376128253747421*b[i + 25*ldb] + 0.1516896732159436*b[i + 26*ldb] + 1.402532525197397*b[i + 27*ldb] + 0.1443793635385614*b[i + 28*ldb] + 0.3025928817647563*b[i + 29*ldb]);
        c[i + 31*ldc] = (-0.00931763715572317*b[i + 20*ldb] + -0.08480139426291668*b[i + 21*ldb] + 1.3076436072264*b[i + 22*ldb] + 0.0190921505595041*b[i + 23*ldb] + -0.668898792282742*b[i + 24*ldb] + 0.01069077635493623*b[i + 25*ldb] + -0.08035417718870008*b[i + 26*ldb] + 0.20558978371198*b[i + 27*ldb] + -0.01360123306753975*b[i + 28*ldb] + 0.3139569161048014*b[i + 29*ldb]);
        c[i + 32*ldc] = (-0.00931763715572317*b[i + 30*ldb] + -0.08480139426291668*b[i + 31*ldb] + 0.0190921505595041*b[i + 32*ldb] + 1.3076436072264*b[i + 33*ldb] + 0.01069077635493623*b[i + 34*ldb] + -0.668898792282742*b[i + 35*ldb] + 0.20558978371198*b[i + 36*ldb] + -0.08035417718870008*b[i + 37*ldb] + 0.3139569161048014*b[i + 38*ldb] + -0.01360123306753975*b[i + 39*ldb]);
        c[i + 33*ldc] = (-0.6000294893938931*b[i + 30*ldb] + -0.1208050050634916*b[i + 31*ldb] + -0.03774132900735336*b[i + 32*ldb] + 0.04783219882870976*b[i + 33*ldb] + 0.02376128253747421*b[i + 34*ldb] + -0.3142121016181042*b[i + 35*ldb] + 1.402532525197397*b[i + 36*ldb] + 0.1516896732159436*b[i + 37*ldb] + 0.3025928817647563*b[i + 38*ldb] + 0.1443793635385614*b[i + 39*ldb]);
        c[i + 34*ldc] = (-0.6000294893938931*b[i + 30*ldb] + -0.1208050050634916*b[i + 31*ldb] + 0.04783219882870976*b[i + 32*ldb] + -0.03774132900735336*b[i + 33*ldb] + -0.3142121016181042*b[i + 34*ldb] + 0.02376128253747421*b[i + 35*ldb] + 0.1516896732159436*b[i + 36*ldb] + 1.402532525197397*b[i + 37*ldb] + 0.1443793635385614*b[i + 38*ldb] + 0.3025928817647563*b[i + 39*ldb]);
        c[i + 35*ldc] = (-0.00931763715572317*b[i + 30*ldb] + -0.08480139426291668*b[i + 31*ldb] + 1.3076436072264*b[i + 32*ldb] + 0.0190921505595041*b[i + 33*ldb] + -0.668898792282742*b[i + 34*ldb] + 0.01069077635493623*b[i + 35*ldb] + -0.08035417718870008*b[i + 36*ldb] + 0.20558978371198*b[i + 37*ldb] + -0.01360123306753975*b[i + 38*ldb] + 0.3139569161048014*b[i + 39*ldb]);
        c[i + 36*ldc] = (-0.00931763715572317*b[i + 0*ldb] + 0.0190921505595041*b[i + 1*ldb] + 1.3076436072264*b[i + 2*ldb] + -0.08480139426291668*b[i + 3*ldb] + 0.20558978371198*b[i + 4*ldb] + -0.01360123306753975*b[i + 5*ldb] + 0.3139569161048014*b[i + 6*ldb] + -0.668898792282742*b[i + 7*ldb] + 0.01069077635493623*b[i + 8*ldb] + -0.08035417718870008*b[i + 9*ldb]);
        c[i + 37*ldc] = (-0.6000294893938931*b[i + 0*ldb] + -0.03774132900735336*b[i + 1*ldb] + 0.04783219882870976*b[i + 2*ldb] + -0.1208050050634916*b[i + 3*ldb] + 1.402532525197397*b[i + 4*ldb] + 0.1443793635385614*b[i + 5*ldb] + 0.3025928817647563*b[i + 6*ldb] + -0.3142121016181042*b[i + 7*ldb] + 0.02376128253747421*b[i + 8*ldb] + 0.1516896732159436*b[i + 9*ldb]);
        c[i + 38*ldc] = (-0.6000294893938931*b[i + 0*ldb] + 0.04783219882870976*b[i + 1*ldb] + -0.03774132900735336*b[i + 2*ldb] + -0.1208050050634916*b[i + 3*ldb] + 0.1516896732159436*b[i + 4*ldb] + 0.3025928817647563*b[i + 5*ldb] + 0.1443793635385614*b[i + 6*ldb] + 0.02376128253747421*b[i + 7*ldb] + -0.3142121016181042*b[i + 8*ldb] + 1.402532525197397*b[i + 9*ldb]);
        c[i + 39*ldc] = (-0.00931763715572317*b[i + 0*ldb] + 1.3076436072264*b[i + 1*ldb] + 0.0190921505595041*b[i + 2*ldb] + -0.08480139426291668*b[i + 3*ldb] + -0.08035417718870008*b[i + 4*ldb] + 0.3139569161048014*b[i + 5*ldb] + -0.01360123306753975*b[i + 6*ldb] + 0.01069077635493623*b[i + 7*ldb] + -0.668898792282742*b[i + 8*ldb] + 0.20558978371198*b[i + 9*ldb]);
        c[i + 40*ldc] = (-0.00931763715572317*b[i + 10*ldb] + 0.0190921505595041*b[i + 11*ldb] + 1.3076436072264*b[i + 12*ldb] + -0.08480139426291668*b[i + 13*ldb] + 0.20558978371198*b[i + 14*ldb] + -0.01360123306753975*b[i + 15*ldb] + 0.3139569161048014*b[i + 16*ldb] + -0.668898792282742*b[i + 17*ldb] + 0.01069077635493623*b[i + 18*ldb] + -0.08035417718870008*b[i + 19*ldb]);
        c[i + 41*ldc] = (-0.6000294893938931*b[i + 10*ldb] + -0.03774132900735336*b[i + 11*ldb] + 0.04783219882870976*b[i + 12*ldb] + -0.1208050050634916*b[i + 13*ldb] + 1.402532525197397*b[i + 14*ldb] + 0.1443793635385614*b[i + 15*ldb] + 0.3025928817647563*b[i + 16*ldb] + -0.3142121016181042*b[i + 17*ldb] + 0.02376128253747421*b[i + 18*ldb] + 0.1516896732159436*b[i + 19*ldb]);
        c[i + 42*ldc] = (-0.6000294893938931*b[i + 10*ldb] + 0.04783219882870976*b[i + 11*ldb] + -0.03774132900735336*b[i + 12*ldb] + -0.1208050050634916*b[i + 13*ldb] + 0.1516896732159436*b[i + 14*ldb] + 0.3025928817647563*b[i + 15*ldb] + 0.1443793635385614*b[i + 16*ldb] + 0.02376128253747421*b[i + 17*ldb] + -0.3142121016181042*b[i + 18*ldb] + 1.402532525197397*b[i + 19*ldb]);
        c[i + 43*ldc] = (-0.00931763715572317*b[i + 10*ldb] + 1.3076436072264*b[i + 11*ldb] + 0.0190921505595041*b[i + 12*ldb] + -0.08480139426291668*b[i + 13*ldb] + -0.08035417718870008*b[i + 14*ldb] + 0.3139569161048014*b[i + 15*ldb] + -0.01360123306753975*b[i + 16*ldb] + 0.01069077635493623*b[i + 17*ldb] + -0.668898792282742*b[i + 18*ldb] + 0.20558978371198*b[i + 19*ldb]);
        c[i + 44*ldc] = (-0.00931763715572317*b[i + 20*ldb] + 0.0190921505595041*b[i + 21*ldb] + 1.3076436072264*b[i + 22*ldb] + -0.08480139426291668*b[i + 23*ldb] + 0.20558978371198*b[i + 24*ldb] + -0.01360123306753975*b[i + 25*ldb] + 0.3139569161048014*b[i + 26*ldb] + -0.668898792282742*b[i + 27*ldb] + 0.01069077635493623*b[i + 28*ldb] + -0.08035417718870008*b[i + 29*ldb]);
        c[i + 45*ldc] = (-0.6000294893938931*b[i + 20*ldb] + -0.03774132900735336*b[i + 21*ldb] + 0.04783219882870976*b[i + 22*ldb] + -0.1208050050634916*b[i + 23*ldb] + 1.402532525197397*b[i + 24*ldb] + 0.1443793635385614*b[i + 25*ldb] + 0.3025928817647563*b[i + 26*ldb] + -0.3142121016181042*b[i + 27*ldb] + 0.02376128253747421*b[i + 28*ldb] + 0.1516896732159436*b[i + 29*ldb]);
        c[i + 46*ldc] = (-0.6000294893938931*b[i + 20*ldb] + 0.04783219882870976*b[i + 21*ldb] + -0.03774132900735336*b[i + 22*ldb] + -0.1208050050634916*b[i + 23*ldb] + 0.1516896732159436*b[i + 24*ldb] + 0.3025928817647563*b[i + 25*ldb] + 0.1443793635385614*b[i + 26*ldb] + 0.02376128253747421*b[i + 27*ldb] + -0.3142121016181042*b[i + 28*ldb] + 1.402532525197397*b[i + 29*ldb]);
        c[i + 47*ldc] = (-0.00931763715572317*b[i + 20*ldb] + 1.3076436072264*b[i + 21*ldb] + 0.0190921505595041*b[i + 22*ldb] + -0.08480139426291668*b[i + 23*ldb] + -0.08035417718870008*b[i + 24*ldb] + 0.3139569161048014*b[i + 25*ldb] + -0.01360123306753975*b[i + 26*ldb] + 0.01069077635493623*b[i + 27*ldb] + -0.668898792282742*b[i + 28*ldb] + 0.20558978371198*b[i + 29*ldb]);
        c[i + 48*ldc] = (-0.00931763715572317*b[i + 30*ldb] + 0.0190921505595041*b[i + 31*ldb] + 1.3076436072264*b[i + 32*ldb] + -0.08480139426291668*b[i + 33*ldb] + 0.20558978371198*b[i + 34*ldb] + -0.01360123306753975*b[i + 35*ldb] + 0.3139569161048014*b[i + 36*ldb] + -0.668898792282742*b[i + 37*ldb] + 0.01069077635493623*b[i + 38*ldb] + -0.08035417718870008*b[i + 39*ldb]);
        c[i + 49*ldc] = (-0.6000294893938931*b[i + 30*ldb] + -0.03774132900735336*b[i + 31*ldb] + 0.04783219882870976*b[i + 32*ldb] + -0.1208050050634916*b[i + 33*ldb] + 1.402532525197397*b[i + 34*ldb] + 0.1443793635385614*b[i + 35*ldb] + 0.3025928817647563*b[i + 36*ldb] + -0.3142121016181042*b[i + 37*ldb] + 0.02376128253747421*b[i + 38*ldb] + 0.1516896732159436*b[i + 39*ldb]);
        c[i + 50*ldc] = (-0.6000294893938931*b[i + 30*ldb] + 0.04783219882870976*b[i + 31*ldb] + -0.03774132900735336*b[i + 32*ldb] + -0.1208050050634916*b[i + 33*ldb] + 0.1516896732159436*b[i + 34*ldb] + 0.3025928817647563*b[i + 35*ldb] + 0.1443793635385614*b[i + 36*ldb] + 0.02376128253747421*b[i + 37*ldb] + -0.3142121016181042*b[i + 38*ldb] + 1.402532525197397*b[i + 39*ldb]);
        c[i + 51*ldc] = (-0.00931763715572317*b[i + 30*ldb] + 1.3076436072264*b[i + 31*ldb] + 0.0190921505595041*b[i + 32*ldb] + -0.08480139426291668*b[i + 33*ldb] + -0.08035417718870008*b[i + 34*ldb] + 0.3139569161048014*b[i + 35*ldb] + -0.01360123306753975*b[i + 36*ldb] + 0.01069077635493623*b[i + 37*ldb] + -0.668898792282742*b[i + 38*ldb] + 0.20558978371198*b[i + 39*ldb]);
        c[i + 52*ldc] = (-0.00931763715572317*b[i + 0*ldb] + 0.0190921505595041*b[i + 1*ldb] + -0.08480139426291668*b[i + 2*ldb] + 1.3076436072264*b[i + 3*ldb] + -0.01360123306753975*b[i + 4*ldb] + 0.20558978371198*b[i + 5*ldb] + -0.668898792282742*b[i + 6*ldb] + 0.3139569161048014*b[i + 7*ldb] + -0.08035417718870008*b[i + 8*ldb] + 0.01069077635493623*b[i + 9*ldb]);
        c[i + 53*ldc] = (-0.6000294893938931*b[i + 0*ldb] + -0.03774132900735336*b[i + 1*ldb] + -0.1208050050634916*b[i + 2*ldb] + 0.04783219882870976*b[i + 3*ldb] + 0.1443793635385614*b[i + 4*ldb] + 1.402532525197397*b[i + 5*ldb] + -0.3142121016181042*b[i + 6*ldb] + 0.3025928817647563*b[i + 7*ldb] + 0.1516896732159436*b[i + 8*ldb] + 0.02376128253747421*b[i + 9*ldb]);
        c[i + 54*ldc] = (-0.6000294893938931*b[i + 0*ldb] + 0.04783219882870976*b[i + 1*ldb] + -0.1208050050634916*b[i + 2*ldb] + -0.03774132900735336*b[i + 3*ldb] + 0.3025928817647563*b[i + 4*ldb] + 0.1516896732159436*b[i + 5*ldb] + 0.02376128253747421*b[i + 6*ldb] + 0.1443793635385614*b[i + 7*ldb] + 1.402532525197397*b[i + 8*ldb] + -0.3142121016181042*b[i + 9*ldb]);
        c[i + 55*ldc] = (-0.00931763715572317*b[i + 0*ldb] + 1.3076436072264*b[i + 1*ldb] + -0.08480139426291668*b[i + 2*ldb] + 0.0190921505595041*b[i + 3*ldb] + 0.3139569161048014*b[i + 4*ldb] + -0.08035417718870008*b[i + 5*ldb] + 0.01069077635493623*b[i + 6*ldb] + -0.01360123306753975*b[i + 7*ldb] + 0.20558978371198*b[i + 8*ldb] + -0.668898792282742*b[i + 9*ldb]);
        c[i + 56*ldc] = (-0.00931763715572317*b[i + 10*ldb] + 0.0190921505595041*b[i + 11*ldb] + -0.08480139426291668*b[i + 12*ldb] + 1.3076436072264*b[i + 13*ldb] + -0.01360123306753975*b[i + 14*ldb] + 0.20558978371198*b[i + 15*ldb] + -0.668898792282742*b[i + 16*ldb] + 0.3139569161048014*b[i + 17*ldb] + -0.08035417718870008*b[i + 18*ldb] + 0.01069077635493623*b[i + 19*ldb]);
        c[i + 57*ldc] = (-0.6000294893938931*b[i + 10*ldb] + -0.03774132900735336*b[i + 11*ldb] + -0.1208050050634916*b[i + 12*ldb] + 0.04783219882870976*b[i + 13*ldb] + 0.1443793635385614*b[i + 14*ldb] + 1.402532525197397*b[i + 15*ldb] + -0.3142121016181042*b[i + 16*ldb] + 0.3025928817647563*b[i + 17*ldb] + 0.1516896732159436*b[i + 18*ldb] + 0.02376128253747421*b[i + 19*ldb]);
        c[i + 58*ldc] = (-0.6000294893938931*b[i + 10*ldb] + 0.04783219882870976*b[i + 11*ldb] + -0.1208050050634916*b[i + 12*ldb] + -0.03774132900735336*b[i + 13*ldb] + 0.3025928817647563*b[i + 14*ldb] + 0.1516896732159436*b[i + 15*ldb] + 0.02376128253747421*b[i + 16*ldb] + 0.1443793635385614*b[i + 17*ldb] + 1.402532525197397*b[i + 18*ldb] + -0.3142121016181042*b[i + 19*ldb]);
        c[i + 59*ldc] = (-0.00931763715572317*b[i + 10*ldb] + 1.3076436072264*b[i + 11*ldb] + -0.08480139426291668*b[i + 12*ldb] + 0.0190921505595041*b[i + 13*ldb] + 0.3139569161048014*b[i + 14*ldb] + -0.08035417718870008*b[i + 15*ldb] + 0.01069077635493623*b[i + 16*ldb] + -0.01360123306753975*b[i + 17*ldb] + 0.20558978371198*b[i + 18*ldb] + -0.668898792282742*b[i + 19*ldb]);
        c[i + 60*ldc] = (-0.00931763715572317*b[i + 20*ldb] + 0.0190921505595041*b[i + 21*ldb] + -0.08480139426291668*b[i + 22*ldb] + 1.3076436072264*b[i + 23*ldb] + -0.01360123306753975*b[i + 24*ldb] + 0.20558978371198*b[i + 25*ldb] + -0.668898792282742*b[i + 26*ldb] + 0.3139569161048014*b[i + 27*ldb] + -0.08035417718870008*b[i + 28*ldb] + 0.01069077635493623*b[i + 29*ldb]);
        c[i + 61*ldc] = (-0.6000294893938931*b[i + 20*ldb] + -0.03774132900735336*b[i + 21*ldb] + -0.1208050050634916*b[i + 22*ldb] + 0.04783219882870976*b[i + 23*ldb] + 0.1443793635385614*b[i + 24*ldb] + 1.402532525197397*b[i + 25*ldb] + -0.3142121016181042*b[i + 26*ldb] + 0.3025928817647563*b[i + 27*ldb] + 0.1516896732159436*b[i + 28*ldb] + 0.02376128253747421*b[i + 29*ldb]);
        c[i + 62*ldc] = (-0.6000294893938931*b[i + 20*ldb] + 0.04783219882870976*b[i + 21*ldb] + -0.1208050050634916*b[i + 22*ldb] + -0.03774132900735336*b[i + 23*ldb] + 0.3025928817647563*b[i + 24*ldb] + 0.1516896732159436*b[i + 25*ldb] + 0.02376128253747421*b[i + 26*ldb] + 0.1443793635385614*b[i + 27*ldb] + 1.402532525197397*b[i + 28*ldb] + -0.3142121016181042*b[i + 29*ldb]);
        c[i + 63*ldc] = (-0.00931763715572317*b[i + 20*ldb] + 1.3076436072264*b[i + 21*ldb] + -0.08480139426291668*b[i + 22*ldb] + 0.0190921505595041*b[i + 23*ldb] + 0.3139569161048014*b[i + 24*ldb] + -0.08035417718870008*b[i + 25*ldb] + 0.01069077635493623*b[i + 26*ldb] + -0.01360123306753975*b[i + 27*ldb] + 0.20558978371198*b[i + 28*ldb] + -0.668898792282742*b[i + 29*ldb]);
        c[i + 64*ldc] = (-0.00931763715572317*b[i + 30*ldb] + 0.0190921505595041*b[i + 31*ldb] + -0.08480139426291668*b[i + 32*ldb] + 1.3076436072264*b[i + 33*ldb] + -0.01360123306753975*b[i + 34*ldb] + 0.20558978371198*b[i + 35*ldb] + -0.668898792282742*b[i + 36*ldb] + 0.3139569161048014*b[i + 37*ldb] + -0.08035417718870008*b[i + 38*ldb] + 0.01069077635493623*b[i + 39*ldb]);
        c[i + 65*ldc] = (-0.6000294893938931*b[i + 30*ldb] + -0.03774132900735336*b[i + 31*ldb] + -0.1208050050634916*b[i + 32*ldb] + 0.04783219882870976*b[i + 33*ldb] + 0.1443793635385614*b[i + 34*ldb] + 1.402532525197397*b[i + 35*ldb] + -0.3142121016181042*b[i + 36*ldb] + 0.3025928817647563*b[i + 37*ldb] + 0.1516896732159436*b[i + 38*ldb] + 0.02376128253747421*b[i + 39*ldb]);
        c[i + 66*ldc] = (-0.6000294893938931*b[i + 30*ldb] + 0.04783219882870976*b[i + 31*ldb] + -0.1208050050634916*b[i + 32*ldb] + -0.03774132900735336*b[i + 33*ldb] + 0.3025928817647563*b[i + 34*ldb] + 0.1516896732159436*b[i + 35*ldb] + 0.02376128253747421*b[i + 36*ldb] + 0.1443793635385614*b[i + 37*ldb] + 1.402532525197397*b[i + 38*ldb] + -0.3142121016181042*b[i + 39*ldb]);
        c[i + 67*ldc] = (-0.00931763715572317*b[i + 30*ldb] + 1.3076436072264*b[i + 31*ldb] + -0.08480139426291668*b[i + 32*ldb] + 0.0190921505595041*b[i + 33*ldb] + 0.3139569161048014*b[i + 34*ldb] + -0.08035417718870008*b[i + 35*ldb] + 0.01069077635493623*b[i + 36*ldb] + -0.01360123306753975*b[i + 37*ldb] + 0.20558978371198*b[i + 38*ldb] + -0.668898792282742*b[i + 39*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_pri_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (4.389152966531057*b[i + 0*ldb] + -0.327484862937513*b[i + 10*ldb] + -0.04597253852487309*b[i + 20*ldb] + -0.8799533874010523*b[i + 21*ldb] + -0.8799533874010523*b[i + 22*ldb] + -0.04597253852487309*b[i + 23*ldb] + -0.04597253852487309*b[i + 36*ldb] + -0.8799533874010523*b[i + 37*ldb] + -0.8799533874010523*b[i + 38*ldb] + -0.04597253852487309*b[i + 39*ldb] + -0.04597253852487309*b[i + 52*ldb] + -0.8799533874010523*b[i + 53*ldb] + -0.8799533874010523*b[i + 54*ldb] + -0.04597253852487309*b[i + 55*ldb]);
        c[i + 1*ldc] += (4.389152966531057*b[i + 1*ldb] + -0.327484862937513*b[i + 11*ldb] + -0.3585590940368028*b[i + 20*ldb] + -0.8413030105765111*b[i + 21*ldb] + -0.8413030105765111*b[i + 22*ldb] + -0.3585590940368028*b[i + 23*ldb] + 0.05630923643747009*b[i + 36*ldb] + -0.2421198530592513*b[i + 37*ldb] + 0.4559769152683339*b[i + 38*ldb] + 5.353398886950359*b[i + 39*ldb] + 0.05630923643747009*b[i + 52*ldb] + -0.2421198530592513*b[i + 53*ldb] + 0.4559769152683339*b[i + 54*ldb] + 5.353398886950359*b[i + 55*ldb]);
        c[i + 2*ldc] += (4.389152966531057*b[i + 2*ldb] + -0.327484862937513*b[i + 12*ldb] + 0.05630923643747009*b[i + 20*ldb] + -0.2421198530592513*b[i + 21*ldb] + 0.4559769152683339*b[i + 22*ldb] + 5.353398886950359*b[i + 23*ldb] + 5.353398886950359*b[i + 36*ldb] + 0.4559769152683339*b[i + 37*ldb] + -0.2421198530592513*b[i + 38*ldb] + 0.05630923643747009*b[i + 39*ldb] + -0.3585590940368028*b[i + 52*ldb] + -0.8413030105765111*b[i + 53*ldb] + -0.8413030105765111*b[i + 54*ldb] + -0.3585590940368028*b[i + 55*ldb]);
        c[i + 3*ldc] += (4.389152966531057*b[i + 3*ldb] + -0.327484862937513*b[i + 13*ldb] + 5.353398886950359*b[i + 20*ldb] + 0.4559769152683339*b[i + 21*ldb] + -0.2421198530592513*b[i + 22*ldb] + 0.05630923643747009*b[i + 23*ldb] + -0.3585590940368028*b[i + 36*ldb] + -0.8413030105765111*b[i + 37*ldb] + -0.8413030105765111*b[i + 38*ldb] + -0.3585590940368028*b[i + 39*ldb] + 5.353398886950359*b[i + 52*ldb] + 0.4559769152683339*b[i + 53*ldb] + -0.2421198530592513*b[i + 54*ldb] + 0.05630923643747009*b[i + 55*ldb]);
        c[i + 4*ldc] += (4.389152966531057*b[i + 4*ldb] + -0.327484862937513*b[i + 14*ldb] + 0.05511438251869109*b[i + 20*ldb] + 0.08108871202779089*b[i + 21*ldb] + -0.9899260824740314*b[i + 22*ldb] + -1.016549610880705*b[i + 23*ldb] + 0.365666393621057*b[i + 36*ldb] + 4.065939100421376*b[i + 37*ldb] + 0.3707740839849649*b[i + 38*ldb] + -0.1373994448117385*b[i + 39*ldb] + -0.02349353850087958*b[i + 52*ldb] + 0.324262917433938*b[i + 53*ldb] + 0.8735823541978489*b[i + 54*ldb] + 0.5003630637507921*b[i + 55*ldb]);
        c[i + 5*ldc] += (4.389152966531057*b[i + 5*ldb] + -0.327484862937513*b[i + 15*ldb] + -1.016549610880705*b[i + 20*ldb] + -0.9899260824740314*b[i + 21*ldb] + 0.08108871202779089*b[i + 22*ldb] + 0.05511438251869109*b[i + 23*ldb] + -0.02349353850087958*b[i + 36*ldb] + 0.324262917433938*b[i + 37*ldb] + 0.8735823541978489*b[i + 38*ldb] + 0.5003630637507921*b[i + 39*ldb] + 0.365666393621057*b[i + 52*ldb] + 4.065939100421376*b[i + 53*ldb] + 0.3707740839849649*b[i + 54*ldb] + -0.1373994448117385*b[i + 55*ldb]);
        c[i + 6*ldc] += (4.389152966531057*b[i + 6*ldb] + -0.327484862937513*b[i + 16*ldb] + 0.365666393621057*b[i + 20*ldb] + 4.065939100421376*b[i + 21*ldb] + 0.3707740839849649*b[i + 22*ldb] + -0.1373994448117385*b[i + 23*ldb] + 0.5003630637507921*b[i + 36*ldb] + 0.8735823541978489*b[i + 37*ldb] + 0.324262917433938*b[i + 38*ldb] + -0.02349353850087958*b[i + 39*ldb] + -1.016549610880705*b[i + 52*ldb] + -0.9899260824740314*b[i + 53*ldb] + 0.08108871202779089*b[i + 54*ldb] + 0.05511438251869109*b[i + 55*ldb]);
        c[i + 7*ldc] += (4.389152966531057*b[i + 7*ldb] + -0.327484862937513*b[i + 17*ldb] + -0.1373994448117385*b[i + 20*ldb] + 0.3707740839849649*b[i + 21*ldb] + 4.065939100421376*b[i + 22*ldb] + 0.365666393621057*b[i + 23*ldb] + -1.016549610880705*b[i + 36*ldb] + -0.9899260824740314*b[i + 37*ldb] + 0.08108871202779089*b[i + 38*ldb] + 0.05511438251869109*b[i + 39*ldb] + 0.5003630637507921*b[i + 52*ldb] + 0.8735823541978489*b[i + 53*ldb] + 0.324262917433938*b[i + 54*ldb] + -0.02349353850087958*b[i + 55*ldb]);
        c[i + 8*ldc] += (4.389152966531057*b[i + 8*ldb] + -0.327484862937513*b[i + 18*ldb] + 0.5003630637507921*b[i + 20*ldb] + 0.8735823541978489*b[i + 21*ldb] + 0.324262917433938*b[i + 22*ldb] + -0.02349353850087958*b[i + 23*ldb] + 0.05511438251869109*b[i + 36*ldb] + 0.08108871202779089*b[i + 37*ldb] + -0.9899260824740314*b[i + 38*ldb] + -1.016549610880705*b[i + 39*ldb] + -0.1373994448117385*b[i + 52*ldb] + 0.3707740839849649*b[i + 53*ldb] + 4.065939100421376*b[i + 54*ldb] + 0.365666393621057*b[i + 55*ldb]);
        c[i + 9*ldc] += (4.389152966531057*b[i + 9*ldb] + -0.327484862937513*b[i + 19*ldb] + -0.02349353850087958*b[i + 20*ldb] + 0.324262917433938*b[i + 21*ldb] + 0.8735823541978489*b[i + 22*ldb] + 0.5003630637507921*b[i + 23*ldb] + -0.1373994448117385*b[i + 36*ldb] + 0.3707740839849649*b[i + 37*ldb] + 4.065939100421376*b[i + 38*ldb] + 0.365666393621057*b[i + 39*ldb] + 0.05511438251869109*b[i + 52*ldb] + 0.08108871202779089*b[i + 53*ldb] + -0.9899260824740314*b[i + 54*ldb] + -1.016549610880705*b[i + 55*ldb]);
        c[i + 10*ldc] += (-1.247624770988926*b[i + 0*ldb] + 0.6145280959667898*b[i + 10*ldb] + -0.04597253852487309*b[i + 24*ldb] + -0.8799533874010523*b[i + 25*ldb] + -0.8799533874010523*b[i + 26*ldb] + -0.04597253852487309*b[i + 27*ldb] + -0.04597253852487309*b[i + 40*ldb] + -0.8799533874010523*b[i + 41*ldb] + -0.8799533874010523*b[i + 42*ldb] + -0.04597253852487309*b[i + 43*ldb] + -0.04597253852487309*b[i + 56*ldb] + -0.8799533874010523*b[i + 57*ldb] + -0.8799533874010523*b[i + 58*ldb] + -0.04597253852487309*b[i + 59*ldb]);
        c[i + 11*ldc] += (-1.247624770988926*b[i + 1*ldb] + 0.6145280959667898*b[i + 11*ldb] + -0.3585590940368028*b[i + 24*ldb] + -0.8413030105765111*b[i + 25*ldb] + -0.8413030105765111*b[i + 26*ldb] + -0.3585590940368028*b[i + 27*ldb] + 0.05630923643747009*b[i + 40*ldb] + -0.2421198530592513*b[i + 41*ldb] + 0.4559769152683339*b[i + 42*ldb] + 5.353398886950359*b[i + 43*ldb] + 0.05630923643747009*b[i + 56*ldb] + -0.2421198530592513*b[i + 57*ldb] + 0.4559769152683339*b[i + 58*ldb] + 5.353398886950359*b[i + 59*ldb]);
        c[i + 12*ldc] += (-1.247624770988926*b[i + 2*ldb] + 0.6145280959667898*b[i + 12*ldb] + 0.05630923643747009*b[i + 24*ldb] + -0.2421198530592513*b[i + 25*ldb] + 0.4559769152683339*b[i + 26*ldb] + 5.353398886950359*b[i + 27*ldb] + 5.353398886950359*b[i + 40*ldb] + 0.4559769152683339*b[i + 41*ldb] + -0.2421198530592513*b[i + 42*ldb] + 0.05630923643747009*b[i + 43*ldb] + -0.3585590940368028*b[i + 56*ldb] + -0.8413030105765111*b[i + 57*ldb] + -0.8413030105765111*b[i + 58*ldb] + -0.3585590940368028*b[i + 59*ldb]);
        c[i + 13*ldc] += (-1.247624770988926*b[i + 3*ldb] + 0.6145280959667898*b[i + 13*ldb] + 5.353398886950359*b[i + 24*ldb] + 0.4559769152683339*b[i + 25*ldb] + -0.2421198530592513*b[i + 26*ldb] + 0.05630923643747009*b[i + 27*ldb] + -0.3585590940368028*b[i + 40*ldb] + -0.8413030105765111*b[i + 41*ldb] + -0.8413030105765111*b[i + 42*ldb] + -0.3585590940368028*b[i + 43*ldb] + 5.353398886950359*b[i + 56*ldb] + 0.4559769152683339*b[i + 57*ldb] + -0.2421198530592513*b[i + 58*ldb] + 0.05630923643747009*b[i + 59*ldb]);
        c[i + 14*ldc] += (-1.247624770988926*b[i + 4*ldb] + 0.6145280959667898*b[i + 14*ldb] + 0.05511438251869109*b[i + 24*ldb] + 0.08108871202779089*b[i + 25*ldb] + -0.9899260824740314*b[i + 26*ldb] + -1.016549610880705*b[i + 27*ldb] + 0.365666393621057*b[i + 40*ldb] + 4.065939100421376*b[i + 41*ldb] + 0.3707740839849649*b[i + 42*ldb] + -0.1373994448117385*b[i + 43*ldb] + -0.02349353850087958*b[i + 56*ldb] + 0.324262917433938*b[i + 57*ldb] + 0.8735823541978489*b[i + 58*ldb] + 0.5003630637507921*b[i + 59*ldb]);
        c[i + 15*ldc] += (-1.247624770988926*b[i + 5*ldb] + 0.6145280959667898*b[i + 15*ldb] + -1.016549610880705*b[i + 24*ldb] + -0.9899260824740314*b[i + 25*ldb] + 0.08108871202779089*b[i + 26*ldb] + 0.05511438251869109*b[i + 27*ldb] + -0.02349353850087958*b[i + 40*ldb] + 0.324262917433938*b[i + 41*ldb] + 0.8735823541978489*b[i + 42*ldb] + 0.5003630637507921*b[i + 43*ldb] + 0.365666393621057*b[i + 56*ldb] + 4.065939100421376*b[i + 57*ldb] + 0.3707740839849649*b[i + 58*ldb] + -0.1373994448117385*b[i + 59*ldb]);
        c[i + 16*ldc] += (-1.247624770988926*b[i + 6*ldb] + 0.6145280959667898*b[i + 16*ldb] + 0.365666393621057*b[i + 24*ldb] + 4.065939100421376*b[i + 25*ldb] + 0.3707740839849649*b[i + 26*ldb] + -0.1373994448117385*b[i + 27*ldb] + 0.5003630637507921*b[i + 40*ldb] + 0.8735823541978489*b[i + 41*ldb] + 0.324262917433938*b[i + 42*ldb] + -0.02349353850087958*b[i + 43*ldb] + -1.016549610880705*b[i + 56*ldb] + -0.9899260824740314*b[i + 57*ldb] + 0.08108871202779089*b[i + 58*ldb] + 0.05511438251869109*b[i + 59*ldb]);
        c[i + 17*ldc] += (-1.247624770988926*b[i + 7*ldb] + 0.6145280959667898*b[i + 17*ldb] + -0.1373994448117385*b[i + 24*ldb] + 0.3707740839849649*b[i + 25*ldb] + 4.065939100421376*b[i + 26*ldb] + 0.365666393621057*b[i + 27*ldb] + -1.016549610880705*b[i + 40*ldb] + -0.9899260824740314*b[i + 41*ldb] + 0.08108871202779089*b[i + 42*ldb] + 0.05511438251869109*b[i + 43*ldb] + 0.5003630637507921*b[i + 56*ldb] + 0.8735823541978489*b[i + 57*ldb] + 0.324262917433938*b[i + 58*ldb] + -0.02349353850087958*b[i + 59*ldb]);
        c[i + 18*ldc] += (-1.247624770988926*b[i + 8*ldb] + 0.6145280959667898*b[i + 18*ldb] + 0.5003630637507921*b[i + 24*ldb] + 0.8735823541978489*b[i + 25*ldb] + 0.324262917433938*b[i + 26*ldb] + -0.02349353850087958*b[i + 27*ldb] + 0.05511438251869109*b[i + 40*ldb] + 0.08108871202779089*b[i + 41*ldb] + -0.9899260824740314*b[i + 42*ldb] + -1.016549610880705*b[i + 43*ldb] + -0.1373994448117385*b[i + 56*ldb] + 0.3707740839849649*b[i + 57*ldb] + 4.065939100421376*b[i + 58*ldb] + 0.365666393621057*b[i + 59*ldb]);
        c[i + 19*ldc] += (-1.247624770988926*b[i + 9*ldb] + 0.6145280959667898*b[i + 19*ldb] + -0.02349353850087958*b[i + 24*ldb] + 0.324262917433938*b[i + 25*ldb] + 0.8735823541978489*b[i + 26*ldb] + 0.5003630637507921*b[i + 27*ldb] + -0.1373994448117385*b[i + 40*ldb] + 0.3707740839849649*b[i + 41*ldb] + 4.065939100421376*b[i + 42*ldb] + 0.365666393621057*b[i + 43*ldb] + 0.05511438251869109*b[i + 56*ldb] + 0.08108871202779089*b[i + 57*ldb] + -0.9899260824740314*b[i + 58*ldb] + -1.016549610880705*b[i + 59*ldb]);
        c[i + 20*ldc] += (0.6145280959667898*b[i + 0*ldb] + -1.247624770988926*b[i + 10*ldb] + -0.04597253852487309*b[i + 28*ldb] + -0.8799533874010523*b[i + 29*ldb] + -0.8799533874010523*b[i + 30*ldb] + -0.04597253852487309*b[i + 31*ldb] + -0.04597253852487309*b[i + 44*ldb] + -0.8799533874010523*b[i + 45*ldb] + -0.8799533874010523*b[i + 46*ldb] + -0.04597253852487309*b[i + 47*ldb] + -0.04597253852487309*b[i + 60*ldb] + -0.8799533874010523*b[i + 61*ldb] + -0.8799533874010523*b[i + 62*ldb] + -0.04597253852487309*b[i + 63*ldb]);
        c[i + 21*ldc] += (0.6145280959667898*b[i + 1*ldb] + -1.247624770988926*b[i + 11*ldb] + -0.3585590940368028*b[i + 28*ldb] + -0.8413030105765111*b[i + 29*ldb] + -0.8413030105765111*b[i + 30*ldb] + -0.3585590940368028*b[i + 31*ldb] + 0.05630923643747009*b[i + 44*ldb] + -0.2421198530592513*b[i + 45*ldb] + 0.4559769152683339*b[i + 46*ldb] + 5.353398886950359*b[i + 47*ldb] + 0.05630923643747009*b[i + 60*ldb] + -0.2421198530592513*b[i + 61*ldb] + 0.4559769152683339*b[i + 62*ldb] + 5.353398886950359*b[i + 63*ldb]);
        c[i + 22*ldc] += (0.6145280959667898*b[i + 2*ldb] + -1.247624770988926*b[i + 12*ldb] + 0.05630923643747009*b[i + 28*ldb] + -0.2421198530592513*b[i + 29*ldb] + 0.4559769152683339*b[i + 30*ldb] + 5.353398886950359*b[i + 31*ldb] + 5.353398886950359*b[i + 44*ldb] + 0.4559769152683339*b[i + 45*ldb] + -0.2421198530592513*b[i + 46*ldb] + 0.05630923643747009*b[i + 47*ldb] + -0.3585590940368028*b[i + 60*ldb] + -0.8413030105765111*b[i + 61*ldb] + -0.8413030105765111*b[i + 62*ldb] + -0.3585590940368028*b[i + 63*ldb]);
        c[i + 23*ldc] += (0.6145280959667898*b[i + 3*ldb] + -1.247624770988926*b[i + 13*ldb] + 5.353398886950359*b[i + 28*ldb] + 0.4559769152683339*b[i + 29*ldb] + -0.2421198530592513*b[i + 30*ldb] + 0.05630923643747009*b[i + 31*ldb] + -0.3585590940368028*b[i + 44*ldb] + -0.8413030105765111*b[i + 45*ldb] + -0.8413030105765111*b[i + 46*ldb] + -0.3585590940368028*b[i + 47*ldb] + 5.353398886950359*b[i + 60*ldb] + 0.4559769152683339*b[i + 61*ldb] + -0.2421198530592513*b[i + 62*ldb] + 0.05630923643747009*b[i + 63*ldb]);
        c[i + 24*ldc] += (0.6145280959667898*b[i + 4*ldb] + -1.247624770988926*b[i + 14*ldb] + 0.05511438251869109*b[i + 28*ldb] + 0.08108871202779089*b[i + 29*ldb] + -0.9899260824740314*b[i + 30*ldb] + -1.016549610880705*b[i + 31*ldb] + 0.365666393621057*b[i + 44*ldb] + 4.065939100421376*b[i + 45*ldb] + 0.3707740839849649*b[i + 46*ldb] + -0.1373994448117385*b[i + 47*ldb] + -0.02349353850087958*b[i + 60*ldb] + 0.324262917433938*b[i + 61*ldb] + 0.8735823541978489*b[i + 62*ldb] + 0.5003630637507921*b[i + 63*ldb]);
        c[i + 25*ldc] += (0.6145280959667898*b[i + 5*ldb] + -1.247624770988926*b[i + 15*ldb] + -1.016549610880705*b[i + 28*ldb] + -0.9899260824740314*b[i + 29*ldb] + 0.08108871202779089*b[i + 30*ldb] + 0.05511438251869109*b[i + 31*ldb] + -0.02349353850087958*b[i + 44*ldb] + 0.324262917433938*b[i + 45*ldb] + 0.8735823541978489*b[i + 46*ldb] + 0.5003630637507921*b[i + 47*ldb] + 0.365666393621057*b[i + 60*ldb] + 4.065939100421376*b[i + 61*ldb] + 0.3707740839849649*b[i + 62*ldb] + -0.1373994448117385*b[i + 63*ldb]);
        c[i + 26*ldc] += (0.6145280959667898*b[i + 6*ldb] + -1.247624770988926*b[i + 16*ldb] + 0.365666393621057*b[i + 28*ldb] + 4.065939100421376*b[i + 29*ldb] + 0.3707740839849649*b[i + 30*ldb] + -0.1373994448117385*b[i + 31*ldb] + 0.5003630637507921*b[i + 44*ldb] + 0.8735823541978489*b[i + 45*ldb] + 0.324262917433938*b[i + 46*ldb] + -0.02349353850087958*b[i + 47*ldb] + -1.016549610880705*b[i + 60*ldb] + -0.9899260824740314*b[i + 61*ldb] + 0.08108871202779089*b[i + 62*ldb] + 0.05511438251869109*b[i + 63*ldb]);
        c[i + 27*ldc] += (0.6145280959667898*b[i + 7*ldb] + -1.247624770988926*b[i + 17*ldb] + -0.1373994448117385*b[i + 28*ldb] + 0.3707740839849649*b[i + 29*ldb] + 4.065939100421376*b[i + 30*ldb] + 0.365666393621057*b[i + 31*ldb] + -1.016549610880705*b[i + 44*ldb] + -0.9899260824740314*b[i + 45*ldb] + 0.08108871202779089*b[i + 46*ldb] + 0.05511438251869109*b[i + 47*ldb] + 0.5003630637507921*b[i + 60*ldb] + 0.8735823541978489*b[i + 61*ldb] + 0.324262917433938*b[i + 62*ldb] + -0.02349353850087958*b[i + 63*ldb]);
        c[i + 28*ldc] += (0.6145280959667898*b[i + 8*ldb] + -1.247624770988926*b[i + 18*ldb] + 0.5003630637507921*b[i + 28*ldb] + 0.8735823541978489*b[i + 29*ldb] + 0.324262917433938*b[i + 30*ldb] + -0.02349353850087958*b[i + 31*ldb] + 0.05511438251869109*b[i + 44*ldb] + 0.08108871202779089*b[i + 45*ldb] + -0.9899260824740314*b[i + 46*ldb] + -1.016549610880705*b[i + 47*ldb] + -0.1373994448117385*b[i + 60*ldb] + 0.3707740839849649*b[i + 61*ldb] + 4.065939100421376*b[i + 62*ldb] + 0.365666393621057*b[i + 63*ldb]);
        c[i + 29*ldc] += (0.6145280959667898*b[i + 9*ldb] + -1.247624770988926*b[i + 19*ldb] + -0.02349353850087958*b[i + 28*ldb] + 0.324262917433938*b[i + 29*ldb] + 0.8735823541978489*b[i + 30*ldb] + 0.5003630637507921*b[i + 31*ldb] + -0.1373994448117385*b[i + 44*ldb] + 0.3707740839849649*b[i + 45*ldb] + 4.065939100421376*b[i + 46*ldb] + 0.365666393621057*b[i + 47*ldb] + 0.05511438251869109*b[i + 60*ldb] + 0.08108871202779089*b[i + 61*ldb] + -0.9899260824740314*b[i + 62*ldb] + -1.016549610880705*b[i + 63*ldb]);
        c[i + 30*ldc] += (-0.327484862937513*b[i + 0*ldb] + 4.389152966531057*b[i + 10*ldb] + -0.04597253852487309*b[i + 32*ldb] + -0.8799533874010523*b[i + 33*ldb] + -0.8799533874010523*b[i + 34*ldb] + -0.04597253852487309*b[i + 35*ldb] + -0.04597253852487309*b[i + 48*ldb] + -0.8799533874010523*b[i + 49*ldb] + -0.8799533874010523*b[i + 50*ldb] + -0.04597253852487309*b[i + 51*ldb] + -0.04597253852487309*b[i + 64*ldb] + -0.8799533874010523*b[i + 65*ldb] + -0.8799533874010523*b[i + 66*ldb] + -0.04597253852487309*b[i + 67*ldb]);
        c[i + 31*ldc] += (-0.327484862937513*b[i + 1*ldb] + 4.389152966531057*b[i + 11*ldb] + -0.3585590940368028*b[i + 32*ldb] + -0.8413030105765111*b[i + 33*ldb] + -0.8413030105765111*b[i + 34*ldb] + -0.3585590940368028*b[i + 35*ldb] + 0.05630923643747009*b[i + 48*ldb] + -0.2421198530592513*b[i + 49*ldb] + 0.4559769152683339*b[i + 50*ldb] + 5.353398886950359*b[i + 51*ldb] + 0.05630923643747009*b[i + 64*ldb] + -0.2421198530592513*b[i + 65*ldb] + 0.4559769152683339*b[i + 66*ldb] + 5.353398886950359*b[i + 67*ldb]);
        c[i + 32*ldc] += (-0.327484862937513*b[i + 2*ldb] + 4.389152966531057*b[i + 12*ldb] + 0.05630923643747009*b[i + 32*ldb] + -0.2421198530592513*b[i + 33*ldb] + 0.4559769152683339*b[i + 34*ldb] + 5.353398886950359*b[i + 35*ldb] + 5.353398886950359*b[i + 48*ldb] + 0.4559769152683339*b[i + 49*ldb] + -0.2421198530592513*b[i + 50*ldb] + 0.05630923643747009*b[i + 51*ldb] + -0.3585590940368028*b[i + 64*ldb] + -0.8413030105765111*b[i + 65*ldb] + -0.8413030105765111*b[i + 66*ldb] + -0.3585590940368028*b[i + 67*ldb]);
        c[i + 33*ldc] += (-0.327484862937513*b[i + 3*ldb] + 4.389152966531057*b[i + 13*ldb] + 5.353398886950359*b[i + 32*ldb] + 0.4559769152683339*b[i + 33*ldb] + -0.2421198530592513*b[i + 34*ldb] + 0.05630923643747009*b[i + 35*ldb] + -0.3585590940368028*b[i + 48*ldb] + -0.8413030105765111*b[i + 49*ldb] + -0.8413030105765111*b[i + 50*ldb] + -0.3585590940368028*b[i + 51*ldb] + 5.353398886950359*b[i + 64*ldb] + 0.4559769152683339*b[i + 65*ldb] + -0.2421198530592513*b[i + 66*ldb] + 0.05630923643747009*b[i + 67*ldb]);
        c[i + 34*ldc] += (-0.327484862937513*b[i + 4*ldb] + 4.389152966531057*b[i + 14*ldb] + 0.05511438251869109*b[i + 32*ldb] + 0.08108871202779089*b[i + 33*ldb] + -0.9899260824740314*b[i + 34*ldb] + -1.016549610880705*b[i + 35*ldb] + 0.365666393621057*b[i + 48*ldb] + 4.065939100421376*b[i + 49*ldb] + 0.3707740839849649*b[i + 50*ldb] + -0.1373994448117385*b[i + 51*ldb] + -0.02349353850087958*b[i + 64*ldb] + 0.324262917433938*b[i + 65*ldb] + 0.8735823541978489*b[i + 66*ldb] + 0.5003630637507921*b[i + 67*ldb]);
        c[i + 35*ldc] += (-0.327484862937513*b[i + 5*ldb] + 4.389152966531057*b[i + 15*ldb] + -1.016549610880705*b[i + 32*ldb] + -0.9899260824740314*b[i + 33*ldb] + 0.08108871202779089*b[i + 34*ldb] + 0.05511438251869109*b[i + 35*ldb] + -0.02349353850087958*b[i + 48*ldb] + 0.324262917433938*b[i + 49*ldb] + 0.8735823541978489*b[i + 50*ldb] + 0.5003630637507921*b[i + 51*ldb] + 0.365666393621057*b[i + 64*ldb] + 4.065939100421376*b[i + 65*ldb] + 0.3707740839849649*b[i + 66*ldb] + -0.1373994448117385*b[i + 67*ldb]);
        c[i + 36*ldc] += (-0.327484862937513*b[i + 6*ldb] + 4.389152966531057*b[i + 16*ldb] + 0.365666393621057*b[i + 32*ldb] + 4.065939100421376*b[i + 33*ldb] + 0.3707740839849649*b[i + 34*ldb] + -0.1373994448117385*b[i + 35*ldb] + 0.5003630637507921*b[i + 48*ldb] + 0.8735823541978489*b[i + 49*ldb] + 0.324262917433938*b[i + 50*ldb] + -0.02349353850087958*b[i + 51*ldb] + -1.016549610880705*b[i + 64*ldb] + -0.9899260824740314*b[i + 65*ldb] + 0.08108871202779089*b[i + 66*ldb] + 0.05511438251869109*b[i + 67*ldb]);
        c[i + 37*ldc] += (-0.327484862937513*b[i + 7*ldb] + 4.389152966531057*b[i + 17*ldb] + -0.1373994448117385*b[i + 32*ldb] + 0.3707740839849649*b[i + 33*ldb] + 4.065939100421376*b[i + 34*ldb] + 0.365666393621057*b[i + 35*ldb] + -1.016549610880705*b[i + 48*ldb] + -0.9899260824740314*b[i + 49*ldb] + 0.08108871202779089*b[i + 50*ldb] + 0.05511438251869109*b[i + 51*ldb] + 0.5003630637507921*b[i + 64*ldb] + 0.8735823541978489*b[i + 65*ldb] + 0.324262917433938*b[i + 66*ldb] + -0.02349353850087958*b[i + 67*ldb]);
        c[i + 38*ldc] += (-0.327484862937513*b[i + 8*ldb] + 4.389152966531057*b[i + 18*ldb] + 0.5003630637507921*b[i + 32*ldb] + 0.8735823541978489*b[i + 33*ldb] + 0.324262917433938*b[i + 34*ldb] + -0.02349353850087958*b[i + 35*ldb] + 0.05511438251869109*b[i + 48*ldb] + 0.08108871202779089*b[i + 49*ldb] + -0.9899260824740314*b[i + 50*ldb] + -1.016549610880705*b[i + 51*ldb] + -0.1373994448117385*b[i + 64*ldb] + 0.3707740839849649*b[i + 65*ldb] + 4.065939100421376*b[i + 66*ldb] + 0.365666393621057*b[i + 67*ldb]);
        c[i + 39*ldc] += (-0.327484862937513*b[i + 9*ldb] + 4.389152966531057*b[i + 19*ldb] + -0.02349353850087958*b[i + 32*ldb] + 0.324262917433938*b[i + 33*ldb] + 0.8735823541978489*b[i + 34*ldb] + 0.5003630637507921*b[i + 35*ldb] + -0.1373994448117385*b[i + 48*ldb] + 0.3707740839849649*b[i + 49*ldb] + 4.065939100421376*b[i + 50*ldb] + 0.365666393621057*b[i + 51*ldb] + 0.05511438251869109*b[i + 64*ldb] + 0.08108871202779089*b[i + 65*ldb] + -0.9899260824740314*b[i + 66*ldb] + -1.016549610880705*b[i + 67*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_pri_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (-0.04597253852487312*b[i + 36*ldb] + -0.8799533874010523*b[i + 37*ldb] + -0.8799533874010523*b[i + 38*ldb] + -0.04597253852487312*b[i + 39*ldb] + 0.04597253852487312*b[i + 52*ldb] + 0.8799533874010523*b[i + 53*ldb] + 0.8799533874010523*b[i + 54*ldb] + 0.04597253852487312*b[i + 55*ldb]);
        c[i + 1*ldc] += (0.05630923643747005*b[i + 36*ldb] + -0.2421198530592513*b[i + 37*ldb] + 0.4559769152683337*b[i + 38*ldb] + 5.353398886950359*b[i + 39*ldb] + -0.05630923643747005*b[i + 52*ldb] + 0.2421198530592513*b[i + 53*ldb] + -0.4559769152683337*b[i + 54*ldb] + -5.353398886950359*b[i + 55*ldb]);
        c[i + 2*ldc] += (5.353398886950359*b[i + 36*ldb] + 0.4559769152683337*b[i + 37*ldb] + -0.2421198530592513*b[i + 38*ldb] + 0.05630923643747005*b[i + 39*ldb] + 0.3585590940368028*b[i + 52*ldb] + 0.8413030105765111*b[i + 53*ldb] + 0.8413030105765111*b[i + 54*ldb] + 0.3585590940368028*b[i + 55*ldb]);
        c[i + 3*ldc] += (-0.3585590940368028*b[i + 36*ldb] + -0.8413030105765111*b[i + 37*ldb] + -0.8413030105765111*b[i + 38*ldb] + -0.3585590940368028*b[i + 39*ldb] + -5.353398886950359*b[i + 52*ldb] + -0.4559769152683337*b[i + 53*ldb] + 0.2421198530592513*b[i + 54*ldb] + -0.05630923643747005*b[i + 55*ldb]);
        c[i + 4*ldc] += (0.365666393621057*b[i + 36*ldb] + 4.065939100421376*b[i + 37*ldb] + 0.370774083984965*b[i + 38*ldb] + -0.1373994448117385*b[i + 39*ldb] + 0.02349353850087958*b[i + 52*ldb] + -0.3242629174339381*b[i + 53*ldb] + -0.8735823541978489*b[i + 54*ldb] + -0.5003630637507921*b[i + 55*ldb]);
        c[i + 5*ldc] += (-0.02349353850087958*b[i + 36*ldb] + 0.3242629174339381*b[i + 37*ldb] + 0.8735823541978489*b[i + 38*ldb] + 0.5003630637507921*b[i + 39*ldb] + -0.365666393621057*b[i + 52*ldb] + -4.065939100421376*b[i + 53*ldb] + -0.370774083984965*b[i + 54*ldb] + 0.1373994448117385*b[i + 55*ldb]);
        c[i + 6*ldc] += (0.5003630637507921*b[i + 36*ldb] + 0.8735823541978489*b[i + 37*ldb] + 0.3242629174339381*b[i + 38*ldb] + -0.02349353850087958*b[i + 39*ldb] + 1.016549610880705*b[i + 52*ldb] + 0.9899260824740314*b[i + 53*ldb] + -0.08108871202779085*b[i + 54*ldb] + -0.05511438251869109*b[i + 55*ldb]);
        c[i + 7*ldc] += (-1.016549610880705*b[i + 36*ldb] + -0.9899260824740314*b[i + 37*ldb] + 0.08108871202779085*b[i + 38*ldb] + 0.05511438251869109*b[i + 39*ldb] + -0.5003630637507921*b[i + 52*ldb] + -0.8735823541978489*b[i + 53*ldb] + -0.3242629174339381*b[i + 54*ldb] + 0.02349353850087958*b[i + 55*ldb]);
        c[i + 8*ldc] += (0.05511438251869109*b[i + 36*ldb] + 0.08108871202779085*b[i + 37*ldb] + -0.9899260824740314*b[i + 38*ldb] + -1.016549610880705*b[i + 39*ldb] + 0.1373994448117385*b[i + 52*ldb] + -0.370774083984965*b[i + 53*ldb] + -4.065939100421376*b[i + 54*ldb] + -0.365666393621057*b[i + 55*ldb]);
        c[i + 9*ldc] += (-0.1373994448117385*b[i + 36*ldb] + 0.370774083984965*b[i + 37*ldb] + 4.065939100421376*b[i + 38*ldb] + 0.365666393621057*b[i + 39*ldb] + -0.05511438251869109*b[i + 52*ldb] + -0.08108871202779085*b[i + 53*ldb] + 0.9899260824740314*b[i + 54*ldb] + 1.016549610880705*b[i + 55*ldb]);
        c[i + 10*ldc] += (-0.04597253852487312*b[i + 40*ldb] + -0.8799533874010523*b[i + 41*ldb] + -0.8799533874010523*b[i + 42*ldb] + -0.04597253852487312*b[i + 43*ldb] + 0.04597253852487312*b[i + 56*ldb] + 0.8799533874010523*b[i + 57*ldb] + 0.8799533874010523*b[i + 58*ldb] + 0.04597253852487312*b[i + 59*ldb]);
        c[i + 11*ldc] += (0.05630923643747005*b[i + 40*ldb] + -0.2421198530592513*b[i + 41*ldb] + 0.4559769152683337*b[i + 42*ldb] + 5.353398886950359*b[i + 43*ldb] + -0.05630923643747005*b[i + 56*ldb] + 0.2421198530592513*b[i + 57*ldb] + -0.4559769152683337*b[i + 58*ldb] + -5.353398886950359*b[i + 59*ldb]);
        c[i + 12*ldc] += (5.353398886950359*b[i + 40*ldb] + 0.4559769152683337*b[i + 41*ldb] + -0.2421198530592513*b[i + 42*ldb] + 0.05630923643747005*b[i + 43*ldb] + 0.3585590940368028*b[i + 56*ldb] + 0.8413030105765111*b[i + 57*ldb] + 0.8413030105765111*b[i + 58*ldb] + 0.3585590940368028*b[i + 59*ldb]);
        c[i + 13*ldc] += (-0.3585590940368028*b[i + 40*ldb] + -0.8413030105765111*b[i + 41*ldb] + -0.8413030105765111*b[i + 42*ldb] + -0.3585590940368028*b[i + 43*ldb] + -5.353398886950359*b[i + 56*ldb] + -0.4559769152683337*b[i + 57*ldb] + 0.2421198530592513*b[i + 58*ldb] + -0.05630923643747005*b[i + 59*ldb]);
        c[i + 14*ldc] += (0.365666393621057*b[i + 40*ldb] + 4.065939100421376*b[i + 41*ldb] + 0.370774083984965*b[i + 42*ldb] + -0.1373994448117385*b[i + 43*ldb] + 0.02349353850087958*b[i + 56*ldb] + -0.3242629174339381*b[i + 57*ldb] + -0.8735823541978489*b[i + 58*ldb] + -0.5003630637507921*b[i + 59*ldb]);
        c[i + 15*ldc] += (-0.02349353850087958*b[i + 40*ldb] + 0.3242629174339381*b[i + 41*ldb] + 0.8735823541978489*b[i + 42*ldb] + 0.5003630637507921*b[i + 43*ldb] + -0.365666393621057*b[i + 56*ldb] + -4.065939100421376*b[i + 57*ldb] + -0.370774083984965*b[i + 58*ldb] + 0.1373994448117385*b[i + 59*ldb]);
        c[i + 16*ldc] += (0.5003630637507921*b[i + 40*ldb] + 0.8735823541978489*b[i + 41*ldb] + 0.3242629174339381*b[i + 42*ldb] + -0.02349353850087958*b[i + 43*ldb] + 1.016549610880705*b[i + 56*ldb] + 0.9899260824740314*b[i + 57*ldb] + -0.08108871202779085*b[i + 58*ldb] + -0.05511438251869109*b[i + 59*ldb]);
        c[i + 17*ldc] += (-1.016549610880705*b[i + 40*ldb] + -0.9899260824740314*b[i + 41*ldb] + 0.08108871202779085*b[i + 42*ldb] + 0.05511438251869109*b[i + 43*ldb] + -0.5003630637507921*b[i + 56*ldb] + -0.8735823541978489*b[i + 57*ldb] + -0.3242629174339381*b[i + 58*ldb] + 0.02349353850087958*b[i + 59*ldb]);
        c[i + 18*ldc] += (0.05511438251869109*b[i + 40*ldb] + 0.08108871202779085*b[i + 41*ldb] + -0.9899260824740314*b[i + 42*ldb] + -1.016549610880705*b[i + 43*ldb] + 0.1373994448117385*b[i + 56*ldb] + -0.370774083984965*b[i + 57*ldb] + -4.065939100421376*b[i + 58*ldb] + -0.365666393621057*b[i + 59*ldb]);
        c[i + 19*ldc] += (-0.1373994448117385*b[i + 40*ldb] + 0.370774083984965*b[i + 41*ldb] + 4.065939100421376*b[i + 42*ldb] + 0.365666393621057*b[i + 43*ldb] + -0.05511438251869109*b[i + 56*ldb] + -0.08108871202779085*b[i + 57*ldb] + 0.9899260824740314*b[i + 58*ldb] + 1.016549610880705*b[i + 59*ldb]);
        c[i + 20*ldc] += (-0.04597253852487312*b[i + 44*ldb] + -0.8799533874010523*b[i + 45*ldb] + -0.8799533874010523*b[i + 46*ldb] + -0.04597253852487312*b[i + 47*ldb] + 0.04597253852487312*b[i + 60*ldb] + 0.8799533874010523*b[i + 61*ldb] + 0.8799533874010523*b[i + 62*ldb] + 0.04597253852487312*b[i + 63*ldb]);
        c[i + 21*ldc] += (0.05630923643747005*b[i + 44*ldb] + -0.2421198530592513*b[i + 45*ldb] + 0.4559769152683337*b[i + 46*ldb] + 5.353398886950359*b[i + 47*ldb] + -0.05630923643747005*b[i + 60*ldb] + 0.2421198530592513*b[i + 61*ldb] + -0.4559769152683337*b[i + 62*ldb] + -5.353398886950359*b[i + 63*ldb]);
        c[i + 22*ldc] += (5.353398886950359*b[i + 44*ldb] + 0.4559769152683337*b[i + 45*ldb] + -0.2421198530592513*b[i + 46*ldb] + 0.05630923643747005*b[i + 47*ldb] + 0.3585590940368028*b[i + 60*ldb] + 0.8413030105765111*b[i + 61*ldb] + 0.8413030105765111*b[i + 62*ldb] + 0.3585590940368028*b[i + 63*ldb]);
        c[i + 23*ldc] += (-0.3585590940368028*b[i + 44*ldb] + -0.8413030105765111*b[i + 45*ldb] + -0.8413030105765111*b[i + 46*ldb] + -0.3585590940368028*b[i + 47*ldb] + -5.353398886950359*b[i + 60*ldb] + -0.4559769152683337*b[i + 61*ldb] + 0.2421198530592513*b[i + 62*ldb] + -0.05630923643747005*b[i + 63*ldb]);
        c[i + 24*ldc] += (0.365666393621057*b[i + 44*ldb] + 4.065939100421376*b[i + 45*ldb] + 0.370774083984965*b[i + 46*ldb] + -0.1373994448117385*b[i + 47*ldb] + 0.02349353850087958*b[i + 60*ldb] + -0.3242629174339381*b[i + 61*ldb] + -0.8735823541978489*b[i + 62*ldb] + -0.5003630637507921*b[i + 63*ldb]);
        c[i + 25*ldc] += (-0.02349353850087958*b[i + 44*ldb] + 0.3242629174339381*b[i + 45*ldb] + 0.8735823541978489*b[i + 46*ldb] + 0.5003630637507921*b[i + 47*ldb] + -0.365666393621057*b[i + 60*ldb] + -4.065939100421376*b[i + 61*ldb] + -0.370774083984965*b[i + 62*ldb] + 0.1373994448117385*b[i + 63*ldb]);
        c[i + 26*ldc] += (0.5003630637507921*b[i + 44*ldb] + 0.8735823541978489*b[i + 45*ldb] + 0.3242629174339381*b[i + 46*ldb] + -0.02349353850087958*b[i + 47*ldb] + 1.016549610880705*b[i + 60*ldb] + 0.9899260824740314*b[i + 61*ldb] + -0.08108871202779085*b[i + 62*ldb] + -0.05511438251869109*b[i + 63*ldb]);
        c[i + 27*ldc] += (-1.016549610880705*b[i + 44*ldb] + -0.9899260824740314*b[i + 45*ldb] + 0.08108871202779085*b[i + 46*ldb] + 0.05511438251869109*b[i + 47*ldb] + -0.5003630637507921*b[i + 60*ldb] + -0.8735823541978489*b[i + 61*ldb] + -0.3242629174339381*b[i + 62*ldb] + 0.02349353850087958*b[i + 63*ldb]);
        c[i + 28*ldc] += (0.05511438251869109*b[i + 44*ldb] + 0.08108871202779085*b[i + 45*ldb] + -0.9899260824740314*b[i + 46*ldb] + -1.016549610880705*b[i + 47*ldb] + 0.1373994448117385*b[i + 60*ldb] + -0.370774083984965*b[i + 61*ldb] + -4.065939100421376*b[i + 62*ldb] + -0.365666393621057*b[i + 63*ldb]);
        c[i + 29*ldc] += (-0.1373994448117385*b[i + 44*ldb] + 0.370774083984965*b[i + 45*ldb] + 4.065939100421376*b[i + 46*ldb] + 0.365666393621057*b[i + 47*ldb] + -0.05511438251869109*b[i + 60*ldb] + -0.08108871202779085*b[i + 61*ldb] + 0.9899260824740314*b[i + 62*ldb] + 1.016549610880705*b[i + 63*ldb]);
        c[i + 30*ldc] += (-0.04597253852487312*b[i + 48*ldb] + -0.8799533874010523*b[i + 49*ldb] + -0.8799533874010523*b[i + 50*ldb] + -0.04597253852487312*b[i + 51*ldb] + 0.04597253852487312*b[i + 64*ldb] + 0.8799533874010523*b[i + 65*ldb] + 0.8799533874010523*b[i + 66*ldb] + 0.04597253852487312*b[i + 67*ldb]);
        c[i + 31*ldc] += (0.05630923643747005*b[i + 48*ldb] + -0.2421198530592513*b[i + 49*ldb] + 0.4559769152683337*b[i + 50*ldb] + 5.353398886950359*b[i + 51*ldb] + -0.05630923643747005*b[i + 64*ldb] + 0.2421198530592513*b[i + 65*ldb] + -0.4559769152683337*b[i + 66*ldb] + -5.353398886950359*b[i + 67*ldb]);
        c[i + 32*ldc] += (5.353398886950359*b[i + 48*ldb] + 0.4559769152683337*b[i + 49*ldb] + -0.2421198530592513*b[i + 50*ldb] + 0.05630923643747005*b[i + 51*ldb] + 0.3585590940368028*b[i + 64*ldb] + 0.8413030105765111*b[i + 65*ldb] + 0.8413030105765111*b[i + 66*ldb] + 0.3585590940368028*b[i + 67*ldb]);
        c[i + 33*ldc] += (-0.3585590940368028*b[i + 48*ldb] + -0.8413030105765111*b[i + 49*ldb] + -0.8413030105765111*b[i + 50*ldb] + -0.3585590940368028*b[i + 51*ldb] + -5.353398886950359*b[i + 64*ldb] + -0.4559769152683337*b[i + 65*ldb] + 0.2421198530592513*b[i + 66*ldb] + -0.05630923643747005*b[i + 67*ldb]);
        c[i + 34*ldc] += (0.365666393621057*b[i + 48*ldb] + 4.065939100421376*b[i + 49*ldb] + 0.370774083984965*b[i + 50*ldb] + -0.1373994448117385*b[i + 51*ldb] + 0.02349353850087958*b[i + 64*ldb] + -0.3242629174339381*b[i + 65*ldb] + -0.8735823541978489*b[i + 66*ldb] + -0.5003630637507921*b[i + 67*ldb]);
        c[i + 35*ldc] += (-0.02349353850087958*b[i + 48*ldb] + 0.3242629174339381*b[i + 49*ldb] + 0.8735823541978489*b[i + 50*ldb] + 0.5003630637507921*b[i + 51*ldb] + -0.365666393621057*b[i + 64*ldb] + -4.065939100421376*b[i + 65*ldb] + -0.370774083984965*b[i + 66*ldb] + 0.1373994448117385*b[i + 67*ldb]);
        c[i + 36*ldc] += (0.5003630637507921*b[i + 48*ldb] + 0.8735823541978489*b[i + 49*ldb] + 0.3242629174339381*b[i + 50*ldb] + -0.02349353850087958*b[i + 51*ldb] + 1.016549610880705*b[i + 64*ldb] + 0.9899260824740314*b[i + 65*ldb] + -0.08108871202779085*b[i + 66*ldb] + -0.05511438251869109*b[i + 67*ldb]);
        c[i + 37*ldc] += (-1.016549610880705*b[i + 48*ldb] + -0.9899260824740314*b[i + 49*ldb] + 0.08108871202779085*b[i + 50*ldb] + 0.05511438251869109*b[i + 51*ldb] + -0.5003630637507921*b[i + 64*ldb] + -0.8735823541978489*b[i + 65*ldb] + -0.3242629174339381*b[i + 66*ldb] + 0.02349353850087958*b[i + 67*ldb]);
        c[i + 38*ldc] += (0.05511438251869109*b[i + 48*ldb] + 0.08108871202779085*b[i + 49*ldb] + -0.9899260824740314*b[i + 50*ldb] + -1.016549610880705*b[i + 51*ldb] + 0.1373994448117385*b[i + 64*ldb] + -0.370774083984965*b[i + 65*ldb] + -4.065939100421376*b[i + 66*ldb] + -0.365666393621057*b[i + 67*ldb]);
        c[i + 39*ldc] += (-0.1373994448117385*b[i + 48*ldb] + 0.370774083984965*b[i + 49*ldb] + 4.065939100421376*b[i + 50*ldb] + 0.365666393621057*b[i + 51*ldb] + -0.05511438251869109*b[i + 64*ldb] + -0.08108871202779085*b[i + 65*ldb] + 0.9899260824740314*b[i + 66*ldb] + 1.016549610880705*b[i + 67*ldb]);
        c[i + 40*ldc] += (0.04597253852487312*b[i + 20*ldb] + 0.8799533874010523*b[i + 21*ldb] + 0.8799533874010523*b[i + 22*ldb] + 0.04597253852487312*b[i + 23*ldb] + -0.04597253852487312*b[i + 36*ldb] + -0.8799533874010523*b[i + 37*ldb] + -0.8799533874010523*b[i + 38*ldb] + -0.04597253852487312*b[i + 39*ldb]);
        c[i + 41*ldc] += (0.3585590940368028*b[i + 20*ldb] + 0.8413030105765111*b[i + 21*ldb] + 0.8413030105765111*b[i + 22*ldb] + 0.3585590940368028*b[i + 23*ldb] + 0.05630923643747005*b[i + 36*ldb] + -0.2421198530592513*b[i + 37*ldb] + 0.4559769152683337*b[i + 38*ldb] + 5.353398886950359*b[i + 39*ldb]);
        c[i + 42*ldc] += (-0.05630923643747005*b[i + 20*ldb] + 0.2421198530592513*b[i + 21*ldb] + -0.4559769152683337*b[i + 22*ldb] + -5.353398886950359*b[i + 23*ldb] + 5.353398886950359*b[i + 36*ldb] + 0.4559769152683337*b[i + 37*ldb] + -0.2421198530592513*b[i + 38*ldb] + 0.05630923643747005*b[i + 39*ldb]);
        c[i + 43*ldc] += (-5.353398886950359*b[i + 20*ldb] + -0.4559769152683337*b[i + 21*ldb] + 0.2421198530592513*b[i + 22*ldb] + -0.05630923643747005*b[i + 23*ldb] + -0.3585590940368028*b[i + 36*ldb] + -0.8413030105765111*b[i + 37*ldb] + -0.8413030105765111*b[i + 38*ldb] + -0.3585590940368028*b[i + 39*ldb]);
        c[i + 44*ldc] += (-0.05511438251869109*b[i + 20*ldb] + -0.08108871202779085*b[i + 21*ldb] + 0.9899260824740314*b[i + 22*ldb] + 1.016549610880705*b[i + 23*ldb] + 0.365666393621057*b[i + 36*ldb] + 4.065939100421376*b[i + 37*ldb] + 0.370774083984965*b[i + 38*ldb] + -0.1373994448117385*b[i + 39*ldb]);
        c[i + 45*ldc] += (1.016549610880705*b[i + 20*ldb] + 0.9899260824740314*b[i + 21*ldb] + -0.08108871202779085*b[i + 22*ldb] + -0.05511438251869109*b[i + 23*ldb] + -0.02349353850087958*b[i + 36*ldb] + 0.3242629174339381*b[i + 37*ldb] + 0.8735823541978489*b[i + 38*ldb] + 0.5003630637507921*b[i + 39*ldb]);
        c[i + 46*ldc] += (-0.365666393621057*b[i + 20*ldb] + -4.065939100421376*b[i + 21*ldb] + -0.370774083984965*b[i + 22*ldb] + 0.1373994448117385*b[i + 23*ldb] + 0.5003630637507921*b[i + 36*ldb] + 0.8735823541978489*b[i + 37*ldb] + 0.3242629174339381*b[i + 38*ldb] + -0.02349353850087958*b[i + 39*ldb]);
        c[i + 47*ldc] += (0.1373994448117385*b[i + 20*ldb] + -0.370774083984965*b[i + 21*ldb] + -4.065939100421376*b[i + 22*ldb] + -0.365666393621057*b[i + 23*ldb] + -1.016549610880705*b[i + 36*ldb] + -0.9899260824740314*b[i + 37*ldb] + 0.08108871202779085*b[i + 38*ldb] + 0.05511438251869109*b[i + 39*ldb]);
        c[i + 48*ldc] += (-0.5003630637507921*b[i + 20*ldb] + -0.8735823541978489*b[i + 21*ldb] + -0.3242629174339381*b[i + 22*ldb] + 0.02349353850087958*b[i + 23*ldb] + 0.05511438251869109*b[i + 36*ldb] + 0.08108871202779085*b[i + 37*ldb] + -0.9899260824740314*b[i + 38*ldb] + -1.016549610880705*b[i + 39*ldb]);
        c[i + 49*ldc] += (0.02349353850087958*b[i + 20*ldb] + -0.3242629174339381*b[i + 21*ldb] + -0.8735823541978489*b[i + 22*ldb] + -0.5003630637507921*b[i + 23*ldb] + -0.1373994448117385*b[i + 36*ldb] + 0.370774083984965*b[i + 37*ldb] + 4.065939100421376*b[i + 38*ldb] + 0.365666393621057*b[i + 39*ldb]);
        c[i + 50*ldc] += (0.04597253852487312*b[i + 24*ldb] + 0.8799533874010523*b[i + 25*ldb] + 0.8799533874010523*b[i + 26*ldb] + 0.04597253852487312*b[i + 27*ldb] + -0.04597253852487312*b[i + 40*ldb] + -0.8799533874010523*b[i + 41*ldb] + -0.8799533874010523*b[i + 42*ldb] + -0.04597253852487312*b[i + 43*ldb]);
        c[i + 51*ldc] += (0.3585590940368028*b[i + 24*ldb] + 0.8413030105765111*b[i + 25*ldb] + 0.8413030105765111*b[i + 26*ldb] + 0.3585590940368028*b[i + 27*ldb] + 0.05630923643747005*b[i + 40*ldb] + -0.2421198530592513*b[i + 41*ldb] + 0.4559769152683337*b[i + 42*ldb] + 5.353398886950359*b[i + 43*ldb]);
        c[i + 52*ldc] += (-0.05630923643747005*b[i + 24*ldb] + 0.2421198530592513*b[i + 25*ldb] + -0.4559769152683337*b[i + 26*ldb] + -5.353398886950359*b[i + 27*ldb] + 5.353398886950359*b[i + 40*ldb] + 0.4559769152683337*b[i + 41*ldb] + -0.2421198530592513*b[i + 42*ldb] + 0.05630923643747005*b[i + 43*ldb]);
        c[i + 53*ldc] += (-5.353398886950359*b[i + 24*ldb] + -0.4559769152683337*b[i + 25*ldb] + 0.2421198530592513*b[i + 26*ldb] + -0.05630923643747005*b[i + 27*ldb] + -0.3585590940368028*b[i + 40*ldb] + -0.8413030105765111*b[i + 41*ldb] + -0.8413030105765111*b[i + 42*ldb] + -0.3585590940368028*b[i + 43*ldb]);
        c[i + 54*ldc] += (-0.05511438251869109*b[i + 24*ldb] + -0.08108871202779085*b[i + 25*ldb] + 0.9899260824740314*b[i + 26*ldb] + 1.016549610880705*b[i + 27*ldb] + 0.365666393621057*b[i + 40*ldb] + 4.065939100421376*b[i + 41*ldb] + 0.370774083984965*b[i + 42*ldb] + -0.1373994448117385*b[i + 43*ldb]);
        c[i + 55*ldc] += (1.016549610880705*b[i + 24*ldb] + 0.9899260824740314*b[i + 25*ldb] + -0.08108871202779085*b[i + 26*ldb] + -0.05511438251869109*b[i + 27*ldb] + -0.02349353850087958*b[i + 40*ldb] + 0.3242629174339381*b[i + 41*ldb] + 0.8735823541978489*b[i + 42*ldb] + 0.5003630637507921*b[i + 43*ldb]);
        c[i + 56*ldc] += (-0.365666393621057*b[i + 24*ldb] + -4.065939100421376*b[i + 25*ldb] + -0.370774083984965*b[i + 26*ldb] + 0.1373994448117385*b[i + 27*ldb] + 0.5003630637507921*b[i + 40*ldb] + 0.8735823541978489*b[i + 41*ldb] + 0.3242629174339381*b[i + 42*ldb] + -0.02349353850087958*b[i + 43*ldb]);
        c[i + 57*ldc] += (0.1373994448117385*b[i + 24*ldb] + -0.370774083984965*b[i + 25*ldb] + -4.065939100421376*b[i + 26*ldb] + -0.365666393621057*b[i + 27*ldb] + -1.016549610880705*b[i + 40*ldb] + -0.9899260824740314*b[i + 41*ldb] + 0.08108871202779085*b[i + 42*ldb] + 0.05511438251869109*b[i + 43*ldb]);
        c[i + 58*ldc] += (-0.5003630637507921*b[i + 24*ldb] + -0.8735823541978489*b[i + 25*ldb] + -0.3242629174339381*b[i + 26*ldb] + 0.02349353850087958*b[i + 27*ldb] + 0.05511438251869109*b[i + 40*ldb] + 0.08108871202779085*b[i + 41*ldb] + -0.9899260824740314*b[i + 42*ldb] + -1.016549610880705*b[i + 43*ldb]);
        c[i + 59*ldc] += (0.02349353850087958*b[i + 24*ldb] + -0.3242629174339381*b[i + 25*ldb] + -0.8735823541978489*b[i + 26*ldb] + -0.5003630637507921*b[i + 27*ldb] + -0.1373994448117385*b[i + 40*ldb] + 0.370774083984965*b[i + 41*ldb] + 4.065939100421376*b[i + 42*ldb] + 0.365666393621057*b[i + 43*ldb]);
        c[i + 60*ldc] += (0.04597253852487312*b[i + 28*ldb] + 0.8799533874010523*b[i + 29*ldb] + 0.8799533874010523*b[i + 30*ldb] + 0.04597253852487312*b[i + 31*ldb] + -0.04597253852487312*b[i + 44*ldb] + -0.8799533874010523*b[i + 45*ldb] + -0.8799533874010523*b[i + 46*ldb] + -0.04597253852487312*b[i + 47*ldb]);
        c[i + 61*ldc] += (0.3585590940368028*b[i + 28*ldb] + 0.8413030105765111*b[i + 29*ldb] + 0.8413030105765111*b[i + 30*ldb] + 0.3585590940368028*b[i + 31*ldb] + 0.05630923643747005*b[i + 44*ldb] + -0.2421198530592513*b[i + 45*ldb] + 0.4559769152683337*b[i + 46*ldb] + 5.353398886950359*b[i + 47*ldb]);
        c[i + 62*ldc] += (-0.05630923643747005*b[i + 28*ldb] + 0.2421198530592513*b[i + 29*ldb] + -0.4559769152683337*b[i + 30*ldb] + -5.353398886950359*b[i + 31*ldb] + 5.353398886950359*b[i + 44*ldb] + 0.4559769152683337*b[i + 45*ldb] + -0.2421198530592513*b[i + 46*ldb] + 0.05630923643747005*b[i + 47*ldb]);
        c[i + 63*ldc] += (-5.353398886950359*b[i + 28*ldb] + -0.4559769152683337*b[i + 29*ldb] + 0.2421198530592513*b[i + 30*ldb] + -0.05630923643747005*b[i + 31*ldb] + -0.3585590940368028*b[i + 44*ldb] + -0.8413030105765111*b[i + 45*ldb] + -0.8413030105765111*b[i + 46*ldb] + -0.3585590940368028*b[i + 47*ldb]);
        c[i + 64*ldc] += (-0.05511438251869109*b[i + 28*ldb] + -0.08108871202779085*b[i + 29*ldb] + 0.9899260824740314*b[i + 30*ldb] + 1.016549610880705*b[i + 31*ldb] + 0.365666393621057*b[i + 44*ldb] + 4.065939100421376*b[i + 45*ldb] + 0.370774083984965*b[i + 46*ldb] + -0.1373994448117385*b[i + 47*ldb]);
        c[i + 65*ldc] += (1.016549610880705*b[i + 28*ldb] + 0.9899260824740314*b[i + 29*ldb] + -0.08108871202779085*b[i + 30*ldb] + -0.05511438251869109*b[i + 31*ldb] + -0.02349353850087958*b[i + 44*ldb] + 0.3242629174339381*b[i + 45*ldb] + 0.8735823541978489*b[i + 46*ldb] + 0.5003630637507921*b[i + 47*ldb]);
        c[i + 66*ldc] += (-0.365666393621057*b[i + 28*ldb] + -4.065939100421376*b[i + 29*ldb] + -0.370774083984965*b[i + 30*ldb] + 0.1373994448117385*b[i + 31*ldb] + 0.5003630637507921*b[i + 44*ldb] + 0.8735823541978489*b[i + 45*ldb] + 0.3242629174339381*b[i + 46*ldb] + -0.02349353850087958*b[i + 47*ldb]);
        c[i + 67*ldc] += (0.1373994448117385*b[i + 28*ldb] + -0.370774083984965*b[i + 29*ldb] + -4.065939100421376*b[i + 30*ldb] + -0.365666393621057*b[i + 31*ldb] + -1.016549610880705*b[i + 44*ldb] + -0.9899260824740314*b[i + 45*ldb] + 0.08108871202779085*b[i + 46*ldb] + 0.05511438251869109*b[i + 47*ldb]);
        c[i + 68*ldc] += (-0.5003630637507921*b[i + 28*ldb] + -0.8735823541978489*b[i + 29*ldb] + -0.3242629174339381*b[i + 30*ldb] + 0.02349353850087958*b[i + 31*ldb] + 0.05511438251869109*b[i + 44*ldb] + 0.08108871202779085*b[i + 45*ldb] + -0.9899260824740314*b[i + 46*ldb] + -1.016549610880705*b[i + 47*ldb]);
        c[i + 69*ldc] += (0.02349353850087958*b[i + 28*ldb] + -0.3242629174339381*b[i + 29*ldb] + -0.8735823541978489*b[i + 30*ldb] + -0.5003630637507921*b[i + 31*ldb] + -0.1373994448117385*b[i + 44*ldb] + 0.370774083984965*b[i + 45*ldb] + 4.065939100421376*b[i + 46*ldb] + 0.365666393621057*b[i + 47*ldb]);
        c[i + 70*ldc] += (0.04597253852487312*b[i + 32*ldb] + 0.8799533874010523*b[i + 33*ldb] + 0.8799533874010523*b[i + 34*ldb] + 0.04597253852487312*b[i + 35*ldb] + -0.04597253852487312*b[i + 48*ldb] + -0.8799533874010523*b[i + 49*ldb] + -0.8799533874010523*b[i + 50*ldb] + -0.04597253852487312*b[i + 51*ldb]);
        c[i + 71*ldc] += (0.3585590940368028*b[i + 32*ldb] + 0.8413030105765111*b[i + 33*ldb] + 0.8413030105765111*b[i + 34*ldb] + 0.3585590940368028*b[i + 35*ldb] + 0.05630923643747005*b[i + 48*ldb] + -0.2421198530592513*b[i + 49*ldb] + 0.4559769152683337*b[i + 50*ldb] + 5.353398886950359*b[i + 51*ldb]);
        c[i + 72*ldc] += (-0.05630923643747005*b[i + 32*ldb] + 0.2421198530592513*b[i + 33*ldb] + -0.4559769152683337*b[i + 34*ldb] + -5.353398886950359*b[i + 35*ldb] + 5.353398886950359*b[i + 48*ldb] + 0.4559769152683337*b[i + 49*ldb] + -0.2421198530592513*b[i + 50*ldb] + 0.05630923643747005*b[i + 51*ldb]);
        c[i + 73*ldc] += (-5.353398886950359*b[i + 32*ldb] + -0.4559769152683337*b[i + 33*ldb] + 0.2421198530592513*b[i + 34*ldb] + -0.05630923643747005*b[i + 35*ldb] + -0.3585590940368028*b[i + 48*ldb] + -0.8413030105765111*b[i + 49*ldb] + -0.8413030105765111*b[i + 50*ldb] + -0.3585590940368028*b[i + 51*ldb]);
        c[i + 74*ldc] += (-0.05511438251869109*b[i + 32*ldb] + -0.08108871202779085*b[i + 33*ldb] + 0.9899260824740314*b[i + 34*ldb] + 1.016549610880705*b[i + 35*ldb] + 0.365666393621057*b[i + 48*ldb] + 4.065939100421376*b[i + 49*ldb] + 0.370774083984965*b[i + 50*ldb] + -0.1373994448117385*b[i + 51*ldb]);
        c[i + 75*ldc] += (1.016549610880705*b[i + 32*ldb] + 0.9899260824740314*b[i + 33*ldb] + -0.08108871202779085*b[i + 34*ldb] + -0.05511438251869109*b[i + 35*ldb] + -0.02349353850087958*b[i + 48*ldb] + 0.3242629174339381*b[i + 49*ldb] + 0.8735823541978489*b[i + 50*ldb] + 0.5003630637507921*b[i + 51*ldb]);
        c[i + 76*ldc] += (-0.365666393621057*b[i + 32*ldb] + -4.065939100421376*b[i + 33*ldb] + -0.370774083984965*b[i + 34*ldb] + 0.1373994448117385*b[i + 35*ldb] + 0.5003630637507921*b[i + 48*ldb] + 0.8735823541978489*b[i + 49*ldb] + 0.3242629174339381*b[i + 50*ldb] + -0.02349353850087958*b[i + 51*ldb]);
        c[i + 77*ldc] += (0.1373994448117385*b[i + 32*ldb] + -0.370774083984965*b[i + 33*ldb] + -4.065939100421376*b[i + 34*ldb] + -0.365666393621057*b[i + 35*ldb] + -1.016549610880705*b[i + 48*ldb] + -0.9899260824740314*b[i + 49*ldb] + 0.08108871202779085*b[i + 50*ldb] + 0.05511438251869109*b[i + 51*ldb]);
        c[i + 78*ldc] += (-0.5003630637507921*b[i + 32*ldb] + -0.8735823541978489*b[i + 33*ldb] + -0.3242629174339381*b[i + 34*ldb] + 0.02349353850087958*b[i + 35*ldb] + 0.05511438251869109*b[i + 48*ldb] + 0.08108871202779085*b[i + 49*ldb] + -0.9899260824740314*b[i + 50*ldb] + -1.016549610880705*b[i + 51*ldb]);
        c[i + 79*ldc] += (0.02349353850087958*b[i + 32*ldb] + -0.3242629174339381*b[i + 33*ldb] + -0.8735823541978489*b[i + 34*ldb] + -0.5003630637507921*b[i + 35*ldb] + -0.1373994448117385*b[i + 48*ldb] + 0.370774083984965*b[i + 49*ldb] + 4.065939100421376*b[i + 50*ldb] + 0.365666393621057*b[i + 51*ldb]);
        c[i + 80*ldc] += (-4.389152966531057*b[i + 0*ldb] + -0.327484862937513*b[i + 10*ldb]);
        c[i + 81*ldc] += (-4.389152966531057*b[i + 1*ldb] + -0.327484862937513*b[i + 11*ldb]);
        c[i + 82*ldc] += (-4.389152966531057*b[i + 2*ldb] + -0.327484862937513*b[i + 12*ldb]);
        c[i + 83*ldc] += (-4.389152966531057*b[i + 3*ldb] + -0.327484862937513*b[i + 13*ldb]);
        c[i + 84*ldc] += (-4.389152966531057*b[i + 4*ldb] + -0.327484862937513*b[i + 14*ldb]);
        c[i + 85*ldc] += (-4.389152966531057*b[i + 5*ldb] + -0.327484862937513*b[i + 15*ldb]);
        c[i + 86*ldc] += (-4.389152966531057*b[i + 6*ldb] + -0.327484862937513*b[i + 16*ldb]);
        c[i + 87*ldc] += (-4.389152966531057*b[i + 7*ldb] + -0.327484862937513*b[i + 17*ldb]);
        c[i + 88*ldc] += (-4.389152966531057*b[i + 8*ldb] + -0.327484862937513*b[i + 18*ldb]);
        c[i + 89*ldc] += (-4.389152966531057*b[i + 9*ldb] + -0.327484862937513*b[i + 19*ldb]);
        c[i + 90*ldc] += (1.247624770988926*b[i + 0*ldb] + 0.6145280959667898*b[i + 10*ldb]);
        c[i + 91*ldc] += (1.247624770988926*b[i + 1*ldb] + 0.6145280959667898*b[i + 11*ldb]);
        c[i + 92*ldc] += (1.247624770988926*b[i + 2*ldb] + 0.6145280959667898*b[i + 12*ldb]);
        c[i + 93*ldc] += (1.247624770988926*b[i + 3*ldb] + 0.6145280959667898*b[i + 13*ldb]);
        c[i + 94*ldc] += (1.247624770988926*b[i + 4*ldb] + 0.6145280959667898*b[i + 14*ldb]);
        c[i + 95*ldc] += (1.247624770988926*b[i + 5*ldb] + 0.6145280959667898*b[i + 15*ldb]);
        c[i + 96*ldc] += (1.247624770988926*b[i + 6*ldb] + 0.6145280959667898*b[i + 16*ldb]);
        c[i + 97*ldc] += (1.247624770988926*b[i + 7*ldb] + 0.6145280959667898*b[i + 17*ldb]);
        c[i + 98*ldc] += (1.247624770988926*b[i + 8*ldb] + 0.6145280959667898*b[i + 18*ldb]);
        c[i + 99*ldc] += (1.247624770988926*b[i + 9*ldb] + 0.6145280959667898*b[i + 19*ldb]);
        c[i + 100*ldc] += (-0.6145280959667898*b[i + 0*ldb] + -1.247624770988926*b[i + 10*ldb]);
        c[i + 101*ldc] += (-0.6145280959667898*b[i + 1*ldb] + -1.247624770988926*b[i + 11*ldb]);
        c[i + 102*ldc] += (-0.6145280959667898*b[i + 2*ldb] + -1.247624770988926*b[i + 12*ldb]);
        c[i + 103*ldc] += (-0.6145280959667898*b[i + 3*ldb] + -1.247624770988926*b[i + 13*ldb]);
        c[i + 104*ldc] += (-0.6145280959667898*b[i + 4*ldb] + -1.247624770988926*b[i + 14*ldb]);
        c[i + 105*ldc] += (-0.6145280959667898*b[i + 5*ldb] + -1.247624770988926*b[i + 15*ldb]);
        c[i + 106*ldc] += (-0.6145280959667898*b[i + 6*ldb] + -1.247624770988926*b[i + 16*ldb]);
        c[i + 107*ldc] += (-0.6145280959667898*b[i + 7*ldb] + -1.247624770988926*b[i + 17*ldb]);
        c[i + 108*ldc] += (-0.6145280959667898*b[i + 8*ldb] + -1.247624770988926*b[i + 18*ldb]);
        c[i + 109*ldc] += (-0.6145280959667898*b[i + 9*ldb] + -1.247624770988926*b[i + 19*ldb]);
        c[i + 110*ldc] += (0.327484862937513*b[i + 0*ldb] + 4.389152966531057*b[i + 10*ldb]);
        c[i + 111*ldc] += (0.327484862937513*b[i + 1*ldb] + 4.389152966531057*b[i + 11*ldb]);
        c[i + 112*ldc] += (0.327484862937513*b[i + 2*ldb] + 4.389152966531057*b[i + 12*ldb]);
        c[i + 113*ldc] += (0.327484862937513*b[i + 3*ldb] + 4.389152966531057*b[i + 13*ldb]);
        c[i + 114*ldc] += (0.327484862937513*b[i + 4*ldb] + 4.389152966531057*b[i + 14*ldb]);
        c[i + 115*ldc] += (0.327484862937513*b[i + 5*ldb] + 4.389152966531057*b[i + 15*ldb]);
        c[i + 116*ldc] += (0.327484862937513*b[i + 6*ldb] + 4.389152966531057*b[i + 16*ldb]);
        c[i + 117*ldc] += (0.327484862937513*b[i + 7*ldb] + 4.389152966531057*b[i + 17*ldb]);
        c[i + 118*ldc] += (0.327484862937513*b[i + 8*ldb] + 4.389152966531057*b[i + 18*ldb]);
        c[i + 119*ldc] += (0.327484862937513*b[i + 9*ldb] + 4.389152966531057*b[i + 19*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_pri_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (-0.03017698203251321*b[i + 2*ldb] + 0.03017698203251321*b[i + 3*ldb] + 1.833320258631525*b[i + 4*ldb] + -1.833320258631525*b[i + 5*ldb] + -0.03664146213189456*b[i + 6*ldb] + 0.03664146213189456*b[i + 7*ldb] + -1.796678796499631*b[i + 8*ldb] + 1.796678796499631*b[i + 9*ldb]);
        c[i + 1*ldc] = (-0.03161745145272921*b[i + 2*ldb] + 0.03161745145272921*b[i + 3*ldb] + 0.1482821472622804*b[i + 4*ldb] + -0.1482821472622804*b[i + 5*ldb] + 0.02677969298108662*b[i + 6*ldb] + -0.02677969298108662*b[i + 7*ldb] + -0.1750618402433646*b[i + 8*ldb] + 0.1750618402433646*b[i + 9*ldb]);
        c[i + 2*ldc] = (1.502821807911975*b[i + 0*ldb] + -0.5764568723296889*b[i + 1*ldb] + -3.352054625649612*b[i + 2*ldb] + -0.5448394208769596*b[i + 3*ldb] + -1.880145437552564*b[i + 4*ldb] + -1.442087069209281*b[i + 5*ldb] + 0.8226320578033056*b[i + 6*ldb] + -2.055207277795931*b[i + 7*ldb] + -1.468866762190367*b[i + 8*ldb] + 0.9709142050655857*b[i + 9*ldb]);
        c[i + 3*ldc] = (-1.502821807911975*b[i + 0*ldb] + 0.5764568723296889*b[i + 1*ldb] + 0.5448394208769596*b[i + 2*ldb] + 3.352054625649612*b[i + 3*ldb] + 1.442087069209281*b[i + 4*ldb] + 1.880145437552564*b[i + 5*ldb] + 2.055207277795931*b[i + 6*ldb] + -0.8226320578033056*b[i + 7*ldb] + -0.9709142050655857*b[i + 8*ldb] + 1.468866762190367*b[i + 9*ldb]);
        c[i + 4*ldc] = (-1.547794495565776*b[i + 0*ldb] + 0.9088687149339676*b[i + 1*ldb] + -0.1645658595194091*b[i + 2*ldb] + -0.07145144361504918*b[i + 3*ldb] + -2.68438394041468*b[i + 4*ldb] + 0.6018446554234487*b[i + 5*ldb] + 0.08483971514664668*b[i + 6*ldb] + -0.1309057053603245*b[i + 7*ldb] + 1.541883098984185*b[i + 8*ldb] + -1.528600076346972*b[i + 9*ldb]);
        c[i + 5*ldc] = (1.547794495565776*b[i + 0*ldb] + -0.9088687149339676*b[i + 1*ldb] + 0.07145144361504918*b[i + 2*ldb] + 0.1645658595194091*b[i + 3*ldb] + -0.6018446554234487*b[i + 4*ldb] + 2.68438394041468*b[i + 5*ldb] + 0.1309057053603245*b[i + 6*ldb] + -0.08483971514664668*b[i + 7*ldb] + 1.528600076346972*b[i + 8*ldb] + -1.541883098984185*b[i + 9*ldb]);
        c[i + 6*ldc] = (1.288308238382692*b[i + 0*ldb] + 0.1146719895825324*b[i + 1*ldb] + -0.813336618056223*b[i + 2*ldb] + -1.970896065380053*b[i + 3*ldb] + -1.520106975288837*b[i + 4*ldb] + -1.928363752763298*b[i + 5*ldb] + 0.2734547660549973*b[i + 6*ldb] + 1.468505039653621*b[i + 7*ldb] + 0.1647847391243889*b[i + 8*ldb] + -0.6220087569997739*b[i + 9*ldb]);
        c[i + 7*ldc] = (-1.288308238382692*b[i + 0*ldb] + -0.1146719895825324*b[i + 1*ldb] + 1.970896065380053*b[i + 2*ldb] + 0.813336618056223*b[i + 3*ldb] + 1.928363752763298*b[i + 4*ldb] + 1.520106975288837*b[i + 5*ldb] + -1.468505039653621*b[i + 6*ldb] + -0.2734547660549973*b[i + 7*ldb] + 0.6220087569997739*b[i + 8*ldb] + -0.1647847391243889*b[i + 9*ldb]);
        c[i + 8*ldc] = (0.2594862571830836*b[i + 0*ldb] + 2.135461924899462*b[i + 1*ldb] + -0.04322054596748309*b[i + 2*ldb] + -0.09553209687774447*b[i + 3*ldb] + -0.2496244542710354*b[i + 4*ldb] + 0.06009503669335015*b[i + 5*ldb] + -0.02177612369534747*b[i + 6*ldb] + 0.02016410157632526*b[i + 7*ldb] + 2.410929174359682*b[i + 8*ldb] + 2.059269458123622*b[i + 9*ldb]);
        c[i + 9*ldc] = (-0.2594862571830836*b[i + 0*ldb] + -2.135461924899462*b[i + 1*ldb] + 0.09553209687774447*b[i + 2*ldb] + 0.04322054596748309*b[i + 3*ldb] + -0.06009503669335015*b[i + 4*ldb] + 0.2496244542710354*b[i + 5*ldb] + -0.02016410157632526*b[i + 6*ldb] + 0.02177612369534747*b[i + 7*ldb] + -2.059269458123622*b[i + 8*ldb] + -2.410929174359682*b[i + 9*ldb]);
        c[i + 10*ldc] = (-0.03017698203251321*b[i + 12*ldb] + 0.03017698203251321*b[i + 13*ldb] + 1.833320258631525*b[i + 14*ldb] + -1.833320258631525*b[i + 15*ldb] + -0.03664146213189456*b[i + 16*ldb] + 0.03664146213189456*b[i + 17*ldb] + -1.796678796499631*b[i + 18*ldb] + 1.796678796499631*b[i + 19*ldb]);
        c[i + 11*ldc] = (-0.03161745145272921*b[i + 12*ldb] + 0.03161745145272921*b[i + 13*ldb] + 0.1482821472622804*b[i + 14*ldb] + -0.1482821472622804*b[i + 15*ldb] + 0.02677969298108662*b[i + 16*ldb] + -0.02677969298108662*b[i + 17*ldb] + -0.1750618402433646*b[i + 18*ldb] + 0.1750618402433646*b[i + 19*ldb]);
        c[i + 12*ldc] = (1.502821807911975*b[i + 10*ldb] + -0.5764568723296889*b[i + 11*ldb] + -3.352054625649612*b[i + 12*ldb] + -0.5448394208769596*b[i + 13*ldb] + -1.880145437552564*b[i + 14*ldb] + -1.442087069209281*b[i + 15*ldb] + 0.8226320578033056*b[i + 16*ldb] + -2.055207277795931*b[i + 17*ldb] + -1.468866762190367*b[i + 18*ldb] + 0.9709142050655857*b[i + 19*ldb]);
        c[i + 13*ldc] = (-1.502821807911975*b[i + 10*ldb] + 0.5764568723296889*b[i + 11*ldb] + 0.5448394208769596*b[i + 12*ldb] + 3.352054625649612*b[i + 13*ldb] + 1.442087069209281*b[i + 14*ldb] + 1.880145437552564*b[i + 15*ldb] + 2.055207277795931*b[i + 16*ldb] + -0.8226320578033056*b[i + 17*ldb] + -0.9709142050655857*b[i + 18*ldb] + 1.468866762190367*b[i + 19*ldb]);
        c[i + 14*ldc] = (-1.547794495565776*b[i + 10*ldb] + 0.9088687149339676*b[i + 11*ldb] + -0.1645658595194091*b[i + 12*ldb] + -0.07145144361504918*b[i + 13*ldb] + -2.68438394041468*b[i + 14*ldb] + 0.6018446554234487*b[i + 15*ldb] + 0.08483971514664668*b[i + 16*ldb] + -0.1309057053603245*b[i + 17*ldb] + 1.541883098984185*b[i + 18*ldb] + -1.528600076346972*b[i + 19*ldb]);
        c[i + 15*ldc] = (1.547794495565776*b[i + 10*ldb] + -0.9088687149339676*b[i + 11*ldb] + 0.07145144361504918*b[i + 12*ldb] + 0.1645658595194091*b[i + 13*ldb] + -0.6018446554234487*b[i + 14*ldb] + 2.68438394041468*b[i + 15*ldb] + 0.1309057053603245*b[i + 16*ldb] + -0.08483971514664668*b[i + 17*ldb] + 1.528600076346972*b[i + 18*ldb] + -1.541883098984185*b[i + 19*ldb]);
        c[i + 16*ldc] = (1.288308238382692*b[i + 10*ldb] + 0.1146719895825324*b[i + 11*ldb] + -0.813336618056223*b[i + 12*ldb] + -1.970896065380053*b[i + 13*ldb] + -1.520106975288837*b[i + 14*ldb] + -1.928363752763298*b[i + 15*ldb] + 0.2734547660549973*b[i + 16*ldb] + 1.468505039653621*b[i + 17*ldb] + 0.1647847391243889*b[i + 18*ldb] + -0.6220087569997739*b[i + 19*ldb]);
        c[i + 17*ldc] = (-1.288308238382692*b[i + 10*ldb] + -0.1146719895825324*b[i + 11*ldb] + 1.970896065380053*b[i + 12*ldb] + 0.813336618056223*b[i + 13*ldb] + 1.928363752763298*b[i + 14*ldb] + 1.520106975288837*b[i + 15*ldb] + -1.468505039653621*b[i + 16*ldb] + -0.2734547660549973*b[i + 17*ldb] + 0.6220087569997739*b[i + 18*ldb] + -0.1647847391243889*b[i + 19*ldb]);
        c[i + 18*ldc] = (0.2594862571830836*b[i + 10*ldb] + 2.135461924899462*b[i + 11*ldb] + -0.04322054596748309*b[i + 12*ldb] + -0.09553209687774447*b[i + 13*ldb] + -0.2496244542710354*b[i + 14*ldb] + 0.06009503669335015*b[i + 15*ldb] + -0.02177612369534747*b[i + 16*ldb] + 0.02016410157632526*b[i + 17*ldb] + 2.410929174359682*b[i + 18*ldb] + 2.059269458123622*b[i + 19*ldb]);
        c[i + 19*ldc] = (-0.2594862571830836*b[i + 10*ldb] + -2.135461924899462*b[i + 11*ldb] + 0.09553209687774447*b[i + 12*ldb] + 0.04322054596748309*b[i + 13*ldb] + -0.06009503669335015*b[i + 14*ldb] + 0.2496244542710354*b[i + 15*ldb] + -0.02016410157632526*b[i + 16*ldb] + 0.02177612369534747*b[i + 17*ldb] + -2.059269458123622*b[i + 18*ldb] + -2.410929174359682*b[i + 19*ldb]);
        c[i + 20*ldc] = (-0.03017698203251321*b[i + 22*ldb] + 0.03017698203251321*b[i + 23*ldb] + 1.833320258631525*b[i + 24*ldb] + -1.833320258631525*b[i + 25*ldb] + -0.03664146213189456*b[i + 26*ldb] + 0.03664146213189456*b[i + 27*ldb] + -1.796678796499631*b[i + 28*ldb] + 1.796678796499631*b[i + 29*ldb]);
        c[i + 21*ldc] = (-0.03161745145272921*b[i + 22*ldb] + 0.03161745145272921*b[i + 23*ldb] + 0.1482821472622804*b[i + 24*ldb] + -0.1482821472622804*b[i + 25*ldb] + 0.02677969298108662*b[i + 26*ldb] + -0.02677969298108662*b[i + 27*ldb] + -0.1750618402433646*b[i + 28*ldb] + 0.1750618402433646*b[i + 29*ldb]);
        c[i + 22*ldc] = (1.502821807911975*b[i + 20*ldb] + -0.5764568723296889*b[i + 21*ldb] + -3.352054625649612*b[i + 22*ldb] + -0.5448394208769596*b[i + 23*ldb] + -1.880145437552564*b[i + 24*ldb] + -1.442087069209281*b[i + 25*ldb] + 0.8226320578033056*b[i + 26*ldb] + -2.055207277795931*b[i + 27*ldb] + -1.468866762190367*b[i + 28*ldb] + 0.9709142050655857*b[i + 29*ldb]);
        c[i + 23*ldc] = (-1.502821807911975*b[i + 20*ldb] + 0.5764568723296889*b[i + 21*ldb] + 0.5448394208769596*b[i + 22*ldb] + 3.352054625649612*b[i + 23*ldb] + 1.442087069209281*b[i + 24*ldb] + 1.880145437552564*b[i + 25*ldb] + 2.055207277795931*b[i + 26*ldb] + -0.8226320578033056*b[i + 27*ldb] + -0.9709142050655857*b[i + 28*ldb] + 1.468866762190367*b[i + 29*ldb]);
        c[i + 24*ldc] = (-1.547794495565776*b[i + 20*ldb] + 0.9088687149339676*b[i + 21*ldb] + -0.1645658595194091*b[i + 22*ldb] + -0.07145144361504918*b[i + 23*ldb] + -2.68438394041468*b[i + 24*ldb] + 0.6018446554234487*b[i + 25*ldb] + 0.08483971514664668*b[i + 26*ldb] + -0.1309057053603245*b[i + 27*ldb] + 1.541883098984185*b[i + 28*ldb] + -1.528600076346972*b[i + 29*ldb]);
        c[i + 25*ldc] = (1.547794495565776*b[i + 20*ldb] + -0.9088687149339676*b[i + 21*ldb] + 0.07145144361504918*b[i + 22*ldb] + 0.1645658595194091*b[i + 23*ldb] + -0.6018446554234487*b[i + 24*ldb] + 2.68438394041468*b[i + 25*ldb] + 0.1309057053603245*b[i + 26*ldb] + -0.08483971514664668*b[i + 27*ldb] + 1.528600076346972*b[i + 28*ldb] + -1.541883098984185*b[i + 29*ldb]);
        c[i + 26*ldc] = (1.288308238382692*b[i + 20*ldb] + 0.1146719895825324*b[i + 21*ldb] + -0.813336618056223*b[i + 22*ldb] + -1.970896065380053*b[i + 23*ldb] + -1.520106975288837*b[i + 24*ldb] + -1.928363752763298*b[i + 25*ldb] + 0.2734547660549973*b[i + 26*ldb] + 1.468505039653621*b[i + 27*ldb] + 0.1647847391243889*b[i + 28*ldb] + -0.6220087569997739*b[i + 29*ldb]);
        c[i + 27*ldc] = (-1.288308238382692*b[i + 20*ldb] + -0.1146719895825324*b[i + 21*ldb] + 1.970896065380053*b[i + 22*ldb] + 0.813336618056223*b[i + 23*ldb] + 1.928363752763298*b[i + 24*ldb] + 1.520106975288837*b[i + 25*ldb] + -1.468505039653621*b[i + 26*ldb] + -0.2734547660549973*b[i + 27*ldb] + 0.6220087569997739*b[i + 28*ldb] + -0.1647847391243889*b[i + 29*ldb]);
        c[i + 28*ldc] = (0.2594862571830836*b[i + 20*ldb] + 2.135461924899462*b[i + 21*ldb] + -0.04322054596748309*b[i + 22*ldb] + -0.09553209687774447*b[i + 23*ldb] + -0.2496244542710354*b[i + 24*ldb] + 0.06009503669335015*b[i + 25*ldb] + -0.02177612369534747*b[i + 26*ldb] + 0.02016410157632526*b[i + 27*ldb] + 2.410929174359682*b[i + 28*ldb] + 2.059269458123622*b[i + 29*ldb]);
        c[i + 29*ldc] = (-0.2594862571830836*b[i + 20*ldb] + -2.135461924899462*b[i + 21*ldb] + 0.09553209687774447*b[i + 22*ldb] + 0.04322054596748309*b[i + 23*ldb] + -0.06009503669335015*b[i + 24*ldb] + 0.2496244542710354*b[i + 25*ldb] + -0.02016410157632526*b[i + 26*ldb] + 0.02177612369534747*b[i + 27*ldb] + -2.059269458123622*b[i + 28*ldb] + -2.410929174359682*b[i + 29*ldb]);
        c[i + 30*ldc] = (-0.03017698203251321*b[i + 32*ldb] + 0.03017698203251321*b[i + 33*ldb] + 1.833320258631525*b[i + 34*ldb] + -1.833320258631525*b[i + 35*ldb] + -0.03664146213189456*b[i + 36*ldb] + 0.03664146213189456*b[i + 37*ldb] + -1.796678796499631*b[i + 38*ldb] + 1.796678796499631*b[i + 39*ldb]);
        c[i + 31*ldc] = (-0.03161745145272921*b[i + 32*ldb] + 0.03161745145272921*b[i + 33*ldb] + 0.1482821472622804*b[i + 34*ldb] + -0.1482821472622804*b[i + 35*ldb] + 0.02677969298108662*b[i + 36*ldb] + -0.02677969298108662*b[i + 37*ldb] + -0.1750618402433646*b[i + 38*ldb] + 0.1750618402433646*b[i + 39*ldb]);
        c[i + 32*ldc] = (1.502821807911975*b[i + 30*ldb] + -0.5764568723296889*b[i + 31*ldb] + -3.352054625649612*b[i + 32*ldb] + -0.5448394208769596*b[i + 33*ldb] + -1.880145437552564*b[i + 34*ldb] + -1.442087069209281*b[i + 35*ldb] + 0.8226320578033056*b[i + 36*ldb] + -2.055207277795931*b[i + 37*ldb] + -1.468866762190367*b[i + 38*ldb] + 0.9709142050655857*b[i + 39*ldb]);
        c[i + 33*ldc] = (-1.502821807911975*b[i + 30*ldb] + 0.5764568723296889*b[i + 31*ldb] + 0.5448394208769596*b[i + 32*ldb] + 3.352054625649612*b[i + 33*ldb] + 1.442087069209281*b[i + 34*ldb] + 1.880145437552564*b[i + 35*ldb] + 2.055207277795931*b[i + 36*ldb] + -0.8226320578033056*b[i + 37*ldb] + -0.9709142050655857*b[i + 38*ldb] + 1.468866762190367*b[i + 39*ldb]);
        c[i + 34*ldc] = (-1.547794495565776*b[i + 30*ldb] + 0.9088687149339676*b[i + 31*ldb] + -0.1645658595194091*b[i + 32*ldb] + -0.07145144361504918*b[i + 33*ldb] + -2.68438394041468*b[i + 34*ldb] + 0.6018446554234487*b[i + 35*ldb] + 0.08483971514664668*b[i + 36*ldb] + -0.1309057053603245*b[i + 37*ldb] + 1.541883098984185*b[i + 38*ldb] + -1.528600076346972*b[i + 39*ldb]);
        c[i + 35*ldc] = (1.547794495565776*b[i + 30*ldb] + -0.9088687149339676*b[i + 31*ldb] + 0.07145144361504918*b[i + 32*ldb] + 0.1645658595194091*b[i + 33*ldb] + -0.6018446554234487*b[i + 34*ldb] + 2.68438394041468*b[i + 35*ldb] + 0.1309057053603245*b[i + 36*ldb] + -0.08483971514664668*b[i + 37*ldb] + 1.528600076346972*b[i + 38*ldb] + -1.541883098984185*b[i + 39*ldb]);
        c[i + 36*ldc] = (1.288308238382692*b[i + 30*ldb] + 0.1146719895825324*b[i + 31*ldb] + -0.813336618056223*b[i + 32*ldb] + -1.970896065380053*b[i + 33*ldb] + -1.520106975288837*b[i + 34*ldb] + -1.928363752763298*b[i + 35*ldb] + 0.2734547660549973*b[i + 36*ldb] + 1.468505039653621*b[i + 37*ldb] + 0.1647847391243889*b[i + 38*ldb] + -0.6220087569997739*b[i + 39*ldb]);
        c[i + 37*ldc] = (-1.288308238382692*b[i + 30*ldb] + -0.1146719895825324*b[i + 31*ldb] + 1.970896065380053*b[i + 32*ldb] + 0.813336618056223*b[i + 33*ldb] + 1.928363752763298*b[i + 34*ldb] + 1.520106975288837*b[i + 35*ldb] + -1.468505039653621*b[i + 36*ldb] + -0.2734547660549973*b[i + 37*ldb] + 0.6220087569997739*b[i + 38*ldb] + -0.1647847391243889*b[i + 39*ldb]);
        c[i + 38*ldc] = (0.2594862571830836*b[i + 30*ldb] + 2.135461924899462*b[i + 31*ldb] + -0.04322054596748309*b[i + 32*ldb] + -0.09553209687774447*b[i + 33*ldb] + -0.2496244542710354*b[i + 34*ldb] + 0.06009503669335015*b[i + 35*ldb] + -0.02177612369534747*b[i + 36*ldb] + 0.02016410157632526*b[i + 37*ldb] + 2.410929174359682*b[i + 38*ldb] + 2.059269458123622*b[i + 39*ldb]);
        c[i + 39*ldc] = (-0.2594862571830836*b[i + 30*ldb] + -2.135461924899462*b[i + 31*ldb] + 0.09553209687774447*b[i + 32*ldb] + 0.04322054596748309*b[i + 33*ldb] + -0.06009503669335015*b[i + 34*ldb] + 0.2496244542710354*b[i + 35*ldb] + -0.02016410157632526*b[i + 36*ldb] + 0.02177612369534747*b[i + 37*ldb] + -2.059269458123622*b[i + 38*ldb] + -2.410929174359682*b[i + 39*ldb]);
        c[i + 40*ldc] = (-0.03017698203251321*b[i + 1*ldb] + 0.03017698203251321*b[i + 3*ldb] + 1.796678796499631*b[i + 4*ldb] + -0.03664146213189456*b[i + 5*ldb] + -1.833320258631525*b[i + 6*ldb] + -1.796678796499631*b[i + 7*ldb] + 0.03664146213189456*b[i + 8*ldb] + 1.833320258631525*b[i + 9*ldb]);
        c[i + 41*ldc] = (1.502821807911975*b[i + 0*ldb] + -3.352054625649612*b[i + 1*ldb] + -0.5764568723296889*b[i + 2*ldb] + -0.5448394208769596*b[i + 3*ldb] + 0.9709142050655857*b[i + 4*ldb] + 0.8226320578033056*b[i + 5*ldb] + -1.442087069209281*b[i + 6*ldb] + -1.468866762190367*b[i + 7*ldb] + -2.055207277795931*b[i + 8*ldb] + -1.880145437552564*b[i + 9*ldb]);
        c[i + 42*ldc] = (-0.03161745145272921*b[i + 1*ldb] + 0.03161745145272921*b[i + 3*ldb] + 0.1750618402433646*b[i + 4*ldb] + 0.02677969298108662*b[i + 5*ldb] + -0.1482821472622804*b[i + 6*ldb] + -0.1750618402433646*b[i + 7*ldb] + -0.02677969298108662*b[i + 8*ldb] + 0.1482821472622804*b[i + 9*ldb]);
        c[i + 43*ldc] = (-1.502821807911975*b[i + 0*ldb] + 0.5448394208769596*b[i + 1*ldb] + 0.5764568723296889*b[i + 2*ldb] + 3.352054625649612*b[i + 3*ldb] + 1.468866762190367*b[i + 4*ldb] + 2.055207277795931*b[i + 5*ldb] + 1.880145437552564*b[i + 6*ldb] + -0.9709142050655857*b[i + 7*ldb] + -0.8226320578033056*b[i + 8*ldb] + 1.442087069209281*b[i + 9*ldb]);
        c[i + 44*ldc] = (-0.2594862571830836*b[i + 0*ldb] + 0.09553209687774447*b[i + 1*ldb] + -2.135461924899462*b[i + 2*ldb] + 0.04322054596748309*b[i + 3*ldb] + -2.410929174359682*b[i + 4*ldb] + -0.02016410157632526*b[i + 5*ldb] + 0.2496244542710354*b[i + 6*ldb] + -2.059269458123622*b[i + 7*ldb] + 0.02177612369534747*b[i + 8*ldb] + -0.06009503669335015*b[i + 9*ldb]);
        c[i + 45*ldc] = (1.288308238382692*b[i + 0*ldb] + -0.813336618056223*b[i + 1*ldb] + 0.1146719895825324*b[i + 2*ldb] + -1.970896065380053*b[i + 3*ldb] + -0.6220087569997739*b[i + 4*ldb] + 0.2734547660549973*b[i + 5*ldb] + -1.928363752763298*b[i + 6*ldb] + 0.1647847391243889*b[i + 7*ldb] + 1.468505039653621*b[i + 8*ldb] + -1.520106975288837*b[i + 9*ldb]);
        c[i + 46*ldc] = (1.547794495565776*b[i + 0*ldb] + 0.07145144361504918*b[i + 1*ldb] + -0.9088687149339676*b[i + 2*ldb] + 0.1645658595194091*b[i + 3*ldb] + -1.541883098984185*b[i + 4*ldb] + 0.1309057053603245*b[i + 5*ldb] + 2.68438394041468*b[i + 6*ldb] + 1.528600076346972*b[i + 7*ldb] + -0.08483971514664668*b[i + 8*ldb] + -0.6018446554234487*b[i + 9*ldb]);
        c[i + 47*ldc] = (0.2594862571830836*b[i + 0*ldb] + -0.04322054596748309*b[i + 1*ldb] + 2.135461924899462*b[i + 2*ldb] + -0.09553209687774447*b[i + 3*ldb] + 2.059269458123622*b[i + 4*ldb] + -0.02177612369534747*b[i + 5*ldb] + 0.06009503669335015*b[i + 6*ldb] + 2.410929174359682*b[i + 7*ldb] + 0.02016410157632526*b[i + 8*ldb] + -0.2496244542710354*b[i + 9*ldb]);
        c[i + 48*ldc] = (-1.288308238382692*b[i + 0*ldb] + 1.970896065380053*b[i + 1*ldb] + -0.1146719895825324*b[i + 2*ldb] + 0.813336618056223*b[i + 3*ldb] + -0.1647847391243889*b[i + 4*ldb] + -1.468505039653621*b[i + 5*ldb] + 1.520106975288837*b[i + 6*ldb] + 0.6220087569997739*b[i + 7*ldb] + -0.2734547660549973*b[i + 8*ldb] + 1.928363752763298*b[i + 9*ldb]);
        c[i + 49*ldc] = (-1.547794495565776*b[i + 0*ldb] + -0.1645658595194091*b[i + 1*ldb] + 0.9088687149339676*b[i + 2*ldb] + -0.07145144361504918*b[i + 3*ldb] + -1.528600076346972*b[i + 4*ldb] + 0.08483971514664668*b[i + 5*ldb] + 0.6018446554234487*b[i + 6*ldb] + 1.541883098984185*b[i + 7*ldb] + -0.1309057053603245*b[i + 8*ldb] + -2.68438394041468*b[i + 9*ldb]);
        c[i + 50*ldc] = (-0.03017698203251321*b[i + 11*ldb] + 0.03017698203251321*b[i + 13*ldb] + 1.796678796499631*b[i + 14*ldb] + -0.03664146213189456*b[i + 15*ldb] + -1.833320258631525*b[i + 16*ldb] + -1.796678796499631*b[i + 17*ldb] + 0.03664146213189456*b[i + 18*ldb] + 1.833320258631525*b[i + 19*ldb]);
        c[i + 51*ldc] = (1.502821807911975*b[i + 10*ldb] + -3.352054625649612*b[i + 11*ldb] + -0.5764568723296889*b[i + 12*ldb] + -0.5448394208769596*b[i + 13*ldb] + 0.9709142050655857*b[i + 14*ldb] + 0.8226320578033056*b[i + 15*ldb] + -1.442087069209281*b[i + 16*ldb] + -1.468866762190367*b[i + 17*ldb] + -2.055207277795931*b[i + 18*ldb] + -1.880145437552564*b[i + 19*ldb]);
        c[i + 52*ldc] = (-0.03161745145272921*b[i + 11*ldb] + 0.03161745145272921*b[i + 13*ldb] + 0.1750618402433646*b[i + 14*ldb] + 0.02677969298108662*b[i + 15*ldb] + -0.1482821472622804*b[i + 16*ldb] + -0.1750618402433646*b[i + 17*ldb] + -0.02677969298108662*b[i + 18*ldb] + 0.1482821472622804*b[i + 19*ldb]);
        c[i + 53*ldc] = (-1.502821807911975*b[i + 10*ldb] + 0.5448394208769596*b[i + 11*ldb] + 0.5764568723296889*b[i + 12*ldb] + 3.352054625649612*b[i + 13*ldb] + 1.468866762190367*b[i + 14*ldb] + 2.055207277795931*b[i + 15*ldb] + 1.880145437552564*b[i + 16*ldb] + -0.9709142050655857*b[i + 17*ldb] + -0.8226320578033056*b[i + 18*ldb] + 1.442087069209281*b[i + 19*ldb]);
        c[i + 54*ldc] = (-0.2594862571830836*b[i + 10*ldb] + 0.09553209687774447*b[i + 11*ldb] + -2.135461924899462*b[i + 12*ldb] + 0.04322054596748309*b[i + 13*ldb] + -2.410929174359682*b[i + 14*ldb] + -0.02016410157632526*b[i + 15*ldb] + 0.2496244542710354*b[i + 16*ldb] + -2.059269458123622*b[i + 17*ldb] + 0.02177612369534747*b[i + 18*ldb] + -0.06009503669335015*b[i + 19*ldb]);
        c[i + 55*ldc] = (1.288308238382692*b[i + 10*ldb] + -0.813336618056223*b[i + 11*ldb] + 0.1146719895825324*b[i + 12*ldb] + -1.970896065380053*b[i + 13*ldb] + -0.6220087569997739*b[i + 14*ldb] + 0.2734547660549973*b[i + 15*ldb] + -1.928363752763298*b[i + 16*ldb] + 0.1647847391243889*b[i + 17*ldb] + 1.468505039653621*b[i + 18*ldb] + -1.520106975288837*b[i + 19*ldb]);
        c[i + 56*ldc] = (1.547794495565776*b[i + 10*ldb] + 0.07145144361504918*b[i + 11*ldb] + -0.9088687149339676*b[i + 12*ldb] + 0.1645658595194091*b[i + 13*ldb] + -1.541883098984185*b[i + 14*ldb] + 0.1309057053603245*b[i + 15*ldb] + 2.68438394041468*b[i + 16*ldb] + 1.528600076346972*b[i + 17*ldb] + -0.08483971514664668*b[i + 18*ldb] + -0.6018446554234487*b[i + 19*ldb]);
        c[i + 57*ldc] = (0.2594862571830836*b[i + 10*ldb] + -0.04322054596748309*b[i + 11*ldb] + 2.135461924899462*b[i + 12*ldb] + -0.09553209687774447*b[i + 13*ldb] + 2.059269458123622*b[i + 14*ldb] + -0.02177612369534747*b[i + 15*ldb] + 0.06009503669335015*b[i + 16*ldb] + 2.410929174359682*b[i + 17*ldb] + 0.02016410157632526*b[i + 18*ldb] + -0.2496244542710354*b[i + 19*ldb]);
        c[i + 58*ldc] = (-1.288308238382692*b[i + 10*ldb] + 1.970896065380053*b[i + 11*ldb] + -0.1146719895825324*b[i + 12*ldb] + 0.813336618056223*b[i + 13*ldb] + -0.1647847391243889*b[i + 14*ldb] + -1.468505039653621*b[i + 15*ldb] + 1.520106975288837*b[i + 16*ldb] + 0.6220087569997739*b[i + 17*ldb] + -0.2734547660549973*b[i + 18*ldb] + 1.928363752763298*b[i + 19*ldb]);
        c[i + 59*ldc] = (-1.547794495565776*b[i + 10*ldb] + -0.1645658595194091*b[i + 11*ldb] + 0.9088687149339676*b[i + 12*ldb] + -0.07145144361504918*b[i + 13*ldb] + -1.528600076346972*b[i + 14*ldb] + 0.08483971514664668*b[i + 15*ldb] + 0.6018446554234487*b[i + 16*ldb] + 1.541883098984185*b[i + 17*ldb] + -0.1309057053603245*b[i + 18*ldb] + -2.68438394041468*b[i + 19*ldb]);
        c[i + 60*ldc] = (-0.03017698203251321*b[i + 21*ldb] + 0.03017698203251321*b[i + 23*ldb] + 1.796678796499631*b[i + 24*ldb] + -0.03664146213189456*b[i + 25*ldb] + -1.833320258631525*b[i + 26*ldb] + -1.796678796499631*b[i + 27*ldb] + 0.03664146213189456*b[i + 28*ldb] + 1.833320258631525*b[i + 29*ldb]);
        c[i + 61*ldc] = (1.502821807911975*b[i + 20*ldb] + -3.352054625649612*b[i + 21*ldb] + -0.5764568723296889*b[i + 22*ldb] + -0.5448394208769596*b[i + 23*ldb] + 0.9709142050655857*b[i + 24*ldb] + 0.8226320578033056*b[i + 25*ldb] + -1.442087069209281*b[i + 26*ldb] + -1.468866762190367*b[i + 27*ldb] + -2.055207277795931*b[i + 28*ldb] + -1.880145437552564*b[i + 29*ldb]);
        c[i + 62*ldc] = (-0.03161745145272921*b[i + 21*ldb] + 0.03161745145272921*b[i + 23*ldb] + 0.1750618402433646*b[i + 24*ldb] + 0.02677969298108662*b[i + 25*ldb] + -0.1482821472622804*b[i + 26*ldb] + -0.1750618402433646*b[i + 27*ldb] + -0.02677969298108662*b[i + 28*ldb] + 0.1482821472622804*b[i + 29*ldb]);
        c[i + 63*ldc] = (-1.502821807911975*b[i + 20*ldb] + 0.5448394208769596*b[i + 21*ldb] + 0.5764568723296889*b[i + 22*ldb] + 3.352054625649612*b[i + 23*ldb] + 1.468866762190367*b[i + 24*ldb] + 2.055207277795931*b[i + 25*ldb] + 1.880145437552564*b[i + 26*ldb] + -0.9709142050655857*b[i + 27*ldb] + -0.8226320578033056*b[i + 28*ldb] + 1.442087069209281*b[i + 29*ldb]);
        c[i + 64*ldc] = (-0.2594862571830836*b[i + 20*ldb] + 0.09553209687774447*b[i + 21*ldb] + -2.135461924899462*b[i + 22*ldb] + 0.04322054596748309*b[i + 23*ldb] + -2.410929174359682*b[i + 24*ldb] + -0.02016410157632526*b[i + 25*ldb] + 0.2496244542710354*b[i + 26*ldb] + -2.059269458123622*b[i + 27*ldb] + 0.02177612369534747*b[i + 28*ldb] + -0.06009503669335015*b[i + 29*ldb]);
        c[i + 65*ldc] = (1.288308238382692*b[i + 20*ldb] + -0.813336618056223*b[i + 21*ldb] + 0.1146719895825324*b[i + 22*ldb] + -1.970896065380053*b[i + 23*ldb] + -0.6220087569997739*b[i + 24*ldb] + 0.2734547660549973*b[i + 25*ldb] + -1.928363752763298*b[i + 26*ldb] + 0.1647847391243889*b[i + 27*ldb] + 1.468505039653621*b[i + 28*ldb] + -1.520106975288837*b[i + 29*ldb]);
        c[i + 66*ldc] = (1.547794495565776*b[i + 20*ldb] + 0.07145144361504918*b[i + 21*ldb] + -0.9088687149339676*b[i + 22*ldb] + 0.1645658595194091*b[i + 23*ldb] + -1.541883098984185*b[i + 24*ldb] + 0.1309057053603245*b[i + 25*ldb] + 2.68438394041468*b[i + 26*ldb] + 1.528600076346972*b[i + 27*ldb] + -0.08483971514664668*b[i + 28*ldb] + -0.6018446554234487*b[i + 29*ldb]);
        c[i + 67*ldc] = (0.2594862571830836*b[i + 20*ldb] + -0.04322054596748309*b[i + 21*ldb] + 2.135461924899462*b[i + 22*ldb] + -0.09553209687774447*b[i + 23*ldb] + 2.059269458123622*b[i + 24*ldb] + -0.02177612369534747*b[i + 25*ldb] + 0.06009503669335015*b[i + 26*ldb] + 2.410929174359682*b[i + 27*ldb] + 0.02016410157632526*b[i + 28*ldb] + -0.2496244542710354*b[i + 29*ldb]);
        c[i + 68*ldc] = (-1.288308238382692*b[i + 20*ldb] + 1.970896065380053*b[i + 21*ldb] + -0.1146719895825324*b[i + 22*ldb] + 0.813336618056223*b[i + 23*ldb] + -0.1647847391243889*b[i + 24*ldb] + -1.468505039653621*b[i + 25*ldb] + 1.520106975288837*b[i + 26*ldb] + 0.6220087569997739*b[i + 27*ldb] + -0.2734547660549973*b[i + 28*ldb] + 1.928363752763298*b[i + 29*ldb]);
        c[i + 69*ldc] = (-1.547794495565776*b[i + 20*ldb] + -0.1645658595194091*b[i + 21*ldb] + 0.9088687149339676*b[i + 22*ldb] + -0.07145144361504918*b[i + 23*ldb] + -1.528600076346972*b[i + 24*ldb] + 0.08483971514664668*b[i + 25*ldb] + 0.6018446554234487*b[i + 26*ldb] + 1.541883098984185*b[i + 27*ldb] + -0.1309057053603245*b[i + 28*ldb] + -2.68438394041468*b[i + 29*ldb]);
        c[i + 70*ldc] = (-0.03017698203251321*b[i + 31*ldb] + 0.03017698203251321*b[i + 33*ldb] + 1.796678796499631*b[i + 34*ldb] + -0.03664146213189456*b[i + 35*ldb] + -1.833320258631525*b[i + 36*ldb] + -1.796678796499631*b[i + 37*ldb] + 0.03664146213189456*b[i + 38*ldb] + 1.833320258631525*b[i + 39*ldb]);
        c[i + 71*ldc] = (1.502821807911975*b[i + 30*ldb] + -3.352054625649612*b[i + 31*ldb] + -0.5764568723296889*b[i + 32*ldb] + -0.5448394208769596*b[i + 33*ldb] + 0.9709142050655857*b[i + 34*ldb] + 0.8226320578033056*b[i + 35*ldb] + -1.442087069209281*b[i + 36*ldb] + -1.468866762190367*b[i + 37*ldb] + -2.055207277795931*b[i + 38*ldb] + -1.880145437552564*b[i + 39*ldb]);
        c[i + 72*ldc] = (-0.03161745145272921*b[i + 31*ldb] + 0.03161745145272921*b[i + 33*ldb] + 0.1750618402433646*b[i + 34*ldb] + 0.02677969298108662*b[i + 35*ldb] + -0.1482821472622804*b[i + 36*ldb] + -0.1750618402433646*b[i + 37*ldb] + -0.02677969298108662*b[i + 38*ldb] + 0.1482821472622804*b[i + 39*ldb]);
        c[i + 73*ldc] = (-1.502821807911975*b[i + 30*ldb] + 0.5448394208769596*b[i + 31*ldb] + 0.5764568723296889*b[i + 32*ldb] + 3.352054625649612*b[i + 33*ldb] + 1.468866762190367*b[i + 34*ldb] + 2.055207277795931*b[i + 35*ldb] + 1.880145437552564*b[i + 36*ldb] + -0.9709142050655857*b[i + 37*ldb] + -0.8226320578033056*b[i + 38*ldb] + 1.442087069209281*b[i + 39*ldb]);
        c[i + 74*ldc] = (-0.2594862571830836*b[i + 30*ldb] + 0.09553209687774447*b[i + 31*ldb] + -2.135461924899462*b[i + 32*ldb] + 0.04322054596748309*b[i + 33*ldb] + -2.410929174359682*b[i + 34*ldb] + -0.02016410157632526*b[i + 35*ldb] + 0.2496244542710354*b[i + 36*ldb] + -2.059269458123622*b[i + 37*ldb] + 0.02177612369534747*b[i + 38*ldb] + -0.06009503669335015*b[i + 39*ldb]);
        c[i + 75*ldc] = (1.288308238382692*b[i + 30*ldb] + -0.813336618056223*b[i + 31*ldb] + 0.1146719895825324*b[i + 32*ldb] + -1.970896065380053*b[i + 33*ldb] + -0.6220087569997739*b[i + 34*ldb] + 0.2734547660549973*b[i + 35*ldb] + -1.928363752763298*b[i + 36*ldb] + 0.1647847391243889*b[i + 37*ldb] + 1.468505039653621*b[i + 38*ldb] + -1.520106975288837*b[i + 39*ldb]);
        c[i + 76*ldc] = (1.547794495565776*b[i + 30*ldb] + 0.07145144361504918*b[i + 31*ldb] + -0.9088687149339676*b[i + 32*ldb] + 0.1645658595194091*b[i + 33*ldb] + -1.541883098984185*b[i + 34*ldb] + 0.1309057053603245*b[i + 35*ldb] + 2.68438394041468*b[i + 36*ldb] + 1.528600076346972*b[i + 37*ldb] + -0.08483971514664668*b[i + 38*ldb] + -0.6018446554234487*b[i + 39*ldb]);
        c[i + 77*ldc] = (0.2594862571830836*b[i + 30*ldb] + -0.04322054596748309*b[i + 31*ldb] + 2.135461924899462*b[i + 32*ldb] + -0.09553209687774447*b[i + 33*ldb] + 2.059269458123622*b[i + 34*ldb] + -0.02177612369534747*b[i + 35*ldb] + 0.06009503669335015*b[i + 36*ldb] + 2.410929174359682*b[i + 37*ldb] + 0.02016410157632526*b[i + 38*ldb] + -0.2496244542710354*b[i + 39*ldb]);
        c[i + 78*ldc] = (-1.288308238382692*b[i + 30*ldb] + 1.970896065380053*b[i + 31*ldb] + -0.1146719895825324*b[i + 32*ldb] + 0.813336618056223*b[i + 33*ldb] + -0.1647847391243889*b[i + 34*ldb] + -1.468505039653621*b[i + 35*ldb] + 1.520106975288837*b[i + 36*ldb] + 0.6220087569997739*b[i + 37*ldb] + -0.2734547660549973*b[i + 38*ldb] + 1.928363752763298*b[i + 39*ldb]);
        c[i + 79*ldc] = (-1.547794495565776*b[i + 30*ldb] + -0.1645658595194091*b[i + 31*ldb] + 0.9088687149339676*b[i + 32*ldb] + -0.07145144361504918*b[i + 33*ldb] + -1.528600076346972*b[i + 34*ldb] + 0.08483971514664668*b[i + 35*ldb] + 0.6018446554234487*b[i + 36*ldb] + 1.541883098984185*b[i + 37*ldb] + -0.1309057053603245*b[i + 38*ldb] + -2.68438394041468*b[i + 39*ldb]);
        c[i + 80*ldc] = (3.332000236352239*b[i + 0*ldb] + 1.420240467903609*b[i + 10*ldb] + -0.6162310439495416*b[i + 20*ldb] + 0.5806281691622632*b[i + 30*ldb]);
        c[i + 81*ldc] = (3.332000236352239*b[i + 1*ldb] + 1.420240467903609*b[i + 11*ldb] + -0.6162310439495416*b[i + 21*ldb] + 0.5806281691622632*b[i + 31*ldb]);
        c[i + 82*ldc] = (3.332000236352239*b[i + 2*ldb] + 1.420240467903609*b[i + 12*ldb] + -0.6162310439495416*b[i + 22*ldb] + 0.5806281691622632*b[i + 32*ldb]);
        c[i + 83*ldc] = (3.332000236352239*b[i + 3*ldb] + 1.420240467903609*b[i + 13*ldb] + -0.6162310439495416*b[i + 23*ldb] + 0.5806281691622632*b[i + 33*ldb]);
        c[i + 84*ldc] = (3.332000236352239*b[i + 4*ldb] + 1.420240467903609*b[i + 14*ldb] + -0.6162310439495416*b[i + 24*ldb] + 0.5806281691622632*b[i + 34*ldb]);
        c[i + 85*ldc] = (3.332000236352239*b[i + 5*ldb] + 1.420240467903609*b[i + 15*ldb] + -0.6162310439495416*b[i + 25*ldb] + 0.5806281691622632*b[i + 35*ldb]);
        c[i + 86*ldc] = (3.332000236352239*b[i + 6*ldb] + 1.420240467903609*b[i + 16*ldb] + -0.6162310439495416*b[i + 26*ldb] + 0.5806281691622632*b[i + 36*ldb]);
        c[i + 87*ldc] = (3.332000236352239*b[i + 7*ldb] + 1.420240467903609*b[i + 17*ldb] + -0.6162310439495416*b[i + 27*ldb] + 0.5806281691622632*b[i + 37*ldb]);
        c[i + 88*ldc] = (3.332000236352239*b[i + 8*ldb] + 1.420240467903609*b[i + 18*ldb] + -0.6162310439495416*b[i + 28*ldb] + 0.5806281691622632*b[i + 38*ldb]);
        c[i + 89*ldc] = (3.332000236352239*b[i + 9*ldb] + 1.420240467903609*b[i + 19*ldb] + -0.6162310439495416*b[i + 29*ldb] + 0.5806281691622632*b[i + 39*ldb]);
        c[i + 90*ldc] = (-2.592410982442422*b[i + 0*ldb] + 0.3844143922232035*b[i + 10*ldb] + 1.470670231280717*b[i + 20*ldb] + -1.124826508017214*b[i + 30*ldb]);
        c[i + 91*ldc] = (-2.592410982442422*b[i + 1*ldb] + 0.3844143922232035*b[i + 11*ldb] + 1.470670231280717*b[i + 21*ldb] + -1.124826508017214*b[i + 31*ldb]);
        c[i + 92*ldc] = (-2.592410982442422*b[i + 2*ldb] + 0.3844143922232035*b[i + 12*ldb] + 1.470670231280717*b[i + 22*ldb] + -1.124826508017214*b[i + 32*ldb]);
        c[i + 93*ldc] = (-2.592410982442422*b[i + 3*ldb] + 0.3844143922232035*b[i + 13*ldb] + 1.470670231280717*b[i + 23*ldb] + -1.124826508017214*b[i + 33*ldb]);
        c[i + 94*ldc] = (-2.592410982442422*b[i + 4*ldb] + 0.3844143922232035*b[i + 14*ldb] + 1.470670231280717*b[i + 24*ldb] + -1.124826508017214*b[i + 34*ldb]);
        c[i + 95*ldc] = (-2.592410982442422*b[i + 5*ldb] + 0.3844143922232035*b[i + 15*ldb] + 1.470670231280717*b[i + 25*ldb] + -1.124826508017214*b[i + 35*ldb]);
        c[i + 96*ldc] = (-2.592410982442422*b[i + 6*ldb] + 0.3844143922232035*b[i + 16*ldb] + 1.470670231280717*b[i + 26*ldb] + -1.124826508017214*b[i + 36*ldb]);
        c[i + 97*ldc] = (-2.592410982442422*b[i + 7*ldb] + 0.3844143922232035*b[i + 17*ldb] + 1.470670231280717*b[i + 27*ldb] + -1.124826508017214*b[i + 37*ldb]);
        c[i + 98*ldc] = (-2.592410982442422*b[i + 8*ldb] + 0.3844143922232035*b[i + 18*ldb] + 1.470670231280717*b[i + 28*ldb] + -1.124826508017214*b[i + 38*ldb]);
        c[i + 99*ldc] = (-2.592410982442422*b[i + 9*ldb] + 0.3844143922232035*b[i + 19*ldb] + 1.470670231280717*b[i + 29*ldb] + -1.124826508017214*b[i + 39*ldb]);
        c[i + 100*ldc] = (1.124826508017214*b[i + 0*ldb] + -1.470670231280717*b[i + 10*ldb] + -0.3844143922232035*b[i + 20*ldb] + 2.592410982442422*b[i + 30*ldb]);
        c[i + 101*ldc] = (1.124826508017214*b[i + 1*ldb] + -1.470670231280717*b[i + 11*ldb] + -0.3844143922232035*b[i + 21*ldb] + 2.592410982442422*b[i + 31*ldb]);
        c[i + 102*ldc] = (1.124826508017214*b[i + 2*ldb] + -1.470670231280717*b[i + 12*ldb] + -0.3844143922232035*b[i + 22*ldb] + 2.592410982442422*b[i + 32*ldb]);
        c[i + 103*ldc] = (1.124826508017214*b[i + 3*ldb] + -1.470670231280717*b[i + 13*ldb] + -0.3844143922232035*b[i + 23*ldb] + 2.592410982442422*b[i + 33*ldb]);
        c[i + 104*ldc] = (1.124826508017214*b[i + 4*ldb] + -1.470670231280717*b[i + 14*ldb] + -0.3844143922232035*b[i + 24*ldb] + 2.592410982442422*b[i + 34*ldb]);
        c[i + 105*ldc] = (1.124826508017214*b[i + 5*ldb] + -1.470670231280717*b[i + 15*ldb] + -0.3844143922232035*b[i + 25*ldb] + 2.592410982442422*b[i + 35*ldb]);
        c[i + 106*ldc] = (1.124826508017214*b[i + 6*ldb] + -1.470670231280717*b[i + 16*ldb] + -0.3844143922232035*b[i + 26*ldb] + 2.592410982442422*b[i + 36*ldb]);
        c[i + 107*ldc] = (1.124826508017214*b[i + 7*ldb] + -1.470670231280717*b[i + 17*ldb] + -0.3844143922232035*b[i + 27*ldb] + 2.592410982442422*b[i + 37*ldb]);
        c[i + 108*ldc] = (1.124826508017214*b[i + 8*ldb] + -1.470670231280717*b[i + 18*ldb] + -0.3844143922232035*b[i + 28*ldb] + 2.592410982442422*b[i + 38*ldb]);
        c[i + 109*ldc] = (1.124826508017214*b[i + 9*ldb] + -1.470670231280717*b[i + 19*ldb] + -0.3844143922232035*b[i + 29*ldb] + 2.592410982442422*b[i + 39*ldb]);
        c[i + 110*ldc] = (-0.5806281691622632*b[i + 0*ldb] + 0.6162310439495416*b[i + 10*ldb] + -1.420240467903609*b[i + 20*ldb] + -3.332000236352239*b[i + 30*ldb]);
        c[i + 111*ldc] = (-0.5806281691622632*b[i + 1*ldb] + 0.6162310439495416*b[i + 11*ldb] + -1.420240467903609*b[i + 21*ldb] + -3.332000236352239*b[i + 31*ldb]);
        c[i + 112*ldc] = (-0.5806281691622632*b[i + 2*ldb] + 0.6162310439495416*b[i + 12*ldb] + -1.420240467903609*b[i + 22*ldb] + -3.332000236352239*b[i + 32*ldb]);
        c[i + 113*ldc] = (-0.5806281691622632*b[i + 3*ldb] + 0.6162310439495416*b[i + 13*ldb] + -1.420240467903609*b[i + 23*ldb] + -3.332000236352239*b[i + 33*ldb]);
        c[i + 114*ldc] = (-0.5806281691622632*b[i + 4*ldb] + 0.6162310439495416*b[i + 14*ldb] + -1.420240467903609*b[i + 24*ldb] + -3.332000236352239*b[i + 34*ldb]);
        c[i + 115*ldc] = (-0.5806281691622632*b[i + 5*ldb] + 0.6162310439495416*b[i + 15*ldb] + -1.420240467903609*b[i + 25*ldb] + -3.332000236352239*b[i + 35*ldb]);
        c[i + 116*ldc] = (-0.5806281691622632*b[i + 6*ldb] + 0.6162310439495416*b[i + 16*ldb] + -1.420240467903609*b[i + 26*ldb] + -3.332000236352239*b[i + 36*ldb]);
        c[i + 117*ldc] = (-0.5806281691622632*b[i + 7*ldb] + 0.6162310439495416*b[i + 17*ldb] + -1.420240467903609*b[i + 27*ldb] + -3.332000236352239*b[i + 37*ldb]);
        c[i + 118*ldc] = (-0.5806281691622632*b[i + 8*ldb] + 0.6162310439495416*b[i + 18*ldb] + -1.420240467903609*b[i + 28*ldb] + -3.332000236352239*b[i + 38*ldb]);
        c[i + 119*ldc] = (-0.5806281691622632*b[i + 9*ldb] + 0.6162310439495416*b[i + 19*ldb] + -1.420240467903609*b[i + 29*ldb] + -3.332000236352239*b[i + 39*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p3_pri_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (-0.03017698203251321*b[i + 2*ldb] + 0.03017698203251321*b[i + 3*ldb] + 1.833320258631525*b[i + 4*ldb] + -1.833320258631525*b[i + 5*ldb] + -0.03664146213189456*b[i + 6*ldb] + 0.03664146213189456*b[i + 7*ldb] + -1.796678796499631*b[i + 8*ldb] + 1.796678796499631*b[i + 9*ldb] + -0.03017698203251321*b[i + 41*ldb] + 0.03017698203251321*b[i + 43*ldb] + 1.796678796499631*b[i + 44*ldb] + -0.03664146213189456*b[i + 45*ldb] + -1.833320258631525*b[i + 46*ldb] + -1.796678796499631*b[i + 47*ldb] + 0.03664146213189456*b[i + 48*ldb] + 1.833320258631525*b[i + 49*ldb] + 3.332000236352239*b[i + 80*ldb] + 1.420240467903609*b[i + 90*ldb] + -0.6162310439495416*b[i + 100*ldb] + 0.5806281691622632*b[i + 110*ldb]);
        c[i + 1*ldc] = (-0.03161745145272921*b[i + 2*ldb] + 0.03161745145272921*b[i + 3*ldb] + 0.1482821472622804*b[i + 4*ldb] + -0.1482821472622804*b[i + 5*ldb] + 0.02677969298108662*b[i + 6*ldb] + -0.02677969298108662*b[i + 7*ldb] + -0.1750618402433646*b[i + 8*ldb] + 0.1750618402433646*b[i + 9*ldb] + 1.502821807911975*b[i + 40*ldb] + -3.352054625649612*b[i + 41*ldb] + -0.5764568723296889*b[i + 42*ldb] + -0.5448394208769596*b[i + 43*ldb] + 0.9709142050655857*b[i + 44*ldb] + 0.8226320578033056*b[i + 45*ldb] + -1.442087069209281*b[i + 46*ldb] + -1.468866762190367*b[i + 47*ldb] + -2.055207277795931*b[i + 48*ldb] + -1.880145437552564*b[i + 49*ldb] + 3.332000236352239*b[i + 81*ldb] + 1.420240467903609*b[i + 91*ldb] + -0.6162310439495416*b[i + 101*ldb] + 0.5806281691622632*b[i + 111*ldb]);
        c[i + 2*ldc] = (1.502821807911975*b[i + 0*ldb] + -0.5764568723296889*b[i + 1*ldb] + -3.352054625649612*b[i + 2*ldb] + -0.5448394208769596*b[i + 3*ldb] + -1.880145437552564*b[i + 4*ldb] + -1.442087069209281*b[i + 5*ldb] + 0.8226320578033056*b[i + 6*ldb] + -2.055207277795931*b[i + 7*ldb] + -1.468866762190367*b[i + 8*ldb] + 0.9709142050655857*b[i + 9*ldb] + -0.03161745145272921*b[i + 41*ldb] + 0.03161745145272921*b[i + 43*ldb] + 0.1750618402433646*b[i + 44*ldb] + 0.02677969298108662*b[i + 45*ldb] + -0.1482821472622804*b[i + 46*ldb] + -0.1750618402433646*b[i + 47*ldb] + -0.02677969298108662*b[i + 48*ldb] + 0.1482821472622804*b[i + 49*ldb] + 3.332000236352239*b[i + 82*ldb] + 1.420240467903609*b[i + 92*ldb] + -0.6162310439495416*b[i + 102*ldb] + 0.5806281691622632*b[i + 112*ldb]);
        c[i + 3*ldc] = (-1.502821807911975*b[i + 0*ldb] + 0.5764568723296889*b[i + 1*ldb] + 0.5448394208769596*b[i + 2*ldb] + 3.352054625649612*b[i + 3*ldb] + 1.442087069209281*b[i + 4*ldb] + 1.880145437552564*b[i + 5*ldb] + 2.055207277795931*b[i + 6*ldb] + -0.8226320578033056*b[i + 7*ldb] + -0.9709142050655857*b[i + 8*ldb] + 1.468866762190367*b[i + 9*ldb] + -1.502821807911975*b[i + 40*ldb] + 0.5448394208769596*b[i + 41*ldb] + 0.5764568723296889*b[i + 42*ldb] + 3.352054625649612*b[i + 43*ldb] + 1.468866762190367*b[i + 44*ldb] + 2.055207277795931*b[i + 45*ldb] + 1.880145437552564*b[i + 46*ldb] + -0.9709142050655857*b[i + 47*ldb] + -0.8226320578033056*b[i + 48*ldb] + 1.442087069209281*b[i + 49*ldb] + 3.332000236352239*b[i + 83*ldb] + 1.420240467903609*b[i + 93*ldb] + -0.6162310439495416*b[i + 103*ldb] + 0.5806281691622632*b[i + 113*ldb]);
        c[i + 4*ldc] = (-1.547794495565776*b[i + 0*ldb] + 0.9088687149339676*b[i + 1*ldb] + -0.1645658595194091*b[i + 2*ldb] + -0.07145144361504918*b[i + 3*ldb] + -2.68438394041468*b[i + 4*ldb] + 0.6018446554234487*b[i + 5*ldb] + 0.08483971514664668*b[i + 6*ldb] + -0.1309057053603245*b[i + 7*ldb] + 1.541883098984185*b[i + 8*ldb] + -1.528600076346972*b[i + 9*ldb] + -0.2594862571830836*b[i + 40*ldb] + 0.09553209687774447*b[i + 41*ldb] + -2.135461924899462*b[i + 42*ldb] + 0.04322054596748309*b[i + 43*ldb] + -2.410929174359682*b[i + 44*ldb] + -0.02016410157632526*b[i + 45*ldb] + 0.2496244542710354*b[i + 46*ldb] + -2.059269458123622*b[i + 47*ldb] + 0.02177612369534747*b[i + 48*ldb] + -0.06009503669335015*b[i + 49*ldb] + 3.332000236352239*b[i + 84*ldb] + 1.420240467903609*b[i + 94*ldb] + -0.6162310439495416*b[i + 104*ldb] + 0.5806281691622632*b[i + 114*ldb]);
        c[i + 5*ldc] = (1.547794495565776*b[i + 0*ldb] + -0.9088687149339676*b[i + 1*ldb] + 0.07145144361504918*b[i + 2*ldb] + 0.1645658595194091*b[i + 3*ldb] + -0.6018446554234487*b[i + 4*ldb] + 2.68438394041468*b[i + 5*ldb] + 0.1309057053603245*b[i + 6*ldb] + -0.08483971514664668*b[i + 7*ldb] + 1.528600076346972*b[i + 8*ldb] + -1.541883098984185*b[i + 9*ldb] + 1.288308238382692*b[i + 40*ldb] + -0.813336618056223*b[i + 41*ldb] + 0.1146719895825324*b[i + 42*ldb] + -1.970896065380053*b[i + 43*ldb] + -0.6220087569997739*b[i + 44*ldb] + 0.2734547660549973*b[i + 45*ldb] + -1.928363752763298*b[i + 46*ldb] + 0.1647847391243889*b[i + 47*ldb] + 1.468505039653621*b[i + 48*ldb] + -1.520106975288837*b[i + 49*ldb] + 3.332000236352239*b[i + 85*ldb] + 1.420240467903609*b[i + 95*ldb] + -0.6162310439495416*b[i + 105*ldb] + 0.5806281691622632*b[i + 115*ldb]);
        c[i + 6*ldc] = (1.288308238382692*b[i + 0*ldb] + 0.1146719895825324*b[i + 1*ldb] + -0.813336618056223*b[i + 2*ldb] + -1.970896065380053*b[i + 3*ldb] + -1.520106975288837*b[i + 4*ldb] + -1.928363752763298*b[i + 5*ldb] + 0.2734547660549973*b[i + 6*ldb] + 1.468505039653621*b[i + 7*ldb] + 0.1647847391243889*b[i + 8*ldb] + -0.6220087569997739*b[i + 9*ldb] + 1.547794495565776*b[i + 40*ldb] + 0.07145144361504918*b[i + 41*ldb] + -0.9088687149339676*b[i + 42*ldb] + 0.1645658595194091*b[i + 43*ldb] + -1.541883098984185*b[i + 44*ldb] + 0.1309057053603245*b[i + 45*ldb] + 2.68438394041468*b[i + 46*ldb] + 1.528600076346972*b[i + 47*ldb] + -0.08483971514664668*b[i + 48*ldb] + -0.6018446554234487*b[i + 49*ldb] + 3.332000236352239*b[i + 86*ldb] + 1.420240467903609*b[i + 96*ldb] + -0.6162310439495416*b[i + 106*ldb] + 0.5806281691622632*b[i + 116*ldb]);
        c[i + 7*ldc] = (-1.288308238382692*b[i + 0*ldb] + -0.1146719895825324*b[i + 1*ldb] + 1.970896065380053*b[i + 2*ldb] + 0.813336618056223*b[i + 3*ldb] + 1.928363752763298*b[i + 4*ldb] + 1.520106975288837*b[i + 5*ldb] + -1.468505039653621*b[i + 6*ldb] + -0.2734547660549973*b[i + 7*ldb] + 0.6220087569997739*b[i + 8*ldb] + -0.1647847391243889*b[i + 9*ldb] + 0.2594862571830836*b[i + 40*ldb] + -0.04322054596748309*b[i + 41*ldb] + 2.135461924899462*b[i + 42*ldb] + -0.09553209687774447*b[i + 43*ldb] + 2.059269458123622*b[i + 44*ldb] + -0.02177612369534747*b[i + 45*ldb] + 0.06009503669335015*b[i + 46*ldb] + 2.410929174359682*b[i + 47*ldb] + 0.02016410157632526*b[i + 48*ldb] + -0.2496244542710354*b[i + 49*ldb] + 3.332000236352239*b[i + 87*ldb] + 1.420240467903609*b[i + 97*ldb] + -0.6162310439495416*b[i + 107*ldb] + 0.5806281691622632*b[i + 117*ldb]);
        c[i + 8*ldc] = (0.2594862571830836*b[i + 0*ldb] + 2.135461924899462*b[i + 1*ldb] + -0.04322054596748309*b[i + 2*ldb] + -0.09553209687774447*b[i + 3*ldb] + -0.2496244542710354*b[i + 4*ldb] + 0.06009503669335015*b[i + 5*ldb] + -0.02177612369534747*b[i + 6*ldb] + 0.02016410157632526*b[i + 7*ldb] + 2.410929174359682*b[i + 8*ldb] + 2.059269458123622*b[i + 9*ldb] + -1.288308238382692*b[i + 40*ldb] + 1.970896065380053*b[i + 41*ldb] + -0.1146719895825324*b[i + 42*ldb] + 0.813336618056223*b[i + 43*ldb] + -0.1647847391243889*b[i + 44*ldb] + -1.468505039653621*b[i + 45*ldb] + 1.520106975288837*b[i + 46*ldb] + 0.6220087569997739*b[i + 47*ldb] + -0.2734547660549973*b[i + 48*ldb] + 1.928363752763298*b[i + 49*ldb] + 3.332000236352239*b[i + 88*ldb] + 1.420240467903609*b[i + 98*ldb] + -0.6162310439495416*b[i + 108*ldb] + 0.5806281691622632*b[i + 118*ldb]);
        c[i + 9*ldc] = (-0.2594862571830836*b[i + 0*ldb] + -2.135461924899462*b[i + 1*ldb] + 0.09553209687774447*b[i + 2*ldb] + 0.04322054596748309*b[i + 3*ldb] + -0.06009503669335015*b[i + 4*ldb] + 0.2496244542710354*b[i + 5*ldb] + -0.02016410157632526*b[i + 6*ldb] + 0.02177612369534747*b[i + 7*ldb] + -2.059269458123622*b[i + 8*ldb] + -2.410929174359682*b[i + 9*ldb] + -1.547794495565776*b[i + 40*ldb] + -0.1645658595194091*b[i + 41*ldb] + 0.9088687149339676*b[i + 42*ldb] + -0.07145144361504918*b[i + 43*ldb] + -1.528600076346972*b[i + 44*ldb] + 0.08483971514664668*b[i + 45*ldb] + 0.6018446554234487*b[i + 46*ldb] + 1.541883098984185*b[i + 47*ldb] + -0.1309057053603245*b[i + 48*ldb] + -2.68438394041468*b[i + 49*ldb] + 3.332000236352239*b[i + 89*ldb] + 1.420240467903609*b[i + 99*ldb] + -0.6162310439495416*b[i + 109*ldb] + 0.5806281691622632*b[i + 119*ldb]);
        c[i + 10*ldc] = (-0.03017698203251321*b[i + 12*ldb] + 0.03017698203251321*b[i + 13*ldb] + 1.833320258631525*b[i + 14*ldb] + -1.833320258631525*b[i + 15*ldb] + -0.03664146213189456*b[i + 16*ldb] + 0.03664146213189456*b[i + 17*ldb] + -1.796678796499631*b[i + 18*ldb] + 1.796678796499631*b[i + 19*ldb] + -0.03017698203251321*b[i + 51*ldb] + 0.03017698203251321*b[i + 53*ldb] + 1.796678796499631*b[i + 54*ldb] + -0.03664146213189456*b[i + 55*ldb] + -1.833320258631525*b[i + 56*ldb] + -1.796678796499631*b[i + 57*ldb] + 0.03664146213189456*b[i + 58*ldb] + 1.833320258631525*b[i + 59*ldb] + -2.592410982442422*b[i + 80*ldb] + 0.3844143922232035*b[i + 90*ldb] + 1.470670231280717*b[i + 100*ldb] + -1.124826508017214*b[i + 110*ldb]);
        c[i + 11*ldc] = (-0.03161745145272921*b[i + 12*ldb] + 0.03161745145272921*b[i + 13*ldb] + 0.1482821472622804*b[i + 14*ldb] + -0.1482821472622804*b[i + 15*ldb] + 0.02677969298108662*b[i + 16*ldb] + -0.02677969298108662*b[i + 17*ldb] + -0.1750618402433646*b[i + 18*ldb] + 0.1750618402433646*b[i + 19*ldb] + 1.502821807911975*b[i + 50*ldb] + -3.352054625649612*b[i + 51*ldb] + -0.5764568723296889*b[i + 52*ldb] + -0.5448394208769596*b[i + 53*ldb] + 0.9709142050655857*b[i + 54*ldb] + 0.8226320578033056*b[i + 55*ldb] + -1.442087069209281*b[i + 56*ldb] + -1.468866762190367*b[i + 57*ldb] + -2.055207277795931*b[i + 58*ldb] + -1.880145437552564*b[i + 59*ldb] + -2.592410982442422*b[i + 81*ldb] + 0.3844143922232035*b[i + 91*ldb] + 1.470670231280717*b[i + 101*ldb] + -1.124826508017214*b[i + 111*ldb]);
        c[i + 12*ldc] = (1.502821807911975*b[i + 10*ldb] + -0.5764568723296889*b[i + 11*ldb] + -3.352054625649612*b[i + 12*ldb] + -0.5448394208769596*b[i + 13*ldb] + -1.880145437552564*b[i + 14*ldb] + -1.442087069209281*b[i + 15*ldb] + 0.8226320578033056*b[i + 16*ldb] + -2.055207277795931*b[i + 17*ldb] + -1.468866762190367*b[i + 18*ldb] + 0.9709142050655857*b[i + 19*ldb] + -0.03161745145272921*b[i + 51*ldb] + 0.03161745145272921*b[i + 53*ldb] + 0.1750618402433646*b[i + 54*ldb] + 0.02677969298108662*b[i + 55*ldb] + -0.1482821472622804*b[i + 56*ldb] + -0.1750618402433646*b[i + 57*ldb] + -0.02677969298108662*b[i + 58*ldb] + 0.1482821472622804*b[i + 59*ldb] + -2.592410982442422*b[i + 82*ldb] + 0.3844143922232035*b[i + 92*ldb] + 1.470670231280717*b[i + 102*ldb] + -1.124826508017214*b[i + 112*ldb]);
        c[i + 13*ldc] = (-1.502821807911975*b[i + 10*ldb] + 0.5764568723296889*b[i + 11*ldb] + 0.5448394208769596*b[i + 12*ldb] + 3.352054625649612*b[i + 13*ldb] + 1.442087069209281*b[i + 14*ldb] + 1.880145437552564*b[i + 15*ldb] + 2.055207277795931*b[i + 16*ldb] + -0.8226320578033056*b[i + 17*ldb] + -0.9709142050655857*b[i + 18*ldb] + 1.468866762190367*b[i + 19*ldb] + -1.502821807911975*b[i + 50*ldb] + 0.5448394208769596*b[i + 51*ldb] + 0.5764568723296889*b[i + 52*ldb] + 3.352054625649612*b[i + 53*ldb] + 1.468866762190367*b[i + 54*ldb] + 2.055207277795931*b[i + 55*ldb] + 1.880145437552564*b[i + 56*ldb] + -0.9709142050655857*b[i + 57*ldb] + -0.8226320578033056*b[i + 58*ldb] + 1.442087069209281*b[i + 59*ldb] + -2.592410982442422*b[i + 83*ldb] + 0.3844143922232035*b[i + 93*ldb] + 1.470670231280717*b[i + 103*ldb] + -1.124826508017214*b[i + 113*ldb]);
        c[i + 14*ldc] = (-1.547794495565776*b[i + 10*ldb] + 0.9088687149339676*b[i + 11*ldb] + -0.1645658595194091*b[i + 12*ldb] + -0.07145144361504918*b[i + 13*ldb] + -2.68438394041468*b[i + 14*ldb] + 0.6018446554234487*b[i + 15*ldb] + 0.08483971514664668*b[i + 16*ldb] + -0.1309057053603245*b[i + 17*ldb] + 1.541883098984185*b[i + 18*ldb] + -1.528600076346972*b[i + 19*ldb] + -0.2594862571830836*b[i + 50*ldb] + 0.09553209687774447*b[i + 51*ldb] + -2.135461924899462*b[i + 52*ldb] + 0.04322054596748309*b[i + 53*ldb] + -2.410929174359682*b[i + 54*ldb] + -0.02016410157632526*b[i + 55*ldb] + 0.2496244542710354*b[i + 56*ldb] + -2.059269458123622*b[i + 57*ldb] + 0.02177612369534747*b[i + 58*ldb] + -0.06009503669335015*b[i + 59*ldb] + -2.592410982442422*b[i + 84*ldb] + 0.3844143922232035*b[i + 94*ldb] + 1.470670231280717*b[i + 104*ldb] + -1.124826508017214*b[i + 114*ldb]);
        c[i + 15*ldc] = (1.547794495565776*b[i + 10*ldb] + -0.9088687149339676*b[i + 11*ldb] + 0.07145144361504918*b[i + 12*ldb] + 0.1645658595194091*b[i + 13*ldb] + -0.6018446554234487*b[i + 14*ldb] + 2.68438394041468*b[i + 15*ldb] + 0.1309057053603245*b[i + 16*ldb] + -0.08483971514664668*b[i + 17*ldb] + 1.528600076346972*b[i + 18*ldb] + -1.541883098984185*b[i + 19*ldb] + 1.288308238382692*b[i + 50*ldb] + -0.813336618056223*b[i + 51*ldb] + 0.1146719895825324*b[i + 52*ldb] + -1.970896065380053*b[i + 53*ldb] + -0.6220087569997739*b[i + 54*ldb] + 0.2734547660549973*b[i + 55*ldb] + -1.928363752763298*b[i + 56*ldb] + 0.1647847391243889*b[i + 57*ldb] + 1.468505039653621*b[i + 58*ldb] + -1.520106975288837*b[i + 59*ldb] + -2.592410982442422*b[i + 85*ldb] + 0.3844143922232035*b[i + 95*ldb] + 1.470670231280717*b[i + 105*ldb] + -1.124826508017214*b[i + 115*ldb]);
        c[i + 16*ldc] = (1.288308238382692*b[i + 10*ldb] + 0.1146719895825324*b[i + 11*ldb] + -0.813336618056223*b[i + 12*ldb] + -1.970896065380053*b[i + 13*ldb] + -1.520106975288837*b[i + 14*ldb] + -1.928363752763298*b[i + 15*ldb] + 0.2734547660549973*b[i + 16*ldb] + 1.468505039653621*b[i + 17*ldb] + 0.1647847391243889*b[i + 18*ldb] + -0.6220087569997739*b[i + 19*ldb] + 1.547794495565776*b[i + 50*ldb] + 0.07145144361504918*b[i + 51*ldb] + -0.9088687149339676*b[i + 52*ldb] + 0.1645658595194091*b[i + 53*ldb] + -1.541883098984185*b[i + 54*ldb] + 0.1309057053603245*b[i + 55*ldb] + 2.68438394041468*b[i + 56*ldb] + 1.528600076346972*b[i + 57*ldb] + -0.08483971514664668*b[i + 58*ldb] + -0.6018446554234487*b[i + 59*ldb] + -2.592410982442422*b[i + 86*ldb] + 0.3844143922232035*b[i + 96*ldb] + 1.470670231280717*b[i + 106*ldb] + -1.124826508017214*b[i + 116*ldb]);
        c[i + 17*ldc] = (-1.288308238382692*b[i + 10*ldb] + -0.1146719895825324*b[i + 11*ldb] + 1.970896065380053*b[i + 12*ldb] + 0.813336618056223*b[i + 13*ldb] + 1.928363752763298*b[i + 14*ldb] + 1.520106975288837*b[i + 15*ldb] + -1.468505039653621*b[i + 16*ldb] + -0.2734547660549973*b[i + 17*ldb] + 0.6220087569997739*b[i + 18*ldb] + -0.1647847391243889*b[i + 19*ldb] + 0.2594862571830836*b[i + 50*ldb] + -0.04322054596748309*b[i + 51*ldb] + 2.135461924899462*b[i + 52*ldb] + -0.09553209687774447*b[i + 53*ldb] + 2.059269458123622*b[i + 54*ldb] + -0.02177612369534747*b[i + 55*ldb] + 0.06009503669335015*b[i + 56*ldb] + 2.410929174359682*b[i + 57*ldb] + 0.02016410157632526*b[i + 58*ldb] + -0.2496244542710354*b[i + 59*ldb] + -2.592410982442422*b[i + 87*ldb] + 0.3844143922232035*b[i + 97*ldb] + 1.470670231280717*b[i + 107*ldb] + -1.124826508017214*b[i + 117*ldb]);
        c[i + 18*ldc] = (0.2594862571830836*b[i + 10*ldb] + 2.135461924899462*b[i + 11*ldb] + -0.04322054596748309*b[i + 12*ldb] + -0.09553209687774447*b[i + 13*ldb] + -0.2496244542710354*b[i + 14*ldb] + 0.06009503669335015*b[i + 15*ldb] + -0.02177612369534747*b[i + 16*ldb] + 0.02016410157632526*b[i + 17*ldb] + 2.410929174359682*b[i + 18*ldb] + 2.059269458123622*b[i + 19*ldb] + -1.288308238382692*b[i + 50*ldb] + 1.970896065380053*b[i + 51*ldb] + -0.1146719895825324*b[i + 52*ldb] + 0.813336618056223*b[i + 53*ldb] + -0.1647847391243889*b[i + 54*ldb] + -1.468505039653621*b[i + 55*ldb] + 1.520106975288837*b[i + 56*ldb] + 0.6220087569997739*b[i + 57*ldb] + -0.2734547660549973*b[i + 58*ldb] + 1.928363752763298*b[i + 59*ldb] + -2.592410982442422*b[i + 88*ldb] + 0.3844143922232035*b[i + 98*ldb] + 1.470670231280717*b[i + 108*ldb] + -1.124826508017214*b[i + 118*ldb]);
        c[i + 19*ldc] = (-0.2594862571830836*b[i + 10*ldb] + -2.135461924899462*b[i + 11*ldb] + 0.09553209687774447*b[i + 12*ldb] + 0.04322054596748309*b[i + 13*ldb] + -0.06009503669335015*b[i + 14*ldb] + 0.2496244542710354*b[i + 15*ldb] + -0.02016410157632526*b[i + 16*ldb] + 0.02177612369534747*b[i + 17*ldb] + -2.059269458123622*b[i + 18*ldb] + -2.410929174359682*b[i + 19*ldb] + -1.547794495565776*b[i + 50*ldb] + -0.1645658595194091*b[i + 51*ldb] + 0.9088687149339676*b[i + 52*ldb] + -0.07145144361504918*b[i + 53*ldb] + -1.528600076346972*b[i + 54*ldb] + 0.08483971514664668*b[i + 55*ldb] + 0.6018446554234487*b[i + 56*ldb] + 1.541883098984185*b[i + 57*ldb] + -0.1309057053603245*b[i + 58*ldb] + -2.68438394041468*b[i + 59*ldb] + -2.592410982442422*b[i + 89*ldb] + 0.3844143922232035*b[i + 99*ldb] + 1.470670231280717*b[i + 109*ldb] + -1.124826508017214*b[i + 119*ldb]);
        c[i + 20*ldc] = (-0.03017698203251321*b[i + 22*ldb] + 0.03017698203251321*b[i + 23*ldb] + 1.833320258631525*b[i + 24*ldb] + -1.833320258631525*b[i + 25*ldb] + -0.03664146213189456*b[i + 26*ldb] + 0.03664146213189456*b[i + 27*ldb] + -1.796678796499631*b[i + 28*ldb] + 1.796678796499631*b[i + 29*ldb] + -0.03017698203251321*b[i + 61*ldb] + 0.03017698203251321*b[i + 63*ldb] + 1.796678796499631*b[i + 64*ldb] + -0.03664146213189456*b[i + 65*ldb] + -1.833320258631525*b[i + 66*ldb] + -1.796678796499631*b[i + 67*ldb] + 0.03664146213189456*b[i + 68*ldb] + 1.833320258631525*b[i + 69*ldb] + 1.124826508017214*b[i + 80*ldb] + -1.470670231280717*b[i + 90*ldb] + -0.3844143922232035*b[i + 100*ldb] + 2.592410982442422*b[i + 110*ldb]);
        c[i + 21*ldc] = (-0.03161745145272921*b[i + 22*ldb] + 0.03161745145272921*b[i + 23*ldb] + 0.1482821472622804*b[i + 24*ldb] + -0.1482821472622804*b[i + 25*ldb] + 0.02677969298108662*b[i + 26*ldb] + -0.02677969298108662*b[i + 27*ldb] + -0.1750618402433646*b[i + 28*ldb] + 0.1750618402433646*b[i + 29*ldb] + 1.502821807911975*b[i + 60*ldb] + -3.352054625649612*b[i + 61*ldb] + -0.5764568723296889*b[i + 62*ldb] + -0.5448394208769596*b[i + 63*ldb] + 0.9709142050655857*b[i + 64*ldb] + 0.8226320578033056*b[i + 65*ldb] + -1.442087069209281*b[i + 66*ldb] + -1.468866762190367*b[i + 67*ldb] + -2.055207277795931*b[i + 68*ldb] + -1.880145437552564*b[i + 69*ldb] + 1.124826508017214*b[i + 81*ldb] + -1.470670231280717*b[i + 91*ldb] + -0.3844143922232035*b[i + 101*ldb] + 2.592410982442422*b[i + 111*ldb]);
        c[i + 22*ldc] = (1.502821807911975*b[i + 20*ldb] + -0.5764568723296889*b[i + 21*ldb] + -3.352054625649612*b[i + 22*ldb] + -0.5448394208769596*b[i + 23*ldb] + -1.880145437552564*b[i + 24*ldb] + -1.442087069209281*b[i + 25*ldb] + 0.8226320578033056*b[i + 26*ldb] + -2.055207277795931*b[i + 27*ldb] + -1.468866762190367*b[i + 28*ldb] + 0.9709142050655857*b[i + 29*ldb] + -0.03161745145272921*b[i + 61*ldb] + 0.03161745145272921*b[i + 63*ldb] + 0.1750618402433646*b[i + 64*ldb] + 0.02677969298108662*b[i + 65*ldb] + -0.1482821472622804*b[i + 66*ldb] + -0.1750618402433646*b[i + 67*ldb] + -0.02677969298108662*b[i + 68*ldb] + 0.1482821472622804*b[i + 69*ldb] + 1.124826508017214*b[i + 82*ldb] + -1.470670231280717*b[i + 92*ldb] + -0.3844143922232035*b[i + 102*ldb] + 2.592410982442422*b[i + 112*ldb]);
        c[i + 23*ldc] = (-1.502821807911975*b[i + 20*ldb] + 0.5764568723296889*b[i + 21*ldb] + 0.5448394208769596*b[i + 22*ldb] + 3.352054625649612*b[i + 23*ldb] + 1.442087069209281*b[i + 24*ldb] + 1.880145437552564*b[i + 25*ldb] + 2.055207277795931*b[i + 26*ldb] + -0.8226320578033056*b[i + 27*ldb] + -0.9709142050655857*b[i + 28*ldb] + 1.468866762190367*b[i + 29*ldb] + -1.502821807911975*b[i + 60*ldb] + 0.5448394208769596*b[i + 61*ldb] + 0.5764568723296889*b[i + 62*ldb] + 3.352054625649612*b[i + 63*ldb] + 1.468866762190367*b[i + 64*ldb] + 2.055207277795931*b[i + 65*ldb] + 1.880145437552564*b[i + 66*ldb] + -0.9709142050655857*b[i + 67*ldb] + -0.8226320578033056*b[i + 68*ldb] + 1.442087069209281*b[i + 69*ldb] + 1.124826508017214*b[i + 83*ldb] + -1.470670231280717*b[i + 93*ldb] + -0.3844143922232035*b[i + 103*ldb] + 2.592410982442422*b[i + 113*ldb]);
        c[i + 24*ldc] = (-1.547794495565776*b[i + 20*ldb] + 0.9088687149339676*b[i + 21*ldb] + -0.1645658595194091*b[i + 22*ldb] + -0.07145144361504918*b[i + 23*ldb] + -2.68438394041468*b[i + 24*ldb] + 0.6018446554234487*b[i + 25*ldb] + 0.08483971514664668*b[i + 26*ldb] + -0.1309057053603245*b[i + 27*ldb] + 1.541883098984185*b[i + 28*ldb] + -1.528600076346972*b[i + 29*ldb] + -0.2594862571830836*b[i + 60*ldb] + 0.09553209687774447*b[i + 61*ldb] + -2.135461924899462*b[i + 62*ldb] + 0.04322054596748309*b[i + 63*ldb] + -2.410929174359682*b[i + 64*ldb] + -0.02016410157632526*b[i + 65*ldb] + 0.2496244542710354*b[i + 66*ldb] + -2.059269458123622*b[i + 67*ldb] + 0.02177612369534747*b[i + 68*ldb] + -0.06009503669335015*b[i + 69*ldb] + 1.124826508017214*b[i + 84*ldb] + -1.470670231280717*b[i + 94*ldb] + -0.3844143922232035*b[i + 104*ldb] + 2.592410982442422*b[i + 114*ldb]);
        c[i + 25*ldc] = (1.547794495565776*b[i + 20*ldb] + -0.9088687149339676*b[i + 21*ldb] + 0.07145144361504918*b[i + 22*ldb] + 0.1645658595194091*b[i + 23*ldb] + -0.6018446554234487*b[i + 24*ldb] + 2.68438394041468*b[i + 25*ldb] + 0.1309057053603245*b[i + 26*ldb] + -0.08483971514664668*b[i + 27*ldb] + 1.528600076346972*b[i + 28*ldb] + -1.541883098984185*b[i + 29*ldb] + 1.288308238382692*b[i + 60*ldb] + -0.813336618056223*b[i + 61*ldb] + 0.1146719895825324*b[i + 62*ldb] + -1.970896065380053*b[i + 63*ldb] + -0.6220087569997739*b[i + 64*ldb] + 0.2734547660549973*b[i + 65*ldb] + -1.928363752763298*b[i + 66*ldb] + 0.1647847391243889*b[i + 67*ldb] + 1.468505039653621*b[i + 68*ldb] + -1.520106975288837*b[i + 69*ldb] + 1.124826508017214*b[i + 85*ldb] + -1.470670231280717*b[i + 95*ldb] + -0.3844143922232035*b[i + 105*ldb] + 2.592410982442422*b[i + 115*ldb]);
        c[i + 26*ldc] = (1.288308238382692*b[i + 20*ldb] + 0.1146719895825324*b[i + 21*ldb] + -0.813336618056223*b[i + 22*ldb] + -1.970896065380053*b[i + 23*ldb] + -1.520106975288837*b[i + 24*ldb] + -1.928363752763298*b[i + 25*ldb] + 0.2734547660549973*b[i + 26*ldb] + 1.468505039653621*b[i + 27*ldb] + 0.1647847391243889*b[i + 28*ldb] + -0.6220087569997739*b[i + 29*ldb] + 1.547794495565776*b[i + 60*ldb] + 0.07145144361504918*b[i + 61*ldb] + -0.9088687149339676*b[i + 62*ldb] + 0.1645658595194091*b[i + 63*ldb] + -1.541883098984185*b[i + 64*ldb] + 0.1309057053603245*b[i + 65*ldb] + 2.68438394041468*b[i + 66*ldb] + 1.528600076346972*b[i + 67*ldb] + -0.08483971514664668*b[i + 68*ldb] + -0.6018446554234487*b[i + 69*ldb] + 1.124826508017214*b[i + 86*ldb] + -1.470670231280717*b[i + 96*ldb] + -0.3844143922232035*b[i + 106*ldb] + 2.592410982442422*b[i + 116*ldb]);
        c[i + 27*ldc] = (-1.288308238382692*b[i + 20*ldb] + -0.1146719895825324*b[i + 21*ldb] + 1.970896065380053*b[i + 22*ldb] + 0.813336618056223*b[i + 23*ldb] + 1.928363752763298*b[i + 24*ldb] + 1.520106975288837*b[i + 25*ldb] + -1.468505039653621*b[i + 26*ldb] + -0.2734547660549973*b[i + 27*ldb] + 0.6220087569997739*b[i + 28*ldb] + -0.1647847391243889*b[i + 29*ldb] + 0.2594862571830836*b[i + 60*ldb] + -0.04322054596748309*b[i + 61*ldb] + 2.135461924899462*b[i + 62*ldb] + -0.09553209687774447*b[i + 63*ldb] + 2.059269458123622*b[i + 64*ldb] + -0.02177612369534747*b[i + 65*ldb] + 0.06009503669335015*b[i + 66*ldb] + 2.410929174359682*b[i + 67*ldb] + 0.02016410157632526*b[i + 68*ldb] + -0.2496244542710354*b[i + 69*ldb] + 1.124826508017214*b[i + 87*ldb] + -1.470670231280717*b[i + 97*ldb] + -0.3844143922232035*b[i + 107*ldb] + 2.592410982442422*b[i + 117*ldb]);
        c[i + 28*ldc] = (0.2594862571830836*b[i + 20*ldb] + 2.135461924899462*b[i + 21*ldb] + -0.04322054596748309*b[i + 22*ldb] + -0.09553209687774447*b[i + 23*ldb] + -0.2496244542710354*b[i + 24*ldb] + 0.06009503669335015*b[i + 25*ldb] + -0.02177612369534747*b[i + 26*ldb] + 0.02016410157632526*b[i + 27*ldb] + 2.410929174359682*b[i + 28*ldb] + 2.059269458123622*b[i + 29*ldb] + -1.288308238382692*b[i + 60*ldb] + 1.970896065380053*b[i + 61*ldb] + -0.1146719895825324*b[i + 62*ldb] + 0.813336618056223*b[i + 63*ldb] + -0.1647847391243889*b[i + 64*ldb] + -1.468505039653621*b[i + 65*ldb] + 1.520106975288837*b[i + 66*ldb] + 0.6220087569997739*b[i + 67*ldb] + -0.2734547660549973*b[i + 68*ldb] + 1.928363752763298*b[i + 69*ldb] + 1.124826508017214*b[i + 88*ldb] + -1.470670231280717*b[i + 98*ldb] + -0.3844143922232035*b[i + 108*ldb] + 2.592410982442422*b[i + 118*ldb]);
        c[i + 29*ldc] = (-0.2594862571830836*b[i + 20*ldb] + -2.135461924899462*b[i + 21*ldb] + 0.09553209687774447*b[i + 22*ldb] + 0.04322054596748309*b[i + 23*ldb] + -0.06009503669335015*b[i + 24*ldb] + 0.2496244542710354*b[i + 25*ldb] + -0.02016410157632526*b[i + 26*ldb] + 0.02177612369534747*b[i + 27*ldb] + -2.059269458123622*b[i + 28*ldb] + -2.410929174359682*b[i + 29*ldb] + -1.547794495565776*b[i + 60*ldb] + -0.1645658595194091*b[i + 61*ldb] + 0.9088687149339676*b[i + 62*ldb] + -0.07145144361504918*b[i + 63*ldb] + -1.528600076346972*b[i + 64*ldb] + 0.08483971514664668*b[i + 65*ldb] + 0.6018446554234487*b[i + 66*ldb] + 1.541883098984185*b[i + 67*ldb] + -0.1309057053603245*b[i + 68*ldb] + -2.68438394041468*b[i + 69*ldb] + 1.124826508017214*b[i + 89*ldb] + -1.470670231280717*b[i + 99*ldb] + -0.3844143922232035*b[i + 109*ldb] + 2.592410982442422*b[i + 119*ldb]);
        c[i + 30*ldc] = (-0.03017698203251321*b[i + 32*ldb] + 0.03017698203251321*b[i + 33*ldb] + 1.833320258631525*b[i + 34*ldb] + -1.833320258631525*b[i + 35*ldb] + -0.03664146213189456*b[i + 36*ldb] + 0.03664146213189456*b[i + 37*ldb] + -1.796678796499631*b[i + 38*ldb] + 1.796678796499631*b[i + 39*ldb] + -0.03017698203251321*b[i + 71*ldb] + 0.03017698203251321*b[i + 73*ldb] + 1.796678796499631*b[i + 74*ldb] + -0.03664146213189456*b[i + 75*ldb] + -1.833320258631525*b[i + 76*ldb] + -1.796678796499631*b[i + 77*ldb] + 0.03664146213189456*b[i + 78*ldb] + 1.833320258631525*b[i + 79*ldb] + -0.5806281691622632*b[i + 80*ldb] + 0.6162310439495416*b[i + 90*ldb] + -1.420240467903609*b[i + 100*ldb] + -3.332000236352239*b[i + 110*ldb]);
        c[i + 31*ldc] = (-0.03161745145272921*b[i + 32*ldb] + 0.03161745145272921*b[i + 33*ldb] + 0.1482821472622804*b[i + 34*ldb] + -0.1482821472622804*b[i + 35*ldb] + 0.02677969298108662*b[i + 36*ldb] + -0.02677969298108662*b[i + 37*ldb] + -0.1750618402433646*b[i + 38*ldb] + 0.1750618402433646*b[i + 39*ldb] + 1.502821807911975*b[i + 70*ldb] + -3.352054625649612*b[i + 71*ldb] + -0.5764568723296889*b[i + 72*ldb] + -0.5448394208769596*b[i + 73*ldb] + 0.9709142050655857*b[i + 74*ldb] + 0.8226320578033056*b[i + 75*ldb] + -1.442087069209281*b[i + 76*ldb] + -1.468866762190367*b[i + 77*ldb] + -2.055207277795931*b[i + 78*ldb] + -1.880145437552564*b[i + 79*ldb] + -0.5806281691622632*b[i + 81*ldb] + 0.6162310439495416*b[i + 91*ldb] + -1.420240467903609*b[i + 101*ldb] + -3.332000236352239*b[i + 111*ldb]);
        c[i + 32*ldc] = (1.502821807911975*b[i + 30*ldb] + -0.5764568723296889*b[i + 31*ldb] + -3.352054625649612*b[i + 32*ldb] + -0.5448394208769596*b[i + 33*ldb] + -1.880145437552564*b[i + 34*ldb] + -1.442087069209281*b[i + 35*ldb] + 0.8226320578033056*b[i + 36*ldb] + -2.055207277795931*b[i + 37*ldb] + -1.468866762190367*b[i + 38*ldb] + 0.9709142050655857*b[i + 39*ldb] + -0.03161745145272921*b[i + 71*ldb] + 0.03161745145272921*b[i + 73*ldb] + 0.1750618402433646*b[i + 74*ldb] + 0.02677969298108662*b[i + 75*ldb] + -0.1482821472622804*b[i + 76*ldb] + -0.1750618402433646*b[i + 77*ldb] + -0.02677969298108662*b[i + 78*ldb] + 0.1482821472622804*b[i + 79*ldb] + -0.5806281691622632*b[i + 82*ldb] + 0.6162310439495416*b[i + 92*ldb] + -1.420240467903609*b[i + 102*ldb] + -3.332000236352239*b[i + 112*ldb]);
        c[i + 33*ldc] = (-1.502821807911975*b[i + 30*ldb] + 0.5764568723296889*b[i + 31*ldb] + 0.5448394208769596*b[i + 32*ldb] + 3.352054625649612*b[i + 33*ldb] + 1.442087069209281*b[i + 34*ldb] + 1.880145437552564*b[i + 35*ldb] + 2.055207277795931*b[i + 36*ldb] + -0.8226320578033056*b[i + 37*ldb] + -0.9709142050655857*b[i + 38*ldb] + 1.468866762190367*b[i + 39*ldb] + -1.502821807911975*b[i + 70*ldb] + 0.5448394208769596*b[i + 71*ldb] + 0.5764568723296889*b[i + 72*ldb] + 3.352054625649612*b[i + 73*ldb] + 1.468866762190367*b[i + 74*ldb] + 2.055207277795931*b[i + 75*ldb] + 1.880145437552564*b[i + 76*ldb] + -0.9709142050655857*b[i + 77*ldb] + -0.8226320578033056*b[i + 78*ldb] + 1.442087069209281*b[i + 79*ldb] + -0.5806281691622632*b[i + 83*ldb] + 0.6162310439495416*b[i + 93*ldb] + -1.420240467903609*b[i + 103*ldb] + -3.332000236352239*b[i + 113*ldb]);
        c[i + 34*ldc] = (-1.547794495565776*b[i + 30*ldb] + 0.9088687149339676*b[i + 31*ldb] + -0.1645658595194091*b[i + 32*ldb] + -0.07145144361504918*b[i + 33*ldb] + -2.68438394041468*b[i + 34*ldb] + 0.6018446554234487*b[i + 35*ldb] + 0.08483971514664668*b[i + 36*ldb] + -0.1309057053603245*b[i + 37*ldb] + 1.541883098984185*b[i + 38*ldb] + -1.528600076346972*b[i + 39*ldb] + -0.2594862571830836*b[i + 70*ldb] + 0.09553209687774447*b[i + 71*ldb] + -2.135461924899462*b[i + 72*ldb] + 0.04322054596748309*b[i + 73*ldb] + -2.410929174359682*b[i + 74*ldb] + -0.02016410157632526*b[i + 75*ldb] + 0.2496244542710354*b[i + 76*ldb] + -2.059269458123622*b[i + 77*ldb] + 0.02177612369534747*b[i + 78*ldb] + -0.06009503669335015*b[i + 79*ldb] + -0.5806281691622632*b[i + 84*ldb] + 0.6162310439495416*b[i + 94*ldb] + -1.420240467903609*b[i + 104*ldb] + -3.332000236352239*b[i + 114*ldb]);
        c[i + 35*ldc] = (1.547794495565776*b[i + 30*ldb] + -0.9088687149339676*b[i + 31*ldb] + 0.07145144361504918*b[i + 32*ldb] + 0.1645658595194091*b[i + 33*ldb] + -0.6018446554234487*b[i + 34*ldb] + 2.68438394041468*b[i + 35*ldb] + 0.1309057053603245*b[i + 36*ldb] + -0.08483971514664668*b[i + 37*ldb] + 1.528600076346972*b[i + 38*ldb] + -1.541883098984185*b[i + 39*ldb] + 1.288308238382692*b[i + 70*ldb] + -0.813336618056223*b[i + 71*ldb] + 0.1146719895825324*b[i + 72*ldb] + -1.970896065380053*b[i + 73*ldb] + -0.6220087569997739*b[i + 74*ldb] + 0.2734547660549973*b[i + 75*ldb] + -1.928363752763298*b[i + 76*ldb] + 0.1647847391243889*b[i + 77*ldb] + 1.468505039653621*b[i + 78*ldb] + -1.520106975288837*b[i + 79*ldb] + -0.5806281691622632*b[i + 85*ldb] + 0.6162310439495416*b[i + 95*ldb] + -1.420240467903609*b[i + 105*ldb] + -3.332000236352239*b[i + 115*ldb]);
        c[i + 36*ldc] = (1.288308238382692*b[i + 30*ldb] + 0.1146719895825324*b[i + 31*ldb] + -0.813336618056223*b[i + 32*ldb] + -1.970896065380053*b[i + 33*ldb] + -1.520106975288837*b[i + 34*ldb] + -1.928363752763298*b[i + 35*ldb] + 0.2734547660549973*b[i + 36*ldb] + 1.468505039653621*b[i + 37*ldb] + 0.1647847391243889*b[i + 38*ldb] + -0.6220087569997739*b[i + 39*ldb] + 1.547794495565776*b[i + 70*ldb] + 0.07145144361504918*b[i + 71*ldb] + -0.9088687149339676*b[i + 72*ldb] + 0.1645658595194091*b[i + 73*ldb] + -1.541883098984185*b[i + 74*ldb] + 0.1309057053603245*b[i + 75*ldb] + 2.68438394041468*b[i + 76*ldb] + 1.528600076346972*b[i + 77*ldb] + -0.08483971514664668*b[i + 78*ldb] + -0.6018446554234487*b[i + 79*ldb] + -0.5806281691622632*b[i + 86*ldb] + 0.6162310439495416*b[i + 96*ldb] + -1.420240467903609*b[i + 106*ldb] + -3.332000236352239*b[i + 116*ldb]);
        c[i + 37*ldc] = (-1.288308238382692*b[i + 30*ldb] + -0.1146719895825324*b[i + 31*ldb] + 1.970896065380053*b[i + 32*ldb] + 0.813336618056223*b[i + 33*ldb] + 1.928363752763298*b[i + 34*ldb] + 1.520106975288837*b[i + 35*ldb] + -1.468505039653621*b[i + 36*ldb] + -0.2734547660549973*b[i + 37*ldb] + 0.6220087569997739*b[i + 38*ldb] + -0.1647847391243889*b[i + 39*ldb] + 0.2594862571830836*b[i + 70*ldb] + -0.04322054596748309*b[i + 71*ldb] + 2.135461924899462*b[i + 72*ldb] + -0.09553209687774447*b[i + 73*ldb] + 2.059269458123622*b[i + 74*ldb] + -0.02177612369534747*b[i + 75*ldb] + 0.06009503669335015*b[i + 76*ldb] + 2.410929174359682*b[i + 77*ldb] + 0.02016410157632526*b[i + 78*ldb] + -0.2496244542710354*b[i + 79*ldb] + -0.5806281691622632*b[i + 87*ldb] + 0.6162310439495416*b[i + 97*ldb] + -1.420240467903609*b[i + 107*ldb] + -3.332000236352239*b[i + 117*ldb]);
        c[i + 38*ldc] = (0.2594862571830836*b[i + 30*ldb] + 2.135461924899462*b[i + 31*ldb] + -0.04322054596748309*b[i + 32*ldb] + -0.09553209687774447*b[i + 33*ldb] + -0.2496244542710354*b[i + 34*ldb] + 0.06009503669335015*b[i + 35*ldb] + -0.02177612369534747*b[i + 36*ldb] + 0.02016410157632526*b[i + 37*ldb] + 2.410929174359682*b[i + 38*ldb] + 2.059269458123622*b[i + 39*ldb] + -1.288308238382692*b[i + 70*ldb] + 1.970896065380053*b[i + 71*ldb] + -0.1146719895825324*b[i + 72*ldb] + 0.813336618056223*b[i + 73*ldb] + -0.1647847391243889*b[i + 74*ldb] + -1.468505039653621*b[i + 75*ldb] + 1.520106975288837*b[i + 76*ldb] + 0.6220087569997739*b[i + 77*ldb] + -0.2734547660549973*b[i + 78*ldb] + 1.928363752763298*b[i + 79*ldb] + -0.5806281691622632*b[i + 88*ldb] + 0.6162310439495416*b[i + 98*ldb] + -1.420240467903609*b[i + 108*ldb] + -3.332000236352239*b[i + 118*ldb]);
        c[i + 39*ldc] = (-0.2594862571830836*b[i + 30*ldb] + -2.135461924899462*b[i + 31*ldb] + 0.09553209687774447*b[i + 32*ldb] + 0.04322054596748309*b[i + 33*ldb] + -0.06009503669335015*b[i + 34*ldb] + 0.2496244542710354*b[i + 35*ldb] + -0.02016410157632526*b[i + 36*ldb] + 0.02177612369534747*b[i + 37*ldb] + -2.059269458123622*b[i + 38*ldb] + -2.410929174359682*b[i + 39*ldb] + -1.547794495565776*b[i + 70*ldb] + -0.1645658595194091*b[i + 71*ldb] + 0.9088687149339676*b[i + 72*ldb] + -0.07145144361504918*b[i + 73*ldb] + -1.528600076346972*b[i + 74*ldb] + 0.08483971514664668*b[i + 75*ldb] + 0.6018446554234487*b[i + 76*ldb] + 1.541883098984185*b[i + 77*ldb] + -0.1309057053603245*b[i + 78*ldb] + -2.68438394041468*b[i + 79*ldb] + -0.5806281691622632*b[i + 89*ldb] + 0.6162310439495416*b[i + 99*ldb] + -1.420240467903609*b[i + 109*ldb] + -3.332000236352239*b[i + 119*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_hex_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.551408049094313*b[i + 0*ldb] + -0.8931583920000719*b[i + 25*ldb] + 0.5333333333333334*b[i + 50*ldb] + -0.2679416522233877*b[i + 75*ldb] + 0.07635866179581294*b[i + 100*ldb]);
        c[i + 1*ldc] = (1.551408049094313*b[i + 1*ldb] + -0.8931583920000719*b[i + 26*ldb] + 0.5333333333333334*b[i + 51*ldb] + -0.2679416522233877*b[i + 76*ldb] + 0.07635866179581294*b[i + 101*ldb]);
        c[i + 2*ldc] = (1.551408049094313*b[i + 2*ldb] + -0.8931583920000719*b[i + 27*ldb] + 0.5333333333333334*b[i + 52*ldb] + -0.2679416522233877*b[i + 77*ldb] + 0.07635866179581294*b[i + 102*ldb]);
        c[i + 3*ldc] = (1.551408049094313*b[i + 3*ldb] + -0.8931583920000719*b[i + 28*ldb] + 0.5333333333333334*b[i + 53*ldb] + -0.2679416522233877*b[i + 78*ldb] + 0.07635866179581294*b[i + 103*ldb]);
        c[i + 4*ldc] = (1.551408049094313*b[i + 4*ldb] + -0.8931583920000719*b[i + 29*ldb] + 0.5333333333333334*b[i + 54*ldb] + -0.2679416522233877*b[i + 79*ldb] + 0.07635866179581294*b[i + 104*ldb]);
        c[i + 5*ldc] = (1.551408049094313*b[i + 5*ldb] + -0.8931583920000719*b[i + 30*ldb] + 0.5333333333333334*b[i + 55*ldb] + -0.2679416522233877*b[i + 80*ldb] + 0.07635866179581294*b[i + 105*ldb]);
        c[i + 6*ldc] = (1.551408049094313*b[i + 6*ldb] + -0.8931583920000719*b[i + 31*ldb] + 0.5333333333333334*b[i + 56*ldb] + -0.2679416522233877*b[i + 81*ldb] + 0.07635866179581294*b[i + 106*ldb]);
        c[i + 7*ldc] = (1.551408049094313*b[i + 7*ldb] + -0.8931583920000719*b[i + 32*ldb] + 0.5333333333333334*b[i + 57*ldb] + -0.2679416522233877*b[i + 82*ldb] + 0.07635866179581294*b[i + 107*ldb]);
        c[i + 8*ldc] = (1.551408049094313*b[i + 8*ldb] + -0.8931583920000719*b[i + 33*ldb] + 0.5333333333333334*b[i + 58*ldb] + -0.2679416522233877*b[i + 83*ldb] + 0.07635866179581294*b[i + 108*ldb]);
        c[i + 9*ldc] = (1.551408049094313*b[i + 9*ldb] + -0.8931583920000719*b[i + 34*ldb] + 0.5333333333333334*b[i + 59*ldb] + -0.2679416522233877*b[i + 84*ldb] + 0.07635866179581294*b[i + 109*ldb]);
        c[i + 10*ldc] = (1.551408049094313*b[i + 10*ldb] + -0.8931583920000719*b[i + 35*ldb] + 0.5333333333333334*b[i + 60*ldb] + -0.2679416522233877*b[i + 85*ldb] + 0.07635866179581294*b[i + 110*ldb]);
        c[i + 11*ldc] = (1.551408049094313*b[i + 11*ldb] + -0.8931583920000719*b[i + 36*ldb] + 0.5333333333333334*b[i + 61*ldb] + -0.2679416522233877*b[i + 86*ldb] + 0.07635866179581294*b[i + 111*ldb]);
        c[i + 12*ldc] = (1.551408049094313*b[i + 12*ldb] + -0.8931583920000719*b[i + 37*ldb] + 0.5333333333333334*b[i + 62*ldb] + -0.2679416522233877*b[i + 87*ldb] + 0.07635866179581294*b[i + 112*ldb]);
        c[i + 13*ldc] = (1.551408049094313*b[i + 13*ldb] + -0.8931583920000719*b[i + 38*ldb] + 0.5333333333333334*b[i + 63*ldb] + -0.2679416522233877*b[i + 88*ldb] + 0.07635866179581294*b[i + 113*ldb]);
        c[i + 14*ldc] = (1.551408049094313*b[i + 14*ldb] + -0.8931583920000719*b[i + 39*ldb] + 0.5333333333333334*b[i + 64*ldb] + -0.2679416522233877*b[i + 89*ldb] + 0.07635866179581294*b[i + 114*ldb]);
        c[i + 15*ldc] = (1.551408049094313*b[i + 15*ldb] + -0.8931583920000719*b[i + 40*ldb] + 0.5333333333333334*b[i + 65*ldb] + -0.2679416522233877*b[i + 90*ldb] + 0.07635866179581294*b[i + 115*ldb]);
        c[i + 16*ldc] = (1.551408049094313*b[i + 16*ldb] + -0.8931583920000719*b[i + 41*ldb] + 0.5333333333333334*b[i + 66*ldb] + -0.2679416522233877*b[i + 91*ldb] + 0.07635866179581294*b[i + 116*ldb]);
        c[i + 17*ldc] = (1.551408049094313*b[i + 17*ldb] + -0.8931583920000719*b[i + 42*ldb] + 0.5333333333333334*b[i + 67*ldb] + -0.2679416522233877*b[i + 92*ldb] + 0.07635866179581294*b[i + 117*ldb]);
        c[i + 18*ldc] = (1.551408049094313*b[i + 18*ldb] + -0.8931583920000719*b[i + 43*ldb] + 0.5333333333333334*b[i + 68*ldb] + -0.2679416522233877*b[i + 93*ldb] + 0.07635866179581294*b[i + 118*ldb]);
        c[i + 19*ldc] = (1.551408049094313*b[i + 19*ldb] + -0.8931583920000719*b[i + 44*ldb] + 0.5333333333333334*b[i + 69*ldb] + -0.2679416522233877*b[i + 94*ldb] + 0.07635866179581294*b[i + 119*ldb]);
        c[i + 20*ldc] = (1.551408049094313*b[i + 20*ldb] + -0.8931583920000719*b[i + 45*ldb] + 0.5333333333333334*b[i + 70*ldb] + -0.2679416522233877*b[i + 95*ldb] + 0.07635866179581294*b[i + 120*ldb]);
        c[i + 21*ldc] = (1.551408049094313*b[i + 21*ldb] + -0.8931583920000719*b[i + 46*ldb] + 0.5333333333333334*b[i + 71*ldb] + -0.2679416522233877*b[i + 96*ldb] + 0.07635866179581294*b[i + 121*ldb]);
        c[i + 22*ldc] = (1.551408049094313*b[i + 22*ldb] + -0.8931583920000719*b[i + 47*ldb] + 0.5333333333333334*b[i + 72*ldb] + -0.2679416522233877*b[i + 97*ldb] + 0.07635866179581294*b[i + 122*ldb]);
        c[i + 23*ldc] = (1.551408049094313*b[i + 23*ldb] + -0.8931583920000719*b[i + 48*ldb] + 0.5333333333333334*b[i + 73*ldb] + -0.2679416522233877*b[i + 98*ldb] + 0.07635866179581294*b[i + 123*ldb]);
        c[i + 24*ldc] = (1.551408049094313*b[i + 24*ldb] + -0.8931583920000719*b[i + 49*ldb] + 0.5333333333333334*b[i + 74*ldb] + -0.2679416522233877*b[i + 99*ldb] + 0.07635866179581294*b[i + 124*ldb]);
        c[i + 25*ldc] = (1.551408049094313*b[i + 0*ldb] + -0.8931583920000719*b[i + 5*ldb] + 0.5333333333333334*b[i + 10*ldb] + -0.2679416522233877*b[i + 15*ldb] + 0.07635866179581294*b[i + 20*ldb]);
        c[i + 26*ldc] = (1.551408049094313*b[i + 1*ldb] + -0.8931583920000719*b[i + 6*ldb] + 0.5333333333333334*b[i + 11*ldb] + -0.2679416522233877*b[i + 16*ldb] + 0.07635866179581294*b[i + 21*ldb]);
        c[i + 27*ldc] = (1.551408049094313*b[i + 2*ldb] + -0.8931583920000719*b[i + 7*ldb] + 0.5333333333333334*b[i + 12*ldb] + -0.2679416522233877*b[i + 17*ldb] + 0.07635866179581294*b[i + 22*ldb]);
        c[i + 28*ldc] = (1.551408049094313*b[i + 3*ldb] + -0.8931583920000719*b[i + 8*ldb] + 0.5333333333333334*b[i + 13*ldb] + -0.2679416522233877*b[i + 18*ldb] + 0.07635866179581294*b[i + 23*ldb]);
        c[i + 29*ldc] = (1.551408049094313*b[i + 4*ldb] + -0.8931583920000719*b[i + 9*ldb] + 0.5333333333333334*b[i + 14*ldb] + -0.2679416522233877*b[i + 19*ldb] + 0.07635866179581294*b[i + 24*ldb]);
        c[i + 30*ldc] = (1.551408049094313*b[i + 25*ldb] + -0.8931583920000719*b[i + 30*ldb] + 0.5333333333333334*b[i + 35*ldb] + -0.2679416522233877*b[i + 40*ldb] + 0.07635866179581294*b[i + 45*ldb]);
        c[i + 31*ldc] = (1.551408049094313*b[i + 26*ldb] + -0.8931583920000719*b[i + 31*ldb] + 0.5333333333333334*b[i + 36*ldb] + -0.2679416522233877*b[i + 41*ldb] + 0.07635866179581294*b[i + 46*ldb]);
        c[i + 32*ldc] = (1.551408049094313*b[i + 27*ldb] + -0.8931583920000719*b[i + 32*ldb] + 0.5333333333333334*b[i + 37*ldb] + -0.2679416522233877*b[i + 42*ldb] + 0.07635866179581294*b[i + 47*ldb]);
        c[i + 33*ldc] = (1.551408049094313*b[i + 28*ldb] + -0.8931583920000719*b[i + 33*ldb] + 0.5333333333333334*b[i + 38*ldb] + -0.2679416522233877*b[i + 43*ldb] + 0.07635866179581294*b[i + 48*ldb]);
        c[i + 34*ldc] = (1.551408049094313*b[i + 29*ldb] + -0.8931583920000719*b[i + 34*ldb] + 0.5333333333333334*b[i + 39*ldb] + -0.2679416522233877*b[i + 44*ldb] + 0.07635866179581294*b[i + 49*ldb]);
        c[i + 35*ldc] = (1.551408049094313*b[i + 50*ldb] + -0.8931583920000719*b[i + 55*ldb] + 0.5333333333333334*b[i + 60*ldb] + -0.2679416522233877*b[i + 65*ldb] + 0.07635866179581294*b[i + 70*ldb]);
        c[i + 36*ldc] = (1.551408049094313*b[i + 51*ldb] + -0.8931583920000719*b[i + 56*ldb] + 0.5333333333333334*b[i + 61*ldb] + -0.2679416522233877*b[i + 66*ldb] + 0.07635866179581294*b[i + 71*ldb]);
        c[i + 37*ldc] = (1.551408049094313*b[i + 52*ldb] + -0.8931583920000719*b[i + 57*ldb] + 0.5333333333333334*b[i + 62*ldb] + -0.2679416522233877*b[i + 67*ldb] + 0.07635866179581294*b[i + 72*ldb]);
        c[i + 38*ldc] = (1.551408049094313*b[i + 53*ldb] + -0.8931583920000719*b[i + 58*ldb] + 0.5333333333333334*b[i + 63*ldb] + -0.2679416522233877*b[i + 68*ldb] + 0.07635866179581294*b[i + 73*ldb]);
        c[i + 39*ldc] = (1.551408049094313*b[i + 54*ldb] + -0.8931583920000719*b[i + 59*ldb] + 0.5333333333333334*b[i + 64*ldb] + -0.2679416522233877*b[i + 69*ldb] + 0.07635866179581294*b[i + 74*ldb]);
        c[i + 40*ldc] = (1.551408049094313*b[i + 75*ldb] + -0.8931583920000719*b[i + 80*ldb] + 0.5333333333333334*b[i + 85*ldb] + -0.2679416522233877*b[i + 90*ldb] + 0.07635866179581294*b[i + 95*ldb]);
        c[i + 41*ldc] = (1.551408049094313*b[i + 76*ldb] + -0.8931583920000719*b[i + 81*ldb] + 0.5333333333333334*b[i + 86*ldb] + -0.2679416522233877*b[i + 91*ldb] + 0.07635866179581294*b[i + 96*ldb]);
        c[i + 42*ldc] = (1.551408049094313*b[i + 77*ldb] + -0.8931583920000719*b[i + 82*ldb] + 0.5333333333333334*b[i + 87*ldb] + -0.2679416522233877*b[i + 92*ldb] + 0.07635866179581294*b[i + 97*ldb]);
        c[i + 43*ldc] = (1.551408049094313*b[i + 78*ldb] + -0.8931583920000719*b[i + 83*ldb] + 0.5333333333333334*b[i + 88*ldb] + -0.2679416522233877*b[i + 93*ldb] + 0.07635866179581294*b[i + 98*ldb]);
        c[i + 44*ldc] = (1.551408049094313*b[i + 79*ldb] + -0.8931583920000719*b[i + 84*ldb] + 0.5333333333333334*b[i + 89*ldb] + -0.2679416522233877*b[i + 94*ldb] + 0.07635866179581294*b[i + 99*ldb]);
        c[i + 45*ldc] = (1.551408049094313*b[i + 100*ldb] + -0.8931583920000719*b[i + 105*ldb] + 0.5333333333333334*b[i + 110*ldb] + -0.2679416522233877*b[i + 115*ldb] + 0.07635866179581294*b[i + 120*ldb]);
        c[i + 46*ldc] = (1.551408049094313*b[i + 101*ldb] + -0.8931583920000719*b[i + 106*ldb] + 0.5333333333333334*b[i + 111*ldb] + -0.2679416522233877*b[i + 116*ldb] + 0.07635866179581294*b[i + 121*ldb]);
        c[i + 47*ldc] = (1.551408049094313*b[i + 102*ldb] + -0.8931583920000719*b[i + 107*ldb] + 0.5333333333333334*b[i + 112*ldb] + -0.2679416522233877*b[i + 117*ldb] + 0.07635866179581294*b[i + 122*ldb]);
        c[i + 48*ldc] = (1.551408049094313*b[i + 103*ldb] + -0.8931583920000719*b[i + 108*ldb] + 0.5333333333333334*b[i + 113*ldb] + -0.2679416522233877*b[i + 118*ldb] + 0.07635866179581294*b[i + 123*ldb]);
        c[i + 49*ldc] = (1.551408049094313*b[i + 104*ldb] + -0.8931583920000719*b[i + 109*ldb] + 0.5333333333333334*b[i + 114*ldb] + -0.2679416522233877*b[i + 119*ldb] + 0.07635866179581294*b[i + 124*ldb]);
        c[i + 50*ldc] = (0.07635866179581294*b[i + 0*ldb] + -0.2679416522233877*b[i + 1*ldb] + 0.5333333333333334*b[i + 2*ldb] + -0.8931583920000719*b[i + 3*ldb] + 1.551408049094313*b[i + 4*ldb]);
        c[i + 51*ldc] = (0.07635866179581294*b[i + 5*ldb] + -0.2679416522233877*b[i + 6*ldb] + 0.5333333333333334*b[i + 7*ldb] + -0.8931583920000719*b[i + 8*ldb] + 1.551408049094313*b[i + 9*ldb]);
        c[i + 52*ldc] = (0.07635866179581294*b[i + 10*ldb] + -0.2679416522233877*b[i + 11*ldb] + 0.5333333333333334*b[i + 12*ldb] + -0.8931583920000719*b[i + 13*ldb] + 1.551408049094313*b[i + 14*ldb]);
        c[i + 53*ldc] = (0.07635866179581294*b[i + 15*ldb] + -0.2679416522233877*b[i + 16*ldb] + 0.5333333333333334*b[i + 17*ldb] + -0.8931583920000719*b[i + 18*ldb] + 1.551408049094313*b[i + 19*ldb]);
        c[i + 54*ldc] = (0.07635866179581294*b[i + 20*ldb] + -0.2679416522233877*b[i + 21*ldb] + 0.5333333333333334*b[i + 22*ldb] + -0.8931583920000719*b[i + 23*ldb] + 1.551408049094313*b[i + 24*ldb]);
        c[i + 55*ldc] = (0.07635866179581294*b[i + 25*ldb] + -0.2679416522233877*b[i + 26*ldb] + 0.5333333333333334*b[i + 27*ldb] + -0.8931583920000719*b[i + 28*ldb] + 1.551408049094313*b[i + 29*ldb]);
        c[i + 56*ldc] = (0.07635866179581294*b[i + 30*ldb] + -0.2679416522233877*b[i + 31*ldb] + 0.5333333333333334*b[i + 32*ldb] + -0.8931583920000719*b[i + 33*ldb] + 1.551408049094313*b[i + 34*ldb]);
        c[i + 57*ldc] = (0.07635866179581294*b[i + 35*ldb] + -0.2679416522233877*b[i + 36*ldb] + 0.5333333333333334*b[i + 37*ldb] + -0.8931583920000719*b[i + 38*ldb] + 1.551408049094313*b[i + 39*ldb]);
        c[i + 58*ldc] = (0.07635866179581294*b[i + 40*ldb] + -0.2679416522233877*b[i + 41*ldb] + 0.5333333333333334*b[i + 42*ldb] + -0.8931583920000719*b[i + 43*ldb] + 1.551408049094313*b[i + 44*ldb]);
        c[i + 59*ldc] = (0.07635866179581294*b[i + 45*ldb] + -0.2679416522233877*b[i + 46*ldb] + 0.5333333333333334*b[i + 47*ldb] + -0.8931583920000719*b[i + 48*ldb] + 1.551408049094313*b[i + 49*ldb]);
        c[i + 60*ldc] = (0.07635866179581294*b[i + 50*ldb] + -0.2679416522233877*b[i + 51*ldb] + 0.5333333333333334*b[i + 52*ldb] + -0.8931583920000719*b[i + 53*ldb] + 1.551408049094313*b[i + 54*ldb]);
        c[i + 61*ldc] = (0.07635866179581294*b[i + 55*ldb] + -0.2679416522233877*b[i + 56*ldb] + 0.5333333333333334*b[i + 57*ldb] + -0.8931583920000719*b[i + 58*ldb] + 1.551408049094313*b[i + 59*ldb]);
        c[i + 62*ldc] = (0.07635866179581294*b[i + 60*ldb] + -0.2679416522233877*b[i + 61*ldb] + 0.5333333333333334*b[i + 62*ldb] + -0.8931583920000719*b[i + 63*ldb] + 1.551408049094313*b[i + 64*ldb]);
        c[i + 63*ldc] = (0.07635866179581294*b[i + 65*ldb] + -0.2679416522233877*b[i + 66*ldb] + 0.5333333333333334*b[i + 67*ldb] + -0.8931583920000719*b[i + 68*ldb] + 1.551408049094313*b[i + 69*ldb]);
        c[i + 64*ldc] = (0.07635866179581294*b[i + 70*ldb] + -0.2679416522233877*b[i + 71*ldb] + 0.5333333333333334*b[i + 72*ldb] + -0.8931583920000719*b[i + 73*ldb] + 1.551408049094313*b[i + 74*ldb]);
        c[i + 65*ldc] = (0.07635866179581294*b[i + 75*ldb] + -0.2679416522233877*b[i + 76*ldb] + 0.5333333333333334*b[i + 77*ldb] + -0.8931583920000719*b[i + 78*ldb] + 1.551408049094313*b[i + 79*ldb]);
        c[i + 66*ldc] = (0.07635866179581294*b[i + 80*ldb] + -0.2679416522233877*b[i + 81*ldb] + 0.5333333333333334*b[i + 82*ldb] + -0.8931583920000719*b[i + 83*ldb] + 1.551408049094313*b[i + 84*ldb]);
        c[i + 67*ldc] = (0.07635866179581294*b[i + 85*ldb] + -0.2679416522233877*b[i + 86*ldb] + 0.5333333333333334*b[i + 87*ldb] + -0.8931583920000719*b[i + 88*ldb] + 1.551408049094313*b[i + 89*ldb]);
        c[i + 68*ldc] = (0.07635866179581294*b[i + 90*ldb] + -0.2679416522233877*b[i + 91*ldb] + 0.5333333333333334*b[i + 92*ldb] + -0.8931583920000719*b[i + 93*ldb] + 1.551408049094313*b[i + 94*ldb]);
        c[i + 69*ldc] = (0.07635866179581294*b[i + 95*ldb] + -0.2679416522233877*b[i + 96*ldb] + 0.5333333333333334*b[i + 97*ldb] + -0.8931583920000719*b[i + 98*ldb] + 1.551408049094313*b[i + 99*ldb]);
        c[i + 70*ldc] = (0.07635866179581294*b[i + 100*ldb] + -0.2679416522233877*b[i + 101*ldb] + 0.5333333333333334*b[i + 102*ldb] + -0.8931583920000719*b[i + 103*ldb] + 1.551408049094313*b[i + 104*ldb]);
        c[i + 71*ldc] = (0.07635866179581294*b[i + 105*ldb] + -0.2679416522233877*b[i + 106*ldb] + 0.5333333333333334*b[i + 107*ldb] + -0.8931583920000719*b[i + 108*ldb] + 1.551408049094313*b[i + 109*ldb]);
        c[i + 72*ldc] = (0.07635866179581294*b[i + 110*ldb] + -0.2679416522233877*b[i + 111*ldb] + 0.5333333333333334*b[i + 112*ldb] + -0.8931583920000719*b[i + 113*ldb] + 1.551408049094313*b[i + 114*ldb]);
        c[i + 73*ldc] = (0.07635866179581294*b[i + 115*ldb] + -0.2679416522233877*b[i + 116*ldb] + 0.5333333333333334*b[i + 117*ldb] + -0.8931583920000719*b[i + 118*ldb] + 1.551408049094313*b[i + 119*ldb]);
        c[i + 74*ldc] = (0.07635866179581294*b[i + 120*ldb] + -0.2679416522233877*b[i + 121*ldb] + 0.5333333333333334*b[i + 122*ldb] + -0.8931583920000719*b[i + 123*ldb] + 1.551408049094313*b[i + 124*ldb]);
        c[i + 75*ldc] = (0.07635866179581294*b[i + 0*ldb] + -0.2679416522233877*b[i + 5*ldb] + 0.5333333333333334*b[i + 10*ldb] + -0.8931583920000719*b[i + 15*ldb] + 1.551408049094313*b[i + 20*ldb]);
        c[i + 76*ldc] = (0.07635866179581294*b[i + 1*ldb] + -0.2679416522233877*b[i + 6*ldb] + 0.5333333333333334*b[i + 11*ldb] + -0.8931583920000719*b[i + 16*ldb] + 1.551408049094313*b[i + 21*ldb]);
        c[i + 77*ldc] = (0.07635866179581294*b[i + 2*ldb] + -0.2679416522233877*b[i + 7*ldb] + 0.5333333333333334*b[i + 12*ldb] + -0.8931583920000719*b[i + 17*ldb] + 1.551408049094313*b[i + 22*ldb]);
        c[i + 78*ldc] = (0.07635866179581294*b[i + 3*ldb] + -0.2679416522233877*b[i + 8*ldb] + 0.5333333333333334*b[i + 13*ldb] + -0.8931583920000719*b[i + 18*ldb] + 1.551408049094313*b[i + 23*ldb]);
        c[i + 79*ldc] = (0.07635866179581294*b[i + 4*ldb] + -0.2679416522233877*b[i + 9*ldb] + 0.5333333333333334*b[i + 14*ldb] + -0.8931583920000719*b[i + 19*ldb] + 1.551408049094313*b[i + 24*ldb]);
        c[i + 80*ldc] = (0.07635866179581294*b[i + 25*ldb] + -0.2679416522233877*b[i + 30*ldb] + 0.5333333333333334*b[i + 35*ldb] + -0.8931583920000719*b[i + 40*ldb] + 1.551408049094313*b[i + 45*ldb]);
        c[i + 81*ldc] = (0.07635866179581294*b[i + 26*ldb] + -0.2679416522233877*b[i + 31*ldb] + 0.5333333333333334*b[i + 36*ldb] + -0.8931583920000719*b[i + 41*ldb] + 1.551408049094313*b[i + 46*ldb]);
        c[i + 82*ldc] = (0.07635866179581294*b[i + 27*ldb] + -0.2679416522233877*b[i + 32*ldb] + 0.5333333333333334*b[i + 37*ldb] + -0.8931583920000719*b[i + 42*ldb] + 1.551408049094313*b[i + 47*ldb]);
        c[i + 83*ldc] = (0.07635866179581294*b[i + 28*ldb] + -0.2679416522233877*b[i + 33*ldb] + 0.5333333333333334*b[i + 38*ldb] + -0.8931583920000719*b[i + 43*ldb] + 1.551408049094313*b[i + 48*ldb]);
        c[i + 84*ldc] = (0.07635866179581294*b[i + 29*ldb] + -0.2679416522233877*b[i + 34*ldb] + 0.5333333333333334*b[i + 39*ldb] + -0.8931583920000719*b[i + 44*ldb] + 1.551408049094313*b[i + 49*ldb]);
        c[i + 85*ldc] = (0.07635866179581294*b[i + 50*ldb] + -0.2679416522233877*b[i + 55*ldb] + 0.5333333333333334*b[i + 60*ldb] + -0.8931583920000719*b[i + 65*ldb] + 1.551408049094313*b[i + 70*ldb]);
        c[i + 86*ldc] = (0.07635866179581294*b[i + 51*ldb] + -0.2679416522233877*b[i + 56*ldb] + 0.5333333333333334*b[i + 61*ldb] + -0.8931583920000719*b[i + 66*ldb] + 1.551408049094313*b[i + 71*ldb]);
        c[i + 87*ldc] = (0.07635866179581294*b[i + 52*ldb] + -0.2679416522233877*b[i + 57*ldb] + 0.5333333333333334*b[i + 62*ldb] + -0.8931583920000719*b[i + 67*ldb] + 1.551408049094313*b[i + 72*ldb]);
        c[i + 88*ldc] = (0.07635866179581294*b[i + 53*ldb] + -0.2679416522233877*b[i + 58*ldb] + 0.5333333333333334*b[i + 63*ldb] + -0.8931583920000719*b[i + 68*ldb] + 1.551408049094313*b[i + 73*ldb]);
        c[i + 89*ldc] = (0.07635866179581294*b[i + 54*ldb] + -0.2679416522233877*b[i + 59*ldb] + 0.5333333333333334*b[i + 64*ldb] + -0.8931583920000719*b[i + 69*ldb] + 1.551408049094313*b[i + 74*ldb]);
        c[i + 90*ldc] = (0.07635866179581294*b[i + 75*ldb] + -0.2679416522233877*b[i + 80*ldb] + 0.5333333333333334*b[i + 85*ldb] + -0.8931583920000719*b[i + 90*ldb] + 1.551408049094313*b[i + 95*ldb]);
        c[i + 91*ldc] = (0.07635866179581294*b[i + 76*ldb] + -0.2679416522233877*b[i + 81*ldb] + 0.5333333333333334*b[i + 86*ldb] + -0.8931583920000719*b[i + 91*ldb] + 1.551408049094313*b[i + 96*ldb]);
        c[i + 92*ldc] = (0.07635866179581294*b[i + 77*ldb] + -0.2679416522233877*b[i + 82*ldb] + 0.5333333333333334*b[i + 87*ldb] + -0.8931583920000719*b[i + 92*ldb] + 1.551408049094313*b[i + 97*ldb]);
        c[i + 93*ldc] = (0.07635866179581294*b[i + 78*ldb] + -0.2679416522233877*b[i + 83*ldb] + 0.5333333333333334*b[i + 88*ldb] + -0.8931583920000719*b[i + 93*ldb] + 1.551408049094313*b[i + 98*ldb]);
        c[i + 94*ldc] = (0.07635866179581294*b[i + 79*ldb] + -0.2679416522233877*b[i + 84*ldb] + 0.5333333333333334*b[i + 89*ldb] + -0.8931583920000719*b[i + 94*ldb] + 1.551408049094313*b[i + 99*ldb]);
        c[i + 95*ldc] = (0.07635866179581294*b[i + 100*ldb] + -0.2679416522233877*b[i + 105*ldb] + 0.5333333333333334*b[i + 110*ldb] + -0.8931583920000719*b[i + 115*ldb] + 1.551408049094313*b[i + 120*ldb]);
        c[i + 96*ldc] = (0.07635866179581294*b[i + 101*ldb] + -0.2679416522233877*b[i + 106*ldb] + 0.5333333333333334*b[i + 111*ldb] + -0.8931583920000719*b[i + 116*ldb] + 1.551408049094313*b[i + 121*ldb]);
        c[i + 97*ldc] = (0.07635866179581294*b[i + 102*ldb] + -0.2679416522233877*b[i + 107*ldb] + 0.5333333333333334*b[i + 112*ldb] + -0.8931583920000719*b[i + 117*ldb] + 1.551408049094313*b[i + 122*ldb]);
        c[i + 98*ldc] = (0.07635866179581294*b[i + 103*ldb] + -0.2679416522233877*b[i + 108*ldb] + 0.5333333333333334*b[i + 113*ldb] + -0.8931583920000719*b[i + 118*ldb] + 1.551408049094313*b[i + 123*ldb]);
        c[i + 99*ldc] = (0.07635866179581294*b[i + 104*ldb] + -0.2679416522233877*b[i + 109*ldb] + 0.5333333333333334*b[i + 114*ldb] + -0.8931583920000719*b[i + 119*ldb] + 1.551408049094313*b[i + 124*ldb]);
        c[i + 100*ldc] = (1.551408049094313*b[i + 0*ldb] + -0.8931583920000719*b[i + 1*ldb] + 0.5333333333333334*b[i + 2*ldb] + -0.2679416522233877*b[i + 3*ldb] + 0.07635866179581294*b[i + 4*ldb]);
        c[i + 101*ldc] = (1.551408049094313*b[i + 5*ldb] + -0.8931583920000719*b[i + 6*ldb] + 0.5333333333333334*b[i + 7*ldb] + -0.2679416522233877*b[i + 8*ldb] + 0.07635866179581294*b[i + 9*ldb]);
        c[i + 102*ldc] = (1.551408049094313*b[i + 10*ldb] + -0.8931583920000719*b[i + 11*ldb] + 0.5333333333333334*b[i + 12*ldb] + -0.2679416522233877*b[i + 13*ldb] + 0.07635866179581294*b[i + 14*ldb]);
        c[i + 103*ldc] = (1.551408049094313*b[i + 15*ldb] + -0.8931583920000719*b[i + 16*ldb] + 0.5333333333333334*b[i + 17*ldb] + -0.2679416522233877*b[i + 18*ldb] + 0.07635866179581294*b[i + 19*ldb]);
        c[i + 104*ldc] = (1.551408049094313*b[i + 20*ldb] + -0.8931583920000719*b[i + 21*ldb] + 0.5333333333333334*b[i + 22*ldb] + -0.2679416522233877*b[i + 23*ldb] + 0.07635866179581294*b[i + 24*ldb]);
        c[i + 105*ldc] = (1.551408049094313*b[i + 25*ldb] + -0.8931583920000719*b[i + 26*ldb] + 0.5333333333333334*b[i + 27*ldb] + -0.2679416522233877*b[i + 28*ldb] + 0.07635866179581294*b[i + 29*ldb]);
        c[i + 106*ldc] = (1.551408049094313*b[i + 30*ldb] + -0.8931583920000719*b[i + 31*ldb] + 0.5333333333333334*b[i + 32*ldb] + -0.2679416522233877*b[i + 33*ldb] + 0.07635866179581294*b[i + 34*ldb]);
        c[i + 107*ldc] = (1.551408049094313*b[i + 35*ldb] + -0.8931583920000719*b[i + 36*ldb] + 0.5333333333333334*b[i + 37*ldb] + -0.2679416522233877*b[i + 38*ldb] + 0.07635866179581294*b[i + 39*ldb]);
        c[i + 108*ldc] = (1.551408049094313*b[i + 40*ldb] + -0.8931583920000719*b[i + 41*ldb] + 0.5333333333333334*b[i + 42*ldb] + -0.2679416522233877*b[i + 43*ldb] + 0.07635866179581294*b[i + 44*ldb]);
        c[i + 109*ldc] = (1.551408049094313*b[i + 45*ldb] + -0.8931583920000719*b[i + 46*ldb] + 0.5333333333333334*b[i + 47*ldb] + -0.2679416522233877*b[i + 48*ldb] + 0.07635866179581294*b[i + 49*ldb]);
        c[i + 110*ldc] = (1.551408049094313*b[i + 50*ldb] + -0.8931583920000719*b[i + 51*ldb] + 0.5333333333333334*b[i + 52*ldb] + -0.2679416522233877*b[i + 53*ldb] + 0.07635866179581294*b[i + 54*ldb]);
        c[i + 111*ldc] = (1.551408049094313*b[i + 55*ldb] + -0.8931583920000719*b[i + 56*ldb] + 0.5333333333333334*b[i + 57*ldb] + -0.2679416522233877*b[i + 58*ldb] + 0.07635866179581294*b[i + 59*ldb]);
        c[i + 112*ldc] = (1.551408049094313*b[i + 60*ldb] + -0.8931583920000719*b[i + 61*ldb] + 0.5333333333333334*b[i + 62*ldb] + -0.2679416522233877*b[i + 63*ldb] + 0.07635866179581294*b[i + 64*ldb]);
        c[i + 113*ldc] = (1.551408049094313*b[i + 65*ldb] + -0.8931583920000719*b[i + 66*ldb] + 0.5333333333333334*b[i + 67*ldb] + -0.2679416522233877*b[i + 68*ldb] + 0.07635866179581294*b[i + 69*ldb]);
        c[i + 114*ldc] = (1.551408049094313*b[i + 70*ldb] + -0.8931583920000719*b[i + 71*ldb] + 0.5333333333333334*b[i + 72*ldb] + -0.2679416522233877*b[i + 73*ldb] + 0.07635866179581294*b[i + 74*ldb]);
        c[i + 115*ldc] = (1.551408049094313*b[i + 75*ldb] + -0.8931583920000719*b[i + 76*ldb] + 0.5333333333333334*b[i + 77*ldb] + -0.2679416522233877*b[i + 78*ldb] + 0.07635866179581294*b[i + 79*ldb]);
        c[i + 116*ldc] = (1.551408049094313*b[i + 80*ldb] + -0.8931583920000719*b[i + 81*ldb] + 0.5333333333333334*b[i + 82*ldb] + -0.2679416522233877*b[i + 83*ldb] + 0.07635866179581294*b[i + 84*ldb]);
        c[i + 117*ldc] = (1.551408049094313*b[i + 85*ldb] + -0.8931583920000719*b[i + 86*ldb] + 0.5333333333333334*b[i + 87*ldb] + -0.2679416522233877*b[i + 88*ldb] + 0.07635866179581294*b[i + 89*ldb]);
        c[i + 118*ldc] = (1.551408049094313*b[i + 90*ldb] + -0.8931583920000719*b[i + 91*ldb] + 0.5333333333333334*b[i + 92*ldb] + -0.2679416522233877*b[i + 93*ldb] + 0.07635866179581294*b[i + 94*ldb]);
        c[i + 119*ldc] = (1.551408049094313*b[i + 95*ldb] + -0.8931583920000719*b[i + 96*ldb] + 0.5333333333333334*b[i + 97*ldb] + -0.2679416522233877*b[i + 98*ldb] + 0.07635866179581294*b[i + 99*ldb]);
        c[i + 120*ldc] = (1.551408049094313*b[i + 100*ldb] + -0.8931583920000719*b[i + 101*ldb] + 0.5333333333333334*b[i + 102*ldb] + -0.2679416522233877*b[i + 103*ldb] + 0.07635866179581294*b[i + 104*ldb]);
        c[i + 121*ldc] = (1.551408049094313*b[i + 105*ldb] + -0.8931583920000719*b[i + 106*ldb] + 0.5333333333333334*b[i + 107*ldb] + -0.2679416522233877*b[i + 108*ldb] + 0.07635866179581294*b[i + 109*ldb]);
        c[i + 122*ldc] = (1.551408049094313*b[i + 110*ldb] + -0.8931583920000719*b[i + 111*ldb] + 0.5333333333333334*b[i + 112*ldb] + -0.2679416522233877*b[i + 113*ldb] + 0.07635866179581294*b[i + 114*ldb]);
        c[i + 123*ldc] = (1.551408049094313*b[i + 115*ldb] + -0.8931583920000719*b[i + 116*ldb] + 0.5333333333333334*b[i + 117*ldb] + -0.2679416522233877*b[i + 118*ldb] + 0.07635866179581294*b[i + 119*ldb]);
        c[i + 124*ldc] = (1.551408049094313*b[i + 120*ldb] + -0.8931583920000719*b[i + 121*ldb] + 0.5333333333333334*b[i + 122*ldb] + -0.2679416522233877*b[i + 123*ldb] + 0.07635866179581294*b[i + 124*ldb]);
        c[i + 125*ldc] = (0.07635866179581294*b[i + 0*ldb] + -0.2679416522233877*b[i + 25*ldb] + 0.5333333333333334*b[i + 50*ldb] + -0.8931583920000719*b[i + 75*ldb] + 1.551408049094313*b[i + 100*ldb]);
        c[i + 126*ldc] = (0.07635866179581294*b[i + 1*ldb] + -0.2679416522233877*b[i + 26*ldb] + 0.5333333333333334*b[i + 51*ldb] + -0.8931583920000719*b[i + 76*ldb] + 1.551408049094313*b[i + 101*ldb]);
        c[i + 127*ldc] = (0.07635866179581294*b[i + 2*ldb] + -0.2679416522233877*b[i + 27*ldb] + 0.5333333333333334*b[i + 52*ldb] + -0.8931583920000719*b[i + 77*ldb] + 1.551408049094313*b[i + 102*ldb]);
        c[i + 128*ldc] = (0.07635866179581294*b[i + 3*ldb] + -0.2679416522233877*b[i + 28*ldb] + 0.5333333333333334*b[i + 53*ldb] + -0.8931583920000719*b[i + 78*ldb] + 1.551408049094313*b[i + 103*ldb]);
        c[i + 129*ldc] = (0.07635866179581294*b[i + 4*ldb] + -0.2679416522233877*b[i + 29*ldb] + 0.5333333333333334*b[i + 54*ldb] + -0.8931583920000719*b[i + 79*ldb] + 1.551408049094313*b[i + 104*ldb]);
        c[i + 130*ldc] = (0.07635866179581294*b[i + 5*ldb] + -0.2679416522233877*b[i + 30*ldb] + 0.5333333333333334*b[i + 55*ldb] + -0.8931583920000719*b[i + 80*ldb] + 1.551408049094313*b[i + 105*ldb]);
        c[i + 131*ldc] = (0.07635866179581294*b[i + 6*ldb] + -0.2679416522233877*b[i + 31*ldb] + 0.5333333333333334*b[i + 56*ldb] + -0.8931583920000719*b[i + 81*ldb] + 1.551408049094313*b[i + 106*ldb]);
        c[i + 132*ldc] = (0.07635866179581294*b[i + 7*ldb] + -0.2679416522233877*b[i + 32*ldb] + 0.5333333333333334*b[i + 57*ldb] + -0.8931583920000719*b[i + 82*ldb] + 1.551408049094313*b[i + 107*ldb]);
        c[i + 133*ldc] = (0.07635866179581294*b[i + 8*ldb] + -0.2679416522233877*b[i + 33*ldb] + 0.5333333333333334*b[i + 58*ldb] + -0.8931583920000719*b[i + 83*ldb] + 1.551408049094313*b[i + 108*ldb]);
        c[i + 134*ldc] = (0.07635866179581294*b[i + 9*ldb] + -0.2679416522233877*b[i + 34*ldb] + 0.5333333333333334*b[i + 59*ldb] + -0.8931583920000719*b[i + 84*ldb] + 1.551408049094313*b[i + 109*ldb]);
        c[i + 135*ldc] = (0.07635866179581294*b[i + 10*ldb] + -0.2679416522233877*b[i + 35*ldb] + 0.5333333333333334*b[i + 60*ldb] + -0.8931583920000719*b[i + 85*ldb] + 1.551408049094313*b[i + 110*ldb]);
        c[i + 136*ldc] = (0.07635866179581294*b[i + 11*ldb] + -0.2679416522233877*b[i + 36*ldb] + 0.5333333333333334*b[i + 61*ldb] + -0.8931583920000719*b[i + 86*ldb] + 1.551408049094313*b[i + 111*ldb]);
        c[i + 137*ldc] = (0.07635866179581294*b[i + 12*ldb] + -0.2679416522233877*b[i + 37*ldb] + 0.5333333333333334*b[i + 62*ldb] + -0.8931583920000719*b[i + 87*ldb] + 1.551408049094313*b[i + 112*ldb]);
        c[i + 138*ldc] = (0.07635866179581294*b[i + 13*ldb] + -0.2679416522233877*b[i + 38*ldb] + 0.5333333333333334*b[i + 63*ldb] + -0.8931583920000719*b[i + 88*ldb] + 1.551408049094313*b[i + 113*ldb]);
        c[i + 139*ldc] = (0.07635866179581294*b[i + 14*ldb] + -0.2679416522233877*b[i + 39*ldb] + 0.5333333333333334*b[i + 64*ldb] + -0.8931583920000719*b[i + 89*ldb] + 1.551408049094313*b[i + 114*ldb]);
        c[i + 140*ldc] = (0.07635866179581294*b[i + 15*ldb] + -0.2679416522233877*b[i + 40*ldb] + 0.5333333333333334*b[i + 65*ldb] + -0.8931583920000719*b[i + 90*ldb] + 1.551408049094313*b[i + 115*ldb]);
        c[i + 141*ldc] = (0.07635866179581294*b[i + 16*ldb] + -0.2679416522233877*b[i + 41*ldb] + 0.5333333333333334*b[i + 66*ldb] + -0.8931583920000719*b[i + 91*ldb] + 1.551408049094313*b[i + 116*ldb]);
        c[i + 142*ldc] = (0.07635866179581294*b[i + 17*ldb] + -0.2679416522233877*b[i + 42*ldb] + 0.5333333333333334*b[i + 67*ldb] + -0.8931583920000719*b[i + 92*ldb] + 1.551408049094313*b[i + 117*ldb]);
        c[i + 143*ldc] = (0.07635866179581294*b[i + 18*ldb] + -0.2679416522233877*b[i + 43*ldb] + 0.5333333333333334*b[i + 68*ldb] + -0.8931583920000719*b[i + 93*ldb] + 1.551408049094313*b[i + 118*ldb]);
        c[i + 144*ldc] = (0.07635866179581294*b[i + 19*ldb] + -0.2679416522233877*b[i + 44*ldb] + 0.5333333333333334*b[i + 69*ldb] + -0.8931583920000719*b[i + 94*ldb] + 1.551408049094313*b[i + 119*ldb]);
        c[i + 145*ldc] = (0.07635866179581294*b[i + 20*ldb] + -0.2679416522233877*b[i + 45*ldb] + 0.5333333333333334*b[i + 70*ldb] + -0.8931583920000719*b[i + 95*ldb] + 1.551408049094313*b[i + 120*ldb]);
        c[i + 146*ldc] = (0.07635866179581294*b[i + 21*ldb] + -0.2679416522233877*b[i + 46*ldb] + 0.5333333333333334*b[i + 71*ldb] + -0.8931583920000719*b[i + 96*ldb] + 1.551408049094313*b[i + 121*ldb]);
        c[i + 147*ldc] = (0.07635866179581294*b[i + 22*ldb] + -0.2679416522233877*b[i + 47*ldb] + 0.5333333333333334*b[i + 72*ldb] + -0.8931583920000719*b[i + 97*ldb] + 1.551408049094313*b[i + 122*ldb]);
        c[i + 148*ldc] = (0.07635866179581294*b[i + 23*ldb] + -0.2679416522233877*b[i + 48*ldb] + 0.5333333333333334*b[i + 73*ldb] + -0.8931583920000719*b[i + 98*ldb] + 1.551408049094313*b[i + 123*ldb]);
        c[i + 149*ldc] = (0.07635866179581294*b[i + 24*ldb] + -0.2679416522233877*b[i + 49*ldb] + 0.5333333333333334*b[i + 74*ldb] + -0.8931583920000719*b[i + 99*ldb] + 1.551408049094313*b[i + 124*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_hex_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (6.548045607936744*b[i + 0*ldb] + 6.548045607936744*b[i + 25*ldb] + 0.3222878728081187*b[i + 50*ldb] + 0.3222878728081187*b[i + 75*ldb] + 6.548045607936744*b[i + 100*ldb] + 0.3222878728081187*b[i + 125*ldb]);
        c[i + 1*ldc] += (6.548045607936744*b[i + 1*ldb] + 6.548045607936744*b[i + 26*ldb] + -0.5598111202653958*b[i + 50*ldb] + 0.3222878728081187*b[i + 76*ldb] + -1.866077916035022*b[i + 100*ldb] + 0.3222878728081187*b[i + 126*ldb]);
        c[i + 2*ldc] += (6.548045607936744*b[i + 2*ldb] + 6.548045607936744*b[i + 27*ldb] + 0.9374999999999998*b[i + 50*ldb] + 0.3222878728081187*b[i + 77*ldb] + 0.9374999999999998*b[i + 100*ldb] + 0.3222878728081187*b[i + 127*ldb]);
        c[i + 3*ldc] += (6.548045607936744*b[i + 3*ldb] + 6.548045607936744*b[i + 28*ldb] + -1.866077916035022*b[i + 50*ldb] + 0.3222878728081187*b[i + 78*ldb] + -0.5598111202653958*b[i + 100*ldb] + 0.3222878728081187*b[i + 128*ldb]);
        c[i + 4*ldc] += (6.548045607936744*b[i + 4*ldb] + 6.548045607936744*b[i + 29*ldb] + 6.548045607936744*b[i + 50*ldb] + 0.3222878728081187*b[i + 79*ldb] + 0.3222878728081187*b[i + 100*ldb] + 0.3222878728081187*b[i + 129*ldb]);
        c[i + 5*ldc] += (6.548045607936744*b[i + 5*ldb] + -1.866077916035022*b[i + 25*ldb] + 0.3222878728081187*b[i + 51*ldb] + -0.5598111202653958*b[i + 75*ldb] + 6.548045607936744*b[i + 101*ldb] + 0.3222878728081187*b[i + 130*ldb]);
        c[i + 6*ldc] += (6.548045607936744*b[i + 6*ldb] + -1.866077916035022*b[i + 26*ldb] + -0.5598111202653958*b[i + 51*ldb] + -0.5598111202653958*b[i + 76*ldb] + -1.866077916035022*b[i + 101*ldb] + 0.3222878728081187*b[i + 131*ldb]);
        c[i + 7*ldc] += (6.548045607936744*b[i + 7*ldb] + -1.866077916035022*b[i + 27*ldb] + 0.9374999999999998*b[i + 51*ldb] + -0.5598111202653958*b[i + 77*ldb] + 0.9374999999999998*b[i + 101*ldb] + 0.3222878728081187*b[i + 132*ldb]);
        c[i + 8*ldc] += (6.548045607936744*b[i + 8*ldb] + -1.866077916035022*b[i + 28*ldb] + -1.866077916035022*b[i + 51*ldb] + -0.5598111202653958*b[i + 78*ldb] + -0.5598111202653958*b[i + 101*ldb] + 0.3222878728081187*b[i + 133*ldb]);
        c[i + 9*ldc] += (6.548045607936744*b[i + 9*ldb] + -1.866077916035022*b[i + 29*ldb] + 6.548045607936744*b[i + 51*ldb] + -0.5598111202653958*b[i + 79*ldb] + 0.3222878728081187*b[i + 101*ldb] + 0.3222878728081187*b[i + 134*ldb]);
        c[i + 10*ldc] += (6.548045607936744*b[i + 10*ldb] + 0.9374999999999998*b[i + 25*ldb] + 0.3222878728081187*b[i + 52*ldb] + 0.9374999999999998*b[i + 75*ldb] + 6.548045607936744*b[i + 102*ldb] + 0.3222878728081187*b[i + 135*ldb]);
        c[i + 11*ldc] += (6.548045607936744*b[i + 11*ldb] + 0.9374999999999998*b[i + 26*ldb] + -0.5598111202653958*b[i + 52*ldb] + 0.9374999999999998*b[i + 76*ldb] + -1.866077916035022*b[i + 102*ldb] + 0.3222878728081187*b[i + 136*ldb]);
        c[i + 12*ldc] += (6.548045607936744*b[i + 12*ldb] + 0.9374999999999998*b[i + 27*ldb] + 0.9374999999999998*b[i + 52*ldb] + 0.9374999999999998*b[i + 77*ldb] + 0.9374999999999998*b[i + 102*ldb] + 0.3222878728081187*b[i + 137*ldb]);
        c[i + 13*ldc] += (6.548045607936744*b[i + 13*ldb] + 0.9374999999999998*b[i + 28*ldb] + -1.866077916035022*b[i + 52*ldb] + 0.9374999999999998*b[i + 78*ldb] + -0.5598111202653958*b[i + 102*ldb] + 0.3222878728081187*b[i + 138*ldb]);
        c[i + 14*ldc] += (6.548045607936744*b[i + 14*ldb] + 0.9374999999999998*b[i + 29*ldb] + 6.548045607936744*b[i + 52*ldb] + 0.9374999999999998*b[i + 79*ldb] + 0.3222878728081187*b[i + 102*ldb] + 0.3222878728081187*b[i + 139*ldb]);
        c[i + 15*ldc] += (6.548045607936744*b[i + 15*ldb] + -0.5598111202653958*b[i + 25*ldb] + 0.3222878728081187*b[i + 53*ldb] + -1.866077916035022*b[i + 75*ldb] + 6.548045607936744*b[i + 103*ldb] + 0.3222878728081187*b[i + 140*ldb]);
        c[i + 16*ldc] += (6.548045607936744*b[i + 16*ldb] + -0.5598111202653958*b[i + 26*ldb] + -0.5598111202653958*b[i + 53*ldb] + -1.866077916035022*b[i + 76*ldb] + -1.866077916035022*b[i + 103*ldb] + 0.3222878728081187*b[i + 141*ldb]);
        c[i + 17*ldc] += (6.548045607936744*b[i + 17*ldb] + -0.5598111202653958*b[i + 27*ldb] + 0.9374999999999998*b[i + 53*ldb] + -1.866077916035022*b[i + 77*ldb] + 0.9374999999999998*b[i + 103*ldb] + 0.3222878728081187*b[i + 142*ldb]);
        c[i + 18*ldc] += (6.548045607936744*b[i + 18*ldb] + -0.5598111202653958*b[i + 28*ldb] + -1.866077916035022*b[i + 53*ldb] + -1.866077916035022*b[i + 78*ldb] + -0.5598111202653958*b[i + 103*ldb] + 0.3222878728081187*b[i + 143*ldb]);
        c[i + 19*ldc] += (6.548045607936744*b[i + 19*ldb] + -0.5598111202653958*b[i + 29*ldb] + 6.548045607936744*b[i + 53*ldb] + -1.866077916035022*b[i + 79*ldb] + 0.3222878728081187*b[i + 103*ldb] + 0.3222878728081187*b[i + 144*ldb]);
        c[i + 20*ldc] += (6.548045607936744*b[i + 20*ldb] + 0.3222878728081187*b[i + 25*ldb] + 0.3222878728081187*b[i + 54*ldb] + 6.548045607936744*b[i + 75*ldb] + 6.548045607936744*b[i + 104*ldb] + 0.3222878728081187*b[i + 145*ldb]);
        c[i + 21*ldc] += (6.548045607936744*b[i + 21*ldb] + 0.3222878728081187*b[i + 26*ldb] + -0.5598111202653958*b[i + 54*ldb] + 6.548045607936744*b[i + 76*ldb] + -1.866077916035022*b[i + 104*ldb] + 0.3222878728081187*b[i + 146*ldb]);
        c[i + 22*ldc] += (6.548045607936744*b[i + 22*ldb] + 0.3222878728081187*b[i + 27*ldb] + 0.9374999999999998*b[i + 54*ldb] + 6.548045607936744*b[i + 77*ldb] + 0.9374999999999998*b[i + 104*ldb] + 0.3222878728081187*b[i + 147*ldb]);
        c[i + 23*ldc] += (6.548045607936744*b[i + 23*ldb] + 0.3222878728081187*b[i + 28*ldb] + -1.866077916035022*b[i + 54*ldb] + 6.548045607936744*b[i + 78*ldb] + -0.5598111202653958*b[i + 104*ldb] + 0.3222878728081187*b[i + 148*ldb]);
        c[i + 24*ldc] += (6.548045607936744*b[i + 24*ldb] + 0.3222878728081187*b[i + 29*ldb] + 6.548045607936744*b[i + 54*ldb] + 6.548045607936744*b[i + 79*ldb] + 0.3222878728081187*b[i + 104*ldb] + 0.3222878728081187*b[i + 149*ldb]);
        c[i + 25*ldc] += (-1.866077916035022*b[i + 0*ldb] + 6.548045607936744*b[i + 30*ldb] + 0.3222878728081187*b[i + 55*ldb] + 0.3222878728081187*b[i + 80*ldb] + 6.548045607936744*b[i + 105*ldb] + -0.5598111202653958*b[i + 125*ldb]);
        c[i + 26*ldc] += (-1.866077916035022*b[i + 1*ldb] + 6.548045607936744*b[i + 31*ldb] + -0.5598111202653958*b[i + 55*ldb] + 0.3222878728081187*b[i + 81*ldb] + -1.866077916035022*b[i + 105*ldb] + -0.5598111202653958*b[i + 126*ldb]);
        c[i + 27*ldc] += (-1.866077916035022*b[i + 2*ldb] + 6.548045607936744*b[i + 32*ldb] + 0.9374999999999998*b[i + 55*ldb] + 0.3222878728081187*b[i + 82*ldb] + 0.9374999999999998*b[i + 105*ldb] + -0.5598111202653958*b[i + 127*ldb]);
        c[i + 28*ldc] += (-1.866077916035022*b[i + 3*ldb] + 6.548045607936744*b[i + 33*ldb] + -1.866077916035022*b[i + 55*ldb] + 0.3222878728081187*b[i + 83*ldb] + -0.5598111202653958*b[i + 105*ldb] + -0.5598111202653958*b[i + 128*ldb]);
        c[i + 29*ldc] += (-1.866077916035022*b[i + 4*ldb] + 6.548045607936744*b[i + 34*ldb] + 6.548045607936744*b[i + 55*ldb] + 0.3222878728081187*b[i + 84*ldb] + 0.3222878728081187*b[i + 105*ldb] + -0.5598111202653958*b[i + 129*ldb]);
        c[i + 30*ldc] += (-1.866077916035022*b[i + 5*ldb] + -1.866077916035022*b[i + 30*ldb] + 0.3222878728081187*b[i + 56*ldb] + -0.5598111202653958*b[i + 80*ldb] + 6.548045607936744*b[i + 106*ldb] + -0.5598111202653958*b[i + 130*ldb]);
        c[i + 31*ldc] += (-1.866077916035022*b[i + 6*ldb] + -1.866077916035022*b[i + 31*ldb] + -0.5598111202653958*b[i + 56*ldb] + -0.5598111202653958*b[i + 81*ldb] + -1.866077916035022*b[i + 106*ldb] + -0.5598111202653958*b[i + 131*ldb]);
        c[i + 32*ldc] += (-1.866077916035022*b[i + 7*ldb] + -1.866077916035022*b[i + 32*ldb] + 0.9374999999999998*b[i + 56*ldb] + -0.5598111202653958*b[i + 82*ldb] + 0.9374999999999998*b[i + 106*ldb] + -0.5598111202653958*b[i + 132*ldb]);
        c[i + 33*ldc] += (-1.866077916035022*b[i + 8*ldb] + -1.866077916035022*b[i + 33*ldb] + -1.866077916035022*b[i + 56*ldb] + -0.5598111202653958*b[i + 83*ldb] + -0.5598111202653958*b[i + 106*ldb] + -0.5598111202653958*b[i + 133*ldb]);
        c[i + 34*ldc] += (-1.866077916035022*b[i + 9*ldb] + -1.866077916035022*b[i + 34*ldb] + 6.548045607936744*b[i + 56*ldb] + -0.5598111202653958*b[i + 84*ldb] + 0.3222878728081187*b[i + 106*ldb] + -0.5598111202653958*b[i + 134*ldb]);
        c[i + 35*ldc] += (-1.866077916035022*b[i + 10*ldb] + 0.9374999999999998*b[i + 30*ldb] + 0.3222878728081187*b[i + 57*ldb] + 0.9374999999999998*b[i + 80*ldb] + 6.548045607936744*b[i + 107*ldb] + -0.5598111202653958*b[i + 135*ldb]);
        c[i + 36*ldc] += (-1.866077916035022*b[i + 11*ldb] + 0.9374999999999998*b[i + 31*ldb] + -0.5598111202653958*b[i + 57*ldb] + 0.9374999999999998*b[i + 81*ldb] + -1.866077916035022*b[i + 107*ldb] + -0.5598111202653958*b[i + 136*ldb]);
        c[i + 37*ldc] += (-1.866077916035022*b[i + 12*ldb] + 0.9374999999999998*b[i + 32*ldb] + 0.9374999999999998*b[i + 57*ldb] + 0.9374999999999998*b[i + 82*ldb] + 0.9374999999999998*b[i + 107*ldb] + -0.5598111202653958*b[i + 137*ldb]);
        c[i + 38*ldc] += (-1.866077916035022*b[i + 13*ldb] + 0.9374999999999998*b[i + 33*ldb] + -1.866077916035022*b[i + 57*ldb] + 0.9374999999999998*b[i + 83*ldb] + -0.5598111202653958*b[i + 107*ldb] + -0.5598111202653958*b[i + 138*ldb]);
        c[i + 39*ldc] += (-1.866077916035022*b[i + 14*ldb] + 0.9374999999999998*b[i + 34*ldb] + 6.548045607936744*b[i + 57*ldb] + 0.9374999999999998*b[i + 84*ldb] + 0.3222878728081187*b[i + 107*ldb] + -0.5598111202653958*b[i + 139*ldb]);
        c[i + 40*ldc] += (-1.866077916035022*b[i + 15*ldb] + -0.5598111202653958*b[i + 30*ldb] + 0.3222878728081187*b[i + 58*ldb] + -1.866077916035022*b[i + 80*ldb] + 6.548045607936744*b[i + 108*ldb] + -0.5598111202653958*b[i + 140*ldb]);
        c[i + 41*ldc] += (-1.866077916035022*b[i + 16*ldb] + -0.5598111202653958*b[i + 31*ldb] + -0.5598111202653958*b[i + 58*ldb] + -1.866077916035022*b[i + 81*ldb] + -1.866077916035022*b[i + 108*ldb] + -0.5598111202653958*b[i + 141*ldb]);
        c[i + 42*ldc] += (-1.866077916035022*b[i + 17*ldb] + -0.5598111202653958*b[i + 32*ldb] + 0.9374999999999998*b[i + 58*ldb] + -1.866077916035022*b[i + 82*ldb] + 0.9374999999999998*b[i + 108*ldb] + -0.5598111202653958*b[i + 142*ldb]);
        c[i + 43*ldc] += (-1.866077916035022*b[i + 18*ldb] + -0.5598111202653958*b[i + 33*ldb] + -1.866077916035022*b[i + 58*ldb] + -1.866077916035022*b[i + 83*ldb] + -0.5598111202653958*b[i + 108*ldb] + -0.5598111202653958*b[i + 143*ldb]);
        c[i + 44*ldc] += (-1.866077916035022*b[i + 19*ldb] + -0.5598111202653958*b[i + 34*ldb] + 6.548045607936744*b[i + 58*ldb] + -1.866077916035022*b[i + 84*ldb] + 0.3222878728081187*b[i + 108*ldb] + -0.5598111202653958*b[i + 144*ldb]);
        c[i + 45*ldc] += (-1.866077916035022*b[i + 20*ldb] + 0.3222878728081187*b[i + 30*ldb] + 0.3222878728081187*b[i + 59*ldb] + 6.548045607936744*b[i + 80*ldb] + 6.548045607936744*b[i + 109*ldb] + -0.5598111202653958*b[i + 145*ldb]);
        c[i + 46*ldc] += (-1.866077916035022*b[i + 21*ldb] + 0.3222878728081187*b[i + 31*ldb] + -0.5598111202653958*b[i + 59*ldb] + 6.548045607936744*b[i + 81*ldb] + -1.866077916035022*b[i + 109*ldb] + -0.5598111202653958*b[i + 146*ldb]);
        c[i + 47*ldc] += (-1.866077916035022*b[i + 22*ldb] + 0.3222878728081187*b[i + 32*ldb] + 0.9374999999999998*b[i + 59*ldb] + 6.548045607936744*b[i + 82*ldb] + 0.9374999999999998*b[i + 109*ldb] + -0.5598111202653958*b[i + 147*ldb]);
        c[i + 48*ldc] += (-1.866077916035022*b[i + 23*ldb] + 0.3222878728081187*b[i + 33*ldb] + -1.866077916035022*b[i + 59*ldb] + 6.548045607936744*b[i + 83*ldb] + -0.5598111202653958*b[i + 109*ldb] + -0.5598111202653958*b[i + 148*ldb]);
        c[i + 49*ldc] += (-1.866077916035022*b[i + 24*ldb] + 0.3222878728081187*b[i + 34*ldb] + 6.548045607936744*b[i + 59*ldb] + 6.548045607936744*b[i + 84*ldb] + 0.3222878728081187*b[i + 109*ldb] + -0.5598111202653958*b[i + 149*ldb]);
        c[i + 50*ldc] += (0.9374999999999998*b[i + 0*ldb] + 6.548045607936744*b[i + 35*ldb] + 0.3222878728081187*b[i + 60*ldb] + 0.3222878728081187*b[i + 85*ldb] + 6.548045607936744*b[i + 110*ldb] + 0.9374999999999998*b[i + 125*ldb]);
        c[i + 51*ldc] += (0.9374999999999998*b[i + 1*ldb] + 6.548045607936744*b[i + 36*ldb] + -0.5598111202653958*b[i + 60*ldb] + 0.3222878728081187*b[i + 86*ldb] + -1.866077916035022*b[i + 110*ldb] + 0.9374999999999998*b[i + 126*ldb]);
        c[i + 52*ldc] += (0.9374999999999998*b[i + 2*ldb] + 6.548045607936744*b[i + 37*ldb] + 0.9374999999999998*b[i + 60*ldb] + 0.3222878728081187*b[i + 87*ldb] + 0.9374999999999998*b[i + 110*ldb] + 0.9374999999999998*b[i + 127*ldb]);
        c[i + 53*ldc] += (0.9374999999999998*b[i + 3*ldb] + 6.548045607936744*b[i + 38*ldb] + -1.866077916035022*b[i + 60*ldb] + 0.3222878728081187*b[i + 88*ldb] + -0.5598111202653958*b[i + 110*ldb] + 0.9374999999999998*b[i + 128*ldb]);
        c[i + 54*ldc] += (0.9374999999999998*b[i + 4*ldb] + 6.548045607936744*b[i + 39*ldb] + 6.548045607936744*b[i + 60*ldb] + 0.3222878728081187*b[i + 89*ldb] + 0.3222878728081187*b[i + 110*ldb] + 0.9374999999999998*b[i + 129*ldb]);
        c[i + 55*ldc] += (0.9374999999999998*b[i + 5*ldb] + -1.866077916035022*b[i + 35*ldb] + 0.3222878728081187*b[i + 61*ldb] + -0.5598111202653958*b[i + 85*ldb] + 6.548045607936744*b[i + 111*ldb] + 0.9374999999999998*b[i + 130*ldb]);
        c[i + 56*ldc] += (0.9374999999999998*b[i + 6*ldb] + -1.866077916035022*b[i + 36*ldb] + -0.5598111202653958*b[i + 61*ldb] + -0.5598111202653958*b[i + 86*ldb] + -1.866077916035022*b[i + 111*ldb] + 0.9374999999999998*b[i + 131*ldb]);
        c[i + 57*ldc] += (0.9374999999999998*b[i + 7*ldb] + -1.866077916035022*b[i + 37*ldb] + 0.9374999999999998*b[i + 61*ldb] + -0.5598111202653958*b[i + 87*ldb] + 0.9374999999999998*b[i + 111*ldb] + 0.9374999999999998*b[i + 132*ldb]);
        c[i + 58*ldc] += (0.9374999999999998*b[i + 8*ldb] + -1.866077916035022*b[i + 38*ldb] + -1.866077916035022*b[i + 61*ldb] + -0.5598111202653958*b[i + 88*ldb] + -0.5598111202653958*b[i + 111*ldb] + 0.9374999999999998*b[i + 133*ldb]);
        c[i + 59*ldc] += (0.9374999999999998*b[i + 9*ldb] + -1.866077916035022*b[i + 39*ldb] + 6.548045607936744*b[i + 61*ldb] + -0.5598111202653958*b[i + 89*ldb] + 0.3222878728081187*b[i + 111*ldb] + 0.9374999999999998*b[i + 134*ldb]);
        c[i + 60*ldc] += (0.9374999999999998*b[i + 10*ldb] + 0.9374999999999998*b[i + 35*ldb] + 0.3222878728081187*b[i + 62*ldb] + 0.9374999999999998*b[i + 85*ldb] + 6.548045607936744*b[i + 112*ldb] + 0.9374999999999998*b[i + 135*ldb]);
        c[i + 61*ldc] += (0.9374999999999998*b[i + 11*ldb] + 0.9374999999999998*b[i + 36*ldb] + -0.5598111202653958*b[i + 62*ldb] + 0.9374999999999998*b[i + 86*ldb] + -1.866077916035022*b[i + 112*ldb] + 0.9374999999999998*b[i + 136*ldb]);
        c[i + 62*ldc] += (0.9374999999999998*b[i + 12*ldb] + 0.9374999999999998*b[i + 37*ldb] + 0.9374999999999998*b[i + 62*ldb] + 0.9374999999999998*b[i + 87*ldb] + 0.9374999999999998*b[i + 112*ldb] + 0.9374999999999998*b[i + 137*ldb]);
        c[i + 63*ldc] += (0.9374999999999998*b[i + 13*ldb] + 0.9374999999999998*b[i + 38*ldb] + -1.866077916035022*b[i + 62*ldb] + 0.9374999999999998*b[i + 88*ldb] + -0.5598111202653958*b[i + 112*ldb] + 0.9374999999999998*b[i + 138*ldb]);
        c[i + 64*ldc] += (0.9374999999999998*b[i + 14*ldb] + 0.9374999999999998*b[i + 39*ldb] + 6.548045607936744*b[i + 62*ldb] + 0.9374999999999998*b[i + 89*ldb] + 0.3222878728081187*b[i + 112*ldb] + 0.9374999999999998*b[i + 139*ldb]);
        c[i + 65*ldc] += (0.9374999999999998*b[i + 15*ldb] + -0.5598111202653958*b[i + 35*ldb] + 0.3222878728081187*b[i + 63*ldb] + -1.866077916035022*b[i + 85*ldb] + 6.548045607936744*b[i + 113*ldb] + 0.9374999999999998*b[i + 140*ldb]);
        c[i + 66*ldc] += (0.9374999999999998*b[i + 16*ldb] + -0.5598111202653958*b[i + 36*ldb] + -0.5598111202653958*b[i + 63*ldb] + -1.866077916035022*b[i + 86*ldb] + -1.866077916035022*b[i + 113*ldb] + 0.9374999999999998*b[i + 141*ldb]);
        c[i + 67*ldc] += (0.9374999999999998*b[i + 17*ldb] + -0.5598111202653958*b[i + 37*ldb] + 0.9374999999999998*b[i + 63*ldb] + -1.866077916035022*b[i + 87*ldb] + 0.9374999999999998*b[i + 113*ldb] + 0.9374999999999998*b[i + 142*ldb]);
        c[i + 68*ldc] += (0.9374999999999998*b[i + 18*ldb] + -0.5598111202653958*b[i + 38*ldb] + -1.866077916035022*b[i + 63*ldb] + -1.866077916035022*b[i + 88*ldb] + -0.5598111202653958*b[i + 113*ldb] + 0.9374999999999998*b[i + 143*ldb]);
        c[i + 69*ldc] += (0.9374999999999998*b[i + 19*ldb] + -0.5598111202653958*b[i + 39*ldb] + 6.548045607936744*b[i + 63*ldb] + -1.866077916035022*b[i + 89*ldb] + 0.3222878728081187*b[i + 113*ldb] + 0.9374999999999998*b[i + 144*ldb]);
        c[i + 70*ldc] += (0.9374999999999998*b[i + 20*ldb] + 0.3222878728081187*b[i + 35*ldb] + 0.3222878728081187*b[i + 64*ldb] + 6.548045607936744*b[i + 85*ldb] + 6.548045607936744*b[i + 114*ldb] + 0.9374999999999998*b[i + 145*ldb]);
        c[i + 71*ldc] += (0.9374999999999998*b[i + 21*ldb] + 0.3222878728081187*b[i + 36*ldb] + -0.5598111202653958*b[i + 64*ldb] + 6.548045607936744*b[i + 86*ldb] + -1.866077916035022*b[i + 114*ldb] + 0.9374999999999998*b[i + 146*ldb]);
        c[i + 72*ldc] += (0.9374999999999998*b[i + 22*ldb] + 0.3222878728081187*b[i + 37*ldb] + 0.9374999999999998*b[i + 64*ldb] + 6.548045607936744*b[i + 87*ldb] + 0.9374999999999998*b[i + 114*ldb] + 0.9374999999999998*b[i + 147*ldb]);
        c[i + 73*ldc] += (0.9374999999999998*b[i + 23*ldb] + 0.3222878728081187*b[i + 38*ldb] + -1.866077916035022*b[i + 64*ldb] + 6.548045607936744*b[i + 88*ldb] + -0.5598111202653958*b[i + 114*ldb] + 0.9374999999999998*b[i + 148*ldb]);
        c[i + 74*ldc] += (0.9374999999999998*b[i + 24*ldb] + 0.3222878728081187*b[i + 39*ldb] + 6.548045607936744*b[i + 64*ldb] + 6.548045607936744*b[i + 89*ldb] + 0.3222878728081187*b[i + 114*ldb] + 0.9374999999999998*b[i + 149*ldb]);
        c[i + 75*ldc] += (-0.5598111202653958*b[i + 0*ldb] + 6.548045607936744*b[i + 40*ldb] + 0.3222878728081187*b[i + 65*ldb] + 0.3222878728081187*b[i + 90*ldb] + 6.548045607936744*b[i + 115*ldb] + -1.866077916035022*b[i + 125*ldb]);
        c[i + 76*ldc] += (-0.5598111202653958*b[i + 1*ldb] + 6.548045607936744*b[i + 41*ldb] + -0.5598111202653958*b[i + 65*ldb] + 0.3222878728081187*b[i + 91*ldb] + -1.866077916035022*b[i + 115*ldb] + -1.866077916035022*b[i + 126*ldb]);
        c[i + 77*ldc] += (-0.5598111202653958*b[i + 2*ldb] + 6.548045607936744*b[i + 42*ldb] + 0.9374999999999998*b[i + 65*ldb] + 0.3222878728081187*b[i + 92*ldb] + 0.9374999999999998*b[i + 115*ldb] + -1.866077916035022*b[i + 127*ldb]);
        c[i + 78*ldc] += (-0.5598111202653958*b[i + 3*ldb] + 6.548045607936744*b[i + 43*ldb] + -1.866077916035022*b[i + 65*ldb] + 0.3222878728081187*b[i + 93*ldb] + -0.5598111202653958*b[i + 115*ldb] + -1.866077916035022*b[i + 128*ldb]);
        c[i + 79*ldc] += (-0.5598111202653958*b[i + 4*ldb] + 6.548045607936744*b[i + 44*ldb] + 6.548045607936744*b[i + 65*ldb] + 0.3222878728081187*b[i + 94*ldb] + 0.3222878728081187*b[i + 115*ldb] + -1.866077916035022*b[i + 129*ldb]);
        c[i + 80*ldc] += (-0.5598111202653958*b[i + 5*ldb] + -1.866077916035022*b[i + 40*ldb] + 0.3222878728081187*b[i + 66*ldb] + -0.5598111202653958*b[i + 90*ldb] + 6.548045607936744*b[i + 116*ldb] + -1.866077916035022*b[i + 130*ldb]);
        c[i + 81*ldc] += (-0.5598111202653958*b[i + 6*ldb] + -1.866077916035022*b[i + 41*ldb] + -0.5598111202653958*b[i + 66*ldb] + -0.5598111202653958*b[i + 91*ldb] + -1.866077916035022*b[i + 116*ldb] + -1.866077916035022*b[i + 131*ldb]);
        c[i + 82*ldc] += (-0.5598111202653958*b[i + 7*ldb] + -1.866077916035022*b[i + 42*ldb] + 0.9374999999999998*b[i + 66*ldb] + -0.5598111202653958*b[i + 92*ldb] + 0.9374999999999998*b[i + 116*ldb] + -1.866077916035022*b[i + 132*ldb]);
        c[i + 83*ldc] += (-0.5598111202653958*b[i + 8*ldb] + -1.866077916035022*b[i + 43*ldb] + -1.866077916035022*b[i + 66*ldb] + -0.5598111202653958*b[i + 93*ldb] + -0.5598111202653958*b[i + 116*ldb] + -1.866077916035022*b[i + 133*ldb]);
        c[i + 84*ldc] += (-0.5598111202653958*b[i + 9*ldb] + -1.866077916035022*b[i + 44*ldb] + 6.548045607936744*b[i + 66*ldb] + -0.5598111202653958*b[i + 94*ldb] + 0.3222878728081187*b[i + 116*ldb] + -1.866077916035022*b[i + 134*ldb]);
        c[i + 85*ldc] += (-0.5598111202653958*b[i + 10*ldb] + 0.9374999999999998*b[i + 40*ldb] + 0.3222878728081187*b[i + 67*ldb] + 0.9374999999999998*b[i + 90*ldb] + 6.548045607936744*b[i + 117*ldb] + -1.866077916035022*b[i + 135*ldb]);
        c[i + 86*ldc] += (-0.5598111202653958*b[i + 11*ldb] + 0.9374999999999998*b[i + 41*ldb] + -0.5598111202653958*b[i + 67*ldb] + 0.9374999999999998*b[i + 91*ldb] + -1.866077916035022*b[i + 117*ldb] + -1.866077916035022*b[i + 136*ldb]);
        c[i + 87*ldc] += (-0.5598111202653958*b[i + 12*ldb] + 0.9374999999999998*b[i + 42*ldb] + 0.9374999999999998*b[i + 67*ldb] + 0.9374999999999998*b[i + 92*ldb] + 0.9374999999999998*b[i + 117*ldb] + -1.866077916035022*b[i + 137*ldb]);
        c[i + 88*ldc] += (-0.5598111202653958*b[i + 13*ldb] + 0.9374999999999998*b[i + 43*ldb] + -1.866077916035022*b[i + 67*ldb] + 0.9374999999999998*b[i + 93*ldb] + -0.5598111202653958*b[i + 117*ldb] + -1.866077916035022*b[i + 138*ldb]);
        c[i + 89*ldc] += (-0.5598111202653958*b[i + 14*ldb] + 0.9374999999999998*b[i + 44*ldb] + 6.548045607936744*b[i + 67*ldb] + 0.9374999999999998*b[i + 94*ldb] + 0.3222878728081187*b[i + 117*ldb] + -1.866077916035022*b[i + 139*ldb]);
        c[i + 90*ldc] += (-0.5598111202653958*b[i + 15*ldb] + -0.5598111202653958*b[i + 40*ldb] + 0.3222878728081187*b[i + 68*ldb] + -1.866077916035022*b[i + 90*ldb] + 6.548045607936744*b[i + 118*ldb] + -1.866077916035022*b[i + 140*ldb]);
        c[i + 91*ldc] += (-0.5598111202653958*b[i + 16*ldb] + -0.5598111202653958*b[i + 41*ldb] + -0.5598111202653958*b[i + 68*ldb] + -1.866077916035022*b[i + 91*ldb] + -1.866077916035022*b[i + 118*ldb] + -1.866077916035022*b[i + 141*ldb]);
        c[i + 92*ldc] += (-0.5598111202653958*b[i + 17*ldb] + -0.5598111202653958*b[i + 42*ldb] + 0.9374999999999998*b[i + 68*ldb] + -1.866077916035022*b[i + 92*ldb] + 0.9374999999999998*b[i + 118*ldb] + -1.866077916035022*b[i + 142*ldb]);
        c[i + 93*ldc] += (-0.5598111202653958*b[i + 18*ldb] + -0.5598111202653958*b[i + 43*ldb] + -1.866077916035022*b[i + 68*ldb] + -1.866077916035022*b[i + 93*ldb] + -0.5598111202653958*b[i + 118*ldb] + -1.866077916035022*b[i + 143*ldb]);
        c[i + 94*ldc] += (-0.5598111202653958*b[i + 19*ldb] + -0.5598111202653958*b[i + 44*ldb] + 6.548045607936744*b[i + 68*ldb] + -1.866077916035022*b[i + 94*ldb] + 0.3222878728081187*b[i + 118*ldb] + -1.866077916035022*b[i + 144*ldb]);
        c[i + 95*ldc] += (-0.5598111202653958*b[i + 20*ldb] + 0.3222878728081187*b[i + 40*ldb] + 0.3222878728081187*b[i + 69*ldb] + 6.548045607936744*b[i + 90*ldb] + 6.548045607936744*b[i + 119*ldb] + -1.866077916035022*b[i + 145*ldb]);
        c[i + 96*ldc] += (-0.5598111202653958*b[i + 21*ldb] + 0.3222878728081187*b[i + 41*ldb] + -0.5598111202653958*b[i + 69*ldb] + 6.548045607936744*b[i + 91*ldb] + -1.866077916035022*b[i + 119*ldb] + -1.866077916035022*b[i + 146*ldb]);
        c[i + 97*ldc] += (-0.5598111202653958*b[i + 22*ldb] + 0.3222878728081187*b[i + 42*ldb] + 0.9374999999999998*b[i + 69*ldb] + 6.548045607936744*b[i + 92*ldb] + 0.9374999999999998*b[i + 119*ldb] + -1.866077916035022*b[i + 147*ldb]);
        c[i + 98*ldc] += (-0.5598111202653958*b[i + 23*ldb] + 0.3222878728081187*b[i + 43*ldb] + -1.866077916035022*b[i + 69*ldb] + 6.548045607936744*b[i + 93*ldb] + -0.5598111202653958*b[i + 119*ldb] + -1.866077916035022*b[i + 148*ldb]);
        c[i + 99*ldc] += (-0.5598111202653958*b[i + 24*ldb] + 0.3222878728081187*b[i + 44*ldb] + 6.548045607936744*b[i + 69*ldb] + 6.548045607936744*b[i + 94*ldb] + 0.3222878728081187*b[i + 119*ldb] + -1.866077916035022*b[i + 149*ldb]);
        c[i + 100*ldc] += (0.3222878728081187*b[i + 0*ldb] + 6.548045607936744*b[i + 45*ldb] + 0.3222878728081187*b[i + 70*ldb] + 0.3222878728081187*b[i + 95*ldb] + 6.548045607936744*b[i + 120*ldb] + 6.548045607936744*b[i + 125*ldb]);
        c[i + 101*ldc] += (0.3222878728081187*b[i + 1*ldb] + 6.548045607936744*b[i + 46*ldb] + -0.5598111202653958*b[i + 70*ldb] + 0.3222878728081187*b[i + 96*ldb] + -1.866077916035022*b[i + 120*ldb] + 6.548045607936744*b[i + 126*ldb]);
        c[i + 102*ldc] += (0.3222878728081187*b[i + 2*ldb] + 6.548045607936744*b[i + 47*ldb] + 0.9374999999999998*b[i + 70*ldb] + 0.3222878728081187*b[i + 97*ldb] + 0.9374999999999998*b[i + 120*ldb] + 6.548045607936744*b[i + 127*ldb]);
        c[i + 103*ldc] += (0.3222878728081187*b[i + 3*ldb] + 6.548045607936744*b[i + 48*ldb] + -1.866077916035022*b[i + 70*ldb] + 0.3222878728081187*b[i + 98*ldb] + -0.5598111202653958*b[i + 120*ldb] + 6.548045607936744*b[i + 128*ldb]);
        c[i + 104*ldc] += (0.3222878728081187*b[i + 4*ldb] + 6.548045607936744*b[i + 49*ldb] + 6.548045607936744*b[i + 70*ldb] + 0.3222878728081187*b[i + 99*ldb] + 0.3222878728081187*b[i + 120*ldb] + 6.548045607936744*b[i + 129*ldb]);
        c[i + 105*ldc] += (0.3222878728081187*b[i + 5*ldb] + -1.866077916035022*b[i + 45*ldb] + 0.3222878728081187*b[i + 71*ldb] + -0.5598111202653958*b[i + 95*ldb] + 6.548045607936744*b[i + 121*ldb] + 6.548045607936744*b[i + 130*ldb]);
        c[i + 106*ldc] += (0.3222878728081187*b[i + 6*ldb] + -1.866077916035022*b[i + 46*ldb] + -0.5598111202653958*b[i + 71*ldb] + -0.5598111202653958*b[i + 96*ldb] + -1.866077916035022*b[i + 121*ldb] + 6.548045607936744*b[i + 131*ldb]);
        c[i + 107*ldc] += (0.3222878728081187*b[i + 7*ldb] + -1.866077916035022*b[i + 47*ldb] + 0.9374999999999998*b[i + 71*ldb] + -0.5598111202653958*b[i + 97*ldb] + 0.9374999999999998*b[i + 121*ldb] + 6.548045607936744*b[i + 132*ldb]);
        c[i + 108*ldc] += (0.3222878728081187*b[i + 8*ldb] + -1.866077916035022*b[i + 48*ldb] + -1.866077916035022*b[i + 71*ldb] + -0.5598111202653958*b[i + 98*ldb] + -0.5598111202653958*b[i + 121*ldb] + 6.548045607936744*b[i + 133*ldb]);
        c[i + 109*ldc] += (0.3222878728081187*b[i + 9*ldb] + -1.866077916035022*b[i + 49*ldb] + 6.548045607936744*b[i + 71*ldb] + -0.5598111202653958*b[i + 99*ldb] + 0.3222878728081187*b[i + 121*ldb] + 6.548045607936744*b[i + 134*ldb]);
        c[i + 110*ldc] += (0.3222878728081187*b[i + 10*ldb] + 0.9374999999999998*b[i + 45*ldb] + 0.3222878728081187*b[i + 72*ldb] + 0.9374999999999998*b[i + 95*ldb] + 6.548045607936744*b[i + 122*ldb] + 6.548045607936744*b[i + 135*ldb]);
        c[i + 111*ldc] += (0.3222878728081187*b[i + 11*ldb] + 0.9374999999999998*b[i + 46*ldb] + -0.5598111202653958*b[i + 72*ldb] + 0.9374999999999998*b[i + 96*ldb] + -1.866077916035022*b[i + 122*ldb] + 6.548045607936744*b[i + 136*ldb]);
        c[i + 112*ldc] += (0.3222878728081187*b[i + 12*ldb] + 0.9374999999999998*b[i + 47*ldb] + 0.9374999999999998*b[i + 72*ldb] + 0.9374999999999998*b[i + 97*ldb] + 0.9374999999999998*b[i + 122*ldb] + 6.548045607936744*b[i + 137*ldb]);
        c[i + 113*ldc] += (0.3222878728081187*b[i + 13*ldb] + 0.9374999999999998*b[i + 48*ldb] + -1.866077916035022*b[i + 72*ldb] + 0.9374999999999998*b[i + 98*ldb] + -0.5598111202653958*b[i + 122*ldb] + 6.548045607936744*b[i + 138*ldb]);
        c[i + 114*ldc] += (0.3222878728081187*b[i + 14*ldb] + 0.9374999999999998*b[i + 49*ldb] + 6.548045607936744*b[i + 72*ldb] + 0.9374999999999998*b[i + 99*ldb] + 0.3222878728081187*b[i + 122*ldb] + 6.548045607936744*b[i + 139*ldb]);
        c[i + 115*ldc] += (0.3222878728081187*b[i + 15*ldb] + -0.5598111202653958*b[i + 45*ldb] + 0.3222878728081187*b[i + 73*ldb] + -1.866077916035022*b[i + 95*ldb] + 6.548045607936744*b[i + 123*ldb] + 6.548045607936744*b[i + 140*ldb]);
        c[i + 116*ldc] += (0.3222878728081187*b[i + 16*ldb] + -0.5598111202653958*b[i + 46*ldb] + -0.5598111202653958*b[i + 73*ldb] + -1.866077916035022*b[i + 96*ldb] + -1.866077916035022*b[i + 123*ldb] + 6.548045607936744*b[i + 141*ldb]);
        c[i + 117*ldc] += (0.3222878728081187*b[i + 17*ldb] + -0.5598111202653958*b[i + 47*ldb] + 0.9374999999999998*b[i + 73*ldb] + -1.866077916035022*b[i + 97*ldb] + 0.9374999999999998*b[i + 123*ldb] + 6.548045607936744*b[i + 142*ldb]);
        c[i + 118*ldc] += (0.3222878728081187*b[i + 18*ldb] + -0.5598111202653958*b[i + 48*ldb] + -1.866077916035022*b[i + 73*ldb] + -1.866077916035022*b[i + 98*ldb] + -0.5598111202653958*b[i + 123*ldb] + 6.548045607936744*b[i + 143*ldb]);
        c[i + 119*ldc] += (0.3222878728081187*b[i + 19*ldb] + -0.5598111202653958*b[i + 49*ldb] + 6.548045607936744*b[i + 73*ldb] + -1.866077916035022*b[i + 99*ldb] + 0.3222878728081187*b[i + 123*ldb] + 6.548045607936744*b[i + 144*ldb]);
        c[i + 120*ldc] += (0.3222878728081187*b[i + 20*ldb] + 0.3222878728081187*b[i + 45*ldb] + 0.3222878728081187*b[i + 74*ldb] + 6.548045607936744*b[i + 95*ldb] + 6.548045607936744*b[i + 124*ldb] + 6.548045607936744*b[i + 145*ldb]);
        c[i + 121*ldc] += (0.3222878728081187*b[i + 21*ldb] + 0.3222878728081187*b[i + 46*ldb] + -0.5598111202653958*b[i + 74*ldb] + 6.548045607936744*b[i + 96*ldb] + -1.866077916035022*b[i + 124*ldb] + 6.548045607936744*b[i + 146*ldb]);
        c[i + 122*ldc] += (0.3222878728081187*b[i + 22*ldb] + 0.3222878728081187*b[i + 47*ldb] + 0.9374999999999998*b[i + 74*ldb] + 6.548045607936744*b[i + 97*ldb] + 0.9374999999999998*b[i + 124*ldb] + 6.548045607936744*b[i + 147*ldb]);
        c[i + 123*ldc] += (0.3222878728081187*b[i + 23*ldb] + 0.3222878728081187*b[i + 48*ldb] + -1.866077916035022*b[i + 74*ldb] + 6.548045607936744*b[i + 98*ldb] + -0.5598111202653958*b[i + 124*ldb] + 6.548045607936744*b[i + 148*ldb]);
        c[i + 124*ldc] += (0.3222878728081187*b[i + 24*ldb] + 0.3222878728081187*b[i + 49*ldb] + 6.548045607936744*b[i + 74*ldb] + 6.548045607936744*b[i + 99*ldb] + 0.3222878728081187*b[i + 124*ldb] + 6.548045607936744*b[i + 149*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_hex_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (0.3222878728081187*b[i + 50*ldb] + -6.548045607936744*b[i + 100*ldb]);
        c[i + 1*ldc] += (-0.5598111202653958*b[i + 50*ldb] + 1.866077916035022*b[i + 100*ldb]);
        c[i + 2*ldc] += (0.9374999999999998*b[i + 50*ldb] + -0.9374999999999998*b[i + 100*ldb]);
        c[i + 3*ldc] += (-1.866077916035022*b[i + 50*ldb] + 0.5598111202653958*b[i + 100*ldb]);
        c[i + 4*ldc] += (6.548045607936744*b[i + 50*ldb] + -0.3222878728081187*b[i + 100*ldb]);
        c[i + 5*ldc] += (0.3222878728081187*b[i + 51*ldb] + -6.548045607936744*b[i + 101*ldb]);
        c[i + 6*ldc] += (-0.5598111202653958*b[i + 51*ldb] + 1.866077916035022*b[i + 101*ldb]);
        c[i + 7*ldc] += (0.9374999999999998*b[i + 51*ldb] + -0.9374999999999998*b[i + 101*ldb]);
        c[i + 8*ldc] += (-1.866077916035022*b[i + 51*ldb] + 0.5598111202653958*b[i + 101*ldb]);
        c[i + 9*ldc] += (6.548045607936744*b[i + 51*ldb] + -0.3222878728081187*b[i + 101*ldb]);
        c[i + 10*ldc] += (0.3222878728081187*b[i + 52*ldb] + -6.548045607936744*b[i + 102*ldb]);
        c[i + 11*ldc] += (-0.5598111202653958*b[i + 52*ldb] + 1.866077916035022*b[i + 102*ldb]);
        c[i + 12*ldc] += (0.9374999999999998*b[i + 52*ldb] + -0.9374999999999998*b[i + 102*ldb]);
        c[i + 13*ldc] += (-1.866077916035022*b[i + 52*ldb] + 0.5598111202653958*b[i + 102*ldb]);
        c[i + 14*ldc] += (6.548045607936744*b[i + 52*ldb] + -0.3222878728081187*b[i + 102*ldb]);
        c[i + 15*ldc] += (0.3222878728081187*b[i + 53*ldb] + -6.548045607936744*b[i + 103*ldb]);
        c[i + 16*ldc] += (-0.5598111202653958*b[i + 53*ldb] + 1.866077916035022*b[i + 103*ldb]);
        c[i + 17*ldc] += (0.9374999999999998*b[i + 53*ldb] + -0.9374999999999998*b[i + 103*ldb]);
        c[i + 18*ldc] += (-1.866077916035022*b[i + 53*ldb] + 0.5598111202653958*b[i + 103*ldb]);
        c[i + 19*ldc] += (6.548045607936744*b[i + 53*ldb] + -0.3222878728081187*b[i + 103*ldb]);
        c[i + 20*ldc] += (0.3222878728081187*b[i + 54*ldb] + -6.548045607936744*b[i + 104*ldb]);
        c[i + 21*ldc] += (-0.5598111202653958*b[i + 54*ldb] + 1.866077916035022*b[i + 104*ldb]);
        c[i + 22*ldc] += (0.9374999999999998*b[i + 54*ldb] + -0.9374999999999998*b[i + 104*ldb]);
        c[i + 23*ldc] += (-1.866077916035022*b[i + 54*ldb] + 0.5598111202653958*b[i + 104*ldb]);
        c[i + 24*ldc] += (6.548045607936744*b[i + 54*ldb] + -0.3222878728081187*b[i + 104*ldb]);
        c[i + 25*ldc] += (0.3222878728081187*b[i + 55*ldb] + -6.548045607936744*b[i + 105*ldb]);
        c[i + 26*ldc] += (-0.5598111202653958*b[i + 55*ldb] + 1.866077916035022*b[i + 105*ldb]);
        c[i + 27*ldc] += (0.9374999999999998*b[i + 55*ldb] + -0.9374999999999998*b[i + 105*ldb]);
        c[i + 28*ldc] += (-1.866077916035022*b[i + 55*ldb] + 0.5598111202653958*b[i + 105*ldb]);
        c[i + 29*ldc] += (6.548045607936744*b[i + 55*ldb] + -0.3222878728081187*b[i + 105*ldb]);
        c[i + 30*ldc] += (0.3222878728081187*b[i + 56*ldb] + -6.548045607936744*b[i + 106*ldb]);
        c[i + 31*ldc] += (-0.5598111202653958*b[i + 56*ldb] + 1.866077916035022*b[i + 106*ldb]);
        c[i + 32*ldc] += (0.9374999999999998*b[i + 56*ldb] + -0.9374999999999998*b[i + 106*ldb]);
        c[i + 33*ldc] += (-1.866077916035022*b[i + 56*ldb] + 0.5598111202653958*b[i + 106*ldb]);
        c[i + 34*ldc] += (6.548045607936744*b[i + 56*ldb] + -0.3222878728081187*b[i + 106*ldb]);
        c[i + 35*ldc] += (0.3222878728081187*b[i + 57*ldb] + -6.548045607936744*b[i + 107*ldb]);
        c[i + 36*ldc] += (-0.5598111202653958*b[i + 57*ldb] + 1.866077916035022*b[i + 107*ldb]);
        c[i + 37*ldc] += (0.9374999999999998*b[i + 57*ldb] + -0.9374999999999998*b[i + 107*ldb]);
        c[i + 38*ldc] += (-1.866077916035022*b[i + 57*ldb] + 0.5598111202653958*b[i + 107*ldb]);
        c[i + 39*ldc] += (6.548045607936744*b[i + 57*ldb] + -0.3222878728081187*b[i + 107*ldb]);
        c[i + 40*ldc] += (0.3222878728081187*b[i + 58*ldb] + -6.548045607936744*b[i + 108*ldb]);
        c[i + 41*ldc] += (-0.5598111202653958*b[i + 58*ldb] + 1.866077916035022*b[i + 108*ldb]);
        c[i + 42*ldc] += (0.9374999999999998*b[i + 58*ldb] + -0.9374999999999998*b[i + 108*ldb]);
        c[i + 43*ldc] += (-1.866077916035022*b[i + 58*ldb] + 0.5598111202653958*b[i + 108*ldb]);
        c[i + 44*ldc] += (6.548045607936744*b[i + 58*ldb] + -0.3222878728081187*b[i + 108*ldb]);
        c[i + 45*ldc] += (0.3222878728081187*b[i + 59*ldb] + -6.548045607936744*b[i + 109*ldb]);
        c[i + 46*ldc] += (-0.5598111202653958*b[i + 59*ldb] + 1.866077916035022*b[i + 109*ldb]);
        c[i + 47*ldc] += (0.9374999999999998*b[i + 59*ldb] + -0.9374999999999998*b[i + 109*ldb]);
        c[i + 48*ldc] += (-1.866077916035022*b[i + 59*ldb] + 0.5598111202653958*b[i + 109*ldb]);
        c[i + 49*ldc] += (6.548045607936744*b[i + 59*ldb] + -0.3222878728081187*b[i + 109*ldb]);
        c[i + 50*ldc] += (0.3222878728081187*b[i + 60*ldb] + -6.548045607936744*b[i + 110*ldb]);
        c[i + 51*ldc] += (-0.5598111202653958*b[i + 60*ldb] + 1.866077916035022*b[i + 110*ldb]);
        c[i + 52*ldc] += (0.9374999999999998*b[i + 60*ldb] + -0.9374999999999998*b[i + 110*ldb]);
        c[i + 53*ldc] += (-1.866077916035022*b[i + 60*ldb] + 0.5598111202653958*b[i + 110*ldb]);
        c[i + 54*ldc] += (6.548045607936744*b[i + 60*ldb] + -0.3222878728081187*b[i + 110*ldb]);
        c[i + 55*ldc] += (0.3222878728081187*b[i + 61*ldb] + -6.548045607936744*b[i + 111*ldb]);
        c[i + 56*ldc] += (-0.5598111202653958*b[i + 61*ldb] + 1.866077916035022*b[i + 111*ldb]);
        c[i + 57*ldc] += (0.9374999999999998*b[i + 61*ldb] + -0.9374999999999998*b[i + 111*ldb]);
        c[i + 58*ldc] += (-1.866077916035022*b[i + 61*ldb] + 0.5598111202653958*b[i + 111*ldb]);
        c[i + 59*ldc] += (6.548045607936744*b[i + 61*ldb] + -0.3222878728081187*b[i + 111*ldb]);
        c[i + 60*ldc] += (0.3222878728081187*b[i + 62*ldb] + -6.548045607936744*b[i + 112*ldb]);
        c[i + 61*ldc] += (-0.5598111202653958*b[i + 62*ldb] + 1.866077916035022*b[i + 112*ldb]);
        c[i + 62*ldc] += (0.9374999999999998*b[i + 62*ldb] + -0.9374999999999998*b[i + 112*ldb]);
        c[i + 63*ldc] += (-1.866077916035022*b[i + 62*ldb] + 0.5598111202653958*b[i + 112*ldb]);
        c[i + 64*ldc] += (6.548045607936744*b[i + 62*ldb] + -0.3222878728081187*b[i + 112*ldb]);
        c[i + 65*ldc] += (0.3222878728081187*b[i + 63*ldb] + -6.548045607936744*b[i + 113*ldb]);
        c[i + 66*ldc] += (-0.5598111202653958*b[i + 63*ldb] + 1.866077916035022*b[i + 113*ldb]);
        c[i + 67*ldc] += (0.9374999999999998*b[i + 63*ldb] + -0.9374999999999998*b[i + 113*ldb]);
        c[i + 68*ldc] += (-1.866077916035022*b[i + 63*ldb] + 0.5598111202653958*b[i + 113*ldb]);
        c[i + 69*ldc] += (6.548045607936744*b[i + 63*ldb] + -0.3222878728081187*b[i + 113*ldb]);
        c[i + 70*ldc] += (0.3222878728081187*b[i + 64*ldb] + -6.548045607936744*b[i + 114*ldb]);
        c[i + 71*ldc] += (-0.5598111202653958*b[i + 64*ldb] + 1.866077916035022*b[i + 114*ldb]);
        c[i + 72*ldc] += (0.9374999999999998*b[i + 64*ldb] + -0.9374999999999998*b[i + 114*ldb]);
        c[i + 73*ldc] += (-1.866077916035022*b[i + 64*ldb] + 0.5598111202653958*b[i + 114*ldb]);
        c[i + 74*ldc] += (6.548045607936744*b[i + 64*ldb] + -0.3222878728081187*b[i + 114*ldb]);
        c[i + 75*ldc] += (0.3222878728081187*b[i + 65*ldb] + -6.548045607936744*b[i + 115*ldb]);
        c[i + 76*ldc] += (-0.5598111202653958*b[i + 65*ldb] + 1.866077916035022*b[i + 115*ldb]);
        c[i + 77*ldc] += (0.9374999999999998*b[i + 65*ldb] + -0.9374999999999998*b[i + 115*ldb]);
        c[i + 78*ldc] += (-1.866077916035022*b[i + 65*ldb] + 0.5598111202653958*b[i + 115*ldb]);
        c[i + 79*ldc] += (6.548045607936744*b[i + 65*ldb] + -0.3222878728081187*b[i + 115*ldb]);
        c[i + 80*ldc] += (0.3222878728081187*b[i + 66*ldb] + -6.548045607936744*b[i + 116*ldb]);
        c[i + 81*ldc] += (-0.5598111202653958*b[i + 66*ldb] + 1.866077916035022*b[i + 116*ldb]);
        c[i + 82*ldc] += (0.9374999999999998*b[i + 66*ldb] + -0.9374999999999998*b[i + 116*ldb]);
        c[i + 83*ldc] += (-1.866077916035022*b[i + 66*ldb] + 0.5598111202653958*b[i + 116*ldb]);
        c[i + 84*ldc] += (6.548045607936744*b[i + 66*ldb] + -0.3222878728081187*b[i + 116*ldb]);
        c[i + 85*ldc] += (0.3222878728081187*b[i + 67*ldb] + -6.548045607936744*b[i + 117*ldb]);
        c[i + 86*ldc] += (-0.5598111202653958*b[i + 67*ldb] + 1.866077916035022*b[i + 117*ldb]);
        c[i + 87*ldc] += (0.9374999999999998*b[i + 67*ldb] + -0.9374999999999998*b[i + 117*ldb]);
        c[i + 88*ldc] += (-1.866077916035022*b[i + 67*ldb] + 0.5598111202653958*b[i + 117*ldb]);
        c[i + 89*ldc] += (6.548045607936744*b[i + 67*ldb] + -0.3222878728081187*b[i + 117*ldb]);
        c[i + 90*ldc] += (0.3222878728081187*b[i + 68*ldb] + -6.548045607936744*b[i + 118*ldb]);
        c[i + 91*ldc] += (-0.5598111202653958*b[i + 68*ldb] + 1.866077916035022*b[i + 118*ldb]);
        c[i + 92*ldc] += (0.9374999999999998*b[i + 68*ldb] + -0.9374999999999998*b[i + 118*ldb]);
        c[i + 93*ldc] += (-1.866077916035022*b[i + 68*ldb] + 0.5598111202653958*b[i + 118*ldb]);
        c[i + 94*ldc] += (6.548045607936744*b[i + 68*ldb] + -0.3222878728081187*b[i + 118*ldb]);
        c[i + 95*ldc] += (0.3222878728081187*b[i + 69*ldb] + -6.548045607936744*b[i + 119*ldb]);
        c[i + 96*ldc] += (-0.5598111202653958*b[i + 69*ldb] + 1.866077916035022*b[i + 119*ldb]);
        c[i + 97*ldc] += (0.9374999999999998*b[i + 69*ldb] + -0.9374999999999998*b[i + 119*ldb]);
        c[i + 98*ldc] += (-1.866077916035022*b[i + 69*ldb] + 0.5598111202653958*b[i + 119*ldb]);
        c[i + 99*ldc] += (6.548045607936744*b[i + 69*ldb] + -0.3222878728081187*b[i + 119*ldb]);
        c[i + 100*ldc] += (0.3222878728081187*b[i + 70*ldb] + -6.548045607936744*b[i + 120*ldb]);
        c[i + 101*ldc] += (-0.5598111202653958*b[i + 70*ldb] + 1.866077916035022*b[i + 120*ldb]);
        c[i + 102*ldc] += (0.9374999999999998*b[i + 70*ldb] + -0.9374999999999998*b[i + 120*ldb]);
        c[i + 103*ldc] += (-1.866077916035022*b[i + 70*ldb] + 0.5598111202653958*b[i + 120*ldb]);
        c[i + 104*ldc] += (6.548045607936744*b[i + 70*ldb] + -0.3222878728081187*b[i + 120*ldb]);
        c[i + 105*ldc] += (0.3222878728081187*b[i + 71*ldb] + -6.548045607936744*b[i + 121*ldb]);
        c[i + 106*ldc] += (-0.5598111202653958*b[i + 71*ldb] + 1.866077916035022*b[i + 121*ldb]);
        c[i + 107*ldc] += (0.9374999999999998*b[i + 71*ldb] + -0.9374999999999998*b[i + 121*ldb]);
        c[i + 108*ldc] += (-1.866077916035022*b[i + 71*ldb] + 0.5598111202653958*b[i + 121*ldb]);
        c[i + 109*ldc] += (6.548045607936744*b[i + 71*ldb] + -0.3222878728081187*b[i + 121*ldb]);
        c[i + 110*ldc] += (0.3222878728081187*b[i + 72*ldb] + -6.548045607936744*b[i + 122*ldb]);
        c[i + 111*ldc] += (-0.5598111202653958*b[i + 72*ldb] + 1.866077916035022*b[i + 122*ldb]);
        c[i + 112*ldc] += (0.9374999999999998*b[i + 72*ldb] + -0.9374999999999998*b[i + 122*ldb]);
        c[i + 113*ldc] += (-1.866077916035022*b[i + 72*ldb] + 0.5598111202653958*b[i + 122*ldb]);
        c[i + 114*ldc] += (6.548045607936744*b[i + 72*ldb] + -0.3222878728081187*b[i + 122*ldb]);
        c[i + 115*ldc] += (0.3222878728081187*b[i + 73*ldb] + -6.548045607936744*b[i + 123*ldb]);
        c[i + 116*ldc] += (-0.5598111202653958*b[i + 73*ldb] + 1.866077916035022*b[i + 123*ldb]);
        c[i + 117*ldc] += (0.9374999999999998*b[i + 73*ldb] + -0.9374999999999998*b[i + 123*ldb]);
        c[i + 118*ldc] += (-1.866077916035022*b[i + 73*ldb] + 0.5598111202653958*b[i + 123*ldb]);
        c[i + 119*ldc] += (6.548045607936744*b[i + 73*ldb] + -0.3222878728081187*b[i + 123*ldb]);
        c[i + 120*ldc] += (0.3222878728081187*b[i + 74*ldb] + -6.548045607936744*b[i + 124*ldb]);
        c[i + 121*ldc] += (-0.5598111202653958*b[i + 74*ldb] + 1.866077916035022*b[i + 124*ldb]);
        c[i + 122*ldc] += (0.9374999999999998*b[i + 74*ldb] + -0.9374999999999998*b[i + 124*ldb]);
        c[i + 123*ldc] += (-1.866077916035022*b[i + 74*ldb] + 0.5598111202653958*b[i + 124*ldb]);
        c[i + 124*ldc] += (6.548045607936744*b[i + 74*ldb] + -0.3222878728081187*b[i + 124*ldb]);
        c[i + 125*ldc] += (-6.548045607936744*b[i + 25*ldb] + 0.3222878728081187*b[i + 75*ldb]);
        c[i + 126*ldc] += (-6.548045607936744*b[i + 26*ldb] + 0.3222878728081187*b[i + 76*ldb]);
        c[i + 127*ldc] += (-6.548045607936744*b[i + 27*ldb] + 0.3222878728081187*b[i + 77*ldb]);
        c[i + 128*ldc] += (-6.548045607936744*b[i + 28*ldb] + 0.3222878728081187*b[i + 78*ldb]);
        c[i + 129*ldc] += (-6.548045607936744*b[i + 29*ldb] + 0.3222878728081187*b[i + 79*ldb]);
        c[i + 130*ldc] += (1.866077916035022*b[i + 25*ldb] + -0.5598111202653958*b[i + 75*ldb]);
        c[i + 131*ldc] += (1.866077916035022*b[i + 26*ldb] + -0.5598111202653958*b[i + 76*ldb]);
        c[i + 132*ldc] += (1.866077916035022*b[i + 27*ldb] + -0.5598111202653958*b[i + 77*ldb]);
        c[i + 133*ldc] += (1.866077916035022*b[i + 28*ldb] + -0.5598111202653958*b[i + 78*ldb]);
        c[i + 134*ldc] += (1.866077916035022*b[i + 29*ldb] + -0.5598111202653958*b[i + 79*ldb]);
        c[i + 135*ldc] += (-0.9374999999999998*b[i + 25*ldb] + 0.9374999999999998*b[i + 75*ldb]);
        c[i + 136*ldc] += (-0.9374999999999998*b[i + 26*ldb] + 0.9374999999999998*b[i + 76*ldb]);
        c[i + 137*ldc] += (-0.9374999999999998*b[i + 27*ldb] + 0.9374999999999998*b[i + 77*ldb]);
        c[i + 138*ldc] += (-0.9374999999999998*b[i + 28*ldb] + 0.9374999999999998*b[i + 78*ldb]);
        c[i + 139*ldc] += (-0.9374999999999998*b[i + 29*ldb] + 0.9374999999999998*b[i + 79*ldb]);
        c[i + 140*ldc] += (0.5598111202653958*b[i + 25*ldb] + -1.866077916035022*b[i + 75*ldb]);
        c[i + 141*ldc] += (0.5598111202653958*b[i + 26*ldb] + -1.866077916035022*b[i + 76*ldb]);
        c[i + 142*ldc] += (0.5598111202653958*b[i + 27*ldb] + -1.866077916035022*b[i + 77*ldb]);
        c[i + 143*ldc] += (0.5598111202653958*b[i + 28*ldb] + -1.866077916035022*b[i + 78*ldb]);
        c[i + 144*ldc] += (0.5598111202653958*b[i + 29*ldb] + -1.866077916035022*b[i + 79*ldb]);
        c[i + 145*ldc] += (-0.3222878728081187*b[i + 25*ldb] + 6.548045607936744*b[i + 75*ldb]);
        c[i + 146*ldc] += (-0.3222878728081187*b[i + 26*ldb] + 6.548045607936744*b[i + 76*ldb]);
        c[i + 147*ldc] += (-0.3222878728081187*b[i + 27*ldb] + 6.548045607936744*b[i + 77*ldb]);
        c[i + 148*ldc] += (-0.3222878728081187*b[i + 28*ldb] + 6.548045607936744*b[i + 78*ldb]);
        c[i + 149*ldc] += (-0.3222878728081187*b[i + 29*ldb] + 6.548045607936744*b[i + 79*ldb]);
        c[i + 150*ldc] += (-6.548045607936744*b[i + 30*ldb] + 0.3222878728081187*b[i + 80*ldb]);
        c[i + 151*ldc] += (-6.548045607936744*b[i + 31*ldb] + 0.3222878728081187*b[i + 81*ldb]);
        c[i + 152*ldc] += (-6.548045607936744*b[i + 32*ldb] + 0.3222878728081187*b[i + 82*ldb]);
        c[i + 153*ldc] += (-6.548045607936744*b[i + 33*ldb] + 0.3222878728081187*b[i + 83*ldb]);
        c[i + 154*ldc] += (-6.548045607936744*b[i + 34*ldb] + 0.3222878728081187*b[i + 84*ldb]);
        c[i + 155*ldc] += (1.866077916035022*b[i + 30*ldb] + -0.5598111202653958*b[i + 80*ldb]);
        c[i + 156*ldc] += (1.866077916035022*b[i + 31*ldb] + -0.5598111202653958*b[i + 81*ldb]);
        c[i + 157*ldc] += (1.866077916035022*b[i + 32*ldb] + -0.5598111202653958*b[i + 82*ldb]);
        c[i + 158*ldc] += (1.866077916035022*b[i + 33*ldb] + -0.5598111202653958*b[i + 83*ldb]);
        c[i + 159*ldc] += (1.866077916035022*b[i + 34*ldb] + -0.5598111202653958*b[i + 84*ldb]);
        c[i + 160*ldc] += (-0.9374999999999998*b[i + 30*ldb] + 0.9374999999999998*b[i + 80*ldb]);
        c[i + 161*ldc] += (-0.9374999999999998*b[i + 31*ldb] + 0.9374999999999998*b[i + 81*ldb]);
        c[i + 162*ldc] += (-0.9374999999999998*b[i + 32*ldb] + 0.9374999999999998*b[i + 82*ldb]);
        c[i + 163*ldc] += (-0.9374999999999998*b[i + 33*ldb] + 0.9374999999999998*b[i + 83*ldb]);
        c[i + 164*ldc] += (-0.9374999999999998*b[i + 34*ldb] + 0.9374999999999998*b[i + 84*ldb]);
        c[i + 165*ldc] += (0.5598111202653958*b[i + 30*ldb] + -1.866077916035022*b[i + 80*ldb]);
        c[i + 166*ldc] += (0.5598111202653958*b[i + 31*ldb] + -1.866077916035022*b[i + 81*ldb]);
        c[i + 167*ldc] += (0.5598111202653958*b[i + 32*ldb] + -1.866077916035022*b[i + 82*ldb]);
        c[i + 168*ldc] += (0.5598111202653958*b[i + 33*ldb] + -1.866077916035022*b[i + 83*ldb]);
        c[i + 169*ldc] += (0.5598111202653958*b[i + 34*ldb] + -1.866077916035022*b[i + 84*ldb]);
        c[i + 170*ldc] += (-0.3222878728081187*b[i + 30*ldb] + 6.548045607936744*b[i + 80*ldb]);
        c[i + 171*ldc] += (-0.3222878728081187*b[i + 31*ldb] + 6.548045607936744*b[i + 81*ldb]);
        c[i + 172*ldc] += (-0.3222878728081187*b[i + 32*ldb] + 6.548045607936744*b[i + 82*ldb]);
        c[i + 173*ldc] += (-0.3222878728081187*b[i + 33*ldb] + 6.548045607936744*b[i + 83*ldb]);
        c[i + 174*ldc] += (-0.3222878728081187*b[i + 34*ldb] + 6.548045607936744*b[i + 84*ldb]);
        c[i + 175*ldc] += (-6.548045607936744*b[i + 35*ldb] + 0.3222878728081187*b[i + 85*ldb]);
        c[i + 176*ldc] += (-6.548045607936744*b[i + 36*ldb] + 0.3222878728081187*b[i + 86*ldb]);
        c[i + 177*ldc] += (-6.548045607936744*b[i + 37*ldb] + 0.3222878728081187*b[i + 87*ldb]);
        c[i + 178*ldc] += (-6.548045607936744*b[i + 38*ldb] + 0.3222878728081187*b[i + 88*ldb]);
        c[i + 179*ldc] += (-6.548045607936744*b[i + 39*ldb] + 0.3222878728081187*b[i + 89*ldb]);
        c[i + 180*ldc] += (1.866077916035022*b[i + 35*ldb] + -0.5598111202653958*b[i + 85*ldb]);
        c[i + 181*ldc] += (1.866077916035022*b[i + 36*ldb] + -0.5598111202653958*b[i + 86*ldb]);
        c[i + 182*ldc] += (1.866077916035022*b[i + 37*ldb] + -0.5598111202653958*b[i + 87*ldb]);
        c[i + 183*ldc] += (1.866077916035022*b[i + 38*ldb] + -0.5598111202653958*b[i + 88*ldb]);
        c[i + 184*ldc] += (1.866077916035022*b[i + 39*ldb] + -0.5598111202653958*b[i + 89*ldb]);
        c[i + 185*ldc] += (-0.9374999999999998*b[i + 35*ldb] + 0.9374999999999998*b[i + 85*ldb]);
        c[i + 186*ldc] += (-0.9374999999999998*b[i + 36*ldb] + 0.9374999999999998*b[i + 86*ldb]);
        c[i + 187*ldc] += (-0.9374999999999998*b[i + 37*ldb] + 0.9374999999999998*b[i + 87*ldb]);
        c[i + 188*ldc] += (-0.9374999999999998*b[i + 38*ldb] + 0.9374999999999998*b[i + 88*ldb]);
        c[i + 189*ldc] += (-0.9374999999999998*b[i + 39*ldb] + 0.9374999999999998*b[i + 89*ldb]);
        c[i + 190*ldc] += (0.5598111202653958*b[i + 35*ldb] + -1.866077916035022*b[i + 85*ldb]);
        c[i + 191*ldc] += (0.5598111202653958*b[i + 36*ldb] + -1.866077916035022*b[i + 86*ldb]);
        c[i + 192*ldc] += (0.5598111202653958*b[i + 37*ldb] + -1.866077916035022*b[i + 87*ldb]);
        c[i + 193*ldc] += (0.5598111202653958*b[i + 38*ldb] + -1.866077916035022*b[i + 88*ldb]);
        c[i + 194*ldc] += (0.5598111202653958*b[i + 39*ldb] + -1.866077916035022*b[i + 89*ldb]);
        c[i + 195*ldc] += (-0.3222878728081187*b[i + 35*ldb] + 6.548045607936744*b[i + 85*ldb]);
        c[i + 196*ldc] += (-0.3222878728081187*b[i + 36*ldb] + 6.548045607936744*b[i + 86*ldb]);
        c[i + 197*ldc] += (-0.3222878728081187*b[i + 37*ldb] + 6.548045607936744*b[i + 87*ldb]);
        c[i + 198*ldc] += (-0.3222878728081187*b[i + 38*ldb] + 6.548045607936744*b[i + 88*ldb]);
        c[i + 199*ldc] += (-0.3222878728081187*b[i + 39*ldb] + 6.548045607936744*b[i + 89*ldb]);
        c[i + 200*ldc] += (-6.548045607936744*b[i + 40*ldb] + 0.3222878728081187*b[i + 90*ldb]);
        c[i + 201*ldc] += (-6.548045607936744*b[i + 41*ldb] + 0.3222878728081187*b[i + 91*ldb]);
        c[i + 202*ldc] += (-6.548045607936744*b[i + 42*ldb] + 0.3222878728081187*b[i + 92*ldb]);
        c[i + 203*ldc] += (-6.548045607936744*b[i + 43*ldb] + 0.3222878728081187*b[i + 93*ldb]);
        c[i + 204*ldc] += (-6.548045607936744*b[i + 44*ldb] + 0.3222878728081187*b[i + 94*ldb]);
        c[i + 205*ldc] += (1.866077916035022*b[i + 40*ldb] + -0.5598111202653958*b[i + 90*ldb]);
        c[i + 206*ldc] += (1.866077916035022*b[i + 41*ldb] + -0.5598111202653958*b[i + 91*ldb]);
        c[i + 207*ldc] += (1.866077916035022*b[i + 42*ldb] + -0.5598111202653958*b[i + 92*ldb]);
        c[i + 208*ldc] += (1.866077916035022*b[i + 43*ldb] + -0.5598111202653958*b[i + 93*ldb]);
        c[i + 209*ldc] += (1.866077916035022*b[i + 44*ldb] + -0.5598111202653958*b[i + 94*ldb]);
        c[i + 210*ldc] += (-0.9374999999999998*b[i + 40*ldb] + 0.9374999999999998*b[i + 90*ldb]);
        c[i + 211*ldc] += (-0.9374999999999998*b[i + 41*ldb] + 0.9374999999999998*b[i + 91*ldb]);
        c[i + 212*ldc] += (-0.9374999999999998*b[i + 42*ldb] + 0.9374999999999998*b[i + 92*ldb]);
        c[i + 213*ldc] += (-0.9374999999999998*b[i + 43*ldb] + 0.9374999999999998*b[i + 93*ldb]);
        c[i + 214*ldc] += (-0.9374999999999998*b[i + 44*ldb] + 0.9374999999999998*b[i + 94*ldb]);
        c[i + 215*ldc] += (0.5598111202653958*b[i + 40*ldb] + -1.866077916035022*b[i + 90*ldb]);
        c[i + 216*ldc] += (0.5598111202653958*b[i + 41*ldb] + -1.866077916035022*b[i + 91*ldb]);
        c[i + 217*ldc] += (0.5598111202653958*b[i + 42*ldb] + -1.866077916035022*b[i + 92*ldb]);
        c[i + 218*ldc] += (0.5598111202653958*b[i + 43*ldb] + -1.866077916035022*b[i + 93*ldb]);
        c[i + 219*ldc] += (0.5598111202653958*b[i + 44*ldb] + -1.866077916035022*b[i + 94*ldb]);
        c[i + 220*ldc] += (-0.3222878728081187*b[i + 40*ldb] + 6.548045607936744*b[i + 90*ldb]);
        c[i + 221*ldc] += (-0.3222878728081187*b[i + 41*ldb] + 6.548045607936744*b[i + 91*ldb]);
        c[i + 222*ldc] += (-0.3222878728081187*b[i + 42*ldb] + 6.548045607936744*b[i + 92*ldb]);
        c[i + 223*ldc] += (-0.3222878728081187*b[i + 43*ldb] + 6.548045607936744*b[i + 93*ldb]);
        c[i + 224*ldc] += (-0.3222878728081187*b[i + 44*ldb] + 6.548045607936744*b[i + 94*ldb]);
        c[i + 225*ldc] += (-6.548045607936744*b[i + 45*ldb] + 0.3222878728081187*b[i + 95*ldb]);
        c[i + 226*ldc] += (-6.548045607936744*b[i + 46*ldb] + 0.3222878728081187*b[i + 96*ldb]);
        c[i + 227*ldc] += (-6.548045607936744*b[i + 47*ldb] + 0.3222878728081187*b[i + 97*ldb]);
        c[i + 228*ldc] += (-6.548045607936744*b[i + 48*ldb] + 0.3222878728081187*b[i + 98*ldb]);
        c[i + 229*ldc] += (-6.548045607936744*b[i + 49*ldb] + 0.3222878728081187*b[i + 99*ldb]);
        c[i + 230*ldc] += (1.866077916035022*b[i + 45*ldb] + -0.5598111202653958*b[i + 95*ldb]);
        c[i + 231*ldc] += (1.866077916035022*b[i + 46*ldb] + -0.5598111202653958*b[i + 96*ldb]);
        c[i + 232*ldc] += (1.866077916035022*b[i + 47*ldb] + -0.5598111202653958*b[i + 97*ldb]);
        c[i + 233*ldc] += (1.866077916035022*b[i + 48*ldb] + -0.5598111202653958*b[i + 98*ldb]);
        c[i + 234*ldc] += (1.866077916035022*b[i + 49*ldb] + -0.5598111202653958*b[i + 99*ldb]);
        c[i + 235*ldc] += (-0.9374999999999998*b[i + 45*ldb] + 0.9374999999999998*b[i + 95*ldb]);
        c[i + 236*ldc] += (-0.9374999999999998*b[i + 46*ldb] + 0.9374999999999998*b[i + 96*ldb]);
        c[i + 237*ldc] += (-0.9374999999999998*b[i + 47*ldb] + 0.9374999999999998*b[i + 97*ldb]);
        c[i + 238*ldc] += (-0.9374999999999998*b[i + 48*ldb] + 0.9374999999999998*b[i + 98*ldb]);
        c[i + 239*ldc] += (-0.9374999999999998*b[i + 49*ldb] + 0.9374999999999998*b[i + 99*ldb]);
        c[i + 240*ldc] += (0.5598111202653958*b[i + 45*ldb] + -1.866077916035022*b[i + 95*ldb]);
        c[i + 241*ldc] += (0.5598111202653958*b[i + 46*ldb] + -1.866077916035022*b[i + 96*ldb]);
        c[i + 242*ldc] += (0.5598111202653958*b[i + 47*ldb] + -1.866077916035022*b[i + 97*ldb]);
        c[i + 243*ldc] += (0.5598111202653958*b[i + 48*ldb] + -1.866077916035022*b[i + 98*ldb]);
        c[i + 244*ldc] += (0.5598111202653958*b[i + 49*ldb] + -1.866077916035022*b[i + 99*ldb]);
        c[i + 245*ldc] += (-0.3222878728081187*b[i + 45*ldb] + 6.548045607936744*b[i + 95*ldb]);
        c[i + 246*ldc] += (-0.3222878728081187*b[i + 46*ldb] + 6.548045607936744*b[i + 96*ldb]);
        c[i + 247*ldc] += (-0.3222878728081187*b[i + 47*ldb] + 6.548045607936744*b[i + 97*ldb]);
        c[i + 248*ldc] += (-0.3222878728081187*b[i + 48*ldb] + 6.548045607936744*b[i + 98*ldb]);
        c[i + 249*ldc] += (-0.3222878728081187*b[i + 49*ldb] + 6.548045607936744*b[i + 99*ldb]);
        c[i + 250*ldc] += (-6.548045607936744*b[i + 0*ldb] + 0.3222878728081187*b[i + 125*ldb]);
        c[i + 251*ldc] += (-6.548045607936744*b[i + 1*ldb] + 0.3222878728081187*b[i + 126*ldb]);
        c[i + 252*ldc] += (-6.548045607936744*b[i + 2*ldb] + 0.3222878728081187*b[i + 127*ldb]);
        c[i + 253*ldc] += (-6.548045607936744*b[i + 3*ldb] + 0.3222878728081187*b[i + 128*ldb]);
        c[i + 254*ldc] += (-6.548045607936744*b[i + 4*ldb] + 0.3222878728081187*b[i + 129*ldb]);
        c[i + 255*ldc] += (-6.548045607936744*b[i + 5*ldb] + 0.3222878728081187*b[i + 130*ldb]);
        c[i + 256*ldc] += (-6.548045607936744*b[i + 6*ldb] + 0.3222878728081187*b[i + 131*ldb]);
        c[i + 257*ldc] += (-6.548045607936744*b[i + 7*ldb] + 0.3222878728081187*b[i + 132*ldb]);
        c[i + 258*ldc] += (-6.548045607936744*b[i + 8*ldb] + 0.3222878728081187*b[i + 133*ldb]);
        c[i + 259*ldc] += (-6.548045607936744*b[i + 9*ldb] + 0.3222878728081187*b[i + 134*ldb]);
        c[i + 260*ldc] += (-6.548045607936744*b[i + 10*ldb] + 0.3222878728081187*b[i + 135*ldb]);
        c[i + 261*ldc] += (-6.548045607936744*b[i + 11*ldb] + 0.3222878728081187*b[i + 136*ldb]);
        c[i + 262*ldc] += (-6.548045607936744*b[i + 12*ldb] + 0.3222878728081187*b[i + 137*ldb]);
        c[i + 263*ldc] += (-6.548045607936744*b[i + 13*ldb] + 0.3222878728081187*b[i + 138*ldb]);
        c[i + 264*ldc] += (-6.548045607936744*b[i + 14*ldb] + 0.3222878728081187*b[i + 139*ldb]);
        c[i + 265*ldc] += (-6.548045607936744*b[i + 15*ldb] + 0.3222878728081187*b[i + 140*ldb]);
        c[i + 266*ldc] += (-6.548045607936744*b[i + 16*ldb] + 0.3222878728081187*b[i + 141*ldb]);
        c[i + 267*ldc] += (-6.548045607936744*b[i + 17*ldb] + 0.3222878728081187*b[i + 142*ldb]);
        c[i + 268*ldc] += (-6.548045607936744*b[i + 18*ldb] + 0.3222878728081187*b[i + 143*ldb]);
        c[i + 269*ldc] += (-6.548045607936744*b[i + 19*ldb] + 0.3222878728081187*b[i + 144*ldb]);
        c[i + 270*ldc] += (-6.548045607936744*b[i + 20*ldb] + 0.3222878728081187*b[i + 145*ldb]);
        c[i + 271*ldc] += (-6.548045607936744*b[i + 21*ldb] + 0.3222878728081187*b[i + 146*ldb]);
        c[i + 272*ldc] += (-6.548045607936744*b[i + 22*ldb] + 0.3222878728081187*b[i + 147*ldb]);
        c[i + 273*ldc] += (-6.548045607936744*b[i + 23*ldb] + 0.3222878728081187*b[i + 148*ldb]);
        c[i + 274*ldc] += (-6.548045607936744*b[i + 24*ldb] + 0.3222878728081187*b[i + 149*ldb]);
        c[i + 275*ldc] += (1.866077916035022*b[i + 0*ldb] + -0.5598111202653958*b[i + 125*ldb]);
        c[i + 276*ldc] += (1.866077916035022*b[i + 1*ldb] + -0.5598111202653958*b[i + 126*ldb]);
        c[i + 277*ldc] += (1.866077916035022*b[i + 2*ldb] + -0.5598111202653958*b[i + 127*ldb]);
        c[i + 278*ldc] += (1.866077916035022*b[i + 3*ldb] + -0.5598111202653958*b[i + 128*ldb]);
        c[i + 279*ldc] += (1.866077916035022*b[i + 4*ldb] + -0.5598111202653958*b[i + 129*ldb]);
        c[i + 280*ldc] += (1.866077916035022*b[i + 5*ldb] + -0.5598111202653958*b[i + 130*ldb]);
        c[i + 281*ldc] += (1.866077916035022*b[i + 6*ldb] + -0.5598111202653958*b[i + 131*ldb]);
        c[i + 282*ldc] += (1.866077916035022*b[i + 7*ldb] + -0.5598111202653958*b[i + 132*ldb]);
        c[i + 283*ldc] += (1.866077916035022*b[i + 8*ldb] + -0.5598111202653958*b[i + 133*ldb]);
        c[i + 284*ldc] += (1.866077916035022*b[i + 9*ldb] + -0.5598111202653958*b[i + 134*ldb]);
        c[i + 285*ldc] += (1.866077916035022*b[i + 10*ldb] + -0.5598111202653958*b[i + 135*ldb]);
        c[i + 286*ldc] += (1.866077916035022*b[i + 11*ldb] + -0.5598111202653958*b[i + 136*ldb]);
        c[i + 287*ldc] += (1.866077916035022*b[i + 12*ldb] + -0.5598111202653958*b[i + 137*ldb]);
        c[i + 288*ldc] += (1.866077916035022*b[i + 13*ldb] + -0.5598111202653958*b[i + 138*ldb]);
        c[i + 289*ldc] += (1.866077916035022*b[i + 14*ldb] + -0.5598111202653958*b[i + 139*ldb]);
        c[i + 290*ldc] += (1.866077916035022*b[i + 15*ldb] + -0.5598111202653958*b[i + 140*ldb]);
        c[i + 291*ldc] += (1.866077916035022*b[i + 16*ldb] + -0.5598111202653958*b[i + 141*ldb]);
        c[i + 292*ldc] += (1.866077916035022*b[i + 17*ldb] + -0.5598111202653958*b[i + 142*ldb]);
        c[i + 293*ldc] += (1.866077916035022*b[i + 18*ldb] + -0.5598111202653958*b[i + 143*ldb]);
        c[i + 294*ldc] += (1.866077916035022*b[i + 19*ldb] + -0.5598111202653958*b[i + 144*ldb]);
        c[i + 295*ldc] += (1.866077916035022*b[i + 20*ldb] + -0.5598111202653958*b[i + 145*ldb]);
        c[i + 296*ldc] += (1.866077916035022*b[i + 21*ldb] + -0.5598111202653958*b[i + 146*ldb]);
        c[i + 297*ldc] += (1.866077916035022*b[i + 22*ldb] + -0.5598111202653958*b[i + 147*ldb]);
        c[i + 298*ldc] += (1.866077916035022*b[i + 23*ldb] + -0.5598111202653958*b[i + 148*ldb]);
        c[i + 299*ldc] += (1.866077916035022*b[i + 24*ldb] + -0.5598111202653958*b[i + 149*ldb]);
        c[i + 300*ldc] += (-0.9374999999999998*b[i + 0*ldb] + 0.9374999999999998*b[i + 125*ldb]);
        c[i + 301*ldc] += (-0.9374999999999998*b[i + 1*ldb] + 0.9374999999999998*b[i + 126*ldb]);
        c[i + 302*ldc] += (-0.9374999999999998*b[i + 2*ldb] + 0.9374999999999998*b[i + 127*ldb]);
        c[i + 303*ldc] += (-0.9374999999999998*b[i + 3*ldb] + 0.9374999999999998*b[i + 128*ldb]);
        c[i + 304*ldc] += (-0.9374999999999998*b[i + 4*ldb] + 0.9374999999999998*b[i + 129*ldb]);
        c[i + 305*ldc] += (-0.9374999999999998*b[i + 5*ldb] + 0.9374999999999998*b[i + 130*ldb]);
        c[i + 306*ldc] += (-0.9374999999999998*b[i + 6*ldb] + 0.9374999999999998*b[i + 131*ldb]);
        c[i + 307*ldc] += (-0.9374999999999998*b[i + 7*ldb] + 0.9374999999999998*b[i + 132*ldb]);
        c[i + 308*ldc] += (-0.9374999999999998*b[i + 8*ldb] + 0.9374999999999998*b[i + 133*ldb]);
        c[i + 309*ldc] += (-0.9374999999999998*b[i + 9*ldb] + 0.9374999999999998*b[i + 134*ldb]);
        c[i + 310*ldc] += (-0.9374999999999998*b[i + 10*ldb] + 0.9374999999999998*b[i + 135*ldb]);
        c[i + 311*ldc] += (-0.9374999999999998*b[i + 11*ldb] + 0.9374999999999998*b[i + 136*ldb]);
        c[i + 312*ldc] += (-0.9374999999999998*b[i + 12*ldb] + 0.9374999999999998*b[i + 137*ldb]);
        c[i + 313*ldc] += (-0.9374999999999998*b[i + 13*ldb] + 0.9374999999999998*b[i + 138*ldb]);
        c[i + 314*ldc] += (-0.9374999999999998*b[i + 14*ldb] + 0.9374999999999998*b[i + 139*ldb]);
        c[i + 315*ldc] += (-0.9374999999999998*b[i + 15*ldb] + 0.9374999999999998*b[i + 140*ldb]);
        c[i + 316*ldc] += (-0.9374999999999998*b[i + 16*ldb] + 0.9374999999999998*b[i + 141*ldb]);
        c[i + 317*ldc] += (-0.9374999999999998*b[i + 17*ldb] + 0.9374999999999998*b[i + 142*ldb]);
        c[i + 318*ldc] += (-0.9374999999999998*b[i + 18*ldb] + 0.9374999999999998*b[i + 143*ldb]);
        c[i + 319*ldc] += (-0.9374999999999998*b[i + 19*ldb] + 0.9374999999999998*b[i + 144*ldb]);
        c[i + 320*ldc] += (-0.9374999999999998*b[i + 20*ldb] + 0.9374999999999998*b[i + 145*ldb]);
        c[i + 321*ldc] += (-0.9374999999999998*b[i + 21*ldb] + 0.9374999999999998*b[i + 146*ldb]);
        c[i + 322*ldc] += (-0.9374999999999998*b[i + 22*ldb] + 0.9374999999999998*b[i + 147*ldb]);
        c[i + 323*ldc] += (-0.9374999999999998*b[i + 23*ldb] + 0.9374999999999998*b[i + 148*ldb]);
        c[i + 324*ldc] += (-0.9374999999999998*b[i + 24*ldb] + 0.9374999999999998*b[i + 149*ldb]);
        c[i + 325*ldc] += (0.5598111202653958*b[i + 0*ldb] + -1.866077916035022*b[i + 125*ldb]);
        c[i + 326*ldc] += (0.5598111202653958*b[i + 1*ldb] + -1.866077916035022*b[i + 126*ldb]);
        c[i + 327*ldc] += (0.5598111202653958*b[i + 2*ldb] + -1.866077916035022*b[i + 127*ldb]);
        c[i + 328*ldc] += (0.5598111202653958*b[i + 3*ldb] + -1.866077916035022*b[i + 128*ldb]);
        c[i + 329*ldc] += (0.5598111202653958*b[i + 4*ldb] + -1.866077916035022*b[i + 129*ldb]);
        c[i + 330*ldc] += (0.5598111202653958*b[i + 5*ldb] + -1.866077916035022*b[i + 130*ldb]);
        c[i + 331*ldc] += (0.5598111202653958*b[i + 6*ldb] + -1.866077916035022*b[i + 131*ldb]);
        c[i + 332*ldc] += (0.5598111202653958*b[i + 7*ldb] + -1.866077916035022*b[i + 132*ldb]);
        c[i + 333*ldc] += (0.5598111202653958*b[i + 8*ldb] + -1.866077916035022*b[i + 133*ldb]);
        c[i + 334*ldc] += (0.5598111202653958*b[i + 9*ldb] + -1.866077916035022*b[i + 134*ldb]);
        c[i + 335*ldc] += (0.5598111202653958*b[i + 10*ldb] + -1.866077916035022*b[i + 135*ldb]);
        c[i + 336*ldc] += (0.5598111202653958*b[i + 11*ldb] + -1.866077916035022*b[i + 136*ldb]);
        c[i + 337*ldc] += (0.5598111202653958*b[i + 12*ldb] + -1.866077916035022*b[i + 137*ldb]);
        c[i + 338*ldc] += (0.5598111202653958*b[i + 13*ldb] + -1.866077916035022*b[i + 138*ldb]);
        c[i + 339*ldc] += (0.5598111202653958*b[i + 14*ldb] + -1.866077916035022*b[i + 139*ldb]);
        c[i + 340*ldc] += (0.5598111202653958*b[i + 15*ldb] + -1.866077916035022*b[i + 140*ldb]);
        c[i + 341*ldc] += (0.5598111202653958*b[i + 16*ldb] + -1.866077916035022*b[i + 141*ldb]);
        c[i + 342*ldc] += (0.5598111202653958*b[i + 17*ldb] + -1.866077916035022*b[i + 142*ldb]);
        c[i + 343*ldc] += (0.5598111202653958*b[i + 18*ldb] + -1.866077916035022*b[i + 143*ldb]);
        c[i + 344*ldc] += (0.5598111202653958*b[i + 19*ldb] + -1.866077916035022*b[i + 144*ldb]);
        c[i + 345*ldc] += (0.5598111202653958*b[i + 20*ldb] + -1.866077916035022*b[i + 145*ldb]);
        c[i + 346*ldc] += (0.5598111202653958*b[i + 21*ldb] + -1.866077916035022*b[i + 146*ldb]);
        c[i + 347*ldc] += (0.5598111202653958*b[i + 22*ldb] + -1.866077916035022*b[i + 147*ldb]);
        c[i + 348*ldc] += (0.5598111202653958*b[i + 23*ldb] + -1.866077916035022*b[i + 148*ldb]);
        c[i + 349*ldc] += (0.5598111202653958*b[i + 24*ldb] + -1.866077916035022*b[i + 149*ldb]);
        c[i + 350*ldc] += (-0.3222878728081187*b[i + 0*ldb] + 6.548045607936744*b[i + 125*ldb]);
        c[i + 351*ldc] += (-0.3222878728081187*b[i + 1*ldb] + 6.548045607936744*b[i + 126*ldb]);
        c[i + 352*ldc] += (-0.3222878728081187*b[i + 2*ldb] + 6.548045607936744*b[i + 127*ldb]);
        c[i + 353*ldc] += (-0.3222878728081187*b[i + 3*ldb] + 6.548045607936744*b[i + 128*ldb]);
        c[i + 354*ldc] += (-0.3222878728081187*b[i + 4*ldb] + 6.548045607936744*b[i + 129*ldb]);
        c[i + 355*ldc] += (-0.3222878728081187*b[i + 5*ldb] + 6.548045607936744*b[i + 130*ldb]);
        c[i + 356*ldc] += (-0.3222878728081187*b[i + 6*ldb] + 6.548045607936744*b[i + 131*ldb]);
        c[i + 357*ldc] += (-0.3222878728081187*b[i + 7*ldb] + 6.548045607936744*b[i + 132*ldb]);
        c[i + 358*ldc] += (-0.3222878728081187*b[i + 8*ldb] + 6.548045607936744*b[i + 133*ldb]);
        c[i + 359*ldc] += (-0.3222878728081187*b[i + 9*ldb] + 6.548045607936744*b[i + 134*ldb]);
        c[i + 360*ldc] += (-0.3222878728081187*b[i + 10*ldb] + 6.548045607936744*b[i + 135*ldb]);
        c[i + 361*ldc] += (-0.3222878728081187*b[i + 11*ldb] + 6.548045607936744*b[i + 136*ldb]);
        c[i + 362*ldc] += (-0.3222878728081187*b[i + 12*ldb] + 6.548045607936744*b[i + 137*ldb]);
        c[i + 363*ldc] += (-0.3222878728081187*b[i + 13*ldb] + 6.548045607936744*b[i + 138*ldb]);
        c[i + 364*ldc] += (-0.3222878728081187*b[i + 14*ldb] + 6.548045607936744*b[i + 139*ldb]);
        c[i + 365*ldc] += (-0.3222878728081187*b[i + 15*ldb] + 6.548045607936744*b[i + 140*ldb]);
        c[i + 366*ldc] += (-0.3222878728081187*b[i + 16*ldb] + 6.548045607936744*b[i + 141*ldb]);
        c[i + 367*ldc] += (-0.3222878728081187*b[i + 17*ldb] + 6.548045607936744*b[i + 142*ldb]);
        c[i + 368*ldc] += (-0.3222878728081187*b[i + 18*ldb] + 6.548045607936744*b[i + 143*ldb]);
        c[i + 369*ldc] += (-0.3222878728081187*b[i + 19*ldb] + 6.548045607936744*b[i + 144*ldb]);
        c[i + 370*ldc] += (-0.3222878728081187*b[i + 20*ldb] + 6.548045607936744*b[i + 145*ldb]);
        c[i + 371*ldc] += (-0.3222878728081187*b[i + 21*ldb] + 6.548045607936744*b[i + 146*ldb]);
        c[i + 372*ldc] += (-0.3222878728081187*b[i + 22*ldb] + 6.548045607936744*b[i + 147*ldb]);
        c[i + 373*ldc] += (-0.3222878728081187*b[i + 23*ldb] + 6.548045607936744*b[i + 148*ldb]);
        c[i + 374*ldc] += (-0.3222878728081187*b[i + 24*ldb] + 6.548045607936744*b[i + 149*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_hex_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (5.06704059565454*b[i + 0*ldb] + 1.939864544376097*b[i + 1*ldb] + -0.7231396289857297*b[i + 2*ldb] + 0.4937590750470338*b[i + 3*ldb] + -0.5517668509633159*b[i + 4*ldb]);
        c[i + 1*ldc] = (-3.812557894803954*b[i + 0*ldb] + 0.7583532171678757*b[i + 1*ldb] + 1.706075027753831*b[i + 2*ldb] + -0.9285580266438338*b[i + 3*ldb] + 0.9704208807564537*b[i + 4*ldb]);
        c[i + 2*ldc] = (1.684026960320175*b[i + 0*ldb] + -2.021528935875383*b[i + 1*ldb] + 2.021528935875383*b[i + 3*ldb] + -1.684026960320175*b[i + 4*ldb]);
        c[i + 3*ldc] = (-0.9704208807564537*b[i + 0*ldb] + 0.9285580266438338*b[i + 1*ldb] + -1.706075027753831*b[i + 2*ldb] + -0.7583532171678757*b[i + 3*ldb] + 3.812557894803954*b[i + 4*ldb]);
        c[i + 4*ldc] = (0.5517668509633159*b[i + 0*ldb] + -0.4937590750470338*b[i + 1*ldb] + 0.7231396289857297*b[i + 2*ldb] + -1.939864544376097*b[i + 3*ldb] + -5.06704059565454*b[i + 4*ldb]);
        c[i + 5*ldc] = (5.06704059565454*b[i + 5*ldb] + 1.939864544376097*b[i + 6*ldb] + -0.7231396289857297*b[i + 7*ldb] + 0.4937590750470338*b[i + 8*ldb] + -0.5517668509633159*b[i + 9*ldb]);
        c[i + 6*ldc] = (-3.812557894803954*b[i + 5*ldb] + 0.7583532171678757*b[i + 6*ldb] + 1.706075027753831*b[i + 7*ldb] + -0.9285580266438338*b[i + 8*ldb] + 0.9704208807564537*b[i + 9*ldb]);
        c[i + 7*ldc] = (1.684026960320175*b[i + 5*ldb] + -2.021528935875383*b[i + 6*ldb] + 2.021528935875383*b[i + 8*ldb] + -1.684026960320175*b[i + 9*ldb]);
        c[i + 8*ldc] = (-0.9704208807564537*b[i + 5*ldb] + 0.9285580266438338*b[i + 6*ldb] + -1.706075027753831*b[i + 7*ldb] + -0.7583532171678757*b[i + 8*ldb] + 3.812557894803954*b[i + 9*ldb]);
        c[i + 9*ldc] = (0.5517668509633159*b[i + 5*ldb] + -0.4937590750470338*b[i + 6*ldb] + 0.7231396289857297*b[i + 7*ldb] + -1.939864544376097*b[i + 8*ldb] + -5.06704059565454*b[i + 9*ldb]);
        c[i + 10*ldc] = (5.06704059565454*b[i + 10*ldb] + 1.939864544376097*b[i + 11*ldb] + -0.7231396289857297*b[i + 12*ldb] + 0.4937590750470338*b[i + 13*ldb] + -0.5517668509633159*b[i + 14*ldb]);
        c[i + 11*ldc] = (-3.812557894803954*b[i + 10*ldb] + 0.7583532171678757*b[i + 11*ldb] + 1.706075027753831*b[i + 12*ldb] + -0.9285580266438338*b[i + 13*ldb] + 0.9704208807564537*b[i + 14*ldb]);
        c[i + 12*ldc] = (1.684026960320175*b[i + 10*ldb] + -2.021528935875383*b[i + 11*ldb] + 2.021528935875383*b[i + 13*ldb] + -1.684026960320175*b[i + 14*ldb]);
        c[i + 13*ldc] = (-0.9704208807564537*b[i + 10*ldb] + 0.9285580266438338*b[i + 11*ldb] + -1.706075027753831*b[i + 12*ldb] + -0.7583532171678757*b[i + 13*ldb] + 3.812557894803954*b[i + 14*ldb]);
        c[i + 14*ldc] = (0.5517668509633159*b[i + 10*ldb] + -0.4937590750470338*b[i + 11*ldb] + 0.7231396289857297*b[i + 12*ldb] + -1.939864544376097*b[i + 13*ldb] + -5.06704059565454*b[i + 14*ldb]);
        c[i + 15*ldc] = (5.06704059565454*b[i + 15*ldb] + 1.939864544376097*b[i + 16*ldb] + -0.7231396289857297*b[i + 17*ldb] + 0.4937590750470338*b[i + 18*ldb] + -0.5517668509633159*b[i + 19*ldb]);
        c[i + 16*ldc] = (-3.812557894803954*b[i + 15*ldb] + 0.7583532171678757*b[i + 16*ldb] + 1.706075027753831*b[i + 17*ldb] + -0.9285580266438338*b[i + 18*ldb] + 0.9704208807564537*b[i + 19*ldb]);
        c[i + 17*ldc] = (1.684026960320175*b[i + 15*ldb] + -2.021528935875383*b[i + 16*ldb] + 2.021528935875383*b[i + 18*ldb] + -1.684026960320175*b[i + 19*ldb]);
        c[i + 18*ldc] = (-0.9704208807564537*b[i + 15*ldb] + 0.9285580266438338*b[i + 16*ldb] + -1.706075027753831*b[i + 17*ldb] + -0.7583532171678757*b[i + 18*ldb] + 3.812557894803954*b[i + 19*ldb]);
        c[i + 19*ldc] = (0.5517668509633159*b[i + 15*ldb] + -0.4937590750470338*b[i + 16*ldb] + 0.7231396289857297*b[i + 17*ldb] + -1.939864544376097*b[i + 18*ldb] + -5.06704059565454*b[i + 19*ldb]);
        c[i + 20*ldc] = (5.06704059565454*b[i + 20*ldb] + 1.939864544376097*b[i + 21*ldb] + -0.7231396289857297*b[i + 22*ldb] + 0.4937590750470338*b[i + 23*ldb] + -0.5517668509633159*b[i + 24*ldb]);
        c[i + 21*ldc] = (-3.812557894803954*b[i + 20*ldb] + 0.7583532171678757*b[i + 21*ldb] + 1.706075027753831*b[i + 22*ldb] + -0.9285580266438338*b[i + 23*ldb] + 0.9704208807564537*b[i + 24*ldb]);
        c[i + 22*ldc] = (1.684026960320175*b[i + 20*ldb] + -2.021528935875383*b[i + 21*ldb] + 2.021528935875383*b[i + 23*ldb] + -1.684026960320175*b[i + 24*ldb]);
        c[i + 23*ldc] = (-0.9704208807564537*b[i + 20*ldb] + 0.9285580266438338*b[i + 21*ldb] + -1.706075027753831*b[i + 22*ldb] + -0.7583532171678757*b[i + 23*ldb] + 3.812557894803954*b[i + 24*ldb]);
        c[i + 24*ldc] = (0.5517668509633159*b[i + 20*ldb] + -0.4937590750470338*b[i + 21*ldb] + 0.7231396289857297*b[i + 22*ldb] + -1.939864544376097*b[i + 23*ldb] + -5.06704059565454*b[i + 24*ldb]);
        c[i + 25*ldc] = (5.06704059565454*b[i + 25*ldb] + 1.939864544376097*b[i + 26*ldb] + -0.7231396289857297*b[i + 27*ldb] + 0.4937590750470338*b[i + 28*ldb] + -0.5517668509633159*b[i + 29*ldb]);
        c[i + 26*ldc] = (-3.812557894803954*b[i + 25*ldb] + 0.7583532171678757*b[i + 26*ldb] + 1.706075027753831*b[i + 27*ldb] + -0.9285580266438338*b[i + 28*ldb] + 0.9704208807564537*b[i + 29*ldb]);
        c[i + 27*ldc] = (1.684026960320175*b[i + 25*ldb] + -2.021528935875383*b[i + 26*ldb] + 2.021528935875383*b[i + 28*ldb] + -1.684026960320175*b[i + 29*ldb]);
        c[i + 28*ldc] = (-0.9704208807564537*b[i + 25*ldb] + 0.9285580266438338*b[i + 26*ldb] + -1.706075027753831*b[i + 27*ldb] + -0.7583532171678757*b[i + 28*ldb] + 3.812557894803954*b[i + 29*ldb]);
        c[i + 29*ldc] = (0.5517668509633159*b[i + 25*ldb] + -0.4937590750470338*b[i + 26*ldb] + 0.7231396289857297*b[i + 27*ldb] + -1.939864544376097*b[i + 28*ldb] + -5.06704059565454*b[i + 29*ldb]);
        c[i + 30*ldc] = (5.06704059565454*b[i + 30*ldb] + 1.939864544376097*b[i + 31*ldb] + -0.7231396289857297*b[i + 32*ldb] + 0.4937590750470338*b[i + 33*ldb] + -0.5517668509633159*b[i + 34*ldb]);
        c[i + 31*ldc] = (-3.812557894803954*b[i + 30*ldb] + 0.7583532171678757*b[i + 31*ldb] + 1.706075027753831*b[i + 32*ldb] + -0.9285580266438338*b[i + 33*ldb] + 0.9704208807564537*b[i + 34*ldb]);
        c[i + 32*ldc] = (1.684026960320175*b[i + 30*ldb] + -2.021528935875383*b[i + 31*ldb] + 2.021528935875383*b[i + 33*ldb] + -1.684026960320175*b[i + 34*ldb]);
        c[i + 33*ldc] = (-0.9704208807564537*b[i + 30*ldb] + 0.9285580266438338*b[i + 31*ldb] + -1.706075027753831*b[i + 32*ldb] + -0.7583532171678757*b[i + 33*ldb] + 3.812557894803954*b[i + 34*ldb]);
        c[i + 34*ldc] = (0.5517668509633159*b[i + 30*ldb] + -0.4937590750470338*b[i + 31*ldb] + 0.7231396289857297*b[i + 32*ldb] + -1.939864544376097*b[i + 33*ldb] + -5.06704059565454*b[i + 34*ldb]);
        c[i + 35*ldc] = (5.06704059565454*b[i + 35*ldb] + 1.939864544376097*b[i + 36*ldb] + -0.7231396289857297*b[i + 37*ldb] + 0.4937590750470338*b[i + 38*ldb] + -0.5517668509633159*b[i + 39*ldb]);
        c[i + 36*ldc] = (-3.812557894803954*b[i + 35*ldb] + 0.7583532171678757*b[i + 36*ldb] + 1.706075027753831*b[i + 37*ldb] + -0.9285580266438338*b[i + 38*ldb] + 0.9704208807564537*b[i + 39*ldb]);
        c[i + 37*ldc] = (1.684026960320175*b[i + 35*ldb] + -2.021528935875383*b[i + 36*ldb] + 2.021528935875383*b[i + 38*ldb] + -1.684026960320175*b[i + 39*ldb]);
        c[i + 38*ldc] = (-0.9704208807564537*b[i + 35*ldb] + 0.9285580266438338*b[i + 36*ldb] + -1.706075027753831*b[i + 37*ldb] + -0.7583532171678757*b[i + 38*ldb] + 3.812557894803954*b[i + 39*ldb]);
        c[i + 39*ldc] = (0.5517668509633159*b[i + 35*ldb] + -0.4937590750470338*b[i + 36*ldb] + 0.7231396289857297*b[i + 37*ldb] + -1.939864544376097*b[i + 38*ldb] + -5.06704059565454*b[i + 39*ldb]);
        c[i + 40*ldc] = (5.06704059565454*b[i + 40*ldb] + 1.939864544376097*b[i + 41*ldb] + -0.7231396289857297*b[i + 42*ldb] + 0.4937590750470338*b[i + 43*ldb] + -0.5517668509633159*b[i + 44*ldb]);
        c[i + 41*ldc] = (-3.812557894803954*b[i + 40*ldb] + 0.7583532171678757*b[i + 41*ldb] + 1.706075027753831*b[i + 42*ldb] + -0.9285580266438338*b[i + 43*ldb] + 0.9704208807564537*b[i + 44*ldb]);
        c[i + 42*ldc] = (1.684026960320175*b[i + 40*ldb] + -2.021528935875383*b[i + 41*ldb] + 2.021528935875383*b[i + 43*ldb] + -1.684026960320175*b[i + 44*ldb]);
        c[i + 43*ldc] = (-0.9704208807564537*b[i + 40*ldb] + 0.9285580266438338*b[i + 41*ldb] + -1.706075027753831*b[i + 42*ldb] + -0.7583532171678757*b[i + 43*ldb] + 3.812557894803954*b[i + 44*ldb]);
        c[i + 44*ldc] = (0.5517668509633159*b[i + 40*ldb] + -0.4937590750470338*b[i + 41*ldb] + 0.7231396289857297*b[i + 42*ldb] + -1.939864544376097*b[i + 43*ldb] + -5.06704059565454*b[i + 44*ldb]);
        c[i + 45*ldc] = (5.06704059565454*b[i + 45*ldb] + 1.939864544376097*b[i + 46*ldb] + -0.7231396289857297*b[i + 47*ldb] + 0.4937590750470338*b[i + 48*ldb] + -0.5517668509633159*b[i + 49*ldb]);
        c[i + 46*ldc] = (-3.812557894803954*b[i + 45*ldb] + 0.7583532171678757*b[i + 46*ldb] + 1.706075027753831*b[i + 47*ldb] + -0.9285580266438338*b[i + 48*ldb] + 0.9704208807564537*b[i + 49*ldb]);
        c[i + 47*ldc] = (1.684026960320175*b[i + 45*ldb] + -2.021528935875383*b[i + 46*ldb] + 2.021528935875383*b[i + 48*ldb] + -1.684026960320175*b[i + 49*ldb]);
        c[i + 48*ldc] = (-0.9704208807564537*b[i + 45*ldb] + 0.9285580266438338*b[i + 46*ldb] + -1.706075027753831*b[i + 47*ldb] + -0.7583532171678757*b[i + 48*ldb] + 3.812557894803954*b[i + 49*ldb]);
        c[i + 49*ldc] = (0.5517668509633159*b[i + 45*ldb] + -0.4937590750470338*b[i + 46*ldb] + 0.7231396289857297*b[i + 47*ldb] + -1.939864544376097*b[i + 48*ldb] + -5.06704059565454*b[i + 49*ldb]);
        c[i + 50*ldc] = (5.06704059565454*b[i + 50*ldb] + 1.939864544376097*b[i + 51*ldb] + -0.7231396289857297*b[i + 52*ldb] + 0.4937590750470338*b[i + 53*ldb] + -0.5517668509633159*b[i + 54*ldb]);
        c[i + 51*ldc] = (-3.812557894803954*b[i + 50*ldb] + 0.7583532171678757*b[i + 51*ldb] + 1.706075027753831*b[i + 52*ldb] + -0.9285580266438338*b[i + 53*ldb] + 0.9704208807564537*b[i + 54*ldb]);
        c[i + 52*ldc] = (1.684026960320175*b[i + 50*ldb] + -2.021528935875383*b[i + 51*ldb] + 2.021528935875383*b[i + 53*ldb] + -1.684026960320175*b[i + 54*ldb]);
        c[i + 53*ldc] = (-0.9704208807564537*b[i + 50*ldb] + 0.9285580266438338*b[i + 51*ldb] + -1.706075027753831*b[i + 52*ldb] + -0.7583532171678757*b[i + 53*ldb] + 3.812557894803954*b[i + 54*ldb]);
        c[i + 54*ldc] = (0.5517668509633159*b[i + 50*ldb] + -0.4937590750470338*b[i + 51*ldb] + 0.7231396289857297*b[i + 52*ldb] + -1.939864544376097*b[i + 53*ldb] + -5.06704059565454*b[i + 54*ldb]);
        c[i + 55*ldc] = (5.06704059565454*b[i + 55*ldb] + 1.939864544376097*b[i + 56*ldb] + -0.7231396289857297*b[i + 57*ldb] + 0.4937590750470338*b[i + 58*ldb] + -0.5517668509633159*b[i + 59*ldb]);
        c[i + 56*ldc] = (-3.812557894803954*b[i + 55*ldb] + 0.7583532171678757*b[i + 56*ldb] + 1.706075027753831*b[i + 57*ldb] + -0.9285580266438338*b[i + 58*ldb] + 0.9704208807564537*b[i + 59*ldb]);
        c[i + 57*ldc] = (1.684026960320175*b[i + 55*ldb] + -2.021528935875383*b[i + 56*ldb] + 2.021528935875383*b[i + 58*ldb] + -1.684026960320175*b[i + 59*ldb]);
        c[i + 58*ldc] = (-0.9704208807564537*b[i + 55*ldb] + 0.9285580266438338*b[i + 56*ldb] + -1.706075027753831*b[i + 57*ldb] + -0.7583532171678757*b[i + 58*ldb] + 3.812557894803954*b[i + 59*ldb]);
        c[i + 59*ldc] = (0.5517668509633159*b[i + 55*ldb] + -0.4937590750470338*b[i + 56*ldb] + 0.7231396289857297*b[i + 57*ldb] + -1.939864544376097*b[i + 58*ldb] + -5.06704059565454*b[i + 59*ldb]);
        c[i + 60*ldc] = (5.06704059565454*b[i + 60*ldb] + 1.939864544376097*b[i + 61*ldb] + -0.7231396289857297*b[i + 62*ldb] + 0.4937590750470338*b[i + 63*ldb] + -0.5517668509633159*b[i + 64*ldb]);
        c[i + 61*ldc] = (-3.812557894803954*b[i + 60*ldb] + 0.7583532171678757*b[i + 61*ldb] + 1.706075027753831*b[i + 62*ldb] + -0.9285580266438338*b[i + 63*ldb] + 0.9704208807564537*b[i + 64*ldb]);
        c[i + 62*ldc] = (1.684026960320175*b[i + 60*ldb] + -2.021528935875383*b[i + 61*ldb] + 2.021528935875383*b[i + 63*ldb] + -1.684026960320175*b[i + 64*ldb]);
        c[i + 63*ldc] = (-0.9704208807564537*b[i + 60*ldb] + 0.9285580266438338*b[i + 61*ldb] + -1.706075027753831*b[i + 62*ldb] + -0.7583532171678757*b[i + 63*ldb] + 3.812557894803954*b[i + 64*ldb]);
        c[i + 64*ldc] = (0.5517668509633159*b[i + 60*ldb] + -0.4937590750470338*b[i + 61*ldb] + 0.7231396289857297*b[i + 62*ldb] + -1.939864544376097*b[i + 63*ldb] + -5.06704059565454*b[i + 64*ldb]);
        c[i + 65*ldc] = (5.06704059565454*b[i + 65*ldb] + 1.939864544376097*b[i + 66*ldb] + -0.7231396289857297*b[i + 67*ldb] + 0.4937590750470338*b[i + 68*ldb] + -0.5517668509633159*b[i + 69*ldb]);
        c[i + 66*ldc] = (-3.812557894803954*b[i + 65*ldb] + 0.7583532171678757*b[i + 66*ldb] + 1.706075027753831*b[i + 67*ldb] + -0.9285580266438338*b[i + 68*ldb] + 0.9704208807564537*b[i + 69*ldb]);
        c[i + 67*ldc] = (1.684026960320175*b[i + 65*ldb] + -2.021528935875383*b[i + 66*ldb] + 2.021528935875383*b[i + 68*ldb] + -1.684026960320175*b[i + 69*ldb]);
        c[i + 68*ldc] = (-0.9704208807564537*b[i + 65*ldb] + 0.9285580266438338*b[i + 66*ldb] + -1.706075027753831*b[i + 67*ldb] + -0.7583532171678757*b[i + 68*ldb] + 3.812557894803954*b[i + 69*ldb]);
        c[i + 69*ldc] = (0.5517668509633159*b[i + 65*ldb] + -0.4937590750470338*b[i + 66*ldb] + 0.7231396289857297*b[i + 67*ldb] + -1.939864544376097*b[i + 68*ldb] + -5.06704059565454*b[i + 69*ldb]);
        c[i + 70*ldc] = (5.06704059565454*b[i + 70*ldb] + 1.939864544376097*b[i + 71*ldb] + -0.7231396289857297*b[i + 72*ldb] + 0.4937590750470338*b[i + 73*ldb] + -0.5517668509633159*b[i + 74*ldb]);
        c[i + 71*ldc] = (-3.812557894803954*b[i + 70*ldb] + 0.7583532171678757*b[i + 71*ldb] + 1.706075027753831*b[i + 72*ldb] + -0.9285580266438338*b[i + 73*ldb] + 0.9704208807564537*b[i + 74*ldb]);
        c[i + 72*ldc] = (1.684026960320175*b[i + 70*ldb] + -2.021528935875383*b[i + 71*ldb] + 2.021528935875383*b[i + 73*ldb] + -1.684026960320175*b[i + 74*ldb]);
        c[i + 73*ldc] = (-0.9704208807564537*b[i + 70*ldb] + 0.9285580266438338*b[i + 71*ldb] + -1.706075027753831*b[i + 72*ldb] + -0.7583532171678757*b[i + 73*ldb] + 3.812557894803954*b[i + 74*ldb]);
        c[i + 74*ldc] = (0.5517668509633159*b[i + 70*ldb] + -0.4937590750470338*b[i + 71*ldb] + 0.7231396289857297*b[i + 72*ldb] + -1.939864544376097*b[i + 73*ldb] + -5.06704059565454*b[i + 74*ldb]);
        c[i + 75*ldc] = (5.06704059565454*b[i + 75*ldb] + 1.939864544376097*b[i + 76*ldb] + -0.7231396289857297*b[i + 77*ldb] + 0.4937590750470338*b[i + 78*ldb] + -0.5517668509633159*b[i + 79*ldb]);
        c[i + 76*ldc] = (-3.812557894803954*b[i + 75*ldb] + 0.7583532171678757*b[i + 76*ldb] + 1.706075027753831*b[i + 77*ldb] + -0.9285580266438338*b[i + 78*ldb] + 0.9704208807564537*b[i + 79*ldb]);
        c[i + 77*ldc] = (1.684026960320175*b[i + 75*ldb] + -2.021528935875383*b[i + 76*ldb] + 2.021528935875383*b[i + 78*ldb] + -1.684026960320175*b[i + 79*ldb]);
        c[i + 78*ldc] = (-0.9704208807564537*b[i + 75*ldb] + 0.9285580266438338*b[i + 76*ldb] + -1.706075027753831*b[i + 77*ldb] + -0.7583532171678757*b[i + 78*ldb] + 3.812557894803954*b[i + 79*ldb]);
        c[i + 79*ldc] = (0.5517668509633159*b[i + 75*ldb] + -0.4937590750470338*b[i + 76*ldb] + 0.7231396289857297*b[i + 77*ldb] + -1.939864544376097*b[i + 78*ldb] + -5.06704059565454*b[i + 79*ldb]);
        c[i + 80*ldc] = (5.06704059565454*b[i + 80*ldb] + 1.939864544376097*b[i + 81*ldb] + -0.7231396289857297*b[i + 82*ldb] + 0.4937590750470338*b[i + 83*ldb] + -0.5517668509633159*b[i + 84*ldb]);
        c[i + 81*ldc] = (-3.812557894803954*b[i + 80*ldb] + 0.7583532171678757*b[i + 81*ldb] + 1.706075027753831*b[i + 82*ldb] + -0.9285580266438338*b[i + 83*ldb] + 0.9704208807564537*b[i + 84*ldb]);
        c[i + 82*ldc] = (1.684026960320175*b[i + 80*ldb] + -2.021528935875383*b[i + 81*ldb] + 2.021528935875383*b[i + 83*ldb] + -1.684026960320175*b[i + 84*ldb]);
        c[i + 83*ldc] = (-0.9704208807564537*b[i + 80*ldb] + 0.9285580266438338*b[i + 81*ldb] + -1.706075027753831*b[i + 82*ldb] + -0.7583532171678757*b[i + 83*ldb] + 3.812557894803954*b[i + 84*ldb]);
        c[i + 84*ldc] = (0.5517668509633159*b[i + 80*ldb] + -0.4937590750470338*b[i + 81*ldb] + 0.7231396289857297*b[i + 82*ldb] + -1.939864544376097*b[i + 83*ldb] + -5.06704059565454*b[i + 84*ldb]);
        c[i + 85*ldc] = (5.06704059565454*b[i + 85*ldb] + 1.939864544376097*b[i + 86*ldb] + -0.7231396289857297*b[i + 87*ldb] + 0.4937590750470338*b[i + 88*ldb] + -0.5517668509633159*b[i + 89*ldb]);
        c[i + 86*ldc] = (-3.812557894803954*b[i + 85*ldb] + 0.7583532171678757*b[i + 86*ldb] + 1.706075027753831*b[i + 87*ldb] + -0.9285580266438338*b[i + 88*ldb] + 0.9704208807564537*b[i + 89*ldb]);
        c[i + 87*ldc] = (1.684026960320175*b[i + 85*ldb] + -2.021528935875383*b[i + 86*ldb] + 2.021528935875383*b[i + 88*ldb] + -1.684026960320175*b[i + 89*ldb]);
        c[i + 88*ldc] = (-0.9704208807564537*b[i + 85*ldb] + 0.9285580266438338*b[i + 86*ldb] + -1.706075027753831*b[i + 87*ldb] + -0.7583532171678757*b[i + 88*ldb] + 3.812557894803954*b[i + 89*ldb]);
        c[i + 89*ldc] = (0.5517668509633159*b[i + 85*ldb] + -0.4937590750470338*b[i + 86*ldb] + 0.7231396289857297*b[i + 87*ldb] + -1.939864544376097*b[i + 88*ldb] + -5.06704059565454*b[i + 89*ldb]);
        c[i + 90*ldc] = (5.06704059565454*b[i + 90*ldb] + 1.939864544376097*b[i + 91*ldb] + -0.7231396289857297*b[i + 92*ldb] + 0.4937590750470338*b[i + 93*ldb] + -0.5517668509633159*b[i + 94*ldb]);
        c[i + 91*ldc] = (-3.812557894803954*b[i + 90*ldb] + 0.7583532171678757*b[i + 91*ldb] + 1.706075027753831*b[i + 92*ldb] + -0.9285580266438338*b[i + 93*ldb] + 0.9704208807564537*b[i + 94*ldb]);
        c[i + 92*ldc] = (1.684026960320175*b[i + 90*ldb] + -2.021528935875383*b[i + 91*ldb] + 2.021528935875383*b[i + 93*ldb] + -1.684026960320175*b[i + 94*ldb]);
        c[i + 93*ldc] = (-0.9704208807564537*b[i + 90*ldb] + 0.9285580266438338*b[i + 91*ldb] + -1.706075027753831*b[i + 92*ldb] + -0.7583532171678757*b[i + 93*ldb] + 3.812557894803954*b[i + 94*ldb]);
        c[i + 94*ldc] = (0.5517668509633159*b[i + 90*ldb] + -0.4937590750470338*b[i + 91*ldb] + 0.7231396289857297*b[i + 92*ldb] + -1.939864544376097*b[i + 93*ldb] + -5.06704059565454*b[i + 94*ldb]);
        c[i + 95*ldc] = (5.06704059565454*b[i + 95*ldb] + 1.939864544376097*b[i + 96*ldb] + -0.7231396289857297*b[i + 97*ldb] + 0.4937590750470338*b[i + 98*ldb] + -0.5517668509633159*b[i + 99*ldb]);
        c[i + 96*ldc] = (-3.812557894803954*b[i + 95*ldb] + 0.7583532171678757*b[i + 96*ldb] + 1.706075027753831*b[i + 97*ldb] + -0.9285580266438338*b[i + 98*ldb] + 0.9704208807564537*b[i + 99*ldb]);
        c[i + 97*ldc] = (1.684026960320175*b[i + 95*ldb] + -2.021528935875383*b[i + 96*ldb] + 2.021528935875383*b[i + 98*ldb] + -1.684026960320175*b[i + 99*ldb]);
        c[i + 98*ldc] = (-0.9704208807564537*b[i + 95*ldb] + 0.9285580266438338*b[i + 96*ldb] + -1.706075027753831*b[i + 97*ldb] + -0.7583532171678757*b[i + 98*ldb] + 3.812557894803954*b[i + 99*ldb]);
        c[i + 99*ldc] = (0.5517668509633159*b[i + 95*ldb] + -0.4937590750470338*b[i + 96*ldb] + 0.7231396289857297*b[i + 97*ldb] + -1.939864544376097*b[i + 98*ldb] + -5.06704059565454*b[i + 99*ldb]);
        c[i + 100*ldc] = (5.06704059565454*b[i + 100*ldb] + 1.939864544376097*b[i + 101*ldb] + -0.7231396289857297*b[i + 102*ldb] + 0.4937590750470338*b[i + 103*ldb] + -0.5517668509633159*b[i + 104*ldb]);
        c[i + 101*ldc] = (-3.812557894803954*b[i + 100*ldb] + 0.7583532171678757*b[i + 101*ldb] + 1.706075027753831*b[i + 102*ldb] + -0.9285580266438338*b[i + 103*ldb] + 0.9704208807564537*b[i + 104*ldb]);
        c[i + 102*ldc] = (1.684026960320175*b[i + 100*ldb] + -2.021528935875383*b[i + 101*ldb] + 2.021528935875383*b[i + 103*ldb] + -1.684026960320175*b[i + 104*ldb]);
        c[i + 103*ldc] = (-0.9704208807564537*b[i + 100*ldb] + 0.9285580266438338*b[i + 101*ldb] + -1.706075027753831*b[i + 102*ldb] + -0.7583532171678757*b[i + 103*ldb] + 3.812557894803954*b[i + 104*ldb]);
        c[i + 104*ldc] = (0.5517668509633159*b[i + 100*ldb] + -0.4937590750470338*b[i + 101*ldb] + 0.7231396289857297*b[i + 102*ldb] + -1.939864544376097*b[i + 103*ldb] + -5.06704059565454*b[i + 104*ldb]);
        c[i + 105*ldc] = (5.06704059565454*b[i + 105*ldb] + 1.939864544376097*b[i + 106*ldb] + -0.7231396289857297*b[i + 107*ldb] + 0.4937590750470338*b[i + 108*ldb] + -0.5517668509633159*b[i + 109*ldb]);
        c[i + 106*ldc] = (-3.812557894803954*b[i + 105*ldb] + 0.7583532171678757*b[i + 106*ldb] + 1.706075027753831*b[i + 107*ldb] + -0.9285580266438338*b[i + 108*ldb] + 0.9704208807564537*b[i + 109*ldb]);
        c[i + 107*ldc] = (1.684026960320175*b[i + 105*ldb] + -2.021528935875383*b[i + 106*ldb] + 2.021528935875383*b[i + 108*ldb] + -1.684026960320175*b[i + 109*ldb]);
        c[i + 108*ldc] = (-0.9704208807564537*b[i + 105*ldb] + 0.9285580266438338*b[i + 106*ldb] + -1.706075027753831*b[i + 107*ldb] + -0.7583532171678757*b[i + 108*ldb] + 3.812557894803954*b[i + 109*ldb]);
        c[i + 109*ldc] = (0.5517668509633159*b[i + 105*ldb] + -0.4937590750470338*b[i + 106*ldb] + 0.7231396289857297*b[i + 107*ldb] + -1.939864544376097*b[i + 108*ldb] + -5.06704059565454*b[i + 109*ldb]);
        c[i + 110*ldc] = (5.06704059565454*b[i + 110*ldb] + 1.939864544376097*b[i + 111*ldb] + -0.7231396289857297*b[i + 112*ldb] + 0.4937590750470338*b[i + 113*ldb] + -0.5517668509633159*b[i + 114*ldb]);
        c[i + 111*ldc] = (-3.812557894803954*b[i + 110*ldb] + 0.7583532171678757*b[i + 111*ldb] + 1.706075027753831*b[i + 112*ldb] + -0.9285580266438338*b[i + 113*ldb] + 0.9704208807564537*b[i + 114*ldb]);
        c[i + 112*ldc] = (1.684026960320175*b[i + 110*ldb] + -2.021528935875383*b[i + 111*ldb] + 2.021528935875383*b[i + 113*ldb] + -1.684026960320175*b[i + 114*ldb]);
        c[i + 113*ldc] = (-0.9704208807564537*b[i + 110*ldb] + 0.9285580266438338*b[i + 111*ldb] + -1.706075027753831*b[i + 112*ldb] + -0.7583532171678757*b[i + 113*ldb] + 3.812557894803954*b[i + 114*ldb]);
        c[i + 114*ldc] = (0.5517668509633159*b[i + 110*ldb] + -0.4937590750470338*b[i + 111*ldb] + 0.7231396289857297*b[i + 112*ldb] + -1.939864544376097*b[i + 113*ldb] + -5.06704059565454*b[i + 114*ldb]);
        c[i + 115*ldc] = (5.06704059565454*b[i + 115*ldb] + 1.939864544376097*b[i + 116*ldb] + -0.7231396289857297*b[i + 117*ldb] + 0.4937590750470338*b[i + 118*ldb] + -0.5517668509633159*b[i + 119*ldb]);
        c[i + 116*ldc] = (-3.812557894803954*b[i + 115*ldb] + 0.7583532171678757*b[i + 116*ldb] + 1.706075027753831*b[i + 117*ldb] + -0.9285580266438338*b[i + 118*ldb] + 0.9704208807564537*b[i + 119*ldb]);
        c[i + 117*ldc] = (1.684026960320175*b[i + 115*ldb] + -2.021528935875383*b[i + 116*ldb] + 2.021528935875383*b[i + 118*ldb] + -1.684026960320175*b[i + 119*ldb]);
        c[i + 118*ldc] = (-0.9704208807564537*b[i + 115*ldb] + 0.9285580266438338*b[i + 116*ldb] + -1.706075027753831*b[i + 117*ldb] + -0.7583532171678757*b[i + 118*ldb] + 3.812557894803954*b[i + 119*ldb]);
        c[i + 119*ldc] = (0.5517668509633159*b[i + 115*ldb] + -0.4937590750470338*b[i + 116*ldb] + 0.7231396289857297*b[i + 117*ldb] + -1.939864544376097*b[i + 118*ldb] + -5.06704059565454*b[i + 119*ldb]);
        c[i + 120*ldc] = (5.06704059565454*b[i + 120*ldb] + 1.939864544376097*b[i + 121*ldb] + -0.7231396289857297*b[i + 122*ldb] + 0.4937590750470338*b[i + 123*ldb] + -0.5517668509633159*b[i + 124*ldb]);
        c[i + 121*ldc] = (-3.812557894803954*b[i + 120*ldb] + 0.7583532171678757*b[i + 121*ldb] + 1.706075027753831*b[i + 122*ldb] + -0.9285580266438338*b[i + 123*ldb] + 0.9704208807564537*b[i + 124*ldb]);
        c[i + 122*ldc] = (1.684026960320175*b[i + 120*ldb] + -2.021528935875383*b[i + 121*ldb] + 2.021528935875383*b[i + 123*ldb] + -1.684026960320175*b[i + 124*ldb]);
        c[i + 123*ldc] = (-0.9704208807564537*b[i + 120*ldb] + 0.9285580266438338*b[i + 121*ldb] + -1.706075027753831*b[i + 122*ldb] + -0.7583532171678757*b[i + 123*ldb] + 3.812557894803954*b[i + 124*ldb]);
        c[i + 124*ldc] = (0.5517668509633159*b[i + 120*ldb] + -0.4937590750470338*b[i + 121*ldb] + 0.7231396289857297*b[i + 122*ldb] + -1.939864544376097*b[i + 123*ldb] + -5.06704059565454*b[i + 124*ldb]);
        c[i + 125*ldc] = (5.06704059565454*b[i + 0*ldb] + 1.939864544376097*b[i + 5*ldb] + -0.7231396289857297*b[i + 10*ldb] + 0.4937590750470338*b[i + 15*ldb] + -0.5517668509633159*b[i + 20*ldb]);
        c[i + 126*ldc] = (5.06704059565454*b[i + 1*ldb] + 1.939864544376097*b[i + 6*ldb] + -0.7231396289857297*b[i + 11*ldb] + 0.4937590750470338*b[i + 16*ldb] + -0.5517668509633159*b[i + 21*ldb]);
        c[i + 127*ldc] = (5.06704059565454*b[i + 2*ldb] + 1.939864544376097*b[i + 7*ldb] + -0.7231396289857297*b[i + 12*ldb] + 0.4937590750470338*b[i + 17*ldb] + -0.5517668509633159*b[i + 22*ldb]);
        c[i + 128*ldc] = (5.06704059565454*b[i + 3*ldb] + 1.939864544376097*b[i + 8*ldb] + -0.7231396289857297*b[i + 13*ldb] + 0.4937590750470338*b[i + 18*ldb] + -0.5517668509633159*b[i + 23*ldb]);
        c[i + 129*ldc] = (5.06704059565454*b[i + 4*ldb] + 1.939864544376097*b[i + 9*ldb] + -0.7231396289857297*b[i + 14*ldb] + 0.4937590750470338*b[i + 19*ldb] + -0.5517668509633159*b[i + 24*ldb]);
        c[i + 130*ldc] = (-3.812557894803954*b[i + 0*ldb] + 0.7583532171678757*b[i + 5*ldb] + 1.706075027753831*b[i + 10*ldb] + -0.9285580266438338*b[i + 15*ldb] + 0.9704208807564537*b[i + 20*ldb]);
        c[i + 131*ldc] = (-3.812557894803954*b[i + 1*ldb] + 0.7583532171678757*b[i + 6*ldb] + 1.706075027753831*b[i + 11*ldb] + -0.9285580266438338*b[i + 16*ldb] + 0.9704208807564537*b[i + 21*ldb]);
        c[i + 132*ldc] = (-3.812557894803954*b[i + 2*ldb] + 0.7583532171678757*b[i + 7*ldb] + 1.706075027753831*b[i + 12*ldb] + -0.9285580266438338*b[i + 17*ldb] + 0.9704208807564537*b[i + 22*ldb]);
        c[i + 133*ldc] = (-3.812557894803954*b[i + 3*ldb] + 0.7583532171678757*b[i + 8*ldb] + 1.706075027753831*b[i + 13*ldb] + -0.9285580266438338*b[i + 18*ldb] + 0.9704208807564537*b[i + 23*ldb]);
        c[i + 134*ldc] = (-3.812557894803954*b[i + 4*ldb] + 0.7583532171678757*b[i + 9*ldb] + 1.706075027753831*b[i + 14*ldb] + -0.9285580266438338*b[i + 19*ldb] + 0.9704208807564537*b[i + 24*ldb]);
        c[i + 135*ldc] = (1.684026960320175*b[i + 0*ldb] + -2.021528935875383*b[i + 5*ldb] + 2.021528935875383*b[i + 15*ldb] + -1.684026960320175*b[i + 20*ldb]);
        c[i + 136*ldc] = (1.684026960320175*b[i + 1*ldb] + -2.021528935875383*b[i + 6*ldb] + 2.021528935875383*b[i + 16*ldb] + -1.684026960320175*b[i + 21*ldb]);
        c[i + 137*ldc] = (1.684026960320175*b[i + 2*ldb] + -2.021528935875383*b[i + 7*ldb] + 2.021528935875383*b[i + 17*ldb] + -1.684026960320175*b[i + 22*ldb]);
        c[i + 138*ldc] = (1.684026960320175*b[i + 3*ldb] + -2.021528935875383*b[i + 8*ldb] + 2.021528935875383*b[i + 18*ldb] + -1.684026960320175*b[i + 23*ldb]);
        c[i + 139*ldc] = (1.684026960320175*b[i + 4*ldb] + -2.021528935875383*b[i + 9*ldb] + 2.021528935875383*b[i + 19*ldb] + -1.684026960320175*b[i + 24*ldb]);
        c[i + 140*ldc] = (-0.9704208807564537*b[i + 0*ldb] + 0.9285580266438338*b[i + 5*ldb] + -1.706075027753831*b[i + 10*ldb] + -0.7583532171678757*b[i + 15*ldb] + 3.812557894803954*b[i + 20*ldb]);
        c[i + 141*ldc] = (-0.9704208807564537*b[i + 1*ldb] + 0.9285580266438338*b[i + 6*ldb] + -1.706075027753831*b[i + 11*ldb] + -0.7583532171678757*b[i + 16*ldb] + 3.812557894803954*b[i + 21*ldb]);
        c[i + 142*ldc] = (-0.9704208807564537*b[i + 2*ldb] + 0.9285580266438338*b[i + 7*ldb] + -1.706075027753831*b[i + 12*ldb] + -0.7583532171678757*b[i + 17*ldb] + 3.812557894803954*b[i + 22*ldb]);
        c[i + 143*ldc] = (-0.9704208807564537*b[i + 3*ldb] + 0.9285580266438338*b[i + 8*ldb] + -1.706075027753831*b[i + 13*ldb] + -0.7583532171678757*b[i + 18*ldb] + 3.812557894803954*b[i + 23*ldb]);
        c[i + 144*ldc] = (-0.9704208807564537*b[i + 4*ldb] + 0.9285580266438338*b[i + 9*ldb] + -1.706075027753831*b[i + 14*ldb] + -0.7583532171678757*b[i + 19*ldb] + 3.812557894803954*b[i + 24*ldb]);
        c[i + 145*ldc] = (0.5517668509633159*b[i + 0*ldb] + -0.4937590750470338*b[i + 5*ldb] + 0.7231396289857297*b[i + 10*ldb] + -1.939864544376097*b[i + 15*ldb] + -5.06704059565454*b[i + 20*ldb]);
        c[i + 146*ldc] = (0.5517668509633159*b[i + 1*ldb] + -0.4937590750470338*b[i + 6*ldb] + 0.7231396289857297*b[i + 11*ldb] + -1.939864544376097*b[i + 16*ldb] + -5.06704059565454*b[i + 21*ldb]);
        c[i + 147*ldc] = (0.5517668509633159*b[i + 2*ldb] + -0.4937590750470338*b[i + 7*ldb] + 0.7231396289857297*b[i + 12*ldb] + -1.939864544376097*b[i + 17*ldb] + -5.06704059565454*b[i + 22*ldb]);
        c[i + 148*ldc] = (0.5517668509633159*b[i + 3*ldb] + -0.4937590750470338*b[i + 8*ldb] + 0.7231396289857297*b[i + 13*ldb] + -1.939864544376097*b[i + 18*ldb] + -5.06704059565454*b[i + 23*ldb]);
        c[i + 149*ldc] = (0.5517668509633159*b[i + 4*ldb] + -0.4937590750470338*b[i + 9*ldb] + 0.7231396289857297*b[i + 14*ldb] + -1.939864544376097*b[i + 19*ldb] + -5.06704059565454*b[i + 24*ldb]);
        c[i + 150*ldc] = (5.06704059565454*b[i + 25*ldb] + 1.939864544376097*b[i + 30*ldb] + -0.7231396289857297*b[i + 35*ldb] + 0.4937590750470338*b[i + 40*ldb] + -0.5517668509633159*b[i + 45*ldb]);
        c[i + 151*ldc] = (5.06704059565454*b[i + 26*ldb] + 1.939864544376097*b[i + 31*ldb] + -0.7231396289857297*b[i + 36*ldb] + 0.4937590750470338*b[i + 41*ldb] + -0.5517668509633159*b[i + 46*ldb]);
        c[i + 152*ldc] = (5.06704059565454*b[i + 27*ldb] + 1.939864544376097*b[i + 32*ldb] + -0.7231396289857297*b[i + 37*ldb] + 0.4937590750470338*b[i + 42*ldb] + -0.5517668509633159*b[i + 47*ldb]);
        c[i + 153*ldc] = (5.06704059565454*b[i + 28*ldb] + 1.939864544376097*b[i + 33*ldb] + -0.7231396289857297*b[i + 38*ldb] + 0.4937590750470338*b[i + 43*ldb] + -0.5517668509633159*b[i + 48*ldb]);
        c[i + 154*ldc] = (5.06704059565454*b[i + 29*ldb] + 1.939864544376097*b[i + 34*ldb] + -0.7231396289857297*b[i + 39*ldb] + 0.4937590750470338*b[i + 44*ldb] + -0.5517668509633159*b[i + 49*ldb]);
        c[i + 155*ldc] = (-3.812557894803954*b[i + 25*ldb] + 0.7583532171678757*b[i + 30*ldb] + 1.706075027753831*b[i + 35*ldb] + -0.9285580266438338*b[i + 40*ldb] + 0.9704208807564537*b[i + 45*ldb]);
        c[i + 156*ldc] = (-3.812557894803954*b[i + 26*ldb] + 0.7583532171678757*b[i + 31*ldb] + 1.706075027753831*b[i + 36*ldb] + -0.9285580266438338*b[i + 41*ldb] + 0.9704208807564537*b[i + 46*ldb]);
        c[i + 157*ldc] = (-3.812557894803954*b[i + 27*ldb] + 0.7583532171678757*b[i + 32*ldb] + 1.706075027753831*b[i + 37*ldb] + -0.9285580266438338*b[i + 42*ldb] + 0.9704208807564537*b[i + 47*ldb]);
        c[i + 158*ldc] = (-3.812557894803954*b[i + 28*ldb] + 0.7583532171678757*b[i + 33*ldb] + 1.706075027753831*b[i + 38*ldb] + -0.9285580266438338*b[i + 43*ldb] + 0.9704208807564537*b[i + 48*ldb]);
        c[i + 159*ldc] = (-3.812557894803954*b[i + 29*ldb] + 0.7583532171678757*b[i + 34*ldb] + 1.706075027753831*b[i + 39*ldb] + -0.9285580266438338*b[i + 44*ldb] + 0.9704208807564537*b[i + 49*ldb]);
        c[i + 160*ldc] = (1.684026960320175*b[i + 25*ldb] + -2.021528935875383*b[i + 30*ldb] + 2.021528935875383*b[i + 40*ldb] + -1.684026960320175*b[i + 45*ldb]);
        c[i + 161*ldc] = (1.684026960320175*b[i + 26*ldb] + -2.021528935875383*b[i + 31*ldb] + 2.021528935875383*b[i + 41*ldb] + -1.684026960320175*b[i + 46*ldb]);
        c[i + 162*ldc] = (1.684026960320175*b[i + 27*ldb] + -2.021528935875383*b[i + 32*ldb] + 2.021528935875383*b[i + 42*ldb] + -1.684026960320175*b[i + 47*ldb]);
        c[i + 163*ldc] = (1.684026960320175*b[i + 28*ldb] + -2.021528935875383*b[i + 33*ldb] + 2.021528935875383*b[i + 43*ldb] + -1.684026960320175*b[i + 48*ldb]);
        c[i + 164*ldc] = (1.684026960320175*b[i + 29*ldb] + -2.021528935875383*b[i + 34*ldb] + 2.021528935875383*b[i + 44*ldb] + -1.684026960320175*b[i + 49*ldb]);
        c[i + 165*ldc] = (-0.9704208807564537*b[i + 25*ldb] + 0.9285580266438338*b[i + 30*ldb] + -1.706075027753831*b[i + 35*ldb] + -0.7583532171678757*b[i + 40*ldb] + 3.812557894803954*b[i + 45*ldb]);
        c[i + 166*ldc] = (-0.9704208807564537*b[i + 26*ldb] + 0.9285580266438338*b[i + 31*ldb] + -1.706075027753831*b[i + 36*ldb] + -0.7583532171678757*b[i + 41*ldb] + 3.812557894803954*b[i + 46*ldb]);
        c[i + 167*ldc] = (-0.9704208807564537*b[i + 27*ldb] + 0.9285580266438338*b[i + 32*ldb] + -1.706075027753831*b[i + 37*ldb] + -0.7583532171678757*b[i + 42*ldb] + 3.812557894803954*b[i + 47*ldb]);
        c[i + 168*ldc] = (-0.9704208807564537*b[i + 28*ldb] + 0.9285580266438338*b[i + 33*ldb] + -1.706075027753831*b[i + 38*ldb] + -0.7583532171678757*b[i + 43*ldb] + 3.812557894803954*b[i + 48*ldb]);
        c[i + 169*ldc] = (-0.9704208807564537*b[i + 29*ldb] + 0.9285580266438338*b[i + 34*ldb] + -1.706075027753831*b[i + 39*ldb] + -0.7583532171678757*b[i + 44*ldb] + 3.812557894803954*b[i + 49*ldb]);
        c[i + 170*ldc] = (0.5517668509633159*b[i + 25*ldb] + -0.4937590750470338*b[i + 30*ldb] + 0.7231396289857297*b[i + 35*ldb] + -1.939864544376097*b[i + 40*ldb] + -5.06704059565454*b[i + 45*ldb]);
        c[i + 171*ldc] = (0.5517668509633159*b[i + 26*ldb] + -0.4937590750470338*b[i + 31*ldb] + 0.7231396289857297*b[i + 36*ldb] + -1.939864544376097*b[i + 41*ldb] + -5.06704059565454*b[i + 46*ldb]);
        c[i + 172*ldc] = (0.5517668509633159*b[i + 27*ldb] + -0.4937590750470338*b[i + 32*ldb] + 0.7231396289857297*b[i + 37*ldb] + -1.939864544376097*b[i + 42*ldb] + -5.06704059565454*b[i + 47*ldb]);
        c[i + 173*ldc] = (0.5517668509633159*b[i + 28*ldb] + -0.4937590750470338*b[i + 33*ldb] + 0.7231396289857297*b[i + 38*ldb] + -1.939864544376097*b[i + 43*ldb] + -5.06704059565454*b[i + 48*ldb]);
        c[i + 174*ldc] = (0.5517668509633159*b[i + 29*ldb] + -0.4937590750470338*b[i + 34*ldb] + 0.7231396289857297*b[i + 39*ldb] + -1.939864544376097*b[i + 44*ldb] + -5.06704059565454*b[i + 49*ldb]);
        c[i + 175*ldc] = (5.06704059565454*b[i + 50*ldb] + 1.939864544376097*b[i + 55*ldb] + -0.7231396289857297*b[i + 60*ldb] + 0.4937590750470338*b[i + 65*ldb] + -0.5517668509633159*b[i + 70*ldb]);
        c[i + 176*ldc] = (5.06704059565454*b[i + 51*ldb] + 1.939864544376097*b[i + 56*ldb] + -0.7231396289857297*b[i + 61*ldb] + 0.4937590750470338*b[i + 66*ldb] + -0.5517668509633159*b[i + 71*ldb]);
        c[i + 177*ldc] = (5.06704059565454*b[i + 52*ldb] + 1.939864544376097*b[i + 57*ldb] + -0.7231396289857297*b[i + 62*ldb] + 0.4937590750470338*b[i + 67*ldb] + -0.5517668509633159*b[i + 72*ldb]);
        c[i + 178*ldc] = (5.06704059565454*b[i + 53*ldb] + 1.939864544376097*b[i + 58*ldb] + -0.7231396289857297*b[i + 63*ldb] + 0.4937590750470338*b[i + 68*ldb] + -0.5517668509633159*b[i + 73*ldb]);
        c[i + 179*ldc] = (5.06704059565454*b[i + 54*ldb] + 1.939864544376097*b[i + 59*ldb] + -0.7231396289857297*b[i + 64*ldb] + 0.4937590750470338*b[i + 69*ldb] + -0.5517668509633159*b[i + 74*ldb]);
        c[i + 180*ldc] = (-3.812557894803954*b[i + 50*ldb] + 0.7583532171678757*b[i + 55*ldb] + 1.706075027753831*b[i + 60*ldb] + -0.9285580266438338*b[i + 65*ldb] + 0.9704208807564537*b[i + 70*ldb]);
        c[i + 181*ldc] = (-3.812557894803954*b[i + 51*ldb] + 0.7583532171678757*b[i + 56*ldb] + 1.706075027753831*b[i + 61*ldb] + -0.9285580266438338*b[i + 66*ldb] + 0.9704208807564537*b[i + 71*ldb]);
        c[i + 182*ldc] = (-3.812557894803954*b[i + 52*ldb] + 0.7583532171678757*b[i + 57*ldb] + 1.706075027753831*b[i + 62*ldb] + -0.9285580266438338*b[i + 67*ldb] + 0.9704208807564537*b[i + 72*ldb]);
        c[i + 183*ldc] = (-3.812557894803954*b[i + 53*ldb] + 0.7583532171678757*b[i + 58*ldb] + 1.706075027753831*b[i + 63*ldb] + -0.9285580266438338*b[i + 68*ldb] + 0.9704208807564537*b[i + 73*ldb]);
        c[i + 184*ldc] = (-3.812557894803954*b[i + 54*ldb] + 0.7583532171678757*b[i + 59*ldb] + 1.706075027753831*b[i + 64*ldb] + -0.9285580266438338*b[i + 69*ldb] + 0.9704208807564537*b[i + 74*ldb]);
        c[i + 185*ldc] = (1.684026960320175*b[i + 50*ldb] + -2.021528935875383*b[i + 55*ldb] + 2.021528935875383*b[i + 65*ldb] + -1.684026960320175*b[i + 70*ldb]);
        c[i + 186*ldc] = (1.684026960320175*b[i + 51*ldb] + -2.021528935875383*b[i + 56*ldb] + 2.021528935875383*b[i + 66*ldb] + -1.684026960320175*b[i + 71*ldb]);
        c[i + 187*ldc] = (1.684026960320175*b[i + 52*ldb] + -2.021528935875383*b[i + 57*ldb] + 2.021528935875383*b[i + 67*ldb] + -1.684026960320175*b[i + 72*ldb]);
        c[i + 188*ldc] = (1.684026960320175*b[i + 53*ldb] + -2.021528935875383*b[i + 58*ldb] + 2.021528935875383*b[i + 68*ldb] + -1.684026960320175*b[i + 73*ldb]);
        c[i + 189*ldc] = (1.684026960320175*b[i + 54*ldb] + -2.021528935875383*b[i + 59*ldb] + 2.021528935875383*b[i + 69*ldb] + -1.684026960320175*b[i + 74*ldb]);
        c[i + 190*ldc] = (-0.9704208807564537*b[i + 50*ldb] + 0.9285580266438338*b[i + 55*ldb] + -1.706075027753831*b[i + 60*ldb] + -0.7583532171678757*b[i + 65*ldb] + 3.812557894803954*b[i + 70*ldb]);
        c[i + 191*ldc] = (-0.9704208807564537*b[i + 51*ldb] + 0.9285580266438338*b[i + 56*ldb] + -1.706075027753831*b[i + 61*ldb] + -0.7583532171678757*b[i + 66*ldb] + 3.812557894803954*b[i + 71*ldb]);
        c[i + 192*ldc] = (-0.9704208807564537*b[i + 52*ldb] + 0.9285580266438338*b[i + 57*ldb] + -1.706075027753831*b[i + 62*ldb] + -0.7583532171678757*b[i + 67*ldb] + 3.812557894803954*b[i + 72*ldb]);
        c[i + 193*ldc] = (-0.9704208807564537*b[i + 53*ldb] + 0.9285580266438338*b[i + 58*ldb] + -1.706075027753831*b[i + 63*ldb] + -0.7583532171678757*b[i + 68*ldb] + 3.812557894803954*b[i + 73*ldb]);
        c[i + 194*ldc] = (-0.9704208807564537*b[i + 54*ldb] + 0.9285580266438338*b[i + 59*ldb] + -1.706075027753831*b[i + 64*ldb] + -0.7583532171678757*b[i + 69*ldb] + 3.812557894803954*b[i + 74*ldb]);
        c[i + 195*ldc] = (0.5517668509633159*b[i + 50*ldb] + -0.4937590750470338*b[i + 55*ldb] + 0.7231396289857297*b[i + 60*ldb] + -1.939864544376097*b[i + 65*ldb] + -5.06704059565454*b[i + 70*ldb]);
        c[i + 196*ldc] = (0.5517668509633159*b[i + 51*ldb] + -0.4937590750470338*b[i + 56*ldb] + 0.7231396289857297*b[i + 61*ldb] + -1.939864544376097*b[i + 66*ldb] + -5.06704059565454*b[i + 71*ldb]);
        c[i + 197*ldc] = (0.5517668509633159*b[i + 52*ldb] + -0.4937590750470338*b[i + 57*ldb] + 0.7231396289857297*b[i + 62*ldb] + -1.939864544376097*b[i + 67*ldb] + -5.06704059565454*b[i + 72*ldb]);
        c[i + 198*ldc] = (0.5517668509633159*b[i + 53*ldb] + -0.4937590750470338*b[i + 58*ldb] + 0.7231396289857297*b[i + 63*ldb] + -1.939864544376097*b[i + 68*ldb] + -5.06704059565454*b[i + 73*ldb]);
        c[i + 199*ldc] = (0.5517668509633159*b[i + 54*ldb] + -0.4937590750470338*b[i + 59*ldb] + 0.7231396289857297*b[i + 64*ldb] + -1.939864544376097*b[i + 69*ldb] + -5.06704059565454*b[i + 74*ldb]);
        c[i + 200*ldc] = (5.06704059565454*b[i + 75*ldb] + 1.939864544376097*b[i + 80*ldb] + -0.7231396289857297*b[i + 85*ldb] + 0.4937590750470338*b[i + 90*ldb] + -0.5517668509633159*b[i + 95*ldb]);
        c[i + 201*ldc] = (5.06704059565454*b[i + 76*ldb] + 1.939864544376097*b[i + 81*ldb] + -0.7231396289857297*b[i + 86*ldb] + 0.4937590750470338*b[i + 91*ldb] + -0.5517668509633159*b[i + 96*ldb]);
        c[i + 202*ldc] = (5.06704059565454*b[i + 77*ldb] + 1.939864544376097*b[i + 82*ldb] + -0.7231396289857297*b[i + 87*ldb] + 0.4937590750470338*b[i + 92*ldb] + -0.5517668509633159*b[i + 97*ldb]);
        c[i + 203*ldc] = (5.06704059565454*b[i + 78*ldb] + 1.939864544376097*b[i + 83*ldb] + -0.7231396289857297*b[i + 88*ldb] + 0.4937590750470338*b[i + 93*ldb] + -0.5517668509633159*b[i + 98*ldb]);
        c[i + 204*ldc] = (5.06704059565454*b[i + 79*ldb] + 1.939864544376097*b[i + 84*ldb] + -0.7231396289857297*b[i + 89*ldb] + 0.4937590750470338*b[i + 94*ldb] + -0.5517668509633159*b[i + 99*ldb]);
        c[i + 205*ldc] = (-3.812557894803954*b[i + 75*ldb] + 0.7583532171678757*b[i + 80*ldb] + 1.706075027753831*b[i + 85*ldb] + -0.9285580266438338*b[i + 90*ldb] + 0.9704208807564537*b[i + 95*ldb]);
        c[i + 206*ldc] = (-3.812557894803954*b[i + 76*ldb] + 0.7583532171678757*b[i + 81*ldb] + 1.706075027753831*b[i + 86*ldb] + -0.9285580266438338*b[i + 91*ldb] + 0.9704208807564537*b[i + 96*ldb]);
        c[i + 207*ldc] = (-3.812557894803954*b[i + 77*ldb] + 0.7583532171678757*b[i + 82*ldb] + 1.706075027753831*b[i + 87*ldb] + -0.9285580266438338*b[i + 92*ldb] + 0.9704208807564537*b[i + 97*ldb]);
        c[i + 208*ldc] = (-3.812557894803954*b[i + 78*ldb] + 0.7583532171678757*b[i + 83*ldb] + 1.706075027753831*b[i + 88*ldb] + -0.9285580266438338*b[i + 93*ldb] + 0.9704208807564537*b[i + 98*ldb]);
        c[i + 209*ldc] = (-3.812557894803954*b[i + 79*ldb] + 0.7583532171678757*b[i + 84*ldb] + 1.706075027753831*b[i + 89*ldb] + -0.9285580266438338*b[i + 94*ldb] + 0.9704208807564537*b[i + 99*ldb]);
        c[i + 210*ldc] = (1.684026960320175*b[i + 75*ldb] + -2.021528935875383*b[i + 80*ldb] + 2.021528935875383*b[i + 90*ldb] + -1.684026960320175*b[i + 95*ldb]);
        c[i + 211*ldc] = (1.684026960320175*b[i + 76*ldb] + -2.021528935875383*b[i + 81*ldb] + 2.021528935875383*b[i + 91*ldb] + -1.684026960320175*b[i + 96*ldb]);
        c[i + 212*ldc] = (1.684026960320175*b[i + 77*ldb] + -2.021528935875383*b[i + 82*ldb] + 2.021528935875383*b[i + 92*ldb] + -1.684026960320175*b[i + 97*ldb]);
        c[i + 213*ldc] = (1.684026960320175*b[i + 78*ldb] + -2.021528935875383*b[i + 83*ldb] + 2.021528935875383*b[i + 93*ldb] + -1.684026960320175*b[i + 98*ldb]);
        c[i + 214*ldc] = (1.684026960320175*b[i + 79*ldb] + -2.021528935875383*b[i + 84*ldb] + 2.021528935875383*b[i + 94*ldb] + -1.684026960320175*b[i + 99*ldb]);
        c[i + 215*ldc] = (-0.9704208807564537*b[i + 75*ldb] + 0.9285580266438338*b[i + 80*ldb] + -1.706075027753831*b[i + 85*ldb] + -0.7583532171678757*b[i + 90*ldb] + 3.812557894803954*b[i + 95*ldb]);
        c[i + 216*ldc] = (-0.9704208807564537*b[i + 76*ldb] + 0.9285580266438338*b[i + 81*ldb] + -1.706075027753831*b[i + 86*ldb] + -0.7583532171678757*b[i + 91*ldb] + 3.812557894803954*b[i + 96*ldb]);
        c[i + 217*ldc] = (-0.9704208807564537*b[i + 77*ldb] + 0.9285580266438338*b[i + 82*ldb] + -1.706075027753831*b[i + 87*ldb] + -0.7583532171678757*b[i + 92*ldb] + 3.812557894803954*b[i + 97*ldb]);
        c[i + 218*ldc] = (-0.9704208807564537*b[i + 78*ldb] + 0.9285580266438338*b[i + 83*ldb] + -1.706075027753831*b[i + 88*ldb] + -0.7583532171678757*b[i + 93*ldb] + 3.812557894803954*b[i + 98*ldb]);
        c[i + 219*ldc] = (-0.9704208807564537*b[i + 79*ldb] + 0.9285580266438338*b[i + 84*ldb] + -1.706075027753831*b[i + 89*ldb] + -0.7583532171678757*b[i + 94*ldb] + 3.812557894803954*b[i + 99*ldb]);
        c[i + 220*ldc] = (0.5517668509633159*b[i + 75*ldb] + -0.4937590750470338*b[i + 80*ldb] + 0.7231396289857297*b[i + 85*ldb] + -1.939864544376097*b[i + 90*ldb] + -5.06704059565454*b[i + 95*ldb]);
        c[i + 221*ldc] = (0.5517668509633159*b[i + 76*ldb] + -0.4937590750470338*b[i + 81*ldb] + 0.7231396289857297*b[i + 86*ldb] + -1.939864544376097*b[i + 91*ldb] + -5.06704059565454*b[i + 96*ldb]);
        c[i + 222*ldc] = (0.5517668509633159*b[i + 77*ldb] + -0.4937590750470338*b[i + 82*ldb] + 0.7231396289857297*b[i + 87*ldb] + -1.939864544376097*b[i + 92*ldb] + -5.06704059565454*b[i + 97*ldb]);
        c[i + 223*ldc] = (0.5517668509633159*b[i + 78*ldb] + -0.4937590750470338*b[i + 83*ldb] + 0.7231396289857297*b[i + 88*ldb] + -1.939864544376097*b[i + 93*ldb] + -5.06704059565454*b[i + 98*ldb]);
        c[i + 224*ldc] = (0.5517668509633159*b[i + 79*ldb] + -0.4937590750470338*b[i + 84*ldb] + 0.7231396289857297*b[i + 89*ldb] + -1.939864544376097*b[i + 94*ldb] + -5.06704059565454*b[i + 99*ldb]);
        c[i + 225*ldc] = (5.06704059565454*b[i + 100*ldb] + 1.939864544376097*b[i + 105*ldb] + -0.7231396289857297*b[i + 110*ldb] + 0.4937590750470338*b[i + 115*ldb] + -0.5517668509633159*b[i + 120*ldb]);
        c[i + 226*ldc] = (5.06704059565454*b[i + 101*ldb] + 1.939864544376097*b[i + 106*ldb] + -0.7231396289857297*b[i + 111*ldb] + 0.4937590750470338*b[i + 116*ldb] + -0.5517668509633159*b[i + 121*ldb]);
        c[i + 227*ldc] = (5.06704059565454*b[i + 102*ldb] + 1.939864544376097*b[i + 107*ldb] + -0.7231396289857297*b[i + 112*ldb] + 0.4937590750470338*b[i + 117*ldb] + -0.5517668509633159*b[i + 122*ldb]);
        c[i + 228*ldc] = (5.06704059565454*b[i + 103*ldb] + 1.939864544376097*b[i + 108*ldb] + -0.7231396289857297*b[i + 113*ldb] + 0.4937590750470338*b[i + 118*ldb] + -0.5517668509633159*b[i + 123*ldb]);
        c[i + 229*ldc] = (5.06704059565454*b[i + 104*ldb] + 1.939864544376097*b[i + 109*ldb] + -0.7231396289857297*b[i + 114*ldb] + 0.4937590750470338*b[i + 119*ldb] + -0.5517668509633159*b[i + 124*ldb]);
        c[i + 230*ldc] = (-3.812557894803954*b[i + 100*ldb] + 0.7583532171678757*b[i + 105*ldb] + 1.706075027753831*b[i + 110*ldb] + -0.9285580266438338*b[i + 115*ldb] + 0.9704208807564537*b[i + 120*ldb]);
        c[i + 231*ldc] = (-3.812557894803954*b[i + 101*ldb] + 0.7583532171678757*b[i + 106*ldb] + 1.706075027753831*b[i + 111*ldb] + -0.9285580266438338*b[i + 116*ldb] + 0.9704208807564537*b[i + 121*ldb]);
        c[i + 232*ldc] = (-3.812557894803954*b[i + 102*ldb] + 0.7583532171678757*b[i + 107*ldb] + 1.706075027753831*b[i + 112*ldb] + -0.9285580266438338*b[i + 117*ldb] + 0.9704208807564537*b[i + 122*ldb]);
        c[i + 233*ldc] = (-3.812557894803954*b[i + 103*ldb] + 0.7583532171678757*b[i + 108*ldb] + 1.706075027753831*b[i + 113*ldb] + -0.9285580266438338*b[i + 118*ldb] + 0.9704208807564537*b[i + 123*ldb]);
        c[i + 234*ldc] = (-3.812557894803954*b[i + 104*ldb] + 0.7583532171678757*b[i + 109*ldb] + 1.706075027753831*b[i + 114*ldb] + -0.9285580266438338*b[i + 119*ldb] + 0.9704208807564537*b[i + 124*ldb]);
        c[i + 235*ldc] = (1.684026960320175*b[i + 100*ldb] + -2.021528935875383*b[i + 105*ldb] + 2.021528935875383*b[i + 115*ldb] + -1.684026960320175*b[i + 120*ldb]);
        c[i + 236*ldc] = (1.684026960320175*b[i + 101*ldb] + -2.021528935875383*b[i + 106*ldb] + 2.021528935875383*b[i + 116*ldb] + -1.684026960320175*b[i + 121*ldb]);
        c[i + 237*ldc] = (1.684026960320175*b[i + 102*ldb] + -2.021528935875383*b[i + 107*ldb] + 2.021528935875383*b[i + 117*ldb] + -1.684026960320175*b[i + 122*ldb]);
        c[i + 238*ldc] = (1.684026960320175*b[i + 103*ldb] + -2.021528935875383*b[i + 108*ldb] + 2.021528935875383*b[i + 118*ldb] + -1.684026960320175*b[i + 123*ldb]);
        c[i + 239*ldc] = (1.684026960320175*b[i + 104*ldb] + -2.021528935875383*b[i + 109*ldb] + 2.021528935875383*b[i + 119*ldb] + -1.684026960320175*b[i + 124*ldb]);
        c[i + 240*ldc] = (-0.9704208807564537*b[i + 100*ldb] + 0.9285580266438338*b[i + 105*ldb] + -1.706075027753831*b[i + 110*ldb] + -0.7583532171678757*b[i + 115*ldb] + 3.812557894803954*b[i + 120*ldb]);
        c[i + 241*ldc] = (-0.9704208807564537*b[i + 101*ldb] + 0.9285580266438338*b[i + 106*ldb] + -1.706075027753831*b[i + 111*ldb] + -0.7583532171678757*b[i + 116*ldb] + 3.812557894803954*b[i + 121*ldb]);
        c[i + 242*ldc] = (-0.9704208807564537*b[i + 102*ldb] + 0.9285580266438338*b[i + 107*ldb] + -1.706075027753831*b[i + 112*ldb] + -0.7583532171678757*b[i + 117*ldb] + 3.812557894803954*b[i + 122*ldb]);
        c[i + 243*ldc] = (-0.9704208807564537*b[i + 103*ldb] + 0.9285580266438338*b[i + 108*ldb] + -1.706075027753831*b[i + 113*ldb] + -0.7583532171678757*b[i + 118*ldb] + 3.812557894803954*b[i + 123*ldb]);
        c[i + 244*ldc] = (-0.9704208807564537*b[i + 104*ldb] + 0.9285580266438338*b[i + 109*ldb] + -1.706075027753831*b[i + 114*ldb] + -0.7583532171678757*b[i + 119*ldb] + 3.812557894803954*b[i + 124*ldb]);
        c[i + 245*ldc] = (0.5517668509633159*b[i + 100*ldb] + -0.4937590750470338*b[i + 105*ldb] + 0.7231396289857297*b[i + 110*ldb] + -1.939864544376097*b[i + 115*ldb] + -5.06704059565454*b[i + 120*ldb]);
        c[i + 246*ldc] = (0.5517668509633159*b[i + 101*ldb] + -0.4937590750470338*b[i + 106*ldb] + 0.7231396289857297*b[i + 111*ldb] + -1.939864544376097*b[i + 116*ldb] + -5.06704059565454*b[i + 121*ldb]);
        c[i + 247*ldc] = (0.5517668509633159*b[i + 102*ldb] + -0.4937590750470338*b[i + 107*ldb] + 0.7231396289857297*b[i + 112*ldb] + -1.939864544376097*b[i + 117*ldb] + -5.06704059565454*b[i + 122*ldb]);
        c[i + 248*ldc] = (0.5517668509633159*b[i + 103*ldb] + -0.4937590750470338*b[i + 108*ldb] + 0.7231396289857297*b[i + 113*ldb] + -1.939864544376097*b[i + 118*ldb] + -5.06704059565454*b[i + 123*ldb]);
        c[i + 249*ldc] = (0.5517668509633159*b[i + 104*ldb] + -0.4937590750470338*b[i + 109*ldb] + 0.7231396289857297*b[i + 114*ldb] + -1.939864544376097*b[i + 119*ldb] + -5.06704059565454*b[i + 124*ldb]);
        c[i + 250*ldc] = (5.06704059565454*b[i + 0*ldb] + 1.939864544376097*b[i + 25*ldb] + -0.7231396289857297*b[i + 50*ldb] + 0.4937590750470338*b[i + 75*ldb] + -0.5517668509633159*b[i + 100*ldb]);
        c[i + 251*ldc] = (5.06704059565454*b[i + 1*ldb] + 1.939864544376097*b[i + 26*ldb] + -0.7231396289857297*b[i + 51*ldb] + 0.4937590750470338*b[i + 76*ldb] + -0.5517668509633159*b[i + 101*ldb]);
        c[i + 252*ldc] = (5.06704059565454*b[i + 2*ldb] + 1.939864544376097*b[i + 27*ldb] + -0.7231396289857297*b[i + 52*ldb] + 0.4937590750470338*b[i + 77*ldb] + -0.5517668509633159*b[i + 102*ldb]);
        c[i + 253*ldc] = (5.06704059565454*b[i + 3*ldb] + 1.939864544376097*b[i + 28*ldb] + -0.7231396289857297*b[i + 53*ldb] + 0.4937590750470338*b[i + 78*ldb] + -0.5517668509633159*b[i + 103*ldb]);
        c[i + 254*ldc] = (5.06704059565454*b[i + 4*ldb] + 1.939864544376097*b[i + 29*ldb] + -0.7231396289857297*b[i + 54*ldb] + 0.4937590750470338*b[i + 79*ldb] + -0.5517668509633159*b[i + 104*ldb]);
        c[i + 255*ldc] = (5.06704059565454*b[i + 5*ldb] + 1.939864544376097*b[i + 30*ldb] + -0.7231396289857297*b[i + 55*ldb] + 0.4937590750470338*b[i + 80*ldb] + -0.5517668509633159*b[i + 105*ldb]);
        c[i + 256*ldc] = (5.06704059565454*b[i + 6*ldb] + 1.939864544376097*b[i + 31*ldb] + -0.7231396289857297*b[i + 56*ldb] + 0.4937590750470338*b[i + 81*ldb] + -0.5517668509633159*b[i + 106*ldb]);
        c[i + 257*ldc] = (5.06704059565454*b[i + 7*ldb] + 1.939864544376097*b[i + 32*ldb] + -0.7231396289857297*b[i + 57*ldb] + 0.4937590750470338*b[i + 82*ldb] + -0.5517668509633159*b[i + 107*ldb]);
        c[i + 258*ldc] = (5.06704059565454*b[i + 8*ldb] + 1.939864544376097*b[i + 33*ldb] + -0.7231396289857297*b[i + 58*ldb] + 0.4937590750470338*b[i + 83*ldb] + -0.5517668509633159*b[i + 108*ldb]);
        c[i + 259*ldc] = (5.06704059565454*b[i + 9*ldb] + 1.939864544376097*b[i + 34*ldb] + -0.7231396289857297*b[i + 59*ldb] + 0.4937590750470338*b[i + 84*ldb] + -0.5517668509633159*b[i + 109*ldb]);
        c[i + 260*ldc] = (5.06704059565454*b[i + 10*ldb] + 1.939864544376097*b[i + 35*ldb] + -0.7231396289857297*b[i + 60*ldb] + 0.4937590750470338*b[i + 85*ldb] + -0.5517668509633159*b[i + 110*ldb]);
        c[i + 261*ldc] = (5.06704059565454*b[i + 11*ldb] + 1.939864544376097*b[i + 36*ldb] + -0.7231396289857297*b[i + 61*ldb] + 0.4937590750470338*b[i + 86*ldb] + -0.5517668509633159*b[i + 111*ldb]);
        c[i + 262*ldc] = (5.06704059565454*b[i + 12*ldb] + 1.939864544376097*b[i + 37*ldb] + -0.7231396289857297*b[i + 62*ldb] + 0.4937590750470338*b[i + 87*ldb] + -0.5517668509633159*b[i + 112*ldb]);
        c[i + 263*ldc] = (5.06704059565454*b[i + 13*ldb] + 1.939864544376097*b[i + 38*ldb] + -0.7231396289857297*b[i + 63*ldb] + 0.4937590750470338*b[i + 88*ldb] + -0.5517668509633159*b[i + 113*ldb]);
        c[i + 264*ldc] = (5.06704059565454*b[i + 14*ldb] + 1.939864544376097*b[i + 39*ldb] + -0.7231396289857297*b[i + 64*ldb] + 0.4937590750470338*b[i + 89*ldb] + -0.5517668509633159*b[i + 114*ldb]);
        c[i + 265*ldc] = (5.06704059565454*b[i + 15*ldb] + 1.939864544376097*b[i + 40*ldb] + -0.7231396289857297*b[i + 65*ldb] + 0.4937590750470338*b[i + 90*ldb] + -0.5517668509633159*b[i + 115*ldb]);
        c[i + 266*ldc] = (5.06704059565454*b[i + 16*ldb] + 1.939864544376097*b[i + 41*ldb] + -0.7231396289857297*b[i + 66*ldb] + 0.4937590750470338*b[i + 91*ldb] + -0.5517668509633159*b[i + 116*ldb]);
        c[i + 267*ldc] = (5.06704059565454*b[i + 17*ldb] + 1.939864544376097*b[i + 42*ldb] + -0.7231396289857297*b[i + 67*ldb] + 0.4937590750470338*b[i + 92*ldb] + -0.5517668509633159*b[i + 117*ldb]);
        c[i + 268*ldc] = (5.06704059565454*b[i + 18*ldb] + 1.939864544376097*b[i + 43*ldb] + -0.7231396289857297*b[i + 68*ldb] + 0.4937590750470338*b[i + 93*ldb] + -0.5517668509633159*b[i + 118*ldb]);
        c[i + 269*ldc] = (5.06704059565454*b[i + 19*ldb] + 1.939864544376097*b[i + 44*ldb] + -0.7231396289857297*b[i + 69*ldb] + 0.4937590750470338*b[i + 94*ldb] + -0.5517668509633159*b[i + 119*ldb]);
        c[i + 270*ldc] = (5.06704059565454*b[i + 20*ldb] + 1.939864544376097*b[i + 45*ldb] + -0.7231396289857297*b[i + 70*ldb] + 0.4937590750470338*b[i + 95*ldb] + -0.5517668509633159*b[i + 120*ldb]);
        c[i + 271*ldc] = (5.06704059565454*b[i + 21*ldb] + 1.939864544376097*b[i + 46*ldb] + -0.7231396289857297*b[i + 71*ldb] + 0.4937590750470338*b[i + 96*ldb] + -0.5517668509633159*b[i + 121*ldb]);
        c[i + 272*ldc] = (5.06704059565454*b[i + 22*ldb] + 1.939864544376097*b[i + 47*ldb] + -0.7231396289857297*b[i + 72*ldb] + 0.4937590750470338*b[i + 97*ldb] + -0.5517668509633159*b[i + 122*ldb]);
        c[i + 273*ldc] = (5.06704059565454*b[i + 23*ldb] + 1.939864544376097*b[i + 48*ldb] + -0.7231396289857297*b[i + 73*ldb] + 0.4937590750470338*b[i + 98*ldb] + -0.5517668509633159*b[i + 123*ldb]);
        c[i + 274*ldc] = (5.06704059565454*b[i + 24*ldb] + 1.939864544376097*b[i + 49*ldb] + -0.7231396289857297*b[i + 74*ldb] + 0.4937590750470338*b[i + 99*ldb] + -0.5517668509633159*b[i + 124*ldb]);
        c[i + 275*ldc] = (-3.812557894803954*b[i + 0*ldb] + 0.7583532171678757*b[i + 25*ldb] + 1.706075027753831*b[i + 50*ldb] + -0.9285580266438338*b[i + 75*ldb] + 0.9704208807564537*b[i + 100*ldb]);
        c[i + 276*ldc] = (-3.812557894803954*b[i + 1*ldb] + 0.7583532171678757*b[i + 26*ldb] + 1.706075027753831*b[i + 51*ldb] + -0.9285580266438338*b[i + 76*ldb] + 0.9704208807564537*b[i + 101*ldb]);
        c[i + 277*ldc] = (-3.812557894803954*b[i + 2*ldb] + 0.7583532171678757*b[i + 27*ldb] + 1.706075027753831*b[i + 52*ldb] + -0.9285580266438338*b[i + 77*ldb] + 0.9704208807564537*b[i + 102*ldb]);
        c[i + 278*ldc] = (-3.812557894803954*b[i + 3*ldb] + 0.7583532171678757*b[i + 28*ldb] + 1.706075027753831*b[i + 53*ldb] + -0.9285580266438338*b[i + 78*ldb] + 0.9704208807564537*b[i + 103*ldb]);
        c[i + 279*ldc] = (-3.812557894803954*b[i + 4*ldb] + 0.7583532171678757*b[i + 29*ldb] + 1.706075027753831*b[i + 54*ldb] + -0.9285580266438338*b[i + 79*ldb] + 0.9704208807564537*b[i + 104*ldb]);
        c[i + 280*ldc] = (-3.812557894803954*b[i + 5*ldb] + 0.7583532171678757*b[i + 30*ldb] + 1.706075027753831*b[i + 55*ldb] + -0.9285580266438338*b[i + 80*ldb] + 0.9704208807564537*b[i + 105*ldb]);
        c[i + 281*ldc] = (-3.812557894803954*b[i + 6*ldb] + 0.7583532171678757*b[i + 31*ldb] + 1.706075027753831*b[i + 56*ldb] + -0.9285580266438338*b[i + 81*ldb] + 0.9704208807564537*b[i + 106*ldb]);
        c[i + 282*ldc] = (-3.812557894803954*b[i + 7*ldb] + 0.7583532171678757*b[i + 32*ldb] + 1.706075027753831*b[i + 57*ldb] + -0.9285580266438338*b[i + 82*ldb] + 0.9704208807564537*b[i + 107*ldb]);
        c[i + 283*ldc] = (-3.812557894803954*b[i + 8*ldb] + 0.7583532171678757*b[i + 33*ldb] + 1.706075027753831*b[i + 58*ldb] + -0.9285580266438338*b[i + 83*ldb] + 0.9704208807564537*b[i + 108*ldb]);
        c[i + 284*ldc] = (-3.812557894803954*b[i + 9*ldb] + 0.7583532171678757*b[i + 34*ldb] + 1.706075027753831*b[i + 59*ldb] + -0.9285580266438338*b[i + 84*ldb] + 0.9704208807564537*b[i + 109*ldb]);
        c[i + 285*ldc] = (-3.812557894803954*b[i + 10*ldb] + 0.7583532171678757*b[i + 35*ldb] + 1.706075027753831*b[i + 60*ldb] + -0.9285580266438338*b[i + 85*ldb] + 0.9704208807564537*b[i + 110*ldb]);
        c[i + 286*ldc] = (-3.812557894803954*b[i + 11*ldb] + 0.7583532171678757*b[i + 36*ldb] + 1.706075027753831*b[i + 61*ldb] + -0.9285580266438338*b[i + 86*ldb] + 0.9704208807564537*b[i + 111*ldb]);
        c[i + 287*ldc] = (-3.812557894803954*b[i + 12*ldb] + 0.7583532171678757*b[i + 37*ldb] + 1.706075027753831*b[i + 62*ldb] + -0.9285580266438338*b[i + 87*ldb] + 0.9704208807564537*b[i + 112*ldb]);
        c[i + 288*ldc] = (-3.812557894803954*b[i + 13*ldb] + 0.7583532171678757*b[i + 38*ldb] + 1.706075027753831*b[i + 63*ldb] + -0.9285580266438338*b[i + 88*ldb] + 0.9704208807564537*b[i + 113*ldb]);
        c[i + 289*ldc] = (-3.812557894803954*b[i + 14*ldb] + 0.7583532171678757*b[i + 39*ldb] + 1.706075027753831*b[i + 64*ldb] + -0.9285580266438338*b[i + 89*ldb] + 0.9704208807564537*b[i + 114*ldb]);
        c[i + 290*ldc] = (-3.812557894803954*b[i + 15*ldb] + 0.7583532171678757*b[i + 40*ldb] + 1.706075027753831*b[i + 65*ldb] + -0.9285580266438338*b[i + 90*ldb] + 0.9704208807564537*b[i + 115*ldb]);
        c[i + 291*ldc] = (-3.812557894803954*b[i + 16*ldb] + 0.7583532171678757*b[i + 41*ldb] + 1.706075027753831*b[i + 66*ldb] + -0.9285580266438338*b[i + 91*ldb] + 0.9704208807564537*b[i + 116*ldb]);
        c[i + 292*ldc] = (-3.812557894803954*b[i + 17*ldb] + 0.7583532171678757*b[i + 42*ldb] + 1.706075027753831*b[i + 67*ldb] + -0.9285580266438338*b[i + 92*ldb] + 0.9704208807564537*b[i + 117*ldb]);
        c[i + 293*ldc] = (-3.812557894803954*b[i + 18*ldb] + 0.7583532171678757*b[i + 43*ldb] + 1.706075027753831*b[i + 68*ldb] + -0.9285580266438338*b[i + 93*ldb] + 0.9704208807564537*b[i + 118*ldb]);
        c[i + 294*ldc] = (-3.812557894803954*b[i + 19*ldb] + 0.7583532171678757*b[i + 44*ldb] + 1.706075027753831*b[i + 69*ldb] + -0.9285580266438338*b[i + 94*ldb] + 0.9704208807564537*b[i + 119*ldb]);
        c[i + 295*ldc] = (-3.812557894803954*b[i + 20*ldb] + 0.7583532171678757*b[i + 45*ldb] + 1.706075027753831*b[i + 70*ldb] + -0.9285580266438338*b[i + 95*ldb] + 0.9704208807564537*b[i + 120*ldb]);
        c[i + 296*ldc] = (-3.812557894803954*b[i + 21*ldb] + 0.7583532171678757*b[i + 46*ldb] + 1.706075027753831*b[i + 71*ldb] + -0.9285580266438338*b[i + 96*ldb] + 0.9704208807564537*b[i + 121*ldb]);
        c[i + 297*ldc] = (-3.812557894803954*b[i + 22*ldb] + 0.7583532171678757*b[i + 47*ldb] + 1.706075027753831*b[i + 72*ldb] + -0.9285580266438338*b[i + 97*ldb] + 0.9704208807564537*b[i + 122*ldb]);
        c[i + 298*ldc] = (-3.812557894803954*b[i + 23*ldb] + 0.7583532171678757*b[i + 48*ldb] + 1.706075027753831*b[i + 73*ldb] + -0.9285580266438338*b[i + 98*ldb] + 0.9704208807564537*b[i + 123*ldb]);
        c[i + 299*ldc] = (-3.812557894803954*b[i + 24*ldb] + 0.7583532171678757*b[i + 49*ldb] + 1.706075027753831*b[i + 74*ldb] + -0.9285580266438338*b[i + 99*ldb] + 0.9704208807564537*b[i + 124*ldb]);
        c[i + 300*ldc] = (1.684026960320175*b[i + 0*ldb] + -2.021528935875383*b[i + 25*ldb] + 2.021528935875383*b[i + 75*ldb] + -1.684026960320175*b[i + 100*ldb]);
        c[i + 301*ldc] = (1.684026960320175*b[i + 1*ldb] + -2.021528935875383*b[i + 26*ldb] + 2.021528935875383*b[i + 76*ldb] + -1.684026960320175*b[i + 101*ldb]);
        c[i + 302*ldc] = (1.684026960320175*b[i + 2*ldb] + -2.021528935875383*b[i + 27*ldb] + 2.021528935875383*b[i + 77*ldb] + -1.684026960320175*b[i + 102*ldb]);
        c[i + 303*ldc] = (1.684026960320175*b[i + 3*ldb] + -2.021528935875383*b[i + 28*ldb] + 2.021528935875383*b[i + 78*ldb] + -1.684026960320175*b[i + 103*ldb]);
        c[i + 304*ldc] = (1.684026960320175*b[i + 4*ldb] + -2.021528935875383*b[i + 29*ldb] + 2.021528935875383*b[i + 79*ldb] + -1.684026960320175*b[i + 104*ldb]);
        c[i + 305*ldc] = (1.684026960320175*b[i + 5*ldb] + -2.021528935875383*b[i + 30*ldb] + 2.021528935875383*b[i + 80*ldb] + -1.684026960320175*b[i + 105*ldb]);
        c[i + 306*ldc] = (1.684026960320175*b[i + 6*ldb] + -2.021528935875383*b[i + 31*ldb] + 2.021528935875383*b[i + 81*ldb] + -1.684026960320175*b[i + 106*ldb]);
        c[i + 307*ldc] = (1.684026960320175*b[i + 7*ldb] + -2.021528935875383*b[i + 32*ldb] + 2.021528935875383*b[i + 82*ldb] + -1.684026960320175*b[i + 107*ldb]);
        c[i + 308*ldc] = (1.684026960320175*b[i + 8*ldb] + -2.021528935875383*b[i + 33*ldb] + 2.021528935875383*b[i + 83*ldb] + -1.684026960320175*b[i + 108*ldb]);
        c[i + 309*ldc] = (1.684026960320175*b[i + 9*ldb] + -2.021528935875383*b[i + 34*ldb] + 2.021528935875383*b[i + 84*ldb] + -1.684026960320175*b[i + 109*ldb]);
        c[i + 310*ldc] = (1.684026960320175*b[i + 10*ldb] + -2.021528935875383*b[i + 35*ldb] + 2.021528935875383*b[i + 85*ldb] + -1.684026960320175*b[i + 110*ldb]);
        c[i + 311*ldc] = (1.684026960320175*b[i + 11*ldb] + -2.021528935875383*b[i + 36*ldb] + 2.021528935875383*b[i + 86*ldb] + -1.684026960320175*b[i + 111*ldb]);
        c[i + 312*ldc] = (1.684026960320175*b[i + 12*ldb] + -2.021528935875383*b[i + 37*ldb] + 2.021528935875383*b[i + 87*ldb] + -1.684026960320175*b[i + 112*ldb]);
        c[i + 313*ldc] = (1.684026960320175*b[i + 13*ldb] + -2.021528935875383*b[i + 38*ldb] + 2.021528935875383*b[i + 88*ldb] + -1.684026960320175*b[i + 113*ldb]);
        c[i + 314*ldc] = (1.684026960320175*b[i + 14*ldb] + -2.021528935875383*b[i + 39*ldb] + 2.021528935875383*b[i + 89*ldb] + -1.684026960320175*b[i + 114*ldb]);
        c[i + 315*ldc] = (1.684026960320175*b[i + 15*ldb] + -2.021528935875383*b[i + 40*ldb] + 2.021528935875383*b[i + 90*ldb] + -1.684026960320175*b[i + 115*ldb]);
        c[i + 316*ldc] = (1.684026960320175*b[i + 16*ldb] + -2.021528935875383*b[i + 41*ldb] + 2.021528935875383*b[i + 91*ldb] + -1.684026960320175*b[i + 116*ldb]);
        c[i + 317*ldc] = (1.684026960320175*b[i + 17*ldb] + -2.021528935875383*b[i + 42*ldb] + 2.021528935875383*b[i + 92*ldb] + -1.684026960320175*b[i + 117*ldb]);
        c[i + 318*ldc] = (1.684026960320175*b[i + 18*ldb] + -2.021528935875383*b[i + 43*ldb] + 2.021528935875383*b[i + 93*ldb] + -1.684026960320175*b[i + 118*ldb]);
        c[i + 319*ldc] = (1.684026960320175*b[i + 19*ldb] + -2.021528935875383*b[i + 44*ldb] + 2.021528935875383*b[i + 94*ldb] + -1.684026960320175*b[i + 119*ldb]);
        c[i + 320*ldc] = (1.684026960320175*b[i + 20*ldb] + -2.021528935875383*b[i + 45*ldb] + 2.021528935875383*b[i + 95*ldb] + -1.684026960320175*b[i + 120*ldb]);
        c[i + 321*ldc] = (1.684026960320175*b[i + 21*ldb] + -2.021528935875383*b[i + 46*ldb] + 2.021528935875383*b[i + 96*ldb] + -1.684026960320175*b[i + 121*ldb]);
        c[i + 322*ldc] = (1.684026960320175*b[i + 22*ldb] + -2.021528935875383*b[i + 47*ldb] + 2.021528935875383*b[i + 97*ldb] + -1.684026960320175*b[i + 122*ldb]);
        c[i + 323*ldc] = (1.684026960320175*b[i + 23*ldb] + -2.021528935875383*b[i + 48*ldb] + 2.021528935875383*b[i + 98*ldb] + -1.684026960320175*b[i + 123*ldb]);
        c[i + 324*ldc] = (1.684026960320175*b[i + 24*ldb] + -2.021528935875383*b[i + 49*ldb] + 2.021528935875383*b[i + 99*ldb] + -1.684026960320175*b[i + 124*ldb]);
        c[i + 325*ldc] = (-0.9704208807564537*b[i + 0*ldb] + 0.9285580266438338*b[i + 25*ldb] + -1.706075027753831*b[i + 50*ldb] + -0.7583532171678757*b[i + 75*ldb] + 3.812557894803954*b[i + 100*ldb]);
        c[i + 326*ldc] = (-0.9704208807564537*b[i + 1*ldb] + 0.9285580266438338*b[i + 26*ldb] + -1.706075027753831*b[i + 51*ldb] + -0.7583532171678757*b[i + 76*ldb] + 3.812557894803954*b[i + 101*ldb]);
        c[i + 327*ldc] = (-0.9704208807564537*b[i + 2*ldb] + 0.9285580266438338*b[i + 27*ldb] + -1.706075027753831*b[i + 52*ldb] + -0.7583532171678757*b[i + 77*ldb] + 3.812557894803954*b[i + 102*ldb]);
        c[i + 328*ldc] = (-0.9704208807564537*b[i + 3*ldb] + 0.9285580266438338*b[i + 28*ldb] + -1.706075027753831*b[i + 53*ldb] + -0.7583532171678757*b[i + 78*ldb] + 3.812557894803954*b[i + 103*ldb]);
        c[i + 329*ldc] = (-0.9704208807564537*b[i + 4*ldb] + 0.9285580266438338*b[i + 29*ldb] + -1.706075027753831*b[i + 54*ldb] + -0.7583532171678757*b[i + 79*ldb] + 3.812557894803954*b[i + 104*ldb]);
        c[i + 330*ldc] = (-0.9704208807564537*b[i + 5*ldb] + 0.9285580266438338*b[i + 30*ldb] + -1.706075027753831*b[i + 55*ldb] + -0.7583532171678757*b[i + 80*ldb] + 3.812557894803954*b[i + 105*ldb]);
        c[i + 331*ldc] = (-0.9704208807564537*b[i + 6*ldb] + 0.9285580266438338*b[i + 31*ldb] + -1.706075027753831*b[i + 56*ldb] + -0.7583532171678757*b[i + 81*ldb] + 3.812557894803954*b[i + 106*ldb]);
        c[i + 332*ldc] = (-0.9704208807564537*b[i + 7*ldb] + 0.9285580266438338*b[i + 32*ldb] + -1.706075027753831*b[i + 57*ldb] + -0.7583532171678757*b[i + 82*ldb] + 3.812557894803954*b[i + 107*ldb]);
        c[i + 333*ldc] = (-0.9704208807564537*b[i + 8*ldb] + 0.9285580266438338*b[i + 33*ldb] + -1.706075027753831*b[i + 58*ldb] + -0.7583532171678757*b[i + 83*ldb] + 3.812557894803954*b[i + 108*ldb]);
        c[i + 334*ldc] = (-0.9704208807564537*b[i + 9*ldb] + 0.9285580266438338*b[i + 34*ldb] + -1.706075027753831*b[i + 59*ldb] + -0.7583532171678757*b[i + 84*ldb] + 3.812557894803954*b[i + 109*ldb]);
        c[i + 335*ldc] = (-0.9704208807564537*b[i + 10*ldb] + 0.9285580266438338*b[i + 35*ldb] + -1.706075027753831*b[i + 60*ldb] + -0.7583532171678757*b[i + 85*ldb] + 3.812557894803954*b[i + 110*ldb]);
        c[i + 336*ldc] = (-0.9704208807564537*b[i + 11*ldb] + 0.9285580266438338*b[i + 36*ldb] + -1.706075027753831*b[i + 61*ldb] + -0.7583532171678757*b[i + 86*ldb] + 3.812557894803954*b[i + 111*ldb]);
        c[i + 337*ldc] = (-0.9704208807564537*b[i + 12*ldb] + 0.9285580266438338*b[i + 37*ldb] + -1.706075027753831*b[i + 62*ldb] + -0.7583532171678757*b[i + 87*ldb] + 3.812557894803954*b[i + 112*ldb]);
        c[i + 338*ldc] = (-0.9704208807564537*b[i + 13*ldb] + 0.9285580266438338*b[i + 38*ldb] + -1.706075027753831*b[i + 63*ldb] + -0.7583532171678757*b[i + 88*ldb] + 3.812557894803954*b[i + 113*ldb]);
        c[i + 339*ldc] = (-0.9704208807564537*b[i + 14*ldb] + 0.9285580266438338*b[i + 39*ldb] + -1.706075027753831*b[i + 64*ldb] + -0.7583532171678757*b[i + 89*ldb] + 3.812557894803954*b[i + 114*ldb]);
        c[i + 340*ldc] = (-0.9704208807564537*b[i + 15*ldb] + 0.9285580266438338*b[i + 40*ldb] + -1.706075027753831*b[i + 65*ldb] + -0.7583532171678757*b[i + 90*ldb] + 3.812557894803954*b[i + 115*ldb]);
        c[i + 341*ldc] = (-0.9704208807564537*b[i + 16*ldb] + 0.9285580266438338*b[i + 41*ldb] + -1.706075027753831*b[i + 66*ldb] + -0.7583532171678757*b[i + 91*ldb] + 3.812557894803954*b[i + 116*ldb]);
        c[i + 342*ldc] = (-0.9704208807564537*b[i + 17*ldb] + 0.9285580266438338*b[i + 42*ldb] + -1.706075027753831*b[i + 67*ldb] + -0.7583532171678757*b[i + 92*ldb] + 3.812557894803954*b[i + 117*ldb]);
        c[i + 343*ldc] = (-0.9704208807564537*b[i + 18*ldb] + 0.9285580266438338*b[i + 43*ldb] + -1.706075027753831*b[i + 68*ldb] + -0.7583532171678757*b[i + 93*ldb] + 3.812557894803954*b[i + 118*ldb]);
        c[i + 344*ldc] = (-0.9704208807564537*b[i + 19*ldb] + 0.9285580266438338*b[i + 44*ldb] + -1.706075027753831*b[i + 69*ldb] + -0.7583532171678757*b[i + 94*ldb] + 3.812557894803954*b[i + 119*ldb]);
        c[i + 345*ldc] = (-0.9704208807564537*b[i + 20*ldb] + 0.9285580266438338*b[i + 45*ldb] + -1.706075027753831*b[i + 70*ldb] + -0.7583532171678757*b[i + 95*ldb] + 3.812557894803954*b[i + 120*ldb]);
        c[i + 346*ldc] = (-0.9704208807564537*b[i + 21*ldb] + 0.9285580266438338*b[i + 46*ldb] + -1.706075027753831*b[i + 71*ldb] + -0.7583532171678757*b[i + 96*ldb] + 3.812557894803954*b[i + 121*ldb]);
        c[i + 347*ldc] = (-0.9704208807564537*b[i + 22*ldb] + 0.9285580266438338*b[i + 47*ldb] + -1.706075027753831*b[i + 72*ldb] + -0.7583532171678757*b[i + 97*ldb] + 3.812557894803954*b[i + 122*ldb]);
        c[i + 348*ldc] = (-0.9704208807564537*b[i + 23*ldb] + 0.9285580266438338*b[i + 48*ldb] + -1.706075027753831*b[i + 73*ldb] + -0.7583532171678757*b[i + 98*ldb] + 3.812557894803954*b[i + 123*ldb]);
        c[i + 349*ldc] = (-0.9704208807564537*b[i + 24*ldb] + 0.9285580266438338*b[i + 49*ldb] + -1.706075027753831*b[i + 74*ldb] + -0.7583532171678757*b[i + 99*ldb] + 3.812557894803954*b[i + 124*ldb]);
        c[i + 350*ldc] = (0.5517668509633159*b[i + 0*ldb] + -0.4937590750470338*b[i + 25*ldb] + 0.7231396289857297*b[i + 50*ldb] + -1.939864544376097*b[i + 75*ldb] + -5.06704059565454*b[i + 100*ldb]);
        c[i + 351*ldc] = (0.5517668509633159*b[i + 1*ldb] + -0.4937590750470338*b[i + 26*ldb] + 0.7231396289857297*b[i + 51*ldb] + -1.939864544376097*b[i + 76*ldb] + -5.06704059565454*b[i + 101*ldb]);
        c[i + 352*ldc] = (0.5517668509633159*b[i + 2*ldb] + -0.4937590750470338*b[i + 27*ldb] + 0.7231396289857297*b[i + 52*ldb] + -1.939864544376097*b[i + 77*ldb] + -5.06704059565454*b[i + 102*ldb]);
        c[i + 353*ldc] = (0.5517668509633159*b[i + 3*ldb] + -0.4937590750470338*b[i + 28*ldb] + 0.7231396289857297*b[i + 53*ldb] + -1.939864544376097*b[i + 78*ldb] + -5.06704059565454*b[i + 103*ldb]);
        c[i + 354*ldc] = (0.5517668509633159*b[i + 4*ldb] + -0.4937590750470338*b[i + 29*ldb] + 0.7231396289857297*b[i + 54*ldb] + -1.939864544376097*b[i + 79*ldb] + -5.06704059565454*b[i + 104*ldb]);
        c[i + 355*ldc] = (0.5517668509633159*b[i + 5*ldb] + -0.4937590750470338*b[i + 30*ldb] + 0.7231396289857297*b[i + 55*ldb] + -1.939864544376097*b[i + 80*ldb] + -5.06704059565454*b[i + 105*ldb]);
        c[i + 356*ldc] = (0.5517668509633159*b[i + 6*ldb] + -0.4937590750470338*b[i + 31*ldb] + 0.7231396289857297*b[i + 56*ldb] + -1.939864544376097*b[i + 81*ldb] + -5.06704059565454*b[i + 106*ldb]);
        c[i + 357*ldc] = (0.5517668509633159*b[i + 7*ldb] + -0.4937590750470338*b[i + 32*ldb] + 0.7231396289857297*b[i + 57*ldb] + -1.939864544376097*b[i + 82*ldb] + -5.06704059565454*b[i + 107*ldb]);
        c[i + 358*ldc] = (0.5517668509633159*b[i + 8*ldb] + -0.4937590750470338*b[i + 33*ldb] + 0.7231396289857297*b[i + 58*ldb] + -1.939864544376097*b[i + 83*ldb] + -5.06704059565454*b[i + 108*ldb]);
        c[i + 359*ldc] = (0.5517668509633159*b[i + 9*ldb] + -0.4937590750470338*b[i + 34*ldb] + 0.7231396289857297*b[i + 59*ldb] + -1.939864544376097*b[i + 84*ldb] + -5.06704059565454*b[i + 109*ldb]);
        c[i + 360*ldc] = (0.5517668509633159*b[i + 10*ldb] + -0.4937590750470338*b[i + 35*ldb] + 0.7231396289857297*b[i + 60*ldb] + -1.939864544376097*b[i + 85*ldb] + -5.06704059565454*b[i + 110*ldb]);
        c[i + 361*ldc] = (0.5517668509633159*b[i + 11*ldb] + -0.4937590750470338*b[i + 36*ldb] + 0.7231396289857297*b[i + 61*ldb] + -1.939864544376097*b[i + 86*ldb] + -5.06704059565454*b[i + 111*ldb]);
        c[i + 362*ldc] = (0.5517668509633159*b[i + 12*ldb] + -0.4937590750470338*b[i + 37*ldb] + 0.7231396289857297*b[i + 62*ldb] + -1.939864544376097*b[i + 87*ldb] + -5.06704059565454*b[i + 112*ldb]);
        c[i + 363*ldc] = (0.5517668509633159*b[i + 13*ldb] + -0.4937590750470338*b[i + 38*ldb] + 0.7231396289857297*b[i + 63*ldb] + -1.939864544376097*b[i + 88*ldb] + -5.06704059565454*b[i + 113*ldb]);
        c[i + 364*ldc] = (0.5517668509633159*b[i + 14*ldb] + -0.4937590750470338*b[i + 39*ldb] + 0.7231396289857297*b[i + 64*ldb] + -1.939864544376097*b[i + 89*ldb] + -5.06704059565454*b[i + 114*ldb]);
        c[i + 365*ldc] = (0.5517668509633159*b[i + 15*ldb] + -0.4937590750470338*b[i + 40*ldb] + 0.7231396289857297*b[i + 65*ldb] + -1.939864544376097*b[i + 90*ldb] + -5.06704059565454*b[i + 115*ldb]);
        c[i + 366*ldc] = (0.5517668509633159*b[i + 16*ldb] + -0.4937590750470338*b[i + 41*ldb] + 0.7231396289857297*b[i + 66*ldb] + -1.939864544376097*b[i + 91*ldb] + -5.06704059565454*b[i + 116*ldb]);
        c[i + 367*ldc] = (0.5517668509633159*b[i + 17*ldb] + -0.4937590750470338*b[i + 42*ldb] + 0.7231396289857297*b[i + 67*ldb] + -1.939864544376097*b[i + 92*ldb] + -5.06704059565454*b[i + 117*ldb]);
        c[i + 368*ldc] = (0.5517668509633159*b[i + 18*ldb] + -0.4937590750470338*b[i + 43*ldb] + 0.7231396289857297*b[i + 68*ldb] + -1.939864544376097*b[i + 93*ldb] + -5.06704059565454*b[i + 118*ldb]);
        c[i + 369*ldc] = (0.5517668509633159*b[i + 19*ldb] + -0.4937590750470338*b[i + 44*ldb] + 0.7231396289857297*b[i + 69*ldb] + -1.939864544376097*b[i + 94*ldb] + -5.06704059565454*b[i + 119*ldb]);
        c[i + 370*ldc] = (0.5517668509633159*b[i + 20*ldb] + -0.4937590750470338*b[i + 45*ldb] + 0.7231396289857297*b[i + 70*ldb] + -1.939864544376097*b[i + 95*ldb] + -5.06704059565454*b[i + 120*ldb]);
        c[i + 371*ldc] = (0.5517668509633159*b[i + 21*ldb] + -0.4937590750470338*b[i + 46*ldb] + 0.7231396289857297*b[i + 71*ldb] + -1.939864544376097*b[i + 96*ldb] + -5.06704059565454*b[i + 121*ldb]);
        c[i + 372*ldc] = (0.5517668509633159*b[i + 22*ldb] + -0.4937590750470338*b[i + 47*ldb] + 0.7231396289857297*b[i + 72*ldb] + -1.939864544376097*b[i + 97*ldb] + -5.06704059565454*b[i + 122*ldb]);
        c[i + 373*ldc] = (0.5517668509633159*b[i + 23*ldb] + -0.4937590750470338*b[i + 48*ldb] + 0.7231396289857297*b[i + 73*ldb] + -1.939864544376097*b[i + 98*ldb] + -5.06704059565454*b[i + 123*ldb]);
        c[i + 374*ldc] = (0.5517668509633159*b[i + 24*ldb] + -0.4937590750470338*b[i + 49*ldb] + 0.7231396289857297*b[i + 74*ldb] + -1.939864544376097*b[i + 99*ldb] + -5.06704059565454*b[i + 124*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_hex_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (5.06704059565454*b[i + 0*ldb] + 1.939864544376097*b[i + 1*ldb] + -0.7231396289857297*b[i + 2*ldb] + 0.4937590750470338*b[i + 3*ldb] + -0.5517668509633159*b[i + 4*ldb] + 5.06704059565454*b[i + 125*ldb] + 1.939864544376097*b[i + 130*ldb] + -0.7231396289857297*b[i + 135*ldb] + 0.4937590750470338*b[i + 140*ldb] + -0.5517668509633159*b[i + 145*ldb] + 5.06704059565454*b[i + 250*ldb] + 1.939864544376097*b[i + 275*ldb] + -0.7231396289857297*b[i + 300*ldb] + 0.4937590750470338*b[i + 325*ldb] + -0.5517668509633159*b[i + 350*ldb]);
        c[i + 1*ldc] = (-3.812557894803954*b[i + 0*ldb] + 0.7583532171678757*b[i + 1*ldb] + 1.706075027753831*b[i + 2*ldb] + -0.9285580266438338*b[i + 3*ldb] + 0.9704208807564537*b[i + 4*ldb] + 5.06704059565454*b[i + 126*ldb] + 1.939864544376097*b[i + 131*ldb] + -0.7231396289857297*b[i + 136*ldb] + 0.4937590750470338*b[i + 141*ldb] + -0.5517668509633159*b[i + 146*ldb] + 5.06704059565454*b[i + 251*ldb] + 1.939864544376097*b[i + 276*ldb] + -0.7231396289857297*b[i + 301*ldb] + 0.4937590750470338*b[i + 326*ldb] + -0.5517668509633159*b[i + 351*ldb]);
        c[i + 2*ldc] = (1.684026960320175*b[i + 0*ldb] + -2.021528935875383*b[i + 1*ldb] + 2.021528935875383*b[i + 3*ldb] + -1.684026960320175*b[i + 4*ldb] + 5.06704059565454*b[i + 127*ldb] + 1.939864544376097*b[i + 132*ldb] + -0.7231396289857297*b[i + 137*ldb] + 0.4937590750470338*b[i + 142*ldb] + -0.5517668509633159*b[i + 147*ldb] + 5.06704059565454*b[i + 252*ldb] + 1.939864544376097*b[i + 277*ldb] + -0.7231396289857297*b[i + 302*ldb] + 0.4937590750470338*b[i + 327*ldb] + -0.5517668509633159*b[i + 352*ldb]);
        c[i + 3*ldc] = (-0.9704208807564537*b[i + 0*ldb] + 0.9285580266438338*b[i + 1*ldb] + -1.706075027753831*b[i + 2*ldb] + -0.7583532171678757*b[i + 3*ldb] + 3.812557894803954*b[i + 4*ldb] + 5.06704059565454*b[i + 128*ldb] + 1.939864544376097*b[i + 133*ldb] + -0.7231396289857297*b[i + 138*ldb] + 0.4937590750470338*b[i + 143*ldb] + -0.5517668509633159*b[i + 148*ldb] + 5.06704059565454*b[i + 253*ldb] + 1.939864544376097*b[i + 278*ldb] + -0.7231396289857297*b[i + 303*ldb] + 0.4937590750470338*b[i + 328*ldb] + -0.5517668509633159*b[i + 353*ldb]);
        c[i + 4*ldc] = (0.5517668509633159*b[i + 0*ldb] + -0.4937590750470338*b[i + 1*ldb] + 0.7231396289857297*b[i + 2*ldb] + -1.939864544376097*b[i + 3*ldb] + -5.06704059565454*b[i + 4*ldb] + 5.06704059565454*b[i + 129*ldb] + 1.939864544376097*b[i + 134*ldb] + -0.7231396289857297*b[i + 139*ldb] + 0.4937590750470338*b[i + 144*ldb] + -0.5517668509633159*b[i + 149*ldb] + 5.06704059565454*b[i + 254*ldb] + 1.939864544376097*b[i + 279*ldb] + -0.7231396289857297*b[i + 304*ldb] + 0.4937590750470338*b[i + 329*ldb] + -0.5517668509633159*b[i + 354*ldb]);
        c[i + 5*ldc] = (5.06704059565454*b[i + 5*ldb] + 1.939864544376097*b[i + 6*ldb] + -0.7231396289857297*b[i + 7*ldb] + 0.4937590750470338*b[i + 8*ldb] + -0.5517668509633159*b[i + 9*ldb] + -3.812557894803954*b[i + 125*ldb] + 0.7583532171678757*b[i + 130*ldb] + 1.706075027753831*b[i + 135*ldb] + -0.9285580266438338*b[i + 140*ldb] + 0.9704208807564537*b[i + 145*ldb] + 5.06704059565454*b[i + 255*ldb] + 1.939864544376097*b[i + 280*ldb] + -0.7231396289857297*b[i + 305*ldb] + 0.4937590750470338*b[i + 330*ldb] + -0.5517668509633159*b[i + 355*ldb]);
        c[i + 6*ldc] = (-3.812557894803954*b[i + 5*ldb] + 0.7583532171678757*b[i + 6*ldb] + 1.706075027753831*b[i + 7*ldb] + -0.9285580266438338*b[i + 8*ldb] + 0.9704208807564537*b[i + 9*ldb] + -3.812557894803954*b[i + 126*ldb] + 0.7583532171678757*b[i + 131*ldb] + 1.706075027753831*b[i + 136*ldb] + -0.9285580266438338*b[i + 141*ldb] + 0.9704208807564537*b[i + 146*ldb] + 5.06704059565454*b[i + 256*ldb] + 1.939864544376097*b[i + 281*ldb] + -0.7231396289857297*b[i + 306*ldb] + 0.4937590750470338*b[i + 331*ldb] + -0.5517668509633159*b[i + 356*ldb]);
        c[i + 7*ldc] = (1.684026960320175*b[i + 5*ldb] + -2.021528935875383*b[i + 6*ldb] + 2.021528935875383*b[i + 8*ldb] + -1.684026960320175*b[i + 9*ldb] + -3.812557894803954*b[i + 127*ldb] + 0.7583532171678757*b[i + 132*ldb] + 1.706075027753831*b[i + 137*ldb] + -0.9285580266438338*b[i + 142*ldb] + 0.9704208807564537*b[i + 147*ldb] + 5.06704059565454*b[i + 257*ldb] + 1.939864544376097*b[i + 282*ldb] + -0.7231396289857297*b[i + 307*ldb] + 0.4937590750470338*b[i + 332*ldb] + -0.5517668509633159*b[i + 357*ldb]);
        c[i + 8*ldc] = (-0.9704208807564537*b[i + 5*ldb] + 0.9285580266438338*b[i + 6*ldb] + -1.706075027753831*b[i + 7*ldb] + -0.7583532171678757*b[i + 8*ldb] + 3.812557894803954*b[i + 9*ldb] + -3.812557894803954*b[i + 128*ldb] + 0.7583532171678757*b[i + 133*ldb] + 1.706075027753831*b[i + 138*ldb] + -0.9285580266438338*b[i + 143*ldb] + 0.9704208807564537*b[i + 148*ldb] + 5.06704059565454*b[i + 258*ldb] + 1.939864544376097*b[i + 283*ldb] + -0.7231396289857297*b[i + 308*ldb] + 0.4937590750470338*b[i + 333*ldb] + -0.5517668509633159*b[i + 358*ldb]);
        c[i + 9*ldc] = (0.5517668509633159*b[i + 5*ldb] + -0.4937590750470338*b[i + 6*ldb] + 0.7231396289857297*b[i + 7*ldb] + -1.939864544376097*b[i + 8*ldb] + -5.06704059565454*b[i + 9*ldb] + -3.812557894803954*b[i + 129*ldb] + 0.7583532171678757*b[i + 134*ldb] + 1.706075027753831*b[i + 139*ldb] + -0.9285580266438338*b[i + 144*ldb] + 0.9704208807564537*b[i + 149*ldb] + 5.06704059565454*b[i + 259*ldb] + 1.939864544376097*b[i + 284*ldb] + -0.7231396289857297*b[i + 309*ldb] + 0.4937590750470338*b[i + 334*ldb] + -0.5517668509633159*b[i + 359*ldb]);
        c[i + 10*ldc] = (5.06704059565454*b[i + 10*ldb] + 1.939864544376097*b[i + 11*ldb] + -0.7231396289857297*b[i + 12*ldb] + 0.4937590750470338*b[i + 13*ldb] + -0.5517668509633159*b[i + 14*ldb] + 1.684026960320175*b[i + 125*ldb] + -2.021528935875383*b[i + 130*ldb] + 2.021528935875383*b[i + 140*ldb] + -1.684026960320175*b[i + 145*ldb] + 5.06704059565454*b[i + 260*ldb] + 1.939864544376097*b[i + 285*ldb] + -0.7231396289857297*b[i + 310*ldb] + 0.4937590750470338*b[i + 335*ldb] + -0.5517668509633159*b[i + 360*ldb]);
        c[i + 11*ldc] = (-3.812557894803954*b[i + 10*ldb] + 0.7583532171678757*b[i + 11*ldb] + 1.706075027753831*b[i + 12*ldb] + -0.9285580266438338*b[i + 13*ldb] + 0.9704208807564537*b[i + 14*ldb] + 1.684026960320175*b[i + 126*ldb] + -2.021528935875383*b[i + 131*ldb] + 2.021528935875383*b[i + 141*ldb] + -1.684026960320175*b[i + 146*ldb] + 5.06704059565454*b[i + 261*ldb] + 1.939864544376097*b[i + 286*ldb] + -0.7231396289857297*b[i + 311*ldb] + 0.4937590750470338*b[i + 336*ldb] + -0.5517668509633159*b[i + 361*ldb]);
        c[i + 12*ldc] = (1.684026960320175*b[i + 10*ldb] + -2.021528935875383*b[i + 11*ldb] + 2.021528935875383*b[i + 13*ldb] + -1.684026960320175*b[i + 14*ldb] + 1.684026960320175*b[i + 127*ldb] + -2.021528935875383*b[i + 132*ldb] + 2.021528935875383*b[i + 142*ldb] + -1.684026960320175*b[i + 147*ldb] + 5.06704059565454*b[i + 262*ldb] + 1.939864544376097*b[i + 287*ldb] + -0.7231396289857297*b[i + 312*ldb] + 0.4937590750470338*b[i + 337*ldb] + -0.5517668509633159*b[i + 362*ldb]);
        c[i + 13*ldc] = (-0.9704208807564537*b[i + 10*ldb] + 0.9285580266438338*b[i + 11*ldb] + -1.706075027753831*b[i + 12*ldb] + -0.7583532171678757*b[i + 13*ldb] + 3.812557894803954*b[i + 14*ldb] + 1.684026960320175*b[i + 128*ldb] + -2.021528935875383*b[i + 133*ldb] + 2.021528935875383*b[i + 143*ldb] + -1.684026960320175*b[i + 148*ldb] + 5.06704059565454*b[i + 263*ldb] + 1.939864544376097*b[i + 288*ldb] + -0.7231396289857297*b[i + 313*ldb] + 0.4937590750470338*b[i + 338*ldb] + -0.5517668509633159*b[i + 363*ldb]);
        c[i + 14*ldc] = (0.5517668509633159*b[i + 10*ldb] + -0.4937590750470338*b[i + 11*ldb] + 0.7231396289857297*b[i + 12*ldb] + -1.939864544376097*b[i + 13*ldb] + -5.06704059565454*b[i + 14*ldb] + 1.684026960320175*b[i + 129*ldb] + -2.021528935875383*b[i + 134*ldb] + 2.021528935875383*b[i + 144*ldb] + -1.684026960320175*b[i + 149*ldb] + 5.06704059565454*b[i + 264*ldb] + 1.939864544376097*b[i + 289*ldb] + -0.7231396289857297*b[i + 314*ldb] + 0.4937590750470338*b[i + 339*ldb] + -0.5517668509633159*b[i + 364*ldb]);
        c[i + 15*ldc] = (5.06704059565454*b[i + 15*ldb] + 1.939864544376097*b[i + 16*ldb] + -0.7231396289857297*b[i + 17*ldb] + 0.4937590750470338*b[i + 18*ldb] + -0.5517668509633159*b[i + 19*ldb] + -0.9704208807564537*b[i + 125*ldb] + 0.9285580266438338*b[i + 130*ldb] + -1.706075027753831*b[i + 135*ldb] + -0.7583532171678757*b[i + 140*ldb] + 3.812557894803954*b[i + 145*ldb] + 5.06704059565454*b[i + 265*ldb] + 1.939864544376097*b[i + 290*ldb] + -0.7231396289857297*b[i + 315*ldb] + 0.4937590750470338*b[i + 340*ldb] + -0.5517668509633159*b[i + 365*ldb]);
        c[i + 16*ldc] = (-3.812557894803954*b[i + 15*ldb] + 0.7583532171678757*b[i + 16*ldb] + 1.706075027753831*b[i + 17*ldb] + -0.9285580266438338*b[i + 18*ldb] + 0.9704208807564537*b[i + 19*ldb] + -0.9704208807564537*b[i + 126*ldb] + 0.9285580266438338*b[i + 131*ldb] + -1.706075027753831*b[i + 136*ldb] + -0.7583532171678757*b[i + 141*ldb] + 3.812557894803954*b[i + 146*ldb] + 5.06704059565454*b[i + 266*ldb] + 1.939864544376097*b[i + 291*ldb] + -0.7231396289857297*b[i + 316*ldb] + 0.4937590750470338*b[i + 341*ldb] + -0.5517668509633159*b[i + 366*ldb]);
        c[i + 17*ldc] = (1.684026960320175*b[i + 15*ldb] + -2.021528935875383*b[i + 16*ldb] + 2.021528935875383*b[i + 18*ldb] + -1.684026960320175*b[i + 19*ldb] + -0.9704208807564537*b[i + 127*ldb] + 0.9285580266438338*b[i + 132*ldb] + -1.706075027753831*b[i + 137*ldb] + -0.7583532171678757*b[i + 142*ldb] + 3.812557894803954*b[i + 147*ldb] + 5.06704059565454*b[i + 267*ldb] + 1.939864544376097*b[i + 292*ldb] + -0.7231396289857297*b[i + 317*ldb] + 0.4937590750470338*b[i + 342*ldb] + -0.5517668509633159*b[i + 367*ldb]);
        c[i + 18*ldc] = (-0.9704208807564537*b[i + 15*ldb] + 0.9285580266438338*b[i + 16*ldb] + -1.706075027753831*b[i + 17*ldb] + -0.7583532171678757*b[i + 18*ldb] + 3.812557894803954*b[i + 19*ldb] + -0.9704208807564537*b[i + 128*ldb] + 0.9285580266438338*b[i + 133*ldb] + -1.706075027753831*b[i + 138*ldb] + -0.7583532171678757*b[i + 143*ldb] + 3.812557894803954*b[i + 148*ldb] + 5.06704059565454*b[i + 268*ldb] + 1.939864544376097*b[i + 293*ldb] + -0.7231396289857297*b[i + 318*ldb] + 0.4937590750470338*b[i + 343*ldb] + -0.5517668509633159*b[i + 368*ldb]);
        c[i + 19*ldc] = (0.5517668509633159*b[i + 15*ldb] + -0.4937590750470338*b[i + 16*ldb] + 0.7231396289857297*b[i + 17*ldb] + -1.939864544376097*b[i + 18*ldb] + -5.06704059565454*b[i + 19*ldb] + -0.9704208807564537*b[i + 129*ldb] + 0.9285580266438338*b[i + 134*ldb] + -1.706075027753831*b[i + 139*ldb] + -0.7583532171678757*b[i + 144*ldb] + 3.812557894803954*b[i + 149*ldb] + 5.06704059565454*b[i + 269*ldb] + 1.939864544376097*b[i + 294*ldb] + -0.7231396289857297*b[i + 319*ldb] + 0.4937590750470338*b[i + 344*ldb] + -0.5517668509633159*b[i + 369*ldb]);
        c[i + 20*ldc] = (5.06704059565454*b[i + 20*ldb] + 1.939864544376097*b[i + 21*ldb] + -0.7231396289857297*b[i + 22*ldb] + 0.4937590750470338*b[i + 23*ldb] + -0.5517668509633159*b[i + 24*ldb] + 0.5517668509633159*b[i + 125*ldb] + -0.4937590750470338*b[i + 130*ldb] + 0.7231396289857297*b[i + 135*ldb] + -1.939864544376097*b[i + 140*ldb] + -5.06704059565454*b[i + 145*ldb] + 5.06704059565454*b[i + 270*ldb] + 1.939864544376097*b[i + 295*ldb] + -0.7231396289857297*b[i + 320*ldb] + 0.4937590750470338*b[i + 345*ldb] + -0.5517668509633159*b[i + 370*ldb]);
        c[i + 21*ldc] = (-3.812557894803954*b[i + 20*ldb] + 0.7583532171678757*b[i + 21*ldb] + 1.706075027753831*b[i + 22*ldb] + -0.9285580266438338*b[i + 23*ldb] + 0.9704208807564537*b[i + 24*ldb] + 0.5517668509633159*b[i + 126*ldb] + -0.4937590750470338*b[i + 131*ldb] + 0.7231396289857297*b[i + 136*ldb] + -1.939864544376097*b[i + 141*ldb] + -5.06704059565454*b[i + 146*ldb] + 5.06704059565454*b[i + 271*ldb] + 1.939864544376097*b[i + 296*ldb] + -0.7231396289857297*b[i + 321*ldb] + 0.4937590750470338*b[i + 346*ldb] + -0.5517668509633159*b[i + 371*ldb]);
        c[i + 22*ldc] = (1.684026960320175*b[i + 20*ldb] + -2.021528935875383*b[i + 21*ldb] + 2.021528935875383*b[i + 23*ldb] + -1.684026960320175*b[i + 24*ldb] + 0.5517668509633159*b[i + 127*ldb] + -0.4937590750470338*b[i + 132*ldb] + 0.7231396289857297*b[i + 137*ldb] + -1.939864544376097*b[i + 142*ldb] + -5.06704059565454*b[i + 147*ldb] + 5.06704059565454*b[i + 272*ldb] + 1.939864544376097*b[i + 297*ldb] + -0.7231396289857297*b[i + 322*ldb] + 0.4937590750470338*b[i + 347*ldb] + -0.5517668509633159*b[i + 372*ldb]);
        c[i + 23*ldc] = (-0.9704208807564537*b[i + 20*ldb] + 0.9285580266438338*b[i + 21*ldb] + -1.706075027753831*b[i + 22*ldb] + -0.7583532171678757*b[i + 23*ldb] + 3.812557894803954*b[i + 24*ldb] + 0.5517668509633159*b[i + 128*ldb] + -0.4937590750470338*b[i + 133*ldb] + 0.7231396289857297*b[i + 138*ldb] + -1.939864544376097*b[i + 143*ldb] + -5.06704059565454*b[i + 148*ldb] + 5.06704059565454*b[i + 273*ldb] + 1.939864544376097*b[i + 298*ldb] + -0.7231396289857297*b[i + 323*ldb] + 0.4937590750470338*b[i + 348*ldb] + -0.5517668509633159*b[i + 373*ldb]);
        c[i + 24*ldc] = (0.5517668509633159*b[i + 20*ldb] + -0.4937590750470338*b[i + 21*ldb] + 0.7231396289857297*b[i + 22*ldb] + -1.939864544376097*b[i + 23*ldb] + -5.06704059565454*b[i + 24*ldb] + 0.5517668509633159*b[i + 129*ldb] + -0.4937590750470338*b[i + 134*ldb] + 0.7231396289857297*b[i + 139*ldb] + -1.939864544376097*b[i + 144*ldb] + -5.06704059565454*b[i + 149*ldb] + 5.06704059565454*b[i + 274*ldb] + 1.939864544376097*b[i + 299*ldb] + -0.7231396289857297*b[i + 324*ldb] + 0.4937590750470338*b[i + 349*ldb] + -0.5517668509633159*b[i + 374*ldb]);
        c[i + 25*ldc] = (5.06704059565454*b[i + 25*ldb] + 1.939864544376097*b[i + 26*ldb] + -0.7231396289857297*b[i + 27*ldb] + 0.4937590750470338*b[i + 28*ldb] + -0.5517668509633159*b[i + 29*ldb] + 5.06704059565454*b[i + 150*ldb] + 1.939864544376097*b[i + 155*ldb] + -0.7231396289857297*b[i + 160*ldb] + 0.4937590750470338*b[i + 165*ldb] + -0.5517668509633159*b[i + 170*ldb] + -3.812557894803954*b[i + 250*ldb] + 0.7583532171678757*b[i + 275*ldb] + 1.706075027753831*b[i + 300*ldb] + -0.9285580266438338*b[i + 325*ldb] + 0.9704208807564537*b[i + 350*ldb]);
        c[i + 26*ldc] = (-3.812557894803954*b[i + 25*ldb] + 0.7583532171678757*b[i + 26*ldb] + 1.706075027753831*b[i + 27*ldb] + -0.9285580266438338*b[i + 28*ldb] + 0.9704208807564537*b[i + 29*ldb] + 5.06704059565454*b[i + 151*ldb] + 1.939864544376097*b[i + 156*ldb] + -0.7231396289857297*b[i + 161*ldb] + 0.4937590750470338*b[i + 166*ldb] + -0.5517668509633159*b[i + 171*ldb] + -3.812557894803954*b[i + 251*ldb] + 0.7583532171678757*b[i + 276*ldb] + 1.706075027753831*b[i + 301*ldb] + -0.9285580266438338*b[i + 326*ldb] + 0.9704208807564537*b[i + 351*ldb]);
        c[i + 27*ldc] = (1.684026960320175*b[i + 25*ldb] + -2.021528935875383*b[i + 26*ldb] + 2.021528935875383*b[i + 28*ldb] + -1.684026960320175*b[i + 29*ldb] + 5.06704059565454*b[i + 152*ldb] + 1.939864544376097*b[i + 157*ldb] + -0.7231396289857297*b[i + 162*ldb] + 0.4937590750470338*b[i + 167*ldb] + -0.5517668509633159*b[i + 172*ldb] + -3.812557894803954*b[i + 252*ldb] + 0.7583532171678757*b[i + 277*ldb] + 1.706075027753831*b[i + 302*ldb] + -0.9285580266438338*b[i + 327*ldb] + 0.9704208807564537*b[i + 352*ldb]);
        c[i + 28*ldc] = (-0.9704208807564537*b[i + 25*ldb] + 0.9285580266438338*b[i + 26*ldb] + -1.706075027753831*b[i + 27*ldb] + -0.7583532171678757*b[i + 28*ldb] + 3.812557894803954*b[i + 29*ldb] + 5.06704059565454*b[i + 153*ldb] + 1.939864544376097*b[i + 158*ldb] + -0.7231396289857297*b[i + 163*ldb] + 0.4937590750470338*b[i + 168*ldb] + -0.5517668509633159*b[i + 173*ldb] + -3.812557894803954*b[i + 253*ldb] + 0.7583532171678757*b[i + 278*ldb] + 1.706075027753831*b[i + 303*ldb] + -0.9285580266438338*b[i + 328*ldb] + 0.9704208807564537*b[i + 353*ldb]);
        c[i + 29*ldc] = (0.5517668509633159*b[i + 25*ldb] + -0.4937590750470338*b[i + 26*ldb] + 0.7231396289857297*b[i + 27*ldb] + -1.939864544376097*b[i + 28*ldb] + -5.06704059565454*b[i + 29*ldb] + 5.06704059565454*b[i + 154*ldb] + 1.939864544376097*b[i + 159*ldb] + -0.7231396289857297*b[i + 164*ldb] + 0.4937590750470338*b[i + 169*ldb] + -0.5517668509633159*b[i + 174*ldb] + -3.812557894803954*b[i + 254*ldb] + 0.7583532171678757*b[i + 279*ldb] + 1.706075027753831*b[i + 304*ldb] + -0.9285580266438338*b[i + 329*ldb] + 0.9704208807564537*b[i + 354*ldb]);
        c[i + 30*ldc] = (5.06704059565454*b[i + 30*ldb] + 1.939864544376097*b[i + 31*ldb] + -0.7231396289857297*b[i + 32*ldb] + 0.4937590750470338*b[i + 33*ldb] + -0.5517668509633159*b[i + 34*ldb] + -3.812557894803954*b[i + 150*ldb] + 0.7583532171678757*b[i + 155*ldb] + 1.706075027753831*b[i + 160*ldb] + -0.9285580266438338*b[i + 165*ldb] + 0.9704208807564537*b[i + 170*ldb] + -3.812557894803954*b[i + 255*ldb] + 0.7583532171678757*b[i + 280*ldb] + 1.706075027753831*b[i + 305*ldb] + -0.9285580266438338*b[i + 330*ldb] + 0.9704208807564537*b[i + 355*ldb]);
        c[i + 31*ldc] = (-3.812557894803954*b[i + 30*ldb] + 0.7583532171678757*b[i + 31*ldb] + 1.706075027753831*b[i + 32*ldb] + -0.9285580266438338*b[i + 33*ldb] + 0.9704208807564537*b[i + 34*ldb] + -3.812557894803954*b[i + 151*ldb] + 0.7583532171678757*b[i + 156*ldb] + 1.706075027753831*b[i + 161*ldb] + -0.9285580266438338*b[i + 166*ldb] + 0.9704208807564537*b[i + 171*ldb] + -3.812557894803954*b[i + 256*ldb] + 0.7583532171678757*b[i + 281*ldb] + 1.706075027753831*b[i + 306*ldb] + -0.9285580266438338*b[i + 331*ldb] + 0.9704208807564537*b[i + 356*ldb]);
        c[i + 32*ldc] = (1.684026960320175*b[i + 30*ldb] + -2.021528935875383*b[i + 31*ldb] + 2.021528935875383*b[i + 33*ldb] + -1.684026960320175*b[i + 34*ldb] + -3.812557894803954*b[i + 152*ldb] + 0.7583532171678757*b[i + 157*ldb] + 1.706075027753831*b[i + 162*ldb] + -0.9285580266438338*b[i + 167*ldb] + 0.9704208807564537*b[i + 172*ldb] + -3.812557894803954*b[i + 257*ldb] + 0.7583532171678757*b[i + 282*ldb] + 1.706075027753831*b[i + 307*ldb] + -0.9285580266438338*b[i + 332*ldb] + 0.9704208807564537*b[i + 357*ldb]);
        c[i + 33*ldc] = (-0.9704208807564537*b[i + 30*ldb] + 0.9285580266438338*b[i + 31*ldb] + -1.706075027753831*b[i + 32*ldb] + -0.7583532171678757*b[i + 33*ldb] + 3.812557894803954*b[i + 34*ldb] + -3.812557894803954*b[i + 153*ldb] + 0.7583532171678757*b[i + 158*ldb] + 1.706075027753831*b[i + 163*ldb] + -0.9285580266438338*b[i + 168*ldb] + 0.9704208807564537*b[i + 173*ldb] + -3.812557894803954*b[i + 258*ldb] + 0.7583532171678757*b[i + 283*ldb] + 1.706075027753831*b[i + 308*ldb] + -0.9285580266438338*b[i + 333*ldb] + 0.9704208807564537*b[i + 358*ldb]);
        c[i + 34*ldc] = (0.5517668509633159*b[i + 30*ldb] + -0.4937590750470338*b[i + 31*ldb] + 0.7231396289857297*b[i + 32*ldb] + -1.939864544376097*b[i + 33*ldb] + -5.06704059565454*b[i + 34*ldb] + -3.812557894803954*b[i + 154*ldb] + 0.7583532171678757*b[i + 159*ldb] + 1.706075027753831*b[i + 164*ldb] + -0.9285580266438338*b[i + 169*ldb] + 0.9704208807564537*b[i + 174*ldb] + -3.812557894803954*b[i + 259*ldb] + 0.7583532171678757*b[i + 284*ldb] + 1.706075027753831*b[i + 309*ldb] + -0.9285580266438338*b[i + 334*ldb] + 0.9704208807564537*b[i + 359*ldb]);
        c[i + 35*ldc] = (5.06704059565454*b[i + 35*ldb] + 1.939864544376097*b[i + 36*ldb] + -0.7231396289857297*b[i + 37*ldb] + 0.4937590750470338*b[i + 38*ldb] + -0.5517668509633159*b[i + 39*ldb] + 1.684026960320175*b[i + 150*ldb] + -2.021528935875383*b[i + 155*ldb] + 2.021528935875383*b[i + 165*ldb] + -1.684026960320175*b[i + 170*ldb] + -3.812557894803954*b[i + 260*ldb] + 0.7583532171678757*b[i + 285*ldb] + 1.706075027753831*b[i + 310*ldb] + -0.9285580266438338*b[i + 335*ldb] + 0.9704208807564537*b[i + 360*ldb]);
        c[i + 36*ldc] = (-3.812557894803954*b[i + 35*ldb] + 0.7583532171678757*b[i + 36*ldb] + 1.706075027753831*b[i + 37*ldb] + -0.9285580266438338*b[i + 38*ldb] + 0.9704208807564537*b[i + 39*ldb] + 1.684026960320175*b[i + 151*ldb] + -2.021528935875383*b[i + 156*ldb] + 2.021528935875383*b[i + 166*ldb] + -1.684026960320175*b[i + 171*ldb] + -3.812557894803954*b[i + 261*ldb] + 0.7583532171678757*b[i + 286*ldb] + 1.706075027753831*b[i + 311*ldb] + -0.9285580266438338*b[i + 336*ldb] + 0.9704208807564537*b[i + 361*ldb]);
        c[i + 37*ldc] = (1.684026960320175*b[i + 35*ldb] + -2.021528935875383*b[i + 36*ldb] + 2.021528935875383*b[i + 38*ldb] + -1.684026960320175*b[i + 39*ldb] + 1.684026960320175*b[i + 152*ldb] + -2.021528935875383*b[i + 157*ldb] + 2.021528935875383*b[i + 167*ldb] + -1.684026960320175*b[i + 172*ldb] + -3.812557894803954*b[i + 262*ldb] + 0.7583532171678757*b[i + 287*ldb] + 1.706075027753831*b[i + 312*ldb] + -0.9285580266438338*b[i + 337*ldb] + 0.9704208807564537*b[i + 362*ldb]);
        c[i + 38*ldc] = (-0.9704208807564537*b[i + 35*ldb] + 0.9285580266438338*b[i + 36*ldb] + -1.706075027753831*b[i + 37*ldb] + -0.7583532171678757*b[i + 38*ldb] + 3.812557894803954*b[i + 39*ldb] + 1.684026960320175*b[i + 153*ldb] + -2.021528935875383*b[i + 158*ldb] + 2.021528935875383*b[i + 168*ldb] + -1.684026960320175*b[i + 173*ldb] + -3.812557894803954*b[i + 263*ldb] + 0.7583532171678757*b[i + 288*ldb] + 1.706075027753831*b[i + 313*ldb] + -0.9285580266438338*b[i + 338*ldb] + 0.9704208807564537*b[i + 363*ldb]);
        c[i + 39*ldc] = (0.5517668509633159*b[i + 35*ldb] + -0.4937590750470338*b[i + 36*ldb] + 0.7231396289857297*b[i + 37*ldb] + -1.939864544376097*b[i + 38*ldb] + -5.06704059565454*b[i + 39*ldb] + 1.684026960320175*b[i + 154*ldb] + -2.021528935875383*b[i + 159*ldb] + 2.021528935875383*b[i + 169*ldb] + -1.684026960320175*b[i + 174*ldb] + -3.812557894803954*b[i + 264*ldb] + 0.7583532171678757*b[i + 289*ldb] + 1.706075027753831*b[i + 314*ldb] + -0.9285580266438338*b[i + 339*ldb] + 0.9704208807564537*b[i + 364*ldb]);
        c[i + 40*ldc] = (5.06704059565454*b[i + 40*ldb] + 1.939864544376097*b[i + 41*ldb] + -0.7231396289857297*b[i + 42*ldb] + 0.4937590750470338*b[i + 43*ldb] + -0.5517668509633159*b[i + 44*ldb] + -0.9704208807564537*b[i + 150*ldb] + 0.9285580266438338*b[i + 155*ldb] + -1.706075027753831*b[i + 160*ldb] + -0.7583532171678757*b[i + 165*ldb] + 3.812557894803954*b[i + 170*ldb] + -3.812557894803954*b[i + 265*ldb] + 0.7583532171678757*b[i + 290*ldb] + 1.706075027753831*b[i + 315*ldb] + -0.9285580266438338*b[i + 340*ldb] + 0.9704208807564537*b[i + 365*ldb]);
        c[i + 41*ldc] = (-3.812557894803954*b[i + 40*ldb] + 0.7583532171678757*b[i + 41*ldb] + 1.706075027753831*b[i + 42*ldb] + -0.9285580266438338*b[i + 43*ldb] + 0.9704208807564537*b[i + 44*ldb] + -0.9704208807564537*b[i + 151*ldb] + 0.9285580266438338*b[i + 156*ldb] + -1.706075027753831*b[i + 161*ldb] + -0.7583532171678757*b[i + 166*ldb] + 3.812557894803954*b[i + 171*ldb] + -3.812557894803954*b[i + 266*ldb] + 0.7583532171678757*b[i + 291*ldb] + 1.706075027753831*b[i + 316*ldb] + -0.9285580266438338*b[i + 341*ldb] + 0.9704208807564537*b[i + 366*ldb]);
        c[i + 42*ldc] = (1.684026960320175*b[i + 40*ldb] + -2.021528935875383*b[i + 41*ldb] + 2.021528935875383*b[i + 43*ldb] + -1.684026960320175*b[i + 44*ldb] + -0.9704208807564537*b[i + 152*ldb] + 0.9285580266438338*b[i + 157*ldb] + -1.706075027753831*b[i + 162*ldb] + -0.7583532171678757*b[i + 167*ldb] + 3.812557894803954*b[i + 172*ldb] + -3.812557894803954*b[i + 267*ldb] + 0.7583532171678757*b[i + 292*ldb] + 1.706075027753831*b[i + 317*ldb] + -0.9285580266438338*b[i + 342*ldb] + 0.9704208807564537*b[i + 367*ldb]);
        c[i + 43*ldc] = (-0.9704208807564537*b[i + 40*ldb] + 0.9285580266438338*b[i + 41*ldb] + -1.706075027753831*b[i + 42*ldb] + -0.7583532171678757*b[i + 43*ldb] + 3.812557894803954*b[i + 44*ldb] + -0.9704208807564537*b[i + 153*ldb] + 0.9285580266438338*b[i + 158*ldb] + -1.706075027753831*b[i + 163*ldb] + -0.7583532171678757*b[i + 168*ldb] + 3.812557894803954*b[i + 173*ldb] + -3.812557894803954*b[i + 268*ldb] + 0.7583532171678757*b[i + 293*ldb] + 1.706075027753831*b[i + 318*ldb] + -0.9285580266438338*b[i + 343*ldb] + 0.9704208807564537*b[i + 368*ldb]);
        c[i + 44*ldc] = (0.5517668509633159*b[i + 40*ldb] + -0.4937590750470338*b[i + 41*ldb] + 0.7231396289857297*b[i + 42*ldb] + -1.939864544376097*b[i + 43*ldb] + -5.06704059565454*b[i + 44*ldb] + -0.9704208807564537*b[i + 154*ldb] + 0.9285580266438338*b[i + 159*ldb] + -1.706075027753831*b[i + 164*ldb] + -0.7583532171678757*b[i + 169*ldb] + 3.812557894803954*b[i + 174*ldb] + -3.812557894803954*b[i + 269*ldb] + 0.7583532171678757*b[i + 294*ldb] + 1.706075027753831*b[i + 319*ldb] + -0.9285580266438338*b[i + 344*ldb] + 0.9704208807564537*b[i + 369*ldb]);
        c[i + 45*ldc] = (5.06704059565454*b[i + 45*ldb] + 1.939864544376097*b[i + 46*ldb] + -0.7231396289857297*b[i + 47*ldb] + 0.4937590750470338*b[i + 48*ldb] + -0.5517668509633159*b[i + 49*ldb] + 0.5517668509633159*b[i + 150*ldb] + -0.4937590750470338*b[i + 155*ldb] + 0.7231396289857297*b[i + 160*ldb] + -1.939864544376097*b[i + 165*ldb] + -5.06704059565454*b[i + 170*ldb] + -3.812557894803954*b[i + 270*ldb] + 0.7583532171678757*b[i + 295*ldb] + 1.706075027753831*b[i + 320*ldb] + -0.9285580266438338*b[i + 345*ldb] + 0.9704208807564537*b[i + 370*ldb]);
        c[i + 46*ldc] = (-3.812557894803954*b[i + 45*ldb] + 0.7583532171678757*b[i + 46*ldb] + 1.706075027753831*b[i + 47*ldb] + -0.9285580266438338*b[i + 48*ldb] + 0.9704208807564537*b[i + 49*ldb] + 0.5517668509633159*b[i + 151*ldb] + -0.4937590750470338*b[i + 156*ldb] + 0.7231396289857297*b[i + 161*ldb] + -1.939864544376097*b[i + 166*ldb] + -5.06704059565454*b[i + 171*ldb] + -3.812557894803954*b[i + 271*ldb] + 0.7583532171678757*b[i + 296*ldb] + 1.706075027753831*b[i + 321*ldb] + -0.9285580266438338*b[i + 346*ldb] + 0.9704208807564537*b[i + 371*ldb]);
        c[i + 47*ldc] = (1.684026960320175*b[i + 45*ldb] + -2.021528935875383*b[i + 46*ldb] + 2.021528935875383*b[i + 48*ldb] + -1.684026960320175*b[i + 49*ldb] + 0.5517668509633159*b[i + 152*ldb] + -0.4937590750470338*b[i + 157*ldb] + 0.7231396289857297*b[i + 162*ldb] + -1.939864544376097*b[i + 167*ldb] + -5.06704059565454*b[i + 172*ldb] + -3.812557894803954*b[i + 272*ldb] + 0.7583532171678757*b[i + 297*ldb] + 1.706075027753831*b[i + 322*ldb] + -0.9285580266438338*b[i + 347*ldb] + 0.9704208807564537*b[i + 372*ldb]);
        c[i + 48*ldc] = (-0.9704208807564537*b[i + 45*ldb] + 0.9285580266438338*b[i + 46*ldb] + -1.706075027753831*b[i + 47*ldb] + -0.7583532171678757*b[i + 48*ldb] + 3.812557894803954*b[i + 49*ldb] + 0.5517668509633159*b[i + 153*ldb] + -0.4937590750470338*b[i + 158*ldb] + 0.7231396289857297*b[i + 163*ldb] + -1.939864544376097*b[i + 168*ldb] + -5.06704059565454*b[i + 173*ldb] + -3.812557894803954*b[i + 273*ldb] + 0.7583532171678757*b[i + 298*ldb] + 1.706075027753831*b[i + 323*ldb] + -0.9285580266438338*b[i + 348*ldb] + 0.9704208807564537*b[i + 373*ldb]);
        c[i + 49*ldc] = (0.5517668509633159*b[i + 45*ldb] + -0.4937590750470338*b[i + 46*ldb] + 0.7231396289857297*b[i + 47*ldb] + -1.939864544376097*b[i + 48*ldb] + -5.06704059565454*b[i + 49*ldb] + 0.5517668509633159*b[i + 154*ldb] + -0.4937590750470338*b[i + 159*ldb] + 0.7231396289857297*b[i + 164*ldb] + -1.939864544376097*b[i + 169*ldb] + -5.06704059565454*b[i + 174*ldb] + -3.812557894803954*b[i + 274*ldb] + 0.7583532171678757*b[i + 299*ldb] + 1.706075027753831*b[i + 324*ldb] + -0.9285580266438338*b[i + 349*ldb] + 0.9704208807564537*b[i + 374*ldb]);
        c[i + 50*ldc] = (5.06704059565454*b[i + 50*ldb] + 1.939864544376097*b[i + 51*ldb] + -0.7231396289857297*b[i + 52*ldb] + 0.4937590750470338*b[i + 53*ldb] + -0.5517668509633159*b[i + 54*ldb] + 5.06704059565454*b[i + 175*ldb] + 1.939864544376097*b[i + 180*ldb] + -0.7231396289857297*b[i + 185*ldb] + 0.4937590750470338*b[i + 190*ldb] + -0.5517668509633159*b[i + 195*ldb] + 1.684026960320175*b[i + 250*ldb] + -2.021528935875383*b[i + 275*ldb] + 2.021528935875383*b[i + 325*ldb] + -1.684026960320175*b[i + 350*ldb]);
        c[i + 51*ldc] = (-3.812557894803954*b[i + 50*ldb] + 0.7583532171678757*b[i + 51*ldb] + 1.706075027753831*b[i + 52*ldb] + -0.9285580266438338*b[i + 53*ldb] + 0.9704208807564537*b[i + 54*ldb] + 5.06704059565454*b[i + 176*ldb] + 1.939864544376097*b[i + 181*ldb] + -0.7231396289857297*b[i + 186*ldb] + 0.4937590750470338*b[i + 191*ldb] + -0.5517668509633159*b[i + 196*ldb] + 1.684026960320175*b[i + 251*ldb] + -2.021528935875383*b[i + 276*ldb] + 2.021528935875383*b[i + 326*ldb] + -1.684026960320175*b[i + 351*ldb]);
        c[i + 52*ldc] = (1.684026960320175*b[i + 50*ldb] + -2.021528935875383*b[i + 51*ldb] + 2.021528935875383*b[i + 53*ldb] + -1.684026960320175*b[i + 54*ldb] + 5.06704059565454*b[i + 177*ldb] + 1.939864544376097*b[i + 182*ldb] + -0.7231396289857297*b[i + 187*ldb] + 0.4937590750470338*b[i + 192*ldb] + -0.5517668509633159*b[i + 197*ldb] + 1.684026960320175*b[i + 252*ldb] + -2.021528935875383*b[i + 277*ldb] + 2.021528935875383*b[i + 327*ldb] + -1.684026960320175*b[i + 352*ldb]);
        c[i + 53*ldc] = (-0.9704208807564537*b[i + 50*ldb] + 0.9285580266438338*b[i + 51*ldb] + -1.706075027753831*b[i + 52*ldb] + -0.7583532171678757*b[i + 53*ldb] + 3.812557894803954*b[i + 54*ldb] + 5.06704059565454*b[i + 178*ldb] + 1.939864544376097*b[i + 183*ldb] + -0.7231396289857297*b[i + 188*ldb] + 0.4937590750470338*b[i + 193*ldb] + -0.5517668509633159*b[i + 198*ldb] + 1.684026960320175*b[i + 253*ldb] + -2.021528935875383*b[i + 278*ldb] + 2.021528935875383*b[i + 328*ldb] + -1.684026960320175*b[i + 353*ldb]);
        c[i + 54*ldc] = (0.5517668509633159*b[i + 50*ldb] + -0.4937590750470338*b[i + 51*ldb] + 0.7231396289857297*b[i + 52*ldb] + -1.939864544376097*b[i + 53*ldb] + -5.06704059565454*b[i + 54*ldb] + 5.06704059565454*b[i + 179*ldb] + 1.939864544376097*b[i + 184*ldb] + -0.7231396289857297*b[i + 189*ldb] + 0.4937590750470338*b[i + 194*ldb] + -0.5517668509633159*b[i + 199*ldb] + 1.684026960320175*b[i + 254*ldb] + -2.021528935875383*b[i + 279*ldb] + 2.021528935875383*b[i + 329*ldb] + -1.684026960320175*b[i + 354*ldb]);
        c[i + 55*ldc] = (5.06704059565454*b[i + 55*ldb] + 1.939864544376097*b[i + 56*ldb] + -0.7231396289857297*b[i + 57*ldb] + 0.4937590750470338*b[i + 58*ldb] + -0.5517668509633159*b[i + 59*ldb] + -3.812557894803954*b[i + 175*ldb] + 0.7583532171678757*b[i + 180*ldb] + 1.706075027753831*b[i + 185*ldb] + -0.9285580266438338*b[i + 190*ldb] + 0.9704208807564537*b[i + 195*ldb] + 1.684026960320175*b[i + 255*ldb] + -2.021528935875383*b[i + 280*ldb] + 2.021528935875383*b[i + 330*ldb] + -1.684026960320175*b[i + 355*ldb]);
        c[i + 56*ldc] = (-3.812557894803954*b[i + 55*ldb] + 0.7583532171678757*b[i + 56*ldb] + 1.706075027753831*b[i + 57*ldb] + -0.9285580266438338*b[i + 58*ldb] + 0.9704208807564537*b[i + 59*ldb] + -3.812557894803954*b[i + 176*ldb] + 0.7583532171678757*b[i + 181*ldb] + 1.706075027753831*b[i + 186*ldb] + -0.9285580266438338*b[i + 191*ldb] + 0.9704208807564537*b[i + 196*ldb] + 1.684026960320175*b[i + 256*ldb] + -2.021528935875383*b[i + 281*ldb] + 2.021528935875383*b[i + 331*ldb] + -1.684026960320175*b[i + 356*ldb]);
        c[i + 57*ldc] = (1.684026960320175*b[i + 55*ldb] + -2.021528935875383*b[i + 56*ldb] + 2.021528935875383*b[i + 58*ldb] + -1.684026960320175*b[i + 59*ldb] + -3.812557894803954*b[i + 177*ldb] + 0.7583532171678757*b[i + 182*ldb] + 1.706075027753831*b[i + 187*ldb] + -0.9285580266438338*b[i + 192*ldb] + 0.9704208807564537*b[i + 197*ldb] + 1.684026960320175*b[i + 257*ldb] + -2.021528935875383*b[i + 282*ldb] + 2.021528935875383*b[i + 332*ldb] + -1.684026960320175*b[i + 357*ldb]);
        c[i + 58*ldc] = (-0.9704208807564537*b[i + 55*ldb] + 0.9285580266438338*b[i + 56*ldb] + -1.706075027753831*b[i + 57*ldb] + -0.7583532171678757*b[i + 58*ldb] + 3.812557894803954*b[i + 59*ldb] + -3.812557894803954*b[i + 178*ldb] + 0.7583532171678757*b[i + 183*ldb] + 1.706075027753831*b[i + 188*ldb] + -0.9285580266438338*b[i + 193*ldb] + 0.9704208807564537*b[i + 198*ldb] + 1.684026960320175*b[i + 258*ldb] + -2.021528935875383*b[i + 283*ldb] + 2.021528935875383*b[i + 333*ldb] + -1.684026960320175*b[i + 358*ldb]);
        c[i + 59*ldc] = (0.5517668509633159*b[i + 55*ldb] + -0.4937590750470338*b[i + 56*ldb] + 0.7231396289857297*b[i + 57*ldb] + -1.939864544376097*b[i + 58*ldb] + -5.06704059565454*b[i + 59*ldb] + -3.812557894803954*b[i + 179*ldb] + 0.7583532171678757*b[i + 184*ldb] + 1.706075027753831*b[i + 189*ldb] + -0.9285580266438338*b[i + 194*ldb] + 0.9704208807564537*b[i + 199*ldb] + 1.684026960320175*b[i + 259*ldb] + -2.021528935875383*b[i + 284*ldb] + 2.021528935875383*b[i + 334*ldb] + -1.684026960320175*b[i + 359*ldb]);
        c[i + 60*ldc] = (5.06704059565454*b[i + 60*ldb] + 1.939864544376097*b[i + 61*ldb] + -0.7231396289857297*b[i + 62*ldb] + 0.4937590750470338*b[i + 63*ldb] + -0.5517668509633159*b[i + 64*ldb] + 1.684026960320175*b[i + 175*ldb] + -2.021528935875383*b[i + 180*ldb] + 2.021528935875383*b[i + 190*ldb] + -1.684026960320175*b[i + 195*ldb] + 1.684026960320175*b[i + 260*ldb] + -2.021528935875383*b[i + 285*ldb] + 2.021528935875383*b[i + 335*ldb] + -1.684026960320175*b[i + 360*ldb]);
        c[i + 61*ldc] = (-3.812557894803954*b[i + 60*ldb] + 0.7583532171678757*b[i + 61*ldb] + 1.706075027753831*b[i + 62*ldb] + -0.9285580266438338*b[i + 63*ldb] + 0.9704208807564537*b[i + 64*ldb] + 1.684026960320175*b[i + 176*ldb] + -2.021528935875383*b[i + 181*ldb] + 2.021528935875383*b[i + 191*ldb] + -1.684026960320175*b[i + 196*ldb] + 1.684026960320175*b[i + 261*ldb] + -2.021528935875383*b[i + 286*ldb] + 2.021528935875383*b[i + 336*ldb] + -1.684026960320175*b[i + 361*ldb]);
        c[i + 62*ldc] = (1.684026960320175*b[i + 60*ldb] + -2.021528935875383*b[i + 61*ldb] + 2.021528935875383*b[i + 63*ldb] + -1.684026960320175*b[i + 64*ldb] + 1.684026960320175*b[i + 177*ldb] + -2.021528935875383*b[i + 182*ldb] + 2.021528935875383*b[i + 192*ldb] + -1.684026960320175*b[i + 197*ldb] + 1.684026960320175*b[i + 262*ldb] + -2.021528935875383*b[i + 287*ldb] + 2.021528935875383*b[i + 337*ldb] + -1.684026960320175*b[i + 362*ldb]);
        c[i + 63*ldc] = (-0.9704208807564537*b[i + 60*ldb] + 0.9285580266438338*b[i + 61*ldb] + -1.706075027753831*b[i + 62*ldb] + -0.7583532171678757*b[i + 63*ldb] + 3.812557894803954*b[i + 64*ldb] + 1.684026960320175*b[i + 178*ldb] + -2.021528935875383*b[i + 183*ldb] + 2.021528935875383*b[i + 193*ldb] + -1.684026960320175*b[i + 198*ldb] + 1.684026960320175*b[i + 263*ldb] + -2.021528935875383*b[i + 288*ldb] + 2.021528935875383*b[i + 338*ldb] + -1.684026960320175*b[i + 363*ldb]);
        c[i + 64*ldc] = (0.5517668509633159*b[i + 60*ldb] + -0.4937590750470338*b[i + 61*ldb] + 0.7231396289857297*b[i + 62*ldb] + -1.939864544376097*b[i + 63*ldb] + -5.06704059565454*b[i + 64*ldb] + 1.684026960320175*b[i + 179*ldb] + -2.021528935875383*b[i + 184*ldb] + 2.021528935875383*b[i + 194*ldb] + -1.684026960320175*b[i + 199*ldb] + 1.684026960320175*b[i + 264*ldb] + -2.021528935875383*b[i + 289*ldb] + 2.021528935875383*b[i + 339*ldb] + -1.684026960320175*b[i + 364*ldb]);
        c[i + 65*ldc] = (5.06704059565454*b[i + 65*ldb] + 1.939864544376097*b[i + 66*ldb] + -0.7231396289857297*b[i + 67*ldb] + 0.4937590750470338*b[i + 68*ldb] + -0.5517668509633159*b[i + 69*ldb] + -0.9704208807564537*b[i + 175*ldb] + 0.9285580266438338*b[i + 180*ldb] + -1.706075027753831*b[i + 185*ldb] + -0.7583532171678757*b[i + 190*ldb] + 3.812557894803954*b[i + 195*ldb] + 1.684026960320175*b[i + 265*ldb] + -2.021528935875383*b[i + 290*ldb] + 2.021528935875383*b[i + 340*ldb] + -1.684026960320175*b[i + 365*ldb]);
        c[i + 66*ldc] = (-3.812557894803954*b[i + 65*ldb] + 0.7583532171678757*b[i + 66*ldb] + 1.706075027753831*b[i + 67*ldb] + -0.9285580266438338*b[i + 68*ldb] + 0.9704208807564537*b[i + 69*ldb] + -0.9704208807564537*b[i + 176*ldb] + 0.9285580266438338*b[i + 181*ldb] + -1.706075027753831*b[i + 186*ldb] + -0.7583532171678757*b[i + 191*ldb] + 3.812557894803954*b[i + 196*ldb] + 1.684026960320175*b[i + 266*ldb] + -2.021528935875383*b[i + 291*ldb] + 2.021528935875383*b[i + 341*ldb] + -1.684026960320175*b[i + 366*ldb]);
        c[i + 67*ldc] = (1.684026960320175*b[i + 65*ldb] + -2.021528935875383*b[i + 66*ldb] + 2.021528935875383*b[i + 68*ldb] + -1.684026960320175*b[i + 69*ldb] + -0.9704208807564537*b[i + 177*ldb] + 0.9285580266438338*b[i + 182*ldb] + -1.706075027753831*b[i + 187*ldb] + -0.7583532171678757*b[i + 192*ldb] + 3.812557894803954*b[i + 197*ldb] + 1.684026960320175*b[i + 267*ldb] + -2.021528935875383*b[i + 292*ldb] + 2.021528935875383*b[i + 342*ldb] + -1.684026960320175*b[i + 367*ldb]);
        c[i + 68*ldc] = (-0.9704208807564537*b[i + 65*ldb] + 0.9285580266438338*b[i + 66*ldb] + -1.706075027753831*b[i + 67*ldb] + -0.7583532171678757*b[i + 68*ldb] + 3.812557894803954*b[i + 69*ldb] + -0.9704208807564537*b[i + 178*ldb] + 0.9285580266438338*b[i + 183*ldb] + -1.706075027753831*b[i + 188*ldb] + -0.7583532171678757*b[i + 193*ldb] + 3.812557894803954*b[i + 198*ldb] + 1.684026960320175*b[i + 268*ldb] + -2.021528935875383*b[i + 293*ldb] + 2.021528935875383*b[i + 343*ldb] + -1.684026960320175*b[i + 368*ldb]);
        c[i + 69*ldc] = (0.5517668509633159*b[i + 65*ldb] + -0.4937590750470338*b[i + 66*ldb] + 0.7231396289857297*b[i + 67*ldb] + -1.939864544376097*b[i + 68*ldb] + -5.06704059565454*b[i + 69*ldb] + -0.9704208807564537*b[i + 179*ldb] + 0.9285580266438338*b[i + 184*ldb] + -1.706075027753831*b[i + 189*ldb] + -0.7583532171678757*b[i + 194*ldb] + 3.812557894803954*b[i + 199*ldb] + 1.684026960320175*b[i + 269*ldb] + -2.021528935875383*b[i + 294*ldb] + 2.021528935875383*b[i + 344*ldb] + -1.684026960320175*b[i + 369*ldb]);
        c[i + 70*ldc] = (5.06704059565454*b[i + 70*ldb] + 1.939864544376097*b[i + 71*ldb] + -0.7231396289857297*b[i + 72*ldb] + 0.4937590750470338*b[i + 73*ldb] + -0.5517668509633159*b[i + 74*ldb] + 0.5517668509633159*b[i + 175*ldb] + -0.4937590750470338*b[i + 180*ldb] + 0.7231396289857297*b[i + 185*ldb] + -1.939864544376097*b[i + 190*ldb] + -5.06704059565454*b[i + 195*ldb] + 1.684026960320175*b[i + 270*ldb] + -2.021528935875383*b[i + 295*ldb] + 2.021528935875383*b[i + 345*ldb] + -1.684026960320175*b[i + 370*ldb]);
        c[i + 71*ldc] = (-3.812557894803954*b[i + 70*ldb] + 0.7583532171678757*b[i + 71*ldb] + 1.706075027753831*b[i + 72*ldb] + -0.9285580266438338*b[i + 73*ldb] + 0.9704208807564537*b[i + 74*ldb] + 0.5517668509633159*b[i + 176*ldb] + -0.4937590750470338*b[i + 181*ldb] + 0.7231396289857297*b[i + 186*ldb] + -1.939864544376097*b[i + 191*ldb] + -5.06704059565454*b[i + 196*ldb] + 1.684026960320175*b[i + 271*ldb] + -2.021528935875383*b[i + 296*ldb] + 2.021528935875383*b[i + 346*ldb] + -1.684026960320175*b[i + 371*ldb]);
        c[i + 72*ldc] = (1.684026960320175*b[i + 70*ldb] + -2.021528935875383*b[i + 71*ldb] + 2.021528935875383*b[i + 73*ldb] + -1.684026960320175*b[i + 74*ldb] + 0.5517668509633159*b[i + 177*ldb] + -0.4937590750470338*b[i + 182*ldb] + 0.7231396289857297*b[i + 187*ldb] + -1.939864544376097*b[i + 192*ldb] + -5.06704059565454*b[i + 197*ldb] + 1.684026960320175*b[i + 272*ldb] + -2.021528935875383*b[i + 297*ldb] + 2.021528935875383*b[i + 347*ldb] + -1.684026960320175*b[i + 372*ldb]);
        c[i + 73*ldc] = (-0.9704208807564537*b[i + 70*ldb] + 0.9285580266438338*b[i + 71*ldb] + -1.706075027753831*b[i + 72*ldb] + -0.7583532171678757*b[i + 73*ldb] + 3.812557894803954*b[i + 74*ldb] + 0.5517668509633159*b[i + 178*ldb] + -0.4937590750470338*b[i + 183*ldb] + 0.7231396289857297*b[i + 188*ldb] + -1.939864544376097*b[i + 193*ldb] + -5.06704059565454*b[i + 198*ldb] + 1.684026960320175*b[i + 273*ldb] + -2.021528935875383*b[i + 298*ldb] + 2.021528935875383*b[i + 348*ldb] + -1.684026960320175*b[i + 373*ldb]);
        c[i + 74*ldc] = (0.5517668509633159*b[i + 70*ldb] + -0.4937590750470338*b[i + 71*ldb] + 0.7231396289857297*b[i + 72*ldb] + -1.939864544376097*b[i + 73*ldb] + -5.06704059565454*b[i + 74*ldb] + 0.5517668509633159*b[i + 179*ldb] + -0.4937590750470338*b[i + 184*ldb] + 0.7231396289857297*b[i + 189*ldb] + -1.939864544376097*b[i + 194*ldb] + -5.06704059565454*b[i + 199*ldb] + 1.684026960320175*b[i + 274*ldb] + -2.021528935875383*b[i + 299*ldb] + 2.021528935875383*b[i + 349*ldb] + -1.684026960320175*b[i + 374*ldb]);
        c[i + 75*ldc] = (5.06704059565454*b[i + 75*ldb] + 1.939864544376097*b[i + 76*ldb] + -0.7231396289857297*b[i + 77*ldb] + 0.4937590750470338*b[i + 78*ldb] + -0.5517668509633159*b[i + 79*ldb] + 5.06704059565454*b[i + 200*ldb] + 1.939864544376097*b[i + 205*ldb] + -0.7231396289857297*b[i + 210*ldb] + 0.4937590750470338*b[i + 215*ldb] + -0.5517668509633159*b[i + 220*ldb] + -0.9704208807564537*b[i + 250*ldb] + 0.9285580266438338*b[i + 275*ldb] + -1.706075027753831*b[i + 300*ldb] + -0.7583532171678757*b[i + 325*ldb] + 3.812557894803954*b[i + 350*ldb]);
        c[i + 76*ldc] = (-3.812557894803954*b[i + 75*ldb] + 0.7583532171678757*b[i + 76*ldb] + 1.706075027753831*b[i + 77*ldb] + -0.9285580266438338*b[i + 78*ldb] + 0.9704208807564537*b[i + 79*ldb] + 5.06704059565454*b[i + 201*ldb] + 1.939864544376097*b[i + 206*ldb] + -0.7231396289857297*b[i + 211*ldb] + 0.4937590750470338*b[i + 216*ldb] + -0.5517668509633159*b[i + 221*ldb] + -0.9704208807564537*b[i + 251*ldb] + 0.9285580266438338*b[i + 276*ldb] + -1.706075027753831*b[i + 301*ldb] + -0.7583532171678757*b[i + 326*ldb] + 3.812557894803954*b[i + 351*ldb]);
        c[i + 77*ldc] = (1.684026960320175*b[i + 75*ldb] + -2.021528935875383*b[i + 76*ldb] + 2.021528935875383*b[i + 78*ldb] + -1.684026960320175*b[i + 79*ldb] + 5.06704059565454*b[i + 202*ldb] + 1.939864544376097*b[i + 207*ldb] + -0.7231396289857297*b[i + 212*ldb] + 0.4937590750470338*b[i + 217*ldb] + -0.5517668509633159*b[i + 222*ldb] + -0.9704208807564537*b[i + 252*ldb] + 0.9285580266438338*b[i + 277*ldb] + -1.706075027753831*b[i + 302*ldb] + -0.7583532171678757*b[i + 327*ldb] + 3.812557894803954*b[i + 352*ldb]);
        c[i + 78*ldc] = (-0.9704208807564537*b[i + 75*ldb] + 0.9285580266438338*b[i + 76*ldb] + -1.706075027753831*b[i + 77*ldb] + -0.7583532171678757*b[i + 78*ldb] + 3.812557894803954*b[i + 79*ldb] + 5.06704059565454*b[i + 203*ldb] + 1.939864544376097*b[i + 208*ldb] + -0.7231396289857297*b[i + 213*ldb] + 0.4937590750470338*b[i + 218*ldb] + -0.5517668509633159*b[i + 223*ldb] + -0.9704208807564537*b[i + 253*ldb] + 0.9285580266438338*b[i + 278*ldb] + -1.706075027753831*b[i + 303*ldb] + -0.7583532171678757*b[i + 328*ldb] + 3.812557894803954*b[i + 353*ldb]);
        c[i + 79*ldc] = (0.5517668509633159*b[i + 75*ldb] + -0.4937590750470338*b[i + 76*ldb] + 0.7231396289857297*b[i + 77*ldb] + -1.939864544376097*b[i + 78*ldb] + -5.06704059565454*b[i + 79*ldb] + 5.06704059565454*b[i + 204*ldb] + 1.939864544376097*b[i + 209*ldb] + -0.7231396289857297*b[i + 214*ldb] + 0.4937590750470338*b[i + 219*ldb] + -0.5517668509633159*b[i + 224*ldb] + -0.9704208807564537*b[i + 254*ldb] + 0.9285580266438338*b[i + 279*ldb] + -1.706075027753831*b[i + 304*ldb] + -0.7583532171678757*b[i + 329*ldb] + 3.812557894803954*b[i + 354*ldb]);
        c[i + 80*ldc] = (5.06704059565454*b[i + 80*ldb] + 1.939864544376097*b[i + 81*ldb] + -0.7231396289857297*b[i + 82*ldb] + 0.4937590750470338*b[i + 83*ldb] + -0.5517668509633159*b[i + 84*ldb] + -3.812557894803954*b[i + 200*ldb] + 0.7583532171678757*b[i + 205*ldb] + 1.706075027753831*b[i + 210*ldb] + -0.9285580266438338*b[i + 215*ldb] + 0.9704208807564537*b[i + 220*ldb] + -0.9704208807564537*b[i + 255*ldb] + 0.9285580266438338*b[i + 280*ldb] + -1.706075027753831*b[i + 305*ldb] + -0.7583532171678757*b[i + 330*ldb] + 3.812557894803954*b[i + 355*ldb]);
        c[i + 81*ldc] = (-3.812557894803954*b[i + 80*ldb] + 0.7583532171678757*b[i + 81*ldb] + 1.706075027753831*b[i + 82*ldb] + -0.9285580266438338*b[i + 83*ldb] + 0.9704208807564537*b[i + 84*ldb] + -3.812557894803954*b[i + 201*ldb] + 0.7583532171678757*b[i + 206*ldb] + 1.706075027753831*b[i + 211*ldb] + -0.9285580266438338*b[i + 216*ldb] + 0.9704208807564537*b[i + 221*ldb] + -0.9704208807564537*b[i + 256*ldb] + 0.9285580266438338*b[i + 281*ldb] + -1.706075027753831*b[i + 306*ldb] + -0.7583532171678757*b[i + 331*ldb] + 3.812557894803954*b[i + 356*ldb]);
        c[i + 82*ldc] = (1.684026960320175*b[i + 80*ldb] + -2.021528935875383*b[i + 81*ldb] + 2.021528935875383*b[i + 83*ldb] + -1.684026960320175*b[i + 84*ldb] + -3.812557894803954*b[i + 202*ldb] + 0.7583532171678757*b[i + 207*ldb] + 1.706075027753831*b[i + 212*ldb] + -0.9285580266438338*b[i + 217*ldb] + 0.9704208807564537*b[i + 222*ldb] + -0.9704208807564537*b[i + 257*ldb] + 0.9285580266438338*b[i + 282*ldb] + -1.706075027753831*b[i + 307*ldb] + -0.7583532171678757*b[i + 332*ldb] + 3.812557894803954*b[i + 357*ldb]);
        c[i + 83*ldc] = (-0.9704208807564537*b[i + 80*ldb] + 0.9285580266438338*b[i + 81*ldb] + -1.706075027753831*b[i + 82*ldb] + -0.7583532171678757*b[i + 83*ldb] + 3.812557894803954*b[i + 84*ldb] + -3.812557894803954*b[i + 203*ldb] + 0.7583532171678757*b[i + 208*ldb] + 1.706075027753831*b[i + 213*ldb] + -0.9285580266438338*b[i + 218*ldb] + 0.9704208807564537*b[i + 223*ldb] + -0.9704208807564537*b[i + 258*ldb] + 0.9285580266438338*b[i + 283*ldb] + -1.706075027753831*b[i + 308*ldb] + -0.7583532171678757*b[i + 333*ldb] + 3.812557894803954*b[i + 358*ldb]);
        c[i + 84*ldc] = (0.5517668509633159*b[i + 80*ldb] + -0.4937590750470338*b[i + 81*ldb] + 0.7231396289857297*b[i + 82*ldb] + -1.939864544376097*b[i + 83*ldb] + -5.06704059565454*b[i + 84*ldb] + -3.812557894803954*b[i + 204*ldb] + 0.7583532171678757*b[i + 209*ldb] + 1.706075027753831*b[i + 214*ldb] + -0.9285580266438338*b[i + 219*ldb] + 0.9704208807564537*b[i + 224*ldb] + -0.9704208807564537*b[i + 259*ldb] + 0.9285580266438338*b[i + 284*ldb] + -1.706075027753831*b[i + 309*ldb] + -0.7583532171678757*b[i + 334*ldb] + 3.812557894803954*b[i + 359*ldb]);
        c[i + 85*ldc] = (5.06704059565454*b[i + 85*ldb] + 1.939864544376097*b[i + 86*ldb] + -0.7231396289857297*b[i + 87*ldb] + 0.4937590750470338*b[i + 88*ldb] + -0.5517668509633159*b[i + 89*ldb] + 1.684026960320175*b[i + 200*ldb] + -2.021528935875383*b[i + 205*ldb] + 2.021528935875383*b[i + 215*ldb] + -1.684026960320175*b[i + 220*ldb] + -0.9704208807564537*b[i + 260*ldb] + 0.9285580266438338*b[i + 285*ldb] + -1.706075027753831*b[i + 310*ldb] + -0.7583532171678757*b[i + 335*ldb] + 3.812557894803954*b[i + 360*ldb]);
        c[i + 86*ldc] = (-3.812557894803954*b[i + 85*ldb] + 0.7583532171678757*b[i + 86*ldb] + 1.706075027753831*b[i + 87*ldb] + -0.9285580266438338*b[i + 88*ldb] + 0.9704208807564537*b[i + 89*ldb] + 1.684026960320175*b[i + 201*ldb] + -2.021528935875383*b[i + 206*ldb] + 2.021528935875383*b[i + 216*ldb] + -1.684026960320175*b[i + 221*ldb] + -0.9704208807564537*b[i + 261*ldb] + 0.9285580266438338*b[i + 286*ldb] + -1.706075027753831*b[i + 311*ldb] + -0.7583532171678757*b[i + 336*ldb] + 3.812557894803954*b[i + 361*ldb]);
        c[i + 87*ldc] = (1.684026960320175*b[i + 85*ldb] + -2.021528935875383*b[i + 86*ldb] + 2.021528935875383*b[i + 88*ldb] + -1.684026960320175*b[i + 89*ldb] + 1.684026960320175*b[i + 202*ldb] + -2.021528935875383*b[i + 207*ldb] + 2.021528935875383*b[i + 217*ldb] + -1.684026960320175*b[i + 222*ldb] + -0.9704208807564537*b[i + 262*ldb] + 0.9285580266438338*b[i + 287*ldb] + -1.706075027753831*b[i + 312*ldb] + -0.7583532171678757*b[i + 337*ldb] + 3.812557894803954*b[i + 362*ldb]);
        c[i + 88*ldc] = (-0.9704208807564537*b[i + 85*ldb] + 0.9285580266438338*b[i + 86*ldb] + -1.706075027753831*b[i + 87*ldb] + -0.7583532171678757*b[i + 88*ldb] + 3.812557894803954*b[i + 89*ldb] + 1.684026960320175*b[i + 203*ldb] + -2.021528935875383*b[i + 208*ldb] + 2.021528935875383*b[i + 218*ldb] + -1.684026960320175*b[i + 223*ldb] + -0.9704208807564537*b[i + 263*ldb] + 0.9285580266438338*b[i + 288*ldb] + -1.706075027753831*b[i + 313*ldb] + -0.7583532171678757*b[i + 338*ldb] + 3.812557894803954*b[i + 363*ldb]);
        c[i + 89*ldc] = (0.5517668509633159*b[i + 85*ldb] + -0.4937590750470338*b[i + 86*ldb] + 0.7231396289857297*b[i + 87*ldb] + -1.939864544376097*b[i + 88*ldb] + -5.06704059565454*b[i + 89*ldb] + 1.684026960320175*b[i + 204*ldb] + -2.021528935875383*b[i + 209*ldb] + 2.021528935875383*b[i + 219*ldb] + -1.684026960320175*b[i + 224*ldb] + -0.9704208807564537*b[i + 264*ldb] + 0.9285580266438338*b[i + 289*ldb] + -1.706075027753831*b[i + 314*ldb] + -0.7583532171678757*b[i + 339*ldb] + 3.812557894803954*b[i + 364*ldb]);
        c[i + 90*ldc] = (5.06704059565454*b[i + 90*ldb] + 1.939864544376097*b[i + 91*ldb] + -0.7231396289857297*b[i + 92*ldb] + 0.4937590750470338*b[i + 93*ldb] + -0.5517668509633159*b[i + 94*ldb] + -0.9704208807564537*b[i + 200*ldb] + 0.9285580266438338*b[i + 205*ldb] + -1.706075027753831*b[i + 210*ldb] + -0.7583532171678757*b[i + 215*ldb] + 3.812557894803954*b[i + 220*ldb] + -0.9704208807564537*b[i + 265*ldb] + 0.9285580266438338*b[i + 290*ldb] + -1.706075027753831*b[i + 315*ldb] + -0.7583532171678757*b[i + 340*ldb] + 3.812557894803954*b[i + 365*ldb]);
        c[i + 91*ldc] = (-3.812557894803954*b[i + 90*ldb] + 0.7583532171678757*b[i + 91*ldb] + 1.706075027753831*b[i + 92*ldb] + -0.9285580266438338*b[i + 93*ldb] + 0.9704208807564537*b[i + 94*ldb] + -0.9704208807564537*b[i + 201*ldb] + 0.9285580266438338*b[i + 206*ldb] + -1.706075027753831*b[i + 211*ldb] + -0.7583532171678757*b[i + 216*ldb] + 3.812557894803954*b[i + 221*ldb] + -0.9704208807564537*b[i + 266*ldb] + 0.9285580266438338*b[i + 291*ldb] + -1.706075027753831*b[i + 316*ldb] + -0.7583532171678757*b[i + 341*ldb] + 3.812557894803954*b[i + 366*ldb]);
        c[i + 92*ldc] = (1.684026960320175*b[i + 90*ldb] + -2.021528935875383*b[i + 91*ldb] + 2.021528935875383*b[i + 93*ldb] + -1.684026960320175*b[i + 94*ldb] + -0.9704208807564537*b[i + 202*ldb] + 0.9285580266438338*b[i + 207*ldb] + -1.706075027753831*b[i + 212*ldb] + -0.7583532171678757*b[i + 217*ldb] + 3.812557894803954*b[i + 222*ldb] + -0.9704208807564537*b[i + 267*ldb] + 0.9285580266438338*b[i + 292*ldb] + -1.706075027753831*b[i + 317*ldb] + -0.7583532171678757*b[i + 342*ldb] + 3.812557894803954*b[i + 367*ldb]);
        c[i + 93*ldc] = (-0.9704208807564537*b[i + 90*ldb] + 0.9285580266438338*b[i + 91*ldb] + -1.706075027753831*b[i + 92*ldb] + -0.7583532171678757*b[i + 93*ldb] + 3.812557894803954*b[i + 94*ldb] + -0.9704208807564537*b[i + 203*ldb] + 0.9285580266438338*b[i + 208*ldb] + -1.706075027753831*b[i + 213*ldb] + -0.7583532171678757*b[i + 218*ldb] + 3.812557894803954*b[i + 223*ldb] + -0.9704208807564537*b[i + 268*ldb] + 0.9285580266438338*b[i + 293*ldb] + -1.706075027753831*b[i + 318*ldb] + -0.7583532171678757*b[i + 343*ldb] + 3.812557894803954*b[i + 368*ldb]);
        c[i + 94*ldc] = (0.5517668509633159*b[i + 90*ldb] + -0.4937590750470338*b[i + 91*ldb] + 0.7231396289857297*b[i + 92*ldb] + -1.939864544376097*b[i + 93*ldb] + -5.06704059565454*b[i + 94*ldb] + -0.9704208807564537*b[i + 204*ldb] + 0.9285580266438338*b[i + 209*ldb] + -1.706075027753831*b[i + 214*ldb] + -0.7583532171678757*b[i + 219*ldb] + 3.812557894803954*b[i + 224*ldb] + -0.9704208807564537*b[i + 269*ldb] + 0.9285580266438338*b[i + 294*ldb] + -1.706075027753831*b[i + 319*ldb] + -0.7583532171678757*b[i + 344*ldb] + 3.812557894803954*b[i + 369*ldb]);
        c[i + 95*ldc] = (5.06704059565454*b[i + 95*ldb] + 1.939864544376097*b[i + 96*ldb] + -0.7231396289857297*b[i + 97*ldb] + 0.4937590750470338*b[i + 98*ldb] + -0.5517668509633159*b[i + 99*ldb] + 0.5517668509633159*b[i + 200*ldb] + -0.4937590750470338*b[i + 205*ldb] + 0.7231396289857297*b[i + 210*ldb] + -1.939864544376097*b[i + 215*ldb] + -5.06704059565454*b[i + 220*ldb] + -0.9704208807564537*b[i + 270*ldb] + 0.9285580266438338*b[i + 295*ldb] + -1.706075027753831*b[i + 320*ldb] + -0.7583532171678757*b[i + 345*ldb] + 3.812557894803954*b[i + 370*ldb]);
        c[i + 96*ldc] = (-3.812557894803954*b[i + 95*ldb] + 0.7583532171678757*b[i + 96*ldb] + 1.706075027753831*b[i + 97*ldb] + -0.9285580266438338*b[i + 98*ldb] + 0.9704208807564537*b[i + 99*ldb] + 0.5517668509633159*b[i + 201*ldb] + -0.4937590750470338*b[i + 206*ldb] + 0.7231396289857297*b[i + 211*ldb] + -1.939864544376097*b[i + 216*ldb] + -5.06704059565454*b[i + 221*ldb] + -0.9704208807564537*b[i + 271*ldb] + 0.9285580266438338*b[i + 296*ldb] + -1.706075027753831*b[i + 321*ldb] + -0.7583532171678757*b[i + 346*ldb] + 3.812557894803954*b[i + 371*ldb]);
        c[i + 97*ldc] = (1.684026960320175*b[i + 95*ldb] + -2.021528935875383*b[i + 96*ldb] + 2.021528935875383*b[i + 98*ldb] + -1.684026960320175*b[i + 99*ldb] + 0.5517668509633159*b[i + 202*ldb] + -0.4937590750470338*b[i + 207*ldb] + 0.7231396289857297*b[i + 212*ldb] + -1.939864544376097*b[i + 217*ldb] + -5.06704059565454*b[i + 222*ldb] + -0.9704208807564537*b[i + 272*ldb] + 0.9285580266438338*b[i + 297*ldb] + -1.706075027753831*b[i + 322*ldb] + -0.7583532171678757*b[i + 347*ldb] + 3.812557894803954*b[i + 372*ldb]);
        c[i + 98*ldc] = (-0.9704208807564537*b[i + 95*ldb] + 0.9285580266438338*b[i + 96*ldb] + -1.706075027753831*b[i + 97*ldb] + -0.7583532171678757*b[i + 98*ldb] + 3.812557894803954*b[i + 99*ldb] + 0.5517668509633159*b[i + 203*ldb] + -0.4937590750470338*b[i + 208*ldb] + 0.7231396289857297*b[i + 213*ldb] + -1.939864544376097*b[i + 218*ldb] + -5.06704059565454*b[i + 223*ldb] + -0.9704208807564537*b[i + 273*ldb] + 0.9285580266438338*b[i + 298*ldb] + -1.706075027753831*b[i + 323*ldb] + -0.7583532171678757*b[i + 348*ldb] + 3.812557894803954*b[i + 373*ldb]);
        c[i + 99*ldc] = (0.5517668509633159*b[i + 95*ldb] + -0.4937590750470338*b[i + 96*ldb] + 0.7231396289857297*b[i + 97*ldb] + -1.939864544376097*b[i + 98*ldb] + -5.06704059565454*b[i + 99*ldb] + 0.5517668509633159*b[i + 204*ldb] + -0.4937590750470338*b[i + 209*ldb] + 0.7231396289857297*b[i + 214*ldb] + -1.939864544376097*b[i + 219*ldb] + -5.06704059565454*b[i + 224*ldb] + -0.9704208807564537*b[i + 274*ldb] + 0.9285580266438338*b[i + 299*ldb] + -1.706075027753831*b[i + 324*ldb] + -0.7583532171678757*b[i + 349*ldb] + 3.812557894803954*b[i + 374*ldb]);
        c[i + 100*ldc] = (5.06704059565454*b[i + 100*ldb] + 1.939864544376097*b[i + 101*ldb] + -0.7231396289857297*b[i + 102*ldb] + 0.4937590750470338*b[i + 103*ldb] + -0.5517668509633159*b[i + 104*ldb] + 5.06704059565454*b[i + 225*ldb] + 1.939864544376097*b[i + 230*ldb] + -0.7231396289857297*b[i + 235*ldb] + 0.4937590750470338*b[i + 240*ldb] + -0.5517668509633159*b[i + 245*ldb] + 0.5517668509633159*b[i + 250*ldb] + -0.4937590750470338*b[i + 275*ldb] + 0.7231396289857297*b[i + 300*ldb] + -1.939864544376097*b[i + 325*ldb] + -5.06704059565454*b[i + 350*ldb]);
        c[i + 101*ldc] = (-3.812557894803954*b[i + 100*ldb] + 0.7583532171678757*b[i + 101*ldb] + 1.706075027753831*b[i + 102*ldb] + -0.9285580266438338*b[i + 103*ldb] + 0.9704208807564537*b[i + 104*ldb] + 5.06704059565454*b[i + 226*ldb] + 1.939864544376097*b[i + 231*ldb] + -0.7231396289857297*b[i + 236*ldb] + 0.4937590750470338*b[i + 241*ldb] + -0.5517668509633159*b[i + 246*ldb] + 0.5517668509633159*b[i + 251*ldb] + -0.4937590750470338*b[i + 276*ldb] + 0.7231396289857297*b[i + 301*ldb] + -1.939864544376097*b[i + 326*ldb] + -5.06704059565454*b[i + 351*ldb]);
        c[i + 102*ldc] = (1.684026960320175*b[i + 100*ldb] + -2.021528935875383*b[i + 101*ldb] + 2.021528935875383*b[i + 103*ldb] + -1.684026960320175*b[i + 104*ldb] + 5.06704059565454*b[i + 227*ldb] + 1.939864544376097*b[i + 232*ldb] + -0.7231396289857297*b[i + 237*ldb] + 0.4937590750470338*b[i + 242*ldb] + -0.5517668509633159*b[i + 247*ldb] + 0.5517668509633159*b[i + 252*ldb] + -0.4937590750470338*b[i + 277*ldb] + 0.7231396289857297*b[i + 302*ldb] + -1.939864544376097*b[i + 327*ldb] + -5.06704059565454*b[i + 352*ldb]);
        c[i + 103*ldc] = (-0.9704208807564537*b[i + 100*ldb] + 0.9285580266438338*b[i + 101*ldb] + -1.706075027753831*b[i + 102*ldb] + -0.7583532171678757*b[i + 103*ldb] + 3.812557894803954*b[i + 104*ldb] + 5.06704059565454*b[i + 228*ldb] + 1.939864544376097*b[i + 233*ldb] + -0.7231396289857297*b[i + 238*ldb] + 0.4937590750470338*b[i + 243*ldb] + -0.5517668509633159*b[i + 248*ldb] + 0.5517668509633159*b[i + 253*ldb] + -0.4937590750470338*b[i + 278*ldb] + 0.7231396289857297*b[i + 303*ldb] + -1.939864544376097*b[i + 328*ldb] + -5.06704059565454*b[i + 353*ldb]);
        c[i + 104*ldc] = (0.5517668509633159*b[i + 100*ldb] + -0.4937590750470338*b[i + 101*ldb] + 0.7231396289857297*b[i + 102*ldb] + -1.939864544376097*b[i + 103*ldb] + -5.06704059565454*b[i + 104*ldb] + 5.06704059565454*b[i + 229*ldb] + 1.939864544376097*b[i + 234*ldb] + -0.7231396289857297*b[i + 239*ldb] + 0.4937590750470338*b[i + 244*ldb] + -0.5517668509633159*b[i + 249*ldb] + 0.5517668509633159*b[i + 254*ldb] + -0.4937590750470338*b[i + 279*ldb] + 0.7231396289857297*b[i + 304*ldb] + -1.939864544376097*b[i + 329*ldb] + -5.06704059565454*b[i + 354*ldb]);
        c[i + 105*ldc] = (5.06704059565454*b[i + 105*ldb] + 1.939864544376097*b[i + 106*ldb] + -0.7231396289857297*b[i + 107*ldb] + 0.4937590750470338*b[i + 108*ldb] + -0.5517668509633159*b[i + 109*ldb] + -3.812557894803954*b[i + 225*ldb] + 0.7583532171678757*b[i + 230*ldb] + 1.706075027753831*b[i + 235*ldb] + -0.9285580266438338*b[i + 240*ldb] + 0.9704208807564537*b[i + 245*ldb] + 0.5517668509633159*b[i + 255*ldb] + -0.4937590750470338*b[i + 280*ldb] + 0.7231396289857297*b[i + 305*ldb] + -1.939864544376097*b[i + 330*ldb] + -5.06704059565454*b[i + 355*ldb]);
        c[i + 106*ldc] = (-3.812557894803954*b[i + 105*ldb] + 0.7583532171678757*b[i + 106*ldb] + 1.706075027753831*b[i + 107*ldb] + -0.9285580266438338*b[i + 108*ldb] + 0.9704208807564537*b[i + 109*ldb] + -3.812557894803954*b[i + 226*ldb] + 0.7583532171678757*b[i + 231*ldb] + 1.706075027753831*b[i + 236*ldb] + -0.9285580266438338*b[i + 241*ldb] + 0.9704208807564537*b[i + 246*ldb] + 0.5517668509633159*b[i + 256*ldb] + -0.4937590750470338*b[i + 281*ldb] + 0.7231396289857297*b[i + 306*ldb] + -1.939864544376097*b[i + 331*ldb] + -5.06704059565454*b[i + 356*ldb]);
        c[i + 107*ldc] = (1.684026960320175*b[i + 105*ldb] + -2.021528935875383*b[i + 106*ldb] + 2.021528935875383*b[i + 108*ldb] + -1.684026960320175*b[i + 109*ldb] + -3.812557894803954*b[i + 227*ldb] + 0.7583532171678757*b[i + 232*ldb] + 1.706075027753831*b[i + 237*ldb] + -0.9285580266438338*b[i + 242*ldb] + 0.9704208807564537*b[i + 247*ldb] + 0.5517668509633159*b[i + 257*ldb] + -0.4937590750470338*b[i + 282*ldb] + 0.7231396289857297*b[i + 307*ldb] + -1.939864544376097*b[i + 332*ldb] + -5.06704059565454*b[i + 357*ldb]);
        c[i + 108*ldc] = (-0.9704208807564537*b[i + 105*ldb] + 0.9285580266438338*b[i + 106*ldb] + -1.706075027753831*b[i + 107*ldb] + -0.7583532171678757*b[i + 108*ldb] + 3.812557894803954*b[i + 109*ldb] + -3.812557894803954*b[i + 228*ldb] + 0.7583532171678757*b[i + 233*ldb] + 1.706075027753831*b[i + 238*ldb] + -0.9285580266438338*b[i + 243*ldb] + 0.9704208807564537*b[i + 248*ldb] + 0.5517668509633159*b[i + 258*ldb] + -0.4937590750470338*b[i + 283*ldb] + 0.7231396289857297*b[i + 308*ldb] + -1.939864544376097*b[i + 333*ldb] + -5.06704059565454*b[i + 358*ldb]);
        c[i + 109*ldc] = (0.5517668509633159*b[i + 105*ldb] + -0.4937590750470338*b[i + 106*ldb] + 0.7231396289857297*b[i + 107*ldb] + -1.939864544376097*b[i + 108*ldb] + -5.06704059565454*b[i + 109*ldb] + -3.812557894803954*b[i + 229*ldb] + 0.7583532171678757*b[i + 234*ldb] + 1.706075027753831*b[i + 239*ldb] + -0.9285580266438338*b[i + 244*ldb] + 0.9704208807564537*b[i + 249*ldb] + 0.5517668509633159*b[i + 259*ldb] + -0.4937590750470338*b[i + 284*ldb] + 0.7231396289857297*b[i + 309*ldb] + -1.939864544376097*b[i + 334*ldb] + -5.06704059565454*b[i + 359*ldb]);
        c[i + 110*ldc] = (5.06704059565454*b[i + 110*ldb] + 1.939864544376097*b[i + 111*ldb] + -0.7231396289857297*b[i + 112*ldb] + 0.4937590750470338*b[i + 113*ldb] + -0.5517668509633159*b[i + 114*ldb] + 1.684026960320175*b[i + 225*ldb] + -2.021528935875383*b[i + 230*ldb] + 2.021528935875383*b[i + 240*ldb] + -1.684026960320175*b[i + 245*ldb] + 0.5517668509633159*b[i + 260*ldb] + -0.4937590750470338*b[i + 285*ldb] + 0.7231396289857297*b[i + 310*ldb] + -1.939864544376097*b[i + 335*ldb] + -5.06704059565454*b[i + 360*ldb]);
        c[i + 111*ldc] = (-3.812557894803954*b[i + 110*ldb] + 0.7583532171678757*b[i + 111*ldb] + 1.706075027753831*b[i + 112*ldb] + -0.9285580266438338*b[i + 113*ldb] + 0.9704208807564537*b[i + 114*ldb] + 1.684026960320175*b[i + 226*ldb] + -2.021528935875383*b[i + 231*ldb] + 2.021528935875383*b[i + 241*ldb] + -1.684026960320175*b[i + 246*ldb] + 0.5517668509633159*b[i + 261*ldb] + -0.4937590750470338*b[i + 286*ldb] + 0.7231396289857297*b[i + 311*ldb] + -1.939864544376097*b[i + 336*ldb] + -5.06704059565454*b[i + 361*ldb]);
        c[i + 112*ldc] = (1.684026960320175*b[i + 110*ldb] + -2.021528935875383*b[i + 111*ldb] + 2.021528935875383*b[i + 113*ldb] + -1.684026960320175*b[i + 114*ldb] + 1.684026960320175*b[i + 227*ldb] + -2.021528935875383*b[i + 232*ldb] + 2.021528935875383*b[i + 242*ldb] + -1.684026960320175*b[i + 247*ldb] + 0.5517668509633159*b[i + 262*ldb] + -0.4937590750470338*b[i + 287*ldb] + 0.7231396289857297*b[i + 312*ldb] + -1.939864544376097*b[i + 337*ldb] + -5.06704059565454*b[i + 362*ldb]);
        c[i + 113*ldc] = (-0.9704208807564537*b[i + 110*ldb] + 0.9285580266438338*b[i + 111*ldb] + -1.706075027753831*b[i + 112*ldb] + -0.7583532171678757*b[i + 113*ldb] + 3.812557894803954*b[i + 114*ldb] + 1.684026960320175*b[i + 228*ldb] + -2.021528935875383*b[i + 233*ldb] + 2.021528935875383*b[i + 243*ldb] + -1.684026960320175*b[i + 248*ldb] + 0.5517668509633159*b[i + 263*ldb] + -0.4937590750470338*b[i + 288*ldb] + 0.7231396289857297*b[i + 313*ldb] + -1.939864544376097*b[i + 338*ldb] + -5.06704059565454*b[i + 363*ldb]);
        c[i + 114*ldc] = (0.5517668509633159*b[i + 110*ldb] + -0.4937590750470338*b[i + 111*ldb] + 0.7231396289857297*b[i + 112*ldb] + -1.939864544376097*b[i + 113*ldb] + -5.06704059565454*b[i + 114*ldb] + 1.684026960320175*b[i + 229*ldb] + -2.021528935875383*b[i + 234*ldb] + 2.021528935875383*b[i + 244*ldb] + -1.684026960320175*b[i + 249*ldb] + 0.5517668509633159*b[i + 264*ldb] + -0.4937590750470338*b[i + 289*ldb] + 0.7231396289857297*b[i + 314*ldb] + -1.939864544376097*b[i + 339*ldb] + -5.06704059565454*b[i + 364*ldb]);
        c[i + 115*ldc] = (5.06704059565454*b[i + 115*ldb] + 1.939864544376097*b[i + 116*ldb] + -0.7231396289857297*b[i + 117*ldb] + 0.4937590750470338*b[i + 118*ldb] + -0.5517668509633159*b[i + 119*ldb] + -0.9704208807564537*b[i + 225*ldb] + 0.9285580266438338*b[i + 230*ldb] + -1.706075027753831*b[i + 235*ldb] + -0.7583532171678757*b[i + 240*ldb] + 3.812557894803954*b[i + 245*ldb] + 0.5517668509633159*b[i + 265*ldb] + -0.4937590750470338*b[i + 290*ldb] + 0.7231396289857297*b[i + 315*ldb] + -1.939864544376097*b[i + 340*ldb] + -5.06704059565454*b[i + 365*ldb]);
        c[i + 116*ldc] = (-3.812557894803954*b[i + 115*ldb] + 0.7583532171678757*b[i + 116*ldb] + 1.706075027753831*b[i + 117*ldb] + -0.9285580266438338*b[i + 118*ldb] + 0.9704208807564537*b[i + 119*ldb] + -0.9704208807564537*b[i + 226*ldb] + 0.9285580266438338*b[i + 231*ldb] + -1.706075027753831*b[i + 236*ldb] + -0.7583532171678757*b[i + 241*ldb] + 3.812557894803954*b[i + 246*ldb] + 0.5517668509633159*b[i + 266*ldb] + -0.4937590750470338*b[i + 291*ldb] + 0.7231396289857297*b[i + 316*ldb] + -1.939864544376097*b[i + 341*ldb] + -5.06704059565454*b[i + 366*ldb]);
        c[i + 117*ldc] = (1.684026960320175*b[i + 115*ldb] + -2.021528935875383*b[i + 116*ldb] + 2.021528935875383*b[i + 118*ldb] + -1.684026960320175*b[i + 119*ldb] + -0.9704208807564537*b[i + 227*ldb] + 0.9285580266438338*b[i + 232*ldb] + -1.706075027753831*b[i + 237*ldb] + -0.7583532171678757*b[i + 242*ldb] + 3.812557894803954*b[i + 247*ldb] + 0.5517668509633159*b[i + 267*ldb] + -0.4937590750470338*b[i + 292*ldb] + 0.7231396289857297*b[i + 317*ldb] + -1.939864544376097*b[i + 342*ldb] + -5.06704059565454*b[i + 367*ldb]);
        c[i + 118*ldc] = (-0.9704208807564537*b[i + 115*ldb] + 0.9285580266438338*b[i + 116*ldb] + -1.706075027753831*b[i + 117*ldb] + -0.7583532171678757*b[i + 118*ldb] + 3.812557894803954*b[i + 119*ldb] + -0.9704208807564537*b[i + 228*ldb] + 0.9285580266438338*b[i + 233*ldb] + -1.706075027753831*b[i + 238*ldb] + -0.7583532171678757*b[i + 243*ldb] + 3.812557894803954*b[i + 248*ldb] + 0.5517668509633159*b[i + 268*ldb] + -0.4937590750470338*b[i + 293*ldb] + 0.7231396289857297*b[i + 318*ldb] + -1.939864544376097*b[i + 343*ldb] + -5.06704059565454*b[i + 368*ldb]);
        c[i + 119*ldc] = (0.5517668509633159*b[i + 115*ldb] + -0.4937590750470338*b[i + 116*ldb] + 0.7231396289857297*b[i + 117*ldb] + -1.939864544376097*b[i + 118*ldb] + -5.06704059565454*b[i + 119*ldb] + -0.9704208807564537*b[i + 229*ldb] + 0.9285580266438338*b[i + 234*ldb] + -1.706075027753831*b[i + 239*ldb] + -0.7583532171678757*b[i + 244*ldb] + 3.812557894803954*b[i + 249*ldb] + 0.5517668509633159*b[i + 269*ldb] + -0.4937590750470338*b[i + 294*ldb] + 0.7231396289857297*b[i + 319*ldb] + -1.939864544376097*b[i + 344*ldb] + -5.06704059565454*b[i + 369*ldb]);
        c[i + 120*ldc] = (5.06704059565454*b[i + 120*ldb] + 1.939864544376097*b[i + 121*ldb] + -0.7231396289857297*b[i + 122*ldb] + 0.4937590750470338*b[i + 123*ldb] + -0.5517668509633159*b[i + 124*ldb] + 0.5517668509633159*b[i + 225*ldb] + -0.4937590750470338*b[i + 230*ldb] + 0.7231396289857297*b[i + 235*ldb] + -1.939864544376097*b[i + 240*ldb] + -5.06704059565454*b[i + 245*ldb] + 0.5517668509633159*b[i + 270*ldb] + -0.4937590750470338*b[i + 295*ldb] + 0.7231396289857297*b[i + 320*ldb] + -1.939864544376097*b[i + 345*ldb] + -5.06704059565454*b[i + 370*ldb]);
        c[i + 121*ldc] = (-3.812557894803954*b[i + 120*ldb] + 0.7583532171678757*b[i + 121*ldb] + 1.706075027753831*b[i + 122*ldb] + -0.9285580266438338*b[i + 123*ldb] + 0.9704208807564537*b[i + 124*ldb] + 0.5517668509633159*b[i + 226*ldb] + -0.4937590750470338*b[i + 231*ldb] + 0.7231396289857297*b[i + 236*ldb] + -1.939864544376097*b[i + 241*ldb] + -5.06704059565454*b[i + 246*ldb] + 0.5517668509633159*b[i + 271*ldb] + -0.4937590750470338*b[i + 296*ldb] + 0.7231396289857297*b[i + 321*ldb] + -1.939864544376097*b[i + 346*ldb] + -5.06704059565454*b[i + 371*ldb]);
        c[i + 122*ldc] = (1.684026960320175*b[i + 120*ldb] + -2.021528935875383*b[i + 121*ldb] + 2.021528935875383*b[i + 123*ldb] + -1.684026960320175*b[i + 124*ldb] + 0.5517668509633159*b[i + 227*ldb] + -0.4937590750470338*b[i + 232*ldb] + 0.7231396289857297*b[i + 237*ldb] + -1.939864544376097*b[i + 242*ldb] + -5.06704059565454*b[i + 247*ldb] + 0.5517668509633159*b[i + 272*ldb] + -0.4937590750470338*b[i + 297*ldb] + 0.7231396289857297*b[i + 322*ldb] + -1.939864544376097*b[i + 347*ldb] + -5.06704059565454*b[i + 372*ldb]);
        c[i + 123*ldc] = (-0.9704208807564537*b[i + 120*ldb] + 0.9285580266438338*b[i + 121*ldb] + -1.706075027753831*b[i + 122*ldb] + -0.7583532171678757*b[i + 123*ldb] + 3.812557894803954*b[i + 124*ldb] + 0.5517668509633159*b[i + 228*ldb] + -0.4937590750470338*b[i + 233*ldb] + 0.7231396289857297*b[i + 238*ldb] + -1.939864544376097*b[i + 243*ldb] + -5.06704059565454*b[i + 248*ldb] + 0.5517668509633159*b[i + 273*ldb] + -0.4937590750470338*b[i + 298*ldb] + 0.7231396289857297*b[i + 323*ldb] + -1.939864544376097*b[i + 348*ldb] + -5.06704059565454*b[i + 373*ldb]);
        c[i + 124*ldc] = (0.5517668509633159*b[i + 120*ldb] + -0.4937590750470338*b[i + 121*ldb] + 0.7231396289857297*b[i + 122*ldb] + -1.939864544376097*b[i + 123*ldb] + -5.06704059565454*b[i + 124*ldb] + 0.5517668509633159*b[i + 229*ldb] + -0.4937590750470338*b[i + 234*ldb] + 0.7231396289857297*b[i + 239*ldb] + -1.939864544376097*b[i + 244*ldb] + -5.06704059565454*b[i + 249*ldb] + 0.5517668509633159*b[i + 274*ldb] + -0.4937590750470338*b[i + 299*ldb] + 0.7231396289857297*b[i + 324*ldb] + -1.939864544376097*b[i + 349*ldb] + -5.06704059565454*b[i + 374*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_pri_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.551408049094313*b[i + 0*ldb] + -0.8931583920000719*b[i + 15*ldb] + 0.5333333333333334*b[i + 30*ldb] + -0.2679416522233877*b[i + 45*ldb] + 0.07635866179581294*b[i + 60*ldb]);
        c[i + 1*ldc] = (1.551408049094313*b[i + 1*ldb] + -0.8931583920000719*b[i + 16*ldb] + 0.5333333333333334*b[i + 31*ldb] + -0.2679416522233877*b[i + 46*ldb] + 0.07635866179581294*b[i + 61*ldb]);
        c[i + 2*ldc] = (1.551408049094313*b[i + 2*ldb] + -0.8931583920000719*b[i + 17*ldb] + 0.5333333333333334*b[i + 32*ldb] + -0.2679416522233877*b[i + 47*ldb] + 0.07635866179581294*b[i + 62*ldb]);
        c[i + 3*ldc] = (1.551408049094313*b[i + 3*ldb] + -0.8931583920000719*b[i + 18*ldb] + 0.5333333333333334*b[i + 33*ldb] + -0.2679416522233877*b[i + 48*ldb] + 0.07635866179581294*b[i + 63*ldb]);
        c[i + 4*ldc] = (1.551408049094313*b[i + 4*ldb] + -0.8931583920000719*b[i + 19*ldb] + 0.5333333333333334*b[i + 34*ldb] + -0.2679416522233877*b[i + 49*ldb] + 0.07635866179581294*b[i + 64*ldb]);
        c[i + 5*ldc] = (1.551408049094313*b[i + 5*ldb] + -0.8931583920000719*b[i + 20*ldb] + 0.5333333333333334*b[i + 35*ldb] + -0.2679416522233877*b[i + 50*ldb] + 0.07635866179581294*b[i + 65*ldb]);
        c[i + 6*ldc] = (1.551408049094313*b[i + 6*ldb] + -0.8931583920000719*b[i + 21*ldb] + 0.5333333333333334*b[i + 36*ldb] + -0.2679416522233877*b[i + 51*ldb] + 0.07635866179581294*b[i + 66*ldb]);
        c[i + 7*ldc] = (1.551408049094313*b[i + 7*ldb] + -0.8931583920000719*b[i + 22*ldb] + 0.5333333333333334*b[i + 37*ldb] + -0.2679416522233877*b[i + 52*ldb] + 0.07635866179581294*b[i + 67*ldb]);
        c[i + 8*ldc] = (1.551408049094313*b[i + 8*ldb] + -0.8931583920000719*b[i + 23*ldb] + 0.5333333333333334*b[i + 38*ldb] + -0.2679416522233877*b[i + 53*ldb] + 0.07635866179581294*b[i + 68*ldb]);
        c[i + 9*ldc] = (1.551408049094313*b[i + 9*ldb] + -0.8931583920000719*b[i + 24*ldb] + 0.5333333333333334*b[i + 39*ldb] + -0.2679416522233877*b[i + 54*ldb] + 0.07635866179581294*b[i + 69*ldb]);
        c[i + 10*ldc] = (1.551408049094313*b[i + 10*ldb] + -0.8931583920000719*b[i + 25*ldb] + 0.5333333333333334*b[i + 40*ldb] + -0.2679416522233877*b[i + 55*ldb] + 0.07635866179581294*b[i + 70*ldb]);
        c[i + 11*ldc] = (1.551408049094313*b[i + 11*ldb] + -0.8931583920000719*b[i + 26*ldb] + 0.5333333333333334*b[i + 41*ldb] + -0.2679416522233877*b[i + 56*ldb] + 0.07635866179581294*b[i + 71*ldb]);
        c[i + 12*ldc] = (1.551408049094313*b[i + 12*ldb] + -0.8931583920000719*b[i + 27*ldb] + 0.5333333333333334*b[i + 42*ldb] + -0.2679416522233877*b[i + 57*ldb] + 0.07635866179581294*b[i + 72*ldb]);
        c[i + 13*ldc] = (1.551408049094313*b[i + 13*ldb] + -0.8931583920000719*b[i + 28*ldb] + 0.5333333333333334*b[i + 43*ldb] + -0.2679416522233877*b[i + 58*ldb] + 0.07635866179581294*b[i + 73*ldb]);
        c[i + 14*ldc] = (1.551408049094313*b[i + 14*ldb] + -0.8931583920000719*b[i + 29*ldb] + 0.5333333333333334*b[i + 44*ldb] + -0.2679416522233877*b[i + 59*ldb] + 0.07635866179581294*b[i + 74*ldb]);
        c[i + 15*ldc] = (0.07635866179581294*b[i + 0*ldb] + -0.2679416522233877*b[i + 15*ldb] + 0.5333333333333334*b[i + 30*ldb] + -0.8931583920000719*b[i + 45*ldb] + 1.551408049094313*b[i + 60*ldb]);
        c[i + 16*ldc] = (0.07635866179581294*b[i + 1*ldb] + -0.2679416522233877*b[i + 16*ldb] + 0.5333333333333334*b[i + 31*ldb] + -0.8931583920000719*b[i + 46*ldb] + 1.551408049094313*b[i + 61*ldb]);
        c[i + 17*ldc] = (0.07635866179581294*b[i + 2*ldb] + -0.2679416522233877*b[i + 17*ldb] + 0.5333333333333334*b[i + 32*ldb] + -0.8931583920000719*b[i + 47*ldb] + 1.551408049094313*b[i + 62*ldb]);
        c[i + 18*ldc] = (0.07635866179581294*b[i + 3*ldb] + -0.2679416522233877*b[i + 18*ldb] + 0.5333333333333334*b[i + 33*ldb] + -0.8931583920000719*b[i + 48*ldb] + 1.551408049094313*b[i + 63*ldb]);
        c[i + 19*ldc] = (0.07635866179581294*b[i + 4*ldb] + -0.2679416522233877*b[i + 19*ldb] + 0.5333333333333334*b[i + 34*ldb] + -0.8931583920000719*b[i + 49*ldb] + 1.551408049094313*b[i + 64*ldb]);
        c[i + 20*ldc] = (0.07635866179581294*b[i + 5*ldb] + -0.2679416522233877*b[i + 20*ldb] + 0.5333333333333334*b[i + 35*ldb] + -0.8931583920000719*b[i + 50*ldb] + 1.551408049094313*b[i + 65*ldb]);
        c[i + 21*ldc] = (0.07635866179581294*b[i + 6*ldb] + -0.2679416522233877*b[i + 21*ldb] + 0.5333333333333334*b[i + 36*ldb] + -0.8931583920000719*b[i + 51*ldb] + 1.551408049094313*b[i + 66*ldb]);
        c[i + 22*ldc] = (0.07635866179581294*b[i + 7*ldb] + -0.2679416522233877*b[i + 22*ldb] + 0.5333333333333334*b[i + 37*ldb] + -0.8931583920000719*b[i + 52*ldb] + 1.551408049094313*b[i + 67*ldb]);
        c[i + 23*ldc] = (0.07635866179581294*b[i + 8*ldb] + -0.2679416522233877*b[i + 23*ldb] + 0.5333333333333334*b[i + 38*ldb] + -0.8931583920000719*b[i + 53*ldb] + 1.551408049094313*b[i + 68*ldb]);
        c[i + 24*ldc] = (0.07635866179581294*b[i + 9*ldb] + -0.2679416522233877*b[i + 24*ldb] + 0.5333333333333334*b[i + 39*ldb] + -0.8931583920000719*b[i + 54*ldb] + 1.551408049094313*b[i + 69*ldb]);
        c[i + 25*ldc] = (0.07635866179581294*b[i + 10*ldb] + -0.2679416522233877*b[i + 25*ldb] + 0.5333333333333334*b[i + 40*ldb] + -0.8931583920000719*b[i + 55*ldb] + 1.551408049094313*b[i + 70*ldb]);
        c[i + 26*ldc] = (0.07635866179581294*b[i + 11*ldb] + -0.2679416522233877*b[i + 26*ldb] + 0.5333333333333334*b[i + 41*ldb] + -0.8931583920000719*b[i + 56*ldb] + 1.551408049094313*b[i + 71*ldb]);
        c[i + 27*ldc] = (0.07635866179581294*b[i + 12*ldb] + -0.2679416522233877*b[i + 27*ldb] + 0.5333333333333334*b[i + 42*ldb] + -0.8931583920000719*b[i + 57*ldb] + 1.551408049094313*b[i + 72*ldb]);
        c[i + 28*ldc] = (0.07635866179581294*b[i + 13*ldb] + -0.2679416522233877*b[i + 28*ldb] + 0.5333333333333334*b[i + 43*ldb] + -0.8931583920000719*b[i + 58*ldb] + 1.551408049094313*b[i + 73*ldb]);
        c[i + 29*ldc] = (0.07635866179581294*b[i + 14*ldb] + -0.2679416522233877*b[i + 29*ldb] + 0.5333333333333334*b[i + 44*ldb] + -0.8931583920000719*b[i + 59*ldb] + 1.551408049094313*b[i + 74*ldb]);
        c[i + 30*ldc] = (0.05081580409017567*b[i + 0*ldb] + -0.01242883443549132*b[i + 1*ldb] + 1.277362792917128*b[i + 2*ldb] + -0.01135060080460352*b[i + 3*ldb] + 0.02039085112673084*b[i + 4*ldb] + -0.02715144289883629*b[i + 5*ldb] + -0.107487692056558*b[i + 6*ldb] + 0.3621578131742781*b[i + 7*ldb] + -0.003038871981994752*b[i + 8*ldb] + -0.005994644592905073*b[i + 9*ldb] + -0.6723301193964519*b[i + 10*ldb] + 0.2514627884468437*b[i + 11*ldb] + 0.04705260855827426*b[i + 12*ldb] + -0.1805392485472571*b[i + 13*ldb] + 0.01107879640066772*b[i + 14*ldb]);
        c[i + 31*ldc] = (0.08730963130269272*b[i + 0*ldb] + 0.02066118346088678*b[i + 1*ldb] + 0.01539912197902723*b[i + 2*ldb] + 0.3056969514972447*b[i + 3*ldb] + 0.01661907203849378*b[i + 4*ldb] + -0.6974449061221744*b[i + 5*ldb] + 0.217021863935519*b[i + 6*ldb] + 0.313071197570935*b[i + 7*ldb] + -0.02742354100263193*b[i + 8*ldb] + 0.009316048215090128*b[i + 9*ldb] + -0.2716967136714197*b[i + 10*ldb] + 1.40533040629815*b[i + 11*ldb] + -0.08515380986958124*b[i + 12*ldb] + -0.2389821452946306*b[i + 13*ldb] + -0.0697243603376021*b[i + 14*ldb]);
        c[i + 32*ldc] = (0.1067893819824541*b[i + 0*ldb] + -0.03258815541097042*b[i + 1*ldb] + -0.03258815541097042*b[i + 2*ldb] + 0.5133997618360752*b[i + 3*ldb] + -0.5647500511335565*b[i + 4*ldb] + -0.5647500511335565*b[i + 5*ldb] + 1.446419140262625*b[i + 6*ldb] + 0.1033618406535255*b[i + 7*ldb] + 0.1033618406535255*b[i + 8*ldb] + 0.043492184722717*b[i + 9*ldb] + 0.043492184722717*b[i + 10*ldb] + 0.1096948080323159*b[i + 11*ldb] + 0.1096948080323159*b[i + 12*ldb] + -0.1925147689046085*b[i + 13*ldb] + -0.1925147689046085*b[i + 14*ldb]);
        c[i + 33*ldc] = (0.08730963130269272*b[i + 0*ldb] + 0.01539912197902723*b[i + 1*ldb] + 0.02066118346088678*b[i + 2*ldb] + 0.3056969514972447*b[i + 3*ldb] + -0.6974449061221744*b[i + 4*ldb] + 0.01661907203849378*b[i + 5*ldb] + 0.217021863935519*b[i + 6*ldb] + -0.02742354100263193*b[i + 7*ldb] + 0.313071197570935*b[i + 8*ldb] + -0.2716967136714197*b[i + 9*ldb] + 0.009316048215090128*b[i + 10*ldb] + -0.08515380986958124*b[i + 11*ldb] + 1.40533040629815*b[i + 12*ldb] + -0.0697243603376021*b[i + 13*ldb] + -0.2389821452946306*b[i + 14*ldb]);
        c[i + 34*ldc] = (0.05081580409017567*b[i + 0*ldb] + 1.277362792917128*b[i + 1*ldb] + -0.01242883443549132*b[i + 2*ldb] + -0.01135060080460352*b[i + 3*ldb] + -0.02715144289883629*b[i + 4*ldb] + 0.02039085112673084*b[i + 5*ldb] + -0.107487692056558*b[i + 6*ldb] + -0.003038871981994752*b[i + 7*ldb] + 0.3621578131742781*b[i + 8*ldb] + -0.6723301193964519*b[i + 9*ldb] + -0.005994644592905073*b[i + 10*ldb] + 0.04705260855827426*b[i + 11*ldb] + 0.2514627884468437*b[i + 12*ldb] + 0.01107879640066772*b[i + 13*ldb] + -0.1805392485472571*b[i + 14*ldb]);
        c[i + 35*ldc] = (0.05081580409017567*b[i + 15*ldb] + -0.01242883443549132*b[i + 16*ldb] + 1.277362792917128*b[i + 17*ldb] + -0.01135060080460352*b[i + 18*ldb] + 0.02039085112673084*b[i + 19*ldb] + -0.02715144289883629*b[i + 20*ldb] + -0.107487692056558*b[i + 21*ldb] + 0.3621578131742781*b[i + 22*ldb] + -0.003038871981994752*b[i + 23*ldb] + -0.005994644592905073*b[i + 24*ldb] + -0.6723301193964519*b[i + 25*ldb] + 0.2514627884468437*b[i + 26*ldb] + 0.04705260855827426*b[i + 27*ldb] + -0.1805392485472571*b[i + 28*ldb] + 0.01107879640066772*b[i + 29*ldb]);
        c[i + 36*ldc] = (0.08730963130269272*b[i + 15*ldb] + 0.02066118346088678*b[i + 16*ldb] + 0.01539912197902723*b[i + 17*ldb] + 0.3056969514972447*b[i + 18*ldb] + 0.01661907203849378*b[i + 19*ldb] + -0.6974449061221744*b[i + 20*ldb] + 0.217021863935519*b[i + 21*ldb] + 0.313071197570935*b[i + 22*ldb] + -0.02742354100263193*b[i + 23*ldb] + 0.009316048215090128*b[i + 24*ldb] + -0.2716967136714197*b[i + 25*ldb] + 1.40533040629815*b[i + 26*ldb] + -0.08515380986958124*b[i + 27*ldb] + -0.2389821452946306*b[i + 28*ldb] + -0.0697243603376021*b[i + 29*ldb]);
        c[i + 37*ldc] = (0.1067893819824541*b[i + 15*ldb] + -0.03258815541097042*b[i + 16*ldb] + -0.03258815541097042*b[i + 17*ldb] + 0.5133997618360752*b[i + 18*ldb] + -0.5647500511335565*b[i + 19*ldb] + -0.5647500511335565*b[i + 20*ldb] + 1.446419140262625*b[i + 21*ldb] + 0.1033618406535255*b[i + 22*ldb] + 0.1033618406535255*b[i + 23*ldb] + 0.043492184722717*b[i + 24*ldb] + 0.043492184722717*b[i + 25*ldb] + 0.1096948080323159*b[i + 26*ldb] + 0.1096948080323159*b[i + 27*ldb] + -0.1925147689046085*b[i + 28*ldb] + -0.1925147689046085*b[i + 29*ldb]);
        c[i + 38*ldc] = (0.08730963130269272*b[i + 15*ldb] + 0.01539912197902723*b[i + 16*ldb] + 0.02066118346088678*b[i + 17*ldb] + 0.3056969514972447*b[i + 18*ldb] + -0.6974449061221744*b[i + 19*ldb] + 0.01661907203849378*b[i + 20*ldb] + 0.217021863935519*b[i + 21*ldb] + -0.02742354100263193*b[i + 22*ldb] + 0.313071197570935*b[i + 23*ldb] + -0.2716967136714197*b[i + 24*ldb] + 0.009316048215090128*b[i + 25*ldb] + -0.08515380986958124*b[i + 26*ldb] + 1.40533040629815*b[i + 27*ldb] + -0.0697243603376021*b[i + 28*ldb] + -0.2389821452946306*b[i + 29*ldb]);
        c[i + 39*ldc] = (0.05081580409017567*b[i + 15*ldb] + 1.277362792917128*b[i + 16*ldb] + -0.01242883443549132*b[i + 17*ldb] + -0.01135060080460352*b[i + 18*ldb] + -0.02715144289883629*b[i + 19*ldb] + 0.02039085112673084*b[i + 20*ldb] + -0.107487692056558*b[i + 21*ldb] + -0.003038871981994752*b[i + 22*ldb] + 0.3621578131742781*b[i + 23*ldb] + -0.6723301193964519*b[i + 24*ldb] + -0.005994644592905073*b[i + 25*ldb] + 0.04705260855827426*b[i + 26*ldb] + 0.2514627884468437*b[i + 27*ldb] + 0.01107879640066772*b[i + 28*ldb] + -0.1805392485472571*b[i + 29*ldb]);
        c[i + 40*ldc] = (0.05081580409017567*b[i + 30*ldb] + -0.01242883443549132*b[i + 31*ldb] + 1.277362792917128*b[i + 32*ldb] + -0.01135060080460352*b[i + 33*ldb] + 0.02039085112673084*b[i + 34*ldb] + -0.02715144289883629*b[i + 35*ldb] + -0.107487692056558*b[i + 36*ldb] + 0.3621578131742781*b[i + 37*ldb] + -0.003038871981994752*b[i + 38*ldb] + -0.005994644592905073*b[i + 39*ldb] + -0.6723301193964519*b[i + 40*ldb] + 0.2514627884468437*b[i + 41*ldb] + 0.04705260855827426*b[i + 42*ldb] + -0.1805392485472571*b[i + 43*ldb] + 0.01107879640066772*b[i + 44*ldb]);
        c[i + 41*ldc] = (0.08730963130269272*b[i + 30*ldb] + 0.02066118346088678*b[i + 31*ldb] + 0.01539912197902723*b[i + 32*ldb] + 0.3056969514972447*b[i + 33*ldb] + 0.01661907203849378*b[i + 34*ldb] + -0.6974449061221744*b[i + 35*ldb] + 0.217021863935519*b[i + 36*ldb] + 0.313071197570935*b[i + 37*ldb] + -0.02742354100263193*b[i + 38*ldb] + 0.009316048215090128*b[i + 39*ldb] + -0.2716967136714197*b[i + 40*ldb] + 1.40533040629815*b[i + 41*ldb] + -0.08515380986958124*b[i + 42*ldb] + -0.2389821452946306*b[i + 43*ldb] + -0.0697243603376021*b[i + 44*ldb]);
        c[i + 42*ldc] = (0.1067893819824541*b[i + 30*ldb] + -0.03258815541097042*b[i + 31*ldb] + -0.03258815541097042*b[i + 32*ldb] + 0.5133997618360752*b[i + 33*ldb] + -0.5647500511335565*b[i + 34*ldb] + -0.5647500511335565*b[i + 35*ldb] + 1.446419140262625*b[i + 36*ldb] + 0.1033618406535255*b[i + 37*ldb] + 0.1033618406535255*b[i + 38*ldb] + 0.043492184722717*b[i + 39*ldb] + 0.043492184722717*b[i + 40*ldb] + 0.1096948080323159*b[i + 41*ldb] + 0.1096948080323159*b[i + 42*ldb] + -0.1925147689046085*b[i + 43*ldb] + -0.1925147689046085*b[i + 44*ldb]);
        c[i + 43*ldc] = (0.08730963130269272*b[i + 30*ldb] + 0.01539912197902723*b[i + 31*ldb] + 0.02066118346088678*b[i + 32*ldb] + 0.3056969514972447*b[i + 33*ldb] + -0.6974449061221744*b[i + 34*ldb] + 0.01661907203849378*b[i + 35*ldb] + 0.217021863935519*b[i + 36*ldb] + -0.02742354100263193*b[i + 37*ldb] + 0.313071197570935*b[i + 38*ldb] + -0.2716967136714197*b[i + 39*ldb] + 0.009316048215090128*b[i + 40*ldb] + -0.08515380986958124*b[i + 41*ldb] + 1.40533040629815*b[i + 42*ldb] + -0.0697243603376021*b[i + 43*ldb] + -0.2389821452946306*b[i + 44*ldb]);
        c[i + 44*ldc] = (0.05081580409017567*b[i + 30*ldb] + 1.277362792917128*b[i + 31*ldb] + -0.01242883443549132*b[i + 32*ldb] + -0.01135060080460352*b[i + 33*ldb] + -0.02715144289883629*b[i + 34*ldb] + 0.02039085112673084*b[i + 35*ldb] + -0.107487692056558*b[i + 36*ldb] + -0.003038871981994752*b[i + 37*ldb] + 0.3621578131742781*b[i + 38*ldb] + -0.6723301193964519*b[i + 39*ldb] + -0.005994644592905073*b[i + 40*ldb] + 0.04705260855827426*b[i + 41*ldb] + 0.2514627884468437*b[i + 42*ldb] + 0.01107879640066772*b[i + 43*ldb] + -0.1805392485472571*b[i + 44*ldb]);
        c[i + 45*ldc] = (0.05081580409017567*b[i + 45*ldb] + -0.01242883443549132*b[i + 46*ldb] + 1.277362792917128*b[i + 47*ldb] + -0.01135060080460352*b[i + 48*ldb] + 0.02039085112673084*b[i + 49*ldb] + -0.02715144289883629*b[i + 50*ldb] + -0.107487692056558*b[i + 51*ldb] + 0.3621578131742781*b[i + 52*ldb] + -0.003038871981994752*b[i + 53*ldb] + -0.005994644592905073*b[i + 54*ldb] + -0.6723301193964519*b[i + 55*ldb] + 0.2514627884468437*b[i + 56*ldb] + 0.04705260855827426*b[i + 57*ldb] + -0.1805392485472571*b[i + 58*ldb] + 0.01107879640066772*b[i + 59*ldb]);
        c[i + 46*ldc] = (0.08730963130269272*b[i + 45*ldb] + 0.02066118346088678*b[i + 46*ldb] + 0.01539912197902723*b[i + 47*ldb] + 0.3056969514972447*b[i + 48*ldb] + 0.01661907203849378*b[i + 49*ldb] + -0.6974449061221744*b[i + 50*ldb] + 0.217021863935519*b[i + 51*ldb] + 0.313071197570935*b[i + 52*ldb] + -0.02742354100263193*b[i + 53*ldb] + 0.009316048215090128*b[i + 54*ldb] + -0.2716967136714197*b[i + 55*ldb] + 1.40533040629815*b[i + 56*ldb] + -0.08515380986958124*b[i + 57*ldb] + -0.2389821452946306*b[i + 58*ldb] + -0.0697243603376021*b[i + 59*ldb]);
        c[i + 47*ldc] = (0.1067893819824541*b[i + 45*ldb] + -0.03258815541097042*b[i + 46*ldb] + -0.03258815541097042*b[i + 47*ldb] + 0.5133997618360752*b[i + 48*ldb] + -0.5647500511335565*b[i + 49*ldb] + -0.5647500511335565*b[i + 50*ldb] + 1.446419140262625*b[i + 51*ldb] + 0.1033618406535255*b[i + 52*ldb] + 0.1033618406535255*b[i + 53*ldb] + 0.043492184722717*b[i + 54*ldb] + 0.043492184722717*b[i + 55*ldb] + 0.1096948080323159*b[i + 56*ldb] + 0.1096948080323159*b[i + 57*ldb] + -0.1925147689046085*b[i + 58*ldb] + -0.1925147689046085*b[i + 59*ldb]);
        c[i + 48*ldc] = (0.08730963130269272*b[i + 45*ldb] + 0.01539912197902723*b[i + 46*ldb] + 0.02066118346088678*b[i + 47*ldb] + 0.3056969514972447*b[i + 48*ldb] + -0.6974449061221744*b[i + 49*ldb] + 0.01661907203849378*b[i + 50*ldb] + 0.217021863935519*b[i + 51*ldb] + -0.02742354100263193*b[i + 52*ldb] + 0.313071197570935*b[i + 53*ldb] + -0.2716967136714197*b[i + 54*ldb] + 0.009316048215090128*b[i + 55*ldb] + -0.08515380986958124*b[i + 56*ldb] + 1.40533040629815*b[i + 57*ldb] + -0.0697243603376021*b[i + 58*ldb] + -0.2389821452946306*b[i + 59*ldb]);
        c[i + 49*ldc] = (0.05081580409017567*b[i + 45*ldb] + 1.277362792917128*b[i + 46*ldb] + -0.01242883443549132*b[i + 47*ldb] + -0.01135060080460352*b[i + 48*ldb] + -0.02715144289883629*b[i + 49*ldb] + 0.02039085112673084*b[i + 50*ldb] + -0.107487692056558*b[i + 51*ldb] + -0.003038871981994752*b[i + 52*ldb] + 0.3621578131742781*b[i + 53*ldb] + -0.6723301193964519*b[i + 54*ldb] + -0.005994644592905073*b[i + 55*ldb] + 0.04705260855827426*b[i + 56*ldb] + 0.2514627884468437*b[i + 57*ldb] + 0.01107879640066772*b[i + 58*ldb] + -0.1805392485472571*b[i + 59*ldb]);
        c[i + 50*ldc] = (0.05081580409017567*b[i + 60*ldb] + -0.01242883443549132*b[i + 61*ldb] + 1.277362792917128*b[i + 62*ldb] + -0.01135060080460352*b[i + 63*ldb] + 0.02039085112673084*b[i + 64*ldb] + -0.02715144289883629*b[i + 65*ldb] + -0.107487692056558*b[i + 66*ldb] + 0.3621578131742781*b[i + 67*ldb] + -0.003038871981994752*b[i + 68*ldb] + -0.005994644592905073*b[i + 69*ldb] + -0.6723301193964519*b[i + 70*ldb] + 0.2514627884468437*b[i + 71*ldb] + 0.04705260855827426*b[i + 72*ldb] + -0.1805392485472571*b[i + 73*ldb] + 0.01107879640066772*b[i + 74*ldb]);
        c[i + 51*ldc] = (0.08730963130269272*b[i + 60*ldb] + 0.02066118346088678*b[i + 61*ldb] + 0.01539912197902723*b[i + 62*ldb] + 0.3056969514972447*b[i + 63*ldb] + 0.01661907203849378*b[i + 64*ldb] + -0.6974449061221744*b[i + 65*ldb] + 0.217021863935519*b[i + 66*ldb] + 0.313071197570935*b[i + 67*ldb] + -0.02742354100263193*b[i + 68*ldb] + 0.009316048215090128*b[i + 69*ldb] + -0.2716967136714197*b[i + 70*ldb] + 1.40533040629815*b[i + 71*ldb] + -0.08515380986958124*b[i + 72*ldb] + -0.2389821452946306*b[i + 73*ldb] + -0.0697243603376021*b[i + 74*ldb]);
        c[i + 52*ldc] = (0.1067893819824541*b[i + 60*ldb] + -0.03258815541097042*b[i + 61*ldb] + -0.03258815541097042*b[i + 62*ldb] + 0.5133997618360752*b[i + 63*ldb] + -0.5647500511335565*b[i + 64*ldb] + -0.5647500511335565*b[i + 65*ldb] + 1.446419140262625*b[i + 66*ldb] + 0.1033618406535255*b[i + 67*ldb] + 0.1033618406535255*b[i + 68*ldb] + 0.043492184722717*b[i + 69*ldb] + 0.043492184722717*b[i + 70*ldb] + 0.1096948080323159*b[i + 71*ldb] + 0.1096948080323159*b[i + 72*ldb] + -0.1925147689046085*b[i + 73*ldb] + -0.1925147689046085*b[i + 74*ldb]);
        c[i + 53*ldc] = (0.08730963130269272*b[i + 60*ldb] + 0.01539912197902723*b[i + 61*ldb] + 0.02066118346088678*b[i + 62*ldb] + 0.3056969514972447*b[i + 63*ldb] + -0.6974449061221744*b[i + 64*ldb] + 0.01661907203849378*b[i + 65*ldb] + 0.217021863935519*b[i + 66*ldb] + -0.02742354100263193*b[i + 67*ldb] + 0.313071197570935*b[i + 68*ldb] + -0.2716967136714197*b[i + 69*ldb] + 0.009316048215090128*b[i + 70*ldb] + -0.08515380986958124*b[i + 71*ldb] + 1.40533040629815*b[i + 72*ldb] + -0.0697243603376021*b[i + 73*ldb] + -0.2389821452946306*b[i + 74*ldb]);
        c[i + 54*ldc] = (0.05081580409017567*b[i + 60*ldb] + 1.277362792917128*b[i + 61*ldb] + -0.01242883443549132*b[i + 62*ldb] + -0.01135060080460352*b[i + 63*ldb] + -0.02715144289883629*b[i + 64*ldb] + 0.02039085112673084*b[i + 65*ldb] + -0.107487692056558*b[i + 66*ldb] + -0.003038871981994752*b[i + 67*ldb] + 0.3621578131742781*b[i + 68*ldb] + -0.6723301193964519*b[i + 69*ldb] + -0.005994644592905073*b[i + 70*ldb] + 0.04705260855827426*b[i + 71*ldb] + 0.2514627884468437*b[i + 72*ldb] + 0.01107879640066772*b[i + 73*ldb] + -0.1805392485472571*b[i + 74*ldb]);
        c[i + 55*ldc] = (-0.01242883443549132*b[i + 0*ldb] + 1.277362792917128*b[i + 1*ldb] + 0.05081580409017567*b[i + 2*ldb] + 0.02039085112673084*b[i + 3*ldb] + -0.02715144289883629*b[i + 4*ldb] + -0.01135060080460352*b[i + 5*ldb] + 0.3621578131742781*b[i + 6*ldb] + -0.003038871981994752*b[i + 7*ldb] + -0.107487692056558*b[i + 8*ldb] + 0.2514627884468437*b[i + 9*ldb] + 0.01107879640066772*b[i + 10*ldb] + -0.1805392485472571*b[i + 11*ldb] + -0.6723301193964519*b[i + 12*ldb] + -0.005994644592905073*b[i + 13*ldb] + 0.04705260855827426*b[i + 14*ldb]);
        c[i + 56*ldc] = (0.02066118346088678*b[i + 0*ldb] + 0.01539912197902723*b[i + 1*ldb] + 0.08730963130269272*b[i + 2*ldb] + 0.01661907203849378*b[i + 3*ldb] + -0.6974449061221744*b[i + 4*ldb] + 0.3056969514972447*b[i + 5*ldb] + 0.313071197570935*b[i + 6*ldb] + -0.02742354100263193*b[i + 7*ldb] + 0.217021863935519*b[i + 8*ldb] + 1.40533040629815*b[i + 9*ldb] + -0.0697243603376021*b[i + 10*ldb] + -0.2389821452946306*b[i + 11*ldb] + -0.2716967136714197*b[i + 12*ldb] + 0.009316048215090128*b[i + 13*ldb] + -0.08515380986958124*b[i + 14*ldb]);
        c[i + 57*ldc] = (-0.03258815541097042*b[i + 0*ldb] + -0.03258815541097042*b[i + 1*ldb] + 0.1067893819824541*b[i + 2*ldb] + -0.5647500511335565*b[i + 3*ldb] + -0.5647500511335565*b[i + 4*ldb] + 0.5133997618360752*b[i + 5*ldb] + 0.1033618406535255*b[i + 6*ldb] + 0.1033618406535255*b[i + 7*ldb] + 1.446419140262625*b[i + 8*ldb] + 0.1096948080323159*b[i + 9*ldb] + -0.1925147689046085*b[i + 10*ldb] + -0.1925147689046085*b[i + 11*ldb] + 0.043492184722717*b[i + 12*ldb] + 0.043492184722717*b[i + 13*ldb] + 0.1096948080323159*b[i + 14*ldb]);
        c[i + 58*ldc] = (0.01539912197902723*b[i + 0*ldb] + 0.02066118346088678*b[i + 1*ldb] + 0.08730963130269272*b[i + 2*ldb] + -0.6974449061221744*b[i + 3*ldb] + 0.01661907203849378*b[i + 4*ldb] + 0.3056969514972447*b[i + 5*ldb] + -0.02742354100263193*b[i + 6*ldb] + 0.313071197570935*b[i + 7*ldb] + 0.217021863935519*b[i + 8*ldb] + -0.08515380986958124*b[i + 9*ldb] + -0.2389821452946306*b[i + 10*ldb] + -0.0697243603376021*b[i + 11*ldb] + 0.009316048215090128*b[i + 12*ldb] + -0.2716967136714197*b[i + 13*ldb] + 1.40533040629815*b[i + 14*ldb]);
        c[i + 59*ldc] = (1.277362792917128*b[i + 0*ldb] + -0.01242883443549132*b[i + 1*ldb] + 0.05081580409017567*b[i + 2*ldb] + -0.02715144289883629*b[i + 3*ldb] + 0.02039085112673084*b[i + 4*ldb] + -0.01135060080460352*b[i + 5*ldb] + -0.003038871981994752*b[i + 6*ldb] + 0.3621578131742781*b[i + 7*ldb] + -0.107487692056558*b[i + 8*ldb] + 0.04705260855827426*b[i + 9*ldb] + -0.1805392485472571*b[i + 10*ldb] + 0.01107879640066772*b[i + 11*ldb] + -0.005994644592905073*b[i + 12*ldb] + -0.6723301193964519*b[i + 13*ldb] + 0.2514627884468437*b[i + 14*ldb]);
        c[i + 60*ldc] = (-0.01242883443549132*b[i + 15*ldb] + 1.277362792917128*b[i + 16*ldb] + 0.05081580409017567*b[i + 17*ldb] + 0.02039085112673084*b[i + 18*ldb] + -0.02715144289883629*b[i + 19*ldb] + -0.01135060080460352*b[i + 20*ldb] + 0.3621578131742781*b[i + 21*ldb] + -0.003038871981994752*b[i + 22*ldb] + -0.107487692056558*b[i + 23*ldb] + 0.2514627884468437*b[i + 24*ldb] + 0.01107879640066772*b[i + 25*ldb] + -0.1805392485472571*b[i + 26*ldb] + -0.6723301193964519*b[i + 27*ldb] + -0.005994644592905073*b[i + 28*ldb] + 0.04705260855827426*b[i + 29*ldb]);
        c[i + 61*ldc] = (0.02066118346088678*b[i + 15*ldb] + 0.01539912197902723*b[i + 16*ldb] + 0.08730963130269272*b[i + 17*ldb] + 0.01661907203849378*b[i + 18*ldb] + -0.6974449061221744*b[i + 19*ldb] + 0.3056969514972447*b[i + 20*ldb] + 0.313071197570935*b[i + 21*ldb] + -0.02742354100263193*b[i + 22*ldb] + 0.217021863935519*b[i + 23*ldb] + 1.40533040629815*b[i + 24*ldb] + -0.0697243603376021*b[i + 25*ldb] + -0.2389821452946306*b[i + 26*ldb] + -0.2716967136714197*b[i + 27*ldb] + 0.009316048215090128*b[i + 28*ldb] + -0.08515380986958124*b[i + 29*ldb]);
        c[i + 62*ldc] = (-0.03258815541097042*b[i + 15*ldb] + -0.03258815541097042*b[i + 16*ldb] + 0.1067893819824541*b[i + 17*ldb] + -0.5647500511335565*b[i + 18*ldb] + -0.5647500511335565*b[i + 19*ldb] + 0.5133997618360752*b[i + 20*ldb] + 0.1033618406535255*b[i + 21*ldb] + 0.1033618406535255*b[i + 22*ldb] + 1.446419140262625*b[i + 23*ldb] + 0.1096948080323159*b[i + 24*ldb] + -0.1925147689046085*b[i + 25*ldb] + -0.1925147689046085*b[i + 26*ldb] + 0.043492184722717*b[i + 27*ldb] + 0.043492184722717*b[i + 28*ldb] + 0.1096948080323159*b[i + 29*ldb]);
        c[i + 63*ldc] = (0.01539912197902723*b[i + 15*ldb] + 0.02066118346088678*b[i + 16*ldb] + 0.08730963130269272*b[i + 17*ldb] + -0.6974449061221744*b[i + 18*ldb] + 0.01661907203849378*b[i + 19*ldb] + 0.3056969514972447*b[i + 20*ldb] + -0.02742354100263193*b[i + 21*ldb] + 0.313071197570935*b[i + 22*ldb] + 0.217021863935519*b[i + 23*ldb] + -0.08515380986958124*b[i + 24*ldb] + -0.2389821452946306*b[i + 25*ldb] + -0.0697243603376021*b[i + 26*ldb] + 0.009316048215090128*b[i + 27*ldb] + -0.2716967136714197*b[i + 28*ldb] + 1.40533040629815*b[i + 29*ldb]);
        c[i + 64*ldc] = (1.277362792917128*b[i + 15*ldb] + -0.01242883443549132*b[i + 16*ldb] + 0.05081580409017567*b[i + 17*ldb] + -0.02715144289883629*b[i + 18*ldb] + 0.02039085112673084*b[i + 19*ldb] + -0.01135060080460352*b[i + 20*ldb] + -0.003038871981994752*b[i + 21*ldb] + 0.3621578131742781*b[i + 22*ldb] + -0.107487692056558*b[i + 23*ldb] + 0.04705260855827426*b[i + 24*ldb] + -0.1805392485472571*b[i + 25*ldb] + 0.01107879640066772*b[i + 26*ldb] + -0.005994644592905073*b[i + 27*ldb] + -0.6723301193964519*b[i + 28*ldb] + 0.2514627884468437*b[i + 29*ldb]);
        c[i + 65*ldc] = (-0.01242883443549132*b[i + 30*ldb] + 1.277362792917128*b[i + 31*ldb] + 0.05081580409017567*b[i + 32*ldb] + 0.02039085112673084*b[i + 33*ldb] + -0.02715144289883629*b[i + 34*ldb] + -0.01135060080460352*b[i + 35*ldb] + 0.3621578131742781*b[i + 36*ldb] + -0.003038871981994752*b[i + 37*ldb] + -0.107487692056558*b[i + 38*ldb] + 0.2514627884468437*b[i + 39*ldb] + 0.01107879640066772*b[i + 40*ldb] + -0.1805392485472571*b[i + 41*ldb] + -0.6723301193964519*b[i + 42*ldb] + -0.005994644592905073*b[i + 43*ldb] + 0.04705260855827426*b[i + 44*ldb]);
        c[i + 66*ldc] = (0.02066118346088678*b[i + 30*ldb] + 0.01539912197902723*b[i + 31*ldb] + 0.08730963130269272*b[i + 32*ldb] + 0.01661907203849378*b[i + 33*ldb] + -0.6974449061221744*b[i + 34*ldb] + 0.3056969514972447*b[i + 35*ldb] + 0.313071197570935*b[i + 36*ldb] + -0.02742354100263193*b[i + 37*ldb] + 0.217021863935519*b[i + 38*ldb] + 1.40533040629815*b[i + 39*ldb] + -0.0697243603376021*b[i + 40*ldb] + -0.2389821452946306*b[i + 41*ldb] + -0.2716967136714197*b[i + 42*ldb] + 0.009316048215090128*b[i + 43*ldb] + -0.08515380986958124*b[i + 44*ldb]);
        c[i + 67*ldc] = (-0.03258815541097042*b[i + 30*ldb] + -0.03258815541097042*b[i + 31*ldb] + 0.1067893819824541*b[i + 32*ldb] + -0.5647500511335565*b[i + 33*ldb] + -0.5647500511335565*b[i + 34*ldb] + 0.5133997618360752*b[i + 35*ldb] + 0.1033618406535255*b[i + 36*ldb] + 0.1033618406535255*b[i + 37*ldb] + 1.446419140262625*b[i + 38*ldb] + 0.1096948080323159*b[i + 39*ldb] + -0.1925147689046085*b[i + 40*ldb] + -0.1925147689046085*b[i + 41*ldb] + 0.043492184722717*b[i + 42*ldb] + 0.043492184722717*b[i + 43*ldb] + 0.1096948080323159*b[i + 44*ldb]);
        c[i + 68*ldc] = (0.01539912197902723*b[i + 30*ldb] + 0.02066118346088678*b[i + 31*ldb] + 0.08730963130269272*b[i + 32*ldb] + -0.6974449061221744*b[i + 33*ldb] + 0.01661907203849378*b[i + 34*ldb] + 0.3056969514972447*b[i + 35*ldb] + -0.02742354100263193*b[i + 36*ldb] + 0.313071197570935*b[i + 37*ldb] + 0.217021863935519*b[i + 38*ldb] + -0.08515380986958124*b[i + 39*ldb] + -0.2389821452946306*b[i + 40*ldb] + -0.0697243603376021*b[i + 41*ldb] + 0.009316048215090128*b[i + 42*ldb] + -0.2716967136714197*b[i + 43*ldb] + 1.40533040629815*b[i + 44*ldb]);
        c[i + 69*ldc] = (1.277362792917128*b[i + 30*ldb] + -0.01242883443549132*b[i + 31*ldb] + 0.05081580409017567*b[i + 32*ldb] + -0.02715144289883629*b[i + 33*ldb] + 0.02039085112673084*b[i + 34*ldb] + -0.01135060080460352*b[i + 35*ldb] + -0.003038871981994752*b[i + 36*ldb] + 0.3621578131742781*b[i + 37*ldb] + -0.107487692056558*b[i + 38*ldb] + 0.04705260855827426*b[i + 39*ldb] + -0.1805392485472571*b[i + 40*ldb] + 0.01107879640066772*b[i + 41*ldb] + -0.005994644592905073*b[i + 42*ldb] + -0.6723301193964519*b[i + 43*ldb] + 0.2514627884468437*b[i + 44*ldb]);
        c[i + 70*ldc] = (-0.01242883443549132*b[i + 45*ldb] + 1.277362792917128*b[i + 46*ldb] + 0.05081580409017567*b[i + 47*ldb] + 0.02039085112673084*b[i + 48*ldb] + -0.02715144289883629*b[i + 49*ldb] + -0.01135060080460352*b[i + 50*ldb] + 0.3621578131742781*b[i + 51*ldb] + -0.003038871981994752*b[i + 52*ldb] + -0.107487692056558*b[i + 53*ldb] + 0.2514627884468437*b[i + 54*ldb] + 0.01107879640066772*b[i + 55*ldb] + -0.1805392485472571*b[i + 56*ldb] + -0.6723301193964519*b[i + 57*ldb] + -0.005994644592905073*b[i + 58*ldb] + 0.04705260855827426*b[i + 59*ldb]);
        c[i + 71*ldc] = (0.02066118346088678*b[i + 45*ldb] + 0.01539912197902723*b[i + 46*ldb] + 0.08730963130269272*b[i + 47*ldb] + 0.01661907203849378*b[i + 48*ldb] + -0.6974449061221744*b[i + 49*ldb] + 0.3056969514972447*b[i + 50*ldb] + 0.313071197570935*b[i + 51*ldb] + -0.02742354100263193*b[i + 52*ldb] + 0.217021863935519*b[i + 53*ldb] + 1.40533040629815*b[i + 54*ldb] + -0.0697243603376021*b[i + 55*ldb] + -0.2389821452946306*b[i + 56*ldb] + -0.2716967136714197*b[i + 57*ldb] + 0.009316048215090128*b[i + 58*ldb] + -0.08515380986958124*b[i + 59*ldb]);
        c[i + 72*ldc] = (-0.03258815541097042*b[i + 45*ldb] + -0.03258815541097042*b[i + 46*ldb] + 0.1067893819824541*b[i + 47*ldb] + -0.5647500511335565*b[i + 48*ldb] + -0.5647500511335565*b[i + 49*ldb] + 0.5133997618360752*b[i + 50*ldb] + 0.1033618406535255*b[i + 51*ldb] + 0.1033618406535255*b[i + 52*ldb] + 1.446419140262625*b[i + 53*ldb] + 0.1096948080323159*b[i + 54*ldb] + -0.1925147689046085*b[i + 55*ldb] + -0.1925147689046085*b[i + 56*ldb] + 0.043492184722717*b[i + 57*ldb] + 0.043492184722717*b[i + 58*ldb] + 0.1096948080323159*b[i + 59*ldb]);
        c[i + 73*ldc] = (0.01539912197902723*b[i + 45*ldb] + 0.02066118346088678*b[i + 46*ldb] + 0.08730963130269272*b[i + 47*ldb] + -0.6974449061221744*b[i + 48*ldb] + 0.01661907203849378*b[i + 49*ldb] + 0.3056969514972447*b[i + 50*ldb] + -0.02742354100263193*b[i + 51*ldb] + 0.313071197570935*b[i + 52*ldb] + 0.217021863935519*b[i + 53*ldb] + -0.08515380986958124*b[i + 54*ldb] + -0.2389821452946306*b[i + 55*ldb] + -0.0697243603376021*b[i + 56*ldb] + 0.009316048215090128*b[i + 57*ldb] + -0.2716967136714197*b[i + 58*ldb] + 1.40533040629815*b[i + 59*ldb]);
        c[i + 74*ldc] = (1.277362792917128*b[i + 45*ldb] + -0.01242883443549132*b[i + 46*ldb] + 0.05081580409017567*b[i + 47*ldb] + -0.02715144289883629*b[i + 48*ldb] + 0.02039085112673084*b[i + 49*ldb] + -0.01135060080460352*b[i + 50*ldb] + -0.003038871981994752*b[i + 51*ldb] + 0.3621578131742781*b[i + 52*ldb] + -0.107487692056558*b[i + 53*ldb] + 0.04705260855827426*b[i + 54*ldb] + -0.1805392485472571*b[i + 55*ldb] + 0.01107879640066772*b[i + 56*ldb] + -0.005994644592905073*b[i + 57*ldb] + -0.6723301193964519*b[i + 58*ldb] + 0.2514627884468437*b[i + 59*ldb]);
        c[i + 75*ldc] = (-0.01242883443549132*b[i + 60*ldb] + 1.277362792917128*b[i + 61*ldb] + 0.05081580409017567*b[i + 62*ldb] + 0.02039085112673084*b[i + 63*ldb] + -0.02715144289883629*b[i + 64*ldb] + -0.01135060080460352*b[i + 65*ldb] + 0.3621578131742781*b[i + 66*ldb] + -0.003038871981994752*b[i + 67*ldb] + -0.107487692056558*b[i + 68*ldb] + 0.2514627884468437*b[i + 69*ldb] + 0.01107879640066772*b[i + 70*ldb] + -0.1805392485472571*b[i + 71*ldb] + -0.6723301193964519*b[i + 72*ldb] + -0.005994644592905073*b[i + 73*ldb] + 0.04705260855827426*b[i + 74*ldb]);
        c[i + 76*ldc] = (0.02066118346088678*b[i + 60*ldb] + 0.01539912197902723*b[i + 61*ldb] + 0.08730963130269272*b[i + 62*ldb] + 0.01661907203849378*b[i + 63*ldb] + -0.6974449061221744*b[i + 64*ldb] + 0.3056969514972447*b[i + 65*ldb] + 0.313071197570935*b[i + 66*ldb] + -0.02742354100263193*b[i + 67*ldb] + 0.217021863935519*b[i + 68*ldb] + 1.40533040629815*b[i + 69*ldb] + -0.0697243603376021*b[i + 70*ldb] + -0.2389821452946306*b[i + 71*ldb] + -0.2716967136714197*b[i + 72*ldb] + 0.009316048215090128*b[i + 73*ldb] + -0.08515380986958124*b[i + 74*ldb]);
        c[i + 77*ldc] = (-0.03258815541097042*b[i + 60*ldb] + -0.03258815541097042*b[i + 61*ldb] + 0.1067893819824541*b[i + 62*ldb] + -0.5647500511335565*b[i + 63*ldb] + -0.5647500511335565*b[i + 64*ldb] + 0.5133997618360752*b[i + 65*ldb] + 0.1033618406535255*b[i + 66*ldb] + 0.1033618406535255*b[i + 67*ldb] + 1.446419140262625*b[i + 68*ldb] + 0.1096948080323159*b[i + 69*ldb] + -0.1925147689046085*b[i + 70*ldb] + -0.1925147689046085*b[i + 71*ldb] + 0.043492184722717*b[i + 72*ldb] + 0.043492184722717*b[i + 73*ldb] + 0.1096948080323159*b[i + 74*ldb]);
        c[i + 78*ldc] = (0.01539912197902723*b[i + 60*ldb] + 0.02066118346088678*b[i + 61*ldb] + 0.08730963130269272*b[i + 62*ldb] + -0.6974449061221744*b[i + 63*ldb] + 0.01661907203849378*b[i + 64*ldb] + 0.3056969514972447*b[i + 65*ldb] + -0.02742354100263193*b[i + 66*ldb] + 0.313071197570935*b[i + 67*ldb] + 0.217021863935519*b[i + 68*ldb] + -0.08515380986958124*b[i + 69*ldb] + -0.2389821452946306*b[i + 70*ldb] + -0.0697243603376021*b[i + 71*ldb] + 0.009316048215090128*b[i + 72*ldb] + -0.2716967136714197*b[i + 73*ldb] + 1.40533040629815*b[i + 74*ldb]);
        c[i + 79*ldc] = (1.277362792917128*b[i + 60*ldb] + -0.01242883443549132*b[i + 61*ldb] + 0.05081580409017567*b[i + 62*ldb] + -0.02715144289883629*b[i + 63*ldb] + 0.02039085112673084*b[i + 64*ldb] + -0.01135060080460352*b[i + 65*ldb] + -0.003038871981994752*b[i + 66*ldb] + 0.3621578131742781*b[i + 67*ldb] + -0.107487692056558*b[i + 68*ldb] + 0.04705260855827426*b[i + 69*ldb] + -0.1805392485472571*b[i + 70*ldb] + 0.01107879640066772*b[i + 71*ldb] + -0.005994644592905073*b[i + 72*ldb] + -0.6723301193964519*b[i + 73*ldb] + 0.2514627884468437*b[i + 74*ldb]);
        c[i + 80*ldc] = (-0.01242883443549132*b[i + 0*ldb] + 0.05081580409017567*b[i + 1*ldb] + 1.277362792917128*b[i + 2*ldb] + 0.02039085112673084*b[i + 3*ldb] + -0.01135060080460352*b[i + 4*ldb] + -0.02715144289883629*b[i + 5*ldb] + 0.3621578131742781*b[i + 6*ldb] + -0.107487692056558*b[i + 7*ldb] + -0.003038871981994752*b[i + 8*ldb] + 0.01107879640066772*b[i + 9*ldb] + 0.2514627884468437*b[i + 10*ldb] + -0.6723301193964519*b[i + 11*ldb] + -0.1805392485472571*b[i + 12*ldb] + 0.04705260855827426*b[i + 13*ldb] + -0.005994644592905073*b[i + 14*ldb]);
        c[i + 81*ldc] = (0.02066118346088678*b[i + 0*ldb] + 0.08730963130269272*b[i + 1*ldb] + 0.01539912197902723*b[i + 2*ldb] + 0.01661907203849378*b[i + 3*ldb] + 0.3056969514972447*b[i + 4*ldb] + -0.6974449061221744*b[i + 5*ldb] + 0.313071197570935*b[i + 6*ldb] + 0.217021863935519*b[i + 7*ldb] + -0.02742354100263193*b[i + 8*ldb] + -0.0697243603376021*b[i + 9*ldb] + 1.40533040629815*b[i + 10*ldb] + -0.2716967136714197*b[i + 11*ldb] + -0.2389821452946306*b[i + 12*ldb] + -0.08515380986958124*b[i + 13*ldb] + 0.009316048215090128*b[i + 14*ldb]);
        c[i + 82*ldc] = (-0.03258815541097042*b[i + 0*ldb] + 0.1067893819824541*b[i + 1*ldb] + -0.03258815541097042*b[i + 2*ldb] + -0.5647500511335565*b[i + 3*ldb] + 0.5133997618360752*b[i + 4*ldb] + -0.5647500511335565*b[i + 5*ldb] + 0.1033618406535255*b[i + 6*ldb] + 1.446419140262625*b[i + 7*ldb] + 0.1033618406535255*b[i + 8*ldb] + -0.1925147689046085*b[i + 9*ldb] + 0.1096948080323159*b[i + 10*ldb] + 0.043492184722717*b[i + 11*ldb] + -0.1925147689046085*b[i + 12*ldb] + 0.1096948080323159*b[i + 13*ldb] + 0.043492184722717*b[i + 14*ldb]);
        c[i + 83*ldc] = (0.01539912197902723*b[i + 0*ldb] + 0.08730963130269272*b[i + 1*ldb] + 0.02066118346088678*b[i + 2*ldb] + -0.6974449061221744*b[i + 3*ldb] + 0.3056969514972447*b[i + 4*ldb] + 0.01661907203849378*b[i + 5*ldb] + -0.02742354100263193*b[i + 6*ldb] + 0.217021863935519*b[i + 7*ldb] + 0.313071197570935*b[i + 8*ldb] + -0.2389821452946306*b[i + 9*ldb] + -0.08515380986958124*b[i + 10*ldb] + 0.009316048215090128*b[i + 11*ldb] + -0.0697243603376021*b[i + 12*ldb] + 1.40533040629815*b[i + 13*ldb] + -0.2716967136714197*b[i + 14*ldb]);
        c[i + 84*ldc] = (1.277362792917128*b[i + 0*ldb] + 0.05081580409017567*b[i + 1*ldb] + -0.01242883443549132*b[i + 2*ldb] + -0.02715144289883629*b[i + 3*ldb] + -0.01135060080460352*b[i + 4*ldb] + 0.02039085112673084*b[i + 5*ldb] + -0.003038871981994752*b[i + 6*ldb] + -0.107487692056558*b[i + 7*ldb] + 0.3621578131742781*b[i + 8*ldb] + -0.1805392485472571*b[i + 9*ldb] + 0.04705260855827426*b[i + 10*ldb] + -0.005994644592905073*b[i + 11*ldb] + 0.01107879640066772*b[i + 12*ldb] + 0.2514627884468437*b[i + 13*ldb] + -0.6723301193964519*b[i + 14*ldb]);
        c[i + 85*ldc] = (-0.01242883443549132*b[i + 15*ldb] + 0.05081580409017567*b[i + 16*ldb] + 1.277362792917128*b[i + 17*ldb] + 0.02039085112673084*b[i + 18*ldb] + -0.01135060080460352*b[i + 19*ldb] + -0.02715144289883629*b[i + 20*ldb] + 0.3621578131742781*b[i + 21*ldb] + -0.107487692056558*b[i + 22*ldb] + -0.003038871981994752*b[i + 23*ldb] + 0.01107879640066772*b[i + 24*ldb] + 0.2514627884468437*b[i + 25*ldb] + -0.6723301193964519*b[i + 26*ldb] + -0.1805392485472571*b[i + 27*ldb] + 0.04705260855827426*b[i + 28*ldb] + -0.005994644592905073*b[i + 29*ldb]);
        c[i + 86*ldc] = (0.02066118346088678*b[i + 15*ldb] + 0.08730963130269272*b[i + 16*ldb] + 0.01539912197902723*b[i + 17*ldb] + 0.01661907203849378*b[i + 18*ldb] + 0.3056969514972447*b[i + 19*ldb] + -0.6974449061221744*b[i + 20*ldb] + 0.313071197570935*b[i + 21*ldb] + 0.217021863935519*b[i + 22*ldb] + -0.02742354100263193*b[i + 23*ldb] + -0.0697243603376021*b[i + 24*ldb] + 1.40533040629815*b[i + 25*ldb] + -0.2716967136714197*b[i + 26*ldb] + -0.2389821452946306*b[i + 27*ldb] + -0.08515380986958124*b[i + 28*ldb] + 0.009316048215090128*b[i + 29*ldb]);
        c[i + 87*ldc] = (-0.03258815541097042*b[i + 15*ldb] + 0.1067893819824541*b[i + 16*ldb] + -0.03258815541097042*b[i + 17*ldb] + -0.5647500511335565*b[i + 18*ldb] + 0.5133997618360752*b[i + 19*ldb] + -0.5647500511335565*b[i + 20*ldb] + 0.1033618406535255*b[i + 21*ldb] + 1.446419140262625*b[i + 22*ldb] + 0.1033618406535255*b[i + 23*ldb] + -0.1925147689046085*b[i + 24*ldb] + 0.1096948080323159*b[i + 25*ldb] + 0.043492184722717*b[i + 26*ldb] + -0.1925147689046085*b[i + 27*ldb] + 0.1096948080323159*b[i + 28*ldb] + 0.043492184722717*b[i + 29*ldb]);
        c[i + 88*ldc] = (0.01539912197902723*b[i + 15*ldb] + 0.08730963130269272*b[i + 16*ldb] + 0.02066118346088678*b[i + 17*ldb] + -0.6974449061221744*b[i + 18*ldb] + 0.3056969514972447*b[i + 19*ldb] + 0.01661907203849378*b[i + 20*ldb] + -0.02742354100263193*b[i + 21*ldb] + 0.217021863935519*b[i + 22*ldb] + 0.313071197570935*b[i + 23*ldb] + -0.2389821452946306*b[i + 24*ldb] + -0.08515380986958124*b[i + 25*ldb] + 0.009316048215090128*b[i + 26*ldb] + -0.0697243603376021*b[i + 27*ldb] + 1.40533040629815*b[i + 28*ldb] + -0.2716967136714197*b[i + 29*ldb]);
        c[i + 89*ldc] = (1.277362792917128*b[i + 15*ldb] + 0.05081580409017567*b[i + 16*ldb] + -0.01242883443549132*b[i + 17*ldb] + -0.02715144289883629*b[i + 18*ldb] + -0.01135060080460352*b[i + 19*ldb] + 0.02039085112673084*b[i + 20*ldb] + -0.003038871981994752*b[i + 21*ldb] + -0.107487692056558*b[i + 22*ldb] + 0.3621578131742781*b[i + 23*ldb] + -0.1805392485472571*b[i + 24*ldb] + 0.04705260855827426*b[i + 25*ldb] + -0.005994644592905073*b[i + 26*ldb] + 0.01107879640066772*b[i + 27*ldb] + 0.2514627884468437*b[i + 28*ldb] + -0.6723301193964519*b[i + 29*ldb]);
        c[i + 90*ldc] = (-0.01242883443549132*b[i + 30*ldb] + 0.05081580409017567*b[i + 31*ldb] + 1.277362792917128*b[i + 32*ldb] + 0.02039085112673084*b[i + 33*ldb] + -0.01135060080460352*b[i + 34*ldb] + -0.02715144289883629*b[i + 35*ldb] + 0.3621578131742781*b[i + 36*ldb] + -0.107487692056558*b[i + 37*ldb] + -0.003038871981994752*b[i + 38*ldb] + 0.01107879640066772*b[i + 39*ldb] + 0.2514627884468437*b[i + 40*ldb] + -0.6723301193964519*b[i + 41*ldb] + -0.1805392485472571*b[i + 42*ldb] + 0.04705260855827426*b[i + 43*ldb] + -0.005994644592905073*b[i + 44*ldb]);
        c[i + 91*ldc] = (0.02066118346088678*b[i + 30*ldb] + 0.08730963130269272*b[i + 31*ldb] + 0.01539912197902723*b[i + 32*ldb] + 0.01661907203849378*b[i + 33*ldb] + 0.3056969514972447*b[i + 34*ldb] + -0.6974449061221744*b[i + 35*ldb] + 0.313071197570935*b[i + 36*ldb] + 0.217021863935519*b[i + 37*ldb] + -0.02742354100263193*b[i + 38*ldb] + -0.0697243603376021*b[i + 39*ldb] + 1.40533040629815*b[i + 40*ldb] + -0.2716967136714197*b[i + 41*ldb] + -0.2389821452946306*b[i + 42*ldb] + -0.08515380986958124*b[i + 43*ldb] + 0.009316048215090128*b[i + 44*ldb]);
        c[i + 92*ldc] = (-0.03258815541097042*b[i + 30*ldb] + 0.1067893819824541*b[i + 31*ldb] + -0.03258815541097042*b[i + 32*ldb] + -0.5647500511335565*b[i + 33*ldb] + 0.5133997618360752*b[i + 34*ldb] + -0.5647500511335565*b[i + 35*ldb] + 0.1033618406535255*b[i + 36*ldb] + 1.446419140262625*b[i + 37*ldb] + 0.1033618406535255*b[i + 38*ldb] + -0.1925147689046085*b[i + 39*ldb] + 0.1096948080323159*b[i + 40*ldb] + 0.043492184722717*b[i + 41*ldb] + -0.1925147689046085*b[i + 42*ldb] + 0.1096948080323159*b[i + 43*ldb] + 0.043492184722717*b[i + 44*ldb]);
        c[i + 93*ldc] = (0.01539912197902723*b[i + 30*ldb] + 0.08730963130269272*b[i + 31*ldb] + 0.02066118346088678*b[i + 32*ldb] + -0.6974449061221744*b[i + 33*ldb] + 0.3056969514972447*b[i + 34*ldb] + 0.01661907203849378*b[i + 35*ldb] + -0.02742354100263193*b[i + 36*ldb] + 0.217021863935519*b[i + 37*ldb] + 0.313071197570935*b[i + 38*ldb] + -0.2389821452946306*b[i + 39*ldb] + -0.08515380986958124*b[i + 40*ldb] + 0.009316048215090128*b[i + 41*ldb] + -0.0697243603376021*b[i + 42*ldb] + 1.40533040629815*b[i + 43*ldb] + -0.2716967136714197*b[i + 44*ldb]);
        c[i + 94*ldc] = (1.277362792917128*b[i + 30*ldb] + 0.05081580409017567*b[i + 31*ldb] + -0.01242883443549132*b[i + 32*ldb] + -0.02715144289883629*b[i + 33*ldb] + -0.01135060080460352*b[i + 34*ldb] + 0.02039085112673084*b[i + 35*ldb] + -0.003038871981994752*b[i + 36*ldb] + -0.107487692056558*b[i + 37*ldb] + 0.3621578131742781*b[i + 38*ldb] + -0.1805392485472571*b[i + 39*ldb] + 0.04705260855827426*b[i + 40*ldb] + -0.005994644592905073*b[i + 41*ldb] + 0.01107879640066772*b[i + 42*ldb] + 0.2514627884468437*b[i + 43*ldb] + -0.6723301193964519*b[i + 44*ldb]);
        c[i + 95*ldc] = (-0.01242883443549132*b[i + 45*ldb] + 0.05081580409017567*b[i + 46*ldb] + 1.277362792917128*b[i + 47*ldb] + 0.02039085112673084*b[i + 48*ldb] + -0.01135060080460352*b[i + 49*ldb] + -0.02715144289883629*b[i + 50*ldb] + 0.3621578131742781*b[i + 51*ldb] + -0.107487692056558*b[i + 52*ldb] + -0.003038871981994752*b[i + 53*ldb] + 0.01107879640066772*b[i + 54*ldb] + 0.2514627884468437*b[i + 55*ldb] + -0.6723301193964519*b[i + 56*ldb] + -0.1805392485472571*b[i + 57*ldb] + 0.04705260855827426*b[i + 58*ldb] + -0.005994644592905073*b[i + 59*ldb]);
        c[i + 96*ldc] = (0.02066118346088678*b[i + 45*ldb] + 0.08730963130269272*b[i + 46*ldb] + 0.01539912197902723*b[i + 47*ldb] + 0.01661907203849378*b[i + 48*ldb] + 0.3056969514972447*b[i + 49*ldb] + -0.6974449061221744*b[i + 50*ldb] + 0.313071197570935*b[i + 51*ldb] + 0.217021863935519*b[i + 52*ldb] + -0.02742354100263193*b[i + 53*ldb] + -0.0697243603376021*b[i + 54*ldb] + 1.40533040629815*b[i + 55*ldb] + -0.2716967136714197*b[i + 56*ldb] + -0.2389821452946306*b[i + 57*ldb] + -0.08515380986958124*b[i + 58*ldb] + 0.009316048215090128*b[i + 59*ldb]);
        c[i + 97*ldc] = (-0.03258815541097042*b[i + 45*ldb] + 0.1067893819824541*b[i + 46*ldb] + -0.03258815541097042*b[i + 47*ldb] + -0.5647500511335565*b[i + 48*ldb] + 0.5133997618360752*b[i + 49*ldb] + -0.5647500511335565*b[i + 50*ldb] + 0.1033618406535255*b[i + 51*ldb] + 1.446419140262625*b[i + 52*ldb] + 0.1033618406535255*b[i + 53*ldb] + -0.1925147689046085*b[i + 54*ldb] + 0.1096948080323159*b[i + 55*ldb] + 0.043492184722717*b[i + 56*ldb] + -0.1925147689046085*b[i + 57*ldb] + 0.1096948080323159*b[i + 58*ldb] + 0.043492184722717*b[i + 59*ldb]);
        c[i + 98*ldc] = (0.01539912197902723*b[i + 45*ldb] + 0.08730963130269272*b[i + 46*ldb] + 0.02066118346088678*b[i + 47*ldb] + -0.6974449061221744*b[i + 48*ldb] + 0.3056969514972447*b[i + 49*ldb] + 0.01661907203849378*b[i + 50*ldb] + -0.02742354100263193*b[i + 51*ldb] + 0.217021863935519*b[i + 52*ldb] + 0.313071197570935*b[i + 53*ldb] + -0.2389821452946306*b[i + 54*ldb] + -0.08515380986958124*b[i + 55*ldb] + 0.009316048215090128*b[i + 56*ldb] + -0.0697243603376021*b[i + 57*ldb] + 1.40533040629815*b[i + 58*ldb] + -0.2716967136714197*b[i + 59*ldb]);
        c[i + 99*ldc] = (1.277362792917128*b[i + 45*ldb] + 0.05081580409017567*b[i + 46*ldb] + -0.01242883443549132*b[i + 47*ldb] + -0.02715144289883629*b[i + 48*ldb] + -0.01135060080460352*b[i + 49*ldb] + 0.02039085112673084*b[i + 50*ldb] + -0.003038871981994752*b[i + 51*ldb] + -0.107487692056558*b[i + 52*ldb] + 0.3621578131742781*b[i + 53*ldb] + -0.1805392485472571*b[i + 54*ldb] + 0.04705260855827426*b[i + 55*ldb] + -0.005994644592905073*b[i + 56*ldb] + 0.01107879640066772*b[i + 57*ldb] + 0.2514627884468437*b[i + 58*ldb] + -0.6723301193964519*b[i + 59*ldb]);
        c[i + 100*ldc] = (-0.01242883443549132*b[i + 60*ldb] + 0.05081580409017567*b[i + 61*ldb] + 1.277362792917128*b[i + 62*ldb] + 0.02039085112673084*b[i + 63*ldb] + -0.01135060080460352*b[i + 64*ldb] + -0.02715144289883629*b[i + 65*ldb] + 0.3621578131742781*b[i + 66*ldb] + -0.107487692056558*b[i + 67*ldb] + -0.003038871981994752*b[i + 68*ldb] + 0.01107879640066772*b[i + 69*ldb] + 0.2514627884468437*b[i + 70*ldb] + -0.6723301193964519*b[i + 71*ldb] + -0.1805392485472571*b[i + 72*ldb] + 0.04705260855827426*b[i + 73*ldb] + -0.005994644592905073*b[i + 74*ldb]);
        c[i + 101*ldc] = (0.02066118346088678*b[i + 60*ldb] + 0.08730963130269272*b[i + 61*ldb] + 0.01539912197902723*b[i + 62*ldb] + 0.01661907203849378*b[i + 63*ldb] + 0.3056969514972447*b[i + 64*ldb] + -0.6974449061221744*b[i + 65*ldb] + 0.313071197570935*b[i + 66*ldb] + 0.217021863935519*b[i + 67*ldb] + -0.02742354100263193*b[i + 68*ldb] + -0.0697243603376021*b[i + 69*ldb] + 1.40533040629815*b[i + 70*ldb] + -0.2716967136714197*b[i + 71*ldb] + -0.2389821452946306*b[i + 72*ldb] + -0.08515380986958124*b[i + 73*ldb] + 0.009316048215090128*b[i + 74*ldb]);
        c[i + 102*ldc] = (-0.03258815541097042*b[i + 60*ldb] + 0.1067893819824541*b[i + 61*ldb] + -0.03258815541097042*b[i + 62*ldb] + -0.5647500511335565*b[i + 63*ldb] + 0.5133997618360752*b[i + 64*ldb] + -0.5647500511335565*b[i + 65*ldb] + 0.1033618406535255*b[i + 66*ldb] + 1.446419140262625*b[i + 67*ldb] + 0.1033618406535255*b[i + 68*ldb] + -0.1925147689046085*b[i + 69*ldb] + 0.1096948080323159*b[i + 70*ldb] + 0.043492184722717*b[i + 71*ldb] + -0.1925147689046085*b[i + 72*ldb] + 0.1096948080323159*b[i + 73*ldb] + 0.043492184722717*b[i + 74*ldb]);
        c[i + 103*ldc] = (0.01539912197902723*b[i + 60*ldb] + 0.08730963130269272*b[i + 61*ldb] + 0.02066118346088678*b[i + 62*ldb] + -0.6974449061221744*b[i + 63*ldb] + 0.3056969514972447*b[i + 64*ldb] + 0.01661907203849378*b[i + 65*ldb] + -0.02742354100263193*b[i + 66*ldb] + 0.217021863935519*b[i + 67*ldb] + 0.313071197570935*b[i + 68*ldb] + -0.2389821452946306*b[i + 69*ldb] + -0.08515380986958124*b[i + 70*ldb] + 0.009316048215090128*b[i + 71*ldb] + -0.0697243603376021*b[i + 72*ldb] + 1.40533040629815*b[i + 73*ldb] + -0.2716967136714197*b[i + 74*ldb]);
        c[i + 104*ldc] = (1.277362792917128*b[i + 60*ldb] + 0.05081580409017567*b[i + 61*ldb] + -0.01242883443549132*b[i + 62*ldb] + -0.02715144289883629*b[i + 63*ldb] + -0.01135060080460352*b[i + 64*ldb] + 0.02039085112673084*b[i + 65*ldb] + -0.003038871981994752*b[i + 66*ldb] + -0.107487692056558*b[i + 67*ldb] + 0.3621578131742781*b[i + 68*ldb] + -0.1805392485472571*b[i + 69*ldb] + 0.04705260855827426*b[i + 70*ldb] + -0.005994644592905073*b[i + 71*ldb] + 0.01107879640066772*b[i + 72*ldb] + 0.2514627884468437*b[i + 73*ldb] + -0.6723301193964519*b[i + 74*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_pri_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (6.548045607936747*b[i + 0*ldb] + 0.3222878728081189*b[i + 15*ldb] + 0.3766849869423851*b[i + 30*ldb] + 0.9249186854440405*b[i + 31*ldb] + 1.205841535663667*b[i + 32*ldb] + 0.9249186854440405*b[i + 33*ldb] + 0.3766849869423851*b[i + 34*ldb] + -0.0340706876090276*b[i + 55*ldb] + 0.1414709948159385*b[i + 56*ldb] + -0.3732534616347094*b[i + 57*ldb] + 0.5787140289764674*b[i + 58*ldb] + 8.177986284176342*b[i + 59*ldb] + -0.0340706876090276*b[i + 80*ldb] + 0.1414709948159385*b[i + 81*ldb] + -0.3732534616347094*b[i + 82*ldb] + 0.5787140289764674*b[i + 83*ldb] + 8.177986284176342*b[i + 84*ldb]);
        c[i + 1*ldc] += (6.548045607936747*b[i + 1*ldb] + 0.3222878728081189*b[i + 16*ldb] + -0.0340706876090276*b[i + 30*ldb] + 0.1414709948159385*b[i + 31*ldb] + -0.3732534616347094*b[i + 32*ldb] + 0.5787140289764674*b[i + 33*ldb] + 8.177986284176342*b[i + 34*ldb] + 8.177986284176342*b[i + 55*ldb] + 0.5787140289764674*b[i + 56*ldb] + -0.3732534616347094*b[i + 57*ldb] + 0.1414709948159385*b[i + 58*ldb] + -0.0340706876090276*b[i + 59*ldb] + 0.3766849869423851*b[i + 80*ldb] + 0.9249186854440405*b[i + 81*ldb] + 1.205841535663667*b[i + 82*ldb] + 0.9249186854440405*b[i + 83*ldb] + 0.3766849869423851*b[i + 84*ldb]);
        c[i + 2*ldc] += (6.548045607936747*b[i + 2*ldb] + 0.3222878728081189*b[i + 17*ldb] + 8.177986284176342*b[i + 30*ldb] + 0.5787140289764674*b[i + 31*ldb] + -0.3732534616347094*b[i + 32*ldb] + 0.1414709948159385*b[i + 33*ldb] + -0.0340706876090276*b[i + 34*ldb] + 0.3766849869423851*b[i + 55*ldb] + 0.9249186854440405*b[i + 56*ldb] + 1.205841535663667*b[i + 57*ldb] + 0.9249186854440405*b[i + 58*ldb] + 0.3766849869423851*b[i + 59*ldb] + 8.177986284176342*b[i + 80*ldb] + 0.5787140289764674*b[i + 81*ldb] + -0.3732534616347094*b[i + 82*ldb] + 0.1414709948159385*b[i + 83*ldb] + -0.0340706876090276*b[i + 84*ldb]);
        c[i + 3*ldc] += (6.548045607936747*b[i + 3*ldb] + 0.3222878728081189*b[i + 18*ldb] + 0.03078013091636318*b[i + 30*ldb] + 0.4044323368695614*b[i + 31*ldb] + 0.9758930126717729*b[i + 32*ldb] + 0.4044323368695614*b[i + 33*ldb] + 0.03078013091636318*b[i + 34*ldb] + 0.1065108706569845*b[i + 55*ldb] + 0.01797338358554743*b[i + 56*ldb] + -1.172900949469982*b[i + 57*ldb] + -1.125310822402669*b[i + 58*ldb] + -0.1520494233293387*b[i + 59*ldb] + 0.1065108706569845*b[i + 80*ldb] + 0.01797338358554743*b[i + 81*ldb] + -1.172900949469982*b[i + 82*ldb] + -1.125310822402669*b[i + 83*ldb] + -0.1520494233293387*b[i + 84*ldb]);
        c[i + 4*ldc] += (6.548045607936747*b[i + 4*ldb] + 0.3222878728081189*b[i + 19*ldb] + 0.1065108706569845*b[i + 30*ldb] + 0.01797338358554743*b[i + 31*ldb] + -1.172900949469982*b[i + 32*ldb] + -1.125310822402669*b[i + 33*ldb] + -0.1520494233293387*b[i + 34*ldb] + -0.1520494233293387*b[i + 55*ldb] + -1.125310822402669*b[i + 56*ldb] + -1.172900949469982*b[i + 57*ldb] + 0.01797338358554743*b[i + 58*ldb] + 0.1065108706569845*b[i + 59*ldb] + 0.03078013091636318*b[i + 80*ldb] + 0.4044323368695614*b[i + 81*ldb] + 0.9758930126717729*b[i + 82*ldb] + 0.4044323368695614*b[i + 83*ldb] + 0.03078013091636318*b[i + 84*ldb]);
        c[i + 5*ldc] += (6.548045607936747*b[i + 5*ldb] + 0.3222878728081189*b[i + 20*ldb] + -0.1520494233293387*b[i + 30*ldb] + -1.125310822402669*b[i + 31*ldb] + -1.172900949469982*b[i + 32*ldb] + 0.01797338358554743*b[i + 33*ldb] + 0.1065108706569845*b[i + 34*ldb] + 0.03078013091636318*b[i + 55*ldb] + 0.4044323368695614*b[i + 56*ldb] + 0.9758930126717729*b[i + 57*ldb] + 0.4044323368695614*b[i + 58*ldb] + 0.03078013091636318*b[i + 59*ldb] + -0.1520494233293387*b[i + 80*ldb] + -1.125310822402669*b[i + 81*ldb] + -1.172900949469982*b[i + 82*ldb] + 0.01797338358554743*b[i + 83*ldb] + 0.1065108706569845*b[i + 84*ldb]);
        c[i + 6*ldc] += (6.548045607936747*b[i + 6*ldb] + 0.3222878728081189*b[i + 21*ldb] + -0.2111687061258069*b[i + 30*ldb] + 0.6143808272731024*b[i + 31*ldb] + 5.454458520792602*b[i + 32*ldb] + 0.6143808272731024*b[i + 33*ldb] + -0.2111687061258069*b[i + 34*ldb] + 0.5856389335240263*b[i + 55*ldb] + 1.072236397422101*b[i + 56*ldb] + 0.3158549142070798*b[i + 57*ldb] + -0.1092563383478909*b[i + 58*ldb] + -0.05850347735875195*b[i + 59*ldb] + 0.5856389335240263*b[i + 80*ldb] + 1.072236397422101*b[i + 81*ldb] + 0.3158549142070798*b[i + 82*ldb] + -0.1092563383478909*b[i + 83*ldb] + -0.05850347735875195*b[i + 84*ldb]);
        c[i + 7*ldc] += (6.548045607936747*b[i + 7*ldb] + 0.3222878728081189*b[i + 22*ldb] + 0.5856389335240263*b[i + 30*ldb] + 1.072236397422101*b[i + 31*ldb] + 0.3158549142070798*b[i + 32*ldb] + -0.1092563383478909*b[i + 33*ldb] + -0.05850347735875195*b[i + 34*ldb] + -0.05850347735875195*b[i + 55*ldb] + -0.1092563383478909*b[i + 56*ldb] + 0.3158549142070798*b[i + 57*ldb] + 1.072236397422101*b[i + 58*ldb] + 0.5856389335240263*b[i + 59*ldb] + -0.2111687061258069*b[i + 80*ldb] + 0.6143808272731024*b[i + 81*ldb] + 5.454458520792602*b[i + 82*ldb] + 0.6143808272731024*b[i + 83*ldb] + -0.2111687061258069*b[i + 84*ldb]);
        c[i + 8*ldc] += (6.548045607936747*b[i + 8*ldb] + 0.3222878728081189*b[i + 23*ldb] + -0.05850347735875195*b[i + 30*ldb] + -0.1092563383478909*b[i + 31*ldb] + 0.3158549142070798*b[i + 32*ldb] + 1.072236397422101*b[i + 33*ldb] + 0.5856389335240263*b[i + 34*ldb] + -0.2111687061258069*b[i + 55*ldb] + 0.6143808272731024*b[i + 56*ldb] + 5.454458520792602*b[i + 57*ldb] + 0.6143808272731024*b[i + 58*ldb] + -0.2111687061258069*b[i + 59*ldb] + -0.05850347735875195*b[i + 80*ldb] + -0.1092563383478909*b[i + 81*ldb] + 0.3158549142070798*b[i + 82*ldb] + 1.072236397422101*b[i + 83*ldb] + 0.5856389335240263*b[i + 84*ldb]);
        c[i + 9*ldc] += (6.548045607936747*b[i + 9*ldb] + 0.3222878728081189*b[i + 24*ldb] + -0.04441552013474288*b[i + 30*ldb] + 0.09218614391798516*b[i + 31*ldb] + 0.2356403269331877*b[i + 32*ldb] + -1.426271532084567*b[i + 33*ldb] + -1.33618960885414*b[i + 34*ldb] + 0.6982350131118886*b[i + 55*ldb] + 5.935183299806961*b[i + 56*ldb] + 0.4050837191937215*b[i + 57*ldb] + -0.2981430049956752*b[i + 58*ldb] + 0.0740478351152375*b[i + 59*ldb] + 0.03493992481549068*b[i + 80*ldb] + -0.1054765566754525*b[i + 81*ldb] + -0.7540302351461837*b[i + 82*ldb] + -0.9794109587905273*b[i + 83*ldb] + -0.4379349075782941*b[i + 84*ldb]);
        c[i + 10*ldc] += (6.548045607936747*b[i + 10*ldb] + 0.3222878728081189*b[i + 25*ldb] + -1.33618960885414*b[i + 30*ldb] + -1.426271532084567*b[i + 31*ldb] + 0.2356403269331877*b[i + 32*ldb] + 0.09218614391798516*b[i + 33*ldb] + -0.04441552013474288*b[i + 34*ldb] + 0.03493992481549068*b[i + 55*ldb] + -0.1054765566754525*b[i + 56*ldb] + -0.7540302351461837*b[i + 57*ldb] + -0.9794109587905273*b[i + 58*ldb] + -0.4379349075782941*b[i + 59*ldb] + 0.6982350131118886*b[i + 80*ldb] + 5.935183299806961*b[i + 81*ldb] + 0.4050837191937215*b[i + 82*ldb] + -0.2981430049956752*b[i + 83*ldb] + 0.0740478351152375*b[i + 84*ldb]);
        c[i + 11*ldc] += (6.548045607936747*b[i + 11*ldb] + 0.3222878728081189*b[i + 26*ldb] + 0.6982350131118886*b[i + 30*ldb] + 5.935183299806961*b[i + 31*ldb] + 0.4050837191937215*b[i + 32*ldb] + -0.2981430049956752*b[i + 33*ldb] + 0.0740478351152375*b[i + 34*ldb] + -0.4379349075782941*b[i + 55*ldb] + -0.9794109587905273*b[i + 56*ldb] + -0.7540302351461837*b[i + 57*ldb] + -0.1054765566754525*b[i + 58*ldb] + 0.03493992481549068*b[i + 59*ldb] + -1.33618960885414*b[i + 80*ldb] + -1.426271532084567*b[i + 81*ldb] + 0.2356403269331877*b[i + 82*ldb] + 0.09218614391798516*b[i + 83*ldb] + -0.04441552013474288*b[i + 84*ldb]);
        c[i + 12*ldc] += (6.548045607936747*b[i + 12*ldb] + 0.3222878728081189*b[i + 27*ldb] + 0.0740478351152375*b[i + 30*ldb] + -0.2981430049956752*b[i + 31*ldb] + 0.4050837191937215*b[i + 32*ldb] + 5.935183299806961*b[i + 33*ldb] + 0.6982350131118886*b[i + 34*ldb] + -1.33618960885414*b[i + 55*ldb] + -1.426271532084567*b[i + 56*ldb] + 0.2356403269331877*b[i + 57*ldb] + 0.09218614391798516*b[i + 58*ldb] + -0.04441552013474288*b[i + 59*ldb] + -0.4379349075782941*b[i + 80*ldb] + -0.9794109587905273*b[i + 81*ldb] + -0.7540302351461837*b[i + 82*ldb] + -0.1054765566754525*b[i + 83*ldb] + 0.03493992481549068*b[i + 84*ldb]);
        c[i + 13*ldc] += (6.548045607936747*b[i + 13*ldb] + 0.3222878728081189*b[i + 28*ldb] + -0.4379349075782941*b[i + 30*ldb] + -0.9794109587905273*b[i + 31*ldb] + -0.7540302351461837*b[i + 32*ldb] + -0.1054765566754525*b[i + 33*ldb] + 0.03493992481549068*b[i + 34*ldb] + -0.04441552013474288*b[i + 55*ldb] + 0.09218614391798516*b[i + 56*ldb] + 0.2356403269331877*b[i + 57*ldb] + -1.426271532084567*b[i + 58*ldb] + -1.33618960885414*b[i + 59*ldb] + 0.0740478351152375*b[i + 80*ldb] + -0.2981430049956752*b[i + 81*ldb] + 0.4050837191937215*b[i + 82*ldb] + 5.935183299806961*b[i + 83*ldb] + 0.6982350131118886*b[i + 84*ldb]);
        c[i + 14*ldc] += (6.548045607936747*b[i + 14*ldb] + 0.3222878728081189*b[i + 29*ldb] + 0.03493992481549068*b[i + 30*ldb] + -0.1054765566754525*b[i + 31*ldb] + -0.7540302351461837*b[i + 32*ldb] + -0.9794109587905273*b[i + 33*ldb] + -0.4379349075782941*b[i + 34*ldb] + 0.0740478351152375*b[i + 55*ldb] + -0.2981430049956752*b[i + 56*ldb] + 0.4050837191937215*b[i + 57*ldb] + 5.935183299806961*b[i + 58*ldb] + 0.6982350131118886*b[i + 59*ldb] + -0.04441552013474288*b[i + 80*ldb] + 0.09218614391798516*b[i + 81*ldb] + 0.2356403269331877*b[i + 82*ldb] + -1.426271532084567*b[i + 83*ldb] + -1.33618960885414*b[i + 84*ldb]);
        c[i + 15*ldc] += (-1.866077916035024*b[i + 0*ldb] + -0.5598111202653964*b[i + 15*ldb] + 0.3766849869423851*b[i + 35*ldb] + 0.9249186854440405*b[i + 36*ldb] + 1.205841535663667*b[i + 37*ldb] + 0.9249186854440405*b[i + 38*ldb] + 0.3766849869423851*b[i + 39*ldb] + -0.0340706876090276*b[i + 60*ldb] + 0.1414709948159385*b[i + 61*ldb] + -0.3732534616347094*b[i + 62*ldb] + 0.5787140289764674*b[i + 63*ldb] + 8.177986284176342*b[i + 64*ldb] + -0.0340706876090276*b[i + 85*ldb] + 0.1414709948159385*b[i + 86*ldb] + -0.3732534616347094*b[i + 87*ldb] + 0.5787140289764674*b[i + 88*ldb] + 8.177986284176342*b[i + 89*ldb]);
        c[i + 16*ldc] += (-1.866077916035024*b[i + 1*ldb] + -0.5598111202653964*b[i + 16*ldb] + -0.0340706876090276*b[i + 35*ldb] + 0.1414709948159385*b[i + 36*ldb] + -0.3732534616347094*b[i + 37*ldb] + 0.5787140289764674*b[i + 38*ldb] + 8.177986284176342*b[i + 39*ldb] + 8.177986284176342*b[i + 60*ldb] + 0.5787140289764674*b[i + 61*ldb] + -0.3732534616347094*b[i + 62*ldb] + 0.1414709948159385*b[i + 63*ldb] + -0.0340706876090276*b[i + 64*ldb] + 0.3766849869423851*b[i + 85*ldb] + 0.9249186854440405*b[i + 86*ldb] + 1.205841535663667*b[i + 87*ldb] + 0.9249186854440405*b[i + 88*ldb] + 0.3766849869423851*b[i + 89*ldb]);
        c[i + 17*ldc] += (-1.866077916035024*b[i + 2*ldb] + -0.5598111202653964*b[i + 17*ldb] + 8.177986284176342*b[i + 35*ldb] + 0.5787140289764674*b[i + 36*ldb] + -0.3732534616347094*b[i + 37*ldb] + 0.1414709948159385*b[i + 38*ldb] + -0.0340706876090276*b[i + 39*ldb] + 0.3766849869423851*b[i + 60*ldb] + 0.9249186854440405*b[i + 61*ldb] + 1.205841535663667*b[i + 62*ldb] + 0.9249186854440405*b[i + 63*ldb] + 0.3766849869423851*b[i + 64*ldb] + 8.177986284176342*b[i + 85*ldb] + 0.5787140289764674*b[i + 86*ldb] + -0.3732534616347094*b[i + 87*ldb] + 0.1414709948159385*b[i + 88*ldb] + -0.0340706876090276*b[i + 89*ldb]);
        c[i + 18*ldc] += (-1.866077916035024*b[i + 3*ldb] + -0.5598111202653964*b[i + 18*ldb] + 0.03078013091636318*b[i + 35*ldb] + 0.4044323368695614*b[i + 36*ldb] + 0.9758930126717729*b[i + 37*ldb] + 0.4044323368695614*b[i + 38*ldb] + 0.03078013091636318*b[i + 39*ldb] + 0.1065108706569845*b[i + 60*ldb] + 0.01797338358554743*b[i + 61*ldb] + -1.172900949469982*b[i + 62*ldb] + -1.125310822402669*b[i + 63*ldb] + -0.1520494233293387*b[i + 64*ldb] + 0.1065108706569845*b[i + 85*ldb] + 0.01797338358554743*b[i + 86*ldb] + -1.172900949469982*b[i + 87*ldb] + -1.125310822402669*b[i + 88*ldb] + -0.1520494233293387*b[i + 89*ldb]);
        c[i + 19*ldc] += (-1.866077916035024*b[i + 4*ldb] + -0.5598111202653964*b[i + 19*ldb] + 0.1065108706569845*b[i + 35*ldb] + 0.01797338358554743*b[i + 36*ldb] + -1.172900949469982*b[i + 37*ldb] + -1.125310822402669*b[i + 38*ldb] + -0.1520494233293387*b[i + 39*ldb] + -0.1520494233293387*b[i + 60*ldb] + -1.125310822402669*b[i + 61*ldb] + -1.172900949469982*b[i + 62*ldb] + 0.01797338358554743*b[i + 63*ldb] + 0.1065108706569845*b[i + 64*ldb] + 0.03078013091636318*b[i + 85*ldb] + 0.4044323368695614*b[i + 86*ldb] + 0.9758930126717729*b[i + 87*ldb] + 0.4044323368695614*b[i + 88*ldb] + 0.03078013091636318*b[i + 89*ldb]);
        c[i + 20*ldc] += (-1.866077916035024*b[i + 5*ldb] + -0.5598111202653964*b[i + 20*ldb] + -0.1520494233293387*b[i + 35*ldb] + -1.125310822402669*b[i + 36*ldb] + -1.172900949469982*b[i + 37*ldb] + 0.01797338358554743*b[i + 38*ldb] + 0.1065108706569845*b[i + 39*ldb] + 0.03078013091636318*b[i + 60*ldb] + 0.4044323368695614*b[i + 61*ldb] + 0.9758930126717729*b[i + 62*ldb] + 0.4044323368695614*b[i + 63*ldb] + 0.03078013091636318*b[i + 64*ldb] + -0.1520494233293387*b[i + 85*ldb] + -1.125310822402669*b[i + 86*ldb] + -1.172900949469982*b[i + 87*ldb] + 0.01797338358554743*b[i + 88*ldb] + 0.1065108706569845*b[i + 89*ldb]);
        c[i + 21*ldc] += (-1.866077916035024*b[i + 6*ldb] + -0.5598111202653964*b[i + 21*ldb] + -0.2111687061258069*b[i + 35*ldb] + 0.6143808272731024*b[i + 36*ldb] + 5.454458520792602*b[i + 37*ldb] + 0.6143808272731024*b[i + 38*ldb] + -0.2111687061258069*b[i + 39*ldb] + 0.5856389335240263*b[i + 60*ldb] + 1.072236397422101*b[i + 61*ldb] + 0.3158549142070798*b[i + 62*ldb] + -0.1092563383478909*b[i + 63*ldb] + -0.05850347735875195*b[i + 64*ldb] + 0.5856389335240263*b[i + 85*ldb] + 1.072236397422101*b[i + 86*ldb] + 0.3158549142070798*b[i + 87*ldb] + -0.1092563383478909*b[i + 88*ldb] + -0.05850347735875195*b[i + 89*ldb]);
        c[i + 22*ldc] += (-1.866077916035024*b[i + 7*ldb] + -0.5598111202653964*b[i + 22*ldb] + 0.5856389335240263*b[i + 35*ldb] + 1.072236397422101*b[i + 36*ldb] + 0.3158549142070798*b[i + 37*ldb] + -0.1092563383478909*b[i + 38*ldb] + -0.05850347735875195*b[i + 39*ldb] + -0.05850347735875195*b[i + 60*ldb] + -0.1092563383478909*b[i + 61*ldb] + 0.3158549142070798*b[i + 62*ldb] + 1.072236397422101*b[i + 63*ldb] + 0.5856389335240263*b[i + 64*ldb] + -0.2111687061258069*b[i + 85*ldb] + 0.6143808272731024*b[i + 86*ldb] + 5.454458520792602*b[i + 87*ldb] + 0.6143808272731024*b[i + 88*ldb] + -0.2111687061258069*b[i + 89*ldb]);
        c[i + 23*ldc] += (-1.866077916035024*b[i + 8*ldb] + -0.5598111202653964*b[i + 23*ldb] + -0.05850347735875195*b[i + 35*ldb] + -0.1092563383478909*b[i + 36*ldb] + 0.3158549142070798*b[i + 37*ldb] + 1.072236397422101*b[i + 38*ldb] + 0.5856389335240263*b[i + 39*ldb] + -0.2111687061258069*b[i + 60*ldb] + 0.6143808272731024*b[i + 61*ldb] + 5.454458520792602*b[i + 62*ldb] + 0.6143808272731024*b[i + 63*ldb] + -0.2111687061258069*b[i + 64*ldb] + -0.05850347735875195*b[i + 85*ldb] + -0.1092563383478909*b[i + 86*ldb] + 0.3158549142070798*b[i + 87*ldb] + 1.072236397422101*b[i + 88*ldb] + 0.5856389335240263*b[i + 89*ldb]);
        c[i + 24*ldc] += (-1.866077916035024*b[i + 9*ldb] + -0.5598111202653964*b[i + 24*ldb] + -0.04441552013474288*b[i + 35*ldb] + 0.09218614391798516*b[i + 36*ldb] + 0.2356403269331877*b[i + 37*ldb] + -1.426271532084567*b[i + 38*ldb] + -1.33618960885414*b[i + 39*ldb] + 0.6982350131118886*b[i + 60*ldb] + 5.935183299806961*b[i + 61*ldb] + 0.4050837191937215*b[i + 62*ldb] + -0.2981430049956752*b[i + 63*ldb] + 0.0740478351152375*b[i + 64*ldb] + 0.03493992481549068*b[i + 85*ldb] + -0.1054765566754525*b[i + 86*ldb] + -0.7540302351461837*b[i + 87*ldb] + -0.9794109587905273*b[i + 88*ldb] + -0.4379349075782941*b[i + 89*ldb]);
        c[i + 25*ldc] += (-1.866077916035024*b[i + 10*ldb] + -0.5598111202653964*b[i + 25*ldb] + -1.33618960885414*b[i + 35*ldb] + -1.426271532084567*b[i + 36*ldb] + 0.2356403269331877*b[i + 37*ldb] + 0.09218614391798516*b[i + 38*ldb] + -0.04441552013474288*b[i + 39*ldb] + 0.03493992481549068*b[i + 60*ldb] + -0.1054765566754525*b[i + 61*ldb] + -0.7540302351461837*b[i + 62*ldb] + -0.9794109587905273*b[i + 63*ldb] + -0.4379349075782941*b[i + 64*ldb] + 0.6982350131118886*b[i + 85*ldb] + 5.935183299806961*b[i + 86*ldb] + 0.4050837191937215*b[i + 87*ldb] + -0.2981430049956752*b[i + 88*ldb] + 0.0740478351152375*b[i + 89*ldb]);
        c[i + 26*ldc] += (-1.866077916035024*b[i + 11*ldb] + -0.5598111202653964*b[i + 26*ldb] + 0.6982350131118886*b[i + 35*ldb] + 5.935183299806961*b[i + 36*ldb] + 0.4050837191937215*b[i + 37*ldb] + -0.2981430049956752*b[i + 38*ldb] + 0.0740478351152375*b[i + 39*ldb] + -0.4379349075782941*b[i + 60*ldb] + -0.9794109587905273*b[i + 61*ldb] + -0.7540302351461837*b[i + 62*ldb] + -0.1054765566754525*b[i + 63*ldb] + 0.03493992481549068*b[i + 64*ldb] + -1.33618960885414*b[i + 85*ldb] + -1.426271532084567*b[i + 86*ldb] + 0.2356403269331877*b[i + 87*ldb] + 0.09218614391798516*b[i + 88*ldb] + -0.04441552013474288*b[i + 89*ldb]);
        c[i + 27*ldc] += (-1.866077916035024*b[i + 12*ldb] + -0.5598111202653964*b[i + 27*ldb] + 0.0740478351152375*b[i + 35*ldb] + -0.2981430049956752*b[i + 36*ldb] + 0.4050837191937215*b[i + 37*ldb] + 5.935183299806961*b[i + 38*ldb] + 0.6982350131118886*b[i + 39*ldb] + -1.33618960885414*b[i + 60*ldb] + -1.426271532084567*b[i + 61*ldb] + 0.2356403269331877*b[i + 62*ldb] + 0.09218614391798516*b[i + 63*ldb] + -0.04441552013474288*b[i + 64*ldb] + -0.4379349075782941*b[i + 85*ldb] + -0.9794109587905273*b[i + 86*ldb] + -0.7540302351461837*b[i + 87*ldb] + -0.1054765566754525*b[i + 88*ldb] + 0.03493992481549068*b[i + 89*ldb]);
        c[i + 28*ldc] += (-1.866077916035024*b[i + 13*ldb] + -0.5598111202653964*b[i + 28*ldb] + -0.4379349075782941*b[i + 35*ldb] + -0.9794109587905273*b[i + 36*ldb] + -0.7540302351461837*b[i + 37*ldb] + -0.1054765566754525*b[i + 38*ldb] + 0.03493992481549068*b[i + 39*ldb] + -0.04441552013474288*b[i + 60*ldb] + 0.09218614391798516*b[i + 61*ldb] + 0.2356403269331877*b[i + 62*ldb] + -1.426271532084567*b[i + 63*ldb] + -1.33618960885414*b[i + 64*ldb] + 0.0740478351152375*b[i + 85*ldb] + -0.2981430049956752*b[i + 86*ldb] + 0.4050837191937215*b[i + 87*ldb] + 5.935183299806961*b[i + 88*ldb] + 0.6982350131118886*b[i + 89*ldb]);
        c[i + 29*ldc] += (-1.866077916035024*b[i + 14*ldb] + -0.5598111202653964*b[i + 29*ldb] + 0.03493992481549068*b[i + 35*ldb] + -0.1054765566754525*b[i + 36*ldb] + -0.7540302351461837*b[i + 37*ldb] + -0.9794109587905273*b[i + 38*ldb] + -0.4379349075782941*b[i + 39*ldb] + 0.0740478351152375*b[i + 60*ldb] + -0.2981430049956752*b[i + 61*ldb] + 0.4050837191937215*b[i + 62*ldb] + 5.935183299806961*b[i + 63*ldb] + 0.6982350131118886*b[i + 64*ldb] + -0.04441552013474288*b[i + 85*ldb] + 0.09218614391798516*b[i + 86*ldb] + 0.2356403269331877*b[i + 87*ldb] + -1.426271532084567*b[i + 88*ldb] + -1.33618960885414*b[i + 89*ldb]);
        c[i + 30*ldc] += (0.9375000000000007*b[i + 0*ldb] + 0.9375000000000007*b[i + 15*ldb] + 0.3766849869423851*b[i + 40*ldb] + 0.9249186854440405*b[i + 41*ldb] + 1.205841535663667*b[i + 42*ldb] + 0.9249186854440405*b[i + 43*ldb] + 0.3766849869423851*b[i + 44*ldb] + -0.0340706876090276*b[i + 65*ldb] + 0.1414709948159385*b[i + 66*ldb] + -0.3732534616347094*b[i + 67*ldb] + 0.5787140289764674*b[i + 68*ldb] + 8.177986284176342*b[i + 69*ldb] + -0.0340706876090276*b[i + 90*ldb] + 0.1414709948159385*b[i + 91*ldb] + -0.3732534616347094*b[i + 92*ldb] + 0.5787140289764674*b[i + 93*ldb] + 8.177986284176342*b[i + 94*ldb]);
        c[i + 31*ldc] += (0.9375000000000007*b[i + 1*ldb] + 0.9375000000000007*b[i + 16*ldb] + -0.0340706876090276*b[i + 40*ldb] + 0.1414709948159385*b[i + 41*ldb] + -0.3732534616347094*b[i + 42*ldb] + 0.5787140289764674*b[i + 43*ldb] + 8.177986284176342*b[i + 44*ldb] + 8.177986284176342*b[i + 65*ldb] + 0.5787140289764674*b[i + 66*ldb] + -0.3732534616347094*b[i + 67*ldb] + 0.1414709948159385*b[i + 68*ldb] + -0.0340706876090276*b[i + 69*ldb] + 0.3766849869423851*b[i + 90*ldb] + 0.9249186854440405*b[i + 91*ldb] + 1.205841535663667*b[i + 92*ldb] + 0.9249186854440405*b[i + 93*ldb] + 0.3766849869423851*b[i + 94*ldb]);
        c[i + 32*ldc] += (0.9375000000000007*b[i + 2*ldb] + 0.9375000000000007*b[i + 17*ldb] + 8.177986284176342*b[i + 40*ldb] + 0.5787140289764674*b[i + 41*ldb] + -0.3732534616347094*b[i + 42*ldb] + 0.1414709948159385*b[i + 43*ldb] + -0.0340706876090276*b[i + 44*ldb] + 0.3766849869423851*b[i + 65*ldb] + 0.9249186854440405*b[i + 66*ldb] + 1.205841535663667*b[i + 67*ldb] + 0.9249186854440405*b[i + 68*ldb] + 0.3766849869423851*b[i + 69*ldb] + 8.177986284176342*b[i + 90*ldb] + 0.5787140289764674*b[i + 91*ldb] + -0.3732534616347094*b[i + 92*ldb] + 0.1414709948159385*b[i + 93*ldb] + -0.0340706876090276*b[i + 94*ldb]);
        c[i + 33*ldc] += (0.9375000000000007*b[i + 3*ldb] + 0.9375000000000007*b[i + 18*ldb] + 0.03078013091636318*b[i + 40*ldb] + 0.4044323368695614*b[i + 41*ldb] + 0.9758930126717729*b[i + 42*ldb] + 0.4044323368695614*b[i + 43*ldb] + 0.03078013091636318*b[i + 44*ldb] + 0.1065108706569845*b[i + 65*ldb] + 0.01797338358554743*b[i + 66*ldb] + -1.172900949469982*b[i + 67*ldb] + -1.125310822402669*b[i + 68*ldb] + -0.1520494233293387*b[i + 69*ldb] + 0.1065108706569845*b[i + 90*ldb] + 0.01797338358554743*b[i + 91*ldb] + -1.172900949469982*b[i + 92*ldb] + -1.125310822402669*b[i + 93*ldb] + -0.1520494233293387*b[i + 94*ldb]);
        c[i + 34*ldc] += (0.9375000000000007*b[i + 4*ldb] + 0.9375000000000007*b[i + 19*ldb] + 0.1065108706569845*b[i + 40*ldb] + 0.01797338358554743*b[i + 41*ldb] + -1.172900949469982*b[i + 42*ldb] + -1.125310822402669*b[i + 43*ldb] + -0.1520494233293387*b[i + 44*ldb] + -0.1520494233293387*b[i + 65*ldb] + -1.125310822402669*b[i + 66*ldb] + -1.172900949469982*b[i + 67*ldb] + 0.01797338358554743*b[i + 68*ldb] + 0.1065108706569845*b[i + 69*ldb] + 0.03078013091636318*b[i + 90*ldb] + 0.4044323368695614*b[i + 91*ldb] + 0.9758930126717729*b[i + 92*ldb] + 0.4044323368695614*b[i + 93*ldb] + 0.03078013091636318*b[i + 94*ldb]);
        c[i + 35*ldc] += (0.9375000000000007*b[i + 5*ldb] + 0.9375000000000007*b[i + 20*ldb] + -0.1520494233293387*b[i + 40*ldb] + -1.125310822402669*b[i + 41*ldb] + -1.172900949469982*b[i + 42*ldb] + 0.01797338358554743*b[i + 43*ldb] + 0.1065108706569845*b[i + 44*ldb] + 0.03078013091636318*b[i + 65*ldb] + 0.4044323368695614*b[i + 66*ldb] + 0.9758930126717729*b[i + 67*ldb] + 0.4044323368695614*b[i + 68*ldb] + 0.03078013091636318*b[i + 69*ldb] + -0.1520494233293387*b[i + 90*ldb] + -1.125310822402669*b[i + 91*ldb] + -1.172900949469982*b[i + 92*ldb] + 0.01797338358554743*b[i + 93*ldb] + 0.1065108706569845*b[i + 94*ldb]);
        c[i + 36*ldc] += (0.9375000000000007*b[i + 6*ldb] + 0.9375000000000007*b[i + 21*ldb] + -0.2111687061258069*b[i + 40*ldb] + 0.6143808272731024*b[i + 41*ldb] + 5.454458520792602*b[i + 42*ldb] + 0.6143808272731024*b[i + 43*ldb] + -0.2111687061258069*b[i + 44*ldb] + 0.5856389335240263*b[i + 65*ldb] + 1.072236397422101*b[i + 66*ldb] + 0.3158549142070798*b[i + 67*ldb] + -0.1092563383478909*b[i + 68*ldb] + -0.05850347735875195*b[i + 69*ldb] + 0.5856389335240263*b[i + 90*ldb] + 1.072236397422101*b[i + 91*ldb] + 0.3158549142070798*b[i + 92*ldb] + -0.1092563383478909*b[i + 93*ldb] + -0.05850347735875195*b[i + 94*ldb]);
        c[i + 37*ldc] += (0.9375000000000007*b[i + 7*ldb] + 0.9375000000000007*b[i + 22*ldb] + 0.5856389335240263*b[i + 40*ldb] + 1.072236397422101*b[i + 41*ldb] + 0.3158549142070798*b[i + 42*ldb] + -0.1092563383478909*b[i + 43*ldb] + -0.05850347735875195*b[i + 44*ldb] + -0.05850347735875195*b[i + 65*ldb] + -0.1092563383478909*b[i + 66*ldb] + 0.3158549142070798*b[i + 67*ldb] + 1.072236397422101*b[i + 68*ldb] + 0.5856389335240263*b[i + 69*ldb] + -0.2111687061258069*b[i + 90*ldb] + 0.6143808272731024*b[i + 91*ldb] + 5.454458520792602*b[i + 92*ldb] + 0.6143808272731024*b[i + 93*ldb] + -0.2111687061258069*b[i + 94*ldb]);
        c[i + 38*ldc] += (0.9375000000000007*b[i + 8*ldb] + 0.9375000000000007*b[i + 23*ldb] + -0.05850347735875195*b[i + 40*ldb] + -0.1092563383478909*b[i + 41*ldb] + 0.3158549142070798*b[i + 42*ldb] + 1.072236397422101*b[i + 43*ldb] + 0.5856389335240263*b[i + 44*ldb] + -0.2111687061258069*b[i + 65*ldb] + 0.6143808272731024*b[i + 66*ldb] + 5.454458520792602*b[i + 67*ldb] + 0.6143808272731024*b[i + 68*ldb] + -0.2111687061258069*b[i + 69*ldb] + -0.05850347735875195*b[i + 90*ldb] + -0.1092563383478909*b[i + 91*ldb] + 0.3158549142070798*b[i + 92*ldb] + 1.072236397422101*b[i + 93*ldb] + 0.5856389335240263*b[i + 94*ldb]);
        c[i + 39*ldc] += (0.9375000000000007*b[i + 9*ldb] + 0.9375000000000007*b[i + 24*ldb] + -0.04441552013474288*b[i + 40*ldb] + 0.09218614391798516*b[i + 41*ldb] + 0.2356403269331877*b[i + 42*ldb] + -1.426271532084567*b[i + 43*ldb] + -1.33618960885414*b[i + 44*ldb] + 0.6982350131118886*b[i + 65*ldb] + 5.935183299806961*b[i + 66*ldb] + 0.4050837191937215*b[i + 67*ldb] + -0.2981430049956752*b[i + 68*ldb] + 0.0740478351152375*b[i + 69*ldb] + 0.03493992481549068*b[i + 90*ldb] + -0.1054765566754525*b[i + 91*ldb] + -0.7540302351461837*b[i + 92*ldb] + -0.9794109587905273*b[i + 93*ldb] + -0.4379349075782941*b[i + 94*ldb]);
        c[i + 40*ldc] += (0.9375000000000007*b[i + 10*ldb] + 0.9375000000000007*b[i + 25*ldb] + -1.33618960885414*b[i + 40*ldb] + -1.426271532084567*b[i + 41*ldb] + 0.2356403269331877*b[i + 42*ldb] + 0.09218614391798516*b[i + 43*ldb] + -0.04441552013474288*b[i + 44*ldb] + 0.03493992481549068*b[i + 65*ldb] + -0.1054765566754525*b[i + 66*ldb] + -0.7540302351461837*b[i + 67*ldb] + -0.9794109587905273*b[i + 68*ldb] + -0.4379349075782941*b[i + 69*ldb] + 0.6982350131118886*b[i + 90*ldb] + 5.935183299806961*b[i + 91*ldb] + 0.4050837191937215*b[i + 92*ldb] + -0.2981430049956752*b[i + 93*ldb] + 0.0740478351152375*b[i + 94*ldb]);
        c[i + 41*ldc] += (0.9375000000000007*b[i + 11*ldb] + 0.9375000000000007*b[i + 26*ldb] + 0.6982350131118886*b[i + 40*ldb] + 5.935183299806961*b[i + 41*ldb] + 0.4050837191937215*b[i + 42*ldb] + -0.2981430049956752*b[i + 43*ldb] + 0.0740478351152375*b[i + 44*ldb] + -0.4379349075782941*b[i + 65*ldb] + -0.9794109587905273*b[i + 66*ldb] + -0.7540302351461837*b[i + 67*ldb] + -0.1054765566754525*b[i + 68*ldb] + 0.03493992481549068*b[i + 69*ldb] + -1.33618960885414*b[i + 90*ldb] + -1.426271532084567*b[i + 91*ldb] + 0.2356403269331877*b[i + 92*ldb] + 0.09218614391798516*b[i + 93*ldb] + -0.04441552013474288*b[i + 94*ldb]);
        c[i + 42*ldc] += (0.9375000000000007*b[i + 12*ldb] + 0.9375000000000007*b[i + 27*ldb] + 0.0740478351152375*b[i + 40*ldb] + -0.2981430049956752*b[i + 41*ldb] + 0.4050837191937215*b[i + 42*ldb] + 5.935183299806961*b[i + 43*ldb] + 0.6982350131118886*b[i + 44*ldb] + -1.33618960885414*b[i + 65*ldb] + -1.426271532084567*b[i + 66*ldb] + 0.2356403269331877*b[i + 67*ldb] + 0.09218614391798516*b[i + 68*ldb] + -0.04441552013474288*b[i + 69*ldb] + -0.4379349075782941*b[i + 90*ldb] + -0.9794109587905273*b[i + 91*ldb] + -0.7540302351461837*b[i + 92*ldb] + -0.1054765566754525*b[i + 93*ldb] + 0.03493992481549068*b[i + 94*ldb]);
        c[i + 43*ldc] += (0.9375000000000007*b[i + 13*ldb] + 0.9375000000000007*b[i + 28*ldb] + -0.4379349075782941*b[i + 40*ldb] + -0.9794109587905273*b[i + 41*ldb] + -0.7540302351461837*b[i + 42*ldb] + -0.1054765566754525*b[i + 43*ldb] + 0.03493992481549068*b[i + 44*ldb] + -0.04441552013474288*b[i + 65*ldb] + 0.09218614391798516*b[i + 66*ldb] + 0.2356403269331877*b[i + 67*ldb] + -1.426271532084567*b[i + 68*ldb] + -1.33618960885414*b[i + 69*ldb] + 0.0740478351152375*b[i + 90*ldb] + -0.2981430049956752*b[i + 91*ldb] + 0.4050837191937215*b[i + 92*ldb] + 5.935183299806961*b[i + 93*ldb] + 0.6982350131118886*b[i + 94*ldb]);
        c[i + 44*ldc] += (0.9375000000000007*b[i + 14*ldb] + 0.9375000000000007*b[i + 29*ldb] + 0.03493992481549068*b[i + 40*ldb] + -0.1054765566754525*b[i + 41*ldb] + -0.7540302351461837*b[i + 42*ldb] + -0.9794109587905273*b[i + 43*ldb] + -0.4379349075782941*b[i + 44*ldb] + 0.0740478351152375*b[i + 65*ldb] + -0.2981430049956752*b[i + 66*ldb] + 0.4050837191937215*b[i + 67*ldb] + 5.935183299806961*b[i + 68*ldb] + 0.6982350131118886*b[i + 69*ldb] + -0.04441552013474288*b[i + 90*ldb] + 0.09218614391798516*b[i + 91*ldb] + 0.2356403269331877*b[i + 92*ldb] + -1.426271532084567*b[i + 93*ldb] + -1.33618960885414*b[i + 94*ldb]);
        c[i + 45*ldc] += (-0.5598111202653964*b[i + 0*ldb] + -1.866077916035024*b[i + 15*ldb] + 0.3766849869423851*b[i + 45*ldb] + 0.9249186854440405*b[i + 46*ldb] + 1.205841535663667*b[i + 47*ldb] + 0.9249186854440405*b[i + 48*ldb] + 0.3766849869423851*b[i + 49*ldb] + -0.0340706876090276*b[i + 70*ldb] + 0.1414709948159385*b[i + 71*ldb] + -0.3732534616347094*b[i + 72*ldb] + 0.5787140289764674*b[i + 73*ldb] + 8.177986284176342*b[i + 74*ldb] + -0.0340706876090276*b[i + 95*ldb] + 0.1414709948159385*b[i + 96*ldb] + -0.3732534616347094*b[i + 97*ldb] + 0.5787140289764674*b[i + 98*ldb] + 8.177986284176342*b[i + 99*ldb]);
        c[i + 46*ldc] += (-0.5598111202653964*b[i + 1*ldb] + -1.866077916035024*b[i + 16*ldb] + -0.0340706876090276*b[i + 45*ldb] + 0.1414709948159385*b[i + 46*ldb] + -0.3732534616347094*b[i + 47*ldb] + 0.5787140289764674*b[i + 48*ldb] + 8.177986284176342*b[i + 49*ldb] + 8.177986284176342*b[i + 70*ldb] + 0.5787140289764674*b[i + 71*ldb] + -0.3732534616347094*b[i + 72*ldb] + 0.1414709948159385*b[i + 73*ldb] + -0.0340706876090276*b[i + 74*ldb] + 0.3766849869423851*b[i + 95*ldb] + 0.9249186854440405*b[i + 96*ldb] + 1.205841535663667*b[i + 97*ldb] + 0.9249186854440405*b[i + 98*ldb] + 0.3766849869423851*b[i + 99*ldb]);
        c[i + 47*ldc] += (-0.5598111202653964*b[i + 2*ldb] + -1.866077916035024*b[i + 17*ldb] + 8.177986284176342*b[i + 45*ldb] + 0.5787140289764674*b[i + 46*ldb] + -0.3732534616347094*b[i + 47*ldb] + 0.1414709948159385*b[i + 48*ldb] + -0.0340706876090276*b[i + 49*ldb] + 0.3766849869423851*b[i + 70*ldb] + 0.9249186854440405*b[i + 71*ldb] + 1.205841535663667*b[i + 72*ldb] + 0.9249186854440405*b[i + 73*ldb] + 0.3766849869423851*b[i + 74*ldb] + 8.177986284176342*b[i + 95*ldb] + 0.5787140289764674*b[i + 96*ldb] + -0.3732534616347094*b[i + 97*ldb] + 0.1414709948159385*b[i + 98*ldb] + -0.0340706876090276*b[i + 99*ldb]);
        c[i + 48*ldc] += (-0.5598111202653964*b[i + 3*ldb] + -1.866077916035024*b[i + 18*ldb] + 0.03078013091636318*b[i + 45*ldb] + 0.4044323368695614*b[i + 46*ldb] + 0.9758930126717729*b[i + 47*ldb] + 0.4044323368695614*b[i + 48*ldb] + 0.03078013091636318*b[i + 49*ldb] + 0.1065108706569845*b[i + 70*ldb] + 0.01797338358554743*b[i + 71*ldb] + -1.172900949469982*b[i + 72*ldb] + -1.125310822402669*b[i + 73*ldb] + -0.1520494233293387*b[i + 74*ldb] + 0.1065108706569845*b[i + 95*ldb] + 0.01797338358554743*b[i + 96*ldb] + -1.172900949469982*b[i + 97*ldb] + -1.125310822402669*b[i + 98*ldb] + -0.1520494233293387*b[i + 99*ldb]);
        c[i + 49*ldc] += (-0.5598111202653964*b[i + 4*ldb] + -1.866077916035024*b[i + 19*ldb] + 0.1065108706569845*b[i + 45*ldb] + 0.01797338358554743*b[i + 46*ldb] + -1.172900949469982*b[i + 47*ldb] + -1.125310822402669*b[i + 48*ldb] + -0.1520494233293387*b[i + 49*ldb] + -0.1520494233293387*b[i + 70*ldb] + -1.125310822402669*b[i + 71*ldb] + -1.172900949469982*b[i + 72*ldb] + 0.01797338358554743*b[i + 73*ldb] + 0.1065108706569845*b[i + 74*ldb] + 0.03078013091636318*b[i + 95*ldb] + 0.4044323368695614*b[i + 96*ldb] + 0.9758930126717729*b[i + 97*ldb] + 0.4044323368695614*b[i + 98*ldb] + 0.03078013091636318*b[i + 99*ldb]);
        c[i + 50*ldc] += (-0.5598111202653964*b[i + 5*ldb] + -1.866077916035024*b[i + 20*ldb] + -0.1520494233293387*b[i + 45*ldb] + -1.125310822402669*b[i + 46*ldb] + -1.172900949469982*b[i + 47*ldb] + 0.01797338358554743*b[i + 48*ldb] + 0.1065108706569845*b[i + 49*ldb] + 0.03078013091636318*b[i + 70*ldb] + 0.4044323368695614*b[i + 71*ldb] + 0.9758930126717729*b[i + 72*ldb] + 0.4044323368695614*b[i + 73*ldb] + 0.03078013091636318*b[i + 74*ldb] + -0.1520494233293387*b[i + 95*ldb] + -1.125310822402669*b[i + 96*ldb] + -1.172900949469982*b[i + 97*ldb] + 0.01797338358554743*b[i + 98*ldb] + 0.1065108706569845*b[i + 99*ldb]);
        c[i + 51*ldc] += (-0.5598111202653964*b[i + 6*ldb] + -1.866077916035024*b[i + 21*ldb] + -0.2111687061258069*b[i + 45*ldb] + 0.6143808272731024*b[i + 46*ldb] + 5.454458520792602*b[i + 47*ldb] + 0.6143808272731024*b[i + 48*ldb] + -0.2111687061258069*b[i + 49*ldb] + 0.5856389335240263*b[i + 70*ldb] + 1.072236397422101*b[i + 71*ldb] + 0.3158549142070798*b[i + 72*ldb] + -0.1092563383478909*b[i + 73*ldb] + -0.05850347735875195*b[i + 74*ldb] + 0.5856389335240263*b[i + 95*ldb] + 1.072236397422101*b[i + 96*ldb] + 0.3158549142070798*b[i + 97*ldb] + -0.1092563383478909*b[i + 98*ldb] + -0.05850347735875195*b[i + 99*ldb]);
        c[i + 52*ldc] += (-0.5598111202653964*b[i + 7*ldb] + -1.866077916035024*b[i + 22*ldb] + 0.5856389335240263*b[i + 45*ldb] + 1.072236397422101*b[i + 46*ldb] + 0.3158549142070798*b[i + 47*ldb] + -0.1092563383478909*b[i + 48*ldb] + -0.05850347735875195*b[i + 49*ldb] + -0.05850347735875195*b[i + 70*ldb] + -0.1092563383478909*b[i + 71*ldb] + 0.3158549142070798*b[i + 72*ldb] + 1.072236397422101*b[i + 73*ldb] + 0.5856389335240263*b[i + 74*ldb] + -0.2111687061258069*b[i + 95*ldb] + 0.6143808272731024*b[i + 96*ldb] + 5.454458520792602*b[i + 97*ldb] + 0.6143808272731024*b[i + 98*ldb] + -0.2111687061258069*b[i + 99*ldb]);
        c[i + 53*ldc] += (-0.5598111202653964*b[i + 8*ldb] + -1.866077916035024*b[i + 23*ldb] + -0.05850347735875195*b[i + 45*ldb] + -0.1092563383478909*b[i + 46*ldb] + 0.3158549142070798*b[i + 47*ldb] + 1.072236397422101*b[i + 48*ldb] + 0.5856389335240263*b[i + 49*ldb] + -0.2111687061258069*b[i + 70*ldb] + 0.6143808272731024*b[i + 71*ldb] + 5.454458520792602*b[i + 72*ldb] + 0.6143808272731024*b[i + 73*ldb] + -0.2111687061258069*b[i + 74*ldb] + -0.05850347735875195*b[i + 95*ldb] + -0.1092563383478909*b[i + 96*ldb] + 0.3158549142070798*b[i + 97*ldb] + 1.072236397422101*b[i + 98*ldb] + 0.5856389335240263*b[i + 99*ldb]);
        c[i + 54*ldc] += (-0.5598111202653964*b[i + 9*ldb] + -1.866077916035024*b[i + 24*ldb] + -0.04441552013474288*b[i + 45*ldb] + 0.09218614391798516*b[i + 46*ldb] + 0.2356403269331877*b[i + 47*ldb] + -1.426271532084567*b[i + 48*ldb] + -1.33618960885414*b[i + 49*ldb] + 0.6982350131118886*b[i + 70*ldb] + 5.935183299806961*b[i + 71*ldb] + 0.4050837191937215*b[i + 72*ldb] + -0.2981430049956752*b[i + 73*ldb] + 0.0740478351152375*b[i + 74*ldb] + 0.03493992481549068*b[i + 95*ldb] + -0.1054765566754525*b[i + 96*ldb] + -0.7540302351461837*b[i + 97*ldb] + -0.9794109587905273*b[i + 98*ldb] + -0.4379349075782941*b[i + 99*ldb]);
        c[i + 55*ldc] += (-0.5598111202653964*b[i + 10*ldb] + -1.866077916035024*b[i + 25*ldb] + -1.33618960885414*b[i + 45*ldb] + -1.426271532084567*b[i + 46*ldb] + 0.2356403269331877*b[i + 47*ldb] + 0.09218614391798516*b[i + 48*ldb] + -0.04441552013474288*b[i + 49*ldb] + 0.03493992481549068*b[i + 70*ldb] + -0.1054765566754525*b[i + 71*ldb] + -0.7540302351461837*b[i + 72*ldb] + -0.9794109587905273*b[i + 73*ldb] + -0.4379349075782941*b[i + 74*ldb] + 0.6982350131118886*b[i + 95*ldb] + 5.935183299806961*b[i + 96*ldb] + 0.4050837191937215*b[i + 97*ldb] + -0.2981430049956752*b[i + 98*ldb] + 0.0740478351152375*b[i + 99*ldb]);
        c[i + 56*ldc] += (-0.5598111202653964*b[i + 11*ldb] + -1.866077916035024*b[i + 26*ldb] + 0.6982350131118886*b[i + 45*ldb] + 5.935183299806961*b[i + 46*ldb] + 0.4050837191937215*b[i + 47*ldb] + -0.2981430049956752*b[i + 48*ldb] + 0.0740478351152375*b[i + 49*ldb] + -0.4379349075782941*b[i + 70*ldb] + -0.9794109587905273*b[i + 71*ldb] + -0.7540302351461837*b[i + 72*ldb] + -0.1054765566754525*b[i + 73*ldb] + 0.03493992481549068*b[i + 74*ldb] + -1.33618960885414*b[i + 95*ldb] + -1.426271532084567*b[i + 96*ldb] + 0.2356403269331877*b[i + 97*ldb] + 0.09218614391798516*b[i + 98*ldb] + -0.04441552013474288*b[i + 99*ldb]);
        c[i + 57*ldc] += (-0.5598111202653964*b[i + 12*ldb] + -1.866077916035024*b[i + 27*ldb] + 0.0740478351152375*b[i + 45*ldb] + -0.2981430049956752*b[i + 46*ldb] + 0.4050837191937215*b[i + 47*ldb] + 5.935183299806961*b[i + 48*ldb] + 0.6982350131118886*b[i + 49*ldb] + -1.33618960885414*b[i + 70*ldb] + -1.426271532084567*b[i + 71*ldb] + 0.2356403269331877*b[i + 72*ldb] + 0.09218614391798516*b[i + 73*ldb] + -0.04441552013474288*b[i + 74*ldb] + -0.4379349075782941*b[i + 95*ldb] + -0.9794109587905273*b[i + 96*ldb] + -0.7540302351461837*b[i + 97*ldb] + -0.1054765566754525*b[i + 98*ldb] + 0.03493992481549068*b[i + 99*ldb]);
        c[i + 58*ldc] += (-0.5598111202653964*b[i + 13*ldb] + -1.866077916035024*b[i + 28*ldb] + -0.4379349075782941*b[i + 45*ldb] + -0.9794109587905273*b[i + 46*ldb] + -0.7540302351461837*b[i + 47*ldb] + -0.1054765566754525*b[i + 48*ldb] + 0.03493992481549068*b[i + 49*ldb] + -0.04441552013474288*b[i + 70*ldb] + 0.09218614391798516*b[i + 71*ldb] + 0.2356403269331877*b[i + 72*ldb] + -1.426271532084567*b[i + 73*ldb] + -1.33618960885414*b[i + 74*ldb] + 0.0740478351152375*b[i + 95*ldb] + -0.2981430049956752*b[i + 96*ldb] + 0.4050837191937215*b[i + 97*ldb] + 5.935183299806961*b[i + 98*ldb] + 0.6982350131118886*b[i + 99*ldb]);
        c[i + 59*ldc] += (-0.5598111202653964*b[i + 14*ldb] + -1.866077916035024*b[i + 29*ldb] + 0.03493992481549068*b[i + 45*ldb] + -0.1054765566754525*b[i + 46*ldb] + -0.7540302351461837*b[i + 47*ldb] + -0.9794109587905273*b[i + 48*ldb] + -0.4379349075782941*b[i + 49*ldb] + 0.0740478351152375*b[i + 70*ldb] + -0.2981430049956752*b[i + 71*ldb] + 0.4050837191937215*b[i + 72*ldb] + 5.935183299806961*b[i + 73*ldb] + 0.6982350131118886*b[i + 74*ldb] + -0.04441552013474288*b[i + 95*ldb] + 0.09218614391798516*b[i + 96*ldb] + 0.2356403269331877*b[i + 97*ldb] + -1.426271532084567*b[i + 98*ldb] + -1.33618960885414*b[i + 99*ldb]);
        c[i + 60*ldc] += (0.3222878728081189*b[i + 0*ldb] + 6.548045607936747*b[i + 15*ldb] + 0.3766849869423851*b[i + 50*ldb] + 0.9249186854440405*b[i + 51*ldb] + 1.205841535663667*b[i + 52*ldb] + 0.9249186854440405*b[i + 53*ldb] + 0.3766849869423851*b[i + 54*ldb] + -0.0340706876090276*b[i + 75*ldb] + 0.1414709948159385*b[i + 76*ldb] + -0.3732534616347094*b[i + 77*ldb] + 0.5787140289764674*b[i + 78*ldb] + 8.177986284176342*b[i + 79*ldb] + -0.0340706876090276*b[i + 100*ldb] + 0.1414709948159385*b[i + 101*ldb] + -0.3732534616347094*b[i + 102*ldb] + 0.5787140289764674*b[i + 103*ldb] + 8.177986284176342*b[i + 104*ldb]);
        c[i + 61*ldc] += (0.3222878728081189*b[i + 1*ldb] + 6.548045607936747*b[i + 16*ldb] + -0.0340706876090276*b[i + 50*ldb] + 0.1414709948159385*b[i + 51*ldb] + -0.3732534616347094*b[i + 52*ldb] + 0.5787140289764674*b[i + 53*ldb] + 8.177986284176342*b[i + 54*ldb] + 8.177986284176342*b[i + 75*ldb] + 0.5787140289764674*b[i + 76*ldb] + -0.3732534616347094*b[i + 77*ldb] + 0.1414709948159385*b[i + 78*ldb] + -0.0340706876090276*b[i + 79*ldb] + 0.3766849869423851*b[i + 100*ldb] + 0.9249186854440405*b[i + 101*ldb] + 1.205841535663667*b[i + 102*ldb] + 0.9249186854440405*b[i + 103*ldb] + 0.3766849869423851*b[i + 104*ldb]);
        c[i + 62*ldc] += (0.3222878728081189*b[i + 2*ldb] + 6.548045607936747*b[i + 17*ldb] + 8.177986284176342*b[i + 50*ldb] + 0.5787140289764674*b[i + 51*ldb] + -0.3732534616347094*b[i + 52*ldb] + 0.1414709948159385*b[i + 53*ldb] + -0.0340706876090276*b[i + 54*ldb] + 0.3766849869423851*b[i + 75*ldb] + 0.9249186854440405*b[i + 76*ldb] + 1.205841535663667*b[i + 77*ldb] + 0.9249186854440405*b[i + 78*ldb] + 0.3766849869423851*b[i + 79*ldb] + 8.177986284176342*b[i + 100*ldb] + 0.5787140289764674*b[i + 101*ldb] + -0.3732534616347094*b[i + 102*ldb] + 0.1414709948159385*b[i + 103*ldb] + -0.0340706876090276*b[i + 104*ldb]);
        c[i + 63*ldc] += (0.3222878728081189*b[i + 3*ldb] + 6.548045607936747*b[i + 18*ldb] + 0.03078013091636318*b[i + 50*ldb] + 0.4044323368695614*b[i + 51*ldb] + 0.9758930126717729*b[i + 52*ldb] + 0.4044323368695614*b[i + 53*ldb] + 0.03078013091636318*b[i + 54*ldb] + 0.1065108706569845*b[i + 75*ldb] + 0.01797338358554743*b[i + 76*ldb] + -1.172900949469982*b[i + 77*ldb] + -1.125310822402669*b[i + 78*ldb] + -0.1520494233293387*b[i + 79*ldb] + 0.1065108706569845*b[i + 100*ldb] + 0.01797338358554743*b[i + 101*ldb] + -1.172900949469982*b[i + 102*ldb] + -1.125310822402669*b[i + 103*ldb] + -0.1520494233293387*b[i + 104*ldb]);
        c[i + 64*ldc] += (0.3222878728081189*b[i + 4*ldb] + 6.548045607936747*b[i + 19*ldb] + 0.1065108706569845*b[i + 50*ldb] + 0.01797338358554743*b[i + 51*ldb] + -1.172900949469982*b[i + 52*ldb] + -1.125310822402669*b[i + 53*ldb] + -0.1520494233293387*b[i + 54*ldb] + -0.1520494233293387*b[i + 75*ldb] + -1.125310822402669*b[i + 76*ldb] + -1.172900949469982*b[i + 77*ldb] + 0.01797338358554743*b[i + 78*ldb] + 0.1065108706569845*b[i + 79*ldb] + 0.03078013091636318*b[i + 100*ldb] + 0.4044323368695614*b[i + 101*ldb] + 0.9758930126717729*b[i + 102*ldb] + 0.4044323368695614*b[i + 103*ldb] + 0.03078013091636318*b[i + 104*ldb]);
        c[i + 65*ldc] += (0.3222878728081189*b[i + 5*ldb] + 6.548045607936747*b[i + 20*ldb] + -0.1520494233293387*b[i + 50*ldb] + -1.125310822402669*b[i + 51*ldb] + -1.172900949469982*b[i + 52*ldb] + 0.01797338358554743*b[i + 53*ldb] + 0.1065108706569845*b[i + 54*ldb] + 0.03078013091636318*b[i + 75*ldb] + 0.4044323368695614*b[i + 76*ldb] + 0.9758930126717729*b[i + 77*ldb] + 0.4044323368695614*b[i + 78*ldb] + 0.03078013091636318*b[i + 79*ldb] + -0.1520494233293387*b[i + 100*ldb] + -1.125310822402669*b[i + 101*ldb] + -1.172900949469982*b[i + 102*ldb] + 0.01797338358554743*b[i + 103*ldb] + 0.1065108706569845*b[i + 104*ldb]);
        c[i + 66*ldc] += (0.3222878728081189*b[i + 6*ldb] + 6.548045607936747*b[i + 21*ldb] + -0.2111687061258069*b[i + 50*ldb] + 0.6143808272731024*b[i + 51*ldb] + 5.454458520792602*b[i + 52*ldb] + 0.6143808272731024*b[i + 53*ldb] + -0.2111687061258069*b[i + 54*ldb] + 0.5856389335240263*b[i + 75*ldb] + 1.072236397422101*b[i + 76*ldb] + 0.3158549142070798*b[i + 77*ldb] + -0.1092563383478909*b[i + 78*ldb] + -0.05850347735875195*b[i + 79*ldb] + 0.5856389335240263*b[i + 100*ldb] + 1.072236397422101*b[i + 101*ldb] + 0.3158549142070798*b[i + 102*ldb] + -0.1092563383478909*b[i + 103*ldb] + -0.05850347735875195*b[i + 104*ldb]);
        c[i + 67*ldc] += (0.3222878728081189*b[i + 7*ldb] + 6.548045607936747*b[i + 22*ldb] + 0.5856389335240263*b[i + 50*ldb] + 1.072236397422101*b[i + 51*ldb] + 0.3158549142070798*b[i + 52*ldb] + -0.1092563383478909*b[i + 53*ldb] + -0.05850347735875195*b[i + 54*ldb] + -0.05850347735875195*b[i + 75*ldb] + -0.1092563383478909*b[i + 76*ldb] + 0.3158549142070798*b[i + 77*ldb] + 1.072236397422101*b[i + 78*ldb] + 0.5856389335240263*b[i + 79*ldb] + -0.2111687061258069*b[i + 100*ldb] + 0.6143808272731024*b[i + 101*ldb] + 5.454458520792602*b[i + 102*ldb] + 0.6143808272731024*b[i + 103*ldb] + -0.2111687061258069*b[i + 104*ldb]);
        c[i + 68*ldc] += (0.3222878728081189*b[i + 8*ldb] + 6.548045607936747*b[i + 23*ldb] + -0.05850347735875195*b[i + 50*ldb] + -0.1092563383478909*b[i + 51*ldb] + 0.3158549142070798*b[i + 52*ldb] + 1.072236397422101*b[i + 53*ldb] + 0.5856389335240263*b[i + 54*ldb] + -0.2111687061258069*b[i + 75*ldb] + 0.6143808272731024*b[i + 76*ldb] + 5.454458520792602*b[i + 77*ldb] + 0.6143808272731024*b[i + 78*ldb] + -0.2111687061258069*b[i + 79*ldb] + -0.05850347735875195*b[i + 100*ldb] + -0.1092563383478909*b[i + 101*ldb] + 0.3158549142070798*b[i + 102*ldb] + 1.072236397422101*b[i + 103*ldb] + 0.5856389335240263*b[i + 104*ldb]);
        c[i + 69*ldc] += (0.3222878728081189*b[i + 9*ldb] + 6.548045607936747*b[i + 24*ldb] + -0.04441552013474288*b[i + 50*ldb] + 0.09218614391798516*b[i + 51*ldb] + 0.2356403269331877*b[i + 52*ldb] + -1.426271532084567*b[i + 53*ldb] + -1.33618960885414*b[i + 54*ldb] + 0.6982350131118886*b[i + 75*ldb] + 5.935183299806961*b[i + 76*ldb] + 0.4050837191937215*b[i + 77*ldb] + -0.2981430049956752*b[i + 78*ldb] + 0.0740478351152375*b[i + 79*ldb] + 0.03493992481549068*b[i + 100*ldb] + -0.1054765566754525*b[i + 101*ldb] + -0.7540302351461837*b[i + 102*ldb] + -0.9794109587905273*b[i + 103*ldb] + -0.4379349075782941*b[i + 104*ldb]);
        c[i + 70*ldc] += (0.3222878728081189*b[i + 10*ldb] + 6.548045607936747*b[i + 25*ldb] + -1.33618960885414*b[i + 50*ldb] + -1.426271532084567*b[i + 51*ldb] + 0.2356403269331877*b[i + 52*ldb] + 0.09218614391798516*b[i + 53*ldb] + -0.04441552013474288*b[i + 54*ldb] + 0.03493992481549068*b[i + 75*ldb] + -0.1054765566754525*b[i + 76*ldb] + -0.7540302351461837*b[i + 77*ldb] + -0.9794109587905273*b[i + 78*ldb] + -0.4379349075782941*b[i + 79*ldb] + 0.6982350131118886*b[i + 100*ldb] + 5.935183299806961*b[i + 101*ldb] + 0.4050837191937215*b[i + 102*ldb] + -0.2981430049956752*b[i + 103*ldb] + 0.0740478351152375*b[i + 104*ldb]);
        c[i + 71*ldc] += (0.3222878728081189*b[i + 11*ldb] + 6.548045607936747*b[i + 26*ldb] + 0.6982350131118886*b[i + 50*ldb] + 5.935183299806961*b[i + 51*ldb] + 0.4050837191937215*b[i + 52*ldb] + -0.2981430049956752*b[i + 53*ldb] + 0.0740478351152375*b[i + 54*ldb] + -0.4379349075782941*b[i + 75*ldb] + -0.9794109587905273*b[i + 76*ldb] + -0.7540302351461837*b[i + 77*ldb] + -0.1054765566754525*b[i + 78*ldb] + 0.03493992481549068*b[i + 79*ldb] + -1.33618960885414*b[i + 100*ldb] + -1.426271532084567*b[i + 101*ldb] + 0.2356403269331877*b[i + 102*ldb] + 0.09218614391798516*b[i + 103*ldb] + -0.04441552013474288*b[i + 104*ldb]);
        c[i + 72*ldc] += (0.3222878728081189*b[i + 12*ldb] + 6.548045607936747*b[i + 27*ldb] + 0.0740478351152375*b[i + 50*ldb] + -0.2981430049956752*b[i + 51*ldb] + 0.4050837191937215*b[i + 52*ldb] + 5.935183299806961*b[i + 53*ldb] + 0.6982350131118886*b[i + 54*ldb] + -1.33618960885414*b[i + 75*ldb] + -1.426271532084567*b[i + 76*ldb] + 0.2356403269331877*b[i + 77*ldb] + 0.09218614391798516*b[i + 78*ldb] + -0.04441552013474288*b[i + 79*ldb] + -0.4379349075782941*b[i + 100*ldb] + -0.9794109587905273*b[i + 101*ldb] + -0.7540302351461837*b[i + 102*ldb] + -0.1054765566754525*b[i + 103*ldb] + 0.03493992481549068*b[i + 104*ldb]);
        c[i + 73*ldc] += (0.3222878728081189*b[i + 13*ldb] + 6.548045607936747*b[i + 28*ldb] + -0.4379349075782941*b[i + 50*ldb] + -0.9794109587905273*b[i + 51*ldb] + -0.7540302351461837*b[i + 52*ldb] + -0.1054765566754525*b[i + 53*ldb] + 0.03493992481549068*b[i + 54*ldb] + -0.04441552013474288*b[i + 75*ldb] + 0.09218614391798516*b[i + 76*ldb] + 0.2356403269331877*b[i + 77*ldb] + -1.426271532084567*b[i + 78*ldb] + -1.33618960885414*b[i + 79*ldb] + 0.0740478351152375*b[i + 100*ldb] + -0.2981430049956752*b[i + 101*ldb] + 0.4050837191937215*b[i + 102*ldb] + 5.935183299806961*b[i + 103*ldb] + 0.6982350131118886*b[i + 104*ldb]);
        c[i + 74*ldc] += (0.3222878728081189*b[i + 14*ldb] + 6.548045607936747*b[i + 29*ldb] + 0.03493992481549068*b[i + 50*ldb] + -0.1054765566754525*b[i + 51*ldb] + -0.7540302351461837*b[i + 52*ldb] + -0.9794109587905273*b[i + 53*ldb] + -0.4379349075782941*b[i + 54*ldb] + 0.0740478351152375*b[i + 75*ldb] + -0.2981430049956752*b[i + 76*ldb] + 0.4050837191937215*b[i + 77*ldb] + 5.935183299806961*b[i + 78*ldb] + 0.6982350131118886*b[i + 79*ldb] + -0.04441552013474288*b[i + 100*ldb] + 0.09218614391798516*b[i + 101*ldb] + 0.2356403269331877*b[i + 102*ldb] + -1.426271532084567*b[i + 103*ldb] + -1.33618960885414*b[i + 104*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_pri_m6(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (-0.03407068760902764*b[i + 55*ldb] + 0.1414709948159384*b[i + 56*ldb] + -0.3732534616347092*b[i + 57*ldb] + 0.5787140289764666*b[i + 58*ldb] + 8.177986284176342*b[i + 59*ldb] + 0.03407068760902764*b[i + 80*ldb] + -0.1414709948159384*b[i + 81*ldb] + 0.3732534616347092*b[i + 82*ldb] + -0.5787140289764666*b[i + 83*ldb] + -8.177986284176342*b[i + 84*ldb]);
        c[i + 1*ldc] += (8.177986284176342*b[i + 55*ldb] + 0.5787140289764666*b[i + 56*ldb] + -0.3732534616347092*b[i + 57*ldb] + 0.1414709948159384*b[i + 58*ldb] + -0.03407068760902764*b[i + 59*ldb] + -0.3766849869423851*b[i + 80*ldb] + -0.9249186854440405*b[i + 81*ldb] + -1.205841535663668*b[i + 82*ldb] + -0.9249186854440405*b[i + 83*ldb] + -0.3766849869423851*b[i + 84*ldb]);
        c[i + 2*ldc] += (0.3766849869423851*b[i + 55*ldb] + 0.9249186854440405*b[i + 56*ldb] + 1.205841535663668*b[i + 57*ldb] + 0.9249186854440405*b[i + 58*ldb] + 0.3766849869423851*b[i + 59*ldb] + -8.177986284176342*b[i + 80*ldb] + -0.5787140289764666*b[i + 81*ldb] + 0.3732534616347092*b[i + 82*ldb] + -0.1414709948159384*b[i + 83*ldb] + 0.03407068760902764*b[i + 84*ldb]);
        c[i + 3*ldc] += (0.1065108706569845*b[i + 55*ldb] + 0.01797338358554743*b[i + 56*ldb] + -1.172900949469982*b[i + 57*ldb] + -1.125310822402669*b[i + 58*ldb] + -0.1520494233293387*b[i + 59*ldb] + -0.1065108706569845*b[i + 80*ldb] + -0.01797338358554743*b[i + 81*ldb] + 1.172900949469982*b[i + 82*ldb] + 1.125310822402669*b[i + 83*ldb] + 0.1520494233293387*b[i + 84*ldb]);
        c[i + 4*ldc] += (-0.1520494233293387*b[i + 55*ldb] + -1.125310822402669*b[i + 56*ldb] + -1.172900949469982*b[i + 57*ldb] + 0.01797338358554743*b[i + 58*ldb] + 0.1065108706569845*b[i + 59*ldb] + -0.03078013091636318*b[i + 80*ldb] + -0.4044323368695613*b[i + 81*ldb] + -0.9758930126717729*b[i + 82*ldb] + -0.4044323368695613*b[i + 83*ldb] + -0.03078013091636318*b[i + 84*ldb]);
        c[i + 5*ldc] += (0.03078013091636318*b[i + 55*ldb] + 0.4044323368695613*b[i + 56*ldb] + 0.9758930126717729*b[i + 57*ldb] + 0.4044323368695613*b[i + 58*ldb] + 0.03078013091636318*b[i + 59*ldb] + 0.1520494233293387*b[i + 80*ldb] + 1.125310822402669*b[i + 81*ldb] + 1.172900949469982*b[i + 82*ldb] + -0.01797338358554743*b[i + 83*ldb] + -0.1065108706569845*b[i + 84*ldb]);
        c[i + 6*ldc] += (0.5856389335240263*b[i + 55*ldb] + 1.072236397422101*b[i + 56*ldb] + 0.3158549142070798*b[i + 57*ldb] + -0.1092563383478909*b[i + 58*ldb] + -0.05850347735875196*b[i + 59*ldb] + -0.5856389335240263*b[i + 80*ldb] + -1.072236397422101*b[i + 81*ldb] + -0.3158549142070798*b[i + 82*ldb] + 0.1092563383478909*b[i + 83*ldb] + 0.05850347735875196*b[i + 84*ldb]);
        c[i + 7*ldc] += (-0.05850347735875196*b[i + 55*ldb] + -0.1092563383478909*b[i + 56*ldb] + 0.3158549142070798*b[i + 57*ldb] + 1.072236397422101*b[i + 58*ldb] + 0.5856389335240263*b[i + 59*ldb] + 0.2111687061258069*b[i + 80*ldb] + -0.6143808272731023*b[i + 81*ldb] + -5.454458520792602*b[i + 82*ldb] + -0.6143808272731023*b[i + 83*ldb] + 0.2111687061258069*b[i + 84*ldb]);
        c[i + 8*ldc] += (-0.2111687061258069*b[i + 55*ldb] + 0.6143808272731023*b[i + 56*ldb] + 5.454458520792602*b[i + 57*ldb] + 0.6143808272731023*b[i + 58*ldb] + -0.2111687061258069*b[i + 59*ldb] + 0.05850347735875196*b[i + 80*ldb] + 0.1092563383478909*b[i + 81*ldb] + -0.3158549142070798*b[i + 82*ldb] + -1.072236397422101*b[i + 83*ldb] + -0.5856389335240263*b[i + 84*ldb]);
        c[i + 9*ldc] += (0.6982350131118888*b[i + 55*ldb] + 5.935183299806961*b[i + 56*ldb] + 0.4050837191937215*b[i + 57*ldb] + -0.2981430049956753*b[i + 58*ldb] + 0.0740478351152375*b[i + 59*ldb] + -0.03493992481549068*b[i + 80*ldb] + 0.1054765566754525*b[i + 81*ldb] + 0.7540302351461837*b[i + 82*ldb] + 0.9794109587905273*b[i + 83*ldb] + 0.4379349075782941*b[i + 84*ldb]);
        c[i + 10*ldc] += (0.03493992481549068*b[i + 55*ldb] + -0.1054765566754525*b[i + 56*ldb] + -0.7540302351461837*b[i + 57*ldb] + -0.9794109587905273*b[i + 58*ldb] + -0.4379349075782941*b[i + 59*ldb] + -0.6982350131118888*b[i + 80*ldb] + -5.935183299806961*b[i + 81*ldb] + -0.4050837191937215*b[i + 82*ldb] + 0.2981430049956753*b[i + 83*ldb] + -0.0740478351152375*b[i + 84*ldb]);
        c[i + 11*ldc] += (-0.4379349075782941*b[i + 55*ldb] + -0.9794109587905273*b[i + 56*ldb] + -0.7540302351461837*b[i + 57*ldb] + -0.1054765566754525*b[i + 58*ldb] + 0.03493992481549068*b[i + 59*ldb] + 1.33618960885414*b[i + 80*ldb] + 1.426271532084567*b[i + 81*ldb] + -0.2356403269331877*b[i + 82*ldb] + -0.09218614391798526*b[i + 83*ldb] + 0.04441552013474293*b[i + 84*ldb]);
        c[i + 12*ldc] += (-1.33618960885414*b[i + 55*ldb] + -1.426271532084567*b[i + 56*ldb] + 0.2356403269331877*b[i + 57*ldb] + 0.09218614391798526*b[i + 58*ldb] + -0.04441552013474293*b[i + 59*ldb] + 0.4379349075782941*b[i + 80*ldb] + 0.9794109587905273*b[i + 81*ldb] + 0.7540302351461837*b[i + 82*ldb] + 0.1054765566754525*b[i + 83*ldb] + -0.03493992481549068*b[i + 84*ldb]);
        c[i + 13*ldc] += (-0.04441552013474293*b[i + 55*ldb] + 0.09218614391798526*b[i + 56*ldb] + 0.2356403269331877*b[i + 57*ldb] + -1.426271532084567*b[i + 58*ldb] + -1.33618960885414*b[i + 59*ldb] + -0.0740478351152375*b[i + 80*ldb] + 0.2981430049956753*b[i + 81*ldb] + -0.4050837191937215*b[i + 82*ldb] + -5.935183299806961*b[i + 83*ldb] + -0.6982350131118888*b[i + 84*ldb]);
        c[i + 14*ldc] += (0.0740478351152375*b[i + 55*ldb] + -0.2981430049956753*b[i + 56*ldb] + 0.4050837191937215*b[i + 57*ldb] + 5.935183299806961*b[i + 58*ldb] + 0.6982350131118888*b[i + 59*ldb] + 0.04441552013474293*b[i + 80*ldb] + -0.09218614391798526*b[i + 81*ldb] + -0.2356403269331877*b[i + 82*ldb] + 1.426271532084567*b[i + 83*ldb] + 1.33618960885414*b[i + 84*ldb]);
        c[i + 15*ldc] += (-0.03407068760902764*b[i + 60*ldb] + 0.1414709948159384*b[i + 61*ldb] + -0.3732534616347092*b[i + 62*ldb] + 0.5787140289764666*b[i + 63*ldb] + 8.177986284176342*b[i + 64*ldb] + 0.03407068760902764*b[i + 85*ldb] + -0.1414709948159384*b[i + 86*ldb] + 0.3732534616347092*b[i + 87*ldb] + -0.5787140289764666*b[i + 88*ldb] + -8.177986284176342*b[i + 89*ldb]);
        c[i + 16*ldc] += (8.177986284176342*b[i + 60*ldb] + 0.5787140289764666*b[i + 61*ldb] + -0.3732534616347092*b[i + 62*ldb] + 0.1414709948159384*b[i + 63*ldb] + -0.03407068760902764*b[i + 64*ldb] + -0.3766849869423851*b[i + 85*ldb] + -0.9249186854440405*b[i + 86*ldb] + -1.205841535663668*b[i + 87*ldb] + -0.9249186854440405*b[i + 88*ldb] + -0.3766849869423851*b[i + 89*ldb]);
        c[i + 17*ldc] += (0.3766849869423851*b[i + 60*ldb] + 0.9249186854440405*b[i + 61*ldb] + 1.205841535663668*b[i + 62*ldb] + 0.9249186854440405*b[i + 63*ldb] + 0.3766849869423851*b[i + 64*ldb] + -8.177986284176342*b[i + 85*ldb] + -0.5787140289764666*b[i + 86*ldb] + 0.3732534616347092*b[i + 87*ldb] + -0.1414709948159384*b[i + 88*ldb] + 0.03407068760902764*b[i + 89*ldb]);
        c[i + 18*ldc] += (0.1065108706569845*b[i + 60*ldb] + 0.01797338358554743*b[i + 61*ldb] + -1.172900949469982*b[i + 62*ldb] + -1.125310822402669*b[i + 63*ldb] + -0.1520494233293387*b[i + 64*ldb] + -0.1065108706569845*b[i + 85*ldb] + -0.01797338358554743*b[i + 86*ldb] + 1.172900949469982*b[i + 87*ldb] + 1.125310822402669*b[i + 88*ldb] + 0.1520494233293387*b[i + 89*ldb]);
        c[i + 19*ldc] += (-0.1520494233293387*b[i + 60*ldb] + -1.125310822402669*b[i + 61*ldb] + -1.172900949469982*b[i + 62*ldb] + 0.01797338358554743*b[i + 63*ldb] + 0.1065108706569845*b[i + 64*ldb] + -0.03078013091636318*b[i + 85*ldb] + -0.4044323368695613*b[i + 86*ldb] + -0.9758930126717729*b[i + 87*ldb] + -0.4044323368695613*b[i + 88*ldb] + -0.03078013091636318*b[i + 89*ldb]);
        c[i + 20*ldc] += (0.03078013091636318*b[i + 60*ldb] + 0.4044323368695613*b[i + 61*ldb] + 0.9758930126717729*b[i + 62*ldb] + 0.4044323368695613*b[i + 63*ldb] + 0.03078013091636318*b[i + 64*ldb] + 0.1520494233293387*b[i + 85*ldb] + 1.125310822402669*b[i + 86*ldb] + 1.172900949469982*b[i + 87*ldb] + -0.01797338358554743*b[i + 88*ldb] + -0.1065108706569845*b[i + 89*ldb]);
        c[i + 21*ldc] += (0.5856389335240263*b[i + 60*ldb] + 1.072236397422101*b[i + 61*ldb] + 0.3158549142070798*b[i + 62*ldb] + -0.1092563383478909*b[i + 63*ldb] + -0.05850347735875196*b[i + 64*ldb] + -0.5856389335240263*b[i + 85*ldb] + -1.072236397422101*b[i + 86*ldb] + -0.3158549142070798*b[i + 87*ldb] + 0.1092563383478909*b[i + 88*ldb] + 0.05850347735875196*b[i + 89*ldb]);
        c[i + 22*ldc] += (-0.05850347735875196*b[i + 60*ldb] + -0.1092563383478909*b[i + 61*ldb] + 0.3158549142070798*b[i + 62*ldb] + 1.072236397422101*b[i + 63*ldb] + 0.5856389335240263*b[i + 64*ldb] + 0.2111687061258069*b[i + 85*ldb] + -0.6143808272731023*b[i + 86*ldb] + -5.454458520792602*b[i + 87*ldb] + -0.6143808272731023*b[i + 88*ldb] + 0.2111687061258069*b[i + 89*ldb]);
        c[i + 23*ldc] += (-0.2111687061258069*b[i + 60*ldb] + 0.6143808272731023*b[i + 61*ldb] + 5.454458520792602*b[i + 62*ldb] + 0.6143808272731023*b[i + 63*ldb] + -0.2111687061258069*b[i + 64*ldb] + 0.05850347735875196*b[i + 85*ldb] + 0.1092563383478909*b[i + 86*ldb] + -0.3158549142070798*b[i + 87*ldb] + -1.072236397422101*b[i + 88*ldb] + -0.5856389335240263*b[i + 89*ldb]);
        c[i + 24*ldc] += (0.6982350131118888*b[i + 60*ldb] + 5.935183299806961*b[i + 61*ldb] + 0.4050837191937215*b[i + 62*ldb] + -0.2981430049956753*b[i + 63*ldb] + 0.0740478351152375*b[i + 64*ldb] + -0.03493992481549068*b[i + 85*ldb] + 0.1054765566754525*b[i + 86*ldb] + 0.7540302351461837*b[i + 87*ldb] + 0.9794109587905273*b[i + 88*ldb] + 0.4379349075782941*b[i + 89*ldb]);
        c[i + 25*ldc] += (0.03493992481549068*b[i + 60*ldb] + -0.1054765566754525*b[i + 61*ldb] + -0.7540302351461837*b[i + 62*ldb] + -0.9794109587905273*b[i + 63*ldb] + -0.4379349075782941*b[i + 64*ldb] + -0.6982350131118888*b[i + 85*ldb] + -5.935183299806961*b[i + 86*ldb] + -0.4050837191937215*b[i + 87*ldb] + 0.2981430049956753*b[i + 88*ldb] + -0.0740478351152375*b[i + 89*ldb]);
        c[i + 26*ldc] += (-0.4379349075782941*b[i + 60*ldb] + -0.9794109587905273*b[i + 61*ldb] + -0.7540302351461837*b[i + 62*ldb] + -0.1054765566754525*b[i + 63*ldb] + 0.03493992481549068*b[i + 64*ldb] + 1.33618960885414*b[i + 85*ldb] + 1.426271532084567*b[i + 86*ldb] + -0.2356403269331877*b[i + 87*ldb] + -0.09218614391798526*b[i + 88*ldb] + 0.04441552013474293*b[i + 89*ldb]);
        c[i + 27*ldc] += (-1.33618960885414*b[i + 60*ldb] + -1.426271532084567*b[i + 61*ldb] + 0.2356403269331877*b[i + 62*ldb] + 0.09218614391798526*b[i + 63*ldb] + -0.04441552013474293*b[i + 64*ldb] + 0.4379349075782941*b[i + 85*ldb] + 0.9794109587905273*b[i + 86*ldb] + 0.7540302351461837*b[i + 87*ldb] + 0.1054765566754525*b[i + 88*ldb] + -0.03493992481549068*b[i + 89*ldb]);
        c[i + 28*ldc] += (-0.04441552013474293*b[i + 60*ldb] + 0.09218614391798526*b[i + 61*ldb] + 0.2356403269331877*b[i + 62*ldb] + -1.426271532084567*b[i + 63*ldb] + -1.33618960885414*b[i + 64*ldb] + -0.0740478351152375*b[i + 85*ldb] + 0.2981430049956753*b[i + 86*ldb] + -0.4050837191937215*b[i + 87*ldb] + -5.935183299806961*b[i + 88*ldb] + -0.6982350131118888*b[i + 89*ldb]);
        c[i + 29*ldc] += (0.0740478351152375*b[i + 60*ldb] + -0.2981430049956753*b[i + 61*ldb] + 0.4050837191937215*b[i + 62*ldb] + 5.935183299806961*b[i + 63*ldb] + 0.6982350131118888*b[i + 64*ldb] + 0.04441552013474293*b[i + 85*ldb] + -0.09218614391798526*b[i + 86*ldb] + -0.2356403269331877*b[i + 87*ldb] + 1.426271532084567*b[i + 88*ldb] + 1.33618960885414*b[i + 89*ldb]);
        c[i + 30*ldc] += (-0.03407068760902764*b[i + 65*ldb] + 0.1414709948159384*b[i + 66*ldb] + -0.3732534616347092*b[i + 67*ldb] + 0.5787140289764666*b[i + 68*ldb] + 8.177986284176342*b[i + 69*ldb] + 0.03407068760902764*b[i + 90*ldb] + -0.1414709948159384*b[i + 91*ldb] + 0.3732534616347092*b[i + 92*ldb] + -0.5787140289764666*b[i + 93*ldb] + -8.177986284176342*b[i + 94*ldb]);
        c[i + 31*ldc] += (8.177986284176342*b[i + 65*ldb] + 0.5787140289764666*b[i + 66*ldb] + -0.3732534616347092*b[i + 67*ldb] + 0.1414709948159384*b[i + 68*ldb] + -0.03407068760902764*b[i + 69*ldb] + -0.3766849869423851*b[i + 90*ldb] + -0.9249186854440405*b[i + 91*ldb] + -1.205841535663668*b[i + 92*ldb] + -0.9249186854440405*b[i + 93*ldb] + -0.3766849869423851*b[i + 94*ldb]);
        c[i + 32*ldc] += (0.3766849869423851*b[i + 65*ldb] + 0.9249186854440405*b[i + 66*ldb] + 1.205841535663668*b[i + 67*ldb] + 0.9249186854440405*b[i + 68*ldb] + 0.3766849869423851*b[i + 69*ldb] + -8.177986284176342*b[i + 90*ldb] + -0.5787140289764666*b[i + 91*ldb] + 0.3732534616347092*b[i + 92*ldb] + -0.1414709948159384*b[i + 93*ldb] + 0.03407068760902764*b[i + 94*ldb]);
        c[i + 33*ldc] += (0.1065108706569845*b[i + 65*ldb] + 0.01797338358554743*b[i + 66*ldb] + -1.172900949469982*b[i + 67*ldb] + -1.125310822402669*b[i + 68*ldb] + -0.1520494233293387*b[i + 69*ldb] + -0.1065108706569845*b[i + 90*ldb] + -0.01797338358554743*b[i + 91*ldb] + 1.172900949469982*b[i + 92*ldb] + 1.125310822402669*b[i + 93*ldb] + 0.1520494233293387*b[i + 94*ldb]);
        c[i + 34*ldc] += (-0.1520494233293387*b[i + 65*ldb] + -1.125310822402669*b[i + 66*ldb] + -1.172900949469982*b[i + 67*ldb] + 0.01797338358554743*b[i + 68*ldb] + 0.1065108706569845*b[i + 69*ldb] + -0.03078013091636318*b[i + 90*ldb] + -0.4044323368695613*b[i + 91*ldb] + -0.9758930126717729*b[i + 92*ldb] + -0.4044323368695613*b[i + 93*ldb] + -0.03078013091636318*b[i + 94*ldb]);
        c[i + 35*ldc] += (0.03078013091636318*b[i + 65*ldb] + 0.4044323368695613*b[i + 66*ldb] + 0.9758930126717729*b[i + 67*ldb] + 0.4044323368695613*b[i + 68*ldb] + 0.03078013091636318*b[i + 69*ldb] + 0.1520494233293387*b[i + 90*ldb] + 1.125310822402669*b[i + 91*ldb] + 1.172900949469982*b[i + 92*ldb] + -0.01797338358554743*b[i + 93*ldb] + -0.1065108706569845*b[i + 94*ldb]);
        c[i + 36*ldc] += (0.5856389335240263*b[i + 65*ldb] + 1.072236397422101*b[i + 66*ldb] + 0.3158549142070798*b[i + 67*ldb] + -0.1092563383478909*b[i + 68*ldb] + -0.05850347735875196*b[i + 69*ldb] + -0.5856389335240263*b[i + 90*ldb] + -1.072236397422101*b[i + 91*ldb] + -0.3158549142070798*b[i + 92*ldb] + 0.1092563383478909*b[i + 93*ldb] + 0.05850347735875196*b[i + 94*ldb]);
        c[i + 37*ldc] += (-0.05850347735875196*b[i + 65*ldb] + -0.1092563383478909*b[i + 66*ldb] + 0.3158549142070798*b[i + 67*ldb] + 1.072236397422101*b[i + 68*ldb] + 0.5856389335240263*b[i + 69*ldb] + 0.2111687061258069*b[i + 90*ldb] + -0.6143808272731023*b[i + 91*ldb] + -5.454458520792602*b[i + 92*ldb] + -0.6143808272731023*b[i + 93*ldb] + 0.2111687061258069*b[i + 94*ldb]);
        c[i + 38*ldc] += (-0.2111687061258069*b[i + 65*ldb] + 0.6143808272731023*b[i + 66*ldb] + 5.454458520792602*b[i + 67*ldb] + 0.6143808272731023*b[i + 68*ldb] + -0.2111687061258069*b[i + 69*ldb] + 0.05850347735875196*b[i + 90*ldb] + 0.1092563383478909*b[i + 91*ldb] + -0.3158549142070798*b[i + 92*ldb] + -1.072236397422101*b[i + 93*ldb] + -0.5856389335240263*b[i + 94*ldb]);
        c[i + 39*ldc] += (0.6982350131118888*b[i + 65*ldb] + 5.935183299806961*b[i + 66*ldb] + 0.4050837191937215*b[i + 67*ldb] + -0.2981430049956753*b[i + 68*ldb] + 0.0740478351152375*b[i + 69*ldb] + -0.03493992481549068*b[i + 90*ldb] + 0.1054765566754525*b[i + 91*ldb] + 0.7540302351461837*b[i + 92*ldb] + 0.9794109587905273*b[i + 93*ldb] + 0.4379349075782941*b[i + 94*ldb]);
        c[i + 40*ldc] += (0.03493992481549068*b[i + 65*ldb] + -0.1054765566754525*b[i + 66*ldb] + -0.7540302351461837*b[i + 67*ldb] + -0.9794109587905273*b[i + 68*ldb] + -0.4379349075782941*b[i + 69*ldb] + -0.6982350131118888*b[i + 90*ldb] + -5.935183299806961*b[i + 91*ldb] + -0.4050837191937215*b[i + 92*ldb] + 0.2981430049956753*b[i + 93*ldb] + -0.0740478351152375*b[i + 94*ldb]);
        c[i + 41*ldc] += (-0.4379349075782941*b[i + 65*ldb] + -0.9794109587905273*b[i + 66*ldb] + -0.7540302351461837*b[i + 67*ldb] + -0.1054765566754525*b[i + 68*ldb] + 0.03493992481549068*b[i + 69*ldb] + 1.33618960885414*b[i + 90*ldb] + 1.426271532084567*b[i + 91*ldb] + -0.2356403269331877*b[i + 92*ldb] + -0.09218614391798526*b[i + 93*ldb] + 0.04441552013474293*b[i + 94*ldb]);
        c[i + 42*ldc] += (-1.33618960885414*b[i + 65*ldb] + -1.426271532084567*b[i + 66*ldb] + 0.2356403269331877*b[i + 67*ldb] + 0.09218614391798526*b[i + 68*ldb] + -0.04441552013474293*b[i + 69*ldb] + 0.4379349075782941*b[i + 90*ldb] + 0.9794109587905273*b[i + 91*ldb] + 0.7540302351461837*b[i + 92*ldb] + 0.1054765566754525*b[i + 93*ldb] + -0.03493992481549068*b[i + 94*ldb]);
        c[i + 43*ldc] += (-0.04441552013474293*b[i + 65*ldb] + 0.09218614391798526*b[i + 66*ldb] + 0.2356403269331877*b[i + 67*ldb] + -1.426271532084567*b[i + 68*ldb] + -1.33618960885414*b[i + 69*ldb] + -0.0740478351152375*b[i + 90*ldb] + 0.2981430049956753*b[i + 91*ldb] + -0.4050837191937215*b[i + 92*ldb] + -5.935183299806961*b[i + 93*ldb] + -0.6982350131118888*b[i + 94*ldb]);
        c[i + 44*ldc] += (0.0740478351152375*b[i + 65*ldb] + -0.2981430049956753*b[i + 66*ldb] + 0.4050837191937215*b[i + 67*ldb] + 5.935183299806961*b[i + 68*ldb] + 0.6982350131118888*b[i + 69*ldb] + 0.04441552013474293*b[i + 90*ldb] + -0.09218614391798526*b[i + 91*ldb] + -0.2356403269331877*b[i + 92*ldb] + 1.426271532084567*b[i + 93*ldb] + 1.33618960885414*b[i + 94*ldb]);
        c[i + 45*ldc] += (-0.03407068760902764*b[i + 70*ldb] + 0.1414709948159384*b[i + 71*ldb] + -0.3732534616347092*b[i + 72*ldb] + 0.5787140289764666*b[i + 73*ldb] + 8.177986284176342*b[i + 74*ldb] + 0.03407068760902764*b[i + 95*ldb] + -0.1414709948159384*b[i + 96*ldb] + 0.3732534616347092*b[i + 97*ldb] + -0.5787140289764666*b[i + 98*ldb] + -8.177986284176342*b[i + 99*ldb]);
        c[i + 46*ldc] += (8.177986284176342*b[i + 70*ldb] + 0.5787140289764666*b[i + 71*ldb] + -0.3732534616347092*b[i + 72*ldb] + 0.1414709948159384*b[i + 73*ldb] + -0.03407068760902764*b[i + 74*ldb] + -0.3766849869423851*b[i + 95*ldb] + -0.9249186854440405*b[i + 96*ldb] + -1.205841535663668*b[i + 97*ldb] + -0.9249186854440405*b[i + 98*ldb] + -0.3766849869423851*b[i + 99*ldb]);
        c[i + 47*ldc] += (0.3766849869423851*b[i + 70*ldb] + 0.9249186854440405*b[i + 71*ldb] + 1.205841535663668*b[i + 72*ldb] + 0.9249186854440405*b[i + 73*ldb] + 0.3766849869423851*b[i + 74*ldb] + -8.177986284176342*b[i + 95*ldb] + -0.5787140289764666*b[i + 96*ldb] + 0.3732534616347092*b[i + 97*ldb] + -0.1414709948159384*b[i + 98*ldb] + 0.03407068760902764*b[i + 99*ldb]);
        c[i + 48*ldc] += (0.1065108706569845*b[i + 70*ldb] + 0.01797338358554743*b[i + 71*ldb] + -1.172900949469982*b[i + 72*ldb] + -1.125310822402669*b[i + 73*ldb] + -0.1520494233293387*b[i + 74*ldb] + -0.1065108706569845*b[i + 95*ldb] + -0.01797338358554743*b[i + 96*ldb] + 1.172900949469982*b[i + 97*ldb] + 1.125310822402669*b[i + 98*ldb] + 0.1520494233293387*b[i + 99*ldb]);
        c[i + 49*ldc] += (-0.1520494233293387*b[i + 70*ldb] + -1.125310822402669*b[i + 71*ldb] + -1.172900949469982*b[i + 72*ldb] + 0.01797338358554743*b[i + 73*ldb] + 0.1065108706569845*b[i + 74*ldb] + -0.03078013091636318*b[i + 95*ldb] + -0.4044323368695613*b[i + 96*ldb] + -0.9758930126717729*b[i + 97*ldb] + -0.4044323368695613*b[i + 98*ldb] + -0.03078013091636318*b[i + 99*ldb]);
        c[i + 50*ldc] += (0.03078013091636318*b[i + 70*ldb] + 0.4044323368695613*b[i + 71*ldb] + 0.9758930126717729*b[i + 72*ldb] + 0.4044323368695613*b[i + 73*ldb] + 0.03078013091636318*b[i + 74*ldb] + 0.1520494233293387*b[i + 95*ldb] + 1.125310822402669*b[i + 96*ldb] + 1.172900949469982*b[i + 97*ldb] + -0.01797338358554743*b[i + 98*ldb] + -0.1065108706569845*b[i + 99*ldb]);
        c[i + 51*ldc] += (0.5856389335240263*b[i + 70*ldb] + 1.072236397422101*b[i + 71*ldb] + 0.3158549142070798*b[i + 72*ldb] + -0.1092563383478909*b[i + 73*ldb] + -0.05850347735875196*b[i + 74*ldb] + -0.5856389335240263*b[i + 95*ldb] + -1.072236397422101*b[i + 96*ldb] + -0.3158549142070798*b[i + 97*ldb] + 0.1092563383478909*b[i + 98*ldb] + 0.05850347735875196*b[i + 99*ldb]);
        c[i + 52*ldc] += (-0.05850347735875196*b[i + 70*ldb] + -0.1092563383478909*b[i + 71*ldb] + 0.3158549142070798*b[i + 72*ldb] + 1.072236397422101*b[i + 73*ldb] + 0.5856389335240263*b[i + 74*ldb] + 0.2111687061258069*b[i + 95*ldb] + -0.6143808272731023*b[i + 96*ldb] + -5.454458520792602*b[i + 97*ldb] + -0.6143808272731023*b[i + 98*ldb] + 0.2111687061258069*b[i + 99*ldb]);
        c[i + 53*ldc] += (-0.2111687061258069*b[i + 70*ldb] + 0.6143808272731023*b[i + 71*ldb] + 5.454458520792602*b[i + 72*ldb] + 0.6143808272731023*b[i + 73*ldb] + -0.2111687061258069*b[i + 74*ldb] + 0.05850347735875196*b[i + 95*ldb] + 0.1092563383478909*b[i + 96*ldb] + -0.3158549142070798*b[i + 97*ldb] + -1.072236397422101*b[i + 98*ldb] + -0.5856389335240263*b[i + 99*ldb]);
        c[i + 54*ldc] += (0.6982350131118888*b[i + 70*ldb] + 5.935183299806961*b[i + 71*ldb] + 0.4050837191937215*b[i + 72*ldb] + -0.2981430049956753*b[i + 73*ldb] + 0.0740478351152375*b[i + 74*ldb] + -0.03493992481549068*b[i + 95*ldb] + 0.1054765566754525*b[i + 96*ldb] + 0.7540302351461837*b[i + 97*ldb] + 0.9794109587905273*b[i + 98*ldb] + 0.4379349075782941*b[i + 99*ldb]);
        c[i + 55*ldc] += (0.03493992481549068*b[i + 70*ldb] + -0.1054765566754525*b[i + 71*ldb] + -0.7540302351461837*b[i + 72*ldb] + -0.9794109587905273*b[i + 73*ldb] + -0.4379349075782941*b[i + 74*ldb] + -0.6982350131118888*b[i + 95*ldb] + -5.935183299806961*b[i + 96*ldb] + -0.4050837191937215*b[i + 97*ldb] + 0.2981430049956753*b[i + 98*ldb] + -0.0740478351152375*b[i + 99*ldb]);
        c[i + 56*ldc] += (-0.4379349075782941*b[i + 70*ldb] + -0.9794109587905273*b[i + 71*ldb] + -0.7540302351461837*b[i + 72*ldb] + -0.1054765566754525*b[i + 73*ldb] + 0.03493992481549068*b[i + 74*ldb] + 1.33618960885414*b[i + 95*ldb] + 1.426271532084567*b[i + 96*ldb] + -0.2356403269331877*b[i + 97*ldb] + -0.09218614391798526*b[i + 98*ldb] + 0.04441552013474293*b[i + 99*ldb]);
        c[i + 57*ldc] += (-1.33618960885414*b[i + 70*ldb] + -1.426271532084567*b[i + 71*ldb] + 0.2356403269331877*b[i + 72*ldb] + 0.09218614391798526*b[i + 73*ldb] + -0.04441552013474293*b[i + 74*ldb] + 0.4379349075782941*b[i + 95*ldb] + 0.9794109587905273*b[i + 96*ldb] + 0.7540302351461837*b[i + 97*ldb] + 0.1054765566754525*b[i + 98*ldb] + -0.03493992481549068*b[i + 99*ldb]);
        c[i + 58*ldc] += (-0.04441552013474293*b[i + 70*ldb] + 0.09218614391798526*b[i + 71*ldb] + 0.2356403269331877*b[i + 72*ldb] + -1.426271532084567*b[i + 73*ldb] + -1.33618960885414*b[i + 74*ldb] + -0.0740478351152375*b[i + 95*ldb] + 0.2981430049956753*b[i + 96*ldb] + -0.4050837191937215*b[i + 97*ldb] + -5.935183299806961*b[i + 98*ldb] + -0.6982350131118888*b[i + 99*ldb]);
        c[i + 59*ldc] += (0.0740478351152375*b[i + 70*ldb] + -0.2981430049956753*b[i + 71*ldb] + 0.4050837191937215*b[i + 72*ldb] + 5.935183299806961*b[i + 73*ldb] + 0.6982350131118888*b[i + 74*ldb] + 0.04441552013474293*b[i + 95*ldb] + -0.09218614391798526*b[i + 96*ldb] + -0.2356403269331877*b[i + 97*ldb] + 1.426271532084567*b[i + 98*ldb] + 1.33618960885414*b[i + 99*ldb]);
        c[i + 60*ldc] += (-0.03407068760902764*b[i + 75*ldb] + 0.1414709948159384*b[i + 76*ldb] + -0.3732534616347092*b[i + 77*ldb] + 0.5787140289764666*b[i + 78*ldb] + 8.177986284176342*b[i + 79*ldb] + 0.03407068760902764*b[i + 100*ldb] + -0.1414709948159384*b[i + 101*ldb] + 0.3732534616347092*b[i + 102*ldb] + -0.5787140289764666*b[i + 103*ldb] + -8.177986284176342*b[i + 104*ldb]);
        c[i + 61*ldc] += (8.177986284176342*b[i + 75*ldb] + 0.5787140289764666*b[i + 76*ldb] + -0.3732534616347092*b[i + 77*ldb] + 0.1414709948159384*b[i + 78*ldb] + -0.03407068760902764*b[i + 79*ldb] + -0.3766849869423851*b[i + 100*ldb] + -0.9249186854440405*b[i + 101*ldb] + -1.205841535663668*b[i + 102*ldb] + -0.9249186854440405*b[i + 103*ldb] + -0.3766849869423851*b[i + 104*ldb]);
        c[i + 62*ldc] += (0.3766849869423851*b[i + 75*ldb] + 0.9249186854440405*b[i + 76*ldb] + 1.205841535663668*b[i + 77*ldb] + 0.9249186854440405*b[i + 78*ldb] + 0.3766849869423851*b[i + 79*ldb] + -8.177986284176342*b[i + 100*ldb] + -0.5787140289764666*b[i + 101*ldb] + 0.3732534616347092*b[i + 102*ldb] + -0.1414709948159384*b[i + 103*ldb] + 0.03407068760902764*b[i + 104*ldb]);
        c[i + 63*ldc] += (0.1065108706569845*b[i + 75*ldb] + 0.01797338358554743*b[i + 76*ldb] + -1.172900949469982*b[i + 77*ldb] + -1.125310822402669*b[i + 78*ldb] + -0.1520494233293387*b[i + 79*ldb] + -0.1065108706569845*b[i + 100*ldb] + -0.01797338358554743*b[i + 101*ldb] + 1.172900949469982*b[i + 102*ldb] + 1.125310822402669*b[i + 103*ldb] + 0.1520494233293387*b[i + 104*ldb]);
        c[i + 64*ldc] += (-0.1520494233293387*b[i + 75*ldb] + -1.125310822402669*b[i + 76*ldb] + -1.172900949469982*b[i + 77*ldb] + 0.01797338358554743*b[i + 78*ldb] + 0.1065108706569845*b[i + 79*ldb] + -0.03078013091636318*b[i + 100*ldb] + -0.4044323368695613*b[i + 101*ldb] + -0.9758930126717729*b[i + 102*ldb] + -0.4044323368695613*b[i + 103*ldb] + -0.03078013091636318*b[i + 104*ldb]);
        c[i + 65*ldc] += (0.03078013091636318*b[i + 75*ldb] + 0.4044323368695613*b[i + 76*ldb] + 0.9758930126717729*b[i + 77*ldb] + 0.4044323368695613*b[i + 78*ldb] + 0.03078013091636318*b[i + 79*ldb] + 0.1520494233293387*b[i + 100*ldb] + 1.125310822402669*b[i + 101*ldb] + 1.172900949469982*b[i + 102*ldb] + -0.01797338358554743*b[i + 103*ldb] + -0.1065108706569845*b[i + 104*ldb]);
        c[i + 66*ldc] += (0.5856389335240263*b[i + 75*ldb] + 1.072236397422101*b[i + 76*ldb] + 0.3158549142070798*b[i + 77*ldb] + -0.1092563383478909*b[i + 78*ldb] + -0.05850347735875196*b[i + 79*ldb] + -0.5856389335240263*b[i + 100*ldb] + -1.072236397422101*b[i + 101*ldb] + -0.3158549142070798*b[i + 102*ldb] + 0.1092563383478909*b[i + 103*ldb] + 0.05850347735875196*b[i + 104*ldb]);
        c[i + 67*ldc] += (-0.05850347735875196*b[i + 75*ldb] + -0.1092563383478909*b[i + 76*ldb] + 0.3158549142070798*b[i + 77*ldb] + 1.072236397422101*b[i + 78*ldb] + 0.5856389335240263*b[i + 79*ldb] + 0.2111687061258069*b[i + 100*ldb] + -0.6143808272731023*b[i + 101*ldb] + -5.454458520792602*b[i + 102*ldb] + -0.6143808272731023*b[i + 103*ldb] + 0.2111687061258069*b[i + 104*ldb]);
        c[i + 68*ldc] += (-0.2111687061258069*b[i + 75*ldb] + 0.6143808272731023*b[i + 76*ldb] + 5.454458520792602*b[i + 77*ldb] + 0.6143808272731023*b[i + 78*ldb] + -0.2111687061258069*b[i + 79*ldb] + 0.05850347735875196*b[i + 100*ldb] + 0.1092563383478909*b[i + 101*ldb] + -0.3158549142070798*b[i + 102*ldb] + -1.072236397422101*b[i + 103*ldb] + -0.5856389335240263*b[i + 104*ldb]);
        c[i + 69*ldc] += (0.6982350131118888*b[i + 75*ldb] + 5.935183299806961*b[i + 76*ldb] + 0.4050837191937215*b[i + 77*ldb] + -0.2981430049956753*b[i + 78*ldb] + 0.0740478351152375*b[i + 79*ldb] + -0.03493992481549068*b[i + 100*ldb] + 0.1054765566754525*b[i + 101*ldb] + 0.7540302351461837*b[i + 102*ldb] + 0.9794109587905273*b[i + 103*ldb] + 0.4379349075782941*b[i + 104*ldb]);
        c[i + 70*ldc] += (0.03493992481549068*b[i + 75*ldb] + -0.1054765566754525*b[i + 76*ldb] + -0.7540302351461837*b[i + 77*ldb] + -0.9794109587905273*b[i + 78*ldb] + -0.4379349075782941*b[i + 79*ldb] + -0.6982350131118888*b[i + 100*ldb] + -5.935183299806961*b[i + 101*ldb] + -0.4050837191937215*b[i + 102*ldb] + 0.2981430049956753*b[i + 103*ldb] + -0.0740478351152375*b[i + 104*ldb]);
        c[i + 71*ldc] += (-0.4379349075782941*b[i + 75*ldb] + -0.9794109587905273*b[i + 76*ldb] + -0.7540302351461837*b[i + 77*ldb] + -0.1054765566754525*b[i + 78*ldb] + 0.03493992481549068*b[i + 79*ldb] + 1.33618960885414*b[i + 100*ldb] + 1.426271532084567*b[i + 101*ldb] + -0.2356403269331877*b[i + 102*ldb] + -0.09218614391798526*b[i + 103*ldb] + 0.04441552013474293*b[i + 104*ldb]);
        c[i + 72*ldc] += (-1.33618960885414*b[i + 75*ldb] + -1.426271532084567*b[i + 76*ldb] + 0.2356403269331877*b[i + 77*ldb] + 0.09218614391798526*b[i + 78*ldb] + -0.04441552013474293*b[i + 79*ldb] + 0.4379349075782941*b[i + 100*ldb] + 0.9794109587905273*b[i + 101*ldb] + 0.7540302351461837*b[i + 102*ldb] + 0.1054765566754525*b[i + 103*ldb] + -0.03493992481549068*b[i + 104*ldb]);
        c[i + 73*ldc] += (-0.04441552013474293*b[i + 75*ldb] + 0.09218614391798526*b[i + 76*ldb] + 0.2356403269331877*b[i + 77*ldb] + -1.426271532084567*b[i + 78*ldb] + -1.33618960885414*b[i + 79*ldb] + -0.0740478351152375*b[i + 100*ldb] + 0.2981430049956753*b[i + 101*ldb] + -0.4050837191937215*b[i + 102*ldb] + -5.935183299806961*b[i + 103*ldb] + -0.6982350131118888*b[i + 104*ldb]);
        c[i + 74*ldc] += (0.0740478351152375*b[i + 75*ldb] + -0.2981430049956753*b[i + 76*ldb] + 0.4050837191937215*b[i + 77*ldb] + 5.935183299806961*b[i + 78*ldb] + 0.6982350131118888*b[i + 79*ldb] + 0.04441552013474293*b[i + 100*ldb] + -0.09218614391798526*b[i + 101*ldb] + -0.2356403269331877*b[i + 102*ldb] + 1.426271532084567*b[i + 103*ldb] + 1.33618960885414*b[i + 104*ldb]);
        c[i + 75*ldc] += (-0.3766849869423851*b[i + 30*ldb] + -0.9249186854440405*b[i + 31*ldb] + -1.205841535663668*b[i + 32*ldb] + -0.9249186854440405*b[i + 33*ldb] + -0.3766849869423851*b[i + 34*ldb] + -0.03407068760902764*b[i + 55*ldb] + 0.1414709948159384*b[i + 56*ldb] + -0.3732534616347092*b[i + 57*ldb] + 0.5787140289764666*b[i + 58*ldb] + 8.177986284176342*b[i + 59*ldb]);
        c[i + 76*ldc] += (0.03407068760902764*b[i + 30*ldb] + -0.1414709948159384*b[i + 31*ldb] + 0.3732534616347092*b[i + 32*ldb] + -0.5787140289764666*b[i + 33*ldb] + -8.177986284176342*b[i + 34*ldb] + 8.177986284176342*b[i + 55*ldb] + 0.5787140289764666*b[i + 56*ldb] + -0.3732534616347092*b[i + 57*ldb] + 0.1414709948159384*b[i + 58*ldb] + -0.03407068760902764*b[i + 59*ldb]);
        c[i + 77*ldc] += (-8.177986284176342*b[i + 30*ldb] + -0.5787140289764666*b[i + 31*ldb] + 0.3732534616347092*b[i + 32*ldb] + -0.1414709948159384*b[i + 33*ldb] + 0.03407068760902764*b[i + 34*ldb] + 0.3766849869423851*b[i + 55*ldb] + 0.9249186854440405*b[i + 56*ldb] + 1.205841535663668*b[i + 57*ldb] + 0.9249186854440405*b[i + 58*ldb] + 0.3766849869423851*b[i + 59*ldb]);
        c[i + 78*ldc] += (-0.03078013091636318*b[i + 30*ldb] + -0.4044323368695613*b[i + 31*ldb] + -0.9758930126717729*b[i + 32*ldb] + -0.4044323368695613*b[i + 33*ldb] + -0.03078013091636318*b[i + 34*ldb] + 0.1065108706569845*b[i + 55*ldb] + 0.01797338358554743*b[i + 56*ldb] + -1.172900949469982*b[i + 57*ldb] + -1.125310822402669*b[i + 58*ldb] + -0.1520494233293387*b[i + 59*ldb]);
        c[i + 79*ldc] += (-0.1065108706569845*b[i + 30*ldb] + -0.01797338358554743*b[i + 31*ldb] + 1.172900949469982*b[i + 32*ldb] + 1.125310822402669*b[i + 33*ldb] + 0.1520494233293387*b[i + 34*ldb] + -0.1520494233293387*b[i + 55*ldb] + -1.125310822402669*b[i + 56*ldb] + -1.172900949469982*b[i + 57*ldb] + 0.01797338358554743*b[i + 58*ldb] + 0.1065108706569845*b[i + 59*ldb]);
        c[i + 80*ldc] += (0.1520494233293387*b[i + 30*ldb] + 1.125310822402669*b[i + 31*ldb] + 1.172900949469982*b[i + 32*ldb] + -0.01797338358554743*b[i + 33*ldb] + -0.1065108706569845*b[i + 34*ldb] + 0.03078013091636318*b[i + 55*ldb] + 0.4044323368695613*b[i + 56*ldb] + 0.9758930126717729*b[i + 57*ldb] + 0.4044323368695613*b[i + 58*ldb] + 0.03078013091636318*b[i + 59*ldb]);
        c[i + 81*ldc] += (0.2111687061258069*b[i + 30*ldb] + -0.6143808272731023*b[i + 31*ldb] + -5.454458520792602*b[i + 32*ldb] + -0.6143808272731023*b[i + 33*ldb] + 0.2111687061258069*b[i + 34*ldb] + 0.5856389335240263*b[i + 55*ldb] + 1.072236397422101*b[i + 56*ldb] + 0.3158549142070798*b[i + 57*ldb] + -0.1092563383478909*b[i + 58*ldb] + -0.05850347735875196*b[i + 59*ldb]);
        c[i + 82*ldc] += (-0.5856389335240263*b[i + 30*ldb] + -1.072236397422101*b[i + 31*ldb] + -0.3158549142070798*b[i + 32*ldb] + 0.1092563383478909*b[i + 33*ldb] + 0.05850347735875196*b[i + 34*ldb] + -0.05850347735875196*b[i + 55*ldb] + -0.1092563383478909*b[i + 56*ldb] + 0.3158549142070798*b[i + 57*ldb] + 1.072236397422101*b[i + 58*ldb] + 0.5856389335240263*b[i + 59*ldb]);
        c[i + 83*ldc] += (0.05850347735875196*b[i + 30*ldb] + 0.1092563383478909*b[i + 31*ldb] + -0.3158549142070798*b[i + 32*ldb] + -1.072236397422101*b[i + 33*ldb] + -0.5856389335240263*b[i + 34*ldb] + -0.2111687061258069*b[i + 55*ldb] + 0.6143808272731023*b[i + 56*ldb] + 5.454458520792602*b[i + 57*ldb] + 0.6143808272731023*b[i + 58*ldb] + -0.2111687061258069*b[i + 59*ldb]);
        c[i + 84*ldc] += (0.04441552013474293*b[i + 30*ldb] + -0.09218614391798526*b[i + 31*ldb] + -0.2356403269331877*b[i + 32*ldb] + 1.426271532084567*b[i + 33*ldb] + 1.33618960885414*b[i + 34*ldb] + 0.6982350131118888*b[i + 55*ldb] + 5.935183299806961*b[i + 56*ldb] + 0.4050837191937215*b[i + 57*ldb] + -0.2981430049956753*b[i + 58*ldb] + 0.0740478351152375*b[i + 59*ldb]);
        c[i + 85*ldc] += (1.33618960885414*b[i + 30*ldb] + 1.426271532084567*b[i + 31*ldb] + -0.2356403269331877*b[i + 32*ldb] + -0.09218614391798526*b[i + 33*ldb] + 0.04441552013474293*b[i + 34*ldb] + 0.03493992481549068*b[i + 55*ldb] + -0.1054765566754525*b[i + 56*ldb] + -0.7540302351461837*b[i + 57*ldb] + -0.9794109587905273*b[i + 58*ldb] + -0.4379349075782941*b[i + 59*ldb]);
        c[i + 86*ldc] += (-0.6982350131118888*b[i + 30*ldb] + -5.935183299806961*b[i + 31*ldb] + -0.4050837191937215*b[i + 32*ldb] + 0.2981430049956753*b[i + 33*ldb] + -0.0740478351152375*b[i + 34*ldb] + -0.4379349075782941*b[i + 55*ldb] + -0.9794109587905273*b[i + 56*ldb] + -0.7540302351461837*b[i + 57*ldb] + -0.1054765566754525*b[i + 58*ldb] + 0.03493992481549068*b[i + 59*ldb]);
        c[i + 87*ldc] += (-0.0740478351152375*b[i + 30*ldb] + 0.2981430049956753*b[i + 31*ldb] + -0.4050837191937215*b[i + 32*ldb] + -5.935183299806961*b[i + 33*ldb] + -0.6982350131118888*b[i + 34*ldb] + -1.33618960885414*b[i + 55*ldb] + -1.426271532084567*b[i + 56*ldb] + 0.2356403269331877*b[i + 57*ldb] + 0.09218614391798526*b[i + 58*ldb] + -0.04441552013474293*b[i + 59*ldb]);
        c[i + 88*ldc] += (0.4379349075782941*b[i + 30*ldb] + 0.9794109587905273*b[i + 31*ldb] + 0.7540302351461837*b[i + 32*ldb] + 0.1054765566754525*b[i + 33*ldb] + -0.03493992481549068*b[i + 34*ldb] + -0.04441552013474293*b[i + 55*ldb] + 0.09218614391798526*b[i + 56*ldb] + 0.2356403269331877*b[i + 57*ldb] + -1.426271532084567*b[i + 58*ldb] + -1.33618960885414*b[i + 59*ldb]);
        c[i + 89*ldc] += (-0.03493992481549068*b[i + 30*ldb] + 0.1054765566754525*b[i + 31*ldb] + 0.7540302351461837*b[i + 32*ldb] + 0.9794109587905273*b[i + 33*ldb] + 0.4379349075782941*b[i + 34*ldb] + 0.0740478351152375*b[i + 55*ldb] + -0.2981430049956753*b[i + 56*ldb] + 0.4050837191937215*b[i + 57*ldb] + 5.935183299806961*b[i + 58*ldb] + 0.6982350131118888*b[i + 59*ldb]);
        c[i + 90*ldc] += (-0.3766849869423851*b[i + 35*ldb] + -0.9249186854440405*b[i + 36*ldb] + -1.205841535663668*b[i + 37*ldb] + -0.9249186854440405*b[i + 38*ldb] + -0.3766849869423851*b[i + 39*ldb] + -0.03407068760902764*b[i + 60*ldb] + 0.1414709948159384*b[i + 61*ldb] + -0.3732534616347092*b[i + 62*ldb] + 0.5787140289764666*b[i + 63*ldb] + 8.177986284176342*b[i + 64*ldb]);
        c[i + 91*ldc] += (0.03407068760902764*b[i + 35*ldb] + -0.1414709948159384*b[i + 36*ldb] + 0.3732534616347092*b[i + 37*ldb] + -0.5787140289764666*b[i + 38*ldb] + -8.177986284176342*b[i + 39*ldb] + 8.177986284176342*b[i + 60*ldb] + 0.5787140289764666*b[i + 61*ldb] + -0.3732534616347092*b[i + 62*ldb] + 0.1414709948159384*b[i + 63*ldb] + -0.03407068760902764*b[i + 64*ldb]);
        c[i + 92*ldc] += (-8.177986284176342*b[i + 35*ldb] + -0.5787140289764666*b[i + 36*ldb] + 0.3732534616347092*b[i + 37*ldb] + -0.1414709948159384*b[i + 38*ldb] + 0.03407068760902764*b[i + 39*ldb] + 0.3766849869423851*b[i + 60*ldb] + 0.9249186854440405*b[i + 61*ldb] + 1.205841535663668*b[i + 62*ldb] + 0.9249186854440405*b[i + 63*ldb] + 0.3766849869423851*b[i + 64*ldb]);
        c[i + 93*ldc] += (-0.03078013091636318*b[i + 35*ldb] + -0.4044323368695613*b[i + 36*ldb] + -0.9758930126717729*b[i + 37*ldb] + -0.4044323368695613*b[i + 38*ldb] + -0.03078013091636318*b[i + 39*ldb] + 0.1065108706569845*b[i + 60*ldb] + 0.01797338358554743*b[i + 61*ldb] + -1.172900949469982*b[i + 62*ldb] + -1.125310822402669*b[i + 63*ldb] + -0.1520494233293387*b[i + 64*ldb]);
        c[i + 94*ldc] += (-0.1065108706569845*b[i + 35*ldb] + -0.01797338358554743*b[i + 36*ldb] + 1.172900949469982*b[i + 37*ldb] + 1.125310822402669*b[i + 38*ldb] + 0.1520494233293387*b[i + 39*ldb] + -0.1520494233293387*b[i + 60*ldb] + -1.125310822402669*b[i + 61*ldb] + -1.172900949469982*b[i + 62*ldb] + 0.01797338358554743*b[i + 63*ldb] + 0.1065108706569845*b[i + 64*ldb]);
        c[i + 95*ldc] += (0.1520494233293387*b[i + 35*ldb] + 1.125310822402669*b[i + 36*ldb] + 1.172900949469982*b[i + 37*ldb] + -0.01797338358554743*b[i + 38*ldb] + -0.1065108706569845*b[i + 39*ldb] + 0.03078013091636318*b[i + 60*ldb] + 0.4044323368695613*b[i + 61*ldb] + 0.9758930126717729*b[i + 62*ldb] + 0.4044323368695613*b[i + 63*ldb] + 0.03078013091636318*b[i + 64*ldb]);
        c[i + 96*ldc] += (0.2111687061258069*b[i + 35*ldb] + -0.6143808272731023*b[i + 36*ldb] + -5.454458520792602*b[i + 37*ldb] + -0.6143808272731023*b[i + 38*ldb] + 0.2111687061258069*b[i + 39*ldb] + 0.5856389335240263*b[i + 60*ldb] + 1.072236397422101*b[i + 61*ldb] + 0.3158549142070798*b[i + 62*ldb] + -0.1092563383478909*b[i + 63*ldb] + -0.05850347735875196*b[i + 64*ldb]);
        c[i + 97*ldc] += (-0.5856389335240263*b[i + 35*ldb] + -1.072236397422101*b[i + 36*ldb] + -0.3158549142070798*b[i + 37*ldb] + 0.1092563383478909*b[i + 38*ldb] + 0.05850347735875196*b[i + 39*ldb] + -0.05850347735875196*b[i + 60*ldb] + -0.1092563383478909*b[i + 61*ldb] + 0.3158549142070798*b[i + 62*ldb] + 1.072236397422101*b[i + 63*ldb] + 0.5856389335240263*b[i + 64*ldb]);
        c[i + 98*ldc] += (0.05850347735875196*b[i + 35*ldb] + 0.1092563383478909*b[i + 36*ldb] + -0.3158549142070798*b[i + 37*ldb] + -1.072236397422101*b[i + 38*ldb] + -0.5856389335240263*b[i + 39*ldb] + -0.2111687061258069*b[i + 60*ldb] + 0.6143808272731023*b[i + 61*ldb] + 5.454458520792602*b[i + 62*ldb] + 0.6143808272731023*b[i + 63*ldb] + -0.2111687061258069*b[i + 64*ldb]);
        c[i + 99*ldc] += (0.04441552013474293*b[i + 35*ldb] + -0.09218614391798526*b[i + 36*ldb] + -0.2356403269331877*b[i + 37*ldb] + 1.426271532084567*b[i + 38*ldb] + 1.33618960885414*b[i + 39*ldb] + 0.6982350131118888*b[i + 60*ldb] + 5.935183299806961*b[i + 61*ldb] + 0.4050837191937215*b[i + 62*ldb] + -0.2981430049956753*b[i + 63*ldb] + 0.0740478351152375*b[i + 64*ldb]);
        c[i + 100*ldc] += (1.33618960885414*b[i + 35*ldb] + 1.426271532084567*b[i + 36*ldb] + -0.2356403269331877*b[i + 37*ldb] + -0.09218614391798526*b[i + 38*ldb] + 0.04441552013474293*b[i + 39*ldb] + 0.03493992481549068*b[i + 60*ldb] + -0.1054765566754525*b[i + 61*ldb] + -0.7540302351461837*b[i + 62*ldb] + -0.9794109587905273*b[i + 63*ldb] + -0.4379349075782941*b[i + 64*ldb]);
        c[i + 101*ldc] += (-0.6982350131118888*b[i + 35*ldb] + -5.935183299806961*b[i + 36*ldb] + -0.4050837191937215*b[i + 37*ldb] + 0.2981430049956753*b[i + 38*ldb] + -0.0740478351152375*b[i + 39*ldb] + -0.4379349075782941*b[i + 60*ldb] + -0.9794109587905273*b[i + 61*ldb] + -0.7540302351461837*b[i + 62*ldb] + -0.1054765566754525*b[i + 63*ldb] + 0.03493992481549068*b[i + 64*ldb]);
        c[i + 102*ldc] += (-0.0740478351152375*b[i + 35*ldb] + 0.2981430049956753*b[i + 36*ldb] + -0.4050837191937215*b[i + 37*ldb] + -5.935183299806961*b[i + 38*ldb] + -0.6982350131118888*b[i + 39*ldb] + -1.33618960885414*b[i + 60*ldb] + -1.426271532084567*b[i + 61*ldb] + 0.2356403269331877*b[i + 62*ldb] + 0.09218614391798526*b[i + 63*ldb] + -0.04441552013474293*b[i + 64*ldb]);
        c[i + 103*ldc] += (0.4379349075782941*b[i + 35*ldb] + 0.9794109587905273*b[i + 36*ldb] + 0.7540302351461837*b[i + 37*ldb] + 0.1054765566754525*b[i + 38*ldb] + -0.03493992481549068*b[i + 39*ldb] + -0.04441552013474293*b[i + 60*ldb] + 0.09218614391798526*b[i + 61*ldb] + 0.2356403269331877*b[i + 62*ldb] + -1.426271532084567*b[i + 63*ldb] + -1.33618960885414*b[i + 64*ldb]);
        c[i + 104*ldc] += (-0.03493992481549068*b[i + 35*ldb] + 0.1054765566754525*b[i + 36*ldb] + 0.7540302351461837*b[i + 37*ldb] + 0.9794109587905273*b[i + 38*ldb] + 0.4379349075782941*b[i + 39*ldb] + 0.0740478351152375*b[i + 60*ldb] + -0.2981430049956753*b[i + 61*ldb] + 0.4050837191937215*b[i + 62*ldb] + 5.935183299806961*b[i + 63*ldb] + 0.6982350131118888*b[i + 64*ldb]);
        c[i + 105*ldc] += (-0.3766849869423851*b[i + 40*ldb] + -0.9249186854440405*b[i + 41*ldb] + -1.205841535663668*b[i + 42*ldb] + -0.9249186854440405*b[i + 43*ldb] + -0.3766849869423851*b[i + 44*ldb] + -0.03407068760902764*b[i + 65*ldb] + 0.1414709948159384*b[i + 66*ldb] + -0.3732534616347092*b[i + 67*ldb] + 0.5787140289764666*b[i + 68*ldb] + 8.177986284176342*b[i + 69*ldb]);
        c[i + 106*ldc] += (0.03407068760902764*b[i + 40*ldb] + -0.1414709948159384*b[i + 41*ldb] + 0.3732534616347092*b[i + 42*ldb] + -0.5787140289764666*b[i + 43*ldb] + -8.177986284176342*b[i + 44*ldb] + 8.177986284176342*b[i + 65*ldb] + 0.5787140289764666*b[i + 66*ldb] + -0.3732534616347092*b[i + 67*ldb] + 0.1414709948159384*b[i + 68*ldb] + -0.03407068760902764*b[i + 69*ldb]);
        c[i + 107*ldc] += (-8.177986284176342*b[i + 40*ldb] + -0.5787140289764666*b[i + 41*ldb] + 0.3732534616347092*b[i + 42*ldb] + -0.1414709948159384*b[i + 43*ldb] + 0.03407068760902764*b[i + 44*ldb] + 0.3766849869423851*b[i + 65*ldb] + 0.9249186854440405*b[i + 66*ldb] + 1.205841535663668*b[i + 67*ldb] + 0.9249186854440405*b[i + 68*ldb] + 0.3766849869423851*b[i + 69*ldb]);
        c[i + 108*ldc] += (-0.03078013091636318*b[i + 40*ldb] + -0.4044323368695613*b[i + 41*ldb] + -0.9758930126717729*b[i + 42*ldb] + -0.4044323368695613*b[i + 43*ldb] + -0.03078013091636318*b[i + 44*ldb] + 0.1065108706569845*b[i + 65*ldb] + 0.01797338358554743*b[i + 66*ldb] + -1.172900949469982*b[i + 67*ldb] + -1.125310822402669*b[i + 68*ldb] + -0.1520494233293387*b[i + 69*ldb]);
        c[i + 109*ldc] += (-0.1065108706569845*b[i + 40*ldb] + -0.01797338358554743*b[i + 41*ldb] + 1.172900949469982*b[i + 42*ldb] + 1.125310822402669*b[i + 43*ldb] + 0.1520494233293387*b[i + 44*ldb] + -0.1520494233293387*b[i + 65*ldb] + -1.125310822402669*b[i + 66*ldb] + -1.172900949469982*b[i + 67*ldb] + 0.01797338358554743*b[i + 68*ldb] + 0.1065108706569845*b[i + 69*ldb]);
        c[i + 110*ldc] += (0.1520494233293387*b[i + 40*ldb] + 1.125310822402669*b[i + 41*ldb] + 1.172900949469982*b[i + 42*ldb] + -0.01797338358554743*b[i + 43*ldb] + -0.1065108706569845*b[i + 44*ldb] + 0.03078013091636318*b[i + 65*ldb] + 0.4044323368695613*b[i + 66*ldb] + 0.9758930126717729*b[i + 67*ldb] + 0.4044323368695613*b[i + 68*ldb] + 0.03078013091636318*b[i + 69*ldb]);
        c[i + 111*ldc] += (0.2111687061258069*b[i + 40*ldb] + -0.6143808272731023*b[i + 41*ldb] + -5.454458520792602*b[i + 42*ldb] + -0.6143808272731023*b[i + 43*ldb] + 0.2111687061258069*b[i + 44*ldb] + 0.5856389335240263*b[i + 65*ldb] + 1.072236397422101*b[i + 66*ldb] + 0.3158549142070798*b[i + 67*ldb] + -0.1092563383478909*b[i + 68*ldb] + -0.05850347735875196*b[i + 69*ldb]);
        c[i + 112*ldc] += (-0.5856389335240263*b[i + 40*ldb] + -1.072236397422101*b[i + 41*ldb] + -0.3158549142070798*b[i + 42*ldb] + 0.1092563383478909*b[i + 43*ldb] + 0.05850347735875196*b[i + 44*ldb] + -0.05850347735875196*b[i + 65*ldb] + -0.1092563383478909*b[i + 66*ldb] + 0.3158549142070798*b[i + 67*ldb] + 1.072236397422101*b[i + 68*ldb] + 0.5856389335240263*b[i + 69*ldb]);
        c[i + 113*ldc] += (0.05850347735875196*b[i + 40*ldb] + 0.1092563383478909*b[i + 41*ldb] + -0.3158549142070798*b[i + 42*ldb] + -1.072236397422101*b[i + 43*ldb] + -0.5856389335240263*b[i + 44*ldb] + -0.2111687061258069*b[i + 65*ldb] + 0.6143808272731023*b[i + 66*ldb] + 5.454458520792602*b[i + 67*ldb] + 0.6143808272731023*b[i + 68*ldb] + -0.2111687061258069*b[i + 69*ldb]);
        c[i + 114*ldc] += (0.04441552013474293*b[i + 40*ldb] + -0.09218614391798526*b[i + 41*ldb] + -0.2356403269331877*b[i + 42*ldb] + 1.426271532084567*b[i + 43*ldb] + 1.33618960885414*b[i + 44*ldb] + 0.6982350131118888*b[i + 65*ldb] + 5.935183299806961*b[i + 66*ldb] + 0.4050837191937215*b[i + 67*ldb] + -0.2981430049956753*b[i + 68*ldb] + 0.0740478351152375*b[i + 69*ldb]);
        c[i + 115*ldc] += (1.33618960885414*b[i + 40*ldb] + 1.426271532084567*b[i + 41*ldb] + -0.2356403269331877*b[i + 42*ldb] + -0.09218614391798526*b[i + 43*ldb] + 0.04441552013474293*b[i + 44*ldb] + 0.03493992481549068*b[i + 65*ldb] + -0.1054765566754525*b[i + 66*ldb] + -0.7540302351461837*b[i + 67*ldb] + -0.9794109587905273*b[i + 68*ldb] + -0.4379349075782941*b[i + 69*ldb]);
        c[i + 116*ldc] += (-0.6982350131118888*b[i + 40*ldb] + -5.935183299806961*b[i + 41*ldb] + -0.4050837191937215*b[i + 42*ldb] + 0.2981430049956753*b[i + 43*ldb] + -0.0740478351152375*b[i + 44*ldb] + -0.4379349075782941*b[i + 65*ldb] + -0.9794109587905273*b[i + 66*ldb] + -0.7540302351461837*b[i + 67*ldb] + -0.1054765566754525*b[i + 68*ldb] + 0.03493992481549068*b[i + 69*ldb]);
        c[i + 117*ldc] += (-0.0740478351152375*b[i + 40*ldb] + 0.2981430049956753*b[i + 41*ldb] + -0.4050837191937215*b[i + 42*ldb] + -5.935183299806961*b[i + 43*ldb] + -0.6982350131118888*b[i + 44*ldb] + -1.33618960885414*b[i + 65*ldb] + -1.426271532084567*b[i + 66*ldb] + 0.2356403269331877*b[i + 67*ldb] + 0.09218614391798526*b[i + 68*ldb] + -0.04441552013474293*b[i + 69*ldb]);
        c[i + 118*ldc] += (0.4379349075782941*b[i + 40*ldb] + 0.9794109587905273*b[i + 41*ldb] + 0.7540302351461837*b[i + 42*ldb] + 0.1054765566754525*b[i + 43*ldb] + -0.03493992481549068*b[i + 44*ldb] + -0.04441552013474293*b[i + 65*ldb] + 0.09218614391798526*b[i + 66*ldb] + 0.2356403269331877*b[i + 67*ldb] + -1.426271532084567*b[i + 68*ldb] + -1.33618960885414*b[i + 69*ldb]);
        c[i + 119*ldc] += (-0.03493992481549068*b[i + 40*ldb] + 0.1054765566754525*b[i + 41*ldb] + 0.7540302351461837*b[i + 42*ldb] + 0.9794109587905273*b[i + 43*ldb] + 0.4379349075782941*b[i + 44*ldb] + 0.0740478351152375*b[i + 65*ldb] + -0.2981430049956753*b[i + 66*ldb] + 0.4050837191937215*b[i + 67*ldb] + 5.935183299806961*b[i + 68*ldb] + 0.6982350131118888*b[i + 69*ldb]);
        c[i + 120*ldc] += (-0.3766849869423851*b[i + 45*ldb] + -0.9249186854440405*b[i + 46*ldb] + -1.205841535663668*b[i + 47*ldb] + -0.9249186854440405*b[i + 48*ldb] + -0.3766849869423851*b[i + 49*ldb] + -0.03407068760902764*b[i + 70*ldb] + 0.1414709948159384*b[i + 71*ldb] + -0.3732534616347092*b[i + 72*ldb] + 0.5787140289764666*b[i + 73*ldb] + 8.177986284176342*b[i + 74*ldb]);
        c[i + 121*ldc] += (0.03407068760902764*b[i + 45*ldb] + -0.1414709948159384*b[i + 46*ldb] + 0.3732534616347092*b[i + 47*ldb] + -0.5787140289764666*b[i + 48*ldb] + -8.177986284176342*b[i + 49*ldb] + 8.177986284176342*b[i + 70*ldb] + 0.5787140289764666*b[i + 71*ldb] + -0.3732534616347092*b[i + 72*ldb] + 0.1414709948159384*b[i + 73*ldb] + -0.03407068760902764*b[i + 74*ldb]);
        c[i + 122*ldc] += (-8.177986284176342*b[i + 45*ldb] + -0.5787140289764666*b[i + 46*ldb] + 0.3732534616347092*b[i + 47*ldb] + -0.1414709948159384*b[i + 48*ldb] + 0.03407068760902764*b[i + 49*ldb] + 0.3766849869423851*b[i + 70*ldb] + 0.9249186854440405*b[i + 71*ldb] + 1.205841535663668*b[i + 72*ldb] + 0.9249186854440405*b[i + 73*ldb] + 0.3766849869423851*b[i + 74*ldb]);
        c[i + 123*ldc] += (-0.03078013091636318*b[i + 45*ldb] + -0.4044323368695613*b[i + 46*ldb] + -0.9758930126717729*b[i + 47*ldb] + -0.4044323368695613*b[i + 48*ldb] + -0.03078013091636318*b[i + 49*ldb] + 0.1065108706569845*b[i + 70*ldb] + 0.01797338358554743*b[i + 71*ldb] + -1.172900949469982*b[i + 72*ldb] + -1.125310822402669*b[i + 73*ldb] + -0.1520494233293387*b[i + 74*ldb]);
        c[i + 124*ldc] += (-0.1065108706569845*b[i + 45*ldb] + -0.01797338358554743*b[i + 46*ldb] + 1.172900949469982*b[i + 47*ldb] + 1.125310822402669*b[i + 48*ldb] + 0.1520494233293387*b[i + 49*ldb] + -0.1520494233293387*b[i + 70*ldb] + -1.125310822402669*b[i + 71*ldb] + -1.172900949469982*b[i + 72*ldb] + 0.01797338358554743*b[i + 73*ldb] + 0.1065108706569845*b[i + 74*ldb]);
        c[i + 125*ldc] += (0.1520494233293387*b[i + 45*ldb] + 1.125310822402669*b[i + 46*ldb] + 1.172900949469982*b[i + 47*ldb] + -0.01797338358554743*b[i + 48*ldb] + -0.1065108706569845*b[i + 49*ldb] + 0.03078013091636318*b[i + 70*ldb] + 0.4044323368695613*b[i + 71*ldb] + 0.9758930126717729*b[i + 72*ldb] + 0.4044323368695613*b[i + 73*ldb] + 0.03078013091636318*b[i + 74*ldb]);
        c[i + 126*ldc] += (0.2111687061258069*b[i + 45*ldb] + -0.6143808272731023*b[i + 46*ldb] + -5.454458520792602*b[i + 47*ldb] + -0.6143808272731023*b[i + 48*ldb] + 0.2111687061258069*b[i + 49*ldb] + 0.5856389335240263*b[i + 70*ldb] + 1.072236397422101*b[i + 71*ldb] + 0.3158549142070798*b[i + 72*ldb] + -0.1092563383478909*b[i + 73*ldb] + -0.05850347735875196*b[i + 74*ldb]);
        c[i + 127*ldc] += (-0.5856389335240263*b[i + 45*ldb] + -1.072236397422101*b[i + 46*ldb] + -0.3158549142070798*b[i + 47*ldb] + 0.1092563383478909*b[i + 48*ldb] + 0.05850347735875196*b[i + 49*ldb] + -0.05850347735875196*b[i + 70*ldb] + -0.1092563383478909*b[i + 71*ldb] + 0.3158549142070798*b[i + 72*ldb] + 1.072236397422101*b[i + 73*ldb] + 0.5856389335240263*b[i + 74*ldb]);
        c[i + 128*ldc] += (0.05850347735875196*b[i + 45*ldb] + 0.1092563383478909*b[i + 46*ldb] + -0.3158549142070798*b[i + 47*ldb] + -1.072236397422101*b[i + 48*ldb] + -0.5856389335240263*b[i + 49*ldb] + -0.2111687061258069*b[i + 70*ldb] + 0.6143808272731023*b[i + 71*ldb] + 5.454458520792602*b[i + 72*ldb] + 0.6143808272731023*b[i + 73*ldb] + -0.2111687061258069*b[i + 74*ldb]);
        c[i + 129*ldc] += (0.04441552013474293*b[i + 45*ldb] + -0.09218614391798526*b[i + 46*ldb] + -0.2356403269331877*b[i + 47*ldb] + 1.426271532084567*b[i + 48*ldb] + 1.33618960885414*b[i + 49*ldb] + 0.6982350131118888*b[i + 70*ldb] + 5.935183299806961*b[i + 71*ldb] + 0.4050837191937215*b[i + 72*ldb] + -0.2981430049956753*b[i + 73*ldb] + 0.0740478351152375*b[i + 74*ldb]);
        c[i + 130*ldc] += (1.33618960885414*b[i + 45*ldb] + 1.426271532084567*b[i + 46*ldb] + -0.2356403269331877*b[i + 47*ldb] + -0.09218614391798526*b[i + 48*ldb] + 0.04441552013474293*b[i + 49*ldb] + 0.03493992481549068*b[i + 70*ldb] + -0.1054765566754525*b[i + 71*ldb] + -0.7540302351461837*b[i + 72*ldb] + -0.9794109587905273*b[i + 73*ldb] + -0.4379349075782941*b[i + 74*ldb]);
        c[i + 131*ldc] += (-0.6982350131118888*b[i + 45*ldb] + -5.935183299806961*b[i + 46*ldb] + -0.4050837191937215*b[i + 47*ldb] + 0.2981430049956753*b[i + 48*ldb] + -0.0740478351152375*b[i + 49*ldb] + -0.4379349075782941*b[i + 70*ldb] + -0.9794109587905273*b[i + 71*ldb] + -0.7540302351461837*b[i + 72*ldb] + -0.1054765566754525*b[i + 73*ldb] + 0.03493992481549068*b[i + 74*ldb]);
        c[i + 132*ldc] += (-0.0740478351152375*b[i + 45*ldb] + 0.2981430049956753*b[i + 46*ldb] + -0.4050837191937215*b[i + 47*ldb] + -5.935183299806961*b[i + 48*ldb] + -0.6982350131118888*b[i + 49*ldb] + -1.33618960885414*b[i + 70*ldb] + -1.426271532084567*b[i + 71*ldb] + 0.2356403269331877*b[i + 72*ldb] + 0.09218614391798526*b[i + 73*ldb] + -0.04441552013474293*b[i + 74*ldb]);
        c[i + 133*ldc] += (0.4379349075782941*b[i + 45*ldb] + 0.9794109587905273*b[i + 46*ldb] + 0.7540302351461837*b[i + 47*ldb] + 0.1054765566754525*b[i + 48*ldb] + -0.03493992481549068*b[i + 49*ldb] + -0.04441552013474293*b[i + 70*ldb] + 0.09218614391798526*b[i + 71*ldb] + 0.2356403269331877*b[i + 72*ldb] + -1.426271532084567*b[i + 73*ldb] + -1.33618960885414*b[i + 74*ldb]);
        c[i + 134*ldc] += (-0.03493992481549068*b[i + 45*ldb] + 0.1054765566754525*b[i + 46*ldb] + 0.7540302351461837*b[i + 47*ldb] + 0.9794109587905273*b[i + 48*ldb] + 0.4379349075782941*b[i + 49*ldb] + 0.0740478351152375*b[i + 70*ldb] + -0.2981430049956753*b[i + 71*ldb] + 0.4050837191937215*b[i + 72*ldb] + 5.935183299806961*b[i + 73*ldb] + 0.6982350131118888*b[i + 74*ldb]);
        c[i + 135*ldc] += (-0.3766849869423851*b[i + 50*ldb] + -0.9249186854440405*b[i + 51*ldb] + -1.205841535663668*b[i + 52*ldb] + -0.9249186854440405*b[i + 53*ldb] + -0.3766849869423851*b[i + 54*ldb] + -0.03407068760902764*b[i + 75*ldb] + 0.1414709948159384*b[i + 76*ldb] + -0.3732534616347092*b[i + 77*ldb] + 0.5787140289764666*b[i + 78*ldb] + 8.177986284176342*b[i + 79*ldb]);
        c[i + 136*ldc] += (0.03407068760902764*b[i + 50*ldb] + -0.1414709948159384*b[i + 51*ldb] + 0.3732534616347092*b[i + 52*ldb] + -0.5787140289764666*b[i + 53*ldb] + -8.177986284176342*b[i + 54*ldb] + 8.177986284176342*b[i + 75*ldb] + 0.5787140289764666*b[i + 76*ldb] + -0.3732534616347092*b[i + 77*ldb] + 0.1414709948159384*b[i + 78*ldb] + -0.03407068760902764*b[i + 79*ldb]);
        c[i + 137*ldc] += (-8.177986284176342*b[i + 50*ldb] + -0.5787140289764666*b[i + 51*ldb] + 0.3732534616347092*b[i + 52*ldb] + -0.1414709948159384*b[i + 53*ldb] + 0.03407068760902764*b[i + 54*ldb] + 0.3766849869423851*b[i + 75*ldb] + 0.9249186854440405*b[i + 76*ldb] + 1.205841535663668*b[i + 77*ldb] + 0.9249186854440405*b[i + 78*ldb] + 0.3766849869423851*b[i + 79*ldb]);
        c[i + 138*ldc] += (-0.03078013091636318*b[i + 50*ldb] + -0.4044323368695613*b[i + 51*ldb] + -0.9758930126717729*b[i + 52*ldb] + -0.4044323368695613*b[i + 53*ldb] + -0.03078013091636318*b[i + 54*ldb] + 0.1065108706569845*b[i + 75*ldb] + 0.01797338358554743*b[i + 76*ldb] + -1.172900949469982*b[i + 77*ldb] + -1.125310822402669*b[i + 78*ldb] + -0.1520494233293387*b[i + 79*ldb]);
        c[i + 139*ldc] += (-0.1065108706569845*b[i + 50*ldb] + -0.01797338358554743*b[i + 51*ldb] + 1.172900949469982*b[i + 52*ldb] + 1.125310822402669*b[i + 53*ldb] + 0.1520494233293387*b[i + 54*ldb] + -0.1520494233293387*b[i + 75*ldb] + -1.125310822402669*b[i + 76*ldb] + -1.172900949469982*b[i + 77*ldb] + 0.01797338358554743*b[i + 78*ldb] + 0.1065108706569845*b[i + 79*ldb]);
        c[i + 140*ldc] += (0.1520494233293387*b[i + 50*ldb] + 1.125310822402669*b[i + 51*ldb] + 1.172900949469982*b[i + 52*ldb] + -0.01797338358554743*b[i + 53*ldb] + -0.1065108706569845*b[i + 54*ldb] + 0.03078013091636318*b[i + 75*ldb] + 0.4044323368695613*b[i + 76*ldb] + 0.9758930126717729*b[i + 77*ldb] + 0.4044323368695613*b[i + 78*ldb] + 0.03078013091636318*b[i + 79*ldb]);
        c[i + 141*ldc] += (0.2111687061258069*b[i + 50*ldb] + -0.6143808272731023*b[i + 51*ldb] + -5.454458520792602*b[i + 52*ldb] + -0.6143808272731023*b[i + 53*ldb] + 0.2111687061258069*b[i + 54*ldb] + 0.5856389335240263*b[i + 75*ldb] + 1.072236397422101*b[i + 76*ldb] + 0.3158549142070798*b[i + 77*ldb] + -0.1092563383478909*b[i + 78*ldb] + -0.05850347735875196*b[i + 79*ldb]);
        c[i + 142*ldc] += (-0.5856389335240263*b[i + 50*ldb] + -1.072236397422101*b[i + 51*ldb] + -0.3158549142070798*b[i + 52*ldb] + 0.1092563383478909*b[i + 53*ldb] + 0.05850347735875196*b[i + 54*ldb] + -0.05850347735875196*b[i + 75*ldb] + -0.1092563383478909*b[i + 76*ldb] + 0.3158549142070798*b[i + 77*ldb] + 1.072236397422101*b[i + 78*ldb] + 0.5856389335240263*b[i + 79*ldb]);
        c[i + 143*ldc] += (0.05850347735875196*b[i + 50*ldb] + 0.1092563383478909*b[i + 51*ldb] + -0.3158549142070798*b[i + 52*ldb] + -1.072236397422101*b[i + 53*ldb] + -0.5856389335240263*b[i + 54*ldb] + -0.2111687061258069*b[i + 75*ldb] + 0.6143808272731023*b[i + 76*ldb] + 5.454458520792602*b[i + 77*ldb] + 0.6143808272731023*b[i + 78*ldb] + -0.2111687061258069*b[i + 79*ldb]);
        c[i + 144*ldc] += (0.04441552013474293*b[i + 50*ldb] + -0.09218614391798526*b[i + 51*ldb] + -0.2356403269331877*b[i + 52*ldb] + 1.426271532084567*b[i + 53*ldb] + 1.33618960885414*b[i + 54*ldb] + 0.6982350131118888*b[i + 75*ldb] + 5.935183299806961*b[i + 76*ldb] + 0.4050837191937215*b[i + 77*ldb] + -0.2981430049956753*b[i + 78*ldb] + 0.0740478351152375*b[i + 79*ldb]);
        c[i + 145*ldc] += (1.33618960885414*b[i + 50*ldb] + 1.426271532084567*b[i + 51*ldb] + -0.2356403269331877*b[i + 52*ldb] + -0.09218614391798526*b[i + 53*ldb] + 0.04441552013474293*b[i + 54*ldb] + 0.03493992481549068*b[i + 75*ldb] + -0.1054765566754525*b[i + 76*ldb] + -0.7540302351461837*b[i + 77*ldb] + -0.9794109587905273*b[i + 78*ldb] + -0.4379349075782941*b[i + 79*ldb]);
        c[i + 146*ldc] += (-0.6982350131118888*b[i + 50*ldb] + -5.935183299806961*b[i + 51*ldb] + -0.4050837191937215*b[i + 52*ldb] + 0.2981430049956753*b[i + 53*ldb] + -0.0740478351152375*b[i + 54*ldb] + -0.4379349075782941*b[i + 75*ldb] + -0.9794109587905273*b[i + 76*ldb] + -0.7540302351461837*b[i + 77*ldb] + -0.1054765566754525*b[i + 78*ldb] + 0.03493992481549068*b[i + 79*ldb]);
        c[i + 147*ldc] += (-0.0740478351152375*b[i + 50*ldb] + 0.2981430049956753*b[i + 51*ldb] + -0.4050837191937215*b[i + 52*ldb] + -5.935183299806961*b[i + 53*ldb] + -0.6982350131118888*b[i + 54*ldb] + -1.33618960885414*b[i + 75*ldb] + -1.426271532084567*b[i + 76*ldb] + 0.2356403269331877*b[i + 77*ldb] + 0.09218614391798526*b[i + 78*ldb] + -0.04441552013474293*b[i + 79*ldb]);
        c[i + 148*ldc] += (0.4379349075782941*b[i + 50*ldb] + 0.9794109587905273*b[i + 51*ldb] + 0.7540302351461837*b[i + 52*ldb] + 0.1054765566754525*b[i + 53*ldb] + -0.03493992481549068*b[i + 54*ldb] + -0.04441552013474293*b[i + 75*ldb] + 0.09218614391798526*b[i + 76*ldb] + 0.2356403269331877*b[i + 77*ldb] + -1.426271532084567*b[i + 78*ldb] + -1.33618960885414*b[i + 79*ldb]);
        c[i + 149*ldc] += (-0.03493992481549068*b[i + 50*ldb] + 0.1054765566754525*b[i + 51*ldb] + 0.7540302351461837*b[i + 52*ldb] + 0.9794109587905273*b[i + 53*ldb] + 0.4379349075782941*b[i + 54*ldb] + 0.0740478351152375*b[i + 75*ldb] + -0.2981430049956753*b[i + 76*ldb] + 0.4050837191937215*b[i + 77*ldb] + 5.935183299806961*b[i + 78*ldb] + 0.6982350131118888*b[i + 79*ldb]);
        c[i + 150*ldc] += (-6.548045607936747*b[i + 0*ldb] + 0.3222878728081189*b[i + 15*ldb]);
        c[i + 151*ldc] += (-6.548045607936747*b[i + 1*ldb] + 0.3222878728081189*b[i + 16*ldb]);
        c[i + 152*ldc] += (-6.548045607936747*b[i + 2*ldb] + 0.3222878728081189*b[i + 17*ldb]);
        c[i + 153*ldc] += (-6.548045607936747*b[i + 3*ldb] + 0.3222878728081189*b[i + 18*ldb]);
        c[i + 154*ldc] += (-6.548045607936747*b[i + 4*ldb] + 0.3222878728081189*b[i + 19*ldb]);
        c[i + 155*ldc] += (-6.548045607936747*b[i + 5*ldb] + 0.3222878728081189*b[i + 20*ldb]);
        c[i + 156*ldc] += (-6.548045607936747*b[i + 6*ldb] + 0.3222878728081189*b[i + 21*ldb]);
        c[i + 157*ldc] += (-6.548045607936747*b[i + 7*ldb] + 0.3222878728081189*b[i + 22*ldb]);
        c[i + 158*ldc] += (-6.548045607936747*b[i + 8*ldb] + 0.3222878728081189*b[i + 23*ldb]);
        c[i + 159*ldc] += (-6.548045607936747*b[i + 9*ldb] + 0.3222878728081189*b[i + 24*ldb]);
        c[i + 160*ldc] += (-6.548045607936747*b[i + 10*ldb] + 0.3222878728081189*b[i + 25*ldb]);
        c[i + 161*ldc] += (-6.548045607936747*b[i + 11*ldb] + 0.3222878728081189*b[i + 26*ldb]);
        c[i + 162*ldc] += (-6.548045607936747*b[i + 12*ldb] + 0.3222878728081189*b[i + 27*ldb]);
        c[i + 163*ldc] += (-6.548045607936747*b[i + 13*ldb] + 0.3222878728081189*b[i + 28*ldb]);
        c[i + 164*ldc] += (-6.548045607936747*b[i + 14*ldb] + 0.3222878728081189*b[i + 29*ldb]);
        c[i + 165*ldc] += (1.866077916035024*b[i + 0*ldb] + -0.5598111202653964*b[i + 15*ldb]);
        c[i + 166*ldc] += (1.866077916035024*b[i + 1*ldb] + -0.5598111202653964*b[i + 16*ldb]);
        c[i + 167*ldc] += (1.866077916035024*b[i + 2*ldb] + -0.5598111202653964*b[i + 17*ldb]);
        c[i + 168*ldc] += (1.866077916035024*b[i + 3*ldb] + -0.5598111202653964*b[i + 18*ldb]);
        c[i + 169*ldc] += (1.866077916035024*b[i + 4*ldb] + -0.5598111202653964*b[i + 19*ldb]);
        c[i + 170*ldc] += (1.866077916035024*b[i + 5*ldb] + -0.5598111202653964*b[i + 20*ldb]);
        c[i + 171*ldc] += (1.866077916035024*b[i + 6*ldb] + -0.5598111202653964*b[i + 21*ldb]);
        c[i + 172*ldc] += (1.866077916035024*b[i + 7*ldb] + -0.5598111202653964*b[i + 22*ldb]);
        c[i + 173*ldc] += (1.866077916035024*b[i + 8*ldb] + -0.5598111202653964*b[i + 23*ldb]);
        c[i + 174*ldc] += (1.866077916035024*b[i + 9*ldb] + -0.5598111202653964*b[i + 24*ldb]);
        c[i + 175*ldc] += (1.866077916035024*b[i + 10*ldb] + -0.5598111202653964*b[i + 25*ldb]);
        c[i + 176*ldc] += (1.866077916035024*b[i + 11*ldb] + -0.5598111202653964*b[i + 26*ldb]);
        c[i + 177*ldc] += (1.866077916035024*b[i + 12*ldb] + -0.5598111202653964*b[i + 27*ldb]);
        c[i + 178*ldc] += (1.866077916035024*b[i + 13*ldb] + -0.5598111202653964*b[i + 28*ldb]);
        c[i + 179*ldc] += (1.866077916035024*b[i + 14*ldb] + -0.5598111202653964*b[i + 29*ldb]);
        c[i + 180*ldc] += (-0.9375000000000007*b[i + 0*ldb] + 0.9375000000000007*b[i + 15*ldb]);
        c[i + 181*ldc] += (-0.9375000000000007*b[i + 1*ldb] + 0.9375000000000007*b[i + 16*ldb]);
        c[i + 182*ldc] += (-0.9375000000000007*b[i + 2*ldb] + 0.9375000000000007*b[i + 17*ldb]);
        c[i + 183*ldc] += (-0.9375000000000007*b[i + 3*ldb] + 0.9375000000000007*b[i + 18*ldb]);
        c[i + 184*ldc] += (-0.9375000000000007*b[i + 4*ldb] + 0.9375000000000007*b[i + 19*ldb]);
        c[i + 185*ldc] += (-0.9375000000000007*b[i + 5*ldb] + 0.9375000000000007*b[i + 20*ldb]);
        c[i + 186*ldc] += (-0.9375000000000007*b[i + 6*ldb] + 0.9375000000000007*b[i + 21*ldb]);
        c[i + 187*ldc] += (-0.9375000000000007*b[i + 7*ldb] + 0.9375000000000007*b[i + 22*ldb]);
        c[i + 188*ldc] += (-0.9375000000000007*b[i + 8*ldb] + 0.9375000000000007*b[i + 23*ldb]);
        c[i + 189*ldc] += (-0.9375000000000007*b[i + 9*ldb] + 0.9375000000000007*b[i + 24*ldb]);
        c[i + 190*ldc] += (-0.9375000000000007*b[i + 10*ldb] + 0.9375000000000007*b[i + 25*ldb]);
        c[i + 191*ldc] += (-0.9375000000000007*b[i + 11*ldb] + 0.9375000000000007*b[i + 26*ldb]);
        c[i + 192*ldc] += (-0.9375000000000007*b[i + 12*ldb] + 0.9375000000000007*b[i + 27*ldb]);
        c[i + 193*ldc] += (-0.9375000000000007*b[i + 13*ldb] + 0.9375000000000007*b[i + 28*ldb]);
        c[i + 194*ldc] += (-0.9375000000000007*b[i + 14*ldb] + 0.9375000000000007*b[i + 29*ldb]);
        c[i + 195*ldc] += (0.5598111202653964*b[i + 0*ldb] + -1.866077916035024*b[i + 15*ldb]);
        c[i + 196*ldc] += (0.5598111202653964*b[i + 1*ldb] + -1.866077916035024*b[i + 16*ldb]);
        c[i + 197*ldc] += (0.5598111202653964*b[i + 2*ldb] + -1.866077916035024*b[i + 17*ldb]);
        c[i + 198*ldc] += (0.5598111202653964*b[i + 3*ldb] + -1.866077916035024*b[i + 18*ldb]);
        c[i + 199*ldc] += (0.5598111202653964*b[i + 4*ldb] + -1.866077916035024*b[i + 19*ldb]);
        c[i + 200*ldc] += (0.5598111202653964*b[i + 5*ldb] + -1.866077916035024*b[i + 20*ldb]);
        c[i + 201*ldc] += (0.5598111202653964*b[i + 6*ldb] + -1.866077916035024*b[i + 21*ldb]);
        c[i + 202*ldc] += (0.5598111202653964*b[i + 7*ldb] + -1.866077916035024*b[i + 22*ldb]);
        c[i + 203*ldc] += (0.5598111202653964*b[i + 8*ldb] + -1.866077916035024*b[i + 23*ldb]);
        c[i + 204*ldc] += (0.5598111202653964*b[i + 9*ldb] + -1.866077916035024*b[i + 24*ldb]);
        c[i + 205*ldc] += (0.5598111202653964*b[i + 10*ldb] + -1.866077916035024*b[i + 25*ldb]);
        c[i + 206*ldc] += (0.5598111202653964*b[i + 11*ldb] + -1.866077916035024*b[i + 26*ldb]);
        c[i + 207*ldc] += (0.5598111202653964*b[i + 12*ldb] + -1.866077916035024*b[i + 27*ldb]);
        c[i + 208*ldc] += (0.5598111202653964*b[i + 13*ldb] + -1.866077916035024*b[i + 28*ldb]);
        c[i + 209*ldc] += (0.5598111202653964*b[i + 14*ldb] + -1.866077916035024*b[i + 29*ldb]);
        c[i + 210*ldc] += (-0.3222878728081189*b[i + 0*ldb] + 6.548045607936747*b[i + 15*ldb]);
        c[i + 211*ldc] += (-0.3222878728081189*b[i + 1*ldb] + 6.548045607936747*b[i + 16*ldb]);
        c[i + 212*ldc] += (-0.3222878728081189*b[i + 2*ldb] + 6.548045607936747*b[i + 17*ldb]);
        c[i + 213*ldc] += (-0.3222878728081189*b[i + 3*ldb] + 6.548045607936747*b[i + 18*ldb]);
        c[i + 214*ldc] += (-0.3222878728081189*b[i + 4*ldb] + 6.548045607936747*b[i + 19*ldb]);
        c[i + 215*ldc] += (-0.3222878728081189*b[i + 5*ldb] + 6.548045607936747*b[i + 20*ldb]);
        c[i + 216*ldc] += (-0.3222878728081189*b[i + 6*ldb] + 6.548045607936747*b[i + 21*ldb]);
        c[i + 217*ldc] += (-0.3222878728081189*b[i + 7*ldb] + 6.548045607936747*b[i + 22*ldb]);
        c[i + 218*ldc] += (-0.3222878728081189*b[i + 8*ldb] + 6.548045607936747*b[i + 23*ldb]);
        c[i + 219*ldc] += (-0.3222878728081189*b[i + 9*ldb] + 6.548045607936747*b[i + 24*ldb]);
        c[i + 220*ldc] += (-0.3222878728081189*b[i + 10*ldb] + 6.548045607936747*b[i + 25*ldb]);
        c[i + 221*ldc] += (-0.3222878728081189*b[i + 11*ldb] + 6.548045607936747*b[i + 26*ldb]);
        c[i + 222*ldc] += (-0.3222878728081189*b[i + 12*ldb] + 6.548045607936747*b[i + 27*ldb]);
        c[i + 223*ldc] += (-0.3222878728081189*b[i + 13*ldb] + 6.548045607936747*b[i + 28*ldb]);
        c[i + 224*ldc] += (-0.3222878728081189*b[i + 14*ldb] + 6.548045607936747*b[i + 29*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_pri_m460(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (0.01666240169962252*b[i + 1*ldb] + -0.01666240169962252*b[i + 2*ldb] + -0.06412597883381979*b[i + 4*ldb] + 0.06412597883381979*b[i + 5*ldb] + -0.2284464562720814*b[i + 7*ldb] + 0.2284464562720814*b[i + 8*ldb] + -0.0809696560654336*b[i + 9*ldb] + 0.0809696560654336*b[i + 10*ldb] + -0.01902826490985636*b[i + 11*ldb] + 0.01902826490985636*b[i + 12*ldb] + -0.2968235823045307*b[i + 13*ldb] + 0.2968235823045307*b[i + 14*ldb]);
        c[i + 1*ldc] = (0.5320310574554866*b[i + 0*ldb] + -4.943623329974175*b[i + 1*ldb] + 0.5153686557558634*b[i + 2*ldb] + -1.668497037618385*b[i + 3*ldb] + 2.118084753790551*b[i + 4*ldb] + -1.604371058784565*b[i + 5*ldb] + 1.189090704074046*b[i + 6*ldb] + 2.136333242112812*b[i + 7*ldb] + 1.417537160346129*b[i + 8*ldb] + -2.877453657493225*b[i + 9*ldb] + 1.526761453986784*b[i + 10*ldb] + -0.6568015224866337*b[i + 11*ldb] + -3.174277239797759*b[i + 12*ldb] + 1.545789718896642*b[i + 13*ldb] + -0.7377711785520655*b[i + 14*ldb]);
        c[i + 2*ldc] = (-0.5320310574554866*b[i + 0*ldb] + -0.5153686557558634*b[i + 1*ldb] + 4.943623329974175*b[i + 2*ldb] + 1.668497037618385*b[i + 3*ldb] + 1.604371058784565*b[i + 4*ldb] + -2.118084753790551*b[i + 5*ldb] + -1.189090704074046*b[i + 6*ldb] + -1.417537160346129*b[i + 7*ldb] + -2.136333242112812*b[i + 8*ldb] + -1.526761453986784*b[i + 9*ldb] + 2.877453657493225*b[i + 10*ldb] + 3.174277239797759*b[i + 11*ldb] + 0.6568015224866337*b[i + 12*ldb] + 0.7377711785520655*b[i + 13*ldb] + -1.545789718896642*b[i + 14*ldb]);
        c[i + 3*ldc] = (-0.0832386718891518*b[i + 1*ldb] + 0.0832386718891518*b[i + 2*ldb] + 0.1767047850928541*b[i + 4*ldb] + -0.1767047850928541*b[i + 5*ldb] + -2.508033750268638*b[i + 7*ldb] + 2.508033750268638*b[i + 8*ldb] + -0.2525315576529422*b[i + 9*ldb] + 0.2525315576529422*b[i + 10*ldb] + -0.03160100937678251*b[i + 11*ldb] + 0.03160100937678251*b[i + 12*ldb] + -2.356239812122482*b[i + 13*ldb] + 2.356239812122482*b[i + 14*ldb]);
        c[i + 4*ldc] = (-0.1031803103571685*b[i + 0*ldb] + 0.04609417395922302*b[i + 1*ldb] + -0.01994163846801661*b[i + 2*ldb] + -1.492300533375874*b[i + 3*ldb] + -0.3632813123758165*b[i + 4*ldb] + -1.669005318468729*b[i + 5*ldb] + -0.119528214542479*b[i + 6*ldb] + 1.730263001372271*b[i + 7*ldb] + 2.388505535726159*b[i + 8*ldb] + 2.365427409367463*b[i + 9*ldb] + 0.7288527548607495*b[i + 10*ldb] + 0.08153976883786418*b[i + 11*ldb] + 0.009187597244981638*b[i + 12*ldb] + 0.7604537642375322*b[i + 13*ldb] + -0.1709917888150785*b[i + 14*ldb]);
        c[i + 5*ldc] = (0.1031803103571685*b[i + 0*ldb] + 0.01994163846801661*b[i + 1*ldb] + -0.04609417395922302*b[i + 2*ldb] + 1.492300533375874*b[i + 3*ldb] + 1.669005318468729*b[i + 4*ldb] + 0.3632813123758165*b[i + 5*ldb] + 0.119528214542479*b[i + 6*ldb] + -2.388505535726159*b[i + 7*ldb] + -1.730263001372271*b[i + 8*ldb] + -0.7288527548607495*b[i + 9*ldb] + -2.365427409367463*b[i + 10*ldb] + -0.009187597244981638*b[i + 11*ldb] + -0.08153976883786418*b[i + 12*ldb] + 0.1709917888150785*b[i + 13*ldb] + -0.7604537642375322*b[i + 14*ldb]);
        c[i + 6*ldc] = (-0.9213245156088653*b[i + 1*ldb] + 0.9213245156088653*b[i + 2*ldb] + 1.478053430463056*b[i + 4*ldb] + -1.478053430463056*b[i + 5*ldb] + 0.657627957956578*b[i + 7*ldb] + -0.657627957956578*b[i + 8*ldb] + -1.844372618022506*b[i + 9*ldb] + 1.844372618022506*b[i + 10*ldb] + -1.70239108991215*b[i + 11*ldb] + 1.70239108991215*b[i + 12*ldb] + -0.2828454530477449*b[i + 13*ldb] + 0.2828454530477449*b[i + 14*ldb]);
        c[i + 7*ldc] = (-1.063952765527867*b[i + 0*ldb] + 0.04922131659554296*b[i + 1*ldb] + -0.1426282499190014*b[i + 2*ldb] + 1.892059090254097*b[i + 3*ldb] + -0.2449733459341608*b[i + 4*ldb] + 0.4140056597910398*b[i + 5*ldb] + 0.01268686934620999*b[i + 6*ldb] + 3.824491607376837*b[i + 7*ldb] + -0.6449410886103684*b[i + 8*ldb] + 0.2548046964372861*b[i + 9*ldb] + 0.1863127236068944*b[i + 10*ldb] + -0.04923230933097847*b[i + 11*ldb] + -0.02804075661045902*b[i + 12*ldb] + 1.888703813519044*b[i + 13*ldb] + -1.893604927353485*b[i + 14*ldb]);
        c[i + 8*ldc] = (1.063952765527867*b[i + 0*ldb] + 0.1426282499190014*b[i + 1*ldb] + -0.04922131659554296*b[i + 2*ldb] + -1.892059090254097*b[i + 3*ldb] + -0.4140056597910398*b[i + 4*ldb] + 0.2449733459341608*b[i + 5*ldb] + -0.01268686934620999*b[i + 6*ldb] + 0.6449410886103684*b[i + 7*ldb] + -3.824491607376837*b[i + 8*ldb] + -0.1863127236068944*b[i + 9*ldb] + -0.2548046964372861*b[i + 10*ldb] + 0.02804075661045902*b[i + 11*ldb] + 0.04923230933097847*b[i + 12*ldb] + 1.893604927353485*b[i + 13*ldb] + -1.888703813519044*b[i + 14*ldb]);
        c[i + 9*ldc] = (-0.6700089687429422*b[i + 0*ldb] + -0.3382891868158406*b[i + 1*ldb] + 0.07381136587329767*b[i + 2*ldb] + 1.547856590176338*b[i + 3*ldb] + -2.110251502449065*b[i + 4*ldb] + 0.6449271066413235*b[i + 5*ldb] + 0.1536175324542066*b[i + 6*ldb] + -1.335288332277977*b[i + 7*ldb] + -1.896047521200515*b[i + 8*ldb] + -4.031390515234344*b[i + 9*ldb] + -0.1712431320875245*b[i + 10*ldb] + -0.1241305557641109*b[i + 11*ldb] + -0.209949353949926*b[i + 12*ldb] + -1.687561521519859*b[i + 13*ldb] + 1.09762839928984*b[i + 14*ldb]);
        c[i + 10*ldc] = (0.6700089687429422*b[i + 0*ldb] + -0.07381136587329767*b[i + 1*ldb] + 0.3382891868158406*b[i + 2*ldb] + -1.547856590176338*b[i + 3*ldb] + -0.6449271066413235*b[i + 4*ldb] + 2.110251502449065*b[i + 5*ldb] + -0.1536175324542066*b[i + 6*ldb] + 1.896047521200515*b[i + 7*ldb] + 1.335288332277977*b[i + 8*ldb] + 0.1712431320875245*b[i + 9*ldb] + 4.031390515234344*b[i + 10*ldb] + 0.209949353949926*b[i + 11*ldb] + 0.1241305557641109*b[i + 12*ldb] + -1.09762839928984*b[i + 13*ldb] + 1.687561521519859*b[i + 14*ldb]);
        c[i + 11*ldc] = (-0.1068368224642844*b[i + 0*ldb] + 0.6255688165573523*b[i + 1*ldb] + -2.583413129926359*b[i + 2*ldb] + -0.6619114463571192*b[i + 3*ldb] + -1.477330712695793*b[i + 4*ldb] + 1.546200852363405*b[i + 5*ldb] + 1.91592718061395*b[i + 6*ldb] + 0.3742866353879682*b[i + 7*ldb] + 1.355641220983662*b[i + 8*ldb] + 1.639898802233694*b[i + 9*ldb] + -2.755439543527363*b[i + 10*ldb] + 0.4497931998799397*b[i + 11*ldb] + -0.8886523802884596*b[i + 12*ldb] + 0.1700384034174278*b[i + 13*ldb] + 0.1590914669746716*b[i + 14*ldb]);
        c[i + 12*ldc] = (0.1068368224642844*b[i + 0*ldb] + 2.583413129926359*b[i + 1*ldb] + -0.6255688165573523*b[i + 2*ldb] + 0.6619114463571192*b[i + 3*ldb] + -1.546200852363405*b[i + 4*ldb] + 1.477330712695793*b[i + 5*ldb] + -1.91592718061395*b[i + 6*ldb] + -1.355641220983662*b[i + 7*ldb] + -0.3742866353879682*b[i + 8*ldb] + 2.755439543527363*b[i + 9*ldb] + -1.639898802233694*b[i + 10*ldb] + 0.8886523802884596*b[i + 11*ldb] + -0.4497931998799397*b[i + 12*ldb] + -0.1590914669746716*b[i + 13*ldb] + -0.1700384034174278*b[i + 14*ldb]);
        c[i + 13*ldc] = (2.9217023167422*b[i + 0*ldb] + 0.03302545659098766*b[i + 1*ldb] + 0.04444015218558958*b[i + 2*ldb] + 0.564050650085659*b[i + 3*ldb] + 0.01698433971579627*b[i + 4*ldb] + -0.07052587748054273*b[i + 5*ldb] + -0.02035288870568681*b[i + 6*ldb] + -0.01987965941343628*b[i + 7*ldb] + -0.5279041678421734*b[i + 8*ldb] + -0.0459078476533179*b[i + 9*ldb] + -0.2089760190013807*b[i + 10*ldb] + 0.04766271928616608*b[i + 11*ldb] + 0.01215166511285262*b[i + 12*ldb] + 3.581597315354408*b[i + 13*ldb] + 2.965388897477289*b[i + 14*ldb]);
        c[i + 14*ldc] = (-2.9217023167422*b[i + 0*ldb] + -0.04444015218558958*b[i + 1*ldb] + -0.03302545659098766*b[i + 2*ldb] + -0.564050650085659*b[i + 3*ldb] + 0.07052587748054273*b[i + 4*ldb] + -0.01698433971579627*b[i + 5*ldb] + 0.02035288870568681*b[i + 6*ldb] + 0.5279041678421734*b[i + 7*ldb] + 0.01987965941343628*b[i + 8*ldb] + 0.2089760190013807*b[i + 9*ldb] + 0.0459078476533179*b[i + 10*ldb] + -0.01215166511285262*b[i + 11*ldb] + -0.04766271928616608*b[i + 12*ldb] + -2.965388897477289*b[i + 13*ldb] + -3.581597315354408*b[i + 14*ldb]);
        c[i + 15*ldc] = (0.01666240169962252*b[i + 16*ldb] + -0.01666240169962252*b[i + 17*ldb] + -0.06412597883381979*b[i + 19*ldb] + 0.06412597883381979*b[i + 20*ldb] + -0.2284464562720814*b[i + 22*ldb] + 0.2284464562720814*b[i + 23*ldb] + -0.0809696560654336*b[i + 24*ldb] + 0.0809696560654336*b[i + 25*ldb] + -0.01902826490985636*b[i + 26*ldb] + 0.01902826490985636*b[i + 27*ldb] + -0.2968235823045307*b[i + 28*ldb] + 0.2968235823045307*b[i + 29*ldb]);
        c[i + 16*ldc] = (0.5320310574554866*b[i + 15*ldb] + -4.943623329974175*b[i + 16*ldb] + 0.5153686557558634*b[i + 17*ldb] + -1.668497037618385*b[i + 18*ldb] + 2.118084753790551*b[i + 19*ldb] + -1.604371058784565*b[i + 20*ldb] + 1.189090704074046*b[i + 21*ldb] + 2.136333242112812*b[i + 22*ldb] + 1.417537160346129*b[i + 23*ldb] + -2.877453657493225*b[i + 24*ldb] + 1.526761453986784*b[i + 25*ldb] + -0.6568015224866337*b[i + 26*ldb] + -3.174277239797759*b[i + 27*ldb] + 1.545789718896642*b[i + 28*ldb] + -0.7377711785520655*b[i + 29*ldb]);
        c[i + 17*ldc] = (-0.5320310574554866*b[i + 15*ldb] + -0.5153686557558634*b[i + 16*ldb] + 4.943623329974175*b[i + 17*ldb] + 1.668497037618385*b[i + 18*ldb] + 1.604371058784565*b[i + 19*ldb] + -2.118084753790551*b[i + 20*ldb] + -1.189090704074046*b[i + 21*ldb] + -1.417537160346129*b[i + 22*ldb] + -2.136333242112812*b[i + 23*ldb] + -1.526761453986784*b[i + 24*ldb] + 2.877453657493225*b[i + 25*ldb] + 3.174277239797759*b[i + 26*ldb] + 0.6568015224866337*b[i + 27*ldb] + 0.7377711785520655*b[i + 28*ldb] + -1.545789718896642*b[i + 29*ldb]);
        c[i + 18*ldc] = (-0.0832386718891518*b[i + 16*ldb] + 0.0832386718891518*b[i + 17*ldb] + 0.1767047850928541*b[i + 19*ldb] + -0.1767047850928541*b[i + 20*ldb] + -2.508033750268638*b[i + 22*ldb] + 2.508033750268638*b[i + 23*ldb] + -0.2525315576529422*b[i + 24*ldb] + 0.2525315576529422*b[i + 25*ldb] + -0.03160100937678251*b[i + 26*ldb] + 0.03160100937678251*b[i + 27*ldb] + -2.356239812122482*b[i + 28*ldb] + 2.356239812122482*b[i + 29*ldb]);
        c[i + 19*ldc] = (-0.1031803103571685*b[i + 15*ldb] + 0.04609417395922302*b[i + 16*ldb] + -0.01994163846801661*b[i + 17*ldb] + -1.492300533375874*b[i + 18*ldb] + -0.3632813123758165*b[i + 19*ldb] + -1.669005318468729*b[i + 20*ldb] + -0.119528214542479*b[i + 21*ldb] + 1.730263001372271*b[i + 22*ldb] + 2.388505535726159*b[i + 23*ldb] + 2.365427409367463*b[i + 24*ldb] + 0.7288527548607495*b[i + 25*ldb] + 0.08153976883786418*b[i + 26*ldb] + 0.009187597244981638*b[i + 27*ldb] + 0.7604537642375322*b[i + 28*ldb] + -0.1709917888150785*b[i + 29*ldb]);
        c[i + 20*ldc] = (0.1031803103571685*b[i + 15*ldb] + 0.01994163846801661*b[i + 16*ldb] + -0.04609417395922302*b[i + 17*ldb] + 1.492300533375874*b[i + 18*ldb] + 1.669005318468729*b[i + 19*ldb] + 0.3632813123758165*b[i + 20*ldb] + 0.119528214542479*b[i + 21*ldb] + -2.388505535726159*b[i + 22*ldb] + -1.730263001372271*b[i + 23*ldb] + -0.7288527548607495*b[i + 24*ldb] + -2.365427409367463*b[i + 25*ldb] + -0.009187597244981638*b[i + 26*ldb] + -0.08153976883786418*b[i + 27*ldb] + 0.1709917888150785*b[i + 28*ldb] + -0.7604537642375322*b[i + 29*ldb]);
        c[i + 21*ldc] = (-0.9213245156088653*b[i + 16*ldb] + 0.9213245156088653*b[i + 17*ldb] + 1.478053430463056*b[i + 19*ldb] + -1.478053430463056*b[i + 20*ldb] + 0.657627957956578*b[i + 22*ldb] + -0.657627957956578*b[i + 23*ldb] + -1.844372618022506*b[i + 24*ldb] + 1.844372618022506*b[i + 25*ldb] + -1.70239108991215*b[i + 26*ldb] + 1.70239108991215*b[i + 27*ldb] + -0.2828454530477449*b[i + 28*ldb] + 0.2828454530477449*b[i + 29*ldb]);
        c[i + 22*ldc] = (-1.063952765527867*b[i + 15*ldb] + 0.04922131659554296*b[i + 16*ldb] + -0.1426282499190014*b[i + 17*ldb] + 1.892059090254097*b[i + 18*ldb] + -0.2449733459341608*b[i + 19*ldb] + 0.4140056597910398*b[i + 20*ldb] + 0.01268686934620999*b[i + 21*ldb] + 3.824491607376837*b[i + 22*ldb] + -0.6449410886103684*b[i + 23*ldb] + 0.2548046964372861*b[i + 24*ldb] + 0.1863127236068944*b[i + 25*ldb] + -0.04923230933097847*b[i + 26*ldb] + -0.02804075661045902*b[i + 27*ldb] + 1.888703813519044*b[i + 28*ldb] + -1.893604927353485*b[i + 29*ldb]);
        c[i + 23*ldc] = (1.063952765527867*b[i + 15*ldb] + 0.1426282499190014*b[i + 16*ldb] + -0.04922131659554296*b[i + 17*ldb] + -1.892059090254097*b[i + 18*ldb] + -0.4140056597910398*b[i + 19*ldb] + 0.2449733459341608*b[i + 20*ldb] + -0.01268686934620999*b[i + 21*ldb] + 0.6449410886103684*b[i + 22*ldb] + -3.824491607376837*b[i + 23*ldb] + -0.1863127236068944*b[i + 24*ldb] + -0.2548046964372861*b[i + 25*ldb] + 0.02804075661045902*b[i + 26*ldb] + 0.04923230933097847*b[i + 27*ldb] + 1.893604927353485*b[i + 28*ldb] + -1.888703813519044*b[i + 29*ldb]);
        c[i + 24*ldc] = (-0.6700089687429422*b[i + 15*ldb] + -0.3382891868158406*b[i + 16*ldb] + 0.07381136587329767*b[i + 17*ldb] + 1.547856590176338*b[i + 18*ldb] + -2.110251502449065*b[i + 19*ldb] + 0.6449271066413235*b[i + 20*ldb] + 0.1536175324542066*b[i + 21*ldb] + -1.335288332277977*b[i + 22*ldb] + -1.896047521200515*b[i + 23*ldb] + -4.031390515234344*b[i + 24*ldb] + -0.1712431320875245*b[i + 25*ldb] + -0.1241305557641109*b[i + 26*ldb] + -0.209949353949926*b[i + 27*ldb] + -1.687561521519859*b[i + 28*ldb] + 1.09762839928984*b[i + 29*ldb]);
        c[i + 25*ldc] = (0.6700089687429422*b[i + 15*ldb] + -0.07381136587329767*b[i + 16*ldb] + 0.3382891868158406*b[i + 17*ldb] + -1.547856590176338*b[i + 18*ldb] + -0.6449271066413235*b[i + 19*ldb] + 2.110251502449065*b[i + 20*ldb] + -0.1536175324542066*b[i + 21*ldb] + 1.896047521200515*b[i + 22*ldb] + 1.335288332277977*b[i + 23*ldb] + 0.1712431320875245*b[i + 24*ldb] + 4.031390515234344*b[i + 25*ldb] + 0.209949353949926*b[i + 26*ldb] + 0.1241305557641109*b[i + 27*ldb] + -1.09762839928984*b[i + 28*ldb] + 1.687561521519859*b[i + 29*ldb]);
        c[i + 26*ldc] = (-0.1068368224642844*b[i + 15*ldb] + 0.6255688165573523*b[i + 16*ldb] + -2.583413129926359*b[i + 17*ldb] + -0.6619114463571192*b[i + 18*ldb] + -1.477330712695793*b[i + 19*ldb] + 1.546200852363405*b[i + 20*ldb] + 1.91592718061395*b[i + 21*ldb] + 0.3742866353879682*b[i + 22*ldb] + 1.355641220983662*b[i + 23*ldb] + 1.639898802233694*b[i + 24*ldb] + -2.755439543527363*b[i + 25*ldb] + 0.4497931998799397*b[i + 26*ldb] + -0.8886523802884596*b[i + 27*ldb] + 0.1700384034174278*b[i + 28*ldb] + 0.1590914669746716*b[i + 29*ldb]);
        c[i + 27*ldc] = (0.1068368224642844*b[i + 15*ldb] + 2.583413129926359*b[i + 16*ldb] + -0.6255688165573523*b[i + 17*ldb] + 0.6619114463571192*b[i + 18*ldb] + -1.546200852363405*b[i + 19*ldb] + 1.477330712695793*b[i + 20*ldb] + -1.91592718061395*b[i + 21*ldb] + -1.355641220983662*b[i + 22*ldb] + -0.3742866353879682*b[i + 23*ldb] + 2.755439543527363*b[i + 24*ldb] + -1.639898802233694*b[i + 25*ldb] + 0.8886523802884596*b[i + 26*ldb] + -0.4497931998799397*b[i + 27*ldb] + -0.1590914669746716*b[i + 28*ldb] + -0.1700384034174278*b[i + 29*ldb]);
        c[i + 28*ldc] = (2.9217023167422*b[i + 15*ldb] + 0.03302545659098766*b[i + 16*ldb] + 0.04444015218558958*b[i + 17*ldb] + 0.564050650085659*b[i + 18*ldb] + 0.01698433971579627*b[i + 19*ldb] + -0.07052587748054273*b[i + 20*ldb] + -0.02035288870568681*b[i + 21*ldb] + -0.01987965941343628*b[i + 22*ldb] + -0.5279041678421734*b[i + 23*ldb] + -0.0459078476533179*b[i + 24*ldb] + -0.2089760190013807*b[i + 25*ldb] + 0.04766271928616608*b[i + 26*ldb] + 0.01215166511285262*b[i + 27*ldb] + 3.581597315354408*b[i + 28*ldb] + 2.965388897477289*b[i + 29*ldb]);
        c[i + 29*ldc] = (-2.9217023167422*b[i + 15*ldb] + -0.04444015218558958*b[i + 16*ldb] + -0.03302545659098766*b[i + 17*ldb] + -0.564050650085659*b[i + 18*ldb] + 0.07052587748054273*b[i + 19*ldb] + -0.01698433971579627*b[i + 20*ldb] + 0.02035288870568681*b[i + 21*ldb] + 0.5279041678421734*b[i + 22*ldb] + 0.01987965941343628*b[i + 23*ldb] + 0.2089760190013807*b[i + 24*ldb] + 0.0459078476533179*b[i + 25*ldb] + -0.01215166511285262*b[i + 26*ldb] + -0.04766271928616608*b[i + 27*ldb] + -2.965388897477289*b[i + 28*ldb] + -3.581597315354408*b[i + 29*ldb]);
        c[i + 30*ldc] = (0.01666240169962252*b[i + 31*ldb] + -0.01666240169962252*b[i + 32*ldb] + -0.06412597883381979*b[i + 34*ldb] + 0.06412597883381979*b[i + 35*ldb] + -0.2284464562720814*b[i + 37*ldb] + 0.2284464562720814*b[i + 38*ldb] + -0.0809696560654336*b[i + 39*ldb] + 0.0809696560654336*b[i + 40*ldb] + -0.01902826490985636*b[i + 41*ldb] + 0.01902826490985636*b[i + 42*ldb] + -0.2968235823045307*b[i + 43*ldb] + 0.2968235823045307*b[i + 44*ldb]);
        c[i + 31*ldc] = (0.5320310574554866*b[i + 30*ldb] + -4.943623329974175*b[i + 31*ldb] + 0.5153686557558634*b[i + 32*ldb] + -1.668497037618385*b[i + 33*ldb] + 2.118084753790551*b[i + 34*ldb] + -1.604371058784565*b[i + 35*ldb] + 1.189090704074046*b[i + 36*ldb] + 2.136333242112812*b[i + 37*ldb] + 1.417537160346129*b[i + 38*ldb] + -2.877453657493225*b[i + 39*ldb] + 1.526761453986784*b[i + 40*ldb] + -0.6568015224866337*b[i + 41*ldb] + -3.174277239797759*b[i + 42*ldb] + 1.545789718896642*b[i + 43*ldb] + -0.7377711785520655*b[i + 44*ldb]);
        c[i + 32*ldc] = (-0.5320310574554866*b[i + 30*ldb] + -0.5153686557558634*b[i + 31*ldb] + 4.943623329974175*b[i + 32*ldb] + 1.668497037618385*b[i + 33*ldb] + 1.604371058784565*b[i + 34*ldb] + -2.118084753790551*b[i + 35*ldb] + -1.189090704074046*b[i + 36*ldb] + -1.417537160346129*b[i + 37*ldb] + -2.136333242112812*b[i + 38*ldb] + -1.526761453986784*b[i + 39*ldb] + 2.877453657493225*b[i + 40*ldb] + 3.174277239797759*b[i + 41*ldb] + 0.6568015224866337*b[i + 42*ldb] + 0.7377711785520655*b[i + 43*ldb] + -1.545789718896642*b[i + 44*ldb]);
        c[i + 33*ldc] = (-0.0832386718891518*b[i + 31*ldb] + 0.0832386718891518*b[i + 32*ldb] + 0.1767047850928541*b[i + 34*ldb] + -0.1767047850928541*b[i + 35*ldb] + -2.508033750268638*b[i + 37*ldb] + 2.508033750268638*b[i + 38*ldb] + -0.2525315576529422*b[i + 39*ldb] + 0.2525315576529422*b[i + 40*ldb] + -0.03160100937678251*b[i + 41*ldb] + 0.03160100937678251*b[i + 42*ldb] + -2.356239812122482*b[i + 43*ldb] + 2.356239812122482*b[i + 44*ldb]);
        c[i + 34*ldc] = (-0.1031803103571685*b[i + 30*ldb] + 0.04609417395922302*b[i + 31*ldb] + -0.01994163846801661*b[i + 32*ldb] + -1.492300533375874*b[i + 33*ldb] + -0.3632813123758165*b[i + 34*ldb] + -1.669005318468729*b[i + 35*ldb] + -0.119528214542479*b[i + 36*ldb] + 1.730263001372271*b[i + 37*ldb] + 2.388505535726159*b[i + 38*ldb] + 2.365427409367463*b[i + 39*ldb] + 0.7288527548607495*b[i + 40*ldb] + 0.08153976883786418*b[i + 41*ldb] + 0.009187597244981638*b[i + 42*ldb] + 0.7604537642375322*b[i + 43*ldb] + -0.1709917888150785*b[i + 44*ldb]);
        c[i + 35*ldc] = (0.1031803103571685*b[i + 30*ldb] + 0.01994163846801661*b[i + 31*ldb] + -0.04609417395922302*b[i + 32*ldb] + 1.492300533375874*b[i + 33*ldb] + 1.669005318468729*b[i + 34*ldb] + 0.3632813123758165*b[i + 35*ldb] + 0.119528214542479*b[i + 36*ldb] + -2.388505535726159*b[i + 37*ldb] + -1.730263001372271*b[i + 38*ldb] + -0.7288527548607495*b[i + 39*ldb] + -2.365427409367463*b[i + 40*ldb] + -0.009187597244981638*b[i + 41*ldb] + -0.08153976883786418*b[i + 42*ldb] + 0.1709917888150785*b[i + 43*ldb] + -0.7604537642375322*b[i + 44*ldb]);
        c[i + 36*ldc] = (-0.9213245156088653*b[i + 31*ldb] + 0.9213245156088653*b[i + 32*ldb] + 1.478053430463056*b[i + 34*ldb] + -1.478053430463056*b[i + 35*ldb] + 0.657627957956578*b[i + 37*ldb] + -0.657627957956578*b[i + 38*ldb] + -1.844372618022506*b[i + 39*ldb] + 1.844372618022506*b[i + 40*ldb] + -1.70239108991215*b[i + 41*ldb] + 1.70239108991215*b[i + 42*ldb] + -0.2828454530477449*b[i + 43*ldb] + 0.2828454530477449*b[i + 44*ldb]);
        c[i + 37*ldc] = (-1.063952765527867*b[i + 30*ldb] + 0.04922131659554296*b[i + 31*ldb] + -0.1426282499190014*b[i + 32*ldb] + 1.892059090254097*b[i + 33*ldb] + -0.2449733459341608*b[i + 34*ldb] + 0.4140056597910398*b[i + 35*ldb] + 0.01268686934620999*b[i + 36*ldb] + 3.824491607376837*b[i + 37*ldb] + -0.6449410886103684*b[i + 38*ldb] + 0.2548046964372861*b[i + 39*ldb] + 0.1863127236068944*b[i + 40*ldb] + -0.04923230933097847*b[i + 41*ldb] + -0.02804075661045902*b[i + 42*ldb] + 1.888703813519044*b[i + 43*ldb] + -1.893604927353485*b[i + 44*ldb]);
        c[i + 38*ldc] = (1.063952765527867*b[i + 30*ldb] + 0.1426282499190014*b[i + 31*ldb] + -0.04922131659554296*b[i + 32*ldb] + -1.892059090254097*b[i + 33*ldb] + -0.4140056597910398*b[i + 34*ldb] + 0.2449733459341608*b[i + 35*ldb] + -0.01268686934620999*b[i + 36*ldb] + 0.6449410886103684*b[i + 37*ldb] + -3.824491607376837*b[i + 38*ldb] + -0.1863127236068944*b[i + 39*ldb] + -0.2548046964372861*b[i + 40*ldb] + 0.02804075661045902*b[i + 41*ldb] + 0.04923230933097847*b[i + 42*ldb] + 1.893604927353485*b[i + 43*ldb] + -1.888703813519044*b[i + 44*ldb]);
        c[i + 39*ldc] = (-0.6700089687429422*b[i + 30*ldb] + -0.3382891868158406*b[i + 31*ldb] + 0.07381136587329767*b[i + 32*ldb] + 1.547856590176338*b[i + 33*ldb] + -2.110251502449065*b[i + 34*ldb] + 0.6449271066413235*b[i + 35*ldb] + 0.1536175324542066*b[i + 36*ldb] + -1.335288332277977*b[i + 37*ldb] + -1.896047521200515*b[i + 38*ldb] + -4.031390515234344*b[i + 39*ldb] + -0.1712431320875245*b[i + 40*ldb] + -0.1241305557641109*b[i + 41*ldb] + -0.209949353949926*b[i + 42*ldb] + -1.687561521519859*b[i + 43*ldb] + 1.09762839928984*b[i + 44*ldb]);
        c[i + 40*ldc] = (0.6700089687429422*b[i + 30*ldb] + -0.07381136587329767*b[i + 31*ldb] + 0.3382891868158406*b[i + 32*ldb] + -1.547856590176338*b[i + 33*ldb] + -0.6449271066413235*b[i + 34*ldb] + 2.110251502449065*b[i + 35*ldb] + -0.1536175324542066*b[i + 36*ldb] + 1.896047521200515*b[i + 37*ldb] + 1.335288332277977*b[i + 38*ldb] + 0.1712431320875245*b[i + 39*ldb] + 4.031390515234344*b[i + 40*ldb] + 0.209949353949926*b[i + 41*ldb] + 0.1241305557641109*b[i + 42*ldb] + -1.09762839928984*b[i + 43*ldb] + 1.687561521519859*b[i + 44*ldb]);
        c[i + 41*ldc] = (-0.1068368224642844*b[i + 30*ldb] + 0.6255688165573523*b[i + 31*ldb] + -2.583413129926359*b[i + 32*ldb] + -0.6619114463571192*b[i + 33*ldb] + -1.477330712695793*b[i + 34*ldb] + 1.546200852363405*b[i + 35*ldb] + 1.91592718061395*b[i + 36*ldb] + 0.3742866353879682*b[i + 37*ldb] + 1.355641220983662*b[i + 38*ldb] + 1.639898802233694*b[i + 39*ldb] + -2.755439543527363*b[i + 40*ldb] + 0.4497931998799397*b[i + 41*ldb] + -0.8886523802884596*b[i + 42*ldb] + 0.1700384034174278*b[i + 43*ldb] + 0.1590914669746716*b[i + 44*ldb]);
        c[i + 42*ldc] = (0.1068368224642844*b[i + 30*ldb] + 2.583413129926359*b[i + 31*ldb] + -0.6255688165573523*b[i + 32*ldb] + 0.6619114463571192*b[i + 33*ldb] + -1.546200852363405*b[i + 34*ldb] + 1.477330712695793*b[i + 35*ldb] + -1.91592718061395*b[i + 36*ldb] + -1.355641220983662*b[i + 37*ldb] + -0.3742866353879682*b[i + 38*ldb] + 2.755439543527363*b[i + 39*ldb] + -1.639898802233694*b[i + 40*ldb] + 0.8886523802884596*b[i + 41*ldb] + -0.4497931998799397*b[i + 42*ldb] + -0.1590914669746716*b[i + 43*ldb] + -0.1700384034174278*b[i + 44*ldb]);
        c[i + 43*ldc] = (2.9217023167422*b[i + 30*ldb] + 0.03302545659098766*b[i + 31*ldb] + 0.04444015218558958*b[i + 32*ldb] + 0.564050650085659*b[i + 33*ldb] + 0.01698433971579627*b[i + 34*ldb] + -0.07052587748054273*b[i + 35*ldb] + -0.02035288870568681*b[i + 36*ldb] + -0.01987965941343628*b[i + 37*ldb] + -0.5279041678421734*b[i + 38*ldb] + -0.0459078476533179*b[i + 39*ldb] + -0.2089760190013807*b[i + 40*ldb] + 0.04766271928616608*b[i + 41*ldb] + 0.01215166511285262*b[i + 42*ldb] + 3.581597315354408*b[i + 43*ldb] + 2.965388897477289*b[i + 44*ldb]);
        c[i + 44*ldc] = (-2.9217023167422*b[i + 30*ldb] + -0.04444015218558958*b[i + 31*ldb] + -0.03302545659098766*b[i + 32*ldb] + -0.564050650085659*b[i + 33*ldb] + 0.07052587748054273*b[i + 34*ldb] + -0.01698433971579627*b[i + 35*ldb] + 0.02035288870568681*b[i + 36*ldb] + 0.5279041678421734*b[i + 37*ldb] + 0.01987965941343628*b[i + 38*ldb] + 0.2089760190013807*b[i + 39*ldb] + 0.0459078476533179*b[i + 40*ldb] + -0.01215166511285262*b[i + 41*ldb] + -0.04766271928616608*b[i + 42*ldb] + -2.965388897477289*b[i + 43*ldb] + -3.581597315354408*b[i + 44*ldb]);
        c[i + 45*ldc] = (0.01666240169962252*b[i + 46*ldb] + -0.01666240169962252*b[i + 47*ldb] + -0.06412597883381979*b[i + 49*ldb] + 0.06412597883381979*b[i + 50*ldb] + -0.2284464562720814*b[i + 52*ldb] + 0.2284464562720814*b[i + 53*ldb] + -0.0809696560654336*b[i + 54*ldb] + 0.0809696560654336*b[i + 55*ldb] + -0.01902826490985636*b[i + 56*ldb] + 0.01902826490985636*b[i + 57*ldb] + -0.2968235823045307*b[i + 58*ldb] + 0.2968235823045307*b[i + 59*ldb]);
        c[i + 46*ldc] = (0.5320310574554866*b[i + 45*ldb] + -4.943623329974175*b[i + 46*ldb] + 0.5153686557558634*b[i + 47*ldb] + -1.668497037618385*b[i + 48*ldb] + 2.118084753790551*b[i + 49*ldb] + -1.604371058784565*b[i + 50*ldb] + 1.189090704074046*b[i + 51*ldb] + 2.136333242112812*b[i + 52*ldb] + 1.417537160346129*b[i + 53*ldb] + -2.877453657493225*b[i + 54*ldb] + 1.526761453986784*b[i + 55*ldb] + -0.6568015224866337*b[i + 56*ldb] + -3.174277239797759*b[i + 57*ldb] + 1.545789718896642*b[i + 58*ldb] + -0.7377711785520655*b[i + 59*ldb]);
        c[i + 47*ldc] = (-0.5320310574554866*b[i + 45*ldb] + -0.5153686557558634*b[i + 46*ldb] + 4.943623329974175*b[i + 47*ldb] + 1.668497037618385*b[i + 48*ldb] + 1.604371058784565*b[i + 49*ldb] + -2.118084753790551*b[i + 50*ldb] + -1.189090704074046*b[i + 51*ldb] + -1.417537160346129*b[i + 52*ldb] + -2.136333242112812*b[i + 53*ldb] + -1.526761453986784*b[i + 54*ldb] + 2.877453657493225*b[i + 55*ldb] + 3.174277239797759*b[i + 56*ldb] + 0.6568015224866337*b[i + 57*ldb] + 0.7377711785520655*b[i + 58*ldb] + -1.545789718896642*b[i + 59*ldb]);
        c[i + 48*ldc] = (-0.0832386718891518*b[i + 46*ldb] + 0.0832386718891518*b[i + 47*ldb] + 0.1767047850928541*b[i + 49*ldb] + -0.1767047850928541*b[i + 50*ldb] + -2.508033750268638*b[i + 52*ldb] + 2.508033750268638*b[i + 53*ldb] + -0.2525315576529422*b[i + 54*ldb] + 0.2525315576529422*b[i + 55*ldb] + -0.03160100937678251*b[i + 56*ldb] + 0.03160100937678251*b[i + 57*ldb] + -2.356239812122482*b[i + 58*ldb] + 2.356239812122482*b[i + 59*ldb]);
        c[i + 49*ldc] = (-0.1031803103571685*b[i + 45*ldb] + 0.04609417395922302*b[i + 46*ldb] + -0.01994163846801661*b[i + 47*ldb] + -1.492300533375874*b[i + 48*ldb] + -0.3632813123758165*b[i + 49*ldb] + -1.669005318468729*b[i + 50*ldb] + -0.119528214542479*b[i + 51*ldb] + 1.730263001372271*b[i + 52*ldb] + 2.388505535726159*b[i + 53*ldb] + 2.365427409367463*b[i + 54*ldb] + 0.7288527548607495*b[i + 55*ldb] + 0.08153976883786418*b[i + 56*ldb] + 0.009187597244981638*b[i + 57*ldb] + 0.7604537642375322*b[i + 58*ldb] + -0.1709917888150785*b[i + 59*ldb]);
        c[i + 50*ldc] = (0.1031803103571685*b[i + 45*ldb] + 0.01994163846801661*b[i + 46*ldb] + -0.04609417395922302*b[i + 47*ldb] + 1.492300533375874*b[i + 48*ldb] + 1.669005318468729*b[i + 49*ldb] + 0.3632813123758165*b[i + 50*ldb] + 0.119528214542479*b[i + 51*ldb] + -2.388505535726159*b[i + 52*ldb] + -1.730263001372271*b[i + 53*ldb] + -0.7288527548607495*b[i + 54*ldb] + -2.365427409367463*b[i + 55*ldb] + -0.009187597244981638*b[i + 56*ldb] + -0.08153976883786418*b[i + 57*ldb] + 0.1709917888150785*b[i + 58*ldb] + -0.7604537642375322*b[i + 59*ldb]);
        c[i + 51*ldc] = (-0.9213245156088653*b[i + 46*ldb] + 0.9213245156088653*b[i + 47*ldb] + 1.478053430463056*b[i + 49*ldb] + -1.478053430463056*b[i + 50*ldb] + 0.657627957956578*b[i + 52*ldb] + -0.657627957956578*b[i + 53*ldb] + -1.844372618022506*b[i + 54*ldb] + 1.844372618022506*b[i + 55*ldb] + -1.70239108991215*b[i + 56*ldb] + 1.70239108991215*b[i + 57*ldb] + -0.2828454530477449*b[i + 58*ldb] + 0.2828454530477449*b[i + 59*ldb]);
        c[i + 52*ldc] = (-1.063952765527867*b[i + 45*ldb] + 0.04922131659554296*b[i + 46*ldb] + -0.1426282499190014*b[i + 47*ldb] + 1.892059090254097*b[i + 48*ldb] + -0.2449733459341608*b[i + 49*ldb] + 0.4140056597910398*b[i + 50*ldb] + 0.01268686934620999*b[i + 51*ldb] + 3.824491607376837*b[i + 52*ldb] + -0.6449410886103684*b[i + 53*ldb] + 0.2548046964372861*b[i + 54*ldb] + 0.1863127236068944*b[i + 55*ldb] + -0.04923230933097847*b[i + 56*ldb] + -0.02804075661045902*b[i + 57*ldb] + 1.888703813519044*b[i + 58*ldb] + -1.893604927353485*b[i + 59*ldb]);
        c[i + 53*ldc] = (1.063952765527867*b[i + 45*ldb] + 0.1426282499190014*b[i + 46*ldb] + -0.04922131659554296*b[i + 47*ldb] + -1.892059090254097*b[i + 48*ldb] + -0.4140056597910398*b[i + 49*ldb] + 0.2449733459341608*b[i + 50*ldb] + -0.01268686934620999*b[i + 51*ldb] + 0.6449410886103684*b[i + 52*ldb] + -3.824491607376837*b[i + 53*ldb] + -0.1863127236068944*b[i + 54*ldb] + -0.2548046964372861*b[i + 55*ldb] + 0.02804075661045902*b[i + 56*ldb] + 0.04923230933097847*b[i + 57*ldb] + 1.893604927353485*b[i + 58*ldb] + -1.888703813519044*b[i + 59*ldb]);
        c[i + 54*ldc] = (-0.6700089687429422*b[i + 45*ldb] + -0.3382891868158406*b[i + 46*ldb] + 0.07381136587329767*b[i + 47*ldb] + 1.547856590176338*b[i + 48*ldb] + -2.110251502449065*b[i + 49*ldb] + 0.6449271066413235*b[i + 50*ldb] + 0.1536175324542066*b[i + 51*ldb] + -1.335288332277977*b[i + 52*ldb] + -1.896047521200515*b[i + 53*ldb] + -4.031390515234344*b[i + 54*ldb] + -0.1712431320875245*b[i + 55*ldb] + -0.1241305557641109*b[i + 56*ldb] + -0.209949353949926*b[i + 57*ldb] + -1.687561521519859*b[i + 58*ldb] + 1.09762839928984*b[i + 59*ldb]);
        c[i + 55*ldc] = (0.6700089687429422*b[i + 45*ldb] + -0.07381136587329767*b[i + 46*ldb] + 0.3382891868158406*b[i + 47*ldb] + -1.547856590176338*b[i + 48*ldb] + -0.6449271066413235*b[i + 49*ldb] + 2.110251502449065*b[i + 50*ldb] + -0.1536175324542066*b[i + 51*ldb] + 1.896047521200515*b[i + 52*ldb] + 1.335288332277977*b[i + 53*ldb] + 0.1712431320875245*b[i + 54*ldb] + 4.031390515234344*b[i + 55*ldb] + 0.209949353949926*b[i + 56*ldb] + 0.1241305557641109*b[i + 57*ldb] + -1.09762839928984*b[i + 58*ldb] + 1.687561521519859*b[i + 59*ldb]);
        c[i + 56*ldc] = (-0.1068368224642844*b[i + 45*ldb] + 0.6255688165573523*b[i + 46*ldb] + -2.583413129926359*b[i + 47*ldb] + -0.6619114463571192*b[i + 48*ldb] + -1.477330712695793*b[i + 49*ldb] + 1.546200852363405*b[i + 50*ldb] + 1.91592718061395*b[i + 51*ldb] + 0.3742866353879682*b[i + 52*ldb] + 1.355641220983662*b[i + 53*ldb] + 1.639898802233694*b[i + 54*ldb] + -2.755439543527363*b[i + 55*ldb] + 0.4497931998799397*b[i + 56*ldb] + -0.8886523802884596*b[i + 57*ldb] + 0.1700384034174278*b[i + 58*ldb] + 0.1590914669746716*b[i + 59*ldb]);
        c[i + 57*ldc] = (0.1068368224642844*b[i + 45*ldb] + 2.583413129926359*b[i + 46*ldb] + -0.6255688165573523*b[i + 47*ldb] + 0.6619114463571192*b[i + 48*ldb] + -1.546200852363405*b[i + 49*ldb] + 1.477330712695793*b[i + 50*ldb] + -1.91592718061395*b[i + 51*ldb] + -1.355641220983662*b[i + 52*ldb] + -0.3742866353879682*b[i + 53*ldb] + 2.755439543527363*b[i + 54*ldb] + -1.639898802233694*b[i + 55*ldb] + 0.8886523802884596*b[i + 56*ldb] + -0.4497931998799397*b[i + 57*ldb] + -0.1590914669746716*b[i + 58*ldb] + -0.1700384034174278*b[i + 59*ldb]);
        c[i + 58*ldc] = (2.9217023167422*b[i + 45*ldb] + 0.03302545659098766*b[i + 46*ldb] + 0.04444015218558958*b[i + 47*ldb] + 0.564050650085659*b[i + 48*ldb] + 0.01698433971579627*b[i + 49*ldb] + -0.07052587748054273*b[i + 50*ldb] + -0.02035288870568681*b[i + 51*ldb] + -0.01987965941343628*b[i + 52*ldb] + -0.5279041678421734*b[i + 53*ldb] + -0.0459078476533179*b[i + 54*ldb] + -0.2089760190013807*b[i + 55*ldb] + 0.04766271928616608*b[i + 56*ldb] + 0.01215166511285262*b[i + 57*ldb] + 3.581597315354408*b[i + 58*ldb] + 2.965388897477289*b[i + 59*ldb]);
        c[i + 59*ldc] = (-2.9217023167422*b[i + 45*ldb] + -0.04444015218558958*b[i + 46*ldb] + -0.03302545659098766*b[i + 47*ldb] + -0.564050650085659*b[i + 48*ldb] + 0.07052587748054273*b[i + 49*ldb] + -0.01698433971579627*b[i + 50*ldb] + 0.02035288870568681*b[i + 51*ldb] + 0.5279041678421734*b[i + 52*ldb] + 0.01987965941343628*b[i + 53*ldb] + 0.2089760190013807*b[i + 54*ldb] + 0.0459078476533179*b[i + 55*ldb] + -0.01215166511285262*b[i + 56*ldb] + -0.04766271928616608*b[i + 57*ldb] + -2.965388897477289*b[i + 58*ldb] + -3.581597315354408*b[i + 59*ldb]);
        c[i + 60*ldc] = (0.01666240169962252*b[i + 61*ldb] + -0.01666240169962252*b[i + 62*ldb] + -0.06412597883381979*b[i + 64*ldb] + 0.06412597883381979*b[i + 65*ldb] + -0.2284464562720814*b[i + 67*ldb] + 0.2284464562720814*b[i + 68*ldb] + -0.0809696560654336*b[i + 69*ldb] + 0.0809696560654336*b[i + 70*ldb] + -0.01902826490985636*b[i + 71*ldb] + 0.01902826490985636*b[i + 72*ldb] + -0.2968235823045307*b[i + 73*ldb] + 0.2968235823045307*b[i + 74*ldb]);
        c[i + 61*ldc] = (0.5320310574554866*b[i + 60*ldb] + -4.943623329974175*b[i + 61*ldb] + 0.5153686557558634*b[i + 62*ldb] + -1.668497037618385*b[i + 63*ldb] + 2.118084753790551*b[i + 64*ldb] + -1.604371058784565*b[i + 65*ldb] + 1.189090704074046*b[i + 66*ldb] + 2.136333242112812*b[i + 67*ldb] + 1.417537160346129*b[i + 68*ldb] + -2.877453657493225*b[i + 69*ldb] + 1.526761453986784*b[i + 70*ldb] + -0.6568015224866337*b[i + 71*ldb] + -3.174277239797759*b[i + 72*ldb] + 1.545789718896642*b[i + 73*ldb] + -0.7377711785520655*b[i + 74*ldb]);
        c[i + 62*ldc] = (-0.5320310574554866*b[i + 60*ldb] + -0.5153686557558634*b[i + 61*ldb] + 4.943623329974175*b[i + 62*ldb] + 1.668497037618385*b[i + 63*ldb] + 1.604371058784565*b[i + 64*ldb] + -2.118084753790551*b[i + 65*ldb] + -1.189090704074046*b[i + 66*ldb] + -1.417537160346129*b[i + 67*ldb] + -2.136333242112812*b[i + 68*ldb] + -1.526761453986784*b[i + 69*ldb] + 2.877453657493225*b[i + 70*ldb] + 3.174277239797759*b[i + 71*ldb] + 0.6568015224866337*b[i + 72*ldb] + 0.7377711785520655*b[i + 73*ldb] + -1.545789718896642*b[i + 74*ldb]);
        c[i + 63*ldc] = (-0.0832386718891518*b[i + 61*ldb] + 0.0832386718891518*b[i + 62*ldb] + 0.1767047850928541*b[i + 64*ldb] + -0.1767047850928541*b[i + 65*ldb] + -2.508033750268638*b[i + 67*ldb] + 2.508033750268638*b[i + 68*ldb] + -0.2525315576529422*b[i + 69*ldb] + 0.2525315576529422*b[i + 70*ldb] + -0.03160100937678251*b[i + 71*ldb] + 0.03160100937678251*b[i + 72*ldb] + -2.356239812122482*b[i + 73*ldb] + 2.356239812122482*b[i + 74*ldb]);
        c[i + 64*ldc] = (-0.1031803103571685*b[i + 60*ldb] + 0.04609417395922302*b[i + 61*ldb] + -0.01994163846801661*b[i + 62*ldb] + -1.492300533375874*b[i + 63*ldb] + -0.3632813123758165*b[i + 64*ldb] + -1.669005318468729*b[i + 65*ldb] + -0.119528214542479*b[i + 66*ldb] + 1.730263001372271*b[i + 67*ldb] + 2.388505535726159*b[i + 68*ldb] + 2.365427409367463*b[i + 69*ldb] + 0.7288527548607495*b[i + 70*ldb] + 0.08153976883786418*b[i + 71*ldb] + 0.009187597244981638*b[i + 72*ldb] + 0.7604537642375322*b[i + 73*ldb] + -0.1709917888150785*b[i + 74*ldb]);
        c[i + 65*ldc] = (0.1031803103571685*b[i + 60*ldb] + 0.01994163846801661*b[i + 61*ldb] + -0.04609417395922302*b[i + 62*ldb] + 1.492300533375874*b[i + 63*ldb] + 1.669005318468729*b[i + 64*ldb] + 0.3632813123758165*b[i + 65*ldb] + 0.119528214542479*b[i + 66*ldb] + -2.388505535726159*b[i + 67*ldb] + -1.730263001372271*b[i + 68*ldb] + -0.7288527548607495*b[i + 69*ldb] + -2.365427409367463*b[i + 70*ldb] + -0.009187597244981638*b[i + 71*ldb] + -0.08153976883786418*b[i + 72*ldb] + 0.1709917888150785*b[i + 73*ldb] + -0.7604537642375322*b[i + 74*ldb]);
        c[i + 66*ldc] = (-0.9213245156088653*b[i + 61*ldb] + 0.9213245156088653*b[i + 62*ldb] + 1.478053430463056*b[i + 64*ldb] + -1.478053430463056*b[i + 65*ldb] + 0.657627957956578*b[i + 67*ldb] + -0.657627957956578*b[i + 68*ldb] + -1.844372618022506*b[i + 69*ldb] + 1.844372618022506*b[i + 70*ldb] + -1.70239108991215*b[i + 71*ldb] + 1.70239108991215*b[i + 72*ldb] + -0.2828454530477449*b[i + 73*ldb] + 0.2828454530477449*b[i + 74*ldb]);
        c[i + 67*ldc] = (-1.063952765527867*b[i + 60*ldb] + 0.04922131659554296*b[i + 61*ldb] + -0.1426282499190014*b[i + 62*ldb] + 1.892059090254097*b[i + 63*ldb] + -0.2449733459341608*b[i + 64*ldb] + 0.4140056597910398*b[i + 65*ldb] + 0.01268686934620999*b[i + 66*ldb] + 3.824491607376837*b[i + 67*ldb] + -0.6449410886103684*b[i + 68*ldb] + 0.2548046964372861*b[i + 69*ldb] + 0.1863127236068944*b[i + 70*ldb] + -0.04923230933097847*b[i + 71*ldb] + -0.02804075661045902*b[i + 72*ldb] + 1.888703813519044*b[i + 73*ldb] + -1.893604927353485*b[i + 74*ldb]);
        c[i + 68*ldc] = (1.063952765527867*b[i + 60*ldb] + 0.1426282499190014*b[i + 61*ldb] + -0.04922131659554296*b[i + 62*ldb] + -1.892059090254097*b[i + 63*ldb] + -0.4140056597910398*b[i + 64*ldb] + 0.2449733459341608*b[i + 65*ldb] + -0.01268686934620999*b[i + 66*ldb] + 0.6449410886103684*b[i + 67*ldb] + -3.824491607376837*b[i + 68*ldb] + -0.1863127236068944*b[i + 69*ldb] + -0.2548046964372861*b[i + 70*ldb] + 0.02804075661045902*b[i + 71*ldb] + 0.04923230933097847*b[i + 72*ldb] + 1.893604927353485*b[i + 73*ldb] + -1.888703813519044*b[i + 74*ldb]);
        c[i + 69*ldc] = (-0.6700089687429422*b[i + 60*ldb] + -0.3382891868158406*b[i + 61*ldb] + 0.07381136587329767*b[i + 62*ldb] + 1.547856590176338*b[i + 63*ldb] + -2.110251502449065*b[i + 64*ldb] + 0.6449271066413235*b[i + 65*ldb] + 0.1536175324542066*b[i + 66*ldb] + -1.335288332277977*b[i + 67*ldb] + -1.896047521200515*b[i + 68*ldb] + -4.031390515234344*b[i + 69*ldb] + -0.1712431320875245*b[i + 70*ldb] + -0.1241305557641109*b[i + 71*ldb] + -0.209949353949926*b[i + 72*ldb] + -1.687561521519859*b[i + 73*ldb] + 1.09762839928984*b[i + 74*ldb]);
        c[i + 70*ldc] = (0.6700089687429422*b[i + 60*ldb] + -0.07381136587329767*b[i + 61*ldb] + 0.3382891868158406*b[i + 62*ldb] + -1.547856590176338*b[i + 63*ldb] + -0.6449271066413235*b[i + 64*ldb] + 2.110251502449065*b[i + 65*ldb] + -0.1536175324542066*b[i + 66*ldb] + 1.896047521200515*b[i + 67*ldb] + 1.335288332277977*b[i + 68*ldb] + 0.1712431320875245*b[i + 69*ldb] + 4.031390515234344*b[i + 70*ldb] + 0.209949353949926*b[i + 71*ldb] + 0.1241305557641109*b[i + 72*ldb] + -1.09762839928984*b[i + 73*ldb] + 1.687561521519859*b[i + 74*ldb]);
        c[i + 71*ldc] = (-0.1068368224642844*b[i + 60*ldb] + 0.6255688165573523*b[i + 61*ldb] + -2.583413129926359*b[i + 62*ldb] + -0.6619114463571192*b[i + 63*ldb] + -1.477330712695793*b[i + 64*ldb] + 1.546200852363405*b[i + 65*ldb] + 1.91592718061395*b[i + 66*ldb] + 0.3742866353879682*b[i + 67*ldb] + 1.355641220983662*b[i + 68*ldb] + 1.639898802233694*b[i + 69*ldb] + -2.755439543527363*b[i + 70*ldb] + 0.4497931998799397*b[i + 71*ldb] + -0.8886523802884596*b[i + 72*ldb] + 0.1700384034174278*b[i + 73*ldb] + 0.1590914669746716*b[i + 74*ldb]);
        c[i + 72*ldc] = (0.1068368224642844*b[i + 60*ldb] + 2.583413129926359*b[i + 61*ldb] + -0.6255688165573523*b[i + 62*ldb] + 0.6619114463571192*b[i + 63*ldb] + -1.546200852363405*b[i + 64*ldb] + 1.477330712695793*b[i + 65*ldb] + -1.91592718061395*b[i + 66*ldb] + -1.355641220983662*b[i + 67*ldb] + -0.3742866353879682*b[i + 68*ldb] + 2.755439543527363*b[i + 69*ldb] + -1.639898802233694*b[i + 70*ldb] + 0.8886523802884596*b[i + 71*ldb] + -0.4497931998799397*b[i + 72*ldb] + -0.1590914669746716*b[i + 73*ldb] + -0.1700384034174278*b[i + 74*ldb]);
        c[i + 73*ldc] = (2.9217023167422*b[i + 60*ldb] + 0.03302545659098766*b[i + 61*ldb] + 0.04444015218558958*b[i + 62*ldb] + 0.564050650085659*b[i + 63*ldb] + 0.01698433971579627*b[i + 64*ldb] + -0.07052587748054273*b[i + 65*ldb] + -0.02035288870568681*b[i + 66*ldb] + -0.01987965941343628*b[i + 67*ldb] + -0.5279041678421734*b[i + 68*ldb] + -0.0459078476533179*b[i + 69*ldb] + -0.2089760190013807*b[i + 70*ldb] + 0.04766271928616608*b[i + 71*ldb] + 0.01215166511285262*b[i + 72*ldb] + 3.581597315354408*b[i + 73*ldb] + 2.965388897477289*b[i + 74*ldb]);
        c[i + 74*ldc] = (-2.9217023167422*b[i + 60*ldb] + -0.04444015218558958*b[i + 61*ldb] + -0.03302545659098766*b[i + 62*ldb] + -0.564050650085659*b[i + 63*ldb] + 0.07052587748054273*b[i + 64*ldb] + -0.01698433971579627*b[i + 65*ldb] + 0.02035288870568681*b[i + 66*ldb] + 0.5279041678421734*b[i + 67*ldb] + 0.01987965941343628*b[i + 68*ldb] + 0.2089760190013807*b[i + 69*ldb] + 0.0459078476533179*b[i + 70*ldb] + -0.01215166511285262*b[i + 71*ldb] + -0.04766271928616608*b[i + 72*ldb] + -2.965388897477289*b[i + 73*ldb] + -3.581597315354408*b[i + 74*ldb]);
        c[i + 75*ldc] = (-4.943623329974175*b[i + 0*ldb] + 0.5320310574554866*b[i + 1*ldb] + 0.5153686557558634*b[i + 2*ldb] + 2.118084753790551*b[i + 3*ldb] + -1.668497037618385*b[i + 4*ldb] + -1.604371058784565*b[i + 5*ldb] + 2.136333242112812*b[i + 6*ldb] + 1.189090704074046*b[i + 7*ldb] + 1.417537160346129*b[i + 8*ldb] + -0.7377711785520655*b[i + 9*ldb] + -0.6568015224866337*b[i + 10*ldb] + 1.526761453986784*b[i + 11*ldb] + 1.545789718896642*b[i + 12*ldb] + -3.174277239797759*b[i + 13*ldb] + -2.877453657493225*b[i + 14*ldb]);
        c[i + 76*ldc] = (0.01666240169962252*b[i + 0*ldb] + -0.01666240169962252*b[i + 2*ldb] + -0.06412597883381979*b[i + 3*ldb] + 0.06412597883381979*b[i + 5*ldb] + -0.2284464562720814*b[i + 6*ldb] + 0.2284464562720814*b[i + 8*ldb] + 0.2968235823045307*b[i + 9*ldb] + -0.01902826490985636*b[i + 10*ldb] + 0.0809696560654336*b[i + 11*ldb] + -0.2968235823045307*b[i + 12*ldb] + 0.01902826490985636*b[i + 13*ldb] + -0.0809696560654336*b[i + 14*ldb]);
        c[i + 77*ldc] = (-0.5153686557558634*b[i + 0*ldb] + -0.5320310574554866*b[i + 1*ldb] + 4.943623329974175*b[i + 2*ldb] + 1.604371058784565*b[i + 3*ldb] + 1.668497037618385*b[i + 4*ldb] + -2.118084753790551*b[i + 5*ldb] + -1.417537160346129*b[i + 6*ldb] + -1.189090704074046*b[i + 7*ldb] + -2.136333242112812*b[i + 8*ldb] + -1.545789718896642*b[i + 9*ldb] + 3.174277239797759*b[i + 10*ldb] + 2.877453657493225*b[i + 11*ldb] + 0.7377711785520655*b[i + 12*ldb] + 0.6568015224866337*b[i + 13*ldb] + -1.526761453986784*b[i + 14*ldb]);
        c[i + 78*ldc] = (0.04609417395922302*b[i + 0*ldb] + -0.1031803103571685*b[i + 1*ldb] + -0.01994163846801661*b[i + 2*ldb] + -0.3632813123758165*b[i + 3*ldb] + -1.492300533375874*b[i + 4*ldb] + -1.669005318468729*b[i + 5*ldb] + 1.730263001372271*b[i + 6*ldb] + -0.119528214542479*b[i + 7*ldb] + 2.388505535726159*b[i + 8*ldb] + -0.1709917888150785*b[i + 9*ldb] + 0.08153976883786418*b[i + 10*ldb] + 0.7288527548607495*b[i + 11*ldb] + 0.7604537642375322*b[i + 12*ldb] + 0.009187597244981638*b[i + 13*ldb] + 2.365427409367463*b[i + 14*ldb]);
        c[i + 79*ldc] = (-0.0832386718891518*b[i + 0*ldb] + 0.0832386718891518*b[i + 2*ldb] + 0.1767047850928541*b[i + 3*ldb] + -0.1767047850928541*b[i + 5*ldb] + -2.508033750268638*b[i + 6*ldb] + 2.508033750268638*b[i + 8*ldb] + 2.356239812122482*b[i + 9*ldb] + -0.03160100937678251*b[i + 10*ldb] + 0.2525315576529422*b[i + 11*ldb] + -2.356239812122482*b[i + 12*ldb] + 0.03160100937678251*b[i + 13*ldb] + -0.2525315576529422*b[i + 14*ldb]);
        c[i + 80*ldc] = (0.01994163846801661*b[i + 0*ldb] + 0.1031803103571685*b[i + 1*ldb] + -0.04609417395922302*b[i + 2*ldb] + 1.669005318468729*b[i + 3*ldb] + 1.492300533375874*b[i + 4*ldb] + 0.3632813123758165*b[i + 5*ldb] + -2.388505535726159*b[i + 6*ldb] + 0.119528214542479*b[i + 7*ldb] + -1.730263001372271*b[i + 8*ldb] + -0.7604537642375322*b[i + 9*ldb] + -0.009187597244981638*b[i + 10*ldb] + -2.365427409367463*b[i + 11*ldb] + 0.1709917888150785*b[i + 12*ldb] + -0.08153976883786418*b[i + 13*ldb] + -0.7288527548607495*b[i + 14*ldb]);
        c[i + 81*ldc] = (0.04922131659554296*b[i + 0*ldb] + -1.063952765527867*b[i + 1*ldb] + -0.1426282499190014*b[i + 2*ldb] + -0.2449733459341608*b[i + 3*ldb] + 1.892059090254097*b[i + 4*ldb] + 0.4140056597910398*b[i + 5*ldb] + 3.824491607376837*b[i + 6*ldb] + 0.01268686934620999*b[i + 7*ldb] + -0.6449410886103684*b[i + 8*ldb] + -1.893604927353485*b[i + 9*ldb] + -0.04923230933097847*b[i + 10*ldb] + 0.1863127236068944*b[i + 11*ldb] + 1.888703813519044*b[i + 12*ldb] + -0.02804075661045902*b[i + 13*ldb] + 0.2548046964372861*b[i + 14*ldb]);
        c[i + 82*ldc] = (-0.9213245156088653*b[i + 0*ldb] + 0.9213245156088653*b[i + 2*ldb] + 1.478053430463056*b[i + 3*ldb] + -1.478053430463056*b[i + 5*ldb] + 0.657627957956578*b[i + 6*ldb] + -0.657627957956578*b[i + 8*ldb] + 0.2828454530477449*b[i + 9*ldb] + -1.70239108991215*b[i + 10*ldb] + 1.844372618022506*b[i + 11*ldb] + -0.2828454530477449*b[i + 12*ldb] + 1.70239108991215*b[i + 13*ldb] + -1.844372618022506*b[i + 14*ldb]);
        c[i + 83*ldc] = (0.1426282499190014*b[i + 0*ldb] + 1.063952765527867*b[i + 1*ldb] + -0.04922131659554296*b[i + 2*ldb] + -0.4140056597910398*b[i + 3*ldb] + -1.892059090254097*b[i + 4*ldb] + 0.2449733459341608*b[i + 5*ldb] + 0.6449410886103684*b[i + 6*ldb] + -0.01268686934620999*b[i + 7*ldb] + -3.824491607376837*b[i + 8*ldb] + -1.888703813519044*b[i + 9*ldb] + 0.02804075661045902*b[i + 10*ldb] + -0.2548046964372861*b[i + 11*ldb] + 1.893604927353485*b[i + 12*ldb] + 0.04923230933097847*b[i + 13*ldb] + -0.1863127236068944*b[i + 14*ldb]);
        c[i + 84*ldc] = (-0.04444015218558958*b[i + 0*ldb] + -2.9217023167422*b[i + 1*ldb] + -0.03302545659098766*b[i + 2*ldb] + 0.07052587748054273*b[i + 3*ldb] + -0.564050650085659*b[i + 4*ldb] + -0.01698433971579627*b[i + 5*ldb] + 0.5279041678421734*b[i + 6*ldb] + 0.02035288870568681*b[i + 7*ldb] + 0.01987965941343628*b[i + 8*ldb] + -3.581597315354408*b[i + 9*ldb] + -0.01215166511285262*b[i + 10*ldb] + 0.0459078476533179*b[i + 11*ldb] + -2.965388897477289*b[i + 12*ldb] + -0.04766271928616608*b[i + 13*ldb] + 0.2089760190013807*b[i + 14*ldb]);
        c[i + 85*ldc] = (0.6255688165573523*b[i + 0*ldb] + -0.1068368224642844*b[i + 1*ldb] + -2.583413129926359*b[i + 2*ldb] + -1.477330712695793*b[i + 3*ldb] + -0.6619114463571192*b[i + 4*ldb] + 1.546200852363405*b[i + 5*ldb] + 0.3742866353879682*b[i + 6*ldb] + 1.91592718061395*b[i + 7*ldb] + 1.355641220983662*b[i + 8*ldb] + 0.1590914669746716*b[i + 9*ldb] + 0.4497931998799397*b[i + 10*ldb] + -2.755439543527363*b[i + 11*ldb] + 0.1700384034174278*b[i + 12*ldb] + -0.8886523802884596*b[i + 13*ldb] + 1.639898802233694*b[i + 14*ldb]);
        c[i + 86*ldc] = (-0.07381136587329767*b[i + 0*ldb] + 0.6700089687429422*b[i + 1*ldb] + 0.3382891868158406*b[i + 2*ldb] + -0.6449271066413235*b[i + 3*ldb] + -1.547856590176338*b[i + 4*ldb] + 2.110251502449065*b[i + 5*ldb] + 1.896047521200515*b[i + 6*ldb] + -0.1536175324542066*b[i + 7*ldb] + 1.335288332277977*b[i + 8*ldb] + 1.687561521519859*b[i + 9*ldb] + 0.209949353949926*b[i + 10*ldb] + 4.031390515234344*b[i + 11*ldb] + -1.09762839928984*b[i + 12*ldb] + 0.1241305557641109*b[i + 13*ldb] + 0.1712431320875245*b[i + 14*ldb]);
        c[i + 87*ldc] = (0.03302545659098766*b[i + 0*ldb] + 2.9217023167422*b[i + 1*ldb] + 0.04444015218558958*b[i + 2*ldb] + 0.01698433971579627*b[i + 3*ldb] + 0.564050650085659*b[i + 4*ldb] + -0.07052587748054273*b[i + 5*ldb] + -0.01987965941343628*b[i + 6*ldb] + -0.02035288870568681*b[i + 7*ldb] + -0.5279041678421734*b[i + 8*ldb] + 2.965388897477289*b[i + 9*ldb] + 0.04766271928616608*b[i + 10*ldb] + -0.2089760190013807*b[i + 11*ldb] + 3.581597315354408*b[i + 12*ldb] + 0.01215166511285262*b[i + 13*ldb] + -0.0459078476533179*b[i + 14*ldb]);
        c[i + 88*ldc] = (2.583413129926359*b[i + 0*ldb] + 0.1068368224642844*b[i + 1*ldb] + -0.6255688165573523*b[i + 2*ldb] + -1.546200852363405*b[i + 3*ldb] + 0.6619114463571192*b[i + 4*ldb] + 1.477330712695793*b[i + 5*ldb] + -1.355641220983662*b[i + 6*ldb] + -1.91592718061395*b[i + 7*ldb] + -0.3742866353879682*b[i + 8*ldb] + -0.1700384034174278*b[i + 9*ldb] + 0.8886523802884596*b[i + 10*ldb] + -1.639898802233694*b[i + 11*ldb] + -0.1590914669746716*b[i + 12*ldb] + -0.4497931998799397*b[i + 13*ldb] + 2.755439543527363*b[i + 14*ldb]);
        c[i + 89*ldc] = (-0.3382891868158406*b[i + 0*ldb] + -0.6700089687429422*b[i + 1*ldb] + 0.07381136587329767*b[i + 2*ldb] + -2.110251502449065*b[i + 3*ldb] + 1.547856590176338*b[i + 4*ldb] + 0.6449271066413235*b[i + 5*ldb] + -1.335288332277977*b[i + 6*ldb] + 0.1536175324542066*b[i + 7*ldb] + -1.896047521200515*b[i + 8*ldb] + 1.09762839928984*b[i + 9*ldb] + -0.1241305557641109*b[i + 10*ldb] + -0.1712431320875245*b[i + 11*ldb] + -1.687561521519859*b[i + 12*ldb] + -0.209949353949926*b[i + 13*ldb] + -4.031390515234344*b[i + 14*ldb]);
        c[i + 90*ldc] = (-4.943623329974175*b[i + 15*ldb] + 0.5320310574554866*b[i + 16*ldb] + 0.5153686557558634*b[i + 17*ldb] + 2.118084753790551*b[i + 18*ldb] + -1.668497037618385*b[i + 19*ldb] + -1.604371058784565*b[i + 20*ldb] + 2.136333242112812*b[i + 21*ldb] + 1.189090704074046*b[i + 22*ldb] + 1.417537160346129*b[i + 23*ldb] + -0.7377711785520655*b[i + 24*ldb] + -0.6568015224866337*b[i + 25*ldb] + 1.526761453986784*b[i + 26*ldb] + 1.545789718896642*b[i + 27*ldb] + -3.174277239797759*b[i + 28*ldb] + -2.877453657493225*b[i + 29*ldb]);
        c[i + 91*ldc] = (0.01666240169962252*b[i + 15*ldb] + -0.01666240169962252*b[i + 17*ldb] + -0.06412597883381979*b[i + 18*ldb] + 0.06412597883381979*b[i + 20*ldb] + -0.2284464562720814*b[i + 21*ldb] + 0.2284464562720814*b[i + 23*ldb] + 0.2968235823045307*b[i + 24*ldb] + -0.01902826490985636*b[i + 25*ldb] + 0.0809696560654336*b[i + 26*ldb] + -0.2968235823045307*b[i + 27*ldb] + 0.01902826490985636*b[i + 28*ldb] + -0.0809696560654336*b[i + 29*ldb]);
        c[i + 92*ldc] = (-0.5153686557558634*b[i + 15*ldb] + -0.5320310574554866*b[i + 16*ldb] + 4.943623329974175*b[i + 17*ldb] + 1.604371058784565*b[i + 18*ldb] + 1.668497037618385*b[i + 19*ldb] + -2.118084753790551*b[i + 20*ldb] + -1.417537160346129*b[i + 21*ldb] + -1.189090704074046*b[i + 22*ldb] + -2.136333242112812*b[i + 23*ldb] + -1.545789718896642*b[i + 24*ldb] + 3.174277239797759*b[i + 25*ldb] + 2.877453657493225*b[i + 26*ldb] + 0.7377711785520655*b[i + 27*ldb] + 0.6568015224866337*b[i + 28*ldb] + -1.526761453986784*b[i + 29*ldb]);
        c[i + 93*ldc] = (0.04609417395922302*b[i + 15*ldb] + -0.1031803103571685*b[i + 16*ldb] + -0.01994163846801661*b[i + 17*ldb] + -0.3632813123758165*b[i + 18*ldb] + -1.492300533375874*b[i + 19*ldb] + -1.669005318468729*b[i + 20*ldb] + 1.730263001372271*b[i + 21*ldb] + -0.119528214542479*b[i + 22*ldb] + 2.388505535726159*b[i + 23*ldb] + -0.1709917888150785*b[i + 24*ldb] + 0.08153976883786418*b[i + 25*ldb] + 0.7288527548607495*b[i + 26*ldb] + 0.7604537642375322*b[i + 27*ldb] + 0.009187597244981638*b[i + 28*ldb] + 2.365427409367463*b[i + 29*ldb]);
        c[i + 94*ldc] = (-0.0832386718891518*b[i + 15*ldb] + 0.0832386718891518*b[i + 17*ldb] + 0.1767047850928541*b[i + 18*ldb] + -0.1767047850928541*b[i + 20*ldb] + -2.508033750268638*b[i + 21*ldb] + 2.508033750268638*b[i + 23*ldb] + 2.356239812122482*b[i + 24*ldb] + -0.03160100937678251*b[i + 25*ldb] + 0.2525315576529422*b[i + 26*ldb] + -2.356239812122482*b[i + 27*ldb] + 0.03160100937678251*b[i + 28*ldb] + -0.2525315576529422*b[i + 29*ldb]);
        c[i + 95*ldc] = (0.01994163846801661*b[i + 15*ldb] + 0.1031803103571685*b[i + 16*ldb] + -0.04609417395922302*b[i + 17*ldb] + 1.669005318468729*b[i + 18*ldb] + 1.492300533375874*b[i + 19*ldb] + 0.3632813123758165*b[i + 20*ldb] + -2.388505535726159*b[i + 21*ldb] + 0.119528214542479*b[i + 22*ldb] + -1.730263001372271*b[i + 23*ldb] + -0.7604537642375322*b[i + 24*ldb] + -0.009187597244981638*b[i + 25*ldb] + -2.365427409367463*b[i + 26*ldb] + 0.1709917888150785*b[i + 27*ldb] + -0.08153976883786418*b[i + 28*ldb] + -0.7288527548607495*b[i + 29*ldb]);
        c[i + 96*ldc] = (0.04922131659554296*b[i + 15*ldb] + -1.063952765527867*b[i + 16*ldb] + -0.1426282499190014*b[i + 17*ldb] + -0.2449733459341608*b[i + 18*ldb] + 1.892059090254097*b[i + 19*ldb] + 0.4140056597910398*b[i + 20*ldb] + 3.824491607376837*b[i + 21*ldb] + 0.01268686934620999*b[i + 22*ldb] + -0.6449410886103684*b[i + 23*ldb] + -1.893604927353485*b[i + 24*ldb] + -0.04923230933097847*b[i + 25*ldb] + 0.1863127236068944*b[i + 26*ldb] + 1.888703813519044*b[i + 27*ldb] + -0.02804075661045902*b[i + 28*ldb] + 0.2548046964372861*b[i + 29*ldb]);
        c[i + 97*ldc] = (-0.9213245156088653*b[i + 15*ldb] + 0.9213245156088653*b[i + 17*ldb] + 1.478053430463056*b[i + 18*ldb] + -1.478053430463056*b[i + 20*ldb] + 0.657627957956578*b[i + 21*ldb] + -0.657627957956578*b[i + 23*ldb] + 0.2828454530477449*b[i + 24*ldb] + -1.70239108991215*b[i + 25*ldb] + 1.844372618022506*b[i + 26*ldb] + -0.2828454530477449*b[i + 27*ldb] + 1.70239108991215*b[i + 28*ldb] + -1.844372618022506*b[i + 29*ldb]);
        c[i + 98*ldc] = (0.1426282499190014*b[i + 15*ldb] + 1.063952765527867*b[i + 16*ldb] + -0.04922131659554296*b[i + 17*ldb] + -0.4140056597910398*b[i + 18*ldb] + -1.892059090254097*b[i + 19*ldb] + 0.2449733459341608*b[i + 20*ldb] + 0.6449410886103684*b[i + 21*ldb] + -0.01268686934620999*b[i + 22*ldb] + -3.824491607376837*b[i + 23*ldb] + -1.888703813519044*b[i + 24*ldb] + 0.02804075661045902*b[i + 25*ldb] + -0.2548046964372861*b[i + 26*ldb] + 1.893604927353485*b[i + 27*ldb] + 0.04923230933097847*b[i + 28*ldb] + -0.1863127236068944*b[i + 29*ldb]);
        c[i + 99*ldc] = (-0.04444015218558958*b[i + 15*ldb] + -2.9217023167422*b[i + 16*ldb] + -0.03302545659098766*b[i + 17*ldb] + 0.07052587748054273*b[i + 18*ldb] + -0.564050650085659*b[i + 19*ldb] + -0.01698433971579627*b[i + 20*ldb] + 0.5279041678421734*b[i + 21*ldb] + 0.02035288870568681*b[i + 22*ldb] + 0.01987965941343628*b[i + 23*ldb] + -3.581597315354408*b[i + 24*ldb] + -0.01215166511285262*b[i + 25*ldb] + 0.0459078476533179*b[i + 26*ldb] + -2.965388897477289*b[i + 27*ldb] + -0.04766271928616608*b[i + 28*ldb] + 0.2089760190013807*b[i + 29*ldb]);
        c[i + 100*ldc] = (0.6255688165573523*b[i + 15*ldb] + -0.1068368224642844*b[i + 16*ldb] + -2.583413129926359*b[i + 17*ldb] + -1.477330712695793*b[i + 18*ldb] + -0.6619114463571192*b[i + 19*ldb] + 1.546200852363405*b[i + 20*ldb] + 0.3742866353879682*b[i + 21*ldb] + 1.91592718061395*b[i + 22*ldb] + 1.355641220983662*b[i + 23*ldb] + 0.1590914669746716*b[i + 24*ldb] + 0.4497931998799397*b[i + 25*ldb] + -2.755439543527363*b[i + 26*ldb] + 0.1700384034174278*b[i + 27*ldb] + -0.8886523802884596*b[i + 28*ldb] + 1.639898802233694*b[i + 29*ldb]);
        c[i + 101*ldc] = (-0.07381136587329767*b[i + 15*ldb] + 0.6700089687429422*b[i + 16*ldb] + 0.3382891868158406*b[i + 17*ldb] + -0.6449271066413235*b[i + 18*ldb] + -1.547856590176338*b[i + 19*ldb] + 2.110251502449065*b[i + 20*ldb] + 1.896047521200515*b[i + 21*ldb] + -0.1536175324542066*b[i + 22*ldb] + 1.335288332277977*b[i + 23*ldb] + 1.687561521519859*b[i + 24*ldb] + 0.209949353949926*b[i + 25*ldb] + 4.031390515234344*b[i + 26*ldb] + -1.09762839928984*b[i + 27*ldb] + 0.1241305557641109*b[i + 28*ldb] + 0.1712431320875245*b[i + 29*ldb]);
        c[i + 102*ldc] = (0.03302545659098766*b[i + 15*ldb] + 2.9217023167422*b[i + 16*ldb] + 0.04444015218558958*b[i + 17*ldb] + 0.01698433971579627*b[i + 18*ldb] + 0.564050650085659*b[i + 19*ldb] + -0.07052587748054273*b[i + 20*ldb] + -0.01987965941343628*b[i + 21*ldb] + -0.02035288870568681*b[i + 22*ldb] + -0.5279041678421734*b[i + 23*ldb] + 2.965388897477289*b[i + 24*ldb] + 0.04766271928616608*b[i + 25*ldb] + -0.2089760190013807*b[i + 26*ldb] + 3.581597315354408*b[i + 27*ldb] + 0.01215166511285262*b[i + 28*ldb] + -0.0459078476533179*b[i + 29*ldb]);
        c[i + 103*ldc] = (2.583413129926359*b[i + 15*ldb] + 0.1068368224642844*b[i + 16*ldb] + -0.6255688165573523*b[i + 17*ldb] + -1.546200852363405*b[i + 18*ldb] + 0.6619114463571192*b[i + 19*ldb] + 1.477330712695793*b[i + 20*ldb] + -1.355641220983662*b[i + 21*ldb] + -1.91592718061395*b[i + 22*ldb] + -0.3742866353879682*b[i + 23*ldb] + -0.1700384034174278*b[i + 24*ldb] + 0.8886523802884596*b[i + 25*ldb] + -1.639898802233694*b[i + 26*ldb] + -0.1590914669746716*b[i + 27*ldb] + -0.4497931998799397*b[i + 28*ldb] + 2.755439543527363*b[i + 29*ldb]);
        c[i + 104*ldc] = (-0.3382891868158406*b[i + 15*ldb] + -0.6700089687429422*b[i + 16*ldb] + 0.07381136587329767*b[i + 17*ldb] + -2.110251502449065*b[i + 18*ldb] + 1.547856590176338*b[i + 19*ldb] + 0.6449271066413235*b[i + 20*ldb] + -1.335288332277977*b[i + 21*ldb] + 0.1536175324542066*b[i + 22*ldb] + -1.896047521200515*b[i + 23*ldb] + 1.09762839928984*b[i + 24*ldb] + -0.1241305557641109*b[i + 25*ldb] + -0.1712431320875245*b[i + 26*ldb] + -1.687561521519859*b[i + 27*ldb] + -0.209949353949926*b[i + 28*ldb] + -4.031390515234344*b[i + 29*ldb]);
        c[i + 105*ldc] = (-4.943623329974175*b[i + 30*ldb] + 0.5320310574554866*b[i + 31*ldb] + 0.5153686557558634*b[i + 32*ldb] + 2.118084753790551*b[i + 33*ldb] + -1.668497037618385*b[i + 34*ldb] + -1.604371058784565*b[i + 35*ldb] + 2.136333242112812*b[i + 36*ldb] + 1.189090704074046*b[i + 37*ldb] + 1.417537160346129*b[i + 38*ldb] + -0.7377711785520655*b[i + 39*ldb] + -0.6568015224866337*b[i + 40*ldb] + 1.526761453986784*b[i + 41*ldb] + 1.545789718896642*b[i + 42*ldb] + -3.174277239797759*b[i + 43*ldb] + -2.877453657493225*b[i + 44*ldb]);
        c[i + 106*ldc] = (0.01666240169962252*b[i + 30*ldb] + -0.01666240169962252*b[i + 32*ldb] + -0.06412597883381979*b[i + 33*ldb] + 0.06412597883381979*b[i + 35*ldb] + -0.2284464562720814*b[i + 36*ldb] + 0.2284464562720814*b[i + 38*ldb] + 0.2968235823045307*b[i + 39*ldb] + -0.01902826490985636*b[i + 40*ldb] + 0.0809696560654336*b[i + 41*ldb] + -0.2968235823045307*b[i + 42*ldb] + 0.01902826490985636*b[i + 43*ldb] + -0.0809696560654336*b[i + 44*ldb]);
        c[i + 107*ldc] = (-0.5153686557558634*b[i + 30*ldb] + -0.5320310574554866*b[i + 31*ldb] + 4.943623329974175*b[i + 32*ldb] + 1.604371058784565*b[i + 33*ldb] + 1.668497037618385*b[i + 34*ldb] + -2.118084753790551*b[i + 35*ldb] + -1.417537160346129*b[i + 36*ldb] + -1.189090704074046*b[i + 37*ldb] + -2.136333242112812*b[i + 38*ldb] + -1.545789718896642*b[i + 39*ldb] + 3.174277239797759*b[i + 40*ldb] + 2.877453657493225*b[i + 41*ldb] + 0.7377711785520655*b[i + 42*ldb] + 0.6568015224866337*b[i + 43*ldb] + -1.526761453986784*b[i + 44*ldb]);
        c[i + 108*ldc] = (0.04609417395922302*b[i + 30*ldb] + -0.1031803103571685*b[i + 31*ldb] + -0.01994163846801661*b[i + 32*ldb] + -0.3632813123758165*b[i + 33*ldb] + -1.492300533375874*b[i + 34*ldb] + -1.669005318468729*b[i + 35*ldb] + 1.730263001372271*b[i + 36*ldb] + -0.119528214542479*b[i + 37*ldb] + 2.388505535726159*b[i + 38*ldb] + -0.1709917888150785*b[i + 39*ldb] + 0.08153976883786418*b[i + 40*ldb] + 0.7288527548607495*b[i + 41*ldb] + 0.7604537642375322*b[i + 42*ldb] + 0.009187597244981638*b[i + 43*ldb] + 2.365427409367463*b[i + 44*ldb]);
        c[i + 109*ldc] = (-0.0832386718891518*b[i + 30*ldb] + 0.0832386718891518*b[i + 32*ldb] + 0.1767047850928541*b[i + 33*ldb] + -0.1767047850928541*b[i + 35*ldb] + -2.508033750268638*b[i + 36*ldb] + 2.508033750268638*b[i + 38*ldb] + 2.356239812122482*b[i + 39*ldb] + -0.03160100937678251*b[i + 40*ldb] + 0.2525315576529422*b[i + 41*ldb] + -2.356239812122482*b[i + 42*ldb] + 0.03160100937678251*b[i + 43*ldb] + -0.2525315576529422*b[i + 44*ldb]);
        c[i + 110*ldc] = (0.01994163846801661*b[i + 30*ldb] + 0.1031803103571685*b[i + 31*ldb] + -0.04609417395922302*b[i + 32*ldb] + 1.669005318468729*b[i + 33*ldb] + 1.492300533375874*b[i + 34*ldb] + 0.3632813123758165*b[i + 35*ldb] + -2.388505535726159*b[i + 36*ldb] + 0.119528214542479*b[i + 37*ldb] + -1.730263001372271*b[i + 38*ldb] + -0.7604537642375322*b[i + 39*ldb] + -0.009187597244981638*b[i + 40*ldb] + -2.365427409367463*b[i + 41*ldb] + 0.1709917888150785*b[i + 42*ldb] + -0.08153976883786418*b[i + 43*ldb] + -0.7288527548607495*b[i + 44*ldb]);
        c[i + 111*ldc] = (0.04922131659554296*b[i + 30*ldb] + -1.063952765527867*b[i + 31*ldb] + -0.1426282499190014*b[i + 32*ldb] + -0.2449733459341608*b[i + 33*ldb] + 1.892059090254097*b[i + 34*ldb] + 0.4140056597910398*b[i + 35*ldb] + 3.824491607376837*b[i + 36*ldb] + 0.01268686934620999*b[i + 37*ldb] + -0.6449410886103684*b[i + 38*ldb] + -1.893604927353485*b[i + 39*ldb] + -0.04923230933097847*b[i + 40*ldb] + 0.1863127236068944*b[i + 41*ldb] + 1.888703813519044*b[i + 42*ldb] + -0.02804075661045902*b[i + 43*ldb] + 0.2548046964372861*b[i + 44*ldb]);
        c[i + 112*ldc] = (-0.9213245156088653*b[i + 30*ldb] + 0.9213245156088653*b[i + 32*ldb] + 1.478053430463056*b[i + 33*ldb] + -1.478053430463056*b[i + 35*ldb] + 0.657627957956578*b[i + 36*ldb] + -0.657627957956578*b[i + 38*ldb] + 0.2828454530477449*b[i + 39*ldb] + -1.70239108991215*b[i + 40*ldb] + 1.844372618022506*b[i + 41*ldb] + -0.2828454530477449*b[i + 42*ldb] + 1.70239108991215*b[i + 43*ldb] + -1.844372618022506*b[i + 44*ldb]);
        c[i + 113*ldc] = (0.1426282499190014*b[i + 30*ldb] + 1.063952765527867*b[i + 31*ldb] + -0.04922131659554296*b[i + 32*ldb] + -0.4140056597910398*b[i + 33*ldb] + -1.892059090254097*b[i + 34*ldb] + 0.2449733459341608*b[i + 35*ldb] + 0.6449410886103684*b[i + 36*ldb] + -0.01268686934620999*b[i + 37*ldb] + -3.824491607376837*b[i + 38*ldb] + -1.888703813519044*b[i + 39*ldb] + 0.02804075661045902*b[i + 40*ldb] + -0.2548046964372861*b[i + 41*ldb] + 1.893604927353485*b[i + 42*ldb] + 0.04923230933097847*b[i + 43*ldb] + -0.1863127236068944*b[i + 44*ldb]);
        c[i + 114*ldc] = (-0.04444015218558958*b[i + 30*ldb] + -2.9217023167422*b[i + 31*ldb] + -0.03302545659098766*b[i + 32*ldb] + 0.07052587748054273*b[i + 33*ldb] + -0.564050650085659*b[i + 34*ldb] + -0.01698433971579627*b[i + 35*ldb] + 0.5279041678421734*b[i + 36*ldb] + 0.02035288870568681*b[i + 37*ldb] + 0.01987965941343628*b[i + 38*ldb] + -3.581597315354408*b[i + 39*ldb] + -0.01215166511285262*b[i + 40*ldb] + 0.0459078476533179*b[i + 41*ldb] + -2.965388897477289*b[i + 42*ldb] + -0.04766271928616608*b[i + 43*ldb] + 0.2089760190013807*b[i + 44*ldb]);
        c[i + 115*ldc] = (0.6255688165573523*b[i + 30*ldb] + -0.1068368224642844*b[i + 31*ldb] + -2.583413129926359*b[i + 32*ldb] + -1.477330712695793*b[i + 33*ldb] + -0.6619114463571192*b[i + 34*ldb] + 1.546200852363405*b[i + 35*ldb] + 0.3742866353879682*b[i + 36*ldb] + 1.91592718061395*b[i + 37*ldb] + 1.355641220983662*b[i + 38*ldb] + 0.1590914669746716*b[i + 39*ldb] + 0.4497931998799397*b[i + 40*ldb] + -2.755439543527363*b[i + 41*ldb] + 0.1700384034174278*b[i + 42*ldb] + -0.8886523802884596*b[i + 43*ldb] + 1.639898802233694*b[i + 44*ldb]);
        c[i + 116*ldc] = (-0.07381136587329767*b[i + 30*ldb] + 0.6700089687429422*b[i + 31*ldb] + 0.3382891868158406*b[i + 32*ldb] + -0.6449271066413235*b[i + 33*ldb] + -1.547856590176338*b[i + 34*ldb] + 2.110251502449065*b[i + 35*ldb] + 1.896047521200515*b[i + 36*ldb] + -0.1536175324542066*b[i + 37*ldb] + 1.335288332277977*b[i + 38*ldb] + 1.687561521519859*b[i + 39*ldb] + 0.209949353949926*b[i + 40*ldb] + 4.031390515234344*b[i + 41*ldb] + -1.09762839928984*b[i + 42*ldb] + 0.1241305557641109*b[i + 43*ldb] + 0.1712431320875245*b[i + 44*ldb]);
        c[i + 117*ldc] = (0.03302545659098766*b[i + 30*ldb] + 2.9217023167422*b[i + 31*ldb] + 0.04444015218558958*b[i + 32*ldb] + 0.01698433971579627*b[i + 33*ldb] + 0.564050650085659*b[i + 34*ldb] + -0.07052587748054273*b[i + 35*ldb] + -0.01987965941343628*b[i + 36*ldb] + -0.02035288870568681*b[i + 37*ldb] + -0.5279041678421734*b[i + 38*ldb] + 2.965388897477289*b[i + 39*ldb] + 0.04766271928616608*b[i + 40*ldb] + -0.2089760190013807*b[i + 41*ldb] + 3.581597315354408*b[i + 42*ldb] + 0.01215166511285262*b[i + 43*ldb] + -0.0459078476533179*b[i + 44*ldb]);
        c[i + 118*ldc] = (2.583413129926359*b[i + 30*ldb] + 0.1068368224642844*b[i + 31*ldb] + -0.6255688165573523*b[i + 32*ldb] + -1.546200852363405*b[i + 33*ldb] + 0.6619114463571192*b[i + 34*ldb] + 1.477330712695793*b[i + 35*ldb] + -1.355641220983662*b[i + 36*ldb] + -1.91592718061395*b[i + 37*ldb] + -0.3742866353879682*b[i + 38*ldb] + -0.1700384034174278*b[i + 39*ldb] + 0.8886523802884596*b[i + 40*ldb] + -1.639898802233694*b[i + 41*ldb] + -0.1590914669746716*b[i + 42*ldb] + -0.4497931998799397*b[i + 43*ldb] + 2.755439543527363*b[i + 44*ldb]);
        c[i + 119*ldc] = (-0.3382891868158406*b[i + 30*ldb] + -0.6700089687429422*b[i + 31*ldb] + 0.07381136587329767*b[i + 32*ldb] + -2.110251502449065*b[i + 33*ldb] + 1.547856590176338*b[i + 34*ldb] + 0.6449271066413235*b[i + 35*ldb] + -1.335288332277977*b[i + 36*ldb] + 0.1536175324542066*b[i + 37*ldb] + -1.896047521200515*b[i + 38*ldb] + 1.09762839928984*b[i + 39*ldb] + -0.1241305557641109*b[i + 40*ldb] + -0.1712431320875245*b[i + 41*ldb] + -1.687561521519859*b[i + 42*ldb] + -0.209949353949926*b[i + 43*ldb] + -4.031390515234344*b[i + 44*ldb]);
        c[i + 120*ldc] = (-4.943623329974175*b[i + 45*ldb] + 0.5320310574554866*b[i + 46*ldb] + 0.5153686557558634*b[i + 47*ldb] + 2.118084753790551*b[i + 48*ldb] + -1.668497037618385*b[i + 49*ldb] + -1.604371058784565*b[i + 50*ldb] + 2.136333242112812*b[i + 51*ldb] + 1.189090704074046*b[i + 52*ldb] + 1.417537160346129*b[i + 53*ldb] + -0.7377711785520655*b[i + 54*ldb] + -0.6568015224866337*b[i + 55*ldb] + 1.526761453986784*b[i + 56*ldb] + 1.545789718896642*b[i + 57*ldb] + -3.174277239797759*b[i + 58*ldb] + -2.877453657493225*b[i + 59*ldb]);
        c[i + 121*ldc] = (0.01666240169962252*b[i + 45*ldb] + -0.01666240169962252*b[i + 47*ldb] + -0.06412597883381979*b[i + 48*ldb] + 0.06412597883381979*b[i + 50*ldb] + -0.2284464562720814*b[i + 51*ldb] + 0.2284464562720814*b[i + 53*ldb] + 0.2968235823045307*b[i + 54*ldb] + -0.01902826490985636*b[i + 55*ldb] + 0.0809696560654336*b[i + 56*ldb] + -0.2968235823045307*b[i + 57*ldb] + 0.01902826490985636*b[i + 58*ldb] + -0.0809696560654336*b[i + 59*ldb]);
        c[i + 122*ldc] = (-0.5153686557558634*b[i + 45*ldb] + -0.5320310574554866*b[i + 46*ldb] + 4.943623329974175*b[i + 47*ldb] + 1.604371058784565*b[i + 48*ldb] + 1.668497037618385*b[i + 49*ldb] + -2.118084753790551*b[i + 50*ldb] + -1.417537160346129*b[i + 51*ldb] + -1.189090704074046*b[i + 52*ldb] + -2.136333242112812*b[i + 53*ldb] + -1.545789718896642*b[i + 54*ldb] + 3.174277239797759*b[i + 55*ldb] + 2.877453657493225*b[i + 56*ldb] + 0.7377711785520655*b[i + 57*ldb] + 0.6568015224866337*b[i + 58*ldb] + -1.526761453986784*b[i + 59*ldb]);
        c[i + 123*ldc] = (0.04609417395922302*b[i + 45*ldb] + -0.1031803103571685*b[i + 46*ldb] + -0.01994163846801661*b[i + 47*ldb] + -0.3632813123758165*b[i + 48*ldb] + -1.492300533375874*b[i + 49*ldb] + -1.669005318468729*b[i + 50*ldb] + 1.730263001372271*b[i + 51*ldb] + -0.119528214542479*b[i + 52*ldb] + 2.388505535726159*b[i + 53*ldb] + -0.1709917888150785*b[i + 54*ldb] + 0.08153976883786418*b[i + 55*ldb] + 0.7288527548607495*b[i + 56*ldb] + 0.7604537642375322*b[i + 57*ldb] + 0.009187597244981638*b[i + 58*ldb] + 2.365427409367463*b[i + 59*ldb]);
        c[i + 124*ldc] = (-0.0832386718891518*b[i + 45*ldb] + 0.0832386718891518*b[i + 47*ldb] + 0.1767047850928541*b[i + 48*ldb] + -0.1767047850928541*b[i + 50*ldb] + -2.508033750268638*b[i + 51*ldb] + 2.508033750268638*b[i + 53*ldb] + 2.356239812122482*b[i + 54*ldb] + -0.03160100937678251*b[i + 55*ldb] + 0.2525315576529422*b[i + 56*ldb] + -2.356239812122482*b[i + 57*ldb] + 0.03160100937678251*b[i + 58*ldb] + -0.2525315576529422*b[i + 59*ldb]);
        c[i + 125*ldc] = (0.01994163846801661*b[i + 45*ldb] + 0.1031803103571685*b[i + 46*ldb] + -0.04609417395922302*b[i + 47*ldb] + 1.669005318468729*b[i + 48*ldb] + 1.492300533375874*b[i + 49*ldb] + 0.3632813123758165*b[i + 50*ldb] + -2.388505535726159*b[i + 51*ldb] + 0.119528214542479*b[i + 52*ldb] + -1.730263001372271*b[i + 53*ldb] + -0.7604537642375322*b[i + 54*ldb] + -0.009187597244981638*b[i + 55*ldb] + -2.365427409367463*b[i + 56*ldb] + 0.1709917888150785*b[i + 57*ldb] + -0.08153976883786418*b[i + 58*ldb] + -0.7288527548607495*b[i + 59*ldb]);
        c[i + 126*ldc] = (0.04922131659554296*b[i + 45*ldb] + -1.063952765527867*b[i + 46*ldb] + -0.1426282499190014*b[i + 47*ldb] + -0.2449733459341608*b[i + 48*ldb] + 1.892059090254097*b[i + 49*ldb] + 0.4140056597910398*b[i + 50*ldb] + 3.824491607376837*b[i + 51*ldb] + 0.01268686934620999*b[i + 52*ldb] + -0.6449410886103684*b[i + 53*ldb] + -1.893604927353485*b[i + 54*ldb] + -0.04923230933097847*b[i + 55*ldb] + 0.1863127236068944*b[i + 56*ldb] + 1.888703813519044*b[i + 57*ldb] + -0.02804075661045902*b[i + 58*ldb] + 0.2548046964372861*b[i + 59*ldb]);
        c[i + 127*ldc] = (-0.9213245156088653*b[i + 45*ldb] + 0.9213245156088653*b[i + 47*ldb] + 1.478053430463056*b[i + 48*ldb] + -1.478053430463056*b[i + 50*ldb] + 0.657627957956578*b[i + 51*ldb] + -0.657627957956578*b[i + 53*ldb] + 0.2828454530477449*b[i + 54*ldb] + -1.70239108991215*b[i + 55*ldb] + 1.844372618022506*b[i + 56*ldb] + -0.2828454530477449*b[i + 57*ldb] + 1.70239108991215*b[i + 58*ldb] + -1.844372618022506*b[i + 59*ldb]);
        c[i + 128*ldc] = (0.1426282499190014*b[i + 45*ldb] + 1.063952765527867*b[i + 46*ldb] + -0.04922131659554296*b[i + 47*ldb] + -0.4140056597910398*b[i + 48*ldb] + -1.892059090254097*b[i + 49*ldb] + 0.2449733459341608*b[i + 50*ldb] + 0.6449410886103684*b[i + 51*ldb] + -0.01268686934620999*b[i + 52*ldb] + -3.824491607376837*b[i + 53*ldb] + -1.888703813519044*b[i + 54*ldb] + 0.02804075661045902*b[i + 55*ldb] + -0.2548046964372861*b[i + 56*ldb] + 1.893604927353485*b[i + 57*ldb] + 0.04923230933097847*b[i + 58*ldb] + -0.1863127236068944*b[i + 59*ldb]);
        c[i + 129*ldc] = (-0.04444015218558958*b[i + 45*ldb] + -2.9217023167422*b[i + 46*ldb] + -0.03302545659098766*b[i + 47*ldb] + 0.07052587748054273*b[i + 48*ldb] + -0.564050650085659*b[i + 49*ldb] + -0.01698433971579627*b[i + 50*ldb] + 0.5279041678421734*b[i + 51*ldb] + 0.02035288870568681*b[i + 52*ldb] + 0.01987965941343628*b[i + 53*ldb] + -3.581597315354408*b[i + 54*ldb] + -0.01215166511285262*b[i + 55*ldb] + 0.0459078476533179*b[i + 56*ldb] + -2.965388897477289*b[i + 57*ldb] + -0.04766271928616608*b[i + 58*ldb] + 0.2089760190013807*b[i + 59*ldb]);
        c[i + 130*ldc] = (0.6255688165573523*b[i + 45*ldb] + -0.1068368224642844*b[i + 46*ldb] + -2.583413129926359*b[i + 47*ldb] + -1.477330712695793*b[i + 48*ldb] + -0.6619114463571192*b[i + 49*ldb] + 1.546200852363405*b[i + 50*ldb] + 0.3742866353879682*b[i + 51*ldb] + 1.91592718061395*b[i + 52*ldb] + 1.355641220983662*b[i + 53*ldb] + 0.1590914669746716*b[i + 54*ldb] + 0.4497931998799397*b[i + 55*ldb] + -2.755439543527363*b[i + 56*ldb] + 0.1700384034174278*b[i + 57*ldb] + -0.8886523802884596*b[i + 58*ldb] + 1.639898802233694*b[i + 59*ldb]);
        c[i + 131*ldc] = (-0.07381136587329767*b[i + 45*ldb] + 0.6700089687429422*b[i + 46*ldb] + 0.3382891868158406*b[i + 47*ldb] + -0.6449271066413235*b[i + 48*ldb] + -1.547856590176338*b[i + 49*ldb] + 2.110251502449065*b[i + 50*ldb] + 1.896047521200515*b[i + 51*ldb] + -0.1536175324542066*b[i + 52*ldb] + 1.335288332277977*b[i + 53*ldb] + 1.687561521519859*b[i + 54*ldb] + 0.209949353949926*b[i + 55*ldb] + 4.031390515234344*b[i + 56*ldb] + -1.09762839928984*b[i + 57*ldb] + 0.1241305557641109*b[i + 58*ldb] + 0.1712431320875245*b[i + 59*ldb]);
        c[i + 132*ldc] = (0.03302545659098766*b[i + 45*ldb] + 2.9217023167422*b[i + 46*ldb] + 0.04444015218558958*b[i + 47*ldb] + 0.01698433971579627*b[i + 48*ldb] + 0.564050650085659*b[i + 49*ldb] + -0.07052587748054273*b[i + 50*ldb] + -0.01987965941343628*b[i + 51*ldb] + -0.02035288870568681*b[i + 52*ldb] + -0.5279041678421734*b[i + 53*ldb] + 2.965388897477289*b[i + 54*ldb] + 0.04766271928616608*b[i + 55*ldb] + -0.2089760190013807*b[i + 56*ldb] + 3.581597315354408*b[i + 57*ldb] + 0.01215166511285262*b[i + 58*ldb] + -0.0459078476533179*b[i + 59*ldb]);
        c[i + 133*ldc] = (2.583413129926359*b[i + 45*ldb] + 0.1068368224642844*b[i + 46*ldb] + -0.6255688165573523*b[i + 47*ldb] + -1.546200852363405*b[i + 48*ldb] + 0.6619114463571192*b[i + 49*ldb] + 1.477330712695793*b[i + 50*ldb] + -1.355641220983662*b[i + 51*ldb] + -1.91592718061395*b[i + 52*ldb] + -0.3742866353879682*b[i + 53*ldb] + -0.1700384034174278*b[i + 54*ldb] + 0.8886523802884596*b[i + 55*ldb] + -1.639898802233694*b[i + 56*ldb] + -0.1590914669746716*b[i + 57*ldb] + -0.4497931998799397*b[i + 58*ldb] + 2.755439543527363*b[i + 59*ldb]);
        c[i + 134*ldc] = (-0.3382891868158406*b[i + 45*ldb] + -0.6700089687429422*b[i + 46*ldb] + 0.07381136587329767*b[i + 47*ldb] + -2.110251502449065*b[i + 48*ldb] + 1.547856590176338*b[i + 49*ldb] + 0.6449271066413235*b[i + 50*ldb] + -1.335288332277977*b[i + 51*ldb] + 0.1536175324542066*b[i + 52*ldb] + -1.896047521200515*b[i + 53*ldb] + 1.09762839928984*b[i + 54*ldb] + -0.1241305557641109*b[i + 55*ldb] + -0.1712431320875245*b[i + 56*ldb] + -1.687561521519859*b[i + 57*ldb] + -0.209949353949926*b[i + 58*ldb] + -4.031390515234344*b[i + 59*ldb]);
        c[i + 135*ldc] = (-4.943623329974175*b[i + 60*ldb] + 0.5320310574554866*b[i + 61*ldb] + 0.5153686557558634*b[i + 62*ldb] + 2.118084753790551*b[i + 63*ldb] + -1.668497037618385*b[i + 64*ldb] + -1.604371058784565*b[i + 65*ldb] + 2.136333242112812*b[i + 66*ldb] + 1.189090704074046*b[i + 67*ldb] + 1.417537160346129*b[i + 68*ldb] + -0.7377711785520655*b[i + 69*ldb] + -0.6568015224866337*b[i + 70*ldb] + 1.526761453986784*b[i + 71*ldb] + 1.545789718896642*b[i + 72*ldb] + -3.174277239797759*b[i + 73*ldb] + -2.877453657493225*b[i + 74*ldb]);
        c[i + 136*ldc] = (0.01666240169962252*b[i + 60*ldb] + -0.01666240169962252*b[i + 62*ldb] + -0.06412597883381979*b[i + 63*ldb] + 0.06412597883381979*b[i + 65*ldb] + -0.2284464562720814*b[i + 66*ldb] + 0.2284464562720814*b[i + 68*ldb] + 0.2968235823045307*b[i + 69*ldb] + -0.01902826490985636*b[i + 70*ldb] + 0.0809696560654336*b[i + 71*ldb] + -0.2968235823045307*b[i + 72*ldb] + 0.01902826490985636*b[i + 73*ldb] + -0.0809696560654336*b[i + 74*ldb]);
        c[i + 137*ldc] = (-0.5153686557558634*b[i + 60*ldb] + -0.5320310574554866*b[i + 61*ldb] + 4.943623329974175*b[i + 62*ldb] + 1.604371058784565*b[i + 63*ldb] + 1.668497037618385*b[i + 64*ldb] + -2.118084753790551*b[i + 65*ldb] + -1.417537160346129*b[i + 66*ldb] + -1.189090704074046*b[i + 67*ldb] + -2.136333242112812*b[i + 68*ldb] + -1.545789718896642*b[i + 69*ldb] + 3.174277239797759*b[i + 70*ldb] + 2.877453657493225*b[i + 71*ldb] + 0.7377711785520655*b[i + 72*ldb] + 0.6568015224866337*b[i + 73*ldb] + -1.526761453986784*b[i + 74*ldb]);
        c[i + 138*ldc] = (0.04609417395922302*b[i + 60*ldb] + -0.1031803103571685*b[i + 61*ldb] + -0.01994163846801661*b[i + 62*ldb] + -0.3632813123758165*b[i + 63*ldb] + -1.492300533375874*b[i + 64*ldb] + -1.669005318468729*b[i + 65*ldb] + 1.730263001372271*b[i + 66*ldb] + -0.119528214542479*b[i + 67*ldb] + 2.388505535726159*b[i + 68*ldb] + -0.1709917888150785*b[i + 69*ldb] + 0.08153976883786418*b[i + 70*ldb] + 0.7288527548607495*b[i + 71*ldb] + 0.7604537642375322*b[i + 72*ldb] + 0.009187597244981638*b[i + 73*ldb] + 2.365427409367463*b[i + 74*ldb]);
        c[i + 139*ldc] = (-0.0832386718891518*b[i + 60*ldb] + 0.0832386718891518*b[i + 62*ldb] + 0.1767047850928541*b[i + 63*ldb] + -0.1767047850928541*b[i + 65*ldb] + -2.508033750268638*b[i + 66*ldb] + 2.508033750268638*b[i + 68*ldb] + 2.356239812122482*b[i + 69*ldb] + -0.03160100937678251*b[i + 70*ldb] + 0.2525315576529422*b[i + 71*ldb] + -2.356239812122482*b[i + 72*ldb] + 0.03160100937678251*b[i + 73*ldb] + -0.2525315576529422*b[i + 74*ldb]);
        c[i + 140*ldc] = (0.01994163846801661*b[i + 60*ldb] + 0.1031803103571685*b[i + 61*ldb] + -0.04609417395922302*b[i + 62*ldb] + 1.669005318468729*b[i + 63*ldb] + 1.492300533375874*b[i + 64*ldb] + 0.3632813123758165*b[i + 65*ldb] + -2.388505535726159*b[i + 66*ldb] + 0.119528214542479*b[i + 67*ldb] + -1.730263001372271*b[i + 68*ldb] + -0.7604537642375322*b[i + 69*ldb] + -0.009187597244981638*b[i + 70*ldb] + -2.365427409367463*b[i + 71*ldb] + 0.1709917888150785*b[i + 72*ldb] + -0.08153976883786418*b[i + 73*ldb] + -0.7288527548607495*b[i + 74*ldb]);
        c[i + 141*ldc] = (0.04922131659554296*b[i + 60*ldb] + -1.063952765527867*b[i + 61*ldb] + -0.1426282499190014*b[i + 62*ldb] + -0.2449733459341608*b[i + 63*ldb] + 1.892059090254097*b[i + 64*ldb] + 0.4140056597910398*b[i + 65*ldb] + 3.824491607376837*b[i + 66*ldb] + 0.01268686934620999*b[i + 67*ldb] + -0.6449410886103684*b[i + 68*ldb] + -1.893604927353485*b[i + 69*ldb] + -0.04923230933097847*b[i + 70*ldb] + 0.1863127236068944*b[i + 71*ldb] + 1.888703813519044*b[i + 72*ldb] + -0.02804075661045902*b[i + 73*ldb] + 0.2548046964372861*b[i + 74*ldb]);
        c[i + 142*ldc] = (-0.9213245156088653*b[i + 60*ldb] + 0.9213245156088653*b[i + 62*ldb] + 1.478053430463056*b[i + 63*ldb] + -1.478053430463056*b[i + 65*ldb] + 0.657627957956578*b[i + 66*ldb] + -0.657627957956578*b[i + 68*ldb] + 0.2828454530477449*b[i + 69*ldb] + -1.70239108991215*b[i + 70*ldb] + 1.844372618022506*b[i + 71*ldb] + -0.2828454530477449*b[i + 72*ldb] + 1.70239108991215*b[i + 73*ldb] + -1.844372618022506*b[i + 74*ldb]);
        c[i + 143*ldc] = (0.1426282499190014*b[i + 60*ldb] + 1.063952765527867*b[i + 61*ldb] + -0.04922131659554296*b[i + 62*ldb] + -0.4140056597910398*b[i + 63*ldb] + -1.892059090254097*b[i + 64*ldb] + 0.2449733459341608*b[i + 65*ldb] + 0.6449410886103684*b[i + 66*ldb] + -0.01268686934620999*b[i + 67*ldb] + -3.824491607376837*b[i + 68*ldb] + -1.888703813519044*b[i + 69*ldb] + 0.02804075661045902*b[i + 70*ldb] + -0.2548046964372861*b[i + 71*ldb] + 1.893604927353485*b[i + 72*ldb] + 0.04923230933097847*b[i + 73*ldb] + -0.1863127236068944*b[i + 74*ldb]);
        c[i + 144*ldc] = (-0.04444015218558958*b[i + 60*ldb] + -2.9217023167422*b[i + 61*ldb] + -0.03302545659098766*b[i + 62*ldb] + 0.07052587748054273*b[i + 63*ldb] + -0.564050650085659*b[i + 64*ldb] + -0.01698433971579627*b[i + 65*ldb] + 0.5279041678421734*b[i + 66*ldb] + 0.02035288870568681*b[i + 67*ldb] + 0.01987965941343628*b[i + 68*ldb] + -3.581597315354408*b[i + 69*ldb] + -0.01215166511285262*b[i + 70*ldb] + 0.0459078476533179*b[i + 71*ldb] + -2.965388897477289*b[i + 72*ldb] + -0.04766271928616608*b[i + 73*ldb] + 0.2089760190013807*b[i + 74*ldb]);
        c[i + 145*ldc] = (0.6255688165573523*b[i + 60*ldb] + -0.1068368224642844*b[i + 61*ldb] + -2.583413129926359*b[i + 62*ldb] + -1.477330712695793*b[i + 63*ldb] + -0.6619114463571192*b[i + 64*ldb] + 1.546200852363405*b[i + 65*ldb] + 0.3742866353879682*b[i + 66*ldb] + 1.91592718061395*b[i + 67*ldb] + 1.355641220983662*b[i + 68*ldb] + 0.1590914669746716*b[i + 69*ldb] + 0.4497931998799397*b[i + 70*ldb] + -2.755439543527363*b[i + 71*ldb] + 0.1700384034174278*b[i + 72*ldb] + -0.8886523802884596*b[i + 73*ldb] + 1.639898802233694*b[i + 74*ldb]);
        c[i + 146*ldc] = (-0.07381136587329767*b[i + 60*ldb] + 0.6700089687429422*b[i + 61*ldb] + 0.3382891868158406*b[i + 62*ldb] + -0.6449271066413235*b[i + 63*ldb] + -1.547856590176338*b[i + 64*ldb] + 2.110251502449065*b[i + 65*ldb] + 1.896047521200515*b[i + 66*ldb] + -0.1536175324542066*b[i + 67*ldb] + 1.335288332277977*b[i + 68*ldb] + 1.687561521519859*b[i + 69*ldb] + 0.209949353949926*b[i + 70*ldb] + 4.031390515234344*b[i + 71*ldb] + -1.09762839928984*b[i + 72*ldb] + 0.1241305557641109*b[i + 73*ldb] + 0.1712431320875245*b[i + 74*ldb]);
        c[i + 147*ldc] = (0.03302545659098766*b[i + 60*ldb] + 2.9217023167422*b[i + 61*ldb] + 0.04444015218558958*b[i + 62*ldb] + 0.01698433971579627*b[i + 63*ldb] + 0.564050650085659*b[i + 64*ldb] + -0.07052587748054273*b[i + 65*ldb] + -0.01987965941343628*b[i + 66*ldb] + -0.02035288870568681*b[i + 67*ldb] + -0.5279041678421734*b[i + 68*ldb] + 2.965388897477289*b[i + 69*ldb] + 0.04766271928616608*b[i + 70*ldb] + -0.2089760190013807*b[i + 71*ldb] + 3.581597315354408*b[i + 72*ldb] + 0.01215166511285262*b[i + 73*ldb] + -0.0459078476533179*b[i + 74*ldb]);
        c[i + 148*ldc] = (2.583413129926359*b[i + 60*ldb] + 0.1068368224642844*b[i + 61*ldb] + -0.6255688165573523*b[i + 62*ldb] + -1.546200852363405*b[i + 63*ldb] + 0.6619114463571192*b[i + 64*ldb] + 1.477330712695793*b[i + 65*ldb] + -1.355641220983662*b[i + 66*ldb] + -1.91592718061395*b[i + 67*ldb] + -0.3742866353879682*b[i + 68*ldb] + -0.1700384034174278*b[i + 69*ldb] + 0.8886523802884596*b[i + 70*ldb] + -1.639898802233694*b[i + 71*ldb] + -0.1590914669746716*b[i + 72*ldb] + -0.4497931998799397*b[i + 73*ldb] + 2.755439543527363*b[i + 74*ldb]);
        c[i + 149*ldc] = (-0.3382891868158406*b[i + 60*ldb] + -0.6700089687429422*b[i + 61*ldb] + 0.07381136587329767*b[i + 62*ldb] + -2.110251502449065*b[i + 63*ldb] + 1.547856590176338*b[i + 64*ldb] + 0.6449271066413235*b[i + 65*ldb] + -1.335288332277977*b[i + 66*ldb] + 0.1536175324542066*b[i + 67*ldb] + -1.896047521200515*b[i + 68*ldb] + 1.09762839928984*b[i + 69*ldb] + -0.1241305557641109*b[i + 70*ldb] + -0.1712431320875245*b[i + 71*ldb] + -1.687561521519859*b[i + 72*ldb] + -0.209949353949926*b[i + 73*ldb] + -4.031390515234344*b[i + 74*ldb]);
        c[i + 150*ldc] = (5.067040595654547*b[i + 0*ldb] + 1.939864544376094*b[i + 15*ldb] + -0.7231396289857275*b[i + 30*ldb] + 0.4937590750470335*b[i + 45*ldb] + -0.551766850963316*b[i + 60*ldb]);
        c[i + 151*ldc] = (5.067040595654547*b[i + 1*ldb] + 1.939864544376094*b[i + 16*ldb] + -0.7231396289857275*b[i + 31*ldb] + 0.4937590750470335*b[i + 46*ldb] + -0.551766850963316*b[i + 61*ldb]);
        c[i + 152*ldc] = (5.067040595654547*b[i + 2*ldb] + 1.939864544376094*b[i + 17*ldb] + -0.7231396289857275*b[i + 32*ldb] + 0.4937590750470335*b[i + 47*ldb] + -0.551766850963316*b[i + 62*ldb]);
        c[i + 153*ldc] = (5.067040595654547*b[i + 3*ldb] + 1.939864544376094*b[i + 18*ldb] + -0.7231396289857275*b[i + 33*ldb] + 0.4937590750470335*b[i + 48*ldb] + -0.551766850963316*b[i + 63*ldb]);
        c[i + 154*ldc] = (5.067040595654547*b[i + 4*ldb] + 1.939864544376094*b[i + 19*ldb] + -0.7231396289857275*b[i + 34*ldb] + 0.4937590750470335*b[i + 49*ldb] + -0.551766850963316*b[i + 64*ldb]);
        c[i + 155*ldc] = (5.067040595654547*b[i + 5*ldb] + 1.939864544376094*b[i + 20*ldb] + -0.7231396289857275*b[i + 35*ldb] + 0.4937590750470335*b[i + 50*ldb] + -0.551766850963316*b[i + 65*ldb]);
        c[i + 156*ldc] = (5.067040595654547*b[i + 6*ldb] + 1.939864544376094*b[i + 21*ldb] + -0.7231396289857275*b[i + 36*ldb] + 0.4937590750470335*b[i + 51*ldb] + -0.551766850963316*b[i + 66*ldb]);
        c[i + 157*ldc] = (5.067040595654547*b[i + 7*ldb] + 1.939864544376094*b[i + 22*ldb] + -0.7231396289857275*b[i + 37*ldb] + 0.4937590750470335*b[i + 52*ldb] + -0.551766850963316*b[i + 67*ldb]);
        c[i + 158*ldc] = (5.067040595654547*b[i + 8*ldb] + 1.939864544376094*b[i + 23*ldb] + -0.7231396289857275*b[i + 38*ldb] + 0.4937590750470335*b[i + 53*ldb] + -0.551766850963316*b[i + 68*ldb]);
        c[i + 159*ldc] = (5.067040595654547*b[i + 9*ldb] + 1.939864544376094*b[i + 24*ldb] + -0.7231396289857275*b[i + 39*ldb] + 0.4937590750470335*b[i + 54*ldb] + -0.551766850963316*b[i + 69*ldb]);
        c[i + 160*ldc] = (5.067040595654547*b[i + 10*ldb] + 1.939864544376094*b[i + 25*ldb] + -0.7231396289857275*b[i + 40*ldb] + 0.4937590750470335*b[i + 55*ldb] + -0.551766850963316*b[i + 70*ldb]);
        c[i + 161*ldc] = (5.067040595654547*b[i + 11*ldb] + 1.939864544376094*b[i + 26*ldb] + -0.7231396289857275*b[i + 41*ldb] + 0.4937590750470335*b[i + 56*ldb] + -0.551766850963316*b[i + 71*ldb]);
        c[i + 162*ldc] = (5.067040595654547*b[i + 12*ldb] + 1.939864544376094*b[i + 27*ldb] + -0.7231396289857275*b[i + 42*ldb] + 0.4937590750470335*b[i + 57*ldb] + -0.551766850963316*b[i + 72*ldb]);
        c[i + 163*ldc] = (5.067040595654547*b[i + 13*ldb] + 1.939864544376094*b[i + 28*ldb] + -0.7231396289857275*b[i + 43*ldb] + 0.4937590750470335*b[i + 58*ldb] + -0.551766850963316*b[i + 73*ldb]);
        c[i + 164*ldc] = (5.067040595654547*b[i + 14*ldb] + 1.939864544376094*b[i + 29*ldb] + -0.7231396289857275*b[i + 44*ldb] + 0.4937590750470335*b[i + 59*ldb] + -0.551766850963316*b[i + 74*ldb]);
        c[i + 165*ldc] = (-3.812557894803956*b[i + 0*ldb] + 0.7583532171678773*b[i + 15*ldb] + 1.70607502775383*b[i + 30*ldb] + -0.9285580266438336*b[i + 45*ldb] + 0.9704208807564543*b[i + 60*ldb]);
        c[i + 166*ldc] = (-3.812557894803956*b[i + 1*ldb] + 0.7583532171678773*b[i + 16*ldb] + 1.70607502775383*b[i + 31*ldb] + -0.9285580266438336*b[i + 46*ldb] + 0.9704208807564543*b[i + 61*ldb]);
        c[i + 167*ldc] = (-3.812557894803956*b[i + 2*ldb] + 0.7583532171678773*b[i + 17*ldb] + 1.70607502775383*b[i + 32*ldb] + -0.9285580266438336*b[i + 47*ldb] + 0.9704208807564543*b[i + 62*ldb]);
        c[i + 168*ldc] = (-3.812557894803956*b[i + 3*ldb] + 0.7583532171678773*b[i + 18*ldb] + 1.70607502775383*b[i + 33*ldb] + -0.9285580266438336*b[i + 48*ldb] + 0.9704208807564543*b[i + 63*ldb]);
        c[i + 169*ldc] = (-3.812557894803956*b[i + 4*ldb] + 0.7583532171678773*b[i + 19*ldb] + 1.70607502775383*b[i + 34*ldb] + -0.9285580266438336*b[i + 49*ldb] + 0.9704208807564543*b[i + 64*ldb]);
        c[i + 170*ldc] = (-3.812557894803956*b[i + 5*ldb] + 0.7583532171678773*b[i + 20*ldb] + 1.70607502775383*b[i + 35*ldb] + -0.9285580266438336*b[i + 50*ldb] + 0.9704208807564543*b[i + 65*ldb]);
        c[i + 171*ldc] = (-3.812557894803956*b[i + 6*ldb] + 0.7583532171678773*b[i + 21*ldb] + 1.70607502775383*b[i + 36*ldb] + -0.9285580266438336*b[i + 51*ldb] + 0.9704208807564543*b[i + 66*ldb]);
        c[i + 172*ldc] = (-3.812557894803956*b[i + 7*ldb] + 0.7583532171678773*b[i + 22*ldb] + 1.70607502775383*b[i + 37*ldb] + -0.9285580266438336*b[i + 52*ldb] + 0.9704208807564543*b[i + 67*ldb]);
        c[i + 173*ldc] = (-3.812557894803956*b[i + 8*ldb] + 0.7583532171678773*b[i + 23*ldb] + 1.70607502775383*b[i + 38*ldb] + -0.9285580266438336*b[i + 53*ldb] + 0.9704208807564543*b[i + 68*ldb]);
        c[i + 174*ldc] = (-3.812557894803956*b[i + 9*ldb] + 0.7583532171678773*b[i + 24*ldb] + 1.70607502775383*b[i + 39*ldb] + -0.9285580266438336*b[i + 54*ldb] + 0.9704208807564543*b[i + 69*ldb]);
        c[i + 175*ldc] = (-3.812557894803956*b[i + 10*ldb] + 0.7583532171678773*b[i + 25*ldb] + 1.70607502775383*b[i + 40*ldb] + -0.9285580266438336*b[i + 55*ldb] + 0.9704208807564543*b[i + 70*ldb]);
        c[i + 176*ldc] = (-3.812557894803956*b[i + 11*ldb] + 0.7583532171678773*b[i + 26*ldb] + 1.70607502775383*b[i + 41*ldb] + -0.9285580266438336*b[i + 56*ldb] + 0.9704208807564543*b[i + 71*ldb]);
        c[i + 177*ldc] = (-3.812557894803956*b[i + 12*ldb] + 0.7583532171678773*b[i + 27*ldb] + 1.70607502775383*b[i + 42*ldb] + -0.9285580266438336*b[i + 57*ldb] + 0.9704208807564543*b[i + 72*ldb]);
        c[i + 178*ldc] = (-3.812557894803956*b[i + 13*ldb] + 0.7583532171678773*b[i + 28*ldb] + 1.70607502775383*b[i + 43*ldb] + -0.9285580266438336*b[i + 58*ldb] + 0.9704208807564543*b[i + 73*ldb]);
        c[i + 179*ldc] = (-3.812557894803956*b[i + 14*ldb] + 0.7583532171678773*b[i + 29*ldb] + 1.70607502775383*b[i + 44*ldb] + -0.9285580266438336*b[i + 59*ldb] + 0.9704208807564543*b[i + 74*ldb]);
        c[i + 180*ldc] = (1.684026960320176*b[i + 0*ldb] + -2.021528935875383*b[i + 15*ldb] + 2.021528935875383*b[i + 45*ldb] + -1.684026960320176*b[i + 60*ldb]);
        c[i + 181*ldc] = (1.684026960320176*b[i + 1*ldb] + -2.021528935875383*b[i + 16*ldb] + 2.021528935875383*b[i + 46*ldb] + -1.684026960320176*b[i + 61*ldb]);
        c[i + 182*ldc] = (1.684026960320176*b[i + 2*ldb] + -2.021528935875383*b[i + 17*ldb] + 2.021528935875383*b[i + 47*ldb] + -1.684026960320176*b[i + 62*ldb]);
        c[i + 183*ldc] = (1.684026960320176*b[i + 3*ldb] + -2.021528935875383*b[i + 18*ldb] + 2.021528935875383*b[i + 48*ldb] + -1.684026960320176*b[i + 63*ldb]);
        c[i + 184*ldc] = (1.684026960320176*b[i + 4*ldb] + -2.021528935875383*b[i + 19*ldb] + 2.021528935875383*b[i + 49*ldb] + -1.684026960320176*b[i + 64*ldb]);
        c[i + 185*ldc] = (1.684026960320176*b[i + 5*ldb] + -2.021528935875383*b[i + 20*ldb] + 2.021528935875383*b[i + 50*ldb] + -1.684026960320176*b[i + 65*ldb]);
        c[i + 186*ldc] = (1.684026960320176*b[i + 6*ldb] + -2.021528935875383*b[i + 21*ldb] + 2.021528935875383*b[i + 51*ldb] + -1.684026960320176*b[i + 66*ldb]);
        c[i + 187*ldc] = (1.684026960320176*b[i + 7*ldb] + -2.021528935875383*b[i + 22*ldb] + 2.021528935875383*b[i + 52*ldb] + -1.684026960320176*b[i + 67*ldb]);
        c[i + 188*ldc] = (1.684026960320176*b[i + 8*ldb] + -2.021528935875383*b[i + 23*ldb] + 2.021528935875383*b[i + 53*ldb] + -1.684026960320176*b[i + 68*ldb]);
        c[i + 189*ldc] = (1.684026960320176*b[i + 9*ldb] + -2.021528935875383*b[i + 24*ldb] + 2.021528935875383*b[i + 54*ldb] + -1.684026960320176*b[i + 69*ldb]);
        c[i + 190*ldc] = (1.684026960320176*b[i + 10*ldb] + -2.021528935875383*b[i + 25*ldb] + 2.021528935875383*b[i + 55*ldb] + -1.684026960320176*b[i + 70*ldb]);
        c[i + 191*ldc] = (1.684026960320176*b[i + 11*ldb] + -2.021528935875383*b[i + 26*ldb] + 2.021528935875383*b[i + 56*ldb] + -1.684026960320176*b[i + 71*ldb]);
        c[i + 192*ldc] = (1.684026960320176*b[i + 12*ldb] + -2.021528935875383*b[i + 27*ldb] + 2.021528935875383*b[i + 57*ldb] + -1.684026960320176*b[i + 72*ldb]);
        c[i + 193*ldc] = (1.684026960320176*b[i + 13*ldb] + -2.021528935875383*b[i + 28*ldb] + 2.021528935875383*b[i + 58*ldb] + -1.684026960320176*b[i + 73*ldb]);
        c[i + 194*ldc] = (1.684026960320176*b[i + 14*ldb] + -2.021528935875383*b[i + 29*ldb] + 2.021528935875383*b[i + 59*ldb] + -1.684026960320176*b[i + 74*ldb]);
        c[i + 195*ldc] = (-0.9704208807564543*b[i + 0*ldb] + 0.9285580266438336*b[i + 15*ldb] + -1.70607502775383*b[i + 30*ldb] + -0.7583532171678773*b[i + 45*ldb] + 3.812557894803956*b[i + 60*ldb]);
        c[i + 196*ldc] = (-0.9704208807564543*b[i + 1*ldb] + 0.9285580266438336*b[i + 16*ldb] + -1.70607502775383*b[i + 31*ldb] + -0.7583532171678773*b[i + 46*ldb] + 3.812557894803956*b[i + 61*ldb]);
        c[i + 197*ldc] = (-0.9704208807564543*b[i + 2*ldb] + 0.9285580266438336*b[i + 17*ldb] + -1.70607502775383*b[i + 32*ldb] + -0.7583532171678773*b[i + 47*ldb] + 3.812557894803956*b[i + 62*ldb]);
        c[i + 198*ldc] = (-0.9704208807564543*b[i + 3*ldb] + 0.9285580266438336*b[i + 18*ldb] + -1.70607502775383*b[i + 33*ldb] + -0.7583532171678773*b[i + 48*ldb] + 3.812557894803956*b[i + 63*ldb]);
        c[i + 199*ldc] = (-0.9704208807564543*b[i + 4*ldb] + 0.9285580266438336*b[i + 19*ldb] + -1.70607502775383*b[i + 34*ldb] + -0.7583532171678773*b[i + 49*ldb] + 3.812557894803956*b[i + 64*ldb]);
        c[i + 200*ldc] = (-0.9704208807564543*b[i + 5*ldb] + 0.9285580266438336*b[i + 20*ldb] + -1.70607502775383*b[i + 35*ldb] + -0.7583532171678773*b[i + 50*ldb] + 3.812557894803956*b[i + 65*ldb]);
        c[i + 201*ldc] = (-0.9704208807564543*b[i + 6*ldb] + 0.9285580266438336*b[i + 21*ldb] + -1.70607502775383*b[i + 36*ldb] + -0.7583532171678773*b[i + 51*ldb] + 3.812557894803956*b[i + 66*ldb]);
        c[i + 202*ldc] = (-0.9704208807564543*b[i + 7*ldb] + 0.9285580266438336*b[i + 22*ldb] + -1.70607502775383*b[i + 37*ldb] + -0.7583532171678773*b[i + 52*ldb] + 3.812557894803956*b[i + 67*ldb]);
        c[i + 203*ldc] = (-0.9704208807564543*b[i + 8*ldb] + 0.9285580266438336*b[i + 23*ldb] + -1.70607502775383*b[i + 38*ldb] + -0.7583532171678773*b[i + 53*ldb] + 3.812557894803956*b[i + 68*ldb]);
        c[i + 204*ldc] = (-0.9704208807564543*b[i + 9*ldb] + 0.9285580266438336*b[i + 24*ldb] + -1.70607502775383*b[i + 39*ldb] + -0.7583532171678773*b[i + 54*ldb] + 3.812557894803956*b[i + 69*ldb]);
        c[i + 205*ldc] = (-0.9704208807564543*b[i + 10*ldb] + 0.9285580266438336*b[i + 25*ldb] + -1.70607502775383*b[i + 40*ldb] + -0.7583532171678773*b[i + 55*ldb] + 3.812557894803956*b[i + 70*ldb]);
        c[i + 206*ldc] = (-0.9704208807564543*b[i + 11*ldb] + 0.9285580266438336*b[i + 26*ldb] + -1.70607502775383*b[i + 41*ldb] + -0.7583532171678773*b[i + 56*ldb] + 3.812557894803956*b[i + 71*ldb]);
        c[i + 207*ldc] = (-0.9704208807564543*b[i + 12*ldb] + 0.9285580266438336*b[i + 27*ldb] + -1.70607502775383*b[i + 42*ldb] + -0.7583532171678773*b[i + 57*ldb] + 3.812557894803956*b[i + 72*ldb]);
        c[i + 208*ldc] = (-0.9704208807564543*b[i + 13*ldb] + 0.9285580266438336*b[i + 28*ldb] + -1.70607502775383*b[i + 43*ldb] + -0.7583532171678773*b[i + 58*ldb] + 3.812557894803956*b[i + 73*ldb]);
        c[i + 209*ldc] = (-0.9704208807564543*b[i + 14*ldb] + 0.9285580266438336*b[i + 29*ldb] + -1.70607502775383*b[i + 44*ldb] + -0.7583532171678773*b[i + 59*ldb] + 3.812557894803956*b[i + 74*ldb]);
        c[i + 210*ldc] = (0.551766850963316*b[i + 0*ldb] + -0.4937590750470335*b[i + 15*ldb] + 0.7231396289857275*b[i + 30*ldb] + -1.939864544376094*b[i + 45*ldb] + -5.067040595654547*b[i + 60*ldb]);
        c[i + 211*ldc] = (0.551766850963316*b[i + 1*ldb] + -0.4937590750470335*b[i + 16*ldb] + 0.7231396289857275*b[i + 31*ldb] + -1.939864544376094*b[i + 46*ldb] + -5.067040595654547*b[i + 61*ldb]);
        c[i + 212*ldc] = (0.551766850963316*b[i + 2*ldb] + -0.4937590750470335*b[i + 17*ldb] + 0.7231396289857275*b[i + 32*ldb] + -1.939864544376094*b[i + 47*ldb] + -5.067040595654547*b[i + 62*ldb]);
        c[i + 213*ldc] = (0.551766850963316*b[i + 3*ldb] + -0.4937590750470335*b[i + 18*ldb] + 0.7231396289857275*b[i + 33*ldb] + -1.939864544376094*b[i + 48*ldb] + -5.067040595654547*b[i + 63*ldb]);
        c[i + 214*ldc] = (0.551766850963316*b[i + 4*ldb] + -0.4937590750470335*b[i + 19*ldb] + 0.7231396289857275*b[i + 34*ldb] + -1.939864544376094*b[i + 49*ldb] + -5.067040595654547*b[i + 64*ldb]);
        c[i + 215*ldc] = (0.551766850963316*b[i + 5*ldb] + -0.4937590750470335*b[i + 20*ldb] + 0.7231396289857275*b[i + 35*ldb] + -1.939864544376094*b[i + 50*ldb] + -5.067040595654547*b[i + 65*ldb]);
        c[i + 216*ldc] = (0.551766850963316*b[i + 6*ldb] + -0.4937590750470335*b[i + 21*ldb] + 0.7231396289857275*b[i + 36*ldb] + -1.939864544376094*b[i + 51*ldb] + -5.067040595654547*b[i + 66*ldb]);
        c[i + 217*ldc] = (0.551766850963316*b[i + 7*ldb] + -0.4937590750470335*b[i + 22*ldb] + 0.7231396289857275*b[i + 37*ldb] + -1.939864544376094*b[i + 52*ldb] + -5.067040595654547*b[i + 67*ldb]);
        c[i + 218*ldc] = (0.551766850963316*b[i + 8*ldb] + -0.4937590750470335*b[i + 23*ldb] + 0.7231396289857275*b[i + 38*ldb] + -1.939864544376094*b[i + 53*ldb] + -5.067040595654547*b[i + 68*ldb]);
        c[i + 219*ldc] = (0.551766850963316*b[i + 9*ldb] + -0.4937590750470335*b[i + 24*ldb] + 0.7231396289857275*b[i + 39*ldb] + -1.939864544376094*b[i + 54*ldb] + -5.067040595654547*b[i + 69*ldb]);
        c[i + 220*ldc] = (0.551766850963316*b[i + 10*ldb] + -0.4937590750470335*b[i + 25*ldb] + 0.7231396289857275*b[i + 40*ldb] + -1.939864544376094*b[i + 55*ldb] + -5.067040595654547*b[i + 70*ldb]);
        c[i + 221*ldc] = (0.551766850963316*b[i + 11*ldb] + -0.4937590750470335*b[i + 26*ldb] + 0.7231396289857275*b[i + 41*ldb] + -1.939864544376094*b[i + 56*ldb] + -5.067040595654547*b[i + 71*ldb]);
        c[i + 222*ldc] = (0.551766850963316*b[i + 12*ldb] + -0.4937590750470335*b[i + 27*ldb] + 0.7231396289857275*b[i + 42*ldb] + -1.939864544376094*b[i + 57*ldb] + -5.067040595654547*b[i + 72*ldb]);
        c[i + 223*ldc] = (0.551766850963316*b[i + 13*ldb] + -0.4937590750470335*b[i + 28*ldb] + 0.7231396289857275*b[i + 43*ldb] + -1.939864544376094*b[i + 58*ldb] + -5.067040595654547*b[i + 73*ldb]);
        c[i + 224*ldc] = (0.551766850963316*b[i + 14*ldb] + -0.4937590750470335*b[i + 29*ldb] + 0.7231396289857275*b[i + 44*ldb] + -1.939864544376094*b[i + 59*ldb] + -5.067040595654547*b[i + 74*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p4_pri_m132(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (0.01666240169962252*b[i + 1*ldb] + -0.01666240169962252*b[i + 2*ldb] + -0.06412597883381979*b[i + 4*ldb] + 0.06412597883381979*b[i + 5*ldb] + -0.2284464562720814*b[i + 7*ldb] + 0.2284464562720814*b[i + 8*ldb] + -0.0809696560654336*b[i + 9*ldb] + 0.0809696560654336*b[i + 10*ldb] + -0.01902826490985636*b[i + 11*ldb] + 0.01902826490985636*b[i + 12*ldb] + -0.2968235823045307*b[i + 13*ldb] + 0.2968235823045307*b[i + 14*ldb] + -4.943623329974175*b[i + 75*ldb] + 0.5320310574554866*b[i + 76*ldb] + 0.5153686557558634*b[i + 77*ldb] + 2.118084753790551*b[i + 78*ldb] + -1.668497037618385*b[i + 79*ldb] + -1.604371058784565*b[i + 80*ldb] + 2.136333242112812*b[i + 81*ldb] + 1.189090704074046*b[i + 82*ldb] + 1.417537160346129*b[i + 83*ldb] + -0.7377711785520655*b[i + 84*ldb] + -0.6568015224866337*b[i + 85*ldb] + 1.526761453986784*b[i + 86*ldb] + 1.545789718896642*b[i + 87*ldb] + -3.174277239797759*b[i + 88*ldb] + -2.877453657493225*b[i + 89*ldb] + 5.067040595654547*b[i + 150*ldb] + 1.939864544376094*b[i + 165*ldb] + -0.7231396289857275*b[i + 180*ldb] + 0.4937590750470335*b[i + 195*ldb] + -0.551766850963316*b[i + 210*ldb]);
        c[i + 1*ldc] = (0.5320310574554866*b[i + 0*ldb] + -4.943623329974175*b[i + 1*ldb] + 0.5153686557558634*b[i + 2*ldb] + -1.668497037618385*b[i + 3*ldb] + 2.118084753790551*b[i + 4*ldb] + -1.604371058784565*b[i + 5*ldb] + 1.189090704074046*b[i + 6*ldb] + 2.136333242112812*b[i + 7*ldb] + 1.417537160346129*b[i + 8*ldb] + -2.877453657493225*b[i + 9*ldb] + 1.526761453986784*b[i + 10*ldb] + -0.6568015224866337*b[i + 11*ldb] + -3.174277239797759*b[i + 12*ldb] + 1.545789718896642*b[i + 13*ldb] + -0.7377711785520655*b[i + 14*ldb] + 0.01666240169962252*b[i + 75*ldb] + -0.01666240169962252*b[i + 77*ldb] + -0.06412597883381979*b[i + 78*ldb] + 0.06412597883381979*b[i + 80*ldb] + -0.2284464562720814*b[i + 81*ldb] + 0.2284464562720814*b[i + 83*ldb] + 0.2968235823045307*b[i + 84*ldb] + -0.01902826490985636*b[i + 85*ldb] + 0.0809696560654336*b[i + 86*ldb] + -0.2968235823045307*b[i + 87*ldb] + 0.01902826490985636*b[i + 88*ldb] + -0.0809696560654336*b[i + 89*ldb] + 5.067040595654547*b[i + 151*ldb] + 1.939864544376094*b[i + 166*ldb] + -0.7231396289857275*b[i + 181*ldb] + 0.4937590750470335*b[i + 196*ldb] + -0.551766850963316*b[i + 211*ldb]);
        c[i + 2*ldc] = (-0.5320310574554866*b[i + 0*ldb] + -0.5153686557558634*b[i + 1*ldb] + 4.943623329974175*b[i + 2*ldb] + 1.668497037618385*b[i + 3*ldb] + 1.604371058784565*b[i + 4*ldb] + -2.118084753790551*b[i + 5*ldb] + -1.189090704074046*b[i + 6*ldb] + -1.417537160346129*b[i + 7*ldb] + -2.136333242112812*b[i + 8*ldb] + -1.526761453986784*b[i + 9*ldb] + 2.877453657493225*b[i + 10*ldb] + 3.174277239797759*b[i + 11*ldb] + 0.6568015224866337*b[i + 12*ldb] + 0.7377711785520655*b[i + 13*ldb] + -1.545789718896642*b[i + 14*ldb] + -0.5153686557558634*b[i + 75*ldb] + -0.5320310574554866*b[i + 76*ldb] + 4.943623329974175*b[i + 77*ldb] + 1.604371058784565*b[i + 78*ldb] + 1.668497037618385*b[i + 79*ldb] + -2.118084753790551*b[i + 80*ldb] + -1.417537160346129*b[i + 81*ldb] + -1.189090704074046*b[i + 82*ldb] + -2.136333242112812*b[i + 83*ldb] + -1.545789718896642*b[i + 84*ldb] + 3.174277239797759*b[i + 85*ldb] + 2.877453657493225*b[i + 86*ldb] + 0.7377711785520655*b[i + 87*ldb] + 0.6568015224866337*b[i + 88*ldb] + -1.526761453986784*b[i + 89*ldb] + 5.067040595654547*b[i + 152*ldb] + 1.939864544376094*b[i + 167*ldb] + -0.7231396289857275*b[i + 182*ldb] + 0.4937590750470335*b[i + 197*ldb] + -0.551766850963316*b[i + 212*ldb]);
        c[i + 3*ldc] = (-0.0832386718891518*b[i + 1*ldb] + 0.0832386718891518*b[i + 2*ldb] + 0.1767047850928541*b[i + 4*ldb] + -0.1767047850928541*b[i + 5*ldb] + -2.508033750268638*b[i + 7*ldb] + 2.508033750268638*b[i + 8*ldb] + -0.2525315576529422*b[i + 9*ldb] + 0.2525315576529422*b[i + 10*ldb] + -0.03160100937678251*b[i + 11*ldb] + 0.03160100937678251*b[i + 12*ldb] + -2.356239812122482*b[i + 13*ldb] + 2.356239812122482*b[i + 14*ldb] + 0.04609417395922302*b[i + 75*ldb] + -0.1031803103571685*b[i + 76*ldb] + -0.01994163846801661*b[i + 77*ldb] + -0.3632813123758165*b[i + 78*ldb] + -1.492300533375874*b[i + 79*ldb] + -1.669005318468729*b[i + 80*ldb] + 1.730263001372271*b[i + 81*ldb] + -0.119528214542479*b[i + 82*ldb] + 2.388505535726159*b[i + 83*ldb] + -0.1709917888150785*b[i + 84*ldb] + 0.08153976883786418*b[i + 85*ldb] + 0.7288527548607495*b[i + 86*ldb] + 0.7604537642375322*b[i + 87*ldb] + 0.009187597244981638*b[i + 88*ldb] + 2.365427409367463*b[i + 89*ldb] + 5.067040595654547*b[i + 153*ldb] + 1.939864544376094*b[i + 168*ldb] + -0.7231396289857275*b[i + 183*ldb] + 0.4937590750470335*b[i + 198*ldb] + -0.551766850963316*b[i + 213*ldb]);
        c[i + 4*ldc] = (-0.1031803103571685*b[i + 0*ldb] + 0.04609417395922302*b[i + 1*ldb] + -0.01994163846801661*b[i + 2*ldb] + -1.492300533375874*b[i + 3*ldb] + -0.3632813123758165*b[i + 4*ldb] + -1.669005318468729*b[i + 5*ldb] + -0.119528214542479*b[i + 6*ldb] + 1.730263001372271*b[i + 7*ldb] + 2.388505535726159*b[i + 8*ldb] + 2.365427409367463*b[i + 9*ldb] + 0.7288527548607495*b[i + 10*ldb] + 0.08153976883786418*b[i + 11*ldb] + 0.009187597244981638*b[i + 12*ldb] + 0.7604537642375322*b[i + 13*ldb] + -0.1709917888150785*b[i + 14*ldb] + -0.0832386718891518*b[i + 75*ldb] + 0.0832386718891518*b[i + 77*ldb] + 0.1767047850928541*b[i + 78*ldb] + -0.1767047850928541*b[i + 80*ldb] + -2.508033750268638*b[i + 81*ldb] + 2.508033750268638*b[i + 83*ldb] + 2.356239812122482*b[i + 84*ldb] + -0.03160100937678251*b[i + 85*ldb] + 0.2525315576529422*b[i + 86*ldb] + -2.356239812122482*b[i + 87*ldb] + 0.03160100937678251*b[i + 88*ldb] + -0.2525315576529422*b[i + 89*ldb] + 5.067040595654547*b[i + 154*ldb] + 1.939864544376094*b[i + 169*ldb] + -0.7231396289857275*b[i + 184*ldb] + 0.4937590750470335*b[i + 199*ldb] + -0.551766850963316*b[i + 214*ldb]);
        c[i + 5*ldc] = (0.1031803103571685*b[i + 0*ldb] + 0.01994163846801661*b[i + 1*ldb] + -0.04609417395922302*b[i + 2*ldb] + 1.492300533375874*b[i + 3*ldb] + 1.669005318468729*b[i + 4*ldb] + 0.3632813123758165*b[i + 5*ldb] + 0.119528214542479*b[i + 6*ldb] + -2.388505535726159*b[i + 7*ldb] + -1.730263001372271*b[i + 8*ldb] + -0.7288527548607495*b[i + 9*ldb] + -2.365427409367463*b[i + 10*ldb] + -0.009187597244981638*b[i + 11*ldb] + -0.08153976883786418*b[i + 12*ldb] + 0.1709917888150785*b[i + 13*ldb] + -0.7604537642375322*b[i + 14*ldb] + 0.01994163846801661*b[i + 75*ldb] + 0.1031803103571685*b[i + 76*ldb] + -0.04609417395922302*b[i + 77*ldb] + 1.669005318468729*b[i + 78*ldb] + 1.492300533375874*b[i + 79*ldb] + 0.3632813123758165*b[i + 80*ldb] + -2.388505535726159*b[i + 81*ldb] + 0.119528214542479*b[i + 82*ldb] + -1.730263001372271*b[i + 83*ldb] + -0.7604537642375322*b[i + 84*ldb] + -0.009187597244981638*b[i + 85*ldb] + -2.365427409367463*b[i + 86*ldb] + 0.1709917888150785*b[i + 87*ldb] + -0.08153976883786418*b[i + 88*ldb] + -0.7288527548607495*b[i + 89*ldb] + 5.067040595654547*b[i + 155*ldb] + 1.939864544376094*b[i + 170*ldb] + -0.7231396289857275*b[i + 185*ldb] + 0.4937590750470335*b[i + 200*ldb] + -0.551766850963316*b[i + 215*ldb]);
        c[i + 6*ldc] = (-0.9213245156088653*b[i + 1*ldb] + 0.9213245156088653*b[i + 2*ldb] + 1.478053430463056*b[i + 4*ldb] + -1.478053430463056*b[i + 5*ldb] + 0.657627957956578*b[i + 7*ldb] + -0.657627957956578*b[i + 8*ldb] + -1.844372618022506*b[i + 9*ldb] + 1.844372618022506*b[i + 10*ldb] + -1.70239108991215*b[i + 11*ldb] + 1.70239108991215*b[i + 12*ldb] + -0.2828454530477449*b[i + 13*ldb] + 0.2828454530477449*b[i + 14*ldb] + 0.04922131659554296*b[i + 75*ldb] + -1.063952765527867*b[i + 76*ldb] + -0.1426282499190014*b[i + 77*ldb] + -0.2449733459341608*b[i + 78*ldb] + 1.892059090254097*b[i + 79*ldb] + 0.4140056597910398*b[i + 80*ldb] + 3.824491607376837*b[i + 81*ldb] + 0.01268686934620999*b[i + 82*ldb] + -0.6449410886103684*b[i + 83*ldb] + -1.893604927353485*b[i + 84*ldb] + -0.04923230933097847*b[i + 85*ldb] + 0.1863127236068944*b[i + 86*ldb] + 1.888703813519044*b[i + 87*ldb] + -0.02804075661045902*b[i + 88*ldb] + 0.2548046964372861*b[i + 89*ldb] + 5.067040595654547*b[i + 156*ldb] + 1.939864544376094*b[i + 171*ldb] + -0.7231396289857275*b[i + 186*ldb] + 0.4937590750470335*b[i + 201*ldb] + -0.551766850963316*b[i + 216*ldb]);
        c[i + 7*ldc] = (-1.063952765527867*b[i + 0*ldb] + 0.04922131659554296*b[i + 1*ldb] + -0.1426282499190014*b[i + 2*ldb] + 1.892059090254097*b[i + 3*ldb] + -0.2449733459341608*b[i + 4*ldb] + 0.4140056597910398*b[i + 5*ldb] + 0.01268686934620999*b[i + 6*ldb] + 3.824491607376837*b[i + 7*ldb] + -0.6449410886103684*b[i + 8*ldb] + 0.2548046964372861*b[i + 9*ldb] + 0.1863127236068944*b[i + 10*ldb] + -0.04923230933097847*b[i + 11*ldb] + -0.02804075661045902*b[i + 12*ldb] + 1.888703813519044*b[i + 13*ldb] + -1.893604927353485*b[i + 14*ldb] + -0.9213245156088653*b[i + 75*ldb] + 0.9213245156088653*b[i + 77*ldb] + 1.478053430463056*b[i + 78*ldb] + -1.478053430463056*b[i + 80*ldb] + 0.657627957956578*b[i + 81*ldb] + -0.657627957956578*b[i + 83*ldb] + 0.2828454530477449*b[i + 84*ldb] + -1.70239108991215*b[i + 85*ldb] + 1.844372618022506*b[i + 86*ldb] + -0.2828454530477449*b[i + 87*ldb] + 1.70239108991215*b[i + 88*ldb] + -1.844372618022506*b[i + 89*ldb] + 5.067040595654547*b[i + 157*ldb] + 1.939864544376094*b[i + 172*ldb] + -0.7231396289857275*b[i + 187*ldb] + 0.4937590750470335*b[i + 202*ldb] + -0.551766850963316*b[i + 217*ldb]);
        c[i + 8*ldc] = (1.063952765527867*b[i + 0*ldb] + 0.1426282499190014*b[i + 1*ldb] + -0.04922131659554296*b[i + 2*ldb] + -1.892059090254097*b[i + 3*ldb] + -0.4140056597910398*b[i + 4*ldb] + 0.2449733459341608*b[i + 5*ldb] + -0.01268686934620999*b[i + 6*ldb] + 0.6449410886103684*b[i + 7*ldb] + -3.824491607376837*b[i + 8*ldb] + -0.1863127236068944*b[i + 9*ldb] + -0.2548046964372861*b[i + 10*ldb] + 0.02804075661045902*b[i + 11*ldb] + 0.04923230933097847*b[i + 12*ldb] + 1.893604927353485*b[i + 13*ldb] + -1.888703813519044*b[i + 14*ldb] + 0.1426282499190014*b[i + 75*ldb] + 1.063952765527867*b[i + 76*ldb] + -0.04922131659554296*b[i + 77*ldb] + -0.4140056597910398*b[i + 78*ldb] + -1.892059090254097*b[i + 79*ldb] + 0.2449733459341608*b[i + 80*ldb] + 0.6449410886103684*b[i + 81*ldb] + -0.01268686934620999*b[i + 82*ldb] + -3.824491607376837*b[i + 83*ldb] + -1.888703813519044*b[i + 84*ldb] + 0.02804075661045902*b[i + 85*ldb] + -0.2548046964372861*b[i + 86*ldb] + 1.893604927353485*b[i + 87*ldb] + 0.04923230933097847*b[i + 88*ldb] + -0.1863127236068944*b[i + 89*ldb] + 5.067040595654547*b[i + 158*ldb] + 1.939864544376094*b[i + 173*ldb] + -0.7231396289857275*b[i + 188*ldb] + 0.4937590750470335*b[i + 203*ldb] + -0.551766850963316*b[i + 218*ldb]);
        c[i + 9*ldc] = (-0.6700089687429422*b[i + 0*ldb] + -0.3382891868158406*b[i + 1*ldb] + 0.07381136587329767*b[i + 2*ldb] + 1.547856590176338*b[i + 3*ldb] + -2.110251502449065*b[i + 4*ldb] + 0.6449271066413235*b[i + 5*ldb] + 0.1536175324542066*b[i + 6*ldb] + -1.335288332277977*b[i + 7*ldb] + -1.896047521200515*b[i + 8*ldb] + -4.031390515234344*b[i + 9*ldb] + -0.1712431320875245*b[i + 10*ldb] + -0.1241305557641109*b[i + 11*ldb] + -0.209949353949926*b[i + 12*ldb] + -1.687561521519859*b[i + 13*ldb] + 1.09762839928984*b[i + 14*ldb] + -0.04444015218558958*b[i + 75*ldb] + -2.9217023167422*b[i + 76*ldb] + -0.03302545659098766*b[i + 77*ldb] + 0.07052587748054273*b[i + 78*ldb] + -0.564050650085659*b[i + 79*ldb] + -0.01698433971579627*b[i + 80*ldb] + 0.5279041678421734*b[i + 81*ldb] + 0.02035288870568681*b[i + 82*ldb] + 0.01987965941343628*b[i + 83*ldb] + -3.581597315354408*b[i + 84*ldb] + -0.01215166511285262*b[i + 85*ldb] + 0.0459078476533179*b[i + 86*ldb] + -2.965388897477289*b[i + 87*ldb] + -0.04766271928616608*b[i + 88*ldb] + 0.2089760190013807*b[i + 89*ldb] + 5.067040595654547*b[i + 159*ldb] + 1.939864544376094*b[i + 174*ldb] + -0.7231396289857275*b[i + 189*ldb] + 0.4937590750470335*b[i + 204*ldb] + -0.551766850963316*b[i + 219*ldb]);
        c[i + 10*ldc] = (0.6700089687429422*b[i + 0*ldb] + -0.07381136587329767*b[i + 1*ldb] + 0.3382891868158406*b[i + 2*ldb] + -1.547856590176338*b[i + 3*ldb] + -0.6449271066413235*b[i + 4*ldb] + 2.110251502449065*b[i + 5*ldb] + -0.1536175324542066*b[i + 6*ldb] + 1.896047521200515*b[i + 7*ldb] + 1.335288332277977*b[i + 8*ldb] + 0.1712431320875245*b[i + 9*ldb] + 4.031390515234344*b[i + 10*ldb] + 0.209949353949926*b[i + 11*ldb] + 0.1241305557641109*b[i + 12*ldb] + -1.09762839928984*b[i + 13*ldb] + 1.687561521519859*b[i + 14*ldb] + 0.6255688165573523*b[i + 75*ldb] + -0.1068368224642844*b[i + 76*ldb] + -2.583413129926359*b[i + 77*ldb] + -1.477330712695793*b[i + 78*ldb] + -0.6619114463571192*b[i + 79*ldb] + 1.546200852363405*b[i + 80*ldb] + 0.3742866353879682*b[i + 81*ldb] + 1.91592718061395*b[i + 82*ldb] + 1.355641220983662*b[i + 83*ldb] + 0.1590914669746716*b[i + 84*ldb] + 0.4497931998799397*b[i + 85*ldb] + -2.755439543527363*b[i + 86*ldb] + 0.1700384034174278*b[i + 87*ldb] + -0.8886523802884596*b[i + 88*ldb] + 1.639898802233694*b[i + 89*ldb] + 5.067040595654547*b[i + 160*ldb] + 1.939864544376094*b[i + 175*ldb] + -0.7231396289857275*b[i + 190*ldb] + 0.4937590750470335*b[i + 205*ldb] + -0.551766850963316*b[i + 220*ldb]);
        c[i + 11*ldc] = (-0.1068368224642844*b[i + 0*ldb] + 0.6255688165573523*b[i + 1*ldb] + -2.583413129926359*b[i + 2*ldb] + -0.6619114463571192*b[i + 3*ldb] + -1.477330712695793*b[i + 4*ldb] + 1.546200852363405*b[i + 5*ldb] + 1.91592718061395*b[i + 6*ldb] + 0.3742866353879682*b[i + 7*ldb] + 1.355641220983662*b[i + 8*ldb] + 1.639898802233694*b[i + 9*ldb] + -2.755439543527363*b[i + 10*ldb] + 0.4497931998799397*b[i + 11*ldb] + -0.8886523802884596*b[i + 12*ldb] + 0.1700384034174278*b[i + 13*ldb] + 0.1590914669746716*b[i + 14*ldb] + -0.07381136587329767*b[i + 75*ldb] + 0.6700089687429422*b[i + 76*ldb] + 0.3382891868158406*b[i + 77*ldb] + -0.6449271066413235*b[i + 78*ldb] + -1.547856590176338*b[i + 79*ldb] + 2.110251502449065*b[i + 80*ldb] + 1.896047521200515*b[i + 81*ldb] + -0.1536175324542066*b[i + 82*ldb] + 1.335288332277977*b[i + 83*ldb] + 1.687561521519859*b[i + 84*ldb] + 0.209949353949926*b[i + 85*ldb] + 4.031390515234344*b[i + 86*ldb] + -1.09762839928984*b[i + 87*ldb] + 0.1241305557641109*b[i + 88*ldb] + 0.1712431320875245*b[i + 89*ldb] + 5.067040595654547*b[i + 161*ldb] + 1.939864544376094*b[i + 176*ldb] + -0.7231396289857275*b[i + 191*ldb] + 0.4937590750470335*b[i + 206*ldb] + -0.551766850963316*b[i + 221*ldb]);
        c[i + 12*ldc] = (0.1068368224642844*b[i + 0*ldb] + 2.583413129926359*b[i + 1*ldb] + -0.6255688165573523*b[i + 2*ldb] + 0.6619114463571192*b[i + 3*ldb] + -1.546200852363405*b[i + 4*ldb] + 1.477330712695793*b[i + 5*ldb] + -1.91592718061395*b[i + 6*ldb] + -1.355641220983662*b[i + 7*ldb] + -0.3742866353879682*b[i + 8*ldb] + 2.755439543527363*b[i + 9*ldb] + -1.639898802233694*b[i + 10*ldb] + 0.8886523802884596*b[i + 11*ldb] + -0.4497931998799397*b[i + 12*ldb] + -0.1590914669746716*b[i + 13*ldb] + -0.1700384034174278*b[i + 14*ldb] + 0.03302545659098766*b[i + 75*ldb] + 2.9217023167422*b[i + 76*ldb] + 0.04444015218558958*b[i + 77*ldb] + 0.01698433971579627*b[i + 78*ldb] + 0.564050650085659*b[i + 79*ldb] + -0.07052587748054273*b[i + 80*ldb] + -0.01987965941343628*b[i + 81*ldb] + -0.02035288870568681*b[i + 82*ldb] + -0.5279041678421734*b[i + 83*ldb] + 2.965388897477289*b[i + 84*ldb] + 0.04766271928616608*b[i + 85*ldb] + -0.2089760190013807*b[i + 86*ldb] + 3.581597315354408*b[i + 87*ldb] + 0.01215166511285262*b[i + 88*ldb] + -0.0459078476533179*b[i + 89*ldb] + 5.067040595654547*b[i + 162*ldb] + 1.939864544376094*b[i + 177*ldb] + -0.7231396289857275*b[i + 192*ldb] + 0.4937590750470335*b[i + 207*ldb] + -0.551766850963316*b[i + 222*ldb]);
        c[i + 13*ldc] = (2.9217023167422*b[i + 0*ldb] + 0.03302545659098766*b[i + 1*ldb] + 0.04444015218558958*b[i + 2*ldb] + 0.564050650085659*b[i + 3*ldb] + 0.01698433971579627*b[i + 4*ldb] + -0.07052587748054273*b[i + 5*ldb] + -0.02035288870568681*b[i + 6*ldb] + -0.01987965941343628*b[i + 7*ldb] + -0.5279041678421734*b[i + 8*ldb] + -0.0459078476533179*b[i + 9*ldb] + -0.2089760190013807*b[i + 10*ldb] + 0.04766271928616608*b[i + 11*ldb] + 0.01215166511285262*b[i + 12*ldb] + 3.581597315354408*b[i + 13*ldb] + 2.965388897477289*b[i + 14*ldb] + 2.583413129926359*b[i + 75*ldb] + 0.1068368224642844*b[i + 76*ldb] + -0.6255688165573523*b[i + 77*ldb] + -1.546200852363405*b[i + 78*ldb] + 0.6619114463571192*b[i + 79*ldb] + 1.477330712695793*b[i + 80*ldb] + -1.355641220983662*b[i + 81*ldb] + -1.91592718061395*b[i + 82*ldb] + -0.3742866353879682*b[i + 83*ldb] + -0.1700384034174278*b[i + 84*ldb] + 0.8886523802884596*b[i + 85*ldb] + -1.639898802233694*b[i + 86*ldb] + -0.1590914669746716*b[i + 87*ldb] + -0.4497931998799397*b[i + 88*ldb] + 2.755439543527363*b[i + 89*ldb] + 5.067040595654547*b[i + 163*ldb] + 1.939864544376094*b[i + 178*ldb] + -0.7231396289857275*b[i + 193*ldb] + 0.4937590750470335*b[i + 208*ldb] + -0.551766850963316*b[i + 223*ldb]);
        c[i + 14*ldc] = (-2.9217023167422*b[i + 0*ldb] + -0.04444015218558958*b[i + 1*ldb] + -0.03302545659098766*b[i + 2*ldb] + -0.564050650085659*b[i + 3*ldb] + 0.07052587748054273*b[i + 4*ldb] + -0.01698433971579627*b[i + 5*ldb] + 0.02035288870568681*b[i + 6*ldb] + 0.5279041678421734*b[i + 7*ldb] + 0.01987965941343628*b[i + 8*ldb] + 0.2089760190013807*b[i + 9*ldb] + 0.0459078476533179*b[i + 10*ldb] + -0.01215166511285262*b[i + 11*ldb] + -0.04766271928616608*b[i + 12*ldb] + -2.965388897477289*b[i + 13*ldb] + -3.581597315354408*b[i + 14*ldb] + -0.3382891868158406*b[i + 75*ldb] + -0.6700089687429422*b[i + 76*ldb] + 0.07381136587329767*b[i + 77*ldb] + -2.110251502449065*b[i + 78*ldb] + 1.547856590176338*b[i + 79*ldb] + 0.6449271066413235*b[i + 80*ldb] + -1.335288332277977*b[i + 81*ldb] + 0.1536175324542066*b[i + 82*ldb] + -1.896047521200515*b[i + 83*ldb] + 1.09762839928984*b[i + 84*ldb] + -0.1241305557641109*b[i + 85*ldb] + -0.1712431320875245*b[i + 86*ldb] + -1.687561521519859*b[i + 87*ldb] + -0.209949353949926*b[i + 88*ldb] + -4.031390515234344*b[i + 89*ldb] + 5.067040595654547*b[i + 164*ldb] + 1.939864544376094*b[i + 179*ldb] + -0.7231396289857275*b[i + 194*ldb] + 0.4937590750470335*b[i + 209*ldb] + -0.551766850963316*b[i + 224*ldb]);
        c[i + 15*ldc] = (0.01666240169962252*b[i + 16*ldb] + -0.01666240169962252*b[i + 17*ldb] + -0.06412597883381979*b[i + 19*ldb] + 0.06412597883381979*b[i + 20*ldb] + -0.2284464562720814*b[i + 22*ldb] + 0.2284464562720814*b[i + 23*ldb] + -0.0809696560654336*b[i + 24*ldb] + 0.0809696560654336*b[i + 25*ldb] + -0.01902826490985636*b[i + 26*ldb] + 0.01902826490985636*b[i + 27*ldb] + -0.2968235823045307*b[i + 28*ldb] + 0.2968235823045307*b[i + 29*ldb] + -4.943623329974175*b[i + 90*ldb] + 0.5320310574554866*b[i + 91*ldb] + 0.5153686557558634*b[i + 92*ldb] + 2.118084753790551*b[i + 93*ldb] + -1.668497037618385*b[i + 94*ldb] + -1.604371058784565*b[i + 95*ldb] + 2.136333242112812*b[i + 96*ldb] + 1.189090704074046*b[i + 97*ldb] + 1.417537160346129*b[i + 98*ldb] + -0.7377711785520655*b[i + 99*ldb] + -0.6568015224866337*b[i + 100*ldb] + 1.526761453986784*b[i + 101*ldb] + 1.545789718896642*b[i + 102*ldb] + -3.174277239797759*b[i + 103*ldb] + -2.877453657493225*b[i + 104*ldb] + -3.812557894803956*b[i + 150*ldb] + 0.7583532171678773*b[i + 165*ldb] + 1.70607502775383*b[i + 180*ldb] + -0.9285580266438336*b[i + 195*ldb] + 0.9704208807564543*b[i + 210*ldb]);
        c[i + 16*ldc] = (0.5320310574554866*b[i + 15*ldb] + -4.943623329974175*b[i + 16*ldb] + 0.5153686557558634*b[i + 17*ldb] + -1.668497037618385*b[i + 18*ldb] + 2.118084753790551*b[i + 19*ldb] + -1.604371058784565*b[i + 20*ldb] + 1.189090704074046*b[i + 21*ldb] + 2.136333242112812*b[i + 22*ldb] + 1.417537160346129*b[i + 23*ldb] + -2.877453657493225*b[i + 24*ldb] + 1.526761453986784*b[i + 25*ldb] + -0.6568015224866337*b[i + 26*ldb] + -3.174277239797759*b[i + 27*ldb] + 1.545789718896642*b[i + 28*ldb] + -0.7377711785520655*b[i + 29*ldb] + 0.01666240169962252*b[i + 90*ldb] + -0.01666240169962252*b[i + 92*ldb] + -0.06412597883381979*b[i + 93*ldb] + 0.06412597883381979*b[i + 95*ldb] + -0.2284464562720814*b[i + 96*ldb] + 0.2284464562720814*b[i + 98*ldb] + 0.2968235823045307*b[i + 99*ldb] + -0.01902826490985636*b[i + 100*ldb] + 0.0809696560654336*b[i + 101*ldb] + -0.2968235823045307*b[i + 102*ldb] + 0.01902826490985636*b[i + 103*ldb] + -0.0809696560654336*b[i + 104*ldb] + -3.812557894803956*b[i + 151*ldb] + 0.7583532171678773*b[i + 166*ldb] + 1.70607502775383*b[i + 181*ldb] + -0.9285580266438336*b[i + 196*ldb] + 0.9704208807564543*b[i + 211*ldb]);
        c[i + 17*ldc] = (-0.5320310574554866*b[i + 15*ldb] + -0.5153686557558634*b[i + 16*ldb] + 4.943623329974175*b[i + 17*ldb] + 1.668497037618385*b[i + 18*ldb] + 1.604371058784565*b[i + 19*ldb] + -2.118084753790551*b[i + 20*ldb] + -1.189090704074046*b[i + 21*ldb] + -1.417537160346129*b[i + 22*ldb] + -2.136333242112812*b[i + 23*ldb] + -1.526761453986784*b[i + 24*ldb] + 2.877453657493225*b[i + 25*ldb] + 3.174277239797759*b[i + 26*ldb] + 0.6568015224866337*b[i + 27*ldb] + 0.7377711785520655*b[i + 28*ldb] + -1.545789718896642*b[i + 29*ldb] + -0.5153686557558634*b[i + 90*ldb] + -0.5320310574554866*b[i + 91*ldb] + 4.943623329974175*b[i + 92*ldb] + 1.604371058784565*b[i + 93*ldb] + 1.668497037618385*b[i + 94*ldb] + -2.118084753790551*b[i + 95*ldb] + -1.417537160346129*b[i + 96*ldb] + -1.189090704074046*b[i + 97*ldb] + -2.136333242112812*b[i + 98*ldb] + -1.545789718896642*b[i + 99*ldb] + 3.174277239797759*b[i + 100*ldb] + 2.877453657493225*b[i + 101*ldb] + 0.7377711785520655*b[i + 102*ldb] + 0.6568015224866337*b[i + 103*ldb] + -1.526761453986784*b[i + 104*ldb] + -3.812557894803956*b[i + 152*ldb] + 0.7583532171678773*b[i + 167*ldb] + 1.70607502775383*b[i + 182*ldb] + -0.9285580266438336*b[i + 197*ldb] + 0.9704208807564543*b[i + 212*ldb]);
        c[i + 18*ldc] = (-0.0832386718891518*b[i + 16*ldb] + 0.0832386718891518*b[i + 17*ldb] + 0.1767047850928541*b[i + 19*ldb] + -0.1767047850928541*b[i + 20*ldb] + -2.508033750268638*b[i + 22*ldb] + 2.508033750268638*b[i + 23*ldb] + -0.2525315576529422*b[i + 24*ldb] + 0.2525315576529422*b[i + 25*ldb] + -0.03160100937678251*b[i + 26*ldb] + 0.03160100937678251*b[i + 27*ldb] + -2.356239812122482*b[i + 28*ldb] + 2.356239812122482*b[i + 29*ldb] + 0.04609417395922302*b[i + 90*ldb] + -0.1031803103571685*b[i + 91*ldb] + -0.01994163846801661*b[i + 92*ldb] + -0.3632813123758165*b[i + 93*ldb] + -1.492300533375874*b[i + 94*ldb] + -1.669005318468729*b[i + 95*ldb] + 1.730263001372271*b[i + 96*ldb] + -0.119528214542479*b[i + 97*ldb] + 2.388505535726159*b[i + 98*ldb] + -0.1709917888150785*b[i + 99*ldb] + 0.08153976883786418*b[i + 100*ldb] + 0.7288527548607495*b[i + 101*ldb] + 0.7604537642375322*b[i + 102*ldb] + 0.009187597244981638*b[i + 103*ldb] + 2.365427409367463*b[i + 104*ldb] + -3.812557894803956*b[i + 153*ldb] + 0.7583532171678773*b[i + 168*ldb] + 1.70607502775383*b[i + 183*ldb] + -0.9285580266438336*b[i + 198*ldb] + 0.9704208807564543*b[i + 213*ldb]);
        c[i + 19*ldc] = (-0.1031803103571685*b[i + 15*ldb] + 0.04609417395922302*b[i + 16*ldb] + -0.01994163846801661*b[i + 17*ldb] + -1.492300533375874*b[i + 18*ldb] + -0.3632813123758165*b[i + 19*ldb] + -1.669005318468729*b[i + 20*ldb] + -0.119528214542479*b[i + 21*ldb] + 1.730263001372271*b[i + 22*ldb] + 2.388505535726159*b[i + 23*ldb] + 2.365427409367463*b[i + 24*ldb] + 0.7288527548607495*b[i + 25*ldb] + 0.08153976883786418*b[i + 26*ldb] + 0.009187597244981638*b[i + 27*ldb] + 0.7604537642375322*b[i + 28*ldb] + -0.1709917888150785*b[i + 29*ldb] + -0.0832386718891518*b[i + 90*ldb] + 0.0832386718891518*b[i + 92*ldb] + 0.1767047850928541*b[i + 93*ldb] + -0.1767047850928541*b[i + 95*ldb] + -2.508033750268638*b[i + 96*ldb] + 2.508033750268638*b[i + 98*ldb] + 2.356239812122482*b[i + 99*ldb] + -0.03160100937678251*b[i + 100*ldb] + 0.2525315576529422*b[i + 101*ldb] + -2.356239812122482*b[i + 102*ldb] + 0.03160100937678251*b[i + 103*ldb] + -0.2525315576529422*b[i + 104*ldb] + -3.812557894803956*b[i + 154*ldb] + 0.7583532171678773*b[i + 169*ldb] + 1.70607502775383*b[i + 184*ldb] + -0.9285580266438336*b[i + 199*ldb] + 0.9704208807564543*b[i + 214*ldb]);
        c[i + 20*ldc] = (0.1031803103571685*b[i + 15*ldb] + 0.01994163846801661*b[i + 16*ldb] + -0.04609417395922302*b[i + 17*ldb] + 1.492300533375874*b[i + 18*ldb] + 1.669005318468729*b[i + 19*ldb] + 0.3632813123758165*b[i + 20*ldb] + 0.119528214542479*b[i + 21*ldb] + -2.388505535726159*b[i + 22*ldb] + -1.730263001372271*b[i + 23*ldb] + -0.7288527548607495*b[i + 24*ldb] + -2.365427409367463*b[i + 25*ldb] + -0.009187597244981638*b[i + 26*ldb] + -0.08153976883786418*b[i + 27*ldb] + 0.1709917888150785*b[i + 28*ldb] + -0.7604537642375322*b[i + 29*ldb] + 0.01994163846801661*b[i + 90*ldb] + 0.1031803103571685*b[i + 91*ldb] + -0.04609417395922302*b[i + 92*ldb] + 1.669005318468729*b[i + 93*ldb] + 1.492300533375874*b[i + 94*ldb] + 0.3632813123758165*b[i + 95*ldb] + -2.388505535726159*b[i + 96*ldb] + 0.119528214542479*b[i + 97*ldb] + -1.730263001372271*b[i + 98*ldb] + -0.7604537642375322*b[i + 99*ldb] + -0.009187597244981638*b[i + 100*ldb] + -2.365427409367463*b[i + 101*ldb] + 0.1709917888150785*b[i + 102*ldb] + -0.08153976883786418*b[i + 103*ldb] + -0.7288527548607495*b[i + 104*ldb] + -3.812557894803956*b[i + 155*ldb] + 0.7583532171678773*b[i + 170*ldb] + 1.70607502775383*b[i + 185*ldb] + -0.9285580266438336*b[i + 200*ldb] + 0.9704208807564543*b[i + 215*ldb]);
        c[i + 21*ldc] = (-0.9213245156088653*b[i + 16*ldb] + 0.9213245156088653*b[i + 17*ldb] + 1.478053430463056*b[i + 19*ldb] + -1.478053430463056*b[i + 20*ldb] + 0.657627957956578*b[i + 22*ldb] + -0.657627957956578*b[i + 23*ldb] + -1.844372618022506*b[i + 24*ldb] + 1.844372618022506*b[i + 25*ldb] + -1.70239108991215*b[i + 26*ldb] + 1.70239108991215*b[i + 27*ldb] + -0.2828454530477449*b[i + 28*ldb] + 0.2828454530477449*b[i + 29*ldb] + 0.04922131659554296*b[i + 90*ldb] + -1.063952765527867*b[i + 91*ldb] + -0.1426282499190014*b[i + 92*ldb] + -0.2449733459341608*b[i + 93*ldb] + 1.892059090254097*b[i + 94*ldb] + 0.4140056597910398*b[i + 95*ldb] + 3.824491607376837*b[i + 96*ldb] + 0.01268686934620999*b[i + 97*ldb] + -0.6449410886103684*b[i + 98*ldb] + -1.893604927353485*b[i + 99*ldb] + -0.04923230933097847*b[i + 100*ldb] + 0.1863127236068944*b[i + 101*ldb] + 1.888703813519044*b[i + 102*ldb] + -0.02804075661045902*b[i + 103*ldb] + 0.2548046964372861*b[i + 104*ldb] + -3.812557894803956*b[i + 156*ldb] + 0.7583532171678773*b[i + 171*ldb] + 1.70607502775383*b[i + 186*ldb] + -0.9285580266438336*b[i + 201*ldb] + 0.9704208807564543*b[i + 216*ldb]);
        c[i + 22*ldc] = (-1.063952765527867*b[i + 15*ldb] + 0.04922131659554296*b[i + 16*ldb] + -0.1426282499190014*b[i + 17*ldb] + 1.892059090254097*b[i + 18*ldb] + -0.2449733459341608*b[i + 19*ldb] + 0.4140056597910398*b[i + 20*ldb] + 0.01268686934620999*b[i + 21*ldb] + 3.824491607376837*b[i + 22*ldb] + -0.6449410886103684*b[i + 23*ldb] + 0.2548046964372861*b[i + 24*ldb] + 0.1863127236068944*b[i + 25*ldb] + -0.04923230933097847*b[i + 26*ldb] + -0.02804075661045902*b[i + 27*ldb] + 1.888703813519044*b[i + 28*ldb] + -1.893604927353485*b[i + 29*ldb] + -0.9213245156088653*b[i + 90*ldb] + 0.9213245156088653*b[i + 92*ldb] + 1.478053430463056*b[i + 93*ldb] + -1.478053430463056*b[i + 95*ldb] + 0.657627957956578*b[i + 96*ldb] + -0.657627957956578*b[i + 98*ldb] + 0.2828454530477449*b[i + 99*ldb] + -1.70239108991215*b[i + 100*ldb] + 1.844372618022506*b[i + 101*ldb] + -0.2828454530477449*b[i + 102*ldb] + 1.70239108991215*b[i + 103*ldb] + -1.844372618022506*b[i + 104*ldb] + -3.812557894803956*b[i + 157*ldb] + 0.7583532171678773*b[i + 172*ldb] + 1.70607502775383*b[i + 187*ldb] + -0.9285580266438336*b[i + 202*ldb] + 0.9704208807564543*b[i + 217*ldb]);
        c[i + 23*ldc] = (1.063952765527867*b[i + 15*ldb] + 0.1426282499190014*b[i + 16*ldb] + -0.04922131659554296*b[i + 17*ldb] + -1.892059090254097*b[i + 18*ldb] + -0.4140056597910398*b[i + 19*ldb] + 0.2449733459341608*b[i + 20*ldb] + -0.01268686934620999*b[i + 21*ldb] + 0.6449410886103684*b[i + 22*ldb] + -3.824491607376837*b[i + 23*ldb] + -0.1863127236068944*b[i + 24*ldb] + -0.2548046964372861*b[i + 25*ldb] + 0.02804075661045902*b[i + 26*ldb] + 0.04923230933097847*b[i + 27*ldb] + 1.893604927353485*b[i + 28*ldb] + -1.888703813519044*b[i + 29*ldb] + 0.1426282499190014*b[i + 90*ldb] + 1.063952765527867*b[i + 91*ldb] + -0.04922131659554296*b[i + 92*ldb] + -0.4140056597910398*b[i + 93*ldb] + -1.892059090254097*b[i + 94*ldb] + 0.2449733459341608*b[i + 95*ldb] + 0.6449410886103684*b[i + 96*ldb] + -0.01268686934620999*b[i + 97*ldb] + -3.824491607376837*b[i + 98*ldb] + -1.888703813519044*b[i + 99*ldb] + 0.02804075661045902*b[i + 100*ldb] + -0.2548046964372861*b[i + 101*ldb] + 1.893604927353485*b[i + 102*ldb] + 0.04923230933097847*b[i + 103*ldb] + -0.1863127236068944*b[i + 104*ldb] + -3.812557894803956*b[i + 158*ldb] + 0.7583532171678773*b[i + 173*ldb] + 1.70607502775383*b[i + 188*ldb] + -0.9285580266438336*b[i + 203*ldb] + 0.9704208807564543*b[i + 218*ldb]);
        c[i + 24*ldc] = (-0.6700089687429422*b[i + 15*ldb] + -0.3382891868158406*b[i + 16*ldb] + 0.07381136587329767*b[i + 17*ldb] + 1.547856590176338*b[i + 18*ldb] + -2.110251502449065*b[i + 19*ldb] + 0.6449271066413235*b[i + 20*ldb] + 0.1536175324542066*b[i + 21*ldb] + -1.335288332277977*b[i + 22*ldb] + -1.896047521200515*b[i + 23*ldb] + -4.031390515234344*b[i + 24*ldb] + -0.1712431320875245*b[i + 25*ldb] + -0.1241305557641109*b[i + 26*ldb] + -0.209949353949926*b[i + 27*ldb] + -1.687561521519859*b[i + 28*ldb] + 1.09762839928984*b[i + 29*ldb] + -0.04444015218558958*b[i + 90*ldb] + -2.9217023167422*b[i + 91*ldb] + -0.03302545659098766*b[i + 92*ldb] + 0.07052587748054273*b[i + 93*ldb] + -0.564050650085659*b[i + 94*ldb] + -0.01698433971579627*b[i + 95*ldb] + 0.5279041678421734*b[i + 96*ldb] + 0.02035288870568681*b[i + 97*ldb] + 0.01987965941343628*b[i + 98*ldb] + -3.581597315354408*b[i + 99*ldb] + -0.01215166511285262*b[i + 100*ldb] + 0.0459078476533179*b[i + 101*ldb] + -2.965388897477289*b[i + 102*ldb] + -0.04766271928616608*b[i + 103*ldb] + 0.2089760190013807*b[i + 104*ldb] + -3.812557894803956*b[i + 159*ldb] + 0.7583532171678773*b[i + 174*ldb] + 1.70607502775383*b[i + 189*ldb] + -0.9285580266438336*b[i + 204*ldb] + 0.9704208807564543*b[i + 219*ldb]);
        c[i + 25*ldc] = (0.6700089687429422*b[i + 15*ldb] + -0.07381136587329767*b[i + 16*ldb] + 0.3382891868158406*b[i + 17*ldb] + -1.547856590176338*b[i + 18*ldb] + -0.6449271066413235*b[i + 19*ldb] + 2.110251502449065*b[i + 20*ldb] + -0.1536175324542066*b[i + 21*ldb] + 1.896047521200515*b[i + 22*ldb] + 1.335288332277977*b[i + 23*ldb] + 0.1712431320875245*b[i + 24*ldb] + 4.031390515234344*b[i + 25*ldb] + 0.209949353949926*b[i + 26*ldb] + 0.1241305557641109*b[i + 27*ldb] + -1.09762839928984*b[i + 28*ldb] + 1.687561521519859*b[i + 29*ldb] + 0.6255688165573523*b[i + 90*ldb] + -0.1068368224642844*b[i + 91*ldb] + -2.583413129926359*b[i + 92*ldb] + -1.477330712695793*b[i + 93*ldb] + -0.6619114463571192*b[i + 94*ldb] + 1.546200852363405*b[i + 95*ldb] + 0.3742866353879682*b[i + 96*ldb] + 1.91592718061395*b[i + 97*ldb] + 1.355641220983662*b[i + 98*ldb] + 0.1590914669746716*b[i + 99*ldb] + 0.4497931998799397*b[i + 100*ldb] + -2.755439543527363*b[i + 101*ldb] + 0.1700384034174278*b[i + 102*ldb] + -0.8886523802884596*b[i + 103*ldb] + 1.639898802233694*b[i + 104*ldb] + -3.812557894803956*b[i + 160*ldb] + 0.7583532171678773*b[i + 175*ldb] + 1.70607502775383*b[i + 190*ldb] + -0.9285580266438336*b[i + 205*ldb] + 0.9704208807564543*b[i + 220*ldb]);
        c[i + 26*ldc] = (-0.1068368224642844*b[i + 15*ldb] + 0.6255688165573523*b[i + 16*ldb] + -2.583413129926359*b[i + 17*ldb] + -0.6619114463571192*b[i + 18*ldb] + -1.477330712695793*b[i + 19*ldb] + 1.546200852363405*b[i + 20*ldb] + 1.91592718061395*b[i + 21*ldb] + 0.3742866353879682*b[i + 22*ldb] + 1.355641220983662*b[i + 23*ldb] + 1.639898802233694*b[i + 24*ldb] + -2.755439543527363*b[i + 25*ldb] + 0.4497931998799397*b[i + 26*ldb] + -0.8886523802884596*b[i + 27*ldb] + 0.1700384034174278*b[i + 28*ldb] + 0.1590914669746716*b[i + 29*ldb] + -0.07381136587329767*b[i + 90*ldb] + 0.6700089687429422*b[i + 91*ldb] + 0.3382891868158406*b[i + 92*ldb] + -0.6449271066413235*b[i + 93*ldb] + -1.547856590176338*b[i + 94*ldb] + 2.110251502449065*b[i + 95*ldb] + 1.896047521200515*b[i + 96*ldb] + -0.1536175324542066*b[i + 97*ldb] + 1.335288332277977*b[i + 98*ldb] + 1.687561521519859*b[i + 99*ldb] + 0.209949353949926*b[i + 100*ldb] + 4.031390515234344*b[i + 101*ldb] + -1.09762839928984*b[i + 102*ldb] + 0.1241305557641109*b[i + 103*ldb] + 0.1712431320875245*b[i + 104*ldb] + -3.812557894803956*b[i + 161*ldb] + 0.7583532171678773*b[i + 176*ldb] + 1.70607502775383*b[i + 191*ldb] + -0.9285580266438336*b[i + 206*ldb] + 0.9704208807564543*b[i + 221*ldb]);
        c[i + 27*ldc] = (0.1068368224642844*b[i + 15*ldb] + 2.583413129926359*b[i + 16*ldb] + -0.6255688165573523*b[i + 17*ldb] + 0.6619114463571192*b[i + 18*ldb] + -1.546200852363405*b[i + 19*ldb] + 1.477330712695793*b[i + 20*ldb] + -1.91592718061395*b[i + 21*ldb] + -1.355641220983662*b[i + 22*ldb] + -0.3742866353879682*b[i + 23*ldb] + 2.755439543527363*b[i + 24*ldb] + -1.639898802233694*b[i + 25*ldb] + 0.8886523802884596*b[i + 26*ldb] + -0.4497931998799397*b[i + 27*ldb] + -0.1590914669746716*b[i + 28*ldb] + -0.1700384034174278*b[i + 29*ldb] + 0.03302545659098766*b[i + 90*ldb] + 2.9217023167422*b[i + 91*ldb] + 0.04444015218558958*b[i + 92*ldb] + 0.01698433971579627*b[i + 93*ldb] + 0.564050650085659*b[i + 94*ldb] + -0.07052587748054273*b[i + 95*ldb] + -0.01987965941343628*b[i + 96*ldb] + -0.02035288870568681*b[i + 97*ldb] + -0.5279041678421734*b[i + 98*ldb] + 2.965388897477289*b[i + 99*ldb] + 0.04766271928616608*b[i + 100*ldb] + -0.2089760190013807*b[i + 101*ldb] + 3.581597315354408*b[i + 102*ldb] + 0.01215166511285262*b[i + 103*ldb] + -0.0459078476533179*b[i + 104*ldb] + -3.812557894803956*b[i + 162*ldb] + 0.7583532171678773*b[i + 177*ldb] + 1.70607502775383*b[i + 192*ldb] + -0.9285580266438336*b[i + 207*ldb] + 0.9704208807564543*b[i + 222*ldb]);
        c[i + 28*ldc] = (2.9217023167422*b[i + 15*ldb] + 0.03302545659098766*b[i + 16*ldb] + 0.04444015218558958*b[i + 17*ldb] + 0.564050650085659*b[i + 18*ldb] + 0.01698433971579627*b[i + 19*ldb] + -0.07052587748054273*b[i + 20*ldb] + -0.02035288870568681*b[i + 21*ldb] + -0.01987965941343628*b[i + 22*ldb] + -0.5279041678421734*b[i + 23*ldb] + -0.0459078476533179*b[i + 24*ldb] + -0.2089760190013807*b[i + 25*ldb] + 0.04766271928616608*b[i + 26*ldb] + 0.01215166511285262*b[i + 27*ldb] + 3.581597315354408*b[i + 28*ldb] + 2.965388897477289*b[i + 29*ldb] + 2.583413129926359*b[i + 90*ldb] + 0.1068368224642844*b[i + 91*ldb] + -0.6255688165573523*b[i + 92*ldb] + -1.546200852363405*b[i + 93*ldb] + 0.6619114463571192*b[i + 94*ldb] + 1.477330712695793*b[i + 95*ldb] + -1.355641220983662*b[i + 96*ldb] + -1.91592718061395*b[i + 97*ldb] + -0.3742866353879682*b[i + 98*ldb] + -0.1700384034174278*b[i + 99*ldb] + 0.8886523802884596*b[i + 100*ldb] + -1.639898802233694*b[i + 101*ldb] + -0.1590914669746716*b[i + 102*ldb] + -0.4497931998799397*b[i + 103*ldb] + 2.755439543527363*b[i + 104*ldb] + -3.812557894803956*b[i + 163*ldb] + 0.7583532171678773*b[i + 178*ldb] + 1.70607502775383*b[i + 193*ldb] + -0.9285580266438336*b[i + 208*ldb] + 0.9704208807564543*b[i + 223*ldb]);
        c[i + 29*ldc] = (-2.9217023167422*b[i + 15*ldb] + -0.04444015218558958*b[i + 16*ldb] + -0.03302545659098766*b[i + 17*ldb] + -0.564050650085659*b[i + 18*ldb] + 0.07052587748054273*b[i + 19*ldb] + -0.01698433971579627*b[i + 20*ldb] + 0.02035288870568681*b[i + 21*ldb] + 0.5279041678421734*b[i + 22*ldb] + 0.01987965941343628*b[i + 23*ldb] + 0.2089760190013807*b[i + 24*ldb] + 0.0459078476533179*b[i + 25*ldb] + -0.01215166511285262*b[i + 26*ldb] + -0.04766271928616608*b[i + 27*ldb] + -2.965388897477289*b[i + 28*ldb] + -3.581597315354408*b[i + 29*ldb] + -0.3382891868158406*b[i + 90*ldb] + -0.6700089687429422*b[i + 91*ldb] + 0.07381136587329767*b[i + 92*ldb] + -2.110251502449065*b[i + 93*ldb] + 1.547856590176338*b[i + 94*ldb] + 0.6449271066413235*b[i + 95*ldb] + -1.335288332277977*b[i + 96*ldb] + 0.1536175324542066*b[i + 97*ldb] + -1.896047521200515*b[i + 98*ldb] + 1.09762839928984*b[i + 99*ldb] + -0.1241305557641109*b[i + 100*ldb] + -0.1712431320875245*b[i + 101*ldb] + -1.687561521519859*b[i + 102*ldb] + -0.209949353949926*b[i + 103*ldb] + -4.031390515234344*b[i + 104*ldb] + -3.812557894803956*b[i + 164*ldb] + 0.7583532171678773*b[i + 179*ldb] + 1.70607502775383*b[i + 194*ldb] + -0.9285580266438336*b[i + 209*ldb] + 0.9704208807564543*b[i + 224*ldb]);
        c[i + 30*ldc] = (0.01666240169962252*b[i + 31*ldb] + -0.01666240169962252*b[i + 32*ldb] + -0.06412597883381979*b[i + 34*ldb] + 0.06412597883381979*b[i + 35*ldb] + -0.2284464562720814*b[i + 37*ldb] + 0.2284464562720814*b[i + 38*ldb] + -0.0809696560654336*b[i + 39*ldb] + 0.0809696560654336*b[i + 40*ldb] + -0.01902826490985636*b[i + 41*ldb] + 0.01902826490985636*b[i + 42*ldb] + -0.2968235823045307*b[i + 43*ldb] + 0.2968235823045307*b[i + 44*ldb] + -4.943623329974175*b[i + 105*ldb] + 0.5320310574554866*b[i + 106*ldb] + 0.5153686557558634*b[i + 107*ldb] + 2.118084753790551*b[i + 108*ldb] + -1.668497037618385*b[i + 109*ldb] + -1.604371058784565*b[i + 110*ldb] + 2.136333242112812*b[i + 111*ldb] + 1.189090704074046*b[i + 112*ldb] + 1.417537160346129*b[i + 113*ldb] + -0.7377711785520655*b[i + 114*ldb] + -0.6568015224866337*b[i + 115*ldb] + 1.526761453986784*b[i + 116*ldb] + 1.545789718896642*b[i + 117*ldb] + -3.174277239797759*b[i + 118*ldb] + -2.877453657493225*b[i + 119*ldb] + 1.684026960320176*b[i + 150*ldb] + -2.021528935875383*b[i + 165*ldb] + 2.021528935875383*b[i + 195*ldb] + -1.684026960320176*b[i + 210*ldb]);
        c[i + 31*ldc] = (0.5320310574554866*b[i + 30*ldb] + -4.943623329974175*b[i + 31*ldb] + 0.5153686557558634*b[i + 32*ldb] + -1.668497037618385*b[i + 33*ldb] + 2.118084753790551*b[i + 34*ldb] + -1.604371058784565*b[i + 35*ldb] + 1.189090704074046*b[i + 36*ldb] + 2.136333242112812*b[i + 37*ldb] + 1.417537160346129*b[i + 38*ldb] + -2.877453657493225*b[i + 39*ldb] + 1.526761453986784*b[i + 40*ldb] + -0.6568015224866337*b[i + 41*ldb] + -3.174277239797759*b[i + 42*ldb] + 1.545789718896642*b[i + 43*ldb] + -0.7377711785520655*b[i + 44*ldb] + 0.01666240169962252*b[i + 105*ldb] + -0.01666240169962252*b[i + 107*ldb] + -0.06412597883381979*b[i + 108*ldb] + 0.06412597883381979*b[i + 110*ldb] + -0.2284464562720814*b[i + 111*ldb] + 0.2284464562720814*b[i + 113*ldb] + 0.2968235823045307*b[i + 114*ldb] + -0.01902826490985636*b[i + 115*ldb] + 0.0809696560654336*b[i + 116*ldb] + -0.2968235823045307*b[i + 117*ldb] + 0.01902826490985636*b[i + 118*ldb] + -0.0809696560654336*b[i + 119*ldb] + 1.684026960320176*b[i + 151*ldb] + -2.021528935875383*b[i + 166*ldb] + 2.021528935875383*b[i + 196*ldb] + -1.684026960320176*b[i + 211*ldb]);
        c[i + 32*ldc] = (-0.5320310574554866*b[i + 30*ldb] + -0.5153686557558634*b[i + 31*ldb] + 4.943623329974175*b[i + 32*ldb] + 1.668497037618385*b[i + 33*ldb] + 1.604371058784565*b[i + 34*ldb] + -2.118084753790551*b[i + 35*ldb] + -1.189090704074046*b[i + 36*ldb] + -1.417537160346129*b[i + 37*ldb] + -2.136333242112812*b[i + 38*ldb] + -1.526761453986784*b[i + 39*ldb] + 2.877453657493225*b[i + 40*ldb] + 3.174277239797759*b[i + 41*ldb] + 0.6568015224866337*b[i + 42*ldb] + 0.7377711785520655*b[i + 43*ldb] + -1.545789718896642*b[i + 44*ldb] + -0.5153686557558634*b[i + 105*ldb] + -0.5320310574554866*b[i + 106*ldb] + 4.943623329974175*b[i + 107*ldb] + 1.604371058784565*b[i + 108*ldb] + 1.668497037618385*b[i + 109*ldb] + -2.118084753790551*b[i + 110*ldb] + -1.417537160346129*b[i + 111*ldb] + -1.189090704074046*b[i + 112*ldb] + -2.136333242112812*b[i + 113*ldb] + -1.545789718896642*b[i + 114*ldb] + 3.174277239797759*b[i + 115*ldb] + 2.877453657493225*b[i + 116*ldb] + 0.7377711785520655*b[i + 117*ldb] + 0.6568015224866337*b[i + 118*ldb] + -1.526761453986784*b[i + 119*ldb] + 1.684026960320176*b[i + 152*ldb] + -2.021528935875383*b[i + 167*ldb] + 2.021528935875383*b[i + 197*ldb] + -1.684026960320176*b[i + 212*ldb]);
        c[i + 33*ldc] = (-0.0832386718891518*b[i + 31*ldb] + 0.0832386718891518*b[i + 32*ldb] + 0.1767047850928541*b[i + 34*ldb] + -0.1767047850928541*b[i + 35*ldb] + -2.508033750268638*b[i + 37*ldb] + 2.508033750268638*b[i + 38*ldb] + -0.2525315576529422*b[i + 39*ldb] + 0.2525315576529422*b[i + 40*ldb] + -0.03160100937678251*b[i + 41*ldb] + 0.03160100937678251*b[i + 42*ldb] + -2.356239812122482*b[i + 43*ldb] + 2.356239812122482*b[i + 44*ldb] + 0.04609417395922302*b[i + 105*ldb] + -0.1031803103571685*b[i + 106*ldb] + -0.01994163846801661*b[i + 107*ldb] + -0.3632813123758165*b[i + 108*ldb] + -1.492300533375874*b[i + 109*ldb] + -1.669005318468729*b[i + 110*ldb] + 1.730263001372271*b[i + 111*ldb] + -0.119528214542479*b[i + 112*ldb] + 2.388505535726159*b[i + 113*ldb] + -0.1709917888150785*b[i + 114*ldb] + 0.08153976883786418*b[i + 115*ldb] + 0.7288527548607495*b[i + 116*ldb] + 0.7604537642375322*b[i + 117*ldb] + 0.009187597244981638*b[i + 118*ldb] + 2.365427409367463*b[i + 119*ldb] + 1.684026960320176*b[i + 153*ldb] + -2.021528935875383*b[i + 168*ldb] + 2.021528935875383*b[i + 198*ldb] + -1.684026960320176*b[i + 213*ldb]);
        c[i + 34*ldc] = (-0.1031803103571685*b[i + 30*ldb] + 0.04609417395922302*b[i + 31*ldb] + -0.01994163846801661*b[i + 32*ldb] + -1.492300533375874*b[i + 33*ldb] + -0.3632813123758165*b[i + 34*ldb] + -1.669005318468729*b[i + 35*ldb] + -0.119528214542479*b[i + 36*ldb] + 1.730263001372271*b[i + 37*ldb] + 2.388505535726159*b[i + 38*ldb] + 2.365427409367463*b[i + 39*ldb] + 0.7288527548607495*b[i + 40*ldb] + 0.08153976883786418*b[i + 41*ldb] + 0.009187597244981638*b[i + 42*ldb] + 0.7604537642375322*b[i + 43*ldb] + -0.1709917888150785*b[i + 44*ldb] + -0.0832386718891518*b[i + 105*ldb] + 0.0832386718891518*b[i + 107*ldb] + 0.1767047850928541*b[i + 108*ldb] + -0.1767047850928541*b[i + 110*ldb] + -2.508033750268638*b[i + 111*ldb] + 2.508033750268638*b[i + 113*ldb] + 2.356239812122482*b[i + 114*ldb] + -0.03160100937678251*b[i + 115*ldb] + 0.2525315576529422*b[i + 116*ldb] + -2.356239812122482*b[i + 117*ldb] + 0.03160100937678251*b[i + 118*ldb] + -0.2525315576529422*b[i + 119*ldb] + 1.684026960320176*b[i + 154*ldb] + -2.021528935875383*b[i + 169*ldb] + 2.021528935875383*b[i + 199*ldb] + -1.684026960320176*b[i + 214*ldb]);
        c[i + 35*ldc] = (0.1031803103571685*b[i + 30*ldb] + 0.01994163846801661*b[i + 31*ldb] + -0.04609417395922302*b[i + 32*ldb] + 1.492300533375874*b[i + 33*ldb] + 1.669005318468729*b[i + 34*ldb] + 0.3632813123758165*b[i + 35*ldb] + 0.119528214542479*b[i + 36*ldb] + -2.388505535726159*b[i + 37*ldb] + -1.730263001372271*b[i + 38*ldb] + -0.7288527548607495*b[i + 39*ldb] + -2.365427409367463*b[i + 40*ldb] + -0.009187597244981638*b[i + 41*ldb] + -0.08153976883786418*b[i + 42*ldb] + 0.1709917888150785*b[i + 43*ldb] + -0.7604537642375322*b[i + 44*ldb] + 0.01994163846801661*b[i + 105*ldb] + 0.1031803103571685*b[i + 106*ldb] + -0.04609417395922302*b[i + 107*ldb] + 1.669005318468729*b[i + 108*ldb] + 1.492300533375874*b[i + 109*ldb] + 0.3632813123758165*b[i + 110*ldb] + -2.388505535726159*b[i + 111*ldb] + 0.119528214542479*b[i + 112*ldb] + -1.730263001372271*b[i + 113*ldb] + -0.7604537642375322*b[i + 114*ldb] + -0.009187597244981638*b[i + 115*ldb] + -2.365427409367463*b[i + 116*ldb] + 0.1709917888150785*b[i + 117*ldb] + -0.08153976883786418*b[i + 118*ldb] + -0.7288527548607495*b[i + 119*ldb] + 1.684026960320176*b[i + 155*ldb] + -2.021528935875383*b[i + 170*ldb] + 2.021528935875383*b[i + 200*ldb] + -1.684026960320176*b[i + 215*ldb]);
        c[i + 36*ldc] = (-0.9213245156088653*b[i + 31*ldb] + 0.9213245156088653*b[i + 32*ldb] + 1.478053430463056*b[i + 34*ldb] + -1.478053430463056*b[i + 35*ldb] + 0.657627957956578*b[i + 37*ldb] + -0.657627957956578*b[i + 38*ldb] + -1.844372618022506*b[i + 39*ldb] + 1.844372618022506*b[i + 40*ldb] + -1.70239108991215*b[i + 41*ldb] + 1.70239108991215*b[i + 42*ldb] + -0.2828454530477449*b[i + 43*ldb] + 0.2828454530477449*b[i + 44*ldb] + 0.04922131659554296*b[i + 105*ldb] + -1.063952765527867*b[i + 106*ldb] + -0.1426282499190014*b[i + 107*ldb] + -0.2449733459341608*b[i + 108*ldb] + 1.892059090254097*b[i + 109*ldb] + 0.4140056597910398*b[i + 110*ldb] + 3.824491607376837*b[i + 111*ldb] + 0.01268686934620999*b[i + 112*ldb] + -0.6449410886103684*b[i + 113*ldb] + -1.893604927353485*b[i + 114*ldb] + -0.04923230933097847*b[i + 115*ldb] + 0.1863127236068944*b[i + 116*ldb] + 1.888703813519044*b[i + 117*ldb] + -0.02804075661045902*b[i + 118*ldb] + 0.2548046964372861*b[i + 119*ldb] + 1.684026960320176*b[i + 156*ldb] + -2.021528935875383*b[i + 171*ldb] + 2.021528935875383*b[i + 201*ldb] + -1.684026960320176*b[i + 216*ldb]);
        c[i + 37*ldc] = (-1.063952765527867*b[i + 30*ldb] + 0.04922131659554296*b[i + 31*ldb] + -0.1426282499190014*b[i + 32*ldb] + 1.892059090254097*b[i + 33*ldb] + -0.2449733459341608*b[i + 34*ldb] + 0.4140056597910398*b[i + 35*ldb] + 0.01268686934620999*b[i + 36*ldb] + 3.824491607376837*b[i + 37*ldb] + -0.6449410886103684*b[i + 38*ldb] + 0.2548046964372861*b[i + 39*ldb] + 0.1863127236068944*b[i + 40*ldb] + -0.04923230933097847*b[i + 41*ldb] + -0.02804075661045902*b[i + 42*ldb] + 1.888703813519044*b[i + 43*ldb] + -1.893604927353485*b[i + 44*ldb] + -0.9213245156088653*b[i + 105*ldb] + 0.9213245156088653*b[i + 107*ldb] + 1.478053430463056*b[i + 108*ldb] + -1.478053430463056*b[i + 110*ldb] + 0.657627957956578*b[i + 111*ldb] + -0.657627957956578*b[i + 113*ldb] + 0.2828454530477449*b[i + 114*ldb] + -1.70239108991215*b[i + 115*ldb] + 1.844372618022506*b[i + 116*ldb] + -0.2828454530477449*b[i + 117*ldb] + 1.70239108991215*b[i + 118*ldb] + -1.844372618022506*b[i + 119*ldb] + 1.684026960320176*b[i + 157*ldb] + -2.021528935875383*b[i + 172*ldb] + 2.021528935875383*b[i + 202*ldb] + -1.684026960320176*b[i + 217*ldb]);
        c[i + 38*ldc] = (1.063952765527867*b[i + 30*ldb] + 0.1426282499190014*b[i + 31*ldb] + -0.04922131659554296*b[i + 32*ldb] + -1.892059090254097*b[i + 33*ldb] + -0.4140056597910398*b[i + 34*ldb] + 0.2449733459341608*b[i + 35*ldb] + -0.01268686934620999*b[i + 36*ldb] + 0.6449410886103684*b[i + 37*ldb] + -3.824491607376837*b[i + 38*ldb] + -0.1863127236068944*b[i + 39*ldb] + -0.2548046964372861*b[i + 40*ldb] + 0.02804075661045902*b[i + 41*ldb] + 0.04923230933097847*b[i + 42*ldb] + 1.893604927353485*b[i + 43*ldb] + -1.888703813519044*b[i + 44*ldb] + 0.1426282499190014*b[i + 105*ldb] + 1.063952765527867*b[i + 106*ldb] + -0.04922131659554296*b[i + 107*ldb] + -0.4140056597910398*b[i + 108*ldb] + -1.892059090254097*b[i + 109*ldb] + 0.2449733459341608*b[i + 110*ldb] + 0.6449410886103684*b[i + 111*ldb] + -0.01268686934620999*b[i + 112*ldb] + -3.824491607376837*b[i + 113*ldb] + -1.888703813519044*b[i + 114*ldb] + 0.02804075661045902*b[i + 115*ldb] + -0.2548046964372861*b[i + 116*ldb] + 1.893604927353485*b[i + 117*ldb] + 0.04923230933097847*b[i + 118*ldb] + -0.1863127236068944*b[i + 119*ldb] + 1.684026960320176*b[i + 158*ldb] + -2.021528935875383*b[i + 173*ldb] + 2.021528935875383*b[i + 203*ldb] + -1.684026960320176*b[i + 218*ldb]);
        c[i + 39*ldc] = (-0.6700089687429422*b[i + 30*ldb] + -0.3382891868158406*b[i + 31*ldb] + 0.07381136587329767*b[i + 32*ldb] + 1.547856590176338*b[i + 33*ldb] + -2.110251502449065*b[i + 34*ldb] + 0.6449271066413235*b[i + 35*ldb] + 0.1536175324542066*b[i + 36*ldb] + -1.335288332277977*b[i + 37*ldb] + -1.896047521200515*b[i + 38*ldb] + -4.031390515234344*b[i + 39*ldb] + -0.1712431320875245*b[i + 40*ldb] + -0.1241305557641109*b[i + 41*ldb] + -0.209949353949926*b[i + 42*ldb] + -1.687561521519859*b[i + 43*ldb] + 1.09762839928984*b[i + 44*ldb] + -0.04444015218558958*b[i + 105*ldb] + -2.9217023167422*b[i + 106*ldb] + -0.03302545659098766*b[i + 107*ldb] + 0.07052587748054273*b[i + 108*ldb] + -0.564050650085659*b[i + 109*ldb] + -0.01698433971579627*b[i + 110*ldb] + 0.5279041678421734*b[i + 111*ldb] + 0.02035288870568681*b[i + 112*ldb] + 0.01987965941343628*b[i + 113*ldb] + -3.581597315354408*b[i + 114*ldb] + -0.01215166511285262*b[i + 115*ldb] + 0.0459078476533179*b[i + 116*ldb] + -2.965388897477289*b[i + 117*ldb] + -0.04766271928616608*b[i + 118*ldb] + 0.2089760190013807*b[i + 119*ldb] + 1.684026960320176*b[i + 159*ldb] + -2.021528935875383*b[i + 174*ldb] + 2.021528935875383*b[i + 204*ldb] + -1.684026960320176*b[i + 219*ldb]);
        c[i + 40*ldc] = (0.6700089687429422*b[i + 30*ldb] + -0.07381136587329767*b[i + 31*ldb] + 0.3382891868158406*b[i + 32*ldb] + -1.547856590176338*b[i + 33*ldb] + -0.6449271066413235*b[i + 34*ldb] + 2.110251502449065*b[i + 35*ldb] + -0.1536175324542066*b[i + 36*ldb] + 1.896047521200515*b[i + 37*ldb] + 1.335288332277977*b[i + 38*ldb] + 0.1712431320875245*b[i + 39*ldb] + 4.031390515234344*b[i + 40*ldb] + 0.209949353949926*b[i + 41*ldb] + 0.1241305557641109*b[i + 42*ldb] + -1.09762839928984*b[i + 43*ldb] + 1.687561521519859*b[i + 44*ldb] + 0.6255688165573523*b[i + 105*ldb] + -0.1068368224642844*b[i + 106*ldb] + -2.583413129926359*b[i + 107*ldb] + -1.477330712695793*b[i + 108*ldb] + -0.6619114463571192*b[i + 109*ldb] + 1.546200852363405*b[i + 110*ldb] + 0.3742866353879682*b[i + 111*ldb] + 1.91592718061395*b[i + 112*ldb] + 1.355641220983662*b[i + 113*ldb] + 0.1590914669746716*b[i + 114*ldb] + 0.4497931998799397*b[i + 115*ldb] + -2.755439543527363*b[i + 116*ldb] + 0.1700384034174278*b[i + 117*ldb] + -0.8886523802884596*b[i + 118*ldb] + 1.639898802233694*b[i + 119*ldb] + 1.684026960320176*b[i + 160*ldb] + -2.021528935875383*b[i + 175*ldb] + 2.021528935875383*b[i + 205*ldb] + -1.684026960320176*b[i + 220*ldb]);
        c[i + 41*ldc] = (-0.1068368224642844*b[i + 30*ldb] + 0.6255688165573523*b[i + 31*ldb] + -2.583413129926359*b[i + 32*ldb] + -0.6619114463571192*b[i + 33*ldb] + -1.477330712695793*b[i + 34*ldb] + 1.546200852363405*b[i + 35*ldb] + 1.91592718061395*b[i + 36*ldb] + 0.3742866353879682*b[i + 37*ldb] + 1.355641220983662*b[i + 38*ldb] + 1.639898802233694*b[i + 39*ldb] + -2.755439543527363*b[i + 40*ldb] + 0.4497931998799397*b[i + 41*ldb] + -0.8886523802884596*b[i + 42*ldb] + 0.1700384034174278*b[i + 43*ldb] + 0.1590914669746716*b[i + 44*ldb] + -0.07381136587329767*b[i + 105*ldb] + 0.6700089687429422*b[i + 106*ldb] + 0.3382891868158406*b[i + 107*ldb] + -0.6449271066413235*b[i + 108*ldb] + -1.547856590176338*b[i + 109*ldb] + 2.110251502449065*b[i + 110*ldb] + 1.896047521200515*b[i + 111*ldb] + -0.1536175324542066*b[i + 112*ldb] + 1.335288332277977*b[i + 113*ldb] + 1.687561521519859*b[i + 114*ldb] + 0.209949353949926*b[i + 115*ldb] + 4.031390515234344*b[i + 116*ldb] + -1.09762839928984*b[i + 117*ldb] + 0.1241305557641109*b[i + 118*ldb] + 0.1712431320875245*b[i + 119*ldb] + 1.684026960320176*b[i + 161*ldb] + -2.021528935875383*b[i + 176*ldb] + 2.021528935875383*b[i + 206*ldb] + -1.684026960320176*b[i + 221*ldb]);
        c[i + 42*ldc] = (0.1068368224642844*b[i + 30*ldb] + 2.583413129926359*b[i + 31*ldb] + -0.6255688165573523*b[i + 32*ldb] + 0.6619114463571192*b[i + 33*ldb] + -1.546200852363405*b[i + 34*ldb] + 1.477330712695793*b[i + 35*ldb] + -1.91592718061395*b[i + 36*ldb] + -1.355641220983662*b[i + 37*ldb] + -0.3742866353879682*b[i + 38*ldb] + 2.755439543527363*b[i + 39*ldb] + -1.639898802233694*b[i + 40*ldb] + 0.8886523802884596*b[i + 41*ldb] + -0.4497931998799397*b[i + 42*ldb] + -0.1590914669746716*b[i + 43*ldb] + -0.1700384034174278*b[i + 44*ldb] + 0.03302545659098766*b[i + 105*ldb] + 2.9217023167422*b[i + 106*ldb] + 0.04444015218558958*b[i + 107*ldb] + 0.01698433971579627*b[i + 108*ldb] + 0.564050650085659*b[i + 109*ldb] + -0.07052587748054273*b[i + 110*ldb] + -0.01987965941343628*b[i + 111*ldb] + -0.02035288870568681*b[i + 112*ldb] + -0.5279041678421734*b[i + 113*ldb] + 2.965388897477289*b[i + 114*ldb] + 0.04766271928616608*b[i + 115*ldb] + -0.2089760190013807*b[i + 116*ldb] + 3.581597315354408*b[i + 117*ldb] + 0.01215166511285262*b[i + 118*ldb] + -0.0459078476533179*b[i + 119*ldb] + 1.684026960320176*b[i + 162*ldb] + -2.021528935875383*b[i + 177*ldb] + 2.021528935875383*b[i + 207*ldb] + -1.684026960320176*b[i + 222*ldb]);
        c[i + 43*ldc] = (2.9217023167422*b[i + 30*ldb] + 0.03302545659098766*b[i + 31*ldb] + 0.04444015218558958*b[i + 32*ldb] + 0.564050650085659*b[i + 33*ldb] + 0.01698433971579627*b[i + 34*ldb] + -0.07052587748054273*b[i + 35*ldb] + -0.02035288870568681*b[i + 36*ldb] + -0.01987965941343628*b[i + 37*ldb] + -0.5279041678421734*b[i + 38*ldb] + -0.0459078476533179*b[i + 39*ldb] + -0.2089760190013807*b[i + 40*ldb] + 0.04766271928616608*b[i + 41*ldb] + 0.01215166511285262*b[i + 42*ldb] + 3.581597315354408*b[i + 43*ldb] + 2.965388897477289*b[i + 44*ldb] + 2.583413129926359*b[i + 105*ldb] + 0.1068368224642844*b[i + 106*ldb] + -0.6255688165573523*b[i + 107*ldb] + -1.546200852363405*b[i + 108*ldb] + 0.6619114463571192*b[i + 109*ldb] + 1.477330712695793*b[i + 110*ldb] + -1.355641220983662*b[i + 111*ldb] + -1.91592718061395*b[i + 112*ldb] + -0.3742866353879682*b[i + 113*ldb] + -0.1700384034174278*b[i + 114*ldb] + 0.8886523802884596*b[i + 115*ldb] + -1.639898802233694*b[i + 116*ldb] + -0.1590914669746716*b[i + 117*ldb] + -0.4497931998799397*b[i + 118*ldb] + 2.755439543527363*b[i + 119*ldb] + 1.684026960320176*b[i + 163*ldb] + -2.021528935875383*b[i + 178*ldb] + 2.021528935875383*b[i + 208*ldb] + -1.684026960320176*b[i + 223*ldb]);
        c[i + 44*ldc] = (-2.9217023167422*b[i + 30*ldb] + -0.04444015218558958*b[i + 31*ldb] + -0.03302545659098766*b[i + 32*ldb] + -0.564050650085659*b[i + 33*ldb] + 0.07052587748054273*b[i + 34*ldb] + -0.01698433971579627*b[i + 35*ldb] + 0.02035288870568681*b[i + 36*ldb] + 0.5279041678421734*b[i + 37*ldb] + 0.01987965941343628*b[i + 38*ldb] + 0.2089760190013807*b[i + 39*ldb] + 0.0459078476533179*b[i + 40*ldb] + -0.01215166511285262*b[i + 41*ldb] + -0.04766271928616608*b[i + 42*ldb] + -2.965388897477289*b[i + 43*ldb] + -3.581597315354408*b[i + 44*ldb] + -0.3382891868158406*b[i + 105*ldb] + -0.6700089687429422*b[i + 106*ldb] + 0.07381136587329767*b[i + 107*ldb] + -2.110251502449065*b[i + 108*ldb] + 1.547856590176338*b[i + 109*ldb] + 0.6449271066413235*b[i + 110*ldb] + -1.335288332277977*b[i + 111*ldb] + 0.1536175324542066*b[i + 112*ldb] + -1.896047521200515*b[i + 113*ldb] + 1.09762839928984*b[i + 114*ldb] + -0.1241305557641109*b[i + 115*ldb] + -0.1712431320875245*b[i + 116*ldb] + -1.687561521519859*b[i + 117*ldb] + -0.209949353949926*b[i + 118*ldb] + -4.031390515234344*b[i + 119*ldb] + 1.684026960320176*b[i + 164*ldb] + -2.021528935875383*b[i + 179*ldb] + 2.021528935875383*b[i + 209*ldb] + -1.684026960320176*b[i + 224*ldb]);
        c[i + 45*ldc] = (0.01666240169962252*b[i + 46*ldb] + -0.01666240169962252*b[i + 47*ldb] + -0.06412597883381979*b[i + 49*ldb] + 0.06412597883381979*b[i + 50*ldb] + -0.2284464562720814*b[i + 52*ldb] + 0.2284464562720814*b[i + 53*ldb] + -0.0809696560654336*b[i + 54*ldb] + 0.0809696560654336*b[i + 55*ldb] + -0.01902826490985636*b[i + 56*ldb] + 0.01902826490985636*b[i + 57*ldb] + -0.2968235823045307*b[i + 58*ldb] + 0.2968235823045307*b[i + 59*ldb] + -4.943623329974175*b[i + 120*ldb] + 0.5320310574554866*b[i + 121*ldb] + 0.5153686557558634*b[i + 122*ldb] + 2.118084753790551*b[i + 123*ldb] + -1.668497037618385*b[i + 124*ldb] + -1.604371058784565*b[i + 125*ldb] + 2.136333242112812*b[i + 126*ldb] + 1.189090704074046*b[i + 127*ldb] + 1.417537160346129*b[i + 128*ldb] + -0.7377711785520655*b[i + 129*ldb] + -0.6568015224866337*b[i + 130*ldb] + 1.526761453986784*b[i + 131*ldb] + 1.545789718896642*b[i + 132*ldb] + -3.174277239797759*b[i + 133*ldb] + -2.877453657493225*b[i + 134*ldb] + -0.9704208807564543*b[i + 150*ldb] + 0.9285580266438336*b[i + 165*ldb] + -1.70607502775383*b[i + 180*ldb] + -0.7583532171678773*b[i + 195*ldb] + 3.812557894803956*b[i + 210*ldb]);
        c[i + 46*ldc] = (0.5320310574554866*b[i + 45*ldb] + -4.943623329974175*b[i + 46*ldb] + 0.5153686557558634*b[i + 47*ldb] + -1.668497037618385*b[i + 48*ldb] + 2.118084753790551*b[i + 49*ldb] + -1.604371058784565*b[i + 50*ldb] + 1.189090704074046*b[i + 51*ldb] + 2.136333242112812*b[i + 52*ldb] + 1.417537160346129*b[i + 53*ldb] + -2.877453657493225*b[i + 54*ldb] + 1.526761453986784*b[i + 55*ldb] + -0.6568015224866337*b[i + 56*ldb] + -3.174277239797759*b[i + 57*ldb] + 1.545789718896642*b[i + 58*ldb] + -0.7377711785520655*b[i + 59*ldb] + 0.01666240169962252*b[i + 120*ldb] + -0.01666240169962252*b[i + 122*ldb] + -0.06412597883381979*b[i + 123*ldb] + 0.06412597883381979*b[i + 125*ldb] + -0.2284464562720814*b[i + 126*ldb] + 0.2284464562720814*b[i + 128*ldb] + 0.2968235823045307*b[i + 129*ldb] + -0.01902826490985636*b[i + 130*ldb] + 0.0809696560654336*b[i + 131*ldb] + -0.2968235823045307*b[i + 132*ldb] + 0.01902826490985636*b[i + 133*ldb] + -0.0809696560654336*b[i + 134*ldb] + -0.9704208807564543*b[i + 151*ldb] + 0.9285580266438336*b[i + 166*ldb] + -1.70607502775383*b[i + 181*ldb] + -0.7583532171678773*b[i + 196*ldb] + 3.812557894803956*b[i + 211*ldb]);
        c[i + 47*ldc] = (-0.5320310574554866*b[i + 45*ldb] + -0.5153686557558634*b[i + 46*ldb] + 4.943623329974175*b[i + 47*ldb] + 1.668497037618385*b[i + 48*ldb] + 1.604371058784565*b[i + 49*ldb] + -2.118084753790551*b[i + 50*ldb] + -1.189090704074046*b[i + 51*ldb] + -1.417537160346129*b[i + 52*ldb] + -2.136333242112812*b[i + 53*ldb] + -1.526761453986784*b[i + 54*ldb] + 2.877453657493225*b[i + 55*ldb] + 3.174277239797759*b[i + 56*ldb] + 0.6568015224866337*b[i + 57*ldb] + 0.7377711785520655*b[i + 58*ldb] + -1.545789718896642*b[i + 59*ldb] + -0.5153686557558634*b[i + 120*ldb] + -0.5320310574554866*b[i + 121*ldb] + 4.943623329974175*b[i + 122*ldb] + 1.604371058784565*b[i + 123*ldb] + 1.668497037618385*b[i + 124*ldb] + -2.118084753790551*b[i + 125*ldb] + -1.417537160346129*b[i + 126*ldb] + -1.189090704074046*b[i + 127*ldb] + -2.136333242112812*b[i + 128*ldb] + -1.545789718896642*b[i + 129*ldb] + 3.174277239797759*b[i + 130*ldb] + 2.877453657493225*b[i + 131*ldb] + 0.7377711785520655*b[i + 132*ldb] + 0.6568015224866337*b[i + 133*ldb] + -1.526761453986784*b[i + 134*ldb] + -0.9704208807564543*b[i + 152*ldb] + 0.9285580266438336*b[i + 167*ldb] + -1.70607502775383*b[i + 182*ldb] + -0.7583532171678773*b[i + 197*ldb] + 3.812557894803956*b[i + 212*ldb]);
        c[i + 48*ldc] = (-0.0832386718891518*b[i + 46*ldb] + 0.0832386718891518*b[i + 47*ldb] + 0.1767047850928541*b[i + 49*ldb] + -0.1767047850928541*b[i + 50*ldb] + -2.508033750268638*b[i + 52*ldb] + 2.508033750268638*b[i + 53*ldb] + -0.2525315576529422*b[i + 54*ldb] + 0.2525315576529422*b[i + 55*ldb] + -0.03160100937678251*b[i + 56*ldb] + 0.03160100937678251*b[i + 57*ldb] + -2.356239812122482*b[i + 58*ldb] + 2.356239812122482*b[i + 59*ldb] + 0.04609417395922302*b[i + 120*ldb] + -0.1031803103571685*b[i + 121*ldb] + -0.01994163846801661*b[i + 122*ldb] + -0.3632813123758165*b[i + 123*ldb] + -1.492300533375874*b[i + 124*ldb] + -1.669005318468729*b[i + 125*ldb] + 1.730263001372271*b[i + 126*ldb] + -0.119528214542479*b[i + 127*ldb] + 2.388505535726159*b[i + 128*ldb] + -0.1709917888150785*b[i + 129*ldb] + 0.08153976883786418*b[i + 130*ldb] + 0.7288527548607495*b[i + 131*ldb] + 0.7604537642375322*b[i + 132*ldb] + 0.009187597244981638*b[i + 133*ldb] + 2.365427409367463*b[i + 134*ldb] + -0.9704208807564543*b[i + 153*ldb] + 0.9285580266438336*b[i + 168*ldb] + -1.70607502775383*b[i + 183*ldb] + -0.7583532171678773*b[i + 198*ldb] + 3.812557894803956*b[i + 213*ldb]);
        c[i + 49*ldc] = (-0.1031803103571685*b[i + 45*ldb] + 0.04609417395922302*b[i + 46*ldb] + -0.01994163846801661*b[i + 47*ldb] + -1.492300533375874*b[i + 48*ldb] + -0.3632813123758165*b[i + 49*ldb] + -1.669005318468729*b[i + 50*ldb] + -0.119528214542479*b[i + 51*ldb] + 1.730263001372271*b[i + 52*ldb] + 2.388505535726159*b[i + 53*ldb] + 2.365427409367463*b[i + 54*ldb] + 0.7288527548607495*b[i + 55*ldb] + 0.08153976883786418*b[i + 56*ldb] + 0.009187597244981638*b[i + 57*ldb] + 0.7604537642375322*b[i + 58*ldb] + -0.1709917888150785*b[i + 59*ldb] + -0.0832386718891518*b[i + 120*ldb] + 0.0832386718891518*b[i + 122*ldb] + 0.1767047850928541*b[i + 123*ldb] + -0.1767047850928541*b[i + 125*ldb] + -2.508033750268638*b[i + 126*ldb] + 2.508033750268638*b[i + 128*ldb] + 2.356239812122482*b[i + 129*ldb] + -0.03160100937678251*b[i + 130*ldb] + 0.2525315576529422*b[i + 131*ldb] + -2.356239812122482*b[i + 132*ldb] + 0.03160100937678251*b[i + 133*ldb] + -0.2525315576529422*b[i + 134*ldb] + -0.9704208807564543*b[i + 154*ldb] + 0.9285580266438336*b[i + 169*ldb] + -1.70607502775383*b[i + 184*ldb] + -0.7583532171678773*b[i + 199*ldb] + 3.812557894803956*b[i + 214*ldb]);
        c[i + 50*ldc] = (0.1031803103571685*b[i + 45*ldb] + 0.01994163846801661*b[i + 46*ldb] + -0.04609417395922302*b[i + 47*ldb] + 1.492300533375874*b[i + 48*ldb] + 1.669005318468729*b[i + 49*ldb] + 0.3632813123758165*b[i + 50*ldb] + 0.119528214542479*b[i + 51*ldb] + -2.388505535726159*b[i + 52*ldb] + -1.730263001372271*b[i + 53*ldb] + -0.7288527548607495*b[i + 54*ldb] + -2.365427409367463*b[i + 55*ldb] + -0.009187597244981638*b[i + 56*ldb] + -0.08153976883786418*b[i + 57*ldb] + 0.1709917888150785*b[i + 58*ldb] + -0.7604537642375322*b[i + 59*ldb] + 0.01994163846801661*b[i + 120*ldb] + 0.1031803103571685*b[i + 121*ldb] + -0.04609417395922302*b[i + 122*ldb] + 1.669005318468729*b[i + 123*ldb] + 1.492300533375874*b[i + 124*ldb] + 0.3632813123758165*b[i + 125*ldb] + -2.388505535726159*b[i + 126*ldb] + 0.119528214542479*b[i + 127*ldb] + -1.730263001372271*b[i + 128*ldb] + -0.7604537642375322*b[i + 129*ldb] + -0.009187597244981638*b[i + 130*ldb] + -2.365427409367463*b[i + 131*ldb] + 0.1709917888150785*b[i + 132*ldb] + -0.08153976883786418*b[i + 133*ldb] + -0.7288527548607495*b[i + 134*ldb] + -0.9704208807564543*b[i + 155*ldb] + 0.9285580266438336*b[i + 170*ldb] + -1.70607502775383*b[i + 185*ldb] + -0.7583532171678773*b[i + 200*ldb] + 3.812557894803956*b[i + 215*ldb]);
        c[i + 51*ldc] = (-0.9213245156088653*b[i + 46*ldb] + 0.9213245156088653*b[i + 47*ldb] + 1.478053430463056*b[i + 49*ldb] + -1.478053430463056*b[i + 50*ldb] + 0.657627957956578*b[i + 52*ldb] + -0.657627957956578*b[i + 53*ldb] + -1.844372618022506*b[i + 54*ldb] + 1.844372618022506*b[i + 55*ldb] + -1.70239108991215*b[i + 56*ldb] + 1.70239108991215*b[i + 57*ldb] + -0.2828454530477449*b[i + 58*ldb] + 0.2828454530477449*b[i + 59*ldb] + 0.04922131659554296*b[i + 120*ldb] + -1.063952765527867*b[i + 121*ldb] + -0.1426282499190014*b[i + 122*ldb] + -0.2449733459341608*b[i + 123*ldb] + 1.892059090254097*b[i + 124*ldb] + 0.4140056597910398*b[i + 125*ldb] + 3.824491607376837*b[i + 126*ldb] + 0.01268686934620999*b[i + 127*ldb] + -0.6449410886103684*b[i + 128*ldb] + -1.893604927353485*b[i + 129*ldb] + -0.04923230933097847*b[i + 130*ldb] + 0.1863127236068944*b[i + 131*ldb] + 1.888703813519044*b[i + 132*ldb] + -0.02804075661045902*b[i + 133*ldb] + 0.2548046964372861*b[i + 134*ldb] + -0.9704208807564543*b[i + 156*ldb] + 0.9285580266438336*b[i + 171*ldb] + -1.70607502775383*b[i + 186*ldb] + -0.7583532171678773*b[i + 201*ldb] + 3.812557894803956*b[i + 216*ldb]);
        c[i + 52*ldc] = (-1.063952765527867*b[i + 45*ldb] + 0.04922131659554296*b[i + 46*ldb] + -0.1426282499190014*b[i + 47*ldb] + 1.892059090254097*b[i + 48*ldb] + -0.2449733459341608*b[i + 49*ldb] + 0.4140056597910398*b[i + 50*ldb] + 0.01268686934620999*b[i + 51*ldb] + 3.824491607376837*b[i + 52*ldb] + -0.6449410886103684*b[i + 53*ldb] + 0.2548046964372861*b[i + 54*ldb] + 0.1863127236068944*b[i + 55*ldb] + -0.04923230933097847*b[i + 56*ldb] + -0.02804075661045902*b[i + 57*ldb] + 1.888703813519044*b[i + 58*ldb] + -1.893604927353485*b[i + 59*ldb] + -0.9213245156088653*b[i + 120*ldb] + 0.9213245156088653*b[i + 122*ldb] + 1.478053430463056*b[i + 123*ldb] + -1.478053430463056*b[i + 125*ldb] + 0.657627957956578*b[i + 126*ldb] + -0.657627957956578*b[i + 128*ldb] + 0.2828454530477449*b[i + 129*ldb] + -1.70239108991215*b[i + 130*ldb] + 1.844372618022506*b[i + 131*ldb] + -0.2828454530477449*b[i + 132*ldb] + 1.70239108991215*b[i + 133*ldb] + -1.844372618022506*b[i + 134*ldb] + -0.9704208807564543*b[i + 157*ldb] + 0.9285580266438336*b[i + 172*ldb] + -1.70607502775383*b[i + 187*ldb] + -0.7583532171678773*b[i + 202*ldb] + 3.812557894803956*b[i + 217*ldb]);
        c[i + 53*ldc] = (1.063952765527867*b[i + 45*ldb] + 0.1426282499190014*b[i + 46*ldb] + -0.04922131659554296*b[i + 47*ldb] + -1.892059090254097*b[i + 48*ldb] + -0.4140056597910398*b[i + 49*ldb] + 0.2449733459341608*b[i + 50*ldb] + -0.01268686934620999*b[i + 51*ldb] + 0.6449410886103684*b[i + 52*ldb] + -3.824491607376837*b[i + 53*ldb] + -0.1863127236068944*b[i + 54*ldb] + -0.2548046964372861*b[i + 55*ldb] + 0.02804075661045902*b[i + 56*ldb] + 0.04923230933097847*b[i + 57*ldb] + 1.893604927353485*b[i + 58*ldb] + -1.888703813519044*b[i + 59*ldb] + 0.1426282499190014*b[i + 120*ldb] + 1.063952765527867*b[i + 121*ldb] + -0.04922131659554296*b[i + 122*ldb] + -0.4140056597910398*b[i + 123*ldb] + -1.892059090254097*b[i + 124*ldb] + 0.2449733459341608*b[i + 125*ldb] + 0.6449410886103684*b[i + 126*ldb] + -0.01268686934620999*b[i + 127*ldb] + -3.824491607376837*b[i + 128*ldb] + -1.888703813519044*b[i + 129*ldb] + 0.02804075661045902*b[i + 130*ldb] + -0.2548046964372861*b[i + 131*ldb] + 1.893604927353485*b[i + 132*ldb] + 0.04923230933097847*b[i + 133*ldb] + -0.1863127236068944*b[i + 134*ldb] + -0.9704208807564543*b[i + 158*ldb] + 0.9285580266438336*b[i + 173*ldb] + -1.70607502775383*b[i + 188*ldb] + -0.7583532171678773*b[i + 203*ldb] + 3.812557894803956*b[i + 218*ldb]);
        c[i + 54*ldc] = (-0.6700089687429422*b[i + 45*ldb] + -0.3382891868158406*b[i + 46*ldb] + 0.07381136587329767*b[i + 47*ldb] + 1.547856590176338*b[i + 48*ldb] + -2.110251502449065*b[i + 49*ldb] + 0.6449271066413235*b[i + 50*ldb] + 0.1536175324542066*b[i + 51*ldb] + -1.335288332277977*b[i + 52*ldb] + -1.896047521200515*b[i + 53*ldb] + -4.031390515234344*b[i + 54*ldb] + -0.1712431320875245*b[i + 55*ldb] + -0.1241305557641109*b[i + 56*ldb] + -0.209949353949926*b[i + 57*ldb] + -1.687561521519859*b[i + 58*ldb] + 1.09762839928984*b[i + 59*ldb] + -0.04444015218558958*b[i + 120*ldb] + -2.9217023167422*b[i + 121*ldb] + -0.03302545659098766*b[i + 122*ldb] + 0.07052587748054273*b[i + 123*ldb] + -0.564050650085659*b[i + 124*ldb] + -0.01698433971579627*b[i + 125*ldb] + 0.5279041678421734*b[i + 126*ldb] + 0.02035288870568681*b[i + 127*ldb] + 0.01987965941343628*b[i + 128*ldb] + -3.581597315354408*b[i + 129*ldb] + -0.01215166511285262*b[i + 130*ldb] + 0.0459078476533179*b[i + 131*ldb] + -2.965388897477289*b[i + 132*ldb] + -0.04766271928616608*b[i + 133*ldb] + 0.2089760190013807*b[i + 134*ldb] + -0.9704208807564543*b[i + 159*ldb] + 0.9285580266438336*b[i + 174*ldb] + -1.70607502775383*b[i + 189*ldb] + -0.7583532171678773*b[i + 204*ldb] + 3.812557894803956*b[i + 219*ldb]);
        c[i + 55*ldc] = (0.6700089687429422*b[i + 45*ldb] + -0.07381136587329767*b[i + 46*ldb] + 0.3382891868158406*b[i + 47*ldb] + -1.547856590176338*b[i + 48*ldb] + -0.6449271066413235*b[i + 49*ldb] + 2.110251502449065*b[i + 50*ldb] + -0.1536175324542066*b[i + 51*ldb] + 1.896047521200515*b[i + 52*ldb] + 1.335288332277977*b[i + 53*ldb] + 0.1712431320875245*b[i + 54*ldb] + 4.031390515234344*b[i + 55*ldb] + 0.209949353949926*b[i + 56*ldb] + 0.1241305557641109*b[i + 57*ldb] + -1.09762839928984*b[i + 58*ldb] + 1.687561521519859*b[i + 59*ldb] + 0.6255688165573523*b[i + 120*ldb] + -0.1068368224642844*b[i + 121*ldb] + -2.583413129926359*b[i + 122*ldb] + -1.477330712695793*b[i + 123*ldb] + -0.6619114463571192*b[i + 124*ldb] + 1.546200852363405*b[i + 125*ldb] + 0.3742866353879682*b[i + 126*ldb] + 1.91592718061395*b[i + 127*ldb] + 1.355641220983662*b[i + 128*ldb] + 0.1590914669746716*b[i + 129*ldb] + 0.4497931998799397*b[i + 130*ldb] + -2.755439543527363*b[i + 131*ldb] + 0.1700384034174278*b[i + 132*ldb] + -0.8886523802884596*b[i + 133*ldb] + 1.639898802233694*b[i + 134*ldb] + -0.9704208807564543*b[i + 160*ldb] + 0.9285580266438336*b[i + 175*ldb] + -1.70607502775383*b[i + 190*ldb] + -0.7583532171678773*b[i + 205*ldb] + 3.812557894803956*b[i + 220*ldb]);
        c[i + 56*ldc] = (-0.1068368224642844*b[i + 45*ldb] + 0.6255688165573523*b[i + 46*ldb] + -2.583413129926359*b[i + 47*ldb] + -0.6619114463571192*b[i + 48*ldb] + -1.477330712695793*b[i + 49*ldb] + 1.546200852363405*b[i + 50*ldb] + 1.91592718061395*b[i + 51*ldb] + 0.3742866353879682*b[i + 52*ldb] + 1.355641220983662*b[i + 53*ldb] + 1.639898802233694*b[i + 54*ldb] + -2.755439543527363*b[i + 55*ldb] + 0.4497931998799397*b[i + 56*ldb] + -0.8886523802884596*b[i + 57*ldb] + 0.1700384034174278*b[i + 58*ldb] + 0.1590914669746716*b[i + 59*ldb] + -0.07381136587329767*b[i + 120*ldb] + 0.6700089687429422*b[i + 121*ldb] + 0.3382891868158406*b[i + 122*ldb] + -0.6449271066413235*b[i + 123*ldb] + -1.547856590176338*b[i + 124*ldb] + 2.110251502449065*b[i + 125*ldb] + 1.896047521200515*b[i + 126*ldb] + -0.1536175324542066*b[i + 127*ldb] + 1.335288332277977*b[i + 128*ldb] + 1.687561521519859*b[i + 129*ldb] + 0.209949353949926*b[i + 130*ldb] + 4.031390515234344*b[i + 131*ldb] + -1.09762839928984*b[i + 132*ldb] + 0.1241305557641109*b[i + 133*ldb] + 0.1712431320875245*b[i + 134*ldb] + -0.9704208807564543*b[i + 161*ldb] + 0.9285580266438336*b[i + 176*ldb] + -1.70607502775383*b[i + 191*ldb] + -0.7583532171678773*b[i + 206*ldb] + 3.812557894803956*b[i + 221*ldb]);
        c[i + 57*ldc] = (0.1068368224642844*b[i + 45*ldb] + 2.583413129926359*b[i + 46*ldb] + -0.6255688165573523*b[i + 47*ldb] + 0.6619114463571192*b[i + 48*ldb] + -1.546200852363405*b[i + 49*ldb] + 1.477330712695793*b[i + 50*ldb] + -1.91592718061395*b[i + 51*ldb] + -1.355641220983662*b[i + 52*ldb] + -0.3742866353879682*b[i + 53*ldb] + 2.755439543527363*b[i + 54*ldb] + -1.639898802233694*b[i + 55*ldb] + 0.8886523802884596*b[i + 56*ldb] + -0.4497931998799397*b[i + 57*ldb] + -0.1590914669746716*b[i + 58*ldb] + -0.1700384034174278*b[i + 59*ldb] + 0.03302545659098766*b[i + 120*ldb] + 2.9217023167422*b[i + 121*ldb] + 0.04444015218558958*b[i + 122*ldb] + 0.01698433971579627*b[i + 123*ldb] + 0.564050650085659*b[i + 124*ldb] + -0.07052587748054273*b[i + 125*ldb] + -0.01987965941343628*b[i + 126*ldb] + -0.02035288870568681*b[i + 127*ldb] + -0.5279041678421734*b[i + 128*ldb] + 2.965388897477289*b[i + 129*ldb] + 0.04766271928616608*b[i + 130*ldb] + -0.2089760190013807*b[i + 131*ldb] + 3.581597315354408*b[i + 132*ldb] + 0.01215166511285262*b[i + 133*ldb] + -0.0459078476533179*b[i + 134*ldb] + -0.9704208807564543*b[i + 162*ldb] + 0.9285580266438336*b[i + 177*ldb] + -1.70607502775383*b[i + 192*ldb] + -0.7583532171678773*b[i + 207*ldb] + 3.812557894803956*b[i + 222*ldb]);
        c[i + 58*ldc] = (2.9217023167422*b[i + 45*ldb] + 0.03302545659098766*b[i + 46*ldb] + 0.04444015218558958*b[i + 47*ldb] + 0.564050650085659*b[i + 48*ldb] + 0.01698433971579627*b[i + 49*ldb] + -0.07052587748054273*b[i + 50*ldb] + -0.02035288870568681*b[i + 51*ldb] + -0.01987965941343628*b[i + 52*ldb] + -0.5279041678421734*b[i + 53*ldb] + -0.0459078476533179*b[i + 54*ldb] + -0.2089760190013807*b[i + 55*ldb] + 0.04766271928616608*b[i + 56*ldb] + 0.01215166511285262*b[i + 57*ldb] + 3.581597315354408*b[i + 58*ldb] + 2.965388897477289*b[i + 59*ldb] + 2.583413129926359*b[i + 120*ldb] + 0.1068368224642844*b[i + 121*ldb] + -0.6255688165573523*b[i + 122*ldb] + -1.546200852363405*b[i + 123*ldb] + 0.6619114463571192*b[i + 124*ldb] + 1.477330712695793*b[i + 125*ldb] + -1.355641220983662*b[i + 126*ldb] + -1.91592718061395*b[i + 127*ldb] + -0.3742866353879682*b[i + 128*ldb] + -0.1700384034174278*b[i + 129*ldb] + 0.8886523802884596*b[i + 130*ldb] + -1.639898802233694*b[i + 131*ldb] + -0.1590914669746716*b[i + 132*ldb] + -0.4497931998799397*b[i + 133*ldb] + 2.755439543527363*b[i + 134*ldb] + -0.9704208807564543*b[i + 163*ldb] + 0.9285580266438336*b[i + 178*ldb] + -1.70607502775383*b[i + 193*ldb] + -0.7583532171678773*b[i + 208*ldb] + 3.812557894803956*b[i + 223*ldb]);
        c[i + 59*ldc] = (-2.9217023167422*b[i + 45*ldb] + -0.04444015218558958*b[i + 46*ldb] + -0.03302545659098766*b[i + 47*ldb] + -0.564050650085659*b[i + 48*ldb] + 0.07052587748054273*b[i + 49*ldb] + -0.01698433971579627*b[i + 50*ldb] + 0.02035288870568681*b[i + 51*ldb] + 0.5279041678421734*b[i + 52*ldb] + 0.01987965941343628*b[i + 53*ldb] + 0.2089760190013807*b[i + 54*ldb] + 0.0459078476533179*b[i + 55*ldb] + -0.01215166511285262*b[i + 56*ldb] + -0.04766271928616608*b[i + 57*ldb] + -2.965388897477289*b[i + 58*ldb] + -3.581597315354408*b[i + 59*ldb] + -0.3382891868158406*b[i + 120*ldb] + -0.6700089687429422*b[i + 121*ldb] + 0.07381136587329767*b[i + 122*ldb] + -2.110251502449065*b[i + 123*ldb] + 1.547856590176338*b[i + 124*ldb] + 0.6449271066413235*b[i + 125*ldb] + -1.335288332277977*b[i + 126*ldb] + 0.1536175324542066*b[i + 127*ldb] + -1.896047521200515*b[i + 128*ldb] + 1.09762839928984*b[i + 129*ldb] + -0.1241305557641109*b[i + 130*ldb] + -0.1712431320875245*b[i + 131*ldb] + -1.687561521519859*b[i + 132*ldb] + -0.209949353949926*b[i + 133*ldb] + -4.031390515234344*b[i + 134*ldb] + -0.9704208807564543*b[i + 164*ldb] + 0.9285580266438336*b[i + 179*ldb] + -1.70607502775383*b[i + 194*ldb] + -0.7583532171678773*b[i + 209*ldb] + 3.812557894803956*b[i + 224*ldb]);
        c[i + 60*ldc] = (0.01666240169962252*b[i + 61*ldb] + -0.01666240169962252*b[i + 62*ldb] + -0.06412597883381979*b[i + 64*ldb] + 0.06412597883381979*b[i + 65*ldb] + -0.2284464562720814*b[i + 67*ldb] + 0.2284464562720814*b[i + 68*ldb] + -0.0809696560654336*b[i + 69*ldb] + 0.0809696560654336*b[i + 70*ldb] + -0.01902826490985636*b[i + 71*ldb] + 0.01902826490985636*b[i + 72*ldb] + -0.2968235823045307*b[i + 73*ldb] + 0.2968235823045307*b[i + 74*ldb] + -4.943623329974175*b[i + 135*ldb] + 0.5320310574554866*b[i + 136*ldb] + 0.5153686557558634*b[i + 137*ldb] + 2.118084753790551*b[i + 138*ldb] + -1.668497037618385*b[i + 139*ldb] + -1.604371058784565*b[i + 140*ldb] + 2.136333242112812*b[i + 141*ldb] + 1.189090704074046*b[i + 142*ldb] + 1.417537160346129*b[i + 143*ldb] + -0.7377711785520655*b[i + 144*ldb] + -0.6568015224866337*b[i + 145*ldb] + 1.526761453986784*b[i + 146*ldb] + 1.545789718896642*b[i + 147*ldb] + -3.174277239797759*b[i + 148*ldb] + -2.877453657493225*b[i + 149*ldb] + 0.551766850963316*b[i + 150*ldb] + -0.4937590750470335*b[i + 165*ldb] + 0.7231396289857275*b[i + 180*ldb] + -1.939864544376094*b[i + 195*ldb] + -5.067040595654547*b[i + 210*ldb]);
        c[i + 61*ldc] = (0.5320310574554866*b[i + 60*ldb] + -4.943623329974175*b[i + 61*ldb] + 0.5153686557558634*b[i + 62*ldb] + -1.668497037618385*b[i + 63*ldb] + 2.118084753790551*b[i + 64*ldb] + -1.604371058784565*b[i + 65*ldb] + 1.189090704074046*b[i + 66*ldb] + 2.136333242112812*b[i + 67*ldb] + 1.417537160346129*b[i + 68*ldb] + -2.877453657493225*b[i + 69*ldb] + 1.526761453986784*b[i + 70*ldb] + -0.6568015224866337*b[i + 71*ldb] + -3.174277239797759*b[i + 72*ldb] + 1.545789718896642*b[i + 73*ldb] + -0.7377711785520655*b[i + 74*ldb] + 0.01666240169962252*b[i + 135*ldb] + -0.01666240169962252*b[i + 137*ldb] + -0.06412597883381979*b[i + 138*ldb] + 0.06412597883381979*b[i + 140*ldb] + -0.2284464562720814*b[i + 141*ldb] + 0.2284464562720814*b[i + 143*ldb] + 0.2968235823045307*b[i + 144*ldb] + -0.01902826490985636*b[i + 145*ldb] + 0.0809696560654336*b[i + 146*ldb] + -0.2968235823045307*b[i + 147*ldb] + 0.01902826490985636*b[i + 148*ldb] + -0.0809696560654336*b[i + 149*ldb] + 0.551766850963316*b[i + 151*ldb] + -0.4937590750470335*b[i + 166*ldb] + 0.7231396289857275*b[i + 181*ldb] + -1.939864544376094*b[i + 196*ldb] + -5.067040595654547*b[i + 211*ldb]);
        c[i + 62*ldc] = (-0.5320310574554866*b[i + 60*ldb] + -0.5153686557558634*b[i + 61*ldb] + 4.943623329974175*b[i + 62*ldb] + 1.668497037618385*b[i + 63*ldb] + 1.604371058784565*b[i + 64*ldb] + -2.118084753790551*b[i + 65*ldb] + -1.189090704074046*b[i + 66*ldb] + -1.417537160346129*b[i + 67*ldb] + -2.136333242112812*b[i + 68*ldb] + -1.526761453986784*b[i + 69*ldb] + 2.877453657493225*b[i + 70*ldb] + 3.174277239797759*b[i + 71*ldb] + 0.6568015224866337*b[i + 72*ldb] + 0.7377711785520655*b[i + 73*ldb] + -1.545789718896642*b[i + 74*ldb] + -0.5153686557558634*b[i + 135*ldb] + -0.5320310574554866*b[i + 136*ldb] + 4.943623329974175*b[i + 137*ldb] + 1.604371058784565*b[i + 138*ldb] + 1.668497037618385*b[i + 139*ldb] + -2.118084753790551*b[i + 140*ldb] + -1.417537160346129*b[i + 141*ldb] + -1.189090704074046*b[i + 142*ldb] + -2.136333242112812*b[i + 143*ldb] + -1.545789718896642*b[i + 144*ldb] + 3.174277239797759*b[i + 145*ldb] + 2.877453657493225*b[i + 146*ldb] + 0.7377711785520655*b[i + 147*ldb] + 0.6568015224866337*b[i + 148*ldb] + -1.526761453986784*b[i + 149*ldb] + 0.551766850963316*b[i + 152*ldb] + -0.4937590750470335*b[i + 167*ldb] + 0.7231396289857275*b[i + 182*ldb] + -1.939864544376094*b[i + 197*ldb] + -5.067040595654547*b[i + 212*ldb]);
        c[i + 63*ldc] = (-0.0832386718891518*b[i + 61*ldb] + 0.0832386718891518*b[i + 62*ldb] + 0.1767047850928541*b[i + 64*ldb] + -0.1767047850928541*b[i + 65*ldb] + -2.508033750268638*b[i + 67*ldb] + 2.508033750268638*b[i + 68*ldb] + -0.2525315576529422*b[i + 69*ldb] + 0.2525315576529422*b[i + 70*ldb] + -0.03160100937678251*b[i + 71*ldb] + 0.03160100937678251*b[i + 72*ldb] + -2.356239812122482*b[i + 73*ldb] + 2.356239812122482*b[i + 74*ldb] + 0.04609417395922302*b[i + 135*ldb] + -0.1031803103571685*b[i + 136*ldb] + -0.01994163846801661*b[i + 137*ldb] + -0.3632813123758165*b[i + 138*ldb] + -1.492300533375874*b[i + 139*ldb] + -1.669005318468729*b[i + 140*ldb] + 1.730263001372271*b[i + 141*ldb] + -0.119528214542479*b[i + 142*ldb] + 2.388505535726159*b[i + 143*ldb] + -0.1709917888150785*b[i + 144*ldb] + 0.08153976883786418*b[i + 145*ldb] + 0.7288527548607495*b[i + 146*ldb] + 0.7604537642375322*b[i + 147*ldb] + 0.009187597244981638*b[i + 148*ldb] + 2.365427409367463*b[i + 149*ldb] + 0.551766850963316*b[i + 153*ldb] + -0.4937590750470335*b[i + 168*ldb] + 0.7231396289857275*b[i + 183*ldb] + -1.939864544376094*b[i + 198*ldb] + -5.067040595654547*b[i + 213*ldb]);
        c[i + 64*ldc] = (-0.1031803103571685*b[i + 60*ldb] + 0.04609417395922302*b[i + 61*ldb] + -0.01994163846801661*b[i + 62*ldb] + -1.492300533375874*b[i + 63*ldb] + -0.3632813123758165*b[i + 64*ldb] + -1.669005318468729*b[i + 65*ldb] + -0.119528214542479*b[i + 66*ldb] + 1.730263001372271*b[i + 67*ldb] + 2.388505535726159*b[i + 68*ldb] + 2.365427409367463*b[i + 69*ldb] + 0.7288527548607495*b[i + 70*ldb] + 0.08153976883786418*b[i + 71*ldb] + 0.009187597244981638*b[i + 72*ldb] + 0.7604537642375322*b[i + 73*ldb] + -0.1709917888150785*b[i + 74*ldb] + -0.0832386718891518*b[i + 135*ldb] + 0.0832386718891518*b[i + 137*ldb] + 0.1767047850928541*b[i + 138*ldb] + -0.1767047850928541*b[i + 140*ldb] + -2.508033750268638*b[i + 141*ldb] + 2.508033750268638*b[i + 143*ldb] + 2.356239812122482*b[i + 144*ldb] + -0.03160100937678251*b[i + 145*ldb] + 0.2525315576529422*b[i + 146*ldb] + -2.356239812122482*b[i + 147*ldb] + 0.03160100937678251*b[i + 148*ldb] + -0.2525315576529422*b[i + 149*ldb] + 0.551766850963316*b[i + 154*ldb] + -0.4937590750470335*b[i + 169*ldb] + 0.7231396289857275*b[i + 184*ldb] + -1.939864544376094*b[i + 199*ldb] + -5.067040595654547*b[i + 214*ldb]);
        c[i + 65*ldc] = (0.1031803103571685*b[i + 60*ldb] + 0.01994163846801661*b[i + 61*ldb] + -0.04609417395922302*b[i + 62*ldb] + 1.492300533375874*b[i + 63*ldb] + 1.669005318468729*b[i + 64*ldb] + 0.3632813123758165*b[i + 65*ldb] + 0.119528214542479*b[i + 66*ldb] + -2.388505535726159*b[i + 67*ldb] + -1.730263001372271*b[i + 68*ldb] + -0.7288527548607495*b[i + 69*ldb] + -2.365427409367463*b[i + 70*ldb] + -0.009187597244981638*b[i + 71*ldb] + -0.08153976883786418*b[i + 72*ldb] + 0.1709917888150785*b[i + 73*ldb] + -0.7604537642375322*b[i + 74*ldb] + 0.01994163846801661*b[i + 135*ldb] + 0.1031803103571685*b[i + 136*ldb] + -0.04609417395922302*b[i + 137*ldb] + 1.669005318468729*b[i + 138*ldb] + 1.492300533375874*b[i + 139*ldb] + 0.3632813123758165*b[i + 140*ldb] + -2.388505535726159*b[i + 141*ldb] + 0.119528214542479*b[i + 142*ldb] + -1.730263001372271*b[i + 143*ldb] + -0.7604537642375322*b[i + 144*ldb] + -0.009187597244981638*b[i + 145*ldb] + -2.365427409367463*b[i + 146*ldb] + 0.1709917888150785*b[i + 147*ldb] + -0.08153976883786418*b[i + 148*ldb] + -0.7288527548607495*b[i + 149*ldb] + 0.551766850963316*b[i + 155*ldb] + -0.4937590750470335*b[i + 170*ldb] + 0.7231396289857275*b[i + 185*ldb] + -1.939864544376094*b[i + 200*ldb] + -5.067040595654547*b[i + 215*ldb]);
        c[i + 66*ldc] = (-0.9213245156088653*b[i + 61*ldb] + 0.9213245156088653*b[i + 62*ldb] + 1.478053430463056*b[i + 64*ldb] + -1.478053430463056*b[i + 65*ldb] + 0.657627957956578*b[i + 67*ldb] + -0.657627957956578*b[i + 68*ldb] + -1.844372618022506*b[i + 69*ldb] + 1.844372618022506*b[i + 70*ldb] + -1.70239108991215*b[i + 71*ldb] + 1.70239108991215*b[i + 72*ldb] + -0.2828454530477449*b[i + 73*ldb] + 0.2828454530477449*b[i + 74*ldb] + 0.04922131659554296*b[i + 135*ldb] + -1.063952765527867*b[i + 136*ldb] + -0.1426282499190014*b[i + 137*ldb] + -0.2449733459341608*b[i + 138*ldb] + 1.892059090254097*b[i + 139*ldb] + 0.4140056597910398*b[i + 140*ldb] + 3.824491607376837*b[i + 141*ldb] + 0.01268686934620999*b[i + 142*ldb] + -0.6449410886103684*b[i + 143*ldb] + -1.893604927353485*b[i + 144*ldb] + -0.04923230933097847*b[i + 145*ldb] + 0.1863127236068944*b[i + 146*ldb] + 1.888703813519044*b[i + 147*ldb] + -0.02804075661045902*b[i + 148*ldb] + 0.2548046964372861*b[i + 149*ldb] + 0.551766850963316*b[i + 156*ldb] + -0.4937590750470335*b[i + 171*ldb] + 0.7231396289857275*b[i + 186*ldb] + -1.939864544376094*b[i + 201*ldb] + -5.067040595654547*b[i + 216*ldb]);
        c[i + 67*ldc] = (-1.063952765527867*b[i + 60*ldb] + 0.04922131659554296*b[i + 61*ldb] + -0.1426282499190014*b[i + 62*ldb] + 1.892059090254097*b[i + 63*ldb] + -0.2449733459341608*b[i + 64*ldb] + 0.4140056597910398*b[i + 65*ldb] + 0.01268686934620999*b[i + 66*ldb] + 3.824491607376837*b[i + 67*ldb] + -0.6449410886103684*b[i + 68*ldb] + 0.2548046964372861*b[i + 69*ldb] + 0.1863127236068944*b[i + 70*ldb] + -0.04923230933097847*b[i + 71*ldb] + -0.02804075661045902*b[i + 72*ldb] + 1.888703813519044*b[i + 73*ldb] + -1.893604927353485*b[i + 74*ldb] + -0.9213245156088653*b[i + 135*ldb] + 0.9213245156088653*b[i + 137*ldb] + 1.478053430463056*b[i + 138*ldb] + -1.478053430463056*b[i + 140*ldb] + 0.657627957956578*b[i + 141*ldb] + -0.657627957956578*b[i + 143*ldb] + 0.2828454530477449*b[i + 144*ldb] + -1.70239108991215*b[i + 145*ldb] + 1.844372618022506*b[i + 146*ldb] + -0.2828454530477449*b[i + 147*ldb] + 1.70239108991215*b[i + 148*ldb] + -1.844372618022506*b[i + 149*ldb] + 0.551766850963316*b[i + 157*ldb] + -0.4937590750470335*b[i + 172*ldb] + 0.7231396289857275*b[i + 187*ldb] + -1.939864544376094*b[i + 202*ldb] + -5.067040595654547*b[i + 217*ldb]);
        c[i + 68*ldc] = (1.063952765527867*b[i + 60*ldb] + 0.1426282499190014*b[i + 61*ldb] + -0.04922131659554296*b[i + 62*ldb] + -1.892059090254097*b[i + 63*ldb] + -0.4140056597910398*b[i + 64*ldb] + 0.2449733459341608*b[i + 65*ldb] + -0.01268686934620999*b[i + 66*ldb] + 0.6449410886103684*b[i + 67*ldb] + -3.824491607376837*b[i + 68*ldb] + -0.1863127236068944*b[i + 69*ldb] + -0.2548046964372861*b[i + 70*ldb] + 0.02804075661045902*b[i + 71*ldb] + 0.04923230933097847*b[i + 72*ldb] + 1.893604927353485*b[i + 73*ldb] + -1.888703813519044*b[i + 74*ldb] + 0.1426282499190014*b[i + 135*ldb] + 1.063952765527867*b[i + 136*ldb] + -0.04922131659554296*b[i + 137*ldb] + -0.4140056597910398*b[i + 138*ldb] + -1.892059090254097*b[i + 139*ldb] + 0.2449733459341608*b[i + 140*ldb] + 0.6449410886103684*b[i + 141*ldb] + -0.01268686934620999*b[i + 142*ldb] + -3.824491607376837*b[i + 143*ldb] + -1.888703813519044*b[i + 144*ldb] + 0.02804075661045902*b[i + 145*ldb] + -0.2548046964372861*b[i + 146*ldb] + 1.893604927353485*b[i + 147*ldb] + 0.04923230933097847*b[i + 148*ldb] + -0.1863127236068944*b[i + 149*ldb] + 0.551766850963316*b[i + 158*ldb] + -0.4937590750470335*b[i + 173*ldb] + 0.7231396289857275*b[i + 188*ldb] + -1.939864544376094*b[i + 203*ldb] + -5.067040595654547*b[i + 218*ldb]);
        c[i + 69*ldc] = (-0.6700089687429422*b[i + 60*ldb] + -0.3382891868158406*b[i + 61*ldb] + 0.07381136587329767*b[i + 62*ldb] + 1.547856590176338*b[i + 63*ldb] + -2.110251502449065*b[i + 64*ldb] + 0.6449271066413235*b[i + 65*ldb] + 0.1536175324542066*b[i + 66*ldb] + -1.335288332277977*b[i + 67*ldb] + -1.896047521200515*b[i + 68*ldb] + -4.031390515234344*b[i + 69*ldb] + -0.1712431320875245*b[i + 70*ldb] + -0.1241305557641109*b[i + 71*ldb] + -0.209949353949926*b[i + 72*ldb] + -1.687561521519859*b[i + 73*ldb] + 1.09762839928984*b[i + 74*ldb] + -0.04444015218558958*b[i + 135*ldb] + -2.9217023167422*b[i + 136*ldb] + -0.03302545659098766*b[i + 137*ldb] + 0.07052587748054273*b[i + 138*ldb] + -0.564050650085659*b[i + 139*ldb] + -0.01698433971579627*b[i + 140*ldb] + 0.5279041678421734*b[i + 141*ldb] + 0.02035288870568681*b[i + 142*ldb] + 0.01987965941343628*b[i + 143*ldb] + -3.581597315354408*b[i + 144*ldb] + -0.01215166511285262*b[i + 145*ldb] + 0.0459078476533179*b[i + 146*ldb] + -2.965388897477289*b[i + 147*ldb] + -0.04766271928616608*b[i + 148*ldb] + 0.2089760190013807*b[i + 149*ldb] + 0.551766850963316*b[i + 159*ldb] + -0.4937590750470335*b[i + 174*ldb] + 0.7231396289857275*b[i + 189*ldb] + -1.939864544376094*b[i + 204*ldb] + -5.067040595654547*b[i + 219*ldb]);
        c[i + 70*ldc] = (0.6700089687429422*b[i + 60*ldb] + -0.07381136587329767*b[i + 61*ldb] + 0.3382891868158406*b[i + 62*ldb] + -1.547856590176338*b[i + 63*ldb] + -0.6449271066413235*b[i + 64*ldb] + 2.110251502449065*b[i + 65*ldb] + -0.1536175324542066*b[i + 66*ldb] + 1.896047521200515*b[i + 67*ldb] + 1.335288332277977*b[i + 68*ldb] + 0.1712431320875245*b[i + 69*ldb] + 4.031390515234344*b[i + 70*ldb] + 0.209949353949926*b[i + 71*ldb] + 0.1241305557641109*b[i + 72*ldb] + -1.09762839928984*b[i + 73*ldb] + 1.687561521519859*b[i + 74*ldb] + 0.6255688165573523*b[i + 135*ldb] + -0.1068368224642844*b[i + 136*ldb] + -2.583413129926359*b[i + 137*ldb] + -1.477330712695793*b[i + 138*ldb] + -0.6619114463571192*b[i + 139*ldb] + 1.546200852363405*b[i + 140*ldb] + 0.3742866353879682*b[i + 141*ldb] + 1.91592718061395*b[i + 142*ldb] + 1.355641220983662*b[i + 143*ldb] + 0.1590914669746716*b[i + 144*ldb] + 0.4497931998799397*b[i + 145*ldb] + -2.755439543527363*b[i + 146*ldb] + 0.1700384034174278*b[i + 147*ldb] + -0.8886523802884596*b[i + 148*ldb] + 1.639898802233694*b[i + 149*ldb] + 0.551766850963316*b[i + 160*ldb] + -0.4937590750470335*b[i + 175*ldb] + 0.7231396289857275*b[i + 190*ldb] + -1.939864544376094*b[i + 205*ldb] + -5.067040595654547*b[i + 220*ldb]);
        c[i + 71*ldc] = (-0.1068368224642844*b[i + 60*ldb] + 0.6255688165573523*b[i + 61*ldb] + -2.583413129926359*b[i + 62*ldb] + -0.6619114463571192*b[i + 63*ldb] + -1.477330712695793*b[i + 64*ldb] + 1.546200852363405*b[i + 65*ldb] + 1.91592718061395*b[i + 66*ldb] + 0.3742866353879682*b[i + 67*ldb] + 1.355641220983662*b[i + 68*ldb] + 1.639898802233694*b[i + 69*ldb] + -2.755439543527363*b[i + 70*ldb] + 0.4497931998799397*b[i + 71*ldb] + -0.8886523802884596*b[i + 72*ldb] + 0.1700384034174278*b[i + 73*ldb] + 0.1590914669746716*b[i + 74*ldb] + -0.07381136587329767*b[i + 135*ldb] + 0.6700089687429422*b[i + 136*ldb] + 0.3382891868158406*b[i + 137*ldb] + -0.6449271066413235*b[i + 138*ldb] + -1.547856590176338*b[i + 139*ldb] + 2.110251502449065*b[i + 140*ldb] + 1.896047521200515*b[i + 141*ldb] + -0.1536175324542066*b[i + 142*ldb] + 1.335288332277977*b[i + 143*ldb] + 1.687561521519859*b[i + 144*ldb] + 0.209949353949926*b[i + 145*ldb] + 4.031390515234344*b[i + 146*ldb] + -1.09762839928984*b[i + 147*ldb] + 0.1241305557641109*b[i + 148*ldb] + 0.1712431320875245*b[i + 149*ldb] + 0.551766850963316*b[i + 161*ldb] + -0.4937590750470335*b[i + 176*ldb] + 0.7231396289857275*b[i + 191*ldb] + -1.939864544376094*b[i + 206*ldb] + -5.067040595654547*b[i + 221*ldb]);
        c[i + 72*ldc] = (0.1068368224642844*b[i + 60*ldb] + 2.583413129926359*b[i + 61*ldb] + -0.6255688165573523*b[i + 62*ldb] + 0.6619114463571192*b[i + 63*ldb] + -1.546200852363405*b[i + 64*ldb] + 1.477330712695793*b[i + 65*ldb] + -1.91592718061395*b[i + 66*ldb] + -1.355641220983662*b[i + 67*ldb] + -0.3742866353879682*b[i + 68*ldb] + 2.755439543527363*b[i + 69*ldb] + -1.639898802233694*b[i + 70*ldb] + 0.8886523802884596*b[i + 71*ldb] + -0.4497931998799397*b[i + 72*ldb] + -0.1590914669746716*b[i + 73*ldb] + -0.1700384034174278*b[i + 74*ldb] + 0.03302545659098766*b[i + 135*ldb] + 2.9217023167422*b[i + 136*ldb] + 0.04444015218558958*b[i + 137*ldb] + 0.01698433971579627*b[i + 138*ldb] + 0.564050650085659*b[i + 139*ldb] + -0.07052587748054273*b[i + 140*ldb] + -0.01987965941343628*b[i + 141*ldb] + -0.02035288870568681*b[i + 142*ldb] + -0.5279041678421734*b[i + 143*ldb] + 2.965388897477289*b[i + 144*ldb] + 0.04766271928616608*b[i + 145*ldb] + -0.2089760190013807*b[i + 146*ldb] + 3.581597315354408*b[i + 147*ldb] + 0.01215166511285262*b[i + 148*ldb] + -0.0459078476533179*b[i + 149*ldb] + 0.551766850963316*b[i + 162*ldb] + -0.4937590750470335*b[i + 177*ldb] + 0.7231396289857275*b[i + 192*ldb] + -1.939864544376094*b[i + 207*ldb] + -5.067040595654547*b[i + 222*ldb]);
        c[i + 73*ldc] = (2.9217023167422*b[i + 60*ldb] + 0.03302545659098766*b[i + 61*ldb] + 0.04444015218558958*b[i + 62*ldb] + 0.564050650085659*b[i + 63*ldb] + 0.01698433971579627*b[i + 64*ldb] + -0.07052587748054273*b[i + 65*ldb] + -0.02035288870568681*b[i + 66*ldb] + -0.01987965941343628*b[i + 67*ldb] + -0.5279041678421734*b[i + 68*ldb] + -0.0459078476533179*b[i + 69*ldb] + -0.2089760190013807*b[i + 70*ldb] + 0.04766271928616608*b[i + 71*ldb] + 0.01215166511285262*b[i + 72*ldb] + 3.581597315354408*b[i + 73*ldb] + 2.965388897477289*b[i + 74*ldb] + 2.583413129926359*b[i + 135*ldb] + 0.1068368224642844*b[i + 136*ldb] + -0.6255688165573523*b[i + 137*ldb] + -1.546200852363405*b[i + 138*ldb] + 0.6619114463571192*b[i + 139*ldb] + 1.477330712695793*b[i + 140*ldb] + -1.355641220983662*b[i + 141*ldb] + -1.91592718061395*b[i + 142*ldb] + -0.3742866353879682*b[i + 143*ldb] + -0.1700384034174278*b[i + 144*ldb] + 0.8886523802884596*b[i + 145*ldb] + -1.639898802233694*b[i + 146*ldb] + -0.1590914669746716*b[i + 147*ldb] + -0.4497931998799397*b[i + 148*ldb] + 2.755439543527363*b[i + 149*ldb] + 0.551766850963316*b[i + 163*ldb] + -0.4937590750470335*b[i + 178*ldb] + 0.7231396289857275*b[i + 193*ldb] + -1.939864544376094*b[i + 208*ldb] + -5.067040595654547*b[i + 223*ldb]);
        c[i + 74*ldc] = (-2.9217023167422*b[i + 60*ldb] + -0.04444015218558958*b[i + 61*ldb] + -0.03302545659098766*b[i + 62*ldb] + -0.564050650085659*b[i + 63*ldb] + 0.07052587748054273*b[i + 64*ldb] + -0.01698433971579627*b[i + 65*ldb] + 0.02035288870568681*b[i + 66*ldb] + 0.5279041678421734*b[i + 67*ldb] + 0.01987965941343628*b[i + 68*ldb] + 0.2089760190013807*b[i + 69*ldb] + 0.0459078476533179*b[i + 70*ldb] + -0.01215166511285262*b[i + 71*ldb] + -0.04766271928616608*b[i + 72*ldb] + -2.965388897477289*b[i + 73*ldb] + -3.581597315354408*b[i + 74*ldb] + -0.3382891868158406*b[i + 135*ldb] + -0.6700089687429422*b[i + 136*ldb] + 0.07381136587329767*b[i + 137*ldb] + -2.110251502449065*b[i + 138*ldb] + 1.547856590176338*b[i + 139*ldb] + 0.6449271066413235*b[i + 140*ldb] + -1.335288332277977*b[i + 141*ldb] + 0.1536175324542066*b[i + 142*ldb] + -1.896047521200515*b[i + 143*ldb] + 1.09762839928984*b[i + 144*ldb] + -0.1241305557641109*b[i + 145*ldb] + -0.1712431320875245*b[i + 146*ldb] + -1.687561521519859*b[i + 147*ldb] + -0.209949353949926*b[i + 148*ldb] + -4.031390515234344*b[i + 149*ldb] + 0.551766850963316*b[i + 164*ldb] + -0.4937590750470335*b[i + 179*ldb] + 0.7231396289857275*b[i + 194*ldb] + -1.939864544376094*b[i + 209*ldb] + -5.067040595654547*b[i + 224*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p5_hex_m0(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] = (1.565673200151071*b[i + 0*ldb] + -0.9404628431763479*b[i + 36*ldb] + 0.6169300554304881*b[i + 72*ldb] + -0.3792277021146136*b[i + 108*ldb] + 0.1918000140386678*b[i + 144*ldb] + -0.05471272432926569*b[i + 180*ldb]);
        c[i + 1*ldc] = (1.565673200151071*b[i + 1*ldb] + -0.9404628431763479*b[i + 37*ldb] + 0.6169300554304881*b[i + 73*ldb] + -0.3792277021146136*b[i + 109*ldb] + 0.1918000140386678*b[i + 145*ldb] + -0.05471272432926569*b[i + 181*ldb]);
        c[i + 2*ldc] = (1.565673200151071*b[i + 2*ldb] + -0.9404628431763479*b[i + 38*ldb] + 0.6169300554304881*b[i + 74*ldb] + -0.3792277021146136*b[i + 110*ldb] + 0.1918000140386678*b[i + 146*ldb] + -0.05471272432926569*b[i + 182*ldb]);
        c[i + 3*ldc] = (1.565673200151071*b[i + 3*ldb] + -0.9404628431763479*b[i + 39*ldb] + 0.6169300554304881*b[i + 75*ldb] + -0.3792277021146136*b[i + 111*ldb] + 0.1918000140386678*b[i + 147*ldb] + -0.05471272432926569*b[i + 183*ldb]);
        c[i + 4*ldc] = (1.565673200151071*b[i + 4*ldb] + -0.9404628431763479*b[i + 40*ldb] + 0.6169300554304881*b[i + 76*ldb] + -0.3792277021146136*b[i + 112*ldb] + 0.1918000140386678*b[i + 148*ldb] + -0.05471272432926569*b[i + 184*ldb]);
        c[i + 5*ldc] = (1.565673200151071*b[i + 5*ldb] + -0.9404628431763479*b[i + 41*ldb] + 0.6169300554304881*b[i + 77*ldb] + -0.3792277021146136*b[i + 113*ldb] + 0.1918000140386678*b[i + 149*ldb] + -0.05471272432926569*b[i + 185*ldb]);
        c[i + 6*ldc] = (1.565673200151071*b[i + 6*ldb] + -0.9404628431763479*b[i + 42*ldb] + 0.6169300554304881*b[i + 78*ldb] + -0.3792277021146136*b[i + 114*ldb] + 0.1918000140386678*b[i + 150*ldb] + -0.05471272432926569*b[i + 186*ldb]);
        c[i + 7*ldc] = (1.565673200151071*b[i + 7*ldb] + -0.9404628431763479*b[i + 43*ldb] + 0.6169300554304881*b[i + 79*ldb] + -0.3792277021146136*b[i + 115*ldb] + 0.1918000140386678*b[i + 151*ldb] + -0.05471272432926569*b[i + 187*ldb]);
        c[i + 8*ldc] = (1.565673200151071*b[i + 8*ldb] + -0.9404628431763479*b[i + 44*ldb] + 0.6169300554304881*b[i + 80*ldb] + -0.3792277021146136*b[i + 116*ldb] + 0.1918000140386678*b[i + 152*ldb] + -0.05471272432926569*b[i + 188*ldb]);
        c[i + 9*ldc] = (1.565673200151071*b[i + 9*ldb] + -0.9404628431763479*b[i + 45*ldb] + 0.6169300554304881*b[i + 81*ldb] + -0.3792277021146136*b[i + 117*ldb] + 0.1918000140386678*b[i + 153*ldb] + -0.05471272432926569*b[i + 189*ldb]);
        c[i + 10*ldc] = (1.565673200151071*b[i + 10*ldb] + -0.9404628431763479*b[i + 46*ldb] + 0.6169300554304881*b[i + 82*ldb] + -0.3792277021146136*b[i + 118*ldb] + 0.1918000140386678*b[i + 154*ldb] + -0.05471272432926569*b[i + 190*ldb]);
        c[i + 11*ldc] = (1.565673200151071*b[i + 11*ldb] + -0.9404628431763479*b[i + 47*ldb] + 0.6169300554304881*b[i + 83*ldb] + -0.3792277021146136*b[i + 119*ldb] + 0.1918000140386678*b[i + 155*ldb] + -0.05471272432926569*b[i + 191*ldb]);
        c[i + 12*ldc] = (1.565673200151071*b[i + 12*ldb] + -0.9404628431763479*b[i + 48*ldb] + 0.6169300554304881*b[i + 84*ldb] + -0.3792277021146136*b[i + 120*ldb] + 0.1918000140386678*b[i + 156*ldb] + -0.05471272432926569*b[i + 192*ldb]);
        c[i + 13*ldc] = (1.565673200151071*b[i + 13*ldb] + -0.9404628431763479*b[i + 49*ldb] + 0.6169300554304881*b[i + 85*ldb] + -0.3792277021146136*b[i + 121*ldb] + 0.1918000140386678*b[i + 157*ldb] + -0.05471272432926569*b[i + 193*ldb]);
        c[i + 14*ldc] = (1.565673200151071*b[i + 14*ldb] + -0.9404628431763479*b[i + 50*ldb] + 0.6169300554304881*b[i + 86*ldb] + -0.3792277021146136*b[i + 122*ldb] + 0.1918000140386678*b[i + 158*ldb] + -0.05471272432926569*b[i + 194*ldb]);
        c[i + 15*ldc] = (1.565673200151071*b[i + 15*ldb] + -0.9404628431763479*b[i + 51*ldb] + 0.6169300554304881*b[i + 87*ldb] + -0.3792277021146136*b[i + 123*ldb] + 0.1918000140386678*b[i + 159*ldb] + -0.05471272432926569*b[i + 195*ldb]);
        c[i + 16*ldc] = (1.565673200151071*b[i + 16*ldb] + -0.9404628431763479*b[i + 52*ldb] + 0.6169300554304881*b[i + 88*ldb] + -0.3792277021146136*b[i + 124*ldb] + 0.1918000140386678*b[i + 160*ldb] + -0.05471272432926569*b[i + 196*ldb]);
        c[i + 17*ldc] = (1.565673200151071*b[i + 17*ldb] + -0.9404628431763479*b[i + 53*ldb] + 0.6169300554304881*b[i + 89*ldb] + -0.3792277021146136*b[i + 125*ldb] + 0.1918000140386678*b[i + 161*ldb] + -0.05471272432926569*b[i + 197*ldb]);
        c[i + 18*ldc] = (1.565673200151071*b[i + 18*ldb] + -0.9404628431763479*b[i + 54*ldb] + 0.6169300554304881*b[i + 90*ldb] + -0.3792277021146136*b[i + 126*ldb] + 0.1918000140386678*b[i + 162*ldb] + -0.05471272432926569*b[i + 198*ldb]);
        c[i + 19*ldc] = (1.565673200151071*b[i + 19*ldb] + -0.9404628431763479*b[i + 55*ldb] + 0.6169300554304881*b[i + 91*ldb] + -0.3792277021146136*b[i + 127*ldb] + 0.1918000140386678*b[i + 163*ldb] + -0.05471272432926569*b[i + 199*ldb]);
        c[i + 20*ldc] = (1.565673200151071*b[i + 20*ldb] + -0.9404628431763479*b[i + 56*ldb] + 0.6169300554304881*b[i + 92*ldb] + -0.3792277021146136*b[i + 128*ldb] + 0.1918000140386678*b[i + 164*ldb] + -0.05471272432926569*b[i + 200*ldb]);
        c[i + 21*ldc] = (1.565673200151071*b[i + 21*ldb] + -0.9404628431763479*b[i + 57*ldb] + 0.6169300554304881*b[i + 93*ldb] + -0.3792277021146136*b[i + 129*ldb] + 0.1918000140386678*b[i + 165*ldb] + -0.05471272432926569*b[i + 201*ldb]);
        c[i + 22*ldc] = (1.565673200151071*b[i + 22*ldb] + -0.9404628431763479*b[i + 58*ldb] + 0.6169300554304881*b[i + 94*ldb] + -0.3792277021146136*b[i + 130*ldb] + 0.1918000140386678*b[i + 166*ldb] + -0.05471272432926569*b[i + 202*ldb]);
        c[i + 23*ldc] = (1.565673200151071*b[i + 23*ldb] + -0.9404628431763479*b[i + 59*ldb] + 0.6169300554304881*b[i + 95*ldb] + -0.3792277021146136*b[i + 131*ldb] + 0.1918000140386678*b[i + 167*ldb] + -0.05471272432926569*b[i + 203*ldb]);
        c[i + 24*ldc] = (1.565673200151071*b[i + 24*ldb] + -0.9404628431763479*b[i + 60*ldb] + 0.6169300554304881*b[i + 96*ldb] + -0.3792277021146136*b[i + 132*ldb] + 0.1918000140386678*b[i + 168*ldb] + -0.05471272432926569*b[i + 204*ldb]);
        c[i + 25*ldc] = (1.565673200151071*b[i + 25*ldb] + -0.9404628431763479*b[i + 61*ldb] + 0.6169300554304881*b[i + 97*ldb] + -0.3792277021146136*b[i + 133*ldb] + 0.1918000140386678*b[i + 169*ldb] + -0.05471272432926569*b[i + 205*ldb]);
        c[i + 26*ldc] = (1.565673200151071*b[i + 26*ldb] + -0.9404628431763479*b[i + 62*ldb] + 0.6169300554304881*b[i + 98*ldb] + -0.3792277021146136*b[i + 134*ldb] + 0.1918000140386678*b[i + 170*ldb] + -0.05471272432926569*b[i + 206*ldb]);
        c[i + 27*ldc] = (1.565673200151071*b[i + 27*ldb] + -0.9404628431763479*b[i + 63*ldb] + 0.6169300554304881*b[i + 99*ldb] + -0.3792277021146136*b[i + 135*ldb] + 0.1918000140386678*b[i + 171*ldb] + -0.05471272432926569*b[i + 207*ldb]);
        c[i + 28*ldc] = (1.565673200151071*b[i + 28*ldb] + -0.9404628431763479*b[i + 64*ldb] + 0.6169300554304881*b[i + 100*ldb] + -0.3792277021146136*b[i + 136*ldb] + 0.1918000140386678*b[i + 172*ldb] + -0.05471272432926569*b[i + 208*ldb]);
        c[i + 29*ldc] = (1.565673200151071*b[i + 29*ldb] + -0.9404628431763479*b[i + 65*ldb] + 0.6169300554304881*b[i + 101*ldb] + -0.3792277021146136*b[i + 137*ldb] + 0.1918000140386678*b[i + 173*ldb] + -0.05471272432926569*b[i + 209*ldb]);
        c[i + 30*ldc] = (1.565673200151071*b[i + 30*ldb] + -0.9404628431763479*b[i + 66*ldb] + 0.6169300554304881*b[i + 102*ldb] + -0.3792277021146136*b[i + 138*ldb] + 0.1918000140386678*b[i + 174*ldb] + -0.05471272432926569*b[i + 210*ldb]);
        c[i + 31*ldc] = (1.565673200151071*b[i + 31*ldb] + -0.9404628431763479*b[i + 67*ldb] + 0.6169300554304881*b[i + 103*ldb] + -0.3792277021146136*b[i + 139*ldb] + 0.1918000140386678*b[i + 175*ldb] + -0.05471272432926569*b[i + 211*ldb]);
        c[i + 32*ldc] = (1.565673200151071*b[i + 32*ldb] + -0.9404628431763479*b[i + 68*ldb] + 0.6169300554304881*b[i + 104*ldb] + -0.3792277021146136*b[i + 140*ldb] + 0.1918000140386678*b[i + 176*ldb] + -0.05471272432926569*b[i + 212*ldb]);
        c[i + 33*ldc] = (1.565673200151071*b[i + 33*ldb] + -0.9404628431763479*b[i + 69*ldb] + 0.6169300554304881*b[i + 105*ldb] + -0.3792277021146136*b[i + 141*ldb] + 0.1918000140386678*b[i + 177*ldb] + -0.05471272432926569*b[i + 213*ldb]);
        c[i + 34*ldc] = (1.565673200151071*b[i + 34*ldb] + -0.9404628431763479*b[i + 70*ldb] + 0.6169300554304881*b[i + 106*ldb] + -0.3792277021146136*b[i + 142*ldb] + 0.1918000140386678*b[i + 178*ldb] + -0.05471272432926569*b[i + 214*ldb]);
        c[i + 35*ldc] = (1.565673200151071*b[i + 35*ldb] + -0.9404628431763479*b[i + 71*ldb] + 0.6169300554304881*b[i + 107*ldb] + -0.3792277021146136*b[i + 143*ldb] + 0.1918000140386678*b[i + 179*ldb] + -0.05471272432926569*b[i + 215*ldb]);
        c[i + 36*ldc] = (1.565673200151071*b[i + 0*ldb] + -0.9404628431763479*b[i + 6*ldb] + 0.6169300554304881*b[i + 12*ldb] + -0.3792277021146136*b[i + 18*ldb] + 0.1918000140386678*b[i + 24*ldb] + -0.05471272432926569*b[i + 30*ldb]);
        c[i + 37*ldc] = (1.565673200151071*b[i + 1*ldb] + -0.9404628431763479*b[i + 7*ldb] + 0.6169300554304881*b[i + 13*ldb] + -0.3792277021146136*b[i + 19*ldb] + 0.1918000140386678*b[i + 25*ldb] + -0.05471272432926569*b[i + 31*ldb]);
        c[i + 38*ldc] = (1.565673200151071*b[i + 2*ldb] + -0.9404628431763479*b[i + 8*ldb] + 0.6169300554304881*b[i + 14*ldb] + -0.3792277021146136*b[i + 20*ldb] + 0.1918000140386678*b[i + 26*ldb] + -0.05471272432926569*b[i + 32*ldb]);
        c[i + 39*ldc] = (1.565673200151071*b[i + 3*ldb] + -0.9404628431763479*b[i + 9*ldb] + 0.6169300554304881*b[i + 15*ldb] + -0.3792277021146136*b[i + 21*ldb] + 0.1918000140386678*b[i + 27*ldb] + -0.05471272432926569*b[i + 33*ldb]);
        c[i + 40*ldc] = (1.565673200151071*b[i + 4*ldb] + -0.9404628431763479*b[i + 10*ldb] + 0.6169300554304881*b[i + 16*ldb] + -0.3792277021146136*b[i + 22*ldb] + 0.1918000140386678*b[i + 28*ldb] + -0.05471272432926569*b[i + 34*ldb]);
        c[i + 41*ldc] = (1.565673200151071*b[i + 5*ldb] + -0.9404628431763479*b[i + 11*ldb] + 0.6169300554304881*b[i + 17*ldb] + -0.3792277021146136*b[i + 23*ldb] + 0.1918000140386678*b[i + 29*ldb] + -0.05471272432926569*b[i + 35*ldb]);
        c[i + 42*ldc] = (1.565673200151071*b[i + 36*ldb] + -0.9404628431763479*b[i + 42*ldb] + 0.6169300554304881*b[i + 48*ldb] + -0.3792277021146136*b[i + 54*ldb] + 0.1918000140386678*b[i + 60*ldb] + -0.05471272432926569*b[i + 66*ldb]);
        c[i + 43*ldc] = (1.565673200151071*b[i + 37*ldb] + -0.9404628431763479*b[i + 43*ldb] + 0.6169300554304881*b[i + 49*ldb] + -0.3792277021146136*b[i + 55*ldb] + 0.1918000140386678*b[i + 61*ldb] + -0.05471272432926569*b[i + 67*ldb]);
        c[i + 44*ldc] = (1.565673200151071*b[i + 38*ldb] + -0.9404628431763479*b[i + 44*ldb] + 0.6169300554304881*b[i + 50*ldb] + -0.3792277021146136*b[i + 56*ldb] + 0.1918000140386678*b[i + 62*ldb] + -0.05471272432926569*b[i + 68*ldb]);
        c[i + 45*ldc] = (1.565673200151071*b[i + 39*ldb] + -0.9404628431763479*b[i + 45*ldb] + 0.6169300554304881*b[i + 51*ldb] + -0.3792277021146136*b[i + 57*ldb] + 0.1918000140386678*b[i + 63*ldb] + -0.05471272432926569*b[i + 69*ldb]);
        c[i + 46*ldc] = (1.565673200151071*b[i + 40*ldb] + -0.9404628431763479*b[i + 46*ldb] + 0.6169300554304881*b[i + 52*ldb] + -0.3792277021146136*b[i + 58*ldb] + 0.1918000140386678*b[i + 64*ldb] + -0.05471272432926569*b[i + 70*ldb]);
        c[i + 47*ldc] = (1.565673200151071*b[i + 41*ldb] + -0.9404628431763479*b[i + 47*ldb] + 0.6169300554304881*b[i + 53*ldb] + -0.3792277021146136*b[i + 59*ldb] + 0.1918000140386678*b[i + 65*ldb] + -0.05471272432926569*b[i + 71*ldb]);
        c[i + 48*ldc] = (1.565673200151071*b[i + 72*ldb] + -0.9404628431763479*b[i + 78*ldb] + 0.6169300554304881*b[i + 84*ldb] + -0.3792277021146136*b[i + 90*ldb] + 0.1918000140386678*b[i + 96*ldb] + -0.05471272432926569*b[i + 102*ldb]);
        c[i + 49*ldc] = (1.565673200151071*b[i + 73*ldb] + -0.9404628431763479*b[i + 79*ldb] + 0.6169300554304881*b[i + 85*ldb] + -0.3792277021146136*b[i + 91*ldb] + 0.1918000140386678*b[i + 97*ldb] + -0.05471272432926569*b[i + 103*ldb]);
        c[i + 50*ldc] = (1.565673200151071*b[i + 74*ldb] + -0.9404628431763479*b[i + 80*ldb] + 0.6169300554304881*b[i + 86*ldb] + -0.3792277021146136*b[i + 92*ldb] + 0.1918000140386678*b[i + 98*ldb] + -0.05471272432926569*b[i + 104*ldb]);
        c[i + 51*ldc] = (1.565673200151071*b[i + 75*ldb] + -0.9404628431763479*b[i + 81*ldb] + 0.6169300554304881*b[i + 87*ldb] + -0.3792277021146136*b[i + 93*ldb] + 0.1918000140386678*b[i + 99*ldb] + -0.05471272432926569*b[i + 105*ldb]);
        c[i + 52*ldc] = (1.565673200151071*b[i + 76*ldb] + -0.9404628431763479*b[i + 82*ldb] + 0.6169300554304881*b[i + 88*ldb] + -0.3792277021146136*b[i + 94*ldb] + 0.1918000140386678*b[i + 100*ldb] + -0.05471272432926569*b[i + 106*ldb]);
        c[i + 53*ldc] = (1.565673200151071*b[i + 77*ldb] + -0.9404628431763479*b[i + 83*ldb] + 0.6169300554304881*b[i + 89*ldb] + -0.3792277021146136*b[i + 95*ldb] + 0.1918000140386678*b[i + 101*ldb] + -0.05471272432926569*b[i + 107*ldb]);
        c[i + 54*ldc] = (1.565673200151071*b[i + 108*ldb] + -0.9404628431763479*b[i + 114*ldb] + 0.6169300554304881*b[i + 120*ldb] + -0.3792277021146136*b[i + 126*ldb] + 0.1918000140386678*b[i + 132*ldb] + -0.05471272432926569*b[i + 138*ldb]);
        c[i + 55*ldc] = (1.565673200151071*b[i + 109*ldb] + -0.9404628431763479*b[i + 115*ldb] + 0.6169300554304881*b[i + 121*ldb] + -0.3792277021146136*b[i + 127*ldb] + 0.1918000140386678*b[i + 133*ldb] + -0.05471272432926569*b[i + 139*ldb]);
        c[i + 56*ldc] = (1.565673200151071*b[i + 110*ldb] + -0.9404628431763479*b[i + 116*ldb] + 0.6169300554304881*b[i + 122*ldb] + -0.3792277021146136*b[i + 128*ldb] + 0.1918000140386678*b[i + 134*ldb] + -0.05471272432926569*b[i + 140*ldb]);
        c[i + 57*ldc] = (1.565673200151071*b[i + 111*ldb] + -0.9404628431763479*b[i + 117*ldb] + 0.6169300554304881*b[i + 123*ldb] + -0.3792277021146136*b[i + 129*ldb] + 0.1918000140386678*b[i + 135*ldb] + -0.05471272432926569*b[i + 141*ldb]);
        c[i + 58*ldc] = (1.565673200151071*b[i + 112*ldb] + -0.9404628431763479*b[i + 118*ldb] + 0.6169300554304881*b[i + 124*ldb] + -0.3792277021146136*b[i + 130*ldb] + 0.1918000140386678*b[i + 136*ldb] + -0.05471272432926569*b[i + 142*ldb]);
        c[i + 59*ldc] = (1.565673200151071*b[i + 113*ldb] + -0.9404628431763479*b[i + 119*ldb] + 0.6169300554304881*b[i + 125*ldb] + -0.3792277021146136*b[i + 131*ldb] + 0.1918000140386678*b[i + 137*ldb] + -0.05471272432926569*b[i + 143*ldb]);
        c[i + 60*ldc] = (1.565673200151071*b[i + 144*ldb] + -0.9404628431763479*b[i + 150*ldb] + 0.6169300554304881*b[i + 156*ldb] + -0.3792277021146136*b[i + 162*ldb] + 0.1918000140386678*b[i + 168*ldb] + -0.05471272432926569*b[i + 174*ldb]);
        c[i + 61*ldc] = (1.565673200151071*b[i + 145*ldb] + -0.9404628431763479*b[i + 151*ldb] + 0.6169300554304881*b[i + 157*ldb] + -0.3792277021146136*b[i + 163*ldb] + 0.1918000140386678*b[i + 169*ldb] + -0.05471272432926569*b[i + 175*ldb]);
        c[i + 62*ldc] = (1.565673200151071*b[i + 146*ldb] + -0.9404628431763479*b[i + 152*ldb] + 0.6169300554304881*b[i + 158*ldb] + -0.3792277021146136*b[i + 164*ldb] + 0.1918000140386678*b[i + 170*ldb] + -0.05471272432926569*b[i + 176*ldb]);
        c[i + 63*ldc] = (1.565673200151071*b[i + 147*ldb] + -0.9404628431763479*b[i + 153*ldb] + 0.6169300554304881*b[i + 159*ldb] + -0.3792277021146136*b[i + 165*ldb] + 0.1918000140386678*b[i + 171*ldb] + -0.05471272432926569*b[i + 177*ldb]);
        c[i + 64*ldc] = (1.565673200151071*b[i + 148*ldb] + -0.9404628431763479*b[i + 154*ldb] + 0.6169300554304881*b[i + 160*ldb] + -0.3792277021146136*b[i + 166*ldb] + 0.1918000140386678*b[i + 172*ldb] + -0.05471272432926569*b[i + 178*ldb]);
        c[i + 65*ldc] = (1.565673200151071*b[i + 149*ldb] + -0.9404628431763479*b[i + 155*ldb] + 0.6169300554304881*b[i + 161*ldb] + -0.3792277021146136*b[i + 167*ldb] + 0.1918000140386678*b[i + 173*ldb] + -0.05471272432926569*b[i + 179*ldb]);
        c[i + 66*ldc] = (1.565673200151071*b[i + 180*ldb] + -0.9404628431763479*b[i + 186*ldb] + 0.6169300554304881*b[i + 192*ldb] + -0.3792277021146136*b[i + 198*ldb] + 0.1918000140386678*b[i + 204*ldb] + -0.05471272432926569*b[i + 210*ldb]);
        c[i + 67*ldc] = (1.565673200151071*b[i + 181*ldb] + -0.9404628431763479*b[i + 187*ldb] + 0.6169300554304881*b[i + 193*ldb] + -0.3792277021146136*b[i + 199*ldb] + 0.1918000140386678*b[i + 205*ldb] + -0.05471272432926569*b[i + 211*ldb]);
        c[i + 68*ldc] = (1.565673200151071*b[i + 182*ldb] + -0.9404628431763479*b[i + 188*ldb] + 0.6169300554304881*b[i + 194*ldb] + -0.3792277021146136*b[i + 200*ldb] + 0.1918000140386678*b[i + 206*ldb] + -0.05471272432926569*b[i + 212*ldb]);
        c[i + 69*ldc] = (1.565673200151071*b[i + 183*ldb] + -0.9404628431763479*b[i + 189*ldb] + 0.6169300554304881*b[i + 195*ldb] + -0.3792277021146136*b[i + 201*ldb] + 0.1918000140386678*b[i + 207*ldb] + -0.05471272432926569*b[i + 213*ldb]);
        c[i + 70*ldc] = (1.565673200151071*b[i + 184*ldb] + -0.9404628431763479*b[i + 190*ldb] + 0.6169300554304881*b[i + 196*ldb] + -0.3792277021146136*b[i + 202*ldb] + 0.1918000140386678*b[i + 208*ldb] + -0.05471272432926569*b[i + 214*ldb]);
        c[i + 71*ldc] = (1.565673200151071*b[i + 185*ldb] + -0.9404628431763479*b[i + 191*ldb] + 0.6169300554304881*b[i + 197*ldb] + -0.3792277021146136*b[i + 203*ldb] + 0.1918000140386678*b[i + 209*ldb] + -0.05471272432926569*b[i + 215*ldb]);
        c[i + 72*ldc] = (-0.05471272432926569*b[i + 0*ldb] + 0.1918000140386678*b[i + 1*ldb] + -0.3792277021146136*b[i + 2*ldb] + 0.6169300554304881*b[i + 3*ldb] + -0.9404628431763479*b[i + 4*ldb] + 1.565673200151071*b[i + 5*ldb]);
        c[i + 73*ldc] = (-0.05471272432926569*b[i + 6*ldb] + 0.1918000140386678*b[i + 7*ldb] + -0.3792277021146136*b[i + 8*ldb] + 0.6169300554304881*b[i + 9*ldb] + -0.9404628431763479*b[i + 10*ldb] + 1.565673200151071*b[i + 11*ldb]);
        c[i + 74*ldc] = (-0.05471272432926569*b[i + 12*ldb] + 0.1918000140386678*b[i + 13*ldb] + -0.3792277021146136*b[i + 14*ldb] + 0.6169300554304881*b[i + 15*ldb] + -0.9404628431763479*b[i + 16*ldb] + 1.565673200151071*b[i + 17*ldb]);
        c[i + 75*ldc] = (-0.05471272432926569*b[i + 18*ldb] + 0.1918000140386678*b[i + 19*ldb] + -0.3792277021146136*b[i + 20*ldb] + 0.6169300554304881*b[i + 21*ldb] + -0.9404628431763479*b[i + 22*ldb] + 1.565673200151071*b[i + 23*ldb]);
        c[i + 76*ldc] = (-0.05471272432926569*b[i + 24*ldb] + 0.1918000140386678*b[i + 25*ldb] + -0.3792277021146136*b[i + 26*ldb] + 0.6169300554304881*b[i + 27*ldb] + -0.9404628431763479*b[i + 28*ldb] + 1.565673200151071*b[i + 29*ldb]);
        c[i + 77*ldc] = (-0.05471272432926569*b[i + 30*ldb] + 0.1918000140386678*b[i + 31*ldb] + -0.3792277021146136*b[i + 32*ldb] + 0.6169300554304881*b[i + 33*ldb] + -0.9404628431763479*b[i + 34*ldb] + 1.565673200151071*b[i + 35*ldb]);
        c[i + 78*ldc] = (-0.05471272432926569*b[i + 36*ldb] + 0.1918000140386678*b[i + 37*ldb] + -0.3792277021146136*b[i + 38*ldb] + 0.6169300554304881*b[i + 39*ldb] + -0.9404628431763479*b[i + 40*ldb] + 1.565673200151071*b[i + 41*ldb]);
        c[i + 79*ldc] = (-0.05471272432926569*b[i + 42*ldb] + 0.1918000140386678*b[i + 43*ldb] + -0.3792277021146136*b[i + 44*ldb] + 0.6169300554304881*b[i + 45*ldb] + -0.9404628431763479*b[i + 46*ldb] + 1.565673200151071*b[i + 47*ldb]);
        c[i + 80*ldc] = (-0.05471272432926569*b[i + 48*ldb] + 0.1918000140386678*b[i + 49*ldb] + -0.3792277021146136*b[i + 50*ldb] + 0.6169300554304881*b[i + 51*ldb] + -0.9404628431763479*b[i + 52*ldb] + 1.565673200151071*b[i + 53*ldb]);
        c[i + 81*ldc] = (-0.05471272432926569*b[i + 54*ldb] + 0.1918000140386678*b[i + 55*ldb] + -0.3792277021146136*b[i + 56*ldb] + 0.6169300554304881*b[i + 57*ldb] + -0.9404628431763479*b[i + 58*ldb] + 1.565673200151071*b[i + 59*ldb]);
        c[i + 82*ldc] = (-0.05471272432926569*b[i + 60*ldb] + 0.1918000140386678*b[i + 61*ldb] + -0.3792277021146136*b[i + 62*ldb] + 0.6169300554304881*b[i + 63*ldb] + -0.9404628431763479*b[i + 64*ldb] + 1.565673200151071*b[i + 65*ldb]);
        c[i + 83*ldc] = (-0.05471272432926569*b[i + 66*ldb] + 0.1918000140386678*b[i + 67*ldb] + -0.3792277021146136*b[i + 68*ldb] + 0.6169300554304881*b[i + 69*ldb] + -0.9404628431763479*b[i + 70*ldb] + 1.565673200151071*b[i + 71*ldb]);
        c[i + 84*ldc] = (-0.05471272432926569*b[i + 72*ldb] + 0.1918000140386678*b[i + 73*ldb] + -0.3792277021146136*b[i + 74*ldb] + 0.6169300554304881*b[i + 75*ldb] + -0.9404628431763479*b[i + 76*ldb] + 1.565673200151071*b[i + 77*ldb]);
        c[i + 85*ldc] = (-0.05471272432926569*b[i + 78*ldb] + 0.1918000140386678*b[i + 79*ldb] + -0.3792277021146136*b[i + 80*ldb] + 0.6169300554304881*b[i + 81*ldb] + -0.9404628431763479*b[i + 82*ldb] + 1.565673200151071*b[i + 83*ldb]);
        c[i + 86*ldc] = (-0.05471272432926569*b[i + 84*ldb] + 0.1918000140386678*b[i + 85*ldb] + -0.3792277021146136*b[i + 86*ldb] + 0.6169300554304881*b[i + 87*ldb] + -0.9404628431763479*b[i + 88*ldb] + 1.565673200151071*b[i + 89*ldb]);
        c[i + 87*ldc] = (-0.05471272432926569*b[i + 90*ldb] + 0.1918000140386678*b[i + 91*ldb] + -0.3792277021146136*b[i + 92*ldb] + 0.6169300554304881*b[i + 93*ldb] + -0.9404628431763479*b[i + 94*ldb] + 1.565673200151071*b[i + 95*ldb]);
        c[i + 88*ldc] = (-0.05471272432926569*b[i + 96*ldb] + 0.1918000140386678*b[i + 97*ldb] + -0.3792277021146136*b[i + 98*ldb] + 0.6169300554304881*b[i + 99*ldb] + -0.9404628431763479*b[i + 100*ldb] + 1.565673200151071*b[i + 101*ldb]);
        c[i + 89*ldc] = (-0.05471272432926569*b[i + 102*ldb] + 0.1918000140386678*b[i + 103*ldb] + -0.3792277021146136*b[i + 104*ldb] + 0.6169300554304881*b[i + 105*ldb] + -0.9404628431763479*b[i + 106*ldb] + 1.565673200151071*b[i + 107*ldb]);
        c[i + 90*ldc] = (-0.05471272432926569*b[i + 108*ldb] + 0.1918000140386678*b[i + 109*ldb] + -0.3792277021146136*b[i + 110*ldb] + 0.6169300554304881*b[i + 111*ldb] + -0.9404628431763479*b[i + 112*ldb] + 1.565673200151071*b[i + 113*ldb]);
        c[i + 91*ldc] = (-0.05471272432926569*b[i + 114*ldb] + 0.1918000140386678*b[i + 115*ldb] + -0.3792277021146136*b[i + 116*ldb] + 0.6169300554304881*b[i + 117*ldb] + -0.9404628431763479*b[i + 118*ldb] + 1.565673200151071*b[i + 119*ldb]);
        c[i + 92*ldc] = (-0.05471272432926569*b[i + 120*ldb] + 0.1918000140386678*b[i + 121*ldb] + -0.3792277021146136*b[i + 122*ldb] + 0.6169300554304881*b[i + 123*ldb] + -0.9404628431763479*b[i + 124*ldb] + 1.565673200151071*b[i + 125*ldb]);
        c[i + 93*ldc] = (-0.05471272432926569*b[i + 126*ldb] + 0.1918000140386678*b[i + 127*ldb] + -0.3792277021146136*b[i + 128*ldb] + 0.6169300554304881*b[i + 129*ldb] + -0.9404628431763479*b[i + 130*ldb] + 1.565673200151071*b[i + 131*ldb]);
        c[i + 94*ldc] = (-0.05471272432926569*b[i + 132*ldb] + 0.1918000140386678*b[i + 133*ldb] + -0.3792277021146136*b[i + 134*ldb] + 0.6169300554304881*b[i + 135*ldb] + -0.9404628431763479*b[i + 136*ldb] + 1.565673200151071*b[i + 137*ldb]);
        c[i + 95*ldc] = (-0.05471272432926569*b[i + 138*ldb] + 0.1918000140386678*b[i + 139*ldb] + -0.3792277021146136*b[i + 140*ldb] + 0.6169300554304881*b[i + 141*ldb] + -0.9404628431763479*b[i + 142*ldb] + 1.565673200151071*b[i + 143*ldb]);
        c[i + 96*ldc] = (-0.05471272432926569*b[i + 144*ldb] + 0.1918000140386678*b[i + 145*ldb] + -0.3792277021146136*b[i + 146*ldb] + 0.6169300554304881*b[i + 147*ldb] + -0.9404628431763479*b[i + 148*ldb] + 1.565673200151071*b[i + 149*ldb]);
        c[i + 97*ldc] = (-0.05471272432926569*b[i + 150*ldb] + 0.1918000140386678*b[i + 151*ldb] + -0.3792277021146136*b[i + 152*ldb] + 0.6169300554304881*b[i + 153*ldb] + -0.9404628431763479*b[i + 154*ldb] + 1.565673200151071*b[i + 155*ldb]);
        c[i + 98*ldc] = (-0.05471272432926569*b[i + 156*ldb] + 0.1918000140386678*b[i + 157*ldb] + -0.3792277021146136*b[i + 158*ldb] + 0.6169300554304881*b[i + 159*ldb] + -0.9404628431763479*b[i + 160*ldb] + 1.565673200151071*b[i + 161*ldb]);
        c[i + 99*ldc] = (-0.05471272432926569*b[i + 162*ldb] + 0.1918000140386678*b[i + 163*ldb] + -0.3792277021146136*b[i + 164*ldb] + 0.6169300554304881*b[i + 165*ldb] + -0.9404628431763479*b[i + 166*ldb] + 1.565673200151071*b[i + 167*ldb]);
        c[i + 100*ldc] = (-0.05471272432926569*b[i + 168*ldb] + 0.1918000140386678*b[i + 169*ldb] + -0.3792277021146136*b[i + 170*ldb] + 0.6169300554304881*b[i + 171*ldb] + -0.9404628431763479*b[i + 172*ldb] + 1.565673200151071*b[i + 173*ldb]);
        c[i + 101*ldc] = (-0.05471272432926569*b[i + 174*ldb] + 0.1918000140386678*b[i + 175*ldb] + -0.3792277021146136*b[i + 176*ldb] + 0.6169300554304881*b[i + 177*ldb] + -0.9404628431763479*b[i + 178*ldb] + 1.565673200151071*b[i + 179*ldb]);
        c[i + 102*ldc] = (-0.05471272432926569*b[i + 180*ldb] + 0.1918000140386678*b[i + 181*ldb] + -0.3792277021146136*b[i + 182*ldb] + 0.6169300554304881*b[i + 183*ldb] + -0.9404628431763479*b[i + 184*ldb] + 1.565673200151071*b[i + 185*ldb]);
        c[i + 103*ldc] = (-0.05471272432926569*b[i + 186*ldb] + 0.1918000140386678*b[i + 187*ldb] + -0.3792277021146136*b[i + 188*ldb] + 0.6169300554304881*b[i + 189*ldb] + -0.9404628431763479*b[i + 190*ldb] + 1.565673200151071*b[i + 191*ldb]);
        c[i + 104*ldc] = (-0.05471272432926569*b[i + 192*ldb] + 0.1918000140386678*b[i + 193*ldb] + -0.3792277021146136*b[i + 194*ldb] + 0.6169300554304881*b[i + 195*ldb] + -0.9404628431763479*b[i + 196*ldb] + 1.565673200151071*b[i + 197*ldb]);
        c[i + 105*ldc] = (-0.05471272432926569*b[i + 198*ldb] + 0.1918000140386678*b[i + 199*ldb] + -0.3792277021146136*b[i + 200*ldb] + 0.6169300554304881*b[i + 201*ldb] + -0.9404628431763479*b[i + 202*ldb] + 1.565673200151071*b[i + 203*ldb]);
        c[i + 106*ldc] = (-0.05471272432926569*b[i + 204*ldb] + 0.1918000140386678*b[i + 205*ldb] + -0.3792277021146136*b[i + 206*ldb] + 0.6169300554304881*b[i + 207*ldb] + -0.9404628431763479*b[i + 208*ldb] + 1.565673200151071*b[i + 209*ldb]);
        c[i + 107*ldc] = (-0.05471272432926569*b[i + 210*ldb] + 0.1918000140386678*b[i + 211*ldb] + -0.3792277021146136*b[i + 212*ldb] + 0.6169300554304881*b[i + 213*ldb] + -0.9404628431763479*b[i + 214*ldb] + 1.565673200151071*b[i + 215*ldb]);
        c[i + 108*ldc] = (-0.05471272432926569*b[i + 0*ldb] + 0.1918000140386678*b[i + 6*ldb] + -0.3792277021146136*b[i + 12*ldb] + 0.6169300554304881*b[i + 18*ldb] + -0.9404628431763479*b[i + 24*ldb] + 1.565673200151071*b[i + 30*ldb]);
        c[i + 109*ldc] = (-0.05471272432926569*b[i + 1*ldb] + 0.1918000140386678*b[i + 7*ldb] + -0.3792277021146136*b[i + 13*ldb] + 0.6169300554304881*b[i + 19*ldb] + -0.9404628431763479*b[i + 25*ldb] + 1.565673200151071*b[i + 31*ldb]);
        c[i + 110*ldc] = (-0.05471272432926569*b[i + 2*ldb] + 0.1918000140386678*b[i + 8*ldb] + -0.3792277021146136*b[i + 14*ldb] + 0.6169300554304881*b[i + 20*ldb] + -0.9404628431763479*b[i + 26*ldb] + 1.565673200151071*b[i + 32*ldb]);
        c[i + 111*ldc] = (-0.05471272432926569*b[i + 3*ldb] + 0.1918000140386678*b[i + 9*ldb] + -0.3792277021146136*b[i + 15*ldb] + 0.6169300554304881*b[i + 21*ldb] + -0.9404628431763479*b[i + 27*ldb] + 1.565673200151071*b[i + 33*ldb]);
        c[i + 112*ldc] = (-0.05471272432926569*b[i + 4*ldb] + 0.1918000140386678*b[i + 10*ldb] + -0.3792277021146136*b[i + 16*ldb] + 0.6169300554304881*b[i + 22*ldb] + -0.9404628431763479*b[i + 28*ldb] + 1.565673200151071*b[i + 34*ldb]);
        c[i + 113*ldc] = (-0.05471272432926569*b[i + 5*ldb] + 0.1918000140386678*b[i + 11*ldb] + -0.3792277021146136*b[i + 17*ldb] + 0.6169300554304881*b[i + 23*ldb] + -0.9404628431763479*b[i + 29*ldb] + 1.565673200151071*b[i + 35*ldb]);
        c[i + 114*ldc] = (-0.05471272432926569*b[i + 36*ldb] + 0.1918000140386678*b[i + 42*ldb] + -0.3792277021146136*b[i + 48*ldb] + 0.6169300554304881*b[i + 54*ldb] + -0.9404628431763479*b[i + 60*ldb] + 1.565673200151071*b[i + 66*ldb]);
        c[i + 115*ldc] = (-0.05471272432926569*b[i + 37*ldb] + 0.1918000140386678*b[i + 43*ldb] + -0.3792277021146136*b[i + 49*ldb] + 0.6169300554304881*b[i + 55*ldb] + -0.9404628431763479*b[i + 61*ldb] + 1.565673200151071*b[i + 67*ldb]);
        c[i + 116*ldc] = (-0.05471272432926569*b[i + 38*ldb] + 0.1918000140386678*b[i + 44*ldb] + -0.3792277021146136*b[i + 50*ldb] + 0.6169300554304881*b[i + 56*ldb] + -0.9404628431763479*b[i + 62*ldb] + 1.565673200151071*b[i + 68*ldb]);
        c[i + 117*ldc] = (-0.05471272432926569*b[i + 39*ldb] + 0.1918000140386678*b[i + 45*ldb] + -0.3792277021146136*b[i + 51*ldb] + 0.6169300554304881*b[i + 57*ldb] + -0.9404628431763479*b[i + 63*ldb] + 1.565673200151071*b[i + 69*ldb]);
        c[i + 118*ldc] = (-0.05471272432926569*b[i + 40*ldb] + 0.1918000140386678*b[i + 46*ldb] + -0.3792277021146136*b[i + 52*ldb] + 0.6169300554304881*b[i + 58*ldb] + -0.9404628431763479*b[i + 64*ldb] + 1.565673200151071*b[i + 70*ldb]);
        c[i + 119*ldc] = (-0.05471272432926569*b[i + 41*ldb] + 0.1918000140386678*b[i + 47*ldb] + -0.3792277021146136*b[i + 53*ldb] + 0.6169300554304881*b[i + 59*ldb] + -0.9404628431763479*b[i + 65*ldb] + 1.565673200151071*b[i + 71*ldb]);
        c[i + 120*ldc] = (-0.05471272432926569*b[i + 72*ldb] + 0.1918000140386678*b[i + 78*ldb] + -0.3792277021146136*b[i + 84*ldb] + 0.6169300554304881*b[i + 90*ldb] + -0.9404628431763479*b[i + 96*ldb] + 1.565673200151071*b[i + 102*ldb]);
        c[i + 121*ldc] = (-0.05471272432926569*b[i + 73*ldb] + 0.1918000140386678*b[i + 79*ldb] + -0.3792277021146136*b[i + 85*ldb] + 0.6169300554304881*b[i + 91*ldb] + -0.9404628431763479*b[i + 97*ldb] + 1.565673200151071*b[i + 103*ldb]);
        c[i + 122*ldc] = (-0.05471272432926569*b[i + 74*ldb] + 0.1918000140386678*b[i + 80*ldb] + -0.3792277021146136*b[i + 86*ldb] + 0.6169300554304881*b[i + 92*ldb] + -0.9404628431763479*b[i + 98*ldb] + 1.565673200151071*b[i + 104*ldb]);
        c[i + 123*ldc] = (-0.05471272432926569*b[i + 75*ldb] + 0.1918000140386678*b[i + 81*ldb] + -0.3792277021146136*b[i + 87*ldb] + 0.6169300554304881*b[i + 93*ldb] + -0.9404628431763479*b[i + 99*ldb] + 1.565673200151071*b[i + 105*ldb]);
        c[i + 124*ldc] = (-0.05471272432926569*b[i + 76*ldb] + 0.1918000140386678*b[i + 82*ldb] + -0.3792277021146136*b[i + 88*ldb] + 0.6169300554304881*b[i + 94*ldb] + -0.9404628431763479*b[i + 100*ldb] + 1.565673200151071*b[i + 106*ldb]);
        c[i + 125*ldc] = (-0.05471272432926569*b[i + 77*ldb] + 0.1918000140386678*b[i + 83*ldb] + -0.3792277021146136*b[i + 89*ldb] + 0.6169300554304881*b[i + 95*ldb] + -0.9404628431763479*b[i + 101*ldb] + 1.565673200151071*b[i + 107*ldb]);
        c[i + 126*ldc] = (-0.05471272432926569*b[i + 108*ldb] + 0.1918000140386678*b[i + 114*ldb] + -0.3792277021146136*b[i + 120*ldb] + 0.6169300554304881*b[i + 126*ldb] + -0.9404628431763479*b[i + 132*ldb] + 1.565673200151071*b[i + 138*ldb]);
        c[i + 127*ldc] = (-0.05471272432926569*b[i + 109*ldb] + 0.1918000140386678*b[i + 115*ldb] + -0.3792277021146136*b[i + 121*ldb] + 0.6169300554304881*b[i + 127*ldb] + -0.9404628431763479*b[i + 133*ldb] + 1.565673200151071*b[i + 139*ldb]);
        c[i + 128*ldc] = (-0.05471272432926569*b[i + 110*ldb] + 0.1918000140386678*b[i + 116*ldb] + -0.3792277021146136*b[i + 122*ldb] + 0.6169300554304881*b[i + 128*ldb] + -0.9404628431763479*b[i + 134*ldb] + 1.565673200151071*b[i + 140*ldb]);
        c[i + 129*ldc] = (-0.05471272432926569*b[i + 111*ldb] + 0.1918000140386678*b[i + 117*ldb] + -0.3792277021146136*b[i + 123*ldb] + 0.6169300554304881*b[i + 129*ldb] + -0.9404628431763479*b[i + 135*ldb] + 1.565673200151071*b[i + 141*ldb]);
        c[i + 130*ldc] = (-0.05471272432926569*b[i + 112*ldb] + 0.1918000140386678*b[i + 118*ldb] + -0.3792277021146136*b[i + 124*ldb] + 0.6169300554304881*b[i + 130*ldb] + -0.9404628431763479*b[i + 136*ldb] + 1.565673200151071*b[i + 142*ldb]);
        c[i + 131*ldc] = (-0.05471272432926569*b[i + 113*ldb] + 0.1918000140386678*b[i + 119*ldb] + -0.3792277021146136*b[i + 125*ldb] + 0.6169300554304881*b[i + 131*ldb] + -0.9404628431763479*b[i + 137*ldb] + 1.565673200151071*b[i + 143*ldb]);
        c[i + 132*ldc] = (-0.05471272432926569*b[i + 144*ldb] + 0.1918000140386678*b[i + 150*ldb] + -0.3792277021146136*b[i + 156*ldb] + 0.6169300554304881*b[i + 162*ldb] + -0.9404628431763479*b[i + 168*ldb] + 1.565673200151071*b[i + 174*ldb]);
        c[i + 133*ldc] = (-0.05471272432926569*b[i + 145*ldb] + 0.1918000140386678*b[i + 151*ldb] + -0.3792277021146136*b[i + 157*ldb] + 0.6169300554304881*b[i + 163*ldb] + -0.9404628431763479*b[i + 169*ldb] + 1.565673200151071*b[i + 175*ldb]);
        c[i + 134*ldc] = (-0.05471272432926569*b[i + 146*ldb] + 0.1918000140386678*b[i + 152*ldb] + -0.3792277021146136*b[i + 158*ldb] + 0.6169300554304881*b[i + 164*ldb] + -0.9404628431763479*b[i + 170*ldb] + 1.565673200151071*b[i + 176*ldb]);
        c[i + 135*ldc] = (-0.05471272432926569*b[i + 147*ldb] + 0.1918000140386678*b[i + 153*ldb] + -0.3792277021146136*b[i + 159*ldb] + 0.6169300554304881*b[i + 165*ldb] + -0.9404628431763479*b[i + 171*ldb] + 1.565673200151071*b[i + 177*ldb]);
        c[i + 136*ldc] = (-0.05471272432926569*b[i + 148*ldb] + 0.1918000140386678*b[i + 154*ldb] + -0.3792277021146136*b[i + 160*ldb] + 0.6169300554304881*b[i + 166*ldb] + -0.9404628431763479*b[i + 172*ldb] + 1.565673200151071*b[i + 178*ldb]);
        c[i + 137*ldc] = (-0.05471272432926569*b[i + 149*ldb] + 0.1918000140386678*b[i + 155*ldb] + -0.3792277021146136*b[i + 161*ldb] + 0.6169300554304881*b[i + 167*ldb] + -0.9404628431763479*b[i + 173*ldb] + 1.565673200151071*b[i + 179*ldb]);
        c[i + 138*ldc] = (-0.05471272432926569*b[i + 180*ldb] + 0.1918000140386678*b[i + 186*ldb] + -0.3792277021146136*b[i + 192*ldb] + 0.6169300554304881*b[i + 198*ldb] + -0.9404628431763479*b[i + 204*ldb] + 1.565673200151071*b[i + 210*ldb]);
        c[i + 139*ldc] = (-0.05471272432926569*b[i + 181*ldb] + 0.1918000140386678*b[i + 187*ldb] + -0.3792277021146136*b[i + 193*ldb] + 0.6169300554304881*b[i + 199*ldb] + -0.9404628431763479*b[i + 205*ldb] + 1.565673200151071*b[i + 211*ldb]);
        c[i + 140*ldc] = (-0.05471272432926569*b[i + 182*ldb] + 0.1918000140386678*b[i + 188*ldb] + -0.3792277021146136*b[i + 194*ldb] + 0.6169300554304881*b[i + 200*ldb] + -0.9404628431763479*b[i + 206*ldb] + 1.565673200151071*b[i + 212*ldb]);
        c[i + 141*ldc] = (-0.05471272432926569*b[i + 183*ldb] + 0.1918000140386678*b[i + 189*ldb] + -0.3792277021146136*b[i + 195*ldb] + 0.6169300554304881*b[i + 201*ldb] + -0.9404628431763479*b[i + 207*ldb] + 1.565673200151071*b[i + 213*ldb]);
        c[i + 142*ldc] = (-0.05471272432926569*b[i + 184*ldb] + 0.1918000140386678*b[i + 190*ldb] + -0.3792277021146136*b[i + 196*ldb] + 0.6169300554304881*b[i + 202*ldb] + -0.9404628431763479*b[i + 208*ldb] + 1.565673200151071*b[i + 214*ldb]);
        c[i + 143*ldc] = (-0.05471272432926569*b[i + 185*ldb] + 0.1918000140386678*b[i + 191*ldb] + -0.3792277021146136*b[i + 197*ldb] + 0.6169300554304881*b[i + 203*ldb] + -0.9404628431763479*b[i + 209*ldb] + 1.565673200151071*b[i + 215*ldb]);
        c[i + 144*ldc] = (1.565673200151071*b[i + 0*ldb] + -0.9404628431763479*b[i + 1*ldb] + 0.6169300554304881*b[i + 2*ldb] + -0.3792277021146136*b[i + 3*ldb] + 0.1918000140386678*b[i + 4*ldb] + -0.05471272432926569*b[i + 5*ldb]);
        c[i + 145*ldc] = (1.565673200151071*b[i + 6*ldb] + -0.9404628431763479*b[i + 7*ldb] + 0.6169300554304881*b[i + 8*ldb] + -0.3792277021146136*b[i + 9*ldb] + 0.1918000140386678*b[i + 10*ldb] + -0.05471272432926569*b[i + 11*ldb]);
        c[i + 146*ldc] = (1.565673200151071*b[i + 12*ldb] + -0.9404628431763479*b[i + 13*ldb] + 0.6169300554304881*b[i + 14*ldb] + -0.3792277021146136*b[i + 15*ldb] + 0.1918000140386678*b[i + 16*ldb] + -0.05471272432926569*b[i + 17*ldb]);
        c[i + 147*ldc] = (1.565673200151071*b[i + 18*ldb] + -0.9404628431763479*b[i + 19*ldb] + 0.6169300554304881*b[i + 20*ldb] + -0.3792277021146136*b[i + 21*ldb] + 0.1918000140386678*b[i + 22*ldb] + -0.05471272432926569*b[i + 23*ldb]);
        c[i + 148*ldc] = (1.565673200151071*b[i + 24*ldb] + -0.9404628431763479*b[i + 25*ldb] + 0.6169300554304881*b[i + 26*ldb] + -0.3792277021146136*b[i + 27*ldb] + 0.1918000140386678*b[i + 28*ldb] + -0.05471272432926569*b[i + 29*ldb]);
        c[i + 149*ldc] = (1.565673200151071*b[i + 30*ldb] + -0.9404628431763479*b[i + 31*ldb] + 0.6169300554304881*b[i + 32*ldb] + -0.3792277021146136*b[i + 33*ldb] + 0.1918000140386678*b[i + 34*ldb] + -0.05471272432926569*b[i + 35*ldb]);
        c[i + 150*ldc] = (1.565673200151071*b[i + 36*ldb] + -0.9404628431763479*b[i + 37*ldb] + 0.6169300554304881*b[i + 38*ldb] + -0.3792277021146136*b[i + 39*ldb] + 0.1918000140386678*b[i + 40*ldb] + -0.05471272432926569*b[i + 41*ldb]);
        c[i + 151*ldc] = (1.565673200151071*b[i + 42*ldb] + -0.9404628431763479*b[i + 43*ldb] + 0.6169300554304881*b[i + 44*ldb] + -0.3792277021146136*b[i + 45*ldb] + 0.1918000140386678*b[i + 46*ldb] + -0.05471272432926569*b[i + 47*ldb]);
        c[i + 152*ldc] = (1.565673200151071*b[i + 48*ldb] + -0.9404628431763479*b[i + 49*ldb] + 0.6169300554304881*b[i + 50*ldb] + -0.3792277021146136*b[i + 51*ldb] + 0.1918000140386678*b[i + 52*ldb] + -0.05471272432926569*b[i + 53*ldb]);
        c[i + 153*ldc] = (1.565673200151071*b[i + 54*ldb] + -0.9404628431763479*b[i + 55*ldb] + 0.6169300554304881*b[i + 56*ldb] + -0.3792277021146136*b[i + 57*ldb] + 0.1918000140386678*b[i + 58*ldb] + -0.05471272432926569*b[i + 59*ldb]);
        c[i + 154*ldc] = (1.565673200151071*b[i + 60*ldb] + -0.9404628431763479*b[i + 61*ldb] + 0.6169300554304881*b[i + 62*ldb] + -0.3792277021146136*b[i + 63*ldb] + 0.1918000140386678*b[i + 64*ldb] + -0.05471272432926569*b[i + 65*ldb]);
        c[i + 155*ldc] = (1.565673200151071*b[i + 66*ldb] + -0.9404628431763479*b[i + 67*ldb] + 0.6169300554304881*b[i + 68*ldb] + -0.3792277021146136*b[i + 69*ldb] + 0.1918000140386678*b[i + 70*ldb] + -0.05471272432926569*b[i + 71*ldb]);
        c[i + 156*ldc] = (1.565673200151071*b[i + 72*ldb] + -0.9404628431763479*b[i + 73*ldb] + 0.6169300554304881*b[i + 74*ldb] + -0.3792277021146136*b[i + 75*ldb] + 0.1918000140386678*b[i + 76*ldb] + -0.05471272432926569*b[i + 77*ldb]);
        c[i + 157*ldc] = (1.565673200151071*b[i + 78*ldb] + -0.9404628431763479*b[i + 79*ldb] + 0.6169300554304881*b[i + 80*ldb] + -0.3792277021146136*b[i + 81*ldb] + 0.1918000140386678*b[i + 82*ldb] + -0.05471272432926569*b[i + 83*ldb]);
        c[i + 158*ldc] = (1.565673200151071*b[i + 84*ldb] + -0.9404628431763479*b[i + 85*ldb] + 0.6169300554304881*b[i + 86*ldb] + -0.3792277021146136*b[i + 87*ldb] + 0.1918000140386678*b[i + 88*ldb] + -0.05471272432926569*b[i + 89*ldb]);
        c[i + 159*ldc] = (1.565673200151071*b[i + 90*ldb] + -0.9404628431763479*b[i + 91*ldb] + 0.6169300554304881*b[i + 92*ldb] + -0.3792277021146136*b[i + 93*ldb] + 0.1918000140386678*b[i + 94*ldb] + -0.05471272432926569*b[i + 95*ldb]);
        c[i + 160*ldc] = (1.565673200151071*b[i + 96*ldb] + -0.9404628431763479*b[i + 97*ldb] + 0.6169300554304881*b[i + 98*ldb] + -0.3792277021146136*b[i + 99*ldb] + 0.1918000140386678*b[i + 100*ldb] + -0.05471272432926569*b[i + 101*ldb]);
        c[i + 161*ldc] = (1.565673200151071*b[i + 102*ldb] + -0.9404628431763479*b[i + 103*ldb] + 0.6169300554304881*b[i + 104*ldb] + -0.3792277021146136*b[i + 105*ldb] + 0.1918000140386678*b[i + 106*ldb] + -0.05471272432926569*b[i + 107*ldb]);
        c[i + 162*ldc] = (1.565673200151071*b[i + 108*ldb] + -0.9404628431763479*b[i + 109*ldb] + 0.6169300554304881*b[i + 110*ldb] + -0.3792277021146136*b[i + 111*ldb] + 0.1918000140386678*b[i + 112*ldb] + -0.05471272432926569*b[i + 113*ldb]);
        c[i + 163*ldc] = (1.565673200151071*b[i + 114*ldb] + -0.9404628431763479*b[i + 115*ldb] + 0.6169300554304881*b[i + 116*ldb] + -0.3792277021146136*b[i + 117*ldb] + 0.1918000140386678*b[i + 118*ldb] + -0.05471272432926569*b[i + 119*ldb]);
        c[i + 164*ldc] = (1.565673200151071*b[i + 120*ldb] + -0.9404628431763479*b[i + 121*ldb] + 0.6169300554304881*b[i + 122*ldb] + -0.3792277021146136*b[i + 123*ldb] + 0.1918000140386678*b[i + 124*ldb] + -0.05471272432926569*b[i + 125*ldb]);
        c[i + 165*ldc] = (1.565673200151071*b[i + 126*ldb] + -0.9404628431763479*b[i + 127*ldb] + 0.6169300554304881*b[i + 128*ldb] + -0.3792277021146136*b[i + 129*ldb] + 0.1918000140386678*b[i + 130*ldb] + -0.05471272432926569*b[i + 131*ldb]);
        c[i + 166*ldc] = (1.565673200151071*b[i + 132*ldb] + -0.9404628431763479*b[i + 133*ldb] + 0.6169300554304881*b[i + 134*ldb] + -0.3792277021146136*b[i + 135*ldb] + 0.1918000140386678*b[i + 136*ldb] + -0.05471272432926569*b[i + 137*ldb]);
        c[i + 167*ldc] = (1.565673200151071*b[i + 138*ldb] + -0.9404628431763479*b[i + 139*ldb] + 0.6169300554304881*b[i + 140*ldb] + -0.3792277021146136*b[i + 141*ldb] + 0.1918000140386678*b[i + 142*ldb] + -0.05471272432926569*b[i + 143*ldb]);
        c[i + 168*ldc] = (1.565673200151071*b[i + 144*ldb] + -0.9404628431763479*b[i + 145*ldb] + 0.6169300554304881*b[i + 146*ldb] + -0.3792277021146136*b[i + 147*ldb] + 0.1918000140386678*b[i + 148*ldb] + -0.05471272432926569*b[i + 149*ldb]);
        c[i + 169*ldc] = (1.565673200151071*b[i + 150*ldb] + -0.9404628431763479*b[i + 151*ldb] + 0.6169300554304881*b[i + 152*ldb] + -0.3792277021146136*b[i + 153*ldb] + 0.1918000140386678*b[i + 154*ldb] + -0.05471272432926569*b[i + 155*ldb]);
        c[i + 170*ldc] = (1.565673200151071*b[i + 156*ldb] + -0.9404628431763479*b[i + 157*ldb] + 0.6169300554304881*b[i + 158*ldb] + -0.3792277021146136*b[i + 159*ldb] + 0.1918000140386678*b[i + 160*ldb] + -0.05471272432926569*b[i + 161*ldb]);
        c[i + 171*ldc] = (1.565673200151071*b[i + 162*ldb] + -0.9404628431763479*b[i + 163*ldb] + 0.6169300554304881*b[i + 164*ldb] + -0.3792277021146136*b[i + 165*ldb] + 0.1918000140386678*b[i + 166*ldb] + -0.05471272432926569*b[i + 167*ldb]);
        c[i + 172*ldc] = (1.565673200151071*b[i + 168*ldb] + -0.9404628431763479*b[i + 169*ldb] + 0.6169300554304881*b[i + 170*ldb] + -0.3792277021146136*b[i + 171*ldb] + 0.1918000140386678*b[i + 172*ldb] + -0.05471272432926569*b[i + 173*ldb]);
        c[i + 173*ldc] = (1.565673200151071*b[i + 174*ldb] + -0.9404628431763479*b[i + 175*ldb] + 0.6169300554304881*b[i + 176*ldb] + -0.3792277021146136*b[i + 177*ldb] + 0.1918000140386678*b[i + 178*ldb] + -0.05471272432926569*b[i + 179*ldb]);
        c[i + 174*ldc] = (1.565673200151071*b[i + 180*ldb] + -0.9404628431763479*b[i + 181*ldb] + 0.6169300554304881*b[i + 182*ldb] + -0.3792277021146136*b[i + 183*ldb] + 0.1918000140386678*b[i + 184*ldb] + -0.05471272432926569*b[i + 185*ldb]);
        c[i + 175*ldc] = (1.565673200151071*b[i + 186*ldb] + -0.9404628431763479*b[i + 187*ldb] + 0.6169300554304881*b[i + 188*ldb] + -0.3792277021146136*b[i + 189*ldb] + 0.1918000140386678*b[i + 190*ldb] + -0.05471272432926569*b[i + 191*ldb]);
        c[i + 176*ldc] = (1.565673200151071*b[i + 192*ldb] + -0.9404628431763479*b[i + 193*ldb] + 0.6169300554304881*b[i + 194*ldb] + -0.3792277021146136*b[i + 195*ldb] + 0.1918000140386678*b[i + 196*ldb] + -0.05471272432926569*b[i + 197*ldb]);
        c[i + 177*ldc] = (1.565673200151071*b[i + 198*ldb] + -0.9404628431763479*b[i + 199*ldb] + 0.6169300554304881*b[i + 200*ldb] + -0.3792277021146136*b[i + 201*ldb] + 0.1918000140386678*b[i + 202*ldb] + -0.05471272432926569*b[i + 203*ldb]);
        c[i + 178*ldc] = (1.565673200151071*b[i + 204*ldb] + -0.9404628431763479*b[i + 205*ldb] + 0.6169300554304881*b[i + 206*ldb] + -0.3792277021146136*b[i + 207*ldb] + 0.1918000140386678*b[i + 208*ldb] + -0.05471272432926569*b[i + 209*ldb]);
        c[i + 179*ldc] = (1.565673200151071*b[i + 210*ldb] + -0.9404628431763479*b[i + 211*ldb] + 0.6169300554304881*b[i + 212*ldb] + -0.3792277021146136*b[i + 213*ldb] + 0.1918000140386678*b[i + 214*ldb] + -0.05471272432926569*b[i + 215*ldb]);
        c[i + 180*ldc] = (-0.05471272432926569*b[i + 0*ldb] + 0.1918000140386678*b[i + 36*ldb] + -0.3792277021146136*b[i + 72*ldb] + 0.6169300554304881*b[i + 108*ldb] + -0.9404628431763479*b[i + 144*ldb] + 1.565673200151071*b[i + 180*ldb]);
        c[i + 181*ldc] = (-0.05471272432926569*b[i + 1*ldb] + 0.1918000140386678*b[i + 37*ldb] + -0.3792277021146136*b[i + 73*ldb] + 0.6169300554304881*b[i + 109*ldb] + -0.9404628431763479*b[i + 145*ldb] + 1.565673200151071*b[i + 181*ldb]);
        c[i + 182*ldc] = (-0.05471272432926569*b[i + 2*ldb] + 0.1918000140386678*b[i + 38*ldb] + -0.3792277021146136*b[i + 74*ldb] + 0.6169300554304881*b[i + 110*ldb] + -0.9404628431763479*b[i + 146*ldb] + 1.565673200151071*b[i + 182*ldb]);
        c[i + 183*ldc] = (-0.05471272432926569*b[i + 3*ldb] + 0.1918000140386678*b[i + 39*ldb] + -0.3792277021146136*b[i + 75*ldb] + 0.6169300554304881*b[i + 111*ldb] + -0.9404628431763479*b[i + 147*ldb] + 1.565673200151071*b[i + 183*ldb]);
        c[i + 184*ldc] = (-0.05471272432926569*b[i + 4*ldb] + 0.1918000140386678*b[i + 40*ldb] + -0.3792277021146136*b[i + 76*ldb] + 0.6169300554304881*b[i + 112*ldb] + -0.9404628431763479*b[i + 148*ldb] + 1.565673200151071*b[i + 184*ldb]);
        c[i + 185*ldc] = (-0.05471272432926569*b[i + 5*ldb] + 0.1918000140386678*b[i + 41*ldb] + -0.3792277021146136*b[i + 77*ldb] + 0.6169300554304881*b[i + 113*ldb] + -0.9404628431763479*b[i + 149*ldb] + 1.565673200151071*b[i + 185*ldb]);
        c[i + 186*ldc] = (-0.05471272432926569*b[i + 6*ldb] + 0.1918000140386678*b[i + 42*ldb] + -0.3792277021146136*b[i + 78*ldb] + 0.6169300554304881*b[i + 114*ldb] + -0.9404628431763479*b[i + 150*ldb] + 1.565673200151071*b[i + 186*ldb]);
        c[i + 187*ldc] = (-0.05471272432926569*b[i + 7*ldb] + 0.1918000140386678*b[i + 43*ldb] + -0.3792277021146136*b[i + 79*ldb] + 0.6169300554304881*b[i + 115*ldb] + -0.9404628431763479*b[i + 151*ldb] + 1.565673200151071*b[i + 187*ldb]);
        c[i + 188*ldc] = (-0.05471272432926569*b[i + 8*ldb] + 0.1918000140386678*b[i + 44*ldb] + -0.3792277021146136*b[i + 80*ldb] + 0.6169300554304881*b[i + 116*ldb] + -0.9404628431763479*b[i + 152*ldb] + 1.565673200151071*b[i + 188*ldb]);
        c[i + 189*ldc] = (-0.05471272432926569*b[i + 9*ldb] + 0.1918000140386678*b[i + 45*ldb] + -0.3792277021146136*b[i + 81*ldb] + 0.6169300554304881*b[i + 117*ldb] + -0.9404628431763479*b[i + 153*ldb] + 1.565673200151071*b[i + 189*ldb]);
        c[i + 190*ldc] = (-0.05471272432926569*b[i + 10*ldb] + 0.1918000140386678*b[i + 46*ldb] + -0.3792277021146136*b[i + 82*ldb] + 0.6169300554304881*b[i + 118*ldb] + -0.9404628431763479*b[i + 154*ldb] + 1.565673200151071*b[i + 190*ldb]);
        c[i + 191*ldc] = (-0.05471272432926569*b[i + 11*ldb] + 0.1918000140386678*b[i + 47*ldb] + -0.3792277021146136*b[i + 83*ldb] + 0.6169300554304881*b[i + 119*ldb] + -0.9404628431763479*b[i + 155*ldb] + 1.565673200151071*b[i + 191*ldb]);
        c[i + 192*ldc] = (-0.05471272432926569*b[i + 12*ldb] + 0.1918000140386678*b[i + 48*ldb] + -0.3792277021146136*b[i + 84*ldb] + 0.6169300554304881*b[i + 120*ldb] + -0.9404628431763479*b[i + 156*ldb] + 1.565673200151071*b[i + 192*ldb]);
        c[i + 193*ldc] = (-0.05471272432926569*b[i + 13*ldb] + 0.1918000140386678*b[i + 49*ldb] + -0.3792277021146136*b[i + 85*ldb] + 0.6169300554304881*b[i + 121*ldb] + -0.9404628431763479*b[i + 157*ldb] + 1.565673200151071*b[i + 193*ldb]);
        c[i + 194*ldc] = (-0.05471272432926569*b[i + 14*ldb] + 0.1918000140386678*b[i + 50*ldb] + -0.3792277021146136*b[i + 86*ldb] + 0.6169300554304881*b[i + 122*ldb] + -0.9404628431763479*b[i + 158*ldb] + 1.565673200151071*b[i + 194*ldb]);
        c[i + 195*ldc] = (-0.05471272432926569*b[i + 15*ldb] + 0.1918000140386678*b[i + 51*ldb] + -0.3792277021146136*b[i + 87*ldb] + 0.6169300554304881*b[i + 123*ldb] + -0.9404628431763479*b[i + 159*ldb] + 1.565673200151071*b[i + 195*ldb]);
        c[i + 196*ldc] = (-0.05471272432926569*b[i + 16*ldb] + 0.1918000140386678*b[i + 52*ldb] + -0.3792277021146136*b[i + 88*ldb] + 0.6169300554304881*b[i + 124*ldb] + -0.9404628431763479*b[i + 160*ldb] + 1.565673200151071*b[i + 196*ldb]);
        c[i + 197*ldc] = (-0.05471272432926569*b[i + 17*ldb] + 0.1918000140386678*b[i + 53*ldb] + -0.3792277021146136*b[i + 89*ldb] + 0.6169300554304881*b[i + 125*ldb] + -0.9404628431763479*b[i + 161*ldb] + 1.565673200151071*b[i + 197*ldb]);
        c[i + 198*ldc] = (-0.05471272432926569*b[i + 18*ldb] + 0.1918000140386678*b[i + 54*ldb] + -0.3792277021146136*b[i + 90*ldb] + 0.6169300554304881*b[i + 126*ldb] + -0.9404628431763479*b[i + 162*ldb] + 1.565673200151071*b[i + 198*ldb]);
        c[i + 199*ldc] = (-0.05471272432926569*b[i + 19*ldb] + 0.1918000140386678*b[i + 55*ldb] + -0.3792277021146136*b[i + 91*ldb] + 0.6169300554304881*b[i + 127*ldb] + -0.9404628431763479*b[i + 163*ldb] + 1.565673200151071*b[i + 199*ldb]);
        c[i + 200*ldc] = (-0.05471272432926569*b[i + 20*ldb] + 0.1918000140386678*b[i + 56*ldb] + -0.3792277021146136*b[i + 92*ldb] + 0.6169300554304881*b[i + 128*ldb] + -0.9404628431763479*b[i + 164*ldb] + 1.565673200151071*b[i + 200*ldb]);
        c[i + 201*ldc] = (-0.05471272432926569*b[i + 21*ldb] + 0.1918000140386678*b[i + 57*ldb] + -0.3792277021146136*b[i + 93*ldb] + 0.6169300554304881*b[i + 129*ldb] + -0.9404628431763479*b[i + 165*ldb] + 1.565673200151071*b[i + 201*ldb]);
        c[i + 202*ldc] = (-0.05471272432926569*b[i + 22*ldb] + 0.1918000140386678*b[i + 58*ldb] + -0.3792277021146136*b[i + 94*ldb] + 0.6169300554304881*b[i + 130*ldb] + -0.9404628431763479*b[i + 166*ldb] + 1.565673200151071*b[i + 202*ldb]);
        c[i + 203*ldc] = (-0.05471272432926569*b[i + 23*ldb] + 0.1918000140386678*b[i + 59*ldb] + -0.3792277021146136*b[i + 95*ldb] + 0.6169300554304881*b[i + 131*ldb] + -0.9404628431763479*b[i + 167*ldb] + 1.565673200151071*b[i + 203*ldb]);
        c[i + 204*ldc] = (-0.05471272432926569*b[i + 24*ldb] + 0.1918000140386678*b[i + 60*ldb] + -0.3792277021146136*b[i + 96*ldb] + 0.6169300554304881*b[i + 132*ldb] + -0.9404628431763479*b[i + 168*ldb] + 1.565673200151071*b[i + 204*ldb]);
        c[i + 205*ldc] = (-0.05471272432926569*b[i + 25*ldb] + 0.1918000140386678*b[i + 61*ldb] + -0.3792277021146136*b[i + 97*ldb] + 0.6169300554304881*b[i + 133*ldb] + -0.9404628431763479*b[i + 169*ldb] + 1.565673200151071*b[i + 205*ldb]);
        c[i + 206*ldc] = (-0.05471272432926569*b[i + 26*ldb] + 0.1918000140386678*b[i + 62*ldb] + -0.3792277021146136*b[i + 98*ldb] + 0.6169300554304881*b[i + 134*ldb] + -0.9404628431763479*b[i + 170*ldb] + 1.565673200151071*b[i + 206*ldb]);
        c[i + 207*ldc] = (-0.05471272432926569*b[i + 27*ldb] + 0.1918000140386678*b[i + 63*ldb] + -0.3792277021146136*b[i + 99*ldb] + 0.6169300554304881*b[i + 135*ldb] + -0.9404628431763479*b[i + 171*ldb] + 1.565673200151071*b[i + 207*ldb]);
        c[i + 208*ldc] = (-0.05471272432926569*b[i + 28*ldb] + 0.1918000140386678*b[i + 64*ldb] + -0.3792277021146136*b[i + 100*ldb] + 0.6169300554304881*b[i + 136*ldb] + -0.9404628431763479*b[i + 172*ldb] + 1.565673200151071*b[i + 208*ldb]);
        c[i + 209*ldc] = (-0.05471272432926569*b[i + 29*ldb] + 0.1918000140386678*b[i + 65*ldb] + -0.3792277021146136*b[i + 101*ldb] + 0.6169300554304881*b[i + 137*ldb] + -0.9404628431763479*b[i + 173*ldb] + 1.565673200151071*b[i + 209*ldb]);
        c[i + 210*ldc] = (-0.05471272432926569*b[i + 30*ldb] + 0.1918000140386678*b[i + 66*ldb] + -0.3792277021146136*b[i + 102*ldb] + 0.6169300554304881*b[i + 138*ldb] + -0.9404628431763479*b[i + 174*ldb] + 1.565673200151071*b[i + 210*ldb]);
        c[i + 211*ldc] = (-0.05471272432926569*b[i + 31*ldb] + 0.1918000140386678*b[i + 67*ldb] + -0.3792277021146136*b[i + 103*ldb] + 0.6169300554304881*b[i + 139*ldb] + -0.9404628431763479*b[i + 175*ldb] + 1.565673200151071*b[i + 211*ldb]);
        c[i + 212*ldc] = (-0.05471272432926569*b[i + 32*ldb] + 0.1918000140386678*b[i + 68*ldb] + -0.3792277021146136*b[i + 104*ldb] + 0.6169300554304881*b[i + 140*ldb] + -0.9404628431763479*b[i + 176*ldb] + 1.565673200151071*b[i + 212*ldb]);
        c[i + 213*ldc] = (-0.05471272432926569*b[i + 33*ldb] + 0.1918000140386678*b[i + 69*ldb] + -0.3792277021146136*b[i + 105*ldb] + 0.6169300554304881*b[i + 141*ldb] + -0.9404628431763479*b[i + 177*ldb] + 1.565673200151071*b[i + 213*ldb]);
        c[i + 214*ldc] = (-0.05471272432926569*b[i + 34*ldb] + 0.1918000140386678*b[i + 70*ldb] + -0.3792277021146136*b[i + 106*ldb] + 0.6169300554304881*b[i + 142*ldb] + -0.9404628431763479*b[i + 178*ldb] + 1.565673200151071*b[i + 214*ldb]);
        c[i + 215*ldc] = (-0.05471272432926569*b[i + 35*ldb] + 0.1918000140386678*b[i + 71*ldb] + -0.3792277021146136*b[i + 107*ldb] + 0.6169300554304881*b[i + 143*ldb] + -0.9404628431763479*b[i + 179*ldb] + 1.565673200151071*b[i + 215*ldb]);
    }
}


LIBXSMM_INLINE
void gimmik_p5_hex_m3(const double* LIBXSMM_RESTRICT b, double* LIBXSMM_RESTRICT c)
{
    const int n = N;
    const int ldb = LDB;
    const int ldc = LDC;
    int i;

    LIBXSMM_PRAGMA_SIMD
    for (i = 0; i < n; ++i)
    {
        c[i + 0*ldc] += (9.138641991046859*b[i + 0*ldb] + 9.138641991046859*b[i + 36*ldb] + -0.3193514457242796*b[i + 72*ldb] + -0.3193514457242796*b[i + 108*ldb] + 9.138641991046859*b[i + 144*ldb] + -0.3193514457242796*b[i + 180*ldb]);
        c[i + 1*ldc] += (9.138641991046859*b[i + 1*ldb] + 9.138641991046859*b[i + 37*ldb] + 0.531653114876165*b[i + 72*ldb] + -0.3193514457242796*b[i + 109*ldb] + -2.606881978117047*b[i + 144*ldb] + -0.3193514457242796*b[i + 181*ldb]);
        c[i + 2*ldc] += (9.138641991046859*b[i + 2*ldb] + 9.138641991046859*b[i + 38*ldb] + -0.8104646476513522*b[i + 72*ldb] + -0.3193514457242796*b[i + 110*ldb] + 1.318469081272142*b[i + 144*ldb] + -0.3193514457242796*b[i + 182*ldb]);
        c[i + 3*ldc] += (9.138641991046859*b[i + 3*ldb] + 9.138641991046859*b[i + 39*ldb] + 1.318469081272142*b[i + 72*ldb] + -0.3193514457242796*b[i + 111*ldb] + -0.8104646476513522*b[i + 144*ldb] + -0.3193514457242796*b[i + 183*ldb]);
        c[i + 4*ldc] += (9.138641991046859*b[i + 4*ldb] + 9.138641991046859*b[i + 40*ldb] + -2.606881978117047*b[i + 72*ldb] + -0.3193514457242796*b[i + 112*ldb] + 0.531653114876165*b[i + 144*ldb] + -0.3193514457242796*b[i + 184*ldb]);
        c[i + 5*ldc] += (9.138641991046859*b[i + 5*ldb] + 9.138641991046859*b[i + 41*ldb] + 9.138641991046859*b[i + 72*ldb] + -0.3193514457242796*b[i + 113*ldb] + -0.3193514457242796*b[i + 144*ldb] + -0.3193514457242796*b[i + 185*ldb]);
        c[i + 6*ldc] += (9.138641991046859*b[i + 6*ldb] + -2.606881978117047*b[i + 36*ldb] + -0.3193514457242796*b[i + 73*ldb] + 0.531653114876165*b[i + 108*ldb] + 9.138641991046859*b[i + 145*ldb] + -0.3193514457242796*b[i + 186*ldb]);
        c[i + 7*ldc] += (9.138641991046859*b[i + 7*ldb] + -2.606881978117047*b[i + 37*ldb] + 0.531653114876165*b[i + 73*ldb] + 0.531653114876165*b[i + 109*ldb] + -2.606881978117047*b[i + 145*ldb] + -0.3193514457242796*b[i + 187*ldb]);
        c[i + 8*ldc] += (9.138641991046859*b[i + 8*ldb] + -2.606881978117047*b[i + 38*ldb] + -0.8104646476513522*b[i + 73*ldb] + 0.531653114876165*b[i + 110*ldb] + 1.318469081272142*b[i + 145*ldb] + -0.3193514457242796*b[i + 188*ldb]);
        c[i + 9*ldc] += (9.138641991046859*b[i + 9*ldb] + -2.606881978117047*b[i + 39*ldb] + 1.318469081272142*b[i + 73*ldb] + 0.531653114876165*b[i + 111*ldb] + -0.8104646476513522*b[i + 145*ldb] + -0.3193514457242796*b[i + 189*ldb]);
        c[i + 10*ldc] += (9.138641991046859*b[i + 10*ldb] + -2.606881978117047*b[i + 40*ldb] + -2.606881978117047*b[i + 73*ldb] + 0.531653114876165*b[i + 112*ldb] + 0.531653114876165*b[i + 145*ldb] + -0.3193514457242796*b[i + 190*ldb]);
        c[i + 11*ldc] += (9.138641991046859*b[i + 11*ldb] + -2.606881978117047*b[i + 41*ldb] + 9.138641991046859*b[i + 73*ldb] + 0.531653114876165*b[i + 113*ldb] + -0.3193514457242796*b[i + 145*ldb] + -0.3193514457242796*b[i + 191*ldb]);
        c[i + 12*ldc] += (9.138641991046859*b[i + 12*ldb] + 1.318469081272142*b[i + 36*ldb] + -0.3193514457242796*b[i + 74*ldb] + -0.8104646476513522*b[i + 108*ldb] + 9.138641991046859*b[i + 146*ldb] + -0.3193514457242796*b[i + 192*ldb]);
        c[i + 13*ldc] += (9.138641991046859*b[i + 13*ldb] + 1.318469081272142*b[i + 37*ldb] + 0.531653114876165*b[i + 74*ldb] + -0.8104646476513522*b[i + 109*ldb] + -2.606881978117047*b[i + 146*ldb] + -0.3193514457242796*b[i + 193*ldb]);
        c[i + 14*ldc] += (9.138641991046859*b[i + 14*ldb] + 1.318469081272142*b[i + 38*ldb] + -0.8104646476513522*b[i + 74*ldb] + -0.8104646476513522*b[i + 110*ldb] + 1.318469081272142*b[i + 146*ldb] + -0.319351445724