#!/bin/bash

if [ $# -ne 3 ]
then
  echo "Usage: $(basename $0) iters numa (1-mcdram/0-DDR); using default values: 1000 1 f32"
  ITERS=1000
  NUMA=1
  BIN=f32
else
  ITERS=$1
  NUMA=$2
  BIN=$3
fi

NUMACTL="${TOOL_COMMAND}"
CPUFLAGS=$(if [ -e /proc/cpuinfo ]; then grep -m1 flags /proc/cpuinfo | cut -d: -f2-; fi)
if [ "" != "$(echo "${CPUFLAGS}" | grep -o avx512er)" ]; then
  if [ "0" != "$((NUMA < $(numactl -H | grep "node  " | tr -s " " | cut -d" " -f2- | wc -w)))" ]; then
    NUMACTL="numactl --membind=${NUMA} ${TOOL_COMMAND}"
  fi
fi

# ./layer_example_${BIN} iters inpWidth inpHeight nImg nIfm nOfm kw kh pad stride type

#DeepBench specifies input pad (as in cuDNN, MKL specs) - manually added to input dimension here

${NUMACTL} ./layer_example_${BIN} ${ITERS}  700  161    4     1    32  20   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  700  161    8     1    32  20   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  700  161   16     1    32  20   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  700  161   32     1    32  20   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  341   79    4    32    32  10   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  341   79    8    32    32  10   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  341   79   16    32    32  10   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  341   79   32    32    32  10   5  0  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}  480   48   16     1    16   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  240   24   16    16    32   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  120   12   16    32    64   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   60    6   16    64   128   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  108  108    8     3    64   3   3  1  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}   54   54    8    64    64   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   27   27    8   128   128   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   14   14    8   128   256   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}    7    7    8   256   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  224  224    8     3    64   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  112  112    8    64   128   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   56   56    8   128   256   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   28   28    8   256   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   14   14    8   512   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}    7    7    8   512   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  224  224   16     3    64   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  112  112   16    64   128   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   56   56   16   128   256   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   28   28   16   256   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   14   14   16   512   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}    7    7   16   512   512   3   3  1  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}  224  224   16     3    64   7   7  3  2
${NUMACTL} ./layer_example_${BIN} ${ITERS}   28   28   16   192    32   5   5  2  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   28   28   16   192    64   1   1  0  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   14   14   16   512    48   5   5  2  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}   14   14   16   512   192   1   1  0  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}    7    7   16   832   256   1   1  0  1
${NUMACTL} ./layer_example_${BIN} ${ITERS}    7    7   16   832   128   5   5  2  1

