/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_c_ccdf.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t15, t17, t23;
  double t24, t27, tzk0;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->c2 * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t6 = params->c1 * t5;
  t7 = M_CBRT2;
  t8 = M_CBRT6;
  t9 = t8 * t8;
  t10 = t7 * t9;
  t11 = M_PI * M_PI;
  t12 = POW_1_3(t11);
  t13 = 0.1e1 / t12;
  t14 = sqrt(sigma[0]);
  t15 = t13 * t14;
  t17 = 0.1e1 / t1 / rho[0];
  t23 = exp(-params->c4 * (t10 * t15 * t17 / 0.12e2 - params->c5));
  t24 = 0.1e1 + t23;
  t27 = 0.1e1 - params->c3 / t24;
  tzk0 = t6 * t27;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t15, t17, t23;
  double t24, t27, tzk0;

  double t28, t29, t30, t36, t37, t38, t39, t40;
  double t42, tvrho0, t47, t48, t51, tvsigma0;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->c2 * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t6 = params->c1 * t5;
  t7 = M_CBRT2;
  t8 = M_CBRT6;
  t9 = t8 * t8;
  t10 = t7 * t9;
  t11 = M_PI * M_PI;
  t12 = POW_1_3(t11);
  t13 = 0.1e1 / t12;
  t14 = sqrt(sigma[0]);
  t15 = t13 * t14;
  t17 = 0.1e1 / t1 / rho[0];
  t23 = exp(-params->c4 * (t10 * t15 * t17 / 0.12e2 - params->c5));
  t24 = 0.1e1 + t23;
  t27 = 0.1e1 - params->c3 / t24;
  tzk0 = t6 * t27;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t28 = t2 * params->c1;
  t29 = t4 * t4;
  t30 = 0.1e1 / t29;
  t36 = t5 * params->c3;
  t37 = t24 * t24;
  t38 = 0.1e1 / t37;
  t39 = t36 * t38;
  t40 = t17 * params->c1 * t39;
  t42 = params->c4 * t7 * t9;
  tvrho0 = tzk0 + t28 * t30 * t27 * params->c2 / 0.3e1 + t40 * t42 * t15 * t23 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t47 = t28 * t39;
  t48 = 0.1e1 / t14;
  t51 = t42 * t13 * t48 * t23;
  tvsigma0 = -t47 * t51 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t15, t17, t23;
  double t24, t27, tzk0;

  double t28, t29, t30, t36, t37, t38, t39, t40;
  double t42, tvrho0, t47, t48, t51, tvsigma0;

  double t54, t55, t59, t60, t61, t62, t63, t65;
  double t71, t74, t76, t78, t83, t84, t86, t87;
  double t88, t92, t94, t95, t97, t98, t99, t100;
  double t101, t102, t103, t104, t105, t106, t107, t112;
  double tv2rho20, t120, t121, t122, t123, t126, t127, t129;
  double t132, t134, tv2rhosigma0, t137, t138, t139, t141, t144;
  double t145, t148, t151, t153, tv2sigma20;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->c2 * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t6 = params->c1 * t5;
  t7 = M_CBRT2;
  t8 = M_CBRT6;
  t9 = t8 * t8;
  t10 = t7 * t9;
  t11 = M_PI * M_PI;
  t12 = POW_1_3(t11);
  t13 = 0.1e1 / t12;
  t14 = sqrt(sigma[0]);
  t15 = t13 * t14;
  t17 = 0.1e1 / t1 / rho[0];
  t23 = exp(-params->c4 * (t10 * t15 * t17 / 0.12e2 - params->c5));
  t24 = 0.1e1 + t23;
  t27 = 0.1e1 - params->c3 / t24;
  tzk0 = t6 * t27;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t28 = t2 * params->c1;
  t29 = t4 * t4;
  t30 = 0.1e1 / t29;
  t36 = t5 * params->c3;
  t37 = t24 * t24;
  t38 = 0.1e1 / t37;
  t39 = t36 * t38;
  t40 = t17 * params->c1 * t39;
  t42 = params->c4 * t7 * t9;
  tvrho0 = tzk0 + t28 * t30 * t27 * params->c2 / 0.3e1 + t40 * t42 * t15 * t23 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t47 = t28 * t39;
  t48 = 0.1e1 / t14;
  t51 = t42 * t13 * t48 * t23;
  tvsigma0 = -t47 * t51 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t54 = params->c1 * t30;
  t55 = t27 * params->c2;
  t59 = params->c3 * t38;
  t60 = t59 * params->c4;
  t61 = t6 * t60;
  t62 = t10 * t13;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t1 / t63;
  t71 = t1 * t1;
  t74 = 0.1e1 / t71 / rho[0] * params->c1;
  t76 = 0.1e1 / t29 / t4;
  t78 = params->c2 * params->c2;
  t83 = 0.1e1 / t71 / t63;
  t84 = t83 * params->c1;
  t86 = t84 * t30 * t60;
  t87 = t14 * t23;
  t88 = t87 * params->c2;
  t92 = t63 * rho[0];
  t94 = 0.1e1 / t71 / t92;
  t95 = t94 * params->c1;
  t97 = 0.1e1 / t37 / t24;
  t98 = t36 * t97;
  t99 = t95 * t98;
  t100 = params->c4 * params->c4;
  t101 = t7 * t7;
  t102 = t100 * t101;
  t103 = t102 * t8;
  t104 = t12 * t12;
  t105 = 0.1e1 / t104;
  t106 = t105 * sigma[0];
  t107 = t23 * t23;
  t112 = t95 * t39;
  tv2rho20 = 0.2e1 / 0.9e1 * t54 * t55 * t17 - t61 * t62 * t14 * t65 * t23 / 0.27e2 + 0.2e1 / 0.9e1 * t74 * t76 * t27 * t78 + 0.2e1 / 0.27e2 * t86 * t62 * t88 - 0.4e1 / 0.27e2 * t99 * t103 * t106 * t107 + 0.2e1 / 0.27e2 * t112 * t103 * t106 * t23;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t120 = t74 * t30 * t60;
  t121 = t48 * t23;
  t122 = t121 * params->c2;
  t123 = t62 * t122;
  t126 = t84 * t98;
  t127 = t8 * t105;
  t129 = t102 * t127 * t107;
  t132 = t84 * t39;
  t134 = t102 * t127 * t23;
  tv2rhosigma0 = t40 * t51 / 0.72e2 - t120 * t123 / 0.72e2 + t126 * t129 / 0.18e2 - t132 * t134 / 0.36e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t137 = t74 * t98;
  t138 = 0.1e1 / sigma[0];
  t139 = t105 * t138;
  t141 = t103 * t139 * t107;
  t144 = t14 * sigma[0];
  t145 = 0.1e1 / t144;
  t148 = t42 * t13 * t145 * t23;
  t151 = t74 * t39;
  t153 = t103 * t139 * t23;
  tv2sigma20 = -t137 * t141 / 0.48e2 + t47 * t148 / 0.48e2 + t151 * t153 / 0.96e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t15, t17, t23;
  double t24, t27, tzk0;

  double t28, t29, t30, t36, t37, t38, t39, t40;
  double t42, tvrho0, t47, t48, t51, tvsigma0;

  double t54, t55, t59, t60, t61, t62, t63, t65;
  double t71, t74, t76, t78, t83, t84, t86, t87;
  double t88, t92, t94, t95, t97, t98, t99, t100;
  double t101, t102, t103, t104, t105, t106, t107, t112;
  double tv2rho20, t120, t121, t122, t123, t126, t127, t129;
  double t132, t134, tv2rhosigma0, t137, t138, t139, t141, t144;
  double t145, t148, t151, t153, tv2sigma20;

  double t156, t157, t161, t163, t164, t165, t166, t175;
  double t176, t177, t179, t180, t182, t183, t189, t195;
  double t196, t202, t203, t204, t206, t210, t211, t213;
  double t218, t219, t220, t221, t223, t229, t234, t235;
  double t237, t238, t239, t240, t241, t242, t243, t244;
  double t249, t254, tv3rho30, t260, t270, t272, t275, t276;
  double t278, t280, t283, t285, t287, t290, t291, t293;
  double t296, t298, t303, tv3rho2sigma0, t308, t309, t310, t312;
  double t315, t316, t318, t322, t327, t328, t329, t334;
  double t335, t337, t341, tv3rhosigma20, t344, t345, t347, t350;
  double t351, t352, t354, t358, t362, t365, t369, t373;
  double tv3sigma30;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->c2 * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t6 = params->c1 * t5;
  t7 = M_CBRT2;
  t8 = M_CBRT6;
  t9 = t8 * t8;
  t10 = t7 * t9;
  t11 = M_PI * M_PI;
  t12 = POW_1_3(t11);
  t13 = 0.1e1 / t12;
  t14 = sqrt(sigma[0]);
  t15 = t13 * t14;
  t17 = 0.1e1 / t1 / rho[0];
  t23 = exp(-params->c4 * (t10 * t15 * t17 / 0.12e2 - params->c5));
  t24 = 0.1e1 + t23;
  t27 = 0.1e1 - params->c3 / t24;
  tzk0 = t6 * t27;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t28 = t2 * params->c1;
  t29 = t4 * t4;
  t30 = 0.1e1 / t29;
  t36 = t5 * params->c3;
  t37 = t24 * t24;
  t38 = 0.1e1 / t37;
  t39 = t36 * t38;
  t40 = t17 * params->c1 * t39;
  t42 = params->c4 * t7 * t9;
  tvrho0 = tzk0 + t28 * t30 * t27 * params->c2 / 0.3e1 + t40 * t42 * t15 * t23 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t47 = t28 * t39;
  t48 = 0.1e1 / t14;
  t51 = t42 * t13 * t48 * t23;
  tvsigma0 = -t47 * t51 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t54 = params->c1 * t30;
  t55 = t27 * params->c2;
  t59 = params->c3 * t38;
  t60 = t59 * params->c4;
  t61 = t6 * t60;
  t62 = t10 * t13;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t1 / t63;
  t71 = t1 * t1;
  t74 = 0.1e1 / t71 / rho[0] * params->c1;
  t76 = 0.1e1 / t29 / t4;
  t78 = params->c2 * params->c2;
  t83 = 0.1e1 / t71 / t63;
  t84 = t83 * params->c1;
  t86 = t84 * t30 * t60;
  t87 = t14 * t23;
  t88 = t87 * params->c2;
  t92 = t63 * rho[0];
  t94 = 0.1e1 / t71 / t92;
  t95 = t94 * params->c1;
  t97 = 0.1e1 / t37 / t24;
  t98 = t36 * t97;
  t99 = t95 * t98;
  t100 = params->c4 * params->c4;
  t101 = t7 * t7;
  t102 = t100 * t101;
  t103 = t102 * t8;
  t104 = t12 * t12;
  t105 = 0.1e1 / t104;
  t106 = t105 * sigma[0];
  t107 = t23 * t23;
  t112 = t95 * t39;
  tv2rho20 = 0.2e1 / 0.9e1 * t54 * t55 * t17 - t61 * t62 * t14 * t65 * t23 / 0.27e2 + 0.2e1 / 0.9e1 * t74 * t76 * t27 * t78 + 0.2e1 / 0.27e2 * t86 * t62 * t88 - 0.4e1 / 0.27e2 * t99 * t103 * t106 * t107 + 0.2e1 / 0.27e2 * t112 * t103 * t106 * t23;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t120 = t74 * t30 * t60;
  t121 = t48 * t23;
  t122 = t121 * params->c2;
  t123 = t62 * t122;
  t126 = t84 * t98;
  t127 = t8 * t105;
  t129 = t102 * t127 * t107;
  t132 = t84 * t39;
  t134 = t102 * t127 * t23;
  tv2rhosigma0 = t40 * t51 / 0.72e2 - t120 * t123 / 0.72e2 + t126 * t129 / 0.18e2 - t132 * t134 / 0.36e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t137 = t74 * t98;
  t138 = 0.1e1 / sigma[0];
  t139 = t105 * t138;
  t141 = t103 * t139 * t107;
  t144 = t14 * sigma[0];
  t145 = 0.1e1 / t144;
  t148 = t42 * t13 * t145 * t23;
  t151 = t74 * t39;
  t153 = t103 * t139 * t23;
  tv2sigma20 = -t137 * t141 / 0.48e2 + t47 * t148 / 0.48e2 + t151 * t153 / 0.96e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t156 = params->c1 * t76;
  t157 = t27 * t78;
  t161 = t54 * params->c3;
  t163 = t38 * params->c4 * t7;
  t164 = t161 * t163;
  t165 = t9 * t13;
  t166 = t165 * t14;
  t175 = params->c3 * t97;
  t176 = t175 * t100;
  t177 = t6 * t176;
  t179 = t101 * t8 * t105;
  t180 = t63 * t63;
  t182 = 0.1e1 / t71 / t180;
  t183 = sigma[0] * t182;
  t189 = 0.1e1 / t1 / t92;
  t195 = t59 * t100;
  t196 = t6 * t195;
  t202 = 0.1e1 / t92 * params->c1;
  t203 = t29 * t29;
  t204 = 0.1e1 / t203;
  t206 = t78 * params->c2;
  t210 = 0.1e1 / t180;
  t211 = t210 * params->c1;
  t213 = t211 * t76 * t60;
  t218 = t180 * rho[0];
  t219 = 0.1e1 / t218;
  t220 = t219 * params->c1;
  t221 = t220 * t30;
  t223 = sigma[0] * t107;
  t229 = sigma[0] * t23;
  t234 = t180 * t63;
  t235 = 0.1e1 / t234;
  t237 = t235 * params->c1 * t36;
  t238 = t37 * t37;
  t239 = 0.1e1 / t238;
  t240 = t100 * params->c4;
  t241 = t239 * t240;
  t242 = 0.1e1 / t11;
  t243 = t242 * t144;
  t244 = t107 * t23;
  t249 = t97 * t240;
  t254 = t38 * t240;
  tv3rho30 = -0.2e1 / 0.9e1 * t156 * t157 * t83 - 0.5e1 / 0.27e2 * t164 * t166 * t94 * t23 * params->c2 - 0.8e1 / 0.27e2 * t54 * t55 * t65 + 0.16e2 / 0.27e2 * t177 * t179 * t183 * t107 + 0.7e1 / 0.81e2 * t61 * t62 * t14 * t189 * t23 - 0.8e1 / 0.27e2 * t196 * t179 * t183 * t23 + 0.2e1 / 0.9e1 * t202 * t204 * t27 * t206 + 0.2e1 / 0.27e2 * t213 * t62 * t87 * t78 - 0.4e1 / 0.27e2 * t221 * t176 * t179 * t223 * params->c2 + 0.2e1 / 0.27e2 * t221 * t195 * t179 * t229 * params->c2 + 0.16e2 / 0.27e2 * t237 * t241 * t243 * t244 - 0.16e2 / 0.27e2 * t237 * t249 * t243 * t107 + 0.8e1 / 0.81e2 * t237 * t254 * t243 * t23;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t260 = t65 * params->c1 * t39;
  t270 = t202 * t76 * t60;
  t272 = t62 * t121 * t78;
  t275 = t30 * params->c3;
  t276 = t275 * t97;
  t278 = t105 * t107;
  t280 = t103 * t278 * params->c2;
  t283 = t275 * t38;
  t285 = t105 * t23;
  t287 = t103 * t285 * params->c2;
  t290 = t220 * t36;
  t291 = t242 * t244;
  t293 = t241 * t291 * t14;
  t296 = t242 * t107;
  t298 = t249 * t296 * t14;
  t303 = t254 * t242 * t14 * t23;
  tv3rho2sigma0 = -t260 * t51 / 0.54e2 + t86 * t123 / 0.36e2 - t99 * t129 / 0.6e1 + t112 * t134 / 0.12e2 - t270 * t272 / 0.108e3 + t211 * t276 * t280 / 0.27e2 - t211 * t283 * t287 / 0.54e2 - 0.2e1 / 0.9e1 * t290 * t293 + 0.2e1 / 0.9e1 * t290 * t298 - t290 * t303 / 0.27e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t308 = t202 * t30;
  t309 = t308 * t176;
  t310 = t138 * t107;
  t312 = t179 * t310 * params->c2;
  t315 = t211 * t36;
  t316 = t242 * t48;
  t318 = t241 * t316 * t244;
  t322 = t249 * t316 * t107;
  t327 = t145 * t23;
  t328 = t327 * params->c2;
  t329 = t62 * t328;
  t334 = t308 * t195;
  t335 = t138 * t23;
  t337 = t179 * t335 * params->c2;
  t341 = t254 * t316 * t23;
  tv3rhosigma20 = t126 * t141 / 0.144e3 - t309 * t312 / 0.144e3 + t315 * t318 / 0.12e2 - t315 * t322 / 0.12e2 - t40 * t148 / 0.144e3 + t120 * t329 / 0.144e3 - t132 * t153 / 0.288e3 + t334 * t337 / 0.288e3 + t315 * t341 / 0.72e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t344 = t202 * t36;
  t345 = t242 * t145;
  t347 = t241 * t345 * t244;
  t350 = sigma[0] * sigma[0];
  t351 = 0.1e1 / t350;
  t352 = t105 * t351;
  t354 = t103 * t352 * t107;
  t358 = t249 * t345 * t107;
  t362 = 0.1e1 / t14 / t350;
  t365 = t42 * t13 * t362 * t23;
  t369 = t103 * t352 * t23;
  t373 = t254 * t345 * t23;
  tv3sigma30 = -t344 * t347 / 0.32e2 + t137 * t354 / 0.32e2 + t344 * t358 / 0.32e2 - t47 * t365 / 0.32e2 - t151 * t369 / 0.64e2 - t344 * t373 / 0.192e3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t15, t17, t23;
  double t24, t27, tzk0;

  double t28, t29, t30, t36, t37, t38, t39, t40;
  double t42, tvrho0, t47, t48, t51, tvsigma0;

  double t54, t55, t59, t60, t61, t62, t63, t65;
  double t71, t74, t76, t78, t83, t84, t86, t87;
  double t88, t92, t94, t95, t97, t98, t99, t100;
  double t101, t102, t103, t104, t105, t106, t107, t112;
  double tv2rho20, t120, t121, t122, t123, t126, t127, t129;
  double t132, t134, tv2rhosigma0, t137, t138, t139, t141, t144;
  double t145, t148, t151, t153, tv2sigma20;

  double t156, t157, t161, t163, t164, t165, t166, t175;
  double t176, t177, t179, t180, t182, t183, t189, t195;
  double t196, t202, t203, t204, t206, t210, t211, t213;
  double t218, t219, t220, t221, t223, t229, t234, t235;
  double t237, t238, t239, t240, t241, t242, t243, t244;
  double t249, t254, tv3rho30, t260, t270, t272, t275, t276;
  double t278, t280, t283, t285, t287, t290, t291, t293;
  double t296, t298, t303, tv3rho2sigma0, t308, t309, t310, t312;
  double t315, t316, t318, t322, t327, t328, t329, t334;
  double t335, t337, t341, tv3rhosigma20, t344, t345, t347, t350;
  double t351, t352, t354, t358, t362, t365, t369, t373;
  double tv3sigma30;

  double t376, t378, t379, t381, t401, t417, t423, t431;
  double t440, t441, t452, t456, t458, t460, t461, t463;
  double t464, t469, t475, t476, t482, t485, t506, t507;
  double t531, t535, t544, tv4rho40, t561, t590, t603, tv4rho3sigma0;
  double t634, t638, t662, tv4rho2sigma20, t715, t717, tv4rhosigma30, t772;
  double t774, t779, t789, t791, tv4sigma40;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->c2 * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t6 = params->c1 * t5;
  t7 = M_CBRT2;
  t8 = M_CBRT6;
  t9 = t8 * t8;
  t10 = t7 * t9;
  t11 = M_PI * M_PI;
  t12 = POW_1_3(t11);
  t13 = 0.1e1 / t12;
  t14 = sqrt(sigma[0]);
  t15 = t13 * t14;
  t17 = 0.1e1 / t1 / rho[0];
  t23 = exp(-params->c4 * (t10 * t15 * t17 / 0.12e2 - params->c5));
  t24 = 0.1e1 + t23;
  t27 = 0.1e1 - params->c3 / t24;
  tzk0 = t6 * t27;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t28 = t2 * params->c1;
  t29 = t4 * t4;
  t30 = 0.1e1 / t29;
  t36 = t5 * params->c3;
  t37 = t24 * t24;
  t38 = 0.1e1 / t37;
  t39 = t36 * t38;
  t40 = t17 * params->c1 * t39;
  t42 = params->c4 * t7 * t9;
  tvrho0 = tzk0 + t28 * t30 * t27 * params->c2 / 0.3e1 + t40 * t42 * t15 * t23 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t47 = t28 * t39;
  t48 = 0.1e1 / t14;
  t51 = t42 * t13 * t48 * t23;
  tvsigma0 = -t47 * t51 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t54 = params->c1 * t30;
  t55 = t27 * params->c2;
  t59 = params->c3 * t38;
  t60 = t59 * params->c4;
  t61 = t6 * t60;
  t62 = t10 * t13;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t1 / t63;
  t71 = t1 * t1;
  t74 = 0.1e1 / t71 / rho[0] * params->c1;
  t76 = 0.1e1 / t29 / t4;
  t78 = params->c2 * params->c2;
  t83 = 0.1e1 / t71 / t63;
  t84 = t83 * params->c1;
  t86 = t84 * t30 * t60;
  t87 = t14 * t23;
  t88 = t87 * params->c2;
  t92 = t63 * rho[0];
  t94 = 0.1e1 / t71 / t92;
  t95 = t94 * params->c1;
  t97 = 0.1e1 / t37 / t24;
  t98 = t36 * t97;
  t99 = t95 * t98;
  t100 = params->c4 * params->c4;
  t101 = t7 * t7;
  t102 = t100 * t101;
  t103 = t102 * t8;
  t104 = t12 * t12;
  t105 = 0.1e1 / t104;
  t106 = t105 * sigma[0];
  t107 = t23 * t23;
  t112 = t95 * t39;
  tv2rho20 = 0.2e1 / 0.9e1 * t54 * t55 * t17 - t61 * t62 * t14 * t65 * t23 / 0.27e2 + 0.2e1 / 0.9e1 * t74 * t76 * t27 * t78 + 0.2e1 / 0.27e2 * t86 * t62 * t88 - 0.4e1 / 0.27e2 * t99 * t103 * t106 * t107 + 0.2e1 / 0.27e2 * t112 * t103 * t106 * t23;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t120 = t74 * t30 * t60;
  t121 = t48 * t23;
  t122 = t121 * params->c2;
  t123 = t62 * t122;
  t126 = t84 * t98;
  t127 = t8 * t105;
  t129 = t102 * t127 * t107;
  t132 = t84 * t39;
  t134 = t102 * t127 * t23;
  tv2rhosigma0 = t40 * t51 / 0.72e2 - t120 * t123 / 0.72e2 + t126 * t129 / 0.18e2 - t132 * t134 / 0.36e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t137 = t74 * t98;
  t138 = 0.1e1 / sigma[0];
  t139 = t105 * t138;
  t141 = t103 * t139 * t107;
  t144 = t14 * sigma[0];
  t145 = 0.1e1 / t144;
  t148 = t42 * t13 * t145 * t23;
  t151 = t74 * t39;
  t153 = t103 * t139 * t23;
  tv2sigma20 = -t137 * t141 / 0.48e2 + t47 * t148 / 0.48e2 + t151 * t153 / 0.96e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t156 = params->c1 * t76;
  t157 = t27 * t78;
  t161 = t54 * params->c3;
  t163 = t38 * params->c4 * t7;
  t164 = t161 * t163;
  t165 = t9 * t13;
  t166 = t165 * t14;
  t175 = params->c3 * t97;
  t176 = t175 * t100;
  t177 = t6 * t176;
  t179 = t101 * t8 * t105;
  t180 = t63 * t63;
  t182 = 0.1e1 / t71 / t180;
  t183 = sigma[0] * t182;
  t189 = 0.1e1 / t1 / t92;
  t195 = t59 * t100;
  t196 = t6 * t195;
  t202 = 0.1e1 / t92 * params->c1;
  t203 = t29 * t29;
  t204 = 0.1e1 / t203;
  t206 = t78 * params->c2;
  t210 = 0.1e1 / t180;
  t211 = t210 * params->c1;
  t213 = t211 * t76 * t60;
  t218 = t180 * rho[0];
  t219 = 0.1e1 / t218;
  t220 = t219 * params->c1;
  t221 = t220 * t30;
  t223 = sigma[0] * t107;
  t229 = sigma[0] * t23;
  t234 = t180 * t63;
  t235 = 0.1e1 / t234;
  t237 = t235 * params->c1 * t36;
  t238 = t37 * t37;
  t239 = 0.1e1 / t238;
  t240 = t100 * params->c4;
  t241 = t239 * t240;
  t242 = 0.1e1 / t11;
  t243 = t242 * t144;
  t244 = t107 * t23;
  t249 = t97 * t240;
  t254 = t38 * t240;
  tv3rho30 = -0.2e1 / 0.9e1 * t156 * t157 * t83 - 0.5e1 / 0.27e2 * t164 * t166 * t94 * t23 * params->c2 - 0.8e1 / 0.27e2 * t54 * t55 * t65 + 0.16e2 / 0.27e2 * t177 * t179 * t183 * t107 + 0.7e1 / 0.81e2 * t61 * t62 * t14 * t189 * t23 - 0.8e1 / 0.27e2 * t196 * t179 * t183 * t23 + 0.2e1 / 0.9e1 * t202 * t204 * t27 * t206 + 0.2e1 / 0.27e2 * t213 * t62 * t87 * t78 - 0.4e1 / 0.27e2 * t221 * t176 * t179 * t223 * params->c2 + 0.2e1 / 0.27e2 * t221 * t195 * t179 * t229 * params->c2 + 0.16e2 / 0.27e2 * t237 * t241 * t243 * t244 - 0.16e2 / 0.27e2 * t237 * t249 * t243 * t107 + 0.8e1 / 0.81e2 * t237 * t254 * t243 * t23;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t260 = t65 * params->c1 * t39;
  t270 = t202 * t76 * t60;
  t272 = t62 * t121 * t78;
  t275 = t30 * params->c3;
  t276 = t275 * t97;
  t278 = t105 * t107;
  t280 = t103 * t278 * params->c2;
  t283 = t275 * t38;
  t285 = t105 * t23;
  t287 = t103 * t285 * params->c2;
  t290 = t220 * t36;
  t291 = t242 * t244;
  t293 = t241 * t291 * t14;
  t296 = t242 * t107;
  t298 = t249 * t296 * t14;
  t303 = t254 * t242 * t14 * t23;
  tv3rho2sigma0 = -t260 * t51 / 0.54e2 + t86 * t123 / 0.36e2 - t99 * t129 / 0.6e1 + t112 * t134 / 0.12e2 - t270 * t272 / 0.108e3 + t211 * t276 * t280 / 0.27e2 - t211 * t283 * t287 / 0.54e2 - 0.2e1 / 0.9e1 * t290 * t293 + 0.2e1 / 0.9e1 * t290 * t298 - t290 * t303 / 0.27e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t308 = t202 * t30;
  t309 = t308 * t176;
  t310 = t138 * t107;
  t312 = t179 * t310 * params->c2;
  t315 = t211 * t36;
  t316 = t242 * t48;
  t318 = t241 * t316 * t244;
  t322 = t249 * t316 * t107;
  t327 = t145 * t23;
  t328 = t327 * params->c2;
  t329 = t62 * t328;
  t334 = t308 * t195;
  t335 = t138 * t23;
  t337 = t179 * t335 * params->c2;
  t341 = t254 * t316 * t23;
  tv3rhosigma20 = t126 * t141 / 0.144e3 - t309 * t312 / 0.144e3 + t315 * t318 / 0.12e2 - t315 * t322 / 0.12e2 - t40 * t148 / 0.144e3 + t120 * t329 / 0.144e3 - t132 * t153 / 0.288e3 + t334 * t337 / 0.288e3 + t315 * t341 / 0.72e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t344 = t202 * t36;
  t345 = t242 * t145;
  t347 = t241 * t345 * t244;
  t350 = sigma[0] * sigma[0];
  t351 = 0.1e1 / t350;
  t352 = t105 * t351;
  t354 = t103 * t352 * t107;
  t358 = t249 * t345 * t107;
  t362 = 0.1e1 / t14 / t350;
  t365 = t42 * t13 * t362 * t23;
  t369 = t103 * t352 * t23;
  t373 = t254 * t345 * t23;
  tv3sigma30 = -t344 * t347 / 0.32e2 + t137 * t354 / 0.32e2 + t344 * t358 / 0.32e2 - t47 * t365 / 0.32e2 - t151 * t369 / 0.64e2 - t344 * t373 / 0.192e3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t376 = params->c3 * t239;
  t378 = t240 * t242;
  t379 = t180 * t92;
  t381 = t144 / t379;
  t401 = t127 * sigma[0];
  t417 = sigma[0] / t71 / t218;
  t423 = 0.1e1 / t1 / t180;
  t431 = 0.1e1 / t1 / t218 * params->c1;
  t440 = 0.1e1 / t1 / t234 * params->c1;
  t441 = t440 * t76;
  t452 = t180 * t180;
  t456 = 0.1e1 / t1 / t452 * params->c1 * t5;
  t458 = 0.1e1 / t238 / t24;
  t460 = t100 * t100;
  t461 = params->c3 * t458 * t460;
  t463 = t242 * t350;
  t464 = t107 * t107;
  t469 = t376 * t460;
  t475 = -0.16e3 / 0.27e2 * t6 * t376 * t378 * t381 * t244 + 0.16e3 / 0.27e2 * t6 * t175 * t378 * t381 * t107 - 0.4e1 / 0.9e1 * t156 * params->c3 * t163 * t166 * t219 * t23 * t78 + 0.32e2 / 0.27e2 * t161 * t97 * t100 * t101 * t401 * t235 * t107 * params->c2 - 0.16e2 / 0.27e2 * t161 * t38 * t100 * t101 * t401 * t235 * t23 * params->c2 - 0.7e3 / 0.243e3 * t177 * t179 * t417 * t107 - 0.7e2 / 0.243e3 * t61 * t62 * t14 * t423 * t23 + 0.8e1 / 0.81e2 * t431 * t204 * t60 * t62 * t87 * t206 - 0.16e2 / 0.81e2 * t441 * t176 * t179 * t223 * t78 + 0.8e1 / 0.81e2 * t441 * t195 * t179 * t229 * t78 - 0.64e2 / 0.243e3 * t456 * t461 * t463 * t464 * t62 + 0.32e2 / 0.81e2 * t456 * t469 * t463 * t244 * t62;
  t476 = t175 * t460;
  t482 = t59 * t460;
  t485 = t165 * t23;
  t506 = 0.1e1 / t1 / t379 * params->c1;
  t507 = t275 * t239;
  t531 = t423 * params->c1;
  t535 = t78 * t78;
  t544 = -0.112e3 / 0.729e3 * t456 * t476 * t463 * t107 * t62 + 0.8e1 / 0.729e3 * t456 * t482 * t463 * t7 * t485 + 0.32e2 / 0.81e2 * t156 * t157 * t94 + 0.56e2 / 0.81e2 * t54 * t55 * t189 + 0.35e3 / 0.243e3 * t196 * t179 * t417 * t23 + 0.164e3 / 0.243e3 * t164 * t166 * t182 * t23 * params->c2 + 0.64e2 / 0.81e2 * t506 * t507 * t378 * t144 * t244 * params->c2 - 0.64e2 / 0.81e2 * t506 * t276 * t378 * t144 * t107 * params->c2 + 0.32e2 / 0.243e3 * t506 * t283 * t378 * t144 * t23 * params->c2 - 0.8e1 / 0.9e1 * params->c1 * t204 * t27 * t206 * t210 + 0.8e1 / 0.27e2 * t531 / t203 / t4 * t27 * t535 - 0.8e2 / 0.81e2 * t6 * t59 * t378 * t381 * t23;
  tv4rho40 = t475 + t544;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t561 = t506 * t5;
  t590 = t76 * params->c3;
  t603 = t182 * params->c1;
  tv4rho3sigma0 = 0.7e1 / 0.162e3 * t189 * params->c1 * t39 * t51 - 0.13e2 / 0.162e3 * t95 * t30 * t60 * t123 + 0.5e1 / 0.108e3 * t213 * t272 - t531 * t204 * t60 * t62 * t121 * t206 / 0.108e3 + 0.8e1 / 0.81e2 * t561 * t461 * t242 * t464 * sigma[0] * t62 - 0.4e1 / 0.27e2 * t561 * t469 * t291 * sigma[0] * t62 + 0.14e2 / 0.243e3 * t561 * t476 * t296 * sigma[0] * t62 - t561 * t482 * t242 * sigma[0] * t7 * t485 / 0.243e3 - 0.13e2 / 0.54e2 * t220 * t276 * t280 + 0.13e2 / 0.108e3 * t220 * t283 * t287 + t431 * t590 * t97 * t103 * t278 * t78 / 0.27e2 - t431 * t590 * t38 * t103 * t285 * t78 / 0.54e2 + 0.103e3 / 0.162e3 * t603 * t98 * t129 - 0.103e3 / 0.324e3 * t603 * t39 * t134 - 0.2e1 / 0.9e1 * t440 * t507 * t378 * t244 * params->c2 * t14 + 0.2e1 / 0.9e1 * t440 * t276 * t378 * t107 * params->c2 * t14 - t440 * t283 * t378 * t88 / 0.27e2 + 0.16e2 / 0.9e1 * t237 * t293 - 0.16e2 / 0.9e1 * t237 * t298 + 0.8e1 / 0.27e2 * t237 * t303;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t634 = t211 * t30;
  t638 = t531 * t76;
  t662 = t460 * t242;
  tv4rho2sigma20 = -t99 * t141 / 0.108e3 + t634 * t176 * t312 / 0.72e2 - t638 * t176 * t179 * t310 * t78 / 0.216e3 + t260 * t148 / 0.108e3 - t86 * t329 / 0.72e2 + t270 * t62 * t327 * t78 / 0.216e3 - t634 * t195 * t337 / 0.144e3 + t638 * t195 * t179 * t335 * t78 / 0.432e3 - t440 * t36 * t458 * t662 * t464 * t62 / 0.27e2 + t440 * t36 * t239 * t662 * t244 * t62 / 0.18e2 - 0.7e1 / 0.324e3 * t440 * t98 * t662 * t107 * t62 + t112 * t153 / 0.216e3 + t440 * t39 * t662 * t7 * t485 / 0.648e3 + t431 * t507 * t378 * t48 * t244 * params->c2 / 0.18e2 - t431 * t276 * t378 * t48 * t107 * params->c2 / 0.18e2 + t431 * t283 * t378 * t122 / 0.108e3 - 0.13e2 / 0.36e2 * t290 * t318 + 0.13e2 / 0.36e2 * t290 * t322 - 0.13e2 / 0.216e3 * t290 * t341;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t715 = t431 * t5;
  t717 = t242 * t138;
  tv4rhosigma30 = -t315 * t347 / 0.32e2 - t531 * t507 * t378 * t145 * t244 * params->c2 / 0.96e2 + t715 * t461 * t717 * t464 * t62 / 0.72e2 - t715 * t469 * t717 * t244 * t62 / 0.48e2 - t126 * t354 / 0.96e2 + t309 * t179 * t351 * t107 * params->c2 / 0.96e2 + t315 * t358 / 0.32e2 + t531 * t276 * t378 * t145 * t107 * params->c2 / 0.96e2 + 0.7e1 / 0.864e3 * t715 * t476 * t717 * t107 * t62 + t40 * t365 / 0.96e2 - t120 * t62 * t362 * t23 * params->c2 / 0.96e2 + t132 * t369 / 0.192e3 - t334 * t179 * t351 * t23 * params->c2 / 0.192e3 - t315 * t373 / 0.192e3 - t531 * t283 * t378 * t328 / 0.576e3 - t715 * t482 * t717 * t7 * t485 / 0.1728e4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t772 = t531 * t5;
  t774 = t242 * t351;
  t779 = t242 * t362;
  t789 = t350 * sigma[0];
  t791 = t105 / t789;
  tv4sigma40 = -t772 * t461 * t774 * t464 * t62 / 0.192e3 + 0.3e1 / 0.32e2 * t344 * t241 * t779 * t244 + t772 * t469 * t774 * t244 * t62 / 0.128e3 - 0.5e1 / 0.64e2 * t137 * t103 * t791 * t107 - 0.3e1 / 0.32e2 * t344 * t249 * t779 * t107 - 0.7e1 / 0.2304e4 * t772 * t476 * t774 * t107 * t62 + 0.5e1 / 0.64e2 * t47 * t42 * t13 / t14 / t789 * t23 + 0.5e1 / 0.128e3 * t151 * t103 * t791 * t23 + t344 * t254 * t779 * t23 / 0.64e2 + t772 * t482 * t774 * t7 * t485 / 0.4608e4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t16, t17, t18;
  double t20, t26, t27, t30, tzk0;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = POW_1_3(t1);
  t3 = 0.1e1 / t2;
  t5 = params->c2 * t3 + 0.1e1;
  t6 = 0.1e1 / t5;
  t7 = params->c1 * t6;
  t8 = M_CBRT2;
  t9 = M_CBRT6;
  t10 = t9 * t9;
  t11 = t8 * t10;
  t12 = M_PI * M_PI;
  t13 = POW_1_3(t12);
  t14 = 0.1e1 / t13;
  t16 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t17 = sqrt(t16);
  t18 = t14 * t17;
  t20 = 0.1e1 / t2 / t1;
  t26 = exp(-params->c4 * (t11 * t18 * t20 / 0.12e2 - params->c5));
  t27 = 0.1e1 + t26;
  t30 = 0.1e1 - params->c3 / t27;
  tzk0 = t7 * t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t16, t17, t18;
  double t20, t26, t27, t30, tzk0;

  double t31, t32, t33, t39, t40, t41, t42, t43;
  double t45, tvrho0, tvrho1, t50, t51, t54, t55, tvsigma0;
  double tvsigma1, tvsigma2;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = POW_1_3(t1);
  t3 = 0.1e1 / t2;
  t5 = params->c2 * t3 + 0.1e1;
  t6 = 0.1e1 / t5;
  t7 = params->c1 * t6;
  t8 = M_CBRT2;
  t9 = M_CBRT6;
  t10 = t9 * t9;
  t11 = t8 * t10;
  t12 = M_PI * M_PI;
  t13 = POW_1_3(t12);
  t14 = 0.1e1 / t13;
  t16 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t17 = sqrt(t16);
  t18 = t14 * t17;
  t20 = 0.1e1 / t2 / t1;
  t26 = exp(-params->c4 * (t11 * t18 * t20 / 0.12e2 - params->c5));
  t27 = 0.1e1 + t26;
  t30 = 0.1e1 - params->c3 / t27;
  tzk0 = t7 * t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t31 = t3 * params->c1;
  t32 = t5 * t5;
  t33 = 0.1e1 / t32;
  t39 = t6 * params->c3;
  t40 = t27 * t27;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t43 = t20 * params->c1 * t42;
  t45 = params->c4 * t8 * t10;
  tvrho0 = tzk0 + t31 * t33 * t30 * params->c2 / 0.3e1 + t43 * t45 * t18 * t26 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = tvrho0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t50 = t31 * t42;
  t51 = 0.1e1 / t17;
  t54 = t45 * t14 * t51 * t26;
  t55 = t50 * t54;
  tvsigma0 = -t55 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = -t55 / 0.12e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t16, t17, t18;
  double t20, t26, t27, t30, tzk0;

  double t31, t32, t33, t39, t40, t41, t42, t43;
  double t45, tvrho0, tvrho1, t50, t51, t54, t55, tvsigma0;
  double tvsigma1, tvsigma2;

  double t58, t59, t63, t64, t65, t66, t67, t69;
  double t75, t78, t80, t82, t87, t88, t90, t91;
  double t92, t96, t98, t99, t101, t102, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t116;
  double tv2rho20, tv2rho21, tv2rho22, t121, t124, t125, t126, t127;
  double t128, t130, t131, t133, t134, t136, t138, t139;
  double tv2rhosigma0, tv2rhosigma1, tv2rhosigma2, tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t145, t146;
  double t147, t149, t150, t152, t153, t156, t157, t159;
  double t161, t162, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = POW_1_3(t1);
  t3 = 0.1e1 / t2;
  t5 = params->c2 * t3 + 0.1e1;
  t6 = 0.1e1 / t5;
  t7 = params->c1 * t6;
  t8 = M_CBRT2;
  t9 = M_CBRT6;
  t10 = t9 * t9;
  t11 = t8 * t10;
  t12 = M_PI * M_PI;
  t13 = POW_1_3(t12);
  t14 = 0.1e1 / t13;
  t16 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t17 = sqrt(t16);
  t18 = t14 * t17;
  t20 = 0.1e1 / t2 / t1;
  t26 = exp(-params->c4 * (t11 * t18 * t20 / 0.12e2 - params->c5));
  t27 = 0.1e1 + t26;
  t30 = 0.1e1 - params->c3 / t27;
  tzk0 = t7 * t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t31 = t3 * params->c1;
  t32 = t5 * t5;
  t33 = 0.1e1 / t32;
  t39 = t6 * params->c3;
  t40 = t27 * t27;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t43 = t20 * params->c1 * t42;
  t45 = params->c4 * t8 * t10;
  tvrho0 = tzk0 + t31 * t33 * t30 * params->c2 / 0.3e1 + t43 * t45 * t18 * t26 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = tvrho0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t50 = t31 * t42;
  t51 = 0.1e1 / t17;
  t54 = t45 * t14 * t51 * t26;
  t55 = t50 * t54;
  tvsigma0 = -t55 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = -t55 / 0.12e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t58 = params->c1 * t33;
  t59 = t30 * params->c2;
  t63 = params->c3 * t41;
  t64 = t63 * params->c4;
  t65 = t7 * t64;
  t66 = t11 * t14;
  t67 = t1 * t1;
  t69 = 0.1e1 / t2 / t67;
  t75 = t2 * t2;
  t78 = 0.1e1 / t75 / t1 * params->c1;
  t80 = 0.1e1 / t32 / t5;
  t82 = params->c2 * params->c2;
  t87 = 0.1e1 / t75 / t67;
  t88 = t87 * params->c1;
  t90 = t88 * t33 * t64;
  t91 = t17 * t26;
  t92 = t91 * params->c2;
  t96 = t67 * t1;
  t98 = 0.1e1 / t75 / t96;
  t99 = t98 * params->c1;
  t101 = 0.1e1 / t40 / t27;
  t102 = t39 * t101;
  t103 = t99 * t102;
  t104 = params->c4 * params->c4;
  t105 = t8 * t8;
  t106 = t104 * t105;
  t107 = t106 * t9;
  t108 = t13 * t13;
  t109 = 0.1e1 / t108;
  t110 = t109 * t16;
  t111 = t26 * t26;
  t116 = t99 * t42;
  tv2rho20 = 0.2e1 / 0.9e1 * t58 * t59 * t20 - t65 * t66 * t17 * t69 * t26 / 0.27e2 + 0.2e1 / 0.9e1 * t78 * t80 * t30 * t82 + 0.2e1 / 0.27e2 * t90 * t66 * t92 - 0.4e1 / 0.27e2 * t103 * t107 * t110 * t111 + 0.2e1 / 0.27e2 * t116 * t107 * t110 * t26;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  tv2rho21 = tv2rho20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  tv2rho22 = tv2rho21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t121 = t43 * t54;
  t124 = t78 * t33 * t64;
  t125 = t51 * t26;
  t126 = t125 * params->c2;
  t127 = t66 * t126;
  t128 = t124 * t127;
  t130 = t88 * t102;
  t131 = t9 * t109;
  t133 = t106 * t131 * t111;
  t134 = t130 * t133;
  t136 = t88 * t42;
  t138 = t106 * t131 * t26;
  t139 = t136 * t138;
  tv2rhosigma0 = t121 / 0.72e2 - t128 / 0.72e2 + t134 / 0.18e2 - t139 / 0.36e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = t121 / 0.36e2 - t128 / 0.36e2 + t134 / 0.9e1 - t139 / 0.18e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  tv2rhosigma3 = tv2rhosigma2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = tv2rhosigma1;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t145 = t78 * t102;
  t146 = 0.1e1 / t16;
  t147 = t109 * t146;
  t149 = t107 * t147 * t111;
  t150 = t145 * t149;
  t152 = t17 * t16;
  t153 = 0.1e1 / t152;
  t156 = t45 * t14 * t153 * t26;
  t157 = t50 * t156;
  t159 = t78 * t42;
  t161 = t107 * t147 * t26;
  t162 = t159 * t161;
  tv2sigma20 = -t150 / 0.48e2 + t157 / 0.48e2 + t162 / 0.96e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = -t150 / 0.24e2 + t157 / 0.24e2 + t162 / 0.48e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = -t150 / 0.12e2 + t157 / 0.12e2 + t162 / 0.24e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t16, t17, t18;
  double t20, t26, t27, t30, tzk0;

  double t31, t32, t33, t39, t40, t41, t42, t43;
  double t45, tvrho0, tvrho1, t50, t51, t54, t55, tvsigma0;
  double tvsigma1, tvsigma2;

  double t58, t59, t63, t64, t65, t66, t67, t69;
  double t75, t78, t80, t82, t87, t88, t90, t91;
  double t92, t96, t98, t99, t101, t102, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t116;
  double tv2rho20, tv2rho21, tv2rho22, t121, t124, t125, t126, t127;
  double t128, t130, t131, t133, t134, t136, t138, t139;
  double tv2rhosigma0, tv2rhosigma1, tv2rhosigma2, tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t145, t146;
  double t147, t149, t150, t152, t153, t156, t157, t159;
  double t161, t162, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  double t170, t171, t175, t177, t178, t179, t180, t189;
  double t190, t191, t193, t194, t196, t197, t203, t209;
  double t210, t216, t217, t218, t220, t224, t225, t227;
  double t232, t233, t234, t235, t237, t243, t248, t249;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t263, t268, tv3rho30, tv3rho31, tv3rho32, tv3rho33, t274, t275;
  double t277, t279, t281, t284, t286, t287, t289, t290;
  double t292, t294, t295, t297, t299, t301, t302, t304;
  double t305, t307, t308, t310, t312, t313, t317, t318;
  double tv3rho2sigma0, tv3rho2sigma1, tv3rho2sigma2, tv3rho2sigma3, tv3rho2sigma4, tv3rho2sigma5, tv3rho2sigma6, tv3rho2sigma7;
  double tv3rho2sigma8, t330, t332, t333, t334, t336, t337, t339;
  double t340, t342, t343, t346, t347, t349, t351, t352;
  double t353, t354, t356, t358, t359, t361, t362, t365;
  double t366, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, tv3rhosigma26;
  double tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, t386, t387, t389;
  double t390, t392, t393, t394, t396, t397, t400, t401;
  double t404, t407, t408, t411, t412, t415, t416, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double tv3sigma39;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = POW_1_3(t1);
  t3 = 0.1e1 / t2;
  t5 = params->c2 * t3 + 0.1e1;
  t6 = 0.1e1 / t5;
  t7 = params->c1 * t6;
  t8 = M_CBRT2;
  t9 = M_CBRT6;
  t10 = t9 * t9;
  t11 = t8 * t10;
  t12 = M_PI * M_PI;
  t13 = POW_1_3(t12);
  t14 = 0.1e1 / t13;
  t16 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t17 = sqrt(t16);
  t18 = t14 * t17;
  t20 = 0.1e1 / t2 / t1;
  t26 = exp(-params->c4 * (t11 * t18 * t20 / 0.12e2 - params->c5));
  t27 = 0.1e1 + t26;
  t30 = 0.1e1 - params->c3 / t27;
  tzk0 = t7 * t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t31 = t3 * params->c1;
  t32 = t5 * t5;
  t33 = 0.1e1 / t32;
  t39 = t6 * params->c3;
  t40 = t27 * t27;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t43 = t20 * params->c1 * t42;
  t45 = params->c4 * t8 * t10;
  tvrho0 = tzk0 + t31 * t33 * t30 * params->c2 / 0.3e1 + t43 * t45 * t18 * t26 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = tvrho0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t50 = t31 * t42;
  t51 = 0.1e1 / t17;
  t54 = t45 * t14 * t51 * t26;
  t55 = t50 * t54;
  tvsigma0 = -t55 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = -t55 / 0.12e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t58 = params->c1 * t33;
  t59 = t30 * params->c2;
  t63 = params->c3 * t41;
  t64 = t63 * params->c4;
  t65 = t7 * t64;
  t66 = t11 * t14;
  t67 = t1 * t1;
  t69 = 0.1e1 / t2 / t67;
  t75 = t2 * t2;
  t78 = 0.1e1 / t75 / t1 * params->c1;
  t80 = 0.1e1 / t32 / t5;
  t82 = params->c2 * params->c2;
  t87 = 0.1e1 / t75 / t67;
  t88 = t87 * params->c1;
  t90 = t88 * t33 * t64;
  t91 = t17 * t26;
  t92 = t91 * params->c2;
  t96 = t67 * t1;
  t98 = 0.1e1 / t75 / t96;
  t99 = t98 * params->c1;
  t101 = 0.1e1 / t40 / t27;
  t102 = t39 * t101;
  t103 = t99 * t102;
  t104 = params->c4 * params->c4;
  t105 = t8 * t8;
  t106 = t104 * t105;
  t107 = t106 * t9;
  t108 = t13 * t13;
  t109 = 0.1e1 / t108;
  t110 = t109 * t16;
  t111 = t26 * t26;
  t116 = t99 * t42;
  tv2rho20 = 0.2e1 / 0.9e1 * t58 * t59 * t20 - t65 * t66 * t17 * t69 * t26 / 0.27e2 + 0.2e1 / 0.9e1 * t78 * t80 * t30 * t82 + 0.2e1 / 0.27e2 * t90 * t66 * t92 - 0.4e1 / 0.27e2 * t103 * t107 * t110 * t111 + 0.2e1 / 0.27e2 * t116 * t107 * t110 * t26;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  tv2rho21 = tv2rho20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  tv2rho22 = tv2rho21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t121 = t43 * t54;
  t124 = t78 * t33 * t64;
  t125 = t51 * t26;
  t126 = t125 * params->c2;
  t127 = t66 * t126;
  t128 = t124 * t127;
  t130 = t88 * t102;
  t131 = t9 * t109;
  t133 = t106 * t131 * t111;
  t134 = t130 * t133;
  t136 = t88 * t42;
  t138 = t106 * t131 * t26;
  t139 = t136 * t138;
  tv2rhosigma0 = t121 / 0.72e2 - t128 / 0.72e2 + t134 / 0.18e2 - t139 / 0.36e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = t121 / 0.36e2 - t128 / 0.36e2 + t134 / 0.9e1 - t139 / 0.18e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  tv2rhosigma3 = tv2rhosigma2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = tv2rhosigma1;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t145 = t78 * t102;
  t146 = 0.1e1 / t16;
  t147 = t109 * t146;
  t149 = t107 * t147 * t111;
  t150 = t145 * t149;
  t152 = t17 * t16;
  t153 = 0.1e1 / t152;
  t156 = t45 * t14 * t153 * t26;
  t157 = t50 * t156;
  t159 = t78 * t42;
  t161 = t107 * t147 * t26;
  t162 = t159 * t161;
  tv2sigma20 = -t150 / 0.48e2 + t157 / 0.48e2 + t162 / 0.96e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = -t150 / 0.24e2 + t157 / 0.24e2 + t162 / 0.48e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = -t150 / 0.12e2 + t157 / 0.12e2 + t162 / 0.24e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t170 = params->c1 * t80;
  t171 = t30 * t82;
  t175 = t58 * params->c3;
  t177 = t41 * params->c4 * t8;
  t178 = t175 * t177;
  t179 = t10 * t14;
  t180 = t179 * t17;
  t189 = params->c3 * t101;
  t190 = t189 * t104;
  t191 = t7 * t190;
  t193 = t105 * t9 * t109;
  t194 = t67 * t67;
  t196 = 0.1e1 / t75 / t194;
  t197 = t16 * t196;
  t203 = 0.1e1 / t2 / t96;
  t209 = t63 * t104;
  t210 = t7 * t209;
  t216 = 0.1e1 / t96 * params->c1;
  t217 = t32 * t32;
  t218 = 0.1e1 / t217;
  t220 = t82 * params->c2;
  t224 = 0.1e1 / t194;
  t225 = t224 * params->c1;
  t227 = t225 * t80 * t64;
  t232 = t194 * t1;
  t233 = 0.1e1 / t232;
  t234 = t233 * params->c1;
  t235 = t234 * t33;
  t237 = t16 * t111;
  t243 = t16 * t26;
  t248 = t194 * t67;
  t249 = 0.1e1 / t248;
  t251 = t249 * params->c1 * t39;
  t252 = t40 * t40;
  t253 = 0.1e1 / t252;
  t254 = t104 * params->c4;
  t255 = t253 * t254;
  t256 = 0.1e1 / t12;
  t257 = t256 * t152;
  t258 = t111 * t26;
  t263 = t101 * t254;
  t268 = t41 * t254;
  tv3rho30 = -0.2e1 / 0.9e1 * t170 * t171 * t87 - 0.5e1 / 0.27e2 * t178 * t180 * t98 * t26 * params->c2 - 0.8e1 / 0.27e2 * t58 * t59 * t69 + 0.16e2 / 0.27e2 * t191 * t193 * t197 * t111 + 0.7e1 / 0.81e2 * t65 * t66 * t17 * t203 * t26 - 0.8e1 / 0.27e2 * t210 * t193 * t197 * t26 + 0.2e1 / 0.9e1 * t216 * t218 * t30 * t220 + 0.2e1 / 0.27e2 * t227 * t66 * t91 * t82 - 0.4e1 / 0.27e2 * t235 * t190 * t193 * t237 * params->c2 + 0.2e1 / 0.27e2 * t235 * t209 * t193 * t243 * params->c2 + 0.16e2 / 0.27e2 * t251 * t255 * t257 * t258 - 0.16e2 / 0.27e2 * t251 * t263 * t257 * t111 + 0.8e1 / 0.81e2 * t251 * t268 * t257 * t26;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  tv3rho31 = tv3rho30;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  tv3rho32 = tv3rho31;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  tv3rho33 = tv3rho32;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t274 = t69 * params->c1 * t42;
  t275 = t274 * t54;
  t277 = t90 * t127;
  t279 = t103 * t133;
  t281 = t116 * t138;
  t284 = t216 * t80 * t64;
  t286 = t66 * t125 * t82;
  t287 = t284 * t286;
  t289 = t33 * params->c3;
  t290 = t289 * t101;
  t292 = t109 * t111;
  t294 = t107 * t292 * params->c2;
  t295 = t225 * t290 * t294;
  t297 = t289 * t41;
  t299 = t109 * t26;
  t301 = t107 * t299 * params->c2;
  t302 = t225 * t297 * t301;
  t304 = t234 * t39;
  t305 = t256 * t258;
  t307 = t255 * t305 * t17;
  t308 = t304 * t307;
  t310 = t256 * t111;
  t312 = t263 * t310 * t17;
  t313 = t304 * t312;
  t317 = t268 * t256 * t17 * t26;
  t318 = t304 * t317;
  tv3rho2sigma0 = -t275 / 0.54e2 + t277 / 0.36e2 - t279 / 0.6e1 + t281 / 0.12e2 - t287 / 0.108e3 + t295 / 0.27e2 - t302 / 0.54e2 - 0.2e1 / 0.9e1 * t308 + 0.2e1 / 0.9e1 * t313 - t318 / 0.27e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = -t275 / 0.27e2 + t277 / 0.18e2 - t279 / 0.3e1 + t281 / 0.6e1 - t287 / 0.54e2 + 0.2e1 / 0.27e2 * t295 - t302 / 0.27e2 - 0.4e1 / 0.9e1 * t308 + 0.4e1 / 0.9e1 * t313 - 0.2e1 / 0.27e2 * t318;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  tv3rho2sigma3 = tv3rho2sigma2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = tv3rho2sigma1;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  tv3rho2sigma6 = tv3rho2sigma5;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = tv3rho2sigma4;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t330 = t130 * t149;
  t332 = t216 * t33;
  t333 = t332 * t190;
  t334 = t146 * t111;
  t336 = t193 * t334 * params->c2;
  t337 = t333 * t336;
  t339 = t225 * t39;
  t340 = t256 * t51;
  t342 = t255 * t340 * t258;
  t343 = t339 * t342;
  t346 = t263 * t340 * t111;
  t347 = t339 * t346;
  t349 = t43 * t156;
  t351 = t153 * t26;
  t352 = t351 * params->c2;
  t353 = t66 * t352;
  t354 = t124 * t353;
  t356 = t136 * t161;
  t358 = t332 * t209;
  t359 = t146 * t26;
  t361 = t193 * t359 * params->c2;
  t362 = t358 * t361;
  t365 = t268 * t340 * t26;
  t366 = t339 * t365;
  tv3rhosigma20 = t330 / 0.144e3 - t337 / 0.144e3 + t343 / 0.12e2 - t347 / 0.12e2 - t349 / 0.144e3 + t354 / 0.144e3 - t356 / 0.288e3 + t362 / 0.288e3 + t366 / 0.72e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = t330 / 0.72e2 - t337 / 0.72e2 + t343 / 0.6e1 - t347 / 0.6e1 - t349 / 0.72e2 + t354 / 0.72e2 - t356 / 0.144e3 + t362 / 0.144e3 + t366 / 0.36e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = t330 / 0.36e2 - t337 / 0.36e2 + t343 / 0.3e1 - t347 / 0.3e1 - t349 / 0.36e2 + t354 / 0.36e2 - t356 / 0.72e2 + t362 / 0.72e2 + t366 / 0.18e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = tv3rhosigma25;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = tv3rhosigma24;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = tv3rhosigma23;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t386 = t216 * t39;
  t387 = t256 * t153;
  t389 = t255 * t387 * t258;
  t390 = t386 * t389;
  t392 = t16 * t16;
  t393 = 0.1e1 / t392;
  t394 = t109 * t393;
  t396 = t107 * t394 * t111;
  t397 = t145 * t396;
  t400 = t263 * t387 * t111;
  t401 = t386 * t400;
  t404 = 0.1e1 / t17 / t392;
  t407 = t45 * t14 * t404 * t26;
  t408 = t50 * t407;
  t411 = t107 * t394 * t26;
  t412 = t159 * t411;
  t415 = t268 * t387 * t26;
  t416 = t386 * t415;
  tv3sigma30 = -t390 / 0.32e2 + t397 / 0.32e2 + t401 / 0.32e2 - t408 / 0.32e2 - t412 / 0.64e2 - t416 / 0.192e3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = -t390 / 0.16e2 + t397 / 0.16e2 + t401 / 0.16e2 - t408 / 0.16e2 - t412 / 0.32e2 - t416 / 0.96e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = -t390 / 0.8e1 + t397 / 0.8e1 + t401 / 0.8e1 - t408 / 0.8e1 - t412 / 0.16e2 - t416 / 0.48e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = -t390 / 0.4e1 + t397 / 0.4e1 + t401 / 0.4e1 - t408 / 0.4e1 - t412 / 0.8e1 - t416 / 0.24e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t8, t9;
  double t10, t11, t12, t13, t14, t16, t17, t18;
  double t20, t26, t27, t30, tzk0;

  double t31, t32, t33, t39, t40, t41, t42, t43;
  double t45, tvrho0, tvrho1, t50, t51, t54, t55, tvsigma0;
  double tvsigma1, tvsigma2;

  double t58, t59, t63, t64, t65, t66, t67, t69;
  double t75, t78, t80, t82, t87, t88, t90, t91;
  double t92, t96, t98, t99, t101, t102, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t116;
  double tv2rho20, tv2rho21, tv2rho22, t121, t124, t125, t126, t127;
  double t128, t130, t131, t133, t134, t136, t138, t139;
  double tv2rhosigma0, tv2rhosigma1, tv2rhosigma2, tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t145, t146;
  double t147, t149, t150, t152, t153, t156, t157, t159;
  double t161, t162, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  double t170, t171, t175, t177, t178, t179, t180, t189;
  double t190, t191, t193, t194, t196, t197, t203, t209;
  double t210, t216, t217, t218, t220, t224, t225, t227;
  double t232, t233, t234, t235, t237, t243, t248, t249;
  double t251, t252, t253, t254, t255, t256, t257, t258;
  double t263, t268, tv3rho30, tv3rho31, tv3rho32, tv3rho33, t274, t275;
  double t277, t279, t281, t284, t286, t287, t289, t290;
  double t292, t294, t295, t297, t299, t301, t302, t304;
  double t305, t307, t308, t310, t312, t313, t317, t318;
  double tv3rho2sigma0, tv3rho2sigma1, tv3rho2sigma2, tv3rho2sigma3, tv3rho2sigma4, tv3rho2sigma5, tv3rho2sigma6, tv3rho2sigma7;
  double tv3rho2sigma8, t330, t332, t333, t334, t336, t337, t339;
  double t340, t342, t343, t346, t347, t349, t351, t352;
  double t353, t354, t356, t358, t359, t361, t362, t365;
  double t366, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, tv3rhosigma26;
  double tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, t386, t387, t389;
  double t390, t392, t393, t394, t396, t397, t400, t401;
  double t404, t407, t408, t411, t412, t415, t416, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double tv3sigma39;

  double t452, t468, t474, t482, t491, t492, t503, t507;
  double t509, t511, t512, t514, t515, t520, t521, t527;
  double t528, t534, t537, t555, t559, t563, t566, t567;
  double t569, t589, t604, tv4rho40, tv4rho41, tv4rho42, tv4rho43, tv4rho44;
  double t607, t611, t613, t619, t622, t625, t627, t632;
  double t638, t640, t642, t645, t651, t657, t661, t663;
  double t665, t667, t669, t674, t679, t684, t690, tv4rho3sigma0;
  double tv4rho3sigma1, tv4rho3sigma2, tv4rho3sigma3, tv4rho3sigma4, tv4rho3sigma5, tv4rho3sigma6, tv4rho3sigma7, tv4rho3sigma8;
  double tv4rho3sigma9, tv4rho3sigma10, tv4rho3sigma11, t714, t717, t723, t728, t730;
  double t735, t741, t747, t751, t753, t755, t757, t759;
  double t761, t763, t765, t769, t771, t773, t777, t780;
  double t785, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25, tv4rho2sigma26;
  double tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, tv4rho2sigma211, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214;
  double tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, t825, t831, t833, t835, t838;
  double t843, t845, t850, t852, t858, t863, t865, t870;
  double t872, t877, t879, t883, t888, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32;
  double tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, tv4rhosigma39, tv4rhosigma310;
  double tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318;
  double tv4rhosigma319, t938, t940, t943, t945, t948, t953, t955;
  double t957, t960, t964, t969, t976, t980, t984, t989;
  double tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47;
  double tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, tv4sigma414;

  gga_c_ccdf_params *params;

  assert(p->params != NULL);
  params = (gga_c_ccdf_params * )(p->params);

  t1 = rho[0] + rho[1];
  t2 = POW_1_3(t1);
  t3 = 0.1e1 / t2;
  t5 = params->c2 * t3 + 0.1e1;
  t6 = 0.1e1 / t5;
  t7 = params->c1 * t6;
  t8 = M_CBRT2;
  t9 = M_CBRT6;
  t10 = t9 * t9;
  t11 = t8 * t10;
  t12 = M_PI * M_PI;
  t13 = POW_1_3(t12);
  t14 = 0.1e1 / t13;
  t16 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t17 = sqrt(t16);
  t18 = t14 * t17;
  t20 = 0.1e1 / t2 / t1;
  t26 = exp(-params->c4 * (t11 * t18 * t20 / 0.12e2 - params->c5));
  t27 = 0.1e1 + t26;
  t30 = 0.1e1 - params->c3 / t27;
  tzk0 = t7 * t30;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t31 = t3 * params->c1;
  t32 = t5 * t5;
  t33 = 0.1e1 / t32;
  t39 = t6 * params->c3;
  t40 = t27 * t27;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t43 = t20 * params->c1 * t42;
  t45 = params->c4 * t8 * t10;
  tvrho0 = tzk0 + t31 * t33 * t30 * params->c2 / 0.3e1 + t43 * t45 * t18 * t26 / 0.9e1;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvrho1 = tvrho0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t50 = t31 * t42;
  t51 = 0.1e1 / t17;
  t54 = t45 * t14 * t51 * t26;
  t55 = t50 * t54;
  tvsigma0 = -t55 / 0.24e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = -t55 / 0.12e2;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t58 = params->c1 * t33;
  t59 = t30 * params->c2;
  t63 = params->c3 * t41;
  t64 = t63 * params->c4;
  t65 = t7 * t64;
  t66 = t11 * t14;
  t67 = t1 * t1;
  t69 = 0.1e1 / t2 / t67;
  t75 = t2 * t2;
  t78 = 0.1e1 / t75 / t1 * params->c1;
  t80 = 0.1e1 / t32 / t5;
  t82 = params->c2 * params->c2;
  t87 = 0.1e1 / t75 / t67;
  t88 = t87 * params->c1;
  t90 = t88 * t33 * t64;
  t91 = t17 * t26;
  t92 = t91 * params->c2;
  t96 = t67 * t1;
  t98 = 0.1e1 / t75 / t96;
  t99 = t98 * params->c1;
  t101 = 0.1e1 / t40 / t27;
  t102 = t39 * t101;
  t103 = t99 * t102;
  t104 = params->c4 * params->c4;
  t105 = t8 * t8;
  t106 = t104 * t105;
  t107 = t106 * t9;
  t108 = t13 * t13;
  t109 = 0.1e1 / t108;
  t110 = t109 * t16;
  t111 = t26 * t26;
  t116 = t99 * t42;
  tv2rho20 = 0.2e1 / 0.9e1 * t58 * t59 * t20 - t65 * t66 * t17 * t69 * t26 / 0.27e2 + 0.2e1 / 0.9e1 * t78 * t80 * t30 * t82 + 0.2e1 / 0.27e2 * t90 * t66 * t92 - 0.4e1 / 0.27e2 * t103 * t107 * t110 * t111 + 0.2e1 / 0.27e2 * t116 * t107 * t110 * t26;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  tv2rho21 = tv2rho20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  tv2rho22 = tv2rho21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t121 = t43 * t54;
  t124 = t78 * t33 * t64;
  t125 = t51 * t26;
  t126 = t125 * params->c2;
  t127 = t66 * t126;
  t128 = t124 * t127;
  t130 = t88 * t102;
  t131 = t9 * t109;
  t133 = t106 * t131 * t111;
  t134 = t130 * t133;
  t136 = t88 * t42;
  t138 = t106 * t131 * t26;
  t139 = t136 * t138;
  tv2rhosigma0 = t121 / 0.72e2 - t128 / 0.72e2 + t134 / 0.18e2 - t139 / 0.36e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = t121 / 0.36e2 - t128 / 0.36e2 + t134 / 0.9e1 - t139 / 0.18e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  tv2rhosigma3 = tv2rhosigma2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = tv2rhosigma1;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t145 = t78 * t102;
  t146 = 0.1e1 / t16;
  t147 = t109 * t146;
  t149 = t107 * t147 * t111;
  t150 = t145 * t149;
  t152 = t17 * t16;
  t153 = 0.1e1 / t152;
  t156 = t45 * t14 * t153 * t26;
  t157 = t50 * t156;
  t159 = t78 * t42;
  t161 = t107 * t147 * t26;
  t162 = t159 * t161;
  tv2sigma20 = -t150 / 0.48e2 + t157 / 0.48e2 + t162 / 0.96e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = -t150 / 0.24e2 + t157 / 0.24e2 + t162 / 0.48e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = -t150 / 0.12e2 + t157 / 0.12e2 + t162 / 0.24e2;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t170 = params->c1 * t80;
  t171 = t30 * t82;
  t175 = t58 * params->c3;
  t177 = t41 * params->c4 * t8;
  t178 = t175 * t177;
  t179 = t10 * t14;
  t180 = t179 * t17;
  t189 = params->c3 * t101;
  t190 = t189 * t104;
  t191 = t7 * t190;
  t193 = t105 * t9 * t109;
  t194 = t67 * t67;
  t196 = 0.1e1 / t75 / t194;
  t197 = t16 * t196;
  t203 = 0.1e1 / t2 / t96;
  t209 = t63 * t104;
  t210 = t7 * t209;
  t216 = 0.1e1 / t96 * params->c1;
  t217 = t32 * t32;
  t218 = 0.1e1 / t217;
  t220 = t82 * params->c2;
  t224 = 0.1e1 / t194;
  t225 = t224 * params->c1;
  t227 = t225 * t80 * t64;
  t232 = t194 * t1;
  t233 = 0.1e1 / t232;
  t234 = t233 * params->c1;
  t235 = t234 * t33;
  t237 = t16 * t111;
  t243 = t16 * t26;
  t248 = t194 * t67;
  t249 = 0.1e1 / t248;
  t251 = t249 * params->c1 * t39;
  t252 = t40 * t40;
  t253 = 0.1e1 / t252;
  t254 = t104 * params->c4;
  t255 = t253 * t254;
  t256 = 0.1e1 / t12;
  t257 = t256 * t152;
  t258 = t111 * t26;
  t263 = t101 * t254;
  t268 = t41 * t254;
  tv3rho30 = -0.2e1 / 0.9e1 * t170 * t171 * t87 - 0.5e1 / 0.27e2 * t178 * t180 * t98 * t26 * params->c2 - 0.8e1 / 0.27e2 * t58 * t59 * t69 + 0.16e2 / 0.27e2 * t191 * t193 * t197 * t111 + 0.7e1 / 0.81e2 * t65 * t66 * t17 * t203 * t26 - 0.8e1 / 0.27e2 * t210 * t193 * t197 * t26 + 0.2e1 / 0.9e1 * t216 * t218 * t30 * t220 + 0.2e1 / 0.27e2 * t227 * t66 * t91 * t82 - 0.4e1 / 0.27e2 * t235 * t190 * t193 * t237 * params->c2 + 0.2e1 / 0.27e2 * t235 * t209 * t193 * t243 * params->c2 + 0.16e2 / 0.27e2 * t251 * t255 * t257 * t258 - 0.16e2 / 0.27e2 * t251 * t263 * t257 * t111 + 0.8e1 / 0.81e2 * t251 * t268 * t257 * t26;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  tv3rho31 = tv3rho30;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  tv3rho32 = tv3rho31;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  tv3rho33 = tv3rho32;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t274 = t69 * params->c1 * t42;
  t275 = t274 * t54;
  t277 = t90 * t127;
  t279 = t103 * t133;
  t281 = t116 * t138;
  t284 = t216 * t80 * t64;
  t286 = t66 * t125 * t82;
  t287 = t284 * t286;
  t289 = t33 * params->c3;
  t290 = t289 * t101;
  t292 = t109 * t111;
  t294 = t107 * t292 * params->c2;
  t295 = t225 * t290 * t294;
  t297 = t289 * t41;
  t299 = t109 * t26;
  t301 = t107 * t299 * params->c2;
  t302 = t225 * t297 * t301;
  t304 = t234 * t39;
  t305 = t256 * t258;
  t307 = t255 * t305 * t17;
  t308 = t304 * t307;
  t310 = t256 * t111;
  t312 = t263 * t310 * t17;
  t313 = t304 * t312;
  t317 = t268 * t256 * t17 * t26;
  t318 = t304 * t317;
  tv3rho2sigma0 = -t275 / 0.54e2 + t277 / 0.36e2 - t279 / 0.6e1 + t281 / 0.12e2 - t287 / 0.108e3 + t295 / 0.27e2 - t302 / 0.54e2 - 0.2e1 / 0.9e1 * t308 + 0.2e1 / 0.9e1 * t313 - t318 / 0.27e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = -t275 / 0.27e2 + t277 / 0.18e2 - t279 / 0.3e1 + t281 / 0.6e1 - t287 / 0.54e2 + 0.2e1 / 0.27e2 * t295 - t302 / 0.27e2 - 0.4e1 / 0.9e1 * t308 + 0.4e1 / 0.9e1 * t313 - 0.2e1 / 0.27e2 * t318;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  tv3rho2sigma3 = tv3rho2sigma2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = tv3rho2sigma1;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  tv3rho2sigma6 = tv3rho2sigma5;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = tv3rho2sigma4;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t330 = t130 * t149;
  t332 = t216 * t33;
  t333 = t332 * t190;
  t334 = t146 * t111;
  t336 = t193 * t334 * params->c2;
  t337 = t333 * t336;
  t339 = t225 * t39;
  t340 = t256 * t51;
  t342 = t255 * t340 * t258;
  t343 = t339 * t342;
  t346 = t263 * t340 * t111;
  t347 = t339 * t346;
  t349 = t43 * t156;
  t351 = t153 * t26;
  t352 = t351 * params->c2;
  t353 = t66 * t352;
  t354 = t124 * t353;
  t356 = t136 * t161;
  t358 = t332 * t209;
  t359 = t146 * t26;
  t361 = t193 * t359 * params->c2;
  t362 = t358 * t361;
  t365 = t268 * t340 * t26;
  t366 = t339 * t365;
  tv3rhosigma20 = t330 / 0.144e3 - t337 / 0.144e3 + t343 / 0.12e2 - t347 / 0.12e2 - t349 / 0.144e3 + t354 / 0.144e3 - t356 / 0.288e3 + t362 / 0.288e3 + t366 / 0.72e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = t330 / 0.72e2 - t337 / 0.72e2 + t343 / 0.6e1 - t347 / 0.6e1 - t349 / 0.72e2 + t354 / 0.72e2 - t356 / 0.144e3 + t362 / 0.144e3 + t366 / 0.36e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = t330 / 0.36e2 - t337 / 0.36e2 + t343 / 0.3e1 - t347 / 0.3e1 - t349 / 0.36e2 + t354 / 0.36e2 - t356 / 0.72e2 + t362 / 0.72e2 + t366 / 0.18e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = tv3rhosigma25;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = tv3rhosigma24;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = tv3rhosigma23;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t386 = t216 * t39;
  t387 = t256 * t153;
  t389 = t255 * t387 * t258;
  t390 = t386 * t389;
  t392 = t16 * t16;
  t393 = 0.1e1 / t392;
  t394 = t109 * t393;
  t396 = t107 * t394 * t111;
  t397 = t145 * t396;
  t400 = t263 * t387 * t111;
  t401 = t386 * t400;
  t404 = 0.1e1 / t17 / t392;
  t407 = t45 * t14 * t404 * t26;
  t408 = t50 * t407;
  t411 = t107 * t394 * t26;
  t412 = t159 * t411;
  t415 = t268 * t387 * t26;
  t416 = t386 * t415;
  tv3sigma30 = -t390 / 0.32e2 + t397 / 0.32e2 + t401 / 0.32e2 - t408 / 0.32e2 - t412 / 0.64e2 - t416 / 0.192e3;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = -t390 / 0.16e2 + t397 / 0.16e2 + t401 / 0.16e2 - t408 / 0.16e2 - t412 / 0.32e2 - t416 / 0.96e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = -t390 / 0.8e1 + t397 / 0.8e1 + t401 / 0.8e1 - t408 / 0.8e1 - t412 / 0.16e2 - t416 / 0.48e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = -t390 / 0.4e1 + t397 / 0.4e1 + t401 / 0.4e1 - t408 / 0.4e1 - t412 / 0.8e1 - t416 / 0.24e2;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t452 = t131 * t16;
  t468 = t16 / t75 / t232;
  t474 = 0.1e1 / t2 / t194;
  t482 = 0.1e1 / t2 / t232 * params->c1;
  t491 = 0.1e1 / t2 / t248 * params->c1;
  t492 = t491 * t80;
  t503 = t194 * t194;
  t507 = 0.1e1 / t2 / t503 * params->c1 * t6;
  t509 = 0.1e1 / t252 / t27;
  t511 = t104 * t104;
  t512 = params->c3 * t509 * t511;
  t514 = t256 * t392;
  t515 = t111 * t111;
  t520 = params->c3 * t253;
  t521 = t520 * t511;
  t527 = 0.32e2 / 0.81e2 * t170 * t171 * t98 + 0.56e2 / 0.81e2 * t58 * t59 * t203 - 0.4e1 / 0.9e1 * t170 * params->c3 * t177 * t180 * t233 * t26 * t82 + 0.32e2 / 0.27e2 * t175 * t101 * t104 * t105 * t452 * t249 * t111 * params->c2 - 0.16e2 / 0.27e2 * t175 * t41 * t104 * t105 * t452 * t249 * t26 * params->c2 - 0.7e3 / 0.243e3 * t191 * t193 * t468 * t111 - 0.7e2 / 0.243e3 * t65 * t66 * t17 * t474 * t26 + 0.8e1 / 0.81e2 * t482 * t218 * t64 * t66 * t91 * t220 - 0.16e2 / 0.81e2 * t492 * t190 * t193 * t237 * t82 + 0.8e1 / 0.81e2 * t492 * t209 * t193 * t243 * t82 - 0.64e2 / 0.243e3 * t507 * t512 * t514 * t515 * t66 + 0.32e2 / 0.81e2 * t507 * t521 * t514 * t258 * t66;
  t528 = t189 * t511;
  t534 = t63 * t511;
  t537 = t179 * t26;
  t555 = t474 * params->c1;
  t559 = t82 * t82;
  t563 = t194 * t96;
  t566 = 0.1e1 / t2 / t563 * params->c1;
  t567 = t289 * t253;
  t569 = t254 * t256;
  t589 = t152 / t563;
  t604 = -0.112e3 / 0.729e3 * t507 * t528 * t514 * t111 * t66 + 0.8e1 / 0.729e3 * t507 * t534 * t514 * t8 * t537 + 0.164e3 / 0.243e3 * t178 * t180 * t196 * t26 * params->c2 + 0.35e3 / 0.243e3 * t210 * t193 * t468 * t26 - 0.8e1 / 0.9e1 * params->c1 * t218 * t30 * t220 * t224 + 0.8e1 / 0.27e2 * t555 / t217 / t5 * t30 * t559 + 0.64e2 / 0.81e2 * t566 * t567 * t569 * t152 * t258 * params->c2 - 0.64e2 / 0.81e2 * t566 * t290 * t569 * t152 * t111 * params->c2 + 0.32e2 / 0.243e3 * t566 * t297 * t569 * t152 * t26 * params->c2 - 0.16e3 / 0.27e2 * t7 * t520 * t569 * t589 * t258 + 0.16e3 / 0.27e2 * t7 * t189 * t569 * t589 * t111 - 0.8e2 / 0.81e2 * t7 * t63 * t569 * t589 * t26;
  tv4rho40 = t527 + t604;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  tv4rho41 = tv4rho40;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  tv4rho42 = tv4rho41;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  tv4rho43 = tv4rho42;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  tv4rho44 = tv4rho43;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t607 = t203 * params->c1 * t42 * t54;
  t611 = t99 * t33 * t64 * t127;
  t613 = t227 * t286;
  t619 = t555 * t218 * t64 * t66 * t125 * t220;
  t622 = t234 * t290 * t294;
  t625 = t234 * t297 * t301;
  t627 = t80 * params->c3;
  t632 = t482 * t627 * t101 * t107 * t292 * t82;
  t638 = t482 * t627 * t41 * t107 * t299 * t82;
  t640 = t196 * params->c1;
  t642 = t640 * t102 * t133;
  t645 = t640 * t42 * t138;
  t651 = t491 * t567 * t569 * t258 * params->c2 * t17;
  t657 = t491 * t290 * t569 * t111 * params->c2 * t17;
  t661 = t491 * t297 * t569 * t92;
  t663 = t251 * t307;
  t665 = t251 * t312;
  t667 = t251 * t317;
  t669 = t566 * t6;
  t674 = t669 * t512 * t256 * t515 * t16 * t66;
  t679 = t669 * t521 * t305 * t16 * t66;
  t684 = t669 * t528 * t310 * t16 * t66;
  t690 = t669 * t534 * t256 * t16 * t8 * t537;
  tv4rho3sigma0 = 0.7e1 / 0.162e3 * t607 - 0.13e2 / 0.162e3 * t611 + 0.5e1 / 0.108e3 * t613 - t619 / 0.108e3 - 0.13e2 / 0.54e2 * t622 + 0.13e2 / 0.108e3 * t625 + t632 / 0.27e2 - t638 / 0.54e2 + 0.103e3 / 0.162e3 * t642 - 0.103e3 / 0.324e3 * t645 - 0.2e1 / 0.9e1 * t651 + 0.2e1 / 0.9e1 * t657 - t661 / 0.27e2 + 0.16e2 / 0.9e1 * t663 - 0.16e2 / 0.9e1 * t665 + 0.8e1 / 0.27e2 * t667 + 0.8e1 / 0.81e2 * t674 - 0.4e1 / 0.27e2 * t679 + 0.14e2 / 0.243e3 * t684 - t690 / 0.243e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.7e1 / 0.81e2 * t607 - 0.13e2 / 0.81e2 * t611 + 0.5e1 / 0.54e2 * t613 - t619 / 0.54e2 - 0.13e2 / 0.27e2 * t622 + 0.13e2 / 0.54e2 * t625 + 0.2e1 / 0.27e2 * t632 - t638 / 0.27e2 + 0.103e3 / 0.81e2 * t642 - 0.103e3 / 0.162e3 * t645 - 0.4e1 / 0.9e1 * t651 + 0.4e1 / 0.9e1 * t657 - 0.2e1 / 0.27e2 * t661 + 0.32e2 / 0.9e1 * t663 - 0.32e2 / 0.9e1 * t665 + 0.16e2 / 0.27e2 * t667 + 0.16e2 / 0.81e2 * t674 - 0.8e1 / 0.27e2 * t679 + 0.28e2 / 0.243e3 * t684 - 0.2e1 / 0.243e3 * t690;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = tv4rho3sigma0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  tv4rho3sigma3 = tv4rho3sigma2;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = tv4rho3sigma1;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  tv4rho3sigma5 = tv4rho3sigma3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  tv4rho3sigma6 = tv4rho3sigma5;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = tv4rho3sigma4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  tv4rho3sigma8 = tv4rho3sigma6;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  tv4rho3sigma9 = tv4rho3sigma8;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = tv4rho3sigma7;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  tv4rho3sigma11 = tv4rho3sigma9;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t714 = t511 * t256;
  t717 = t491 * t39 * t509 * t714 * t515 * t66;
  t723 = t491 * t39 * t253 * t714 * t258 * t66;
  t728 = t491 * t102 * t714 * t111 * t66;
  t730 = t116 * t161;
  t735 = t491 * t42 * t714 * t8 * t537;
  t741 = t482 * t567 * t569 * t51 * t258 * params->c2;
  t747 = t482 * t290 * t569 * t51 * t111 * params->c2;
  t751 = t482 * t297 * t569 * t126;
  t753 = t304 * t342;
  t755 = t304 * t346;
  t757 = t304 * t365;
  t759 = t103 * t149;
  t761 = t225 * t33;
  t763 = t761 * t190 * t336;
  t765 = t555 * t80;
  t769 = t765 * t190 * t193 * t334 * t82;
  t771 = t274 * t156;
  t773 = t90 * t353;
  t777 = t284 * t66 * t351 * t82;
  t780 = t761 * t209 * t361;
  t785 = t765 * t209 * t193 * t359 * t82;
  tv4rho2sigma20 = -t717 / 0.27e2 + t723 / 0.18e2 - 0.7e1 / 0.324e3 * t728 + t730 / 0.216e3 + t735 / 0.648e3 + t741 / 0.18e2 - t747 / 0.18e2 + t751 / 0.108e3 - 0.13e2 / 0.36e2 * t753 + 0.13e2 / 0.36e2 * t755 - 0.13e2 / 0.216e3 * t757 - t759 / 0.108e3 + t763 / 0.72e2 - t769 / 0.216e3 + t771 / 0.108e3 - t773 / 0.72e2 + t777 / 0.216e3 - t780 / 0.144e3 + t785 / 0.432e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = -0.2e1 / 0.27e2 * t717 + t723 / 0.9e1 - 0.7e1 / 0.162e3 * t728 + t730 / 0.108e3 + t735 / 0.324e3 + t741 / 0.9e1 - t747 / 0.9e1 + t751 / 0.54e2 - 0.13e2 / 0.18e2 * t753 + 0.13e2 / 0.18e2 * t755 - 0.13e2 / 0.108e3 * t757 - t759 / 0.54e2 + t763 / 0.36e2 - t769 / 0.108e3 + t771 / 0.54e2 - t773 / 0.36e2 + t777 / 0.108e3 - t780 / 0.72e2 + t785 / 0.216e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = tv4rho2sigma20;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = -0.4e1 / 0.27e2 * t717 + 0.2e1 / 0.9e1 * t723 - 0.7e1 / 0.81e2 * t728 + t730 / 0.54e2 + t735 / 0.162e3 + 0.2e1 / 0.9e1 * t741 - 0.2e1 / 0.9e1 * t747 + t751 / 0.27e2 - 0.13e2 / 0.9e1 * t753 + 0.13e2 / 0.9e1 * t755 - 0.13e2 / 0.54e2 * t757 - t759 / 0.27e2 + t763 / 0.18e2 - t769 / 0.54e2 + t771 / 0.27e2 - t773 / 0.18e2 + t777 / 0.54e2 - t780 / 0.36e2 + t785 / 0.108e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = tv4rho2sigma21;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = tv4rho2sigma22;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  tv4rho2sigma26 = tv4rho2sigma25;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = tv4rho2sigma24;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = tv4rho2sigma26;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = tv4rho2sigma23;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = tv4rho2sigma27;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = tv4rho2sigma28;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  tv4rho2sigma212 = tv4rho2sigma211;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = tv4rho2sigma210;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = tv4rho2sigma212;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = tv4rho2sigma29;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = tv4rho2sigma213;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = tv4rho2sigma214;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t825 = t339 * t389;
  t831 = t555 * t567 * t569 * t153 * t258 * params->c2;
  t833 = t482 * t6;
  t835 = t256 * t146;
  t838 = t833 * t512 * t835 * t515 * t66;
  t843 = t833 * t521 * t835 * t258 * t66;
  t845 = t130 * t396;
  t850 = t333 * t193 * t393 * t111 * params->c2;
  t852 = t339 * t400;
  t858 = t555 * t290 * t569 * t153 * t111 * params->c2;
  t863 = t833 * t528 * t835 * t111 * t66;
  t865 = t43 * t407;
  t870 = t124 * t66 * t404 * t26 * params->c2;
  t872 = t136 * t411;
  t877 = t358 * t193 * t393 * t26 * params->c2;
  t879 = t339 * t415;
  t883 = t555 * t297 * t569 * t352;
  t888 = t833 * t534 * t835 * t8 * t537;
  tv4rhosigma30 = -t825 / 0.32e2 - t831 / 0.96e2 + t838 / 0.72e2 - t843 / 0.48e2 - t845 / 0.96e2 + t850 / 0.96e2 + t852 / 0.32e2 + t858 / 0.96e2 + 0.7e1 / 0.864e3 * t863 + t865 / 0.96e2 - t870 / 0.96e2 + t872 / 0.192e3 - t877 / 0.192e3 - t879 / 0.192e3 - t883 / 0.576e3 - t888 / 0.1728e4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = -t825 / 0.16e2 - t831 / 0.48e2 + t838 / 0.36e2 - t843 / 0.24e2 - t845 / 0.48e2 + t850 / 0.48e2 + t852 / 0.16e2 + t858 / 0.48e2 + 0.7e1 / 0.432e3 * t863 + t865 / 0.48e2 - t870 / 0.48e2 + t872 / 0.96e2 - t877 / 0.96e2 - t879 / 0.96e2 - t883 / 0.288e3 - t888 / 0.864e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = tv4rhosigma30;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = -t825 / 0.8e1 - t831 / 0.24e2 + t838 / 0.18e2 - t843 / 0.12e2 - t845 / 0.24e2 + t850 / 0.24e2 + t852 / 0.8e1 + t858 / 0.24e2 + 0.7e1 / 0.216e3 * t863 + t865 / 0.24e2 - t870 / 0.24e2 + t872 / 0.48e2 - t877 / 0.48e2 - t879 / 0.48e2 - t883 / 0.144e3 - t888 / 0.432e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = tv4rhosigma31;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = tv4rhosigma32;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = -t825 / 0.4e1 - t831 / 0.12e2 + t838 / 0.9e1 - t843 / 0.6e1 - t845 / 0.12e2 + t850 / 0.12e2 + t852 / 0.4e1 + t858 / 0.12e2 + 0.7e1 / 0.108e3 * t863 + t865 / 0.12e2 - t870 / 0.12e2 + t872 / 0.24e2 - t877 / 0.24e2 - t879 / 0.24e2 - t883 / 0.72e2 - t888 / 0.216e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = tv4rhosigma33;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = tv4rhosigma34;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = tv4rhosigma35;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  tv4rhosigma310 = tv4rhosigma39;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = tv4rhosigma38;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = tv4rhosigma310;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = tv4rhosigma37;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = tv4rhosigma311;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = tv4rhosigma312;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = tv4rhosigma36;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = tv4rhosigma313;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = tv4rhosigma314;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = tv4rhosigma315;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t938 = t555 * t6;
  t940 = t256 * t393;
  t943 = t938 * t512 * t940 * t515 * t66;
  t945 = t256 * t404;
  t948 = t386 * t255 * t945 * t258;
  t953 = t938 * t521 * t940 * t258 * t66;
  t955 = t392 * t16;
  t957 = t109 / t955;
  t960 = t145 * t107 * t957 * t111;
  t964 = t386 * t263 * t945 * t111;
  t969 = t938 * t528 * t940 * t111 * t66;
  t976 = t50 * t45 * t14 / t17 / t955 * t26;
  t980 = t159 * t107 * t957 * t26;
  t984 = t386 * t268 * t945 * t26;
  t989 = t938 * t534 * t940 * t8 * t537;
  tv4sigma40 = -t943 / 0.192e3 + 0.3e1 / 0.32e2 * t948 + t953 / 0.128e3 - 0.5e1 / 0.64e2 * t960 - 0.3e1 / 0.32e2 * t964 - 0.7e1 / 0.2304e4 * t969 + 0.5e1 / 0.64e2 * t976 + 0.5e1 / 0.128e3 * t980 + t984 / 0.64e2 + t989 / 0.4608e4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = -t943 / 0.96e2 + 0.3e1 / 0.16e2 * t948 + t953 / 0.64e2 - 0.5e1 / 0.32e2 * t960 - 0.3e1 / 0.16e2 * t964 - 0.7e1 / 0.1152e4 * t969 + 0.5e1 / 0.32e2 * t976 + 0.5e1 / 0.64e2 * t980 + t984 / 0.32e2 + t989 / 0.2304e4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = tv4sigma40;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = -t943 / 0.48e2 + 0.3e1 / 0.8e1 * t948 + t953 / 0.32e2 - 0.5e1 / 0.16e2 * t960 - 0.3e1 / 0.8e1 * t964 - 0.7e1 / 0.576e3 * t969 + 0.5e1 / 0.16e2 * t976 + 0.5e1 / 0.32e2 * t980 + t984 / 0.16e2 + t989 / 0.1152e4;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = tv4sigma41;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = tv4sigma42;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = -t943 / 0.24e2 + 0.3e1 / 0.4e1 * t948 + t953 / 0.16e2 - 0.5e1 / 0.8e1 * t960 - 0.3e1 / 0.4e1 * t964 - 0.7e1 / 0.288e3 * t969 + 0.5e1 / 0.8e1 * t976 + 0.5e1 / 0.16e2 * t980 + t984 / 0.8e1 + t989 / 0.576e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = tv4sigma43;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = tv4sigma44;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = tv4sigma45;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = -t943 / 0.12e2 + 0.3e1 / 0.2e1 * t948 + t953 / 0.8e1 - 0.5e1 / 0.4e1 * t960 - 0.3e1 / 0.2e1 * t964 - 0.7e1 / 0.144e3 * t969 + 0.5e1 / 0.4e1 * t976 + 0.5e1 / 0.8e1 * t980 + t984 / 0.4e1 + t989 / 0.288e3;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = tv4sigma46;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = tv4sigma47;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = tv4sigma48;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = tv4sigma49;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

