/* 
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_rlda.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t3, t4, t5, t8, t9, t11, t13, t14;
  double t15, t18, t19, t20, t21, t22, t23, t24;
  double t25, t27, t30, t33, t36, t39;

#ifndef XC_DONT_COMPILE_VXC
  double t40, t45, t46, t47, t48, t49, t51, t56;
  double t58, t62, t67, t68, t70, t71, t73, t76;

#ifndef XC_DONT_COMPILE_FXC
  double t83, t87, t88, t90, t93, t95, t100, t102;
  double t106, t112, t113, t115, t117, t118, t121, t127;
  double t132, t134, t135, t137, t140, t143;

#ifndef XC_DONT_COMPILE_KXC
  double t150, t157, t158, t159, t161, t164, t166, t169;
  double t171, t176, t178, t182, t189, t190, t192, t196;
  double t197, t200, t201, t204, t213, t218, t220, t222;
  double t224, t226, t231, t235, t239, t240, t241, t243;
  double t246, t249, t252;

#ifndef XC_DONT_COMPILE_LXC
  double t273, t274, t284, t293, t295, t305, t306, t314;
  double t316, t318, t320, t322, t325, t332, t336, t339;
  double t351, t358, t360, t365, t369, t372, t381, t390;
  double t394, t400, t403, t409, t415, t421, t430, t432;
  double t435, t438, t441, t444;
#endif

#endif

#endif

#endif

#endif


  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t8 = my_piecewise3(0.1e1 <= p->zeta_threshold, p->zeta_threshold - 0.1e1, 0);
  t9 = 0.1e1 + t8;
  t11 = POW_1_3(t9);
  t13 = my_piecewise3(t9 <= p->zeta_threshold, 0, t11 * t9);
  t14 = t5 * t13;
  t15 = POW_1_3(rho[0]);
  t18 = POW_1_3(0.1e1 / M_PI);
  t19 = 0.1e1 / t18;
  t20 = params->prefactor * t19;
  t21 = M_CBRT4;
  t22 = M_CBRT2;
  t23 = t22 * t22;
  t24 = tau[0] * t23;
  t25 = t15 * t15;
  t27 = 0.1e1 / t25 / rho[0];
  t30 = lapl[0] * t23;
  t33 = 0.2e1 * t24 * t27 - t30 * t27 / 0.4e1;
  t36 = t20 * t21 / t33;
  t39 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t14 * t15 * t36);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t39;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t40 = 0.1e1 / t25;
  t45 = t14 * t15 * params->prefactor;
  t46 = t19 * t21;
  t47 = t33 * t33;
  t48 = 0.1e1 / t47;
  t49 = rho[0] * rho[0];
  t51 = 0.1e1 / t25 / t49;
  t56 = -0.10e2 / 0.3e1 * t24 * t51 + 0.5e1 / 0.12e2 * t30 * t51;
  t58 = t46 * t48 * t56;
  t62 = my_piecewise3(t3, 0, -0.5e1 / 0.16e2 * t14 * t40 * t36 + 0.15e2 / 0.16e2 * t45 * t58);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t62 + 0.2e1 * t39;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  t67 = 0.1e1 / t15 / rho[0] * params->prefactor;
  t68 = t14 * t67;
  t70 = t46 * t48 * t23;
  t71 = t68 * t70;
  t73 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t71);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.2e1 * rho[0] * t73;

  t76 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t71);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = 0.2e1 * rho[0] * t76;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t83 = t14 * t40 * params->prefactor;
  t87 = 0.1e1 / t47 / t33;
  t88 = t56 * t56;
  t90 = t46 * t87 * t88;
  t93 = t49 * rho[0];
  t95 = 0.1e1 / t25 / t93;
  t100 = 0.80e2 / 0.9e1 * t24 * t95 - 0.10e2 / 0.9e1 * t30 * t95;
  t102 = t46 * t48 * t100;
  t106 = my_piecewise3(t3, 0, 0.5e1 / 0.24e2 * t14 * t27 * t36 + 0.5e1 / 0.8e1 * t83 * t58 - 0.15e2 / 0.8e1 * t45 * t90 + 0.15e2 / 0.16e2 * t45 * t102);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t106 + 0.4e1 * t62;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  t112 = t14 / t15 / t49 * params->prefactor;
  t113 = t112 * t70;
  t115 = t87 * t23;
  t117 = t46 * t115 * t56;
  t118 = t68 * t117;
  t121 = my_piecewise3(t3, 0, 0.5e1 / 0.16e2 * t113 + 0.15e2 / 0.32e2 * t118);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.2e1 * rho[0] * t121 + 0.2e1 * t73;

  t127 = my_piecewise3(t3, 0, -0.5e1 / 0.2e1 * t113 - 0.15e2 / 0.4e1 * t118);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = 0.2e1 * rho[0] * t127 + 0.2e1 * t76;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  t132 = t14 / t93 * params->prefactor;
  t134 = t46 * t87 * t22;
  t135 = t132 * t134;
  t137 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t135);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.2e1 * rho[0] * t137;

  t140 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t135);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.2e1 * rho[0] * t140;

  t143 = my_piecewise3(t3, 0, -0.15e2 * t135);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = 0.2e1 * rho[0] * t143;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t150 = t14 * t27 * params->prefactor;
  t157 = t47 * t47;
  t158 = 0.1e1 / t157;
  t159 = t88 * t56;
  t161 = t46 * t158 * t159;
  t164 = t87 * t56;
  t166 = t46 * t164 * t100;
  t169 = t49 * t49;
  t171 = 0.1e1 / t25 / t169;
  t176 = -0.880e3 / 0.27e2 * t24 * t171 + 0.110e3 / 0.27e2 * t30 * t171;
  t178 = t46 * t48 * t176;
  t182 = my_piecewise3(t3, 0, -0.25e2 / 0.72e2 * t14 * t51 * t36 - 0.5e1 / 0.8e1 * t150 * t58 - 0.15e2 / 0.8e1 * t83 * t90 + 0.15e2 / 0.16e2 * t83 * t102 + 0.45e2 / 0.8e1 * t45 * t161 - 0.45e2 / 0.8e1 * t45 * t166 + 0.15e2 / 0.16e2 * t45 * t178);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t182 + 0.6e1 * t106;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  t189 = t14 / t15 / t93 * params->prefactor;
  t190 = t189 * t70;
  t192 = t112 * t117;
  t196 = t46 * t158 * t23 * t88;
  t197 = t68 * t196;
  t200 = t46 * t115 * t100;
  t201 = t68 * t200;
  t204 = my_piecewise3(t3, 0, -0.35e2 / 0.48e2 * t190 - 0.5e1 / 0.4e1 * t192 - 0.45e2 / 0.32e2 * t197 + 0.15e2 / 0.32e2 * t201);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.2e1 * rho[0] * t204 + 0.4e1 * t121;

  t213 = my_piecewise3(t3, 0, 0.35e2 / 0.6e1 * t190 + 0.10e2 * t192 + 0.45e2 / 0.4e1 * t197 - 0.15e2 / 0.4e1 * t201);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = 0.2e1 * rho[0] * t213 + 0.4e1 * t127;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  t218 = t14 / t169 * params->prefactor;
  t220 = t158 * t22;
  t222 = t46 * t220 * t56;
  t224 = t132 * t222 + t218 * t134;
  t226 = my_piecewise3(t3, 0, 0.45e2 / 0.64e2 * t224);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.2e1 * rho[0] * t226 + 0.2e1 * t137;

  t231 = my_piecewise3(t3, 0, -0.45e2 / 0.8e1 * t224);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.2e1 * rho[0] * t231 + 0.2e1 * t140;

  t235 = my_piecewise3(t3, 0, 0.45e2 * t224);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = 0.2e1 * rho[0] * t235 + 0.2e1 * t143;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  t239 = t21 * t158;
  t240 = t20 * t239;
  t241 = t14 * t171 * t240;
  t243 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t241);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.2e1 * rho[0] * t243;

  t246 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t241);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.2e1 * rho[0] * t246;

  t249 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t241);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.2e1 * rho[0] * t249;

  t252 = my_piecewise3(t3, 0, 0.180e3 * t241);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = 0.2e1 * rho[0] * t252;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t273 = 0.1e1 / t157 / t33;
  t274 = t88 * t88;
  t284 = t100 * t100;
  t293 = t169 * rho[0];
  t295 = 0.1e1 / t25 / t293;
  t305 = 0.25e2 / 0.27e2 * t14 * t95 * t36 + 0.25e2 / 0.18e2 * t14 * t51 * params->prefactor * t58 + 0.5e1 / 0.2e1 * t150 * t90 - 0.5e1 / 0.4e1 * t150 * t102 + 0.15e2 / 0.2e1 * t83 * t161 - 0.15e2 / 0.2e1 * t83 * t166 + 0.5e1 / 0.4e1 * t83 * t178 - 0.45e2 / 0.2e1 * t45 * t46 * t273 * t274 + 0.135e3 / 0.4e1 * t45 * t46 * t158 * t88 * t100 - 0.45e2 / 0.8e1 * t45 * t46 * t87 * t284 - 0.15e2 / 0.2e1 * t45 * t46 * t164 * t176 + 0.15e2 / 0.16e2 * t45 * t46 * t48 * (0.12320e5 / 0.81e2 * t24 * t295 - 0.1540e4 / 0.81e2 * t30 * t295);
  t306 = my_piecewise3(t3, 0, t305);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t306 + 0.8e1 * t182;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  t314 = t14 / t15 / t169 * params->prefactor * t70;
  t316 = t189 * t117;
  t318 = t112 * t196;
  t320 = t112 * t200;
  t322 = t273 * t23;
  t325 = t68 * t46 * t322 * t159;
  t332 = t14 * t67 * t19 * t239 * t23 * t56 * t100;
  t336 = t68 * t46 * t115 * t176;
  t339 = my_piecewise3(t3, 0, 0.175e3 / 0.72e2 * t314 + 0.35e2 / 0.8e1 * t316 + 0.45e2 / 0.8e1 * t318 - 0.15e2 / 0.8e1 * t320 + 0.45e2 / 0.8e1 * t325 - 0.135e3 / 0.32e2 * t332 + 0.15e2 / 0.32e2 * t336);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.2e1 * rho[0] * t339 + 0.6e1 * t204;

  t351 = my_piecewise3(t3, 0, -0.175e3 / 0.9e1 * t314 - 0.35e2 * t316 - 0.45e2 * t318 + 0.15e2 * t320 - 0.45e2 * t325 + 0.135e3 / 0.4e1 * t332 - 0.15e2 / 0.4e1 * t336);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = 0.2e1 * rho[0] * t351 + 0.6e1 * t213;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  t358 = t14 / t293 * params->prefactor * t134;
  t360 = t218 * t222;
  t365 = t132 * t46 * t273 * t22 * t88;
  t369 = t132 * t46 * t220 * t100;
  t372 = my_piecewise3(t3, 0, -0.45e2 / 0.16e2 * t358 - 0.135e3 / 0.32e2 * t360 - 0.45e2 / 0.16e2 * t365 + 0.45e2 / 0.64e2 * t369);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.2e1 * rho[0] * t372 + 0.4e1 * t226;

  t381 = my_piecewise3(t3, 0, 0.45e2 / 0.2e1 * t358 + 0.135e3 / 0.4e1 * t360 + 0.45e2 / 0.2e1 * t365 - 0.45e2 / 0.8e1 * t369);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.2e1 * rho[0] * t381 + 0.4e1 * t231;

  t390 = my_piecewise3(t3, 0, -0.180e3 * t358 - 0.270e3 * t360 - 0.180e3 * t365 + 0.45e2 * t369);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = 0.2e1 * rho[0] * t390 + 0.4e1 * t235;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  t394 = t14 * t295 * t240;
  t400 = t14 * t171 * params->prefactor * t46 * t273 * t56;
  t403 = my_piecewise3(t3, 0, 0.105e3 / 0.64e2 * t394 + 0.45e2 / 0.32e2 * t400);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.2e1 * rho[0] * t403 + 0.2e1 * t243;

  t409 = my_piecewise3(t3, 0, -0.105e3 / 0.8e1 * t394 - 0.45e2 / 0.4e1 * t400);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.2e1 * rho[0] * t409 + 0.2e1 * t246;

  t415 = my_piecewise3(t3, 0, 0.105e3 * t394 + 0.90e2 * t400);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.2e1 * rho[0] * t415 + 0.2e1 * t249;

  t421 = my_piecewise3(t3, 0, -0.840e3 * t394 - 0.720e3 * t400);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = 0.2e1 * rho[0] * t421 + 0.2e1 * t252;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  t430 = t14 / t15 / t169 / t49 * params->prefactor * t46 * t322;
  t432 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t430);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.2e1 * rho[0] * t432;

  t435 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t430);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.2e1 * rho[0] * t435;

  t438 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t430);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.2e1 * rho[0] * t438;

  t441 = my_piecewise3(t3, 0, 0.180e3 * t430);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.2e1 * rho[0] * t441;

  t444 = my_piecewise3(t3, 0, -0.1440e4 * t430);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = 0.2e1 * rho[0] * t444;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t5, t6, t9, t10, t11;
  double t13, t14, t15, t16, t18, t19, t20, t23;
  double t24, t25, t26, t27, t28, t30, t35, t38;
  double t41, t42, t45, t46, t48, t49, t50, t51;
  double t53, t54, t56, t57, t59, t64, t67, t70;

#ifndef XC_DONT_COMPILE_VXC
  double t71, t72, t73, t75, t78, t79, t83, t84;
  double t87, t88, t89, t90, t91, t92, t93, t95;
  double t100, t102, t106, t107, t109, t112, t113, t119;
  double t121, t125, t128, t129, t134, t136, t139, t140;
  double t144, t145, t146, t147, t149, t154, t156, t160;
  double t164, t165, t167, t169, t170, t172, t174, t176;

#ifndef XC_DONT_COMPILE_FXC
  double t179, t180, t181, t184, t185, t186, t189, t193;
  double t194, t199, t201, t205, t208, t209, t210, t211;
  double t214, t215, t217, t220, t222, t227, t229, t233;
  double t234, t235, t236, t239, t242, t246, t247, t252;
  double t256, t258, t261, t265, t269, t270, t275, t277;
  double t283, t284, t288, t292, t293, t298, t301, t304;
  double t305, t308, t313, t318, t322, t323, t329, t330;
  double t335, t339, t340, t345, t350, t351, t353, t356;
  double t358, t363, t365, t369, t372, t374, t375, t376;
  double t378, t379, t382, t383, t386, t388, t390, t391;
  double t393, t395, t398, t400, t402, t404, t405, t408;
  double t409, t412, t415, t419, t422, t424, t428, t434;
  double t437, t439, t440, t442, t444, t446, t447, t449;
  double t451, t453, t455, t457;

#ifndef XC_DONT_COMPILE_KXC
  double t461, t462, t465, t468, t469, t470, t473, t477;
  double t478, t484, t486, t487, t488, t490, t493, t495;
  double t499, t501, t505, t507, t508, t513, t516, t517;
  double t518, t519, t521, t523, t525, t530, t532, t535;
  double t536, t538, t539, t542, t545, t548, t552, t553;
  double t558, t561, t565, t567, t570, t571, t572, t575;
  double t580, t581, t583, t587, t588, t594, t595, t599;
  double t601, t603, t614, t615, t616, t619, t624, t626;
  double t630, t631, t637, t639, t643, t646, t648, t649;
  double t650, t653, t656, t661, t665, t669, t670, t675;
  double t677, t684, t685, t690, t694, t698, t699, t704;
  double t707, t710, t711, t717, t721, t723, t724, t729;
  double t736, t740, t741, t748, t749, t756, t760, t761;
  double t767, t768, t769, t771, t774, t776, t785, t790;
  double t792, t797, t799, t802, t803, t807, t809, t811;
  double t813, t815, t816, t817, t819, t823, t824, t826;
  double t828, t829, t832, t833, t836, t837, t839, t840;
  double t843, t845, t847, t848, t850, t852, t854, t856;
  double t858, t864, t866, t868, t871, t873, t875, t877;
  double t880, t883, t887, t890, t893, t895, t901, t902;
  double t904, t906, t907, t910, t911, t914, t915, t917;
  double t918, t925, t932, t933, t938, t940, t950, t960;
  double t966, t979, t980, t982, t984, t985, t986, t988;
  double t989, t992, t994, t995, t998, t1000, t1002, t1003;
  double t1005, t1007, t1010, t1012, t1014, t1016, t1017, t1020;
  double t1022, t1023, t1026, t1029, t1033, t1036, t1038, t1042;
  double t1048, t1051, t1055, t1058, t1060, t1064, t1070, t1072;
  double t1073, t1075, t1076, t1078, t1079, t1080, t1082, t1083;
  double t1085, t1087, t1089, t1091, t1093, t1095, t1097;

#ifndef XC_DONT_COMPILE_LXC
  double t1100, t1105, t1109, t1111, t1112, t1113, t1115, t1117;
  double t1120, t1130, t1131, t1135, t1136, t1138, t1142, t1143;
  double t1148, t1151, t1152, t1163, t1171, t1174, t1177, t1180;
  double t1182, t1184, t1186, t1187, t1193, t1199, t1200, t1203;
  double t1207, t1212, t1214, t1215, t1217, t1218, t1224, t1229;
  double t1232, t1236, t1242, t1245, t1248, t1252, t1254, t1261;
  double t1267, t1268, t1269, t1270, t1274, t1277, t1278, t1285;
  double t1297, t1300, t1301, t1303, t1321, t1322, t1324, t1328;
  double t1333, t1335, t1352, t1354, t1358, t1364, t1367, t1368;
  double t1370, t1375, t1378, t1379, t1381, t1382, t1383, t1384;
  double t1385, t1387, t1388, t1398, t1400, t1404, t1406, t1407;
  double t1433, t1446, t1450, t1455, t1457, t1461, t1464, t1466;
  double t1477, t1479, t1481, t1483, t1484, t1486, t1487, t1489;
  double t1502, t1515, t1519, t1524, t1526, t1547, t1551, t1557;
  double t1559, t1568, t1569, t1570, t1571, t1573, t1575, t1577;
  double t1579, t1590, t1596, t1600, t1620, t1624, t1633, t1636;
  double t1638, t1643, t1648, t1655, t1659, t1668, t1678, t1688;
  double t1696, t1697, t1702, t1708, t1725, t1730, t1737, t1741;
  double t1749, t1751, t1757, t1759, t1761, t1762, t1763, t1765;
  double t1767, t1769, t1771, t1773, t1775, t1777, t1779, t1781;
  double t1782, t1784, t1786, t1788, t1790, t1795, t1800, t1805;
  double t1807, t1809, t1813, t1817, t1819, t1825, t1827, t1829;
  double t1832, t1834, t1836, t1838, t1839, t1841, t1843, t1844;
  double t1845, t1846, t1847, t1848, t1850, t1852, t1853, t1854;
  double t1856, t1858, t1862, t1869, t1871, t1875, t1877, t1879;
  double t1881, t1882, t1884, t1885, t1886, t1890, t1892, t1893;
  double t1894, t1896, t1898, t1899, t1900, t1902, t1903, t1905;
  double t1907, t1909, t1911, t1917, t1918, t1920, t1922, t1925;
  double t1927, t1929, t1931, t1934, t1937, t1939, t1941, t1943;
  double t1945, t1947, t1949, t1951, t1953, t1955, t1958, t1963;
  double t1966, t1973, t1975, t1977, t1984, t1989, t1991, t1995;
  double t1997, t1999, t2006, t2010, t2012, t2014, t2023, t2025;
  double t2027, t2032, t2042, t2056, t2058, t2064, t2066, t2068;
  double t2069, t2070, t2073, t2079, t2091, t2093, t2095, t2097;
  double t2102, t2105, t2107, t2108, t2118, t2119, t2129, t2140;
  double t2142, t2149, t2163, t2177, t2179, t2182, t2184, t2186;
  double t2188, t2190, t2191, t2192, t2194, t2199, t2204, t2208;
  double t2214, t2216, t2217, t2220, t2222, t2224, t2225, t2227;
  double t2229, t2231, t2233, t2235, t2241, t2243, t2245, t2248;
  double t2250, t2252, t2254, t2257, t2260, t2264, t2267, t2270;
  double t2272, t2279, t2284, t2288, t2294, t2296, t2297, t2304;
  double t2311, t2312, t2317, t2319, t2329, t2339, t2345, t2358;
  double t2359, t2366, t2373, t2374, t2379, t2381, t2391, t2401;
  double t2407, t2420, t2421, t2423, t2425, t2426, t2430, t2432;
  double t2436, t2439, t2441, t2443, t2444, t2446, t2448, t2451;
  double t2453, t2458, t2460, t2464, t2467, t2470, t2474, t2477;
  double t2479, t2483, t2489, t2492, t2496, t2499, t2501, t2505;
  double t2511, t2514, t2518, t2521, t2523, t2527, t2533, t2539;
  double t2541, t2546, t2548, t2550, t2552, t2554, t2556, t2558;
  double t2560, t2562, t2564;
#endif

#endif

#endif

#endif

#endif


  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t11 = rho[0] - rho[1];
  t13 = my_piecewise3(t9, t10, t11 * t6);
  t14 = 0.1e1 + t13;
  t15 = t14 <= p->zeta_threshold;
  t16 = POW_1_3(t14);
  t18 = my_piecewise3(t15, 0, t16 * t14);
  t19 = t4 * t18;
  t20 = POW_1_3(t5);
  t23 = POW_1_3(0.1e1 / M_PI);
  t24 = 0.1e1 / t23;
  t25 = params->prefactor * t24;
  t26 = M_CBRT4;
  t27 = POW_1_3(rho[0]);
  t28 = t27 * t27;
  t30 = 0.1e1 / t28 / rho[0];
  t35 = 0.2e1 * tau[0] * t30 - lapl[0] * t30 / 0.4e1;
  t38 = t25 * t26 / t35;
  t41 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t19 * t20 * t38);
  t42 = rho[1] <= p->dens_threshold;
  t45 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t46 = -t11;
  t48 = my_piecewise3(t45, t10, t46 * t6);
  t49 = 0.1e1 + t48;
  t50 = t49 <= p->zeta_threshold;
  t51 = POW_1_3(t49);
  t53 = my_piecewise3(t50, 0, t51 * t49);
  t54 = t4 * t53;
  t56 = POW_1_3(rho[1]);
  t57 = t56 * t56;
  t59 = 0.1e1 / t57 / rho[1];
  t64 = 0.2e1 * tau[1] * t59 - lapl[1] * t59 / 0.4e1;
  t67 = t25 * t26 / t64;
  t70 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t54 * t20 * t67);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t41 + t70;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t71 = t5 * t5;
  t72 = 0.1e1 / t71;
  t73 = t11 * t72;
  t75 = my_piecewise3(t9, 0, t6 - t73);
  t78 = my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t75);
  t79 = t4 * t78;
  t83 = t20 * t20;
  t84 = 0.1e1 / t83;
  t87 = 0.5e1 / 0.16e2 * t19 * t84 * t38;
  t88 = t20 * params->prefactor;
  t89 = t19 * t88;
  t90 = t24 * t26;
  t91 = t35 * t35;
  t92 = 0.1e1 / t91;
  t93 = rho[0] * rho[0];
  t95 = 0.1e1 / t28 / t93;
  t100 = -0.10e2 / 0.3e1 * tau[0] * t95 + 0.5e1 / 0.12e2 * lapl[0] * t95;
  t102 = t90 * t92 * t100;
  t106 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t79 * t20 * t38 - t87 + 0.15e2 / 0.16e2 * t89 * t102);
  t107 = t46 * t72;
  t109 = my_piecewise3(t45, 0, -t6 - t107);
  t112 = my_piecewise3(t50, 0, 0.4e1 / 0.3e1 * t51 * t109);
  t113 = t4 * t112;
  t119 = 0.5e1 / 0.16e2 * t54 * t84 * t67;
  t121 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t113 * t20 * t67 - t119);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t41 + t70 + t5 * (t106 + t121);

  t125 = my_piecewise3(t9, 0, -t6 - t73);
  t128 = my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t125);
  t129 = t4 * t128;
  t134 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t129 * t20 * t38 - t87);
  t136 = my_piecewise3(t45, 0, t6 - t107);
  t139 = my_piecewise3(t50, 0, 0.4e1 / 0.3e1 * t51 * t136);
  t140 = t4 * t139;
  t144 = t54 * t88;
  t145 = t64 * t64;
  t146 = 0.1e1 / t145;
  t147 = rho[1] * rho[1];
  t149 = 0.1e1 / t57 / t147;
  t154 = -0.10e2 / 0.3e1 * tau[1] * t149 + 0.5e1 / 0.12e2 * lapl[1] * t149;
  t156 = t90 * t146 * t154;
  t160 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t140 * t20 * t67 - t119 + 0.15e2 / 0.16e2 * t144 * t156);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t41 + t70 + t5 * (t134 + t160);

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = 0.0e0;

  t164 = t90 * t92 * t30;
  t165 = t89 * t164;
  t167 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t165);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = t5 * t167;

  t169 = t90 * t146 * t59;
  t170 = t144 * t169;
  t172 = my_piecewise3(t42, 0, -0.15e2 / 0.64e2 * t170);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[1] = t5 * t172;

  t174 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t165);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = t5 * t174;

  t176 = my_piecewise3(t42, 0, 0.15e2 / 0.8e1 * t170);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[1] = t5 * t176;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t179 = t16 * t16;
  t180 = 0.1e1 / t179;
  t181 = t75 * t75;
  t184 = t71 * t5;
  t185 = 0.1e1 / t184;
  t186 = t11 * t185;
  t189 = my_piecewise3(t9, 0, -0.2e1 * t72 + 0.2e1 * t186);
  t193 = my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t180 * t181 + 0.4e1 / 0.3e1 * t16 * t189);
  t194 = t4 * t193;
  t199 = t79 * t84 * t38;
  t201 = t79 * t88;
  t205 = 0.1e1 / t83 / t5;
  t208 = 0.5e1 / 0.24e2 * t19 * t205 * t38;
  t209 = t84 * params->prefactor;
  t210 = t19 * t209;
  t211 = t210 * t102;
  t214 = 0.1e1 / t91 / t35;
  t215 = t100 * t100;
  t217 = t90 * t214 * t215;
  t220 = t93 * rho[0];
  t222 = 0.1e1 / t28 / t220;
  t227 = 0.80e2 / 0.9e1 * tau[0] * t222 - 0.10e2 / 0.9e1 * lapl[0] * t222;
  t229 = t90 * t92 * t227;
  t233 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t194 * t20 * t38 - 0.5e1 / 0.8e1 * t199 + 0.15e2 / 0.8e1 * t201 * t102 + t208 + 0.5e1 / 0.8e1 * t211 - 0.15e2 / 0.8e1 * t89 * t217 + 0.15e2 / 0.16e2 * t89 * t229);
  t234 = t51 * t51;
  t235 = 0.1e1 / t234;
  t236 = t109 * t109;
  t239 = t46 * t185;
  t242 = my_piecewise3(t45, 0, 0.2e1 * t72 + 0.2e1 * t239);
  t246 = my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t235 * t236 + 0.4e1 / 0.3e1 * t51 * t242);
  t247 = t4 * t246;
  t252 = t113 * t84 * t67;
  t256 = 0.5e1 / 0.24e2 * t54 * t205 * t67;
  t258 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t247 * t20 * t67 - 0.5e1 / 0.8e1 * t252 + t256);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t106 + 0.2e1 * t121 + t5 * (t233 + t258);

  t261 = t180 * t125;
  t265 = my_piecewise3(t9, 0, 0.2e1 * t186);
  t269 = my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t261 * t75 + 0.4e1 / 0.3e1 * t16 * t265);
  t270 = t4 * t269;
  t275 = t129 * t84 * t38;
  t277 = t129 * t88;
  t283 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t270 * t20 * t38 - 0.5e1 / 0.16e2 * t275 + 0.15e2 / 0.16e2 * t277 * t102 - 0.5e1 / 0.16e2 * t199 + t208 + 0.5e1 / 0.16e2 * t211);
  t284 = t235 * t136;
  t288 = my_piecewise3(t45, 0, 0.2e1 * t239);
  t292 = my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t284 * t109 + 0.4e1 / 0.3e1 * t51 * t288);
  t293 = t4 * t292;
  t298 = t140 * t84 * t67;
  t301 = t113 * t88;
  t304 = t54 * t209;
  t305 = t304 * t156;
  t308 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t293 * t20 * t67 - 0.5e1 / 0.16e2 * t298 - 0.5e1 / 0.16e2 * t252 + t256 + 0.15e2 / 0.16e2 * t301 * t156 + 0.5e1 / 0.16e2 * t305);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t106 + t121 + t134 + t160 + t5 * (t283 + t308);

  t313 = t125 * t125;
  t318 = my_piecewise3(t9, 0, 0.2e1 * t72 + 0.2e1 * t186);
  t322 = my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t180 * t313 + 0.4e1 / 0.3e1 * t16 * t318);
  t323 = t4 * t322;
  t329 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t323 * t20 * t38 - 0.5e1 / 0.8e1 * t275 + t208);
  t330 = t136 * t136;
  t335 = my_piecewise3(t45, 0, -0.2e1 * t72 + 0.2e1 * t239);
  t339 = my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t235 * t330 + 0.4e1 / 0.3e1 * t51 * t335);
  t340 = t4 * t339;
  t345 = t140 * t88;
  t350 = 0.1e1 / t145 / t64;
  t351 = t154 * t154;
  t353 = t90 * t350 * t351;
  t356 = t147 * rho[1];
  t358 = 0.1e1 / t57 / t356;
  t363 = 0.80e2 / 0.9e1 * tau[1] * t358 - 0.10e2 / 0.9e1 * lapl[1] * t358;
  t365 = t90 * t146 * t363;
  t369 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t340 * t20 * t67 - 0.5e1 / 0.8e1 * t298 + 0.15e2 / 0.8e1 * t345 * t156 + t256 + 0.5e1 / 0.8e1 * t305 - 0.15e2 / 0.8e1 * t144 * t353 + 0.15e2 / 0.16e2 * t144 * t365);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t134 + 0.2e1 * t160 + t5 * (t329 + t369);

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = 0.0e0;

  t372 = t201 * t164;
  t374 = t210 * t164;
  t375 = 0.5e1 / 0.64e2 * t374;
  t376 = t214 * t30;
  t378 = t90 * t376 * t100;
  t379 = t89 * t378;
  t382 = t90 * t92 * t95;
  t383 = t89 * t382;
  t386 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t372 - t375 + 0.15e2 / 0.32e2 * t379 + 0.25e2 / 0.64e2 * t383);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = t5 * t386 + t167;

  t388 = t301 * t169;
  t390 = t304 * t169;
  t391 = 0.5e1 / 0.64e2 * t390;
  t393 = my_piecewise3(t42, 0, -0.15e2 / 0.64e2 * t388 - t391);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[1] = t5 * t393 + t172;

  t395 = t277 * t164;
  t398 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t395 - t375);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[2] = t5 * t398 + t167;

  t400 = t345 * t169;
  t402 = t350 * t59;
  t404 = t90 * t402 * t154;
  t405 = t144 * t404;
  t408 = t90 * t146 * t149;
  t409 = t144 * t408;
  t412 = my_piecewise3(t42, 0, -0.15e2 / 0.64e2 * t400 - t391 + 0.15e2 / 0.32e2 * t405 + 0.25e2 / 0.64e2 * t409);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[3] = t5 * t412 + t172;

  t415 = 0.5e1 / 0.8e1 * t374;
  t419 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t372 + t415 - 0.15e2 / 0.4e1 * t379 - 0.25e2 / 0.8e1 * t383);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = t5 * t419 + t174;

  t422 = 0.5e1 / 0.8e1 * t390;
  t424 = my_piecewise3(t42, 0, 0.15e2 / 0.8e1 * t388 + t422);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[1] = t5 * t424 + t176;

  t428 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t395 + t415);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[2] = t5 * t428 + t174;

  t434 = my_piecewise3(t42, 0, 0.15e2 / 0.8e1 * t400 + t422 - 0.15e2 / 0.4e1 * t405 - 0.25e2 / 0.8e1 * t409);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[3] = t5 * t434 + t176;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[5] = 0.0e0;

  t437 = 0.1e1 / t27 / t220;
  t439 = t90 * t214 * t437;
  t440 = t89 * t439;
  t442 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t440);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = t5 * t442;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[1] = 0.0e0;

  t444 = 0.1e1 / t56 / t356;
  t446 = t90 * t350 * t444;
  t447 = t144 * t446;
  t449 = my_piecewise3(t42, 0, -0.15e2 / 0.128e3 * t447);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[2] = t5 * t449;

  t451 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t440);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = t5 * t451;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[2] = 0.0e0;

  t453 = my_piecewise3(t42, 0, 0.15e2 / 0.16e2 * t447);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[3] = t5 * t453;

  t455 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t440);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = t5 * t455;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[1] = 0.0e0;

  t457 = my_piecewise3(t42, 0, -0.15e2 / 0.2e1 * t447);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[2] = t5 * t457;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t461 = 0.1e1 / t179 / t14;
  t462 = t181 * t75;
  t465 = t180 * t75;
  t468 = t71 * t71;
  t469 = 0.1e1 / t468;
  t470 = t11 * t469;
  t473 = my_piecewise3(t9, 0, 0.6e1 * t185 - 0.6e1 * t470);
  t477 = my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t461 * t462 + 0.4e1 / 0.3e1 * t465 * t189 + 0.4e1 / 0.3e1 * t16 * t473);
  t478 = t4 * t477;
  t484 = t210 * t217;
  t486 = t91 * t91;
  t487 = 0.1e1 / t486;
  t488 = t215 * t100;
  t490 = t90 * t487 * t488;
  t493 = t214 * t100;
  t495 = t90 * t493 * t227;
  t499 = t194 * t84 * t38;
  t501 = t194 * t88;
  t505 = t79 * t205 * t38;
  t507 = t79 * t209;
  t508 = t507 * t102;
  t513 = 0.1e1 / t83 / t71;
  t516 = 0.25e2 / 0.72e2 * t19 * t513 * t38;
  t517 = t205 * params->prefactor;
  t518 = t19 * t517;
  t519 = t518 * t102;
  t521 = t210 * t229;
  t523 = t93 * t93;
  t525 = 0.1e1 / t28 / t523;
  t530 = -0.880e3 / 0.27e2 * tau[0] * t525 + 0.110e3 / 0.27e2 * lapl[0] * t525;
  t532 = t90 * t92 * t530;
  t535 = -0.15e2 / 0.16e2 * t478 * t20 * t38 - 0.45e2 / 0.8e1 * t201 * t217 - 0.15e2 / 0.8e1 * t484 + 0.45e2 / 0.8e1 * t89 * t490 - 0.45e2 / 0.8e1 * t89 * t495 - 0.15e2 / 0.16e2 * t499 + 0.45e2 / 0.16e2 * t501 * t102 + 0.5e1 / 0.8e1 * t505 + 0.15e2 / 0.8e1 * t508 + 0.45e2 / 0.16e2 * t201 * t229 - t516 - 0.5e1 / 0.8e1 * t519 + 0.15e2 / 0.16e2 * t521 + 0.15e2 / 0.16e2 * t89 * t532;
  t536 = my_piecewise3(t2, 0, t535);
  t538 = 0.1e1 / t234 / t49;
  t539 = t236 * t109;
  t542 = t235 * t109;
  t545 = t46 * t469;
  t548 = my_piecewise3(t45, 0, -0.6e1 * t185 - 0.6e1 * t545);
  t552 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t538 * t539 + 0.4e1 / 0.3e1 * t542 * t242 + 0.4e1 / 0.3e1 * t51 * t548);
  t553 = t4 * t552;
  t558 = t247 * t84 * t67;
  t561 = t113 * t205 * t67;
  t565 = 0.25e2 / 0.72e2 * t54 * t513 * t67;
  t567 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t553 * t20 * t67 - 0.15e2 / 0.16e2 * t558 + 0.5e1 / 0.8e1 * t561 - t565);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t233 + 0.3e1 * t258 + t5 * (t536 + t567);

  t570 = 0.2e1 * t283;
  t571 = 0.2e1 * t308;
  t572 = t461 * t125;
  t575 = t180 * t265;
  t580 = 0.2e1 * t185;
  t581 = 0.6e1 * t470;
  t583 = my_piecewise3(t9, 0, t580 - t581);
  t587 = my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t572 * t181 + 0.8e1 / 0.9e1 * t575 * t75 + 0.4e1 / 0.9e1 * t261 * t189 + 0.4e1 / 0.3e1 * t16 * t583);
  t588 = t4 * t587;
  t594 = 0.5e1 / 0.8e1 * t270 * t84 * t38;
  t595 = t270 * t88;
  t599 = t129 * t205 * t38;
  t601 = t129 * t209;
  t603 = 0.5e1 / 0.8e1 * t601 * t102;
  t614 = -0.15e2 / 0.16e2 * t588 * t20 * t38 - t594 + 0.15e2 / 0.8e1 * t595 * t102 + 0.5e1 / 0.24e2 * t599 + t603 - 0.15e2 / 0.8e1 * t277 * t217 + 0.15e2 / 0.16e2 * t277 * t229 - 0.5e1 / 0.16e2 * t499 + 0.5e1 / 0.12e2 * t505 + 0.5e1 / 0.8e1 * t508 - t516 - 0.5e1 / 0.12e2 * t519 - 0.5e1 / 0.8e1 * t484 + 0.5e1 / 0.16e2 * t521;
  t615 = my_piecewise3(t2, 0, t614);
  t616 = t538 * t136;
  t619 = t235 * t288;
  t624 = 0.6e1 * t545;
  t626 = my_piecewise3(t45, 0, -t580 - t624);
  t630 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t616 * t236 + 0.8e1 / 0.9e1 * t619 * t109 + 0.4e1 / 0.9e1 * t284 * t242 + 0.4e1 / 0.3e1 * t51 * t626);
  t631 = t4 * t630;
  t637 = 0.5e1 / 0.8e1 * t293 * t84 * t67;
  t639 = t140 * t205 * t67;
  t643 = t247 * t88;
  t646 = t113 * t209;
  t648 = 0.5e1 / 0.8e1 * t646 * t156;
  t649 = t54 * t517;
  t650 = t649 * t156;
  t653 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t631 * t20 * t67 - t637 + 0.5e1 / 0.24e2 * t639 - 0.5e1 / 0.16e2 * t558 + 0.5e1 / 0.12e2 * t561 - t565 + 0.15e2 / 0.16e2 * t643 * t156 + t648 - 0.5e1 / 0.24e2 * t650);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t233 + t258 + t570 + t571 + t5 * (t615 + t653);

  t656 = t461 * t313;
  t661 = t180 * t318;
  t665 = my_piecewise3(t9, 0, -t580 - t581);
  t669 = my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t656 * t75 + 0.8e1 / 0.9e1 * t261 * t265 + 0.4e1 / 0.9e1 * t661 * t75 + 0.4e1 / 0.3e1 * t16 * t665);
  t670 = t4 * t669;
  t675 = t323 * t84 * t38;
  t677 = t323 * t88;
  t684 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t670 * t20 * t38 - 0.5e1 / 0.16e2 * t675 + 0.15e2 / 0.16e2 * t677 * t102 - t594 + 0.5e1 / 0.12e2 * t599 + t603 + 0.5e1 / 0.24e2 * t505 - t516 - 0.5e1 / 0.24e2 * t519);
  t685 = t538 * t330;
  t690 = t235 * t335;
  t694 = my_piecewise3(t45, 0, t580 - t624);
  t698 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t685 * t109 + 0.8e1 / 0.9e1 * t284 * t288 + 0.4e1 / 0.9e1 * t690 * t109 + 0.4e1 / 0.3e1 * t51 * t694);
  t699 = t4 * t698;
  t704 = t340 * t84 * t67;
  t707 = t293 * t88;
  t710 = t140 * t209;
  t711 = t710 * t156;
  t717 = t304 * t353;
  t721 = t304 * t365;
  t723 = -0.15e2 / 0.16e2 * t699 * t20 * t67 - 0.5e1 / 0.16e2 * t704 - t637 + 0.5e1 / 0.12e2 * t639 + 0.15e2 / 0.8e1 * t707 * t156 + 0.5e1 / 0.8e1 * t711 + 0.5e1 / 0.24e2 * t561 - t565 + t648 - 0.5e1 / 0.12e2 * t650 - 0.15e2 / 0.8e1 * t301 * t353 - 0.5e1 / 0.8e1 * t717 + 0.15e2 / 0.16e2 * t301 * t365 + 0.5e1 / 0.16e2 * t721;
  t724 = my_piecewise3(t42, 0, t723);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t570 + t571 + t329 + t369 + t5 * (t684 + t724);

  t729 = t313 * t125;
  t736 = my_piecewise3(t9, 0, -0.6e1 * t185 - 0.6e1 * t470);
  t740 = my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t461 * t729 + 0.4e1 / 0.3e1 * t261 * t318 + 0.4e1 / 0.3e1 * t16 * t736);
  t741 = t4 * t740;
  t748 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t741 * t20 * t38 - 0.15e2 / 0.16e2 * t675 + 0.5e1 / 0.8e1 * t599 - t516);
  t749 = t330 * t136;
  t756 = my_piecewise3(t45, 0, 0.6e1 * t185 - 0.6e1 * t545);
  t760 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t538 * t749 + 0.4e1 / 0.3e1 * t284 * t335 + 0.4e1 / 0.3e1 * t51 * t756);
  t761 = t4 * t760;
  t767 = t145 * t145;
  t768 = 0.1e1 / t767;
  t769 = t351 * t154;
  t771 = t90 * t768 * t769;
  t774 = t350 * t154;
  t776 = t90 * t774 * t363;
  t785 = t340 * t88;
  t790 = t147 * t147;
  t792 = 0.1e1 / t57 / t790;
  t797 = -0.880e3 / 0.27e2 * tau[1] * t792 + 0.110e3 / 0.27e2 * lapl[1] * t792;
  t799 = t90 * t146 * t797;
  t802 = -0.15e2 / 0.16e2 * t761 * t20 * t67 - 0.45e2 / 0.8e1 * t345 * t353 + 0.45e2 / 0.8e1 * t144 * t771 - 0.45e2 / 0.8e1 * t144 * t776 + 0.15e2 / 0.8e1 * t711 - 0.15e2 / 0.8e1 * t717 + 0.15e2 / 0.16e2 * t721 - 0.5e1 / 0.8e1 * t650 - t565 + 0.5e1 / 0.8e1 * t639 - 0.15e2 / 0.16e2 * t704 + 0.45e2 / 0.16e2 * t785 * t156 + 0.45e2 / 0.16e2 * t345 * t365 + 0.15e2 / 0.16e2 * t144 * t799;
  t803 = my_piecewise3(t42, 0, t802);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t329 + 0.3e1 * t369 + t5 * (t748 + t803);

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = 0.0e0;

  t807 = t501 * t164;
  t809 = t507 * t164;
  t811 = t201 * t378;
  t813 = t201 * t382;
  t815 = t518 * t164;
  t816 = 0.5e1 / 0.96e2 * t815;
  t817 = t210 * t378;
  t819 = t210 * t382;
  t823 = t90 * t487 * t30 * t215;
  t824 = t89 * t823;
  t826 = t214 * t95;
  t828 = t90 * t826 * t100;
  t829 = t89 * t828;
  t832 = t90 * t376 * t227;
  t833 = t89 * t832;
  t836 = t90 * t92 * t222;
  t837 = t89 * t836;
  t839 = -0.15e2 / 0.64e2 * t807 - 0.5e1 / 0.32e2 * t809 + 0.15e2 / 0.16e2 * t811 + 0.25e2 / 0.32e2 * t813 + t816 + 0.5e1 / 0.16e2 * t817 + 0.25e2 / 0.96e2 * t819 - 0.45e2 / 0.32e2 * t824 - 0.25e2 / 0.16e2 * t829 + 0.15e2 / 0.32e2 * t833 - 0.25e2 / 0.24e2 * t837;
  t840 = my_piecewise3(t2, 0, t839);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = t5 * t840 + 0.2e1 * t386;

  t843 = t643 * t169;
  t845 = t646 * t169;
  t847 = t649 * t169;
  t848 = 0.5e1 / 0.96e2 * t847;
  t850 = my_piecewise3(t42, 0, -0.15e2 / 0.64e2 * t843 - 0.5e1 / 0.32e2 * t845 + t848);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[1] = t5 * t850 + 0.2e1 * t393;

  t852 = t595 * t164;
  t854 = t601 * t164;
  t856 = t277 * t378;
  t858 = t277 * t382;
  t864 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t852 - 0.5e1 / 0.64e2 * t854 + 0.15e2 / 0.32e2 * t856 + 0.25e2 / 0.64e2 * t858 - 0.5e1 / 0.64e2 * t809 + t816 + 0.5e1 / 0.32e2 * t817 + 0.25e2 / 0.192e3 * t819);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[2] = t5 * t864 + t386 + t398;

  t866 = t707 * t169;
  t868 = t710 * t169;
  t871 = t301 * t404;
  t873 = t304 * t404;
  t875 = t301 * t408;
  t877 = t304 * t408;
  t880 = my_piecewise3(t42, 0, -0.15e2 / 0.64e2 * t866 - 0.5e1 / 0.64e2 * t868 - 0.5e1 / 0.64e2 * t845 + t848 + 0.15e2 / 0.32e2 * t871 + 0.5e1 / 0.32e2 * t873 + 0.25e2 / 0.64e2 * t875 + 0.25e2 / 0.192e3 * t877);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[3] = t5 * t880 + t393 + t412;

  t883 = t677 * t164;
  t887 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t883 - 0.5e1 / 0.32e2 * t854 + t816);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[4] = t5 * t887 + 0.2e1 * t398;

  t890 = t785 * t169;
  t893 = t345 * t404;
  t895 = t345 * t408;
  t901 = t90 * t768 * t59 * t351;
  t902 = t144 * t901;
  t904 = t350 * t149;
  t906 = t90 * t904 * t154;
  t907 = t144 * t906;
  t910 = t90 * t402 * t363;
  t911 = t144 * t910;
  t914 = t90 * t146 * t358;
  t915 = t144 * t914;
  t917 = -0.15e2 / 0.64e2 * t890 - 0.5e1 / 0.32e2 * t868 + 0.15e2 / 0.16e2 * t893 + 0.25e2 / 0.32e2 * t895 + t848 + 0.5e1 / 0.16e2 * t873 + 0.25e2 / 0.96e2 * t877 - 0.45e2 / 0.32e2 * t902 - 0.25e2 / 0.16e2 * t907 + 0.15e2 / 0.32e2 * t911 - 0.25e2 / 0.24e2 * t915;
  t918 = my_piecewise3(t42, 0, t917);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[5] = t5 * t918 + 0.2e1 * t412;

  t925 = 0.5e1 / 0.12e2 * t815;
  t932 = 0.15e2 / 0.8e1 * t807 + 0.5e1 / 0.4e1 * t809 - 0.15e2 / 0.2e1 * t811 - 0.25e2 / 0.4e1 * t813 - t925 - 0.5e1 / 0.2e1 * t817 - 0.25e2 / 0.12e2 * t819 + 0.45e2 / 0.4e1 * t824 + 0.25e2 / 0.2e1 * t829 - 0.15e2 / 0.4e1 * t833 + 0.25e2 / 0.3e1 * t837;
  t933 = my_piecewise3(t2, 0, t932);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = t5 * t933 + 0.2e1 * t419;

  t938 = 0.5e1 / 0.12e2 * t847;
  t940 = my_piecewise3(t42, 0, 0.15e2 / 0.8e1 * t843 + 0.5e1 / 0.4e1 * t845 - t938);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[1] = t5 * t940 + 0.2e1 * t424;

  t950 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t852 + 0.5e1 / 0.8e1 * t854 - 0.15e2 / 0.4e1 * t856 - 0.25e2 / 0.8e1 * t858 + 0.5e1 / 0.8e1 * t809 - t925 - 0.5e1 / 0.4e1 * t817 - 0.25e2 / 0.24e2 * t819);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[2] = t5 * t950 + t419 + t428;

  t960 = my_piecewise3(t42, 0, 0.15e2 / 0.8e1 * t866 + 0.5e1 / 0.8e1 * t868 + 0.5e1 / 0.8e1 * t845 - t938 - 0.15e2 / 0.4e1 * t871 - 0.5e1 / 0.4e1 * t873 - 0.25e2 / 0.8e1 * t875 - 0.25e2 / 0.24e2 * t877);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[3] = t5 * t960 + t424 + t434;

  t966 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t883 + 0.5e1 / 0.4e1 * t854 - t925);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[4] = t5 * t966 + 0.2e1 * t428;

  t979 = 0.15e2 / 0.8e1 * t890 + 0.5e1 / 0.4e1 * t868 - 0.15e2 / 0.2e1 * t893 - 0.25e2 / 0.4e1 * t895 - t938 - 0.5e1 / 0.2e1 * t873 - 0.25e2 / 0.12e2 * t877 + 0.45e2 / 0.4e1 * t902 + 0.25e2 / 0.2e1 * t907 - 0.15e2 / 0.4e1 * t911 + 0.25e2 / 0.3e1 * t915;
  t980 = my_piecewise3(t42, 0, t979);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[5] = t5 * t980 + 0.2e1 * t434;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[11] = 0.0e0;

  t982 = t201 * t439;
  t984 = t210 * t439;
  t985 = 0.5e1 / 0.128e3 * t984;
  t986 = t487 * t437;
  t988 = t90 * t986 * t100;
  t989 = t89 * t988;
  t992 = 0.1e1 / t27 / t523;
  t994 = t90 * t214 * t992;
  t995 = t89 * t994;
  t998 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t982 - t985 + 0.45e2 / 0.128e3 * t989 + 0.25e2 / 0.64e2 * t995);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = t5 * t998 + t442;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[1] = 0.0e0;

  t1000 = t301 * t446;
  t1002 = t304 * t446;
  t1003 = 0.5e1 / 0.128e3 * t1002;
  t1005 = my_piecewise3(t42, 0, -0.15e2 / 0.128e3 * t1000 - t1003);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[2] = t5 * t1005 + t449;

  t1007 = t277 * t439;
  t1010 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t1007 - t985);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[3] = t5 * t1010 + t442;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[4] = 0.0e0;

  t1012 = t345 * t446;
  t1014 = t768 * t444;
  t1016 = t90 * t1014 * t154;
  t1017 = t144 * t1016;
  t1020 = 0.1e1 / t56 / t790;
  t1022 = t90 * t350 * t1020;
  t1023 = t144 * t1022;
  t1026 = my_piecewise3(t42, 0, -0.15e2 / 0.128e3 * t1012 - t1003 + 0.45e2 / 0.128e3 * t1017 + 0.25e2 / 0.64e2 * t1023);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[5] = t5 * t1026 + t449;

  t1029 = 0.5e1 / 0.16e2 * t984;
  t1033 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t982 + t1029 - 0.45e2 / 0.16e2 * t989 - 0.25e2 / 0.8e1 * t995);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = t5 * t1033 + t451;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[2] = 0.0e0;

  t1036 = 0.5e1 / 0.16e2 * t1002;
  t1038 = my_piecewise3(t42, 0, 0.15e2 / 0.16e2 * t1000 + t1036);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[3] = t5 * t1038 + t453;

  t1042 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t1007 + t1029);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[4] = t5 * t1042 + t451;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[6] = 0.0e0;

  t1048 = my_piecewise3(t42, 0, 0.15e2 / 0.16e2 * t1012 + t1036 - 0.45e2 / 0.16e2 * t1017 - 0.25e2 / 0.8e1 * t1023);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[7] = t5 * t1048 + t453;

  t1051 = 0.5e1 / 0.2e1 * t984;
  t1055 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t982 - t1051 + 0.45e2 / 0.2e1 * t989 + 0.25e2 * t995);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = t5 * t1055 + t455;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[1] = 0.0e0;

  t1058 = 0.5e1 / 0.2e1 * t1002;
  t1060 = my_piecewise3(t42, 0, -0.15e2 / 0.2e1 * t1000 - t1058);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[2] = t5 * t1060 + t457;

  t1064 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t1007 - t1051);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[3] = t5 * t1064 + t455;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[4] = 0.0e0;

  t1070 = my_piecewise3(t42, 0, -0.15e2 / 0.2e1 * t1012 - t1058 + 0.45e2 / 0.2e1 * t1017 + 0.25e2 * t1023);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[5] = t5 * t1070 + t457;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[8] = 0.0e0;

  t1072 = t523 * rho[0];
  t1073 = 0.1e1 / t1072;
  t1075 = t90 * t487 * t1073;
  t1076 = t89 * t1075;
  t1078 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t1076);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = t5 * t1078;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[2] = 0.0e0;

  t1079 = t790 * rho[1];
  t1080 = 0.1e1 / t1079;
  t1082 = t90 * t768 * t1080;
  t1083 = t144 * t1082;
  t1085 = my_piecewise3(t42, 0, -0.45e2 / 0.512e3 * t1083);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[3] = t5 * t1085;

  t1087 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t1076);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = t5 * t1087;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[4] = 0.0e0;

  t1089 = my_piecewise3(t42, 0, 0.45e2 / 0.64e2 * t1083);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[5] = t5 * t1089;

  t1091 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t1076);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = t5 * t1091;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[4] = 0.0e0;

  t1093 = my_piecewise3(t42, 0, -0.45e2 / 0.8e1 * t1083);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[5] = t5 * t1093;

  t1095 = my_piecewise3(t2, 0, 0.45e2 * t1076);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = t5 * t1095;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[2] = 0.0e0;

  t1097 = my_piecewise3(t42, 0, 0.45e2 * t1083);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[3] = t5 * t1097;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t1100 = t227 * t227;
  t1105 = t507 * t217;
  t1109 = t518 * t217;
  t1111 = t513 * params->prefactor;
  t1112 = t19 * t1111;
  t1113 = t1112 * t102;
  t1115 = t518 * t229;
  t1117 = t210 * t532;
  t1120 = 0.1e1 / t28 / t1072;
  t1130 = t194 * t209;
  t1131 = t1130 * t102;
  t1135 = t79 * t517;
  t1136 = t1135 * t102;
  t1138 = t507 * t229;
  t1142 = -0.45e2 / 0.8e1 * t89 * t90 * t214 * t1100 - 0.15e2 / 0.2e1 * t1105 + 0.45e2 / 0.2e1 * t201 * t490 + 0.5e1 / 0.2e1 * t1109 + 0.25e2 / 0.18e2 * t1113 - 0.5e1 / 0.4e1 * t1115 + 0.5e1 / 0.4e1 * t1117 + 0.15e2 / 0.16e2 * t89 * t90 * t92 * (0.12320e5 / 0.81e2 * tau[0] * t1120 - 0.1540e4 / 0.81e2 * lapl[0] * t1120) + 0.15e2 / 0.4e1 * t1131 + 0.45e2 / 0.8e1 * t501 * t229 - 0.5e1 / 0.2e1 * t1136 + 0.15e2 / 0.4e1 * t1138 + 0.15e2 / 0.4e1 * t201 * t532;
  t1143 = t478 * t88;
  t1148 = t210 * t490;
  t1151 = 0.1e1 / t486 / t35;
  t1152 = t215 * t215;
  t1163 = t210 * t495;
  t1171 = t194 * t205 * t38;
  t1174 = t79 * t513 * t38;
  t1177 = 0.1e1 / t83 / t184;
  t1180 = 0.25e2 / 0.27e2 * t19 * t1177 * t38;
  t1182 = t478 * t84 * t38;
  t1184 = t14 * t14;
  t1186 = 0.1e1 / t179 / t1184;
  t1187 = t181 * t181;
  t1193 = t189 * t189;
  t1199 = 0.1e1 / t468 / t5;
  t1200 = t11 * t1199;
  t1203 = my_piecewise3(t9, 0, -0.24e2 * t469 + 0.24e2 * t1200);
  t1207 = my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t1186 * t1187 - 0.16e2 / 0.9e1 * t461 * t181 * t189 + 0.4e1 / 0.3e1 * t180 * t1193 + 0.16e2 / 0.9e1 * t465 * t473 + 0.4e1 / 0.3e1 * t16 * t1203);
  t1212 = 0.15e2 / 0.4e1 * t1143 * t102 - 0.45e2 / 0.4e1 * t501 * t217 + 0.15e2 / 0.2e1 * t1148 - 0.45e2 / 0.2e1 * t89 * t90 * t1151 * t1152 - 0.15e2 / 0.2e1 * t89 * t90 * t493 * t530 - 0.45e2 / 0.2e1 * t201 * t495 - 0.15e2 / 0.2e1 * t1163 + 0.135e3 / 0.4e1 * t89 * t90 * t487 * t215 * t227 + 0.5e1 / 0.4e1 * t1171 - 0.25e2 / 0.18e2 * t1174 + t1180 - 0.5e1 / 0.4e1 * t1182 - 0.15e2 / 0.16e2 * t4 * t1207 * t20 * t38;
  t1214 = my_piecewise3(t2, 0, t1142 + t1212);
  t1215 = t49 * t49;
  t1217 = 0.1e1 / t234 / t1215;
  t1218 = t236 * t236;
  t1224 = t242 * t242;
  t1229 = t46 * t1199;
  t1232 = my_piecewise3(t45, 0, 0.24e2 * t469 + 0.24e2 * t1229);
  t1236 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1217 * t1218 - 0.16e2 / 0.9e1 * t538 * t236 * t242 + 0.4e1 / 0.3e1 * t235 * t1224 + 0.16e2 / 0.9e1 * t542 * t548 + 0.4e1 / 0.3e1 * t51 * t1232);
  t1242 = t553 * t84 * t67;
  t1245 = t247 * t205 * t67;
  t1248 = t113 * t513 * t67;
  t1252 = 0.25e2 / 0.27e2 * t54 * t1177 * t67;
  t1254 = my_piecewise3(t42, 0, -0.15e2 / 0.16e2 * t4 * t1236 * t20 * t67 - 0.5e1 / 0.4e1 * t1242 + 0.5e1 / 0.4e1 * t1245 - 0.25e2 / 0.18e2 * t1248 + t1252);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t536 + 0.4e1 * t567 + t5 * (t1214 + t1254);

  t1261 = t601 * t217;
  t1267 = t129 * t517;
  t1268 = t1267 * t102;
  t1269 = 0.5e1 / 0.8e1 * t1268;
  t1270 = t601 * t229;
  t1274 = t588 * t88;
  t1277 = t270 * t209;
  t1278 = t1277 * t102;
  t1285 = -0.45e2 / 0.8e1 * t595 * t217 - 0.15e2 / 0.8e1 * t1261 + 0.45e2 / 0.8e1 * t277 * t490 - 0.15e2 / 0.8e1 * t1105 + 0.5e1 / 0.4e1 * t1109 - t1269 + 0.15e2 / 0.16e2 * t1270 + 0.15e2 / 0.16e2 * t277 * t532 + 0.45e2 / 0.16e2 * t1274 * t102 + 0.15e2 / 0.8e1 * t1278 + 0.45e2 / 0.16e2 * t595 * t229 + 0.25e2 / 0.24e2 * t1113 - 0.5e1 / 0.8e1 * t1115 + 0.5e1 / 0.16e2 * t1117;
  t1297 = t588 * t84 * t38;
  t1300 = t270 * t205 * t38;
  t1301 = 0.5e1 / 0.8e1 * t1300;
  t1303 = t129 * t513 * t38;
  t1321 = 0.12e2 * t469;
  t1322 = 0.24e2 * t1200;
  t1324 = my_piecewise3(t9, 0, -t1321 + t1322);
  t1328 = my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t1186 * t125 * t462 - 0.8e1 / 0.9e1 * t461 * t265 * t181 - 0.8e1 / 0.9e1 * t572 * t75 * t189 + 0.4e1 / 0.3e1 * t180 * t583 * t75 + 0.4e1 / 0.3e1 * t575 * t189 + 0.4e1 / 0.9e1 * t261 * t473 + 0.4e1 / 0.3e1 * t16 * t1324);
  t1333 = 0.15e2 / 0.16e2 * t1131 - 0.5e1 / 0.4e1 * t1136 + 0.15e2 / 0.16e2 * t1138 + 0.15e2 / 0.8e1 * t1148 - 0.45e2 / 0.8e1 * t277 * t495 - 0.15e2 / 0.8e1 * t1163 + 0.5e1 / 0.8e1 * t1171 - 0.25e2 / 0.24e2 * t1174 + t1180 - 0.5e1 / 0.16e2 * t1182 - 0.15e2 / 0.16e2 * t1297 + t1301 - 0.25e2 / 0.72e2 * t1303 - 0.15e2 / 0.16e2 * t4 * t1328 * t20 * t38;
  t1335 = my_piecewise3(t2, 0, t1285 + t1333);
  t1352 = 0.24e2 * t1229;
  t1354 = my_piecewise3(t45, 0, t1321 + t1352);
  t1358 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1217 * t136 * t539 - 0.8e1 / 0.9e1 * t538 * t288 * t236 - 0.8e1 / 0.9e1 * t616 * t109 * t242 + 0.4e1 / 0.3e1 * t235 * t626 * t109 + 0.4e1 / 0.3e1 * t619 * t242 + 0.4e1 / 0.9e1 * t284 * t548 + 0.4e1 / 0.3e1 * t51 * t1354);
  t1364 = t631 * t84 * t67;
  t1367 = t293 * t205 * t67;
  t1368 = 0.5e1 / 0.8e1 * t1367;
  t1370 = t140 * t513 * t67;
  t1375 = t553 * t88;
  t1378 = t247 * t209;
  t1379 = t1378 * t156;
  t1381 = t113 * t517;
  t1382 = t1381 * t156;
  t1383 = 0.5e1 / 0.8e1 * t1382;
  t1384 = t54 * t1111;
  t1385 = t1384 * t156;
  t1387 = -0.15e2 / 0.16e2 * t4 * t1358 * t20 * t67 - 0.15e2 / 0.16e2 * t1364 + t1368 - 0.25e2 / 0.72e2 * t1370 - 0.5e1 / 0.16e2 * t1242 + 0.5e1 / 0.8e1 * t1245 - 0.25e2 / 0.24e2 * t1248 + t1252 + 0.15e2 / 0.16e2 * t1375 * t156 + 0.15e2 / 0.16e2 * t1379 - t1383 + 0.25e2 / 0.72e2 * t1385;
  t1388 = my_piecewise3(t42, 0, t1387);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t536 + t567 + 0.3e1 * t615 + 0.3e1 * t653 + t5 * (t1335 + t1388);

  t1398 = t670 * t84 * t38;
  t1400 = t670 * t88;
  t1404 = t323 * t205 * t38;
  t1406 = t323 * t209;
  t1407 = t1406 * t102;
  t1433 = t265 * t265;
  t1446 = my_piecewise3(t9, 0, t1322);
  t1450 = my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t1186 * t313 * t181 - 0.32e2 / 0.27e2 * t572 * t75 * t265 - 0.8e1 / 0.27e2 * t656 * t189 + 0.8e1 / 0.9e1 * t180 * t1433 + 0.8e1 / 0.9e1 * t261 * t583 - 0.8e1 / 0.27e2 * t461 * t318 * t181 + 0.8e1 / 0.9e1 * t180 * t665 * t75 + 0.4e1 / 0.9e1 * t661 * t189 + 0.4e1 / 0.3e1 * t16 * t1446);
  t1455 = -0.25e2 / 0.36e2 * t1303 + 0.25e2 / 0.36e2 * t1113 - 0.5e1 / 0.24e2 * t1115 + 0.5e1 / 0.24e2 * t1171 - 0.25e2 / 0.36e2 * t1174 - 0.5e1 / 0.12e2 * t1136 + t1180 - 0.15e2 / 0.8e1 * t677 * t217 - 0.5e1 / 0.4e1 * t1261 + 0.5e1 / 0.12e2 * t1109 - 0.15e2 / 0.16e2 * t4 * t1450 * t20 * t38;
  t1457 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t677 * t229 - 0.5e1 / 0.8e1 * t1398 + 0.15e2 / 0.8e1 * t1400 * t102 + 0.5e1 / 0.24e2 * t1404 + 0.5e1 / 0.8e1 * t1407 - 0.5e1 / 0.6e1 * t1268 + 0.5e1 / 0.8e1 * t1270 - 0.5e1 / 0.8e1 * t1297 + 0.5e1 / 0.6e1 * t1300 + 0.5e1 / 0.4e1 * t1278 + t1455);
  t1461 = t699 * t84 * t67;
  t1464 = t340 * t205 * t67;
  t1466 = t631 * t88;
  t1477 = t649 * t353;
  t1479 = t646 * t365;
  t1481 = t649 * t365;
  t1483 = t293 * t209;
  t1484 = t1483 * t156;
  t1486 = t140 * t517;
  t1487 = t1486 * t156;
  t1489 = t646 * t353;
  t1502 = t288 * t288;
  t1515 = my_piecewise3(t45, 0, t1352);
  t1519 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1217 * t330 * t236 - 0.32e2 / 0.27e2 * t616 * t109 * t288 - 0.8e1 / 0.27e2 * t685 * t242 + 0.8e1 / 0.9e1 * t235 * t1502 + 0.8e1 / 0.9e1 * t284 * t626 - 0.8e1 / 0.27e2 * t538 * t335 * t236 + 0.8e1 / 0.9e1 * t235 * t694 * t109 + 0.4e1 / 0.9e1 * t690 * t242 + 0.4e1 / 0.3e1 * t51 * t1515);
  t1524 = -0.25e2 / 0.36e2 * t1248 + 0.5e1 / 0.12e2 * t1477 + 0.5e1 / 0.8e1 * t1479 - 0.5e1 / 0.24e2 * t1481 + 0.5e1 / 0.4e1 * t1484 - 0.5e1 / 0.12e2 * t1487 - 0.5e1 / 0.4e1 * t1489 + 0.5e1 / 0.8e1 * t1379 - 0.5e1 / 0.6e1 * t1382 + 0.25e2 / 0.36e2 * t1385 - 0.15e2 / 0.16e2 * t4 * t1519 * t20 * t67;
  t1526 = my_piecewise3(t42, 0, 0.15e2 / 0.16e2 * t643 * t365 - 0.5e1 / 0.8e1 * t1461 + 0.5e1 / 0.24e2 * t1464 + 0.15e2 / 0.8e1 * t1466 * t156 - 0.15e2 / 0.8e1 * t643 * t353 - 0.5e1 / 0.8e1 * t1364 + 0.5e1 / 0.6e1 * t1367 - 0.25e2 / 0.36e2 * t1370 + t1252 + 0.5e1 / 0.24e2 * t1245 + t1524);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t615 + 0.2e1 * t653 + 0.2e1 * t684 + 0.2e1 * t724 + t5 * (t1457 + t1526);

  t1547 = my_piecewise3(t9, 0, t1321 + t1322);
  t1551 = my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t1186 * t729 * t75 - 0.8e1 / 0.9e1 * t656 * t265 - 0.8e1 / 0.9e1 * t572 * t318 * t75 + 0.4e1 / 0.3e1 * t575 * t318 + 0.4e1 / 0.3e1 * t261 * t665 + 0.4e1 / 0.9e1 * t180 * t736 * t75 + 0.4e1 / 0.3e1 * t16 * t1547);
  t1557 = t741 * t84 * t38;
  t1559 = t741 * t88;
  t1568 = -0.15e2 / 0.16e2 * t4 * t1551 * t20 * t38 - 0.5e1 / 0.16e2 * t1557 + 0.15e2 / 0.16e2 * t1559 * t102 - 0.15e2 / 0.16e2 * t1398 + 0.5e1 / 0.8e1 * t1404 + 0.15e2 / 0.16e2 * t1407 + t1301 - 0.25e2 / 0.24e2 * t1303 - t1269 - 0.25e2 / 0.72e2 * t1174 + t1180 + 0.25e2 / 0.72e2 * t1113;
  t1569 = my_piecewise3(t2, 0, t1568);
  t1570 = t340 * t209;
  t1571 = t1570 * t156;
  t1573 = t710 * t365;
  t1575 = t304 * t799;
  t1577 = t710 * t353;
  t1579 = t699 * t88;
  t1590 = t304 * t771;
  t1596 = 0.15e2 / 0.16e2 * t1571 + 0.15e2 / 0.16e2 * t1573 + 0.5e1 / 0.16e2 * t1575 - 0.15e2 / 0.8e1 * t1577 + 0.45e2 / 0.16e2 * t1579 * t156 + 0.45e2 / 0.16e2 * t707 * t365 + 0.15e2 / 0.16e2 * t301 * t799 - 0.45e2 / 0.8e1 * t707 * t353 + 0.45e2 / 0.8e1 * t301 * t771 + 0.15e2 / 0.8e1 * t1590 + 0.5e1 / 0.4e1 * t1477 + 0.15e2 / 0.16e2 * t1479 - 0.5e1 / 0.8e1 * t1481 + 0.15e2 / 0.8e1 * t1484;
  t1600 = t304 * t776;
  t1620 = my_piecewise3(t45, 0, -t1321 + t1352);
  t1624 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1217 * t749 * t109 - 0.8e1 / 0.9e1 * t685 * t288 - 0.8e1 / 0.9e1 * t616 * t335 * t109 + 0.4e1 / 0.3e1 * t619 * t335 + 0.4e1 / 0.3e1 * t284 * t694 + 0.4e1 / 0.9e1 * t235 * t756 * t109 + 0.4e1 / 0.3e1 * t51 * t1620);
  t1633 = t761 * t84 * t67;
  t1636 = -0.5e1 / 0.4e1 * t1487 - 0.15e2 / 0.8e1 * t1489 - t1383 + 0.25e2 / 0.24e2 * t1385 - 0.15e2 / 0.8e1 * t1600 - 0.45e2 / 0.8e1 * t301 * t776 - 0.15e2 / 0.16e2 * t4 * t1624 * t20 * t67 - 0.25e2 / 0.24e2 * t1370 - 0.15e2 / 0.16e2 * t1461 + 0.5e1 / 0.8e1 * t1464 - 0.5e1 / 0.16e2 * t1633 - 0.25e2 / 0.72e2 * t1248 + t1252 + t1368;
  t1638 = my_piecewise3(t42, 0, t1596 + t1636);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t684 + 0.3e1 * t724 + t748 + t803 + t5 * (t1569 + t1638);

  t1643 = t313 * t313;
  t1648 = t318 * t318;
  t1655 = my_piecewise3(t9, 0, 0.24e2 * t469 + 0.24e2 * t1200);
  t1659 = my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t1186 * t1643 - 0.16e2 / 0.9e1 * t656 * t318 + 0.4e1 / 0.3e1 * t180 * t1648 + 0.16e2 / 0.9e1 * t261 * t736 + 0.4e1 / 0.3e1 * t16 * t1655);
  t1668 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t4 * t1659 * t20 * t38 - 0.5e1 / 0.4e1 * t1557 + 0.5e1 / 0.4e1 * t1404 - 0.25e2 / 0.18e2 * t1303 + t1180);
  t1678 = 0.1e1 / t57 / t1079;
  t1688 = t761 * t88;
  t1696 = 0.1e1 / t767 / t64;
  t1697 = t351 * t351;
  t1702 = t363 * t363;
  t1708 = 0.15e2 / 0.4e1 * t1571 + 0.15e2 / 0.4e1 * t1573 + 0.5e1 / 0.4e1 * t1575 - 0.15e2 / 0.2e1 * t1577 + 0.45e2 / 0.8e1 * t785 * t365 + 0.15e2 / 0.4e1 * t345 * t799 + 0.15e2 / 0.16e2 * t144 * t90 * t146 * (0.12320e5 / 0.81e2 * tau[1] * t1678 - 0.1540e4 / 0.81e2 * lapl[1] * t1678) + 0.15e2 / 0.4e1 * t1688 * t156 - 0.45e2 / 0.4e1 * t785 * t353 + 0.45e2 / 0.2e1 * t345 * t771 - 0.45e2 / 0.2e1 * t144 * t90 * t1696 * t1697 - 0.45e2 / 0.8e1 * t144 * t90 * t350 * t1702 + 0.15e2 / 0.2e1 * t1590;
  t1725 = t330 * t330;
  t1730 = t335 * t335;
  t1737 = my_piecewise3(t45, 0, -0.24e2 * t469 + 0.24e2 * t1229);
  t1741 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1217 * t1725 - 0.16e2 / 0.9e1 * t685 * t335 + 0.4e1 / 0.3e1 * t235 * t1730 + 0.16e2 / 0.9e1 * t284 * t756 + 0.4e1 / 0.3e1 * t51 * t1737);
  t1749 = 0.5e1 / 0.2e1 * t1477 - 0.5e1 / 0.4e1 * t1481 - 0.5e1 / 0.2e1 * t1487 + 0.25e2 / 0.18e2 * t1385 - 0.15e2 / 0.2e1 * t144 * t90 * t774 * t797 - 0.45e2 / 0.2e1 * t345 * t776 + 0.135e3 / 0.4e1 * t144 * t90 * t768 * t351 * t363 - 0.15e2 / 0.2e1 * t1600 - 0.15e2 / 0.16e2 * t4 * t1741 * t20 * t67 - 0.25e2 / 0.18e2 * t1370 + 0.5e1 / 0.4e1 * t1464 - 0.5e1 / 0.4e1 * t1633 + t1252;
  t1751 = my_piecewise3(t42, 0, t1708 + t1749);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t748 + 0.4e1 * t803 + t5 * (t1668 + t1751);

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = 0.0e0;

  t1757 = t89 * t90 * t92 * t525;
  t1759 = t201 * t836;
  t1761 = t1112 * t164;
  t1762 = 0.25e2 / 0.288e3 * t1761;
  t1763 = t518 * t382;
  t1765 = t210 * t836;
  t1767 = t1130 * t164;
  t1769 = t501 * t382;
  t1771 = t1135 * t164;
  t1773 = t507 * t382;
  t1775 = t1143 * t164;
  t1777 = t201 * t832;
  t1779 = t518 * t378;
  t1781 = 0.275e3 / 0.72e2 * t1757 - 0.25e2 / 0.8e1 * t1759 - t1762 - 0.25e2 / 0.96e2 * t1763 - 0.25e2 / 0.24e2 * t1765 - 0.15e2 / 0.64e2 * t1767 + 0.75e2 / 0.64e2 * t1769 + 0.5e1 / 0.32e2 * t1771 + 0.25e2 / 0.32e2 * t1773 - 0.15e2 / 0.64e2 * t1775 + 0.45e2 / 0.32e2 * t1777 - 0.5e1 / 0.16e2 * t1779;
  t1782 = t210 * t832;
  t1784 = t501 * t378;
  t1786 = t507 * t378;
  t1788 = t210 * t823;
  t1790 = t210 * t828;
  t1795 = t89 * t90 * t1151 * t30 * t488;
  t1800 = t89 * t90 * t487 * t95 * t215;
  t1805 = t89 * t90 * t214 * t222 * t100;
  t1807 = t201 * t823;
  t1809 = t201 * t828;
  t1813 = t89 * t90 * t826 * t227;
  t1817 = t89 * t90 * t376 * t530;
  t1819 = t88 * t24;
  t1825 = t19 * t1819 * t26 * t487 * t30 * t100 * t227;
  t1827 = 0.15e2 / 0.32e2 * t1782 + 0.45e2 / 0.32e2 * t1784 + 0.15e2 / 0.16e2 * t1786 - 0.45e2 / 0.32e2 * t1788 - 0.25e2 / 0.16e2 * t1790 + 0.45e2 / 0.8e1 * t1795 + 0.225e3 / 0.32e2 * t1800 + 0.25e2 / 0.4e1 * t1805 - 0.135e3 / 0.32e2 * t1807 - 0.75e2 / 0.16e2 * t1809 - 0.75e2 / 0.32e2 * t1813 + 0.15e2 / 0.32e2 * t1817 - 0.135e3 / 0.32e2 * t1825;
  t1829 = my_piecewise3(t2, 0, t1781 + t1827);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = t5 * t1829 + 0.3e1 * t840;

  t1832 = t1375 * t169;
  t1834 = t1378 * t169;
  t1836 = t1381 * t169;
  t1838 = t1384 * t169;
  t1839 = 0.25e2 / 0.288e3 * t1838;
  t1841 = my_piecewise3(t42, 0, -0.15e2 / 0.64e2 * t1832 - 0.15e2 / 0.64e2 * t1834 + 0.5e1 / 0.32e2 * t1836 - t1839);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[1] = t5 * t1841 + 0.3e1 * t850;

  t1843 = 0.2e1 * t864;
  t1844 = t601 * t378;
  t1845 = 0.5e1 / 0.16e2 * t1844;
  t1846 = t601 * t382;
  t1847 = 0.25e2 / 0.96e2 * t1846;
  t1848 = t277 * t832;
  t1850 = t277 * t836;
  t1852 = t1277 * t164;
  t1853 = 0.5e1 / 0.32e2 * t1852;
  t1854 = t595 * t378;
  t1856 = t595 * t382;
  t1858 = t1267 * t164;
  t1862 = t1845 + t1847 + 0.15e2 / 0.32e2 * t1848 - 0.25e2 / 0.24e2 * t1850 - t1853 + 0.15e2 / 0.16e2 * t1854 + 0.25e2 / 0.32e2 * t1856 + 0.5e1 / 0.96e2 * t1858 - t1762 - 0.5e1 / 0.24e2 * t1779 - 0.25e2 / 0.144e3 * t1763;
  t1869 = t277 * t823;
  t1871 = t277 * t828;
  t1875 = t1274 * t164;
  t1877 = 0.5e1 / 0.32e2 * t1782 - 0.25e2 / 0.72e2 * t1765 - 0.5e1 / 0.64e2 * t1767 + 0.5e1 / 0.48e2 * t1771 + 0.5e1 / 0.16e2 * t1786 + 0.25e2 / 0.96e2 * t1773 - 0.45e2 / 0.32e2 * t1869 - 0.25e2 / 0.16e2 * t1871 - 0.15e2 / 0.32e2 * t1788 - 0.25e2 / 0.48e2 * t1790 - 0.15e2 / 0.64e2 * t1875;
  t1879 = my_piecewise3(t2, 0, t1862 + t1877);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[2] = t5 * t1879 + t1843 + t840;

  t1881 = 0.2e1 * t880;
  t1882 = t1466 * t169;
  t1884 = t1483 * t169;
  t1885 = 0.5e1 / 0.32e2 * t1884;
  t1886 = t1486 * t169;
  t1890 = t643 * t404;
  t1892 = t646 * t404;
  t1893 = 0.5e1 / 0.16e2 * t1892;
  t1894 = t649 * t404;
  t1896 = t643 * t408;
  t1898 = t646 * t408;
  t1899 = 0.25e2 / 0.96e2 * t1898;
  t1900 = t649 * t408;
  t1902 = -0.15e2 / 0.64e2 * t1882 - t1885 + 0.5e1 / 0.96e2 * t1886 - 0.5e1 / 0.64e2 * t1834 + 0.5e1 / 0.48e2 * t1836 - t1839 + 0.15e2 / 0.32e2 * t1890 + t1893 - 0.5e1 / 0.48e2 * t1894 + 0.25e2 / 0.64e2 * t1896 + t1899 - 0.25e2 / 0.288e3 * t1900;
  t1903 = my_piecewise3(t42, 0, t1902);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[3] = t5 * t1903 + t1881 + t850;

  t1905 = t1400 * t164;
  t1907 = t1406 * t164;
  t1909 = t677 * t378;
  t1911 = t677 * t382;
  t1917 = -0.15e2 / 0.64e2 * t1905 - 0.5e1 / 0.64e2 * t1907 + 0.15e2 / 0.32e2 * t1909 + 0.25e2 / 0.64e2 * t1911 - t1853 + 0.5e1 / 0.48e2 * t1858 + t1845 + t1847 + 0.5e1 / 0.96e2 * t1771 - t1762 - 0.5e1 / 0.48e2 * t1779 - 0.25e2 / 0.288e3 * t1763;
  t1918 = my_piecewise3(t2, 0, t1917);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[4] = t5 * t1918 + t1843 + t887;

  t1920 = t1579 * t169;
  t1922 = t1570 * t169;
  t1925 = t707 * t404;
  t1927 = t710 * t404;
  t1929 = t707 * t408;
  t1931 = t710 * t408;
  t1934 = -0.15e2 / 0.64e2 * t1920 - 0.5e1 / 0.64e2 * t1922 - t1885 + 0.5e1 / 0.48e2 * t1886 + 0.15e2 / 0.16e2 * t1925 + 0.5e1 / 0.16e2 * t1927 + 0.25e2 / 0.32e2 * t1929 + 0.25e2 / 0.96e2 * t1931 + 0.5e1 / 0.96e2 * t1836 - t1839 + t1893;
  t1937 = t301 * t901;
  t1939 = t304 * t901;
  t1941 = t301 * t906;
  t1943 = t304 * t906;
  t1945 = t301 * t910;
  t1947 = t304 * t910;
  t1949 = t301 * t914;
  t1951 = t304 * t914;
  t1953 = -0.5e1 / 0.24e2 * t1894 + t1899 - 0.25e2 / 0.144e3 * t1900 - 0.45e2 / 0.32e2 * t1937 - 0.15e2 / 0.32e2 * t1939 - 0.25e2 / 0.16e2 * t1941 - 0.25e2 / 0.48e2 * t1943 + 0.15e2 / 0.32e2 * t1945 + 0.5e1 / 0.32e2 * t1947 - 0.25e2 / 0.24e2 * t1949 - 0.25e2 / 0.72e2 * t1951;
  t1955 = my_piecewise3(t42, 0, t1934 + t1953);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[5] = t5 * t1955 + t1881 + t918;

  t1958 = t1559 * t164;
  t1963 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t1958 - 0.15e2 / 0.64e2 * t1907 + 0.5e1 / 0.32e2 * t1858 - t1762);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[6] = t5 * t1963 + 0.3e1 * t887;

  t1966 = t1688 * t169;
  t1973 = t144 * t90 * t146 * t792;
  t1975 = t345 * t914;
  t1977 = t785 * t408;
  t1984 = t144 * t90 * t1696 * t59 * t769;
  t1989 = t144 * t90 * t768 * t149 * t351;
  t1991 = -0.15e2 / 0.64e2 * t1966 - 0.15e2 / 0.64e2 * t1922 + 0.25e2 / 0.32e2 * t1931 - 0.25e2 / 0.24e2 * t1951 + 0.275e3 / 0.72e2 * t1973 - 0.25e2 / 0.8e1 * t1975 + 0.75e2 / 0.64e2 * t1977 - t1839 + 0.5e1 / 0.32e2 * t1886 - 0.25e2 / 0.96e2 * t1900 + 0.45e2 / 0.8e1 * t1984 + 0.225e3 / 0.32e2 * t1989;
  t1995 = t144 * t90 * t350 * t358 * t154;
  t1997 = t345 * t901;
  t1999 = t345 * t906;
  t2006 = t144 * t90 * t904 * t363;
  t2010 = t144 * t90 * t402 * t797;
  t2012 = t345 * t910;
  t2014 = t785 * t404;
  t2023 = t54 * t1819 * t26 * t768 * t59 * t154 * t363;
  t2025 = 0.25e2 / 0.4e1 * t1995 - 0.135e3 / 0.32e2 * t1997 - 0.75e2 / 0.16e2 * t1999 - 0.45e2 / 0.32e2 * t1939 - 0.25e2 / 0.16e2 * t1943 + 0.15e2 / 0.32e2 * t1947 - 0.75e2 / 0.32e2 * t2006 + 0.15e2 / 0.32e2 * t2010 + 0.45e2 / 0.32e2 * t2012 + 0.45e2 / 0.32e2 * t2014 - 0.5e1 / 0.16e2 * t1894 + 0.15e2 / 0.16e2 * t1927 - 0.135e3 / 0.32e2 * t2023;
  t2027 = my_piecewise3(t42, 0, t1991 + t2025);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[7] = t5 * t2027 + 0.3e1 * t918;

  t2032 = 0.25e2 / 0.36e2 * t1761;
  t2042 = -0.275e3 / 0.9e1 * t1757 + 0.25e2 * t1759 + t2032 + 0.25e2 / 0.12e2 * t1763 + 0.25e2 / 0.3e1 * t1765 + 0.15e2 / 0.8e1 * t1767 - 0.75e2 / 0.8e1 * t1769 - 0.5e1 / 0.4e1 * t1771 - 0.25e2 / 0.4e1 * t1773 + 0.15e2 / 0.8e1 * t1775 - 0.45e2 / 0.4e1 * t1777 + 0.5e1 / 0.2e1 * t1779;
  t2056 = -0.15e2 / 0.4e1 * t1782 - 0.45e2 / 0.4e1 * t1784 - 0.15e2 / 0.2e1 * t1786 + 0.45e2 / 0.4e1 * t1788 + 0.25e2 / 0.2e1 * t1790 - 0.45e2 * t1795 - 0.225e3 / 0.4e1 * t1800 - 0.50e2 * t1805 + 0.135e3 / 0.4e1 * t1807 + 0.75e2 / 0.2e1 * t1809 + 0.75e2 / 0.4e1 * t1813 - 0.15e2 / 0.4e1 * t1817 + 0.135e3 / 0.4e1 * t1825;
  t2058 = my_piecewise3(t2, 0, t2042 + t2056);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = t5 * t2058 + 0.3e1 * t933;

  t2064 = 0.25e2 / 0.36e2 * t1838;
  t2066 = my_piecewise3(t42, 0, 0.15e2 / 0.8e1 * t1832 + 0.15e2 / 0.8e1 * t1834 - 0.5e1 / 0.4e1 * t1836 + t2064);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[1] = t5 * t2066 + 0.3e1 * t940;

  t2068 = 0.2e1 * t950;
  t2069 = 0.5e1 / 0.2e1 * t1844;
  t2070 = 0.25e2 / 0.12e2 * t1846;
  t2073 = 0.5e1 / 0.4e1 * t1852;
  t2079 = -t2069 - t2070 - 0.15e2 / 0.4e1 * t1848 + 0.25e2 / 0.3e1 * t1850 + t2073 - 0.15e2 / 0.2e1 * t1854 - 0.25e2 / 0.4e1 * t1856 - 0.5e1 / 0.12e2 * t1858 + t2032 + 0.5e1 / 0.3e1 * t1779 + 0.25e2 / 0.18e2 * t1763;
  t2091 = -0.5e1 / 0.4e1 * t1782 + 0.25e2 / 0.9e1 * t1765 + 0.5e1 / 0.8e1 * t1767 - 0.5e1 / 0.6e1 * t1771 - 0.5e1 / 0.2e1 * t1786 - 0.25e2 / 0.12e2 * t1773 + 0.45e2 / 0.4e1 * t1869 + 0.25e2 / 0.2e1 * t1871 + 0.15e2 / 0.4e1 * t1788 + 0.25e2 / 0.6e1 * t1790 + 0.15e2 / 0.8e1 * t1875;
  t2093 = my_piecewise3(t2, 0, t2079 + t2091);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[2] = t5 * t2093 + t2068 + t933;

  t2095 = 0.2e1 * t960;
  t2097 = 0.5e1 / 0.4e1 * t1884;
  t2102 = 0.5e1 / 0.2e1 * t1892;
  t2105 = 0.25e2 / 0.12e2 * t1898;
  t2107 = 0.15e2 / 0.8e1 * t1882 + t2097 - 0.5e1 / 0.12e2 * t1886 + 0.5e1 / 0.8e1 * t1834 - 0.5e1 / 0.6e1 * t1836 + t2064 - 0.15e2 / 0.4e1 * t1890 - t2102 + 0.5e1 / 0.6e1 * t1894 - 0.25e2 / 0.8e1 * t1896 - t2105 + 0.25e2 / 0.36e2 * t1900;
  t2108 = my_piecewise3(t42, 0, t2107);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[3] = t5 * t2108 + t2095 + t940;

  t2118 = 0.15e2 / 0.8e1 * t1905 + 0.5e1 / 0.8e1 * t1907 - 0.15e2 / 0.4e1 * t1909 - 0.25e2 / 0.8e1 * t1911 + t2073 - 0.5e1 / 0.6e1 * t1858 - t2069 - t2070 - 0.5e1 / 0.12e2 * t1771 + t2032 + 0.5e1 / 0.6e1 * t1779 + 0.25e2 / 0.36e2 * t1763;
  t2119 = my_piecewise3(t2, 0, t2118);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[4] = t5 * t2119 + t2068 + t966;

  t2129 = 0.15e2 / 0.8e1 * t1920 + 0.5e1 / 0.8e1 * t1922 + t2097 - 0.5e1 / 0.6e1 * t1886 - 0.15e2 / 0.2e1 * t1925 - 0.5e1 / 0.2e1 * t1927 - 0.25e2 / 0.4e1 * t1929 - 0.25e2 / 0.12e2 * t1931 - 0.5e1 / 0.12e2 * t1836 + t2064 - t2102;
  t2140 = 0.5e1 / 0.3e1 * t1894 - t2105 + 0.25e2 / 0.18e2 * t1900 + 0.45e2 / 0.4e1 * t1937 + 0.15e2 / 0.4e1 * t1939 + 0.25e2 / 0.2e1 * t1941 + 0.25e2 / 0.6e1 * t1943 - 0.15e2 / 0.4e1 * t1945 - 0.5e1 / 0.4e1 * t1947 + 0.25e2 / 0.3e1 * t1949 + 0.25e2 / 0.9e1 * t1951;
  t2142 = my_piecewise3(t42, 0, t2129 + t2140);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[5] = t5 * t2142 + t2095 + t980;

  t2149 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t1958 + 0.15e2 / 0.8e1 * t1907 - 0.5e1 / 0.4e1 * t1858 + t2032);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[6] = t5 * t2149 + 0.3e1 * t966;

  t2163 = 0.15e2 / 0.8e1 * t1966 + 0.15e2 / 0.8e1 * t1922 - 0.25e2 / 0.4e1 * t1931 + 0.25e2 / 0.3e1 * t1951 - 0.275e3 / 0.9e1 * t1973 + 0.25e2 * t1975 - 0.75e2 / 0.8e1 * t1977 + t2064 - 0.5e1 / 0.4e1 * t1886 + 0.25e2 / 0.12e2 * t1900 - 0.45e2 * t1984 - 0.225e3 / 0.4e1 * t1989;
  t2177 = -0.50e2 * t1995 + 0.135e3 / 0.4e1 * t1997 + 0.75e2 / 0.2e1 * t1999 + 0.45e2 / 0.4e1 * t1939 + 0.25e2 / 0.2e1 * t1943 - 0.15e2 / 0.4e1 * t1947 + 0.75e2 / 0.4e1 * t2006 - 0.15e2 / 0.4e1 * t2010 - 0.45e2 / 0.4e1 * t2012 - 0.45e2 / 0.4e1 * t2014 + 0.5e1 / 0.2e1 * t1894 - 0.15e2 / 0.2e1 * t1927 + 0.135e3 / 0.4e1 * t2023;
  t2179 = my_piecewise3(t42, 0, t2163 + t2177);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[7] = t5 * t2179 + 0.3e1 * t980;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[17] = 0.0e0;

  t2182 = t501 * t439;
  t2184 = t507 * t439;
  t2186 = t201 * t988;
  t2188 = t201 * t994;
  t2190 = t518 * t439;
  t2191 = 0.5e1 / 0.192e3 * t2190;
  t2192 = t210 * t988;
  t2194 = t210 * t994;
  t2199 = t89 * t90 * t1151 * t437 * t215;
  t2204 = t89 * t90 * t487 * t992 * t100;
  t2208 = t89 * t90 * t986 * t227;
  t2214 = t89 * t90 * t214 / t27 / t1072;
  t2216 = -0.15e2 / 0.128e3 * t2182 - 0.5e1 / 0.64e2 * t2184 + 0.45e2 / 0.64e2 * t2186 + 0.25e2 / 0.32e2 * t2188 + t2191 + 0.15e2 / 0.64e2 * t2192 + 0.25e2 / 0.96e2 * t2194 - 0.45e2 / 0.32e2 * t2199 - 0.75e2 / 0.32e2 * t2204 + 0.45e2 / 0.128e3 * t2208 - 0.325e3 / 0.192e3 * t2214;
  t2217 = my_piecewise3(t2, 0, t2216);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = t5 * t2217 + 0.2e1 * t998;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[1] = 0.0e0;

  t2220 = t643 * t446;
  t2222 = t646 * t446;
  t2224 = t649 * t446;
  t2225 = 0.5e1 / 0.192e3 * t2224;
  t2227 = my_piecewise3(t42, 0, -0.15e2 / 0.128e3 * t2220 - 0.5e1 / 0.64e2 * t2222 + t2225);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[2] = t5 * t2227 + 0.2e1 * t1005;

  t2229 = t595 * t439;
  t2231 = t601 * t439;
  t2233 = t277 * t988;
  t2235 = t277 * t994;
  t2241 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t2229 - 0.5e1 / 0.128e3 * t2231 + 0.45e2 / 0.128e3 * t2233 + 0.25e2 / 0.64e2 * t2235 - 0.5e1 / 0.128e3 * t2184 + t2191 + 0.15e2 / 0.128e3 * t2192 + 0.25e2 / 0.192e3 * t2194);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[3] = t5 * t2241 + t1010 + t998;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[4] = 0.0e0;

  t2243 = t707 * t446;
  t2245 = t710 * t446;
  t2248 = t301 * t1016;
  t2250 = t304 * t1016;
  t2252 = t301 * t1022;
  t2254 = t304 * t1022;
  t2257 = my_piecewise3(t42, 0, -0.15e2 / 0.128e3 * t2243 - 0.5e1 / 0.128e3 * t2245 - 0.5e1 / 0.128e3 * t2222 + t2225 + 0.45e2 / 0.128e3 * t2248 + 0.15e2 / 0.128e3 * t2250 + 0.25e2 / 0.64e2 * t2252 + 0.25e2 / 0.192e3 * t2254);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[5] = t5 * t2257 + t1005 + t1026;

  t2260 = t677 * t439;
  t2264 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t2260 - 0.5e1 / 0.64e2 * t2231 + t2191);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[6] = t5 * t2264 + 0.2e1 * t1010;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[7] = 0.0e0;

  t2267 = t785 * t446;
  t2270 = t345 * t1016;
  t2272 = t345 * t1022;
  t2279 = t144 * t90 * t1696 * t444 * t351;
  t2284 = t144 * t90 * t768 * t1020 * t154;
  t2288 = t144 * t90 * t1014 * t363;
  t2294 = t144 * t90 * t350 / t56 / t1079;
  t2296 = -0.15e2 / 0.128e3 * t2267 - 0.5e1 / 0.64e2 * t2245 + 0.45e2 / 0.64e2 * t2270 + 0.25e2 / 0.32e2 * t2272 + t2225 + 0.15e2 / 0.64e2 * t2250 + 0.25e2 / 0.96e2 * t2254 - 0.45e2 / 0.32e2 * t2279 - 0.75e2 / 0.32e2 * t2284 + 0.45e2 / 0.128e3 * t2288 - 0.325e3 / 0.192e3 * t2294;
  t2297 = my_piecewise3(t42, 0, t2296);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[8] = t5 * t2297 + 0.2e1 * t1026;

  t2304 = 0.5e1 / 0.24e2 * t2190;
  t2311 = 0.15e2 / 0.16e2 * t2182 + 0.5e1 / 0.8e1 * t2184 - 0.45e2 / 0.8e1 * t2186 - 0.25e2 / 0.4e1 * t2188 - t2304 - 0.15e2 / 0.8e1 * t2192 - 0.25e2 / 0.12e2 * t2194 + 0.45e2 / 0.4e1 * t2199 + 0.75e2 / 0.4e1 * t2204 - 0.45e2 / 0.16e2 * t2208 + 0.325e3 / 0.24e2 * t2214;
  t2312 = my_piecewise3(t2, 0, t2311);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = t5 * t2312 + 0.2e1 * t1033;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[2] = 0.0e0;

  t2317 = 0.5e1 / 0.24e2 * t2224;
  t2319 = my_piecewise3(t42, 0, 0.15e2 / 0.16e2 * t2220 + 0.5e1 / 0.8e1 * t2222 - t2317);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[3] = t5 * t2319 + 0.2e1 * t1038;

  t2329 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t2229 + 0.5e1 / 0.16e2 * t2231 - 0.45e2 / 0.16e2 * t2233 - 0.25e2 / 0.8e1 * t2235 + 0.5e1 / 0.16e2 * t2184 - t2304 - 0.15e2 / 0.16e2 * t2192 - 0.25e2 / 0.24e2 * t2194);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[4] = t5 * t2329 + t1033 + t1042;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[6] = 0.0e0;

  t2339 = my_piecewise3(t42, 0, 0.15e2 / 0.16e2 * t2243 + 0.5e1 / 0.16e2 * t2245 + 0.5e1 / 0.16e2 * t2222 - t2317 - 0.45e2 / 0.16e2 * t2248 - 0.15e2 / 0.16e2 * t2250 - 0.25e2 / 0.8e1 * t2252 - 0.25e2 / 0.24e2 * t2254);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[7] = t5 * t2339 + t1038 + t1048;

  t2345 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t2260 + 0.5e1 / 0.8e1 * t2231 - t2304);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[8] = t5 * t2345 + 0.2e1 * t1042;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[10] = 0.0e0;

  t2358 = 0.15e2 / 0.16e2 * t2267 + 0.5e1 / 0.8e1 * t2245 - 0.45e2 / 0.8e1 * t2270 - 0.25e2 / 0.4e1 * t2272 - t2317 - 0.15e2 / 0.8e1 * t2250 - 0.25e2 / 0.12e2 * t2254 + 0.45e2 / 0.4e1 * t2279 + 0.75e2 / 0.4e1 * t2284 - 0.45e2 / 0.16e2 * t2288 + 0.325e3 / 0.24e2 * t2294;
  t2359 = my_piecewise3(t42, 0, t2358);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[11] = t5 * t2359 + 0.2e1 * t1048;

  t2366 = 0.5e1 / 0.3e1 * t2190;
  t2373 = -0.15e2 / 0.2e1 * t2182 - 0.5e1 * t2184 + 0.45e2 * t2186 + 0.50e2 * t2188 + t2366 + 0.15e2 * t2192 + 0.50e2 / 0.3e1 * t2194 - 0.90e2 * t2199 - 0.150e3 * t2204 + 0.45e2 / 0.2e1 * t2208 - 0.325e3 / 0.3e1 * t2214;
  t2374 = my_piecewise3(t2, 0, t2373);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = t5 * t2374 + 0.2e1 * t1055;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[1] = 0.0e0;

  t2379 = 0.5e1 / 0.3e1 * t2224;
  t2381 = my_piecewise3(t42, 0, -0.15e2 / 0.2e1 * t2220 - 0.5e1 * t2222 + t2379);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[2] = t5 * t2381 + 0.2e1 * t1060;

  t2391 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t2229 - 0.5e1 / 0.2e1 * t2231 + 0.45e2 / 0.2e1 * t2233 + 0.25e2 * t2235 - 0.5e1 / 0.2e1 * t2184 + t2366 + 0.15e2 / 0.2e1 * t2192 + 0.25e2 / 0.3e1 * t2194);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[3] = t5 * t2391 + t1055 + t1064;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[4] = 0.0e0;

  t2401 = my_piecewise3(t42, 0, -0.15e2 / 0.2e1 * t2243 - 0.5e1 / 0.2e1 * t2245 - 0.5e1 / 0.2e1 * t2222 + t2379 + 0.45e2 / 0.2e1 * t2248 + 0.15e2 / 0.2e1 * t2250 + 0.25e2 * t2252 + 0.25e2 / 0.3e1 * t2254);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[5] = t5 * t2401 + t1060 + t1070;

  t2407 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t2260 - 0.5e1 * t2231 + t2366);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[6] = t5 * t2407 + 0.2e1 * t1064;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[7] = 0.0e0;

  t2420 = -0.15e2 / 0.2e1 * t2267 - 0.5e1 * t2245 + 0.45e2 * t2270 + 0.50e2 * t2272 + t2379 + 0.15e2 * t2250 + 0.50e2 / 0.3e1 * t2254 - 0.90e2 * t2279 - 0.150e3 * t2284 + 0.45e2 / 0.2e1 * t2288 - 0.325e3 / 0.3e1 * t2294;
  t2421 = my_piecewise3(t42, 0, t2420);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[8] = t5 * t2421 + 0.2e1 * t1070;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[17] = 0.0e0;

  t2423 = t201 * t1075;
  t2425 = t210 * t1075;
  t2426 = 0.15e2 / 0.512e3 * t2425;
  t2430 = t89 * t90 * t1151 * t1073 * t100;
  t2432 = t523 * t93;
  t2436 = t89 * t90 * t487 / t2432;
  t2439 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2423 - t2426 + 0.45e2 / 0.128e3 * t2430 + 0.225e3 / 0.512e3 * t2436);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = t5 * t2439 + t1078;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[2] = 0.0e0;

  t2441 = t301 * t1082;
  t2443 = t304 * t1082;
  t2444 = 0.15e2 / 0.512e3 * t2443;
  t2446 = my_piecewise3(t42, 0, -0.45e2 / 0.512e3 * t2441 - t2444);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[3] = t5 * t2446 + t1085;

  t2448 = t277 * t1075;
  t2451 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2448 - t2426);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[4] = t5 * t2451 + t1078;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[6] = 0.0e0;

  t2453 = t345 * t1082;
  t2458 = t144 * t90 * t1696 * t1080 * t154;
  t2460 = t790 * t147;
  t2464 = t144 * t90 * t768 / t2460;
  t2467 = my_piecewise3(t42, 0, -0.45e2 / 0.512e3 * t2453 - t2444 + 0.45e2 / 0.128e3 * t2458 + 0.225e3 / 0.512e3 * t2464);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[7] = t5 * t2467 + t1085;

  t2470 = 0.15e2 / 0.64e2 * t2425;
  t2474 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2423 + t2470 - 0.45e2 / 0.16e2 * t2430 - 0.225e3 / 0.64e2 * t2436);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = t5 * t2474 + t1087;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[4] = 0.0e0;

  t2477 = 0.15e2 / 0.64e2 * t2443;
  t2479 = my_piecewise3(t42, 0, 0.45e2 / 0.64e2 * t2441 + t2477);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[5] = t5 * t2479 + t1089;

  t2483 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2448 + t2470);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[6] = t5 * t2483 + t1087;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[10] = 0.0e0;

  t2489 = my_piecewise3(t42, 0, 0.45e2 / 0.64e2 * t2453 + t2477 - 0.45e2 / 0.16e2 * t2458 - 0.225e3 / 0.64e2 * t2464);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[11] = t5 * t2489 + t1089;

  t2492 = 0.15e2 / 0.8e1 * t2425;
  t2496 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2423 - t2492 + 0.45e2 / 0.2e1 * t2430 + 0.225e3 / 0.8e1 * t2436);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = t5 * t2496 + t1091;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[4] = 0.0e0;

  t2499 = 0.15e2 / 0.8e1 * t2443;
  t2501 = my_piecewise3(t42, 0, -0.45e2 / 0.8e1 * t2441 - t2499);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[5] = t5 * t2501 + t1093;

  t2505 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2448 - t2492);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[6] = t5 * t2505 + t1091;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[10] = 0.0e0;

  t2511 = my_piecewise3(t42, 0, -0.45e2 / 0.8e1 * t2453 - t2499 + 0.45e2 / 0.2e1 * t2458 + 0.225e3 / 0.8e1 * t2464);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[11] = t5 * t2511 + t1093;

  t2514 = 0.15e2 * t2425;
  t2518 = my_piecewise3(t2, 0, 0.45e2 * t2423 + t2514 - 0.180e3 * t2430 - 0.225e3 * t2436);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = t5 * t2518 + t1095;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[2] = 0.0e0;

  t2521 = 0.15e2 * t2443;
  t2523 = my_piecewise3(t42, 0, 0.45e2 * t2441 + t2521);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[3] = t5 * t2523 + t1097;

  t2527 = my_piecewise3(t2, 0, 0.45e2 * t2448 + t2514);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[4] = t5 * t2527 + t1095;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[6] = 0.0e0;

  t2533 = my_piecewise3(t42, 0, 0.45e2 * t2453 + t2521 - 0.180e3 * t2458 - 0.225e3 * t2464);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[7] = t5 * t2533 + t1097;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[11] = 0.0e0;

  t2539 = t89 * t90 * t1151 / t28 / t2432;
  t2541 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2539);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = t5 * t2541;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[3] = 0.0e0;

  t2546 = t144 * t90 * t1696 / t57 / t2460;
  t2548 = my_piecewise3(t42, 0, -0.45e2 / 0.512e3 * t2546);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[4] = t5 * t2548;

  t2550 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2539);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = t5 * t2550;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[6] = 0.0e0;

  t2552 = my_piecewise3(t42, 0, 0.45e2 / 0.64e2 * t2546);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[7] = t5 * t2552;

  t2554 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2539);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = t5 * t2554;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[7] = 0.0e0;

  t2556 = my_piecewise3(t42, 0, -0.45e2 / 0.8e1 * t2546);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[8] = t5 * t2556;

  t2558 = my_piecewise3(t2, 0, 0.45e2 * t2539);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = t5 * t2558;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[6] = 0.0e0;

  t2560 = my_piecewise3(t42, 0, 0.45e2 * t2546);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[7] = t5 * t2560;

  t2562 = my_piecewise3(t2, 0, -0.360e3 * t2539);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = t5 * t2562;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[3] = 0.0e0;

  t2564 = my_piecewise3(t42, 0, -0.360e3 * t2546);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[4] = t5 * t2564;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

