/* 
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_lta.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t3, t4, t5, t7, t10, t11, t13, t15;
  double t16, t18, t19, t21, t23, t24, t26, t27;
  double t28, t34, t38;

#ifndef XC_DONT_COMPILE_VXC
  double t39, t44, t45, t50, t53, t54, t55, t59;

#ifndef XC_DONT_COMPILE_FXC
  double t66, t70, t75, t81, t86, t89, t90, t91;
  double t95, t100;

#ifndef XC_DONT_COMPILE_KXC
  double t103, t105, t110, t117, t122, t132, t137, t143;
  double t151, t155, t156, t160, t164, t169;

#ifndef XC_DONT_COMPILE_LXC
  double t174, t179, t189, t194, t212, t230, t247, t250;
  double t251, t269;
#endif

#endif

#endif

#endif

#endif


  mgga_x_lta_params *params;

  assert(p->params != NULL);
  params = (mgga_x_lta_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t10 = my_piecewise3(0.1e1 <= p->zeta_threshold, p->zeta_threshold - 0.1e1, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(t11);
  t15 = my_piecewise3(t11 <= p->zeta_threshold, 0, t13 * t11);
  t16 = POW_1_3(rho[0]);
  t18 = M_CBRT2;
  t19 = t18 * t18;
  t21 = t16 * t16;
  t23 = 0.1e1 / t21 / rho[0];
  t24 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t34 = pow(0.5e1 / 0.9e1 * tau[0] * t19 * t23 * t24 / t28, 0.4e1 / 0.5e1 * params->ltafrac);
  t38 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t15 * t16 * t34);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t38;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t39 = 0.1e1 / t21;
  t44 = t7 * t15;
  t45 = t39 * t34;
  t50 = my_piecewise3(t3, 0, -t7 * t15 * t39 * t34 / 0.8e1 + t44 * t45 * params->ltafrac / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t50 + 0.2e1 * t38;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.0e0;

  t53 = t16 * t34;
  t54 = 0.1e1 / tau[0];
  t55 = params->ltafrac * t54;
  t59 = my_piecewise3(t3, 0, -0.3e1 / 0.10e2 * t44 * t53 * t55);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = 0.2e1 * rho[0] * t59;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t66 = t23 * t34;
  t70 = params->ltafrac * params->ltafrac;
  t75 = my_piecewise3(t3, 0, t7 * t15 * t23 * t34 / 0.12e2 - t44 * t66 * params->ltafrac / 0.6e1 - 0.2e1 / 0.3e1 * t44 * t66 * t70);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t75 + 0.4e1 * t50;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.0e0;

  t81 = t70 * t54;
  t86 = my_piecewise3(t3, 0, -t44 * t45 * t55 / 0.10e2 + 0.2e1 / 0.5e1 * t44 * t45 * t81);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = 0.2e1 * rho[0] * t86 + 0.2e1 * t59;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.0e0;

  t89 = tau[0] * tau[0];
  t90 = 0.1e1 / t89;
  t91 = t70 * t90;
  t95 = params->ltafrac * t90;
  t100 = my_piecewise3(t3, 0, -0.6e1 / 0.25e2 * t44 * t53 * t91 + 0.3e1 / 0.10e2 * t44 * t53 * t95);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = 0.2e1 * rho[0] * t100;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t103 = rho[0] * rho[0];
  t105 = 0.1e1 / t21 / t103;
  t110 = t105 * t34;
  t117 = t70 * params->ltafrac;
  t122 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t15 * t105 * t34 + t44 * t110 * params->ltafrac / 0.6e1 + 0.4e1 / 0.3e1 * t44 * t110 * t70 + 0.8e1 / 0.9e1 * t44 * t110 * t117);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t122 + 0.6e1 * t75;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.0e0;

  t132 = t117 * t54;
  t137 = my_piecewise3(t3, 0, t44 * t66 * t55 / 0.15e2 - 0.2e1 / 0.15e2 * t44 * t66 * t81 - 0.8e1 / 0.15e2 * t44 * t66 * t132);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = 0.2e1 * rho[0] * t137 + 0.4e1 * t86;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.0e0;

  t143 = t117 * t90;
  t151 = my_piecewise3(t3, 0, -0.12e2 / 0.25e2 * t44 * t45 * t91 + 0.8e1 / 0.25e2 * t44 * t45 * t143 + t44 * t45 * t95 / 0.10e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = 0.2e1 * rho[0] * t151 + 0.2e1 * t100;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.0e0;

  t155 = 0.1e1 / t89 / tau[0];
  t156 = t117 * t155;
  t160 = t70 * t155;
  t164 = params->ltafrac * t155;
  t169 = my_piecewise3(t3, 0, -0.24e2 / 0.125e3 * t44 * t53 * t156 + 0.18e2 / 0.25e2 * t44 * t53 * t160 - 0.3e1 / 0.5e1 * t44 * t53 * t164);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = 0.2e1 * rho[0] * t169;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t174 = 0.1e1 / t21 / t103 / rho[0];
  t179 = t174 * t34;
  t189 = t70 * t70;
  t194 = my_piecewise3(t3, 0, 0.10e2 / 0.27e2 * t7 * t15 * t174 * t34 - 0.7e1 / 0.27e2 * t44 * t179 * params->ltafrac - 0.34e2 / 0.9e1 * t44 * t179 * t70 - 0.112e3 / 0.27e2 * t44 * t179 * t117 - 0.32e2 / 0.27e2 * t44 * t179 * t189);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t194 + 0.8e1 * t122;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.0e0;

  t212 = my_piecewise3(t3, 0, -t44 * t110 * t55 / 0.9e1 + 0.2e1 / 0.15e2 * t44 * t110 * t81 + 0.16e2 / 0.15e2 * t44 * t110 * t132 + 0.32e2 / 0.45e2 * t44 * t110 * t189 * t54);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = 0.2e1 * rho[0] * t212 + 0.6e1 * t137;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.0e0;

  t230 = my_piecewise3(t3, 0, 0.14e2 / 0.75e2 * t44 * t66 * t91 + 0.32e2 / 0.75e2 * t44 * t66 * t143 - 0.32e2 / 0.75e2 * t44 * t66 * t189 * t90 - t44 * t66 * t95 / 0.15e2);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = 0.2e1 * rho[0] * t230 + 0.4e1 * t151;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.0e0;

  t247 = my_piecewise3(t3, 0, -0.128e3 / 0.125e3 * t44 * t45 * t156 + 0.32e2 / 0.125e3 * t44 * t45 * t189 * t155 + 0.26e2 / 0.25e2 * t44 * t45 * t160 - t44 * t45 * t164 / 0.5e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = 0.2e1 * rho[0] * t247 + 0.2e1 * t169;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.0e0;

  t250 = t89 * t89;
  t251 = 0.1e1 / t250;
  t269 = my_piecewise3(t3, 0, -0.96e2 / 0.625e3 * t44 * t53 * t189 * t251 + 0.144e3 / 0.125e3 * t44 * t53 * t117 * t251 - 0.66e2 / 0.25e2 * t44 * t53 * t70 * t251 + 0.9e1 / 0.5e1 * t44 * t53 * params->ltafrac * t251);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = 0.2e1 * rho[0] * t269;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t13, t15, t16, t17, t18, t20, t21, t22;
  double t23, t24, t28, t29, t30, t31, t33, t36;
  double t37, t41, t42, t45, t46, t48, t49, t50;
  double t51, t53, t54, t55, t56, t62, t66;

#ifndef XC_DONT_COMPILE_VXC
  double t67, t68, t69, t71, t74, t75, t79, t80;
  double t81, t84, t85, t86, t87, t88, t89, t93;
  double t94, t96, t99, t100, t104, t107, t109, t113;
  double t116, t117, t122, t124, t127, t128, t132, t133;
  double t134, t135, t136, t140, t143, t144, t145, t148;
  double t149, t150, t151, t154;

#ifndef XC_DONT_COMPILE_FXC
  double t157, t158, t159, t162, t163, t164, t167, t171;
  double t172, t176, t178, t180, t183, t184, t187, t188;
  double t189, t190, t192, t193, t194, t195, t196, t199;
  double t200, t204, t205, t206, t207, t210, t213, t217;
  double t218, t222, t224, t226, t229, t231, t234, t238;
  double t242, t243, t247, t249, t251, t257, t258, t262;
  double t266, t267, t271, t273, t276, t279, t280, t281;
  double t284, t289, t294, t298, t299, t305, t306, t311;
  double t315, t316, t321, t324, t325, t326, t327, t330;
  double t331, t335, t340, t342, t343, t344, t346, t350;
  double t354, t356, t358, t363, t367, t368, t370, t374;
  double t376, t377, t378, t379, t382, t383, t387, t388;
  double t389, t390, t391, t394, t395, t399;

#ifndef XC_DONT_COMPILE_KXC
  double t404, t408, t411, t415, t416, t418, t419, t420;
  double t423, t426, t429, t430, t431, t433, t434, t437;
  double t438, t441, t444, t445, t446, t449, t453, t460;
  double t461, t463, t464, t467, t468, t470, t471, t473;
  double t474, t477, t480, t483, t487, t494, t498, t503;
  double t505, t508, t509, t510, t513, t518, t519, t521;
  double t525, t533, t534, t538, t541, t552, t553, t554;
  double t557, t562, t564, t568, t576, t579, t583, t587;
  double t588, t589, t590, t593, t596, t601, t605, t609;
  double t616, t618, t625, t626, t631, t635, t639, t646;
  double t649, t651, t657, t658, t662, t663, t665, t666;
  double t671, t678, t682, t690, t691, t698, t702, t709;
  double t715, t716, t717, t725, t726, t729, t730, t732;
  double t733, t739, t741, t744, t746, t747, t748, t750;
  double t751, t752, t755, t759, t764, t766, t768, t770;
  double t774, t776, t782, t786, t789, t792, t793, t796;
  double t803, t809, t813, t814, t815, t818, t822, t826;
  double t828, t829, t830, t835, t837, t838, t842, t846;
  double t848, t851, t853, t855, t862, t866, t867, t872;
  double t876, t879, t880, t881, t884, t885, t888, t889;
  double t893, t895, t896, t897, t900, t901, t904, t905;
  double t909;

#ifndef XC_DONT_COMPILE_LXC
  double t914, t916, t918, t919, t925, t931, t932, t935;
  double t939, t946, t950, t953, t957, t958, t960, t964;
  double t965, t966, t974, t984, t987, t992, t995, t998;
  double t1004, t1009, t1012, t1014, t1016, t1018, t1020, t1021;
  double t1023, t1024, t1030, t1035, t1038, t1042, t1049, t1053;
  double t1057, t1062, t1064, t1085, t1086, t1088, t1092, t1099;
  double t1103, t1104, t1107, t1115, t1122, t1123, t1126, t1129;
  double t1130, t1131, t1142, t1144, t1161, t1163, t1167, t1174;
  double t1178, t1179, t1182, t1187, t1190, t1192, t1193, t1194;
  double t1196, t1198, t1199, t1216, t1229, t1233, t1240, t1244;
  double t1254, t1256, t1266, t1268, t1269, t1271, t1273, t1276;
  double t1278, t1281, t1294, t1307, t1311, t1319, t1323, t1330;
  double t1336, t1338, t1359, t1363, t1370, t1372, t1381, t1382;
  double t1399, t1403, t1410, t1423, t1428, t1435, t1437, t1439;
  double t1442, t1444, t1447, t1450, t1452, t1457, t1462, t1469;
  double t1473, t1482, t1483, t1488, t1495, t1499, t1509, t1510;
  double t1529, t1534, t1549, t1551, t1555, t1557, t1567, t1569;
  double t1571, t1575, t1580, t1583, t1589, t1592, t1593, t1598;
  double t1600, t1604, t1606, t1608, t1612, t1616, t1620, t1631;
  double t1632, t1634, t1638, t1639, t1648, t1650, t1653, t1657;
  double t1666, t1670, t1677, t1683, t1687, t1689, t1690, t1698;
  double t1705, t1721, t1727, t1728, t1733, t1739, t1740, t1742;
  double t1751, t1757, t1758, t1763, t1764, t1769, t1773, t1776;
  double t1780, t1782, t1786, t1794, t1800, t1801, t1805, t1810;
  double t1814, t1819, t1821, t1822, t1832, t1841, t1857, t1858;
  double t1864, t1865, t1873, t1881, t1886, t1892, t1897, t1902;
  double t1904, t1913, t1917, t1932, t1934, t1935, t1953, t1954;
  double t1955, t1973;
#endif

#endif

#endif

#endif

#endif


  mgga_x_lta_params *params;

  assert(p->params != NULL);
  params = (mgga_x_lta_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise3(t11, t12, t13 * t8);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = POW_1_3(t16);
  t20 = my_piecewise3(t17, 0, t18 * t16);
  t21 = POW_1_3(t7);
  t22 = t20 * t21;
  t23 = POW_1_3(rho[0]);
  t24 = t23 * t23;
  t28 = M_CBRT6;
  t29 = M_PI * M_PI;
  t30 = POW_1_3(t29);
  t31 = t30 * t30;
  t33 = t28 / t31;
  t36 = 0.4e1 / 0.5e1 * params->ltafrac;
  t37 = pow(0.5e1 / 0.9e1 * tau[0] / t24 / rho[0] * t33, t36);
  t41 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t22 * t37);
  t42 = rho[1] <= p->dens_threshold;
  t45 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t46 = -t13;
  t48 = my_piecewise3(t45, t12, t46 * t8);
  t49 = 0.1e1 + t48;
  t50 = t49 <= p->zeta_threshold;
  t51 = POW_1_3(t49);
  t53 = my_piecewise3(t50, 0, t51 * t49);
  t54 = t53 * t21;
  t55 = POW_1_3(rho[1]);
  t56 = t55 * t55;
  t62 = pow(0.5e1 / 0.9e1 * tau[1] / t56 / rho[1] * t33, t36);
  t66 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t54 * t62);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t41 + t66;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t67 = t7 * t7;
  t68 = 0.1e1 / t67;
  t69 = t13 * t68;
  t71 = my_piecewise3(t11, 0, t8 - t69);
  t74 = my_piecewise3(t17, 0, 0.4e1 / 0.3e1 * t18 * t71);
  t75 = t74 * t21;
  t79 = t21 * t21;
  t80 = 0.1e1 / t79;
  t81 = t20 * t80;
  t84 = t6 * t81 * t37 / 0.8e1;
  t85 = t6 * t20;
  t86 = t21 * t37;
  t87 = 0.1e1 / rho[0];
  t88 = params->ltafrac * t87;
  t89 = t86 * t88;
  t93 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t75 * t37 - t84 + t85 * t89 / 0.2e1);
  t94 = t46 * t68;
  t96 = my_piecewise3(t45, 0, -t8 - t94);
  t99 = my_piecewise3(t50, 0, 0.4e1 / 0.3e1 * t51 * t96);
  t100 = t99 * t21;
  t104 = t53 * t80;
  t107 = t6 * t104 * t62 / 0.8e1;
  t109 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t100 * t62 - t107);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t41 + t66 + t7 * (t93 + t109);

  t113 = my_piecewise3(t11, 0, -t8 - t69);
  t116 = my_piecewise3(t17, 0, 0.4e1 / 0.3e1 * t18 * t113);
  t117 = t116 * t21;
  t122 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t117 * t37 - t84);
  t124 = my_piecewise3(t45, 0, t8 - t94);
  t127 = my_piecewise3(t50, 0, 0.4e1 / 0.3e1 * t51 * t124);
  t128 = t127 * t21;
  t132 = t6 * t53;
  t133 = t21 * t62;
  t134 = 0.1e1 / rho[1];
  t135 = params->ltafrac * t134;
  t136 = t133 * t135;
  t140 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t128 * t62 - t107 + t132 * t136 / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t41 + t66 + t7 * (t122 + t140);

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[1] = 0.0e0;

  t143 = 0.1e1 / tau[0];
  t144 = params->ltafrac * t143;
  t145 = t86 * t144;
  t148 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t85 * t145);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = t7 * t148;

  t149 = 0.1e1 / tau[1];
  t150 = params->ltafrac * t149;
  t151 = t133 * t150;
  t154 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t132 * t151);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[1] = t7 * t154;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t157 = t18 * t18;
  t158 = 0.1e1 / t157;
  t159 = t71 * t71;
  t162 = t67 * t7;
  t163 = 0.1e1 / t162;
  t164 = t13 * t163;
  t167 = my_piecewise3(t11, 0, -0.2e1 * t68 + 0.2e1 * t164);
  t171 = my_piecewise3(t17, 0, 0.4e1 / 0.9e1 * t158 * t159 + 0.4e1 / 0.3e1 * t18 * t167);
  t172 = t171 * t21;
  t176 = t74 * t80;
  t178 = t6 * t176 * t37;
  t180 = t6 * t74;
  t183 = 0.1e1 / t79 / t7;
  t184 = t20 * t183;
  t187 = t6 * t184 * t37 / 0.12e2;
  t188 = t80 * t37;
  t189 = t188 * t88;
  t190 = t85 * t189;
  t192 = params->ltafrac * params->ltafrac;
  t193 = rho[0] * rho[0];
  t194 = 0.1e1 / t193;
  t195 = t192 * t194;
  t196 = t86 * t195;
  t199 = params->ltafrac * t194;
  t200 = t86 * t199;
  t204 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t172 * t37 - t178 / 0.4e1 + t180 * t89 + t187 + t190 / 0.3e1 - 0.2e1 / 0.3e1 * t85 * t196 - t85 * t200 / 0.2e1);
  t205 = t51 * t51;
  t206 = 0.1e1 / t205;
  t207 = t96 * t96;
  t210 = t46 * t163;
  t213 = my_piecewise3(t45, 0, 0.2e1 * t68 + 0.2e1 * t210);
  t217 = my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t206 * t207 + 0.4e1 / 0.3e1 * t51 * t213);
  t218 = t217 * t21;
  t222 = t99 * t80;
  t224 = t6 * t222 * t62;
  t226 = t53 * t183;
  t229 = t6 * t226 * t62 / 0.12e2;
  t231 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t218 * t62 - t224 / 0.4e1 + t229);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t93 + 0.2e1 * t109 + t7 * (t204 + t231);

  t234 = t158 * t113;
  t238 = my_piecewise3(t11, 0, 0.2e1 * t164);
  t242 = my_piecewise3(t17, 0, 0.4e1 / 0.9e1 * t234 * t71 + 0.4e1 / 0.3e1 * t18 * t238);
  t243 = t242 * t21;
  t247 = t116 * t80;
  t249 = t6 * t247 * t37;
  t251 = t6 * t116;
  t257 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t243 * t37 - t249 / 0.8e1 + t251 * t89 / 0.2e1 - t178 / 0.8e1 + t187 + t190 / 0.6e1);
  t258 = t206 * t124;
  t262 = my_piecewise3(t45, 0, 0.2e1 * t210);
  t266 = my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t258 * t96 + 0.4e1 / 0.3e1 * t51 * t262);
  t267 = t266 * t21;
  t271 = t127 * t80;
  t273 = t6 * t271 * t62;
  t276 = t6 * t99;
  t279 = t80 * t62;
  t280 = t279 * t135;
  t281 = t132 * t280;
  t284 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t267 * t62 - t273 / 0.8e1 - t224 / 0.8e1 + t229 + t276 * t136 / 0.2e1 + t281 / 0.6e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t93 + t109 + t122 + t140 + t7 * (t257 + t284);

  t289 = t113 * t113;
  t294 = my_piecewise3(t11, 0, 0.2e1 * t68 + 0.2e1 * t164);
  t298 = my_piecewise3(t17, 0, 0.4e1 / 0.9e1 * t158 * t289 + 0.4e1 / 0.3e1 * t18 * t294);
  t299 = t298 * t21;
  t305 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t299 * t37 - t249 / 0.4e1 + t187);
  t306 = t124 * t124;
  t311 = my_piecewise3(t45, 0, -0.2e1 * t68 + 0.2e1 * t210);
  t315 = my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t206 * t306 + 0.4e1 / 0.3e1 * t51 * t311);
  t316 = t315 * t21;
  t321 = t6 * t127;
  t324 = rho[1] * rho[1];
  t325 = 0.1e1 / t324;
  t326 = t192 * t325;
  t327 = t133 * t326;
  t330 = params->ltafrac * t325;
  t331 = t133 * t330;
  t335 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t316 * t62 - t273 / 0.4e1 + t321 * t136 + t229 + t281 / 0.3e1 - 0.2e1 / 0.3e1 * t132 * t327 - t132 * t331 / 0.2e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t122 + 0.2e1 * t140 + t7 * (t305 + t335);

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[3] = 0.0e0;

  t340 = t188 * t144;
  t342 = t85 * t340 / 0.10e2;
  t343 = t6 * t22;
  t344 = t37 * t192;
  t346 = t344 * t87 * t143;
  t350 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t180 * t145 - t342 + 0.2e1 / 0.5e1 * t343 * t346);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = t350 * t7 + t148;

  t354 = t279 * t150;
  t356 = t132 * t354 / 0.10e2;
  t358 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t276 * t151 - t356);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[1] = t358 * t7 + t154;

  t363 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t251 * t145 - t342);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[2] = t363 * t7 + t148;

  t367 = t6 * t54;
  t368 = t62 * t192;
  t370 = t368 * t134 * t149;
  t374 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t321 * t151 - t356 + 0.2e1 / 0.5e1 * t367 * t370);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[3] = t374 * t7 + t154;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[3] = 0.0e0;

  t376 = tau[0] * tau[0];
  t377 = 0.1e1 / t376;
  t378 = t192 * t377;
  t379 = t86 * t378;
  t382 = params->ltafrac * t377;
  t383 = t86 * t382;
  t387 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t85 * t379 + 0.3e1 / 0.10e2 * t85 * t383);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = t7 * t387;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[1] = 0.0e0;

  t388 = tau[1] * tau[1];
  t389 = 0.1e1 / t388;
  t390 = t192 * t389;
  t391 = t133 * t390;
  t394 = params->ltafrac * t389;
  t395 = t133 * t394;
  t399 = my_piecewise3(t42, 0, -0.6e1 / 0.25e2 * t132 * t391 + 0.3e1 / 0.10e2 * t132 * t395);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[2] = t7 * t399;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t404 = t6 * t171 * t80 * t37;
  t408 = t6 * t74 * t183 * t37;
  t411 = 0.1e1 / t79 / t67;
  t415 = 0.5e1 / 0.36e2 * t6 * t20 * t411 * t37;
  t416 = t192 * params->ltafrac;
  t418 = 0.1e1 / t193 / rho[0];
  t419 = t416 * t418;
  t420 = t86 * t419;
  t423 = t6 * t171;
  t426 = t180 * t189;
  t429 = t183 * t37;
  t430 = t429 * t88;
  t431 = t85 * t430;
  t433 = t188 * t195;
  t434 = t85 * t433;
  t437 = 0.1e1 / t157 / t16;
  t438 = t159 * t71;
  t441 = t158 * t71;
  t444 = t67 * t67;
  t445 = 0.1e1 / t444;
  t446 = t13 * t445;
  t449 = my_piecewise3(t11, 0, 0.6e1 * t163 - 0.6e1 * t446);
  t453 = my_piecewise3(t17, 0, -0.8e1 / 0.27e2 * t437 * t438 + 0.4e1 / 0.3e1 * t441 * t167 + 0.4e1 / 0.3e1 * t18 * t449);
  t460 = t188 * t199;
  t461 = t85 * t460;
  t463 = t192 * t418;
  t464 = t86 * t463;
  t467 = params->ltafrac * t418;
  t468 = t86 * t467;
  t470 = -0.3e1 / 0.8e1 * t404 + t408 / 0.4e1 - t415 + 0.8e1 / 0.9e1 * t85 * t420 + 0.3e1 / 0.2e1 * t423 * t89 + t426 - 0.2e1 * t180 * t196 - t431 / 0.3e1 - 0.2e1 / 0.3e1 * t434 - 0.3e1 / 0.8e1 * t6 * t453 * t21 * t37 - 0.3e1 / 0.2e1 * t180 * t200 - t461 / 0.2e1 + 0.2e1 * t85 * t464 + t85 * t468;
  t471 = my_piecewise3(t2, 0, t470);
  t473 = 0.1e1 / t205 / t49;
  t474 = t207 * t96;
  t477 = t206 * t96;
  t480 = t46 * t445;
  t483 = my_piecewise3(t45, 0, -0.6e1 * t163 - 0.6e1 * t480);
  t487 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t473 * t474 + 0.4e1 / 0.3e1 * t477 * t213 + 0.4e1 / 0.3e1 * t51 * t483);
  t494 = t6 * t217 * t80 * t62;
  t498 = t6 * t99 * t183 * t62;
  t503 = 0.5e1 / 0.36e2 * t6 * t53 * t411 * t62;
  t505 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t487 * t21 * t62 - 0.3e1 / 0.8e1 * t494 + t498 / 0.4e1 - t503);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t204 + 0.3e1 * t231 + t7 * (t471 + t505);

  t508 = 0.2e1 * t257;
  t509 = 0.2e1 * t284;
  t510 = t437 * t113;
  t513 = t158 * t238;
  t518 = 0.2e1 * t163;
  t519 = 0.6e1 * t446;
  t521 = my_piecewise3(t11, 0, t518 - t519);
  t525 = my_piecewise3(t17, 0, -0.8e1 / 0.27e2 * t510 * t159 + 0.8e1 / 0.9e1 * t513 * t71 + 0.4e1 / 0.9e1 * t234 * t167 + 0.4e1 / 0.3e1 * t18 * t521);
  t533 = t6 * t242 * t80 * t37 / 0.4e1;
  t534 = t6 * t242;
  t538 = t6 * t116 * t183 * t37;
  t541 = t251 * t189 / 0.3e1;
  t552 = -0.3e1 / 0.8e1 * t6 * t525 * t21 * t37 - t533 + t534 * t89 + t538 / 0.12e2 + t541 - 0.2e1 / 0.3e1 * t251 * t196 - t251 * t200 / 0.2e1 - t404 / 0.8e1 + t408 / 0.6e1 + t426 / 0.3e1 - t415 - 0.2e1 / 0.9e1 * t431 - 0.2e1 / 0.9e1 * t434 - t461 / 0.6e1;
  t553 = my_piecewise3(t2, 0, t552);
  t554 = t473 * t124;
  t557 = t206 * t262;
  t562 = 0.6e1 * t480;
  t564 = my_piecewise3(t45, 0, -t518 - t562);
  t568 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t554 * t207 + 0.8e1 / 0.9e1 * t557 * t96 + 0.4e1 / 0.9e1 * t258 * t213 + 0.4e1 / 0.3e1 * t51 * t564);
  t576 = t6 * t266 * t80 * t62 / 0.4e1;
  t579 = t6 * t127 * t183 * t62;
  t583 = t6 * t217;
  t587 = t276 * t280 / 0.3e1;
  t588 = t183 * t62;
  t589 = t588 * t135;
  t590 = t132 * t589;
  t593 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t568 * t21 * t62 - t576 + t579 / 0.12e2 - t494 / 0.8e1 + t498 / 0.6e1 - t503 + t583 * t136 / 0.2e1 + t587 - t590 / 0.9e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t204 + t231 + t508 + t509 + t7 * (t553 + t593);

  t596 = t437 * t289;
  t601 = t158 * t294;
  t605 = my_piecewise3(t11, 0, -t518 - t519);
  t609 = my_piecewise3(t17, 0, -0.8e1 / 0.27e2 * t596 * t71 + 0.8e1 / 0.9e1 * t234 * t238 + 0.4e1 / 0.9e1 * t601 * t71 + 0.4e1 / 0.3e1 * t18 * t605);
  t616 = t6 * t298 * t80 * t37;
  t618 = t6 * t298;
  t625 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t609 * t21 * t37 - t616 / 0.8e1 + t618 * t89 / 0.2e1 - t533 + t538 / 0.6e1 + t541 + t408 / 0.12e2 - t415 - t431 / 0.9e1);
  t626 = t473 * t306;
  t631 = t206 * t311;
  t635 = my_piecewise3(t45, 0, t518 - t562);
  t639 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t626 * t96 + 0.8e1 / 0.9e1 * t258 * t262 + 0.4e1 / 0.9e1 * t631 * t96 + 0.4e1 / 0.3e1 * t51 * t635);
  t646 = t6 * t315 * t80 * t62;
  t649 = t6 * t266;
  t651 = t321 * t280;
  t657 = t279 * t326;
  t658 = t132 * t657;
  t662 = t279 * t330;
  t663 = t132 * t662;
  t665 = -0.3e1 / 0.8e1 * t6 * t639 * t21 * t62 - t646 / 0.8e1 - t576 + t579 / 0.6e1 + t649 * t136 + t651 / 0.3e1 + t498 / 0.12e2 - t503 + t587 - 0.2e1 / 0.9e1 * t590 - 0.2e1 / 0.3e1 * t276 * t327 - 0.2e1 / 0.9e1 * t658 - t276 * t331 / 0.2e1 - t663 / 0.6e1;
  t666 = my_piecewise3(t42, 0, t665);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t508 + t509 + t305 + t335 + t7 * (t625 + t666);

  t671 = t289 * t113;
  t678 = my_piecewise3(t11, 0, -0.6e1 * t163 - 0.6e1 * t446);
  t682 = my_piecewise3(t17, 0, -0.8e1 / 0.27e2 * t437 * t671 + 0.4e1 / 0.3e1 * t234 * t294 + 0.4e1 / 0.3e1 * t18 * t678);
  t690 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t682 * t21 * t37 - 0.3e1 / 0.8e1 * t616 + t538 / 0.4e1 - t415);
  t691 = t306 * t124;
  t698 = my_piecewise3(t45, 0, 0.6e1 * t163 - 0.6e1 * t480);
  t702 = my_piecewise3(t50, 0, -0.8e1 / 0.27e2 * t473 * t691 + 0.4e1 / 0.3e1 * t258 * t311 + 0.4e1 / 0.3e1 * t51 * t698);
  t709 = t6 * t315;
  t715 = 0.1e1 / t324 / rho[1];
  t716 = t416 * t715;
  t717 = t133 * t716;
  t725 = t192 * t715;
  t726 = t133 * t725;
  t729 = params->ltafrac * t715;
  t730 = t133 * t729;
  t732 = -0.3e1 / 0.8e1 * t6 * t702 * t21 * t62 - 0.3e1 / 0.8e1 * t646 - t503 + t579 / 0.4e1 + 0.3e1 / 0.2e1 * t709 * t136 - 0.2e1 * t321 * t327 + 0.8e1 / 0.9e1 * t132 * t717 - t590 / 0.3e1 + t651 - 0.2e1 / 0.3e1 * t658 - t663 / 0.2e1 - 0.3e1 / 0.2e1 * t321 * t331 + 0.2e1 * t132 * t726 + t132 * t730;
  t733 = my_piecewise3(t42, 0, t732);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t305 + 0.3e1 * t335 + t7 * (t690 + t733);

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[5] = 0.0e0;

  t739 = t180 * t340;
  t741 = t6 * t75;
  t744 = t429 * t144;
  t746 = t85 * t744 / 0.15e2;
  t747 = t6 * t81;
  t748 = t747 * t346;
  t750 = t37 * t416;
  t751 = t194 * t143;
  t752 = t750 * t751;
  t755 = t344 * t751;
  t759 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t423 * t145 - t739 / 0.5e1 + 0.4e1 / 0.5e1 * t741 * t346 + t746 + 0.4e1 / 0.15e2 * t748 - 0.8e1 / 0.15e2 * t343 * t752 - 0.2e1 / 0.5e1 * t343 * t755);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = t7 * t759 + 0.2e1 * t350;

  t764 = t276 * t354;
  t766 = t588 * t150;
  t768 = t132 * t766 / 0.15e2;
  t770 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t583 * t151 - t764 / 0.5e1 + t768);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[1] = t7 * t770 + 0.2e1 * t358;

  t774 = t251 * t340;
  t776 = t6 * t117;
  t782 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t534 * t145 - t774 / 0.10e2 + 0.2e1 / 0.5e1 * t776 * t346 - t739 / 0.10e2 + t746 + 0.2e1 / 0.15e2 * t748);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[2] = t7 * t782 + t350 + t363;

  t786 = t321 * t354;
  t789 = t6 * t100;
  t792 = t6 * t104;
  t793 = t792 * t370;
  t796 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t649 * t151 - t786 / 0.10e2 - t764 / 0.10e2 + t768 + 0.2e1 / 0.5e1 * t789 * t370 + 0.2e1 / 0.15e2 * t793);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[3] = t7 * t796 + t358 + t374;

  t803 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t618 * t145 - t774 / 0.5e1 + t746);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[4] = t7 * t803 + 0.2e1 * t363;

  t809 = t6 * t128;
  t813 = t62 * t416;
  t814 = t325 * t149;
  t815 = t813 * t814;
  t818 = t368 * t814;
  t822 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t709 * t151 - t786 / 0.5e1 + 0.4e1 / 0.5e1 * t809 * t370 + t768 + 0.4e1 / 0.15e2 * t793 - 0.8e1 / 0.15e2 * t367 * t815 - 0.2e1 / 0.5e1 * t367 * t818);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[5] = t7 * t822 + 0.2e1 * t374;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[7] = 0.0e0;

  t826 = t188 * t378;
  t828 = 0.2e1 / 0.25e2 * t85 * t826;
  t829 = t87 * t377;
  t830 = t750 * t829;
  t835 = t188 * t382;
  t837 = t85 * t835 / 0.10e2;
  t838 = t344 * t829;
  t842 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t180 * t379 - t828 + 0.8e1 / 0.25e2 * t343 * t830 + 0.3e1 / 0.10e2 * t180 * t383 + t837 - 0.2e1 / 0.5e1 * t343 * t838);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = t7 * t842 + t387;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[1] = 0.0e0;

  t846 = t279 * t390;
  t848 = 0.2e1 / 0.25e2 * t132 * t846;
  t851 = t279 * t394;
  t853 = t132 * t851 / 0.10e2;
  t855 = my_piecewise3(t42, 0, -0.6e1 / 0.25e2 * t276 * t391 - t848 + 0.3e1 / 0.10e2 * t276 * t395 + t853);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[2] = t7 * t855 + t399;

  t862 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t251 * t379 - t828 + 0.3e1 / 0.10e2 * t251 * t383 + t837);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[3] = t7 * t862 + t387;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[4] = 0.0e0;

  t866 = t134 * t389;
  t867 = t813 * t866;
  t872 = t368 * t866;
  t876 = my_piecewise3(t42, 0, -0.6e1 / 0.25e2 * t321 * t391 - t848 + 0.8e1 / 0.25e2 * t367 * t867 + 0.3e1 / 0.10e2 * t321 * t395 + t853 - 0.2e1 / 0.5e1 * t367 * t872);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[5] = t7 * t876 + t399;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[5] = 0.0e0;

  t879 = 0.1e1 / t376 / tau[0];
  t880 = t416 * t879;
  t881 = t86 * t880;
  t884 = t192 * t879;
  t885 = t86 * t884;
  t888 = params->ltafrac * t879;
  t889 = t86 * t888;
  t893 = my_piecewise3(t2, 0, -0.24e2 / 0.125e3 * t85 * t881 + 0.18e2 / 0.25e2 * t85 * t885 - 0.3e1 / 0.5e1 * t85 * t889);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = t7 * t893;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[2] = 0.0e0;

  t895 = 0.1e1 / t388 / tau[1];
  t896 = t416 * t895;
  t897 = t133 * t896;
  t900 = t192 * t895;
  t901 = t133 * t900;
  t904 = params->ltafrac * t895;
  t905 = t133 * t904;
  t909 = my_piecewise3(t42, 0, -0.24e2 / 0.125e3 * t132 * t897 + 0.18e2 / 0.25e2 * t132 * t901 - 0.3e1 / 0.5e1 * t132 * t905);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[3] = t7 * t909;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t914 = t6 * t453 * t80 * t37;
  t916 = t16 * t16;
  t918 = 0.1e1 / t157 / t916;
  t919 = t159 * t159;
  t925 = t167 * t167;
  t931 = 0.1e1 / t444 / t7;
  t932 = t13 * t931;
  t935 = my_piecewise3(t11, 0, -0.24e2 * t445 + 0.24e2 * t932);
  t939 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t918 * t919 - 0.16e2 / 0.9e1 * t437 * t159 * t167 + 0.4e1 / 0.3e1 * t158 * t925 + 0.16e2 / 0.9e1 * t441 * t449 + 0.4e1 / 0.3e1 * t18 * t935);
  t946 = t6 * t171 * t183 * t37;
  t950 = t6 * t74 * t411 * t37;
  t953 = 0.1e1 / t79 / t162;
  t957 = 0.10e2 / 0.27e2 * t6 * t20 * t953 * t37;
  t958 = t411 * t37;
  t960 = t85 * t958 * t88;
  t964 = t192 * t192;
  t965 = t193 * t193;
  t966 = 0.1e1 / t965;
  t974 = t85 * t188 * t467;
  t984 = -t914 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t939 * t21 * t37 + t946 / 0.2e1 - 0.5e1 / 0.9e1 * t950 + t957 + 0.20e2 / 0.27e2 * t960 + 0.32e2 / 0.9e1 * t180 * t420 - 0.32e2 / 0.27e2 * t85 * t86 * t964 * t966 + 0.4e1 * t180 * t468 + 0.4e1 / 0.3e1 * t974 - 0.22e2 / 0.3e1 * t85 * t86 * t192 * t966 - 0.3e1 * t85 * t86 * params->ltafrac * t966;
  t987 = t180 * t460;
  t992 = t85 * t429 * t199;
  t995 = t85 * t188 * t463;
  t998 = t85 * t188 * t419;
  t1004 = t6 * t453;
  t1009 = t180 * t433;
  t1012 = t85 * t429 * t195;
  t1014 = t423 * t189;
  t1016 = t180 * t430;
  t1018 = -0.3e1 * t423 * t200 - 0.2e1 * t987 + 0.8e1 * t180 * t464 + 0.2e1 / 0.3e1 * t992 + 0.8e1 / 0.3e1 * t995 + 0.32e2 / 0.27e2 * t998 - 0.16e2 / 0.3e1 * t85 * t86 * t416 * t966 + 0.2e1 * t1004 * t89 - 0.4e1 * t423 * t196 - 0.8e1 / 0.3e1 * t1009 + 0.8e1 / 0.9e1 * t1012 + 0.2e1 * t1014 - 0.4e1 / 0.3e1 * t1016;
  t1020 = my_piecewise3(t2, 0, t984 + t1018);
  t1021 = t49 * t49;
  t1023 = 0.1e1 / t205 / t1021;
  t1024 = t207 * t207;
  t1030 = t213 * t213;
  t1035 = t46 * t931;
  t1038 = my_piecewise3(t45, 0, 0.24e2 * t445 + 0.24e2 * t1035);
  t1042 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1023 * t1024 - 0.16e2 / 0.9e1 * t473 * t207 * t213 + 0.4e1 / 0.3e1 * t206 * t1030 + 0.16e2 / 0.9e1 * t477 * t483 + 0.4e1 / 0.3e1 * t51 * t1038);
  t1049 = t6 * t487 * t80 * t62;
  t1053 = t6 * t217 * t183 * t62;
  t1057 = t6 * t99 * t411 * t62;
  t1062 = 0.10e2 / 0.27e2 * t6 * t53 * t953 * t62;
  t1064 = my_piecewise3(t42, 0, -0.3e1 / 0.8e1 * t6 * t1042 * t21 * t62 - t1049 / 0.2e1 + t1053 / 0.2e1 - 0.5e1 / 0.9e1 * t1057 + t1062);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t471 + 0.4e1 * t505 + t7 * (t1020 + t1064);

  t1085 = 0.12e2 * t445;
  t1086 = 0.24e2 * t932;
  t1088 = my_piecewise3(t11, 0, -t1085 + t1086);
  t1092 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t918 * t113 * t438 - 0.8e1 / 0.9e1 * t437 * t238 * t159 - 0.8e1 / 0.9e1 * t510 * t71 * t167 + 0.4e1 / 0.3e1 * t158 * t521 * t71 + 0.4e1 / 0.3e1 * t513 * t167 + 0.4e1 / 0.9e1 * t234 * t449 + 0.4e1 / 0.3e1 * t18 * t1088);
  t1099 = t6 * t525 * t80 * t37;
  t1103 = t6 * t242 * t183 * t37;
  t1104 = t1103 / 0.4e1;
  t1107 = t6 * t116 * t411 * t37;
  t1115 = t251 * t460;
  t1122 = -0.3e1 / 0.8e1 * t6 * t1092 * t21 * t37 - 0.3e1 / 0.8e1 * t1099 + t1104 - 0.5e1 / 0.36e2 * t1107 - t914 / 0.8e1 + t946 / 0.4e1 - 0.5e1 / 0.12e2 * t950 + t957 + 0.5e1 / 0.9e1 * t960 - 0.3e1 / 0.2e1 * t534 * t200 - t1115 / 0.2e1 + 0.2e1 * t251 * t464 + t251 * t468 + 0.8e1 / 0.9e1 * t251 * t420;
  t1123 = t6 * t525;
  t1126 = t534 * t189;
  t1129 = t251 * t430;
  t1130 = t1129 / 0.3e1;
  t1131 = t251 * t433;
  t1142 = 0.3e1 / 0.2e1 * t1123 * t89 + t1126 - 0.2e1 * t534 * t196 - t1130 - 0.2e1 / 0.3e1 * t1131 + t974 / 0.3e1 - t987 / 0.2e1 + t992 / 0.3e1 + 0.2e1 / 0.3e1 * t995 + 0.8e1 / 0.27e2 * t998 - 0.2e1 / 0.3e1 * t1009 + 0.4e1 / 0.9e1 * t1012 + t1014 / 0.2e1 - 0.2e1 / 0.3e1 * t1016;
  t1144 = my_piecewise3(t2, 0, t1122 + t1142);
  t1161 = 0.24e2 * t1035;
  t1163 = my_piecewise3(t45, 0, t1085 + t1161);
  t1167 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1023 * t124 * t474 - 0.8e1 / 0.9e1 * t473 * t262 * t207 - 0.8e1 / 0.9e1 * t554 * t96 * t213 + 0.4e1 / 0.3e1 * t206 * t564 * t96 + 0.4e1 / 0.3e1 * t557 * t213 + 0.4e1 / 0.9e1 * t258 * t483 + 0.4e1 / 0.3e1 * t51 * t1163);
  t1174 = t6 * t568 * t80 * t62;
  t1178 = t6 * t266 * t183 * t62;
  t1179 = t1178 / 0.4e1;
  t1182 = t6 * t127 * t411 * t62;
  t1187 = t6 * t487;
  t1190 = t583 * t280;
  t1192 = t276 * t589;
  t1193 = t1192 / 0.3e1;
  t1194 = t411 * t62;
  t1196 = t132 * t1194 * t135;
  t1198 = -0.3e1 / 0.8e1 * t6 * t1167 * t21 * t62 - 0.3e1 / 0.8e1 * t1174 + t1179 - 0.5e1 / 0.36e2 * t1182 - t1049 / 0.8e1 + t1053 / 0.4e1 - 0.5e1 / 0.12e2 * t1057 + t1062 + t1187 * t136 / 0.2e1 + t1190 / 0.2e1 - t1193 + 0.5e1 / 0.27e2 * t1196;
  t1199 = my_piecewise3(t42, 0, t1198);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t471 + t505 + 0.3e1 * t553 + 0.3e1 * t593 + t7 * (t1144 + t1199);

  t1216 = t238 * t238;
  t1229 = my_piecewise3(t11, 0, t1086);
  t1233 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t918 * t289 * t159 - 0.32e2 / 0.27e2 * t510 * t71 * t238 - 0.8e1 / 0.27e2 * t596 * t167 + 0.8e1 / 0.9e1 * t158 * t1216 + 0.8e1 / 0.9e1 * t234 * t521 - 0.8e1 / 0.27e2 * t437 * t294 * t159 + 0.8e1 / 0.9e1 * t158 * t605 * t71 + 0.4e1 / 0.9e1 * t601 * t167 + 0.4e1 / 0.3e1 * t18 * t1229);
  t1240 = t6 * t609 * t80 * t37;
  t1244 = t6 * t298 * t183 * t37;
  t1254 = t6 * t609;
  t1256 = t618 * t189;
  t1266 = -t1115 / 0.3e1 + t992 / 0.9e1 + t1254 * t89 + t1256 / 0.3e1 - 0.2e1 / 0.3e1 * t618 * t196 + 0.2e1 / 0.3e1 * t1126 - 0.4e1 / 0.9e1 * t1129 - 0.4e1 / 0.9e1 * t1131 + 0.4e1 / 0.27e2 * t1012 - 0.2e1 / 0.9e1 * t1016 + 0.10e2 / 0.27e2 * t960;
  t1268 = my_piecewise3(t2, 0, -t618 * t200 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t1233 * t21 * t37 - t1240 / 0.4e1 + t1244 / 0.12e2 - t1099 / 0.4e1 + t1103 / 0.3e1 - 0.5e1 / 0.18e2 * t1107 + t946 / 0.12e2 - 0.5e1 / 0.18e2 * t950 + t957 + t1266);
  t1269 = t649 * t280;
  t1271 = t321 * t589;
  t1273 = t276 * t657;
  t1276 = t132 * t588 * t326;
  t1278 = t276 * t662;
  t1281 = t132 * t588 * t330;
  t1294 = t262 * t262;
  t1307 = my_piecewise3(t45, 0, t1161);
  t1311 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1023 * t306 * t207 - 0.32e2 / 0.27e2 * t554 * t96 * t262 - 0.8e1 / 0.27e2 * t626 * t213 + 0.8e1 / 0.9e1 * t206 * t1294 + 0.8e1 / 0.9e1 * t258 * t564 - 0.8e1 / 0.27e2 * t473 * t311 * t207 + 0.8e1 / 0.9e1 * t206 * t635 * t96 + 0.4e1 / 0.9e1 * t631 * t213 + 0.4e1 / 0.3e1 * t51 * t1307);
  t1319 = t6 * t639 * t80 * t62;
  t1323 = t6 * t315 * t183 * t62;
  t1330 = t6 * t568;
  t1336 = -t1319 / 0.4e1 + t1323 / 0.12e2 - t1174 / 0.4e1 + t1178 / 0.3e1 - 0.5e1 / 0.18e2 * t1182 + t1053 / 0.12e2 - 0.5e1 / 0.18e2 * t1057 + t1062 + t1330 * t136 - 0.2e1 / 0.3e1 * t583 * t327 - t583 * t331 / 0.2e1;
  t1338 = my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t1269 - 0.2e1 / 0.9e1 * t1271 - 0.4e1 / 0.9e1 * t1273 + 0.4e1 / 0.27e2 * t1276 - t1278 / 0.3e1 + t1281 / 0.9e1 + t1190 / 0.3e1 - 0.4e1 / 0.9e1 * t1192 + 0.10e2 / 0.27e2 * t1196 - 0.3e1 / 0.8e1 * t6 * t1311 * t21 * t62 + t1336);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t553 + 0.2e1 * t593 + 0.2e1 * t625 + 0.2e1 * t666 + t7 * (t1268 + t1338);

  t1359 = my_piecewise3(t11, 0, t1085 + t1086);
  t1363 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t918 * t671 * t71 - 0.8e1 / 0.9e1 * t596 * t238 - 0.8e1 / 0.9e1 * t510 * t294 * t71 + 0.4e1 / 0.3e1 * t513 * t294 + 0.4e1 / 0.3e1 * t234 * t605 + 0.4e1 / 0.9e1 * t158 * t678 * t71 + 0.4e1 / 0.3e1 * t18 * t1359);
  t1370 = t6 * t682 * t80 * t37;
  t1372 = t6 * t682;
  t1381 = -0.3e1 / 0.8e1 * t6 * t1363 * t21 * t37 - t1370 / 0.8e1 + t1372 * t89 / 0.2e1 - 0.3e1 / 0.8e1 * t1240 + t1244 / 0.4e1 + t1256 / 0.2e1 + t1104 - 0.5e1 / 0.12e2 * t1107 - t1130 - 0.5e1 / 0.36e2 * t950 + t957 + 0.5e1 / 0.27e2 * t960;
  t1382 = my_piecewise3(t2, 0, t1381);
  t1399 = my_piecewise3(t45, 0, -t1085 + t1161);
  t1403 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1023 * t691 * t96 - 0.8e1 / 0.9e1 * t626 * t262 - 0.8e1 / 0.9e1 * t554 * t311 * t96 + 0.4e1 / 0.3e1 * t557 * t311 + 0.4e1 / 0.3e1 * t258 * t635 + 0.4e1 / 0.9e1 * t206 * t698 * t96 + 0.4e1 / 0.3e1 * t51 * t1399);
  t1410 = t6 * t702 * t80 * t62;
  t1423 = t6 * t639;
  t1428 = -0.3e1 / 0.8e1 * t6 * t1403 * t21 * t62 - t1410 / 0.8e1 - 0.3e1 / 0.8e1 * t1319 + t1323 / 0.4e1 + t1179 - 0.5e1 / 0.12e2 * t1182 - 0.5e1 / 0.36e2 * t1057 + t1062 + 0.8e1 / 0.9e1 * t276 * t717 - 0.3e1 / 0.2e1 * t649 * t331 + 0.2e1 * t276 * t726 + t276 * t730 + 0.3e1 / 0.2e1 * t1423 * t136 - 0.2e1 * t649 * t327;
  t1435 = t132 * t279 * t729;
  t1437 = t709 * t280;
  t1439 = t321 * t657;
  t1442 = t132 * t279 * t716;
  t1444 = t321 * t662;
  t1447 = t132 * t279 * t725;
  t1450 = t1269 - 0.2e1 / 0.3e1 * t1271 - 0.2e1 / 0.3e1 * t1273 + 0.4e1 / 0.9e1 * t1276 - t1278 / 0.2e1 + t1281 / 0.3e1 + t1435 / 0.3e1 + t1437 / 0.2e1 - 0.2e1 / 0.3e1 * t1439 + 0.8e1 / 0.27e2 * t1442 - t1444 / 0.2e1 + 0.2e1 / 0.3e1 * t1447 - t1193 + 0.5e1 / 0.9e1 * t1196;
  t1452 = my_piecewise3(t42, 0, t1428 + t1450);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t625 + 0.3e1 * t666 + t690 + t733 + t7 * (t1382 + t1452);

  t1457 = t289 * t289;
  t1462 = t294 * t294;
  t1469 = my_piecewise3(t11, 0, 0.24e2 * t445 + 0.24e2 * t932);
  t1473 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t918 * t1457 - 0.16e2 / 0.9e1 * t596 * t294 + 0.4e1 / 0.3e1 * t158 * t1462 + 0.16e2 / 0.9e1 * t234 * t678 + 0.4e1 / 0.3e1 * t18 * t1469);
  t1482 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1473 * t21 * t37 - t1370 / 0.2e1 + t1244 / 0.2e1 - 0.5e1 / 0.9e1 * t1107 + t957);
  t1483 = t306 * t306;
  t1488 = t311 * t311;
  t1495 = my_piecewise3(t45, 0, -0.24e2 * t445 + 0.24e2 * t1035);
  t1499 = my_piecewise3(t50, 0, 0.40e2 / 0.81e2 * t1023 * t1483 - 0.16e2 / 0.9e1 * t626 * t311 + 0.4e1 / 0.3e1 * t206 * t1488 + 0.16e2 / 0.9e1 * t258 * t698 + 0.4e1 / 0.3e1 * t51 * t1495);
  t1509 = t324 * t324;
  t1510 = 0.1e1 / t1509;
  t1529 = -0.3e1 / 0.8e1 * t6 * t1499 * t21 * t62 - t1410 / 0.2e1 + t1323 / 0.2e1 - 0.5e1 / 0.9e1 * t1182 + t1062 + 0.4e1 * t321 * t730 - 0.22e2 / 0.3e1 * t132 * t133 * t192 * t1510 - 0.3e1 * t132 * t133 * params->ltafrac * t1510 - 0.16e2 / 0.3e1 * t132 * t133 * t416 * t1510 - 0.3e1 * t709 * t331 + 0.8e1 * t321 * t726 + 0.32e2 / 0.9e1 * t321 * t717;
  t1534 = t6 * t702;
  t1549 = -0.32e2 / 0.27e2 * t132 * t133 * t964 * t1510 + 0.2e1 * t1534 * t136 - 0.4e1 * t709 * t327 - 0.4e1 / 0.3e1 * t1271 + 0.8e1 / 0.9e1 * t1276 + 0.2e1 / 0.3e1 * t1281 + 0.4e1 / 0.3e1 * t1435 + 0.2e1 * t1437 - 0.8e1 / 0.3e1 * t1439 + 0.32e2 / 0.27e2 * t1442 - 0.2e1 * t1444 + 0.8e1 / 0.3e1 * t1447 + 0.20e2 / 0.27e2 * t1196;
  t1551 = my_piecewise3(t42, 0, t1529 + t1549);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t690 + 0.4e1 * t733 + t7 * (t1482 + t1551);

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[7] = 0.0e0;

  t1555 = t747 * t755;
  t1557 = t418 * t143;
  t1567 = t6 * t184 * t346;
  t1569 = t747 * t752;
  t1571 = t37 * t964;
  t1575 = t423 * t340;
  t1580 = t180 * t744;
  t1583 = t6 * t176 * t346;
  t1589 = t85 * t958 * t144 / 0.9e1;
  t1592 = -0.2e1 / 0.5e1 * t1555 + 0.8e1 / 0.5e1 * t343 * t750 * t1557 + 0.4e1 / 0.5e1 * t343 * t344 * t1557 - 0.6e1 / 0.5e1 * t741 * t755 - 0.4e1 / 0.15e2 * t1567 - 0.8e1 / 0.15e2 * t1569 + 0.32e2 / 0.45e2 * t343 * t1571 * t1557 - 0.3e1 / 0.10e2 * t1575 + 0.6e1 / 0.5e1 * t6 * t172 * t346 + t1580 / 0.5e1 + 0.4e1 / 0.5e1 * t1583 - 0.8e1 / 0.5e1 * t741 * t752 - t1589 - 0.3e1 / 0.10e2 * t1004 * t145;
  t1593 = my_piecewise3(t2, 0, t1592);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = t1593 * t7 + 0.3e1 * t759;

  t1598 = t583 * t354;
  t1600 = t276 * t766;
  t1604 = t132 * t1194 * t150 / 0.9e1;
  t1606 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t1187 * t151 - 0.3e1 / 0.10e2 * t1598 + t1600 / 0.5e1 - t1604);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[1] = t1606 * t7 + 0.3e1 * t770;

  t1608 = 0.2e1 * t782;
  t1612 = t534 * t340 / 0.5e1;
  t1616 = t251 * t744;
  t1620 = 0.4e1 / 0.15e2 * t6 * t247 * t346;
  t1631 = -0.3e1 / 0.10e2 * t1123 * t145 - t1612 + 0.4e1 / 0.5e1 * t6 * t243 * t346 + t1616 / 0.15e2 + t1620 - 0.8e1 / 0.15e2 * t776 * t752 - 0.2e1 / 0.5e1 * t776 * t755 - t1575 / 0.10e2 + 0.2e1 / 0.15e2 * t1580 + 0.4e1 / 0.15e2 * t1583 - t1589 - 0.8e1 / 0.45e2 * t1567 - 0.8e1 / 0.45e2 * t1569 - 0.2e1 / 0.15e2 * t1555;
  t1632 = my_piecewise3(t2, 0, t1631);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[2] = t1632 * t7 + t1608 + t759;

  t1634 = 0.2e1 * t796;
  t1638 = t649 * t354 / 0.5e1;
  t1639 = t321 * t766;
  t1648 = 0.4e1 / 0.15e2 * t6 * t222 * t370;
  t1650 = t6 * t226 * t370;
  t1653 = my_piecewise3(t42, 0, -0.3e1 / 0.10e2 * t1330 * t151 - t1638 + t1639 / 0.15e2 - t1598 / 0.10e2 + 0.2e1 / 0.15e2 * t1600 - t1604 + 0.2e1 / 0.5e1 * t6 * t218 * t370 + t1648 - 0.4e1 / 0.45e2 * t1650);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[3] = t1653 * t7 + t1634 + t770;

  t1657 = t618 * t340;
  t1666 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t1254 * t145 - t1657 / 0.10e2 + 0.2e1 / 0.5e1 * t6 * t299 * t346 - t1612 + 0.2e1 / 0.15e2 * t1616 + t1620 + t1580 / 0.15e2 - t1589 - 0.4e1 / 0.45e2 * t1567);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[4] = t1666 * t7 + t1608 + t803;

  t1670 = t709 * t354;
  t1677 = t6 * t271 * t370;
  t1683 = t792 * t815;
  t1687 = t792 * t818;
  t1689 = -0.3e1 / 0.10e2 * t1423 * t151 - t1670 / 0.10e2 - t1638 + 0.2e1 / 0.15e2 * t1639 + 0.4e1 / 0.5e1 * t6 * t267 * t370 + 0.4e1 / 0.15e2 * t1677 + t1600 / 0.15e2 - t1604 + t1648 - 0.8e1 / 0.45e2 * t1650 - 0.8e1 / 0.15e2 * t789 * t815 - 0.8e1 / 0.45e2 * t1683 - 0.2e1 / 0.5e1 * t789 * t818 - 0.2e1 / 0.15e2 * t1687;
  t1690 = my_piecewise3(t42, 0, t1689);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[5] = t1690 * t7 + t1634 + t822;

  t1698 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t1372 * t145 - 0.3e1 / 0.10e2 * t1657 + t1616 / 0.5e1 - t1589);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[6] = t1698 * t7 + 0.3e1 * t803;

  t1705 = t715 * t149;
  t1721 = t62 * t964;
  t1727 = -0.3e1 / 0.10e2 * t1534 * t151 - 0.6e1 / 0.5e1 * t809 * t818 + 0.8e1 / 0.5e1 * t367 * t813 * t1705 + 0.4e1 / 0.5e1 * t367 * t368 * t1705 - 0.8e1 / 0.15e2 * t1683 - 0.2e1 / 0.5e1 * t1687 - 0.4e1 / 0.15e2 * t1650 + 0.4e1 / 0.5e1 * t1677 + 0.6e1 / 0.5e1 * t6 * t316 * t370 - 0.8e1 / 0.5e1 * t809 * t815 + 0.32e2 / 0.45e2 * t367 * t1721 * t1705 - 0.3e1 / 0.10e2 * t1670 + t1639 / 0.5e1 - t1604;
  t1728 = my_piecewise3(t42, 0, t1727);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[7] = t1728 * t7 + 0.3e1 * t822;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[11] = 0.0e0;

  t1733 = t180 * t826;
  t1739 = 0.4e1 / 0.75e2 * t85 * t429 * t378;
  t1740 = t747 * t830;
  t1742 = t194 * t377;
  t1751 = t180 * t835;
  t1757 = t85 * t429 * t382 / 0.15e2;
  t1758 = t747 * t838;
  t1763 = -0.6e1 / 0.25e2 * t423 * t379 - 0.4e1 / 0.25e2 * t1733 + 0.16e2 / 0.25e2 * t741 * t830 + t1739 + 0.16e2 / 0.75e2 * t1740 - 0.32e2 / 0.75e2 * t343 * t1571 * t1742 + 0.16e2 / 0.75e2 * t343 * t750 * t1742 + 0.3e1 / 0.10e2 * t423 * t383 + t1751 / 0.5e1 - 0.4e1 / 0.5e1 * t741 * t838 - t1757 - 0.4e1 / 0.15e2 * t1758 + 0.2e1 / 0.5e1 * t343 * t344 * t1742;
  t1764 = my_piecewise3(t2, 0, t1763);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = t1764 * t7 + 0.2e1 * t842;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[1] = 0.0e0;

  t1769 = t276 * t846;
  t1773 = 0.4e1 / 0.75e2 * t132 * t588 * t390;
  t1776 = t276 * t851;
  t1780 = t132 * t588 * t394 / 0.15e2;
  t1782 = my_piecewise3(t42, 0, -0.6e1 / 0.25e2 * t583 * t391 - 0.4e1 / 0.25e2 * t1769 + t1773 + 0.3e1 / 0.10e2 * t583 * t395 + t1776 / 0.5e1 - t1780);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[2] = t1782 * t7 + 0.2e1 * t855;

  t1786 = t251 * t826;
  t1794 = t251 * t835;
  t1800 = -0.6e1 / 0.25e2 * t534 * t379 - 0.2e1 / 0.25e2 * t1786 + 0.8e1 / 0.25e2 * t776 * t830 - 0.2e1 / 0.25e2 * t1733 + t1739 + 0.8e1 / 0.75e2 * t1740 + 0.3e1 / 0.10e2 * t534 * t383 + t1794 / 0.10e2 - 0.2e1 / 0.5e1 * t776 * t838 + t1751 / 0.10e2 - t1757 - 0.2e1 / 0.15e2 * t1758;
  t1801 = my_piecewise3(t2, 0, t1800);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[3] = t1801 * t7 + t842 + t862;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[4] = 0.0e0;

  t1805 = t321 * t846;
  t1810 = t792 * t867;
  t1814 = t321 * t851;
  t1819 = t792 * t872;
  t1821 = -0.6e1 / 0.25e2 * t649 * t391 - 0.2e1 / 0.25e2 * t1805 - 0.2e1 / 0.25e2 * t1769 + t1773 + 0.8e1 / 0.25e2 * t789 * t867 + 0.8e1 / 0.75e2 * t1810 + 0.3e1 / 0.10e2 * t649 * t395 + t1814 / 0.10e2 + t1776 / 0.10e2 - t1780 - 0.2e1 / 0.5e1 * t789 * t872 - 0.2e1 / 0.15e2 * t1819;
  t1822 = my_piecewise3(t42, 0, t1821);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[5] = t1822 * t7 + t855 + t876;

  t1832 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t618 * t379 - 0.4e1 / 0.25e2 * t1786 + t1739 + 0.3e1 / 0.10e2 * t618 * t383 + t1794 / 0.5e1 - t1757);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[6] = t1832 * t7 + 0.2e1 * t862;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[7] = 0.0e0;

  t1841 = t325 * t389;
  t1857 = -0.6e1 / 0.25e2 * t709 * t391 - 0.4e1 / 0.25e2 * t1805 + 0.16e2 / 0.25e2 * t809 * t867 + t1773 + 0.16e2 / 0.75e2 * t1810 - 0.32e2 / 0.75e2 * t367 * t1721 * t1841 + 0.16e2 / 0.75e2 * t367 * t813 * t1841 + 0.3e1 / 0.10e2 * t709 * t395 + t1814 / 0.5e1 - 0.4e1 / 0.5e1 * t809 * t872 - t1780 - 0.4e1 / 0.15e2 * t1819 + 0.2e1 / 0.5e1 * t367 * t368 * t1841;
  t1858 = my_piecewise3(t42, 0, t1857);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[8] = t1858 * t7 + 0.2e1 * t876;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[11] = 0.0e0;

  t1864 = 0.8e1 / 0.125e3 * t85 * t188 * t880;
  t1865 = t87 * t879;
  t1873 = 0.6e1 / 0.25e2 * t85 * t188 * t884;
  t1881 = t85 * t188 * t888 / 0.5e1;
  t1886 = my_piecewise3(t2, 0, -0.24e2 / 0.125e3 * t180 * t881 - t1864 + 0.32e2 / 0.125e3 * t343 * t1571 * t1865 + 0.18e2 / 0.25e2 * t180 * t885 + t1873 - 0.24e2 / 0.25e2 * t343 * t750 * t1865 - 0.3e1 / 0.5e1 * t180 * t889 - t1881 + 0.4e1 / 0.5e1 * t343 * t344 * t1865);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = t1886 * t7 + t893;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[2] = 0.0e0;

  t1892 = 0.8e1 / 0.125e3 * t132 * t279 * t896;
  t1897 = 0.6e1 / 0.25e2 * t132 * t279 * t900;
  t1902 = t132 * t279 * t904 / 0.5e1;
  t1904 = my_piecewise3(t42, 0, -0.24e2 / 0.125e3 * t276 * t897 - t1892 + 0.18e2 / 0.25e2 * t276 * t901 + t1897 - 0.3e1 / 0.5e1 * t276 * t905 - t1902);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[3] = t1904 * t7 + t909;

  t1913 = my_piecewise3(t2, 0, -0.24e2 / 0.125e3 * t251 * t881 - t1864 + 0.18e2 / 0.25e2 * t251 * t885 + t1873 - 0.3e1 / 0.5e1 * t251 * t889 - t1881);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[4] = t1913 * t7 + t893;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[6] = 0.0e0;

  t1917 = t134 * t895;
  t1932 = my_piecewise3(t42, 0, -0.24e2 / 0.125e3 * t321 * t897 - t1892 + 0.32e2 / 0.125e3 * t367 * t1721 * t1917 + 0.18e2 / 0.25e2 * t321 * t901 + t1897 - 0.24e2 / 0.25e2 * t367 * t813 * t1917 - 0.3e1 / 0.5e1 * t321 * t905 - t1902 + 0.4e1 / 0.5e1 * t367 * t368 * t1917);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[7] = t1932 * t7 + t909;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[7] = 0.0e0;

  t1934 = t376 * t376;
  t1935 = 0.1e1 / t1934;
  t1953 = my_piecewise3(t2, 0, -0.96e2 / 0.625e3 * t85 * t86 * t964 * t1935 + 0.144e3 / 0.125e3 * t85 * t86 * t416 * t1935 - 0.66e2 / 0.25e2 * t85 * t86 * t192 * t1935 + 0.9e1 / 0.5e1 * t85 * t86 * params->ltafrac * t1935);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = t7 * t1953;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[3] = 0.0e0;

  t1954 = t388 * t388;
  t1955 = 0.1e1 / t1954;
  t1973 = my_piecewise3(t42, 0, -0.96e2 / 0.625e3 * t132 * t133 * t964 * t1955 + 0.144e3 / 0.125e3 * t132 * t133 * t416 * t1955 - 0.66e2 / 0.25e2 * t132 * t133 * t192 * t1955 + 0.9e1 / 0.5e1 * t132 * t133 * params->ltafrac * t1955);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[4] = t7 * t1973;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

