/* 
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_x.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho , double *zk LDA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t6, t8, t9, t13, t14;

#ifndef XC_DONT_COMPILE_VXC
  double t15, t16, t21;

#ifndef XC_DONT_COMPILE_FXC
  double t31;

#ifndef XC_DONT_COMPILE_KXC
  double t36, t42;

#ifndef XC_DONT_COMPILE_LXC
  double t53;
#endif

#endif

#endif

#endif

#endif


  lda_x_params *params;

  assert(p->params != NULL);
  params = (lda_x_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t8 = my_piecewise3(0.1e1 <= p->zeta_threshold, 0, 1);
  t9 = POW_1_3(rho[0]);
  t13 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t8 * t9);
  t14 = params->alpha * t13;
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t14;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t15 = rho[0] * params->alpha;
  t16 = t9 * t9;
  t21 = my_piecewise3(t2, 0, -t6 * t8 / t16 / 0.8e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * t15 * t21 + 0.2e1 * t14;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t31 = my_piecewise3(t2, 0, t6 * t8 / t16 / rho[0] / 0.12e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t15 * t31 + 0.4e1 * params->alpha * t21;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t36 = rho[0] * rho[0];
  t42 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t8 / t16 / t36);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * t15 * t42 + 0.6e1 * params->alpha * t31;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t53 = my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t8 / t16 / t36 / rho[0]);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * t15 * t53 + 0.8e1 * params->alpha * t42;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho , double *zk LDA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t1, t2, t3, t5, t6, t7, t8, t10;
  double t11, t12, t13, t17, t18, t22, t23, t24;
  double t25, t27, t28, t29, t33, t37, t38;

#ifndef XC_DONT_COMPILE_VXC
  double t39, t42, t43, t46, t47, t48, t49, t51;
  double t56, t60, t61, t64, t66, t67, t70, t71;
  double t72, t73, t74, t75, t76, t77, t81, t87;
  double t89, t90, t93, t94, t95, t99, t104, t105;
  double t108, t110, t115, t120, t121;

#ifndef XC_DONT_COMPILE_FXC
  double t126, t127, t129, t134, t135, t137, t140, t141;
  double t142, t148, t153, t158, t161, t164, t166, t167;
  double t170, t171, t172, t173, t174, t176, t177, t179;
  double t181, t182, t186, t191, t195, t197, t198, t205;
  double t206, t208, t209, t213, t218, t222, t223, t224;
  double t226, t227, t231, t233, t235, t239, t241, t246;
  double t251, t255, t256, t262, t263, t264, t268, t274;
  double t275, t277, t281, t282, t287, t292, t298, t299;

#ifndef XC_DONT_COMPILE_KXC
  double t304, t306, t308, t311, t316, t318, t322, t325;
  double t329, t331, t335, t336, t337, t342, t346, t347;
  double t352, t355, t358, t361, t363, t364, t367, t369;
  double t372, t374, t376, t377, t379, t382, t387, t392;
  double t395, t399, t401, t402, t405, t406, t414, t418;
  double t419, t421, t422, t423, t426, t429, t432, t433;
  double t439, t441, t446, t447, t448, t450, t451, t453;
  double t454, t460, t462, t464, t468, t469, t477, t478;
  double t479, t483, t484, t490, t492, t497, t498, t508;
  double t509, t511, t512, t516, t521, t526, t527, t530;
  double t532, t533, t536, t544, t550, t551, t555, t561;
  double t565, t566, t571, t576, t577, t584, t585, t586;
  double t590, t597, t598, t601, t604, t611, t615, t619;
  double t623, t624, t631, t632;

#ifndef XC_DONT_COMPILE_LXC
  double t638, t642, t645, t649, t651, t659, t666, t675;
  double t677, t680, t683, t691, t693, t695, t700, t701;
  double t706, t709, t712, t715, t718, t720, t724, t726;
  double t729, t731, t732, t734, t739, t742, t747, t752;
  double t755, t758, t762, t764, t774, t792, t796, t800;
  double t802, t807, t810, t813, t818, t820, t825, t828;
  double t829, t831, t837, t840, t845, t847, t850, t857;
  double t858, t860, t863, t867, t870, t883, t884, t889;
  double t890, t895, t898, t899, t901, t907, t933, t938;
  double t942, t947, t948, t953, t956, t964, t966, t968;
  double t972, t978, t985, t988, t1001, t1002, t1004, t1011;
  double t1016, t1017, t1024, t1026, t1031, t1040, t1042, t1047;
  double t1050, t1058, t1075, t1081, t1082, t1087, t1094, t1098;
  double t1120, t1123, t1129, t1140, t1147, t1149, t1161, t1163;
  double t1168, t1175, t1190, t1198, t1217, t1224, t1238, t1239;
  double t1247;
#endif

#endif

#endif

#endif

#endif


  lda_x_params *params;

  assert(p->params != NULL);
  params = (lda_x_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t8 = rho[0] * t7;
  t10 = 0.2e1 * t8 <= p->zeta_threshold;
  t11 = M_CBRT2;
  t12 = t11 * rho[0];
  t13 = POW_1_3(t8);
  t17 = my_piecewise3(t10, 0, 0.2e1 * t12 * t7 * t13);
  t18 = POW_1_3(t6);
  t22 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t17 * t18);
  t23 = params->alpha * t22;
  t24 = rho[1] <= p->dens_threshold;
  t25 = rho[1] * t7;
  t27 = 0.2e1 * t25 <= p->zeta_threshold;
  t28 = t11 * rho[1];
  t29 = POW_1_3(t25);
  t33 = my_piecewise3(t27, 0, 0.2e1 * t28 * t7 * t29);
  t37 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t33 * t18);
  t38 = params->alpha * t37;
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t23 + t38;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t39 = t11 * t7;
  t42 = t6 * t6;
  t43 = 0.1e1 / t42;
  t46 = 0.2e1 * t12 * t43 * t13;
  t47 = t13 * t13;
  t48 = 0.1e1 / t47;
  t49 = t7 * t48;
  t51 = -rho[0] * t43 + t7;
  t56 = my_piecewise3(t10, 0, 0.2e1 * t39 * t13 - t46 + 0.2e1 / 0.3e1 * t12 * t49 * t51);
  t60 = t18 * t18;
  t61 = 0.1e1 / t60;
  t64 = t5 * t17 * t61 / 0.8e1;
  t66 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t56 * t18 - t64);
  t67 = params->alpha * t66;
  t70 = 0.2e1 * t28 * t43 * t29;
  t71 = rho[1] * rho[1];
  t72 = t11 * t71;
  t73 = t42 * t6;
  t74 = 0.1e1 / t73;
  t75 = t29 * t29;
  t76 = 0.1e1 / t75;
  t77 = t74 * t76;
  t81 = my_piecewise3(t27, 0, -t70 - 0.2e1 / 0.3e1 * t72 * t77);
  t87 = t5 * t33 * t61 / 0.8e1;
  t89 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t81 * t18 - t87);
  t90 = params->alpha * t89;
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t23 + t38 + t6 * (t67 + t90);

  t93 = rho[0] * rho[0];
  t94 = t11 * t93;
  t95 = t74 * t48;
  t99 = my_piecewise3(t10, 0, -t46 - 0.2e1 / 0.3e1 * t94 * t95);
  t104 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t99 * t18 - t64);
  t105 = params->alpha * t104;
  t108 = t7 * t76;
  t110 = -rho[1] * t43 + t7;
  t115 = my_piecewise3(t27, 0, 0.2e1 * t39 * t29 - t70 + 0.2e1 / 0.3e1 * t28 * t108 * t110);
  t120 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t115 * t18 - t87);
  t121 = params->alpha * t120;
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t23 + t38 + t6 * (t105 + t121);

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t126 = t11 * t43;
  t127 = t126 * t13;
  t129 = t48 * t51;
  t134 = 0.4e1 * t12 * t74 * t13;
  t135 = t43 * t48;
  t137 = t12 * t135 * t51;
  t140 = 0.1e1 / t47 / t8;
  t141 = t7 * t140;
  t142 = t51 * t51;
  t148 = 0.2e1 * rho[0] * t74 - 0.2e1 * t43;
  t153 = my_piecewise3(t10, 0, -0.4e1 * t127 + 0.4e1 / 0.3e1 * t39 * t129 + t134 - 0.4e1 / 0.3e1 * t137 - 0.4e1 / 0.9e1 * t12 * t141 * t142 + 0.2e1 / 0.3e1 * t12 * t49 * t148);
  t158 = t5 * t56 * t61;
  t161 = 0.1e1 / t60 / t6;
  t164 = t5 * t17 * t161 / 0.12e2;
  t166 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t153 * t18 - t158 / 0.4e1 + t164);
  t167 = params->alpha * t166;
  t170 = 0.4e1 * t28 * t74 * t29;
  t171 = t42 * t42;
  t172 = 0.1e1 / t171;
  t173 = t172 * t76;
  t174 = t72 * t173;
  t176 = t71 * rho[1];
  t177 = t11 * t176;
  t179 = 0.1e1 / t171 / t6;
  t181 = 0.1e1 / t75 / t25;
  t182 = t179 * t181;
  t186 = my_piecewise3(t27, 0, t170 + 0.8e1 / 0.3e1 * t174 - 0.4e1 / 0.9e1 * t177 * t182);
  t191 = t5 * t81 * t61;
  t195 = t5 * t33 * t161 / 0.12e2;
  t197 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t186 * t18 - t191 / 0.4e1 + t195);
  t198 = params->alpha * t197;
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t67 + 0.2e1 * t90 + t6 * (t167 + t198);

  t205 = t172 * t48;
  t206 = t94 * t205;
  t208 = t74 * t140;
  t209 = t208 * t51;
  t213 = my_piecewise3(t10, 0, -0.2e1 * t127 + t134 - 0.2e1 / 0.3e1 * t137 - 0.4e1 / 0.3e1 * t12 * t95 + 0.2e1 * t206 + 0.4e1 / 0.9e1 * t94 * t209);
  t218 = t5 * t99 * t61;
  t222 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t213 * t18 - t218 / 0.8e1 - t158 / 0.8e1 + t164);
  t223 = params->alpha * t222;
  t224 = t126 * t29;
  t226 = t11 * t74;
  t227 = t76 * rho[1];
  t231 = t43 * t76;
  t233 = t28 * t231 * t110;
  t235 = t74 * t181;
  t239 = rho[1] * t74;
  t241 = -t43 + 0.2e1 * t239;
  t246 = my_piecewise3(t27, 0, -0.2e1 * t224 - 0.2e1 / 0.3e1 * t226 * t227 + t170 + 0.2e1 / 0.3e1 * t174 - 0.2e1 / 0.3e1 * t233 + 0.4e1 / 0.9e1 * t72 * t235 * t110 + 0.2e1 / 0.3e1 * t28 * t108 * t241);
  t251 = t5 * t115 * t61;
  t255 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t246 * t18 - t251 / 0.8e1 - t191 / 0.8e1 + t195);
  t256 = params->alpha * t255;
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t67 + t90 + t105 + t121 + t6 * (t223 + t256);

  t262 = t93 * rho[0];
  t263 = t11 * t262;
  t264 = t179 * t140;
  t268 = my_piecewise3(t10, 0, t134 + 0.8e1 / 0.3e1 * t206 - 0.4e1 / 0.9e1 * t263 * t264);
  t274 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t268 * t18 - t218 / 0.4e1 + t164);
  t275 = params->alpha * t274;
  t277 = t76 * t110;
  t281 = t7 * t181;
  t282 = t110 * t110;
  t287 = -0.2e1 * t43 + 0.2e1 * t239;
  t292 = my_piecewise3(t27, 0, -0.4e1 * t224 + 0.4e1 / 0.3e1 * t39 * t277 + t170 - 0.4e1 / 0.3e1 * t233 - 0.4e1 / 0.9e1 * t28 * t281 * t282 + 0.2e1 / 0.3e1 * t28 * t108 * t287);
  t298 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t292 * t18 - t251 / 0.4e1 + t195);
  t299 = params->alpha * t298;
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t105 + 0.2e1 * t121 + t6 * (t275 + t299);

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t304 = t226 * t13;
  t306 = t126 * t129;
  t308 = t140 * t142;
  t311 = t48 * t148;
  t316 = 0.12e2 * t12 * t172 * t13;
  t318 = t12 * t95 * t51;
  t322 = t12 * t43 * t140 * t142;
  t325 = t12 * t135 * t148;
  t329 = 0.1e1 / t47 / t93 / t43;
  t331 = t142 * t51;
  t335 = t12 * t7;
  t336 = t140 * t51;
  t337 = t336 * t148;
  t342 = -0.6e1 * rho[0] * t172 + 0.6e1 * t74;
  t346 = 0.12e2 * t304 - 0.4e1 * t306 - 0.4e1 / 0.3e1 * t39 * t308 + 0.2e1 * t39 * t311 - t316 + 0.4e1 * t318 + 0.4e1 / 0.3e1 * t322 - 0.2e1 * t325 + 0.20e2 / 0.27e2 * t12 * t7 * t329 * t331 - 0.4e1 / 0.3e1 * t335 * t337 + 0.2e1 / 0.3e1 * t12 * t49 * t342;
  t347 = my_piecewise3(t10, 0, t346);
  t352 = t5 * t153 * t61;
  t355 = t5 * t56 * t161;
  t358 = 0.1e1 / t60 / t42;
  t361 = 0.5e1 / 0.36e2 * t5 * t17 * t358;
  t363 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t347 * t18 - 0.3e1 / 0.8e1 * t352 + t355 / 0.4e1 - t361);
  t364 = params->alpha * t363;
  t367 = 0.12e2 * t28 * t172 * t29;
  t369 = t72 * t179 * t76;
  t372 = 0.1e1 / t171 / t42;
  t374 = t177 * t372 * t181;
  t376 = t71 * t71;
  t377 = t11 * t376;
  t379 = 0.1e1 / t171 / t73;
  t382 = 0.1e1 / t75 / t71 / t43;
  t387 = my_piecewise3(t27, 0, -t367 - 0.12e2 * t369 + 0.4e1 * t374 - 0.20e2 / 0.27e2 * t377 * t379 * t382);
  t392 = t5 * t186 * t61;
  t395 = t5 * t81 * t161;
  t399 = 0.5e1 / 0.36e2 * t5 * t33 * t358;
  t401 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t387 * t18 - 0.3e1 / 0.8e1 * t392 + t395 / 0.4e1 - t399);
  t402 = params->alpha * t401;
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t167 + 0.3e1 * t198 + t6 * (t364 + t402);

  t405 = 0.2e1 * t223;
  t406 = 0.2e1 * t256;
  t414 = t12 * t205;
  t418 = t179 * t48;
  t419 = t94 * t418;
  t421 = t172 * t140;
  t422 = t421 * t51;
  t423 = t94 * t422;
  t426 = t74 * t329 * t142;
  t429 = t208 * t148;
  t432 = 0.8e1 * t304 - 0.4e1 / 0.3e1 * t306 - t316 + 0.8e1 / 0.3e1 * t318 + 0.4e1 / 0.9e1 * t322 - 0.2e1 / 0.3e1 * t325 - 0.4e1 / 0.3e1 * t226 * t48 + 0.8e1 * t414 + 0.16e2 / 0.9e1 * t12 * t209 - 0.8e1 * t419 - 0.8e1 / 0.3e1 * t423 - 0.20e2 / 0.27e2 * t94 * t426 + 0.4e1 / 0.9e1 * t94 * t429;
  t433 = my_piecewise3(t10, 0, t432);
  t439 = t5 * t213 * t61 / 0.4e1;
  t441 = t5 * t99 * t161;
  t446 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t433 * t18 - t439 + t441 / 0.12e2 - t352 / 0.8e1 + t355 / 0.6e1 - t361);
  t447 = params->alpha * t446;
  t448 = t226 * t29;
  t450 = t11 * t172;
  t451 = t450 * t227;
  t453 = t11 * t179;
  t454 = t181 * t71;
  t460 = t28 * t77 * t110;
  t462 = t172 * t181;
  t464 = t72 * t462 * t110;
  t468 = 0.4e1 / 0.3e1 * t28 * t231 * t241;
  t469 = t179 * t382;
  t477 = rho[1] * t172;
  t478 = 0.6e1 * t477;
  t479 = 0.2e1 * t74 - t478;
  t483 = 0.4e1 * t448 + 0.8e1 / 0.3e1 * t451 - 0.4e1 / 0.9e1 * t453 * t454 - t367 - 0.4e1 * t369 + 0.4e1 / 0.9e1 * t374 + 0.4e1 / 0.3e1 * t460 - 0.16e2 / 0.9e1 * t464 - t468 + 0.20e2 / 0.27e2 * t177 * t469 * t110 + 0.8e1 / 0.9e1 * t72 * t235 * t241 + 0.2e1 / 0.3e1 * t28 * t108 * t479;
  t484 = my_piecewise3(t27, 0, t483);
  t490 = t5 * t246 * t61 / 0.4e1;
  t492 = t5 * t115 * t161;
  t497 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t484 * t18 - t490 + t492 / 0.12e2 - t392 / 0.8e1 + t395 / 0.6e1 - t399);
  t498 = params->alpha * t497;
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t167 + t198 + t405 + t406 + t6 * (t447 + t498);

  t508 = t372 * t140;
  t509 = t263 * t508;
  t511 = t179 * t329;
  t512 = t511 * t51;
  t516 = my_piecewise3(t10, 0, 0.4e1 * t304 - t316 + 0.4e1 / 0.3e1 * t318 + 0.16e2 / 0.3e1 * t414 - 0.32e2 / 0.3e1 * t419 - 0.16e2 / 0.9e1 * t423 - 0.4e1 / 0.3e1 * t94 * t264 + 0.20e2 / 0.9e1 * t509 + 0.20e2 / 0.27e2 * t263 * t512);
  t521 = t5 * t268 * t61;
  t526 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t516 * t18 - t521 / 0.8e1 - t439 + t441 / 0.6e1 + t355 / 0.12e2 - t361);
  t527 = params->alpha * t526;
  t530 = t126 * t277;
  t532 = t181 * t110;
  t533 = t532 * rho[1];
  t536 = t76 * t241;
  t544 = t28 * t43 * t181 * t282;
  t550 = t28 * t7;
  t551 = t532 * t241;
  t555 = t28 * t231 * t287;
  t561 = 0.4e1 * t74 - t478;
  t565 = 0.8e1 * t448 + 0.4e1 / 0.3e1 * t451 - 0.4e1 / 0.3e1 * t530 + 0.8e1 / 0.9e1 * t226 * t533 + 0.4e1 / 0.3e1 * t39 * t536 - t367 - 0.4e1 / 0.3e1 * t369 + 0.8e1 / 0.3e1 * t460 - 0.8e1 / 0.9e1 * t464 - t468 + 0.4e1 / 0.9e1 * t544 - 0.20e2 / 0.27e2 * t72 * t74 * t382 * t282 - 0.8e1 / 0.9e1 * t550 * t551 - 0.2e1 / 0.3e1 * t555 + 0.4e1 / 0.9e1 * t72 * t235 * t287 + 0.2e1 / 0.3e1 * t28 * t108 * t561;
  t566 = my_piecewise3(t27, 0, t565);
  t571 = t5 * t292 * t61;
  t576 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t566 * t18 - t571 / 0.8e1 - t490 + t492 / 0.6e1 + t395 / 0.12e2 - t399);
  t577 = params->alpha * t576;
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t405 + t406 + t275 + t299 + t6 * (t527 + t577);

  t584 = t93 * t93;
  t585 = t11 * t584;
  t586 = t379 * t329;
  t590 = my_piecewise3(t10, 0, -t316 - 0.12e2 * t419 + 0.4e1 * t509 - 0.20e2 / 0.27e2 * t585 * t586);
  t597 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t590 * t18 - 0.3e1 / 0.8e1 * t521 + t441 / 0.4e1 - t361);
  t598 = params->alpha * t597;
  t601 = t181 * t282;
  t604 = t76 * t287;
  t611 = t282 * t110;
  t615 = t532 * t287;
  t619 = 0.6e1 * t74 - 0.6e1 * t477;
  t623 = 0.12e2 * t448 - 0.4e1 * t530 - 0.4e1 / 0.3e1 * t39 * t601 + 0.2e1 * t39 * t604 - t367 + 0.4e1 * t460 + 0.4e1 / 0.3e1 * t544 - 0.2e1 * t555 + 0.20e2 / 0.27e2 * t28 * t7 * t382 * t611 - 0.4e1 / 0.3e1 * t550 * t615 + 0.2e1 / 0.3e1 * t28 * t108 * t619;
  t624 = my_piecewise3(t27, 0, t623);
  t631 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t624 * t18 - 0.3e1 / 0.8e1 * t571 + t492 / 0.4e1 - t399);
  t632 = params->alpha * t631;
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t275 + 0.3e1 * t299 + t6 * (t598 + t632);

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t638 = t12 * t208 * t142;
  t642 = t12 * t43 * t329 * t331;
  t645 = t12 * t43 * t337;
  t649 = 0.1e1 / t47 / t262 / t74;
  t651 = t142 * t142;
  t659 = t148 * t148;
  t666 = t126 * t308;
  t675 = 0.48e2 * t12 * t179 * t13;
  t677 = t12 * t205 * t51;
  t680 = t12 * t95 * t148;
  t683 = t12 * t135 * t342;
  t691 = t450 * t13;
  t693 = t226 * t129;
  t695 = t126 * t311;
  t700 = -0.16e2 / 0.3e1 * t638 - 0.80e2 / 0.27e2 * t642 + 0.16e2 / 0.3e1 * t645 - 0.160e3 / 0.81e2 * t12 * t7 * t649 * t651 + 0.40e2 / 0.9e1 * t335 * t329 * t142 * t148 - 0.4e1 / 0.3e1 * t12 * t141 * t659 - 0.16e2 / 0.9e1 * t335 * t336 * t342 + 0.16e2 / 0.3e1 * t666 + 0.80e2 / 0.27e2 * t39 * t329 * t331 - 0.16e2 / 0.3e1 * t39 * t337 + t675 - 0.16e2 * t677 + 0.8e1 * t680 - 0.8e1 / 0.3e1 * t683 + 0.2e1 / 0.3e1 * t12 * t49 * (0.24e2 * rho[0] * t179 - 0.24e2 * t172) - 0.48e2 * t691 + 0.16e2 * t693 - 0.8e1 * t695 + 0.8e1 / 0.3e1 * t39 * t48 * t342;
  t701 = my_piecewise3(t10, 0, t700);
  t706 = t5 * t347 * t61;
  t709 = t5 * t153 * t161;
  t712 = t5 * t56 * t358;
  t715 = 0.1e1 / t60 / t73;
  t718 = 0.10e2 / 0.27e2 * t5 * t17 * t715;
  t720 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t701 * t18 - t706 / 0.2e1 + t709 / 0.2e1 - 0.5e1 / 0.9e1 * t712 + t718);
  t724 = 0.48e2 * t28 * t179 * t29;
  t726 = t72 * t372 * t76;
  t729 = t177 * t379 * t181;
  t731 = t171 * t171;
  t732 = 0.1e1 / t731;
  t734 = t377 * t732 * t382;
  t739 = 0.1e1 / t731 / t6;
  t742 = 0.1e1 / t75 / t176 / t74;
  t747 = my_piecewise3(t27, 0, t724 + 0.64e2 * t726 - 0.32e2 * t729 + 0.320e3 / 0.27e2 * t734 - 0.160e3 / 0.81e2 * t11 * t376 * rho[1] * t739 * t742);
  t752 = t5 * t387 * t61;
  t755 = t5 * t186 * t161;
  t758 = t5 * t81 * t358;
  t762 = 0.10e2 / 0.27e2 * t5 * t33 * t715;
  t764 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t747 * t18 - t752 / 0.2e1 + t755 / 0.2e1 - 0.5e1 / 0.9e1 * t758 + t762);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t364 + 0.4e1 * t402 + t6 * (params->alpha * t720 + params->alpha * t764);

  t774 = t94 * t172 * t329 * t142;
  t792 = -0.40e2 / 0.9e1 * t12 * t426 + 0.20e2 / 0.3e1 * t774 + 0.160e3 / 0.81e2 * t94 * t74 * t649 * t331 - 0.20e2 / 0.9e1 * t94 * t74 * t329 * t51 * t148 - 0.8e1 / 0.3e1 * t638 - 0.20e2 / 0.27e2 * t642 + 0.4e1 / 0.3e1 * t645 + 0.4e1 / 0.3e1 * t666 + t675 - 0.12e2 * t677 + 0.4e1 * t680 - 0.2e1 / 0.3e1 * t683;
  t796 = t450 * t48;
  t800 = t12 * t418;
  t802 = t12 * t422;
  t807 = t94 * t372 * t48;
  t810 = t94 * t264 * t51;
  t813 = t94 * t421 * t148;
  t818 = -0.36e2 * t691 + 0.8e1 * t693 - 0.2e1 * t695 + 0.12e2 * t796 + 0.8e1 / 0.3e1 * t226 * t336 - 0.48e2 * t800 - 0.16e2 * t802 + 0.8e1 / 0.3e1 * t12 * t429 + 0.40e2 * t807 + 0.16e2 * t810 - 0.4e1 * t813 + 0.4e1 / 0.9e1 * t94 * t208 * t342;
  t820 = my_piecewise3(t10, 0, t792 + t818);
  t825 = t5 * t433 * t61;
  t828 = t5 * t213 * t161;
  t829 = t828 / 0.4e1;
  t831 = t5 * t99 * t358;
  t837 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t820 * t18 - 0.3e1 / 0.8e1 * t825 + t829 - 0.5e1 / 0.36e2 * t831 - t706 / 0.8e1 + t709 / 0.4e1 - 0.5e1 / 0.12e2 * t712 + t718);
  t840 = t28 * t173 * t110;
  t845 = t450 * t29;
  t847 = t453 * t227;
  t850 = t11 * t372 * t454;
  t857 = t28 * t77 * t241;
  t858 = 0.4e1 * t857;
  t860 = t72 * t182 * t110;
  t863 = t72 * t462 * t241;
  t867 = t177 * t372 * t382 * t110;
  t870 = t28 * t231 * t479;
  t883 = rho[1] * t179;
  t884 = 0.24e2 * t883;
  t889 = -0.4e1 * t840 + t724 + 0.24e2 * t726 - 0.16e2 / 0.3e1 * t729 + 0.20e2 / 0.27e2 * t734 - 0.12e2 * t845 - 0.12e2 * t847 + 0.4e1 * t850 - 0.20e2 / 0.27e2 * t11 * t379 * t382 * t176 + t858 + 0.8e1 * t860 - 0.16e2 / 0.3e1 * t863 - 0.20e2 / 0.3e1 * t867 - 0.2e1 * t870 + 0.20e2 / 0.9e1 * t177 * t469 * t241 + 0.160e3 / 0.81e2 * t377 * t379 * t742 * t110 + 0.4e1 / 0.3e1 * t72 * t235 * t479 + 0.2e1 / 0.3e1 * t28 * t108 * (-0.6e1 * t172 + t884);
  t890 = my_piecewise3(t27, 0, t889);
  t895 = t5 * t484 * t61;
  t898 = t5 * t246 * t161;
  t899 = t898 / 0.4e1;
  t901 = t5 * t115 * t358;
  t907 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t890 * t18 - 0.3e1 / 0.8e1 * t895 + t899 - 0.5e1 / 0.36e2 * t901 - t752 / 0.8e1 + t755 / 0.4e1 - 0.5e1 / 0.12e2 * t758 + t762);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t364 + t402 + 0.3e1 * t447 + 0.3e1 * t498 + t6 * (params->alpha * t837 + params->alpha * t907);

  t933 = t94 * t508;
  t938 = t263 * t379 * t140;
  t942 = t263 * t372 * t329 * t51;
  t947 = -0.160e3 / 0.81e2 * t263 * t179 * t649 * t142 + 0.80e2 / 0.27e2 * t774 - 0.8e1 / 0.9e1 * t638 + t675 - 0.8e1 * t677 + 0.4e1 / 0.3e1 * t680 - 0.24e2 * t691 + 0.8e1 / 0.3e1 * t693 + 0.16e2 / 0.3e1 * t796 - 0.128e3 / 0.3e1 * t800 - 0.64e2 / 0.9e1 * t802 + 0.160e3 / 0.3e1 * t807 + 0.128e3 / 0.9e1 * t810 - 0.16e2 / 0.9e1 * t813 - 0.8e1 / 0.3e1 * t12 * t264 + 0.40e2 / 0.3e1 * t933 + 0.40e2 / 0.9e1 * t94 * t512 - 0.40e2 / 0.3e1 * t938 - 0.200e3 / 0.27e2 * t942 + 0.20e2 / 0.27e2 * t263 * t511 * t148;
  t948 = my_piecewise3(t10, 0, t947);
  t953 = t5 * t516 * t61;
  t956 = t5 * t268 * t161;
  t964 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t948 * t18 - t953 / 0.4e1 + t956 / 0.12e2 - t825 / 0.4e1 + t828 / 0.3e1 - 0.5e1 / 0.18e2 * t831 + t709 / 0.12e2 - 0.5e1 / 0.18e2 * t712 + t718);
  t966 = t450 * t533;
  t968 = t181 * t241;
  t972 = t382 * t110;
  t978 = t72 * t172 * t382 * t282;
  t985 = t28 * t231 * t561;
  t988 = t72 * t462 * t287;
  t1001 = t28 * t43;
  t1002 = t1001 * t551;
  t1004 = t72 * t74;
  t1011 = t126 * t536;
  t1016 = -0.32e2 / 0.9e1 * t966 + 0.16e2 / 0.9e1 * t226 * t968 * rho[1] + 0.40e2 / 0.27e2 * t453 * t972 * t71 + 0.80e2 / 0.27e2 * t978 - 0.160e3 / 0.81e2 * t177 * t179 * t742 * t282 - 0.4e1 / 0.3e1 * t985 - 0.16e2 / 0.9e1 * t988 + 0.8e1 / 0.9e1 * t72 * t235 * t561 + 0.20e2 / 0.27e2 * t177 * t469 * t287 + 0.2e1 / 0.3e1 * t28 * t108 * (-0.12e2 * t172 + t884) + 0.16e2 / 0.9e1 * t1002 - 0.80e2 / 0.27e2 * t1004 * t972 * t241 - 0.8e1 / 0.9e1 * t550 * t532 * t479 - 0.8e1 / 0.3e1 * t1011 + 0.4e1 / 0.3e1 * t39 * t76 * t479;
  t1017 = t226 * t277;
  t1024 = t28 * t235 * t282;
  t1026 = t241 * t241;
  t1031 = t28 * t77 * t287;
  t1040 = 0.8e1 / 0.3e1 * t1017 - 0.8e1 * t847 + 0.8e1 / 0.9e1 * t850 + t724 + 0.32e2 / 0.3e1 * t726 - 0.8e1 / 0.9e1 * t729 - 0.8e1 / 0.9e1 * t1024 - 0.8e1 / 0.9e1 * t28 * t281 * t1026 + 0.4e1 / 0.3e1 * t1031 - 0.8e1 * t840 + 0.16e2 / 0.3e1 * t857 + 0.16e2 / 0.3e1 * t860 - 0.16e2 / 0.9e1 * t863 - 0.40e2 / 0.27e2 * t867 - 0.4e1 / 0.3e1 * t870 - 0.24e2 * t845;
  t1042 = my_piecewise3(t27, 0, t1016 + t1040);
  t1047 = t5 * t566 * t61;
  t1050 = t5 * t292 * t161;
  t1058 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t1042 * t18 - t1047 / 0.4e1 + t1050 / 0.12e2 - t895 / 0.4e1 + t898 / 0.3e1 - 0.5e1 / 0.18e2 * t901 + t755 / 0.12e2 - 0.5e1 / 0.18e2 * t758 + t762);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t447 + 0.2e1 * t498 + 0.2e1 * t527 + 0.2e1 * t577 + t6 * (params->alpha * t1058 + params->alpha * t964);

  t1075 = t585 * t732 * t329;
  t1081 = -0.12e2 * t691 + t675 - 0.4e1 * t677 - 0.24e2 * t800 + 0.60e2 * t807 + 0.8e1 * t810 + 0.12e2 * t933 - 0.24e2 * t938 - 0.20e2 / 0.3e1 * t942 - 0.80e2 / 0.27e2 * t263 * t586 + 0.140e3 / 0.27e2 * t1075 + 0.160e3 / 0.81e2 * t585 * t379 * t649 * t51;
  t1082 = my_piecewise3(t10, 0, t1081);
  t1087 = t5 * t590 * t61;
  t1094 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1082 * t18 - t1087 / 0.8e1 - 0.3e1 / 0.8e1 * t953 + t956 / 0.4e1 + t829 - 0.5e1 / 0.12e2 * t831 - 0.5e1 / 0.36e2 * t712 + t718);
  t1098 = t382 * t282;
  t1120 = t28 * t43 * t382 * t611;
  t1123 = t28 * t231 * t619;
  t1129 = t1001 * t615;
  t1140 = -0.8e1 / 0.3e1 * t39 * t551 - 0.20e2 / 0.9e1 * t226 * t1098 * rho[1] + 0.4e1 / 0.3e1 * t226 * t181 * t287 * rho[1] + 0.160e3 / 0.81e2 * t72 * t74 * t742 * t611 + 0.2e1 / 0.3e1 * t28 * t108 * (-0.18e2 * t172 + t884) + 0.4e1 / 0.9e1 * t72 * t235 * t619 - 0.20e2 / 0.27e2 * t1120 - 0.2e1 / 0.3e1 * t1123 - 0.8e1 / 0.3e1 * t966 + 0.20e2 / 0.9e1 * t978 - 0.2e1 * t985 - 0.4e1 / 0.3e1 * t988 + 0.4e1 / 0.3e1 * t1129 + 0.20e2 / 0.9e1 * t550 * t1098 * t241 - 0.4e1 / 0.3e1 * t550 * t968 * t287 - 0.4e1 / 0.3e1 * t550 * t532 * t561;
  t1147 = t126 * t601;
  t1149 = t126 * t604;
  t1161 = -0.20e2 / 0.9e1 * t1004 * t972 * t287 + 0.8e1 / 0.3e1 * t1002 - 0.4e1 * t1011 + 0.8e1 * t1017 + 0.4e1 / 0.3e1 * t1147 - 0.2e1 * t1149 + 0.2e1 * t39 * t76 * t561 - 0.4e1 * t847 + t724 + 0.4e1 * t726 - 0.8e1 / 0.3e1 * t1024 + 0.4e1 * t1031 - 0.12e2 * t840 + t858 + 0.8e1 / 0.3e1 * t860 - 0.36e2 * t845;
  t1163 = my_piecewise3(t27, 0, t1140 + t1161);
  t1168 = t5 * t624 * t61;
  t1175 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t1163 * t18 - t1168 / 0.8e1 - 0.3e1 / 0.8e1 * t1047 + t1050 / 0.4e1 + t899 - 0.5e1 / 0.12e2 * t901 - 0.5e1 / 0.36e2 * t758 + t762);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t527 + 0.3e1 * t577 + t598 + t632 + t6 * (params->alpha * t1094 + params->alpha * t1175);

  t1190 = my_piecewise3(t10, 0, t675 + 0.64e2 * t807 - 0.32e2 * t938 + 0.320e3 / 0.27e2 * t1075 - 0.160e3 / 0.81e2 * t11 * t584 * rho[0] * t739 * t649);
  t1198 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1190 * t18 - t1087 / 0.2e1 + t956 / 0.2e1 - 0.5e1 / 0.9e1 * t831 + t718);
  t1217 = t282 * t282;
  t1224 = t287 * t287;
  t1238 = 0.80e2 / 0.27e2 * t39 * t382 * t611 - 0.16e2 / 0.3e1 * t39 * t615 + 0.2e1 / 0.3e1 * t28 * t108 * (-0.24e2 * t172 + 0.24e2 * t883) + 0.16e2 / 0.3e1 * t1147 - 0.8e1 * t1149 + 0.16e2 / 0.3e1 * t1129 - 0.16e2 / 0.9e1 * t550 * t532 * t619 - 0.160e3 / 0.81e2 * t28 * t7 * t742 * t1217 + 0.40e2 / 0.9e1 * t550 * t1098 * t287 - 0.4e1 / 0.3e1 * t28 * t281 * t1224 - 0.80e2 / 0.27e2 * t1120 - 0.8e1 / 0.3e1 * t1123 - 0.16e2 / 0.3e1 * t1024 + 0.8e1 * t1031 - 0.16e2 * t840 + t724 - 0.48e2 * t845 + 0.8e1 / 0.3e1 * t39 * t76 * t619 + 0.16e2 * t1017;
  t1239 = my_piecewise3(t27, 0, t1238);
  t1247 = my_piecewise3(t24, 0, -0.3e1 / 0.8e1 * t5 * t1239 * t18 - t1168 / 0.2e1 + t1050 / 0.2e1 - 0.5e1 / 0.9e1 * t901 + t762);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t598 + 0.4e1 * t632 + t6 * (params->alpha * t1198 + params->alpha * t1247);

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

