/* 
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_k_gds08_worker.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho , double *zk LDA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t5, t6, t8, t10, t15;

#ifndef XC_DONT_COMPILE_VXC
  double t16, t18, t24;

#ifndef XC_DONT_COMPILE_FXC
  double t28, t29, t38;

#ifndef XC_DONT_COMPILE_KXC
  double t43, t53;

#ifndef XC_DONT_COMPILE_LXC
  double t57, t58, t68;
#endif

#endif

#endif

#endif

#endif


  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t5 = my_piecewise3(0.1e1 <= p->zeta_threshold, p->zeta_threshold - 0.1e1, 0);
  t6 = 0.1e1 + t5;
  t8 = log(t6 * rho[0]);
  t10 = t8 * t8;
  t15 = my_piecewise3(t2, 0, t6 * (params->C * t10 + params->B * t8 + params->A) / 0.2e1);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t15;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t16 = 0.1e1 / rho[0];
  t18 = params->C * t8;
  t24 = my_piecewise3(t2, 0, t6 * (0.2e1 * t18 * t16 + params->B * t16) / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t24 + 0.2e1 * t15;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t28 = rho[0] * rho[0];
  t29 = 0.1e1 / t28;
  t38 = my_piecewise3(t2, 0, t6 * (-0.2e1 * t18 * t29 - params->B * t29 + 0.2e1 * params->C * t29) / 0.2e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t38 + 0.4e1 * t24;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t43 = 0.1e1 / t28 / rho[0];
  t53 = my_piecewise3(t2, 0, t6 * (0.4e1 * t18 * t43 + 0.2e1 * params->B * t43 - 0.6e1 * params->C * t43) / 0.2e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t53 + 0.6e1 * t38;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t57 = t28 * t28;
  t58 = 0.1e1 / t57;
  t68 = my_piecewise3(t2, 0, t6 * (-0.12e2 * t18 * t58 - 0.6e1 * params->B * t58 + 0.22e2 * params->C * t58) / 0.2e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t68 + 0.8e1 * t53;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho , double *zk LDA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t1, t2, t3, t4, t5, t7, t8, t9;
  double t10, t13, t14, t15, t17, t19, t21, t24;
  double t25, t27, t28, t29, t32, t33, t35, t36;
  double t38, t40, t42, t45;

#ifndef XC_DONT_COMPILE_VXC
  double t46, t47, t48, t49, t50, t52, t54, t55;
  double t56, t57, t59, t60, t64, t68, t70, t72;
  double t74, t76, t77, t78, t79, t81, t82, t86;
  double t90, t93, t94, t96, t98, t99, t101, t105;
  double t109, t111, t114, t116, t117, t119, t123, t127;

#ifndef XC_DONT_COMPILE_FXC
  double t133, t134, t136, t137, t141, t144, t145, t147;
  double t148, t149, t150, t152, t154, t155, t156, t159;
  double t163, t169, t173, t175, t179, t182, t185, t186;
  double t188, t189, t190, t191, t193, t195, t196, t197;
  double t200, t204, t210, t214, t217, t218, t222, t224;
  double t225, t228, t229, t230, t233, t237, t242, t243;
  double t247, t248, t253, t255, t256, t259, t260, t261;
  double t264, t268, t273, t274, t278, t284, t285, t289;
  double t292, t293, t295, t297, t298, t301, t307, t311;
  double t313, t319, t322, t323, t325, t327, t328, t331;
  double t337, t341;

#ifndef XC_DONT_COMPILE_KXC
  double t346, t347, t348, t350, t351, t362, t364, t371;
  double t372, t373, t376, t379, t382, t383, t387, t389;
  double t390, t391, t394, t401, t412, t416, t418, t429;
  double t431, t438, t439, t440, t443, t446, t449, t452;
  double t453, t457, t459, t460, t461, t464, t471, t482;
  double t486, t489, t490, t491, t492, t493, t494, t505;
  double t509, t510, t513, t516, t518, t519, t520, t524;
  double t528, t532, t534, t535, t536, t539, t540, t542;
  double t546, t552, t553, t557, t559, t570, t574, t575;
  double t578, t581, t583, t585, t586, t587, t591, t595;
  double t599, t601, t602, t603, t606, t607, t609, t613;
  double t619, t620, t624, t627, t628, t641, t643, t648;
  double t650, t651, t655, t658, t659, t661, t663, t664;
  double t665, t667, t669, t670, t674, t677, t679, t680;
  double t681, t684, t691, t692, t696, t698, t709, t710;
  double t713, t715, t716, t718, t719, t724, t726, t727;
  double t732, t736, t739, t740, t742, t745, t748, t750;
  double t751, t752, t755, t762, t763, t767, t773, t774;
  double t785, t792, t795, t796, t800, t803, t804, t815;
  double t819, t821, t832, t841, t844, t845, t848, t849;
  double t860, t864, t868;

#ifndef XC_DONT_COMPILE_LXC
  double t874, t875, t877, t878, t889, t892, t897, t900;
  double t904, t908, t915, t921, t922, t923, t924, t927;
  double t928, t934, t936, t939, t948, t953, t955, t961;
  double t976, t996, t1001, t1003, t1014, t1017, t1020, t1025;
  double t1028, t1032, t1036, t1043, t1049, t1050, t1051, t1052;
  double t1055, t1056, t1062, t1064, t1067, t1076, t1081, t1083;
  double t1089, t1104, t1124, t1129, t1134, t1135, t1136, t1137;
  double t1152, t1154, t1157, t1160, t1163, t1168, t1170, t1172;
  double t1174, t1175, t1178, t1182, t1185, t1188, t1192, t1198;
  double t1199, t1206, t1215, t1217, t1221, t1224, t1225, t1228;
  double t1233, t1235, t1244, t1248, t1250, t1252, t1257, t1259;
  double t1274, t1276, t1278, t1281, t1284, t1287, t1292, t1294;
  double t1296, t1298, t1299, t1302, t1306, t1309, t1312, t1316;
  double t1322, t1323, t1330, t1339, t1341, t1345, t1348, t1349;
  double t1352, t1357, t1359, t1368, t1372, t1374, t1376, t1381;
  double t1388, t1404, t1406, t1407, t1409, t1414, t1416, t1420;
  double t1428, t1431, t1436, t1441, t1442, t1443, t1447, t1450;
  double t1452, t1456, t1477, t1481, t1482, t1486, t1487, t1489;
  double t1499, t1501, t1512, t1518, t1520, t1522, t1523, t1527;
  double t1528, t1532, t1533, t1534, t1536, t1539, t1561, t1567;
  double t1568, t1581, t1587, t1589, t1590, t1592, t1593, t1597;
  double t1601, t1602, t1603, t1605, t1606, t1609, t1617, t1619;
  double t1624, t1628, t1637, t1640, t1642, t1646, t1667, t1668;
  double t1671, t1673, t1675, t1680, t1682, t1686, t1694, t1697;
  double t1702, t1708, t1709, t1713, t1715, t1721, t1741, t1747;
  double t1752, t1753, t1768, t1770, t1771, t1772, t1775, t1778;
  double t1780, t1781, t1788, t1798, t1801, t1809, t1812, t1820;
  double t1835, t1837, t1839, t1841, t1846, t1857, t1877, t1881;
  double t1896, t1902, t1904, t1924, t1938, t1941, t1946, t1949;
  double t1951, t1952, t1953, t1956, t1958, t1959, t1962, t1964;
  double t1975, t1980, t1994, t1996, t1998, t2003, t2011, t2032;
  double t2038, t2048, t2054, t2060, t2061, t2074, t2081, t2084;
  double t2095, t2106, t2111, t2139, t2144, t2146, t2157, t2160;
  double t2171, t2178, t2193, t2199, t2226, t2231;
#endif

#endif

#endif

#endif

#endif


  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise3(t7, t8, t5);
  t10 = 0.1e1 + t9;
  t13 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t14 = my_piecewise3(t13, t8, t5);
  t15 = 0.1e1 + t14;
  t17 = log(t15 * t3);
  t19 = t17 * t17;
  t21 = t17 * params->B + t19 * params->C + params->A;
  t24 = my_piecewise3(t1, 0, t10 * t21 / 0.2e1);
  t25 = rho[1] <= p->dens_threshold;
  t27 = 0.1e1 - t5 <= p->zeta_threshold;
  t28 = my_piecewise3(t27, t8, -t5);
  t29 = 0.1e1 + t28;
  t32 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t33 = -t2;
  t35 = my_piecewise3(t32, t8, t33 * t4);
  t36 = 0.1e1 + t35;
  t38 = log(t36 * t3);
  t40 = t38 * t38;
  t42 = t38 * params->B + t40 * params->C + params->A;
  t45 = my_piecewise3(t25, 0, t29 * t42 / 0.2e1);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t24 + t45;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t46 = t3 * t3;
  t47 = 0.1e1 / t46;
  t48 = t2 * t47;
  t49 = t4 - t48;
  t50 = my_piecewise3(t7, 0, t49);
  t52 = my_piecewise3(t13, 0, t49);
  t54 = t3 * t52 + t14 + 0.1e1;
  t55 = params->B * t54;
  t56 = 0.1e1 / t15;
  t57 = t56 * t4;
  t59 = params->C * t17;
  t60 = t54 * t56;
  t64 = 0.2e1 * t4 * t59 * t60 + t55 * t57;
  t68 = my_piecewise3(t1, 0, t10 * t64 / 0.2e1 + t50 * t21 / 0.2e1);
  t70 = my_piecewise3(t27, 0, -t49);
  t72 = t33 * t47;
  t74 = my_piecewise3(t32, 0, -t4 - t72);
  t76 = t3 * t74 + t35 + 0.1e1;
  t77 = params->B * t76;
  t78 = 0.1e1 / t36;
  t79 = t78 * t4;
  t81 = params->C * t38;
  t82 = t76 * t78;
  t86 = 0.2e1 * t4 * t81 * t82 + t77 * t79;
  t90 = my_piecewise3(t25, 0, t29 * t86 / 0.2e1 + t70 * t42 / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t24 + t45 + t3 * (t68 + t90);

  t93 = -t4 - t48;
  t94 = my_piecewise3(t7, 0, t93);
  t96 = my_piecewise3(t13, 0, t93);
  t98 = t3 * t96 + t14 + 0.1e1;
  t99 = params->B * t98;
  t101 = t98 * t56;
  t105 = 0.2e1 * t101 * t4 * t59 + t57 * t99;
  t109 = my_piecewise3(t1, 0, t10 * t105 / 0.2e1 + t94 * t21 / 0.2e1);
  t111 = my_piecewise3(t27, 0, -t93);
  t114 = my_piecewise3(t32, 0, t4 - t72);
  t116 = t114 * t3 + t35 + 0.1e1;
  t117 = params->B * t116;
  t119 = t116 * t78;
  t123 = 0.2e1 * t119 * t4 * t81 + t117 * t79;
  t127 = my_piecewise3(t25, 0, t111 * t42 / 0.2e1 + t29 * t123 / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t24 + t45 + t3 * (t109 + t127);

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t133 = 0.1e1 / t46 / t3;
  t134 = t2 * t133;
  t136 = -0.2e1 * t47 + 0.2e1 * t134;
  t137 = my_piecewise3(t7, 0, t136);
  t141 = my_piecewise3(t13, 0, t136);
  t144 = t141 * t3 + 0.2e1 * t52;
  t145 = params->B * t144;
  t147 = t15 * t15;
  t148 = 0.1e1 / t147;
  t149 = t148 * t4;
  t150 = t149 * t52;
  t152 = t56 * t47;
  t154 = t54 * t54;
  t155 = params->C * t154;
  t156 = t148 * t47;
  t159 = t144 * t56;
  t163 = t59 * t54;
  t169 = 0.2e1 * t159 * t4 * t59 - 0.2e1 * t47 * t59 * t60 + t145 * t57 - 0.2e1 * t150 * t163 - t150 * t55 - t152 * t55 + 0.2e1 * t155 * t156;
  t173 = my_piecewise3(t1, 0, t137 * t21 / 0.2e1 + t50 * t64 + t10 * t169 / 0.2e1);
  t175 = my_piecewise3(t27, 0, -t136);
  t179 = t33 * t133;
  t182 = my_piecewise3(t32, 0, 0.2e1 * t47 + 0.2e1 * t179);
  t185 = t182 * t3 + 0.2e1 * t74;
  t186 = params->B * t185;
  t188 = t36 * t36;
  t189 = 0.1e1 / t188;
  t190 = t189 * t4;
  t191 = t190 * t74;
  t193 = t78 * t47;
  t195 = t76 * t76;
  t196 = params->C * t195;
  t197 = t189 * t47;
  t200 = t185 * t78;
  t204 = t81 * t76;
  t210 = 0.2e1 * t200 * t4 * t81 - 0.2e1 * t47 * t81 * t82 + t186 * t79 - 0.2e1 * t191 * t204 - t191 * t77 - t193 * t77 + 0.2e1 * t196 * t197;
  t214 = my_piecewise3(t25, 0, t175 * t42 / 0.2e1 + t70 * t86 + t29 * t210 / 0.2e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t68 + 0.2e1 * t90 + t3 * (t173 + t214);

  t217 = 0.2e1 * t134;
  t218 = my_piecewise3(t7, 0, t217);
  t222 = my_piecewise3(t13, 0, t217);
  t224 = t222 * t3 + t52 + t96;
  t225 = params->B * t224;
  t228 = t99 * t152;
  t229 = params->C * t54;
  t230 = t156 * t98;
  t233 = t224 * t56;
  t237 = t59 * t98;
  t242 = 0.2e1 * t59 * t101 * t47;
  t243 = 0.2e1 * t233 * t4 * t59 - 0.2e1 * t150 * t237 - t150 * t99 + t225 * t57 + 0.2e1 * t229 * t230 - t228 - t242;
  t247 = my_piecewise3(t1, 0, t10 * t243 / 0.2e1 + t50 * t105 / 0.2e1 + t218 * t21 / 0.2e1 + t94 * t64 / 0.2e1);
  t248 = my_piecewise3(t27, 0, -t217);
  t253 = my_piecewise3(t32, 0, 0.2e1 * t179);
  t255 = t253 * t3 + t114 + t74;
  t256 = params->B * t255;
  t259 = t117 * t193;
  t260 = params->C * t76;
  t261 = t197 * t116;
  t264 = t255 * t78;
  t268 = t81 * t116;
  t273 = 0.2e1 * t81 * t119 * t47;
  t274 = 0.2e1 * t264 * t4 * t81 - t117 * t191 - 0.2e1 * t191 * t268 + t256 * t79 + 0.2e1 * t260 * t261 - t259 - t273;
  t278 = my_piecewise3(t25, 0, t111 * t86 / 0.2e1 + t70 * t123 / 0.2e1 + t248 * t42 / 0.2e1 + t29 * t274 / 0.2e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t68 + t90 + t109 + t127 + t3 * (t247 + t278);

  t284 = 0.2e1 * t47 + 0.2e1 * t134;
  t285 = my_piecewise3(t7, 0, t284);
  t289 = my_piecewise3(t13, 0, t284);
  t292 = t289 * t3 + 0.2e1 * t96;
  t293 = params->B * t292;
  t295 = t149 * t96;
  t297 = t98 * t98;
  t298 = params->C * t297;
  t301 = t292 * t56;
  t307 = 0.2e1 * t301 * t4 * t59 + 0.2e1 * t156 * t298 - 0.2e1 * t237 * t295 + t293 * t57 - t295 * t99 - t228 - t242;
  t311 = my_piecewise3(t1, 0, t285 * t21 / 0.2e1 + t94 * t105 + t10 * t307 / 0.2e1);
  t313 = my_piecewise3(t27, 0, -t284);
  t319 = my_piecewise3(t32, 0, -0.2e1 * t47 + 0.2e1 * t179);
  t322 = t3 * t319 + 0.2e1 * t114;
  t323 = params->B * t322;
  t325 = t190 * t114;
  t327 = t116 * t116;
  t328 = params->C * t327;
  t331 = t322 * t78;
  t337 = 0.2e1 * t331 * t4 * t81 - t117 * t325 + 0.2e1 * t197 * t328 - 0.2e1 * t268 * t325 + t323 * t79 - t259 - t273;
  t341 = my_piecewise3(t25, 0, t313 * t42 / 0.2e1 + t111 * t123 + t29 * t337 / 0.2e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t109 + 0.2e1 * t127 + t3 * (t311 + t341);

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t346 = t46 * t46;
  t347 = 0.1e1 / t346;
  t348 = t2 * t347;
  t350 = 0.6e1 * t133 - 0.6e1 * t348;
  t351 = my_piecewise3(t7, 0, t350);
  t362 = t149 * t141;
  t364 = t56 * t133;
  t371 = 0.1e1 / t147 / t15;
  t372 = t371 * t47;
  t373 = t372 * t52;
  t376 = t148 * t133;
  t379 = my_piecewise3(t13, 0, t350);
  t382 = t3 * t379 + 0.3e1 * t141;
  t383 = t382 * t56;
  t387 = params->B * t382;
  t389 = t371 * t4;
  t390 = t52 * t52;
  t391 = t389 * t390;
  t394 = t156 * t52;
  t401 = t59 * t144;
  t412 = 0.4e1 * t133 * t59 * t60 + 0.6e1 * t144 * t156 * t229 - 0.4e1 * t159 * t47 * t59 + 0.2e1 * t383 * t4 * t59 - 0.2e1 * t145 * t150 - 0.2e1 * t145 * t152 - 0.4e1 * t150 * t401 - 0.6e1 * t155 * t373 - 0.6e1 * t155 * t376 - 0.2e1 * t163 * t362 + 0.4e1 * t163 * t391 + 0.4e1 * t163 * t394 - t362 * t55 + 0.2e1 * t364 * t55 + t387 * t57 + 0.2e1 * t391 * t55 + 0.2e1 * t394 * t55;
  t416 = my_piecewise3(t1, 0, t351 * t21 / 0.2e1 + 0.3e1 / 0.2e1 * t137 * t64 + 0.3e1 / 0.2e1 * t50 * t169 + t10 * t412 / 0.2e1);
  t418 = my_piecewise3(t27, 0, -t350);
  t429 = t190 * t182;
  t431 = t78 * t133;
  t438 = 0.1e1 / t188 / t36;
  t439 = t438 * t47;
  t440 = t439 * t74;
  t443 = t189 * t133;
  t446 = t33 * t347;
  t449 = my_piecewise3(t32, 0, -0.6e1 * t133 - 0.6e1 * t446);
  t452 = t3 * t449 + 0.3e1 * t182;
  t453 = t452 * t78;
  t457 = params->B * t452;
  t459 = t438 * t4;
  t460 = t74 * t74;
  t461 = t459 * t460;
  t464 = t197 * t74;
  t471 = t81 * t185;
  t482 = 0.4e1 * t133 * t81 * t82 + 0.6e1 * t185 * t197 * t260 - 0.4e1 * t200 * t47 * t81 + 0.2e1 * t4 * t453 * t81 - 0.2e1 * t186 * t191 - 0.2e1 * t186 * t193 - 0.4e1 * t191 * t471 - 0.6e1 * t196 * t440 - 0.6e1 * t196 * t443 - 0.2e1 * t204 * t429 + 0.4e1 * t204 * t461 + 0.4e1 * t204 * t464 - t429 * t77 + 0.2e1 * t431 * t77 + t457 * t79 + 0.2e1 * t461 * t77 + 0.2e1 * t464 * t77;
  t486 = my_piecewise3(t25, 0, t418 * t42 / 0.2e1 + 0.3e1 / 0.2e1 * t175 * t86 + 0.3e1 / 0.2e1 * t70 * t210 + t29 * t482 / 0.2e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t173 + 0.3e1 * t214 + t3 * (t416 + t486);

  t489 = 0.2e1 * t247;
  t490 = 0.2e1 * t278;
  t491 = 0.2e1 * t133;
  t492 = 0.6e1 * t348;
  t493 = t491 - t492;
  t494 = my_piecewise3(t7, 0, t493);
  t505 = t225 * t152;
  t509 = 0.2e1 * t99 * t364;
  t510 = params->C * t144;
  t513 = t156 * t224;
  t516 = my_piecewise3(t13, 0, t493);
  t518 = 0.2e1 * t222;
  t519 = t3 * t516 + t141 + t518;
  t520 = t519 * t56;
  t524 = params->B * t519;
  t528 = t237 * t394;
  t532 = t99 * t394;
  t534 = t229 * t371;
  t535 = t47 * t98;
  t536 = t535 * t52;
  t539 = t376 * t98;
  t540 = t229 * t539;
  t542 = t59 * t224;
  t546 = t59 * t233 * t47;
  t552 = 0.4e1 * t59 * t101 * t133;
  t553 = 0.2e1 * t4 * t520 * t59 - 0.2e1 * t150 * t225 - 0.4e1 * t150 * t542 + 0.4e1 * t229 * t513 + 0.2e1 * t230 * t510 - 0.2e1 * t237 * t362 + 0.4e1 * t237 * t391 - t362 * t99 + 0.2e1 * t391 * t99 + t524 * t57 - 0.6e1 * t534 * t536 - 0.2e1 * t505 + t509 + 0.4e1 * t528 + 0.2e1 * t532 - 0.6e1 * t540 - 0.4e1 * t546 + t552;
  t557 = my_piecewise3(t1, 0, t494 * t21 / 0.2e1 + t218 * t64 + t94 * t169 / 0.2e1 + t137 * t105 / 0.2e1 + t50 * t243 + t10 * t553 / 0.2e1);
  t559 = my_piecewise3(t27, 0, -t493);
  t570 = t256 * t193;
  t574 = 0.2e1 * t117 * t431;
  t575 = params->C * t185;
  t578 = t197 * t255;
  t581 = 0.6e1 * t446;
  t583 = my_piecewise3(t32, 0, -t491 - t581);
  t585 = 0.2e1 * t253;
  t586 = t3 * t583 + t182 + t585;
  t587 = t586 * t78;
  t591 = params->B * t586;
  t595 = t268 * t464;
  t599 = t117 * t464;
  t601 = t260 * t438;
  t602 = t47 * t116;
  t603 = t602 * t74;
  t606 = t443 * t116;
  t607 = t260 * t606;
  t609 = t81 * t255;
  t613 = t81 * t264 * t47;
  t619 = 0.4e1 * t81 * t119 * t133;
  t620 = 0.2e1 * t4 * t587 * t81 - t117 * t429 + 0.2e1 * t117 * t461 - 0.2e1 * t191 * t256 - 0.4e1 * t191 * t609 + 0.4e1 * t260 * t578 + 0.2e1 * t261 * t575 - 0.2e1 * t268 * t429 + 0.4e1 * t268 * t461 + t591 * t79 - 0.6e1 * t601 * t603 - 0.2e1 * t570 + t574 + 0.4e1 * t595 + 0.2e1 * t599 - 0.6e1 * t607 - 0.4e1 * t613 + t619;
  t624 = my_piecewise3(t25, 0, t559 * t42 / 0.2e1 + t248 * t86 + t111 * t210 / 0.2e1 + t175 * t123 / 0.2e1 + t70 * t274 + t29 * t620 / 0.2e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t173 + t214 + t489 + t490 + t3 * (t557 + t624);

  t627 = -t491 - t492;
  t628 = my_piecewise3(t7, 0, t627);
  t641 = t149 * t222;
  t643 = params->C * t98;
  t648 = my_piecewise3(t13, 0, t627);
  t650 = t3 * t648 + t289 + t518;
  t651 = t650 * t56;
  t655 = t156 * t292;
  t658 = t156 * t96;
  t659 = t99 * t658;
  t661 = t59 * t301 * t47;
  t663 = 0.2e1 * t4 * t59 * t651 - t150 * t293 - t225 * t295 + 0.2e1 * t229 * t655 - 0.4e1 * t298 * t373 + 0.4e1 * t513 * t643 - t641 * t99 + t532 - 0.2e1 * t540 - 0.2e1 * t546 + t552 + t659 - 0.2e1 * t661;
  t664 = t293 * t152;
  t665 = t298 * t376;
  t667 = params->B * t650;
  t669 = t96 * t52;
  t670 = t389 * t669;
  t674 = t535 * t96;
  t677 = t237 * t658;
  t679 = t99 * t371;
  t680 = t4 * t96;
  t681 = t680 * t52;
  t684 = t59 * t292;
  t691 = -0.2e1 * t150 * t684 - 0.2e1 * t237 * t641 + 0.4e1 * t237 * t670 - 0.2e1 * t295 * t542 - 0.2e1 * t534 * t674 + t57 * t667 + 0.2e1 * t679 * t681 - t505 + t509 + 0.2e1 * t528 - t664 - 0.4e1 * t665 + 0.2e1 * t677;
  t692 = t663 + t691;
  t696 = my_piecewise3(t1, 0, t628 * t21 / 0.2e1 + t285 * t64 / 0.2e1 + t218 * t105 + t94 * t243 + t50 * t307 / 0.2e1 + t10 * t692 / 0.2e1);
  t698 = my_piecewise3(t27, 0, -t627);
  t709 = t323 * t193;
  t710 = t328 * t443;
  t713 = my_piecewise3(t32, 0, t491 - t581);
  t715 = t3 * t713 + t319 + t585;
  t716 = params->B * t715;
  t718 = t114 * t74;
  t719 = t459 * t718;
  t724 = t190 * t253;
  t726 = -t117 * t724 - t191 * t323 - t256 * t325 + 0.4e1 * t268 * t719 + t716 * t79 - t570 + t574 + t599 - 0.2e1 * t607 - 0.2e1 * t613 + t619 - t709 - 0.4e1 * t710;
  t727 = params->C * t116;
  t732 = t715 * t78;
  t736 = t197 * t322;
  t739 = t197 * t114;
  t740 = t117 * t739;
  t742 = t81 * t331 * t47;
  t745 = t602 * t114;
  t748 = t268 * t739;
  t750 = t117 * t438;
  t751 = t4 * t114;
  t752 = t751 * t74;
  t755 = t81 * t322;
  t762 = 0.2e1 * t4 * t732 * t81 - 0.2e1 * t191 * t755 + 0.2e1 * t260 * t736 - 0.2e1 * t268 * t724 - 0.2e1 * t325 * t609 - 0.4e1 * t328 * t440 + 0.4e1 * t578 * t727 - 0.2e1 * t601 * t745 + 0.2e1 * t750 * t752 + 0.2e1 * t595 + t740 - 0.2e1 * t742 + 0.2e1 * t748;
  t763 = t726 + t762;
  t767 = my_piecewise3(t25, 0, t698 * t42 / 0.2e1 + t313 * t86 / 0.2e1 + t248 * t123 + t111 * t274 + t70 * t337 / 0.2e1 + t29 * t763 / 0.2e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t489 + t490 + t311 + t341 + t3 * (t696 + t767);

  t773 = -0.6e1 * t133 - 0.6e1 * t348;
  t774 = my_piecewise3(t7, 0, t773);
  t785 = t149 * t289;
  t792 = my_piecewise3(t13, 0, t773);
  t795 = t3 * t792 + 0.3e1 * t289;
  t796 = t795 * t56;
  t800 = params->B * t795;
  t803 = t96 * t96;
  t804 = t389 * t803;
  t815 = -0.6e1 * t298 * t372 * t96 + 0.2e1 * t4 * t59 * t796 - 0.2e1 * t237 * t785 + 0.4e1 * t237 * t804 - 0.2e1 * t293 * t295 - 0.4e1 * t295 * t684 + t57 * t800 + 0.6e1 * t643 * t655 - t785 * t99 + 0.2e1 * t804 * t99 + t509 + t552 + 0.2e1 * t659 - 0.4e1 * t661 - 0.2e1 * t664 - 0.6e1 * t665 + 0.4e1 * t677;
  t819 = my_piecewise3(t1, 0, t774 * t21 / 0.2e1 + 0.3e1 / 0.2e1 * t285 * t105 + 0.3e1 / 0.2e1 * t94 * t307 + t10 * t815 / 0.2e1);
  t821 = my_piecewise3(t27, 0, -t773);
  t832 = t190 * t319;
  t841 = my_piecewise3(t32, 0, 0.6e1 * t133 - 0.6e1 * t446);
  t844 = t3 * t841 + 0.3e1 * t319;
  t845 = params->B * t844;
  t848 = t114 * t114;
  t849 = t459 * t848;
  t860 = t844 * t78;
  t864 = -0.6e1 * t114 * t328 * t439 + 0.2e1 * t4 * t81 * t860 - t117 * t832 + 0.2e1 * t117 * t849 - 0.2e1 * t268 * t832 + 0.4e1 * t268 * t849 - 0.2e1 * t323 * t325 - 0.4e1 * t325 * t755 + 0.6e1 * t727 * t736 + t79 * t845 + t574 + t619 - 0.2e1 * t709 - 0.6e1 * t710 + 0.2e1 * t740 - 0.4e1 * t742 + 0.4e1 * t748;
  t868 = my_piecewise3(t25, 0, t821 * t42 / 0.2e1 + 0.3e1 / 0.2e1 * t313 * t123 + 0.3e1 / 0.2e1 * t111 * t337 + t29 * t864 / 0.2e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t311 + 0.3e1 * t341 + t3 * (t819 + t868);

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t874 = 0.1e1 / t346 / t3;
  t875 = t2 * t874;
  t877 = -0.24e2 * t347 + 0.24e2 * t875;
  t878 = my_piecewise3(t7, 0, t877);
  t889 = my_piecewise3(t13, 0, t877);
  t892 = t3 * t889 + 0.4e1 * t379;
  t897 = t56 * t347;
  t900 = t144 * t144;
  t904 = t148 * t347;
  t908 = t389 * t52 * t141;
  t915 = t156 * t141;
  t921 = t147 * t147;
  t922 = 0.1e1 / t921;
  t923 = t922 * t47;
  t924 = t923 * t390;
  t927 = t371 * t133;
  t928 = t927 * t52;
  t934 = t922 * t4;
  t936 = t934 * t390 * t52;
  t939 = t372 * t390;
  t948 = -0.3e1 * t387 * t152 + params->B * t892 * t57 + 0.6e1 * t145 * t364 - 0.6e1 * t55 * t897 + 0.6e1 * params->C * t900 * t156 + 0.22e2 * t155 * t904 + 0.12e2 * t163 * t908 + 0.6e1 * t145 * t391 + 0.6e1 * t145 * t394 + 0.3e1 * t55 * t915 - 0.28e2 * t229 * t376 * t144 + 0.22e2 * t155 * t924 + 0.28e2 * t155 * t928 - 0.6e1 * t59 * t383 * t47 - 0.6e1 * t55 * t936 - 0.6e1 * t55 * t939 + 0.12e2 * t59 * t159 * t133 - 0.12e2 * t59 * t60 * t347;
  t953 = t149 * t379;
  t955 = t376 * t52;
  t961 = t372 * t141;
  t976 = t4 * t141 * t52;
  t996 = -0.28e2 * t144 * t47 * t52 * t534 + 0.2e1 * t4 * t56 * t59 * t892 - 0.6e1 * t150 * t382 * t59 + 0.8e1 * t156 * t229 * t382 + 0.6e1 * t371 * t55 * t976 - 0.3e1 * t145 * t362 - 0.3e1 * t150 * t387 - 0.8e1 * t155 * t961 + 0.6e1 * t163 * t915 - 0.12e2 * t163 * t936 - 0.12e2 * t163 * t939 - 0.2e1 * t163 * t953 - 0.12e2 * t163 * t955 - 0.6e1 * t362 * t401 + 0.12e2 * t391 * t401 + 0.12e2 * t394 * t401 - t55 * t953 - 0.6e1 * t55 * t955;
  t1001 = my_piecewise3(t1, 0, t878 * t21 / 0.2e1 + 0.2e1 * t351 * t64 + 0.3e1 * t137 * t169 + 0.2e1 * t50 * t412 + t10 * (t948 + t996) / 0.2e1);
  t1003 = my_piecewise3(t27, 0, -t877);
  t1014 = t33 * t874;
  t1017 = my_piecewise3(t32, 0, 0.24e2 * t347 + 0.24e2 * t1014);
  t1020 = t1017 * t3 + 0.4e1 * t449;
  t1025 = t78 * t347;
  t1028 = t185 * t185;
  t1032 = t189 * t347;
  t1036 = t459 * t74 * t182;
  t1043 = t197 * t182;
  t1049 = t188 * t188;
  t1050 = 0.1e1 / t1049;
  t1051 = t1050 * t47;
  t1052 = t1051 * t460;
  t1055 = t438 * t133;
  t1056 = t1055 * t74;
  t1062 = t1050 * t4;
  t1064 = t1062 * t460 * t74;
  t1067 = t439 * t460;
  t1076 = -0.3e1 * t457 * t193 + params->B * t1020 * t79 + 0.6e1 * t186 * t431 - 0.6e1 * t77 * t1025 + 0.6e1 * params->C * t1028 * t197 + 0.22e2 * t196 * t1032 + 0.12e2 * t204 * t1036 + 0.6e1 * t186 * t461 + 0.6e1 * t186 * t464 + 0.3e1 * t77 * t1043 - 0.28e2 * t260 * t443 * t185 + 0.22e2 * t196 * t1052 + 0.28e2 * t196 * t1056 - 0.6e1 * t81 * t453 * t47 - 0.6e1 * t77 * t1064 - 0.6e1 * t77 * t1067 + 0.12e2 * t81 * t200 * t133 - 0.12e2 * t81 * t82 * t347;
  t1081 = t190 * t449;
  t1083 = t443 * t74;
  t1089 = t439 * t182;
  t1104 = t4 * t182 * t74;
  t1124 = 0.2e1 * t1020 * t4 * t78 * t81 - 0.28e2 * t185 * t47 * t601 * t74 + 0.6e1 * t1104 * t438 * t77 - 0.6e1 * t191 * t452 * t81 + 0.8e1 * t197 * t260 * t452 + 0.6e1 * t1043 * t204 - 0.12e2 * t1064 * t204 - 0.12e2 * t1067 * t204 - 0.2e1 * t1081 * t204 - t1081 * t77 - 0.12e2 * t1083 * t204 - 0.6e1 * t1083 * t77 - 0.8e1 * t1089 * t196 - 0.3e1 * t186 * t429 - 0.3e1 * t191 * t457 - 0.6e1 * t429 * t471 + 0.12e2 * t461 * t471 + 0.12e2 * t464 * t471;
  t1129 = my_piecewise3(t25, 0, t1003 * t42 / 0.2e1 + 0.2e1 * t418 * t86 + 0.3e1 * t175 * t210 + 0.2e1 * t70 * t482 + t29 * (t1076 + t1124) / 0.2e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t416 + 0.4e1 * t486 + t3 * (t1001 + t1129);

  t1134 = 0.12e2 * t347;
  t1135 = 0.24e2 * t875;
  t1136 = -t1134 + t1135;
  t1137 = my_piecewise3(t7, 0, t1136);
  t1152 = t524 * t152;
  t1154 = my_piecewise3(t13, 0, t1136);
  t1157 = t1154 * t3 + t379 + 0.3e1 * t516;
  t1160 = t225 * t364;
  t1163 = 0.6e1 * t99 * t897;
  t1168 = t225 * t394;
  t1170 = t99 * t915;
  t1172 = t510 * t539;
  t1174 = t376 * t224;
  t1175 = t229 * t1174;
  t1178 = t59 * t520 * t47;
  t1182 = t99 * t939;
  t1185 = t229 * t904 * t98;
  t1188 = t59 * t233 * t133;
  t1192 = 0.12e2 * t59 * t101 * t347;
  t1198 = t1157 * t57 * params->B - 0.3e1 * t150 * t524 - 0.3e1 * t225 * t362 + 0.6e1 * t225 * t391 + 0.12e2 * t237 * t908 - 0.6e1 * t936 * t99 - t953 * t99 - 0.3e1 * t1152 + 0.6e1 * t1160 - t1163 + 0.6e1 * t1168 + 0.3e1 * t1170 - 0.10e2 * t1172 - 0.18e2 * t1175 - 0.6e1 * t1178 - 0.6e1 * t1182 + 0.22e2 * t1185 + 0.12e2 * t1188 - t1192;
  t1199 = t99 * t955;
  t1206 = t156 * t519;
  t1215 = t237 * t939;
  t1217 = t237 * t955;
  t1221 = t510 * t371;
  t1224 = t47 * t224;
  t1225 = t1224 * t52;
  t1228 = t59 * t519;
  t1233 = t542 * t394;
  t1235 = t237 * t915;
  t1244 = t229 * t922;
  t1248 = t133 * t98;
  t1250 = t534 * t1248 * t52;
  t1252 = -0.6e1 * t1199 + 0.2e1 * params->C * t382 * t230 + 0.6e1 * t510 * t513 + 0.6e1 * t229 * t1206 + 0.2e1 * t59 * t1157 * t56 * t4 - 0.12e2 * t237 * t936 - 0.12e2 * t1215 - 0.12e2 * t1217 + 0.6e1 * t679 * t976 - 0.10e2 * t1221 * t536 - 0.18e2 * t534 * t1225 - 0.6e1 * t1228 * t150 + 0.12e2 * t542 * t391 + 0.12e2 * t1233 + 0.6e1 * t1235 - 0.8e1 * t534 * t535 * t141 - 0.6e1 * t542 * t362 - 0.2e1 * t237 * t953 + 0.22e2 * t1244 * t535 * t390 + 0.28e2 * t1250;
  t1257 = my_piecewise3(t1, 0, t1137 * t21 / 0.2e1 + 0.3e1 / 0.2e1 * t494 * t64 + 0.3e1 / 0.2e1 * t218 * t169 + t94 * t412 / 0.2e1 + t351 * t105 / 0.2e1 + 0.3e1 / 0.2e1 * t137 * t243 + 0.3e1 / 0.2e1 * t50 * t553 + t10 * (t1198 + t1252) / 0.2e1);
  t1259 = my_piecewise3(t27, 0, -t1136);
  t1274 = t591 * t193;
  t1276 = 0.24e2 * t1014;
  t1278 = my_piecewise3(t32, 0, t1134 + t1276);
  t1281 = t1278 * t3 + t449 + 0.3e1 * t583;
  t1284 = t256 * t431;
  t1287 = 0.6e1 * t117 * t1025;
  t1292 = t256 * t464;
  t1294 = t117 * t1043;
  t1296 = t575 * t606;
  t1298 = t443 * t255;
  t1299 = t260 * t1298;
  t1302 = t81 * t587 * t47;
  t1306 = t117 * t1067;
  t1309 = t260 * t1032 * t116;
  t1312 = t81 * t264 * t133;
  t1316 = 0.12e2 * t81 * t119 * t347;
  t1322 = t1281 * t79 * params->B + 0.12e2 * t1036 * t268 - 0.6e1 * t1064 * t117 - t1081 * t117 - 0.3e1 * t191 * t591 - 0.3e1 * t256 * t429 + 0.6e1 * t256 * t461 - 0.3e1 * t1274 + 0.6e1 * t1284 - t1287 + 0.6e1 * t1292 + 0.3e1 * t1294 - 0.10e2 * t1296 - 0.18e2 * t1299 - 0.6e1 * t1302 - 0.6e1 * t1306 + 0.22e2 * t1309 + 0.12e2 * t1312 - t1316;
  t1323 = t117 * t1083;
  t1330 = t197 * t586;
  t1339 = t268 * t1067;
  t1341 = t268 * t1083;
  t1345 = t575 * t438;
  t1348 = t47 * t255;
  t1349 = t1348 * t74;
  t1352 = t81 * t586;
  t1357 = t609 * t464;
  t1359 = t268 * t1043;
  t1368 = t260 * t1050;
  t1372 = t133 * t116;
  t1374 = t601 * t1372 * t74;
  t1376 = -0.6e1 * t1323 + 0.2e1 * params->C * t452 * t261 + 0.6e1 * t575 * t578 + 0.6e1 * t260 * t1330 + 0.2e1 * t81 * t1281 * t78 * t4 - 0.12e2 * t268 * t1064 - 0.12e2 * t1339 - 0.12e2 * t1341 + 0.6e1 * t750 * t1104 - 0.10e2 * t1345 * t603 - 0.18e2 * t601 * t1349 - 0.6e1 * t1352 * t191 + 0.12e2 * t609 * t461 + 0.12e2 * t1357 + 0.6e1 * t1359 - 0.8e1 * t601 * t602 * t182 - 0.6e1 * t609 * t429 - 0.2e1 * t268 * t1081 + 0.22e2 * t1368 * t602 * t460 + 0.28e2 * t1374;
  t1381 = my_piecewise3(t25, 0, t1259 * t42 / 0.2e1 + 0.3e1 / 0.2e1 * t559 * t86 + 0.3e1 / 0.2e1 * t248 * t210 + t111 * t482 / 0.2e1 + t418 * t123 / 0.2e1 + 0.3e1 / 0.2e1 * t175 * t274 + 0.3e1 / 0.2e1 * t70 * t620 + t29 * (t1322 + t1376) / 0.2e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t416 + t486 + 0.3e1 * t557 + 0.3e1 * t624 + t3 * (t1257 + t1381);

  t1388 = my_piecewise3(t7, 0, t1135);
  t1404 = t534 * t1248 * t96;
  t1406 = t376 * t96;
  t1407 = t237 * t1406;
  t1409 = t99 * t922;
  t1414 = t47 * t96 * t52;
  t1416 = 0.4e1 * t679 * t1414;
  t1420 = 0.4e1 * t684 * t394;
  t1428 = t643 * t371;
  t1431 = t59 * t650;
  t1436 = t1224 * t96;
  t1441 = 0.2e1 * t667 * t152;
  t1442 = 0.4e1 * t222 * t4 * t52 * t679 - 0.6e1 * t1409 * t390 * t680 + 0.4e1 * t225 * t371 * t681 - 0.2e1 * t1221 * t674 - 0.16e2 * t1225 * t1428 - 0.4e1 * t1431 * t150 - 0.4e1 * t1436 * t534 + 0.4e1 * t391 * t684 + 0.2e1 * t510 * t655 - t1152 + 0.4e1 * t1160 - t1163 + 0.6e1 * t1404 - 0.4e1 * t1407 - t1416 + t1420 - t1441;
  t1443 = my_piecewise3(t13, 0, t1135);
  t1447 = t1443 * t3 + 0.2e1 * t516 + 0.2e1 * t648;
  t1450 = t293 * t364;
  t1452 = t224 * t224;
  t1456 = t298 * t904;
  t1477 = 0.8e1 * t237 * t372 * t669;
  t1481 = t47 * t292;
  t1482 = t1481 * t52;
  t1486 = 0.4e1 * t542 * t658;
  t1487 = t156 * t222;
  t1489 = 0.4e1 * t237 * t1487;
  t1499 = params->B * t1447 * t57 + 0.2e1 * t1450 + 0.4e1 * params->C * t1452 * t156 + 0.12e2 * t1456 + 0.10e2 * t1244 * t535 * t669 + 0.8e1 * t542 * t670 + 0.8e1 * t237 * t389 * t222 * t52 + 0.4e1 * t237 * t389 * t96 * t141 - 0.12e2 * t237 * t934 * t96 * t390 - t1477 - 0.4e1 * t534 * t535 * t222 - 0.6e1 * t534 * t1482 + t1486 + t1489 + 0.2e1 * t679 * t680 * t141 - 0.2e1 * t684 * t362 - 0.2e1 * t1228 * t295 - 0.4e1 * t542 * t641;
  t1501 = t149 * t516;
  t1512 = t156 * t650;
  t1518 = 0.2e1 * t293 * t394;
  t1520 = 0.2e1 * t225 * t658;
  t1522 = 0.2e1 * t99 * t1487;
  t1523 = t643 * t1174;
  t1527 = -0.2e1 * t1501 * t237 + 0.4e1 * t1512 * t229 + 0.2e1 * t293 * t391 + 0.12e2 * t298 * t924 + 0.2e1 * t1168 + t1170 - 0.2e1 * t1172 - 0.4e1 * t1175 - 0.2e1 * t1178 - 0.2e1 * t1182 + 0.10e2 * t1185 + 0.8e1 * t1188 - t1192 - 0.4e1 * t1199 + t1518 + t1520 + t1522 - 0.16e2 * t1523;
  t1528 = t298 * t928;
  t1532 = 0.4e1 * t59 * t651 * t47;
  t1533 = t376 * t292;
  t1534 = t229 * t1533;
  t1536 = t99 * t1406;
  t1539 = t59 * t301 * t133;
  t1561 = 0.2e1 * t1447 * t4 * t56 * t59 + 0.4e1 * t1206 * t643 - 0.2e1 * t150 * t667 - t1501 * t99 - 0.2e1 * t225 * t641 - t293 * t362 - t295 * t524 - 0.4e1 * t298 * t961 - 0.4e1 * t1215 - 0.8e1 * t1217 + 0.4e1 * t1233 + 0.2e1 * t1235 + 0.6e1 * t1250 + 0.16e2 * t1528 - t1532 - 0.6e1 * t1534 - 0.2e1 * t1536 + 0.4e1 * t1539;
  t1567 = my_piecewise3(t1, 0, t1388 * t21 / 0.2e1 + t628 * t64 + t285 * t169 / 0.2e1 + t494 * t105 + 0.2e1 * t218 * t243 + t94 * t553 + t137 * t307 / 0.2e1 + t50 * t692 + t10 * (t1442 + t1499 + t1527 + t1561) / 0.2e1);
  t1568 = my_piecewise3(t27, 0, -t1135);
  t1581 = t197 * t715;
  t1587 = 0.2e1 * t323 * t464;
  t1589 = 0.2e1 * t256 * t739;
  t1590 = t197 * t253;
  t1592 = 0.2e1 * t117 * t1590;
  t1593 = t727 * t1298;
  t1597 = t328 * t1056;
  t1601 = 0.4e1 * t81 * t732 * t47;
  t1602 = t443 * t322;
  t1603 = t260 * t1602;
  t1605 = t443 * t114;
  t1606 = t117 * t1605;
  t1609 = t81 * t331 * t133;
  t1617 = t190 * t583;
  t1619 = 0.12e2 * t1052 * t328 - t117 * t1617 + 0.4e1 * t1581 * t260 - 0.2e1 * t191 * t716 - 0.2e1 * t256 * t724 - t323 * t429 + 0.2e1 * t323 * t461 - t325 * t591 + t1587 + t1589 + t1592 - 0.16e2 * t1593 + 0.16e2 * t1597 - t1601 - 0.6e1 * t1603 - 0.2e1 * t1606 + 0.4e1 * t1609;
  t1624 = my_piecewise3(t32, 0, t1276);
  t1628 = t1624 * t3 + 0.2e1 * t583 + 0.2e1 * t713;
  t1637 = 0.2e1 * t716 * t193;
  t1640 = t323 * t431;
  t1642 = t255 * t255;
  t1646 = t328 * t1032;
  t1667 = 0.8e1 * t268 * t439 * t718;
  t1668 = 0.4e1 * t727 * t1330 - 0.4e1 * t328 * t1089 + 0.2e1 * t81 * t1628 * t78 * t4 + 0.2e1 * t575 * t736 - t1274 + 0.4e1 * t1284 - t1287 - t1637 + params->B * t1628 * t79 + 0.2e1 * t1640 + 0.4e1 * params->C * t1642 * t197 + 0.12e2 * t1646 + 0.10e2 * t1368 * t602 * t718 + 0.8e1 * t609 * t719 + 0.8e1 * t268 * t459 * t253 * t74 + 0.4e1 * t268 * t459 * t114 * t182 - 0.12e2 * t268 * t1062 * t114 * t460 - t1667;
  t1671 = t601 * t1372 * t114;
  t1673 = t268 * t1605;
  t1675 = t117 * t1050;
  t1680 = t47 * t114 * t74;
  t1682 = 0.4e1 * t750 * t1680;
  t1686 = 0.4e1 * t755 * t464;
  t1694 = t727 * t438;
  t1697 = t81 * t715;
  t1702 = t1348 * t114;
  t1708 = t47 * t322;
  t1709 = t1708 * t74;
  t1713 = 0.4e1 * t609 * t739;
  t1715 = 0.4e1 * t268 * t1590;
  t1721 = 0.4e1 * t253 * t4 * t74 * t750 - 0.6e1 * t1675 * t460 * t751 + 0.2e1 * t182 * t750 * t751 - 0.4e1 * t253 * t601 * t602 + 0.4e1 * t256 * t438 * t752 - 0.2e1 * t1345 * t745 - 0.16e2 * t1349 * t1694 - 0.4e1 * t1697 * t191 - 0.4e1 * t1702 * t601 - 0.6e1 * t1709 * t601 - 0.2e1 * t429 * t755 + 0.4e1 * t461 * t755 + 0.6e1 * t1671 - 0.4e1 * t1673 - t1682 + t1686 + t1713 + t1715;
  t1741 = -0.2e1 * t1352 * t325 - 0.2e1 * t1617 * t268 - 0.4e1 * t609 * t724 + 0.2e1 * t1292 + t1294 - 0.2e1 * t1296 - 0.4e1 * t1299 - 0.2e1 * t1302 - 0.2e1 * t1306 + 0.10e2 * t1309 + 0.8e1 * t1312 - t1316 - 0.4e1 * t1323 - 0.4e1 * t1339 - 0.8e1 * t1341 + 0.4e1 * t1357 + 0.2e1 * t1359 + 0.6e1 * t1374;
  t1747 = my_piecewise3(t25, 0, t1568 * t42 / 0.2e1 + t698 * t86 + t313 * t210 / 0.2e1 + t559 * t123 + 0.2e1 * t248 * t274 + t111 * t620 + t175 * t337 / 0.2e1 + t70 * t763 + t29 * (t1619 + t1668 + t1721 + t1741) / 0.2e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t557 + 0.2e1 * t624 + 0.2e1 * t696 + 0.2e1 * t767 + t3 * (t1567 + t1747);

  t1752 = t1134 + t1135;
  t1753 = my_piecewise3(t7, 0, t1752);
  t1768 = t293 * t658;
  t1770 = t156 * t289;
  t1771 = t99 * t1770;
  t1772 = t643 * t1533;
  t1775 = t298 * t927 * t96;
  t1778 = t59 * t796 * t47;
  t1780 = t372 * t803;
  t1781 = t99 * t1780;
  t1788 = t149 * t648;
  t1798 = my_piecewise3(t13, 0, t1752);
  t1801 = t1798 * t3 + 0.3e1 * t648 + t792;
  t1809 = t156 * t795;
  t1812 = 0.2e1 * t1768 + t1771 - 0.12e2 * t1772 + 0.12e2 * t1775 - 0.2e1 * t1778 - 0.2e1 * t1781 - 0.2e1 * t667 * t295 - 0.2e1 * t293 * t641 - t225 * t785 - t99 * t1788 + 0.6e1 * params->C * t224 * t655 + 0.6e1 * t643 * t1512 - 0.6e1 * t298 * t372 * t222 + 0.2e1 * t59 * t1801 * t56 * t4 - t800 * t150 + 0.2e1 * t225 * t804 + 0.2e1 * t229 * t1809;
  t1820 = t800 * t152;
  t1835 = 0.8e1 * t222 * t237 * t389 * t96 + 0.4e1 * t237 * t289 * t389 * t52 - 0.12e2 * t237 * t52 * t803 * t934 + t1801 * t57 * params->B + 0.8e1 * t670 * t684 + 0.2e1 * t1160 - t1163 + 0.4e1 * t1404 - 0.8e1 * t1407 - t1416 + t1420 - t1441 + 0.4e1 * t1450 + 0.18e2 * t1456 - t1477 + t1486 - t1820;
  t1837 = t237 * t1780;
  t1839 = t684 * t658;
  t1841 = t237 * t1770;
  t1846 = t4 * t289;
  t1857 = t59 * t795;
  t1877 = t1489 - 0.4e1 * t1837 + 0.4e1 * t1839 + 0.2e1 * t1841 + 0.4e1 * t293 * t371 * t681 + 0.2e1 * t679 * t1846 * t52 - 0.12e2 * t1428 * t1482 - 0.12e2 * t1428 * t1436 + 0.18e2 * t298 * t922 * t1414 - 0.2e1 * t1857 * t150 + 0.4e1 * t542 * t804 - 0.6e1 * t1409 * t4 * t803 * t52 + 0.4e1 * t679 * t680 * t222 - 0.4e1 * t1431 * t295 - 0.4e1 * t684 * t641 - 0.2e1 * t542 * t785 - 0.2e1 * t237 * t1788;
  t1881 = t1481 * t96;
  t1896 = 0.4e1 * t1244 * t535 * t803 - 0.2e1 * t289 * t534 * t535 - 0.4e1 * t1881 * t534 + 0.4e1 * t1185 + 0.4e1 * t1188 - t1192 - 0.2e1 * t1199 - 0.4e1 * t1217 + t1518 + t1520 + t1522 - 0.12e2 * t1523 + 0.12e2 * t1528 - t1532 - 0.4e1 * t1534 - 0.4e1 * t1536 + 0.8e1 * t1539;
  t1902 = my_piecewise3(t1, 0, t1753 * t21 / 0.2e1 + t774 * t64 / 0.2e1 + 0.3e1 / 0.2e1 * t628 * t105 + 0.3e1 / 0.2e1 * t285 * t243 + 0.3e1 / 0.2e1 * t218 * t307 + 0.3e1 / 0.2e1 * t94 * t692 + t50 * t815 / 0.2e1 + t10 * (t1812 + t1835 + t1877 + t1896) / 0.2e1);
  t1904 = my_piecewise3(t27, 0, -t1752);
  t1924 = t190 * t713;
  t1938 = my_piecewise3(t32, 0, -t1134 + t1276);
  t1941 = t1938 * t3 + 0.3e1 * t713 + t841;
  t1946 = t197 * t844;
  t1949 = t323 * t739;
  t1951 = t197 * t319;
  t1952 = t117 * t1951;
  t1953 = t727 * t1602;
  t1956 = t328 * t1055 * t114;
  t1958 = t439 * t848;
  t1959 = t117 * t1958;
  t1962 = t81 * t860 * t47;
  t1964 = -0.2e1 * t716 * t325 - 0.2e1 * t323 * t724 - t256 * t832 - t117 * t1924 + 0.6e1 * params->C * t255 * t736 + 0.6e1 * t727 * t1581 - 0.6e1 * t328 * t439 * t253 - t845 * t191 + 0.2e1 * t256 * t849 + 0.2e1 * t81 * t1941 * t78 * t4 + 0.2e1 * t260 * t1946 + 0.2e1 * t1949 + t1952 - 0.12e2 * t1953 + 0.12e2 * t1956 - 0.2e1 * t1959 - 0.2e1 * t1962;
  t1975 = t845 * t193;
  t1980 = -0.12e2 * t1062 * t268 * t74 * t848 + t1941 * t79 * params->B + 0.2e1 * t1284 - t1287 + t1587 + t1589 + t1592 - 0.12e2 * t1593 + 0.12e2 * t1597 - t1601 - 0.4e1 * t1603 - 0.4e1 * t1606 + 0.8e1 * t1609 - t1637 + 0.4e1 * t1640 + 0.18e2 * t1646 - t1975;
  t1994 = t268 * t1958;
  t1996 = t755 * t739;
  t1998 = t268 * t1951;
  t2003 = t4 * t319;
  t2011 = 0.8e1 * t114 * t253 * t268 * t459 + 0.4e1 * t268 * t319 * t459 * t74 + 0.2e1 * t2003 * t74 * t750 + 0.4e1 * t323 * t438 * t752 - 0.12e2 * t1694 * t1702 - 0.12e2 * t1694 * t1709 + 0.8e1 * t719 * t755 - t1667 + 0.4e1 * t1671 - 0.8e1 * t1673 - t1682 + t1686 + t1713 + t1715 - 0.4e1 * t1994 + 0.4e1 * t1996 + 0.2e1 * t1998;
  t2032 = t81 * t844;
  t2038 = t1708 * t114;
  t2048 = 0.18e2 * t328 * t1050 * t1680 + 0.4e1 * t609 * t849 - 0.6e1 * t1675 * t4 * t848 * t74 + 0.4e1 * t750 * t751 * t253 - 0.4e1 * t1697 * t325 - 0.4e1 * t755 * t724 - 0.2e1 * t609 * t832 - 0.2e1 * t268 * t1924 - 0.2e1 * t2032 * t191 + 0.4e1 * t1368 * t602 * t848 - 0.4e1 * t601 * t2038 - 0.2e1 * t601 * t602 * t319 + 0.4e1 * t1309 + 0.4e1 * t1312 - t1316 - 0.2e1 * t1323 - 0.4e1 * t1341;
  t2054 = my_piecewise3(t25, 0, t1904 * t42 / 0.2e1 + t821 * t86 / 0.2e1 + 0.3e1 / 0.2e1 * t698 * t123 + 0.3e1 / 0.2e1 * t313 * t274 + 0.3e1 / 0.2e1 * t248 * t337 + 0.3e1 / 0.2e1 * t111 * t763 + t70 * t864 / 0.2e1 + t29 * (t1964 + t1980 + t2011 + t2048) / 0.2e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t696 + 0.3e1 * t767 + t819 + t868 + t3 * (t1902 + t2054);

  t2060 = 0.24e2 * t347 + 0.24e2 * t875;
  t2061 = my_piecewise3(t7, 0, t2060);
  t2074 = t149 * t792;
  t2081 = my_piecewise3(t13, 0, t2060);
  t2084 = t2081 * t3 + 0.4e1 * t792;
  t2095 = t934 * t803 * t96;
  t2106 = 0.2e1 * t2084 * t4 * t56 * t59 - 0.8e1 * t289 * t298 * t372 + 0.22e2 * t298 * t803 * t923 + 0.8e1 * t1809 * t643 - t2074 * t99 - 0.6e1 * t2095 * t99 - 0.3e1 * t293 * t785 + 0.6e1 * t293 * t804 - 0.3e1 * t295 * t800 - t1163 - 0.12e2 * t1407 + 0.6e1 * t1450 + 0.6e1 * t1768 + 0.3e1 * t1771 - 0.28e2 * t1772 + 0.28e2 * t1775 - 0.6e1 * t1778 - 0.6e1 * t1781;
  t2111 = t292 * t292;
  t2139 = 0.12e2 * t237 * t289 * t389 * t96 + 0.6e1 * t156 * t2111 * params->C + 0.6e1 * t1846 * t679 * t96 + t2084 * t57 * params->B - 0.28e2 * t1428 * t1881 - 0.6e1 * t1857 * t295 - 0.2e1 * t2074 * t237 - 0.12e2 * t2095 * t237 - 0.6e1 * t684 * t785 + 0.12e2 * t684 * t804 - t1192 + 0.22e2 * t1456 - 0.6e1 * t1536 + 0.12e2 * t1539 - 0.3e1 * t1820 - 0.12e2 * t1837 + 0.12e2 * t1839 + 0.6e1 * t1841;
  t2144 = my_piecewise3(t1, 0, t2061 * t21 / 0.2e1 + 0.2e1 * t774 * t105 + 0.3e1 * t285 * t307 + 0.2e1 * t94 * t815 + t10 * (t2106 + t2139) / 0.2e1);
  t2146 = my_piecewise3(t27, 0, -t2060);
  t2157 = my_piecewise3(t32, 0, -0.24e2 * t347 + 0.24e2 * t1014);
  t2160 = t2157 * t3 + 0.4e1 * t841;
  t2171 = t1062 * t848 * t114;
  t2178 = t190 * t841;
  t2193 = 0.2e1 * t2160 * t4 * t78 * t81 + 0.22e2 * t1051 * t328 * t848 - 0.8e1 * t319 * t328 * t439 - 0.6e1 * t117 * t2171 - t117 * t2178 + 0.8e1 * t1946 * t727 - 0.3e1 * t323 * t832 + 0.6e1 * t323 * t849 - 0.3e1 * t325 * t845 - t1287 - 0.6e1 * t1606 + 0.12e2 * t1609 + 0.6e1 * t1949 + 0.3e1 * t1952 - 0.28e2 * t1953 + 0.28e2 * t1956 - 0.6e1 * t1959 - 0.6e1 * t1962;
  t2199 = t322 * t322;
  t2226 = 0.12e2 * t114 * t268 * t319 * t459 + 0.6e1 * t114 * t2003 * t750 + 0.6e1 * t197 * t2199 * params->C + t2160 * t79 * params->B - 0.28e2 * t1694 * t2038 - 0.6e1 * t2032 * t325 - 0.12e2 * t2171 * t268 - 0.2e1 * t2178 * t268 - 0.6e1 * t755 * t832 + 0.12e2 * t755 * t849 - t1316 + 0.6e1 * t1640 + 0.22e2 * t1646 - 0.12e2 * t1673 - 0.3e1 * t1975 - 0.12e2 * t1994 + 0.12e2 * t1996 + 0.6e1 * t1998;
  t2231 = my_piecewise3(t25, 0, t2146 * t42 / 0.2e1 + 0.2e1 * t821 * t123 + 0.3e1 * t313 * t337 + 0.2e1 * t111 * t864 + t29 * (t2193 + t2226) / 0.2e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t819 + 0.4e1 * t868 + t3 * (t2144 + t2231);

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

