/* 
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_k_tflw.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma , double *zk GGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t5, t7, t10, t11, t13;
  double t14, t16, t17, t18, t20, t21, t22, t24;
  double t27, t29, t30, t31, t32, t36, t40;

#ifndef XC_DONT_COMPILE_VXC
  double t46, t49, t52, t56, t64, t67;

#ifndef XC_DONT_COMPILE_FXC
  double t76, t79, t83, t88;

#ifndef XC_DONT_COMPILE_KXC
  double t101, t105, t111;

#ifndef XC_DONT_COMPILE_LXC
  double t128, t134;
#endif

#endif

#endif

#endif

#endif


  gga_k_tflw_params *params;

  assert(p->params != NULL);
  params = (gga_k_tflw_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t10 = my_piecewise3(0.1e1 <= p->zeta_threshold, p->zeta_threshold - 0.1e1, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(t11);
  t14 = t13 * t13;
  t16 = my_piecewise3(t11 <= p->zeta_threshold, 0, t14 * t11);
  t17 = POW_1_3(rho[0]);
  t18 = t17 * t17;
  t20 = params->lambda * sigma[0];
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t24 = rho[0] * rho[0];
  t27 = M_CBRT6;
  t29 = M_PI * M_PI;
  t30 = POW_1_3(t29);
  t31 = t30 * t30;
  t32 = 0.1e1 / t31;
  t36 = params->gamma + 0.5e1 / 0.72e2 * t20 * t22 / t18 / t24 * t27 * t32;
  t40 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t16 * t18 * t36);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t40;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t46 = t24 * rho[0];
  t49 = t7 * t16 / t46;
  t52 = t20 * t22 * t27 * t32;
  t56 = my_piecewise3(t2, 0, t7 * t16 / t17 * t36 / 0.10e2 - t49 * t52 / 0.36e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t56 + 0.2e1 * t40;

  t64 = params->lambda * t22 * t27 * t32;
  t67 = my_piecewise3(t2, 0, t7 * t16 / t24 * t64 / 0.96e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.2e1 * rho[0] * t67;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t76 = t24 * t24;
  t79 = t7 * t16 / t76;
  t83 = my_piecewise3(t2, 0, -t7 * t16 / t17 / rho[0] * t36 / 0.30e2 + 0.7e1 / 0.108e3 * t79 * t52);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t83 + 0.4e1 * t56;

  t88 = my_piecewise3(t2, 0, -t49 * t64 / 0.48e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.2e1 * rho[0] * t88 + 0.2e1 * t67;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t101 = t7 * t16 / t76 / rho[0];
  t105 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t16 / t17 / t24 * t36 - 0.41e2 / 0.162e3 * t101 * t52);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t105 + 0.6e1 * t83;

  t111 = my_piecewise3(t2, 0, t79 * t64 / 0.16e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.2e1 * rho[0] * t111 + 0.4e1 * t88;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t128 = my_piecewise3(t2, 0, -0.14e2 / 0.135e3 * t7 * t16 / t17 / t46 * t36 + 0.611e3 / 0.486e3 * t7 * t16 / t76 / t24 * t52);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t128 + 0.8e1 * t105;

  t134 = my_piecewise3(t2, 0, -t101 * t64 / 0.4e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.2e1 * rho[0] * t134 + 0.6e1 * t111;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma , double *zk GGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t13, t15, t16, t17, t18, t19, t21;
  double t22, t23, t24, t25, t26, t27, t28, t30;
  double t31, t33, t34, t35, t36, t40, t44, t45;
  double t48, t49, t51, t52, t53, t54, t55, t57;
  double t58, t59, t60, t61, t62, t64, t69, t73;

#ifndef XC_DONT_COMPILE_VXC
  double t74, t75, t76, t78, t81, t82, t86, t87;
  double t90, t91, t94, t97, t101, t102, t104, t107;
  double t108, t112, t115, t117, t121, t124, t125, t130;
  double t132, t135, t136, t140, t143, t146, t150, t154;
  double t155, t158, t160, t163;

#ifndef XC_DONT_COMPILE_FXC
  double t166, t167, t170, t171, t172, t175, t179, t180;
  double t184, t186, t188, t192, t193, t196, t197, t198;
  double t200, t202, t205, t209, t210, t211, t214, t217;
  double t221, t222, t226, t228, t230, t233, t235, t238;
  double t242, t246, t247, t251, t253, t255, t261, t262;
  double t266, t270, t271, t275, t277, t280, t283, t284;
  double t287, t292, t297, t301, t302, t308, t309, t314;
  double t318, t319, t324, t328, t330, t333, t337, t343;
  double t345, t349, t354, t356, t361, t366, t370;

#ifndef XC_DONT_COMPILE_KXC
  double t375, t376, t379, t382, t383, t384, t387, t391;
  double t392, t396, t398, t400, t403, t405, t407, t408;
  double t413, t414, t417, t418, t419, t421, t425, t428;
  double t432, t434, t435, t438, t441, t444, t448, t449;
  double t453, t455, t457, t459, t461, t464, t466, t469;
  double t470, t471, t474, t479, t480, t482, t486, t487;
  double t491, t494, t495, t498, t500, t502, t504, t512;
  double t513, t514, t517, t522, t524, t528, t529, t533;
  double t536, t537, t539, t543, t546, t548, t549, t550;
  double t553, t556, t561, t565, t569, t570, t574, t576;
  double t578, t585, t586, t591, t595, t599, t600, t604;
  double t606, t609, t612, t613, t619, t621, t622, t627;
  double t634, t638, t639, t646, t647, t654, t658, t659;
  double t664, t675, t678, t682, t688, t693, t694, t697;
  double t701, t706, t709, t711, t715, t722, t726, t731;
  double t734, t741, t751, t755;

#ifndef XC_DONT_COMPILE_LXC
  double t761, t765, t769, t772, t776, t777, t779, t780;
  double t786, t792, t793, t796, t800, t805, t807, t819;
  double t823, t826, t827, t829, t830, t832, t833, t835;
  double t836, t837, t839, t840, t846, t851, t854, t858;
  double t865, t869, t873, t878, t880, t887, t891, t892;
  double t895, t916, t917, t919, t923, t928, t940, t943;
  double t944, t946, t947, t948, t949, t950, t967, t969;
  double t973, t980, t984, t985, t988, t993, t996, t997;
  double t999, t1000, t1001, t1002, t1003, t1005, t1006, t1015;
  double t1022, t1034, t1047, t1051, t1064, t1067, t1068, t1070;
  double t1071, t1080, t1093, t1097, t1104, t1108, t1113, t1116;
  double t1117, t1119, t1120, t1129, t1131, t1133, t1134, t1155;
  double t1159, t1166, t1168, t1177, t1178, t1195, t1199, t1206;
  double t1210, t1213, t1214, t1221, t1229, t1231, t1232, t1237;
  double t1242, t1249, t1253, t1262, t1266, t1271, t1278, t1282;
  double t1305, t1308, t1309, t1315, t1319, t1321, t1326, t1327;
  double t1329, t1336, t1341, t1343, t1346, t1348, t1350, t1354;
  double t1357, t1360, t1368, t1369, t1371, t1375, t1376, t1383;
  double t1384, t1387, t1391, t1399, t1403, t1408, t1414, t1416;
  double t1417, t1425, t1444;
#endif

#endif

#endif

#endif

#endif


  gga_k_tflw_params *params;

  assert(p->params != NULL);
  params = (gga_k_tflw_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise3(t11, t12, t13 * t8);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = POW_1_3(t16);
  t19 = t18 * t18;
  t21 = my_piecewise3(t17, 0, t19 * t16);
  t22 = POW_1_3(t7);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = params->lambda * sigma[0];
  t26 = rho[0] * rho[0];
  t27 = POW_1_3(rho[0]);
  t28 = t27 * t27;
  t30 = 0.1e1 / t28 / t26;
  t31 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t40 = params->gamma + 0.5e1 / 0.72e2 * t25 * t30 * t31 * t36;
  t44 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t24 * t40);
  t45 = rho[1] <= p->dens_threshold;
  t48 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t49 = -t13;
  t51 = my_piecewise3(t48, t12, t49 * t8);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t55 = t54 * t54;
  t57 = my_piecewise3(t53, 0, t55 * t52);
  t58 = t57 * t23;
  t59 = params->lambda * sigma[2];
  t60 = rho[1] * rho[1];
  t61 = POW_1_3(rho[1]);
  t62 = t61 * t61;
  t64 = 0.1e1 / t62 / t60;
  t69 = params->gamma + 0.5e1 / 0.72e2 * t59 * t64 * t31 * t36;
  t73 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t58 * t69);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t44 + t73;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t74 = t7 * t7;
  t75 = 0.1e1 / t74;
  t76 = t13 * t75;
  t78 = my_piecewise3(t11, 0, t8 - t76);
  t81 = my_piecewise3(t17, 0, 0.5e1 / 0.3e1 * t19 * t78);
  t82 = t81 * t23;
  t86 = 0.1e1 / t22;
  t87 = t21 * t86;
  t90 = t6 * t87 * t40 / 0.10e2;
  t91 = t6 * t24;
  t94 = 0.1e1 / t28 / t26 / rho[0];
  t97 = t25 * t94 * t31 * t36;
  t101 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t82 * t40 + t90 - t91 * t97 / 0.36e2);
  t102 = t49 * t75;
  t104 = my_piecewise3(t48, 0, -t8 - t102);
  t107 = my_piecewise3(t53, 0, 0.5e1 / 0.3e1 * t55 * t104);
  t108 = t107 * t23;
  t112 = t57 * t86;
  t115 = t6 * t112 * t69 / 0.10e2;
  t117 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t108 * t69 + t115);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t44 + t73 + t7 * (t101 + t117);

  t121 = my_piecewise3(t11, 0, -t8 - t76);
  t124 = my_piecewise3(t17, 0, 0.5e1 / 0.3e1 * t19 * t121);
  t125 = t124 * t23;
  t130 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t125 * t40 + t90);
  t132 = my_piecewise3(t48, 0, t8 - t102);
  t135 = my_piecewise3(t53, 0, 0.5e1 / 0.3e1 * t55 * t132);
  t136 = t135 * t23;
  t140 = t6 * t58;
  t143 = 0.1e1 / t62 / t60 / rho[1];
  t146 = t59 * t143 * t31 * t36;
  t150 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t136 * t69 + t115 - t140 * t146 / 0.36e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t44 + t73 + t7 * (t130 + t150);

  t154 = t31 * t36;
  t155 = params->lambda * t30 * t154;
  t158 = my_piecewise3(t1, 0, t91 * t155 / 0.96e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = t7 * t158;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  t160 = params->lambda * t64 * t154;
  t163 = my_piecewise3(t45, 0, t140 * t160 / 0.96e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = t7 * t163;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t166 = 0.1e1 / t18;
  t167 = t78 * t78;
  t170 = t74 * t7;
  t171 = 0.1e1 / t170;
  t172 = t13 * t171;
  t175 = my_piecewise3(t11, 0, -0.2e1 * t75 + 0.2e1 * t172);
  t179 = my_piecewise3(t17, 0, 0.10e2 / 0.9e1 * t166 * t167 + 0.5e1 / 0.3e1 * t19 * t175);
  t180 = t179 * t23;
  t184 = t81 * t86;
  t186 = t6 * t184 * t40;
  t188 = t6 * t82;
  t192 = 0.1e1 / t22 / t7;
  t193 = t21 * t192;
  t196 = t6 * t193 * t40 / 0.30e2;
  t197 = t6 * t87;
  t198 = t197 * t97;
  t200 = t26 * t26;
  t202 = 0.1e1 / t28 / t200;
  t205 = t25 * t202 * t31 * t36;
  t209 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t180 * t40 + t186 / 0.5e1 - t188 * t97 / 0.18e2 - t196 - t198 / 0.27e2 + 0.11e2 / 0.108e3 * t91 * t205);
  t210 = 0.1e1 / t54;
  t211 = t104 * t104;
  t214 = t49 * t171;
  t217 = my_piecewise3(t48, 0, 0.2e1 * t75 + 0.2e1 * t214);
  t221 = my_piecewise3(t53, 0, 0.10e2 / 0.9e1 * t210 * t211 + 0.5e1 / 0.3e1 * t55 * t217);
  t222 = t221 * t23;
  t226 = t107 * t86;
  t228 = t6 * t226 * t69;
  t230 = t57 * t192;
  t233 = t6 * t230 * t69 / 0.30e2;
  t235 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t222 * t69 + t228 / 0.5e1 - t233);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t101 + 0.2e1 * t117 + t7 * (t209 + t235);

  t238 = t166 * t121;
  t242 = my_piecewise3(t11, 0, 0.2e1 * t172);
  t246 = my_piecewise3(t17, 0, 0.10e2 / 0.9e1 * t238 * t78 + 0.5e1 / 0.3e1 * t19 * t242);
  t247 = t246 * t23;
  t251 = t124 * t86;
  t253 = t6 * t251 * t40;
  t255 = t6 * t125;
  t261 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t247 * t40 + t253 / 0.10e2 - t255 * t97 / 0.36e2 + t186 / 0.10e2 - t196 - t198 / 0.54e2);
  t262 = t210 * t132;
  t266 = my_piecewise3(t48, 0, 0.2e1 * t214);
  t270 = my_piecewise3(t53, 0, 0.10e2 / 0.9e1 * t262 * t104 + 0.5e1 / 0.3e1 * t55 * t266);
  t271 = t270 * t23;
  t275 = t135 * t86;
  t277 = t6 * t275 * t69;
  t280 = t6 * t108;
  t283 = t6 * t112;
  t284 = t283 * t146;
  t287 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t271 * t69 + t277 / 0.10e2 + t228 / 0.10e2 - t233 - t280 * t146 / 0.36e2 - t284 / 0.54e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t101 + t117 + t130 + t150 + t7 * (t261 + t287);

  t292 = t121 * t121;
  t297 = my_piecewise3(t11, 0, 0.2e1 * t75 + 0.2e1 * t172);
  t301 = my_piecewise3(t17, 0, 0.10e2 / 0.9e1 * t166 * t292 + 0.5e1 / 0.3e1 * t19 * t297);
  t302 = t301 * t23;
  t308 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t302 * t40 + t253 / 0.5e1 - t196);
  t309 = t132 * t132;
  t314 = my_piecewise3(t48, 0, -0.2e1 * t75 + 0.2e1 * t214);
  t318 = my_piecewise3(t53, 0, 0.10e2 / 0.9e1 * t210 * t309 + 0.5e1 / 0.3e1 * t55 * t314);
  t319 = t318 * t23;
  t324 = t6 * t136;
  t328 = t60 * t60;
  t330 = 0.1e1 / t62 / t328;
  t333 = t59 * t330 * t31 * t36;
  t337 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t319 * t69 + t277 / 0.5e1 - t324 * t146 / 0.18e2 - t233 - t284 / 0.27e2 + 0.11e2 / 0.108e3 * t140 * t333);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t130 + 0.2e1 * t150 + t7 * (t308 + t337);

  t343 = t197 * t155 / 0.144e3;
  t345 = params->lambda * t94 * t154;
  t349 = my_piecewise3(t1, 0, t188 * t155 / 0.96e2 + t343 - t91 * t345 / 0.36e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = t7 * t349 + t158;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  t354 = t283 * t160 / 0.144e3;
  t356 = my_piecewise3(t45, 0, t280 * t160 / 0.96e2 + t354);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = t7 * t356 + t163;

  t361 = my_piecewise3(t1, 0, t255 * t155 / 0.96e2 + t343);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = t7 * t361 + t158;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  t366 = params->lambda * t143 * t154;
  t370 = my_piecewise3(t45, 0, t324 * t160 / 0.96e2 + t354 - t140 * t366 / 0.36e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = t7 * t370 + t163;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = 0.0e0;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t375 = 0.1e1 / t18 / t16;
  t376 = t167 * t78;
  t379 = t166 * t78;
  t382 = t74 * t74;
  t383 = 0.1e1 / t382;
  t384 = t13 * t383;
  t387 = my_piecewise3(t11, 0, 0.6e1 * t171 - 0.6e1 * t384);
  t391 = my_piecewise3(t17, 0, -0.10e2 / 0.27e2 * t375 * t376 + 0.10e2 / 0.3e1 * t379 * t175 + 0.5e1 / 0.3e1 * t19 * t387);
  t392 = t391 * t23;
  t396 = t179 * t86;
  t398 = t6 * t396 * t40;
  t400 = t6 * t180;
  t403 = t81 * t192;
  t405 = t6 * t403 * t40;
  t407 = t6 * t184;
  t408 = t407 * t97;
  t413 = 0.1e1 / t22 / t74;
  t414 = t21 * t413;
  t417 = 0.2e1 / 0.45e2 * t6 * t414 * t40;
  t418 = t6 * t193;
  t419 = t418 * t97;
  t421 = t197 * t205;
  t425 = 0.1e1 / t28 / t200 / rho[0];
  t428 = t25 * t425 * t31 * t36;
  t432 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t392 * t40 + 0.3e1 / 0.10e2 * t398 - t400 * t97 / 0.12e2 - t405 / 0.10e2 - t408 / 0.9e1 + 0.11e2 / 0.36e2 * t188 * t205 + t417 + t419 / 0.54e2 + 0.11e2 / 0.54e2 * t421 - 0.77e2 / 0.162e3 * t91 * t428);
  t434 = 0.1e1 / t54 / t52;
  t435 = t211 * t104;
  t438 = t210 * t104;
  t441 = t49 * t383;
  t444 = my_piecewise3(t48, 0, -0.6e1 * t171 - 0.6e1 * t441);
  t448 = my_piecewise3(t53, 0, -0.10e2 / 0.27e2 * t434 * t435 + 0.10e2 / 0.3e1 * t438 * t217 + 0.5e1 / 0.3e1 * t55 * t444);
  t449 = t448 * t23;
  t453 = t221 * t86;
  t455 = t6 * t453 * t69;
  t457 = t107 * t192;
  t459 = t6 * t457 * t69;
  t461 = t57 * t413;
  t464 = 0.2e1 / 0.45e2 * t6 * t461 * t69;
  t466 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t449 * t69 + 0.3e1 / 0.10e2 * t455 - t459 / 0.10e2 + t464);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t209 + 0.3e1 * t235 + t7 * (t432 + t466);

  t469 = 0.2e1 * t261;
  t470 = 0.2e1 * t287;
  t471 = t375 * t121;
  t474 = t166 * t242;
  t479 = 0.2e1 * t171;
  t480 = 0.6e1 * t384;
  t482 = my_piecewise3(t11, 0, t479 - t480);
  t486 = my_piecewise3(t17, 0, -0.10e2 / 0.27e2 * t471 * t167 + 0.20e2 / 0.9e1 * t474 * t78 + 0.10e2 / 0.9e1 * t238 * t175 + 0.5e1 / 0.3e1 * t19 * t482);
  t487 = t486 * t23;
  t491 = t246 * t86;
  t494 = t6 * t491 * t40 / 0.5e1;
  t495 = t6 * t247;
  t498 = t124 * t192;
  t500 = t6 * t498 * t40;
  t502 = t6 * t251;
  t504 = t502 * t97 / 0.27e2;
  t512 = 0.3e1 / 0.20e2 * t6 * t487 * t40 + t494 - t495 * t97 / 0.18e2 - t500 / 0.30e2 - t504 + 0.11e2 / 0.108e3 * t255 * t205 + t398 / 0.10e2 - t405 / 0.15e2 - t408 / 0.27e2 + t417 + t419 / 0.81e2 + 0.11e2 / 0.162e3 * t421;
  t513 = my_piecewise3(t1, 0, t512);
  t514 = t434 * t132;
  t517 = t210 * t266;
  t522 = 0.6e1 * t441;
  t524 = my_piecewise3(t48, 0, -t479 - t522);
  t528 = my_piecewise3(t53, 0, -0.10e2 / 0.27e2 * t514 * t211 + 0.20e2 / 0.9e1 * t517 * t104 + 0.10e2 / 0.9e1 * t262 * t217 + 0.5e1 / 0.3e1 * t55 * t524);
  t529 = t528 * t23;
  t533 = t270 * t86;
  t536 = t6 * t533 * t69 / 0.5e1;
  t537 = t135 * t192;
  t539 = t6 * t537 * t69;
  t543 = t6 * t222;
  t546 = t6 * t226;
  t548 = t546 * t146 / 0.27e2;
  t549 = t6 * t230;
  t550 = t549 * t146;
  t553 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t529 * t69 + t536 - t539 / 0.30e2 + t455 / 0.10e2 - t459 / 0.15e2 + t464 - t543 * t146 / 0.36e2 - t548 + t550 / 0.162e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t209 + t235 + t469 + t470 + t7 * (t513 + t553);

  t556 = t375 * t292;
  t561 = t166 * t297;
  t565 = my_piecewise3(t11, 0, -t479 - t480);
  t569 = my_piecewise3(t17, 0, -0.10e2 / 0.27e2 * t556 * t78 + 0.20e2 / 0.9e1 * t238 * t242 + 0.10e2 / 0.9e1 * t561 * t78 + 0.5e1 / 0.3e1 * t19 * t565);
  t570 = t569 * t23;
  t574 = t301 * t86;
  t576 = t6 * t574 * t40;
  t578 = t6 * t302;
  t585 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t570 * t40 + t576 / 0.10e2 - t578 * t97 / 0.36e2 + t494 - t500 / 0.15e2 - t504 - t405 / 0.30e2 + t417 + t419 / 0.162e3);
  t586 = t434 * t309;
  t591 = t210 * t314;
  t595 = my_piecewise3(t48, 0, t479 - t522);
  t599 = my_piecewise3(t53, 0, -0.10e2 / 0.27e2 * t586 * t104 + 0.20e2 / 0.9e1 * t262 * t266 + 0.10e2 / 0.9e1 * t591 * t104 + 0.5e1 / 0.3e1 * t55 * t595);
  t600 = t599 * t23;
  t604 = t318 * t86;
  t606 = t6 * t604 * t69;
  t609 = t6 * t271;
  t612 = t6 * t275;
  t613 = t612 * t146;
  t619 = t283 * t333;
  t621 = 0.3e1 / 0.20e2 * t6 * t600 * t69 + t606 / 0.10e2 + t536 - t539 / 0.15e2 - t609 * t146 / 0.18e2 - t613 / 0.27e2 - t459 / 0.30e2 + t464 - t548 + t550 / 0.81e2 + 0.11e2 / 0.108e3 * t280 * t333 + 0.11e2 / 0.162e3 * t619;
  t622 = my_piecewise3(t45, 0, t621);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t469 + t470 + t308 + t337 + t7 * (t585 + t622);

  t627 = t292 * t121;
  t634 = my_piecewise3(t11, 0, -0.6e1 * t171 - 0.6e1 * t384);
  t638 = my_piecewise3(t17, 0, -0.10e2 / 0.27e2 * t375 * t627 + 0.10e2 / 0.3e1 * t238 * t297 + 0.5e1 / 0.3e1 * t19 * t634);
  t639 = t638 * t23;
  t646 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t639 * t40 + 0.3e1 / 0.10e2 * t576 - t500 / 0.10e2 + t417);
  t647 = t309 * t132;
  t654 = my_piecewise3(t48, 0, 0.6e1 * t171 - 0.6e1 * t441);
  t658 = my_piecewise3(t53, 0, -0.10e2 / 0.27e2 * t434 * t647 + 0.10e2 / 0.3e1 * t262 * t314 + 0.5e1 / 0.3e1 * t55 * t654);
  t659 = t658 * t23;
  t664 = t6 * t319;
  t675 = 0.1e1 / t62 / t328 / rho[1];
  t678 = t59 * t675 * t31 * t36;
  t682 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t659 * t69 + 0.3e1 / 0.10e2 * t606 - t664 * t146 / 0.12e2 - t539 / 0.10e2 - t613 / 0.9e1 + 0.11e2 / 0.36e2 * t324 * t333 + t464 + t550 / 0.54e2 + 0.11e2 / 0.54e2 * t619 - 0.77e2 / 0.162e3 * t140 * t678);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t308 + 0.3e1 * t337 + t7 * (t646 + t682);

  t688 = t407 * t155;
  t693 = t418 * t155 / 0.432e3;
  t694 = t197 * t345;
  t697 = params->lambda * t202 * t154;
  t701 = my_piecewise3(t1, 0, t400 * t155 / 0.96e2 + t688 / 0.72e2 - t188 * t345 / 0.18e2 - t693 - t694 / 0.27e2 + 0.11e2 / 0.108e3 * t91 * t697);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = t7 * t701 + 0.2e1 * t349;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  t706 = t546 * t160;
  t709 = t549 * t160 / 0.432e3;
  t711 = my_piecewise3(t45, 0, t543 * t160 / 0.96e2 + t706 / 0.72e2 - t709);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = t7 * t711 + 0.2e1 * t356;

  t715 = t502 * t155;
  t722 = my_piecewise3(t1, 0, t495 * t155 / 0.96e2 + t715 / 0.144e3 - t255 * t345 / 0.36e2 + t688 / 0.144e3 - t693 - t694 / 0.54e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = t7 * t722 + t349 + t361;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  t726 = t612 * t160;
  t731 = t283 * t366;
  t734 = my_piecewise3(t45, 0, t609 * t160 / 0.96e2 + t726 / 0.144e3 + t706 / 0.144e3 - t709 - t280 * t366 / 0.36e2 - t731 / 0.54e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = t7 * t734 + t356 + t370;

  t741 = my_piecewise3(t1, 0, t578 * t155 / 0.96e2 + t715 / 0.72e2 - t693);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = t7 * t741 + 0.2e1 * t361;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  t751 = params->lambda * t330 * t154;
  t755 = my_piecewise3(t45, 0, t664 * t160 / 0.96e2 + t726 / 0.72e2 - t324 * t366 / 0.18e2 - t709 - t731 / 0.27e2 + 0.11e2 / 0.108e3 * t140 * t751);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = t7 * t755 + 0.2e1 * t370;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = 0.0e0;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t761 = t6 * t391 * t86 * t40;
  t765 = t6 * t179 * t192 * t40;
  t769 = t6 * t81 * t413 * t40;
  t772 = 0.1e1 / t22 / t170;
  t776 = 0.14e2 / 0.135e3 * t6 * t21 * t772 * t40;
  t777 = t16 * t16;
  t779 = 0.1e1 / t18 / t777;
  t780 = t167 * t167;
  t786 = t175 * t175;
  t792 = 0.1e1 / t382 / t7;
  t793 = t13 * t792;
  t796 = my_piecewise3(t11, 0, -0.24e2 * t383 + 0.24e2 * t793);
  t800 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t779 * t780 - 0.20e2 / 0.9e1 * t375 * t167 * t175 + 0.10e2 / 0.3e1 * t166 * t786 + 0.40e2 / 0.9e1 * t379 * t387 + 0.5e1 / 0.3e1 * t19 * t796);
  t805 = t418 * t205;
  t807 = t197 * t428;
  t819 = t407 * t205;
  t823 = t6 * t392;
  t826 = t6 * t396;
  t827 = t826 * t97;
  t829 = t6 * t403;
  t830 = t829 * t97;
  t832 = t6 * t414;
  t833 = t832 * t97;
  t835 = 0.2e1 / 0.5e1 * t761 - t765 / 0.5e1 + 0.8e1 / 0.45e2 * t769 - t776 + 0.3e1 / 0.20e2 * t6 * t800 * t23 * t40 - 0.11e2 / 0.81e2 * t805 - 0.308e3 / 0.243e3 * t807 + 0.1309e4 / 0.486e3 * t91 * t25 / t28 / t200 / t26 * t31 * t36 + 0.11e2 / 0.18e2 * t400 * t205 + 0.22e2 / 0.27e2 * t819 - 0.154e3 / 0.81e2 * t188 * t428 - t823 * t97 / 0.9e1 - 0.2e1 / 0.9e1 * t827 + 0.2e1 / 0.27e2 * t830 - 0.8e1 / 0.243e3 * t833;
  t836 = my_piecewise3(t1, 0, t835);
  t837 = t52 * t52;
  t839 = 0.1e1 / t54 / t837;
  t840 = t211 * t211;
  t846 = t217 * t217;
  t851 = t49 * t792;
  t854 = my_piecewise3(t48, 0, 0.24e2 * t383 + 0.24e2 * t851);
  t858 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t839 * t840 - 0.20e2 / 0.9e1 * t434 * t211 * t217 + 0.10e2 / 0.3e1 * t210 * t846 + 0.40e2 / 0.9e1 * t438 * t444 + 0.5e1 / 0.3e1 * t55 * t854);
  t865 = t6 * t448 * t86 * t69;
  t869 = t6 * t221 * t192 * t69;
  t873 = t6 * t107 * t413 * t69;
  t878 = 0.14e2 / 0.135e3 * t6 * t57 * t772 * t69;
  t880 = my_piecewise3(t45, 0, 0.3e1 / 0.20e2 * t6 * t858 * t23 * t69 + 0.2e1 / 0.5e1 * t865 - t869 / 0.5e1 + 0.8e1 / 0.45e2 * t873 - t878);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t432 + 0.4e1 * t466 + t7 * (t836 + t880);

  t887 = t6 * t486 * t86 * t40;
  t891 = t6 * t246 * t192 * t40;
  t892 = t891 / 0.10e2;
  t895 = t6 * t124 * t413 * t40;
  t916 = 0.12e2 * t383;
  t917 = 0.24e2 * t793;
  t919 = my_piecewise3(t11, 0, -t916 + t917);
  t923 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t779 * t121 * t376 - 0.10e2 / 0.9e1 * t375 * t242 * t167 - 0.10e2 / 0.9e1 * t471 * t78 * t175 + 0.10e2 / 0.3e1 * t166 * t482 * t78 + 0.10e2 / 0.3e1 * t474 * t175 + 0.10e2 / 0.9e1 * t238 * t387 + 0.5e1 / 0.3e1 * t19 * t919);
  t928 = t502 * t205;
  t940 = t6 * t487;
  t943 = t6 * t491;
  t944 = t943 * t97;
  t946 = t6 * t498;
  t947 = t946 * t97;
  t948 = t947 / 0.54e2;
  t949 = 0.3e1 / 0.10e2 * t887 - t892 + 0.2e1 / 0.45e2 * t895 + t761 / 0.10e2 - t765 / 0.10e2 + 0.2e1 / 0.15e2 * t769 - t776 + 0.3e1 / 0.20e2 * t6 * t923 * t23 * t40 + 0.11e2 / 0.54e2 * t928 - 0.77e2 / 0.162e3 * t255 * t428 - 0.11e2 / 0.162e3 * t805 - 0.77e2 / 0.243e3 * t807 + 0.11e2 / 0.36e2 * t495 * t205 + 0.11e2 / 0.54e2 * t819 - t827 / 0.18e2 + t830 / 0.27e2 - 0.2e1 / 0.81e2 * t833 - t940 * t97 / 0.12e2 - t944 / 0.9e1 + t948;
  t950 = my_piecewise3(t1, 0, t949);
  t967 = 0.24e2 * t851;
  t969 = my_piecewise3(t48, 0, t916 + t967);
  t973 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t839 * t132 * t435 - 0.10e2 / 0.9e1 * t434 * t266 * t211 - 0.10e2 / 0.9e1 * t514 * t104 * t217 + 0.10e2 / 0.3e1 * t210 * t524 * t104 + 0.10e2 / 0.3e1 * t517 * t217 + 0.10e2 / 0.9e1 * t262 * t444 + 0.5e1 / 0.3e1 * t55 * t969);
  t980 = t6 * t528 * t86 * t69;
  t984 = t6 * t270 * t192 * t69;
  t985 = t984 / 0.10e2;
  t988 = t6 * t135 * t413 * t69;
  t993 = t6 * t449;
  t996 = t6 * t453;
  t997 = t996 * t146;
  t999 = t6 * t457;
  t1000 = t999 * t146;
  t1001 = t1000 / 0.54e2;
  t1002 = t6 * t461;
  t1003 = t1002 * t146;
  t1005 = 0.3e1 / 0.20e2 * t6 * t973 * t23 * t69 + 0.3e1 / 0.10e2 * t980 - t985 + 0.2e1 / 0.45e2 * t988 + t865 / 0.10e2 - t869 / 0.10e2 + 0.2e1 / 0.15e2 * t873 - t878 - t993 * t146 / 0.36e2 - t997 / 0.18e2 + t1001 - 0.2e1 / 0.243e3 * t1003;
  t1006 = my_piecewise3(t45, 0, t1005);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t432 + t466 + 0.3e1 * t513 + 0.3e1 * t553 + t7 * (t950 + t1006);

  t1015 = t6 * t301 * t192 * t40;
  t1022 = t6 * t569 * t86 * t40;
  t1034 = t242 * t242;
  t1047 = my_piecewise3(t11, 0, t917);
  t1051 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t779 * t292 * t167 - 0.40e2 / 0.27e2 * t471 * t78 * t242 - 0.10e2 / 0.27e2 * t556 * t175 + 0.20e2 / 0.9e1 * t166 * t1034 + 0.20e2 / 0.9e1 * t238 * t482 - 0.10e2 / 0.27e2 * t375 * t297 * t167 + 0.20e2 / 0.9e1 * t166 * t565 * t78 + 0.10e2 / 0.9e1 * t561 * t175 + 0.5e1 / 0.3e1 * t19 * t1047);
  t1064 = t6 * t570;
  t1067 = t6 * t574;
  t1068 = t1067 * t97;
  t1070 = -t1015 / 0.30e2 + t887 / 0.5e1 - 0.2e1 / 0.15e2 * t891 + 0.4e1 / 0.45e2 * t895 + t1022 / 0.5e1 - t765 / 0.30e2 + 0.4e1 / 0.45e2 * t769 - t776 + 0.3e1 / 0.20e2 * t6 * t1051 * t23 * t40 + 0.11e2 / 0.108e3 * t578 * t205 + 0.11e2 / 0.81e2 * t928 - 0.11e2 / 0.486e3 * t805 + t830 / 0.81e2 - 0.4e1 / 0.243e3 * t833 - 0.2e1 / 0.27e2 * t944 + 0.2e1 / 0.81e2 * t947 - t1064 * t97 / 0.18e2 - t1068 / 0.27e2;
  t1071 = my_piecewise3(t1, 0, t1070);
  t1080 = t266 * t266;
  t1093 = my_piecewise3(t48, 0, t967);
  t1097 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t839 * t309 * t211 - 0.40e2 / 0.27e2 * t514 * t104 * t266 - 0.10e2 / 0.27e2 * t586 * t217 + 0.20e2 / 0.9e1 * t210 * t1080 + 0.20e2 / 0.9e1 * t262 * t524 - 0.10e2 / 0.27e2 * t434 * t314 * t211 + 0.20e2 / 0.9e1 * t210 * t595 * t104 + 0.10e2 / 0.9e1 * t591 * t217 + 0.5e1 / 0.3e1 * t55 * t1093);
  t1104 = t6 * t599 * t86 * t69;
  t1108 = t6 * t318 * t192 * t69;
  t1113 = t6 * t529;
  t1116 = t6 * t533;
  t1117 = t1116 * t146;
  t1119 = t6 * t537;
  t1120 = t1119 * t146;
  t1129 = t546 * t333;
  t1131 = t549 * t333;
  t1133 = 0.3e1 / 0.20e2 * t6 * t1097 * t23 * t69 + t1104 / 0.5e1 - t1108 / 0.30e2 + t980 / 0.5e1 - 0.2e1 / 0.15e2 * t984 + 0.4e1 / 0.45e2 * t988 - t1113 * t146 / 0.18e2 - 0.2e1 / 0.27e2 * t1117 + t1120 / 0.81e2 - t869 / 0.30e2 + 0.4e1 / 0.45e2 * t873 - t878 - t997 / 0.27e2 + 0.2e1 / 0.81e2 * t1000 - 0.4e1 / 0.243e3 * t1003 + 0.11e2 / 0.108e3 * t543 * t333 + 0.11e2 / 0.81e2 * t1129 - 0.11e2 / 0.486e3 * t1131;
  t1134 = my_piecewise3(t45, 0, t1133);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t513 + 0.2e1 * t553 + 0.2e1 * t585 + 0.2e1 * t622 + t7 * (t1071 + t1134);

  t1155 = my_piecewise3(t11, 0, t916 + t917);
  t1159 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t779 * t627 * t78 - 0.10e2 / 0.9e1 * t556 * t242 - 0.10e2 / 0.9e1 * t471 * t297 * t78 + 0.10e2 / 0.3e1 * t474 * t297 + 0.10e2 / 0.3e1 * t238 * t565 + 0.10e2 / 0.9e1 * t166 * t634 * t78 + 0.5e1 / 0.3e1 * t19 * t1155);
  t1166 = t6 * t638 * t86 * t40;
  t1168 = t6 * t639;
  t1177 = 0.3e1 / 0.20e2 * t6 * t1159 * t23 * t40 + t1166 / 0.10e2 - t1168 * t97 / 0.36e2 + 0.3e1 / 0.10e2 * t1022 - t1015 / 0.10e2 - t1068 / 0.18e2 - t892 + 0.2e1 / 0.15e2 * t895 + t948 + 0.2e1 / 0.45e2 * t769 - t776 - 0.2e1 / 0.243e3 * t833;
  t1178 = my_piecewise3(t1, 0, t1177);
  t1195 = my_piecewise3(t48, 0, -t916 + t967);
  t1199 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t839 * t647 * t104 - 0.10e2 / 0.9e1 * t586 * t266 - 0.10e2 / 0.9e1 * t514 * t314 * t104 + 0.10e2 / 0.3e1 * t517 * t314 + 0.10e2 / 0.3e1 * t262 * t595 + 0.10e2 / 0.9e1 * t210 * t654 * t104 + 0.5e1 / 0.3e1 * t55 * t1195);
  t1206 = t6 * t658 * t86 * t69;
  t1210 = t6 * t600;
  t1213 = t6 * t604;
  t1214 = t1213 * t146;
  t1221 = t612 * t333;
  t1229 = t283 * t678;
  t1231 = 0.3e1 / 0.20e2 * t6 * t1199 * t23 * t69 + t1206 / 0.10e2 + 0.3e1 / 0.10e2 * t1104 - t1108 / 0.10e2 - t1210 * t146 / 0.12e2 - t1214 / 0.18e2 - t985 + 0.2e1 / 0.15e2 * t988 - t1117 / 0.9e1 + t1120 / 0.27e2 + 0.11e2 / 0.36e2 * t609 * t333 + 0.11e2 / 0.54e2 * t1221 + 0.2e1 / 0.45e2 * t873 - t878 + t1001 - 0.2e1 / 0.81e2 * t1003 + 0.11e2 / 0.54e2 * t1129 - 0.11e2 / 0.162e3 * t1131 - 0.77e2 / 0.162e3 * t280 * t678 - 0.77e2 / 0.243e3 * t1229;
  t1232 = my_piecewise3(t45, 0, t1231);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t585 + 0.3e1 * t622 + t646 + t682 + t7 * (t1178 + t1232);

  t1237 = t292 * t292;
  t1242 = t297 * t297;
  t1249 = my_piecewise3(t11, 0, 0.24e2 * t383 + 0.24e2 * t793);
  t1253 = my_piecewise3(t17, 0, 0.40e2 / 0.81e2 * t779 * t1237 - 0.20e2 / 0.9e1 * t556 * t297 + 0.10e2 / 0.3e1 * t166 * t1242 + 0.40e2 / 0.9e1 * t238 * t634 + 0.5e1 / 0.3e1 * t19 * t1249);
  t1262 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t1253 * t23 * t40 + 0.2e1 / 0.5e1 * t1166 - t1015 / 0.5e1 + 0.8e1 / 0.45e2 * t895 - t776);
  t1266 = t309 * t309;
  t1271 = t314 * t314;
  t1278 = my_piecewise3(t48, 0, -0.24e2 * t383 + 0.24e2 * t851);
  t1282 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t839 * t1266 - 0.20e2 / 0.9e1 * t586 * t314 + 0.10e2 / 0.3e1 * t210 * t1271 + 0.40e2 / 0.9e1 * t262 * t654 + 0.5e1 / 0.3e1 * t55 * t1278);
  t1305 = t6 * t659;
  t1308 = -t1108 / 0.5e1 + 0.2e1 / 0.5e1 * t1206 + 0.8e1 / 0.45e2 * t988 - t878 + 0.3e1 / 0.20e2 * t6 * t1282 * t23 * t69 + 0.1309e4 / 0.486e3 * t140 * t59 / t62 / t328 / t60 * t31 * t36 + 0.11e2 / 0.18e2 * t664 * t333 - 0.154e3 / 0.81e2 * t324 * t678 - 0.2e1 / 0.9e1 * t1214 + 0.22e2 / 0.27e2 * t1221 - 0.308e3 / 0.243e3 * t1229 + 0.2e1 / 0.27e2 * t1120 - 0.11e2 / 0.81e2 * t1131 - 0.8e1 / 0.243e3 * t1003 - t1305 * t146 / 0.9e1;
  t1309 = my_piecewise3(t45, 0, t1308);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t646 + 0.4e1 * t682 + t7 * (t1262 + t1309);

  t1315 = t826 * t155;
  t1319 = t829 * t155;
  t1321 = t407 * t345;
  t1326 = t832 * t155 / 0.324e3;
  t1327 = t418 * t345;
  t1329 = t197 * t697;
  t1336 = my_piecewise3(t1, 0, t823 * t155 / 0.96e2 + t1315 / 0.48e2 - t400 * t345 / 0.12e2 - t1319 / 0.144e3 - t1321 / 0.9e1 + 0.11e2 / 0.36e2 * t188 * t697 + t1326 + t1327 / 0.54e2 + 0.11e2 / 0.54e2 * t1329 - 0.77e2 / 0.162e3 * t91 * params->lambda * t425 * t154);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = t7 * t1336 + 0.3e1 * t701;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  t1341 = t996 * t160;
  t1343 = t999 * t160;
  t1346 = t1002 * t160 / 0.324e3;
  t1348 = my_piecewise3(t45, 0, t993 * t160 / 0.96e2 + t1341 / 0.48e2 - t1343 / 0.144e3 + t1346);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = t7 * t1348 + 0.3e1 * t711;

  t1350 = 0.2e1 * t722;
  t1354 = t943 * t155 / 0.72e2;
  t1357 = t946 * t155;
  t1360 = t502 * t345 / 0.27e2;
  t1368 = t940 * t155 / 0.96e2 + t1354 - t495 * t345 / 0.18e2 - t1357 / 0.432e3 - t1360 + 0.11e2 / 0.108e3 * t255 * t697 + t1315 / 0.144e3 - t1319 / 0.216e3 - t1321 / 0.27e2 + t1326 + t1327 / 0.81e2 + 0.11e2 / 0.162e3 * t1329;
  t1369 = my_piecewise3(t1, 0, t1368);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = t7 * t1369 + t1350 + t701;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  t1371 = 0.2e1 * t734;
  t1375 = t1116 * t160 / 0.72e2;
  t1376 = t1119 * t160;
  t1383 = t546 * t366 / 0.27e2;
  t1384 = t549 * t366;
  t1387 = my_piecewise3(t45, 0, t1113 * t160 / 0.96e2 + t1375 - t1376 / 0.432e3 + t1341 / 0.144e3 - t1343 / 0.216e3 + t1346 - t543 * t366 / 0.36e2 - t1383 + t1384 / 0.162e3);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = t7 * t1387 + t1371 + t711;

  t1391 = t1067 * t155;
  t1399 = my_piecewise3(t1, 0, t1064 * t155 / 0.96e2 + t1391 / 0.144e3 - t578 * t345 / 0.36e2 + t1354 - t1357 / 0.216e3 - t1360 - t1319 / 0.432e3 + t1326 + t1327 / 0.162e3);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = t7 * t1399 + t1350 + t741;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  t1403 = t1213 * t160;
  t1408 = t612 * t366;
  t1414 = t283 * t751;
  t1416 = t1210 * t160 / 0.96e2 + t1403 / 0.144e3 + t1375 - t1376 / 0.216e3 - t609 * t366 / 0.18e2 - t1408 / 0.27e2 - t1343 / 0.432e3 + t1346 - t1383 + t1384 / 0.81e2 + 0.11e2 / 0.108e3 * t280 * t751 + 0.11e2 / 0.162e3 * t1414;
  t1417 = my_piecewise3(t45, 0, t1416);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = t7 * t1417 + t1371 + t755;

  t1425 = my_piecewise3(t1, 0, t1168 * t155 / 0.96e2 + t1391 / 0.48e2 - t1357 / 0.144e3 + t1326);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = t7 * t1425 + 0.3e1 * t741;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  t1444 = my_piecewise3(t45, 0, t1305 * t160 / 0.96e2 + t1403 / 0.48e2 - t664 * t366 / 0.12e2 - t1376 / 0.144e3 - t1408 / 0.9e1 + 0.11e2 / 0.36e2 * t324 * t751 + t1346 + t1384 / 0.54e2 + 0.11e2 / 0.54e2 * t1414 - 0.77e2 / 0.162e3 * t140 * params->lambda * t675 * t154);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = t7 * t1444 + 0.3e1 * t755;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = 0.0e0;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

