/*****************************************************************************

    TRAVIS - Trajectory Analyzer and Visualizer

    http://www.travis-analyzer.de/

    Copyright (c) 2009-2021 Martin Brehm
                  2012-2021 Martin Thomas
                  2016-2021 Sascha Gehrke

    Please cite:  J. Chem. Phys. 2020, 152 (16), 164105.         (DOI 10.1063/5.0005078 )
                  J. Chem. Inf. Model. 2011, 51 (8), 2007-2023.  (DOI 10.1021/ci200217w )

    This file was written by Martin Brehm and Martin Thomas.

    ---------------------------------------------------------------------------

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/


#ifndef TETRAPAK_H
#define TETRAPAK_H


// This must always be the first include directive
#include "config.h"

#include <vector>

#include "tools.h"
#include "xdmatrix3.h"
#include "xdvec3array.h"
#include "snapshot.h"



#define VORI_EPS 1.0E-11



class CTetraFace;



class CTetraPak {
public:

	CTetraPak() : m_hitCount(NULL) {
	}

	~CTetraPak() {
		if (m_hitCount != NULL) {
			delete[] m_hitCount;
			m_hitCount = NULL;
		}
	}


	bool Init( CSnapshot *snap, int ifac );

	bool ProcessStep( CSnapshot *snap, bool sanity );

	bool WriteEMPFrame( CSnapshot *snap, const char *s, int step );

	bool m_bIntegrateCharge;
	bool m_bIntegrateDipoleMoment;
	bool m_bIntegrateQuadrupoleMoment;
	bool m_bIntegrateTotalCurrent;
	bool m_bIntegrateMagneticMoment;

	
	std::vector<CTetraFace*> m_oaFaces;
	int m_fRayCount;
	int m_fRayHisto[4];
	int *m_hitCount;
	int m_iFaces;
	bool m_bInterpolation;
	int m_iInterpolationFactor;
	int m_iInterpolationFactorCube;


private:
	void integrateCell(CSnapshot *electronDensity, CSnapshot *currentDensity, double mi[2], double ma[2], double refPoint[3], double *charge, CxDVector3 *dipoleMoment, CxDMatrix3 *quadrupoleMoment, CxDVector3 *totalCurrent, CxDVector3 *magneticMoment, bool sanity = false );
	
};



class CTetraFace {
public:

	CTetraFace() {
	}

	~CTetraFace() {
	}


	bool XRay_Hit( const CSnapshot *snap, double py, double pz, double &px ) const;


	CxDVector3 m_vCenter;
	CxDVector3 m_vSpan1;
	CxDVector3 m_vSpan2;
	CxDVector3 m_vNormal;

	CxDVec3Array m_vaEdges;
	std::vector<double> m_faEdgesLength;

	double m_fMin[2];
	double m_fMax[2];
};




#endif
