

#include "config.h"

#include <string.h>

#include "tools.h"
#include "snapshot.h"



bool CSnapshot::ReadCube(const char *s) {

	FILE *a;
	int z, ix, iy, iz, ac;
	char buf[256], *p, *q;
	double tf;
	double mi, ma, sum;
	CSnapshotAtom *ap;


	libvori_printf( LV_PL_VERBOSE, "    ------------------------------------------------------\n");
	libvori_printf( LV_PL_VERBOSE, "        CSnapshot::ReadCube(): Reading cube file \"%s\"...\n",s);
	a = fopen(s,"rt");
	if (a == NULL) {
		libvori_printf( LV_PL_ERROR, "CSnapshot::ReadCube(): Error: Could not open \"%s\" for reading.\n",s);
		return false;
	}

	fgets(buf,256,a);
	p = &buf[strlen(buf)-1];
	while ((*p == '\r') || (*p == '\n'))
		p--;
	p++;
	*p = 0;
	libvori_printf( LV_PL_VERBOSE, "        Comment line 1:  \"%s\"\n",buf);
	fgets(buf,256,a);
	p = &buf[strlen(buf)-1];
	while ((*p == '\r') || (*p == '\n'))
		p--;
	p++;
	*p = 0;
	libvori_printf( LV_PL_VERBOSE, "        Comment line 2:  \"%s\"\n",buf);


	fgets(buf,256,a);
	p = buf;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	ac = atoi(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fCenter[0] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fCenter[1] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while ((*q != ' ') && (*q != '\r') && (*q != '\n') && (*q != 0))
		q++;
	*q = 0;
	m_fCenter[2] = atof(p);


	fgets(buf,256,a);
	p = buf;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_iRes[0] = atoi(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fStrideA[0] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fStrideA[1] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while ((*q != ' ') && (*q != '\r') && (*q != '\n') && (*q != 0))
		q++;
	*q = 0;
	m_fStrideA[2] = atof(p);


	fgets(buf,256,a);
	p = buf;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_iRes[1] = atoi(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fStrideB[0] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fStrideB[1] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while ((*q != ' ') && (*q != '\r') && (*q != '\n') && (*q != 0))
		q++;
	*q = 0;
	m_fStrideB[2] = atof(p);


	fgets(buf,256,a);
	p = buf;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_iRes[2] = atoi(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fStrideC[0] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while (*q != ' ')
		q++;
	*q = 0;
	m_fStrideC[1] = atof(p);
	p = q+1;
	while (*p == ' ')
		p++;
	q = p;
	while ((*q != ' ') && (*q != '\r') && (*q != '\n') && (*q != 0))
		q++;
	*q = 0;
	m_fStrideC[2] = atof(p);

	for (z=0;z<3;z++) {
		m_fCenter[z]  *= LEN_AU2PM;
		m_fStrideA[z] *= LEN_AU2PM;
		m_fStrideB[z] *= LEN_AU2PM;
		m_fStrideC[z] *= LEN_AU2PM;
	}

	m_fCellVecA[0] = m_fStrideA[0] * m_iRes[0];
	m_fCellVecA[1] = m_fStrideA[1] * m_iRes[0];
	m_fCellVecA[2] = m_fStrideA[2] * m_iRes[0];
	m_fCellVecB[0] = m_fStrideB[0] * m_iRes[1];
	m_fCellVecB[1] = m_fStrideB[1] * m_iRes[1];
	m_fCellVecB[2] = m_fStrideB[2] * m_iRes[1];
	m_fCellVecC[0] = m_fStrideC[0] * m_iRes[2];
	m_fCellVecC[1] = m_fStrideC[1] * m_iRes[2];
	m_fCellVecC[2] = m_fStrideC[2] * m_iRes[2];

	if ((m_fCellVecA[1] != 0) || (m_fCellVecA[2] != 0) || (m_fCellVecB[0] != 0) || (m_fCellVecB[2] != 0) || (m_fCellVecC[0] != 0) || (m_fCellVecC[1] != 0))
		m_bBoxNonOrtho = true;
	else
		m_bBoxNonOrtho = false;

	libvori_printf( LV_PL_VERBOSE, "        Resolution:  %d x %d x %d\n",m_iRes[0],m_iRes[1],m_iRes[2]);
	libvori_printf( LV_PL_VERBOSE, "        Center:      %10.6f  %10.6f  %10.6f\n",m_fCenter[0],m_fCenter[1],m_fCenter[2]);
	libvori_printf( LV_PL_VERBOSE, "        Stride A:    %10.6f  %10.6f  %10.6f\n",m_fStrideA[0],m_fStrideA[1],m_fStrideA[2]);
	libvori_printf( LV_PL_VERBOSE, "        Stride B:    %10.6f  %10.6f  %10.6f\n",m_fStrideB[0],m_fStrideB[1],m_fStrideB[2]);
	libvori_printf( LV_PL_VERBOSE, "        Stride C:    %10.6f  %10.6f  %10.6f\n",m_fStrideC[0],m_fStrideC[1],m_fStrideC[2]);
	libvori_printf( LV_PL_VERBOSE, "        Vector A:    %10.6f  %10.6f  %10.6f\n",m_fCellVecA[0],m_fCellVecA[1],m_fCellVecA[2]);
	libvori_printf( LV_PL_VERBOSE, "        Vector B:    %10.6f  %10.6f  %10.6f\n",m_fCellVecB[0],m_fCellVecB[1],m_fCellVecB[2]);
	libvori_printf( LV_PL_VERBOSE, "        Vector C:    %10.6f  %10.6f  %10.6f\n",m_fCellVecC[0],m_fCellVecC[1],m_fCellVecC[2]);
	libvori_printf( LV_PL_VERBOSE, "        Atom count:  %d\n",ac);

	libvori_printf( LV_PL_VERBOSE, "        Reading atom positions...\n");

	for (z=0;z<ac;z++) {

		ap = new CSnapshotAtom();

		fgets(buf,256,a);
		p = buf;
		while (*p == ' ')
			p++;
		q = p;
		while (*q != ' ')
			q++;
		*q = 0;
		ap->m_iOrd = atoi(p);
		p = q+1;
		while (*p == ' ')
			p++;
		q = p;
		while (*q != ' ')
			q++;
		*q = 0;
		p = q+1;
		while (*p == ' ')
			p++;
		q = p;
		while (*q != ' ')
			q++;
		*q = 0;
		ap->m_vPos[0] = atof(p) * LEN_AU2PM;
		p = q+1;
		while (*p == ' ')
			p++;
		q = p;
		while (*q != ' ')
			q++;
		*q = 0;
		ap->m_vPos[1] = atof(p) * LEN_AU2PM;
		p = q+1;
		while (*p == ' ')
			p++;
		q = p;
		while ((*q != ' ') && (*q != '\r') && (*q != '\n') && (*q != 0))
			q++;
		*q = 0;
		ap->m_vPos[2] = atof(p) * LEN_AU2PM;

		m_oaAtoms.push_back(ap);
	}

	if (feof(a)) {
		libvori_printf( LV_PL_ERROR, "CSnapshot::ReadCube(): Error: Unexpected end of cube file.\n");
		fclose(a);
		return false;
	}

	m_pBin = new double[m_iRes[0]*m_iRes[1]*m_iRes[2]];

	libvori_printf( LV_PL_VERBOSE, "        Reading volumetric data...\n");
	libvori_printf( LV_PL_VERBOSE, "          [");

	ix = 0;
	iy = 0;
	iz = 0;

	mi = 1.0e30;
	ma = -1.0e30;
	sum = 0;

	while (!feof(a)) {
_read:
		fgets(buf,256,a);
		if (feof(a))
			break;
		p = buf;

_next:
		while (*p == ' ')
			p++;
		q = p;
		while ((*p != ' ') && (*p != '\n') && (*p != 0))
			p++;
		if ((p-q) < 5)
			goto _read;

		*p = 0;

		#ifdef FAST_ATOF
			tf = fast_atof(q);
		#else
			tf = atof(q);
		#endif

		if (tf < mi)
			mi = tf;
		if (tf > ma)
			ma = tf;
		sum += tf;

		m_pBin[iz*m_iRes[0]*m_iRes[1]+iy*m_iRes[0]+ix] = tf;

		iz++;
		if (iz >= m_iRes[2]) {
			iz = 0;
			iy++;
			if (iy >= m_iRes[1]) {
				iy = 0;
				ix++;
				if (fmod(ix,m_iRes[0]/60.0) < 1.0)
					libvori_printf( LV_PL_VERBOSE, "#");
			}
		}

		if (ix == m_iRes[0])
			break;

		p++;
		goto _next;
	}

	if (feof(a)) {
		libvori_printf( LV_PL_ERROR, "CSnapshot::ReadCube(): Error: Unexpected end of cube file stream.\n");
		fclose(a);
		return false;
	}

	libvori_printf( LV_PL_VERBOSE, "]\n");

	fclose(a);

	libvori_printf( LV_PL_VERBOSE, "        Finished reading cube file.\n");
	libvori_printf( LV_PL_VERBOSE, "        The value range is %.6f .. %.6f\n",mi,ma);
	libvori_printf( LV_PL_VERBOSE, "        Sum = %.10E, Integral = %.10E.\n",sum,sum*m_fStrideA[0]*m_fStrideB[1]*m_fStrideC[2]/LEN_AU2PM/LEN_AU2PM/LEN_AU2PM);
	libvori_printf( LV_PL_VERBOSE, "    ------------------------------------------------------\n");

	return true;
}



void CSnapshot::WriteCube(const char *s) {

	FILE *a;
	int z, zi, ix, iy, iz, ti;
	double tfs, tf, tmi, tma;


	a = fopen(s,"wt");
	if (a == NULL) {
		libvori_printf( LV_PL_ERROR, "CSnapshot::WriteCube(): Error: Could not open \"%s\" for writing.\n",s);
		return;
	}

	fprintf(a,"Gaussian Cube File\n");
	fprintf(a,"Written by libvori, (c) Martin Brehm, 2020\n");


	ti = (int)m_oaAtoms.size();
	if (ti == 0)
		ti = 1;

	fprintf(
		a,
		"%10d  %10.6f  %10.6f  %10.6f\n",
		ti,
		m_fCenter[0] / LEN_BOHR2ANGSTROM,
		m_fCenter[1] / LEN_BOHR2ANGSTROM,
		m_fCenter[2] / LEN_BOHR2ANGSTROM
	);

	fprintf(
		a,
		"%10d  %10.6f  %10.6f  %10.6f\n",
		m_iRes[0],
		m_fStrideA[0] / LEN_BOHR2ANGSTROM,
		m_fStrideA[1] / LEN_BOHR2ANGSTROM,
		m_fStrideA[2] / LEN_BOHR2ANGSTROM
	);

	fprintf(
		a,
		"%10d  %10.6f  %10.6f  %10.6f\n",
		m_iRes[1],
		m_fStrideB[0] / LEN_BOHR2ANGSTROM,
		m_fStrideB[1] / LEN_BOHR2ANGSTROM,
		m_fStrideB[2] / LEN_BOHR2ANGSTROM
	);

	fprintf(
		a,
		"%10d  %10.6f  %10.6f  %10.6f\n",
		m_iRes[2],
		m_fStrideC[0] / LEN_BOHR2ANGSTROM,
		m_fStrideC[1] / LEN_BOHR2ANGSTROM,
		m_fStrideC[2] / LEN_BOHR2ANGSTROM
	);


	for (z=0;z<(int)m_oaAtoms.size();z++)
		fprintf(
			a,
			"%10d  0.00  %10.6f  %10.6f  %10.6f\n",
			m_oaAtoms[z]->m_iOrd,
			m_oaAtoms[z]->m_vPos[0] / LEN_BOHR2ANGSTROM,
			m_oaAtoms[z]->m_vPos[1] / LEN_BOHR2ANGSTROM,
			m_oaAtoms[z]->m_vPos[2] / LEN_BOHR2ANGSTROM
		);

	if (m_oaAtoms.size() == 0)
		fprintf(a,"0 0 0 0 0\n");


	libvori_printf( LV_PL_VERBOSE, "      [");

	tfs = (m_iRes[0]*m_iRes[1]*m_iRes[2])/60.0;
	z = 0;
	zi = 0;
	tmi = 1.0e300;
	tma = -1.0e300;
	for (ix=0;ix<m_iRes[0];ix++) {
		for (iy=0;iy<m_iRes[1];iy++) {
			for (iz=0;iz<m_iRes[2];iz++) {
				tf = m_pBin[iz*m_iRes[0]*m_iRes[1]+iy*m_iRes[0]+ix];
				// Limit to two-digit exponents
				if ((tf > 0) && (tf < 1.0e-98))
					tf = 1.0e-98;
				if ((tf < 0) && (tf > -1.0e-98))
					tf = -1.0e-98;
				if (tf > 1.0e98)
					tf = 1.0e98;
				if (tf < -1.0e98)
					tf = -1.0e98;
				if (tf > tma)
					tma = tf;
				if (tf < tmi)
					tmi = tf;
				fprintf(
					a,
					"  %11.5E",
					tf
				);
				z++;
				zi++;
				if (zi == 6) {
					fprintf(a,"\n");
					zi = 0;
				}
				if (fmod(z,tfs) < 1.0)
					libvori_printf( LV_PL_VERBOSE, "#");
			}
			if (zi != 0) {
				fprintf(a,"\n");
				zi = 0;
			}
		}
	}

	fclose(a);

	libvori_printf( LV_PL_VERBOSE, "] Done.\n");
	libvori_printf( LV_PL_VERBOSE, "    Min value: %.10e\n",tmi);
	libvori_printf( LV_PL_VERBOSE, "    Max value: %.10e\n",tma);
}



void CSnapshot::SetUnityRadii() {

	int z;

	for (z=0;z<(int)m_oaAtoms.size();z++)
		m_oaAtoms[z]->m_fRadius = 1.0;
}



void CSnapshot::SetCovalentRadii() {

	int z, z2;

	for (z=0;z<(int)m_oaAtoms.size();z++) {
		for (z2=0;z2<(int)glv_oaElements.size();z2++) {
			if (glv_oaElements[z2]->m_iOrd == m_oaAtoms[z]->m_iOrd) {
				m_oaAtoms[z]->m_fRadius = glv_oaElements[z2]->m_fRCov;
				goto _done;
			}
		}
		libvori_printf( LV_PL_WARNING, "Warning: Did not find element entry for ordinal number %d, using radius of 100 pm.\n", m_oaAtoms[z]->m_iOrd );
		m_oaAtoms[z]->m_fRadius = 100.0;
_done:;
	}
}



void CSnapshot::SetVdWRadii() {

	int z, z2;

	for (z=0;z<(int)m_oaAtoms.size();z++) {
		for (z2=0;z2<(int)glv_oaElements.size();z2++) {
			if (glv_oaElements[z2]->m_iOrd == m_oaAtoms[z]->m_iOrd) {
				m_oaAtoms[z]->m_fRadius = glv_oaElements[z2]->m_fRVdW;
				goto _done;
			}
		}
		libvori_printf( LV_PL_WARNING, "Warning: Did not find element entry for ordinal number %d, using radius of 100 pm.\n", m_oaAtoms[z]->m_iOrd );
		m_oaAtoms[z]->m_fRadius = 100.0;
_done:;
	}
}



void CSnapshot::SetCustomRadii( double factor, const double *r ) {

	int z;

	for (z=0;z<(int)m_oaAtoms.size();z++)
		m_oaAtoms[z]->m_fRadius = factor * r[z];
}



void CSnapshot::GuessLabels() {

	int z, z2;

	for (z=0;z<(int)m_oaAtoms.size();z++) {
		for (z2=0;z2<(int)glv_oaElements.size();z2++) {
			if (glv_oaElements[z2]->m_iOrd == m_oaAtoms[z]->m_iOrd) {
				m_oaAtoms[z]->m_sLabel = glv_oaElements[z2]->m_sLabel;
				goto _done;
			}
		}
		libvori_printf( LV_PL_WARNING, "Warning: Found element entry for ordinal number %d, using radius of 100 pm.\n", m_oaAtoms[z]->m_iOrd );
		m_oaAtoms[z]->m_sLabel = "X";
_done:;
	}
}




