

#ifndef SNAPSHOT_H
#define SNAPSHOT_H


#include "config.h"

#include <vector>
#include <string>

#include "xdvector3.h"
#include "xdmatrix3.h"



class CSnapshotAtom {
public:

	CSnapshotAtom() : m_fCoreCharge(0), m_iOrd(0), m_fRadius(0), m_fCharge(0), m_vChargeCenter(0) {
	}

	~CSnapshotAtom() {
	}

	CxDVector3 m_vPos;
	CxDVector3 m_vWrappedPos;
	double m_fCoreCharge;
	int m_iOrd;
	double m_fRadius;
	double m_fCharge;
	CxDVector3 m_vDipole;
	CxDVector3 m_vChargeCenter;
	CxDMatrix3 m_mQuadrupole;
	std::string m_sLabel;
};



class CSnapshot {
public:

	CSnapshot() : m_pBin(NULL), m_bBoxNonOrtho(false) {
	}

	~CSnapshot() {
		for (int z=0;z<(int)m_oaAtoms.size();z++)
			delete m_oaAtoms[z];
		m_oaAtoms.clear();
		if (m_pBin != NULL) {
			delete[] m_pBin;
			m_pBin = NULL;
		}
	}


	int m_iRes[3];
	double m_fStrideA[3];
	double m_fStrideB[3];
	double m_fStrideC[3];
	double m_fCellVecA[3];
	double m_fCellVecB[3];
	double m_fCellVecC[3];
	double m_fCenter[3];
	double *m_pBin;

	bool m_bBoxNonOrtho;

	CxDMatrix3 m_mBoxToOrtho;
	CxDMatrix3 m_mBoxFromOrtho;

	std::vector<CSnapshotAtom*> m_oaAtoms;

	bool ReadCube( const char *s );

	void WriteCube( const char *s );

	void SetUnityRadii();

	void SetCovalentRadii();

	void SetVdWRadii();

	void SetCustomRadii( double factor, const double *r );

	void GuessLabels();
};



#endif


