
#include "config.h"

#include "tools.h"
#include "bqb.h"

#include <stdarg.h>
#include <time.h>

#ifdef _MSC_VER
	#include <windows.h>
#else
	#include <unistd.h>
#endif



int glv_iPrintLevel = LV_PL_INFO;

FILE *glv_fLogFile = NULL;

char *glv_pPrintPrefix = NULL;

CTetraPak *glv_pTetraPak = NULL;
CSnapshot *glv_pSnapshot = NULL;

int glv_iVoroMemory = 16;

std::vector<double> glv_faVoronoiRadii;

bool glv_bNewLine = true;

std::vector<CElement*> glv_oaElements;

int glv_iInitialized = 0;

int glv_iInterpolation = 1;

int glv_iStepCounter = 0;

CBQBInterface *glv_pBQBInterface = NULL;

bool glv_bEMPOutput = false;

bool glv_bVoronoi = true;
bool glv_bVoronoiSkipFirstFrame = false;
int glv_iVoronoiStepCounter = 0;

bool glv_bBQBInitialized = false;
int glv_iBQBOptimization = 0;
int glv_iBQBHistory = 0;
char *glv_pBQBFilename = NULL;
CBQBInterface *glv_BIF = NULL;
CBQBVolHeader *glv_pBQBVolHead = NULL;
CBQBFileWriter *glv_pBQBFile = NULL;
int glv_iBQBStepCounter = 0;
bool glv_bBQBSkipFirstFrame = false;
char *glv_pBQBParmString = NULL;
bool glv_bBQBStoreStep = true;
bool glv_bBQBCheck = false;



void libvori_printf( int level, const char *s, ... ) {

	va_list args;
	char buf[16384], *p, *q, *end;


	if (level > glv_iPrintLevel)
		return;

	buf[16383] = 0;
	va_start (args, s);
	vsprintf(buf,s,args);
	va_end (args);
	if (buf[16383] != 0) {
		printf("libvori_printf(): Error: String too long!\n\n");
		buf[16383] = 0;
		printf("\"%s\"\n\n",buf);
		abort();
	}

	if (glv_bNewLine && (glv_pPrintPrefix != NULL))
		printf( "%s", glv_pPrintPrefix );

	glv_bNewLine = false;

	if (strlen(buf) > 0) {

		end = &buf[strlen(buf)-1];

		if (*end == '\n')
			glv_bNewLine = true;

		p = buf;

		while (p < end) {

			q = strchr(p,'\n');

			if ((q == NULL) || (q == end))
				break;

			*q = 0;
			printf( "%s\n", p );
			printf( "%s", glv_pPrintPrefix );
			p = q+1;
		}

		printf( "%s", p );
		fflush(stdout);
	}

	if (glv_fLogFile != NULL) {
		va_start (args, s);
		vfprintf(glv_fLogFile,s,args);
		va_end (args);
		fflush(glv_fLogFile);
	}
}



char *FormatBytes(double i) {

	static char buf[64], buf2[64];

	if (i < 0) {
		buf2[0] = '-';
		buf2[1] = 0;
		i = fabs(i);
	} else buf2[0] = 0;
	if (i > 1024.0*1024.0*1024.0*2.0)
		sprintf(buf,"%.2f GiB",i/1024.0/1024.0/1024.0);
	else if (i > 1024.0*1024.0*2.0)
		sprintf(buf,"%.2f MiB",i/1024.0/1024.0);
	else if (i > 1024.0*2.0)
		sprintf(buf,"%.2f KiB",i/1024.0);
	else
		sprintf(buf,"%.0f Bytes",i);
	strcat(buf2,buf);
	return buf2;
}



void AddElement( const char *label, int ord, double mass, double rcov, double rvdw ) {

	CElement *el;

	el = new CElement();
	strcpy( el->m_sLabel, label );
	el->m_fMass = mass;
	el->m_iOrd = ord;
	el->m_fRVdW = rvdw;
	el->m_fRCov = rcov;
	
	glv_oaElements.push_back( el );
}



void WriteHeader() {

	struct tm *today;
	time_t ltime;
	char buf[256];
	unsigned long tul=0;
	bool b;


	UNUSED(tul);

	if (glv_bVoronoi) {

		libvori_printf( LV_PL_INFO, "---------------------------------------------------------------\n");
		libvori_printf( LV_PL_INFO, "   LibVori - Electromagnetic Moments via Voronoi Integration\n");
		libvori_printf( LV_PL_INFO, "---------------------------------------------------------------\n");
		libvori_printf( LV_PL_INFO, "Copyright (c) Martin Brehm, University of Halle (Saale), 2020.\n");
		libvori_printf( LV_PL_INFO, "              https://brehm-research.de/voronoi\n");
		libvori_printf( LV_PL_INFO, "Free software under GNU LGPL v3, based on Voro++ by C. Rycroft.\n");
		libvori_printf( LV_PL_INFO, "Please cite: * Phys. Chem. Chem. Phys. 2015, 17, 3207-3213.\n");
		libvori_printf( LV_PL_INFO, "             * J. Chem. Inf. Model. 2018, 58 (10), 2092-2107.\n");
		libvori_printf( LV_PL_INFO, "             * Chaos 2009, 19, 041111.\n");
		libvori_printf( LV_PL_INFO, "---------------------------------------------------------------\n");

	} else {

		libvori_printf( LV_PL_INFO, "---------------------------------------------------------------------\n");
		libvori_printf( LV_PL_INFO, "   LibBQB - Lossless Compression of Volumetric Data Trajectories\n");
		libvori_printf( LV_PL_INFO, "---------------------------------------------------------------------\n");
		libvori_printf( LV_PL_INFO, "Copyright (c) Martin Brehm, University of Halle (Saale), 2018-2020.\n");
		libvori_printf( LV_PL_INFO, "              https://brehm-research.de/bqb\n");
		libvori_printf( LV_PL_INFO, "Free software under GNU LGPL v3.\n");
		libvori_printf( LV_PL_INFO, "Please cite:  J. Chem. Inf. Model. 2018, 58 (10), 2092-2107.\n");
		libvori_printf( LV_PL_INFO, "---------------------------------------------------------------------\n");
	}

	libvori_printf( LV_PL_INFO, "Running" );

	#ifdef _MSC_VER
		tul = 256;
		if (!GetComputerNameA(buf,&tul))
			buf[0] = 0;
	#else
		if (!gethostname(buf,256)==0)
			buf[0] = 0;
	#endif

	if (buf[0] != 0)
		libvori_printf( LV_PL_INFO, " on %s",buf);

	time(&ltime);
	today = localtime(&ltime);
	strcpy(buf,asctime(today));
	buf[strlen(buf)-1] = 0;

	libvori_printf( LV_PL_INFO, " at %s",buf);

	#ifdef _MSC_VER
		libvori_printf( LV_PL_INFO, " (PID %d)\n",GetCurrentProcessId());
	#else
		libvori_printf( LV_PL_INFO, " (PID %d)\n",getpid());
	#endif

	libvori_printf( LV_PL_INFO, "Version ");
	libvori_printf( LV_PL_INFO, "%s",SOURCE_VERSION);

	libvori_printf( LV_PL_INFO, ", built at ");
	libvori_printf( LV_PL_INFO, "%s",__DATE__);

	#if defined(__VERSION) || defined(__GNUC__) || defined(_MSC_VER) || defined(__clang__) || defined(__llvm__)
		libvori_printf( LV_PL_INFO, ", compiler");
		b = false;
		#ifdef __VERSION__
			libvori_printf( LV_PL_INFO, " \"%s\"",__VERSION__);
			b = true;
		#endif
		#ifdef __llvm__
			if (b)
				libvori_printf( LV_PL_INFO, ",");
			libvori_printf( LV_PL_INFO, " LLVM");
			b = true;
		#endif
		#ifdef __clang__
			if (b)
				libvori_printf( LV_PL_INFO, ",");
			#if defined(__clang_major__) && defined(__clang_minor__) && defined(__clang_patchlevel__)
				libvori_printf( LV_PL_INFO, " CLANG %d.%d.%d",__clang_major__,__clang_minor__,__clang_patchlevel__);
			#elif defined(__clang_version__)
				libvori_printf( LV_PL_INFO, " CLANG \"%s\"",__clang_version__);
			#else
				libvori_printf( LV_PL_INFO, " CLANG");
			#endif
			b = true;
		#endif
		#ifdef __GNUC__
			if (b)
				libvori_printf( LV_PL_INFO, ",");
			#ifdef __MINGW32__
				libvori_printf( LV_PL_INFO, " MinGW GCC %d.%d.%d",__GNUC__,__GNUC_MINOR__,__GNUC_PATCHLEVEL__);
			#else
				libvori_printf( LV_PL_INFO, " GCC %d.%d.%d",__GNUC__,__GNUC_MINOR__,__GNUC_PATCHLEVEL__);
			#endif
			b = true;
		#endif
		#ifdef _MSC_VER
			if (b)
				libvori_printf( LV_PL_INFO, ",");
			libvori_printf( LV_PL_INFO, " MSVC++ ");
			// See  https://docs.microsoft.com/de-de/cpp/preprocessor/predefined-macros?view=vs-2019
			switch(_MSC_VER) {
				case 1928: libvori_printf( LV_PL_INFO, "16.8, VS 2019"); break;
				case 1927: libvori_printf( LV_PL_INFO, "16.7, VS 2019"); break;
				case 1926: libvori_printf( LV_PL_INFO, "16.6, VS 2019"); break;
				case 1925: libvori_printf( LV_PL_INFO, "16.5, VS 2019"); break;
				case 1924: libvori_printf( LV_PL_INFO, "16.4, VS 2019"); break;
				case 1923: libvori_printf( LV_PL_INFO, "16.3, VS 2019"); break;
				case 1922: libvori_printf( LV_PL_INFO, "16.2, VS 2019"); break;
				case 1921: libvori_printf( LV_PL_INFO, "16.1, VS 2019"); break;
				case 1920: libvori_printf( LV_PL_INFO, "16.0, VS 2019"); break;
				case 1916: libvori_printf( LV_PL_INFO, "15.9, VS 2017"); break;
				case 1915: libvori_printf( LV_PL_INFO, "15.8, VS 2017"); break;
				case 1914: libvori_printf( LV_PL_INFO, "15.7, VS 2017"); break;
				case 1913: libvori_printf( LV_PL_INFO, "15.6, VS 2017"); break;
				case 1912: libvori_printf( LV_PL_INFO, "15.5, VS 2017"); break;
				case 1911: libvori_printf( LV_PL_INFO, "15.3, VS 2017"); break;
				case 1910: libvori_printf( LV_PL_INFO, "15.1, VS 2017"); break;
				case 1900: libvori_printf( LV_PL_INFO, "14.0, VS 2015"); break;
				case 1800: libvori_printf( LV_PL_INFO, "12.0, VS 2013"); break;
				case 1700: libvori_printf( LV_PL_INFO, "11.0, VS 2012"); break;
				case 1600: libvori_printf( LV_PL_INFO, "10.0, VS 2010"); break;
				case 1500: libvori_printf( LV_PL_INFO, "9.0, VS 2008"); break;
				case 1400: libvori_printf( LV_PL_INFO, "8.0, VS 2005"); break;
				case 1310: libvori_printf( LV_PL_INFO, "7.1, VS 2003"); break;
				case 1300: libvori_printf( LV_PL_INFO, "7.0"); break;
				case 1200: libvori_printf( LV_PL_INFO, "6.0"); break;
				case 1100: libvori_printf( LV_PL_INFO, "5.0"); break;
				default: libvori_printf( LV_PL_INFO, "%d",_MSC_VER); break;
			}
			b = true;
		#endif
	#endif

	libvori_printf( LV_PL_INFO, "\n");
	libvori_printf( LV_PL_INFO, "---------------------------------------------------------------\n");
}



