/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <libint2.h>

#ifdef __cplusplus
extern "C" {
#endif
void HRRPart1bra0ket0kf(const Libint_t* inteval, LIBINT2_REALTYPE* target, const LIBINT2_REALTYPE* src0, const LIBINT2_REALTYPE* src1, int highdim) {

LIBINT2_REALTYPE*const  stack = target;
#ifdef __INTEL_COMPILER
#pragma ivdep
#endif
for(int hsi = 0; hsi<highdim; hsi++) {
{
const int lsi = 0;
{
const int vi = 0;
LIBINT2_REALTYPE fp491;
fp491 = inteval->CD_z[vi] * src1[((hsi*216+67)*1+lsi)*1];
LIBINT2_REALTYPE fp490;
fp490 = src0[((hsi*270+103)*1+lsi)*1] + fp491;
target[((hsi*360+114)*1+lsi)*1] = fp490;
LIBINT2_REALTYPE fp489;
fp489 = inteval->CD_z[vi] * src1[((hsi*216+68)*1+lsi)*1];
LIBINT2_REALTYPE fp488;
fp488 = src0[((hsi*270+104)*1+lsi)*1] + fp489;
target[((hsi*360+115)*1+lsi)*1] = fp488;
LIBINT2_REALTYPE fp487;
fp487 = inteval->CD_y[vi] * src1[((hsi*216+69)*1+lsi)*1];
LIBINT2_REALTYPE fp486;
fp486 = src0[((hsi*270+99)*1+lsi)*1] + fp487;
target[((hsi*360+116)*1+lsi)*1] = fp486;
LIBINT2_REALTYPE fp485;
fp485 = inteval->CD_z[vi] * src1[((hsi*216+69)*1+lsi)*1];
LIBINT2_REALTYPE fp484;
fp484 = src0[((hsi*270+105)*1+lsi)*1] + fp485;
target[((hsi*360+117)*1+lsi)*1] = fp484;
LIBINT2_REALTYPE fp483;
fp483 = inteval->CD_z[vi] * src1[((hsi*216+70)*1+lsi)*1];
LIBINT2_REALTYPE fp482;
fp482 = src0[((hsi*270+106)*1+lsi)*1] + fp483;
target[((hsi*360+118)*1+lsi)*1] = fp482;
LIBINT2_REALTYPE fp481;
fp481 = inteval->CD_z[vi] * src1[((hsi*216+71)*1+lsi)*1];
LIBINT2_REALTYPE fp480;
fp480 = src0[((hsi*270+107)*1+lsi)*1] + fp481;
target[((hsi*360+119)*1+lsi)*1] = fp480;
LIBINT2_REALTYPE fp479;
fp479 = inteval->CD_x[vi] * src1[((hsi*216+72)*1+lsi)*1];
LIBINT2_REALTYPE fp478;
fp478 = src0[((hsi*270+72)*1+lsi)*1] + fp479;
target[((hsi*360+120)*1+lsi)*1] = fp478;
LIBINT2_REALTYPE fp477;
fp477 = inteval->CD_y[vi] * src1[((hsi*216+72)*1+lsi)*1];
LIBINT2_REALTYPE fp476;
fp476 = src0[((hsi*270+102)*1+lsi)*1] + fp477;
target[((hsi*360+121)*1+lsi)*1] = fp476;
LIBINT2_REALTYPE fp475;
fp475 = inteval->CD_z[vi] * src1[((hsi*216+72)*1+lsi)*1];
LIBINT2_REALTYPE fp474;
fp474 = src0[((hsi*270+108)*1+lsi)*1] + fp475;
target[((hsi*360+122)*1+lsi)*1] = fp474;
LIBINT2_REALTYPE fp473;
fp473 = inteval->CD_y[vi] * src1[((hsi*216+73)*1+lsi)*1];
LIBINT2_REALTYPE fp472;
fp472 = src0[((hsi*270+103)*1+lsi)*1] + fp473;
target[((hsi*360+123)*1+lsi)*1] = fp472;
LIBINT2_REALTYPE fp719;
fp719 = inteval->CD_x[vi] * src1[((hsi*216+0)*1+lsi)*1];
LIBINT2_REALTYPE fp718;
fp718 = src0[((hsi*270+0)*1+lsi)*1] + fp719;
target[((hsi*360+0)*1+lsi)*1] = fp718;
LIBINT2_REALTYPE fp469;
fp469 = inteval->CD_z[vi] * src1[((hsi*216+74)*1+lsi)*1];
LIBINT2_REALTYPE fp468;
fp468 = src0[((hsi*270+110)*1+lsi)*1] + fp469;
target[((hsi*360+125)*1+lsi)*1] = fp468;
LIBINT2_REALTYPE fp467;
fp467 = inteval->CD_y[vi] * src1[((hsi*216+75)*1+lsi)*1];
LIBINT2_REALTYPE fp466;
fp466 = src0[((hsi*270+105)*1+lsi)*1] + fp467;
target[((hsi*360+126)*1+lsi)*1] = fp466;
LIBINT2_REALTYPE fp465;
fp465 = inteval->CD_z[vi] * src1[((hsi*216+75)*1+lsi)*1];
LIBINT2_REALTYPE fp464;
fp464 = src0[((hsi*270+111)*1+lsi)*1] + fp465;
target[((hsi*360+127)*1+lsi)*1] = fp464;
LIBINT2_REALTYPE fp463;
fp463 = inteval->CD_z[vi] * src1[((hsi*216+76)*1+lsi)*1];
LIBINT2_REALTYPE fp462;
fp462 = src0[((hsi*270+112)*1+lsi)*1] + fp463;
target[((hsi*360+128)*1+lsi)*1] = fp462;
LIBINT2_REALTYPE fp461;
fp461 = inteval->CD_z[vi] * src1[((hsi*216+77)*1+lsi)*1];
LIBINT2_REALTYPE fp460;
fp460 = src0[((hsi*270+113)*1+lsi)*1] + fp461;
target[((hsi*360+129)*1+lsi)*1] = fp460;
LIBINT2_REALTYPE fp459;
fp459 = inteval->CD_x[vi] * src1[((hsi*216+78)*1+lsi)*1];
LIBINT2_REALTYPE fp458;
fp458 = src0[((hsi*270+78)*1+lsi)*1] + fp459;
target[((hsi*360+130)*1+lsi)*1] = fp458;
LIBINT2_REALTYPE fp457;
fp457 = inteval->CD_y[vi] * src1[((hsi*216+78)*1+lsi)*1];
LIBINT2_REALTYPE fp456;
fp456 = src0[((hsi*270+108)*1+lsi)*1] + fp457;
target[((hsi*360+131)*1+lsi)*1] = fp456;
LIBINT2_REALTYPE fp455;
fp455 = inteval->CD_z[vi] * src1[((hsi*216+78)*1+lsi)*1];
LIBINT2_REALTYPE fp454;
fp454 = src0[((hsi*270+114)*1+lsi)*1] + fp455;
target[((hsi*360+132)*1+lsi)*1] = fp454;
LIBINT2_REALTYPE fp453;
fp453 = inteval->CD_y[vi] * src1[((hsi*216+79)*1+lsi)*1];
LIBINT2_REALTYPE fp452;
fp452 = src0[((hsi*270+109)*1+lsi)*1] + fp453;
target[((hsi*360+133)*1+lsi)*1] = fp452;
LIBINT2_REALTYPE fp451;
fp451 = inteval->CD_z[vi] * src1[((hsi*216+79)*1+lsi)*1];
LIBINT2_REALTYPE fp450;
fp450 = src0[((hsi*270+115)*1+lsi)*1] + fp451;
target[((hsi*360+134)*1+lsi)*1] = fp450;
LIBINT2_REALTYPE fp471;
fp471 = inteval->CD_z[vi] * src1[((hsi*216+73)*1+lsi)*1];
LIBINT2_REALTYPE fp470;
fp470 = src0[((hsi*270+109)*1+lsi)*1] + fp471;
target[((hsi*360+124)*1+lsi)*1] = fp470;
LIBINT2_REALTYPE fp537;
fp537 = inteval->CD_y[vi] * src1[((hsi*216+54)*1+lsi)*1];
LIBINT2_REALTYPE fp536;
fp536 = src0[((hsi*270+78)*1+lsi)*1] + fp537;
target[((hsi*360+91)*1+lsi)*1] = fp536;
LIBINT2_REALTYPE fp535;
fp535 = inteval->CD_z[vi] * src1[((hsi*216+54)*1+lsi)*1];
LIBINT2_REALTYPE fp534;
fp534 = src0[((hsi*270+84)*1+lsi)*1] + fp535;
target[((hsi*360+92)*1+lsi)*1] = fp534;
LIBINT2_REALTYPE fp533;
fp533 = inteval->CD_y[vi] * src1[((hsi*216+55)*1+lsi)*1];
LIBINT2_REALTYPE fp532;
fp532 = src0[((hsi*270+79)*1+lsi)*1] + fp533;
target[((hsi*360+93)*1+lsi)*1] = fp532;
LIBINT2_REALTYPE fp531;
fp531 = inteval->CD_z[vi] * src1[((hsi*216+55)*1+lsi)*1];
LIBINT2_REALTYPE fp530;
fp530 = src0[((hsi*270+85)*1+lsi)*1] + fp531;
target[((hsi*360+94)*1+lsi)*1] = fp530;
LIBINT2_REALTYPE fp529;
fp529 = inteval->CD_z[vi] * src1[((hsi*216+56)*1+lsi)*1];
LIBINT2_REALTYPE fp528;
fp528 = src0[((hsi*270+86)*1+lsi)*1] + fp529;
target[((hsi*360+95)*1+lsi)*1] = fp528;
LIBINT2_REALTYPE fp527;
fp527 = inteval->CD_y[vi] * src1[((hsi*216+57)*1+lsi)*1];
LIBINT2_REALTYPE fp526;
fp526 = src0[((hsi*270+81)*1+lsi)*1] + fp527;
target[((hsi*360+96)*1+lsi)*1] = fp526;
LIBINT2_REALTYPE fp525;
fp525 = inteval->CD_z[vi] * src1[((hsi*216+57)*1+lsi)*1];
LIBINT2_REALTYPE fp524;
fp524 = src0[((hsi*270+87)*1+lsi)*1] + fp525;
target[((hsi*360+97)*1+lsi)*1] = fp524;
LIBINT2_REALTYPE fp523;
fp523 = inteval->CD_z[vi] * src1[((hsi*216+58)*1+lsi)*1];
LIBINT2_REALTYPE fp522;
fp522 = src0[((hsi*270+88)*1+lsi)*1] + fp523;
target[((hsi*360+98)*1+lsi)*1] = fp522;
LIBINT2_REALTYPE fp521;
fp521 = inteval->CD_z[vi] * src1[((hsi*216+59)*1+lsi)*1];
LIBINT2_REALTYPE fp520;
fp520 = src0[((hsi*270+89)*1+lsi)*1] + fp521;
target[((hsi*360+99)*1+lsi)*1] = fp520;
LIBINT2_REALTYPE fp519;
fp519 = inteval->CD_x[vi] * src1[((hsi*216+60)*1+lsi)*1];
LIBINT2_REALTYPE fp518;
fp518 = src0[((hsi*270+60)*1+lsi)*1] + fp519;
target[((hsi*360+100)*1+lsi)*1] = fp518;
LIBINT2_REALTYPE fp493;
fp493 = inteval->CD_y[vi] * src1[((hsi*216+67)*1+lsi)*1];
LIBINT2_REALTYPE fp492;
fp492 = src0[((hsi*270+97)*1+lsi)*1] + fp493;
target[((hsi*360+113)*1+lsi)*1] = fp492;
LIBINT2_REALTYPE fp515;
fp515 = inteval->CD_z[vi] * src1[((hsi*216+60)*1+lsi)*1];
LIBINT2_REALTYPE fp514;
fp514 = src0[((hsi*270+96)*1+lsi)*1] + fp515;
target[((hsi*360+102)*1+lsi)*1] = fp514;
LIBINT2_REALTYPE fp513;
fp513 = inteval->CD_y[vi] * src1[((hsi*216+61)*1+lsi)*1];
LIBINT2_REALTYPE fp512;
fp512 = src0[((hsi*270+91)*1+lsi)*1] + fp513;
target[((hsi*360+103)*1+lsi)*1] = fp512;
LIBINT2_REALTYPE fp511;
fp511 = inteval->CD_z[vi] * src1[((hsi*216+61)*1+lsi)*1];
LIBINT2_REALTYPE fp510;
fp510 = src0[((hsi*270+97)*1+lsi)*1] + fp511;
target[((hsi*360+104)*1+lsi)*1] = fp510;
LIBINT2_REALTYPE fp509;
fp509 = inteval->CD_z[vi] * src1[((hsi*216+62)*1+lsi)*1];
LIBINT2_REALTYPE fp508;
fp508 = src0[((hsi*270+98)*1+lsi)*1] + fp509;
target[((hsi*360+105)*1+lsi)*1] = fp508;
LIBINT2_REALTYPE fp507;
fp507 = inteval->CD_y[vi] * src1[((hsi*216+63)*1+lsi)*1];
LIBINT2_REALTYPE fp506;
fp506 = src0[((hsi*270+93)*1+lsi)*1] + fp507;
target[((hsi*360+106)*1+lsi)*1] = fp506;
LIBINT2_REALTYPE fp505;
fp505 = inteval->CD_z[vi] * src1[((hsi*216+63)*1+lsi)*1];
LIBINT2_REALTYPE fp504;
fp504 = src0[((hsi*270+99)*1+lsi)*1] + fp505;
target[((hsi*360+107)*1+lsi)*1] = fp504;
LIBINT2_REALTYPE fp503;
fp503 = inteval->CD_z[vi] * src1[((hsi*216+64)*1+lsi)*1];
LIBINT2_REALTYPE fp502;
fp502 = src0[((hsi*270+100)*1+lsi)*1] + fp503;
target[((hsi*360+108)*1+lsi)*1] = fp502;
LIBINT2_REALTYPE fp501;
fp501 = inteval->CD_z[vi] * src1[((hsi*216+65)*1+lsi)*1];
LIBINT2_REALTYPE fp500;
fp500 = src0[((hsi*270+101)*1+lsi)*1] + fp501;
target[((hsi*360+109)*1+lsi)*1] = fp500;
LIBINT2_REALTYPE fp499;
fp499 = inteval->CD_x[vi] * src1[((hsi*216+66)*1+lsi)*1];
LIBINT2_REALTYPE fp498;
fp498 = src0[((hsi*270+66)*1+lsi)*1] + fp499;
target[((hsi*360+110)*1+lsi)*1] = fp498;
LIBINT2_REALTYPE fp497;
fp497 = inteval->CD_y[vi] * src1[((hsi*216+66)*1+lsi)*1];
LIBINT2_REALTYPE fp496;
fp496 = src0[((hsi*270+96)*1+lsi)*1] + fp497;
target[((hsi*360+111)*1+lsi)*1] = fp496;
LIBINT2_REALTYPE fp495;
fp495 = inteval->CD_z[vi] * src1[((hsi*216+66)*1+lsi)*1];
LIBINT2_REALTYPE fp494;
fp494 = src0[((hsi*270+102)*1+lsi)*1] + fp495;
target[((hsi*360+112)*1+lsi)*1] = fp494;
LIBINT2_REALTYPE fp517;
fp517 = inteval->CD_y[vi] * src1[((hsi*216+60)*1+lsi)*1];
LIBINT2_REALTYPE fp516;
fp516 = src0[((hsi*270+90)*1+lsi)*1] + fp517;
target[((hsi*360+101)*1+lsi)*1] = fp516;
LIBINT2_REALTYPE fp401;
fp401 = inteval->CD_z[vi] * src1[((hsi*216+95)*1+lsi)*1];
LIBINT2_REALTYPE fp400;
fp400 = src0[((hsi*270+137)*1+lsi)*1] + fp401;
target[((hsi*360+159)*1+lsi)*1] = fp400;
LIBINT2_REALTYPE fp399;
fp399 = inteval->CD_x[vi] * src1[((hsi*216+96)*1+lsi)*1];
LIBINT2_REALTYPE fp398;
fp398 = src0[((hsi*270+96)*1+lsi)*1] + fp399;
target[((hsi*360+160)*1+lsi)*1] = fp398;
LIBINT2_REALTYPE fp397;
fp397 = inteval->CD_y[vi] * src1[((hsi*216+96)*1+lsi)*1];
LIBINT2_REALTYPE fp396;
fp396 = src0[((hsi*270+132)*1+lsi)*1] + fp397;
target[((hsi*360+161)*1+lsi)*1] = fp396;
LIBINT2_REALTYPE fp395;
fp395 = inteval->CD_z[vi] * src1[((hsi*216+96)*1+lsi)*1];
LIBINT2_REALTYPE fp394;
fp394 = src0[((hsi*270+138)*1+lsi)*1] + fp395;
target[((hsi*360+162)*1+lsi)*1] = fp394;
LIBINT2_REALTYPE fp393;
fp393 = inteval->CD_y[vi] * src1[((hsi*216+97)*1+lsi)*1];
LIBINT2_REALTYPE fp392;
fp392 = src0[((hsi*270+133)*1+lsi)*1] + fp393;
target[((hsi*360+163)*1+lsi)*1] = fp392;
LIBINT2_REALTYPE fp391;
fp391 = inteval->CD_z[vi] * src1[((hsi*216+97)*1+lsi)*1];
LIBINT2_REALTYPE fp390;
fp390 = src0[((hsi*270+139)*1+lsi)*1] + fp391;
target[((hsi*360+164)*1+lsi)*1] = fp390;
LIBINT2_REALTYPE fp389;
fp389 = inteval->CD_z[vi] * src1[((hsi*216+98)*1+lsi)*1];
LIBINT2_REALTYPE fp388;
fp388 = src0[((hsi*270+140)*1+lsi)*1] + fp389;
target[((hsi*360+165)*1+lsi)*1] = fp388;
LIBINT2_REALTYPE fp387;
fp387 = inteval->CD_y[vi] * src1[((hsi*216+99)*1+lsi)*1];
LIBINT2_REALTYPE fp386;
fp386 = src0[((hsi*270+135)*1+lsi)*1] + fp387;
target[((hsi*360+166)*1+lsi)*1] = fp386;
LIBINT2_REALTYPE fp385;
fp385 = inteval->CD_z[vi] * src1[((hsi*216+99)*1+lsi)*1];
LIBINT2_REALTYPE fp384;
fp384 = src0[((hsi*270+141)*1+lsi)*1] + fp385;
target[((hsi*360+167)*1+lsi)*1] = fp384;
LIBINT2_REALTYPE fp383;
fp383 = inteval->CD_z[vi] * src1[((hsi*216+100)*1+lsi)*1];
LIBINT2_REALTYPE fp382;
fp382 = src0[((hsi*270+142)*1+lsi)*1] + fp383;
target[((hsi*360+168)*1+lsi)*1] = fp382;
LIBINT2_REALTYPE fp449;
fp449 = inteval->CD_z[vi] * src1[((hsi*216+80)*1+lsi)*1];
LIBINT2_REALTYPE fp448;
fp448 = src0[((hsi*270+116)*1+lsi)*1] + fp449;
target[((hsi*360+135)*1+lsi)*1] = fp448;
LIBINT2_REALTYPE fp379;
fp379 = inteval->CD_x[vi] * src1[((hsi*216+102)*1+lsi)*1];
LIBINT2_REALTYPE fp378;
fp378 = src0[((hsi*270+102)*1+lsi)*1] + fp379;
target[((hsi*360+170)*1+lsi)*1] = fp378;
LIBINT2_REALTYPE fp377;
fp377 = inteval->CD_y[vi] * src1[((hsi*216+102)*1+lsi)*1];
LIBINT2_REALTYPE fp376;
fp376 = src0[((hsi*270+138)*1+lsi)*1] + fp377;
target[((hsi*360+171)*1+lsi)*1] = fp376;
LIBINT2_REALTYPE fp375;
fp375 = inteval->CD_z[vi] * src1[((hsi*216+102)*1+lsi)*1];
LIBINT2_REALTYPE fp374;
fp374 = src0[((hsi*270+144)*1+lsi)*1] + fp375;
target[((hsi*360+172)*1+lsi)*1] = fp374;
LIBINT2_REALTYPE fp373;
fp373 = inteval->CD_y[vi] * src1[((hsi*216+103)*1+lsi)*1];
LIBINT2_REALTYPE fp372;
fp372 = src0[((hsi*270+139)*1+lsi)*1] + fp373;
target[((hsi*360+173)*1+lsi)*1] = fp372;
LIBINT2_REALTYPE fp371;
fp371 = inteval->CD_z[vi] * src1[((hsi*216+103)*1+lsi)*1];
LIBINT2_REALTYPE fp370;
fp370 = src0[((hsi*270+145)*1+lsi)*1] + fp371;
target[((hsi*360+174)*1+lsi)*1] = fp370;
LIBINT2_REALTYPE fp369;
fp369 = inteval->CD_z[vi] * src1[((hsi*216+104)*1+lsi)*1];
LIBINT2_REALTYPE fp368;
fp368 = src0[((hsi*270+146)*1+lsi)*1] + fp369;
target[((hsi*360+175)*1+lsi)*1] = fp368;
LIBINT2_REALTYPE fp367;
fp367 = inteval->CD_y[vi] * src1[((hsi*216+105)*1+lsi)*1];
LIBINT2_REALTYPE fp366;
fp366 = src0[((hsi*270+141)*1+lsi)*1] + fp367;
target[((hsi*360+176)*1+lsi)*1] = fp366;
LIBINT2_REALTYPE fp365;
fp365 = inteval->CD_z[vi] * src1[((hsi*216+105)*1+lsi)*1];
LIBINT2_REALTYPE fp364;
fp364 = src0[((hsi*270+147)*1+lsi)*1] + fp365;
target[((hsi*360+177)*1+lsi)*1] = fp364;
LIBINT2_REALTYPE fp363;
fp363 = inteval->CD_z[vi] * src1[((hsi*216+106)*1+lsi)*1];
LIBINT2_REALTYPE fp362;
fp362 = src0[((hsi*270+148)*1+lsi)*1] + fp363;
target[((hsi*360+178)*1+lsi)*1] = fp362;
LIBINT2_REALTYPE fp361;
fp361 = inteval->CD_z[vi] * src1[((hsi*216+107)*1+lsi)*1];
LIBINT2_REALTYPE fp360;
fp360 = src0[((hsi*270+149)*1+lsi)*1] + fp361;
target[((hsi*360+179)*1+lsi)*1] = fp360;
LIBINT2_REALTYPE fp381;
fp381 = inteval->CD_z[vi] * src1[((hsi*216+101)*1+lsi)*1];
LIBINT2_REALTYPE fp380;
fp380 = src0[((hsi*270+143)*1+lsi)*1] + fp381;
target[((hsi*360+169)*1+lsi)*1] = fp380;
LIBINT2_REALTYPE fp447;
fp447 = inteval->CD_y[vi] * src1[((hsi*216+81)*1+lsi)*1];
LIBINT2_REALTYPE fp446;
fp446 = src0[((hsi*270+111)*1+lsi)*1] + fp447;
target[((hsi*360+136)*1+lsi)*1] = fp446;
LIBINT2_REALTYPE fp445;
fp445 = inteval->CD_z[vi] * src1[((hsi*216+81)*1+lsi)*1];
LIBINT2_REALTYPE fp444;
fp444 = src0[((hsi*270+117)*1+lsi)*1] + fp445;
target[((hsi*360+137)*1+lsi)*1] = fp444;
LIBINT2_REALTYPE fp443;
fp443 = inteval->CD_z[vi] * src1[((hsi*216+82)*1+lsi)*1];
LIBINT2_REALTYPE fp442;
fp442 = src0[((hsi*270+118)*1+lsi)*1] + fp443;
target[((hsi*360+138)*1+lsi)*1] = fp442;
LIBINT2_REALTYPE fp441;
fp441 = inteval->CD_z[vi] * src1[((hsi*216+83)*1+lsi)*1];
LIBINT2_REALTYPE fp440;
fp440 = src0[((hsi*270+119)*1+lsi)*1] + fp441;
target[((hsi*360+139)*1+lsi)*1] = fp440;
LIBINT2_REALTYPE fp439;
fp439 = inteval->CD_x[vi] * src1[((hsi*216+84)*1+lsi)*1];
LIBINT2_REALTYPE fp438;
fp438 = src0[((hsi*270+84)*1+lsi)*1] + fp439;
target[((hsi*360+140)*1+lsi)*1] = fp438;
LIBINT2_REALTYPE fp437;
fp437 = inteval->CD_y[vi] * src1[((hsi*216+84)*1+lsi)*1];
LIBINT2_REALTYPE fp436;
fp436 = src0[((hsi*270+114)*1+lsi)*1] + fp437;
target[((hsi*360+141)*1+lsi)*1] = fp436;
LIBINT2_REALTYPE fp435;
fp435 = inteval->CD_z[vi] * src1[((hsi*216+84)*1+lsi)*1];
LIBINT2_REALTYPE fp434;
fp434 = src0[((hsi*270+120)*1+lsi)*1] + fp435;
target[((hsi*360+142)*1+lsi)*1] = fp434;
LIBINT2_REALTYPE fp433;
fp433 = inteval->CD_y[vi] * src1[((hsi*216+85)*1+lsi)*1];
LIBINT2_REALTYPE fp432;
fp432 = src0[((hsi*270+115)*1+lsi)*1] + fp433;
target[((hsi*360+143)*1+lsi)*1] = fp432;
LIBINT2_REALTYPE fp431;
fp431 = inteval->CD_z[vi] * src1[((hsi*216+85)*1+lsi)*1];
LIBINT2_REALTYPE fp430;
fp430 = src0[((hsi*270+121)*1+lsi)*1] + fp431;
target[((hsi*360+144)*1+lsi)*1] = fp430;
LIBINT2_REALTYPE fp429;
fp429 = inteval->CD_z[vi] * src1[((hsi*216+86)*1+lsi)*1];
LIBINT2_REALTYPE fp428;
fp428 = src0[((hsi*270+122)*1+lsi)*1] + fp429;
target[((hsi*360+145)*1+lsi)*1] = fp428;
LIBINT2_REALTYPE fp403;
fp403 = inteval->CD_z[vi] * src1[((hsi*216+94)*1+lsi)*1];
LIBINT2_REALTYPE fp402;
fp402 = src0[((hsi*270+136)*1+lsi)*1] + fp403;
target[((hsi*360+158)*1+lsi)*1] = fp402;
LIBINT2_REALTYPE fp425;
fp425 = inteval->CD_z[vi] * src1[((hsi*216+87)*1+lsi)*1];
LIBINT2_REALTYPE fp424;
fp424 = src0[((hsi*270+123)*1+lsi)*1] + fp425;
target[((hsi*360+147)*1+lsi)*1] = fp424;
LIBINT2_REALTYPE fp423;
fp423 = inteval->CD_z[vi] * src1[((hsi*216+88)*1+lsi)*1];
LIBINT2_REALTYPE fp422;
fp422 = src0[((hsi*270+124)*1+lsi)*1] + fp423;
target[((hsi*360+148)*1+lsi)*1] = fp422;
LIBINT2_REALTYPE fp421;
fp421 = inteval->CD_z[vi] * src1[((hsi*216+89)*1+lsi)*1];
LIBINT2_REALTYPE fp420;
fp420 = src0[((hsi*270+125)*1+lsi)*1] + fp421;
target[((hsi*360+149)*1+lsi)*1] = fp420;
LIBINT2_REALTYPE fp419;
fp419 = inteval->CD_x[vi] * src1[((hsi*216+90)*1+lsi)*1];
LIBINT2_REALTYPE fp418;
fp418 = src0[((hsi*270+90)*1+lsi)*1] + fp419;
target[((hsi*360+150)*1+lsi)*1] = fp418;
LIBINT2_REALTYPE fp417;
fp417 = inteval->CD_y[vi] * src1[((hsi*216+90)*1+lsi)*1];
LIBINT2_REALTYPE fp416;
fp416 = src0[((hsi*270+126)*1+lsi)*1] + fp417;
target[((hsi*360+151)*1+lsi)*1] = fp416;
LIBINT2_REALTYPE fp415;
fp415 = inteval->CD_z[vi] * src1[((hsi*216+90)*1+lsi)*1];
LIBINT2_REALTYPE fp414;
fp414 = src0[((hsi*270+132)*1+lsi)*1] + fp415;
target[((hsi*360+152)*1+lsi)*1] = fp414;
LIBINT2_REALTYPE fp413;
fp413 = inteval->CD_y[vi] * src1[((hsi*216+91)*1+lsi)*1];
LIBINT2_REALTYPE fp412;
fp412 = src0[((hsi*270+127)*1+lsi)*1] + fp413;
target[((hsi*360+153)*1+lsi)*1] = fp412;
LIBINT2_REALTYPE fp411;
fp411 = inteval->CD_z[vi] * src1[((hsi*216+91)*1+lsi)*1];
LIBINT2_REALTYPE fp410;
fp410 = src0[((hsi*270+133)*1+lsi)*1] + fp411;
target[((hsi*360+154)*1+lsi)*1] = fp410;
LIBINT2_REALTYPE fp409;
fp409 = inteval->CD_z[vi] * src1[((hsi*216+92)*1+lsi)*1];
LIBINT2_REALTYPE fp408;
fp408 = src0[((hsi*270+134)*1+lsi)*1] + fp409;
target[((hsi*360+155)*1+lsi)*1] = fp408;
LIBINT2_REALTYPE fp407;
fp407 = inteval->CD_y[vi] * src1[((hsi*216+93)*1+lsi)*1];
LIBINT2_REALTYPE fp406;
fp406 = src0[((hsi*270+129)*1+lsi)*1] + fp407;
target[((hsi*360+156)*1+lsi)*1] = fp406;
LIBINT2_REALTYPE fp405;
fp405 = inteval->CD_z[vi] * src1[((hsi*216+93)*1+lsi)*1];
LIBINT2_REALTYPE fp404;
fp404 = src0[((hsi*270+135)*1+lsi)*1] + fp405;
target[((hsi*360+157)*1+lsi)*1] = fp404;
LIBINT2_REALTYPE fp427;
fp427 = inteval->CD_y[vi] * src1[((hsi*216+87)*1+lsi)*1];
LIBINT2_REALTYPE fp426;
fp426 = src0[((hsi*270+117)*1+lsi)*1] + fp427;
target[((hsi*360+146)*1+lsi)*1] = fp426;
LIBINT2_REALTYPE fp671;
fp671 = inteval->CD_z[vi] * src1[((hsi*216+13)*1+lsi)*1];
LIBINT2_REALTYPE fp670;
fp670 = src0[((hsi*270+31)*1+lsi)*1] + fp671;
target[((hsi*360+24)*1+lsi)*1] = fp670;
LIBINT2_REALTYPE fp669;
fp669 = inteval->CD_z[vi] * src1[((hsi*216+14)*1+lsi)*1];
LIBINT2_REALTYPE fp668;
fp668 = src0[((hsi*270+32)*1+lsi)*1] + fp669;
target[((hsi*360+25)*1+lsi)*1] = fp668;
LIBINT2_REALTYPE fp667;
fp667 = inteval->CD_y[vi] * src1[((hsi*216+15)*1+lsi)*1];
LIBINT2_REALTYPE fp666;
fp666 = src0[((hsi*270+27)*1+lsi)*1] + fp667;
target[((hsi*360+26)*1+lsi)*1] = fp666;
LIBINT2_REALTYPE fp665;
fp665 = inteval->CD_z[vi] * src1[((hsi*216+15)*1+lsi)*1];
LIBINT2_REALTYPE fp664;
fp664 = src0[((hsi*270+33)*1+lsi)*1] + fp665;
target[((hsi*360+27)*1+lsi)*1] = fp664;
LIBINT2_REALTYPE fp663;
fp663 = inteval->CD_z[vi] * src1[((hsi*216+16)*1+lsi)*1];
LIBINT2_REALTYPE fp662;
fp662 = src0[((hsi*270+34)*1+lsi)*1] + fp663;
target[((hsi*360+28)*1+lsi)*1] = fp662;
LIBINT2_REALTYPE fp661;
fp661 = inteval->CD_z[vi] * src1[((hsi*216+17)*1+lsi)*1];
LIBINT2_REALTYPE fp660;
fp660 = src0[((hsi*270+35)*1+lsi)*1] + fp661;
target[((hsi*360+29)*1+lsi)*1] = fp660;
LIBINT2_REALTYPE fp659;
fp659 = inteval->CD_x[vi] * src1[((hsi*216+18)*1+lsi)*1];
LIBINT2_REALTYPE fp658;
fp658 = src0[((hsi*270+18)*1+lsi)*1] + fp659;
target[((hsi*360+30)*1+lsi)*1] = fp658;
LIBINT2_REALTYPE fp657;
fp657 = inteval->CD_y[vi] * src1[((hsi*216+18)*1+lsi)*1];
LIBINT2_REALTYPE fp656;
fp656 = src0[((hsi*270+36)*1+lsi)*1] + fp657;
target[((hsi*360+31)*1+lsi)*1] = fp656;
LIBINT2_REALTYPE fp655;
fp655 = inteval->CD_z[vi] * src1[((hsi*216+18)*1+lsi)*1];
LIBINT2_REALTYPE fp654;
fp654 = src0[((hsi*270+42)*1+lsi)*1] + fp655;
target[((hsi*360+32)*1+lsi)*1] = fp654;
LIBINT2_REALTYPE fp653;
fp653 = inteval->CD_y[vi] * src1[((hsi*216+19)*1+lsi)*1];
LIBINT2_REALTYPE fp652;
fp652 = src0[((hsi*270+37)*1+lsi)*1] + fp653;
target[((hsi*360+33)*1+lsi)*1] = fp652;
LIBINT2_REALTYPE fp539;
fp539 = inteval->CD_x[vi] * src1[((hsi*216+54)*1+lsi)*1];
LIBINT2_REALTYPE fp538;
fp538 = src0[((hsi*270+54)*1+lsi)*1] + fp539;
target[((hsi*360+90)*1+lsi)*1] = fp538;
LIBINT2_REALTYPE fp649;
fp649 = inteval->CD_z[vi] * src1[((hsi*216+20)*1+lsi)*1];
LIBINT2_REALTYPE fp648;
fp648 = src0[((hsi*270+44)*1+lsi)*1] + fp649;
target[((hsi*360+35)*1+lsi)*1] = fp648;
LIBINT2_REALTYPE fp647;
fp647 = inteval->CD_y[vi] * src1[((hsi*216+21)*1+lsi)*1];
LIBINT2_REALTYPE fp646;
fp646 = src0[((hsi*270+39)*1+lsi)*1] + fp647;
target[((hsi*360+36)*1+lsi)*1] = fp646;
LIBINT2_REALTYPE fp645;
fp645 = inteval->CD_z[vi] * src1[((hsi*216+21)*1+lsi)*1];
LIBINT2_REALTYPE fp644;
fp644 = src0[((hsi*270+45)*1+lsi)*1] + fp645;
target[((hsi*360+37)*1+lsi)*1] = fp644;
LIBINT2_REALTYPE fp643;
fp643 = inteval->CD_z[vi] * src1[((hsi*216+22)*1+lsi)*1];
LIBINT2_REALTYPE fp642;
fp642 = src0[((hsi*270+46)*1+lsi)*1] + fp643;
target[((hsi*360+38)*1+lsi)*1] = fp642;
LIBINT2_REALTYPE fp641;
fp641 = inteval->CD_z[vi] * src1[((hsi*216+23)*1+lsi)*1];
LIBINT2_REALTYPE fp640;
fp640 = src0[((hsi*270+47)*1+lsi)*1] + fp641;
target[((hsi*360+39)*1+lsi)*1] = fp640;
LIBINT2_REALTYPE fp639;
fp639 = inteval->CD_x[vi] * src1[((hsi*216+24)*1+lsi)*1];
LIBINT2_REALTYPE fp638;
fp638 = src0[((hsi*270+24)*1+lsi)*1] + fp639;
target[((hsi*360+40)*1+lsi)*1] = fp638;
LIBINT2_REALTYPE fp637;
fp637 = inteval->CD_y[vi] * src1[((hsi*216+24)*1+lsi)*1];
LIBINT2_REALTYPE fp636;
fp636 = src0[((hsi*270+42)*1+lsi)*1] + fp637;
target[((hsi*360+41)*1+lsi)*1] = fp636;
LIBINT2_REALTYPE fp635;
fp635 = inteval->CD_z[vi] * src1[((hsi*216+24)*1+lsi)*1];
LIBINT2_REALTYPE fp634;
fp634 = src0[((hsi*270+48)*1+lsi)*1] + fp635;
target[((hsi*360+42)*1+lsi)*1] = fp634;
LIBINT2_REALTYPE fp633;
fp633 = inteval->CD_y[vi] * src1[((hsi*216+25)*1+lsi)*1];
LIBINT2_REALTYPE fp632;
fp632 = src0[((hsi*270+43)*1+lsi)*1] + fp633;
target[((hsi*360+43)*1+lsi)*1] = fp632;
LIBINT2_REALTYPE fp631;
fp631 = inteval->CD_z[vi] * src1[((hsi*216+25)*1+lsi)*1];
LIBINT2_REALTYPE fp630;
fp630 = src0[((hsi*270+49)*1+lsi)*1] + fp631;
target[((hsi*360+44)*1+lsi)*1] = fp630;
LIBINT2_REALTYPE fp651;
fp651 = inteval->CD_z[vi] * src1[((hsi*216+19)*1+lsi)*1];
LIBINT2_REALTYPE fp650;
fp650 = src0[((hsi*270+43)*1+lsi)*1] + fp651;
target[((hsi*360+34)*1+lsi)*1] = fp650;
LIBINT2_REALTYPE fp717;
fp717 = inteval->CD_y[vi] * src1[((hsi*216+0)*1+lsi)*1];
LIBINT2_REALTYPE fp716;
fp716 = src0[((hsi*270+6)*1+lsi)*1] + fp717;
target[((hsi*360+1)*1+lsi)*1] = fp716;
LIBINT2_REALTYPE fp715;
fp715 = inteval->CD_z[vi] * src1[((hsi*216+0)*1+lsi)*1];
LIBINT2_REALTYPE fp714;
fp714 = src0[((hsi*270+12)*1+lsi)*1] + fp715;
target[((hsi*360+2)*1+lsi)*1] = fp714;
LIBINT2_REALTYPE fp713;
fp713 = inteval->CD_y[vi] * src1[((hsi*216+1)*1+lsi)*1];
LIBINT2_REALTYPE fp712;
fp712 = src0[((hsi*270+7)*1+lsi)*1] + fp713;
target[((hsi*360+3)*1+lsi)*1] = fp712;
LIBINT2_REALTYPE fp711;
fp711 = inteval->CD_z[vi] * src1[((hsi*216+1)*1+lsi)*1];
LIBINT2_REALTYPE fp710;
fp710 = src0[((hsi*270+13)*1+lsi)*1] + fp711;
target[((hsi*360+4)*1+lsi)*1] = fp710;
LIBINT2_REALTYPE fp709;
fp709 = inteval->CD_z[vi] * src1[((hsi*216+2)*1+lsi)*1];
LIBINT2_REALTYPE fp708;
fp708 = src0[((hsi*270+14)*1+lsi)*1] + fp709;
target[((hsi*360+5)*1+lsi)*1] = fp708;
LIBINT2_REALTYPE fp707;
fp707 = inteval->CD_y[vi] * src1[((hsi*216+3)*1+lsi)*1];
LIBINT2_REALTYPE fp706;
fp706 = src0[((hsi*270+9)*1+lsi)*1] + fp707;
target[((hsi*360+6)*1+lsi)*1] = fp706;
LIBINT2_REALTYPE fp705;
fp705 = inteval->CD_z[vi] * src1[((hsi*216+3)*1+lsi)*1];
LIBINT2_REALTYPE fp704;
fp704 = src0[((hsi*270+15)*1+lsi)*1] + fp705;
target[((hsi*360+7)*1+lsi)*1] = fp704;
LIBINT2_REALTYPE fp703;
fp703 = inteval->CD_z[vi] * src1[((hsi*216+4)*1+lsi)*1];
LIBINT2_REALTYPE fp702;
fp702 = src0[((hsi*270+16)*1+lsi)*1] + fp703;
target[((hsi*360+8)*1+lsi)*1] = fp702;
LIBINT2_REALTYPE fp701;
fp701 = inteval->CD_z[vi] * src1[((hsi*216+5)*1+lsi)*1];
LIBINT2_REALTYPE fp700;
fp700 = src0[((hsi*270+17)*1+lsi)*1] + fp701;
target[((hsi*360+9)*1+lsi)*1] = fp700;
LIBINT2_REALTYPE fp699;
fp699 = inteval->CD_x[vi] * src1[((hsi*216+6)*1+lsi)*1];
LIBINT2_REALTYPE fp698;
fp698 = src0[((hsi*270+6)*1+lsi)*1] + fp699;
target[((hsi*360+10)*1+lsi)*1] = fp698;
LIBINT2_REALTYPE fp673;
fp673 = inteval->CD_y[vi] * src1[((hsi*216+13)*1+lsi)*1];
LIBINT2_REALTYPE fp672;
fp672 = src0[((hsi*270+25)*1+lsi)*1] + fp673;
target[((hsi*360+23)*1+lsi)*1] = fp672;
LIBINT2_REALTYPE fp695;
fp695 = inteval->CD_z[vi] * src1[((hsi*216+6)*1+lsi)*1];
LIBINT2_REALTYPE fp694;
fp694 = src0[((hsi*270+24)*1+lsi)*1] + fp695;
target[((hsi*360+12)*1+lsi)*1] = fp694;
LIBINT2_REALTYPE fp693;
fp693 = inteval->CD_y[vi] * src1[((hsi*216+7)*1+lsi)*1];
LIBINT2_REALTYPE fp692;
fp692 = src0[((hsi*270+19)*1+lsi)*1] + fp693;
target[((hsi*360+13)*1+lsi)*1] = fp692;
LIBINT2_REALTYPE fp691;
fp691 = inteval->CD_z[vi] * src1[((hsi*216+7)*1+lsi)*1];
LIBINT2_REALTYPE fp690;
fp690 = src0[((hsi*270+25)*1+lsi)*1] + fp691;
target[((hsi*360+14)*1+lsi)*1] = fp690;
LIBINT2_REALTYPE fp689;
fp689 = inteval->CD_z[vi] * src1[((hsi*216+8)*1+lsi)*1];
LIBINT2_REALTYPE fp688;
fp688 = src0[((hsi*270+26)*1+lsi)*1] + fp689;
target[((hsi*360+15)*1+lsi)*1] = fp688;
LIBINT2_REALTYPE fp687;
fp687 = inteval->CD_y[vi] * src1[((hsi*216+9)*1+lsi)*1];
LIBINT2_REALTYPE fp686;
fp686 = src0[((hsi*270+21)*1+lsi)*1] + fp687;
target[((hsi*360+16)*1+lsi)*1] = fp686;
LIBINT2_REALTYPE fp685;
fp685 = inteval->CD_z[vi] * src1[((hsi*216+9)*1+lsi)*1];
LIBINT2_REALTYPE fp684;
fp684 = src0[((hsi*270+27)*1+lsi)*1] + fp685;
target[((hsi*360+17)*1+lsi)*1] = fp684;
LIBINT2_REALTYPE fp683;
fp683 = inteval->CD_z[vi] * src1[((hsi*216+10)*1+lsi)*1];
LIBINT2_REALTYPE fp682;
fp682 = src0[((hsi*270+28)*1+lsi)*1] + fp683;
target[((hsi*360+18)*1+lsi)*1] = fp682;
LIBINT2_REALTYPE fp681;
fp681 = inteval->CD_z[vi] * src1[((hsi*216+11)*1+lsi)*1];
LIBINT2_REALTYPE fp680;
fp680 = src0[((hsi*270+29)*1+lsi)*1] + fp681;
target[((hsi*360+19)*1+lsi)*1] = fp680;
LIBINT2_REALTYPE fp679;
fp679 = inteval->CD_x[vi] * src1[((hsi*216+12)*1+lsi)*1];
LIBINT2_REALTYPE fp678;
fp678 = src0[((hsi*270+12)*1+lsi)*1] + fp679;
target[((hsi*360+20)*1+lsi)*1] = fp678;
LIBINT2_REALTYPE fp677;
fp677 = inteval->CD_y[vi] * src1[((hsi*216+12)*1+lsi)*1];
LIBINT2_REALTYPE fp676;
fp676 = src0[((hsi*270+24)*1+lsi)*1] + fp677;
target[((hsi*360+21)*1+lsi)*1] = fp676;
LIBINT2_REALTYPE fp675;
fp675 = inteval->CD_z[vi] * src1[((hsi*216+12)*1+lsi)*1];
LIBINT2_REALTYPE fp674;
fp674 = src0[((hsi*270+30)*1+lsi)*1] + fp675;
target[((hsi*360+22)*1+lsi)*1] = fp674;
LIBINT2_REALTYPE fp697;
fp697 = inteval->CD_y[vi] * src1[((hsi*216+6)*1+lsi)*1];
LIBINT2_REALTYPE fp696;
fp696 = src0[((hsi*270+18)*1+lsi)*1] + fp697;
target[((hsi*360+11)*1+lsi)*1] = fp696;
LIBINT2_REALTYPE fp581;
fp581 = inteval->CD_z[vi] * src1[((hsi*216+41)*1+lsi)*1];
LIBINT2_REALTYPE fp580;
fp580 = src0[((hsi*270+71)*1+lsi)*1] + fp581;
target[((hsi*360+69)*1+lsi)*1] = fp580;
LIBINT2_REALTYPE fp579;
fp579 = inteval->CD_x[vi] * src1[((hsi*216+42)*1+lsi)*1];
LIBINT2_REALTYPE fp578;
fp578 = src0[((hsi*270+42)*1+lsi)*1] + fp579;
target[((hsi*360+70)*1+lsi)*1] = fp578;
LIBINT2_REALTYPE fp577;
fp577 = inteval->CD_y[vi] * src1[((hsi*216+42)*1+lsi)*1];
LIBINT2_REALTYPE fp576;
fp576 = src0[((hsi*270+66)*1+lsi)*1] + fp577;
target[((hsi*360+71)*1+lsi)*1] = fp576;
LIBINT2_REALTYPE fp575;
fp575 = inteval->CD_z[vi] * src1[((hsi*216+42)*1+lsi)*1];
LIBINT2_REALTYPE fp574;
fp574 = src0[((hsi*270+72)*1+lsi)*1] + fp575;
target[((hsi*360+72)*1+lsi)*1] = fp574;
LIBINT2_REALTYPE fp573;
fp573 = inteval->CD_y[vi] * src1[((hsi*216+43)*1+lsi)*1];
LIBINT2_REALTYPE fp572;
fp572 = src0[((hsi*270+67)*1+lsi)*1] + fp573;
target[((hsi*360+73)*1+lsi)*1] = fp572;
LIBINT2_REALTYPE fp571;
fp571 = inteval->CD_z[vi] * src1[((hsi*216+43)*1+lsi)*1];
LIBINT2_REALTYPE fp570;
fp570 = src0[((hsi*270+73)*1+lsi)*1] + fp571;
target[((hsi*360+74)*1+lsi)*1] = fp570;
LIBINT2_REALTYPE fp569;
fp569 = inteval->CD_z[vi] * src1[((hsi*216+44)*1+lsi)*1];
LIBINT2_REALTYPE fp568;
fp568 = src0[((hsi*270+74)*1+lsi)*1] + fp569;
target[((hsi*360+75)*1+lsi)*1] = fp568;
LIBINT2_REALTYPE fp567;
fp567 = inteval->CD_y[vi] * src1[((hsi*216+45)*1+lsi)*1];
LIBINT2_REALTYPE fp566;
fp566 = src0[((hsi*270+69)*1+lsi)*1] + fp567;
target[((hsi*360+76)*1+lsi)*1] = fp566;
LIBINT2_REALTYPE fp565;
fp565 = inteval->CD_z[vi] * src1[((hsi*216+45)*1+lsi)*1];
LIBINT2_REALTYPE fp564;
fp564 = src0[((hsi*270+75)*1+lsi)*1] + fp565;
target[((hsi*360+77)*1+lsi)*1] = fp564;
LIBINT2_REALTYPE fp563;
fp563 = inteval->CD_z[vi] * src1[((hsi*216+46)*1+lsi)*1];
LIBINT2_REALTYPE fp562;
fp562 = src0[((hsi*270+76)*1+lsi)*1] + fp563;
target[((hsi*360+78)*1+lsi)*1] = fp562;
LIBINT2_REALTYPE fp629;
fp629 = inteval->CD_z[vi] * src1[((hsi*216+26)*1+lsi)*1];
LIBINT2_REALTYPE fp628;
fp628 = src0[((hsi*270+50)*1+lsi)*1] + fp629;
target[((hsi*360+45)*1+lsi)*1] = fp628;
LIBINT2_REALTYPE fp559;
fp559 = inteval->CD_x[vi] * src1[((hsi*216+48)*1+lsi)*1];
LIBINT2_REALTYPE fp558;
fp558 = src0[((hsi*270+48)*1+lsi)*1] + fp559;
target[((hsi*360+80)*1+lsi)*1] = fp558;
LIBINT2_REALTYPE fp557;
fp557 = inteval->CD_y[vi] * src1[((hsi*216+48)*1+lsi)*1];
LIBINT2_REALTYPE fp556;
fp556 = src0[((hsi*270+72)*1+lsi)*1] + fp557;
target[((hsi*360+81)*1+lsi)*1] = fp556;
LIBINT2_REALTYPE fp555;
fp555 = inteval->CD_z[vi] * src1[((hsi*216+48)*1+lsi)*1];
LIBINT2_REALTYPE fp554;
fp554 = src0[((hsi*270+78)*1+lsi)*1] + fp555;
target[((hsi*360+82)*1+lsi)*1] = fp554;
LIBINT2_REALTYPE fp553;
fp553 = inteval->CD_y[vi] * src1[((hsi*216+49)*1+lsi)*1];
LIBINT2_REALTYPE fp552;
fp552 = src0[((hsi*270+73)*1+lsi)*1] + fp553;
target[((hsi*360+83)*1+lsi)*1] = fp552;
LIBINT2_REALTYPE fp551;
fp551 = inteval->CD_z[vi] * src1[((hsi*216+49)*1+lsi)*1];
LIBINT2_REALTYPE fp550;
fp550 = src0[((hsi*270+79)*1+lsi)*1] + fp551;
target[((hsi*360+84)*1+lsi)*1] = fp550;
LIBINT2_REALTYPE fp549;
fp549 = inteval->CD_z[vi] * src1[((hsi*216+50)*1+lsi)*1];
LIBINT2_REALTYPE fp548;
fp548 = src0[((hsi*270+80)*1+lsi)*1] + fp549;
target[((hsi*360+85)*1+lsi)*1] = fp548;
LIBINT2_REALTYPE fp547;
fp547 = inteval->CD_y[vi] * src1[((hsi*216+51)*1+lsi)*1];
LIBINT2_REALTYPE fp546;
fp546 = src0[((hsi*270+75)*1+lsi)*1] + fp547;
target[((hsi*360+86)*1+lsi)*1] = fp546;
LIBINT2_REALTYPE fp545;
fp545 = inteval->CD_z[vi] * src1[((hsi*216+51)*1+lsi)*1];
LIBINT2_REALTYPE fp544;
fp544 = src0[((hsi*270+81)*1+lsi)*1] + fp545;
target[((hsi*360+87)*1+lsi)*1] = fp544;
LIBINT2_REALTYPE fp543;
fp543 = inteval->CD_z[vi] * src1[((hsi*216+52)*1+lsi)*1];
LIBINT2_REALTYPE fp542;
fp542 = src0[((hsi*270+82)*1+lsi)*1] + fp543;
target[((hsi*360+88)*1+lsi)*1] = fp542;
LIBINT2_REALTYPE fp541;
fp541 = inteval->CD_z[vi] * src1[((hsi*216+53)*1+lsi)*1];
LIBINT2_REALTYPE fp540;
fp540 = src0[((hsi*270+83)*1+lsi)*1] + fp541;
target[((hsi*360+89)*1+lsi)*1] = fp540;
LIBINT2_REALTYPE fp561;
fp561 = inteval->CD_z[vi] * src1[((hsi*216+47)*1+lsi)*1];
LIBINT2_REALTYPE fp560;
fp560 = src0[((hsi*270+77)*1+lsi)*1] + fp561;
target[((hsi*360+79)*1+lsi)*1] = fp560;
LIBINT2_REALTYPE fp627;
fp627 = inteval->CD_y[vi] * src1[((hsi*216+27)*1+lsi)*1];
LIBINT2_REALTYPE fp626;
fp626 = src0[((hsi*270+45)*1+lsi)*1] + fp627;
target[((hsi*360+46)*1+lsi)*1] = fp626;
LIBINT2_REALTYPE fp625;
fp625 = inteval->CD_z[vi] * src1[((hsi*216+27)*1+lsi)*1];
LIBINT2_REALTYPE fp624;
fp624 = src0[((hsi*270+51)*1+lsi)*1] + fp625;
target[((hsi*360+47)*1+lsi)*1] = fp624;
LIBINT2_REALTYPE fp623;
fp623 = inteval->CD_z[vi] * src1[((hsi*216+28)*1+lsi)*1];
LIBINT2_REALTYPE fp622;
fp622 = src0[((hsi*270+52)*1+lsi)*1] + fp623;
target[((hsi*360+48)*1+lsi)*1] = fp622;
LIBINT2_REALTYPE fp621;
fp621 = inteval->CD_z[vi] * src1[((hsi*216+29)*1+lsi)*1];
LIBINT2_REALTYPE fp620;
fp620 = src0[((hsi*270+53)*1+lsi)*1] + fp621;
target[((hsi*360+49)*1+lsi)*1] = fp620;
LIBINT2_REALTYPE fp619;
fp619 = inteval->CD_x[vi] * src1[((hsi*216+30)*1+lsi)*1];
LIBINT2_REALTYPE fp618;
fp618 = src0[((hsi*270+30)*1+lsi)*1] + fp619;
target[((hsi*360+50)*1+lsi)*1] = fp618;
LIBINT2_REALTYPE fp617;
fp617 = inteval->CD_y[vi] * src1[((hsi*216+30)*1+lsi)*1];
LIBINT2_REALTYPE fp616;
fp616 = src0[((hsi*270+48)*1+lsi)*1] + fp617;
target[((hsi*360+51)*1+lsi)*1] = fp616;
LIBINT2_REALTYPE fp615;
fp615 = inteval->CD_z[vi] * src1[((hsi*216+30)*1+lsi)*1];
LIBINT2_REALTYPE fp614;
fp614 = src0[((hsi*270+54)*1+lsi)*1] + fp615;
target[((hsi*360+52)*1+lsi)*1] = fp614;
LIBINT2_REALTYPE fp613;
fp613 = inteval->CD_y[vi] * src1[((hsi*216+31)*1+lsi)*1];
LIBINT2_REALTYPE fp612;
fp612 = src0[((hsi*270+49)*1+lsi)*1] + fp613;
target[((hsi*360+53)*1+lsi)*1] = fp612;
LIBINT2_REALTYPE fp611;
fp611 = inteval->CD_z[vi] * src1[((hsi*216+31)*1+lsi)*1];
LIBINT2_REALTYPE fp610;
fp610 = src0[((hsi*270+55)*1+lsi)*1] + fp611;
target[((hsi*360+54)*1+lsi)*1] = fp610;
LIBINT2_REALTYPE fp609;
fp609 = inteval->CD_z[vi] * src1[((hsi*216+32)*1+lsi)*1];
LIBINT2_REALTYPE fp608;
fp608 = src0[((hsi*270+56)*1+lsi)*1] + fp609;
target[((hsi*360+55)*1+lsi)*1] = fp608;
LIBINT2_REALTYPE fp583;
fp583 = inteval->CD_z[vi] * src1[((hsi*216+40)*1+lsi)*1];
LIBINT2_REALTYPE fp582;
fp582 = src0[((hsi*270+70)*1+lsi)*1] + fp583;
target[((hsi*360+68)*1+lsi)*1] = fp582;
LIBINT2_REALTYPE fp605;
fp605 = inteval->CD_z[vi] * src1[((hsi*216+33)*1+lsi)*1];
LIBINT2_REALTYPE fp604;
fp604 = src0[((hsi*270+57)*1+lsi)*1] + fp605;
target[((hsi*360+57)*1+lsi)*1] = fp604;
LIBINT2_REALTYPE fp603;
fp603 = inteval->CD_z[vi] * src1[((hsi*216+34)*1+lsi)*1];
LIBINT2_REALTYPE fp602;
fp602 = src0[((hsi*270+58)*1+lsi)*1] + fp603;
target[((hsi*360+58)*1+lsi)*1] = fp602;
LIBINT2_REALTYPE fp601;
fp601 = inteval->CD_z[vi] * src1[((hsi*216+35)*1+lsi)*1];
LIBINT2_REALTYPE fp600;
fp600 = src0[((hsi*270+59)*1+lsi)*1] + fp601;
target[((hsi*360+59)*1+lsi)*1] = fp600;
LIBINT2_REALTYPE fp599;
fp599 = inteval->CD_x[vi] * src1[((hsi*216+36)*1+lsi)*1];
LIBINT2_REALTYPE fp598;
fp598 = src0[((hsi*270+36)*1+lsi)*1] + fp599;
target[((hsi*360+60)*1+lsi)*1] = fp598;
LIBINT2_REALTYPE fp597;
fp597 = inteval->CD_y[vi] * src1[((hsi*216+36)*1+lsi)*1];
LIBINT2_REALTYPE fp596;
fp596 = src0[((hsi*270+60)*1+lsi)*1] + fp597;
target[((hsi*360+61)*1+lsi)*1] = fp596;
LIBINT2_REALTYPE fp595;
fp595 = inteval->CD_z[vi] * src1[((hsi*216+36)*1+lsi)*1];
LIBINT2_REALTYPE fp594;
fp594 = src0[((hsi*270+66)*1+lsi)*1] + fp595;
target[((hsi*360+62)*1+lsi)*1] = fp594;
LIBINT2_REALTYPE fp593;
fp593 = inteval->CD_y[vi] * src1[((hsi*216+37)*1+lsi)*1];
LIBINT2_REALTYPE fp592;
fp592 = src0[((hsi*270+61)*1+lsi)*1] + fp593;
target[((hsi*360+63)*1+lsi)*1] = fp592;
LIBINT2_REALTYPE fp591;
fp591 = inteval->CD_z[vi] * src1[((hsi*216+37)*1+lsi)*1];
LIBINT2_REALTYPE fp590;
fp590 = src0[((hsi*270+67)*1+lsi)*1] + fp591;
target[((hsi*360+64)*1+lsi)*1] = fp590;
LIBINT2_REALTYPE fp589;
fp589 = inteval->CD_z[vi] * src1[((hsi*216+38)*1+lsi)*1];
LIBINT2_REALTYPE fp588;
fp588 = src0[((hsi*270+68)*1+lsi)*1] + fp589;
target[((hsi*360+65)*1+lsi)*1] = fp588;
LIBINT2_REALTYPE fp587;
fp587 = inteval->CD_y[vi] * src1[((hsi*216+39)*1+lsi)*1];
LIBINT2_REALTYPE fp586;
fp586 = src0[((hsi*270+63)*1+lsi)*1] + fp587;
target[((hsi*360+66)*1+lsi)*1] = fp586;
LIBINT2_REALTYPE fp585;
fp585 = inteval->CD_z[vi] * src1[((hsi*216+39)*1+lsi)*1];
LIBINT2_REALTYPE fp584;
fp584 = src0[((hsi*270+69)*1+lsi)*1] + fp585;
target[((hsi*360+67)*1+lsi)*1] = fp584;
LIBINT2_REALTYPE fp607;
fp607 = inteval->CD_y[vi] * src1[((hsi*216+33)*1+lsi)*1];
LIBINT2_REALTYPE fp606;
fp606 = src0[((hsi*270+51)*1+lsi)*1] + fp607;
target[((hsi*360+56)*1+lsi)*1] = fp606;
LIBINT2_REALTYPE fp131;
fp131 = inteval->CD_z[vi] * src1[((hsi*216+175)*1+lsi)*1];
LIBINT2_REALTYPE fp130;
fp130 = src0[((hsi*270+229)*1+lsi)*1] + fp131;
target[((hsi*360+294)*1+lsi)*1] = fp130;
LIBINT2_REALTYPE fp129;
fp129 = inteval->CD_z[vi] * src1[((hsi*216+176)*1+lsi)*1];
LIBINT2_REALTYPE fp128;
fp128 = src0[((hsi*270+230)*1+lsi)*1] + fp129;
target[((hsi*360+295)*1+lsi)*1] = fp128;
LIBINT2_REALTYPE fp127;
fp127 = inteval->CD_y[vi] * src1[((hsi*216+177)*1+lsi)*1];
LIBINT2_REALTYPE fp126;
fp126 = src0[((hsi*270+225)*1+lsi)*1] + fp127;
target[((hsi*360+296)*1+lsi)*1] = fp126;
LIBINT2_REALTYPE fp125;
fp125 = inteval->CD_z[vi] * src1[((hsi*216+177)*1+lsi)*1];
LIBINT2_REALTYPE fp124;
fp124 = src0[((hsi*270+231)*1+lsi)*1] + fp125;
target[((hsi*360+297)*1+lsi)*1] = fp124;
LIBINT2_REALTYPE fp123;
fp123 = inteval->CD_z[vi] * src1[((hsi*216+178)*1+lsi)*1];
LIBINT2_REALTYPE fp122;
fp122 = src0[((hsi*270+232)*1+lsi)*1] + fp123;
target[((hsi*360+298)*1+lsi)*1] = fp122;
LIBINT2_REALTYPE fp121;
fp121 = inteval->CD_z[vi] * src1[((hsi*216+179)*1+lsi)*1];
LIBINT2_REALTYPE fp120;
fp120 = src0[((hsi*270+233)*1+lsi)*1] + fp121;
target[((hsi*360+299)*1+lsi)*1] = fp120;
LIBINT2_REALTYPE fp119;
fp119 = inteval->CD_x[vi] * src1[((hsi*216+180)*1+lsi)*1];
LIBINT2_REALTYPE fp118;
fp118 = src0[((hsi*270+180)*1+lsi)*1] + fp119;
target[((hsi*360+300)*1+lsi)*1] = fp118;
LIBINT2_REALTYPE fp117;
fp117 = inteval->CD_y[vi] * src1[((hsi*216+180)*1+lsi)*1];
LIBINT2_REALTYPE fp116;
fp116 = src0[((hsi*270+228)*1+lsi)*1] + fp117;
target[((hsi*360+301)*1+lsi)*1] = fp116;
LIBINT2_REALTYPE fp115;
fp115 = inteval->CD_z[vi] * src1[((hsi*216+180)*1+lsi)*1];
LIBINT2_REALTYPE fp114;
fp114 = src0[((hsi*270+234)*1+lsi)*1] + fp115;
target[((hsi*360+302)*1+lsi)*1] = fp114;
LIBINT2_REALTYPE fp113;
fp113 = inteval->CD_y[vi] * src1[((hsi*216+181)*1+lsi)*1];
LIBINT2_REALTYPE fp112;
fp112 = src0[((hsi*270+229)*1+lsi)*1] + fp113;
target[((hsi*360+303)*1+lsi)*1] = fp112;
LIBINT2_REALTYPE fp359;
fp359 = inteval->CD_x[vi] * src1[((hsi*216+108)*1+lsi)*1];
LIBINT2_REALTYPE fp358;
fp358 = src0[((hsi*270+108)*1+lsi)*1] + fp359;
target[((hsi*360+180)*1+lsi)*1] = fp358;
LIBINT2_REALTYPE fp109;
fp109 = inteval->CD_z[vi] * src1[((hsi*216+182)*1+lsi)*1];
LIBINT2_REALTYPE fp108;
fp108 = src0[((hsi*270+236)*1+lsi)*1] + fp109;
target[((hsi*360+305)*1+lsi)*1] = fp108;
LIBINT2_REALTYPE fp107;
fp107 = inteval->CD_y[vi] * src1[((hsi*216+183)*1+lsi)*1];
LIBINT2_REALTYPE fp106;
fp106 = src0[((hsi*270+231)*1+lsi)*1] + fp107;
target[((hsi*360+306)*1+lsi)*1] = fp106;
LIBINT2_REALTYPE fp105;
fp105 = inteval->CD_z[vi] * src1[((hsi*216+183)*1+lsi)*1];
LIBINT2_REALTYPE fp104;
fp104 = src0[((hsi*270+237)*1+lsi)*1] + fp105;
target[((hsi*360+307)*1+lsi)*1] = fp104;
LIBINT2_REALTYPE fp103;
fp103 = inteval->CD_z[vi] * src1[((hsi*216+184)*1+lsi)*1];
LIBINT2_REALTYPE fp102;
fp102 = src0[((hsi*270+238)*1+lsi)*1] + fp103;
target[((hsi*360+308)*1+lsi)*1] = fp102;
LIBINT2_REALTYPE fp101;
fp101 = inteval->CD_z[vi] * src1[((hsi*216+185)*1+lsi)*1];
LIBINT2_REALTYPE fp100;
fp100 = src0[((hsi*270+239)*1+lsi)*1] + fp101;
target[((hsi*360+309)*1+lsi)*1] = fp100;
LIBINT2_REALTYPE fp99;
fp99 = inteval->CD_x[vi] * src1[((hsi*216+186)*1+lsi)*1];
LIBINT2_REALTYPE fp98;
fp98 = src0[((hsi*270+186)*1+lsi)*1] + fp99;
target[((hsi*360+310)*1+lsi)*1] = fp98;
LIBINT2_REALTYPE fp97;
fp97 = inteval->CD_y[vi] * src1[((hsi*216+186)*1+lsi)*1];
LIBINT2_REALTYPE fp96;
fp96 = src0[((hsi*270+234)*1+lsi)*1] + fp97;
target[((hsi*360+311)*1+lsi)*1] = fp96;
LIBINT2_REALTYPE fp95;
fp95 = inteval->CD_z[vi] * src1[((hsi*216+186)*1+lsi)*1];
LIBINT2_REALTYPE fp94;
fp94 = src0[((hsi*270+240)*1+lsi)*1] + fp95;
target[((hsi*360+312)*1+lsi)*1] = fp94;
LIBINT2_REALTYPE fp93;
fp93 = inteval->CD_y[vi] * src1[((hsi*216+187)*1+lsi)*1];
LIBINT2_REALTYPE fp92;
fp92 = src0[((hsi*270+235)*1+lsi)*1] + fp93;
target[((hsi*360+313)*1+lsi)*1] = fp92;
LIBINT2_REALTYPE fp91;
fp91 = inteval->CD_z[vi] * src1[((hsi*216+187)*1+lsi)*1];
LIBINT2_REALTYPE fp90;
fp90 = src0[((hsi*270+241)*1+lsi)*1] + fp91;
target[((hsi*360+314)*1+lsi)*1] = fp90;
LIBINT2_REALTYPE fp111;
fp111 = inteval->CD_z[vi] * src1[((hsi*216+181)*1+lsi)*1];
LIBINT2_REALTYPE fp110;
fp110 = src0[((hsi*270+235)*1+lsi)*1] + fp111;
target[((hsi*360+304)*1+lsi)*1] = fp110;
LIBINT2_REALTYPE fp177;
fp177 = inteval->CD_y[vi] * src1[((hsi*216+162)*1+lsi)*1];
LIBINT2_REALTYPE fp176;
fp176 = src0[((hsi*270+204)*1+lsi)*1] + fp177;
target[((hsi*360+271)*1+lsi)*1] = fp176;
LIBINT2_REALTYPE fp175;
fp175 = inteval->CD_z[vi] * src1[((hsi*216+162)*1+lsi)*1];
LIBINT2_REALTYPE fp174;
fp174 = src0[((hsi*270+210)*1+lsi)*1] + fp175;
target[((hsi*360+272)*1+lsi)*1] = fp174;
LIBINT2_REALTYPE fp173;
fp173 = inteval->CD_y[vi] * src1[((hsi*216+163)*1+lsi)*1];
LIBINT2_REALTYPE fp172;
fp172 = src0[((hsi*270+205)*1+lsi)*1] + fp173;
target[((hsi*360+273)*1+lsi)*1] = fp172;
LIBINT2_REALTYPE fp171;
fp171 = inteval->CD_z[vi] * src1[((hsi*216+163)*1+lsi)*1];
LIBINT2_REALTYPE fp170;
fp170 = src0[((hsi*270+211)*1+lsi)*1] + fp171;
target[((hsi*360+274)*1+lsi)*1] = fp170;
LIBINT2_REALTYPE fp169;
fp169 = inteval->CD_z[vi] * src1[((hsi*216+164)*1+lsi)*1];
LIBINT2_REALTYPE fp168;
fp168 = src0[((hsi*270+212)*1+lsi)*1] + fp169;
target[((hsi*360+275)*1+lsi)*1] = fp168;
LIBINT2_REALTYPE fp167;
fp167 = inteval->CD_y[vi] * src1[((hsi*216+165)*1+lsi)*1];
LIBINT2_REALTYPE fp166;
fp166 = src0[((hsi*270+207)*1+lsi)*1] + fp167;
target[((hsi*360+276)*1+lsi)*1] = fp166;
LIBINT2_REALTYPE fp165;
fp165 = inteval->CD_z[vi] * src1[((hsi*216+165)*1+lsi)*1];
LIBINT2_REALTYPE fp164;
fp164 = src0[((hsi*270+213)*1+lsi)*1] + fp165;
target[((hsi*360+277)*1+lsi)*1] = fp164;
LIBINT2_REALTYPE fp163;
fp163 = inteval->CD_z[vi] * src1[((hsi*216+166)*1+lsi)*1];
LIBINT2_REALTYPE fp162;
fp162 = src0[((hsi*270+214)*1+lsi)*1] + fp163;
target[((hsi*360+278)*1+lsi)*1] = fp162;
LIBINT2_REALTYPE fp161;
fp161 = inteval->CD_z[vi] * src1[((hsi*216+167)*1+lsi)*1];
LIBINT2_REALTYPE fp160;
fp160 = src0[((hsi*270+215)*1+lsi)*1] + fp161;
target[((hsi*360+279)*1+lsi)*1] = fp160;
LIBINT2_REALTYPE fp159;
fp159 = inteval->CD_x[vi] * src1[((hsi*216+168)*1+lsi)*1];
LIBINT2_REALTYPE fp158;
fp158 = src0[((hsi*270+168)*1+lsi)*1] + fp159;
target[((hsi*360+280)*1+lsi)*1] = fp158;
LIBINT2_REALTYPE fp133;
fp133 = inteval->CD_y[vi] * src1[((hsi*216+175)*1+lsi)*1];
LIBINT2_REALTYPE fp132;
fp132 = src0[((hsi*270+223)*1+lsi)*1] + fp133;
target[((hsi*360+293)*1+lsi)*1] = fp132;
LIBINT2_REALTYPE fp155;
fp155 = inteval->CD_z[vi] * src1[((hsi*216+168)*1+lsi)*1];
LIBINT2_REALTYPE fp154;
fp154 = src0[((hsi*270+222)*1+lsi)*1] + fp155;
target[((hsi*360+282)*1+lsi)*1] = fp154;
LIBINT2_REALTYPE fp153;
fp153 = inteval->CD_y[vi] * src1[((hsi*216+169)*1+lsi)*1];
LIBINT2_REALTYPE fp152;
fp152 = src0[((hsi*270+217)*1+lsi)*1] + fp153;
target[((hsi*360+283)*1+lsi)*1] = fp152;
LIBINT2_REALTYPE fp151;
fp151 = inteval->CD_z[vi] * src1[((hsi*216+169)*1+lsi)*1];
LIBINT2_REALTYPE fp150;
fp150 = src0[((hsi*270+223)*1+lsi)*1] + fp151;
target[((hsi*360+284)*1+lsi)*1] = fp150;
LIBINT2_REALTYPE fp149;
fp149 = inteval->CD_z[vi] * src1[((hsi*216+170)*1+lsi)*1];
LIBINT2_REALTYPE fp148;
fp148 = src0[((hsi*270+224)*1+lsi)*1] + fp149;
target[((hsi*360+285)*1+lsi)*1] = fp148;
LIBINT2_REALTYPE fp147;
fp147 = inteval->CD_y[vi] * src1[((hsi*216+171)*1+lsi)*1];
LIBINT2_REALTYPE fp146;
fp146 = src0[((hsi*270+219)*1+lsi)*1] + fp147;
target[((hsi*360+286)*1+lsi)*1] = fp146;
LIBINT2_REALTYPE fp145;
fp145 = inteval->CD_z[vi] * src1[((hsi*216+171)*1+lsi)*1];
LIBINT2_REALTYPE fp144;
fp144 = src0[((hsi*270+225)*1+lsi)*1] + fp145;
target[((hsi*360+287)*1+lsi)*1] = fp144;
LIBINT2_REALTYPE fp143;
fp143 = inteval->CD_z[vi] * src1[((hsi*216+172)*1+lsi)*1];
LIBINT2_REALTYPE fp142;
fp142 = src0[((hsi*270+226)*1+lsi)*1] + fp143;
target[((hsi*360+288)*1+lsi)*1] = fp142;
LIBINT2_REALTYPE fp141;
fp141 = inteval->CD_z[vi] * src1[((hsi*216+173)*1+lsi)*1];
LIBINT2_REALTYPE fp140;
fp140 = src0[((hsi*270+227)*1+lsi)*1] + fp141;
target[((hsi*360+289)*1+lsi)*1] = fp140;
LIBINT2_REALTYPE fp139;
fp139 = inteval->CD_x[vi] * src1[((hsi*216+174)*1+lsi)*1];
LIBINT2_REALTYPE fp138;
fp138 = src0[((hsi*270+174)*1+lsi)*1] + fp139;
target[((hsi*360+290)*1+lsi)*1] = fp138;
LIBINT2_REALTYPE fp137;
fp137 = inteval->CD_y[vi] * src1[((hsi*216+174)*1+lsi)*1];
LIBINT2_REALTYPE fp136;
fp136 = src0[((hsi*270+222)*1+lsi)*1] + fp137;
target[((hsi*360+291)*1+lsi)*1] = fp136;
LIBINT2_REALTYPE fp135;
fp135 = inteval->CD_z[vi] * src1[((hsi*216+174)*1+lsi)*1];
LIBINT2_REALTYPE fp134;
fp134 = src0[((hsi*270+228)*1+lsi)*1] + fp135;
target[((hsi*360+292)*1+lsi)*1] = fp134;
LIBINT2_REALTYPE fp157;
fp157 = inteval->CD_y[vi] * src1[((hsi*216+168)*1+lsi)*1];
LIBINT2_REALTYPE fp156;
fp156 = src0[((hsi*270+216)*1+lsi)*1] + fp157;
target[((hsi*360+281)*1+lsi)*1] = fp156;
LIBINT2_REALTYPE fp41;
fp41 = inteval->CD_z[vi] * src1[((hsi*216+203)*1+lsi)*1];
LIBINT2_REALTYPE fp40;
fp40 = src0[((hsi*270+257)*1+lsi)*1] + fp41;
target[((hsi*360+339)*1+lsi)*1] = fp40;
LIBINT2_REALTYPE fp39;
fp39 = inteval->CD_x[vi] * src1[((hsi*216+204)*1+lsi)*1];
LIBINT2_REALTYPE fp38;
fp38 = src0[((hsi*270+204)*1+lsi)*1] + fp39;
target[((hsi*360+340)*1+lsi)*1] = fp38;
LIBINT2_REALTYPE fp37;
fp37 = inteval->CD_y[vi] * src1[((hsi*216+204)*1+lsi)*1];
LIBINT2_REALTYPE fp36;
fp36 = src0[((hsi*270+252)*1+lsi)*1] + fp37;
target[((hsi*360+341)*1+lsi)*1] = fp36;
LIBINT2_REALTYPE fp35;
fp35 = inteval->CD_z[vi] * src1[((hsi*216+204)*1+lsi)*1];
LIBINT2_REALTYPE fp34;
fp34 = src0[((hsi*270+258)*1+lsi)*1] + fp35;
target[((hsi*360+342)*1+lsi)*1] = fp34;
LIBINT2_REALTYPE fp33;
fp33 = inteval->CD_y[vi] * src1[((hsi*216+205)*1+lsi)*1];
LIBINT2_REALTYPE fp32;
fp32 = src0[((hsi*270+253)*1+lsi)*1] + fp33;
target[((hsi*360+343)*1+lsi)*1] = fp32;
LIBINT2_REALTYPE fp31;
fp31 = inteval->CD_z[vi] * src1[((hsi*216+205)*1+lsi)*1];
LIBINT2_REALTYPE fp30;
fp30 = src0[((hsi*270+259)*1+lsi)*1] + fp31;
target[((hsi*360+344)*1+lsi)*1] = fp30;
LIBINT2_REALTYPE fp29;
fp29 = inteval->CD_z[vi] * src1[((hsi*216+206)*1+lsi)*1];
LIBINT2_REALTYPE fp28;
fp28 = src0[((hsi*270+260)*1+lsi)*1] + fp29;
target[((hsi*360+345)*1+lsi)*1] = fp28;
LIBINT2_REALTYPE fp27;
fp27 = inteval->CD_y[vi] * src1[((hsi*216+207)*1+lsi)*1];
LIBINT2_REALTYPE fp26;
fp26 = src0[((hsi*270+255)*1+lsi)*1] + fp27;
target[((hsi*360+346)*1+lsi)*1] = fp26;
LIBINT2_REALTYPE fp25;
fp25 = inteval->CD_z[vi] * src1[((hsi*216+207)*1+lsi)*1];
LIBINT2_REALTYPE fp24;
fp24 = src0[((hsi*270+261)*1+lsi)*1] + fp25;
target[((hsi*360+347)*1+lsi)*1] = fp24;
LIBINT2_REALTYPE fp23;
fp23 = inteval->CD_z[vi] * src1[((hsi*216+208)*1+lsi)*1];
LIBINT2_REALTYPE fp22;
fp22 = src0[((hsi*270+262)*1+lsi)*1] + fp23;
target[((hsi*360+348)*1+lsi)*1] = fp22;
LIBINT2_REALTYPE fp89;
fp89 = inteval->CD_z[vi] * src1[((hsi*216+188)*1+lsi)*1];
LIBINT2_REALTYPE fp88;
fp88 = src0[((hsi*270+242)*1+lsi)*1] + fp89;
target[((hsi*360+315)*1+lsi)*1] = fp88;
LIBINT2_REALTYPE fp19;
fp19 = inteval->CD_x[vi] * src1[((hsi*216+210)*1+lsi)*1];
LIBINT2_REALTYPE fp18;
fp18 = src0[((hsi*270+210)*1+lsi)*1] + fp19;
target[((hsi*360+350)*1+lsi)*1] = fp18;
LIBINT2_REALTYPE fp17;
fp17 = inteval->CD_y[vi] * src1[((hsi*216+210)*1+lsi)*1];
LIBINT2_REALTYPE fp16;
fp16 = src0[((hsi*270+258)*1+lsi)*1] + fp17;
target[((hsi*360+351)*1+lsi)*1] = fp16;
LIBINT2_REALTYPE fp15;
fp15 = inteval->CD_z[vi] * src1[((hsi*216+210)*1+lsi)*1];
LIBINT2_REALTYPE fp14;
fp14 = src0[((hsi*270+264)*1+lsi)*1] + fp15;
target[((hsi*360+352)*1+lsi)*1] = fp14;
LIBINT2_REALTYPE fp13;
fp13 = inteval->CD_y[vi] * src1[((hsi*216+211)*1+lsi)*1];
LIBINT2_REALTYPE fp12;
fp12 = src0[((hsi*270+259)*1+lsi)*1] + fp13;
target[((hsi*360+353)*1+lsi)*1] = fp12;
LIBINT2_REALTYPE fp11;
fp11 = inteval->CD_z[vi] * src1[((hsi*216+211)*1+lsi)*1];
LIBINT2_REALTYPE fp10;
fp10 = src0[((hsi*270+265)*1+lsi)*1] + fp11;
target[((hsi*360+354)*1+lsi)*1] = fp10;
LIBINT2_REALTYPE fp9;
fp9 = inteval->CD_z[vi] * src1[((hsi*216+212)*1+lsi)*1];
LIBINT2_REALTYPE fp8;
fp8 = src0[((hsi*270+266)*1+lsi)*1] + fp9;
target[((hsi*360+355)*1+lsi)*1] = fp8;
LIBINT2_REALTYPE fp7;
fp7 = inteval->CD_y[vi] * src1[((hsi*216+213)*1+lsi)*1];
LIBINT2_REALTYPE fp6;
fp6 = src0[((hsi*270+261)*1+lsi)*1] + fp7;
target[((hsi*360+356)*1+lsi)*1] = fp6;
LIBINT2_REALTYPE fp5;
fp5 = inteval->CD_z[vi] * src1[((hsi*216+213)*1+lsi)*1];
LIBINT2_REALTYPE fp4;
fp4 = src0[((hsi*270+267)*1+lsi)*1] + fp5;
target[((hsi*360+357)*1+lsi)*1] = fp4;
LIBINT2_REALTYPE fp3;
fp3 = inteval->CD_z[vi] * src1[((hsi*216+214)*1+lsi)*1];
LIBINT2_REALTYPE fp2;
fp2 = src0[((hsi*270+268)*1+lsi)*1] + fp3;
target[((hsi*360+358)*1+lsi)*1] = fp2;
LIBINT2_REALTYPE fp1;
fp1 = inteval->CD_z[vi] * src1[((hsi*216+215)*1+lsi)*1];
LIBINT2_REALTYPE fp0;
fp0 = src0[((hsi*270+269)*1+lsi)*1] + fp1;
target[((hsi*360+359)*1+lsi)*1] = fp0;
LIBINT2_REALTYPE fp21;
fp21 = inteval->CD_z[vi] * src1[((hsi*216+209)*1+lsi)*1];
LIBINT2_REALTYPE fp20;
fp20 = src0[((hsi*270+263)*1+lsi)*1] + fp21;
target[((hsi*360+349)*1+lsi)*1] = fp20;
LIBINT2_REALTYPE fp87;
fp87 = inteval->CD_y[vi] * src1[((hsi*216+189)*1+lsi)*1];
LIBINT2_REALTYPE fp86;
fp86 = src0[((hsi*270+237)*1+lsi)*1] + fp87;
target[((hsi*360+316)*1+lsi)*1] = fp86;
LIBINT2_REALTYPE fp85;
fp85 = inteval->CD_z[vi] * src1[((hsi*216+189)*1+lsi)*1];
LIBINT2_REALTYPE fp84;
fp84 = src0[((hsi*270+243)*1+lsi)*1] + fp85;
target[((hsi*360+317)*1+lsi)*1] = fp84;
LIBINT2_REALTYPE fp83;
fp83 = inteval->CD_z[vi] * src1[((hsi*216+190)*1+lsi)*1];
LIBINT2_REALTYPE fp82;
fp82 = src0[((hsi*270+244)*1+lsi)*1] + fp83;
target[((hsi*360+318)*1+lsi)*1] = fp82;
LIBINT2_REALTYPE fp81;
fp81 = inteval->CD_z[vi] * src1[((hsi*216+191)*1+lsi)*1];
LIBINT2_REALTYPE fp80;
fp80 = src0[((hsi*270+245)*1+lsi)*1] + fp81;
target[((hsi*360+319)*1+lsi)*1] = fp80;
LIBINT2_REALTYPE fp79;
fp79 = inteval->CD_x[vi] * src1[((hsi*216+192)*1+lsi)*1];
LIBINT2_REALTYPE fp78;
fp78 = src0[((hsi*270+192)*1+lsi)*1] + fp79;
target[((hsi*360+320)*1+lsi)*1] = fp78;
LIBINT2_REALTYPE fp77;
fp77 = inteval->CD_y[vi] * src1[((hsi*216+192)*1+lsi)*1];
LIBINT2_REALTYPE fp76;
fp76 = src0[((hsi*270+240)*1+lsi)*1] + fp77;
target[((hsi*360+321)*1+lsi)*1] = fp76;
LIBINT2_REALTYPE fp75;
fp75 = inteval->CD_z[vi] * src1[((hsi*216+192)*1+lsi)*1];
LIBINT2_REALTYPE fp74;
fp74 = src0[((hsi*270+246)*1+lsi)*1] + fp75;
target[((hsi*360+322)*1+lsi)*1] = fp74;
LIBINT2_REALTYPE fp73;
fp73 = inteval->CD_y[vi] * src1[((hsi*216+193)*1+lsi)*1];
LIBINT2_REALTYPE fp72;
fp72 = src0[((hsi*270+241)*1+lsi)*1] + fp73;
target[((hsi*360+323)*1+lsi)*1] = fp72;
LIBINT2_REALTYPE fp71;
fp71 = inteval->CD_z[vi] * src1[((hsi*216+193)*1+lsi)*1];
LIBINT2_REALTYPE fp70;
fp70 = src0[((hsi*270+247)*1+lsi)*1] + fp71;
target[((hsi*360+324)*1+lsi)*1] = fp70;
LIBINT2_REALTYPE fp69;
fp69 = inteval->CD_z[vi] * src1[((hsi*216+194)*1+lsi)*1];
LIBINT2_REALTYPE fp68;
fp68 = src0[((hsi*270+248)*1+lsi)*1] + fp69;
target[((hsi*360+325)*1+lsi)*1] = fp68;
LIBINT2_REALTYPE fp43;
fp43 = inteval->CD_z[vi] * src1[((hsi*216+202)*1+lsi)*1];
LIBINT2_REALTYPE fp42;
fp42 = src0[((hsi*270+256)*1+lsi)*1] + fp43;
target[((hsi*360+338)*1+lsi)*1] = fp42;
LIBINT2_REALTYPE fp65;
fp65 = inteval->CD_z[vi] * src1[((hsi*216+195)*1+lsi)*1];
LIBINT2_REALTYPE fp64;
fp64 = src0[((hsi*270+249)*1+lsi)*1] + fp65;
target[((hsi*360+327)*1+lsi)*1] = fp64;
LIBINT2_REALTYPE fp63;
fp63 = inteval->CD_z[vi] * src1[((hsi*216+196)*1+lsi)*1];
LIBINT2_REALTYPE fp62;
fp62 = src0[((hsi*270+250)*1+lsi)*1] + fp63;
target[((hsi*360+328)*1+lsi)*1] = fp62;
LIBINT2_REALTYPE fp61;
fp61 = inteval->CD_z[vi] * src1[((hsi*216+197)*1+lsi)*1];
LIBINT2_REALTYPE fp60;
fp60 = src0[((hsi*270+251)*1+lsi)*1] + fp61;
target[((hsi*360+329)*1+lsi)*1] = fp60;
LIBINT2_REALTYPE fp59;
fp59 = inteval->CD_x[vi] * src1[((hsi*216+198)*1+lsi)*1];
LIBINT2_REALTYPE fp58;
fp58 = src0[((hsi*270+198)*1+lsi)*1] + fp59;
target[((hsi*360+330)*1+lsi)*1] = fp58;
LIBINT2_REALTYPE fp57;
fp57 = inteval->CD_y[vi] * src1[((hsi*216+198)*1+lsi)*1];
LIBINT2_REALTYPE fp56;
fp56 = src0[((hsi*270+246)*1+lsi)*1] + fp57;
target[((hsi*360+331)*1+lsi)*1] = fp56;
LIBINT2_REALTYPE fp55;
fp55 = inteval->CD_z[vi] * src1[((hsi*216+198)*1+lsi)*1];
LIBINT2_REALTYPE fp54;
fp54 = src0[((hsi*270+252)*1+lsi)*1] + fp55;
target[((hsi*360+332)*1+lsi)*1] = fp54;
LIBINT2_REALTYPE fp53;
fp53 = inteval->CD_y[vi] * src1[((hsi*216+199)*1+lsi)*1];
LIBINT2_REALTYPE fp52;
fp52 = src0[((hsi*270+247)*1+lsi)*1] + fp53;
target[((hsi*360+333)*1+lsi)*1] = fp52;
LIBINT2_REALTYPE fp51;
fp51 = inteval->CD_z[vi] * src1[((hsi*216+199)*1+lsi)*1];
LIBINT2_REALTYPE fp50;
fp50 = src0[((hsi*270+253)*1+lsi)*1] + fp51;
target[((hsi*360+334)*1+lsi)*1] = fp50;
LIBINT2_REALTYPE fp49;
fp49 = inteval->CD_z[vi] * src1[((hsi*216+200)*1+lsi)*1];
LIBINT2_REALTYPE fp48;
fp48 = src0[((hsi*270+254)*1+lsi)*1] + fp49;
target[((hsi*360+335)*1+lsi)*1] = fp48;
LIBINT2_REALTYPE fp47;
fp47 = inteval->CD_y[vi] * src1[((hsi*216+201)*1+lsi)*1];
LIBINT2_REALTYPE fp46;
fp46 = src0[((hsi*270+249)*1+lsi)*1] + fp47;
target[((hsi*360+336)*1+lsi)*1] = fp46;
LIBINT2_REALTYPE fp45;
fp45 = inteval->CD_z[vi] * src1[((hsi*216+201)*1+lsi)*1];
LIBINT2_REALTYPE fp44;
fp44 = src0[((hsi*270+255)*1+lsi)*1] + fp45;
target[((hsi*360+337)*1+lsi)*1] = fp44;
LIBINT2_REALTYPE fp67;
fp67 = inteval->CD_y[vi] * src1[((hsi*216+195)*1+lsi)*1];
LIBINT2_REALTYPE fp66;
fp66 = src0[((hsi*270+243)*1+lsi)*1] + fp67;
target[((hsi*360+326)*1+lsi)*1] = fp66;
LIBINT2_REALTYPE fp311;
fp311 = inteval->CD_z[vi] * src1[((hsi*216+121)*1+lsi)*1];
LIBINT2_REALTYPE fp310;
fp310 = src0[((hsi*270+163)*1+lsi)*1] + fp311;
target[((hsi*360+204)*1+lsi)*1] = fp310;
LIBINT2_REALTYPE fp309;
fp309 = inteval->CD_z[vi] * src1[((hsi*216+122)*1+lsi)*1];
LIBINT2_REALTYPE fp308;
fp308 = src0[((hsi*270+164)*1+lsi)*1] + fp309;
target[((hsi*360+205)*1+lsi)*1] = fp308;
LIBINT2_REALTYPE fp307;
fp307 = inteval->CD_y[vi] * src1[((hsi*216+123)*1+lsi)*1];
LIBINT2_REALTYPE fp306;
fp306 = src0[((hsi*270+159)*1+lsi)*1] + fp307;
target[((hsi*360+206)*1+lsi)*1] = fp306;
LIBINT2_REALTYPE fp305;
fp305 = inteval->CD_z[vi] * src1[((hsi*216+123)*1+lsi)*1];
LIBINT2_REALTYPE fp304;
fp304 = src0[((hsi*270+165)*1+lsi)*1] + fp305;
target[((hsi*360+207)*1+lsi)*1] = fp304;
LIBINT2_REALTYPE fp303;
fp303 = inteval->CD_z[vi] * src1[((hsi*216+124)*1+lsi)*1];
LIBINT2_REALTYPE fp302;
fp302 = src0[((hsi*270+166)*1+lsi)*1] + fp303;
target[((hsi*360+208)*1+lsi)*1] = fp302;
LIBINT2_REALTYPE fp301;
fp301 = inteval->CD_z[vi] * src1[((hsi*216+125)*1+lsi)*1];
LIBINT2_REALTYPE fp300;
fp300 = src0[((hsi*270+167)*1+lsi)*1] + fp301;
target[((hsi*360+209)*1+lsi)*1] = fp300;
LIBINT2_REALTYPE fp299;
fp299 = inteval->CD_x[vi] * src1[((hsi*216+126)*1+lsi)*1];
LIBINT2_REALTYPE fp298;
fp298 = src0[((hsi*270+126)*1+lsi)*1] + fp299;
target[((hsi*360+210)*1+lsi)*1] = fp298;
LIBINT2_REALTYPE fp297;
fp297 = inteval->CD_y[vi] * src1[((hsi*216+126)*1+lsi)*1];
LIBINT2_REALTYPE fp296;
fp296 = src0[((hsi*270+168)*1+lsi)*1] + fp297;
target[((hsi*360+211)*1+lsi)*1] = fp296;
LIBINT2_REALTYPE fp295;
fp295 = inteval->CD_z[vi] * src1[((hsi*216+126)*1+lsi)*1];
LIBINT2_REALTYPE fp294;
fp294 = src0[((hsi*270+174)*1+lsi)*1] + fp295;
target[((hsi*360+212)*1+lsi)*1] = fp294;
LIBINT2_REALTYPE fp293;
fp293 = inteval->CD_y[vi] * src1[((hsi*216+127)*1+lsi)*1];
LIBINT2_REALTYPE fp292;
fp292 = src0[((hsi*270+169)*1+lsi)*1] + fp293;
target[((hsi*360+213)*1+lsi)*1] = fp292;
LIBINT2_REALTYPE fp179;
fp179 = inteval->CD_x[vi] * src1[((hsi*216+162)*1+lsi)*1];
LIBINT2_REALTYPE fp178;
fp178 = src0[((hsi*270+162)*1+lsi)*1] + fp179;
target[((hsi*360+270)*1+lsi)*1] = fp178;
LIBINT2_REALTYPE fp289;
fp289 = inteval->CD_z[vi] * src1[((hsi*216+128)*1+lsi)*1];
LIBINT2_REALTYPE fp288;
fp288 = src0[((hsi*270+176)*1+lsi)*1] + fp289;
target[((hsi*360+215)*1+lsi)*1] = fp288;
LIBINT2_REALTYPE fp287;
fp287 = inteval->CD_y[vi] * src1[((hsi*216+129)*1+lsi)*1];
LIBINT2_REALTYPE fp286;
fp286 = src0[((hsi*270+171)*1+lsi)*1] + fp287;
target[((hsi*360+216)*1+lsi)*1] = fp286;
LIBINT2_REALTYPE fp285;
fp285 = inteval->CD_z[vi] * src1[((hsi*216+129)*1+lsi)*1];
LIBINT2_REALTYPE fp284;
fp284 = src0[((hsi*270+177)*1+lsi)*1] + fp285;
target[((hsi*360+217)*1+lsi)*1] = fp284;
LIBINT2_REALTYPE fp283;
fp283 = inteval->CD_z[vi] * src1[((hsi*216+130)*1+lsi)*1];
LIBINT2_REALTYPE fp282;
fp282 = src0[((hsi*270+178)*1+lsi)*1] + fp283;
target[((hsi*360+218)*1+lsi)*1] = fp282;
LIBINT2_REALTYPE fp281;
fp281 = inteval->CD_z[vi] * src1[((hsi*216+131)*1+lsi)*1];
LIBINT2_REALTYPE fp280;
fp280 = src0[((hsi*270+179)*1+lsi)*1] + fp281;
target[((hsi*360+219)*1+lsi)*1] = fp280;
LIBINT2_REALTYPE fp279;
fp279 = inteval->CD_x[vi] * src1[((hsi*216+132)*1+lsi)*1];
LIBINT2_REALTYPE fp278;
fp278 = src0[((hsi*270+132)*1+lsi)*1] + fp279;
target[((hsi*360+220)*1+lsi)*1] = fp278;
LIBINT2_REALTYPE fp277;
fp277 = inteval->CD_y[vi] * src1[((hsi*216+132)*1+lsi)*1];
LIBINT2_REALTYPE fp276;
fp276 = src0[((hsi*270+174)*1+lsi)*1] + fp277;
target[((hsi*360+221)*1+lsi)*1] = fp276;
LIBINT2_REALTYPE fp275;
fp275 = inteval->CD_z[vi] * src1[((hsi*216+132)*1+lsi)*1];
LIBINT2_REALTYPE fp274;
fp274 = src0[((hsi*270+180)*1+lsi)*1] + fp275;
target[((hsi*360+222)*1+lsi)*1] = fp274;
LIBINT2_REALTYPE fp273;
fp273 = inteval->CD_y[vi] * src1[((hsi*216+133)*1+lsi)*1];
LIBINT2_REALTYPE fp272;
fp272 = src0[((hsi*270+175)*1+lsi)*1] + fp273;
target[((hsi*360+223)*1+lsi)*1] = fp272;
LIBINT2_REALTYPE fp271;
fp271 = inteval->CD_z[vi] * src1[((hsi*216+133)*1+lsi)*1];
LIBINT2_REALTYPE fp270;
fp270 = src0[((hsi*270+181)*1+lsi)*1] + fp271;
target[((hsi*360+224)*1+lsi)*1] = fp270;
LIBINT2_REALTYPE fp291;
fp291 = inteval->CD_z[vi] * src1[((hsi*216+127)*1+lsi)*1];
LIBINT2_REALTYPE fp290;
fp290 = src0[((hsi*270+175)*1+lsi)*1] + fp291;
target[((hsi*360+214)*1+lsi)*1] = fp290;
LIBINT2_REALTYPE fp357;
fp357 = inteval->CD_y[vi] * src1[((hsi*216+108)*1+lsi)*1];
LIBINT2_REALTYPE fp356;
fp356 = src0[((hsi*270+144)*1+lsi)*1] + fp357;
target[((hsi*360+181)*1+lsi)*1] = fp356;
LIBINT2_REALTYPE fp355;
fp355 = inteval->CD_z[vi] * src1[((hsi*216+108)*1+lsi)*1];
LIBINT2_REALTYPE fp354;
fp354 = src0[((hsi*270+150)*1+lsi)*1] + fp355;
target[((hsi*360+182)*1+lsi)*1] = fp354;
LIBINT2_REALTYPE fp353;
fp353 = inteval->CD_y[vi] * src1[((hsi*216+109)*1+lsi)*1];
LIBINT2_REALTYPE fp352;
fp352 = src0[((hsi*270+145)*1+lsi)*1] + fp353;
target[((hsi*360+183)*1+lsi)*1] = fp352;
LIBINT2_REALTYPE fp351;
fp351 = inteval->CD_z[vi] * src1[((hsi*216+109)*1+lsi)*1];
LIBINT2_REALTYPE fp350;
fp350 = src0[((hsi*270+151)*1+lsi)*1] + fp351;
target[((hsi*360+184)*1+lsi)*1] = fp350;
LIBINT2_REALTYPE fp349;
fp349 = inteval->CD_z[vi] * src1[((hsi*216+110)*1+lsi)*1];
LIBINT2_REALTYPE fp348;
fp348 = src0[((hsi*270+152)*1+lsi)*1] + fp349;
target[((hsi*360+185)*1+lsi)*1] = fp348;
LIBINT2_REALTYPE fp347;
fp347 = inteval->CD_y[vi] * src1[((hsi*216+111)*1+lsi)*1];
LIBINT2_REALTYPE fp346;
fp346 = src0[((hsi*270+147)*1+lsi)*1] + fp347;
target[((hsi*360+186)*1+lsi)*1] = fp346;
LIBINT2_REALTYPE fp345;
fp345 = inteval->CD_z[vi] * src1[((hsi*216+111)*1+lsi)*1];
LIBINT2_REALTYPE fp344;
fp344 = src0[((hsi*270+153)*1+lsi)*1] + fp345;
target[((hsi*360+187)*1+lsi)*1] = fp344;
LIBINT2_REALTYPE fp343;
fp343 = inteval->CD_z[vi] * src1[((hsi*216+112)*1+lsi)*1];
LIBINT2_REALTYPE fp342;
fp342 = src0[((hsi*270+154)*1+lsi)*1] + fp343;
target[((hsi*360+188)*1+lsi)*1] = fp342;
LIBINT2_REALTYPE fp341;
fp341 = inteval->CD_z[vi] * src1[((hsi*216+113)*1+lsi)*1];
LIBINT2_REALTYPE fp340;
fp340 = src0[((hsi*270+155)*1+lsi)*1] + fp341;
target[((hsi*360+189)*1+lsi)*1] = fp340;
LIBINT2_REALTYPE fp339;
fp339 = inteval->CD_x[vi] * src1[((hsi*216+114)*1+lsi)*1];
LIBINT2_REALTYPE fp338;
fp338 = src0[((hsi*270+114)*1+lsi)*1] + fp339;
target[((hsi*360+190)*1+lsi)*1] = fp338;
LIBINT2_REALTYPE fp313;
fp313 = inteval->CD_y[vi] * src1[((hsi*216+121)*1+lsi)*1];
LIBINT2_REALTYPE fp312;
fp312 = src0[((hsi*270+157)*1+lsi)*1] + fp313;
target[((hsi*360+203)*1+lsi)*1] = fp312;
LIBINT2_REALTYPE fp335;
fp335 = inteval->CD_z[vi] * src1[((hsi*216+114)*1+lsi)*1];
LIBINT2_REALTYPE fp334;
fp334 = src0[((hsi*270+156)*1+lsi)*1] + fp335;
target[((hsi*360+192)*1+lsi)*1] = fp334;
LIBINT2_REALTYPE fp333;
fp333 = inteval->CD_y[vi] * src1[((hsi*216+115)*1+lsi)*1];
LIBINT2_REALTYPE fp332;
fp332 = src0[((hsi*270+151)*1+lsi)*1] + fp333;
target[((hsi*360+193)*1+lsi)*1] = fp332;
LIBINT2_REALTYPE fp331;
fp331 = inteval->CD_z[vi] * src1[((hsi*216+115)*1+lsi)*1];
LIBINT2_REALTYPE fp330;
fp330 = src0[((hsi*270+157)*1+lsi)*1] + fp331;
target[((hsi*360+194)*1+lsi)*1] = fp330;
LIBINT2_REALTYPE fp329;
fp329 = inteval->CD_z[vi] * src1[((hsi*216+116)*1+lsi)*1];
LIBINT2_REALTYPE fp328;
fp328 = src0[((hsi*270+158)*1+lsi)*1] + fp329;
target[((hsi*360+195)*1+lsi)*1] = fp328;
LIBINT2_REALTYPE fp327;
fp327 = inteval->CD_y[vi] * src1[((hsi*216+117)*1+lsi)*1];
LIBINT2_REALTYPE fp326;
fp326 = src0[((hsi*270+153)*1+lsi)*1] + fp327;
target[((hsi*360+196)*1+lsi)*1] = fp326;
LIBINT2_REALTYPE fp325;
fp325 = inteval->CD_z[vi] * src1[((hsi*216+117)*1+lsi)*1];
LIBINT2_REALTYPE fp324;
fp324 = src0[((hsi*270+159)*1+lsi)*1] + fp325;
target[((hsi*360+197)*1+lsi)*1] = fp324;
LIBINT2_REALTYPE fp323;
fp323 = inteval->CD_z[vi] * src1[((hsi*216+118)*1+lsi)*1];
LIBINT2_REALTYPE fp322;
fp322 = src0[((hsi*270+160)*1+lsi)*1] + fp323;
target[((hsi*360+198)*1+lsi)*1] = fp322;
LIBINT2_REALTYPE fp321;
fp321 = inteval->CD_z[vi] * src1[((hsi*216+119)*1+lsi)*1];
LIBINT2_REALTYPE fp320;
fp320 = src0[((hsi*270+161)*1+lsi)*1] + fp321;
target[((hsi*360+199)*1+lsi)*1] = fp320;
LIBINT2_REALTYPE fp319;
fp319 = inteval->CD_x[vi] * src1[((hsi*216+120)*1+lsi)*1];
LIBINT2_REALTYPE fp318;
fp318 = src0[((hsi*270+120)*1+lsi)*1] + fp319;
target[((hsi*360+200)*1+lsi)*1] = fp318;
LIBINT2_REALTYPE fp317;
fp317 = inteval->CD_y[vi] * src1[((hsi*216+120)*1+lsi)*1];
LIBINT2_REALTYPE fp316;
fp316 = src0[((hsi*270+156)*1+lsi)*1] + fp317;
target[((hsi*360+201)*1+lsi)*1] = fp316;
LIBINT2_REALTYPE fp315;
fp315 = inteval->CD_z[vi] * src1[((hsi*216+120)*1+lsi)*1];
LIBINT2_REALTYPE fp314;
fp314 = src0[((hsi*270+162)*1+lsi)*1] + fp315;
target[((hsi*360+202)*1+lsi)*1] = fp314;
LIBINT2_REALTYPE fp337;
fp337 = inteval->CD_y[vi] * src1[((hsi*216+114)*1+lsi)*1];
LIBINT2_REALTYPE fp336;
fp336 = src0[((hsi*270+150)*1+lsi)*1] + fp337;
target[((hsi*360+191)*1+lsi)*1] = fp336;
LIBINT2_REALTYPE fp221;
fp221 = inteval->CD_z[vi] * src1[((hsi*216+149)*1+lsi)*1];
LIBINT2_REALTYPE fp220;
fp220 = src0[((hsi*270+197)*1+lsi)*1] + fp221;
target[((hsi*360+249)*1+lsi)*1] = fp220;
LIBINT2_REALTYPE fp219;
fp219 = inteval->CD_x[vi] * src1[((hsi*216+150)*1+lsi)*1];
LIBINT2_REALTYPE fp218;
fp218 = src0[((hsi*270+150)*1+lsi)*1] + fp219;
target[((hsi*360+250)*1+lsi)*1] = fp218;
LIBINT2_REALTYPE fp217;
fp217 = inteval->CD_y[vi] * src1[((hsi*216+150)*1+lsi)*1];
LIBINT2_REALTYPE fp216;
fp216 = src0[((hsi*270+192)*1+lsi)*1] + fp217;
target[((hsi*360+251)*1+lsi)*1] = fp216;
LIBINT2_REALTYPE fp215;
fp215 = inteval->CD_z[vi] * src1[((hsi*216+150)*1+lsi)*1];
LIBINT2_REALTYPE fp214;
fp214 = src0[((hsi*270+198)*1+lsi)*1] + fp215;
target[((hsi*360+252)*1+lsi)*1] = fp214;
LIBINT2_REALTYPE fp213;
fp213 = inteval->CD_y[vi] * src1[((hsi*216+151)*1+lsi)*1];
LIBINT2_REALTYPE fp212;
fp212 = src0[((hsi*270+193)*1+lsi)*1] + fp213;
target[((hsi*360+253)*1+lsi)*1] = fp212;
LIBINT2_REALTYPE fp211;
fp211 = inteval->CD_z[vi] * src1[((hsi*216+151)*1+lsi)*1];
LIBINT2_REALTYPE fp210;
fp210 = src0[((hsi*270+199)*1+lsi)*1] + fp211;
target[((hsi*360+254)*1+lsi)*1] = fp210;
LIBINT2_REALTYPE fp209;
fp209 = inteval->CD_z[vi] * src1[((hsi*216+152)*1+lsi)*1];
LIBINT2_REALTYPE fp208;
fp208 = src0[((hsi*270+200)*1+lsi)*1] + fp209;
target[((hsi*360+255)*1+lsi)*1] = fp208;
LIBINT2_REALTYPE fp207;
fp207 = inteval->CD_y[vi] * src1[((hsi*216+153)*1+lsi)*1];
LIBINT2_REALTYPE fp206;
fp206 = src0[((hsi*270+195)*1+lsi)*1] + fp207;
target[((hsi*360+256)*1+lsi)*1] = fp206;
LIBINT2_REALTYPE fp205;
fp205 = inteval->CD_z[vi] * src1[((hsi*216+153)*1+lsi)*1];
LIBINT2_REALTYPE fp204;
fp204 = src0[((hsi*270+201)*1+lsi)*1] + fp205;
target[((hsi*360+257)*1+lsi)*1] = fp204;
LIBINT2_REALTYPE fp203;
fp203 = inteval->CD_z[vi] * src1[((hsi*216+154)*1+lsi)*1];
LIBINT2_REALTYPE fp202;
fp202 = src0[((hsi*270+202)*1+lsi)*1] + fp203;
target[((hsi*360+258)*1+lsi)*1] = fp202;
LIBINT2_REALTYPE fp269;
fp269 = inteval->CD_z[vi] * src1[((hsi*216+134)*1+lsi)*1];
LIBINT2_REALTYPE fp268;
fp268 = src0[((hsi*270+182)*1+lsi)*1] + fp269;
target[((hsi*360+225)*1+lsi)*1] = fp268;
LIBINT2_REALTYPE fp199;
fp199 = inteval->CD_x[vi] * src1[((hsi*216+156)*1+lsi)*1];
LIBINT2_REALTYPE fp198;
fp198 = src0[((hsi*270+156)*1+lsi)*1] + fp199;
target[((hsi*360+260)*1+lsi)*1] = fp198;
LIBINT2_REALTYPE fp197;
fp197 = inteval->CD_y[vi] * src1[((hsi*216+156)*1+lsi)*1];
LIBINT2_REALTYPE fp196;
fp196 = src0[((hsi*270+198)*1+lsi)*1] + fp197;
target[((hsi*360+261)*1+lsi)*1] = fp196;
LIBINT2_REALTYPE fp195;
fp195 = inteval->CD_z[vi] * src1[((hsi*216+156)*1+lsi)*1];
LIBINT2_REALTYPE fp194;
fp194 = src0[((hsi*270+204)*1+lsi)*1] + fp195;
target[((hsi*360+262)*1+lsi)*1] = fp194;
LIBINT2_REALTYPE fp193;
fp193 = inteval->CD_y[vi] * src1[((hsi*216+157)*1+lsi)*1];
LIBINT2_REALTYPE fp192;
fp192 = src0[((hsi*270+199)*1+lsi)*1] + fp193;
target[((hsi*360+263)*1+lsi)*1] = fp192;
LIBINT2_REALTYPE fp191;
fp191 = inteval->CD_z[vi] * src1[((hsi*216+157)*1+lsi)*1];
LIBINT2_REALTYPE fp190;
fp190 = src0[((hsi*270+205)*1+lsi)*1] + fp191;
target[((hsi*360+264)*1+lsi)*1] = fp190;
LIBINT2_REALTYPE fp189;
fp189 = inteval->CD_z[vi] * src1[((hsi*216+158)*1+lsi)*1];
LIBINT2_REALTYPE fp188;
fp188 = src0[((hsi*270+206)*1+lsi)*1] + fp189;
target[((hsi*360+265)*1+lsi)*1] = fp188;
LIBINT2_REALTYPE fp187;
fp187 = inteval->CD_y[vi] * src1[((hsi*216+159)*1+lsi)*1];
LIBINT2_REALTYPE fp186;
fp186 = src0[((hsi*270+201)*1+lsi)*1] + fp187;
target[((hsi*360+266)*1+lsi)*1] = fp186;
LIBINT2_REALTYPE fp185;
fp185 = inteval->CD_z[vi] * src1[((hsi*216+159)*1+lsi)*1];
LIBINT2_REALTYPE fp184;
fp184 = src0[((hsi*270+207)*1+lsi)*1] + fp185;
target[((hsi*360+267)*1+lsi)*1] = fp184;
LIBINT2_REALTYPE fp183;
fp183 = inteval->CD_z[vi] * src1[((hsi*216+160)*1+lsi)*1];
LIBINT2_REALTYPE fp182;
fp182 = src0[((hsi*270+208)*1+lsi)*1] + fp183;
target[((hsi*360+268)*1+lsi)*1] = fp182;
LIBINT2_REALTYPE fp181;
fp181 = inteval->CD_z[vi] * src1[((hsi*216+161)*1+lsi)*1];
LIBINT2_REALTYPE fp180;
fp180 = src0[((hsi*270+209)*1+lsi)*1] + fp181;
target[((hsi*360+269)*1+lsi)*1] = fp180;
LIBINT2_REALTYPE fp201;
fp201 = inteval->CD_z[vi] * src1[((hsi*216+155)*1+lsi)*1];
LIBINT2_REALTYPE fp200;
fp200 = src0[((hsi*270+203)*1+lsi)*1] + fp201;
target[((hsi*360+259)*1+lsi)*1] = fp200;
LIBINT2_REALTYPE fp267;
fp267 = inteval->CD_y[vi] * src1[((hsi*216+135)*1+lsi)*1];
LIBINT2_REALTYPE fp266;
fp266 = src0[((hsi*270+177)*1+lsi)*1] + fp267;
target[((hsi*360+226)*1+lsi)*1] = fp266;
LIBINT2_REALTYPE fp265;
fp265 = inteval->CD_z[vi] * src1[((hsi*216+135)*1+lsi)*1];
LIBINT2_REALTYPE fp264;
fp264 = src0[((hsi*270+183)*1+lsi)*1] + fp265;
target[((hsi*360+227)*1+lsi)*1] = fp264;
LIBINT2_REALTYPE fp263;
fp263 = inteval->CD_z[vi] * src1[((hsi*216+136)*1+lsi)*1];
LIBINT2_REALTYPE fp262;
fp262 = src0[((hsi*270+184)*1+lsi)*1] + fp263;
target[((hsi*360+228)*1+lsi)*1] = fp262;
LIBINT2_REALTYPE fp261;
fp261 = inteval->CD_z[vi] * src1[((hsi*216+137)*1+lsi)*1];
LIBINT2_REALTYPE fp260;
fp260 = src0[((hsi*270+185)*1+lsi)*1] + fp261;
target[((hsi*360+229)*1+lsi)*1] = fp260;
LIBINT2_REALTYPE fp259;
fp259 = inteval->CD_x[vi] * src1[((hsi*216+138)*1+lsi)*1];
LIBINT2_REALTYPE fp258;
fp258 = src0[((hsi*270+138)*1+lsi)*1] + fp259;
target[((hsi*360+230)*1+lsi)*1] = fp258;
LIBINT2_REALTYPE fp257;
fp257 = inteval->CD_y[vi] * src1[((hsi*216+138)*1+lsi)*1];
LIBINT2_REALTYPE fp256;
fp256 = src0[((hsi*270+180)*1+lsi)*1] + fp257;
target[((hsi*360+231)*1+lsi)*1] = fp256;
LIBINT2_REALTYPE fp255;
fp255 = inteval->CD_z[vi] * src1[((hsi*216+138)*1+lsi)*1];
LIBINT2_REALTYPE fp254;
fp254 = src0[((hsi*270+186)*1+lsi)*1] + fp255;
target[((hsi*360+232)*1+lsi)*1] = fp254;
LIBINT2_REALTYPE fp253;
fp253 = inteval->CD_y[vi] * src1[((hsi*216+139)*1+lsi)*1];
LIBINT2_REALTYPE fp252;
fp252 = src0[((hsi*270+181)*1+lsi)*1] + fp253;
target[((hsi*360+233)*1+lsi)*1] = fp252;
LIBINT2_REALTYPE fp251;
fp251 = inteval->CD_z[vi] * src1[((hsi*216+139)*1+lsi)*1];
LIBINT2_REALTYPE fp250;
fp250 = src0[((hsi*270+187)*1+lsi)*1] + fp251;
target[((hsi*360+234)*1+lsi)*1] = fp250;
LIBINT2_REALTYPE fp249;
fp249 = inteval->CD_z[vi] * src1[((hsi*216+140)*1+lsi)*1];
LIBINT2_REALTYPE fp248;
fp248 = src0[((hsi*270+188)*1+lsi)*1] + fp249;
target[((hsi*360+235)*1+lsi)*1] = fp248;
LIBINT2_REALTYPE fp223;
fp223 = inteval->CD_z[vi] * src1[((hsi*216+148)*1+lsi)*1];
LIBINT2_REALTYPE fp222;
fp222 = src0[((hsi*270+196)*1+lsi)*1] + fp223;
target[((hsi*360+248)*1+lsi)*1] = fp222;
LIBINT2_REALTYPE fp245;
fp245 = inteval->CD_z[vi] * src1[((hsi*216+141)*1+lsi)*1];
LIBINT2_REALTYPE fp244;
fp244 = src0[((hsi*270+189)*1+lsi)*1] + fp245;
target[((hsi*360+237)*1+lsi)*1] = fp244;
LIBINT2_REALTYPE fp243;
fp243 = inteval->CD_z[vi] * src1[((hsi*216+142)*1+lsi)*1];
LIBINT2_REALTYPE fp242;
fp242 = src0[((hsi*270+190)*1+lsi)*1] + fp243;
target[((hsi*360+238)*1+lsi)*1] = fp242;
LIBINT2_REALTYPE fp241;
fp241 = inteval->CD_z[vi] * src1[((hsi*216+143)*1+lsi)*1];
LIBINT2_REALTYPE fp240;
fp240 = src0[((hsi*270+191)*1+lsi)*1] + fp241;
target[((hsi*360+239)*1+lsi)*1] = fp240;
LIBINT2_REALTYPE fp239;
fp239 = inteval->CD_x[vi] * src1[((hsi*216+144)*1+lsi)*1];
LIBINT2_REALTYPE fp238;
fp238 = src0[((hsi*270+144)*1+lsi)*1] + fp239;
target[((hsi*360+240)*1+lsi)*1] = fp238;
LIBINT2_REALTYPE fp237;
fp237 = inteval->CD_y[vi] * src1[((hsi*216+144)*1+lsi)*1];
LIBINT2_REALTYPE fp236;
fp236 = src0[((hsi*270+186)*1+lsi)*1] + fp237;
target[((hsi*360+241)*1+lsi)*1] = fp236;
LIBINT2_REALTYPE fp235;
fp235 = inteval->CD_z[vi] * src1[((hsi*216+144)*1+lsi)*1];
LIBINT2_REALTYPE fp234;
fp234 = src0[((hsi*270+192)*1+lsi)*1] + fp235;
target[((hsi*360+242)*1+lsi)*1] = fp234;
LIBINT2_REALTYPE fp233;
fp233 = inteval->CD_y[vi] * src1[((hsi*216+145)*1+lsi)*1];
LIBINT2_REALTYPE fp232;
fp232 = src0[((hsi*270+187)*1+lsi)*1] + fp233;
target[((hsi*360+243)*1+lsi)*1] = fp232;
LIBINT2_REALTYPE fp231;
fp231 = inteval->CD_z[vi] * src1[((hsi*216+145)*1+lsi)*1];
LIBINT2_REALTYPE fp230;
fp230 = src0[((hsi*270+193)*1+lsi)*1] + fp231;
target[((hsi*360+244)*1+lsi)*1] = fp230;
LIBINT2_REALTYPE fp229;
fp229 = inteval->CD_z[vi] * src1[((hsi*216+146)*1+lsi)*1];
LIBINT2_REALTYPE fp228;
fp228 = src0[((hsi*270+194)*1+lsi)*1] + fp229;
target[((hsi*360+245)*1+lsi)*1] = fp228;
LIBINT2_REALTYPE fp227;
fp227 = inteval->CD_y[vi] * src1[((hsi*216+147)*1+lsi)*1];
LIBINT2_REALTYPE fp226;
fp226 = src0[((hsi*270+189)*1+lsi)*1] + fp227;
target[((hsi*360+246)*1+lsi)*1] = fp226;
LIBINT2_REALTYPE fp225;
fp225 = inteval->CD_z[vi] * src1[((hsi*216+147)*1+lsi)*1];
LIBINT2_REALTYPE fp224;
fp224 = src0[((hsi*270+195)*1+lsi)*1] + fp225;
target[((hsi*360+247)*1+lsi)*1] = fp224;
LIBINT2_REALTYPE fp247;
fp247 = inteval->CD_y[vi] * src1[((hsi*216+141)*1+lsi)*1];
LIBINT2_REALTYPE fp246;
fp246 = src0[((hsi*270+183)*1+lsi)*1] + fp247;
target[((hsi*360+236)*1+lsi)*1] = fp246;
}
}
}
const int hsi = 0;
const int lsi = 0;
const int vi = 0;
/** Number of flops = 720 */
}

#ifdef __cplusplus
};
#endif
