/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <libint2.h>

#ifdef __cplusplus
extern "C" {
#endif
void HRRPart1bra0ket0kd001(const Libint_t* inteval, LIBINT2_REALTYPE* target, const LIBINT2_REALTYPE* src0, const LIBINT2_REALTYPE* src1, const LIBINT2_REALTYPE* src2, int highdim) {

LIBINT2_REALTYPE*const  stack = target;
#ifdef __INTEL_COMPILER
#pragma ivdep
#endif
for(int hsi = 0; hsi<highdim; hsi++) {
{
const int lsi = 0;
{
const int vi = 0;
LIBINT2_REALTYPE fp407;
fp407 = 1.0000000000000000e+00 * src2[((hsi*108+39)*1+lsi)*1];
LIBINT2_REALTYPE fp409;
fp409 = inteval->CD_z[vi] * src1[((hsi*108+39)*1+lsi)*1];
LIBINT2_REALTYPE fp408;
fp408 = src0[((hsi*135+57)*1+lsi)*1] + fp409;
LIBINT2_REALTYPE fp406;
fp406 = fp408 - fp407;
target[((hsi*216+80)*1+lsi)*1] = fp406;
LIBINT2_REALTYPE fp411;
fp411 = inteval->CD_y[vi] * src1[((hsi*108+39)*1+lsi)*1];
LIBINT2_REALTYPE fp410;
fp410 = src0[((hsi*135+54)*1+lsi)*1] + fp411;
target[((hsi*216+79)*1+lsi)*1] = fp410;
LIBINT2_REALTYPE fp413;
fp413 = inteval->CD_x[vi] * src1[((hsi*108+39)*1+lsi)*1];
LIBINT2_REALTYPE fp412;
fp412 = src0[((hsi*135+39)*1+lsi)*1] + fp413;
target[((hsi*216+78)*1+lsi)*1] = fp412;
LIBINT2_REALTYPE fp415;
fp415 = 1.0000000000000000e+00 * src2[((hsi*108+38)*1+lsi)*1];
LIBINT2_REALTYPE fp417;
fp417 = inteval->CD_z[vi] * src1[((hsi*108+38)*1+lsi)*1];
LIBINT2_REALTYPE fp416;
fp416 = src0[((hsi*135+56)*1+lsi)*1] + fp417;
LIBINT2_REALTYPE fp414;
fp414 = fp416 - fp415;
target[((hsi*216+77)*1+lsi)*1] = fp414;
LIBINT2_REALTYPE fp419;
fp419 = 1.0000000000000000e+00 * src2[((hsi*108+37)*1+lsi)*1];
LIBINT2_REALTYPE fp421;
fp421 = inteval->CD_z[vi] * src1[((hsi*108+37)*1+lsi)*1];
LIBINT2_REALTYPE fp420;
fp420 = src0[((hsi*135+55)*1+lsi)*1] + fp421;
LIBINT2_REALTYPE fp418;
fp418 = fp420 - fp419;
target[((hsi*216+76)*1+lsi)*1] = fp418;
LIBINT2_REALTYPE fp423;
fp423 = inteval->CD_y[vi] * src1[((hsi*108+37)*1+lsi)*1];
LIBINT2_REALTYPE fp422;
fp422 = src0[((hsi*135+52)*1+lsi)*1] + fp423;
target[((hsi*216+75)*1+lsi)*1] = fp422;
LIBINT2_REALTYPE fp425;
fp425 = 1.0000000000000000e+00 * src2[((hsi*108+36)*1+lsi)*1];
LIBINT2_REALTYPE fp427;
fp427 = inteval->CD_z[vi] * src1[((hsi*108+36)*1+lsi)*1];
LIBINT2_REALTYPE fp426;
fp426 = src0[((hsi*135+54)*1+lsi)*1] + fp427;
LIBINT2_REALTYPE fp424;
fp424 = fp426 - fp425;
target[((hsi*216+74)*1+lsi)*1] = fp424;
LIBINT2_REALTYPE fp429;
fp429 = inteval->CD_y[vi] * src1[((hsi*108+36)*1+lsi)*1];
LIBINT2_REALTYPE fp428;
fp428 = src0[((hsi*135+51)*1+lsi)*1] + fp429;
target[((hsi*216+73)*1+lsi)*1] = fp428;
LIBINT2_REALTYPE fp431;
fp431 = inteval->CD_x[vi] * src1[((hsi*108+36)*1+lsi)*1];
LIBINT2_REALTYPE fp430;
fp430 = src0[((hsi*135+36)*1+lsi)*1] + fp431;
target[((hsi*216+72)*1+lsi)*1] = fp430;
LIBINT2_REALTYPE fp433;
fp433 = 1.0000000000000000e+00 * src2[((hsi*108+35)*1+lsi)*1];
LIBINT2_REALTYPE fp435;
fp435 = inteval->CD_z[vi] * src1[((hsi*108+35)*1+lsi)*1];
LIBINT2_REALTYPE fp434;
fp434 = src0[((hsi*135+53)*1+lsi)*1] + fp435;
LIBINT2_REALTYPE fp432;
fp432 = fp434 - fp433;
target[((hsi*216+71)*1+lsi)*1] = fp432;
LIBINT2_REALTYPE fp437;
fp437 = 1.0000000000000000e+00 * src2[((hsi*108+34)*1+lsi)*1];
LIBINT2_REALTYPE fp439;
fp439 = inteval->CD_z[vi] * src1[((hsi*108+34)*1+lsi)*1];
LIBINT2_REALTYPE fp438;
fp438 = src0[((hsi*135+52)*1+lsi)*1] + fp439;
LIBINT2_REALTYPE fp436;
fp436 = fp438 - fp437;
target[((hsi*216+70)*1+lsi)*1] = fp436;
LIBINT2_REALTYPE fp441;
fp441 = inteval->CD_y[vi] * src1[((hsi*108+34)*1+lsi)*1];
LIBINT2_REALTYPE fp440;
fp440 = src0[((hsi*135+49)*1+lsi)*1] + fp441;
target[((hsi*216+69)*1+lsi)*1] = fp440;
LIBINT2_REALTYPE fp647;
fp647 = inteval->CD_x[vi] * src1[((hsi*108+0)*1+lsi)*1];
LIBINT2_REALTYPE fp646;
fp646 = src0[((hsi*135+0)*1+lsi)*1] + fp647;
target[((hsi*216+0)*1+lsi)*1] = fp646;
LIBINT2_REALTYPE fp447;
fp447 = inteval->CD_y[vi] * src1[((hsi*108+33)*1+lsi)*1];
LIBINT2_REALTYPE fp446;
fp446 = src0[((hsi*135+48)*1+lsi)*1] + fp447;
target[((hsi*216+67)*1+lsi)*1] = fp446;
LIBINT2_REALTYPE fp449;
fp449 = inteval->CD_x[vi] * src1[((hsi*108+33)*1+lsi)*1];
LIBINT2_REALTYPE fp448;
fp448 = src0[((hsi*135+33)*1+lsi)*1] + fp449;
target[((hsi*216+66)*1+lsi)*1] = fp448;
LIBINT2_REALTYPE fp451;
fp451 = 1.0000000000000000e+00 * src2[((hsi*108+32)*1+lsi)*1];
LIBINT2_REALTYPE fp453;
fp453 = inteval->CD_z[vi] * src1[((hsi*108+32)*1+lsi)*1];
LIBINT2_REALTYPE fp452;
fp452 = src0[((hsi*135+50)*1+lsi)*1] + fp453;
LIBINT2_REALTYPE fp450;
fp450 = fp452 - fp451;
target[((hsi*216+65)*1+lsi)*1] = fp450;
LIBINT2_REALTYPE fp455;
fp455 = 1.0000000000000000e+00 * src2[((hsi*108+31)*1+lsi)*1];
LIBINT2_REALTYPE fp457;
fp457 = inteval->CD_z[vi] * src1[((hsi*108+31)*1+lsi)*1];
LIBINT2_REALTYPE fp456;
fp456 = src0[((hsi*135+49)*1+lsi)*1] + fp457;
LIBINT2_REALTYPE fp454;
fp454 = fp456 - fp455;
target[((hsi*216+64)*1+lsi)*1] = fp454;
LIBINT2_REALTYPE fp459;
fp459 = inteval->CD_y[vi] * src1[((hsi*108+31)*1+lsi)*1];
LIBINT2_REALTYPE fp458;
fp458 = src0[((hsi*135+46)*1+lsi)*1] + fp459;
target[((hsi*216+63)*1+lsi)*1] = fp458;
LIBINT2_REALTYPE fp461;
fp461 = 1.0000000000000000e+00 * src2[((hsi*108+30)*1+lsi)*1];
LIBINT2_REALTYPE fp463;
fp463 = inteval->CD_z[vi] * src1[((hsi*108+30)*1+lsi)*1];
LIBINT2_REALTYPE fp462;
fp462 = src0[((hsi*135+48)*1+lsi)*1] + fp463;
LIBINT2_REALTYPE fp460;
fp460 = fp462 - fp461;
target[((hsi*216+62)*1+lsi)*1] = fp460;
LIBINT2_REALTYPE fp465;
fp465 = inteval->CD_y[vi] * src1[((hsi*108+30)*1+lsi)*1];
LIBINT2_REALTYPE fp464;
fp464 = src0[((hsi*135+45)*1+lsi)*1] + fp465;
target[((hsi*216+61)*1+lsi)*1] = fp464;
LIBINT2_REALTYPE fp467;
fp467 = inteval->CD_x[vi] * src1[((hsi*108+30)*1+lsi)*1];
LIBINT2_REALTYPE fp466;
fp466 = src0[((hsi*135+30)*1+lsi)*1] + fp467;
target[((hsi*216+60)*1+lsi)*1] = fp466;
LIBINT2_REALTYPE fp469;
fp469 = 1.0000000000000000e+00 * src2[((hsi*108+29)*1+lsi)*1];
LIBINT2_REALTYPE fp471;
fp471 = inteval->CD_z[vi] * src1[((hsi*108+29)*1+lsi)*1];
LIBINT2_REALTYPE fp470;
fp470 = src0[((hsi*135+44)*1+lsi)*1] + fp471;
LIBINT2_REALTYPE fp468;
fp468 = fp470 - fp469;
target[((hsi*216+59)*1+lsi)*1] = fp468;
LIBINT2_REALTYPE fp473;
fp473 = 1.0000000000000000e+00 * src2[((hsi*108+28)*1+lsi)*1];
LIBINT2_REALTYPE fp475;
fp475 = inteval->CD_z[vi] * src1[((hsi*108+28)*1+lsi)*1];
LIBINT2_REALTYPE fp474;
fp474 = src0[((hsi*135+43)*1+lsi)*1] + fp475;
LIBINT2_REALTYPE fp472;
fp472 = fp474 - fp473;
target[((hsi*216+58)*1+lsi)*1] = fp472;
LIBINT2_REALTYPE fp477;
fp477 = inteval->CD_y[vi] * src1[((hsi*108+28)*1+lsi)*1];
LIBINT2_REALTYPE fp476;
fp476 = src0[((hsi*135+40)*1+lsi)*1] + fp477;
target[((hsi*216+57)*1+lsi)*1] = fp476;
LIBINT2_REALTYPE fp479;
fp479 = 1.0000000000000000e+00 * src2[((hsi*108+27)*1+lsi)*1];
LIBINT2_REALTYPE fp481;
fp481 = inteval->CD_z[vi] * src1[((hsi*108+27)*1+lsi)*1];
LIBINT2_REALTYPE fp480;
fp480 = src0[((hsi*135+42)*1+lsi)*1] + fp481;
LIBINT2_REALTYPE fp478;
fp478 = fp480 - fp479;
target[((hsi*216+56)*1+lsi)*1] = fp478;
LIBINT2_REALTYPE fp483;
fp483 = inteval->CD_y[vi] * src1[((hsi*108+27)*1+lsi)*1];
LIBINT2_REALTYPE fp482;
fp482 = src0[((hsi*135+39)*1+lsi)*1] + fp483;
target[((hsi*216+55)*1+lsi)*1] = fp482;
LIBINT2_REALTYPE fp443;
fp443 = 1.0000000000000000e+00 * src2[((hsi*108+33)*1+lsi)*1];
LIBINT2_REALTYPE fp445;
fp445 = inteval->CD_z[vi] * src1[((hsi*108+33)*1+lsi)*1];
LIBINT2_REALTYPE fp444;
fp444 = src0[((hsi*135+51)*1+lsi)*1] + fp445;
LIBINT2_REALTYPE fp442;
fp442 = fp444 - fp443;
target[((hsi*216+68)*1+lsi)*1] = fp442;
LIBINT2_REALTYPE fp325;
fp325 = 1.0000000000000000e+00 * src2[((hsi*108+53)*1+lsi)*1];
LIBINT2_REALTYPE fp327;
fp327 = inteval->CD_z[vi] * src1[((hsi*108+53)*1+lsi)*1];
LIBINT2_REALTYPE fp326;
fp326 = src0[((hsi*135+74)*1+lsi)*1] + fp327;
LIBINT2_REALTYPE fp324;
fp324 = fp326 - fp325;
target[((hsi*216+107)*1+lsi)*1] = fp324;
LIBINT2_REALTYPE fp329;
fp329 = 1.0000000000000000e+00 * src2[((hsi*108+52)*1+lsi)*1];
LIBINT2_REALTYPE fp331;
fp331 = inteval->CD_z[vi] * src1[((hsi*108+52)*1+lsi)*1];
LIBINT2_REALTYPE fp330;
fp330 = src0[((hsi*135+73)*1+lsi)*1] + fp331;
LIBINT2_REALTYPE fp328;
fp328 = fp330 - fp329;
target[((hsi*216+106)*1+lsi)*1] = fp328;
LIBINT2_REALTYPE fp333;
fp333 = inteval->CD_y[vi] * src1[((hsi*108+52)*1+lsi)*1];
LIBINT2_REALTYPE fp332;
fp332 = src0[((hsi*135+70)*1+lsi)*1] + fp333;
target[((hsi*216+105)*1+lsi)*1] = fp332;
LIBINT2_REALTYPE fp335;
fp335 = 1.0000000000000000e+00 * src2[((hsi*108+51)*1+lsi)*1];
LIBINT2_REALTYPE fp337;
fp337 = inteval->CD_z[vi] * src1[((hsi*108+51)*1+lsi)*1];
LIBINT2_REALTYPE fp336;
fp336 = src0[((hsi*135+72)*1+lsi)*1] + fp337;
LIBINT2_REALTYPE fp334;
fp334 = fp336 - fp335;
target[((hsi*216+104)*1+lsi)*1] = fp334;
LIBINT2_REALTYPE fp339;
fp339 = inteval->CD_y[vi] * src1[((hsi*108+51)*1+lsi)*1];
LIBINT2_REALTYPE fp338;
fp338 = src0[((hsi*135+69)*1+lsi)*1] + fp339;
target[((hsi*216+103)*1+lsi)*1] = fp338;
LIBINT2_REALTYPE fp341;
fp341 = inteval->CD_x[vi] * src1[((hsi*108+51)*1+lsi)*1];
LIBINT2_REALTYPE fp340;
fp340 = src0[((hsi*135+51)*1+lsi)*1] + fp341;
target[((hsi*216+102)*1+lsi)*1] = fp340;
LIBINT2_REALTYPE fp343;
fp343 = 1.0000000000000000e+00 * src2[((hsi*108+50)*1+lsi)*1];
LIBINT2_REALTYPE fp345;
fp345 = inteval->CD_z[vi] * src1[((hsi*108+50)*1+lsi)*1];
LIBINT2_REALTYPE fp344;
fp344 = src0[((hsi*135+71)*1+lsi)*1] + fp345;
LIBINT2_REALTYPE fp342;
fp342 = fp344 - fp343;
target[((hsi*216+101)*1+lsi)*1] = fp342;
LIBINT2_REALTYPE fp347;
fp347 = 1.0000000000000000e+00 * src2[((hsi*108+49)*1+lsi)*1];
LIBINT2_REALTYPE fp349;
fp349 = inteval->CD_z[vi] * src1[((hsi*108+49)*1+lsi)*1];
LIBINT2_REALTYPE fp348;
fp348 = src0[((hsi*135+70)*1+lsi)*1] + fp349;
LIBINT2_REALTYPE fp346;
fp346 = fp348 - fp347;
target[((hsi*216+100)*1+lsi)*1] = fp346;
LIBINT2_REALTYPE fp351;
fp351 = inteval->CD_y[vi] * src1[((hsi*108+49)*1+lsi)*1];
LIBINT2_REALTYPE fp350;
fp350 = src0[((hsi*135+67)*1+lsi)*1] + fp351;
target[((hsi*216+99)*1+lsi)*1] = fp350;
LIBINT2_REALTYPE fp353;
fp353 = 1.0000000000000000e+00 * src2[((hsi*108+48)*1+lsi)*1];
LIBINT2_REALTYPE fp355;
fp355 = inteval->CD_z[vi] * src1[((hsi*108+48)*1+lsi)*1];
LIBINT2_REALTYPE fp354;
fp354 = src0[((hsi*135+69)*1+lsi)*1] + fp355;
LIBINT2_REALTYPE fp352;
fp352 = fp354 - fp353;
target[((hsi*216+98)*1+lsi)*1] = fp352;
LIBINT2_REALTYPE fp357;
fp357 = inteval->CD_y[vi] * src1[((hsi*108+48)*1+lsi)*1];
LIBINT2_REALTYPE fp356;
fp356 = src0[((hsi*135+66)*1+lsi)*1] + fp357;
target[((hsi*216+97)*1+lsi)*1] = fp356;
LIBINT2_REALTYPE fp359;
fp359 = inteval->CD_x[vi] * src1[((hsi*108+48)*1+lsi)*1];
LIBINT2_REALTYPE fp358;
fp358 = src0[((hsi*135+48)*1+lsi)*1] + fp359;
target[((hsi*216+96)*1+lsi)*1] = fp358;
LIBINT2_REALTYPE fp405;
fp405 = inteval->CD_y[vi] * src1[((hsi*108+40)*1+lsi)*1];
LIBINT2_REALTYPE fp404;
fp404 = src0[((hsi*135+55)*1+lsi)*1] + fp405;
target[((hsi*216+81)*1+lsi)*1] = fp404;
LIBINT2_REALTYPE fp365;
fp365 = 1.0000000000000000e+00 * src2[((hsi*108+46)*1+lsi)*1];
LIBINT2_REALTYPE fp367;
fp367 = inteval->CD_z[vi] * src1[((hsi*108+46)*1+lsi)*1];
LIBINT2_REALTYPE fp366;
fp366 = src0[((hsi*135+67)*1+lsi)*1] + fp367;
LIBINT2_REALTYPE fp364;
fp364 = fp366 - fp365;
target[((hsi*216+94)*1+lsi)*1] = fp364;
LIBINT2_REALTYPE fp369;
fp369 = inteval->CD_y[vi] * src1[((hsi*108+46)*1+lsi)*1];
LIBINT2_REALTYPE fp368;
fp368 = src0[((hsi*135+64)*1+lsi)*1] + fp369;
target[((hsi*216+93)*1+lsi)*1] = fp368;
LIBINT2_REALTYPE fp371;
fp371 = 1.0000000000000000e+00 * src2[((hsi*108+45)*1+lsi)*1];
LIBINT2_REALTYPE fp373;
fp373 = inteval->CD_z[vi] * src1[((hsi*108+45)*1+lsi)*1];
LIBINT2_REALTYPE fp372;
fp372 = src0[((hsi*135+66)*1+lsi)*1] + fp373;
LIBINT2_REALTYPE fp370;
fp370 = fp372 - fp371;
target[((hsi*216+92)*1+lsi)*1] = fp370;
LIBINT2_REALTYPE fp375;
fp375 = inteval->CD_y[vi] * src1[((hsi*108+45)*1+lsi)*1];
LIBINT2_REALTYPE fp374;
fp374 = src0[((hsi*135+63)*1+lsi)*1] + fp375;
target[((hsi*216+91)*1+lsi)*1] = fp374;
LIBINT2_REALTYPE fp377;
fp377 = inteval->CD_x[vi] * src1[((hsi*108+45)*1+lsi)*1];
LIBINT2_REALTYPE fp376;
fp376 = src0[((hsi*135+45)*1+lsi)*1] + fp377;
target[((hsi*216+90)*1+lsi)*1] = fp376;
LIBINT2_REALTYPE fp379;
fp379 = 1.0000000000000000e+00 * src2[((hsi*108+44)*1+lsi)*1];
LIBINT2_REALTYPE fp381;
fp381 = inteval->CD_z[vi] * src1[((hsi*108+44)*1+lsi)*1];
LIBINT2_REALTYPE fp380;
fp380 = src0[((hsi*135+62)*1+lsi)*1] + fp381;
LIBINT2_REALTYPE fp378;
fp378 = fp380 - fp379;
target[((hsi*216+89)*1+lsi)*1] = fp378;
LIBINT2_REALTYPE fp383;
fp383 = 1.0000000000000000e+00 * src2[((hsi*108+43)*1+lsi)*1];
LIBINT2_REALTYPE fp385;
fp385 = inteval->CD_z[vi] * src1[((hsi*108+43)*1+lsi)*1];
LIBINT2_REALTYPE fp384;
fp384 = src0[((hsi*135+61)*1+lsi)*1] + fp385;
LIBINT2_REALTYPE fp382;
fp382 = fp384 - fp383;
target[((hsi*216+88)*1+lsi)*1] = fp382;
LIBINT2_REALTYPE fp387;
fp387 = inteval->CD_y[vi] * src1[((hsi*108+43)*1+lsi)*1];
LIBINT2_REALTYPE fp386;
fp386 = src0[((hsi*135+58)*1+lsi)*1] + fp387;
target[((hsi*216+87)*1+lsi)*1] = fp386;
LIBINT2_REALTYPE fp389;
fp389 = 1.0000000000000000e+00 * src2[((hsi*108+42)*1+lsi)*1];
LIBINT2_REALTYPE fp391;
fp391 = inteval->CD_z[vi] * src1[((hsi*108+42)*1+lsi)*1];
LIBINT2_REALTYPE fp390;
fp390 = src0[((hsi*135+60)*1+lsi)*1] + fp391;
LIBINT2_REALTYPE fp388;
fp388 = fp390 - fp389;
target[((hsi*216+86)*1+lsi)*1] = fp388;
LIBINT2_REALTYPE fp393;
fp393 = inteval->CD_y[vi] * src1[((hsi*108+42)*1+lsi)*1];
LIBINT2_REALTYPE fp392;
fp392 = src0[((hsi*135+57)*1+lsi)*1] + fp393;
target[((hsi*216+85)*1+lsi)*1] = fp392;
LIBINT2_REALTYPE fp395;
fp395 = inteval->CD_x[vi] * src1[((hsi*108+42)*1+lsi)*1];
LIBINT2_REALTYPE fp394;
fp394 = src0[((hsi*135+42)*1+lsi)*1] + fp395;
target[((hsi*216+84)*1+lsi)*1] = fp394;
LIBINT2_REALTYPE fp397;
fp397 = 1.0000000000000000e+00 * src2[((hsi*108+41)*1+lsi)*1];
LIBINT2_REALTYPE fp399;
fp399 = inteval->CD_z[vi] * src1[((hsi*108+41)*1+lsi)*1];
LIBINT2_REALTYPE fp398;
fp398 = src0[((hsi*135+59)*1+lsi)*1] + fp399;
LIBINT2_REALTYPE fp396;
fp396 = fp398 - fp397;
target[((hsi*216+83)*1+lsi)*1] = fp396;
LIBINT2_REALTYPE fp401;
fp401 = 1.0000000000000000e+00 * src2[((hsi*108+40)*1+lsi)*1];
LIBINT2_REALTYPE fp403;
fp403 = inteval->CD_z[vi] * src1[((hsi*108+40)*1+lsi)*1];
LIBINT2_REALTYPE fp402;
fp402 = src0[((hsi*135+58)*1+lsi)*1] + fp403;
LIBINT2_REALTYPE fp400;
fp400 = fp402 - fp401;
target[((hsi*216+82)*1+lsi)*1] = fp400;
LIBINT2_REALTYPE fp361;
fp361 = 1.0000000000000000e+00 * src2[((hsi*108+47)*1+lsi)*1];
LIBINT2_REALTYPE fp363;
fp363 = inteval->CD_z[vi] * src1[((hsi*108+47)*1+lsi)*1];
LIBINT2_REALTYPE fp362;
fp362 = src0[((hsi*135+68)*1+lsi)*1] + fp363;
LIBINT2_REALTYPE fp360;
fp360 = fp362 - fp361;
target[((hsi*216+95)*1+lsi)*1] = fp360;
LIBINT2_REALTYPE fp569;
fp569 = 1.0000000000000000e+00 * src2[((hsi*108+12)*1+lsi)*1];
LIBINT2_REALTYPE fp571;
fp571 = inteval->CD_z[vi] * src1[((hsi*108+12)*1+lsi)*1];
LIBINT2_REALTYPE fp570;
fp570 = src0[((hsi*135+24)*1+lsi)*1] + fp571;
LIBINT2_REALTYPE fp568;
fp568 = fp570 - fp569;
target[((hsi*216+26)*1+lsi)*1] = fp568;
LIBINT2_REALTYPE fp573;
fp573 = inteval->CD_y[vi] * src1[((hsi*108+12)*1+lsi)*1];
LIBINT2_REALTYPE fp572;
fp572 = src0[((hsi*135+21)*1+lsi)*1] + fp573;
target[((hsi*216+25)*1+lsi)*1] = fp572;
LIBINT2_REALTYPE fp575;
fp575 = inteval->CD_x[vi] * src1[((hsi*108+12)*1+lsi)*1];
LIBINT2_REALTYPE fp574;
fp574 = src0[((hsi*135+12)*1+lsi)*1] + fp575;
target[((hsi*216+24)*1+lsi)*1] = fp574;
LIBINT2_REALTYPE fp577;
fp577 = 1.0000000000000000e+00 * src2[((hsi*108+11)*1+lsi)*1];
LIBINT2_REALTYPE fp579;
fp579 = inteval->CD_z[vi] * src1[((hsi*108+11)*1+lsi)*1];
LIBINT2_REALTYPE fp578;
fp578 = src0[((hsi*135+23)*1+lsi)*1] + fp579;
LIBINT2_REALTYPE fp576;
fp576 = fp578 - fp577;
target[((hsi*216+23)*1+lsi)*1] = fp576;
LIBINT2_REALTYPE fp581;
fp581 = 1.0000000000000000e+00 * src2[((hsi*108+10)*1+lsi)*1];
LIBINT2_REALTYPE fp583;
fp583 = inteval->CD_z[vi] * src1[((hsi*108+10)*1+lsi)*1];
LIBINT2_REALTYPE fp582;
fp582 = src0[((hsi*135+22)*1+lsi)*1] + fp583;
LIBINT2_REALTYPE fp580;
fp580 = fp582 - fp581;
target[((hsi*216+22)*1+lsi)*1] = fp580;
LIBINT2_REALTYPE fp585;
fp585 = inteval->CD_y[vi] * src1[((hsi*108+10)*1+lsi)*1];
LIBINT2_REALTYPE fp584;
fp584 = src0[((hsi*135+19)*1+lsi)*1] + fp585;
target[((hsi*216+21)*1+lsi)*1] = fp584;
LIBINT2_REALTYPE fp587;
fp587 = 1.0000000000000000e+00 * src2[((hsi*108+9)*1+lsi)*1];
LIBINT2_REALTYPE fp589;
fp589 = inteval->CD_z[vi] * src1[((hsi*108+9)*1+lsi)*1];
LIBINT2_REALTYPE fp588;
fp588 = src0[((hsi*135+21)*1+lsi)*1] + fp589;
LIBINT2_REALTYPE fp586;
fp586 = fp588 - fp587;
target[((hsi*216+20)*1+lsi)*1] = fp586;
LIBINT2_REALTYPE fp591;
fp591 = inteval->CD_y[vi] * src1[((hsi*108+9)*1+lsi)*1];
LIBINT2_REALTYPE fp590;
fp590 = src0[((hsi*135+18)*1+lsi)*1] + fp591;
target[((hsi*216+19)*1+lsi)*1] = fp590;
LIBINT2_REALTYPE fp593;
fp593 = inteval->CD_x[vi] * src1[((hsi*108+9)*1+lsi)*1];
LIBINT2_REALTYPE fp592;
fp592 = src0[((hsi*135+9)*1+lsi)*1] + fp593;
target[((hsi*216+18)*1+lsi)*1] = fp592;
LIBINT2_REALTYPE fp595;
fp595 = 1.0000000000000000e+00 * src2[((hsi*108+8)*1+lsi)*1];
LIBINT2_REALTYPE fp597;
fp597 = inteval->CD_z[vi] * src1[((hsi*108+8)*1+lsi)*1];
LIBINT2_REALTYPE fp596;
fp596 = src0[((hsi*135+17)*1+lsi)*1] + fp597;
LIBINT2_REALTYPE fp594;
fp594 = fp596 - fp595;
target[((hsi*216+17)*1+lsi)*1] = fp594;
LIBINT2_REALTYPE fp599;
fp599 = 1.0000000000000000e+00 * src2[((hsi*108+7)*1+lsi)*1];
LIBINT2_REALTYPE fp601;
fp601 = inteval->CD_z[vi] * src1[((hsi*108+7)*1+lsi)*1];
LIBINT2_REALTYPE fp600;
fp600 = src0[((hsi*135+16)*1+lsi)*1] + fp601;
LIBINT2_REALTYPE fp598;
fp598 = fp600 - fp599;
target[((hsi*216+16)*1+lsi)*1] = fp598;
LIBINT2_REALTYPE fp603;
fp603 = inteval->CD_y[vi] * src1[((hsi*108+7)*1+lsi)*1];
LIBINT2_REALTYPE fp602;
fp602 = src0[((hsi*135+13)*1+lsi)*1] + fp603;
target[((hsi*216+15)*1+lsi)*1] = fp602;
LIBINT2_REALTYPE fp485;
fp485 = inteval->CD_x[vi] * src1[((hsi*108+27)*1+lsi)*1];
LIBINT2_REALTYPE fp484;
fp484 = src0[((hsi*135+27)*1+lsi)*1] + fp485;
target[((hsi*216+54)*1+lsi)*1] = fp484;
LIBINT2_REALTYPE fp609;
fp609 = inteval->CD_y[vi] * src1[((hsi*108+6)*1+lsi)*1];
LIBINT2_REALTYPE fp608;
fp608 = src0[((hsi*135+12)*1+lsi)*1] + fp609;
target[((hsi*216+13)*1+lsi)*1] = fp608;
LIBINT2_REALTYPE fp611;
fp611 = inteval->CD_x[vi] * src1[((hsi*108+6)*1+lsi)*1];
LIBINT2_REALTYPE fp610;
fp610 = src0[((hsi*135+6)*1+lsi)*1] + fp611;
target[((hsi*216+12)*1+lsi)*1] = fp610;
LIBINT2_REALTYPE fp613;
fp613 = 1.0000000000000000e+00 * src2[((hsi*108+5)*1+lsi)*1];
LIBINT2_REALTYPE fp615;
fp615 = inteval->CD_z[vi] * src1[((hsi*108+5)*1+lsi)*1];
LIBINT2_REALTYPE fp614;
fp614 = src0[((hsi*135+14)*1+lsi)*1] + fp615;
LIBINT2_REALTYPE fp612;
fp612 = fp614 - fp613;
target[((hsi*216+11)*1+lsi)*1] = fp612;
LIBINT2_REALTYPE fp617;
fp617 = 1.0000000000000000e+00 * src2[((hsi*108+4)*1+lsi)*1];
LIBINT2_REALTYPE fp619;
fp619 = inteval->CD_z[vi] * src1[((hsi*108+4)*1+lsi)*1];
LIBINT2_REALTYPE fp618;
fp618 = src0[((hsi*135+13)*1+lsi)*1] + fp619;
LIBINT2_REALTYPE fp616;
fp616 = fp618 - fp617;
target[((hsi*216+10)*1+lsi)*1] = fp616;
LIBINT2_REALTYPE fp621;
fp621 = inteval->CD_y[vi] * src1[((hsi*108+4)*1+lsi)*1];
LIBINT2_REALTYPE fp620;
fp620 = src0[((hsi*135+10)*1+lsi)*1] + fp621;
target[((hsi*216+9)*1+lsi)*1] = fp620;
LIBINT2_REALTYPE fp623;
fp623 = 1.0000000000000000e+00 * src2[((hsi*108+3)*1+lsi)*1];
LIBINT2_REALTYPE fp625;
fp625 = inteval->CD_z[vi] * src1[((hsi*108+3)*1+lsi)*1];
LIBINT2_REALTYPE fp624;
fp624 = src0[((hsi*135+12)*1+lsi)*1] + fp625;
LIBINT2_REALTYPE fp622;
fp622 = fp624 - fp623;
target[((hsi*216+8)*1+lsi)*1] = fp622;
LIBINT2_REALTYPE fp627;
fp627 = inteval->CD_y[vi] * src1[((hsi*108+3)*1+lsi)*1];
LIBINT2_REALTYPE fp626;
fp626 = src0[((hsi*135+9)*1+lsi)*1] + fp627;
target[((hsi*216+7)*1+lsi)*1] = fp626;
LIBINT2_REALTYPE fp629;
fp629 = inteval->CD_x[vi] * src1[((hsi*108+3)*1+lsi)*1];
LIBINT2_REALTYPE fp628;
fp628 = src0[((hsi*135+3)*1+lsi)*1] + fp629;
target[((hsi*216+6)*1+lsi)*1] = fp628;
LIBINT2_REALTYPE fp631;
fp631 = 1.0000000000000000e+00 * src2[((hsi*108+2)*1+lsi)*1];
LIBINT2_REALTYPE fp633;
fp633 = inteval->CD_z[vi] * src1[((hsi*108+2)*1+lsi)*1];
LIBINT2_REALTYPE fp632;
fp632 = src0[((hsi*135+8)*1+lsi)*1] + fp633;
LIBINT2_REALTYPE fp630;
fp630 = fp632 - fp631;
target[((hsi*216+5)*1+lsi)*1] = fp630;
LIBINT2_REALTYPE fp635;
fp635 = 1.0000000000000000e+00 * src2[((hsi*108+1)*1+lsi)*1];
LIBINT2_REALTYPE fp637;
fp637 = inteval->CD_z[vi] * src1[((hsi*108+1)*1+lsi)*1];
LIBINT2_REALTYPE fp636;
fp636 = src0[((hsi*135+7)*1+lsi)*1] + fp637;
LIBINT2_REALTYPE fp634;
fp634 = fp636 - fp635;
target[((hsi*216+4)*1+lsi)*1] = fp634;
LIBINT2_REALTYPE fp639;
fp639 = inteval->CD_y[vi] * src1[((hsi*108+1)*1+lsi)*1];
LIBINT2_REALTYPE fp638;
fp638 = src0[((hsi*135+4)*1+lsi)*1] + fp639;
target[((hsi*216+3)*1+lsi)*1] = fp638;
LIBINT2_REALTYPE fp641;
fp641 = 1.0000000000000000e+00 * src2[((hsi*108+0)*1+lsi)*1];
LIBINT2_REALTYPE fp643;
fp643 = inteval->CD_z[vi] * src1[((hsi*108+0)*1+lsi)*1];
LIBINT2_REALTYPE fp642;
fp642 = src0[((hsi*135+6)*1+lsi)*1] + fp643;
LIBINT2_REALTYPE fp640;
fp640 = fp642 - fp641;
target[((hsi*216+2)*1+lsi)*1] = fp640;
LIBINT2_REALTYPE fp645;
fp645 = inteval->CD_y[vi] * src1[((hsi*108+0)*1+lsi)*1];
LIBINT2_REALTYPE fp644;
fp644 = src0[((hsi*135+3)*1+lsi)*1] + fp645;
target[((hsi*216+1)*1+lsi)*1] = fp644;
LIBINT2_REALTYPE fp605;
fp605 = 1.0000000000000000e+00 * src2[((hsi*108+6)*1+lsi)*1];
LIBINT2_REALTYPE fp607;
fp607 = inteval->CD_z[vi] * src1[((hsi*108+6)*1+lsi)*1];
LIBINT2_REALTYPE fp606;
fp606 = src0[((hsi*135+15)*1+lsi)*1] + fp607;
LIBINT2_REALTYPE fp604;
fp604 = fp606 - fp605;
target[((hsi*216+14)*1+lsi)*1] = fp604;
LIBINT2_REALTYPE fp487;
fp487 = 1.0000000000000000e+00 * src2[((hsi*108+26)*1+lsi)*1];
LIBINT2_REALTYPE fp489;
fp489 = inteval->CD_z[vi] * src1[((hsi*108+26)*1+lsi)*1];
LIBINT2_REALTYPE fp488;
fp488 = src0[((hsi*135+41)*1+lsi)*1] + fp489;
LIBINT2_REALTYPE fp486;
fp486 = fp488 - fp487;
target[((hsi*216+53)*1+lsi)*1] = fp486;
LIBINT2_REALTYPE fp491;
fp491 = 1.0000000000000000e+00 * src2[((hsi*108+25)*1+lsi)*1];
LIBINT2_REALTYPE fp493;
fp493 = inteval->CD_z[vi] * src1[((hsi*108+25)*1+lsi)*1];
LIBINT2_REALTYPE fp492;
fp492 = src0[((hsi*135+40)*1+lsi)*1] + fp493;
LIBINT2_REALTYPE fp490;
fp490 = fp492 - fp491;
target[((hsi*216+52)*1+lsi)*1] = fp490;
LIBINT2_REALTYPE fp495;
fp495 = inteval->CD_y[vi] * src1[((hsi*108+25)*1+lsi)*1];
LIBINT2_REALTYPE fp494;
fp494 = src0[((hsi*135+37)*1+lsi)*1] + fp495;
target[((hsi*216+51)*1+lsi)*1] = fp494;
LIBINT2_REALTYPE fp497;
fp497 = 1.0000000000000000e+00 * src2[((hsi*108+24)*1+lsi)*1];
LIBINT2_REALTYPE fp499;
fp499 = inteval->CD_z[vi] * src1[((hsi*108+24)*1+lsi)*1];
LIBINT2_REALTYPE fp498;
fp498 = src0[((hsi*135+39)*1+lsi)*1] + fp499;
LIBINT2_REALTYPE fp496;
fp496 = fp498 - fp497;
target[((hsi*216+50)*1+lsi)*1] = fp496;
LIBINT2_REALTYPE fp501;
fp501 = inteval->CD_y[vi] * src1[((hsi*108+24)*1+lsi)*1];
LIBINT2_REALTYPE fp500;
fp500 = src0[((hsi*135+36)*1+lsi)*1] + fp501;
target[((hsi*216+49)*1+lsi)*1] = fp500;
LIBINT2_REALTYPE fp503;
fp503 = inteval->CD_x[vi] * src1[((hsi*108+24)*1+lsi)*1];
LIBINT2_REALTYPE fp502;
fp502 = src0[((hsi*135+24)*1+lsi)*1] + fp503;
target[((hsi*216+48)*1+lsi)*1] = fp502;
LIBINT2_REALTYPE fp505;
fp505 = 1.0000000000000000e+00 * src2[((hsi*108+23)*1+lsi)*1];
LIBINT2_REALTYPE fp507;
fp507 = inteval->CD_z[vi] * src1[((hsi*108+23)*1+lsi)*1];
LIBINT2_REALTYPE fp506;
fp506 = src0[((hsi*135+38)*1+lsi)*1] + fp507;
LIBINT2_REALTYPE fp504;
fp504 = fp506 - fp505;
target[((hsi*216+47)*1+lsi)*1] = fp504;
LIBINT2_REALTYPE fp509;
fp509 = 1.0000000000000000e+00 * src2[((hsi*108+22)*1+lsi)*1];
LIBINT2_REALTYPE fp511;
fp511 = inteval->CD_z[vi] * src1[((hsi*108+22)*1+lsi)*1];
LIBINT2_REALTYPE fp510;
fp510 = src0[((hsi*135+37)*1+lsi)*1] + fp511;
LIBINT2_REALTYPE fp508;
fp508 = fp510 - fp509;
target[((hsi*216+46)*1+lsi)*1] = fp508;
LIBINT2_REALTYPE fp513;
fp513 = inteval->CD_y[vi] * src1[((hsi*108+22)*1+lsi)*1];
LIBINT2_REALTYPE fp512;
fp512 = src0[((hsi*135+34)*1+lsi)*1] + fp513;
target[((hsi*216+45)*1+lsi)*1] = fp512;
LIBINT2_REALTYPE fp515;
fp515 = 1.0000000000000000e+00 * src2[((hsi*108+21)*1+lsi)*1];
LIBINT2_REALTYPE fp517;
fp517 = inteval->CD_z[vi] * src1[((hsi*108+21)*1+lsi)*1];
LIBINT2_REALTYPE fp516;
fp516 = src0[((hsi*135+36)*1+lsi)*1] + fp517;
LIBINT2_REALTYPE fp514;
fp514 = fp516 - fp515;
target[((hsi*216+44)*1+lsi)*1] = fp514;
LIBINT2_REALTYPE fp519;
fp519 = inteval->CD_y[vi] * src1[((hsi*108+21)*1+lsi)*1];
LIBINT2_REALTYPE fp518;
fp518 = src0[((hsi*135+33)*1+lsi)*1] + fp519;
target[((hsi*216+43)*1+lsi)*1] = fp518;
LIBINT2_REALTYPE fp521;
fp521 = inteval->CD_x[vi] * src1[((hsi*108+21)*1+lsi)*1];
LIBINT2_REALTYPE fp520;
fp520 = src0[((hsi*135+21)*1+lsi)*1] + fp521;
target[((hsi*216+42)*1+lsi)*1] = fp520;
LIBINT2_REALTYPE fp567;
fp567 = inteval->CD_y[vi] * src1[((hsi*108+13)*1+lsi)*1];
LIBINT2_REALTYPE fp566;
fp566 = src0[((hsi*135+22)*1+lsi)*1] + fp567;
target[((hsi*216+27)*1+lsi)*1] = fp566;
LIBINT2_REALTYPE fp527;
fp527 = 1.0000000000000000e+00 * src2[((hsi*108+19)*1+lsi)*1];
LIBINT2_REALTYPE fp529;
fp529 = inteval->CD_z[vi] * src1[((hsi*108+19)*1+lsi)*1];
LIBINT2_REALTYPE fp528;
fp528 = src0[((hsi*135+34)*1+lsi)*1] + fp529;
LIBINT2_REALTYPE fp526;
fp526 = fp528 - fp527;
target[((hsi*216+40)*1+lsi)*1] = fp526;
LIBINT2_REALTYPE fp531;
fp531 = inteval->CD_y[vi] * src1[((hsi*108+19)*1+lsi)*1];
LIBINT2_REALTYPE fp530;
fp530 = src0[((hsi*135+31)*1+lsi)*1] + fp531;
target[((hsi*216+39)*1+lsi)*1] = fp530;
LIBINT2_REALTYPE fp533;
fp533 = 1.0000000000000000e+00 * src2[((hsi*108+18)*1+lsi)*1];
LIBINT2_REALTYPE fp535;
fp535 = inteval->CD_z[vi] * src1[((hsi*108+18)*1+lsi)*1];
LIBINT2_REALTYPE fp534;
fp534 = src0[((hsi*135+33)*1+lsi)*1] + fp535;
LIBINT2_REALTYPE fp532;
fp532 = fp534 - fp533;
target[((hsi*216+38)*1+lsi)*1] = fp532;
LIBINT2_REALTYPE fp537;
fp537 = inteval->CD_y[vi] * src1[((hsi*108+18)*1+lsi)*1];
LIBINT2_REALTYPE fp536;
fp536 = src0[((hsi*135+30)*1+lsi)*1] + fp537;
target[((hsi*216+37)*1+lsi)*1] = fp536;
LIBINT2_REALTYPE fp539;
fp539 = inteval->CD_x[vi] * src1[((hsi*108+18)*1+lsi)*1];
LIBINT2_REALTYPE fp538;
fp538 = src0[((hsi*135+18)*1+lsi)*1] + fp539;
target[((hsi*216+36)*1+lsi)*1] = fp538;
LIBINT2_REALTYPE fp541;
fp541 = 1.0000000000000000e+00 * src2[((hsi*108+17)*1+lsi)*1];
LIBINT2_REALTYPE fp543;
fp543 = inteval->CD_z[vi] * src1[((hsi*108+17)*1+lsi)*1];
LIBINT2_REALTYPE fp542;
fp542 = src0[((hsi*135+29)*1+lsi)*1] + fp543;
LIBINT2_REALTYPE fp540;
fp540 = fp542 - fp541;
target[((hsi*216+35)*1+lsi)*1] = fp540;
LIBINT2_REALTYPE fp545;
fp545 = 1.0000000000000000e+00 * src2[((hsi*108+16)*1+lsi)*1];
LIBINT2_REALTYPE fp547;
fp547 = inteval->CD_z[vi] * src1[((hsi*108+16)*1+lsi)*1];
LIBINT2_REALTYPE fp546;
fp546 = src0[((hsi*135+28)*1+lsi)*1] + fp547;
LIBINT2_REALTYPE fp544;
fp544 = fp546 - fp545;
target[((hsi*216+34)*1+lsi)*1] = fp544;
LIBINT2_REALTYPE fp549;
fp549 = inteval->CD_y[vi] * src1[((hsi*108+16)*1+lsi)*1];
LIBINT2_REALTYPE fp548;
fp548 = src0[((hsi*135+25)*1+lsi)*1] + fp549;
target[((hsi*216+33)*1+lsi)*1] = fp548;
LIBINT2_REALTYPE fp551;
fp551 = 1.0000000000000000e+00 * src2[((hsi*108+15)*1+lsi)*1];
LIBINT2_REALTYPE fp553;
fp553 = inteval->CD_z[vi] * src1[((hsi*108+15)*1+lsi)*1];
LIBINT2_REALTYPE fp552;
fp552 = src0[((hsi*135+27)*1+lsi)*1] + fp553;
LIBINT2_REALTYPE fp550;
fp550 = fp552 - fp551;
target[((hsi*216+32)*1+lsi)*1] = fp550;
LIBINT2_REALTYPE fp555;
fp555 = inteval->CD_y[vi] * src1[((hsi*108+15)*1+lsi)*1];
LIBINT2_REALTYPE fp554;
fp554 = src0[((hsi*135+24)*1+lsi)*1] + fp555;
target[((hsi*216+31)*1+lsi)*1] = fp554;
LIBINT2_REALTYPE fp557;
fp557 = inteval->CD_x[vi] * src1[((hsi*108+15)*1+lsi)*1];
LIBINT2_REALTYPE fp556;
fp556 = src0[((hsi*135+15)*1+lsi)*1] + fp557;
target[((hsi*216+30)*1+lsi)*1] = fp556;
LIBINT2_REALTYPE fp559;
fp559 = 1.0000000000000000e+00 * src2[((hsi*108+14)*1+lsi)*1];
LIBINT2_REALTYPE fp561;
fp561 = inteval->CD_z[vi] * src1[((hsi*108+14)*1+lsi)*1];
LIBINT2_REALTYPE fp560;
fp560 = src0[((hsi*135+26)*1+lsi)*1] + fp561;
LIBINT2_REALTYPE fp558;
fp558 = fp560 - fp559;
target[((hsi*216+29)*1+lsi)*1] = fp558;
LIBINT2_REALTYPE fp563;
fp563 = 1.0000000000000000e+00 * src2[((hsi*108+13)*1+lsi)*1];
LIBINT2_REALTYPE fp565;
fp565 = inteval->CD_z[vi] * src1[((hsi*108+13)*1+lsi)*1];
LIBINT2_REALTYPE fp564;
fp564 = src0[((hsi*135+25)*1+lsi)*1] + fp565;
LIBINT2_REALTYPE fp562;
fp562 = fp564 - fp563;
target[((hsi*216+28)*1+lsi)*1] = fp562;
LIBINT2_REALTYPE fp523;
fp523 = 1.0000000000000000e+00 * src2[((hsi*108+20)*1+lsi)*1];
LIBINT2_REALTYPE fp525;
fp525 = inteval->CD_z[vi] * src1[((hsi*108+20)*1+lsi)*1];
LIBINT2_REALTYPE fp524;
fp524 = src0[((hsi*135+35)*1+lsi)*1] + fp525;
LIBINT2_REALTYPE fp522;
fp522 = fp524 - fp523;
target[((hsi*216+41)*1+lsi)*1] = fp522;
LIBINT2_REALTYPE fp83;
fp83 = 1.0000000000000000e+00 * src2[((hsi*108+93)*1+lsi)*1];
LIBINT2_REALTYPE fp85;
fp85 = inteval->CD_z[vi] * src1[((hsi*108+93)*1+lsi)*1];
LIBINT2_REALTYPE fp84;
fp84 = src0[((hsi*135+120)*1+lsi)*1] + fp85;
LIBINT2_REALTYPE fp82;
fp82 = fp84 - fp83;
target[((hsi*216+188)*1+lsi)*1] = fp82;
LIBINT2_REALTYPE fp87;
fp87 = inteval->CD_y[vi] * src1[((hsi*108+93)*1+lsi)*1];
LIBINT2_REALTYPE fp86;
fp86 = src0[((hsi*135+117)*1+lsi)*1] + fp87;
target[((hsi*216+187)*1+lsi)*1] = fp86;
LIBINT2_REALTYPE fp89;
fp89 = inteval->CD_x[vi] * src1[((hsi*108+93)*1+lsi)*1];
LIBINT2_REALTYPE fp88;
fp88 = src0[((hsi*135+93)*1+lsi)*1] + fp89;
target[((hsi*216+186)*1+lsi)*1] = fp88;
LIBINT2_REALTYPE fp91;
fp91 = 1.0000000000000000e+00 * src2[((hsi*108+92)*1+lsi)*1];
LIBINT2_REALTYPE fp93;
fp93 = inteval->CD_z[vi] * src1[((hsi*108+92)*1+lsi)*1];
LIBINT2_REALTYPE fp92;
fp92 = src0[((hsi*135+119)*1+lsi)*1] + fp93;
LIBINT2_REALTYPE fp90;
fp90 = fp92 - fp91;
target[((hsi*216+185)*1+lsi)*1] = fp90;
LIBINT2_REALTYPE fp95;
fp95 = 1.0000000000000000e+00 * src2[((hsi*108+91)*1+lsi)*1];
LIBINT2_REALTYPE fp97;
fp97 = inteval->CD_z[vi] * src1[((hsi*108+91)*1+lsi)*1];
LIBINT2_REALTYPE fp96;
fp96 = src0[((hsi*135+118)*1+lsi)*1] + fp97;
LIBINT2_REALTYPE fp94;
fp94 = fp96 - fp95;
target[((hsi*216+184)*1+lsi)*1] = fp94;
LIBINT2_REALTYPE fp99;
fp99 = inteval->CD_y[vi] * src1[((hsi*108+91)*1+lsi)*1];
LIBINT2_REALTYPE fp98;
fp98 = src0[((hsi*135+115)*1+lsi)*1] + fp99;
target[((hsi*216+183)*1+lsi)*1] = fp98;
LIBINT2_REALTYPE fp101;
fp101 = 1.0000000000000000e+00 * src2[((hsi*108+90)*1+lsi)*1];
LIBINT2_REALTYPE fp103;
fp103 = inteval->CD_z[vi] * src1[((hsi*108+90)*1+lsi)*1];
LIBINT2_REALTYPE fp102;
fp102 = src0[((hsi*135+117)*1+lsi)*1] + fp103;
LIBINT2_REALTYPE fp100;
fp100 = fp102 - fp101;
target[((hsi*216+182)*1+lsi)*1] = fp100;
LIBINT2_REALTYPE fp105;
fp105 = inteval->CD_y[vi] * src1[((hsi*108+90)*1+lsi)*1];
LIBINT2_REALTYPE fp104;
fp104 = src0[((hsi*135+114)*1+lsi)*1] + fp105;
target[((hsi*216+181)*1+lsi)*1] = fp104;
LIBINT2_REALTYPE fp107;
fp107 = inteval->CD_x[vi] * src1[((hsi*108+90)*1+lsi)*1];
LIBINT2_REALTYPE fp106;
fp106 = src0[((hsi*135+90)*1+lsi)*1] + fp107;
target[((hsi*216+180)*1+lsi)*1] = fp106;
LIBINT2_REALTYPE fp109;
fp109 = 1.0000000000000000e+00 * src2[((hsi*108+89)*1+lsi)*1];
LIBINT2_REALTYPE fp111;
fp111 = inteval->CD_z[vi] * src1[((hsi*108+89)*1+lsi)*1];
LIBINT2_REALTYPE fp110;
fp110 = src0[((hsi*135+116)*1+lsi)*1] + fp111;
LIBINT2_REALTYPE fp108;
fp108 = fp110 - fp109;
target[((hsi*216+179)*1+lsi)*1] = fp108;
LIBINT2_REALTYPE fp113;
fp113 = 1.0000000000000000e+00 * src2[((hsi*108+88)*1+lsi)*1];
LIBINT2_REALTYPE fp115;
fp115 = inteval->CD_z[vi] * src1[((hsi*108+88)*1+lsi)*1];
LIBINT2_REALTYPE fp114;
fp114 = src0[((hsi*135+115)*1+lsi)*1] + fp115;
LIBINT2_REALTYPE fp112;
fp112 = fp114 - fp113;
target[((hsi*216+178)*1+lsi)*1] = fp112;
LIBINT2_REALTYPE fp117;
fp117 = inteval->CD_y[vi] * src1[((hsi*108+88)*1+lsi)*1];
LIBINT2_REALTYPE fp116;
fp116 = src0[((hsi*135+112)*1+lsi)*1] + fp117;
target[((hsi*216+177)*1+lsi)*1] = fp116;
LIBINT2_REALTYPE fp323;
fp323 = inteval->CD_x[vi] * src1[((hsi*108+54)*1+lsi)*1];
LIBINT2_REALTYPE fp322;
fp322 = src0[((hsi*135+54)*1+lsi)*1] + fp323;
target[((hsi*216+108)*1+lsi)*1] = fp322;
LIBINT2_REALTYPE fp123;
fp123 = inteval->CD_y[vi] * src1[((hsi*108+87)*1+lsi)*1];
LIBINT2_REALTYPE fp122;
fp122 = src0[((hsi*135+111)*1+lsi)*1] + fp123;
target[((hsi*216+175)*1+lsi)*1] = fp122;
LIBINT2_REALTYPE fp125;
fp125 = inteval->CD_x[vi] * src1[((hsi*108+87)*1+lsi)*1];
LIBINT2_REALTYPE fp124;
fp124 = src0[((hsi*135+87)*1+lsi)*1] + fp125;
target[((hsi*216+174)*1+lsi)*1] = fp124;
LIBINT2_REALTYPE fp127;
fp127 = 1.0000000000000000e+00 * src2[((hsi*108+86)*1+lsi)*1];
LIBINT2_REALTYPE fp129;
fp129 = inteval->CD_z[vi] * src1[((hsi*108+86)*1+lsi)*1];
LIBINT2_REALTYPE fp128;
fp128 = src0[((hsi*135+113)*1+lsi)*1] + fp129;
LIBINT2_REALTYPE fp126;
fp126 = fp128 - fp127;
target[((hsi*216+173)*1+lsi)*1] = fp126;
LIBINT2_REALTYPE fp131;
fp131 = 1.0000000000000000e+00 * src2[((hsi*108+85)*1+lsi)*1];
LIBINT2_REALTYPE fp133;
fp133 = inteval->CD_z[vi] * src1[((hsi*108+85)*1+lsi)*1];
LIBINT2_REALTYPE fp132;
fp132 = src0[((hsi*135+112)*1+lsi)*1] + fp133;
LIBINT2_REALTYPE fp130;
fp130 = fp132 - fp131;
target[((hsi*216+172)*1+lsi)*1] = fp130;
LIBINT2_REALTYPE fp135;
fp135 = inteval->CD_y[vi] * src1[((hsi*108+85)*1+lsi)*1];
LIBINT2_REALTYPE fp134;
fp134 = src0[((hsi*135+109)*1+lsi)*1] + fp135;
target[((hsi*216+171)*1+lsi)*1] = fp134;
LIBINT2_REALTYPE fp137;
fp137 = 1.0000000000000000e+00 * src2[((hsi*108+84)*1+lsi)*1];
LIBINT2_REALTYPE fp139;
fp139 = inteval->CD_z[vi] * src1[((hsi*108+84)*1+lsi)*1];
LIBINT2_REALTYPE fp138;
fp138 = src0[((hsi*135+111)*1+lsi)*1] + fp139;
LIBINT2_REALTYPE fp136;
fp136 = fp138 - fp137;
target[((hsi*216+170)*1+lsi)*1] = fp136;
LIBINT2_REALTYPE fp141;
fp141 = inteval->CD_y[vi] * src1[((hsi*108+84)*1+lsi)*1];
LIBINT2_REALTYPE fp140;
fp140 = src0[((hsi*135+108)*1+lsi)*1] + fp141;
target[((hsi*216+169)*1+lsi)*1] = fp140;
LIBINT2_REALTYPE fp143;
fp143 = inteval->CD_x[vi] * src1[((hsi*108+84)*1+lsi)*1];
LIBINT2_REALTYPE fp142;
fp142 = src0[((hsi*135+84)*1+lsi)*1] + fp143;
target[((hsi*216+168)*1+lsi)*1] = fp142;
LIBINT2_REALTYPE fp145;
fp145 = 1.0000000000000000e+00 * src2[((hsi*108+83)*1+lsi)*1];
LIBINT2_REALTYPE fp147;
fp147 = inteval->CD_z[vi] * src1[((hsi*108+83)*1+lsi)*1];
LIBINT2_REALTYPE fp146;
fp146 = src0[((hsi*135+107)*1+lsi)*1] + fp147;
LIBINT2_REALTYPE fp144;
fp144 = fp146 - fp145;
target[((hsi*216+167)*1+lsi)*1] = fp144;
LIBINT2_REALTYPE fp149;
fp149 = 1.0000000000000000e+00 * src2[((hsi*108+82)*1+lsi)*1];
LIBINT2_REALTYPE fp151;
fp151 = inteval->CD_z[vi] * src1[((hsi*108+82)*1+lsi)*1];
LIBINT2_REALTYPE fp150;
fp150 = src0[((hsi*135+106)*1+lsi)*1] + fp151;
LIBINT2_REALTYPE fp148;
fp148 = fp150 - fp149;
target[((hsi*216+166)*1+lsi)*1] = fp148;
LIBINT2_REALTYPE fp153;
fp153 = inteval->CD_y[vi] * src1[((hsi*108+82)*1+lsi)*1];
LIBINT2_REALTYPE fp152;
fp152 = src0[((hsi*135+103)*1+lsi)*1] + fp153;
target[((hsi*216+165)*1+lsi)*1] = fp152;
LIBINT2_REALTYPE fp155;
fp155 = 1.0000000000000000e+00 * src2[((hsi*108+81)*1+lsi)*1];
LIBINT2_REALTYPE fp157;
fp157 = inteval->CD_z[vi] * src1[((hsi*108+81)*1+lsi)*1];
LIBINT2_REALTYPE fp156;
fp156 = src0[((hsi*135+105)*1+lsi)*1] + fp157;
LIBINT2_REALTYPE fp154;
fp154 = fp156 - fp155;
target[((hsi*216+164)*1+lsi)*1] = fp154;
LIBINT2_REALTYPE fp159;
fp159 = inteval->CD_y[vi] * src1[((hsi*108+81)*1+lsi)*1];
LIBINT2_REALTYPE fp158;
fp158 = src0[((hsi*135+102)*1+lsi)*1] + fp159;
target[((hsi*216+163)*1+lsi)*1] = fp158;
LIBINT2_REALTYPE fp119;
fp119 = 1.0000000000000000e+00 * src2[((hsi*108+87)*1+lsi)*1];
LIBINT2_REALTYPE fp121;
fp121 = inteval->CD_z[vi] * src1[((hsi*108+87)*1+lsi)*1];
LIBINT2_REALTYPE fp120;
fp120 = src0[((hsi*135+114)*1+lsi)*1] + fp121;
LIBINT2_REALTYPE fp118;
fp118 = fp120 - fp119;
target[((hsi*216+176)*1+lsi)*1] = fp118;
LIBINT2_REALTYPE fp1;
fp1 = 1.0000000000000000e+00 * src2[((hsi*108+107)*1+lsi)*1];
LIBINT2_REALTYPE fp3;
fp3 = inteval->CD_z[vi] * src1[((hsi*108+107)*1+lsi)*1];
LIBINT2_REALTYPE fp2;
fp2 = src0[((hsi*135+134)*1+lsi)*1] + fp3;
LIBINT2_REALTYPE fp0;
fp0 = fp2 - fp1;
target[((hsi*216+215)*1+lsi)*1] = fp0;
LIBINT2_REALTYPE fp5;
fp5 = 1.0000000000000000e+00 * src2[((hsi*108+106)*1+lsi)*1];
LIBINT2_REALTYPE fp7;
fp7 = inteval->CD_z[vi] * src1[((hsi*108+106)*1+lsi)*1];
LIBINT2_REALTYPE fp6;
fp6 = src0[((hsi*135+133)*1+lsi)*1] + fp7;
LIBINT2_REALTYPE fp4;
fp4 = fp6 - fp5;
target[((hsi*216+214)*1+lsi)*1] = fp4;
LIBINT2_REALTYPE fp9;
fp9 = inteval->CD_y[vi] * src1[((hsi*108+106)*1+lsi)*1];
LIBINT2_REALTYPE fp8;
fp8 = src0[((hsi*135+130)*1+lsi)*1] + fp9;
target[((hsi*216+213)*1+lsi)*1] = fp8;
LIBINT2_REALTYPE fp11;
fp11 = 1.0000000000000000e+00 * src2[((hsi*108+105)*1+lsi)*1];
LIBINT2_REALTYPE fp13;
fp13 = inteval->CD_z[vi] * src1[((hsi*108+105)*1+lsi)*1];
LIBINT2_REALTYPE fp12;
fp12 = src0[((hsi*135+132)*1+lsi)*1] + fp13;
LIBINT2_REALTYPE fp10;
fp10 = fp12 - fp11;
target[((hsi*216+212)*1+lsi)*1] = fp10;
LIBINT2_REALTYPE fp15;
fp15 = inteval->CD_y[vi] * src1[((hsi*108+105)*1+lsi)*1];
LIBINT2_REALTYPE fp14;
fp14 = src0[((hsi*135+129)*1+lsi)*1] + fp15;
target[((hsi*216+211)*1+lsi)*1] = fp14;
LIBINT2_REALTYPE fp17;
fp17 = inteval->CD_x[vi] * src1[((hsi*108+105)*1+lsi)*1];
LIBINT2_REALTYPE fp16;
fp16 = src0[((hsi*135+105)*1+lsi)*1] + fp17;
target[((hsi*216+210)*1+lsi)*1] = fp16;
LIBINT2_REALTYPE fp19;
fp19 = 1.0000000000000000e+00 * src2[((hsi*108+104)*1+lsi)*1];
LIBINT2_REALTYPE fp21;
fp21 = inteval->CD_z[vi] * src1[((hsi*108+104)*1+lsi)*1];
LIBINT2_REALTYPE fp20;
fp20 = src0[((hsi*135+131)*1+lsi)*1] + fp21;
LIBINT2_REALTYPE fp18;
fp18 = fp20 - fp19;
target[((hsi*216+209)*1+lsi)*1] = fp18;
LIBINT2_REALTYPE fp23;
fp23 = 1.0000000000000000e+00 * src2[((hsi*108+103)*1+lsi)*1];
LIBINT2_REALTYPE fp25;
fp25 = inteval->CD_z[vi] * src1[((hsi*108+103)*1+lsi)*1];
LIBINT2_REALTYPE fp24;
fp24 = src0[((hsi*135+130)*1+lsi)*1] + fp25;
LIBINT2_REALTYPE fp22;
fp22 = fp24 - fp23;
target[((hsi*216+208)*1+lsi)*1] = fp22;
LIBINT2_REALTYPE fp27;
fp27 = inteval->CD_y[vi] * src1[((hsi*108+103)*1+lsi)*1];
LIBINT2_REALTYPE fp26;
fp26 = src0[((hsi*135+127)*1+lsi)*1] + fp27;
target[((hsi*216+207)*1+lsi)*1] = fp26;
LIBINT2_REALTYPE fp29;
fp29 = 1.0000000000000000e+00 * src2[((hsi*108+102)*1+lsi)*1];
LIBINT2_REALTYPE fp31;
fp31 = inteval->CD_z[vi] * src1[((hsi*108+102)*1+lsi)*1];
LIBINT2_REALTYPE fp30;
fp30 = src0[((hsi*135+129)*1+lsi)*1] + fp31;
LIBINT2_REALTYPE fp28;
fp28 = fp30 - fp29;
target[((hsi*216+206)*1+lsi)*1] = fp28;
LIBINT2_REALTYPE fp33;
fp33 = inteval->CD_y[vi] * src1[((hsi*108+102)*1+lsi)*1];
LIBINT2_REALTYPE fp32;
fp32 = src0[((hsi*135+126)*1+lsi)*1] + fp33;
target[((hsi*216+205)*1+lsi)*1] = fp32;
LIBINT2_REALTYPE fp35;
fp35 = inteval->CD_x[vi] * src1[((hsi*108+102)*1+lsi)*1];
LIBINT2_REALTYPE fp34;
fp34 = src0[((hsi*135+102)*1+lsi)*1] + fp35;
target[((hsi*216+204)*1+lsi)*1] = fp34;
LIBINT2_REALTYPE fp81;
fp81 = inteval->CD_y[vi] * src1[((hsi*108+94)*1+lsi)*1];
LIBINT2_REALTYPE fp80;
fp80 = src0[((hsi*135+118)*1+lsi)*1] + fp81;
target[((hsi*216+189)*1+lsi)*1] = fp80;
LIBINT2_REALTYPE fp41;
fp41 = 1.0000000000000000e+00 * src2[((hsi*108+100)*1+lsi)*1];
LIBINT2_REALTYPE fp43;
fp43 = inteval->CD_z[vi] * src1[((hsi*108+100)*1+lsi)*1];
LIBINT2_REALTYPE fp42;
fp42 = src0[((hsi*135+127)*1+lsi)*1] + fp43;
LIBINT2_REALTYPE fp40;
fp40 = fp42 - fp41;
target[((hsi*216+202)*1+lsi)*1] = fp40;
LIBINT2_REALTYPE fp45;
fp45 = inteval->CD_y[vi] * src1[((hsi*108+100)*1+lsi)*1];
LIBINT2_REALTYPE fp44;
fp44 = src0[((hsi*135+124)*1+lsi)*1] + fp45;
target[((hsi*216+201)*1+lsi)*1] = fp44;
LIBINT2_REALTYPE fp47;
fp47 = 1.0000000000000000e+00 * src2[((hsi*108+99)*1+lsi)*1];
LIBINT2_REALTYPE fp49;
fp49 = inteval->CD_z[vi] * src1[((hsi*108+99)*1+lsi)*1];
LIBINT2_REALTYPE fp48;
fp48 = src0[((hsi*135+126)*1+lsi)*1] + fp49;
LIBINT2_REALTYPE fp46;
fp46 = fp48 - fp47;
target[((hsi*216+200)*1+lsi)*1] = fp46;
LIBINT2_REALTYPE fp51;
fp51 = inteval->CD_y[vi] * src1[((hsi*108+99)*1+lsi)*1];
LIBINT2_REALTYPE fp50;
fp50 = src0[((hsi*135+123)*1+lsi)*1] + fp51;
target[((hsi*216+199)*1+lsi)*1] = fp50;
LIBINT2_REALTYPE fp53;
fp53 = inteval->CD_x[vi] * src1[((hsi*108+99)*1+lsi)*1];
LIBINT2_REALTYPE fp52;
fp52 = src0[((hsi*135+99)*1+lsi)*1] + fp53;
target[((hsi*216+198)*1+lsi)*1] = fp52;
LIBINT2_REALTYPE fp55;
fp55 = 1.0000000000000000e+00 * src2[((hsi*108+98)*1+lsi)*1];
LIBINT2_REALTYPE fp57;
fp57 = inteval->CD_z[vi] * src1[((hsi*108+98)*1+lsi)*1];
LIBINT2_REALTYPE fp56;
fp56 = src0[((hsi*135+125)*1+lsi)*1] + fp57;
LIBINT2_REALTYPE fp54;
fp54 = fp56 - fp55;
target[((hsi*216+197)*1+lsi)*1] = fp54;
LIBINT2_REALTYPE fp59;
fp59 = 1.0000000000000000e+00 * src2[((hsi*108+97)*1+lsi)*1];
LIBINT2_REALTYPE fp61;
fp61 = inteval->CD_z[vi] * src1[((hsi*108+97)*1+lsi)*1];
LIBINT2_REALTYPE fp60;
fp60 = src0[((hsi*135+124)*1+lsi)*1] + fp61;
LIBINT2_REALTYPE fp58;
fp58 = fp60 - fp59;
target[((hsi*216+196)*1+lsi)*1] = fp58;
LIBINT2_REALTYPE fp63;
fp63 = inteval->CD_y[vi] * src1[((hsi*108+97)*1+lsi)*1];
LIBINT2_REALTYPE fp62;
fp62 = src0[((hsi*135+121)*1+lsi)*1] + fp63;
target[((hsi*216+195)*1+lsi)*1] = fp62;
LIBINT2_REALTYPE fp65;
fp65 = 1.0000000000000000e+00 * src2[((hsi*108+96)*1+lsi)*1];
LIBINT2_REALTYPE fp67;
fp67 = inteval->CD_z[vi] * src1[((hsi*108+96)*1+lsi)*1];
LIBINT2_REALTYPE fp66;
fp66 = src0[((hsi*135+123)*1+lsi)*1] + fp67;
LIBINT2_REALTYPE fp64;
fp64 = fp66 - fp65;
target[((hsi*216+194)*1+lsi)*1] = fp64;
LIBINT2_REALTYPE fp69;
fp69 = inteval->CD_y[vi] * src1[((hsi*108+96)*1+lsi)*1];
LIBINT2_REALTYPE fp68;
fp68 = src0[((hsi*135+120)*1+lsi)*1] + fp69;
target[((hsi*216+193)*1+lsi)*1] = fp68;
LIBINT2_REALTYPE fp71;
fp71 = inteval->CD_x[vi] * src1[((hsi*108+96)*1+lsi)*1];
LIBINT2_REALTYPE fp70;
fp70 = src0[((hsi*135+96)*1+lsi)*1] + fp71;
target[((hsi*216+192)*1+lsi)*1] = fp70;
LIBINT2_REALTYPE fp73;
fp73 = 1.0000000000000000e+00 * src2[((hsi*108+95)*1+lsi)*1];
LIBINT2_REALTYPE fp75;
fp75 = inteval->CD_z[vi] * src1[((hsi*108+95)*1+lsi)*1];
LIBINT2_REALTYPE fp74;
fp74 = src0[((hsi*135+122)*1+lsi)*1] + fp75;
LIBINT2_REALTYPE fp72;
fp72 = fp74 - fp73;
target[((hsi*216+191)*1+lsi)*1] = fp72;
LIBINT2_REALTYPE fp77;
fp77 = 1.0000000000000000e+00 * src2[((hsi*108+94)*1+lsi)*1];
LIBINT2_REALTYPE fp79;
fp79 = inteval->CD_z[vi] * src1[((hsi*108+94)*1+lsi)*1];
LIBINT2_REALTYPE fp78;
fp78 = src0[((hsi*135+121)*1+lsi)*1] + fp79;
LIBINT2_REALTYPE fp76;
fp76 = fp78 - fp77;
target[((hsi*216+190)*1+lsi)*1] = fp76;
LIBINT2_REALTYPE fp37;
fp37 = 1.0000000000000000e+00 * src2[((hsi*108+101)*1+lsi)*1];
LIBINT2_REALTYPE fp39;
fp39 = inteval->CD_z[vi] * src1[((hsi*108+101)*1+lsi)*1];
LIBINT2_REALTYPE fp38;
fp38 = src0[((hsi*135+128)*1+lsi)*1] + fp39;
LIBINT2_REALTYPE fp36;
fp36 = fp38 - fp37;
target[((hsi*216+203)*1+lsi)*1] = fp36;
LIBINT2_REALTYPE fp245;
fp245 = 1.0000000000000000e+00 * src2[((hsi*108+66)*1+lsi)*1];
LIBINT2_REALTYPE fp247;
fp247 = inteval->CD_z[vi] * src1[((hsi*108+66)*1+lsi)*1];
LIBINT2_REALTYPE fp246;
fp246 = src0[((hsi*135+90)*1+lsi)*1] + fp247;
LIBINT2_REALTYPE fp244;
fp244 = fp246 - fp245;
target[((hsi*216+134)*1+lsi)*1] = fp244;
LIBINT2_REALTYPE fp249;
fp249 = inteval->CD_y[vi] * src1[((hsi*108+66)*1+lsi)*1];
LIBINT2_REALTYPE fp248;
fp248 = src0[((hsi*135+87)*1+lsi)*1] + fp249;
target[((hsi*216+133)*1+lsi)*1] = fp248;
LIBINT2_REALTYPE fp251;
fp251 = inteval->CD_x[vi] * src1[((hsi*108+66)*1+lsi)*1];
LIBINT2_REALTYPE fp250;
fp250 = src0[((hsi*135+66)*1+lsi)*1] + fp251;
target[((hsi*216+132)*1+lsi)*1] = fp250;
LIBINT2_REALTYPE fp253;
fp253 = 1.0000000000000000e+00 * src2[((hsi*108+65)*1+lsi)*1];
LIBINT2_REALTYPE fp255;
fp255 = inteval->CD_z[vi] * src1[((hsi*108+65)*1+lsi)*1];
LIBINT2_REALTYPE fp254;
fp254 = src0[((hsi*135+89)*1+lsi)*1] + fp255;
LIBINT2_REALTYPE fp252;
fp252 = fp254 - fp253;
target[((hsi*216+131)*1+lsi)*1] = fp252;
LIBINT2_REALTYPE fp257;
fp257 = 1.0000000000000000e+00 * src2[((hsi*108+64)*1+lsi)*1];
LIBINT2_REALTYPE fp259;
fp259 = inteval->CD_z[vi] * src1[((hsi*108+64)*1+lsi)*1];
LIBINT2_REALTYPE fp258;
fp258 = src0[((hsi*135+88)*1+lsi)*1] + fp259;
LIBINT2_REALTYPE fp256;
fp256 = fp258 - fp257;
target[((hsi*216+130)*1+lsi)*1] = fp256;
LIBINT2_REALTYPE fp261;
fp261 = inteval->CD_y[vi] * src1[((hsi*108+64)*1+lsi)*1];
LIBINT2_REALTYPE fp260;
fp260 = src0[((hsi*135+85)*1+lsi)*1] + fp261;
target[((hsi*216+129)*1+lsi)*1] = fp260;
LIBINT2_REALTYPE fp263;
fp263 = 1.0000000000000000e+00 * src2[((hsi*108+63)*1+lsi)*1];
LIBINT2_REALTYPE fp265;
fp265 = inteval->CD_z[vi] * src1[((hsi*108+63)*1+lsi)*1];
LIBINT2_REALTYPE fp264;
fp264 = src0[((hsi*135+87)*1+lsi)*1] + fp265;
LIBINT2_REALTYPE fp262;
fp262 = fp264 - fp263;
target[((hsi*216+128)*1+lsi)*1] = fp262;
LIBINT2_REALTYPE fp267;
fp267 = inteval->CD_y[vi] * src1[((hsi*108+63)*1+lsi)*1];
LIBINT2_REALTYPE fp266;
fp266 = src0[((hsi*135+84)*1+lsi)*1] + fp267;
target[((hsi*216+127)*1+lsi)*1] = fp266;
LIBINT2_REALTYPE fp269;
fp269 = inteval->CD_x[vi] * src1[((hsi*108+63)*1+lsi)*1];
LIBINT2_REALTYPE fp268;
fp268 = src0[((hsi*135+63)*1+lsi)*1] + fp269;
target[((hsi*216+126)*1+lsi)*1] = fp268;
LIBINT2_REALTYPE fp271;
fp271 = 1.0000000000000000e+00 * src2[((hsi*108+62)*1+lsi)*1];
LIBINT2_REALTYPE fp273;
fp273 = inteval->CD_z[vi] * src1[((hsi*108+62)*1+lsi)*1];
LIBINT2_REALTYPE fp272;
fp272 = src0[((hsi*135+83)*1+lsi)*1] + fp273;
LIBINT2_REALTYPE fp270;
fp270 = fp272 - fp271;
target[((hsi*216+125)*1+lsi)*1] = fp270;
LIBINT2_REALTYPE fp275;
fp275 = 1.0000000000000000e+00 * src2[((hsi*108+61)*1+lsi)*1];
LIBINT2_REALTYPE fp277;
fp277 = inteval->CD_z[vi] * src1[((hsi*108+61)*1+lsi)*1];
LIBINT2_REALTYPE fp276;
fp276 = src0[((hsi*135+82)*1+lsi)*1] + fp277;
LIBINT2_REALTYPE fp274;
fp274 = fp276 - fp275;
target[((hsi*216+124)*1+lsi)*1] = fp274;
LIBINT2_REALTYPE fp279;
fp279 = inteval->CD_y[vi] * src1[((hsi*108+61)*1+lsi)*1];
LIBINT2_REALTYPE fp278;
fp278 = src0[((hsi*135+79)*1+lsi)*1] + fp279;
target[((hsi*216+123)*1+lsi)*1] = fp278;
LIBINT2_REALTYPE fp161;
fp161 = inteval->CD_x[vi] * src1[((hsi*108+81)*1+lsi)*1];
LIBINT2_REALTYPE fp160;
fp160 = src0[((hsi*135+81)*1+lsi)*1] + fp161;
target[((hsi*216+162)*1+lsi)*1] = fp160;
LIBINT2_REALTYPE fp285;
fp285 = inteval->CD_y[vi] * src1[((hsi*108+60)*1+lsi)*1];
LIBINT2_REALTYPE fp284;
fp284 = src0[((hsi*135+78)*1+lsi)*1] + fp285;
target[((hsi*216+121)*1+lsi)*1] = fp284;
LIBINT2_REALTYPE fp287;
fp287 = inteval->CD_x[vi] * src1[((hsi*108+60)*1+lsi)*1];
LIBINT2_REALTYPE fp286;
fp286 = src0[((hsi*135+60)*1+lsi)*1] + fp287;
target[((hsi*216+120)*1+lsi)*1] = fp286;
LIBINT2_REALTYPE fp289;
fp289 = 1.0000000000000000e+00 * src2[((hsi*108+59)*1+lsi)*1];
LIBINT2_REALTYPE fp291;
fp291 = inteval->CD_z[vi] * src1[((hsi*108+59)*1+lsi)*1];
LIBINT2_REALTYPE fp290;
fp290 = src0[((hsi*135+80)*1+lsi)*1] + fp291;
LIBINT2_REALTYPE fp288;
fp288 = fp290 - fp289;
target[((hsi*216+119)*1+lsi)*1] = fp288;
LIBINT2_REALTYPE fp293;
fp293 = 1.0000000000000000e+00 * src2[((hsi*108+58)*1+lsi)*1];
LIBINT2_REALTYPE fp295;
fp295 = inteval->CD_z[vi] * src1[((hsi*108+58)*1+lsi)*1];
LIBINT2_REALTYPE fp294;
fp294 = src0[((hsi*135+79)*1+lsi)*1] + fp295;
LIBINT2_REALTYPE fp292;
fp292 = fp294 - fp293;
target[((hsi*216+118)*1+lsi)*1] = fp292;
LIBINT2_REALTYPE fp297;
fp297 = inteval->CD_y[vi] * src1[((hsi*108+58)*1+lsi)*1];
LIBINT2_REALTYPE fp296;
fp296 = src0[((hsi*135+76)*1+lsi)*1] + fp297;
target[((hsi*216+117)*1+lsi)*1] = fp296;
LIBINT2_REALTYPE fp299;
fp299 = 1.0000000000000000e+00 * src2[((hsi*108+57)*1+lsi)*1];
LIBINT2_REALTYPE fp301;
fp301 = inteval->CD_z[vi] * src1[((hsi*108+57)*1+lsi)*1];
LIBINT2_REALTYPE fp300;
fp300 = src0[((hsi*135+78)*1+lsi)*1] + fp301;
LIBINT2_REALTYPE fp298;
fp298 = fp300 - fp299;
target[((hsi*216+116)*1+lsi)*1] = fp298;
LIBINT2_REALTYPE fp303;
fp303 = inteval->CD_y[vi] * src1[((hsi*108+57)*1+lsi)*1];
LIBINT2_REALTYPE fp302;
fp302 = src0[((hsi*135+75)*1+lsi)*1] + fp303;
target[((hsi*216+115)*1+lsi)*1] = fp302;
LIBINT2_REALTYPE fp305;
fp305 = inteval->CD_x[vi] * src1[((hsi*108+57)*1+lsi)*1];
LIBINT2_REALTYPE fp304;
fp304 = src0[((hsi*135+57)*1+lsi)*1] + fp305;
target[((hsi*216+114)*1+lsi)*1] = fp304;
LIBINT2_REALTYPE fp307;
fp307 = 1.0000000000000000e+00 * src2[((hsi*108+56)*1+lsi)*1];
LIBINT2_REALTYPE fp309;
fp309 = inteval->CD_z[vi] * src1[((hsi*108+56)*1+lsi)*1];
LIBINT2_REALTYPE fp308;
fp308 = src0[((hsi*135+77)*1+lsi)*1] + fp309;
LIBINT2_REALTYPE fp306;
fp306 = fp308 - fp307;
target[((hsi*216+113)*1+lsi)*1] = fp306;
LIBINT2_REALTYPE fp311;
fp311 = 1.0000000000000000e+00 * src2[((hsi*108+55)*1+lsi)*1];
LIBINT2_REALTYPE fp313;
fp313 = inteval->CD_z[vi] * src1[((hsi*108+55)*1+lsi)*1];
LIBINT2_REALTYPE fp312;
fp312 = src0[((hsi*135+76)*1+lsi)*1] + fp313;
LIBINT2_REALTYPE fp310;
fp310 = fp312 - fp311;
target[((hsi*216+112)*1+lsi)*1] = fp310;
LIBINT2_REALTYPE fp315;
fp315 = inteval->CD_y[vi] * src1[((hsi*108+55)*1+lsi)*1];
LIBINT2_REALTYPE fp314;
fp314 = src0[((hsi*135+73)*1+lsi)*1] + fp315;
target[((hsi*216+111)*1+lsi)*1] = fp314;
LIBINT2_REALTYPE fp317;
fp317 = 1.0000000000000000e+00 * src2[((hsi*108+54)*1+lsi)*1];
LIBINT2_REALTYPE fp319;
fp319 = inteval->CD_z[vi] * src1[((hsi*108+54)*1+lsi)*1];
LIBINT2_REALTYPE fp318;
fp318 = src0[((hsi*135+75)*1+lsi)*1] + fp319;
LIBINT2_REALTYPE fp316;
fp316 = fp318 - fp317;
target[((hsi*216+110)*1+lsi)*1] = fp316;
LIBINT2_REALTYPE fp321;
fp321 = inteval->CD_y[vi] * src1[((hsi*108+54)*1+lsi)*1];
LIBINT2_REALTYPE fp320;
fp320 = src0[((hsi*135+72)*1+lsi)*1] + fp321;
target[((hsi*216+109)*1+lsi)*1] = fp320;
LIBINT2_REALTYPE fp281;
fp281 = 1.0000000000000000e+00 * src2[((hsi*108+60)*1+lsi)*1];
LIBINT2_REALTYPE fp283;
fp283 = inteval->CD_z[vi] * src1[((hsi*108+60)*1+lsi)*1];
LIBINT2_REALTYPE fp282;
fp282 = src0[((hsi*135+81)*1+lsi)*1] + fp283;
LIBINT2_REALTYPE fp280;
fp280 = fp282 - fp281;
target[((hsi*216+122)*1+lsi)*1] = fp280;
LIBINT2_REALTYPE fp163;
fp163 = 1.0000000000000000e+00 * src2[((hsi*108+80)*1+lsi)*1];
LIBINT2_REALTYPE fp165;
fp165 = inteval->CD_z[vi] * src1[((hsi*108+80)*1+lsi)*1];
LIBINT2_REALTYPE fp164;
fp164 = src0[((hsi*135+104)*1+lsi)*1] + fp165;
LIBINT2_REALTYPE fp162;
fp162 = fp164 - fp163;
target[((hsi*216+161)*1+lsi)*1] = fp162;
LIBINT2_REALTYPE fp167;
fp167 = 1.0000000000000000e+00 * src2[((hsi*108+79)*1+lsi)*1];
LIBINT2_REALTYPE fp169;
fp169 = inteval->CD_z[vi] * src1[((hsi*108+79)*1+lsi)*1];
LIBINT2_REALTYPE fp168;
fp168 = src0[((hsi*135+103)*1+lsi)*1] + fp169;
LIBINT2_REALTYPE fp166;
fp166 = fp168 - fp167;
target[((hsi*216+160)*1+lsi)*1] = fp166;
LIBINT2_REALTYPE fp171;
fp171 = inteval->CD_y[vi] * src1[((hsi*108+79)*1+lsi)*1];
LIBINT2_REALTYPE fp170;
fp170 = src0[((hsi*135+100)*1+lsi)*1] + fp171;
target[((hsi*216+159)*1+lsi)*1] = fp170;
LIBINT2_REALTYPE fp173;
fp173 = 1.0000000000000000e+00 * src2[((hsi*108+78)*1+lsi)*1];
LIBINT2_REALTYPE fp175;
fp175 = inteval->CD_z[vi] * src1[((hsi*108+78)*1+lsi)*1];
LIBINT2_REALTYPE fp174;
fp174 = src0[((hsi*135+102)*1+lsi)*1] + fp175;
LIBINT2_REALTYPE fp172;
fp172 = fp174 - fp173;
target[((hsi*216+158)*1+lsi)*1] = fp172;
LIBINT2_REALTYPE fp177;
fp177 = inteval->CD_y[vi] * src1[((hsi*108+78)*1+lsi)*1];
LIBINT2_REALTYPE fp176;
fp176 = src0[((hsi*135+99)*1+lsi)*1] + fp177;
target[((hsi*216+157)*1+lsi)*1] = fp176;
LIBINT2_REALTYPE fp179;
fp179 = inteval->CD_x[vi] * src1[((hsi*108+78)*1+lsi)*1];
LIBINT2_REALTYPE fp178;
fp178 = src0[((hsi*135+78)*1+lsi)*1] + fp179;
target[((hsi*216+156)*1+lsi)*1] = fp178;
LIBINT2_REALTYPE fp181;
fp181 = 1.0000000000000000e+00 * src2[((hsi*108+77)*1+lsi)*1];
LIBINT2_REALTYPE fp183;
fp183 = inteval->CD_z[vi] * src1[((hsi*108+77)*1+lsi)*1];
LIBINT2_REALTYPE fp182;
fp182 = src0[((hsi*135+101)*1+lsi)*1] + fp183;
LIBINT2_REALTYPE fp180;
fp180 = fp182 - fp181;
target[((hsi*216+155)*1+lsi)*1] = fp180;
LIBINT2_REALTYPE fp185;
fp185 = 1.0000000000000000e+00 * src2[((hsi*108+76)*1+lsi)*1];
LIBINT2_REALTYPE fp187;
fp187 = inteval->CD_z[vi] * src1[((hsi*108+76)*1+lsi)*1];
LIBINT2_REALTYPE fp186;
fp186 = src0[((hsi*135+100)*1+lsi)*1] + fp187;
LIBINT2_REALTYPE fp184;
fp184 = fp186 - fp185;
target[((hsi*216+154)*1+lsi)*1] = fp184;
LIBINT2_REALTYPE fp189;
fp189 = inteval->CD_y[vi] * src1[((hsi*108+76)*1+lsi)*1];
LIBINT2_REALTYPE fp188;
fp188 = src0[((hsi*135+97)*1+lsi)*1] + fp189;
target[((hsi*216+153)*1+lsi)*1] = fp188;
LIBINT2_REALTYPE fp191;
fp191 = 1.0000000000000000e+00 * src2[((hsi*108+75)*1+lsi)*1];
LIBINT2_REALTYPE fp193;
fp193 = inteval->CD_z[vi] * src1[((hsi*108+75)*1+lsi)*1];
LIBINT2_REALTYPE fp192;
fp192 = src0[((hsi*135+99)*1+lsi)*1] + fp193;
LIBINT2_REALTYPE fp190;
fp190 = fp192 - fp191;
target[((hsi*216+152)*1+lsi)*1] = fp190;
LIBINT2_REALTYPE fp195;
fp195 = inteval->CD_y[vi] * src1[((hsi*108+75)*1+lsi)*1];
LIBINT2_REALTYPE fp194;
fp194 = src0[((hsi*135+96)*1+lsi)*1] + fp195;
target[((hsi*216+151)*1+lsi)*1] = fp194;
LIBINT2_REALTYPE fp197;
fp197 = inteval->CD_x[vi] * src1[((hsi*108+75)*1+lsi)*1];
LIBINT2_REALTYPE fp196;
fp196 = src0[((hsi*135+75)*1+lsi)*1] + fp197;
target[((hsi*216+150)*1+lsi)*1] = fp196;
LIBINT2_REALTYPE fp243;
fp243 = inteval->CD_y[vi] * src1[((hsi*108+67)*1+lsi)*1];
LIBINT2_REALTYPE fp242;
fp242 = src0[((hsi*135+88)*1+lsi)*1] + fp243;
target[((hsi*216+135)*1+lsi)*1] = fp242;
LIBINT2_REALTYPE fp203;
fp203 = 1.0000000000000000e+00 * src2[((hsi*108+73)*1+lsi)*1];
LIBINT2_REALTYPE fp205;
fp205 = inteval->CD_z[vi] * src1[((hsi*108+73)*1+lsi)*1];
LIBINT2_REALTYPE fp204;
fp204 = src0[((hsi*135+97)*1+lsi)*1] + fp205;
LIBINT2_REALTYPE fp202;
fp202 = fp204 - fp203;
target[((hsi*216+148)*1+lsi)*1] = fp202;
LIBINT2_REALTYPE fp207;
fp207 = inteval->CD_y[vi] * src1[((hsi*108+73)*1+lsi)*1];
LIBINT2_REALTYPE fp206;
fp206 = src0[((hsi*135+94)*1+lsi)*1] + fp207;
target[((hsi*216+147)*1+lsi)*1] = fp206;
LIBINT2_REALTYPE fp209;
fp209 = 1.0000000000000000e+00 * src2[((hsi*108+72)*1+lsi)*1];
LIBINT2_REALTYPE fp211;
fp211 = inteval->CD_z[vi] * src1[((hsi*108+72)*1+lsi)*1];
LIBINT2_REALTYPE fp210;
fp210 = src0[((hsi*135+96)*1+lsi)*1] + fp211;
LIBINT2_REALTYPE fp208;
fp208 = fp210 - fp209;
target[((hsi*216+146)*1+lsi)*1] = fp208;
LIBINT2_REALTYPE fp213;
fp213 = inteval->CD_y[vi] * src1[((hsi*108+72)*1+lsi)*1];
LIBINT2_REALTYPE fp212;
fp212 = src0[((hsi*135+93)*1+lsi)*1] + fp213;
target[((hsi*216+145)*1+lsi)*1] = fp212;
LIBINT2_REALTYPE fp215;
fp215 = inteval->CD_x[vi] * src1[((hsi*108+72)*1+lsi)*1];
LIBINT2_REALTYPE fp214;
fp214 = src0[((hsi*135+72)*1+lsi)*1] + fp215;
target[((hsi*216+144)*1+lsi)*1] = fp214;
LIBINT2_REALTYPE fp217;
fp217 = 1.0000000000000000e+00 * src2[((hsi*108+71)*1+lsi)*1];
LIBINT2_REALTYPE fp219;
fp219 = inteval->CD_z[vi] * src1[((hsi*108+71)*1+lsi)*1];
LIBINT2_REALTYPE fp218;
fp218 = src0[((hsi*135+95)*1+lsi)*1] + fp219;
LIBINT2_REALTYPE fp216;
fp216 = fp218 - fp217;
target[((hsi*216+143)*1+lsi)*1] = fp216;
LIBINT2_REALTYPE fp221;
fp221 = 1.0000000000000000e+00 * src2[((hsi*108+70)*1+lsi)*1];
LIBINT2_REALTYPE fp223;
fp223 = inteval->CD_z[vi] * src1[((hsi*108+70)*1+lsi)*1];
LIBINT2_REALTYPE fp222;
fp222 = src0[((hsi*135+94)*1+lsi)*1] + fp223;
LIBINT2_REALTYPE fp220;
fp220 = fp222 - fp221;
target[((hsi*216+142)*1+lsi)*1] = fp220;
LIBINT2_REALTYPE fp225;
fp225 = inteval->CD_y[vi] * src1[((hsi*108+70)*1+lsi)*1];
LIBINT2_REALTYPE fp224;
fp224 = src0[((hsi*135+91)*1+lsi)*1] + fp225;
target[((hsi*216+141)*1+lsi)*1] = fp224;
LIBINT2_REALTYPE fp227;
fp227 = 1.0000000000000000e+00 * src2[((hsi*108+69)*1+lsi)*1];
LIBINT2_REALTYPE fp229;
fp229 = inteval->CD_z[vi] * src1[((hsi*108+69)*1+lsi)*1];
LIBINT2_REALTYPE fp228;
fp228 = src0[((hsi*135+93)*1+lsi)*1] + fp229;
LIBINT2_REALTYPE fp226;
fp226 = fp228 - fp227;
target[((hsi*216+140)*1+lsi)*1] = fp226;
LIBINT2_REALTYPE fp231;
fp231 = inteval->CD_y[vi] * src1[((hsi*108+69)*1+lsi)*1];
LIBINT2_REALTYPE fp230;
fp230 = src0[((hsi*135+90)*1+lsi)*1] + fp231;
target[((hsi*216+139)*1+lsi)*1] = fp230;
LIBINT2_REALTYPE fp233;
fp233 = inteval->CD_x[vi] * src1[((hsi*108+69)*1+lsi)*1];
LIBINT2_REALTYPE fp232;
fp232 = src0[((hsi*135+69)*1+lsi)*1] + fp233;
target[((hsi*216+138)*1+lsi)*1] = fp232;
LIBINT2_REALTYPE fp235;
fp235 = 1.0000000000000000e+00 * src2[((hsi*108+68)*1+lsi)*1];
LIBINT2_REALTYPE fp237;
fp237 = inteval->CD_z[vi] * src1[((hsi*108+68)*1+lsi)*1];
LIBINT2_REALTYPE fp236;
fp236 = src0[((hsi*135+92)*1+lsi)*1] + fp237;
LIBINT2_REALTYPE fp234;
fp234 = fp236 - fp235;
target[((hsi*216+137)*1+lsi)*1] = fp234;
LIBINT2_REALTYPE fp239;
fp239 = 1.0000000000000000e+00 * src2[((hsi*108+67)*1+lsi)*1];
LIBINT2_REALTYPE fp241;
fp241 = inteval->CD_z[vi] * src1[((hsi*108+67)*1+lsi)*1];
LIBINT2_REALTYPE fp240;
fp240 = src0[((hsi*135+91)*1+lsi)*1] + fp241;
LIBINT2_REALTYPE fp238;
fp238 = fp240 - fp239;
target[((hsi*216+136)*1+lsi)*1] = fp238;
LIBINT2_REALTYPE fp199;
fp199 = 1.0000000000000000e+00 * src2[((hsi*108+74)*1+lsi)*1];
LIBINT2_REALTYPE fp201;
fp201 = inteval->CD_z[vi] * src1[((hsi*108+74)*1+lsi)*1];
LIBINT2_REALTYPE fp200;
fp200 = src0[((hsi*135+98)*1+lsi)*1] + fp201;
LIBINT2_REALTYPE fp198;
fp198 = fp200 - fp199;
target[((hsi*216+149)*1+lsi)*1] = fp198;
}
}
}
const int hsi = 0;
const int lsi = 0;
const int vi = 0;
/** Number of flops = 648 */
}

#ifdef __cplusplus
};
#endif
