/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <libint2.h>

#ifdef __cplusplus
extern "C" {
#endif
void HRRPart1bra0ket0h001f(const Libint_t* inteval, LIBINT2_REALTYPE* target, const LIBINT2_REALTYPE* src0, const LIBINT2_REALTYPE* src1, const LIBINT2_REALTYPE* src2, int highdim) {

LIBINT2_REALTYPE*const  stack = target;
#ifdef __INTEL_COMPILER
#pragma ivdep
#endif
for(int hsi = 0; hsi<highdim; hsi++) {
{
const int lsi = 0;
{
const int vi = 0;
LIBINT2_REALTYPE fp421;
fp421 = 1.0000000000000000e+00 * src2[((hsi*126+46)*1+lsi)*1];
LIBINT2_REALTYPE fp423;
fp423 = inteval->CD_z[vi] * src1[((hsi*126+46)*1+lsi)*1];
LIBINT2_REALTYPE fp422;
fp422 = src0[((hsi*168+76)*1+lsi)*1] + fp423;
LIBINT2_REALTYPE fp420;
fp420 = fp422 + fp421;
target[((hsi*210+78)*1+lsi)*1] = fp420;
LIBINT2_REALTYPE fp425;
fp425 = 1.0000000000000000e+00 * src2[((hsi*126+45)*1+lsi)*1];
LIBINT2_REALTYPE fp427;
fp427 = inteval->CD_z[vi] * src1[((hsi*126+45)*1+lsi)*1];
LIBINT2_REALTYPE fp426;
fp426 = src0[((hsi*168+75)*1+lsi)*1] + fp427;
LIBINT2_REALTYPE fp424;
fp424 = fp426 + fp425;
target[((hsi*210+77)*1+lsi)*1] = fp424;
LIBINT2_REALTYPE fp429;
fp429 = inteval->CD_y[vi] * src1[((hsi*126+45)*1+lsi)*1];
LIBINT2_REALTYPE fp428;
fp428 = src0[((hsi*168+69)*1+lsi)*1] + fp429;
target[((hsi*210+76)*1+lsi)*1] = fp428;
LIBINT2_REALTYPE fp431;
fp431 = 1.0000000000000000e+00 * src2[((hsi*126+44)*1+lsi)*1];
LIBINT2_REALTYPE fp433;
fp433 = inteval->CD_z[vi] * src1[((hsi*126+44)*1+lsi)*1];
LIBINT2_REALTYPE fp432;
fp432 = src0[((hsi*168+74)*1+lsi)*1] + fp433;
LIBINT2_REALTYPE fp430;
fp430 = fp432 + fp431;
target[((hsi*210+75)*1+lsi)*1] = fp430;
LIBINT2_REALTYPE fp435;
fp435 = 1.0000000000000000e+00 * src2[((hsi*126+43)*1+lsi)*1];
LIBINT2_REALTYPE fp437;
fp437 = inteval->CD_z[vi] * src1[((hsi*126+43)*1+lsi)*1];
LIBINT2_REALTYPE fp436;
fp436 = src0[((hsi*168+73)*1+lsi)*1] + fp437;
LIBINT2_REALTYPE fp434;
fp434 = fp436 + fp435;
target[((hsi*210+74)*1+lsi)*1] = fp434;
LIBINT2_REALTYPE fp439;
fp439 = inteval->CD_y[vi] * src1[((hsi*126+43)*1+lsi)*1];
LIBINT2_REALTYPE fp438;
fp438 = src0[((hsi*168+67)*1+lsi)*1] + fp439;
target[((hsi*210+73)*1+lsi)*1] = fp438;
LIBINT2_REALTYPE fp441;
fp441 = 1.0000000000000000e+00 * src2[((hsi*126+42)*1+lsi)*1];
LIBINT2_REALTYPE fp443;
fp443 = inteval->CD_z[vi] * src1[((hsi*126+42)*1+lsi)*1];
LIBINT2_REALTYPE fp442;
fp442 = src0[((hsi*168+72)*1+lsi)*1] + fp443;
LIBINT2_REALTYPE fp440;
fp440 = fp442 + fp441;
target[((hsi*210+72)*1+lsi)*1] = fp440;
LIBINT2_REALTYPE fp445;
fp445 = inteval->CD_y[vi] * src1[((hsi*126+42)*1+lsi)*1];
LIBINT2_REALTYPE fp444;
fp444 = src0[((hsi*168+66)*1+lsi)*1] + fp445;
target[((hsi*210+71)*1+lsi)*1] = fp444;
LIBINT2_REALTYPE fp447;
fp447 = inteval->CD_x[vi] * src1[((hsi*126+42)*1+lsi)*1];
LIBINT2_REALTYPE fp446;
fp446 = src0[((hsi*168+42)*1+lsi)*1] + fp447;
target[((hsi*210+70)*1+lsi)*1] = fp446;
LIBINT2_REALTYPE fp449;
fp449 = 1.0000000000000000e+00 * src2[((hsi*126+41)*1+lsi)*1];
LIBINT2_REALTYPE fp451;
fp451 = inteval->CD_z[vi] * src1[((hsi*126+41)*1+lsi)*1];
LIBINT2_REALTYPE fp450;
fp450 = src0[((hsi*168+71)*1+lsi)*1] + fp451;
LIBINT2_REALTYPE fp448;
fp448 = fp450 + fp449;
target[((hsi*210+69)*1+lsi)*1] = fp448;
LIBINT2_REALTYPE fp453;
fp453 = 1.0000000000000000e+00 * src2[((hsi*126+40)*1+lsi)*1];
LIBINT2_REALTYPE fp455;
fp455 = inteval->CD_z[vi] * src1[((hsi*126+40)*1+lsi)*1];
LIBINT2_REALTYPE fp454;
fp454 = src0[((hsi*168+70)*1+lsi)*1] + fp455;
LIBINT2_REALTYPE fp452;
fp452 = fp454 + fp453;
target[((hsi*210+68)*1+lsi)*1] = fp452;
LIBINT2_REALTYPE fp457;
fp457 = 1.0000000000000000e+00 * src2[((hsi*126+39)*1+lsi)*1];
LIBINT2_REALTYPE fp459;
fp459 = inteval->CD_z[vi] * src1[((hsi*126+39)*1+lsi)*1];
LIBINT2_REALTYPE fp458;
fp458 = src0[((hsi*168+69)*1+lsi)*1] + fp459;
LIBINT2_REALTYPE fp456;
fp456 = fp458 + fp457;
target[((hsi*210+67)*1+lsi)*1] = fp456;
LIBINT2_REALTYPE fp671;
fp671 = inteval->CD_x[vi] * src1[((hsi*126+0)*1+lsi)*1];
LIBINT2_REALTYPE fp670;
fp670 = src0[((hsi*168+0)*1+lsi)*1] + fp671;
target[((hsi*210+0)*1+lsi)*1] = fp670;
LIBINT2_REALTYPE fp463;
fp463 = 1.0000000000000000e+00 * src2[((hsi*126+38)*1+lsi)*1];
LIBINT2_REALTYPE fp465;
fp465 = inteval->CD_z[vi] * src1[((hsi*126+38)*1+lsi)*1];
LIBINT2_REALTYPE fp464;
fp464 = src0[((hsi*168+68)*1+lsi)*1] + fp465;
LIBINT2_REALTYPE fp462;
fp462 = fp464 + fp463;
target[((hsi*210+65)*1+lsi)*1] = fp462;
LIBINT2_REALTYPE fp467;
fp467 = 1.0000000000000000e+00 * src2[((hsi*126+37)*1+lsi)*1];
LIBINT2_REALTYPE fp469;
fp469 = inteval->CD_z[vi] * src1[((hsi*126+37)*1+lsi)*1];
LIBINT2_REALTYPE fp468;
fp468 = src0[((hsi*168+67)*1+lsi)*1] + fp469;
LIBINT2_REALTYPE fp466;
fp466 = fp468 + fp467;
target[((hsi*210+64)*1+lsi)*1] = fp466;
LIBINT2_REALTYPE fp471;
fp471 = inteval->CD_y[vi] * src1[((hsi*126+37)*1+lsi)*1];
LIBINT2_REALTYPE fp470;
fp470 = src0[((hsi*168+61)*1+lsi)*1] + fp471;
target[((hsi*210+63)*1+lsi)*1] = fp470;
LIBINT2_REALTYPE fp473;
fp473 = 1.0000000000000000e+00 * src2[((hsi*126+36)*1+lsi)*1];
LIBINT2_REALTYPE fp475;
fp475 = inteval->CD_z[vi] * src1[((hsi*126+36)*1+lsi)*1];
LIBINT2_REALTYPE fp474;
fp474 = src0[((hsi*168+66)*1+lsi)*1] + fp475;
LIBINT2_REALTYPE fp472;
fp472 = fp474 + fp473;
target[((hsi*210+62)*1+lsi)*1] = fp472;
LIBINT2_REALTYPE fp477;
fp477 = inteval->CD_y[vi] * src1[((hsi*126+36)*1+lsi)*1];
LIBINT2_REALTYPE fp476;
fp476 = src0[((hsi*168+60)*1+lsi)*1] + fp477;
target[((hsi*210+61)*1+lsi)*1] = fp476;
LIBINT2_REALTYPE fp479;
fp479 = inteval->CD_x[vi] * src1[((hsi*126+36)*1+lsi)*1];
LIBINT2_REALTYPE fp478;
fp478 = src0[((hsi*168+36)*1+lsi)*1] + fp479;
target[((hsi*210+60)*1+lsi)*1] = fp478;
LIBINT2_REALTYPE fp481;
fp481 = 1.0000000000000000e+00 * src2[((hsi*126+35)*1+lsi)*1];
LIBINT2_REALTYPE fp483;
fp483 = inteval->CD_z[vi] * src1[((hsi*126+35)*1+lsi)*1];
LIBINT2_REALTYPE fp482;
fp482 = src0[((hsi*168+59)*1+lsi)*1] + fp483;
LIBINT2_REALTYPE fp480;
fp480 = fp482 + fp481;
target[((hsi*210+59)*1+lsi)*1] = fp480;
LIBINT2_REALTYPE fp485;
fp485 = 1.0000000000000000e+00 * src2[((hsi*126+34)*1+lsi)*1];
LIBINT2_REALTYPE fp487;
fp487 = inteval->CD_z[vi] * src1[((hsi*126+34)*1+lsi)*1];
LIBINT2_REALTYPE fp486;
fp486 = src0[((hsi*168+58)*1+lsi)*1] + fp487;
LIBINT2_REALTYPE fp484;
fp484 = fp486 + fp485;
target[((hsi*210+58)*1+lsi)*1] = fp484;
LIBINT2_REALTYPE fp489;
fp489 = 1.0000000000000000e+00 * src2[((hsi*126+33)*1+lsi)*1];
LIBINT2_REALTYPE fp491;
fp491 = inteval->CD_z[vi] * src1[((hsi*126+33)*1+lsi)*1];
LIBINT2_REALTYPE fp490;
fp490 = src0[((hsi*168+57)*1+lsi)*1] + fp491;
LIBINT2_REALTYPE fp488;
fp488 = fp490 + fp489;
target[((hsi*210+57)*1+lsi)*1] = fp488;
LIBINT2_REALTYPE fp493;
fp493 = inteval->CD_y[vi] * src1[((hsi*126+33)*1+lsi)*1];
LIBINT2_REALTYPE fp492;
fp492 = src0[((hsi*168+51)*1+lsi)*1] + fp493;
target[((hsi*210+56)*1+lsi)*1] = fp492;
LIBINT2_REALTYPE fp495;
fp495 = 1.0000000000000000e+00 * src2[((hsi*126+32)*1+lsi)*1];
LIBINT2_REALTYPE fp497;
fp497 = inteval->CD_z[vi] * src1[((hsi*126+32)*1+lsi)*1];
LIBINT2_REALTYPE fp496;
fp496 = src0[((hsi*168+56)*1+lsi)*1] + fp497;
LIBINT2_REALTYPE fp494;
fp494 = fp496 + fp495;
target[((hsi*210+55)*1+lsi)*1] = fp494;
LIBINT2_REALTYPE fp499;
fp499 = 1.0000000000000000e+00 * src2[((hsi*126+31)*1+lsi)*1];
LIBINT2_REALTYPE fp501;
fp501 = inteval->CD_z[vi] * src1[((hsi*126+31)*1+lsi)*1];
LIBINT2_REALTYPE fp500;
fp500 = src0[((hsi*168+55)*1+lsi)*1] + fp501;
LIBINT2_REALTYPE fp498;
fp498 = fp500 + fp499;
target[((hsi*210+54)*1+lsi)*1] = fp498;
LIBINT2_REALTYPE fp461;
fp461 = inteval->CD_y[vi] * src1[((hsi*126+39)*1+lsi)*1];
LIBINT2_REALTYPE fp460;
fp460 = src0[((hsi*168+63)*1+lsi)*1] + fp461;
target[((hsi*210+66)*1+lsi)*1] = fp460;
LIBINT2_REALTYPE fp339;
fp339 = 1.0000000000000000e+00 * src2[((hsi*126+61)*1+lsi)*1];
LIBINT2_REALTYPE fp341;
fp341 = inteval->CD_z[vi] * src1[((hsi*126+61)*1+lsi)*1];
LIBINT2_REALTYPE fp340;
fp340 = src0[((hsi*168+97)*1+lsi)*1] + fp341;
LIBINT2_REALTYPE fp338;
fp338 = fp340 + fp339;
target[((hsi*210+104)*1+lsi)*1] = fp338;
LIBINT2_REALTYPE fp343;
fp343 = inteval->CD_y[vi] * src1[((hsi*126+61)*1+lsi)*1];
LIBINT2_REALTYPE fp342;
fp342 = src0[((hsi*168+91)*1+lsi)*1] + fp343;
target[((hsi*210+103)*1+lsi)*1] = fp342;
LIBINT2_REALTYPE fp345;
fp345 = 1.0000000000000000e+00 * src2[((hsi*126+60)*1+lsi)*1];
LIBINT2_REALTYPE fp347;
fp347 = inteval->CD_z[vi] * src1[((hsi*126+60)*1+lsi)*1];
LIBINT2_REALTYPE fp346;
fp346 = src0[((hsi*168+96)*1+lsi)*1] + fp347;
LIBINT2_REALTYPE fp344;
fp344 = fp346 + fp345;
target[((hsi*210+102)*1+lsi)*1] = fp344;
LIBINT2_REALTYPE fp349;
fp349 = inteval->CD_y[vi] * src1[((hsi*126+60)*1+lsi)*1];
LIBINT2_REALTYPE fp348;
fp348 = src0[((hsi*168+90)*1+lsi)*1] + fp349;
target[((hsi*210+101)*1+lsi)*1] = fp348;
LIBINT2_REALTYPE fp351;
fp351 = inteval->CD_x[vi] * src1[((hsi*126+60)*1+lsi)*1];
LIBINT2_REALTYPE fp350;
fp350 = src0[((hsi*168+60)*1+lsi)*1] + fp351;
target[((hsi*210+100)*1+lsi)*1] = fp350;
LIBINT2_REALTYPE fp353;
fp353 = 1.0000000000000000e+00 * src2[((hsi*126+59)*1+lsi)*1];
LIBINT2_REALTYPE fp355;
fp355 = inteval->CD_z[vi] * src1[((hsi*126+59)*1+lsi)*1];
LIBINT2_REALTYPE fp354;
fp354 = src0[((hsi*168+89)*1+lsi)*1] + fp355;
LIBINT2_REALTYPE fp352;
fp352 = fp354 + fp353;
target[((hsi*210+99)*1+lsi)*1] = fp352;
LIBINT2_REALTYPE fp357;
fp357 = 1.0000000000000000e+00 * src2[((hsi*126+58)*1+lsi)*1];
LIBINT2_REALTYPE fp359;
fp359 = inteval->CD_z[vi] * src1[((hsi*126+58)*1+lsi)*1];
LIBINT2_REALTYPE fp358;
fp358 = src0[((hsi*168+88)*1+lsi)*1] + fp359;
LIBINT2_REALTYPE fp356;
fp356 = fp358 + fp357;
target[((hsi*210+98)*1+lsi)*1] = fp356;
LIBINT2_REALTYPE fp361;
fp361 = 1.0000000000000000e+00 * src2[((hsi*126+57)*1+lsi)*1];
LIBINT2_REALTYPE fp363;
fp363 = inteval->CD_z[vi] * src1[((hsi*126+57)*1+lsi)*1];
LIBINT2_REALTYPE fp362;
fp362 = src0[((hsi*168+87)*1+lsi)*1] + fp363;
LIBINT2_REALTYPE fp360;
fp360 = fp362 + fp361;
target[((hsi*210+97)*1+lsi)*1] = fp360;
LIBINT2_REALTYPE fp365;
fp365 = inteval->CD_y[vi] * src1[((hsi*126+57)*1+lsi)*1];
LIBINT2_REALTYPE fp364;
fp364 = src0[((hsi*168+81)*1+lsi)*1] + fp365;
target[((hsi*210+96)*1+lsi)*1] = fp364;
LIBINT2_REALTYPE fp367;
fp367 = 1.0000000000000000e+00 * src2[((hsi*126+56)*1+lsi)*1];
LIBINT2_REALTYPE fp369;
fp369 = inteval->CD_z[vi] * src1[((hsi*126+56)*1+lsi)*1];
LIBINT2_REALTYPE fp368;
fp368 = src0[((hsi*168+86)*1+lsi)*1] + fp369;
LIBINT2_REALTYPE fp366;
fp366 = fp368 + fp367;
target[((hsi*210+95)*1+lsi)*1] = fp366;
LIBINT2_REALTYPE fp371;
fp371 = 1.0000000000000000e+00 * src2[((hsi*126+55)*1+lsi)*1];
LIBINT2_REALTYPE fp373;
fp373 = inteval->CD_z[vi] * src1[((hsi*126+55)*1+lsi)*1];
LIBINT2_REALTYPE fp372;
fp372 = src0[((hsi*168+85)*1+lsi)*1] + fp373;
LIBINT2_REALTYPE fp370;
fp370 = fp372 + fp371;
target[((hsi*210+94)*1+lsi)*1] = fp370;
LIBINT2_REALTYPE fp375;
fp375 = inteval->CD_y[vi] * src1[((hsi*126+55)*1+lsi)*1];
LIBINT2_REALTYPE fp374;
fp374 = src0[((hsi*168+79)*1+lsi)*1] + fp375;
target[((hsi*210+93)*1+lsi)*1] = fp374;
LIBINT2_REALTYPE fp417;
fp417 = 1.0000000000000000e+00 * src2[((hsi*126+47)*1+lsi)*1];
LIBINT2_REALTYPE fp419;
fp419 = inteval->CD_z[vi] * src1[((hsi*126+47)*1+lsi)*1];
LIBINT2_REALTYPE fp418;
fp418 = src0[((hsi*168+77)*1+lsi)*1] + fp419;
LIBINT2_REALTYPE fp416;
fp416 = fp418 + fp417;
target[((hsi*210+79)*1+lsi)*1] = fp416;
LIBINT2_REALTYPE fp381;
fp381 = inteval->CD_y[vi] * src1[((hsi*126+54)*1+lsi)*1];
LIBINT2_REALTYPE fp380;
fp380 = src0[((hsi*168+78)*1+lsi)*1] + fp381;
target[((hsi*210+91)*1+lsi)*1] = fp380;
LIBINT2_REALTYPE fp383;
fp383 = inteval->CD_x[vi] * src1[((hsi*126+54)*1+lsi)*1];
LIBINT2_REALTYPE fp382;
fp382 = src0[((hsi*168+54)*1+lsi)*1] + fp383;
target[((hsi*210+90)*1+lsi)*1] = fp382;
LIBINT2_REALTYPE fp385;
fp385 = 1.0000000000000000e+00 * src2[((hsi*126+53)*1+lsi)*1];
LIBINT2_REALTYPE fp387;
fp387 = inteval->CD_z[vi] * src1[((hsi*126+53)*1+lsi)*1];
LIBINT2_REALTYPE fp386;
fp386 = src0[((hsi*168+83)*1+lsi)*1] + fp387;
LIBINT2_REALTYPE fp384;
fp384 = fp386 + fp385;
target[((hsi*210+89)*1+lsi)*1] = fp384;
LIBINT2_REALTYPE fp389;
fp389 = 1.0000000000000000e+00 * src2[((hsi*126+52)*1+lsi)*1];
LIBINT2_REALTYPE fp391;
fp391 = inteval->CD_z[vi] * src1[((hsi*126+52)*1+lsi)*1];
LIBINT2_REALTYPE fp390;
fp390 = src0[((hsi*168+82)*1+lsi)*1] + fp391;
LIBINT2_REALTYPE fp388;
fp388 = fp390 + fp389;
target[((hsi*210+88)*1+lsi)*1] = fp388;
LIBINT2_REALTYPE fp393;
fp393 = 1.0000000000000000e+00 * src2[((hsi*126+51)*1+lsi)*1];
LIBINT2_REALTYPE fp395;
fp395 = inteval->CD_z[vi] * src1[((hsi*126+51)*1+lsi)*1];
LIBINT2_REALTYPE fp394;
fp394 = src0[((hsi*168+81)*1+lsi)*1] + fp395;
LIBINT2_REALTYPE fp392;
fp392 = fp394 + fp393;
target[((hsi*210+87)*1+lsi)*1] = fp392;
LIBINT2_REALTYPE fp397;
fp397 = inteval->CD_y[vi] * src1[((hsi*126+51)*1+lsi)*1];
LIBINT2_REALTYPE fp396;
fp396 = src0[((hsi*168+75)*1+lsi)*1] + fp397;
target[((hsi*210+86)*1+lsi)*1] = fp396;
LIBINT2_REALTYPE fp399;
fp399 = 1.0000000000000000e+00 * src2[((hsi*126+50)*1+lsi)*1];
LIBINT2_REALTYPE fp401;
fp401 = inteval->CD_z[vi] * src1[((hsi*126+50)*1+lsi)*1];
LIBINT2_REALTYPE fp400;
fp400 = src0[((hsi*168+80)*1+lsi)*1] + fp401;
LIBINT2_REALTYPE fp398;
fp398 = fp400 + fp399;
target[((hsi*210+85)*1+lsi)*1] = fp398;
LIBINT2_REALTYPE fp403;
fp403 = 1.0000000000000000e+00 * src2[((hsi*126+49)*1+lsi)*1];
LIBINT2_REALTYPE fp405;
fp405 = inteval->CD_z[vi] * src1[((hsi*126+49)*1+lsi)*1];
LIBINT2_REALTYPE fp404;
fp404 = src0[((hsi*168+79)*1+lsi)*1] + fp405;
LIBINT2_REALTYPE fp402;
fp402 = fp404 + fp403;
target[((hsi*210+84)*1+lsi)*1] = fp402;
LIBINT2_REALTYPE fp407;
fp407 = inteval->CD_y[vi] * src1[((hsi*126+49)*1+lsi)*1];
LIBINT2_REALTYPE fp406;
fp406 = src0[((hsi*168+73)*1+lsi)*1] + fp407;
target[((hsi*210+83)*1+lsi)*1] = fp406;
LIBINT2_REALTYPE fp409;
fp409 = 1.0000000000000000e+00 * src2[((hsi*126+48)*1+lsi)*1];
LIBINT2_REALTYPE fp411;
fp411 = inteval->CD_z[vi] * src1[((hsi*126+48)*1+lsi)*1];
LIBINT2_REALTYPE fp410;
fp410 = src0[((hsi*168+78)*1+lsi)*1] + fp411;
LIBINT2_REALTYPE fp408;
fp408 = fp410 + fp409;
target[((hsi*210+82)*1+lsi)*1] = fp408;
LIBINT2_REALTYPE fp413;
fp413 = inteval->CD_y[vi] * src1[((hsi*126+48)*1+lsi)*1];
LIBINT2_REALTYPE fp412;
fp412 = src0[((hsi*168+72)*1+lsi)*1] + fp413;
target[((hsi*210+81)*1+lsi)*1] = fp412;
LIBINT2_REALTYPE fp415;
fp415 = inteval->CD_x[vi] * src1[((hsi*126+48)*1+lsi)*1];
LIBINT2_REALTYPE fp414;
fp414 = src0[((hsi*168+48)*1+lsi)*1] + fp415;
target[((hsi*210+80)*1+lsi)*1] = fp414;
LIBINT2_REALTYPE fp377;
fp377 = 1.0000000000000000e+00 * src2[((hsi*126+54)*1+lsi)*1];
LIBINT2_REALTYPE fp379;
fp379 = inteval->CD_z[vi] * src1[((hsi*126+54)*1+lsi)*1];
LIBINT2_REALTYPE fp378;
fp378 = src0[((hsi*168+84)*1+lsi)*1] + fp379;
LIBINT2_REALTYPE fp376;
fp376 = fp378 + fp377;
target[((hsi*210+92)*1+lsi)*1] = fp376;
LIBINT2_REALTYPE fp591;
fp591 = 1.0000000000000000e+00 * src2[((hsi*126+14)*1+lsi)*1];
LIBINT2_REALTYPE fp593;
fp593 = inteval->CD_z[vi] * src1[((hsi*126+14)*1+lsi)*1];
LIBINT2_REALTYPE fp592;
fp592 = src0[((hsi*168+32)*1+lsi)*1] + fp593;
LIBINT2_REALTYPE fp590;
fp590 = fp592 + fp591;
target[((hsi*210+25)*1+lsi)*1] = fp590;
LIBINT2_REALTYPE fp595;
fp595 = 1.0000000000000000e+00 * src2[((hsi*126+13)*1+lsi)*1];
LIBINT2_REALTYPE fp597;
fp597 = inteval->CD_z[vi] * src1[((hsi*126+13)*1+lsi)*1];
LIBINT2_REALTYPE fp596;
fp596 = src0[((hsi*168+31)*1+lsi)*1] + fp597;
LIBINT2_REALTYPE fp594;
fp594 = fp596 + fp595;
target[((hsi*210+24)*1+lsi)*1] = fp594;
LIBINT2_REALTYPE fp599;
fp599 = inteval->CD_y[vi] * src1[((hsi*126+13)*1+lsi)*1];
LIBINT2_REALTYPE fp598;
fp598 = src0[((hsi*168+25)*1+lsi)*1] + fp599;
target[((hsi*210+23)*1+lsi)*1] = fp598;
LIBINT2_REALTYPE fp601;
fp601 = 1.0000000000000000e+00 * src2[((hsi*126+12)*1+lsi)*1];
LIBINT2_REALTYPE fp603;
fp603 = inteval->CD_z[vi] * src1[((hsi*126+12)*1+lsi)*1];
LIBINT2_REALTYPE fp602;
fp602 = src0[((hsi*168+30)*1+lsi)*1] + fp603;
LIBINT2_REALTYPE fp600;
fp600 = fp602 + fp601;
target[((hsi*210+22)*1+lsi)*1] = fp600;
LIBINT2_REALTYPE fp605;
fp605 = inteval->CD_y[vi] * src1[((hsi*126+12)*1+lsi)*1];
LIBINT2_REALTYPE fp604;
fp604 = src0[((hsi*168+24)*1+lsi)*1] + fp605;
target[((hsi*210+21)*1+lsi)*1] = fp604;
LIBINT2_REALTYPE fp607;
fp607 = inteval->CD_x[vi] * src1[((hsi*126+12)*1+lsi)*1];
LIBINT2_REALTYPE fp606;
fp606 = src0[((hsi*168+12)*1+lsi)*1] + fp607;
target[((hsi*210+20)*1+lsi)*1] = fp606;
LIBINT2_REALTYPE fp609;
fp609 = 1.0000000000000000e+00 * src2[((hsi*126+11)*1+lsi)*1];
LIBINT2_REALTYPE fp611;
fp611 = inteval->CD_z[vi] * src1[((hsi*126+11)*1+lsi)*1];
LIBINT2_REALTYPE fp610;
fp610 = src0[((hsi*168+29)*1+lsi)*1] + fp611;
LIBINT2_REALTYPE fp608;
fp608 = fp610 + fp609;
target[((hsi*210+19)*1+lsi)*1] = fp608;
LIBINT2_REALTYPE fp613;
fp613 = 1.0000000000000000e+00 * src2[((hsi*126+10)*1+lsi)*1];
LIBINT2_REALTYPE fp615;
fp615 = inteval->CD_z[vi] * src1[((hsi*126+10)*1+lsi)*1];
LIBINT2_REALTYPE fp614;
fp614 = src0[((hsi*168+28)*1+lsi)*1] + fp615;
LIBINT2_REALTYPE fp612;
fp612 = fp614 + fp613;
target[((hsi*210+18)*1+lsi)*1] = fp612;
LIBINT2_REALTYPE fp617;
fp617 = 1.0000000000000000e+00 * src2[((hsi*126+9)*1+lsi)*1];
LIBINT2_REALTYPE fp619;
fp619 = inteval->CD_z[vi] * src1[((hsi*126+9)*1+lsi)*1];
LIBINT2_REALTYPE fp618;
fp618 = src0[((hsi*168+27)*1+lsi)*1] + fp619;
LIBINT2_REALTYPE fp616;
fp616 = fp618 + fp617;
target[((hsi*210+17)*1+lsi)*1] = fp616;
LIBINT2_REALTYPE fp621;
fp621 = inteval->CD_y[vi] * src1[((hsi*126+9)*1+lsi)*1];
LIBINT2_REALTYPE fp620;
fp620 = src0[((hsi*168+21)*1+lsi)*1] + fp621;
target[((hsi*210+16)*1+lsi)*1] = fp620;
LIBINT2_REALTYPE fp623;
fp623 = 1.0000000000000000e+00 * src2[((hsi*126+8)*1+lsi)*1];
LIBINT2_REALTYPE fp625;
fp625 = inteval->CD_z[vi] * src1[((hsi*126+8)*1+lsi)*1];
LIBINT2_REALTYPE fp624;
fp624 = src0[((hsi*168+26)*1+lsi)*1] + fp625;
LIBINT2_REALTYPE fp622;
fp622 = fp624 + fp623;
target[((hsi*210+15)*1+lsi)*1] = fp622;
LIBINT2_REALTYPE fp627;
fp627 = 1.0000000000000000e+00 * src2[((hsi*126+7)*1+lsi)*1];
LIBINT2_REALTYPE fp629;
fp629 = inteval->CD_z[vi] * src1[((hsi*126+7)*1+lsi)*1];
LIBINT2_REALTYPE fp628;
fp628 = src0[((hsi*168+25)*1+lsi)*1] + fp629;
LIBINT2_REALTYPE fp626;
fp626 = fp628 + fp627;
target[((hsi*210+14)*1+lsi)*1] = fp626;
LIBINT2_REALTYPE fp503;
fp503 = inteval->CD_y[vi] * src1[((hsi*126+31)*1+lsi)*1];
LIBINT2_REALTYPE fp502;
fp502 = src0[((hsi*168+49)*1+lsi)*1] + fp503;
target[((hsi*210+53)*1+lsi)*1] = fp502;
LIBINT2_REALTYPE fp633;
fp633 = 1.0000000000000000e+00 * src2[((hsi*126+6)*1+lsi)*1];
LIBINT2_REALTYPE fp635;
fp635 = inteval->CD_z[vi] * src1[((hsi*126+6)*1+lsi)*1];
LIBINT2_REALTYPE fp634;
fp634 = src0[((hsi*168+24)*1+lsi)*1] + fp635;
LIBINT2_REALTYPE fp632;
fp632 = fp634 + fp633;
target[((hsi*210+12)*1+lsi)*1] = fp632;
LIBINT2_REALTYPE fp637;
fp637 = inteval->CD_y[vi] * src1[((hsi*126+6)*1+lsi)*1];
LIBINT2_REALTYPE fp636;
fp636 = src0[((hsi*168+18)*1+lsi)*1] + fp637;
target[((hsi*210+11)*1+lsi)*1] = fp636;
LIBINT2_REALTYPE fp639;
fp639 = inteval->CD_x[vi] * src1[((hsi*126+6)*1+lsi)*1];
LIBINT2_REALTYPE fp638;
fp638 = src0[((hsi*168+6)*1+lsi)*1] + fp639;
target[((hsi*210+10)*1+lsi)*1] = fp638;
LIBINT2_REALTYPE fp641;
fp641 = 1.0000000000000000e+00 * src2[((hsi*126+5)*1+lsi)*1];
LIBINT2_REALTYPE fp643;
fp643 = inteval->CD_z[vi] * src1[((hsi*126+5)*1+lsi)*1];
LIBINT2_REALTYPE fp642;
fp642 = src0[((hsi*168+17)*1+lsi)*1] + fp643;
LIBINT2_REALTYPE fp640;
fp640 = fp642 + fp641;
target[((hsi*210+9)*1+lsi)*1] = fp640;
LIBINT2_REALTYPE fp645;
fp645 = 1.0000000000000000e+00 * src2[((hsi*126+4)*1+lsi)*1];
LIBINT2_REALTYPE fp647;
fp647 = inteval->CD_z[vi] * src1[((hsi*126+4)*1+lsi)*1];
LIBINT2_REALTYPE fp646;
fp646 = src0[((hsi*168+16)*1+lsi)*1] + fp647;
LIBINT2_REALTYPE fp644;
fp644 = fp646 + fp645;
target[((hsi*210+8)*1+lsi)*1] = fp644;
LIBINT2_REALTYPE fp649;
fp649 = 1.0000000000000000e+00 * src2[((hsi*126+3)*1+lsi)*1];
LIBINT2_REALTYPE fp651;
fp651 = inteval->CD_z[vi] * src1[((hsi*126+3)*1+lsi)*1];
LIBINT2_REALTYPE fp650;
fp650 = src0[((hsi*168+15)*1+lsi)*1] + fp651;
LIBINT2_REALTYPE fp648;
fp648 = fp650 + fp649;
target[((hsi*210+7)*1+lsi)*1] = fp648;
LIBINT2_REALTYPE fp653;
fp653 = inteval->CD_y[vi] * src1[((hsi*126+3)*1+lsi)*1];
LIBINT2_REALTYPE fp652;
fp652 = src0[((hsi*168+9)*1+lsi)*1] + fp653;
target[((hsi*210+6)*1+lsi)*1] = fp652;
LIBINT2_REALTYPE fp655;
fp655 = 1.0000000000000000e+00 * src2[((hsi*126+2)*1+lsi)*1];
LIBINT2_REALTYPE fp657;
fp657 = inteval->CD_z[vi] * src1[((hsi*126+2)*1+lsi)*1];
LIBINT2_REALTYPE fp656;
fp656 = src0[((hsi*168+14)*1+lsi)*1] + fp657;
LIBINT2_REALTYPE fp654;
fp654 = fp656 + fp655;
target[((hsi*210+5)*1+lsi)*1] = fp654;
LIBINT2_REALTYPE fp659;
fp659 = 1.0000000000000000e+00 * src2[((hsi*126+1)*1+lsi)*1];
LIBINT2_REALTYPE fp661;
fp661 = inteval->CD_z[vi] * src1[((hsi*126+1)*1+lsi)*1];
LIBINT2_REALTYPE fp660;
fp660 = src0[((hsi*168+13)*1+lsi)*1] + fp661;
LIBINT2_REALTYPE fp658;
fp658 = fp660 + fp659;
target[((hsi*210+4)*1+lsi)*1] = fp658;
LIBINT2_REALTYPE fp663;
fp663 = inteval->CD_y[vi] * src1[((hsi*126+1)*1+lsi)*1];
LIBINT2_REALTYPE fp662;
fp662 = src0[((hsi*168+7)*1+lsi)*1] + fp663;
target[((hsi*210+3)*1+lsi)*1] = fp662;
LIBINT2_REALTYPE fp665;
fp665 = 1.0000000000000000e+00 * src2[((hsi*126+0)*1+lsi)*1];
LIBINT2_REALTYPE fp667;
fp667 = inteval->CD_z[vi] * src1[((hsi*126+0)*1+lsi)*1];
LIBINT2_REALTYPE fp666;
fp666 = src0[((hsi*168+12)*1+lsi)*1] + fp667;
LIBINT2_REALTYPE fp664;
fp664 = fp666 + fp665;
target[((hsi*210+2)*1+lsi)*1] = fp664;
LIBINT2_REALTYPE fp669;
fp669 = inteval->CD_y[vi] * src1[((hsi*126+0)*1+lsi)*1];
LIBINT2_REALTYPE fp668;
fp668 = src0[((hsi*168+6)*1+lsi)*1] + fp669;
target[((hsi*210+1)*1+lsi)*1] = fp668;
LIBINT2_REALTYPE fp631;
fp631 = inteval->CD_y[vi] * src1[((hsi*126+7)*1+lsi)*1];
LIBINT2_REALTYPE fp630;
fp630 = src0[((hsi*168+19)*1+lsi)*1] + fp631;
target[((hsi*210+13)*1+lsi)*1] = fp630;
LIBINT2_REALTYPE fp505;
fp505 = 1.0000000000000000e+00 * src2[((hsi*126+30)*1+lsi)*1];
LIBINT2_REALTYPE fp507;
fp507 = inteval->CD_z[vi] * src1[((hsi*126+30)*1+lsi)*1];
LIBINT2_REALTYPE fp506;
fp506 = src0[((hsi*168+54)*1+lsi)*1] + fp507;
LIBINT2_REALTYPE fp504;
fp504 = fp506 + fp505;
target[((hsi*210+52)*1+lsi)*1] = fp504;
LIBINT2_REALTYPE fp509;
fp509 = inteval->CD_y[vi] * src1[((hsi*126+30)*1+lsi)*1];
LIBINT2_REALTYPE fp508;
fp508 = src0[((hsi*168+48)*1+lsi)*1] + fp509;
target[((hsi*210+51)*1+lsi)*1] = fp508;
LIBINT2_REALTYPE fp511;
fp511 = inteval->CD_x[vi] * src1[((hsi*126+30)*1+lsi)*1];
LIBINT2_REALTYPE fp510;
fp510 = src0[((hsi*168+30)*1+lsi)*1] + fp511;
target[((hsi*210+50)*1+lsi)*1] = fp510;
LIBINT2_REALTYPE fp513;
fp513 = 1.0000000000000000e+00 * src2[((hsi*126+29)*1+lsi)*1];
LIBINT2_REALTYPE fp515;
fp515 = inteval->CD_z[vi] * src1[((hsi*126+29)*1+lsi)*1];
LIBINT2_REALTYPE fp514;
fp514 = src0[((hsi*168+53)*1+lsi)*1] + fp515;
LIBINT2_REALTYPE fp512;
fp512 = fp514 + fp513;
target[((hsi*210+49)*1+lsi)*1] = fp512;
LIBINT2_REALTYPE fp517;
fp517 = 1.0000000000000000e+00 * src2[((hsi*126+28)*1+lsi)*1];
LIBINT2_REALTYPE fp519;
fp519 = inteval->CD_z[vi] * src1[((hsi*126+28)*1+lsi)*1];
LIBINT2_REALTYPE fp518;
fp518 = src0[((hsi*168+52)*1+lsi)*1] + fp519;
LIBINT2_REALTYPE fp516;
fp516 = fp518 + fp517;
target[((hsi*210+48)*1+lsi)*1] = fp516;
LIBINT2_REALTYPE fp521;
fp521 = 1.0000000000000000e+00 * src2[((hsi*126+27)*1+lsi)*1];
LIBINT2_REALTYPE fp523;
fp523 = inteval->CD_z[vi] * src1[((hsi*126+27)*1+lsi)*1];
LIBINT2_REALTYPE fp522;
fp522 = src0[((hsi*168+51)*1+lsi)*1] + fp523;
LIBINT2_REALTYPE fp520;
fp520 = fp522 + fp521;
target[((hsi*210+47)*1+lsi)*1] = fp520;
LIBINT2_REALTYPE fp525;
fp525 = inteval->CD_y[vi] * src1[((hsi*126+27)*1+lsi)*1];
LIBINT2_REALTYPE fp524;
fp524 = src0[((hsi*168+45)*1+lsi)*1] + fp525;
target[((hsi*210+46)*1+lsi)*1] = fp524;
LIBINT2_REALTYPE fp527;
fp527 = 1.0000000000000000e+00 * src2[((hsi*126+26)*1+lsi)*1];
LIBINT2_REALTYPE fp529;
fp529 = inteval->CD_z[vi] * src1[((hsi*126+26)*1+lsi)*1];
LIBINT2_REALTYPE fp528;
fp528 = src0[((hsi*168+50)*1+lsi)*1] + fp529;
LIBINT2_REALTYPE fp526;
fp526 = fp528 + fp527;
target[((hsi*210+45)*1+lsi)*1] = fp526;
LIBINT2_REALTYPE fp531;
fp531 = 1.0000000000000000e+00 * src2[((hsi*126+25)*1+lsi)*1];
LIBINT2_REALTYPE fp533;
fp533 = inteval->CD_z[vi] * src1[((hsi*126+25)*1+lsi)*1];
LIBINT2_REALTYPE fp532;
fp532 = src0[((hsi*168+49)*1+lsi)*1] + fp533;
LIBINT2_REALTYPE fp530;
fp530 = fp532 + fp531;
target[((hsi*210+44)*1+lsi)*1] = fp530;
LIBINT2_REALTYPE fp535;
fp535 = inteval->CD_y[vi] * src1[((hsi*126+25)*1+lsi)*1];
LIBINT2_REALTYPE fp534;
fp534 = src0[((hsi*168+43)*1+lsi)*1] + fp535;
target[((hsi*210+43)*1+lsi)*1] = fp534;
LIBINT2_REALTYPE fp537;
fp537 = 1.0000000000000000e+00 * src2[((hsi*126+24)*1+lsi)*1];
LIBINT2_REALTYPE fp539;
fp539 = inteval->CD_z[vi] * src1[((hsi*126+24)*1+lsi)*1];
LIBINT2_REALTYPE fp538;
fp538 = src0[((hsi*168+48)*1+lsi)*1] + fp539;
LIBINT2_REALTYPE fp536;
fp536 = fp538 + fp537;
target[((hsi*210+42)*1+lsi)*1] = fp536;
LIBINT2_REALTYPE fp541;
fp541 = inteval->CD_y[vi] * src1[((hsi*126+24)*1+lsi)*1];
LIBINT2_REALTYPE fp540;
fp540 = src0[((hsi*168+42)*1+lsi)*1] + fp541;
target[((hsi*210+41)*1+lsi)*1] = fp540;
LIBINT2_REALTYPE fp589;
fp589 = inteval->CD_y[vi] * src1[((hsi*126+15)*1+lsi)*1];
LIBINT2_REALTYPE fp588;
fp588 = src0[((hsi*168+27)*1+lsi)*1] + fp589;
target[((hsi*210+26)*1+lsi)*1] = fp588;
LIBINT2_REALTYPE fp545;
fp545 = 1.0000000000000000e+00 * src2[((hsi*126+23)*1+lsi)*1];
LIBINT2_REALTYPE fp547;
fp547 = inteval->CD_z[vi] * src1[((hsi*126+23)*1+lsi)*1];
LIBINT2_REALTYPE fp546;
fp546 = src0[((hsi*168+47)*1+lsi)*1] + fp547;
LIBINT2_REALTYPE fp544;
fp544 = fp546 + fp545;
target[((hsi*210+39)*1+lsi)*1] = fp544;
LIBINT2_REALTYPE fp549;
fp549 = 1.0000000000000000e+00 * src2[((hsi*126+22)*1+lsi)*1];
LIBINT2_REALTYPE fp551;
fp551 = inteval->CD_z[vi] * src1[((hsi*126+22)*1+lsi)*1];
LIBINT2_REALTYPE fp550;
fp550 = src0[((hsi*168+46)*1+lsi)*1] + fp551;
LIBINT2_REALTYPE fp548;
fp548 = fp550 + fp549;
target[((hsi*210+38)*1+lsi)*1] = fp548;
LIBINT2_REALTYPE fp553;
fp553 = 1.0000000000000000e+00 * src2[((hsi*126+21)*1+lsi)*1];
LIBINT2_REALTYPE fp555;
fp555 = inteval->CD_z[vi] * src1[((hsi*126+21)*1+lsi)*1];
LIBINT2_REALTYPE fp554;
fp554 = src0[((hsi*168+45)*1+lsi)*1] + fp555;
LIBINT2_REALTYPE fp552;
fp552 = fp554 + fp553;
target[((hsi*210+37)*1+lsi)*1] = fp552;
LIBINT2_REALTYPE fp557;
fp557 = inteval->CD_y[vi] * src1[((hsi*126+21)*1+lsi)*1];
LIBINT2_REALTYPE fp556;
fp556 = src0[((hsi*168+39)*1+lsi)*1] + fp557;
target[((hsi*210+36)*1+lsi)*1] = fp556;
LIBINT2_REALTYPE fp559;
fp559 = 1.0000000000000000e+00 * src2[((hsi*126+20)*1+lsi)*1];
LIBINT2_REALTYPE fp561;
fp561 = inteval->CD_z[vi] * src1[((hsi*126+20)*1+lsi)*1];
LIBINT2_REALTYPE fp560;
fp560 = src0[((hsi*168+44)*1+lsi)*1] + fp561;
LIBINT2_REALTYPE fp558;
fp558 = fp560 + fp559;
target[((hsi*210+35)*1+lsi)*1] = fp558;
LIBINT2_REALTYPE fp563;
fp563 = 1.0000000000000000e+00 * src2[((hsi*126+19)*1+lsi)*1];
LIBINT2_REALTYPE fp565;
fp565 = inteval->CD_z[vi] * src1[((hsi*126+19)*1+lsi)*1];
LIBINT2_REALTYPE fp564;
fp564 = src0[((hsi*168+43)*1+lsi)*1] + fp565;
LIBINT2_REALTYPE fp562;
fp562 = fp564 + fp563;
target[((hsi*210+34)*1+lsi)*1] = fp562;
LIBINT2_REALTYPE fp567;
fp567 = inteval->CD_y[vi] * src1[((hsi*126+19)*1+lsi)*1];
LIBINT2_REALTYPE fp566;
fp566 = src0[((hsi*168+37)*1+lsi)*1] + fp567;
target[((hsi*210+33)*1+lsi)*1] = fp566;
LIBINT2_REALTYPE fp569;
fp569 = 1.0000000000000000e+00 * src2[((hsi*126+18)*1+lsi)*1];
LIBINT2_REALTYPE fp571;
fp571 = inteval->CD_z[vi] * src1[((hsi*126+18)*1+lsi)*1];
LIBINT2_REALTYPE fp570;
fp570 = src0[((hsi*168+42)*1+lsi)*1] + fp571;
LIBINT2_REALTYPE fp568;
fp568 = fp570 + fp569;
target[((hsi*210+32)*1+lsi)*1] = fp568;
LIBINT2_REALTYPE fp573;
fp573 = inteval->CD_y[vi] * src1[((hsi*126+18)*1+lsi)*1];
LIBINT2_REALTYPE fp572;
fp572 = src0[((hsi*168+36)*1+lsi)*1] + fp573;
target[((hsi*210+31)*1+lsi)*1] = fp572;
LIBINT2_REALTYPE fp575;
fp575 = inteval->CD_x[vi] * src1[((hsi*126+18)*1+lsi)*1];
LIBINT2_REALTYPE fp574;
fp574 = src0[((hsi*168+18)*1+lsi)*1] + fp575;
target[((hsi*210+30)*1+lsi)*1] = fp574;
LIBINT2_REALTYPE fp577;
fp577 = 1.0000000000000000e+00 * src2[((hsi*126+17)*1+lsi)*1];
LIBINT2_REALTYPE fp579;
fp579 = inteval->CD_z[vi] * src1[((hsi*126+17)*1+lsi)*1];
LIBINT2_REALTYPE fp578;
fp578 = src0[((hsi*168+35)*1+lsi)*1] + fp579;
LIBINT2_REALTYPE fp576;
fp576 = fp578 + fp577;
target[((hsi*210+29)*1+lsi)*1] = fp576;
LIBINT2_REALTYPE fp581;
fp581 = 1.0000000000000000e+00 * src2[((hsi*126+16)*1+lsi)*1];
LIBINT2_REALTYPE fp583;
fp583 = inteval->CD_z[vi] * src1[((hsi*126+16)*1+lsi)*1];
LIBINT2_REALTYPE fp582;
fp582 = src0[((hsi*168+34)*1+lsi)*1] + fp583;
LIBINT2_REALTYPE fp580;
fp580 = fp582 + fp581;
target[((hsi*210+28)*1+lsi)*1] = fp580;
LIBINT2_REALTYPE fp585;
fp585 = 1.0000000000000000e+00 * src2[((hsi*126+15)*1+lsi)*1];
LIBINT2_REALTYPE fp587;
fp587 = inteval->CD_z[vi] * src1[((hsi*126+15)*1+lsi)*1];
LIBINT2_REALTYPE fp586;
fp586 = src0[((hsi*168+33)*1+lsi)*1] + fp587;
LIBINT2_REALTYPE fp584;
fp584 = fp586 + fp585;
target[((hsi*210+27)*1+lsi)*1] = fp584;
LIBINT2_REALTYPE fp543;
fp543 = inteval->CD_x[vi] * src1[((hsi*126+24)*1+lsi)*1];
LIBINT2_REALTYPE fp542;
fp542 = src0[((hsi*168+24)*1+lsi)*1] + fp543;
target[((hsi*210+40)*1+lsi)*1] = fp542;
LIBINT2_REALTYPE fp87;
fp87 = inteval->CD_y[vi] * src1[((hsi*126+109)*1+lsi)*1];
LIBINT2_REALTYPE fp86;
fp86 = src0[((hsi*168+145)*1+lsi)*1] + fp87;
target[((hsi*210+183)*1+lsi)*1] = fp86;
LIBINT2_REALTYPE fp89;
fp89 = 1.0000000000000000e+00 * src2[((hsi*126+108)*1+lsi)*1];
LIBINT2_REALTYPE fp91;
fp91 = inteval->CD_z[vi] * src1[((hsi*126+108)*1+lsi)*1];
LIBINT2_REALTYPE fp90;
fp90 = src0[((hsi*168+150)*1+lsi)*1] + fp91;
LIBINT2_REALTYPE fp88;
fp88 = fp90 + fp89;
target[((hsi*210+182)*1+lsi)*1] = fp88;
LIBINT2_REALTYPE fp93;
fp93 = inteval->CD_y[vi] * src1[((hsi*126+108)*1+lsi)*1];
LIBINT2_REALTYPE fp92;
fp92 = src0[((hsi*168+144)*1+lsi)*1] + fp93;
target[((hsi*210+181)*1+lsi)*1] = fp92;
LIBINT2_REALTYPE fp95;
fp95 = inteval->CD_x[vi] * src1[((hsi*126+108)*1+lsi)*1];
LIBINT2_REALTYPE fp94;
fp94 = src0[((hsi*168+108)*1+lsi)*1] + fp95;
target[((hsi*210+180)*1+lsi)*1] = fp94;
LIBINT2_REALTYPE fp97;
fp97 = 1.0000000000000000e+00 * src2[((hsi*126+107)*1+lsi)*1];
LIBINT2_REALTYPE fp99;
fp99 = inteval->CD_z[vi] * src1[((hsi*126+107)*1+lsi)*1];
LIBINT2_REALTYPE fp98;
fp98 = src0[((hsi*168+149)*1+lsi)*1] + fp99;
LIBINT2_REALTYPE fp96;
fp96 = fp98 + fp97;
target[((hsi*210+179)*1+lsi)*1] = fp96;
LIBINT2_REALTYPE fp101;
fp101 = 1.0000000000000000e+00 * src2[((hsi*126+106)*1+lsi)*1];
LIBINT2_REALTYPE fp103;
fp103 = inteval->CD_z[vi] * src1[((hsi*126+106)*1+lsi)*1];
LIBINT2_REALTYPE fp102;
fp102 = src0[((hsi*168+148)*1+lsi)*1] + fp103;
LIBINT2_REALTYPE fp100;
fp100 = fp102 + fp101;
target[((hsi*210+178)*1+lsi)*1] = fp100;
LIBINT2_REALTYPE fp105;
fp105 = 1.0000000000000000e+00 * src2[((hsi*126+105)*1+lsi)*1];
LIBINT2_REALTYPE fp107;
fp107 = inteval->CD_z[vi] * src1[((hsi*126+105)*1+lsi)*1];
LIBINT2_REALTYPE fp106;
fp106 = src0[((hsi*168+147)*1+lsi)*1] + fp107;
LIBINT2_REALTYPE fp104;
fp104 = fp106 + fp105;
target[((hsi*210+177)*1+lsi)*1] = fp104;
LIBINT2_REALTYPE fp109;
fp109 = inteval->CD_y[vi] * src1[((hsi*126+105)*1+lsi)*1];
LIBINT2_REALTYPE fp108;
fp108 = src0[((hsi*168+141)*1+lsi)*1] + fp109;
target[((hsi*210+176)*1+lsi)*1] = fp108;
LIBINT2_REALTYPE fp111;
fp111 = 1.0000000000000000e+00 * src2[((hsi*126+104)*1+lsi)*1];
LIBINT2_REALTYPE fp113;
fp113 = inteval->CD_z[vi] * src1[((hsi*126+104)*1+lsi)*1];
LIBINT2_REALTYPE fp112;
fp112 = src0[((hsi*168+146)*1+lsi)*1] + fp113;
LIBINT2_REALTYPE fp110;
fp110 = fp112 + fp111;
target[((hsi*210+175)*1+lsi)*1] = fp110;
LIBINT2_REALTYPE fp115;
fp115 = 1.0000000000000000e+00 * src2[((hsi*126+103)*1+lsi)*1];
LIBINT2_REALTYPE fp117;
fp117 = inteval->CD_z[vi] * src1[((hsi*126+103)*1+lsi)*1];
LIBINT2_REALTYPE fp116;
fp116 = src0[((hsi*168+145)*1+lsi)*1] + fp117;
LIBINT2_REALTYPE fp114;
fp114 = fp116 + fp115;
target[((hsi*210+174)*1+lsi)*1] = fp114;
LIBINT2_REALTYPE fp119;
fp119 = inteval->CD_y[vi] * src1[((hsi*126+103)*1+lsi)*1];
LIBINT2_REALTYPE fp118;
fp118 = src0[((hsi*168+139)*1+lsi)*1] + fp119;
target[((hsi*210+173)*1+lsi)*1] = fp118;
LIBINT2_REALTYPE fp121;
fp121 = 1.0000000000000000e+00 * src2[((hsi*126+102)*1+lsi)*1];
LIBINT2_REALTYPE fp123;
fp123 = inteval->CD_z[vi] * src1[((hsi*126+102)*1+lsi)*1];
LIBINT2_REALTYPE fp122;
fp122 = src0[((hsi*168+144)*1+lsi)*1] + fp123;
LIBINT2_REALTYPE fp120;
fp120 = fp122 + fp121;
target[((hsi*210+172)*1+lsi)*1] = fp120;
LIBINT2_REALTYPE fp335;
fp335 = 1.0000000000000000e+00 * src2[((hsi*126+62)*1+lsi)*1];
LIBINT2_REALTYPE fp337;
fp337 = inteval->CD_z[vi] * src1[((hsi*126+62)*1+lsi)*1];
LIBINT2_REALTYPE fp336;
fp336 = src0[((hsi*168+98)*1+lsi)*1] + fp337;
LIBINT2_REALTYPE fp334;
fp334 = fp336 + fp335;
target[((hsi*210+105)*1+lsi)*1] = fp334;
LIBINT2_REALTYPE fp127;
fp127 = inteval->CD_x[vi] * src1[((hsi*126+102)*1+lsi)*1];
LIBINT2_REALTYPE fp126;
fp126 = src0[((hsi*168+102)*1+lsi)*1] + fp127;
target[((hsi*210+170)*1+lsi)*1] = fp126;
LIBINT2_REALTYPE fp129;
fp129 = 1.0000000000000000e+00 * src2[((hsi*126+101)*1+lsi)*1];
LIBINT2_REALTYPE fp131;
fp131 = inteval->CD_z[vi] * src1[((hsi*126+101)*1+lsi)*1];
LIBINT2_REALTYPE fp130;
fp130 = src0[((hsi*168+143)*1+lsi)*1] + fp131;
LIBINT2_REALTYPE fp128;
fp128 = fp130 + fp129;
target[((hsi*210+169)*1+lsi)*1] = fp128;
LIBINT2_REALTYPE fp133;
fp133 = 1.0000000000000000e+00 * src2[((hsi*126+100)*1+lsi)*1];
LIBINT2_REALTYPE fp135;
fp135 = inteval->CD_z[vi] * src1[((hsi*126+100)*1+lsi)*1];
LIBINT2_REALTYPE fp134;
fp134 = src0[((hsi*168+142)*1+lsi)*1] + fp135;
LIBINT2_REALTYPE fp132;
fp132 = fp134 + fp133;
target[((hsi*210+168)*1+lsi)*1] = fp132;
LIBINT2_REALTYPE fp137;
fp137 = 1.0000000000000000e+00 * src2[((hsi*126+99)*1+lsi)*1];
LIBINT2_REALTYPE fp139;
fp139 = inteval->CD_z[vi] * src1[((hsi*126+99)*1+lsi)*1];
LIBINT2_REALTYPE fp138;
fp138 = src0[((hsi*168+141)*1+lsi)*1] + fp139;
LIBINT2_REALTYPE fp136;
fp136 = fp138 + fp137;
target[((hsi*210+167)*1+lsi)*1] = fp136;
LIBINT2_REALTYPE fp141;
fp141 = inteval->CD_y[vi] * src1[((hsi*126+99)*1+lsi)*1];
LIBINT2_REALTYPE fp140;
fp140 = src0[((hsi*168+135)*1+lsi)*1] + fp141;
target[((hsi*210+166)*1+lsi)*1] = fp140;
LIBINT2_REALTYPE fp143;
fp143 = 1.0000000000000000e+00 * src2[((hsi*126+98)*1+lsi)*1];
LIBINT2_REALTYPE fp145;
fp145 = inteval->CD_z[vi] * src1[((hsi*126+98)*1+lsi)*1];
LIBINT2_REALTYPE fp144;
fp144 = src0[((hsi*168+140)*1+lsi)*1] + fp145;
LIBINT2_REALTYPE fp142;
fp142 = fp144 + fp143;
target[((hsi*210+165)*1+lsi)*1] = fp142;
LIBINT2_REALTYPE fp147;
fp147 = 1.0000000000000000e+00 * src2[((hsi*126+97)*1+lsi)*1];
LIBINT2_REALTYPE fp149;
fp149 = inteval->CD_z[vi] * src1[((hsi*126+97)*1+lsi)*1];
LIBINT2_REALTYPE fp148;
fp148 = src0[((hsi*168+139)*1+lsi)*1] + fp149;
LIBINT2_REALTYPE fp146;
fp146 = fp148 + fp147;
target[((hsi*210+164)*1+lsi)*1] = fp146;
LIBINT2_REALTYPE fp151;
fp151 = inteval->CD_y[vi] * src1[((hsi*126+97)*1+lsi)*1];
LIBINT2_REALTYPE fp150;
fp150 = src0[((hsi*168+133)*1+lsi)*1] + fp151;
target[((hsi*210+163)*1+lsi)*1] = fp150;
LIBINT2_REALTYPE fp153;
fp153 = 1.0000000000000000e+00 * src2[((hsi*126+96)*1+lsi)*1];
LIBINT2_REALTYPE fp155;
fp155 = inteval->CD_z[vi] * src1[((hsi*126+96)*1+lsi)*1];
LIBINT2_REALTYPE fp154;
fp154 = src0[((hsi*168+138)*1+lsi)*1] + fp155;
LIBINT2_REALTYPE fp152;
fp152 = fp154 + fp153;
target[((hsi*210+162)*1+lsi)*1] = fp152;
LIBINT2_REALTYPE fp157;
fp157 = inteval->CD_y[vi] * src1[((hsi*126+96)*1+lsi)*1];
LIBINT2_REALTYPE fp156;
fp156 = src0[((hsi*168+132)*1+lsi)*1] + fp157;
target[((hsi*210+161)*1+lsi)*1] = fp156;
LIBINT2_REALTYPE fp159;
fp159 = inteval->CD_x[vi] * src1[((hsi*126+96)*1+lsi)*1];
LIBINT2_REALTYPE fp158;
fp158 = src0[((hsi*168+96)*1+lsi)*1] + fp159;
target[((hsi*210+160)*1+lsi)*1] = fp158;
LIBINT2_REALTYPE fp161;
fp161 = 1.0000000000000000e+00 * src2[((hsi*126+95)*1+lsi)*1];
LIBINT2_REALTYPE fp163;
fp163 = inteval->CD_z[vi] * src1[((hsi*126+95)*1+lsi)*1];
LIBINT2_REALTYPE fp162;
fp162 = src0[((hsi*168+137)*1+lsi)*1] + fp163;
LIBINT2_REALTYPE fp160;
fp160 = fp162 + fp161;
target[((hsi*210+159)*1+lsi)*1] = fp160;
LIBINT2_REALTYPE fp125;
fp125 = inteval->CD_y[vi] * src1[((hsi*126+102)*1+lsi)*1];
LIBINT2_REALTYPE fp124;
fp124 = src0[((hsi*168+138)*1+lsi)*1] + fp125;
target[((hsi*210+171)*1+lsi)*1] = fp124;
LIBINT2_REALTYPE fp1;
fp1 = 1.0000000000000000e+00 * src2[((hsi*126+125)*1+lsi)*1];
LIBINT2_REALTYPE fp3;
fp3 = inteval->CD_z[vi] * src1[((hsi*126+125)*1+lsi)*1];
LIBINT2_REALTYPE fp2;
fp2 = src0[((hsi*168+167)*1+lsi)*1] + fp3;
LIBINT2_REALTYPE fp0;
fp0 = fp2 + fp1;
target[((hsi*210+209)*1+lsi)*1] = fp0;
LIBINT2_REALTYPE fp5;
fp5 = 1.0000000000000000e+00 * src2[((hsi*126+124)*1+lsi)*1];
LIBINT2_REALTYPE fp7;
fp7 = inteval->CD_z[vi] * src1[((hsi*126+124)*1+lsi)*1];
LIBINT2_REALTYPE fp6;
fp6 = src0[((hsi*168+166)*1+lsi)*1] + fp7;
LIBINT2_REALTYPE fp4;
fp4 = fp6 + fp5;
target[((hsi*210+208)*1+lsi)*1] = fp4;
LIBINT2_REALTYPE fp9;
fp9 = 1.0000000000000000e+00 * src2[((hsi*126+123)*1+lsi)*1];
LIBINT2_REALTYPE fp11;
fp11 = inteval->CD_z[vi] * src1[((hsi*126+123)*1+lsi)*1];
LIBINT2_REALTYPE fp10;
fp10 = src0[((hsi*168+165)*1+lsi)*1] + fp11;
LIBINT2_REALTYPE fp8;
fp8 = fp10 + fp9;
target[((hsi*210+207)*1+lsi)*1] = fp8;
LIBINT2_REALTYPE fp13;
fp13 = inteval->CD_y[vi] * src1[((hsi*126+123)*1+lsi)*1];
LIBINT2_REALTYPE fp12;
fp12 = src0[((hsi*168+159)*1+lsi)*1] + fp13;
target[((hsi*210+206)*1+lsi)*1] = fp12;
LIBINT2_REALTYPE fp15;
fp15 = 1.0000000000000000e+00 * src2[((hsi*126+122)*1+lsi)*1];
LIBINT2_REALTYPE fp17;
fp17 = inteval->CD_z[vi] * src1[((hsi*126+122)*1+lsi)*1];
LIBINT2_REALTYPE fp16;
fp16 = src0[((hsi*168+164)*1+lsi)*1] + fp17;
LIBINT2_REALTYPE fp14;
fp14 = fp16 + fp15;
target[((hsi*210+205)*1+lsi)*1] = fp14;
LIBINT2_REALTYPE fp19;
fp19 = 1.0000000000000000e+00 * src2[((hsi*126+121)*1+lsi)*1];
LIBINT2_REALTYPE fp21;
fp21 = inteval->CD_z[vi] * src1[((hsi*126+121)*1+lsi)*1];
LIBINT2_REALTYPE fp20;
fp20 = src0[((hsi*168+163)*1+lsi)*1] + fp21;
LIBINT2_REALTYPE fp18;
fp18 = fp20 + fp19;
target[((hsi*210+204)*1+lsi)*1] = fp18;
LIBINT2_REALTYPE fp23;
fp23 = inteval->CD_y[vi] * src1[((hsi*126+121)*1+lsi)*1];
LIBINT2_REALTYPE fp22;
fp22 = src0[((hsi*168+157)*1+lsi)*1] + fp23;
target[((hsi*210+203)*1+lsi)*1] = fp22;
LIBINT2_REALTYPE fp25;
fp25 = 1.0000000000000000e+00 * src2[((hsi*126+120)*1+lsi)*1];
LIBINT2_REALTYPE fp27;
fp27 = inteval->CD_z[vi] * src1[((hsi*126+120)*1+lsi)*1];
LIBINT2_REALTYPE fp26;
fp26 = src0[((hsi*168+162)*1+lsi)*1] + fp27;
LIBINT2_REALTYPE fp24;
fp24 = fp26 + fp25;
target[((hsi*210+202)*1+lsi)*1] = fp24;
LIBINT2_REALTYPE fp29;
fp29 = inteval->CD_y[vi] * src1[((hsi*126+120)*1+lsi)*1];
LIBINT2_REALTYPE fp28;
fp28 = src0[((hsi*168+156)*1+lsi)*1] + fp29;
target[((hsi*210+201)*1+lsi)*1] = fp28;
LIBINT2_REALTYPE fp31;
fp31 = inteval->CD_x[vi] * src1[((hsi*126+120)*1+lsi)*1];
LIBINT2_REALTYPE fp30;
fp30 = src0[((hsi*168+120)*1+lsi)*1] + fp31;
target[((hsi*210+200)*1+lsi)*1] = fp30;
LIBINT2_REALTYPE fp33;
fp33 = 1.0000000000000000e+00 * src2[((hsi*126+119)*1+lsi)*1];
LIBINT2_REALTYPE fp35;
fp35 = inteval->CD_z[vi] * src1[((hsi*126+119)*1+lsi)*1];
LIBINT2_REALTYPE fp34;
fp34 = src0[((hsi*168+161)*1+lsi)*1] + fp35;
LIBINT2_REALTYPE fp32;
fp32 = fp34 + fp33;
target[((hsi*210+199)*1+lsi)*1] = fp32;
LIBINT2_REALTYPE fp37;
fp37 = 1.0000000000000000e+00 * src2[((hsi*126+118)*1+lsi)*1];
LIBINT2_REALTYPE fp39;
fp39 = inteval->CD_z[vi] * src1[((hsi*126+118)*1+lsi)*1];
LIBINT2_REALTYPE fp38;
fp38 = src0[((hsi*168+160)*1+lsi)*1] + fp39;
LIBINT2_REALTYPE fp36;
fp36 = fp38 + fp37;
target[((hsi*210+198)*1+lsi)*1] = fp36;
LIBINT2_REALTYPE fp83;
fp83 = 1.0000000000000000e+00 * src2[((hsi*126+109)*1+lsi)*1];
LIBINT2_REALTYPE fp85;
fp85 = inteval->CD_z[vi] * src1[((hsi*126+109)*1+lsi)*1];
LIBINT2_REALTYPE fp84;
fp84 = src0[((hsi*168+151)*1+lsi)*1] + fp85;
LIBINT2_REALTYPE fp82;
fp82 = fp84 + fp83;
target[((hsi*210+184)*1+lsi)*1] = fp82;
LIBINT2_REALTYPE fp45;
fp45 = inteval->CD_y[vi] * src1[((hsi*126+117)*1+lsi)*1];
LIBINT2_REALTYPE fp44;
fp44 = src0[((hsi*168+153)*1+lsi)*1] + fp45;
target[((hsi*210+196)*1+lsi)*1] = fp44;
LIBINT2_REALTYPE fp47;
fp47 = 1.0000000000000000e+00 * src2[((hsi*126+116)*1+lsi)*1];
LIBINT2_REALTYPE fp49;
fp49 = inteval->CD_z[vi] * src1[((hsi*126+116)*1+lsi)*1];
LIBINT2_REALTYPE fp48;
fp48 = src0[((hsi*168+158)*1+lsi)*1] + fp49;
LIBINT2_REALTYPE fp46;
fp46 = fp48 + fp47;
target[((hsi*210+195)*1+lsi)*1] = fp46;
LIBINT2_REALTYPE fp51;
fp51 = 1.0000000000000000e+00 * src2[((hsi*126+115)*1+lsi)*1];
LIBINT2_REALTYPE fp53;
fp53 = inteval->CD_z[vi] * src1[((hsi*126+115)*1+lsi)*1];
LIBINT2_REALTYPE fp52;
fp52 = src0[((hsi*168+157)*1+lsi)*1] + fp53;
LIBINT2_REALTYPE fp50;
fp50 = fp52 + fp51;
target[((hsi*210+194)*1+lsi)*1] = fp50;
LIBINT2_REALTYPE fp55;
fp55 = inteval->CD_y[vi] * src1[((hsi*126+115)*1+lsi)*1];
LIBINT2_REALTYPE fp54;
fp54 = src0[((hsi*168+151)*1+lsi)*1] + fp55;
target[((hsi*210+193)*1+lsi)*1] = fp54;
LIBINT2_REALTYPE fp57;
fp57 = 1.0000000000000000e+00 * src2[((hsi*126+114)*1+lsi)*1];
LIBINT2_REALTYPE fp59;
fp59 = inteval->CD_z[vi] * src1[((hsi*126+114)*1+lsi)*1];
LIBINT2_REALTYPE fp58;
fp58 = src0[((hsi*168+156)*1+lsi)*1] + fp59;
LIBINT2_REALTYPE fp56;
fp56 = fp58 + fp57;
target[((hsi*210+192)*1+lsi)*1] = fp56;
LIBINT2_REALTYPE fp61;
fp61 = inteval->CD_y[vi] * src1[((hsi*126+114)*1+lsi)*1];
LIBINT2_REALTYPE fp60;
fp60 = src0[((hsi*168+150)*1+lsi)*1] + fp61;
target[((hsi*210+191)*1+lsi)*1] = fp60;
LIBINT2_REALTYPE fp63;
fp63 = inteval->CD_x[vi] * src1[((hsi*126+114)*1+lsi)*1];
LIBINT2_REALTYPE fp62;
fp62 = src0[((hsi*168+114)*1+lsi)*1] + fp63;
target[((hsi*210+190)*1+lsi)*1] = fp62;
LIBINT2_REALTYPE fp65;
fp65 = 1.0000000000000000e+00 * src2[((hsi*126+113)*1+lsi)*1];
LIBINT2_REALTYPE fp67;
fp67 = inteval->CD_z[vi] * src1[((hsi*126+113)*1+lsi)*1];
LIBINT2_REALTYPE fp66;
fp66 = src0[((hsi*168+155)*1+lsi)*1] + fp67;
LIBINT2_REALTYPE fp64;
fp64 = fp66 + fp65;
target[((hsi*210+189)*1+lsi)*1] = fp64;
LIBINT2_REALTYPE fp69;
fp69 = 1.0000000000000000e+00 * src2[((hsi*126+112)*1+lsi)*1];
LIBINT2_REALTYPE fp71;
fp71 = inteval->CD_z[vi] * src1[((hsi*126+112)*1+lsi)*1];
LIBINT2_REALTYPE fp70;
fp70 = src0[((hsi*168+154)*1+lsi)*1] + fp71;
LIBINT2_REALTYPE fp68;
fp68 = fp70 + fp69;
target[((hsi*210+188)*1+lsi)*1] = fp68;
LIBINT2_REALTYPE fp73;
fp73 = 1.0000000000000000e+00 * src2[((hsi*126+111)*1+lsi)*1];
LIBINT2_REALTYPE fp75;
fp75 = inteval->CD_z[vi] * src1[((hsi*126+111)*1+lsi)*1];
LIBINT2_REALTYPE fp74;
fp74 = src0[((hsi*168+153)*1+lsi)*1] + fp75;
LIBINT2_REALTYPE fp72;
fp72 = fp74 + fp73;
target[((hsi*210+187)*1+lsi)*1] = fp72;
LIBINT2_REALTYPE fp77;
fp77 = inteval->CD_y[vi] * src1[((hsi*126+111)*1+lsi)*1];
LIBINT2_REALTYPE fp76;
fp76 = src0[((hsi*168+147)*1+lsi)*1] + fp77;
target[((hsi*210+186)*1+lsi)*1] = fp76;
LIBINT2_REALTYPE fp79;
fp79 = 1.0000000000000000e+00 * src2[((hsi*126+110)*1+lsi)*1];
LIBINT2_REALTYPE fp81;
fp81 = inteval->CD_z[vi] * src1[((hsi*126+110)*1+lsi)*1];
LIBINT2_REALTYPE fp80;
fp80 = src0[((hsi*168+152)*1+lsi)*1] + fp81;
LIBINT2_REALTYPE fp78;
fp78 = fp80 + fp79;
target[((hsi*210+185)*1+lsi)*1] = fp78;
LIBINT2_REALTYPE fp41;
fp41 = 1.0000000000000000e+00 * src2[((hsi*126+117)*1+lsi)*1];
LIBINT2_REALTYPE fp43;
fp43 = inteval->CD_z[vi] * src1[((hsi*126+117)*1+lsi)*1];
LIBINT2_REALTYPE fp42;
fp42 = src0[((hsi*168+159)*1+lsi)*1] + fp43;
LIBINT2_REALTYPE fp40;
fp40 = fp42 + fp41;
target[((hsi*210+197)*1+lsi)*1] = fp40;
LIBINT2_REALTYPE fp255;
fp255 = inteval->CD_x[vi] * src1[((hsi*126+78)*1+lsi)*1];
LIBINT2_REALTYPE fp254;
fp254 = src0[((hsi*168+78)*1+lsi)*1] + fp255;
target[((hsi*210+130)*1+lsi)*1] = fp254;
LIBINT2_REALTYPE fp257;
fp257 = 1.0000000000000000e+00 * src2[((hsi*126+77)*1+lsi)*1];
LIBINT2_REALTYPE fp259;
fp259 = inteval->CD_z[vi] * src1[((hsi*126+77)*1+lsi)*1];
LIBINT2_REALTYPE fp258;
fp258 = src0[((hsi*168+113)*1+lsi)*1] + fp259;
LIBINT2_REALTYPE fp256;
fp256 = fp258 + fp257;
target[((hsi*210+129)*1+lsi)*1] = fp256;
LIBINT2_REALTYPE fp261;
fp261 = 1.0000000000000000e+00 * src2[((hsi*126+76)*1+lsi)*1];
LIBINT2_REALTYPE fp263;
fp263 = inteval->CD_z[vi] * src1[((hsi*126+76)*1+lsi)*1];
LIBINT2_REALTYPE fp262;
fp262 = src0[((hsi*168+112)*1+lsi)*1] + fp263;
LIBINT2_REALTYPE fp260;
fp260 = fp262 + fp261;
target[((hsi*210+128)*1+lsi)*1] = fp260;
LIBINT2_REALTYPE fp265;
fp265 = 1.0000000000000000e+00 * src2[((hsi*126+75)*1+lsi)*1];
LIBINT2_REALTYPE fp267;
fp267 = inteval->CD_z[vi] * src1[((hsi*126+75)*1+lsi)*1];
LIBINT2_REALTYPE fp266;
fp266 = src0[((hsi*168+111)*1+lsi)*1] + fp267;
LIBINT2_REALTYPE fp264;
fp264 = fp266 + fp265;
target[((hsi*210+127)*1+lsi)*1] = fp264;
LIBINT2_REALTYPE fp269;
fp269 = inteval->CD_y[vi] * src1[((hsi*126+75)*1+lsi)*1];
LIBINT2_REALTYPE fp268;
fp268 = src0[((hsi*168+105)*1+lsi)*1] + fp269;
target[((hsi*210+126)*1+lsi)*1] = fp268;
LIBINT2_REALTYPE fp271;
fp271 = 1.0000000000000000e+00 * src2[((hsi*126+74)*1+lsi)*1];
LIBINT2_REALTYPE fp273;
fp273 = inteval->CD_z[vi] * src1[((hsi*126+74)*1+lsi)*1];
LIBINT2_REALTYPE fp272;
fp272 = src0[((hsi*168+110)*1+lsi)*1] + fp273;
LIBINT2_REALTYPE fp270;
fp270 = fp272 + fp271;
target[((hsi*210+125)*1+lsi)*1] = fp270;
LIBINT2_REALTYPE fp275;
fp275 = 1.0000000000000000e+00 * src2[((hsi*126+73)*1+lsi)*1];
LIBINT2_REALTYPE fp277;
fp277 = inteval->CD_z[vi] * src1[((hsi*126+73)*1+lsi)*1];
LIBINT2_REALTYPE fp276;
fp276 = src0[((hsi*168+109)*1+lsi)*1] + fp277;
LIBINT2_REALTYPE fp274;
fp274 = fp276 + fp275;
target[((hsi*210+124)*1+lsi)*1] = fp274;
LIBINT2_REALTYPE fp279;
fp279 = inteval->CD_y[vi] * src1[((hsi*126+73)*1+lsi)*1];
LIBINT2_REALTYPE fp278;
fp278 = src0[((hsi*168+103)*1+lsi)*1] + fp279;
target[((hsi*210+123)*1+lsi)*1] = fp278;
LIBINT2_REALTYPE fp281;
fp281 = 1.0000000000000000e+00 * src2[((hsi*126+72)*1+lsi)*1];
LIBINT2_REALTYPE fp283;
fp283 = inteval->CD_z[vi] * src1[((hsi*126+72)*1+lsi)*1];
LIBINT2_REALTYPE fp282;
fp282 = src0[((hsi*168+108)*1+lsi)*1] + fp283;
LIBINT2_REALTYPE fp280;
fp280 = fp282 + fp281;
target[((hsi*210+122)*1+lsi)*1] = fp280;
LIBINT2_REALTYPE fp285;
fp285 = inteval->CD_y[vi] * src1[((hsi*126+72)*1+lsi)*1];
LIBINT2_REALTYPE fp284;
fp284 = src0[((hsi*168+102)*1+lsi)*1] + fp285;
target[((hsi*210+121)*1+lsi)*1] = fp284;
LIBINT2_REALTYPE fp287;
fp287 = inteval->CD_x[vi] * src1[((hsi*126+72)*1+lsi)*1];
LIBINT2_REALTYPE fp286;
fp286 = src0[((hsi*168+72)*1+lsi)*1] + fp287;
target[((hsi*210+120)*1+lsi)*1] = fp286;
LIBINT2_REALTYPE fp289;
fp289 = 1.0000000000000000e+00 * src2[((hsi*126+71)*1+lsi)*1];
LIBINT2_REALTYPE fp291;
fp291 = inteval->CD_z[vi] * src1[((hsi*126+71)*1+lsi)*1];
LIBINT2_REALTYPE fp290;
fp290 = src0[((hsi*168+107)*1+lsi)*1] + fp291;
LIBINT2_REALTYPE fp288;
fp288 = fp290 + fp289;
target[((hsi*210+119)*1+lsi)*1] = fp288;
LIBINT2_REALTYPE fp165;
fp165 = 1.0000000000000000e+00 * src2[((hsi*126+94)*1+lsi)*1];
LIBINT2_REALTYPE fp167;
fp167 = inteval->CD_z[vi] * src1[((hsi*126+94)*1+lsi)*1];
LIBINT2_REALTYPE fp166;
fp166 = src0[((hsi*168+136)*1+lsi)*1] + fp167;
LIBINT2_REALTYPE fp164;
fp164 = fp166 + fp165;
target[((hsi*210+158)*1+lsi)*1] = fp164;
LIBINT2_REALTYPE fp297;
fp297 = 1.0000000000000000e+00 * src2[((hsi*126+69)*1+lsi)*1];
LIBINT2_REALTYPE fp299;
fp299 = inteval->CD_z[vi] * src1[((hsi*126+69)*1+lsi)*1];
LIBINT2_REALTYPE fp298;
fp298 = src0[((hsi*168+105)*1+lsi)*1] + fp299;
LIBINT2_REALTYPE fp296;
fp296 = fp298 + fp297;
target[((hsi*210+117)*1+lsi)*1] = fp296;
LIBINT2_REALTYPE fp301;
fp301 = inteval->CD_y[vi] * src1[((hsi*126+69)*1+lsi)*1];
LIBINT2_REALTYPE fp300;
fp300 = src0[((hsi*168+99)*1+lsi)*1] + fp301;
target[((hsi*210+116)*1+lsi)*1] = fp300;
LIBINT2_REALTYPE fp303;
fp303 = 1.0000000000000000e+00 * src2[((hsi*126+68)*1+lsi)*1];
LIBINT2_REALTYPE fp305;
fp305 = inteval->CD_z[vi] * src1[((hsi*126+68)*1+lsi)*1];
LIBINT2_REALTYPE fp304;
fp304 = src0[((hsi*168+104)*1+lsi)*1] + fp305;
LIBINT2_REALTYPE fp302;
fp302 = fp304 + fp303;
target[((hsi*210+115)*1+lsi)*1] = fp302;
LIBINT2_REALTYPE fp307;
fp307 = 1.0000000000000000e+00 * src2[((hsi*126+67)*1+lsi)*1];
LIBINT2_REALTYPE fp309;
fp309 = inteval->CD_z[vi] * src1[((hsi*126+67)*1+lsi)*1];
LIBINT2_REALTYPE fp308;
fp308 = src0[((hsi*168+103)*1+lsi)*1] + fp309;
LIBINT2_REALTYPE fp306;
fp306 = fp308 + fp307;
target[((hsi*210+114)*1+lsi)*1] = fp306;
LIBINT2_REALTYPE fp311;
fp311 = inteval->CD_y[vi] * src1[((hsi*126+67)*1+lsi)*1];
LIBINT2_REALTYPE fp310;
fp310 = src0[((hsi*168+97)*1+lsi)*1] + fp311;
target[((hsi*210+113)*1+lsi)*1] = fp310;
LIBINT2_REALTYPE fp313;
fp313 = 1.0000000000000000e+00 * src2[((hsi*126+66)*1+lsi)*1];
LIBINT2_REALTYPE fp315;
fp315 = inteval->CD_z[vi] * src1[((hsi*126+66)*1+lsi)*1];
LIBINT2_REALTYPE fp314;
fp314 = src0[((hsi*168+102)*1+lsi)*1] + fp315;
LIBINT2_REALTYPE fp312;
fp312 = fp314 + fp313;
target[((hsi*210+112)*1+lsi)*1] = fp312;
LIBINT2_REALTYPE fp317;
fp317 = inteval->CD_y[vi] * src1[((hsi*126+66)*1+lsi)*1];
LIBINT2_REALTYPE fp316;
fp316 = src0[((hsi*168+96)*1+lsi)*1] + fp317;
target[((hsi*210+111)*1+lsi)*1] = fp316;
LIBINT2_REALTYPE fp319;
fp319 = inteval->CD_x[vi] * src1[((hsi*126+66)*1+lsi)*1];
LIBINT2_REALTYPE fp318;
fp318 = src0[((hsi*168+66)*1+lsi)*1] + fp319;
target[((hsi*210+110)*1+lsi)*1] = fp318;
LIBINT2_REALTYPE fp321;
fp321 = 1.0000000000000000e+00 * src2[((hsi*126+65)*1+lsi)*1];
LIBINT2_REALTYPE fp323;
fp323 = inteval->CD_z[vi] * src1[((hsi*126+65)*1+lsi)*1];
LIBINT2_REALTYPE fp322;
fp322 = src0[((hsi*168+101)*1+lsi)*1] + fp323;
LIBINT2_REALTYPE fp320;
fp320 = fp322 + fp321;
target[((hsi*210+109)*1+lsi)*1] = fp320;
LIBINT2_REALTYPE fp325;
fp325 = 1.0000000000000000e+00 * src2[((hsi*126+64)*1+lsi)*1];
LIBINT2_REALTYPE fp327;
fp327 = inteval->CD_z[vi] * src1[((hsi*126+64)*1+lsi)*1];
LIBINT2_REALTYPE fp326;
fp326 = src0[((hsi*168+100)*1+lsi)*1] + fp327;
LIBINT2_REALTYPE fp324;
fp324 = fp326 + fp325;
target[((hsi*210+108)*1+lsi)*1] = fp324;
LIBINT2_REALTYPE fp329;
fp329 = 1.0000000000000000e+00 * src2[((hsi*126+63)*1+lsi)*1];
LIBINT2_REALTYPE fp331;
fp331 = inteval->CD_z[vi] * src1[((hsi*126+63)*1+lsi)*1];
LIBINT2_REALTYPE fp330;
fp330 = src0[((hsi*168+99)*1+lsi)*1] + fp331;
LIBINT2_REALTYPE fp328;
fp328 = fp330 + fp329;
target[((hsi*210+107)*1+lsi)*1] = fp328;
LIBINT2_REALTYPE fp333;
fp333 = inteval->CD_y[vi] * src1[((hsi*126+63)*1+lsi)*1];
LIBINT2_REALTYPE fp332;
fp332 = src0[((hsi*168+93)*1+lsi)*1] + fp333;
target[((hsi*210+106)*1+lsi)*1] = fp332;
LIBINT2_REALTYPE fp293;
fp293 = 1.0000000000000000e+00 * src2[((hsi*126+70)*1+lsi)*1];
LIBINT2_REALTYPE fp295;
fp295 = inteval->CD_z[vi] * src1[((hsi*126+70)*1+lsi)*1];
LIBINT2_REALTYPE fp294;
fp294 = src0[((hsi*168+106)*1+lsi)*1] + fp295;
LIBINT2_REALTYPE fp292;
fp292 = fp294 + fp293;
target[((hsi*210+118)*1+lsi)*1] = fp292;
LIBINT2_REALTYPE fp169;
fp169 = 1.0000000000000000e+00 * src2[((hsi*126+93)*1+lsi)*1];
LIBINT2_REALTYPE fp171;
fp171 = inteval->CD_z[vi] * src1[((hsi*126+93)*1+lsi)*1];
LIBINT2_REALTYPE fp170;
fp170 = src0[((hsi*168+135)*1+lsi)*1] + fp171;
LIBINT2_REALTYPE fp168;
fp168 = fp170 + fp169;
target[((hsi*210+157)*1+lsi)*1] = fp168;
LIBINT2_REALTYPE fp173;
fp173 = inteval->CD_y[vi] * src1[((hsi*126+93)*1+lsi)*1];
LIBINT2_REALTYPE fp172;
fp172 = src0[((hsi*168+129)*1+lsi)*1] + fp173;
target[((hsi*210+156)*1+lsi)*1] = fp172;
LIBINT2_REALTYPE fp175;
fp175 = 1.0000000000000000e+00 * src2[((hsi*126+92)*1+lsi)*1];
LIBINT2_REALTYPE fp177;
fp177 = inteval->CD_z[vi] * src1[((hsi*126+92)*1+lsi)*1];
LIBINT2_REALTYPE fp176;
fp176 = src0[((hsi*168+134)*1+lsi)*1] + fp177;
LIBINT2_REALTYPE fp174;
fp174 = fp176 + fp175;
target[((hsi*210+155)*1+lsi)*1] = fp174;
LIBINT2_REALTYPE fp179;
fp179 = 1.0000000000000000e+00 * src2[((hsi*126+91)*1+lsi)*1];
LIBINT2_REALTYPE fp181;
fp181 = inteval->CD_z[vi] * src1[((hsi*126+91)*1+lsi)*1];
LIBINT2_REALTYPE fp180;
fp180 = src0[((hsi*168+133)*1+lsi)*1] + fp181;
LIBINT2_REALTYPE fp178;
fp178 = fp180 + fp179;
target[((hsi*210+154)*1+lsi)*1] = fp178;
LIBINT2_REALTYPE fp183;
fp183 = inteval->CD_y[vi] * src1[((hsi*126+91)*1+lsi)*1];
LIBINT2_REALTYPE fp182;
fp182 = src0[((hsi*168+127)*1+lsi)*1] + fp183;
target[((hsi*210+153)*1+lsi)*1] = fp182;
LIBINT2_REALTYPE fp185;
fp185 = 1.0000000000000000e+00 * src2[((hsi*126+90)*1+lsi)*1];
LIBINT2_REALTYPE fp187;
fp187 = inteval->CD_z[vi] * src1[((hsi*126+90)*1+lsi)*1];
LIBINT2_REALTYPE fp186;
fp186 = src0[((hsi*168+132)*1+lsi)*1] + fp187;
LIBINT2_REALTYPE fp184;
fp184 = fp186 + fp185;
target[((hsi*210+152)*1+lsi)*1] = fp184;
LIBINT2_REALTYPE fp189;
fp189 = inteval->CD_y[vi] * src1[((hsi*126+90)*1+lsi)*1];
LIBINT2_REALTYPE fp188;
fp188 = src0[((hsi*168+126)*1+lsi)*1] + fp189;
target[((hsi*210+151)*1+lsi)*1] = fp188;
LIBINT2_REALTYPE fp191;
fp191 = inteval->CD_x[vi] * src1[((hsi*126+90)*1+lsi)*1];
LIBINT2_REALTYPE fp190;
fp190 = src0[((hsi*168+90)*1+lsi)*1] + fp191;
target[((hsi*210+150)*1+lsi)*1] = fp190;
LIBINT2_REALTYPE fp193;
fp193 = 1.0000000000000000e+00 * src2[((hsi*126+89)*1+lsi)*1];
LIBINT2_REALTYPE fp195;
fp195 = inteval->CD_z[vi] * src1[((hsi*126+89)*1+lsi)*1];
LIBINT2_REALTYPE fp194;
fp194 = src0[((hsi*168+125)*1+lsi)*1] + fp195;
LIBINT2_REALTYPE fp192;
fp192 = fp194 + fp193;
target[((hsi*210+149)*1+lsi)*1] = fp192;
LIBINT2_REALTYPE fp197;
fp197 = 1.0000000000000000e+00 * src2[((hsi*126+88)*1+lsi)*1];
LIBINT2_REALTYPE fp199;
fp199 = inteval->CD_z[vi] * src1[((hsi*126+88)*1+lsi)*1];
LIBINT2_REALTYPE fp198;
fp198 = src0[((hsi*168+124)*1+lsi)*1] + fp199;
LIBINT2_REALTYPE fp196;
fp196 = fp198 + fp197;
target[((hsi*210+148)*1+lsi)*1] = fp196;
LIBINT2_REALTYPE fp201;
fp201 = 1.0000000000000000e+00 * src2[((hsi*126+87)*1+lsi)*1];
LIBINT2_REALTYPE fp203;
fp203 = inteval->CD_z[vi] * src1[((hsi*126+87)*1+lsi)*1];
LIBINT2_REALTYPE fp202;
fp202 = src0[((hsi*168+123)*1+lsi)*1] + fp203;
LIBINT2_REALTYPE fp200;
fp200 = fp202 + fp201;
target[((hsi*210+147)*1+lsi)*1] = fp200;
LIBINT2_REALTYPE fp205;
fp205 = inteval->CD_y[vi] * src1[((hsi*126+87)*1+lsi)*1];
LIBINT2_REALTYPE fp204;
fp204 = src0[((hsi*168+117)*1+lsi)*1] + fp205;
target[((hsi*210+146)*1+lsi)*1] = fp204;
LIBINT2_REALTYPE fp253;
fp253 = inteval->CD_y[vi] * src1[((hsi*126+78)*1+lsi)*1];
LIBINT2_REALTYPE fp252;
fp252 = src0[((hsi*168+108)*1+lsi)*1] + fp253;
target[((hsi*210+131)*1+lsi)*1] = fp252;
LIBINT2_REALTYPE fp211;
fp211 = 1.0000000000000000e+00 * src2[((hsi*126+85)*1+lsi)*1];
LIBINT2_REALTYPE fp213;
fp213 = inteval->CD_z[vi] * src1[((hsi*126+85)*1+lsi)*1];
LIBINT2_REALTYPE fp212;
fp212 = src0[((hsi*168+121)*1+lsi)*1] + fp213;
LIBINT2_REALTYPE fp210;
fp210 = fp212 + fp211;
target[((hsi*210+144)*1+lsi)*1] = fp210;
LIBINT2_REALTYPE fp215;
fp215 = inteval->CD_y[vi] * src1[((hsi*126+85)*1+lsi)*1];
LIBINT2_REALTYPE fp214;
fp214 = src0[((hsi*168+115)*1+lsi)*1] + fp215;
target[((hsi*210+143)*1+lsi)*1] = fp214;
LIBINT2_REALTYPE fp217;
fp217 = 1.0000000000000000e+00 * src2[((hsi*126+84)*1+lsi)*1];
LIBINT2_REALTYPE fp219;
fp219 = inteval->CD_z[vi] * src1[((hsi*126+84)*1+lsi)*1];
LIBINT2_REALTYPE fp218;
fp218 = src0[((hsi*168+120)*1+lsi)*1] + fp219;
LIBINT2_REALTYPE fp216;
fp216 = fp218 + fp217;
target[((hsi*210+142)*1+lsi)*1] = fp216;
LIBINT2_REALTYPE fp221;
fp221 = inteval->CD_y[vi] * src1[((hsi*126+84)*1+lsi)*1];
LIBINT2_REALTYPE fp220;
fp220 = src0[((hsi*168+114)*1+lsi)*1] + fp221;
target[((hsi*210+141)*1+lsi)*1] = fp220;
LIBINT2_REALTYPE fp223;
fp223 = inteval->CD_x[vi] * src1[((hsi*126+84)*1+lsi)*1];
LIBINT2_REALTYPE fp222;
fp222 = src0[((hsi*168+84)*1+lsi)*1] + fp223;
target[((hsi*210+140)*1+lsi)*1] = fp222;
LIBINT2_REALTYPE fp225;
fp225 = 1.0000000000000000e+00 * src2[((hsi*126+83)*1+lsi)*1];
LIBINT2_REALTYPE fp227;
fp227 = inteval->CD_z[vi] * src1[((hsi*126+83)*1+lsi)*1];
LIBINT2_REALTYPE fp226;
fp226 = src0[((hsi*168+119)*1+lsi)*1] + fp227;
LIBINT2_REALTYPE fp224;
fp224 = fp226 + fp225;
target[((hsi*210+139)*1+lsi)*1] = fp224;
LIBINT2_REALTYPE fp229;
fp229 = 1.0000000000000000e+00 * src2[((hsi*126+82)*1+lsi)*1];
LIBINT2_REALTYPE fp231;
fp231 = inteval->CD_z[vi] * src1[((hsi*126+82)*1+lsi)*1];
LIBINT2_REALTYPE fp230;
fp230 = src0[((hsi*168+118)*1+lsi)*1] + fp231;
LIBINT2_REALTYPE fp228;
fp228 = fp230 + fp229;
target[((hsi*210+138)*1+lsi)*1] = fp228;
LIBINT2_REALTYPE fp233;
fp233 = 1.0000000000000000e+00 * src2[((hsi*126+81)*1+lsi)*1];
LIBINT2_REALTYPE fp235;
fp235 = inteval->CD_z[vi] * src1[((hsi*126+81)*1+lsi)*1];
LIBINT2_REALTYPE fp234;
fp234 = src0[((hsi*168+117)*1+lsi)*1] + fp235;
LIBINT2_REALTYPE fp232;
fp232 = fp234 + fp233;
target[((hsi*210+137)*1+lsi)*1] = fp232;
LIBINT2_REALTYPE fp237;
fp237 = inteval->CD_y[vi] * src1[((hsi*126+81)*1+lsi)*1];
LIBINT2_REALTYPE fp236;
fp236 = src0[((hsi*168+111)*1+lsi)*1] + fp237;
target[((hsi*210+136)*1+lsi)*1] = fp236;
LIBINT2_REALTYPE fp239;
fp239 = 1.0000000000000000e+00 * src2[((hsi*126+80)*1+lsi)*1];
LIBINT2_REALTYPE fp241;
fp241 = inteval->CD_z[vi] * src1[((hsi*126+80)*1+lsi)*1];
LIBINT2_REALTYPE fp240;
fp240 = src0[((hsi*168+116)*1+lsi)*1] + fp241;
LIBINT2_REALTYPE fp238;
fp238 = fp240 + fp239;
target[((hsi*210+135)*1+lsi)*1] = fp238;
LIBINT2_REALTYPE fp243;
fp243 = 1.0000000000000000e+00 * src2[((hsi*126+79)*1+lsi)*1];
LIBINT2_REALTYPE fp245;
fp245 = inteval->CD_z[vi] * src1[((hsi*126+79)*1+lsi)*1];
LIBINT2_REALTYPE fp244;
fp244 = src0[((hsi*168+115)*1+lsi)*1] + fp245;
LIBINT2_REALTYPE fp242;
fp242 = fp244 + fp243;
target[((hsi*210+134)*1+lsi)*1] = fp242;
LIBINT2_REALTYPE fp247;
fp247 = inteval->CD_y[vi] * src1[((hsi*126+79)*1+lsi)*1];
LIBINT2_REALTYPE fp246;
fp246 = src0[((hsi*168+109)*1+lsi)*1] + fp247;
target[((hsi*210+133)*1+lsi)*1] = fp246;
LIBINT2_REALTYPE fp249;
fp249 = 1.0000000000000000e+00 * src2[((hsi*126+78)*1+lsi)*1];
LIBINT2_REALTYPE fp251;
fp251 = inteval->CD_z[vi] * src1[((hsi*126+78)*1+lsi)*1];
LIBINT2_REALTYPE fp250;
fp250 = src0[((hsi*168+114)*1+lsi)*1] + fp251;
LIBINT2_REALTYPE fp248;
fp248 = fp250 + fp249;
target[((hsi*210+132)*1+lsi)*1] = fp248;
LIBINT2_REALTYPE fp207;
fp207 = 1.0000000000000000e+00 * src2[((hsi*126+86)*1+lsi)*1];
LIBINT2_REALTYPE fp209;
fp209 = inteval->CD_z[vi] * src1[((hsi*126+86)*1+lsi)*1];
LIBINT2_REALTYPE fp208;
fp208 = src0[((hsi*168+122)*1+lsi)*1] + fp209;
LIBINT2_REALTYPE fp206;
fp206 = fp208 + fp207;
target[((hsi*210+145)*1+lsi)*1] = fp206;
}
}
}
const int hsi = 0;
const int lsi = 0;
const int vi = 0;
/** Number of flops = 672 */
}

#ifdef __cplusplus
};
#endif
