/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <libint2.h>

#ifdef __cplusplus
extern "C" {
#endif
void HRRPart0bra0ket0gg001(const Libint_t* inteval, LIBINT2_REALTYPE* target, const LIBINT2_REALTYPE* src0, const LIBINT2_REALTYPE* src1, const LIBINT2_REALTYPE* src2, int lowdim) {

LIBINT2_REALTYPE*const  stack = target;
{
const int hsi = 0;
#ifdef __INTEL_COMPILER
#pragma ivdep
#endif
for(int lsi = 0; lsi<lowdim; lsi++) {
{
const int vi = 0;
LIBINT2_REALTYPE fp473;
fp473 = 1.0000000000000000e+00 * src2[((hsi*150+54)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp475;
fp475 = inteval->AB_z[vi] * src1[((hsi*150+54)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp474;
fp474 = src0[((hsi*210+94)*lowdim+lsi)*1] + fp475;
LIBINT2_REALTYPE fp472;
fp472 = fp474 - fp473;
target[((hsi*225+83)*lowdim+lsi)*1] = fp472;
LIBINT2_REALTYPE fp477;
fp477 = 1.0000000000000000e+00 * src2[((hsi*150+53)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp479;
fp479 = inteval->AB_z[vi] * src1[((hsi*150+53)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp478;
fp478 = src0[((hsi*210+93)*lowdim+lsi)*1] + fp479;
LIBINT2_REALTYPE fp476;
fp476 = fp478 - fp477;
target[((hsi*225+82)*lowdim+lsi)*1] = fp476;
LIBINT2_REALTYPE fp481;
fp481 = inteval->AB_y[vi] * src1[((hsi*150+53)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp480;
fp480 = src0[((hsi*210+83)*lowdim+lsi)*1] + fp481;
target[((hsi*225+81)*lowdim+lsi)*1] = fp480;
LIBINT2_REALTYPE fp483;
fp483 = 1.0000000000000000e+00 * src2[((hsi*150+52)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp485;
fp485 = inteval->AB_z[vi] * src1[((hsi*150+52)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp484;
fp484 = src0[((hsi*210+92)*lowdim+lsi)*1] + fp485;
LIBINT2_REALTYPE fp482;
fp482 = fp484 - fp483;
target[((hsi*225+80)*lowdim+lsi)*1] = fp482;
LIBINT2_REALTYPE fp487;
fp487 = 1.0000000000000000e+00 * src2[((hsi*150+51)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp489;
fp489 = inteval->AB_z[vi] * src1[((hsi*150+51)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp488;
fp488 = src0[((hsi*210+91)*lowdim+lsi)*1] + fp489;
LIBINT2_REALTYPE fp486;
fp486 = fp488 - fp487;
target[((hsi*225+79)*lowdim+lsi)*1] = fp486;
LIBINT2_REALTYPE fp491;
fp491 = inteval->AB_y[vi] * src1[((hsi*150+51)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp490;
fp490 = src0[((hsi*210+81)*lowdim+lsi)*1] + fp491;
target[((hsi*225+78)*lowdim+lsi)*1] = fp490;
LIBINT2_REALTYPE fp493;
fp493 = 1.0000000000000000e+00 * src2[((hsi*150+50)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp495;
fp495 = inteval->AB_z[vi] * src1[((hsi*150+50)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp494;
fp494 = src0[((hsi*210+90)*lowdim+lsi)*1] + fp495;
LIBINT2_REALTYPE fp492;
fp492 = fp494 - fp493;
target[((hsi*225+77)*lowdim+lsi)*1] = fp492;
LIBINT2_REALTYPE fp497;
fp497 = inteval->AB_y[vi] * src1[((hsi*150+50)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp496;
fp496 = src0[((hsi*210+80)*lowdim+lsi)*1] + fp497;
target[((hsi*225+76)*lowdim+lsi)*1] = fp496;
LIBINT2_REALTYPE fp499;
fp499 = inteval->AB_x[vi] * src1[((hsi*150+50)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp498;
fp498 = src0[((hsi*210+50)*lowdim+lsi)*1] + fp499;
target[((hsi*225+75)*lowdim+lsi)*1] = fp498;
LIBINT2_REALTYPE fp501;
fp501 = 1.0000000000000000e+00 * src2[((hsi*150+49)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp503;
fp503 = inteval->AB_z[vi] * src1[((hsi*150+49)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp502;
fp502 = src0[((hsi*210+89)*lowdim+lsi)*1] + fp503;
LIBINT2_REALTYPE fp500;
fp500 = fp502 - fp501;
target[((hsi*225+74)*lowdim+lsi)*1] = fp500;
LIBINT2_REALTYPE fp505;
fp505 = 1.0000000000000000e+00 * src2[((hsi*150+48)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp507;
fp507 = inteval->AB_z[vi] * src1[((hsi*150+48)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp506;
fp506 = src0[((hsi*210+88)*lowdim+lsi)*1] + fp507;
LIBINT2_REALTYPE fp504;
fp504 = fp506 - fp505;
target[((hsi*225+73)*lowdim+lsi)*1] = fp504;
LIBINT2_REALTYPE fp509;
fp509 = 1.0000000000000000e+00 * src2[((hsi*150+47)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp511;
fp511 = inteval->AB_z[vi] * src1[((hsi*150+47)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp510;
fp510 = src0[((hsi*210+87)*lowdim+lsi)*1] + fp511;
LIBINT2_REALTYPE fp508;
fp508 = fp510 - fp509;
target[((hsi*225+72)*lowdim+lsi)*1] = fp508;
LIBINT2_REALTYPE fp513;
fp513 = 1.0000000000000000e+00 * src2[((hsi*150+46)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp515;
fp515 = inteval->AB_z[vi] * src1[((hsi*150+46)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp514;
fp514 = src0[((hsi*210+86)*lowdim+lsi)*1] + fp515;
LIBINT2_REALTYPE fp512;
fp512 = fp514 - fp513;
target[((hsi*225+71)*lowdim+lsi)*1] = fp512;
LIBINT2_REALTYPE fp749;
fp749 = inteval->AB_x[vi] * src1[((hsi*150+0)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp748;
fp748 = src0[((hsi*210+0)*lowdim+lsi)*1] + fp749;
target[((hsi*225+0)*lowdim+lsi)*1] = fp748;
LIBINT2_REALTYPE fp519;
fp519 = 1.0000000000000000e+00 * src2[((hsi*150+45)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp521;
fp521 = inteval->AB_z[vi] * src1[((hsi*150+45)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp520;
fp520 = src0[((hsi*210+85)*lowdim+lsi)*1] + fp521;
LIBINT2_REALTYPE fp518;
fp518 = fp520 - fp519;
target[((hsi*225+69)*lowdim+lsi)*1] = fp518;
LIBINT2_REALTYPE fp523;
fp523 = 1.0000000000000000e+00 * src2[((hsi*150+44)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp525;
fp525 = inteval->AB_z[vi] * src1[((hsi*150+44)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp524;
fp524 = src0[((hsi*210+84)*lowdim+lsi)*1] + fp525;
LIBINT2_REALTYPE fp522;
fp522 = fp524 - fp523;
target[((hsi*225+68)*lowdim+lsi)*1] = fp522;
LIBINT2_REALTYPE fp527;
fp527 = 1.0000000000000000e+00 * src2[((hsi*150+43)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp529;
fp529 = inteval->AB_z[vi] * src1[((hsi*150+43)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp528;
fp528 = src0[((hsi*210+83)*lowdim+lsi)*1] + fp529;
LIBINT2_REALTYPE fp526;
fp526 = fp528 - fp527;
target[((hsi*225+67)*lowdim+lsi)*1] = fp526;
LIBINT2_REALTYPE fp531;
fp531 = inteval->AB_y[vi] * src1[((hsi*150+43)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp530;
fp530 = src0[((hsi*210+73)*lowdim+lsi)*1] + fp531;
target[((hsi*225+66)*lowdim+lsi)*1] = fp530;
LIBINT2_REALTYPE fp533;
fp533 = 1.0000000000000000e+00 * src2[((hsi*150+42)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp535;
fp535 = inteval->AB_z[vi] * src1[((hsi*150+42)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp534;
fp534 = src0[((hsi*210+82)*lowdim+lsi)*1] + fp535;
LIBINT2_REALTYPE fp532;
fp532 = fp534 - fp533;
target[((hsi*225+65)*lowdim+lsi)*1] = fp532;
LIBINT2_REALTYPE fp537;
fp537 = 1.0000000000000000e+00 * src2[((hsi*150+41)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp539;
fp539 = inteval->AB_z[vi] * src1[((hsi*150+41)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp538;
fp538 = src0[((hsi*210+81)*lowdim+lsi)*1] + fp539;
LIBINT2_REALTYPE fp536;
fp536 = fp538 - fp537;
target[((hsi*225+64)*lowdim+lsi)*1] = fp536;
LIBINT2_REALTYPE fp541;
fp541 = inteval->AB_y[vi] * src1[((hsi*150+41)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp540;
fp540 = src0[((hsi*210+71)*lowdim+lsi)*1] + fp541;
target[((hsi*225+63)*lowdim+lsi)*1] = fp540;
LIBINT2_REALTYPE fp543;
fp543 = 1.0000000000000000e+00 * src2[((hsi*150+40)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp545;
fp545 = inteval->AB_z[vi] * src1[((hsi*150+40)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp544;
fp544 = src0[((hsi*210+80)*lowdim+lsi)*1] + fp545;
LIBINT2_REALTYPE fp542;
fp542 = fp544 - fp543;
target[((hsi*225+62)*lowdim+lsi)*1] = fp542;
LIBINT2_REALTYPE fp547;
fp547 = inteval->AB_y[vi] * src1[((hsi*150+40)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp546;
fp546 = src0[((hsi*210+70)*lowdim+lsi)*1] + fp547;
target[((hsi*225+61)*lowdim+lsi)*1] = fp546;
LIBINT2_REALTYPE fp549;
fp549 = inteval->AB_x[vi] * src1[((hsi*150+40)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp548;
fp548 = src0[((hsi*210+40)*lowdim+lsi)*1] + fp549;
target[((hsi*225+60)*lowdim+lsi)*1] = fp548;
LIBINT2_REALTYPE fp551;
fp551 = 1.0000000000000000e+00 * src2[((hsi*150+39)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp553;
fp553 = inteval->AB_z[vi] * src1[((hsi*150+39)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp552;
fp552 = src0[((hsi*210+79)*lowdim+lsi)*1] + fp553;
LIBINT2_REALTYPE fp550;
fp550 = fp552 - fp551;
target[((hsi*225+59)*lowdim+lsi)*1] = fp550;
LIBINT2_REALTYPE fp555;
fp555 = 1.0000000000000000e+00 * src2[((hsi*150+38)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp557;
fp557 = inteval->AB_z[vi] * src1[((hsi*150+38)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp556;
fp556 = src0[((hsi*210+78)*lowdim+lsi)*1] + fp557;
LIBINT2_REALTYPE fp554;
fp554 = fp556 - fp555;
target[((hsi*225+58)*lowdim+lsi)*1] = fp554;
LIBINT2_REALTYPE fp559;
fp559 = 1.0000000000000000e+00 * src2[((hsi*150+37)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp561;
fp561 = inteval->AB_z[vi] * src1[((hsi*150+37)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp560;
fp560 = src0[((hsi*210+77)*lowdim+lsi)*1] + fp561;
LIBINT2_REALTYPE fp558;
fp558 = fp560 - fp559;
target[((hsi*225+57)*lowdim+lsi)*1] = fp558;
LIBINT2_REALTYPE fp517;
fp517 = inteval->AB_y[vi] * src1[((hsi*150+46)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp516;
fp516 = src0[((hsi*210+76)*lowdim+lsi)*1] + fp517;
target[((hsi*225+70)*lowdim+lsi)*1] = fp516;
LIBINT2_REALTYPE fp381;
fp381 = inteval->AB_y[vi] * src1[((hsi*150+73)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp380;
fp380 = src0[((hsi*210+113)*lowdim+lsi)*1] + fp381;
target[((hsi*225+111)*lowdim+lsi)*1] = fp380;
LIBINT2_REALTYPE fp383;
fp383 = 1.0000000000000000e+00 * src2[((hsi*150+72)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp385;
fp385 = inteval->AB_z[vi] * src1[((hsi*150+72)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp384;
fp384 = src0[((hsi*210+122)*lowdim+lsi)*1] + fp385;
LIBINT2_REALTYPE fp382;
fp382 = fp384 - fp383;
target[((hsi*225+110)*lowdim+lsi)*1] = fp382;
LIBINT2_REALTYPE fp387;
fp387 = 1.0000000000000000e+00 * src2[((hsi*150+71)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp389;
fp389 = inteval->AB_z[vi] * src1[((hsi*150+71)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp388;
fp388 = src0[((hsi*210+121)*lowdim+lsi)*1] + fp389;
LIBINT2_REALTYPE fp386;
fp386 = fp388 - fp387;
target[((hsi*225+109)*lowdim+lsi)*1] = fp386;
LIBINT2_REALTYPE fp391;
fp391 = inteval->AB_y[vi] * src1[((hsi*150+71)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp390;
fp390 = src0[((hsi*210+111)*lowdim+lsi)*1] + fp391;
target[((hsi*225+108)*lowdim+lsi)*1] = fp390;
LIBINT2_REALTYPE fp393;
fp393 = 1.0000000000000000e+00 * src2[((hsi*150+70)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp395;
fp395 = inteval->AB_z[vi] * src1[((hsi*150+70)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp394;
fp394 = src0[((hsi*210+120)*lowdim+lsi)*1] + fp395;
LIBINT2_REALTYPE fp392;
fp392 = fp394 - fp393;
target[((hsi*225+107)*lowdim+lsi)*1] = fp392;
LIBINT2_REALTYPE fp397;
fp397 = inteval->AB_y[vi] * src1[((hsi*150+70)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp396;
fp396 = src0[((hsi*210+110)*lowdim+lsi)*1] + fp397;
target[((hsi*225+106)*lowdim+lsi)*1] = fp396;
LIBINT2_REALTYPE fp399;
fp399 = inteval->AB_x[vi] * src1[((hsi*150+70)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp398;
fp398 = src0[((hsi*210+70)*lowdim+lsi)*1] + fp399;
target[((hsi*225+105)*lowdim+lsi)*1] = fp398;
LIBINT2_REALTYPE fp401;
fp401 = 1.0000000000000000e+00 * src2[((hsi*150+69)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp403;
fp403 = inteval->AB_z[vi] * src1[((hsi*150+69)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp402;
fp402 = src0[((hsi*210+119)*lowdim+lsi)*1] + fp403;
LIBINT2_REALTYPE fp400;
fp400 = fp402 - fp401;
target[((hsi*225+104)*lowdim+lsi)*1] = fp400;
LIBINT2_REALTYPE fp405;
fp405 = 1.0000000000000000e+00 * src2[((hsi*150+68)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp407;
fp407 = inteval->AB_z[vi] * src1[((hsi*150+68)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp406;
fp406 = src0[((hsi*210+118)*lowdim+lsi)*1] + fp407;
LIBINT2_REALTYPE fp404;
fp404 = fp406 - fp405;
target[((hsi*225+103)*lowdim+lsi)*1] = fp404;
LIBINT2_REALTYPE fp409;
fp409 = 1.0000000000000000e+00 * src2[((hsi*150+67)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp411;
fp411 = inteval->AB_z[vi] * src1[((hsi*150+67)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp410;
fp410 = src0[((hsi*210+117)*lowdim+lsi)*1] + fp411;
LIBINT2_REALTYPE fp408;
fp408 = fp410 - fp409;
target[((hsi*225+102)*lowdim+lsi)*1] = fp408;
LIBINT2_REALTYPE fp413;
fp413 = 1.0000000000000000e+00 * src2[((hsi*150+66)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp415;
fp415 = inteval->AB_z[vi] * src1[((hsi*150+66)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp414;
fp414 = src0[((hsi*210+116)*lowdim+lsi)*1] + fp415;
LIBINT2_REALTYPE fp412;
fp412 = fp414 - fp413;
target[((hsi*225+101)*lowdim+lsi)*1] = fp412;
LIBINT2_REALTYPE fp417;
fp417 = inteval->AB_y[vi] * src1[((hsi*150+66)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp416;
fp416 = src0[((hsi*210+106)*lowdim+lsi)*1] + fp417;
target[((hsi*225+100)*lowdim+lsi)*1] = fp416;
LIBINT2_REALTYPE fp419;
fp419 = 1.0000000000000000e+00 * src2[((hsi*150+65)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp421;
fp421 = inteval->AB_z[vi] * src1[((hsi*150+65)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp420;
fp420 = src0[((hsi*210+115)*lowdim+lsi)*1] + fp421;
LIBINT2_REALTYPE fp418;
fp418 = fp420 - fp419;
target[((hsi*225+99)*lowdim+lsi)*1] = fp418;
LIBINT2_REALTYPE fp469;
fp469 = 1.0000000000000000e+00 * src2[((hsi*150+55)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp471;
fp471 = inteval->AB_z[vi] * src1[((hsi*150+55)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp470;
fp470 = src0[((hsi*210+95)*lowdim+lsi)*1] + fp471;
LIBINT2_REALTYPE fp468;
fp468 = fp470 - fp469;
target[((hsi*225+84)*lowdim+lsi)*1] = fp468;
LIBINT2_REALTYPE fp427;
fp427 = 1.0000000000000000e+00 * src2[((hsi*150+63)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp429;
fp429 = inteval->AB_z[vi] * src1[((hsi*150+63)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp428;
fp428 = src0[((hsi*210+113)*lowdim+lsi)*1] + fp429;
LIBINT2_REALTYPE fp426;
fp426 = fp428 - fp427;
target[((hsi*225+97)*lowdim+lsi)*1] = fp426;
LIBINT2_REALTYPE fp431;
fp431 = inteval->AB_y[vi] * src1[((hsi*150+63)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp430;
fp430 = src0[((hsi*210+103)*lowdim+lsi)*1] + fp431;
target[((hsi*225+96)*lowdim+lsi)*1] = fp430;
LIBINT2_REALTYPE fp433;
fp433 = 1.0000000000000000e+00 * src2[((hsi*150+62)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp435;
fp435 = inteval->AB_z[vi] * src1[((hsi*150+62)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp434;
fp434 = src0[((hsi*210+112)*lowdim+lsi)*1] + fp435;
LIBINT2_REALTYPE fp432;
fp432 = fp434 - fp433;
target[((hsi*225+95)*lowdim+lsi)*1] = fp432;
LIBINT2_REALTYPE fp437;
fp437 = 1.0000000000000000e+00 * src2[((hsi*150+61)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp439;
fp439 = inteval->AB_z[vi] * src1[((hsi*150+61)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp438;
fp438 = src0[((hsi*210+111)*lowdim+lsi)*1] + fp439;
LIBINT2_REALTYPE fp436;
fp436 = fp438 - fp437;
target[((hsi*225+94)*lowdim+lsi)*1] = fp436;
LIBINT2_REALTYPE fp441;
fp441 = inteval->AB_y[vi] * src1[((hsi*150+61)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp440;
fp440 = src0[((hsi*210+101)*lowdim+lsi)*1] + fp441;
target[((hsi*225+93)*lowdim+lsi)*1] = fp440;
LIBINT2_REALTYPE fp443;
fp443 = 1.0000000000000000e+00 * src2[((hsi*150+60)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp445;
fp445 = inteval->AB_z[vi] * src1[((hsi*150+60)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp444;
fp444 = src0[((hsi*210+110)*lowdim+lsi)*1] + fp445;
LIBINT2_REALTYPE fp442;
fp442 = fp444 - fp443;
target[((hsi*225+92)*lowdim+lsi)*1] = fp442;
LIBINT2_REALTYPE fp447;
fp447 = inteval->AB_y[vi] * src1[((hsi*150+60)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp446;
fp446 = src0[((hsi*210+100)*lowdim+lsi)*1] + fp447;
target[((hsi*225+91)*lowdim+lsi)*1] = fp446;
LIBINT2_REALTYPE fp449;
fp449 = inteval->AB_x[vi] * src1[((hsi*150+60)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp448;
fp448 = src0[((hsi*210+60)*lowdim+lsi)*1] + fp449;
target[((hsi*225+90)*lowdim+lsi)*1] = fp448;
LIBINT2_REALTYPE fp451;
fp451 = 1.0000000000000000e+00 * src2[((hsi*150+59)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp453;
fp453 = inteval->AB_z[vi] * src1[((hsi*150+59)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp452;
fp452 = src0[((hsi*210+99)*lowdim+lsi)*1] + fp453;
LIBINT2_REALTYPE fp450;
fp450 = fp452 - fp451;
target[((hsi*225+89)*lowdim+lsi)*1] = fp450;
LIBINT2_REALTYPE fp455;
fp455 = 1.0000000000000000e+00 * src2[((hsi*150+58)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp457;
fp457 = inteval->AB_z[vi] * src1[((hsi*150+58)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp456;
fp456 = src0[((hsi*210+98)*lowdim+lsi)*1] + fp457;
LIBINT2_REALTYPE fp454;
fp454 = fp456 - fp455;
target[((hsi*225+88)*lowdim+lsi)*1] = fp454;
LIBINT2_REALTYPE fp459;
fp459 = 1.0000000000000000e+00 * src2[((hsi*150+57)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp461;
fp461 = inteval->AB_z[vi] * src1[((hsi*150+57)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp460;
fp460 = src0[((hsi*210+97)*lowdim+lsi)*1] + fp461;
LIBINT2_REALTYPE fp458;
fp458 = fp460 - fp459;
target[((hsi*225+87)*lowdim+lsi)*1] = fp458;
LIBINT2_REALTYPE fp463;
fp463 = 1.0000000000000000e+00 * src2[((hsi*150+56)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp465;
fp465 = inteval->AB_z[vi] * src1[((hsi*150+56)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp464;
fp464 = src0[((hsi*210+96)*lowdim+lsi)*1] + fp465;
LIBINT2_REALTYPE fp462;
fp462 = fp464 - fp463;
target[((hsi*225+86)*lowdim+lsi)*1] = fp462;
LIBINT2_REALTYPE fp467;
fp467 = inteval->AB_y[vi] * src1[((hsi*150+56)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp466;
fp466 = src0[((hsi*210+86)*lowdim+lsi)*1] + fp467;
target[((hsi*225+85)*lowdim+lsi)*1] = fp466;
LIBINT2_REALTYPE fp423;
fp423 = 1.0000000000000000e+00 * src2[((hsi*150+64)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp425;
fp425 = inteval->AB_z[vi] * src1[((hsi*150+64)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp424;
fp424 = src0[((hsi*210+114)*lowdim+lsi)*1] + fp425;
LIBINT2_REALTYPE fp422;
fp422 = fp424 - fp423;
target[((hsi*225+98)*lowdim+lsi)*1] = fp422;
LIBINT2_REALTYPE fp659;
fp659 = 1.0000000000000000e+00 * src2[((hsi*150+17)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp661;
fp661 = inteval->AB_z[vi] * src1[((hsi*150+17)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp660;
fp660 = src0[((hsi*210+47)*lowdim+lsi)*1] + fp661;
LIBINT2_REALTYPE fp658;
fp658 = fp660 - fp659;
target[((hsi*225+27)*lowdim+lsi)*1] = fp658;
LIBINT2_REALTYPE fp663;
fp663 = 1.0000000000000000e+00 * src2[((hsi*150+16)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp665;
fp665 = inteval->AB_z[vi] * src1[((hsi*150+16)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp664;
fp664 = src0[((hsi*210+46)*lowdim+lsi)*1] + fp665;
LIBINT2_REALTYPE fp662;
fp662 = fp664 - fp663;
target[((hsi*225+26)*lowdim+lsi)*1] = fp662;
LIBINT2_REALTYPE fp667;
fp667 = inteval->AB_y[vi] * src1[((hsi*150+16)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp666;
fp666 = src0[((hsi*210+36)*lowdim+lsi)*1] + fp667;
target[((hsi*225+25)*lowdim+lsi)*1] = fp666;
LIBINT2_REALTYPE fp669;
fp669 = 1.0000000000000000e+00 * src2[((hsi*150+15)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp671;
fp671 = inteval->AB_z[vi] * src1[((hsi*150+15)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp670;
fp670 = src0[((hsi*210+45)*lowdim+lsi)*1] + fp671;
LIBINT2_REALTYPE fp668;
fp668 = fp670 - fp669;
target[((hsi*225+24)*lowdim+lsi)*1] = fp668;
LIBINT2_REALTYPE fp673;
fp673 = 1.0000000000000000e+00 * src2[((hsi*150+14)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp675;
fp675 = inteval->AB_z[vi] * src1[((hsi*150+14)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp674;
fp674 = src0[((hsi*210+44)*lowdim+lsi)*1] + fp675;
LIBINT2_REALTYPE fp672;
fp672 = fp674 - fp673;
target[((hsi*225+23)*lowdim+lsi)*1] = fp672;
LIBINT2_REALTYPE fp677;
fp677 = 1.0000000000000000e+00 * src2[((hsi*150+13)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp679;
fp679 = inteval->AB_z[vi] * src1[((hsi*150+13)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp678;
fp678 = src0[((hsi*210+43)*lowdim+lsi)*1] + fp679;
LIBINT2_REALTYPE fp676;
fp676 = fp678 - fp677;
target[((hsi*225+22)*lowdim+lsi)*1] = fp676;
LIBINT2_REALTYPE fp681;
fp681 = inteval->AB_y[vi] * src1[((hsi*150+13)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp680;
fp680 = src0[((hsi*210+33)*lowdim+lsi)*1] + fp681;
target[((hsi*225+21)*lowdim+lsi)*1] = fp680;
LIBINT2_REALTYPE fp683;
fp683 = 1.0000000000000000e+00 * src2[((hsi*150+12)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp685;
fp685 = inteval->AB_z[vi] * src1[((hsi*150+12)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp684;
fp684 = src0[((hsi*210+42)*lowdim+lsi)*1] + fp685;
LIBINT2_REALTYPE fp682;
fp682 = fp684 - fp683;
target[((hsi*225+20)*lowdim+lsi)*1] = fp682;
LIBINT2_REALTYPE fp687;
fp687 = 1.0000000000000000e+00 * src2[((hsi*150+11)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp689;
fp689 = inteval->AB_z[vi] * src1[((hsi*150+11)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp688;
fp688 = src0[((hsi*210+41)*lowdim+lsi)*1] + fp689;
LIBINT2_REALTYPE fp686;
fp686 = fp688 - fp687;
target[((hsi*225+19)*lowdim+lsi)*1] = fp686;
LIBINT2_REALTYPE fp691;
fp691 = inteval->AB_y[vi] * src1[((hsi*150+11)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp690;
fp690 = src0[((hsi*210+31)*lowdim+lsi)*1] + fp691;
target[((hsi*225+18)*lowdim+lsi)*1] = fp690;
LIBINT2_REALTYPE fp693;
fp693 = 1.0000000000000000e+00 * src2[((hsi*150+10)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp695;
fp695 = inteval->AB_z[vi] * src1[((hsi*150+10)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp694;
fp694 = src0[((hsi*210+40)*lowdim+lsi)*1] + fp695;
LIBINT2_REALTYPE fp692;
fp692 = fp694 - fp693;
target[((hsi*225+17)*lowdim+lsi)*1] = fp692;
LIBINT2_REALTYPE fp697;
fp697 = inteval->AB_y[vi] * src1[((hsi*150+10)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp696;
fp696 = src0[((hsi*210+30)*lowdim+lsi)*1] + fp697;
target[((hsi*225+16)*lowdim+lsi)*1] = fp696;
LIBINT2_REALTYPE fp699;
fp699 = inteval->AB_x[vi] * src1[((hsi*150+10)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp698;
fp698 = src0[((hsi*210+10)*lowdim+lsi)*1] + fp699;
target[((hsi*225+15)*lowdim+lsi)*1] = fp698;
LIBINT2_REALTYPE fp563;
fp563 = 1.0000000000000000e+00 * src2[((hsi*150+36)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp565;
fp565 = inteval->AB_z[vi] * src1[((hsi*150+36)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp564;
fp564 = src0[((hsi*210+76)*lowdim+lsi)*1] + fp565;
LIBINT2_REALTYPE fp562;
fp562 = fp564 - fp563;
target[((hsi*225+56)*lowdim+lsi)*1] = fp562;
LIBINT2_REALTYPE fp705;
fp705 = 1.0000000000000000e+00 * src2[((hsi*150+8)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp707;
fp707 = inteval->AB_z[vi] * src1[((hsi*150+8)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp706;
fp706 = src0[((hsi*210+28)*lowdim+lsi)*1] + fp707;
LIBINT2_REALTYPE fp704;
fp704 = fp706 - fp705;
target[((hsi*225+13)*lowdim+lsi)*1] = fp704;
LIBINT2_REALTYPE fp709;
fp709 = 1.0000000000000000e+00 * src2[((hsi*150+7)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp711;
fp711 = inteval->AB_z[vi] * src1[((hsi*150+7)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp710;
fp710 = src0[((hsi*210+27)*lowdim+lsi)*1] + fp711;
LIBINT2_REALTYPE fp708;
fp708 = fp710 - fp709;
target[((hsi*225+12)*lowdim+lsi)*1] = fp708;
LIBINT2_REALTYPE fp713;
fp713 = 1.0000000000000000e+00 * src2[((hsi*150+6)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp715;
fp715 = inteval->AB_z[vi] * src1[((hsi*150+6)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp714;
fp714 = src0[((hsi*210+26)*lowdim+lsi)*1] + fp715;
LIBINT2_REALTYPE fp712;
fp712 = fp714 - fp713;
target[((hsi*225+11)*lowdim+lsi)*1] = fp712;
LIBINT2_REALTYPE fp717;
fp717 = inteval->AB_y[vi] * src1[((hsi*150+6)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp716;
fp716 = src0[((hsi*210+16)*lowdim+lsi)*1] + fp717;
target[((hsi*225+10)*lowdim+lsi)*1] = fp716;
LIBINT2_REALTYPE fp719;
fp719 = 1.0000000000000000e+00 * src2[((hsi*150+5)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp721;
fp721 = inteval->AB_z[vi] * src1[((hsi*150+5)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp720;
fp720 = src0[((hsi*210+25)*lowdim+lsi)*1] + fp721;
LIBINT2_REALTYPE fp718;
fp718 = fp720 - fp719;
target[((hsi*225+9)*lowdim+lsi)*1] = fp718;
LIBINT2_REALTYPE fp723;
fp723 = 1.0000000000000000e+00 * src2[((hsi*150+4)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp725;
fp725 = inteval->AB_z[vi] * src1[((hsi*150+4)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp724;
fp724 = src0[((hsi*210+24)*lowdim+lsi)*1] + fp725;
LIBINT2_REALTYPE fp722;
fp722 = fp724 - fp723;
target[((hsi*225+8)*lowdim+lsi)*1] = fp722;
LIBINT2_REALTYPE fp727;
fp727 = 1.0000000000000000e+00 * src2[((hsi*150+3)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp729;
fp729 = inteval->AB_z[vi] * src1[((hsi*150+3)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp728;
fp728 = src0[((hsi*210+23)*lowdim+lsi)*1] + fp729;
LIBINT2_REALTYPE fp726;
fp726 = fp728 - fp727;
target[((hsi*225+7)*lowdim+lsi)*1] = fp726;
LIBINT2_REALTYPE fp731;
fp731 = inteval->AB_y[vi] * src1[((hsi*150+3)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp730;
fp730 = src0[((hsi*210+13)*lowdim+lsi)*1] + fp731;
target[((hsi*225+6)*lowdim+lsi)*1] = fp730;
LIBINT2_REALTYPE fp733;
fp733 = 1.0000000000000000e+00 * src2[((hsi*150+2)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp735;
fp735 = inteval->AB_z[vi] * src1[((hsi*150+2)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp734;
fp734 = src0[((hsi*210+22)*lowdim+lsi)*1] + fp735;
LIBINT2_REALTYPE fp732;
fp732 = fp734 - fp733;
target[((hsi*225+5)*lowdim+lsi)*1] = fp732;
LIBINT2_REALTYPE fp737;
fp737 = 1.0000000000000000e+00 * src2[((hsi*150+1)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp739;
fp739 = inteval->AB_z[vi] * src1[((hsi*150+1)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp738;
fp738 = src0[((hsi*210+21)*lowdim+lsi)*1] + fp739;
LIBINT2_REALTYPE fp736;
fp736 = fp738 - fp737;
target[((hsi*225+4)*lowdim+lsi)*1] = fp736;
LIBINT2_REALTYPE fp741;
fp741 = inteval->AB_y[vi] * src1[((hsi*150+1)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp740;
fp740 = src0[((hsi*210+11)*lowdim+lsi)*1] + fp741;
target[((hsi*225+3)*lowdim+lsi)*1] = fp740;
LIBINT2_REALTYPE fp743;
fp743 = 1.0000000000000000e+00 * src2[((hsi*150+0)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp745;
fp745 = inteval->AB_z[vi] * src1[((hsi*150+0)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp744;
fp744 = src0[((hsi*210+20)*lowdim+lsi)*1] + fp745;
LIBINT2_REALTYPE fp742;
fp742 = fp744 - fp743;
target[((hsi*225+2)*lowdim+lsi)*1] = fp742;
LIBINT2_REALTYPE fp747;
fp747 = inteval->AB_y[vi] * src1[((hsi*150+0)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp746;
fp746 = src0[((hsi*210+10)*lowdim+lsi)*1] + fp747;
target[((hsi*225+1)*lowdim+lsi)*1] = fp746;
LIBINT2_REALTYPE fp701;
fp701 = 1.0000000000000000e+00 * src2[((hsi*150+9)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp703;
fp703 = inteval->AB_z[vi] * src1[((hsi*150+9)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp702;
fp702 = src0[((hsi*210+29)*lowdim+lsi)*1] + fp703;
LIBINT2_REALTYPE fp700;
fp700 = fp702 - fp701;
target[((hsi*225+14)*lowdim+lsi)*1] = fp700;
LIBINT2_REALTYPE fp567;
fp567 = inteval->AB_y[vi] * src1[((hsi*150+36)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp566;
fp566 = src0[((hsi*210+66)*lowdim+lsi)*1] + fp567;
target[((hsi*225+55)*lowdim+lsi)*1] = fp566;
LIBINT2_REALTYPE fp569;
fp569 = 1.0000000000000000e+00 * src2[((hsi*150+35)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp571;
fp571 = inteval->AB_z[vi] * src1[((hsi*150+35)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp570;
fp570 = src0[((hsi*210+75)*lowdim+lsi)*1] + fp571;
LIBINT2_REALTYPE fp568;
fp568 = fp570 - fp569;
target[((hsi*225+54)*lowdim+lsi)*1] = fp568;
LIBINT2_REALTYPE fp573;
fp573 = 1.0000000000000000e+00 * src2[((hsi*150+34)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp575;
fp575 = inteval->AB_z[vi] * src1[((hsi*150+34)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp574;
fp574 = src0[((hsi*210+74)*lowdim+lsi)*1] + fp575;
LIBINT2_REALTYPE fp572;
fp572 = fp574 - fp573;
target[((hsi*225+53)*lowdim+lsi)*1] = fp572;
LIBINT2_REALTYPE fp577;
fp577 = 1.0000000000000000e+00 * src2[((hsi*150+33)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp579;
fp579 = inteval->AB_z[vi] * src1[((hsi*150+33)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp578;
fp578 = src0[((hsi*210+73)*lowdim+lsi)*1] + fp579;
LIBINT2_REALTYPE fp576;
fp576 = fp578 - fp577;
target[((hsi*225+52)*lowdim+lsi)*1] = fp576;
LIBINT2_REALTYPE fp581;
fp581 = inteval->AB_y[vi] * src1[((hsi*150+33)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp580;
fp580 = src0[((hsi*210+63)*lowdim+lsi)*1] + fp581;
target[((hsi*225+51)*lowdim+lsi)*1] = fp580;
LIBINT2_REALTYPE fp583;
fp583 = 1.0000000000000000e+00 * src2[((hsi*150+32)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp585;
fp585 = inteval->AB_z[vi] * src1[((hsi*150+32)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp584;
fp584 = src0[((hsi*210+72)*lowdim+lsi)*1] + fp585;
LIBINT2_REALTYPE fp582;
fp582 = fp584 - fp583;
target[((hsi*225+50)*lowdim+lsi)*1] = fp582;
LIBINT2_REALTYPE fp587;
fp587 = 1.0000000000000000e+00 * src2[((hsi*150+31)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp589;
fp589 = inteval->AB_z[vi] * src1[((hsi*150+31)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp588;
fp588 = src0[((hsi*210+71)*lowdim+lsi)*1] + fp589;
LIBINT2_REALTYPE fp586;
fp586 = fp588 - fp587;
target[((hsi*225+49)*lowdim+lsi)*1] = fp586;
LIBINT2_REALTYPE fp591;
fp591 = inteval->AB_y[vi] * src1[((hsi*150+31)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp590;
fp590 = src0[((hsi*210+61)*lowdim+lsi)*1] + fp591;
target[((hsi*225+48)*lowdim+lsi)*1] = fp590;
LIBINT2_REALTYPE fp593;
fp593 = 1.0000000000000000e+00 * src2[((hsi*150+30)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp595;
fp595 = inteval->AB_z[vi] * src1[((hsi*150+30)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp594;
fp594 = src0[((hsi*210+70)*lowdim+lsi)*1] + fp595;
LIBINT2_REALTYPE fp592;
fp592 = fp594 - fp593;
target[((hsi*225+47)*lowdim+lsi)*1] = fp592;
LIBINT2_REALTYPE fp597;
fp597 = inteval->AB_y[vi] * src1[((hsi*150+30)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp596;
fp596 = src0[((hsi*210+60)*lowdim+lsi)*1] + fp597;
target[((hsi*225+46)*lowdim+lsi)*1] = fp596;
LIBINT2_REALTYPE fp599;
fp599 = inteval->AB_x[vi] * src1[((hsi*150+30)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp598;
fp598 = src0[((hsi*210+30)*lowdim+lsi)*1] + fp599;
target[((hsi*225+45)*lowdim+lsi)*1] = fp598;
LIBINT2_REALTYPE fp601;
fp601 = 1.0000000000000000e+00 * src2[((hsi*150+29)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp603;
fp603 = inteval->AB_z[vi] * src1[((hsi*150+29)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp602;
fp602 = src0[((hsi*210+59)*lowdim+lsi)*1] + fp603;
LIBINT2_REALTYPE fp600;
fp600 = fp602 - fp601;
target[((hsi*225+44)*lowdim+lsi)*1] = fp600;
LIBINT2_REALTYPE fp605;
fp605 = 1.0000000000000000e+00 * src2[((hsi*150+28)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp607;
fp607 = inteval->AB_z[vi] * src1[((hsi*150+28)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp606;
fp606 = src0[((hsi*210+58)*lowdim+lsi)*1] + fp607;
LIBINT2_REALTYPE fp604;
fp604 = fp606 - fp605;
target[((hsi*225+43)*lowdim+lsi)*1] = fp604;
LIBINT2_REALTYPE fp655;
fp655 = 1.0000000000000000e+00 * src2[((hsi*150+18)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp657;
fp657 = inteval->AB_z[vi] * src1[((hsi*150+18)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp656;
fp656 = src0[((hsi*210+48)*lowdim+lsi)*1] + fp657;
LIBINT2_REALTYPE fp654;
fp654 = fp656 - fp655;
target[((hsi*225+28)*lowdim+lsi)*1] = fp654;
LIBINT2_REALTYPE fp613;
fp613 = 1.0000000000000000e+00 * src2[((hsi*150+26)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp615;
fp615 = inteval->AB_z[vi] * src1[((hsi*150+26)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp614;
fp614 = src0[((hsi*210+56)*lowdim+lsi)*1] + fp615;
LIBINT2_REALTYPE fp612;
fp612 = fp614 - fp613;
target[((hsi*225+41)*lowdim+lsi)*1] = fp612;
LIBINT2_REALTYPE fp617;
fp617 = inteval->AB_y[vi] * src1[((hsi*150+26)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp616;
fp616 = src0[((hsi*210+46)*lowdim+lsi)*1] + fp617;
target[((hsi*225+40)*lowdim+lsi)*1] = fp616;
LIBINT2_REALTYPE fp619;
fp619 = 1.0000000000000000e+00 * src2[((hsi*150+25)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp621;
fp621 = inteval->AB_z[vi] * src1[((hsi*150+25)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp620;
fp620 = src0[((hsi*210+55)*lowdim+lsi)*1] + fp621;
LIBINT2_REALTYPE fp618;
fp618 = fp620 - fp619;
target[((hsi*225+39)*lowdim+lsi)*1] = fp618;
LIBINT2_REALTYPE fp623;
fp623 = 1.0000000000000000e+00 * src2[((hsi*150+24)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp625;
fp625 = inteval->AB_z[vi] * src1[((hsi*150+24)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp624;
fp624 = src0[((hsi*210+54)*lowdim+lsi)*1] + fp625;
LIBINT2_REALTYPE fp622;
fp622 = fp624 - fp623;
target[((hsi*225+38)*lowdim+lsi)*1] = fp622;
LIBINT2_REALTYPE fp627;
fp627 = 1.0000000000000000e+00 * src2[((hsi*150+23)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp629;
fp629 = inteval->AB_z[vi] * src1[((hsi*150+23)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp628;
fp628 = src0[((hsi*210+53)*lowdim+lsi)*1] + fp629;
LIBINT2_REALTYPE fp626;
fp626 = fp628 - fp627;
target[((hsi*225+37)*lowdim+lsi)*1] = fp626;
LIBINT2_REALTYPE fp631;
fp631 = inteval->AB_y[vi] * src1[((hsi*150+23)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp630;
fp630 = src0[((hsi*210+43)*lowdim+lsi)*1] + fp631;
target[((hsi*225+36)*lowdim+lsi)*1] = fp630;
LIBINT2_REALTYPE fp633;
fp633 = 1.0000000000000000e+00 * src2[((hsi*150+22)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp635;
fp635 = inteval->AB_z[vi] * src1[((hsi*150+22)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp634;
fp634 = src0[((hsi*210+52)*lowdim+lsi)*1] + fp635;
LIBINT2_REALTYPE fp632;
fp632 = fp634 - fp633;
target[((hsi*225+35)*lowdim+lsi)*1] = fp632;
LIBINT2_REALTYPE fp637;
fp637 = 1.0000000000000000e+00 * src2[((hsi*150+21)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp639;
fp639 = inteval->AB_z[vi] * src1[((hsi*150+21)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp638;
fp638 = src0[((hsi*210+51)*lowdim+lsi)*1] + fp639;
LIBINT2_REALTYPE fp636;
fp636 = fp638 - fp637;
target[((hsi*225+34)*lowdim+lsi)*1] = fp636;
LIBINT2_REALTYPE fp641;
fp641 = inteval->AB_y[vi] * src1[((hsi*150+21)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp640;
fp640 = src0[((hsi*210+41)*lowdim+lsi)*1] + fp641;
target[((hsi*225+33)*lowdim+lsi)*1] = fp640;
LIBINT2_REALTYPE fp643;
fp643 = 1.0000000000000000e+00 * src2[((hsi*150+20)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp645;
fp645 = inteval->AB_z[vi] * src1[((hsi*150+20)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp644;
fp644 = src0[((hsi*210+50)*lowdim+lsi)*1] + fp645;
LIBINT2_REALTYPE fp642;
fp642 = fp644 - fp643;
target[((hsi*225+32)*lowdim+lsi)*1] = fp642;
LIBINT2_REALTYPE fp647;
fp647 = inteval->AB_y[vi] * src1[((hsi*150+20)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp646;
fp646 = src0[((hsi*210+40)*lowdim+lsi)*1] + fp647;
target[((hsi*225+31)*lowdim+lsi)*1] = fp646;
LIBINT2_REALTYPE fp649;
fp649 = inteval->AB_x[vi] * src1[((hsi*150+20)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp648;
fp648 = src0[((hsi*210+20)*lowdim+lsi)*1] + fp649;
target[((hsi*225+30)*lowdim+lsi)*1] = fp648;
LIBINT2_REALTYPE fp651;
fp651 = 1.0000000000000000e+00 * src2[((hsi*150+19)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp653;
fp653 = inteval->AB_z[vi] * src1[((hsi*150+19)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp652;
fp652 = src0[((hsi*210+49)*lowdim+lsi)*1] + fp653;
LIBINT2_REALTYPE fp650;
fp650 = fp652 - fp651;
target[((hsi*225+29)*lowdim+lsi)*1] = fp650;
LIBINT2_REALTYPE fp609;
fp609 = 1.0000000000000000e+00 * src2[((hsi*150+27)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp611;
fp611 = inteval->AB_z[vi] * src1[((hsi*150+27)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp610;
fp610 = src0[((hsi*210+57)*lowdim+lsi)*1] + fp611;
LIBINT2_REALTYPE fp608;
fp608 = fp610 - fp609;
target[((hsi*225+42)*lowdim+lsi)*1] = fp608;
LIBINT2_REALTYPE fp97;
fp97 = inteval->AB_y[vi] * src1[((hsi*150+130)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp96;
fp96 = src0[((hsi*210+180)*lowdim+lsi)*1] + fp97;
target[((hsi*225+196)*lowdim+lsi)*1] = fp96;
LIBINT2_REALTYPE fp99;
fp99 = inteval->AB_x[vi] * src1[((hsi*150+130)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp98;
fp98 = src0[((hsi*210+130)*lowdim+lsi)*1] + fp99;
target[((hsi*225+195)*lowdim+lsi)*1] = fp98;
LIBINT2_REALTYPE fp101;
fp101 = 1.0000000000000000e+00 * src2[((hsi*150+129)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp103;
fp103 = inteval->AB_z[vi] * src1[((hsi*150+129)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp102;
fp102 = src0[((hsi*210+189)*lowdim+lsi)*1] + fp103;
LIBINT2_REALTYPE fp100;
fp100 = fp102 - fp101;
target[((hsi*225+194)*lowdim+lsi)*1] = fp100;
LIBINT2_REALTYPE fp105;
fp105 = 1.0000000000000000e+00 * src2[((hsi*150+128)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp107;
fp107 = inteval->AB_z[vi] * src1[((hsi*150+128)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp106;
fp106 = src0[((hsi*210+188)*lowdim+lsi)*1] + fp107;
LIBINT2_REALTYPE fp104;
fp104 = fp106 - fp105;
target[((hsi*225+193)*lowdim+lsi)*1] = fp104;
LIBINT2_REALTYPE fp109;
fp109 = 1.0000000000000000e+00 * src2[((hsi*150+127)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp111;
fp111 = inteval->AB_z[vi] * src1[((hsi*150+127)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp110;
fp110 = src0[((hsi*210+187)*lowdim+lsi)*1] + fp111;
LIBINT2_REALTYPE fp108;
fp108 = fp110 - fp109;
target[((hsi*225+192)*lowdim+lsi)*1] = fp108;
LIBINT2_REALTYPE fp113;
fp113 = 1.0000000000000000e+00 * src2[((hsi*150+126)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp115;
fp115 = inteval->AB_z[vi] * src1[((hsi*150+126)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp114;
fp114 = src0[((hsi*210+186)*lowdim+lsi)*1] + fp115;
LIBINT2_REALTYPE fp112;
fp112 = fp114 - fp113;
target[((hsi*225+191)*lowdim+lsi)*1] = fp112;
LIBINT2_REALTYPE fp117;
fp117 = inteval->AB_y[vi] * src1[((hsi*150+126)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp116;
fp116 = src0[((hsi*210+176)*lowdim+lsi)*1] + fp117;
target[((hsi*225+190)*lowdim+lsi)*1] = fp116;
LIBINT2_REALTYPE fp119;
fp119 = 1.0000000000000000e+00 * src2[((hsi*150+125)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp121;
fp121 = inteval->AB_z[vi] * src1[((hsi*150+125)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp120;
fp120 = src0[((hsi*210+185)*lowdim+lsi)*1] + fp121;
LIBINT2_REALTYPE fp118;
fp118 = fp120 - fp119;
target[((hsi*225+189)*lowdim+lsi)*1] = fp118;
LIBINT2_REALTYPE fp123;
fp123 = 1.0000000000000000e+00 * src2[((hsi*150+124)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp125;
fp125 = inteval->AB_z[vi] * src1[((hsi*150+124)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp124;
fp124 = src0[((hsi*210+184)*lowdim+lsi)*1] + fp125;
LIBINT2_REALTYPE fp122;
fp122 = fp124 - fp123;
target[((hsi*225+188)*lowdim+lsi)*1] = fp122;
LIBINT2_REALTYPE fp127;
fp127 = 1.0000000000000000e+00 * src2[((hsi*150+123)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp129;
fp129 = inteval->AB_z[vi] * src1[((hsi*150+123)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp128;
fp128 = src0[((hsi*210+183)*lowdim+lsi)*1] + fp129;
LIBINT2_REALTYPE fp126;
fp126 = fp128 - fp127;
target[((hsi*225+187)*lowdim+lsi)*1] = fp126;
LIBINT2_REALTYPE fp131;
fp131 = inteval->AB_y[vi] * src1[((hsi*150+123)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp130;
fp130 = src0[((hsi*210+173)*lowdim+lsi)*1] + fp131;
target[((hsi*225+186)*lowdim+lsi)*1] = fp130;
LIBINT2_REALTYPE fp133;
fp133 = 1.0000000000000000e+00 * src2[((hsi*150+122)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp135;
fp135 = inteval->AB_z[vi] * src1[((hsi*150+122)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp134;
fp134 = src0[((hsi*210+182)*lowdim+lsi)*1] + fp135;
LIBINT2_REALTYPE fp132;
fp132 = fp134 - fp133;
target[((hsi*225+185)*lowdim+lsi)*1] = fp132;
LIBINT2_REALTYPE fp137;
fp137 = 1.0000000000000000e+00 * src2[((hsi*150+121)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp139;
fp139 = inteval->AB_z[vi] * src1[((hsi*150+121)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp138;
fp138 = src0[((hsi*210+181)*lowdim+lsi)*1] + fp139;
LIBINT2_REALTYPE fp136;
fp136 = fp138 - fp137;
target[((hsi*225+184)*lowdim+lsi)*1] = fp136;
LIBINT2_REALTYPE fp377;
fp377 = 1.0000000000000000e+00 * src2[((hsi*150+73)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp379;
fp379 = inteval->AB_z[vi] * src1[((hsi*150+73)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp378;
fp378 = src0[((hsi*210+123)*lowdim+lsi)*1] + fp379;
LIBINT2_REALTYPE fp376;
fp376 = fp378 - fp377;
target[((hsi*225+112)*lowdim+lsi)*1] = fp376;
LIBINT2_REALTYPE fp143;
fp143 = 1.0000000000000000e+00 * src2[((hsi*150+120)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp145;
fp145 = inteval->AB_z[vi] * src1[((hsi*150+120)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp144;
fp144 = src0[((hsi*210+180)*lowdim+lsi)*1] + fp145;
LIBINT2_REALTYPE fp142;
fp142 = fp144 - fp143;
target[((hsi*225+182)*lowdim+lsi)*1] = fp142;
LIBINT2_REALTYPE fp147;
fp147 = inteval->AB_y[vi] * src1[((hsi*150+120)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp146;
fp146 = src0[((hsi*210+170)*lowdim+lsi)*1] + fp147;
target[((hsi*225+181)*lowdim+lsi)*1] = fp146;
LIBINT2_REALTYPE fp149;
fp149 = inteval->AB_x[vi] * src1[((hsi*150+120)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp148;
fp148 = src0[((hsi*210+120)*lowdim+lsi)*1] + fp149;
target[((hsi*225+180)*lowdim+lsi)*1] = fp148;
LIBINT2_REALTYPE fp151;
fp151 = 1.0000000000000000e+00 * src2[((hsi*150+119)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp153;
fp153 = inteval->AB_z[vi] * src1[((hsi*150+119)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp152;
fp152 = src0[((hsi*210+179)*lowdim+lsi)*1] + fp153;
LIBINT2_REALTYPE fp150;
fp150 = fp152 - fp151;
target[((hsi*225+179)*lowdim+lsi)*1] = fp150;
LIBINT2_REALTYPE fp155;
fp155 = 1.0000000000000000e+00 * src2[((hsi*150+118)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp157;
fp157 = inteval->AB_z[vi] * src1[((hsi*150+118)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp156;
fp156 = src0[((hsi*210+178)*lowdim+lsi)*1] + fp157;
LIBINT2_REALTYPE fp154;
fp154 = fp156 - fp155;
target[((hsi*225+178)*lowdim+lsi)*1] = fp154;
LIBINT2_REALTYPE fp159;
fp159 = 1.0000000000000000e+00 * src2[((hsi*150+117)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp161;
fp161 = inteval->AB_z[vi] * src1[((hsi*150+117)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp160;
fp160 = src0[((hsi*210+177)*lowdim+lsi)*1] + fp161;
LIBINT2_REALTYPE fp158;
fp158 = fp160 - fp159;
target[((hsi*225+177)*lowdim+lsi)*1] = fp158;
LIBINT2_REALTYPE fp163;
fp163 = 1.0000000000000000e+00 * src2[((hsi*150+116)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp165;
fp165 = inteval->AB_z[vi] * src1[((hsi*150+116)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp164;
fp164 = src0[((hsi*210+176)*lowdim+lsi)*1] + fp165;
LIBINT2_REALTYPE fp162;
fp162 = fp164 - fp163;
target[((hsi*225+176)*lowdim+lsi)*1] = fp162;
LIBINT2_REALTYPE fp167;
fp167 = inteval->AB_y[vi] * src1[((hsi*150+116)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp166;
fp166 = src0[((hsi*210+166)*lowdim+lsi)*1] + fp167;
target[((hsi*225+175)*lowdim+lsi)*1] = fp166;
LIBINT2_REALTYPE fp169;
fp169 = 1.0000000000000000e+00 * src2[((hsi*150+115)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp171;
fp171 = inteval->AB_z[vi] * src1[((hsi*150+115)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp170;
fp170 = src0[((hsi*210+175)*lowdim+lsi)*1] + fp171;
LIBINT2_REALTYPE fp168;
fp168 = fp170 - fp169;
target[((hsi*225+174)*lowdim+lsi)*1] = fp168;
LIBINT2_REALTYPE fp173;
fp173 = 1.0000000000000000e+00 * src2[((hsi*150+114)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp175;
fp175 = inteval->AB_z[vi] * src1[((hsi*150+114)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp174;
fp174 = src0[((hsi*210+174)*lowdim+lsi)*1] + fp175;
LIBINT2_REALTYPE fp172;
fp172 = fp174 - fp173;
target[((hsi*225+173)*lowdim+lsi)*1] = fp172;
LIBINT2_REALTYPE fp177;
fp177 = 1.0000000000000000e+00 * src2[((hsi*150+113)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp179;
fp179 = inteval->AB_z[vi] * src1[((hsi*150+113)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp178;
fp178 = src0[((hsi*210+173)*lowdim+lsi)*1] + fp179;
LIBINT2_REALTYPE fp176;
fp176 = fp178 - fp177;
target[((hsi*225+172)*lowdim+lsi)*1] = fp176;
LIBINT2_REALTYPE fp181;
fp181 = inteval->AB_y[vi] * src1[((hsi*150+113)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp180;
fp180 = src0[((hsi*210+163)*lowdim+lsi)*1] + fp181;
target[((hsi*225+171)*lowdim+lsi)*1] = fp180;
LIBINT2_REALTYPE fp183;
fp183 = 1.0000000000000000e+00 * src2[((hsi*150+112)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp185;
fp185 = inteval->AB_z[vi] * src1[((hsi*150+112)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp184;
fp184 = src0[((hsi*210+172)*lowdim+lsi)*1] + fp185;
LIBINT2_REALTYPE fp182;
fp182 = fp184 - fp183;
target[((hsi*225+170)*lowdim+lsi)*1] = fp182;
LIBINT2_REALTYPE fp141;
fp141 = inteval->AB_y[vi] * src1[((hsi*150+121)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp140;
fp140 = src0[((hsi*210+171)*lowdim+lsi)*1] + fp141;
target[((hsi*225+183)*lowdim+lsi)*1] = fp140;
LIBINT2_REALTYPE fp1;
fp1 = 1.0000000000000000e+00 * src2[((hsi*150+149)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp3;
fp3 = inteval->AB_z[vi] * src1[((hsi*150+149)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp2;
fp2 = src0[((hsi*210+209)*lowdim+lsi)*1] + fp3;
LIBINT2_REALTYPE fp0;
fp0 = fp2 - fp1;
target[((hsi*225+224)*lowdim+lsi)*1] = fp0;
LIBINT2_REALTYPE fp5;
fp5 = 1.0000000000000000e+00 * src2[((hsi*150+148)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp7;
fp7 = inteval->AB_z[vi] * src1[((hsi*150+148)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp6;
fp6 = src0[((hsi*210+208)*lowdim+lsi)*1] + fp7;
LIBINT2_REALTYPE fp4;
fp4 = fp6 - fp5;
target[((hsi*225+223)*lowdim+lsi)*1] = fp4;
LIBINT2_REALTYPE fp9;
fp9 = 1.0000000000000000e+00 * src2[((hsi*150+147)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp11;
fp11 = inteval->AB_z[vi] * src1[((hsi*150+147)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp10;
fp10 = src0[((hsi*210+207)*lowdim+lsi)*1] + fp11;
LIBINT2_REALTYPE fp8;
fp8 = fp10 - fp9;
target[((hsi*225+222)*lowdim+lsi)*1] = fp8;
LIBINT2_REALTYPE fp13;
fp13 = 1.0000000000000000e+00 * src2[((hsi*150+146)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp15;
fp15 = inteval->AB_z[vi] * src1[((hsi*150+146)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp14;
fp14 = src0[((hsi*210+206)*lowdim+lsi)*1] + fp15;
LIBINT2_REALTYPE fp12;
fp12 = fp14 - fp13;
target[((hsi*225+221)*lowdim+lsi)*1] = fp12;
LIBINT2_REALTYPE fp17;
fp17 = inteval->AB_y[vi] * src1[((hsi*150+146)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp16;
fp16 = src0[((hsi*210+196)*lowdim+lsi)*1] + fp17;
target[((hsi*225+220)*lowdim+lsi)*1] = fp16;
LIBINT2_REALTYPE fp19;
fp19 = 1.0000000000000000e+00 * src2[((hsi*150+145)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp21;
fp21 = inteval->AB_z[vi] * src1[((hsi*150+145)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp20;
fp20 = src0[((hsi*210+205)*lowdim+lsi)*1] + fp21;
LIBINT2_REALTYPE fp18;
fp18 = fp20 - fp19;
target[((hsi*225+219)*lowdim+lsi)*1] = fp18;
LIBINT2_REALTYPE fp23;
fp23 = 1.0000000000000000e+00 * src2[((hsi*150+144)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp25;
fp25 = inteval->AB_z[vi] * src1[((hsi*150+144)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp24;
fp24 = src0[((hsi*210+204)*lowdim+lsi)*1] + fp25;
LIBINT2_REALTYPE fp22;
fp22 = fp24 - fp23;
target[((hsi*225+218)*lowdim+lsi)*1] = fp22;
LIBINT2_REALTYPE fp27;
fp27 = 1.0000000000000000e+00 * src2[((hsi*150+143)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp29;
fp29 = inteval->AB_z[vi] * src1[((hsi*150+143)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp28;
fp28 = src0[((hsi*210+203)*lowdim+lsi)*1] + fp29;
LIBINT2_REALTYPE fp26;
fp26 = fp28 - fp27;
target[((hsi*225+217)*lowdim+lsi)*1] = fp26;
LIBINT2_REALTYPE fp31;
fp31 = inteval->AB_y[vi] * src1[((hsi*150+143)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp30;
fp30 = src0[((hsi*210+193)*lowdim+lsi)*1] + fp31;
target[((hsi*225+216)*lowdim+lsi)*1] = fp30;
LIBINT2_REALTYPE fp33;
fp33 = 1.0000000000000000e+00 * src2[((hsi*150+142)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp35;
fp35 = inteval->AB_z[vi] * src1[((hsi*150+142)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp34;
fp34 = src0[((hsi*210+202)*lowdim+lsi)*1] + fp35;
LIBINT2_REALTYPE fp32;
fp32 = fp34 - fp33;
target[((hsi*225+215)*lowdim+lsi)*1] = fp32;
LIBINT2_REALTYPE fp37;
fp37 = 1.0000000000000000e+00 * src2[((hsi*150+141)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp39;
fp39 = inteval->AB_z[vi] * src1[((hsi*150+141)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp38;
fp38 = src0[((hsi*210+201)*lowdim+lsi)*1] + fp39;
LIBINT2_REALTYPE fp36;
fp36 = fp38 - fp37;
target[((hsi*225+214)*lowdim+lsi)*1] = fp36;
LIBINT2_REALTYPE fp41;
fp41 = inteval->AB_y[vi] * src1[((hsi*150+141)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp40;
fp40 = src0[((hsi*210+191)*lowdim+lsi)*1] + fp41;
target[((hsi*225+213)*lowdim+lsi)*1] = fp40;
LIBINT2_REALTYPE fp43;
fp43 = 1.0000000000000000e+00 * src2[((hsi*150+140)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp45;
fp45 = inteval->AB_z[vi] * src1[((hsi*150+140)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp44;
fp44 = src0[((hsi*210+200)*lowdim+lsi)*1] + fp45;
LIBINT2_REALTYPE fp42;
fp42 = fp44 - fp43;
target[((hsi*225+212)*lowdim+lsi)*1] = fp42;
LIBINT2_REALTYPE fp93;
fp93 = 1.0000000000000000e+00 * src2[((hsi*150+130)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp95;
fp95 = inteval->AB_z[vi] * src1[((hsi*150+130)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp94;
fp94 = src0[((hsi*210+190)*lowdim+lsi)*1] + fp95;
LIBINT2_REALTYPE fp92;
fp92 = fp94 - fp93;
target[((hsi*225+197)*lowdim+lsi)*1] = fp92;
LIBINT2_REALTYPE fp49;
fp49 = inteval->AB_x[vi] * src1[((hsi*150+140)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp48;
fp48 = src0[((hsi*210+140)*lowdim+lsi)*1] + fp49;
target[((hsi*225+210)*lowdim+lsi)*1] = fp48;
LIBINT2_REALTYPE fp51;
fp51 = 1.0000000000000000e+00 * src2[((hsi*150+139)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp53;
fp53 = inteval->AB_z[vi] * src1[((hsi*150+139)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp52;
fp52 = src0[((hsi*210+199)*lowdim+lsi)*1] + fp53;
LIBINT2_REALTYPE fp50;
fp50 = fp52 - fp51;
target[((hsi*225+209)*lowdim+lsi)*1] = fp50;
LIBINT2_REALTYPE fp55;
fp55 = 1.0000000000000000e+00 * src2[((hsi*150+138)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp57;
fp57 = inteval->AB_z[vi] * src1[((hsi*150+138)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp56;
fp56 = src0[((hsi*210+198)*lowdim+lsi)*1] + fp57;
LIBINT2_REALTYPE fp54;
fp54 = fp56 - fp55;
target[((hsi*225+208)*lowdim+lsi)*1] = fp54;
LIBINT2_REALTYPE fp59;
fp59 = 1.0000000000000000e+00 * src2[((hsi*150+137)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp61;
fp61 = inteval->AB_z[vi] * src1[((hsi*150+137)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp60;
fp60 = src0[((hsi*210+197)*lowdim+lsi)*1] + fp61;
LIBINT2_REALTYPE fp58;
fp58 = fp60 - fp59;
target[((hsi*225+207)*lowdim+lsi)*1] = fp58;
LIBINT2_REALTYPE fp63;
fp63 = 1.0000000000000000e+00 * src2[((hsi*150+136)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp65;
fp65 = inteval->AB_z[vi] * src1[((hsi*150+136)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp64;
fp64 = src0[((hsi*210+196)*lowdim+lsi)*1] + fp65;
LIBINT2_REALTYPE fp62;
fp62 = fp64 - fp63;
target[((hsi*225+206)*lowdim+lsi)*1] = fp62;
LIBINT2_REALTYPE fp67;
fp67 = inteval->AB_y[vi] * src1[((hsi*150+136)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp66;
fp66 = src0[((hsi*210+186)*lowdim+lsi)*1] + fp67;
target[((hsi*225+205)*lowdim+lsi)*1] = fp66;
LIBINT2_REALTYPE fp69;
fp69 = 1.0000000000000000e+00 * src2[((hsi*150+135)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp71;
fp71 = inteval->AB_z[vi] * src1[((hsi*150+135)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp70;
fp70 = src0[((hsi*210+195)*lowdim+lsi)*1] + fp71;
LIBINT2_REALTYPE fp68;
fp68 = fp70 - fp69;
target[((hsi*225+204)*lowdim+lsi)*1] = fp68;
LIBINT2_REALTYPE fp73;
fp73 = 1.0000000000000000e+00 * src2[((hsi*150+134)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp75;
fp75 = inteval->AB_z[vi] * src1[((hsi*150+134)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp74;
fp74 = src0[((hsi*210+194)*lowdim+lsi)*1] + fp75;
LIBINT2_REALTYPE fp72;
fp72 = fp74 - fp73;
target[((hsi*225+203)*lowdim+lsi)*1] = fp72;
LIBINT2_REALTYPE fp77;
fp77 = 1.0000000000000000e+00 * src2[((hsi*150+133)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp79;
fp79 = inteval->AB_z[vi] * src1[((hsi*150+133)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp78;
fp78 = src0[((hsi*210+193)*lowdim+lsi)*1] + fp79;
LIBINT2_REALTYPE fp76;
fp76 = fp78 - fp77;
target[((hsi*225+202)*lowdim+lsi)*1] = fp76;
LIBINT2_REALTYPE fp81;
fp81 = inteval->AB_y[vi] * src1[((hsi*150+133)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp80;
fp80 = src0[((hsi*210+183)*lowdim+lsi)*1] + fp81;
target[((hsi*225+201)*lowdim+lsi)*1] = fp80;
LIBINT2_REALTYPE fp83;
fp83 = 1.0000000000000000e+00 * src2[((hsi*150+132)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp85;
fp85 = inteval->AB_z[vi] * src1[((hsi*150+132)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp84;
fp84 = src0[((hsi*210+192)*lowdim+lsi)*1] + fp85;
LIBINT2_REALTYPE fp82;
fp82 = fp84 - fp83;
target[((hsi*225+200)*lowdim+lsi)*1] = fp82;
LIBINT2_REALTYPE fp87;
fp87 = 1.0000000000000000e+00 * src2[((hsi*150+131)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp89;
fp89 = inteval->AB_z[vi] * src1[((hsi*150+131)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp88;
fp88 = src0[((hsi*210+191)*lowdim+lsi)*1] + fp89;
LIBINT2_REALTYPE fp86;
fp86 = fp88 - fp87;
target[((hsi*225+199)*lowdim+lsi)*1] = fp86;
LIBINT2_REALTYPE fp91;
fp91 = inteval->AB_y[vi] * src1[((hsi*150+131)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp90;
fp90 = src0[((hsi*210+181)*lowdim+lsi)*1] + fp91;
target[((hsi*225+198)*lowdim+lsi)*1] = fp90;
LIBINT2_REALTYPE fp47;
fp47 = inteval->AB_y[vi] * src1[((hsi*150+140)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp46;
fp46 = src0[((hsi*210+190)*lowdim+lsi)*1] + fp47;
target[((hsi*225+211)*lowdim+lsi)*1] = fp46;
LIBINT2_REALTYPE fp287;
fp287 = 1.0000000000000000e+00 * src2[((hsi*150+91)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp289;
fp289 = inteval->AB_z[vi] * src1[((hsi*150+91)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp288;
fp288 = src0[((hsi*210+141)*lowdim+lsi)*1] + fp289;
LIBINT2_REALTYPE fp286;
fp286 = fp288 - fp287;
target[((hsi*225+139)*lowdim+lsi)*1] = fp286;
LIBINT2_REALTYPE fp291;
fp291 = inteval->AB_y[vi] * src1[((hsi*150+91)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp290;
fp290 = src0[((hsi*210+131)*lowdim+lsi)*1] + fp291;
target[((hsi*225+138)*lowdim+lsi)*1] = fp290;
LIBINT2_REALTYPE fp293;
fp293 = 1.0000000000000000e+00 * src2[((hsi*150+90)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp295;
fp295 = inteval->AB_z[vi] * src1[((hsi*150+90)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp294;
fp294 = src0[((hsi*210+140)*lowdim+lsi)*1] + fp295;
LIBINT2_REALTYPE fp292;
fp292 = fp294 - fp293;
target[((hsi*225+137)*lowdim+lsi)*1] = fp292;
LIBINT2_REALTYPE fp297;
fp297 = inteval->AB_y[vi] * src1[((hsi*150+90)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp296;
fp296 = src0[((hsi*210+130)*lowdim+lsi)*1] + fp297;
target[((hsi*225+136)*lowdim+lsi)*1] = fp296;
LIBINT2_REALTYPE fp299;
fp299 = inteval->AB_x[vi] * src1[((hsi*150+90)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp298;
fp298 = src0[((hsi*210+90)*lowdim+lsi)*1] + fp299;
target[((hsi*225+135)*lowdim+lsi)*1] = fp298;
LIBINT2_REALTYPE fp301;
fp301 = 1.0000000000000000e+00 * src2[((hsi*150+89)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp303;
fp303 = inteval->AB_z[vi] * src1[((hsi*150+89)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp302;
fp302 = src0[((hsi*210+139)*lowdim+lsi)*1] + fp303;
LIBINT2_REALTYPE fp300;
fp300 = fp302 - fp301;
target[((hsi*225+134)*lowdim+lsi)*1] = fp300;
LIBINT2_REALTYPE fp305;
fp305 = 1.0000000000000000e+00 * src2[((hsi*150+88)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp307;
fp307 = inteval->AB_z[vi] * src1[((hsi*150+88)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp306;
fp306 = src0[((hsi*210+138)*lowdim+lsi)*1] + fp307;
LIBINT2_REALTYPE fp304;
fp304 = fp306 - fp305;
target[((hsi*225+133)*lowdim+lsi)*1] = fp304;
LIBINT2_REALTYPE fp309;
fp309 = 1.0000000000000000e+00 * src2[((hsi*150+87)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp311;
fp311 = inteval->AB_z[vi] * src1[((hsi*150+87)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp310;
fp310 = src0[((hsi*210+137)*lowdim+lsi)*1] + fp311;
LIBINT2_REALTYPE fp308;
fp308 = fp310 - fp309;
target[((hsi*225+132)*lowdim+lsi)*1] = fp308;
LIBINT2_REALTYPE fp313;
fp313 = 1.0000000000000000e+00 * src2[((hsi*150+86)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp315;
fp315 = inteval->AB_z[vi] * src1[((hsi*150+86)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp314;
fp314 = src0[((hsi*210+136)*lowdim+lsi)*1] + fp315;
LIBINT2_REALTYPE fp312;
fp312 = fp314 - fp313;
target[((hsi*225+131)*lowdim+lsi)*1] = fp312;
LIBINT2_REALTYPE fp317;
fp317 = inteval->AB_y[vi] * src1[((hsi*150+86)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp316;
fp316 = src0[((hsi*210+126)*lowdim+lsi)*1] + fp317;
target[((hsi*225+130)*lowdim+lsi)*1] = fp316;
LIBINT2_REALTYPE fp319;
fp319 = 1.0000000000000000e+00 * src2[((hsi*150+85)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp321;
fp321 = inteval->AB_z[vi] * src1[((hsi*150+85)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp320;
fp320 = src0[((hsi*210+135)*lowdim+lsi)*1] + fp321;
LIBINT2_REALTYPE fp318;
fp318 = fp320 - fp319;
target[((hsi*225+129)*lowdim+lsi)*1] = fp318;
LIBINT2_REALTYPE fp323;
fp323 = 1.0000000000000000e+00 * src2[((hsi*150+84)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp325;
fp325 = inteval->AB_z[vi] * src1[((hsi*150+84)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp324;
fp324 = src0[((hsi*210+134)*lowdim+lsi)*1] + fp325;
LIBINT2_REALTYPE fp322;
fp322 = fp324 - fp323;
target[((hsi*225+128)*lowdim+lsi)*1] = fp322;
LIBINT2_REALTYPE fp327;
fp327 = 1.0000000000000000e+00 * src2[((hsi*150+83)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp329;
fp329 = inteval->AB_z[vi] * src1[((hsi*150+83)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp328;
fp328 = src0[((hsi*210+133)*lowdim+lsi)*1] + fp329;
LIBINT2_REALTYPE fp326;
fp326 = fp328 - fp327;
target[((hsi*225+127)*lowdim+lsi)*1] = fp326;
LIBINT2_REALTYPE fp187;
fp187 = 1.0000000000000000e+00 * src2[((hsi*150+111)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp189;
fp189 = inteval->AB_z[vi] * src1[((hsi*150+111)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp188;
fp188 = src0[((hsi*210+171)*lowdim+lsi)*1] + fp189;
LIBINT2_REALTYPE fp186;
fp186 = fp188 - fp187;
target[((hsi*225+169)*lowdim+lsi)*1] = fp186;
LIBINT2_REALTYPE fp333;
fp333 = 1.0000000000000000e+00 * src2[((hsi*150+82)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp335;
fp335 = inteval->AB_z[vi] * src1[((hsi*150+82)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp334;
fp334 = src0[((hsi*210+132)*lowdim+lsi)*1] + fp335;
LIBINT2_REALTYPE fp332;
fp332 = fp334 - fp333;
target[((hsi*225+125)*lowdim+lsi)*1] = fp332;
LIBINT2_REALTYPE fp337;
fp337 = 1.0000000000000000e+00 * src2[((hsi*150+81)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp339;
fp339 = inteval->AB_z[vi] * src1[((hsi*150+81)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp338;
fp338 = src0[((hsi*210+131)*lowdim+lsi)*1] + fp339;
LIBINT2_REALTYPE fp336;
fp336 = fp338 - fp337;
target[((hsi*225+124)*lowdim+lsi)*1] = fp336;
LIBINT2_REALTYPE fp341;
fp341 = inteval->AB_y[vi] * src1[((hsi*150+81)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp340;
fp340 = src0[((hsi*210+121)*lowdim+lsi)*1] + fp341;
target[((hsi*225+123)*lowdim+lsi)*1] = fp340;
LIBINT2_REALTYPE fp343;
fp343 = 1.0000000000000000e+00 * src2[((hsi*150+80)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp345;
fp345 = inteval->AB_z[vi] * src1[((hsi*150+80)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp344;
fp344 = src0[((hsi*210+130)*lowdim+lsi)*1] + fp345;
LIBINT2_REALTYPE fp342;
fp342 = fp344 - fp343;
target[((hsi*225+122)*lowdim+lsi)*1] = fp342;
LIBINT2_REALTYPE fp347;
fp347 = inteval->AB_y[vi] * src1[((hsi*150+80)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp346;
fp346 = src0[((hsi*210+120)*lowdim+lsi)*1] + fp347;
target[((hsi*225+121)*lowdim+lsi)*1] = fp346;
LIBINT2_REALTYPE fp349;
fp349 = inteval->AB_x[vi] * src1[((hsi*150+80)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp348;
fp348 = src0[((hsi*210+80)*lowdim+lsi)*1] + fp349;
target[((hsi*225+120)*lowdim+lsi)*1] = fp348;
LIBINT2_REALTYPE fp351;
fp351 = 1.0000000000000000e+00 * src2[((hsi*150+79)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp353;
fp353 = inteval->AB_z[vi] * src1[((hsi*150+79)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp352;
fp352 = src0[((hsi*210+129)*lowdim+lsi)*1] + fp353;
LIBINT2_REALTYPE fp350;
fp350 = fp352 - fp351;
target[((hsi*225+119)*lowdim+lsi)*1] = fp350;
LIBINT2_REALTYPE fp355;
fp355 = 1.0000000000000000e+00 * src2[((hsi*150+78)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp357;
fp357 = inteval->AB_z[vi] * src1[((hsi*150+78)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp356;
fp356 = src0[((hsi*210+128)*lowdim+lsi)*1] + fp357;
LIBINT2_REALTYPE fp354;
fp354 = fp356 - fp355;
target[((hsi*225+118)*lowdim+lsi)*1] = fp354;
LIBINT2_REALTYPE fp359;
fp359 = 1.0000000000000000e+00 * src2[((hsi*150+77)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp361;
fp361 = inteval->AB_z[vi] * src1[((hsi*150+77)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp360;
fp360 = src0[((hsi*210+127)*lowdim+lsi)*1] + fp361;
LIBINT2_REALTYPE fp358;
fp358 = fp360 - fp359;
target[((hsi*225+117)*lowdim+lsi)*1] = fp358;
LIBINT2_REALTYPE fp363;
fp363 = 1.0000000000000000e+00 * src2[((hsi*150+76)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp365;
fp365 = inteval->AB_z[vi] * src1[((hsi*150+76)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp364;
fp364 = src0[((hsi*210+126)*lowdim+lsi)*1] + fp365;
LIBINT2_REALTYPE fp362;
fp362 = fp364 - fp363;
target[((hsi*225+116)*lowdim+lsi)*1] = fp362;
LIBINT2_REALTYPE fp367;
fp367 = inteval->AB_y[vi] * src1[((hsi*150+76)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp366;
fp366 = src0[((hsi*210+116)*lowdim+lsi)*1] + fp367;
target[((hsi*225+115)*lowdim+lsi)*1] = fp366;
LIBINT2_REALTYPE fp369;
fp369 = 1.0000000000000000e+00 * src2[((hsi*150+75)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp371;
fp371 = inteval->AB_z[vi] * src1[((hsi*150+75)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp370;
fp370 = src0[((hsi*210+125)*lowdim+lsi)*1] + fp371;
LIBINT2_REALTYPE fp368;
fp368 = fp370 - fp369;
target[((hsi*225+114)*lowdim+lsi)*1] = fp368;
LIBINT2_REALTYPE fp373;
fp373 = 1.0000000000000000e+00 * src2[((hsi*150+74)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp375;
fp375 = inteval->AB_z[vi] * src1[((hsi*150+74)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp374;
fp374 = src0[((hsi*210+124)*lowdim+lsi)*1] + fp375;
LIBINT2_REALTYPE fp372;
fp372 = fp374 - fp373;
target[((hsi*225+113)*lowdim+lsi)*1] = fp372;
LIBINT2_REALTYPE fp331;
fp331 = inteval->AB_y[vi] * src1[((hsi*150+83)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp330;
fp330 = src0[((hsi*210+123)*lowdim+lsi)*1] + fp331;
target[((hsi*225+126)*lowdim+lsi)*1] = fp330;
LIBINT2_REALTYPE fp191;
fp191 = inteval->AB_y[vi] * src1[((hsi*150+111)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp190;
fp190 = src0[((hsi*210+161)*lowdim+lsi)*1] + fp191;
target[((hsi*225+168)*lowdim+lsi)*1] = fp190;
LIBINT2_REALTYPE fp193;
fp193 = 1.0000000000000000e+00 * src2[((hsi*150+110)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp195;
fp195 = inteval->AB_z[vi] * src1[((hsi*150+110)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp194;
fp194 = src0[((hsi*210+170)*lowdim+lsi)*1] + fp195;
LIBINT2_REALTYPE fp192;
fp192 = fp194 - fp193;
target[((hsi*225+167)*lowdim+lsi)*1] = fp192;
LIBINT2_REALTYPE fp197;
fp197 = inteval->AB_y[vi] * src1[((hsi*150+110)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp196;
fp196 = src0[((hsi*210+160)*lowdim+lsi)*1] + fp197;
target[((hsi*225+166)*lowdim+lsi)*1] = fp196;
LIBINT2_REALTYPE fp199;
fp199 = inteval->AB_x[vi] * src1[((hsi*150+110)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp198;
fp198 = src0[((hsi*210+110)*lowdim+lsi)*1] + fp199;
target[((hsi*225+165)*lowdim+lsi)*1] = fp198;
LIBINT2_REALTYPE fp201;
fp201 = 1.0000000000000000e+00 * src2[((hsi*150+109)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp203;
fp203 = inteval->AB_z[vi] * src1[((hsi*150+109)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp202;
fp202 = src0[((hsi*210+169)*lowdim+lsi)*1] + fp203;
LIBINT2_REALTYPE fp200;
fp200 = fp202 - fp201;
target[((hsi*225+164)*lowdim+lsi)*1] = fp200;
LIBINT2_REALTYPE fp205;
fp205 = 1.0000000000000000e+00 * src2[((hsi*150+108)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp207;
fp207 = inteval->AB_z[vi] * src1[((hsi*150+108)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp206;
fp206 = src0[((hsi*210+168)*lowdim+lsi)*1] + fp207;
LIBINT2_REALTYPE fp204;
fp204 = fp206 - fp205;
target[((hsi*225+163)*lowdim+lsi)*1] = fp204;
LIBINT2_REALTYPE fp209;
fp209 = 1.0000000000000000e+00 * src2[((hsi*150+107)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp211;
fp211 = inteval->AB_z[vi] * src1[((hsi*150+107)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp210;
fp210 = src0[((hsi*210+167)*lowdim+lsi)*1] + fp211;
LIBINT2_REALTYPE fp208;
fp208 = fp210 - fp209;
target[((hsi*225+162)*lowdim+lsi)*1] = fp208;
LIBINT2_REALTYPE fp213;
fp213 = 1.0000000000000000e+00 * src2[((hsi*150+106)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp215;
fp215 = inteval->AB_z[vi] * src1[((hsi*150+106)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp214;
fp214 = src0[((hsi*210+166)*lowdim+lsi)*1] + fp215;
LIBINT2_REALTYPE fp212;
fp212 = fp214 - fp213;
target[((hsi*225+161)*lowdim+lsi)*1] = fp212;
LIBINT2_REALTYPE fp217;
fp217 = inteval->AB_y[vi] * src1[((hsi*150+106)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp216;
fp216 = src0[((hsi*210+156)*lowdim+lsi)*1] + fp217;
target[((hsi*225+160)*lowdim+lsi)*1] = fp216;
LIBINT2_REALTYPE fp219;
fp219 = 1.0000000000000000e+00 * src2[((hsi*150+105)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp221;
fp221 = inteval->AB_z[vi] * src1[((hsi*150+105)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp220;
fp220 = src0[((hsi*210+165)*lowdim+lsi)*1] + fp221;
LIBINT2_REALTYPE fp218;
fp218 = fp220 - fp219;
target[((hsi*225+159)*lowdim+lsi)*1] = fp218;
LIBINT2_REALTYPE fp223;
fp223 = 1.0000000000000000e+00 * src2[((hsi*150+104)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp225;
fp225 = inteval->AB_z[vi] * src1[((hsi*150+104)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp224;
fp224 = src0[((hsi*210+164)*lowdim+lsi)*1] + fp225;
LIBINT2_REALTYPE fp222;
fp222 = fp224 - fp223;
target[((hsi*225+158)*lowdim+lsi)*1] = fp222;
LIBINT2_REALTYPE fp227;
fp227 = 1.0000000000000000e+00 * src2[((hsi*150+103)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp229;
fp229 = inteval->AB_z[vi] * src1[((hsi*150+103)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp228;
fp228 = src0[((hsi*210+163)*lowdim+lsi)*1] + fp229;
LIBINT2_REALTYPE fp226;
fp226 = fp228 - fp227;
target[((hsi*225+157)*lowdim+lsi)*1] = fp226;
LIBINT2_REALTYPE fp231;
fp231 = inteval->AB_y[vi] * src1[((hsi*150+103)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp230;
fp230 = src0[((hsi*210+153)*lowdim+lsi)*1] + fp231;
target[((hsi*225+156)*lowdim+lsi)*1] = fp230;
LIBINT2_REALTYPE fp283;
fp283 = 1.0000000000000000e+00 * src2[((hsi*150+92)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp285;
fp285 = inteval->AB_z[vi] * src1[((hsi*150+92)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp284;
fp284 = src0[((hsi*210+142)*lowdim+lsi)*1] + fp285;
LIBINT2_REALTYPE fp282;
fp282 = fp284 - fp283;
target[((hsi*225+140)*lowdim+lsi)*1] = fp282;
LIBINT2_REALTYPE fp237;
fp237 = 1.0000000000000000e+00 * src2[((hsi*150+101)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp239;
fp239 = inteval->AB_z[vi] * src1[((hsi*150+101)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp238;
fp238 = src0[((hsi*210+161)*lowdim+lsi)*1] + fp239;
LIBINT2_REALTYPE fp236;
fp236 = fp238 - fp237;
target[((hsi*225+154)*lowdim+lsi)*1] = fp236;
LIBINT2_REALTYPE fp241;
fp241 = inteval->AB_y[vi] * src1[((hsi*150+101)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp240;
fp240 = src0[((hsi*210+151)*lowdim+lsi)*1] + fp241;
target[((hsi*225+153)*lowdim+lsi)*1] = fp240;
LIBINT2_REALTYPE fp243;
fp243 = 1.0000000000000000e+00 * src2[((hsi*150+100)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp245;
fp245 = inteval->AB_z[vi] * src1[((hsi*150+100)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp244;
fp244 = src0[((hsi*210+160)*lowdim+lsi)*1] + fp245;
LIBINT2_REALTYPE fp242;
fp242 = fp244 - fp243;
target[((hsi*225+152)*lowdim+lsi)*1] = fp242;
LIBINT2_REALTYPE fp247;
fp247 = inteval->AB_y[vi] * src1[((hsi*150+100)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp246;
fp246 = src0[((hsi*210+150)*lowdim+lsi)*1] + fp247;
target[((hsi*225+151)*lowdim+lsi)*1] = fp246;
LIBINT2_REALTYPE fp249;
fp249 = inteval->AB_x[vi] * src1[((hsi*150+100)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp248;
fp248 = src0[((hsi*210+100)*lowdim+lsi)*1] + fp249;
target[((hsi*225+150)*lowdim+lsi)*1] = fp248;
LIBINT2_REALTYPE fp251;
fp251 = 1.0000000000000000e+00 * src2[((hsi*150+99)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp253;
fp253 = inteval->AB_z[vi] * src1[((hsi*150+99)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp252;
fp252 = src0[((hsi*210+149)*lowdim+lsi)*1] + fp253;
LIBINT2_REALTYPE fp250;
fp250 = fp252 - fp251;
target[((hsi*225+149)*lowdim+lsi)*1] = fp250;
LIBINT2_REALTYPE fp255;
fp255 = 1.0000000000000000e+00 * src2[((hsi*150+98)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp257;
fp257 = inteval->AB_z[vi] * src1[((hsi*150+98)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp256;
fp256 = src0[((hsi*210+148)*lowdim+lsi)*1] + fp257;
LIBINT2_REALTYPE fp254;
fp254 = fp256 - fp255;
target[((hsi*225+148)*lowdim+lsi)*1] = fp254;
LIBINT2_REALTYPE fp259;
fp259 = 1.0000000000000000e+00 * src2[((hsi*150+97)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp261;
fp261 = inteval->AB_z[vi] * src1[((hsi*150+97)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp260;
fp260 = src0[((hsi*210+147)*lowdim+lsi)*1] + fp261;
LIBINT2_REALTYPE fp258;
fp258 = fp260 - fp259;
target[((hsi*225+147)*lowdim+lsi)*1] = fp258;
LIBINT2_REALTYPE fp263;
fp263 = 1.0000000000000000e+00 * src2[((hsi*150+96)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp265;
fp265 = inteval->AB_z[vi] * src1[((hsi*150+96)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp264;
fp264 = src0[((hsi*210+146)*lowdim+lsi)*1] + fp265;
LIBINT2_REALTYPE fp262;
fp262 = fp264 - fp263;
target[((hsi*225+146)*lowdim+lsi)*1] = fp262;
LIBINT2_REALTYPE fp267;
fp267 = inteval->AB_y[vi] * src1[((hsi*150+96)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp266;
fp266 = src0[((hsi*210+136)*lowdim+lsi)*1] + fp267;
target[((hsi*225+145)*lowdim+lsi)*1] = fp266;
LIBINT2_REALTYPE fp269;
fp269 = 1.0000000000000000e+00 * src2[((hsi*150+95)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp271;
fp271 = inteval->AB_z[vi] * src1[((hsi*150+95)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp270;
fp270 = src0[((hsi*210+145)*lowdim+lsi)*1] + fp271;
LIBINT2_REALTYPE fp268;
fp268 = fp270 - fp269;
target[((hsi*225+144)*lowdim+lsi)*1] = fp268;
LIBINT2_REALTYPE fp273;
fp273 = 1.0000000000000000e+00 * src2[((hsi*150+94)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp275;
fp275 = inteval->AB_z[vi] * src1[((hsi*150+94)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp274;
fp274 = src0[((hsi*210+144)*lowdim+lsi)*1] + fp275;
LIBINT2_REALTYPE fp272;
fp272 = fp274 - fp273;
target[((hsi*225+143)*lowdim+lsi)*1] = fp272;
LIBINT2_REALTYPE fp277;
fp277 = 1.0000000000000000e+00 * src2[((hsi*150+93)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp279;
fp279 = inteval->AB_z[vi] * src1[((hsi*150+93)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp278;
fp278 = src0[((hsi*210+143)*lowdim+lsi)*1] + fp279;
LIBINT2_REALTYPE fp276;
fp276 = fp278 - fp277;
target[((hsi*225+142)*lowdim+lsi)*1] = fp276;
LIBINT2_REALTYPE fp281;
fp281 = inteval->AB_y[vi] * src1[((hsi*150+93)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp280;
fp280 = src0[((hsi*210+133)*lowdim+lsi)*1] + fp281;
target[((hsi*225+141)*lowdim+lsi)*1] = fp280;
LIBINT2_REALTYPE fp233;
fp233 = 1.0000000000000000e+00 * src2[((hsi*150+102)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp235;
fp235 = inteval->AB_z[vi] * src1[((hsi*150+102)*lowdim+lsi)*1];
LIBINT2_REALTYPE fp234;
fp234 = src0[((hsi*210+162)*lowdim+lsi)*1] + fp235;
LIBINT2_REALTYPE fp232;
fp232 = fp234 - fp233;
target[((hsi*225+155)*lowdim+lsi)*1] = fp232;
}
}
}
const int hsi = 0;
const int lsi = 0;
const int vi = 0;
/** Number of flops = 750 */
}

#ifdef __cplusplus
};
#endif
