/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <libint2.h>

#ifdef __cplusplus
extern "C" {
#endif
void CR_aB_d__0___Kinetic_d__0___Ab__up_(const Libint_t* inteval, LIBINT2_REALTYPE* target, const LIBINT2_REALTYPE* src0, const LIBINT2_REALTYPE* src1, const LIBINT2_REALTYPE* src2) {

LIBINT2_REALTYPE*const  stack = target;
{
const int hsi = 0;
{
const int lsi = 0;
{
const int vi = 0;
LIBINT2_REALTYPE fp18;
fp18 = 1.0000000000000000e+00 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp121;
fp121 = 1.0000000000000000e+00 * inteval->two_alpha0_bra[vi];
LIBINT2_REALTYPE fp20;
fp20 = fp121 * src2[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp105;
fp105 = 5.0000000000000000e-01 * inteval->two_alpha0_ket[vi];
LIBINT2_REALTYPE fp22;
fp22 = fp105 * src2[((hsi*16+3)*1+lsi)*1];
LIBINT2_REALTYPE fp127;
fp127 = 5.0000000000000000e-01 * inteval->two_alpha0_bra[vi];
LIBINT2_REALTYPE fp126;
fp126 = fp127 * inteval->two_alpha0_ket[vi];
LIBINT2_REALTYPE fp23;
fp23 = fp126 * src2[((hsi*16+11)*1+lsi)*1];
LIBINT2_REALTYPE fp21;
fp21 = fp23 - fp22;
LIBINT2_REALTYPE fp19;
fp19 = fp21 - fp20;
LIBINT2_REALTYPE fp17;
fp17 = fp19 + fp18;
LIBINT2_REALTYPE fp274;
fp274 = src0[((hsi*16+4)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp273;
fp273 = fp274 * fp17;
LIBINT2_REALTYPE fp81;
fp81 = fp126 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp277;
fp277 = src0[((hsi*16+4)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp276;
fp276 = fp277 * src2[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp90;
fp90 = fp105 * src0[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp91;
fp91 = fp126 * src0[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp89;
fp89 = fp91 - fp90;
LIBINT2_REALTYPE fp279;
fp279 = fp89 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp278;
fp278 = fp279 * src2[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp275;
fp275 = fp278 + fp276;
LIBINT2_REALTYPE fp272;
fp272 = fp275 + fp273;
target[((hsi*36+17)*1+lsi)*1] = fp272;
LIBINT2_REALTYPE fp25;
fp25 = 5.0000000000000000e-01 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp27;
fp27 = fp127 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp29;
fp29 = fp105 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp30;
fp30 = fp126 * src2[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp28;
fp28 = fp30 - fp29;
LIBINT2_REALTYPE fp26;
fp26 = fp28 - fp27;
LIBINT2_REALTYPE fp24;
fp24 = fp26 + fp25;
LIBINT2_REALTYPE fp282;
fp282 = src0[((hsi*16+4)*1+lsi)*1] * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp281;
fp281 = fp282 * fp24;
LIBINT2_REALTYPE fp79;
fp79 = fp127 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp80;
fp80 = fp126 * src1[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp78;
fp78 = fp80 - fp79;
LIBINT2_REALTYPE fp285;
fp285 = src0[((hsi*16+4)*1+lsi)*1] * fp78;
LIBINT2_REALTYPE fp284;
fp284 = fp285 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp287;
fp287 = fp89 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp286;
fp286 = fp287 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp283;
fp283 = fp286 + fp284;
LIBINT2_REALTYPE fp280;
fp280 = fp283 + fp281;
target[((hsi*36+16)*1+lsi)*1] = fp280;
LIBINT2_REALTYPE fp32;
fp32 = fp105 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp33;
fp33 = fp126 * src2[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp31;
fp31 = fp33 - fp32;
LIBINT2_REALTYPE fp290;
fp290 = src0[((hsi*16+4)*1+lsi)*1] * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp289;
fp289 = fp290 * fp31;
LIBINT2_REALTYPE fp76;
fp76 = fp121 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp77;
fp77 = fp126 * src1[((hsi*16+7)*1+lsi)*1];
LIBINT2_REALTYPE fp75;
fp75 = fp77 - fp76;
LIBINT2_REALTYPE fp293;
fp293 = src0[((hsi*16+4)*1+lsi)*1] * fp75;
LIBINT2_REALTYPE fp292;
fp292 = fp293 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp295;
fp295 = fp89 * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp294;
fp294 = fp295 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp291;
fp291 = fp294 + fp292;
LIBINT2_REALTYPE fp288;
fp288 = fp291 + fp289;
target[((hsi*36+15)*1+lsi)*1] = fp288;
LIBINT2_REALTYPE fp298;
fp298 = src0[((hsi*16+5)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp297;
fp297 = fp298 * fp24;
LIBINT2_REALTYPE fp301;
fp301 = src0[((hsi*16+5)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp300;
fp300 = fp301 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp93;
fp93 = 5.0000000000000000e-01 * src0[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp95;
fp95 = fp127 * src0[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp97;
fp97 = fp105 * src0[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp98;
fp98 = fp126 * src0[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp96;
fp96 = fp98 - fp97;
LIBINT2_REALTYPE fp94;
fp94 = fp96 - fp95;
LIBINT2_REALTYPE fp92;
fp92 = fp94 + fp93;
LIBINT2_REALTYPE fp303;
fp303 = fp92 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp302;
fp302 = fp303 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp299;
fp299 = fp302 + fp300;
LIBINT2_REALTYPE fp296;
fp296 = fp299 + fp297;
target[((hsi*36+14)*1+lsi)*1] = fp296;
LIBINT2_REALTYPE fp306;
fp306 = src0[((hsi*16+5)*1+lsi)*1] * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp305;
fp305 = fp306 * fp31;
LIBINT2_REALTYPE fp309;
fp309 = src0[((hsi*16+5)*1+lsi)*1] * fp78;
LIBINT2_REALTYPE fp308;
fp308 = fp309 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp311;
fp311 = fp92 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp310;
fp310 = fp311 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp307;
fp307 = fp310 + fp308;
LIBINT2_REALTYPE fp304;
fp304 = fp307 + fp305;
target[((hsi*36+13)*1+lsi)*1] = fp304;
LIBINT2_REALTYPE fp314;
fp314 = src0[((hsi*16+6)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp313;
fp313 = fp314 * fp31;
LIBINT2_REALTYPE fp317;
fp317 = src0[((hsi*16+6)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp316;
fp316 = fp317 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp100;
fp100 = 1.0000000000000000e+00 * src0[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp102;
fp102 = fp121 * src0[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp104;
fp104 = fp105 * src0[((hsi*16+3)*1+lsi)*1];
LIBINT2_REALTYPE fp106;
fp106 = fp126 * src0[((hsi*16+11)*1+lsi)*1];
LIBINT2_REALTYPE fp103;
fp103 = fp106 - fp104;
LIBINT2_REALTYPE fp101;
fp101 = fp103 - fp102;
LIBINT2_REALTYPE fp99;
fp99 = fp101 + fp100;
LIBINT2_REALTYPE fp319;
fp319 = fp99 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp318;
fp318 = fp319 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp315;
fp315 = fp318 + fp316;
LIBINT2_REALTYPE fp312;
fp312 = fp315 + fp313;
target[((hsi*36+12)*1+lsi)*1] = fp312;
LIBINT2_REALTYPE fp35;
fp35 = fp121 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp36;
fp36 = fp126 * src2[((hsi*16+7)*1+lsi)*1];
LIBINT2_REALTYPE fp34;
fp34 = fp36 - fp35;
LIBINT2_REALTYPE fp322;
fp322 = src0[((hsi*16+4)*1+lsi)*1] * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp321;
fp321 = fp322 * fp34;
LIBINT2_REALTYPE fp73;
fp73 = fp105 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp74;
fp74 = fp126 * src1[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp72;
fp72 = fp74 - fp73;
LIBINT2_REALTYPE fp325;
fp325 = src0[((hsi*16+4)*1+lsi)*1] * fp72;
LIBINT2_REALTYPE fp324;
fp324 = fp325 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp327;
fp327 = fp89 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp326;
fp326 = fp327 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp323;
fp323 = fp326 + fp324;
LIBINT2_REALTYPE fp320;
fp320 = fp323 + fp321;
target[((hsi*36+11)*1+lsi)*1] = fp320;
LIBINT2_REALTYPE fp38;
fp38 = fp127 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp39;
fp39 = fp126 * src2[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp37;
fp37 = fp39 - fp38;
LIBINT2_REALTYPE fp330;
fp330 = src0[((hsi*16+4)*1+lsi)*1] * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp329;
fp329 = fp330 * fp37;
LIBINT2_REALTYPE fp66;
fp66 = 5.0000000000000000e-01 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp68;
fp68 = fp127 * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp70;
fp70 = fp105 * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp71;
fp71 = fp126 * src1[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp69;
fp69 = fp71 - fp70;
LIBINT2_REALTYPE fp67;
fp67 = fp69 - fp68;
LIBINT2_REALTYPE fp65;
fp65 = fp67 + fp66;
LIBINT2_REALTYPE fp333;
fp333 = src0[((hsi*16+4)*1+lsi)*1] * fp65;
LIBINT2_REALTYPE fp332;
fp332 = fp333 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp335;
fp335 = fp89 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp334;
fp334 = fp335 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp331;
fp331 = fp334 + fp332;
LIBINT2_REALTYPE fp328;
fp328 = fp331 + fp329;
target[((hsi*36+10)*1+lsi)*1] = fp328;
LIBINT2_REALTYPE fp40;
fp40 = fp126 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp410;
fp410 = src0[((hsi*16+10)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp409;
fp409 = fp410 * fp40;
LIBINT2_REALTYPE fp413;
fp413 = src0[((hsi*16+10)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp412;
fp412 = fp413 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp118;
fp118 = 2.0000000000000000e+00 * src0[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp120;
fp120 = fp121 * src0[((hsi*16+13)*1+lsi)*1];
LIBINT2_REALTYPE fp124;
fp124 = 1.0000000000000000e+00 * inteval->two_alpha0_ket[vi];
LIBINT2_REALTYPE fp123;
fp123 = fp124 * src0[((hsi*16+7)*1+lsi)*1];
LIBINT2_REALTYPE fp125;
fp125 = fp126 * src0[((hsi*16+15)*1+lsi)*1];
LIBINT2_REALTYPE fp122;
fp122 = fp125 - fp123;
LIBINT2_REALTYPE fp119;
fp119 = fp122 - fp120;
LIBINT2_REALTYPE fp117;
fp117 = fp119 + fp118;
LIBINT2_REALTYPE fp415;
fp415 = fp117 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp414;
fp414 = fp415 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp411;
fp411 = fp414 + fp412;
LIBINT2_REALTYPE fp408;
fp408 = fp411 + fp409;
target[((hsi*36+0)*1+lsi)*1] = fp408;
LIBINT2_REALTYPE fp346;
fp346 = src0[((hsi*16+5)*1+lsi)*1] * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp345;
fp345 = fp346 * fp37;
LIBINT2_REALTYPE fp349;
fp349 = src0[((hsi*16+5)*1+lsi)*1] * fp72;
LIBINT2_REALTYPE fp348;
fp348 = fp349 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp351;
fp351 = fp92 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp350;
fp350 = fp351 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp347;
fp347 = fp350 + fp348;
LIBINT2_REALTYPE fp344;
fp344 = fp347 + fp345;
target[((hsi*36+8)*1+lsi)*1] = fp344;
LIBINT2_REALTYPE fp354;
fp354 = src0[((hsi*16+5)*1+lsi)*1] * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp353;
fp353 = fp354 * fp40;
LIBINT2_REALTYPE fp357;
fp357 = src0[((hsi*16+5)*1+lsi)*1] * fp65;
LIBINT2_REALTYPE fp356;
fp356 = fp357 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp359;
fp359 = fp92 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp358;
fp358 = fp359 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp355;
fp355 = fp358 + fp356;
LIBINT2_REALTYPE fp352;
fp352 = fp355 + fp353;
target[((hsi*36+7)*1+lsi)*1] = fp352;
LIBINT2_REALTYPE fp362;
fp362 = src0[((hsi*16+6)*1+lsi)*1] * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp361;
fp361 = fp362 * fp40;
LIBINT2_REALTYPE fp365;
fp365 = src0[((hsi*16+6)*1+lsi)*1] * fp72;
LIBINT2_REALTYPE fp364;
fp364 = fp365 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp367;
fp367 = fp99 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp366;
fp366 = fp367 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp363;
fp363 = fp366 + fp364;
LIBINT2_REALTYPE fp360;
fp360 = fp363 + fp361;
target[((hsi*36+6)*1+lsi)*1] = fp360;
LIBINT2_REALTYPE fp370;
fp370 = src0[((hsi*16+8)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp369;
fp369 = fp370 * fp34;
LIBINT2_REALTYPE fp373;
fp373 = src0[((hsi*16+8)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp372;
fp372 = fp373 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp108;
fp108 = fp124 * src0[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp109;
fp109 = fp126 * src0[((hsi*16+13)*1+lsi)*1];
LIBINT2_REALTYPE fp107;
fp107 = fp109 - fp108;
LIBINT2_REALTYPE fp375;
fp375 = fp107 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp374;
fp374 = fp375 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp371;
fp371 = fp374 + fp372;
LIBINT2_REALTYPE fp368;
fp368 = fp371 + fp369;
target[((hsi*36+5)*1+lsi)*1] = fp368;
LIBINT2_REALTYPE fp378;
fp378 = src0[((hsi*16+8)*1+lsi)*1] * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp377;
fp377 = fp378 * fp37;
LIBINT2_REALTYPE fp381;
fp381 = src0[((hsi*16+8)*1+lsi)*1] * fp78;
LIBINT2_REALTYPE fp380;
fp380 = fp381 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp383;
fp383 = fp107 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp382;
fp382 = fp383 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp379;
fp379 = fp382 + fp380;
LIBINT2_REALTYPE fp376;
fp376 = fp379 + fp377;
target[((hsi*36+4)*1+lsi)*1] = fp376;
LIBINT2_REALTYPE fp386;
fp386 = src0[((hsi*16+8)*1+lsi)*1] * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp385;
fp385 = fp386 * fp40;
LIBINT2_REALTYPE fp389;
fp389 = src0[((hsi*16+8)*1+lsi)*1] * fp75;
LIBINT2_REALTYPE fp388;
fp388 = fp389 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp391;
fp391 = fp107 * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp390;
fp390 = fp391 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp387;
fp387 = fp390 + fp388;
LIBINT2_REALTYPE fp384;
fp384 = fp387 + fp385;
target[((hsi*36+3)*1+lsi)*1] = fp384;
LIBINT2_REALTYPE fp394;
fp394 = src0[((hsi*16+9)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp393;
fp393 = fp394 * fp37;
LIBINT2_REALTYPE fp397;
fp397 = src0[((hsi*16+9)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp396;
fp396 = fp397 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp111;
fp111 = 1.0000000000000000e+00 * src0[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp113;
fp113 = fp127 * src0[((hsi*16+12)*1+lsi)*1];
LIBINT2_REALTYPE fp115;
fp115 = fp124 * src0[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp116;
fp116 = fp126 * src0[((hsi*16+14)*1+lsi)*1];
LIBINT2_REALTYPE fp114;
fp114 = fp116 - fp115;
LIBINT2_REALTYPE fp112;
fp112 = fp114 - fp113;
LIBINT2_REALTYPE fp110;
fp110 = fp112 + fp111;
LIBINT2_REALTYPE fp399;
fp399 = fp110 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp398;
fp398 = fp399 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp395;
fp395 = fp398 + fp396;
LIBINT2_REALTYPE fp392;
fp392 = fp395 + fp393;
target[((hsi*36+2)*1+lsi)*1] = fp392;
LIBINT2_REALTYPE fp402;
fp402 = src0[((hsi*16+9)*1+lsi)*1] * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp401;
fp401 = fp402 * fp40;
LIBINT2_REALTYPE fp405;
fp405 = src0[((hsi*16+9)*1+lsi)*1] * fp78;
LIBINT2_REALTYPE fp404;
fp404 = fp405 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp407;
fp407 = fp110 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp406;
fp406 = fp407 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp403;
fp403 = fp406 + fp404;
LIBINT2_REALTYPE fp400;
fp400 = fp403 + fp401;
target[((hsi*36+1)*1+lsi)*1] = fp400;
LIBINT2_REALTYPE fp338;
fp338 = src0[((hsi*16+4)*1+lsi)*1] * src1[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp337;
fp337 = fp338 * fp40;
LIBINT2_REALTYPE fp59;
fp59 = 1.0000000000000000e+00 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp61;
fp61 = fp121 * src1[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp63;
fp63 = fp105 * src1[((hsi*16+3)*1+lsi)*1];
LIBINT2_REALTYPE fp64;
fp64 = fp126 * src1[((hsi*16+11)*1+lsi)*1];
LIBINT2_REALTYPE fp62;
fp62 = fp64 - fp63;
LIBINT2_REALTYPE fp60;
fp60 = fp62 - fp61;
LIBINT2_REALTYPE fp58;
fp58 = fp60 + fp59;
LIBINT2_REALTYPE fp341;
fp341 = src0[((hsi*16+4)*1+lsi)*1] * fp58;
LIBINT2_REALTYPE fp340;
fp340 = fp341 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp343;
fp343 = fp89 * src1[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp342;
fp342 = fp343 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp339;
fp339 = fp342 + fp340;
LIBINT2_REALTYPE fp336;
fp336 = fp339 + fp337;
target[((hsi*36+9)*1+lsi)*1] = fp336;
LIBINT2_REALTYPE fp1;
fp1 = 2.0000000000000000e+00 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp3;
fp3 = fp121 * src2[((hsi*16+13)*1+lsi)*1];
LIBINT2_REALTYPE fp5;
fp5 = fp124 * src2[((hsi*16+7)*1+lsi)*1];
LIBINT2_REALTYPE fp6;
fp6 = fp126 * src2[((hsi*16+15)*1+lsi)*1];
LIBINT2_REALTYPE fp4;
fp4 = fp6 - fp5;
LIBINT2_REALTYPE fp2;
fp2 = fp4 - fp3;
LIBINT2_REALTYPE fp0;
fp0 = fp2 + fp1;
LIBINT2_REALTYPE fp130;
fp130 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp129;
fp129 = fp130 * fp0;
LIBINT2_REALTYPE fp133;
fp133 = src0[((hsi*16+0)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp132;
fp132 = fp133 * src2[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp82;
fp82 = fp126 * src0[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp135;
fp135 = fp82 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp134;
fp134 = fp135 * src2[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp131;
fp131 = fp134 + fp132;
LIBINT2_REALTYPE fp128;
fp128 = fp131 + fp129;
target[((hsi*36+35)*1+lsi)*1] = fp128;
LIBINT2_REALTYPE fp8;
fp8 = 1.0000000000000000e+00 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp10;
fp10 = fp127 * src2[((hsi*16+12)*1+lsi)*1];
LIBINT2_REALTYPE fp12;
fp12 = fp124 * src2[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp13;
fp13 = fp126 * src2[((hsi*16+14)*1+lsi)*1];
LIBINT2_REALTYPE fp11;
fp11 = fp13 - fp12;
LIBINT2_REALTYPE fp9;
fp9 = fp11 - fp10;
LIBINT2_REALTYPE fp7;
fp7 = fp9 + fp8;
LIBINT2_REALTYPE fp138;
fp138 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp137;
fp137 = fp138 * fp7;
LIBINT2_REALTYPE fp141;
fp141 = src0[((hsi*16+0)*1+lsi)*1] * fp78;
LIBINT2_REALTYPE fp140;
fp140 = fp141 * src2[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp143;
fp143 = fp82 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp142;
fp142 = fp143 * src2[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp139;
fp139 = fp142 + fp140;
LIBINT2_REALTYPE fp136;
fp136 = fp139 + fp137;
target[((hsi*36+34)*1+lsi)*1] = fp136;
LIBINT2_REALTYPE fp15;
fp15 = fp124 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp16;
fp16 = fp126 * src2[((hsi*16+13)*1+lsi)*1];
LIBINT2_REALTYPE fp14;
fp14 = fp16 - fp15;
LIBINT2_REALTYPE fp146;
fp146 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp145;
fp145 = fp146 * fp14;
LIBINT2_REALTYPE fp149;
fp149 = src0[((hsi*16+0)*1+lsi)*1] * fp75;
LIBINT2_REALTYPE fp148;
fp148 = fp149 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp151;
fp151 = fp82 * src1[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp150;
fp150 = fp151 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp147;
fp147 = fp150 + fp148;
LIBINT2_REALTYPE fp144;
fp144 = fp147 + fp145;
target[((hsi*36+33)*1+lsi)*1] = fp144;
LIBINT2_REALTYPE fp154;
fp154 = src0[((hsi*16+1)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp153;
fp153 = fp154 * fp7;
LIBINT2_REALTYPE fp157;
fp157 = src0[((hsi*16+1)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp156;
fp156 = fp157 * src2[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp84;
fp84 = fp127 * src0[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp85;
fp85 = fp126 * src0[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp83;
fp83 = fp85 - fp84;
LIBINT2_REALTYPE fp159;
fp159 = fp83 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp158;
fp158 = fp159 * src2[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp155;
fp155 = fp158 + fp156;
LIBINT2_REALTYPE fp152;
fp152 = fp155 + fp153;
target[((hsi*36+32)*1+lsi)*1] = fp152;
LIBINT2_REALTYPE fp162;
fp162 = src0[((hsi*16+1)*1+lsi)*1] * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp161;
fp161 = fp162 * fp14;
LIBINT2_REALTYPE fp165;
fp165 = src0[((hsi*16+1)*1+lsi)*1] * fp78;
LIBINT2_REALTYPE fp164;
fp164 = fp165 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp167;
fp167 = fp83 * src1[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp166;
fp166 = fp167 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp163;
fp163 = fp166 + fp164;
LIBINT2_REALTYPE fp160;
fp160 = fp163 + fp161;
target[((hsi*36+31)*1+lsi)*1] = fp160;
LIBINT2_REALTYPE fp170;
fp170 = src0[((hsi*16+2)*1+lsi)*1] * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp169;
fp169 = fp170 * fp14;
LIBINT2_REALTYPE fp173;
fp173 = src0[((hsi*16+2)*1+lsi)*1] * fp81;
LIBINT2_REALTYPE fp172;
fp172 = fp173 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp87;
fp87 = fp121 * src0[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp88;
fp88 = fp126 * src0[((hsi*16+7)*1+lsi)*1];
LIBINT2_REALTYPE fp86;
fp86 = fp88 - fp87;
LIBINT2_REALTYPE fp175;
fp175 = fp86 * src1[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp174;
fp174 = fp175 * src2[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp171;
fp171 = fp174 + fp172;
LIBINT2_REALTYPE fp168;
fp168 = fp171 + fp169;
target[((hsi*36+30)*1+lsi)*1] = fp168;
LIBINT2_REALTYPE fp178;
fp178 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp177;
fp177 = fp178 * fp17;
LIBINT2_REALTYPE fp181;
fp181 = src0[((hsi*16+0)*1+lsi)*1] * fp72;
LIBINT2_REALTYPE fp180;
fp180 = fp181 * src2[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp183;
fp183 = fp82 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp182;
fp182 = fp183 * src2[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp179;
fp179 = fp182 + fp180;
LIBINT2_REALTYPE fp176;
fp176 = fp179 + fp177;
target[((hsi*36+29)*1+lsi)*1] = fp176;
LIBINT2_REALTYPE fp186;
fp186 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp185;
fp185 = fp186 * fp24;
LIBINT2_REALTYPE fp189;
fp189 = src0[((hsi*16+0)*1+lsi)*1] * fp65;
LIBINT2_REALTYPE fp188;
fp188 = fp189 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp191;
fp191 = fp82 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp190;
fp190 = fp191 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp187;
fp187 = fp190 + fp188;
LIBINT2_REALTYPE fp184;
fp184 = fp187 + fp185;
target[((hsi*36+28)*1+lsi)*1] = fp184;
LIBINT2_REALTYPE fp266;
fp266 = src0[((hsi*16+2)*1+lsi)*1] * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp265;
fp265 = fp266 * fp40;
LIBINT2_REALTYPE fp56;
fp56 = fp124 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp57;
fp57 = fp126 * src1[((hsi*16+13)*1+lsi)*1];
LIBINT2_REALTYPE fp55;
fp55 = fp57 - fp56;
LIBINT2_REALTYPE fp269;
fp269 = src0[((hsi*16+2)*1+lsi)*1] * fp55;
LIBINT2_REALTYPE fp268;
fp268 = fp269 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp271;
fp271 = fp86 * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp270;
fp270 = fp271 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp267;
fp267 = fp270 + fp268;
LIBINT2_REALTYPE fp264;
fp264 = fp267 + fp265;
target[((hsi*36+18)*1+lsi)*1] = fp264;
LIBINT2_REALTYPE fp202;
fp202 = src0[((hsi*16+1)*1+lsi)*1] * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp201;
fp201 = fp202 * fp24;
LIBINT2_REALTYPE fp205;
fp205 = src0[((hsi*16+1)*1+lsi)*1] * fp72;
LIBINT2_REALTYPE fp204;
fp204 = fp205 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp207;
fp207 = fp83 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp206;
fp206 = fp207 * src2[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp203;
fp203 = fp206 + fp204;
LIBINT2_REALTYPE fp200;
fp200 = fp203 + fp201;
target[((hsi*36+26)*1+lsi)*1] = fp200;
LIBINT2_REALTYPE fp210;
fp210 = src0[((hsi*16+1)*1+lsi)*1] * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp209;
fp209 = fp210 * fp31;
LIBINT2_REALTYPE fp213;
fp213 = src0[((hsi*16+1)*1+lsi)*1] * fp65;
LIBINT2_REALTYPE fp212;
fp212 = fp213 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp215;
fp215 = fp83 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp214;
fp214 = fp215 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp211;
fp211 = fp214 + fp212;
LIBINT2_REALTYPE fp208;
fp208 = fp211 + fp209;
target[((hsi*36+25)*1+lsi)*1] = fp208;
LIBINT2_REALTYPE fp218;
fp218 = src0[((hsi*16+2)*1+lsi)*1] * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp217;
fp217 = fp218 * fp31;
LIBINT2_REALTYPE fp221;
fp221 = src0[((hsi*16+2)*1+lsi)*1] * fp72;
LIBINT2_REALTYPE fp220;
fp220 = fp221 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp223;
fp223 = fp86 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp222;
fp222 = fp223 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp219;
fp219 = fp222 + fp220;
LIBINT2_REALTYPE fp216;
fp216 = fp219 + fp217;
target[((hsi*36+24)*1+lsi)*1] = fp216;
LIBINT2_REALTYPE fp226;
fp226 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp225;
fp225 = fp226 * fp34;
LIBINT2_REALTYPE fp229;
fp229 = src0[((hsi*16+0)*1+lsi)*1] * fp55;
LIBINT2_REALTYPE fp228;
fp228 = fp229 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp231;
fp231 = fp82 * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp230;
fp230 = fp231 * src2[((hsi*16+2)*1+lsi)*1];
LIBINT2_REALTYPE fp227;
fp227 = fp230 + fp228;
LIBINT2_REALTYPE fp224;
fp224 = fp227 + fp225;
target[((hsi*36+23)*1+lsi)*1] = fp224;
LIBINT2_REALTYPE fp234;
fp234 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp233;
fp233 = fp234 * fp37;
LIBINT2_REALTYPE fp49;
fp49 = 1.0000000000000000e+00 * src1[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp51;
fp51 = fp127 * src1[((hsi*16+12)*1+lsi)*1];
LIBINT2_REALTYPE fp53;
fp53 = fp124 * src1[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp54;
fp54 = fp126 * src1[((hsi*16+14)*1+lsi)*1];
LIBINT2_REALTYPE fp52;
fp52 = fp54 - fp53;
LIBINT2_REALTYPE fp50;
fp50 = fp52 - fp51;
LIBINT2_REALTYPE fp48;
fp48 = fp50 + fp49;
LIBINT2_REALTYPE fp237;
fp237 = src0[((hsi*16+0)*1+lsi)*1] * fp48;
LIBINT2_REALTYPE fp236;
fp236 = fp237 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp239;
fp239 = fp82 * src1[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp238;
fp238 = fp239 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp235;
fp235 = fp238 + fp236;
LIBINT2_REALTYPE fp232;
fp232 = fp235 + fp233;
target[((hsi*36+22)*1+lsi)*1] = fp232;
LIBINT2_REALTYPE fp242;
fp242 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp241;
fp241 = fp242 * fp40;
LIBINT2_REALTYPE fp42;
fp42 = 2.0000000000000000e+00 * src1[((hsi*16+5)*1+lsi)*1];
LIBINT2_REALTYPE fp44;
fp44 = fp121 * src1[((hsi*16+13)*1+lsi)*1];
LIBINT2_REALTYPE fp46;
fp46 = fp124 * src1[((hsi*16+7)*1+lsi)*1];
LIBINT2_REALTYPE fp47;
fp47 = fp126 * src1[((hsi*16+15)*1+lsi)*1];
LIBINT2_REALTYPE fp45;
fp45 = fp47 - fp46;
LIBINT2_REALTYPE fp43;
fp43 = fp45 - fp44;
LIBINT2_REALTYPE fp41;
fp41 = fp43 + fp42;
LIBINT2_REALTYPE fp245;
fp245 = src0[((hsi*16+0)*1+lsi)*1] * fp41;
LIBINT2_REALTYPE fp244;
fp244 = fp245 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp247;
fp247 = fp82 * src1[((hsi*16+10)*1+lsi)*1];
LIBINT2_REALTYPE fp246;
fp246 = fp247 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp243;
fp243 = fp246 + fp244;
LIBINT2_REALTYPE fp240;
fp240 = fp243 + fp241;
target[((hsi*36+21)*1+lsi)*1] = fp240;
LIBINT2_REALTYPE fp250;
fp250 = src0[((hsi*16+1)*1+lsi)*1] * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp249;
fp249 = fp250 * fp37;
LIBINT2_REALTYPE fp253;
fp253 = src0[((hsi*16+1)*1+lsi)*1] * fp55;
LIBINT2_REALTYPE fp252;
fp252 = fp253 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp255;
fp255 = fp83 * src1[((hsi*16+8)*1+lsi)*1];
LIBINT2_REALTYPE fp254;
fp254 = fp255 * src2[((hsi*16+1)*1+lsi)*1];
LIBINT2_REALTYPE fp251;
fp251 = fp254 + fp252;
LIBINT2_REALTYPE fp248;
fp248 = fp251 + fp249;
target[((hsi*36+20)*1+lsi)*1] = fp248;
LIBINT2_REALTYPE fp258;
fp258 = src0[((hsi*16+1)*1+lsi)*1] * src1[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp257;
fp257 = fp258 * fp40;
LIBINT2_REALTYPE fp261;
fp261 = src0[((hsi*16+1)*1+lsi)*1] * fp48;
LIBINT2_REALTYPE fp260;
fp260 = fp261 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp263;
fp263 = fp83 * src1[((hsi*16+9)*1+lsi)*1];
LIBINT2_REALTYPE fp262;
fp262 = fp263 * src2[((hsi*16+0)*1+lsi)*1];
LIBINT2_REALTYPE fp259;
fp259 = fp262 + fp260;
LIBINT2_REALTYPE fp256;
fp256 = fp259 + fp257;
target[((hsi*36+19)*1+lsi)*1] = fp256;
LIBINT2_REALTYPE fp194;
fp194 = src0[((hsi*16+0)*1+lsi)*1] * src1[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp193;
fp193 = fp194 * fp31;
LIBINT2_REALTYPE fp197;
fp197 = src0[((hsi*16+0)*1+lsi)*1] * fp58;
LIBINT2_REALTYPE fp196;
fp196 = fp197 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp199;
fp199 = fp82 * src1[((hsi*16+6)*1+lsi)*1];
LIBINT2_REALTYPE fp198;
fp198 = fp199 * src2[((hsi*16+4)*1+lsi)*1];
LIBINT2_REALTYPE fp195;
fp195 = fp198 + fp196;
LIBINT2_REALTYPE fp192;
fp192 = fp195 + fp193;
target[((hsi*36+27)*1+lsi)*1] = fp192;
}
}
}
const int hsi = 0;
const int lsi = 0;
const int vi = 0;
/** Number of flops = 416 */
}

#ifdef __cplusplus
};
#endif
