/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <libint2.h>

#ifdef __cplusplus
extern "C" {
#endif
void HRRPart1bra0ket0ff001(const Libint_t* inteval, LIBINT2_REALTYPE* target, const LIBINT2_REALTYPE* src0, const LIBINT2_REALTYPE* src1, const LIBINT2_REALTYPE* src2, int highdim) {

LIBINT2_REALTYPE*const  stack = target;
#ifdef __INTEL_COMPILER
#pragma ivdep
#endif
for(int hsi = 0; hsi<highdim; hsi++) {
{
const int lsi = 0;
{
const int vi = 0;
LIBINT2_REALTYPE fp237;
fp237 = inteval->CD_y[vi] * src1[((hsi*60+15)*1+lsi)*1];
LIBINT2_REALTYPE fp236;
fp236 = src0[((hsi*90+27)*1+lsi)*1] + fp237;
target[((hsi*100+26)*1+lsi)*1] = fp236;
LIBINT2_REALTYPE fp233;
fp233 = 1.0000000000000000e+00 * src2[((hsi*60+15)*1+lsi)*1];
LIBINT2_REALTYPE fp235;
fp235 = inteval->CD_z[vi] * src1[((hsi*60+15)*1+lsi)*1];
LIBINT2_REALTYPE fp234;
fp234 = src0[((hsi*90+33)*1+lsi)*1] + fp235;
LIBINT2_REALTYPE fp232;
fp232 = fp234 - fp233;
target[((hsi*100+27)*1+lsi)*1] = fp232;
LIBINT2_REALTYPE fp229;
fp229 = 1.0000000000000000e+00 * src2[((hsi*60+16)*1+lsi)*1];
LIBINT2_REALTYPE fp231;
fp231 = inteval->CD_z[vi] * src1[((hsi*60+16)*1+lsi)*1];
LIBINT2_REALTYPE fp230;
fp230 = src0[((hsi*90+34)*1+lsi)*1] + fp231;
LIBINT2_REALTYPE fp228;
fp228 = fp230 - fp229;
target[((hsi*100+28)*1+lsi)*1] = fp228;
LIBINT2_REALTYPE fp225;
fp225 = 1.0000000000000000e+00 * src2[((hsi*60+17)*1+lsi)*1];
LIBINT2_REALTYPE fp227;
fp227 = inteval->CD_z[vi] * src1[((hsi*60+17)*1+lsi)*1];
LIBINT2_REALTYPE fp226;
fp226 = src0[((hsi*90+35)*1+lsi)*1] + fp227;
LIBINT2_REALTYPE fp224;
fp224 = fp226 - fp225;
target[((hsi*100+29)*1+lsi)*1] = fp224;
LIBINT2_REALTYPE fp223;
fp223 = inteval->CD_x[vi] * src1[((hsi*60+18)*1+lsi)*1];
LIBINT2_REALTYPE fp222;
fp222 = src0[((hsi*90+18)*1+lsi)*1] + fp223;
target[((hsi*100+30)*1+lsi)*1] = fp222;
LIBINT2_REALTYPE fp221;
fp221 = inteval->CD_y[vi] * src1[((hsi*60+18)*1+lsi)*1];
LIBINT2_REALTYPE fp220;
fp220 = src0[((hsi*90+36)*1+lsi)*1] + fp221;
target[((hsi*100+31)*1+lsi)*1] = fp220;
LIBINT2_REALTYPE fp217;
fp217 = 1.0000000000000000e+00 * src2[((hsi*60+18)*1+lsi)*1];
LIBINT2_REALTYPE fp219;
fp219 = inteval->CD_z[vi] * src1[((hsi*60+18)*1+lsi)*1];
LIBINT2_REALTYPE fp218;
fp218 = src0[((hsi*90+42)*1+lsi)*1] + fp219;
LIBINT2_REALTYPE fp216;
fp216 = fp218 - fp217;
target[((hsi*100+32)*1+lsi)*1] = fp216;
LIBINT2_REALTYPE fp215;
fp215 = inteval->CD_y[vi] * src1[((hsi*60+19)*1+lsi)*1];
LIBINT2_REALTYPE fp214;
fp214 = src0[((hsi*90+37)*1+lsi)*1] + fp215;
target[((hsi*100+33)*1+lsi)*1] = fp214;
LIBINT2_REALTYPE fp211;
fp211 = 1.0000000000000000e+00 * src2[((hsi*60+19)*1+lsi)*1];
LIBINT2_REALTYPE fp213;
fp213 = inteval->CD_z[vi] * src1[((hsi*60+19)*1+lsi)*1];
LIBINT2_REALTYPE fp212;
fp212 = src0[((hsi*90+43)*1+lsi)*1] + fp213;
LIBINT2_REALTYPE fp210;
fp210 = fp212 - fp211;
target[((hsi*100+34)*1+lsi)*1] = fp210;
LIBINT2_REALTYPE fp207;
fp207 = 1.0000000000000000e+00 * src2[((hsi*60+20)*1+lsi)*1];
LIBINT2_REALTYPE fp209;
fp209 = inteval->CD_z[vi] * src1[((hsi*60+20)*1+lsi)*1];
LIBINT2_REALTYPE fp208;
fp208 = src0[((hsi*90+44)*1+lsi)*1] + fp209;
LIBINT2_REALTYPE fp206;
fp206 = fp208 - fp207;
target[((hsi*100+35)*1+lsi)*1] = fp206;
LIBINT2_REALTYPE fp205;
fp205 = inteval->CD_y[vi] * src1[((hsi*60+21)*1+lsi)*1];
LIBINT2_REALTYPE fp204;
fp204 = src0[((hsi*90+39)*1+lsi)*1] + fp205;
target[((hsi*100+36)*1+lsi)*1] = fp204;
LIBINT2_REALTYPE fp319;
fp319 = inteval->CD_x[vi] * src1[((hsi*60+0)*1+lsi)*1];
LIBINT2_REALTYPE fp318;
fp318 = src0[((hsi*90+0)*1+lsi)*1] + fp319;
target[((hsi*100+0)*1+lsi)*1] = fp318;
LIBINT2_REALTYPE fp197;
fp197 = 1.0000000000000000e+00 * src2[((hsi*60+22)*1+lsi)*1];
LIBINT2_REALTYPE fp199;
fp199 = inteval->CD_z[vi] * src1[((hsi*60+22)*1+lsi)*1];
LIBINT2_REALTYPE fp198;
fp198 = src0[((hsi*90+46)*1+lsi)*1] + fp199;
LIBINT2_REALTYPE fp196;
fp196 = fp198 - fp197;
target[((hsi*100+38)*1+lsi)*1] = fp196;
LIBINT2_REALTYPE fp193;
fp193 = 1.0000000000000000e+00 * src2[((hsi*60+23)*1+lsi)*1];
LIBINT2_REALTYPE fp195;
fp195 = inteval->CD_z[vi] * src1[((hsi*60+23)*1+lsi)*1];
LIBINT2_REALTYPE fp194;
fp194 = src0[((hsi*90+47)*1+lsi)*1] + fp195;
LIBINT2_REALTYPE fp192;
fp192 = fp194 - fp193;
target[((hsi*100+39)*1+lsi)*1] = fp192;
LIBINT2_REALTYPE fp191;
fp191 = inteval->CD_x[vi] * src1[((hsi*60+24)*1+lsi)*1];
LIBINT2_REALTYPE fp190;
fp190 = src0[((hsi*90+24)*1+lsi)*1] + fp191;
target[((hsi*100+40)*1+lsi)*1] = fp190;
LIBINT2_REALTYPE fp189;
fp189 = inteval->CD_y[vi] * src1[((hsi*60+24)*1+lsi)*1];
LIBINT2_REALTYPE fp188;
fp188 = src0[((hsi*90+42)*1+lsi)*1] + fp189;
target[((hsi*100+41)*1+lsi)*1] = fp188;
LIBINT2_REALTYPE fp185;
fp185 = 1.0000000000000000e+00 * src2[((hsi*60+24)*1+lsi)*1];
LIBINT2_REALTYPE fp187;
fp187 = inteval->CD_z[vi] * src1[((hsi*60+24)*1+lsi)*1];
LIBINT2_REALTYPE fp186;
fp186 = src0[((hsi*90+48)*1+lsi)*1] + fp187;
LIBINT2_REALTYPE fp184;
fp184 = fp186 - fp185;
target[((hsi*100+42)*1+lsi)*1] = fp184;
LIBINT2_REALTYPE fp183;
fp183 = inteval->CD_y[vi] * src1[((hsi*60+25)*1+lsi)*1];
LIBINT2_REALTYPE fp182;
fp182 = src0[((hsi*90+43)*1+lsi)*1] + fp183;
target[((hsi*100+43)*1+lsi)*1] = fp182;
LIBINT2_REALTYPE fp179;
fp179 = 1.0000000000000000e+00 * src2[((hsi*60+25)*1+lsi)*1];
LIBINT2_REALTYPE fp181;
fp181 = inteval->CD_z[vi] * src1[((hsi*60+25)*1+lsi)*1];
LIBINT2_REALTYPE fp180;
fp180 = src0[((hsi*90+49)*1+lsi)*1] + fp181;
LIBINT2_REALTYPE fp178;
fp178 = fp180 - fp179;
target[((hsi*100+44)*1+lsi)*1] = fp178;
LIBINT2_REALTYPE fp175;
fp175 = 1.0000000000000000e+00 * src2[((hsi*60+26)*1+lsi)*1];
LIBINT2_REALTYPE fp177;
fp177 = inteval->CD_z[vi] * src1[((hsi*60+26)*1+lsi)*1];
LIBINT2_REALTYPE fp176;
fp176 = src0[((hsi*90+50)*1+lsi)*1] + fp177;
LIBINT2_REALTYPE fp174;
fp174 = fp176 - fp175;
target[((hsi*100+45)*1+lsi)*1] = fp174;
LIBINT2_REALTYPE fp173;
fp173 = inteval->CD_y[vi] * src1[((hsi*60+27)*1+lsi)*1];
LIBINT2_REALTYPE fp172;
fp172 = src0[((hsi*90+45)*1+lsi)*1] + fp173;
target[((hsi*100+46)*1+lsi)*1] = fp172;
LIBINT2_REALTYPE fp169;
fp169 = 1.0000000000000000e+00 * src2[((hsi*60+27)*1+lsi)*1];
LIBINT2_REALTYPE fp171;
fp171 = inteval->CD_z[vi] * src1[((hsi*60+27)*1+lsi)*1];
LIBINT2_REALTYPE fp170;
fp170 = src0[((hsi*90+51)*1+lsi)*1] + fp171;
LIBINT2_REALTYPE fp168;
fp168 = fp170 - fp169;
target[((hsi*100+47)*1+lsi)*1] = fp168;
LIBINT2_REALTYPE fp165;
fp165 = 1.0000000000000000e+00 * src2[((hsi*60+28)*1+lsi)*1];
LIBINT2_REALTYPE fp167;
fp167 = inteval->CD_z[vi] * src1[((hsi*60+28)*1+lsi)*1];
LIBINT2_REALTYPE fp166;
fp166 = src0[((hsi*90+52)*1+lsi)*1] + fp167;
LIBINT2_REALTYPE fp164;
fp164 = fp166 - fp165;
target[((hsi*100+48)*1+lsi)*1] = fp164;
LIBINT2_REALTYPE fp161;
fp161 = 1.0000000000000000e+00 * src2[((hsi*60+29)*1+lsi)*1];
LIBINT2_REALTYPE fp163;
fp163 = inteval->CD_z[vi] * src1[((hsi*60+29)*1+lsi)*1];
LIBINT2_REALTYPE fp162;
fp162 = src0[((hsi*90+53)*1+lsi)*1] + fp163;
LIBINT2_REALTYPE fp160;
fp160 = fp162 - fp161;
target[((hsi*100+49)*1+lsi)*1] = fp160;
LIBINT2_REALTYPE fp201;
fp201 = 1.0000000000000000e+00 * src2[((hsi*60+21)*1+lsi)*1];
LIBINT2_REALTYPE fp203;
fp203 = inteval->CD_z[vi] * src1[((hsi*60+21)*1+lsi)*1];
LIBINT2_REALTYPE fp202;
fp202 = src0[((hsi*90+45)*1+lsi)*1] + fp203;
LIBINT2_REALTYPE fp200;
fp200 = fp202 - fp201;
target[((hsi*100+37)*1+lsi)*1] = fp200;
LIBINT2_REALTYPE fp317;
fp317 = inteval->CD_y[vi] * src1[((hsi*60+0)*1+lsi)*1];
LIBINT2_REALTYPE fp316;
fp316 = src0[((hsi*90+6)*1+lsi)*1] + fp317;
target[((hsi*100+1)*1+lsi)*1] = fp316;
LIBINT2_REALTYPE fp313;
fp313 = 1.0000000000000000e+00 * src2[((hsi*60+0)*1+lsi)*1];
LIBINT2_REALTYPE fp315;
fp315 = inteval->CD_z[vi] * src1[((hsi*60+0)*1+lsi)*1];
LIBINT2_REALTYPE fp314;
fp314 = src0[((hsi*90+12)*1+lsi)*1] + fp315;
LIBINT2_REALTYPE fp312;
fp312 = fp314 - fp313;
target[((hsi*100+2)*1+lsi)*1] = fp312;
LIBINT2_REALTYPE fp311;
fp311 = inteval->CD_y[vi] * src1[((hsi*60+1)*1+lsi)*1];
LIBINT2_REALTYPE fp310;
fp310 = src0[((hsi*90+7)*1+lsi)*1] + fp311;
target[((hsi*100+3)*1+lsi)*1] = fp310;
LIBINT2_REALTYPE fp307;
fp307 = 1.0000000000000000e+00 * src2[((hsi*60+1)*1+lsi)*1];
LIBINT2_REALTYPE fp309;
fp309 = inteval->CD_z[vi] * src1[((hsi*60+1)*1+lsi)*1];
LIBINT2_REALTYPE fp308;
fp308 = src0[((hsi*90+13)*1+lsi)*1] + fp309;
LIBINT2_REALTYPE fp306;
fp306 = fp308 - fp307;
target[((hsi*100+4)*1+lsi)*1] = fp306;
LIBINT2_REALTYPE fp303;
fp303 = 1.0000000000000000e+00 * src2[((hsi*60+2)*1+lsi)*1];
LIBINT2_REALTYPE fp305;
fp305 = inteval->CD_z[vi] * src1[((hsi*60+2)*1+lsi)*1];
LIBINT2_REALTYPE fp304;
fp304 = src0[((hsi*90+14)*1+lsi)*1] + fp305;
LIBINT2_REALTYPE fp302;
fp302 = fp304 - fp303;
target[((hsi*100+5)*1+lsi)*1] = fp302;
LIBINT2_REALTYPE fp301;
fp301 = inteval->CD_y[vi] * src1[((hsi*60+3)*1+lsi)*1];
LIBINT2_REALTYPE fp300;
fp300 = src0[((hsi*90+9)*1+lsi)*1] + fp301;
target[((hsi*100+6)*1+lsi)*1] = fp300;
LIBINT2_REALTYPE fp297;
fp297 = 1.0000000000000000e+00 * src2[((hsi*60+3)*1+lsi)*1];
LIBINT2_REALTYPE fp299;
fp299 = inteval->CD_z[vi] * src1[((hsi*60+3)*1+lsi)*1];
LIBINT2_REALTYPE fp298;
fp298 = src0[((hsi*90+15)*1+lsi)*1] + fp299;
LIBINT2_REALTYPE fp296;
fp296 = fp298 - fp297;
target[((hsi*100+7)*1+lsi)*1] = fp296;
LIBINT2_REALTYPE fp293;
fp293 = 1.0000000000000000e+00 * src2[((hsi*60+4)*1+lsi)*1];
LIBINT2_REALTYPE fp295;
fp295 = inteval->CD_z[vi] * src1[((hsi*60+4)*1+lsi)*1];
LIBINT2_REALTYPE fp294;
fp294 = src0[((hsi*90+16)*1+lsi)*1] + fp295;
LIBINT2_REALTYPE fp292;
fp292 = fp294 - fp293;
target[((hsi*100+8)*1+lsi)*1] = fp292;
LIBINT2_REALTYPE fp289;
fp289 = 1.0000000000000000e+00 * src2[((hsi*60+5)*1+lsi)*1];
LIBINT2_REALTYPE fp291;
fp291 = inteval->CD_z[vi] * src1[((hsi*60+5)*1+lsi)*1];
LIBINT2_REALTYPE fp290;
fp290 = src0[((hsi*90+17)*1+lsi)*1] + fp291;
LIBINT2_REALTYPE fp288;
fp288 = fp290 - fp289;
target[((hsi*100+9)*1+lsi)*1] = fp288;
LIBINT2_REALTYPE fp287;
fp287 = inteval->CD_x[vi] * src1[((hsi*60+6)*1+lsi)*1];
LIBINT2_REALTYPE fp286;
fp286 = src0[((hsi*90+6)*1+lsi)*1] + fp287;
target[((hsi*100+10)*1+lsi)*1] = fp286;
LIBINT2_REALTYPE fp285;
fp285 = inteval->CD_y[vi] * src1[((hsi*60+6)*1+lsi)*1];
LIBINT2_REALTYPE fp284;
fp284 = src0[((hsi*90+18)*1+lsi)*1] + fp285;
target[((hsi*100+11)*1+lsi)*1] = fp284;
LIBINT2_REALTYPE fp239;
fp239 = 1.0000000000000000e+00 * src2[((hsi*60+14)*1+lsi)*1];
LIBINT2_REALTYPE fp241;
fp241 = inteval->CD_z[vi] * src1[((hsi*60+14)*1+lsi)*1];
LIBINT2_REALTYPE fp240;
fp240 = src0[((hsi*90+32)*1+lsi)*1] + fp241;
LIBINT2_REALTYPE fp238;
fp238 = fp240 - fp239;
target[((hsi*100+25)*1+lsi)*1] = fp238;
LIBINT2_REALTYPE fp279;
fp279 = inteval->CD_y[vi] * src1[((hsi*60+7)*1+lsi)*1];
LIBINT2_REALTYPE fp278;
fp278 = src0[((hsi*90+19)*1+lsi)*1] + fp279;
target[((hsi*100+13)*1+lsi)*1] = fp278;
LIBINT2_REALTYPE fp275;
fp275 = 1.0000000000000000e+00 * src2[((hsi*60+7)*1+lsi)*1];
LIBINT2_REALTYPE fp277;
fp277 = inteval->CD_z[vi] * src1[((hsi*60+7)*1+lsi)*1];
LIBINT2_REALTYPE fp276;
fp276 = src0[((hsi*90+25)*1+lsi)*1] + fp277;
LIBINT2_REALTYPE fp274;
fp274 = fp276 - fp275;
target[((hsi*100+14)*1+lsi)*1] = fp274;
LIBINT2_REALTYPE fp271;
fp271 = 1.0000000000000000e+00 * src2[((hsi*60+8)*1+lsi)*1];
LIBINT2_REALTYPE fp273;
fp273 = inteval->CD_z[vi] * src1[((hsi*60+8)*1+lsi)*1];
LIBINT2_REALTYPE fp272;
fp272 = src0[((hsi*90+26)*1+lsi)*1] + fp273;
LIBINT2_REALTYPE fp270;
fp270 = fp272 - fp271;
target[((hsi*100+15)*1+lsi)*1] = fp270;
LIBINT2_REALTYPE fp269;
fp269 = inteval->CD_y[vi] * src1[((hsi*60+9)*1+lsi)*1];
LIBINT2_REALTYPE fp268;
fp268 = src0[((hsi*90+21)*1+lsi)*1] + fp269;
target[((hsi*100+16)*1+lsi)*1] = fp268;
LIBINT2_REALTYPE fp265;
fp265 = 1.0000000000000000e+00 * src2[((hsi*60+9)*1+lsi)*1];
LIBINT2_REALTYPE fp267;
fp267 = inteval->CD_z[vi] * src1[((hsi*60+9)*1+lsi)*1];
LIBINT2_REALTYPE fp266;
fp266 = src0[((hsi*90+27)*1+lsi)*1] + fp267;
LIBINT2_REALTYPE fp264;
fp264 = fp266 - fp265;
target[((hsi*100+17)*1+lsi)*1] = fp264;
LIBINT2_REALTYPE fp261;
fp261 = 1.0000000000000000e+00 * src2[((hsi*60+10)*1+lsi)*1];
LIBINT2_REALTYPE fp263;
fp263 = inteval->CD_z[vi] * src1[((hsi*60+10)*1+lsi)*1];
LIBINT2_REALTYPE fp262;
fp262 = src0[((hsi*90+28)*1+lsi)*1] + fp263;
LIBINT2_REALTYPE fp260;
fp260 = fp262 - fp261;
target[((hsi*100+18)*1+lsi)*1] = fp260;
LIBINT2_REALTYPE fp257;
fp257 = 1.0000000000000000e+00 * src2[((hsi*60+11)*1+lsi)*1];
LIBINT2_REALTYPE fp259;
fp259 = inteval->CD_z[vi] * src1[((hsi*60+11)*1+lsi)*1];
LIBINT2_REALTYPE fp258;
fp258 = src0[((hsi*90+29)*1+lsi)*1] + fp259;
LIBINT2_REALTYPE fp256;
fp256 = fp258 - fp257;
target[((hsi*100+19)*1+lsi)*1] = fp256;
LIBINT2_REALTYPE fp255;
fp255 = inteval->CD_x[vi] * src1[((hsi*60+12)*1+lsi)*1];
LIBINT2_REALTYPE fp254;
fp254 = src0[((hsi*90+12)*1+lsi)*1] + fp255;
target[((hsi*100+20)*1+lsi)*1] = fp254;
LIBINT2_REALTYPE fp253;
fp253 = inteval->CD_y[vi] * src1[((hsi*60+12)*1+lsi)*1];
LIBINT2_REALTYPE fp252;
fp252 = src0[((hsi*90+24)*1+lsi)*1] + fp253;
target[((hsi*100+21)*1+lsi)*1] = fp252;
LIBINT2_REALTYPE fp249;
fp249 = 1.0000000000000000e+00 * src2[((hsi*60+12)*1+lsi)*1];
LIBINT2_REALTYPE fp251;
fp251 = inteval->CD_z[vi] * src1[((hsi*60+12)*1+lsi)*1];
LIBINT2_REALTYPE fp250;
fp250 = src0[((hsi*90+30)*1+lsi)*1] + fp251;
LIBINT2_REALTYPE fp248;
fp248 = fp250 - fp249;
target[((hsi*100+22)*1+lsi)*1] = fp248;
LIBINT2_REALTYPE fp247;
fp247 = inteval->CD_y[vi] * src1[((hsi*60+13)*1+lsi)*1];
LIBINT2_REALTYPE fp246;
fp246 = src0[((hsi*90+25)*1+lsi)*1] + fp247;
target[((hsi*100+23)*1+lsi)*1] = fp246;
LIBINT2_REALTYPE fp243;
fp243 = 1.0000000000000000e+00 * src2[((hsi*60+13)*1+lsi)*1];
LIBINT2_REALTYPE fp245;
fp245 = inteval->CD_z[vi] * src1[((hsi*60+13)*1+lsi)*1];
LIBINT2_REALTYPE fp244;
fp244 = src0[((hsi*90+31)*1+lsi)*1] + fp245;
LIBINT2_REALTYPE fp242;
fp242 = fp244 - fp243;
target[((hsi*100+24)*1+lsi)*1] = fp242;
LIBINT2_REALTYPE fp281;
fp281 = 1.0000000000000000e+00 * src2[((hsi*60+6)*1+lsi)*1];
LIBINT2_REALTYPE fp283;
fp283 = inteval->CD_z[vi] * src1[((hsi*60+6)*1+lsi)*1];
LIBINT2_REALTYPE fp282;
fp282 = src0[((hsi*90+24)*1+lsi)*1] + fp283;
LIBINT2_REALTYPE fp280;
fp280 = fp282 - fp281;
target[((hsi*100+12)*1+lsi)*1] = fp280;
LIBINT2_REALTYPE fp77;
fp77 = inteval->CD_y[vi] * src1[((hsi*60+45)*1+lsi)*1];
LIBINT2_REALTYPE fp76;
fp76 = src0[((hsi*90+69)*1+lsi)*1] + fp77;
target[((hsi*100+76)*1+lsi)*1] = fp76;
LIBINT2_REALTYPE fp73;
fp73 = 1.0000000000000000e+00 * src2[((hsi*60+45)*1+lsi)*1];
LIBINT2_REALTYPE fp75;
fp75 = inteval->CD_z[vi] * src1[((hsi*60+45)*1+lsi)*1];
LIBINT2_REALTYPE fp74;
fp74 = src0[((hsi*90+75)*1+lsi)*1] + fp75;
LIBINT2_REALTYPE fp72;
fp72 = fp74 - fp73;
target[((hsi*100+77)*1+lsi)*1] = fp72;
LIBINT2_REALTYPE fp69;
fp69 = 1.0000000000000000e+00 * src2[((hsi*60+46)*1+lsi)*1];
LIBINT2_REALTYPE fp71;
fp71 = inteval->CD_z[vi] * src1[((hsi*60+46)*1+lsi)*1];
LIBINT2_REALTYPE fp70;
fp70 = src0[((hsi*90+76)*1+lsi)*1] + fp71;
LIBINT2_REALTYPE fp68;
fp68 = fp70 - fp69;
target[((hsi*100+78)*1+lsi)*1] = fp68;
LIBINT2_REALTYPE fp65;
fp65 = 1.0000000000000000e+00 * src2[((hsi*60+47)*1+lsi)*1];
LIBINT2_REALTYPE fp67;
fp67 = inteval->CD_z[vi] * src1[((hsi*60+47)*1+lsi)*1];
LIBINT2_REALTYPE fp66;
fp66 = src0[((hsi*90+77)*1+lsi)*1] + fp67;
LIBINT2_REALTYPE fp64;
fp64 = fp66 - fp65;
target[((hsi*100+79)*1+lsi)*1] = fp64;
LIBINT2_REALTYPE fp63;
fp63 = inteval->CD_x[vi] * src1[((hsi*60+48)*1+lsi)*1];
LIBINT2_REALTYPE fp62;
fp62 = src0[((hsi*90+48)*1+lsi)*1] + fp63;
target[((hsi*100+80)*1+lsi)*1] = fp62;
LIBINT2_REALTYPE fp61;
fp61 = inteval->CD_y[vi] * src1[((hsi*60+48)*1+lsi)*1];
LIBINT2_REALTYPE fp60;
fp60 = src0[((hsi*90+72)*1+lsi)*1] + fp61;
target[((hsi*100+81)*1+lsi)*1] = fp60;
LIBINT2_REALTYPE fp57;
fp57 = 1.0000000000000000e+00 * src2[((hsi*60+48)*1+lsi)*1];
LIBINT2_REALTYPE fp59;
fp59 = inteval->CD_z[vi] * src1[((hsi*60+48)*1+lsi)*1];
LIBINT2_REALTYPE fp58;
fp58 = src0[((hsi*90+78)*1+lsi)*1] + fp59;
LIBINT2_REALTYPE fp56;
fp56 = fp58 - fp57;
target[((hsi*100+82)*1+lsi)*1] = fp56;
LIBINT2_REALTYPE fp55;
fp55 = inteval->CD_y[vi] * src1[((hsi*60+49)*1+lsi)*1];
LIBINT2_REALTYPE fp54;
fp54 = src0[((hsi*90+73)*1+lsi)*1] + fp55;
target[((hsi*100+83)*1+lsi)*1] = fp54;
LIBINT2_REALTYPE fp51;
fp51 = 1.0000000000000000e+00 * src2[((hsi*60+49)*1+lsi)*1];
LIBINT2_REALTYPE fp53;
fp53 = inteval->CD_z[vi] * src1[((hsi*60+49)*1+lsi)*1];
LIBINT2_REALTYPE fp52;
fp52 = src0[((hsi*90+79)*1+lsi)*1] + fp53;
LIBINT2_REALTYPE fp50;
fp50 = fp52 - fp51;
target[((hsi*100+84)*1+lsi)*1] = fp50;
LIBINT2_REALTYPE fp47;
fp47 = 1.0000000000000000e+00 * src2[((hsi*60+50)*1+lsi)*1];
LIBINT2_REALTYPE fp49;
fp49 = inteval->CD_z[vi] * src1[((hsi*60+50)*1+lsi)*1];
LIBINT2_REALTYPE fp48;
fp48 = src0[((hsi*90+80)*1+lsi)*1] + fp49;
LIBINT2_REALTYPE fp46;
fp46 = fp48 - fp47;
target[((hsi*100+85)*1+lsi)*1] = fp46;
LIBINT2_REALTYPE fp45;
fp45 = inteval->CD_y[vi] * src1[((hsi*60+51)*1+lsi)*1];
LIBINT2_REALTYPE fp44;
fp44 = src0[((hsi*90+75)*1+lsi)*1] + fp45;
target[((hsi*100+86)*1+lsi)*1] = fp44;
LIBINT2_REALTYPE fp159;
fp159 = inteval->CD_x[vi] * src1[((hsi*60+30)*1+lsi)*1];
LIBINT2_REALTYPE fp158;
fp158 = src0[((hsi*90+30)*1+lsi)*1] + fp159;
target[((hsi*100+50)*1+lsi)*1] = fp158;
LIBINT2_REALTYPE fp37;
fp37 = 1.0000000000000000e+00 * src2[((hsi*60+52)*1+lsi)*1];
LIBINT2_REALTYPE fp39;
fp39 = inteval->CD_z[vi] * src1[((hsi*60+52)*1+lsi)*1];
LIBINT2_REALTYPE fp38;
fp38 = src0[((hsi*90+82)*1+lsi)*1] + fp39;
LIBINT2_REALTYPE fp36;
fp36 = fp38 - fp37;
target[((hsi*100+88)*1+lsi)*1] = fp36;
LIBINT2_REALTYPE fp33;
fp33 = 1.0000000000000000e+00 * src2[((hsi*60+53)*1+lsi)*1];
LIBINT2_REALTYPE fp35;
fp35 = inteval->CD_z[vi] * src1[((hsi*60+53)*1+lsi)*1];
LIBINT2_REALTYPE fp34;
fp34 = src0[((hsi*90+83)*1+lsi)*1] + fp35;
LIBINT2_REALTYPE fp32;
fp32 = fp34 - fp33;
target[((hsi*100+89)*1+lsi)*1] = fp32;
LIBINT2_REALTYPE fp31;
fp31 = inteval->CD_x[vi] * src1[((hsi*60+54)*1+lsi)*1];
LIBINT2_REALTYPE fp30;
fp30 = src0[((hsi*90+54)*1+lsi)*1] + fp31;
target[((hsi*100+90)*1+lsi)*1] = fp30;
LIBINT2_REALTYPE fp29;
fp29 = inteval->CD_y[vi] * src1[((hsi*60+54)*1+lsi)*1];
LIBINT2_REALTYPE fp28;
fp28 = src0[((hsi*90+78)*1+lsi)*1] + fp29;
target[((hsi*100+91)*1+lsi)*1] = fp28;
LIBINT2_REALTYPE fp25;
fp25 = 1.0000000000000000e+00 * src2[((hsi*60+54)*1+lsi)*1];
LIBINT2_REALTYPE fp27;
fp27 = inteval->CD_z[vi] * src1[((hsi*60+54)*1+lsi)*1];
LIBINT2_REALTYPE fp26;
fp26 = src0[((hsi*90+84)*1+lsi)*1] + fp27;
LIBINT2_REALTYPE fp24;
fp24 = fp26 - fp25;
target[((hsi*100+92)*1+lsi)*1] = fp24;
LIBINT2_REALTYPE fp23;
fp23 = inteval->CD_y[vi] * src1[((hsi*60+55)*1+lsi)*1];
LIBINT2_REALTYPE fp22;
fp22 = src0[((hsi*90+79)*1+lsi)*1] + fp23;
target[((hsi*100+93)*1+lsi)*1] = fp22;
LIBINT2_REALTYPE fp19;
fp19 = 1.0000000000000000e+00 * src2[((hsi*60+55)*1+lsi)*1];
LIBINT2_REALTYPE fp21;
fp21 = inteval->CD_z[vi] * src1[((hsi*60+55)*1+lsi)*1];
LIBINT2_REALTYPE fp20;
fp20 = src0[((hsi*90+85)*1+lsi)*1] + fp21;
LIBINT2_REALTYPE fp18;
fp18 = fp20 - fp19;
target[((hsi*100+94)*1+lsi)*1] = fp18;
LIBINT2_REALTYPE fp15;
fp15 = 1.0000000000000000e+00 * src2[((hsi*60+56)*1+lsi)*1];
LIBINT2_REALTYPE fp17;
fp17 = inteval->CD_z[vi] * src1[((hsi*60+56)*1+lsi)*1];
LIBINT2_REALTYPE fp16;
fp16 = src0[((hsi*90+86)*1+lsi)*1] + fp17;
LIBINT2_REALTYPE fp14;
fp14 = fp16 - fp15;
target[((hsi*100+95)*1+lsi)*1] = fp14;
LIBINT2_REALTYPE fp13;
fp13 = inteval->CD_y[vi] * src1[((hsi*60+57)*1+lsi)*1];
LIBINT2_REALTYPE fp12;
fp12 = src0[((hsi*90+81)*1+lsi)*1] + fp13;
target[((hsi*100+96)*1+lsi)*1] = fp12;
LIBINT2_REALTYPE fp9;
fp9 = 1.0000000000000000e+00 * src2[((hsi*60+57)*1+lsi)*1];
LIBINT2_REALTYPE fp11;
fp11 = inteval->CD_z[vi] * src1[((hsi*60+57)*1+lsi)*1];
LIBINT2_REALTYPE fp10;
fp10 = src0[((hsi*90+87)*1+lsi)*1] + fp11;
LIBINT2_REALTYPE fp8;
fp8 = fp10 - fp9;
target[((hsi*100+97)*1+lsi)*1] = fp8;
LIBINT2_REALTYPE fp5;
fp5 = 1.0000000000000000e+00 * src2[((hsi*60+58)*1+lsi)*1];
LIBINT2_REALTYPE fp7;
fp7 = inteval->CD_z[vi] * src1[((hsi*60+58)*1+lsi)*1];
LIBINT2_REALTYPE fp6;
fp6 = src0[((hsi*90+88)*1+lsi)*1] + fp7;
LIBINT2_REALTYPE fp4;
fp4 = fp6 - fp5;
target[((hsi*100+98)*1+lsi)*1] = fp4;
LIBINT2_REALTYPE fp1;
fp1 = 1.0000000000000000e+00 * src2[((hsi*60+59)*1+lsi)*1];
LIBINT2_REALTYPE fp3;
fp3 = inteval->CD_z[vi] * src1[((hsi*60+59)*1+lsi)*1];
LIBINT2_REALTYPE fp2;
fp2 = src0[((hsi*90+89)*1+lsi)*1] + fp3;
LIBINT2_REALTYPE fp0;
fp0 = fp2 - fp1;
target[((hsi*100+99)*1+lsi)*1] = fp0;
LIBINT2_REALTYPE fp41;
fp41 = 1.0000000000000000e+00 * src2[((hsi*60+51)*1+lsi)*1];
LIBINT2_REALTYPE fp43;
fp43 = inteval->CD_z[vi] * src1[((hsi*60+51)*1+lsi)*1];
LIBINT2_REALTYPE fp42;
fp42 = src0[((hsi*90+81)*1+lsi)*1] + fp43;
LIBINT2_REALTYPE fp40;
fp40 = fp42 - fp41;
target[((hsi*100+87)*1+lsi)*1] = fp40;
LIBINT2_REALTYPE fp157;
fp157 = inteval->CD_y[vi] * src1[((hsi*60+30)*1+lsi)*1];
LIBINT2_REALTYPE fp156;
fp156 = src0[((hsi*90+48)*1+lsi)*1] + fp157;
target[((hsi*100+51)*1+lsi)*1] = fp156;
LIBINT2_REALTYPE fp153;
fp153 = 1.0000000000000000e+00 * src2[((hsi*60+30)*1+lsi)*1];
LIBINT2_REALTYPE fp155;
fp155 = inteval->CD_z[vi] * src1[((hsi*60+30)*1+lsi)*1];
LIBINT2_REALTYPE fp154;
fp154 = src0[((hsi*90+54)*1+lsi)*1] + fp155;
LIBINT2_REALTYPE fp152;
fp152 = fp154 - fp153;
target[((hsi*100+52)*1+lsi)*1] = fp152;
LIBINT2_REALTYPE fp151;
fp151 = inteval->CD_y[vi] * src1[((hsi*60+31)*1+lsi)*1];
LIBINT2_REALTYPE fp150;
fp150 = src0[((hsi*90+49)*1+lsi)*1] + fp151;
target[((hsi*100+53)*1+lsi)*1] = fp150;
LIBINT2_REALTYPE fp147;
fp147 = 1.0000000000000000e+00 * src2[((hsi*60+31)*1+lsi)*1];
LIBINT2_REALTYPE fp149;
fp149 = inteval->CD_z[vi] * src1[((hsi*60+31)*1+lsi)*1];
LIBINT2_REALTYPE fp148;
fp148 = src0[((hsi*90+55)*1+lsi)*1] + fp149;
LIBINT2_REALTYPE fp146;
fp146 = fp148 - fp147;
target[((hsi*100+54)*1+lsi)*1] = fp146;
LIBINT2_REALTYPE fp143;
fp143 = 1.0000000000000000e+00 * src2[((hsi*60+32)*1+lsi)*1];
LIBINT2_REALTYPE fp145;
fp145 = inteval->CD_z[vi] * src1[((hsi*60+32)*1+lsi)*1];
LIBINT2_REALTYPE fp144;
fp144 = src0[((hsi*90+56)*1+lsi)*1] + fp145;
LIBINT2_REALTYPE fp142;
fp142 = fp144 - fp143;
target[((hsi*100+55)*1+lsi)*1] = fp142;
LIBINT2_REALTYPE fp141;
fp141 = inteval->CD_y[vi] * src1[((hsi*60+33)*1+lsi)*1];
LIBINT2_REALTYPE fp140;
fp140 = src0[((hsi*90+51)*1+lsi)*1] + fp141;
target[((hsi*100+56)*1+lsi)*1] = fp140;
LIBINT2_REALTYPE fp137;
fp137 = 1.0000000000000000e+00 * src2[((hsi*60+33)*1+lsi)*1];
LIBINT2_REALTYPE fp139;
fp139 = inteval->CD_z[vi] * src1[((hsi*60+33)*1+lsi)*1];
LIBINT2_REALTYPE fp138;
fp138 = src0[((hsi*90+57)*1+lsi)*1] + fp139;
LIBINT2_REALTYPE fp136;
fp136 = fp138 - fp137;
target[((hsi*100+57)*1+lsi)*1] = fp136;
LIBINT2_REALTYPE fp133;
fp133 = 1.0000000000000000e+00 * src2[((hsi*60+34)*1+lsi)*1];
LIBINT2_REALTYPE fp135;
fp135 = inteval->CD_z[vi] * src1[((hsi*60+34)*1+lsi)*1];
LIBINT2_REALTYPE fp134;
fp134 = src0[((hsi*90+58)*1+lsi)*1] + fp135;
LIBINT2_REALTYPE fp132;
fp132 = fp134 - fp133;
target[((hsi*100+58)*1+lsi)*1] = fp132;
LIBINT2_REALTYPE fp129;
fp129 = 1.0000000000000000e+00 * src2[((hsi*60+35)*1+lsi)*1];
LIBINT2_REALTYPE fp131;
fp131 = inteval->CD_z[vi] * src1[((hsi*60+35)*1+lsi)*1];
LIBINT2_REALTYPE fp130;
fp130 = src0[((hsi*90+59)*1+lsi)*1] + fp131;
LIBINT2_REALTYPE fp128;
fp128 = fp130 - fp129;
target[((hsi*100+59)*1+lsi)*1] = fp128;
LIBINT2_REALTYPE fp127;
fp127 = inteval->CD_x[vi] * src1[((hsi*60+36)*1+lsi)*1];
LIBINT2_REALTYPE fp126;
fp126 = src0[((hsi*90+36)*1+lsi)*1] + fp127;
target[((hsi*100+60)*1+lsi)*1] = fp126;
LIBINT2_REALTYPE fp125;
fp125 = inteval->CD_y[vi] * src1[((hsi*60+36)*1+lsi)*1];
LIBINT2_REALTYPE fp124;
fp124 = src0[((hsi*90+60)*1+lsi)*1] + fp125;
target[((hsi*100+61)*1+lsi)*1] = fp124;
LIBINT2_REALTYPE fp79;
fp79 = 1.0000000000000000e+00 * src2[((hsi*60+44)*1+lsi)*1];
LIBINT2_REALTYPE fp81;
fp81 = inteval->CD_z[vi] * src1[((hsi*60+44)*1+lsi)*1];
LIBINT2_REALTYPE fp80;
fp80 = src0[((hsi*90+74)*1+lsi)*1] + fp81;
LIBINT2_REALTYPE fp78;
fp78 = fp80 - fp79;
target[((hsi*100+75)*1+lsi)*1] = fp78;
LIBINT2_REALTYPE fp119;
fp119 = inteval->CD_y[vi] * src1[((hsi*60+37)*1+lsi)*1];
LIBINT2_REALTYPE fp118;
fp118 = src0[((hsi*90+61)*1+lsi)*1] + fp119;
target[((hsi*100+63)*1+lsi)*1] = fp118;
LIBINT2_REALTYPE fp115;
fp115 = 1.0000000000000000e+00 * src2[((hsi*60+37)*1+lsi)*1];
LIBINT2_REALTYPE fp117;
fp117 = inteval->CD_z[vi] * src1[((hsi*60+37)*1+lsi)*1];
LIBINT2_REALTYPE fp116;
fp116 = src0[((hsi*90+67)*1+lsi)*1] + fp117;
LIBINT2_REALTYPE fp114;
fp114 = fp116 - fp115;
target[((hsi*100+64)*1+lsi)*1] = fp114;
LIBINT2_REALTYPE fp111;
fp111 = 1.0000000000000000e+00 * src2[((hsi*60+38)*1+lsi)*1];
LIBINT2_REALTYPE fp113;
fp113 = inteval->CD_z[vi] * src1[((hsi*60+38)*1+lsi)*1];
LIBINT2_REALTYPE fp112;
fp112 = src0[((hsi*90+68)*1+lsi)*1] + fp113;
LIBINT2_REALTYPE fp110;
fp110 = fp112 - fp111;
target[((hsi*100+65)*1+lsi)*1] = fp110;
LIBINT2_REALTYPE fp109;
fp109 = inteval->CD_y[vi] * src1[((hsi*60+39)*1+lsi)*1];
LIBINT2_REALTYPE fp108;
fp108 = src0[((hsi*90+63)*1+lsi)*1] + fp109;
target[((hsi*100+66)*1+lsi)*1] = fp108;
LIBINT2_REALTYPE fp105;
fp105 = 1.0000000000000000e+00 * src2[((hsi*60+39)*1+lsi)*1];
LIBINT2_REALTYPE fp107;
fp107 = inteval->CD_z[vi] * src1[((hsi*60+39)*1+lsi)*1];
LIBINT2_REALTYPE fp106;
fp106 = src0[((hsi*90+69)*1+lsi)*1] + fp107;
LIBINT2_REALTYPE fp104;
fp104 = fp106 - fp105;
target[((hsi*100+67)*1+lsi)*1] = fp104;
LIBINT2_REALTYPE fp101;
fp101 = 1.0000000000000000e+00 * src2[((hsi*60+40)*1+lsi)*1];
LIBINT2_REALTYPE fp103;
fp103 = inteval->CD_z[vi] * src1[((hsi*60+40)*1+lsi)*1];
LIBINT2_REALTYPE fp102;
fp102 = src0[((hsi*90+70)*1+lsi)*1] + fp103;
LIBINT2_REALTYPE fp100;
fp100 = fp102 - fp101;
target[((hsi*100+68)*1+lsi)*1] = fp100;
LIBINT2_REALTYPE fp97;
fp97 = 1.0000000000000000e+00 * src2[((hsi*60+41)*1+lsi)*1];
LIBINT2_REALTYPE fp99;
fp99 = inteval->CD_z[vi] * src1[((hsi*60+41)*1+lsi)*1];
LIBINT2_REALTYPE fp98;
fp98 = src0[((hsi*90+71)*1+lsi)*1] + fp99;
LIBINT2_REALTYPE fp96;
fp96 = fp98 - fp97;
target[((hsi*100+69)*1+lsi)*1] = fp96;
LIBINT2_REALTYPE fp95;
fp95 = inteval->CD_x[vi] * src1[((hsi*60+42)*1+lsi)*1];
LIBINT2_REALTYPE fp94;
fp94 = src0[((hsi*90+42)*1+lsi)*1] + fp95;
target[((hsi*100+70)*1+lsi)*1] = fp94;
LIBINT2_REALTYPE fp93;
fp93 = inteval->CD_y[vi] * src1[((hsi*60+42)*1+lsi)*1];
LIBINT2_REALTYPE fp92;
fp92 = src0[((hsi*90+66)*1+lsi)*1] + fp93;
target[((hsi*100+71)*1+lsi)*1] = fp92;
LIBINT2_REALTYPE fp89;
fp89 = 1.0000000000000000e+00 * src2[((hsi*60+42)*1+lsi)*1];
LIBINT2_REALTYPE fp91;
fp91 = inteval->CD_z[vi] * src1[((hsi*60+42)*1+lsi)*1];
LIBINT2_REALTYPE fp90;
fp90 = src0[((hsi*90+72)*1+lsi)*1] + fp91;
LIBINT2_REALTYPE fp88;
fp88 = fp90 - fp89;
target[((hsi*100+72)*1+lsi)*1] = fp88;
LIBINT2_REALTYPE fp87;
fp87 = inteval->CD_y[vi] * src1[((hsi*60+43)*1+lsi)*1];
LIBINT2_REALTYPE fp86;
fp86 = src0[((hsi*90+67)*1+lsi)*1] + fp87;
target[((hsi*100+73)*1+lsi)*1] = fp86;
LIBINT2_REALTYPE fp83;
fp83 = 1.0000000000000000e+00 * src2[((hsi*60+43)*1+lsi)*1];
LIBINT2_REALTYPE fp85;
fp85 = inteval->CD_z[vi] * src1[((hsi*60+43)*1+lsi)*1];
LIBINT2_REALTYPE fp84;
fp84 = src0[((hsi*90+73)*1+lsi)*1] + fp85;
LIBINT2_REALTYPE fp82;
fp82 = fp84 - fp83;
target[((hsi*100+74)*1+lsi)*1] = fp82;
LIBINT2_REALTYPE fp121;
fp121 = 1.0000000000000000e+00 * src2[((hsi*60+36)*1+lsi)*1];
LIBINT2_REALTYPE fp123;
fp123 = inteval->CD_z[vi] * src1[((hsi*60+36)*1+lsi)*1];
LIBINT2_REALTYPE fp122;
fp122 = src0[((hsi*90+66)*1+lsi)*1] + fp123;
LIBINT2_REALTYPE fp120;
fp120 = fp122 - fp121;
target[((hsi*100+62)*1+lsi)*1] = fp120;
}
}
}
const int hsi = 0;
const int lsi = 0;
const int vi = 0;
/** Number of flops = 320 */
}

#ifdef __cplusplus
};
#endif
