title: Development Resources

This page is a place to collect resources which are useful to
JSON-Fortran contributors and developers.

# Contributing

The guidelines for contributing to JSON-Fortran can be found
[here](CONTRIBUTING.html). Please read these before posting
[issues](https://github.com/jacobwilliams/json-fortran/issues)
or opening
[pull requests](https://github.com/jacobwilliams/json-fortran/pulls). Also,
please carefully read the
[LICENSE](|url|/page/development-resources/LICENSE.html) before using
JSON-Fortran in an application, or contributing code.

# Test Coverage Information

The best place to start when trying to increase test coverage, is to
look at the
[procedure level coverage report](json_module.F90.gcov.html)
automatically generated by
[FoBiS.py](https://github.com/szaghi/FoBiS). If all procedures are
listed as covered, then please take a look at the
[Codecov.io coverage info](https://codecov.io/gh/jacobwilliams/json-fortran/branch/master).

# Scripts

Scripts used to build and test JSON-Fortran. This is a partial list of
scripts used in building and testing JSON-Fortran, as well as
deploying documentation and managing test coverage information.

- [`build.sh`](build.sh.html)
- [`deploy.sh`](deploy.sh.html)
- [`.travis.yml`](travis.yml.html)
- [`codecov.yml`](codecov.yml.html)
- [`gccr.pl`](gccr.pl.html)

# Release Checklist

[This](|url|/page/development-resources/release-checklist.html) is a
checklist of tasks to be performed when tagging a new release of
JSON-Fortran. The current stable version is **{!.VERSION!}**.
