!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_optim_dumper
!! NAME
!!  m_optim_dumper
!!
!! FUNCTION
!!  This module contains information about the optimizations set at
!!  configure-time when building ABINIT (useful for debugging).
!!
!! COPYRIGHT
!!  Copyright (C) 2010-2024 ABINIT group (Yann Pouillon)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module m_optim_dumper

  implicit none

  public :: dump_optim

contains  !===========================================================
!!***

!!****f* ABINIT/m_optim_dumper/dump_optim
!! NAME
!!  dump_optim
!!
!! FUNCTION
!!  Reports a printout of the optimizations set at configure-time,
!!  useful for error messages and debugging.
!!
!! COPYRIGHT
!!  Copyright (C) 2010-2024 ABINIT group (Yann Pouillon)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  my_unit= Fortran unit number (optional, default is std_out)
!!
!! OUTPUT
!!  Only printing
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

subroutine dump_optim(my_unit)
    
  use defs_basis

  implicit none

!Arguments ------------------------------------
  integer,intent(in) :: my_unit

!Local variables-------------------------------
 
! *************************************************************************
 
  write(my_unit,"(a,1x,a)") ch10,repeat("+",78)
  write(my_unit,"(1x,a,a,3x,a,a,a)") "Default optimizations:",ch10, &
&   "--- None ---",ch10,ch10

  write(my_unit,"(1x,a,a)") repeat("+",78),ch10

end subroutine dump_optim

end module m_optim_dumper
!!***
