# finds CUDA_TOOLKIT_MAJOR_VERSION AND CUDA_TOOLKIT_MINOR_VERSION
function(find_cuda_version)
    execute_process(COMMAND nvcc --version  OUTPUT_VARIABLE CUDA_VERSION_STRING)
    string(REGEX MATCH "release ([0-9]*)\\.([0-9]*)" _ "${CUDA_VERSION_STRING}")
    set(CUDA_TOOLKIT_MAJOR_VERSION ${CMAKE_MATCH_1})
    set(CUDA_TOOLKIT_MINOR_VERSION ${CMAKE_MATCH_2})
    message("-- CUDA_TOOLKIT_MAJOR_VERSION = ${CUDA_TOOLKIT_MAJOR_VERSION}")
    message("-- CUDA_TOOLKIT_MINOR_VERSION = ${CUDA_TOOLKIT_MINOR_VERSION}")
endfunction()

