# find dftd4

include(FindPackageHandleStandardArgs)
find_package(PkgConfig REQUIRED)

pkg_search_module(SIRIUS_DFTD4 IMPORTED_TARGET GLOBAL dftd4)
pkg_search_module(SIRIUS_MCTCLIB IMPORTED_TARGET GLOBAL mctc-lib)
pkg_search_module(SIRIUS_MULTICHARGE IMPORTED_TARGET GLOBAL multicharge)

find_package_handle_standard_args(DFTD4 DEFAULT_MSG SIRIUS_DFTD4_LINK_LIBRARIES SIRIUS_DFTD4_INCLUDE_DIRS)

if(SIRIUS_DFTD4_FOUND AND NOT TARGET sirius::dftd4)
  add_library(sirius::dftd4 INTERFACE IMPORTED)
  set_target_properties(sirius::dftd4 PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${SIRIUS_DFTD4_INCLUDE_DIRS}"
    INTERFACE_LINK_LIBRARIES "${SIRIUS_DFTD4_LINK_LIBRARIES}")
endif()

if (SIRIUS_MCTCLIB_FOUND AND NOT TARGET sirius::mctclib)
  add_library(sirius::mctclib INTERFACE IMPORTED)
  set_target_properties(sirius::mctclib PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${SIRIUS_MCTCLIB_INCLUDE_DIRS}"
    INTERFACE_LINK_LIBRARIES "${SIRIUS_MCTCLIB_LINK_LIBRARIES}")
endif()

if (SIRIUS_MULTICHARGE_FOUND AND NOT TARGET sirius::multicharge)
  add_library(sirius::multicharge INTERFACE IMPORTED)
  set_target_properties(sirius::multicharge PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${SIRIUS_MULTICHARGE_INCLUDE_DIRS}"
    INTERFACE_LINK_LIBRARIES "${SIRIUS_MULTICHARGE_LINK_LIBRARIES}")
endif()

mark_as_advanced(
  SIRIUS_DFTD4_FOUND
  SIRIUS_DFTD4_LINK_LIBRARIES
  SIRIUS_DFTD4_LINK_INCLUDE_DIRS
  SIRIUS_MCTCLIB_FOUND
  SIRIUS_MCTCLIB_LINK_LIBRARIES
  SIRIUS_MCTCLIB_LINK_INCLUDE_DIRS
  SIRIUS_MULTICHARGE_FOUND
  SIRIUS_MULTICHARGE_LINK_LIBRARIES
  SIRIUS_MULTICHARGE_LINK_INCLUDE_DIRS)

