# find dftd3

include(FindPackageHandleStandardArgs)
find_package(PkgConfig REQUIRED)

pkg_search_module(SIRIUS_DFTD3 IMPORTED_TARGET GLOBAL s-dftd3)
pkg_search_module(SIRIUS_MCTCLIB IMPORTED_TARGET GLOBAL mctc-lib)

find_package_handle_standard_args(DFTD3 DEFAULT_MSG SIRIUS_DFTD3_LINK_LIBRARIES SIRIUS_DFTD3_INCLUDE_DIRS)

if(SIRIUS_DFTD3_FOUND AND NOT TARGET sirius::dftd3)
  add_library(sirius::dftd3 INTERFACE IMPORTED)
  set_target_properties(sirius::dftd3 PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${SIRIUS_DFTD3_INCLUDE_DIRS}"
    INTERFACE_LINK_LIBRARIES "${SIRIUS_DFTD3_LINK_LIBRARIES}")
endif()

if (SIRIUS_MCTCLIB_FOUND AND NOT TARGET sirius::mctclib)
  add_library(sirius::mctclib INTERFACE IMPORTED)
  set_target_properties(sirius::mctclib PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${SIRIUS_MCTCLIB_INCLUDE_DIRS}"
    INTERFACE_LINK_LIBRARIES "${SIRIUS_MCTCLIB_LINK_LIBRARIES}")
endif()

mark_as_advanced(
  SIRIUS_DFTD3_FOUND
  SIRIUS_DFTD3_LINK_LIBRARIES
  SIRIUS_DFTD3_LINK_INCLUDE_DIRS
  SIRIUS_MCTCLIB_FOUND
  SIRIUS_MCTCLIB_LINK_LIBRARIES
  SIRIUS_MCTCLIB_LINK_INCLUDE_DIRS)
