To submit the tests:

```bash
export MKL_NUM_THREADS=12
export OMP_NUM_THREADS=12
export CRAY_CUDA_MPS=0
export MPIRUN="srun -N4 -n4 -c12 --unbuffered --hint=nomultithread"
salloc -N4 -C gpu --time=60:00 -A csstaff
```

## test01: SrVO3
- ultrasoft pseudopotential
- non-magnetic
- LDA (PZ)

## test02: He atom
- full potential
- non-magnetic
- LDA (VWN)
- iterative Davidson solver

## test03: Fe
- PAW pseudopotential
- magnetic
- GGA (PBE)
- 4x4x4 k-point mesh

## test04: LiF
- PAW pseudopotential
- non-magnetic
- LDA (PZ)
- 4x4x4 k-point mesh

## test05: NiO
- ultrasoft pseudopotential
- collinear magentic, AFM configuration
- LDA (PZ)

## test06: Fe
- ultrasoft pseudopotential
- collinear magentic, FM configuration
- LDA (PZ)

## test07: Ni
- ultrasoft pseudopotential
- collinear magentic, FM configuration
- GGA (PBE for solids)

## test08: Si
- ultrasoft pseudopotential
- non-magentic
- LDA (PZ)
- 1x1x1 k-mesh without Gamma-point treatment

## test09: Ni
- ultrasoft pseudopotential
- non-collinear magentic
- LDA (PZ)

## test10: Au
- norm-conserving pseudopotential
- non-collinear magnetic
- spin-orbit coupling
- LDA (PZ)
- no symmetry

## test11: Au
- ultrasoft pseudopotential
- non-collinear magnetic
- spin-orbit coupling
- LDA (PZ)
- no symmetry

## test12: Au
- norm-conserving pseudopotential
- non-collinear magnetic
- spin-orbit coupling
- Hubbard correction
- LDA (PZ)
- no symmetry

## test13: Au
- ultrasoft pseudopotential
- non-collinear magnetic
- spin-orbit coupling
- Hubbard correction
- LDA (PZ)
- no symmetry

## test14: SrVO3
- ultrasoft pseudopotential
- non-magnetic
- GGA (PBE)

## test15: LiF
- PAW pseudopotential
- non-magnetic
- LDA (PZ)
- Gamma-point case

## test16: NiO
- full potential
- collinear magnetic
- LDA (PZ)

## test17: NiO
- full potential
- non-magnetic
- GGA (PBE)

## test18: YN
- full potential
- non-magnetic
- LDA (PZ)
- IORA treatment of relativity

