// Warning! This is an automatically generated header file!
/** \file atomic_data.hpp
 *  \brief Basic atomic data information.
 */

#ifndef __ATOMIC_DATA_HPP__
#define __ATOMIC_DATA_HPP__

#include <string>
#include <vector>
#include <map>

/// Describes single atomic level.
struct atomic_level_descriptor
{
    /// Principal quantum number.
    int n;

    /// Angular momentum quantum number.
    int l;

    /// Quantum number k.
    int k;

    /// Level occupancy.
    double occupancy;

    /// True if this is a core level.
    bool core;
};

const std::vector<std::string> atomic_symb = {
    "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf"
};

const std::vector<std::string> atomic_name = {
    "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminium", "silicon", "phosphorus", "sulphur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium"
};

const std::map<std::string, int> atomic_zn = {
    {"H", 1}, {"He", 2}, {"Li", 3}, {"Be", 4}, {"B", 5}, {"C", 6}, {"N", 7}, {"O", 8}, {"F", 9}, {"Ne", 10}, {"Na", 11}, {"Mg", 12}, {"Al", 13}, {"Si", 14}, {"P", 15}, {"S", 16}, {"Cl", 17}, {"Ar", 18}, {"K", 19}, {"Ca", 20}, {"Sc", 21}, {"Ti", 22}, {"V", 23}, {"Cr", 24}, {"Mn", 25}, {"Fe", 26}, {"Co", 27}, {"Ni", 28}, {"Cu", 29}, {"Zn", 30}, {"Ga", 31}, {"Ge", 32}, {"As", 33}, {"Se", 34}, {"Br", 35}, {"Kr", 36}, {"Rb", 37}, {"Sr", 38}, {"Y", 39}, {"Zr", 40}, {"Nb", 41}, {"Mo", 42}, {"Tc", 43}, {"Ru", 44}, {"Rh", 45}, {"Pd", 46}, {"Ag", 47}, {"Cd", 48}, {"In", 49}, {"Sn", 50}, {"Sb", 51}, {"Te", 52}, {"I", 53}, {"Xe", 54}, {"Cs", 55}, {"Ba", 56}, {"La", 57}, {"Ce", 58}, {"Pr", 59}, {"Nd", 60}, {"Pm", 61}, {"Sm", 62}, {"Eu", 63}, {"Gd", 64}, {"Tb", 65}, {"Dy", 66}, {"Ho", 67}, {"Er", 68}, {"Tm", 69}, {"Yb", 70}, {"Lu", 71}, {"Hf", 72}, {"Ta", 73}, {"W", 74}, {"Re", 75}, {"Os", 76}, {"Ir", 77}, {"Pt", 78}, {"Au", 79}, {"Hg", 80}, {"Tl", 81}, {"Pb", 82}, {"Bi", 83}, {"Po", 84}, {"At", 85}, {"Rn", 86}, {"Fr", 87}, {"Ra", 88}, {"Ac", 89}, {"Th", 90}, {"Pa", 91}, {"U", 92}, {"Np", 93}, {"Pu", 94}, {"Am", 95}, {"Cm", 96}, {"Bk", 97}, {"Cf", 98}, {"Es", 99}, {"Fm", 100}, {"Md", 101}, {"No", 102}, {"Lr", 103}, {"Rf", 104}
};

const std::vector<std::vector<atomic_level_descriptor>> atomic_conf = {
    { // H, z = 1
        {1, 0, 1, 1.000000}, 
    },
    { // He, z = 2
        {1, 0, 1, 2.000000}, 
    },
    { // Li, z = 3
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 1.000000}, 
    },
    { // Be, z = 4
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
    },
    { // B, z = 5
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 1.000000}, 
    },
    { // C, z = 6
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 1.000000}, 
        {2, 1, 2, 1.000000}, 
    },
    { // N, z = 7
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 1.000000}, 
        {2, 1, 2, 2.000000}, 
    },
    { // O, z = 8
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 2.000000}, 
    },
    { // F, z = 9
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 3.000000}, 
    },
    { // Ne, z = 10
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
    },
    { // Na, z = 11
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 1.000000}, 
    },
    { // Mg, z = 12
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
    },
    { // Al, z = 13
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 1.000000}, 
    },
    { // Si, z = 14
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 1.000000}, 
        {3, 1, 2, 1.000000}, 
    },
    { // P, z = 15
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 1.000000}, 
        {3, 1, 2, 2.000000}, 
    },
    { // S, z = 16
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 2.000000}, 
    },
    { // Cl, z = 17
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 3.000000}, 
    },
    { // Ar, z = 18
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
    },
    { // K, z = 19
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {4, 0, 1, 1.000000}, 
    },
    { // Ca, z = 20
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Sc, z = 21
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 1.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Ti, z = 22
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 2.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // V, z = 23
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 3.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Cr, z = 24
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 3.000000}, 
        {3, 2, 3, 2.000000}, 
        {4, 0, 1, 1.000000}, 
    },
    { // Mn, z = 25
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 3.000000}, 
        {3, 2, 3, 2.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Fe, z = 26
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 2.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Co, z = 27
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 3.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Ni, z = 28
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 4.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Cu, z = 29
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 1.000000}, 
    },
    { // Zn, z = 30
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
    },
    { // Ga, z = 31
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 1.000000}, 
    },
    { // Ge, z = 32
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 1.000000}, 
        {4, 1, 2, 1.000000}, 
    },
    { // As, z = 33
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 1.000000}, 
        {4, 1, 2, 2.000000}, 
    },
    { // Se, z = 34
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 2.000000}, 
    },
    { // Br, z = 35
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 3.000000}, 
    },
    { // Kr, z = 36
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
    },
    { // Rb, z = 37
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {5, 0, 1, 1.000000}, 
    },
    { // Sr, z = 38
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {5, 0, 1, 2.000000}, 
    },
    { // Y, z = 39
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 1.000000}, 
        {5, 0, 1, 2.000000}, 
    },
    { // Zr, z = 40
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 2.000000}, 
        {5, 0, 1, 2.000000}, 
    },
    { // Nb, z = 41
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 3.000000}, 
        {4, 2, 3, 1.000000}, 
        {5, 0, 1, 1.000000}, 
    },
    { // Mo, z = 42
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 3.000000}, 
        {4, 2, 3, 2.000000}, 
        {5, 0, 1, 1.000000}, 
    },
    { // Tc, z = 43
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 1.000000}, 
        {5, 0, 1, 2.000000}, 
    },
    { // Ru, z = 44
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 3.000000}, 
        {5, 0, 1, 1.000000}, 
    },
    { // Rh, z = 45
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 4.000000}, 
        {5, 0, 1, 1.000000}, 
    },
    { // Pd, z = 46
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
    },
    { // Ag, z = 47
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 1.000000}, 
    },
    { // Cd, z = 48
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
    },
    { // In, z = 49
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 1.000000}, 
    },
    { // Sn, z = 50
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 1.000000}, 
        {5, 1, 2, 1.000000}, 
    },
    { // Sb, z = 51
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 1.000000}, 
        {5, 1, 2, 2.000000}, 
    },
    { // Te, z = 52
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 2.000000}, 
    },
    { // I, z = 53
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 3.000000}, 
    },
    { // Xe, z = 54
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
    },
    { // Cs, z = 55
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 1.000000}, 
    },
    { // Ba, z = 56
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // La, z = 57
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 1.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Ce, z = 58
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 1.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 1.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Pr, z = 59
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 3.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Nd, z = 60
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 3.000000}, 
        {4, 3, 4, 1.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Pm, z = 61
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 3.000000}, 
        {4, 3, 4, 2.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Sm, z = 62
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 3.000000}, 
        {4, 3, 4, 3.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Eu, z = 63
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 3.000000}, 
        {4, 3, 4, 4.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Gd, z = 64
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 3.000000}, 
        {4, 3, 4, 4.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 1.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Tb, z = 65
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 5.000000}, 
        {4, 3, 4, 4.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Dy, z = 66
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 4.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Ho, z = 67
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 5.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Er, z = 68
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 6.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Tm, z = 69
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 7.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Yb, z = 70
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Lu, z = 71
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 1.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Hf, z = 72
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 2.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Ta, z = 73
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 3.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // W, z = 74
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 3.000000}, 
        {5, 2, 3, 1.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Re, z = 75
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 3.000000}, 
        {5, 2, 3, 2.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Os, z = 76
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 2.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Ir, z = 77
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 3.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Pt, z = 78
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 5.000000}, 
        {6, 0, 1, 1.000000}, 
    },
    { // Au, z = 79
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 1.000000}, 
    },
    { // Hg, z = 80
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
    },
    { // Tl, z = 81
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 1.000000}, 
    },
    { // Pb, z = 82
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 1.000000}, 
        {6, 1, 2, 1.000000}, 
    },
    { // Bi, z = 83
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 1.000000}, 
        {6, 1, 2, 2.000000}, 
    },
    { // Po, z = 84
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 2.000000}, 
    },
    { // At, z = 85
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 3.000000}, 
    },
    { // Rn, z = 86
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
    },
    { // Fr, z = 87
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 1.000000}, 
    },
    { // Ra, z = 88
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Ac, z = 89
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 1.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Th, z = 90
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 2.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Pa, z = 91
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 2.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 1.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // U, z = 92
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 3.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 1.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Np, z = 93
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 3.000000}, 
        {5, 3, 4, 1.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 1.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Pu, z = 94
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 3.000000}, 
        {5, 3, 4, 3.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Am, z = 95
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 3.000000}, 
        {5, 3, 4, 4.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Cm, z = 96
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 3.000000}, 
        {5, 3, 4, 4.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 1.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Bk, z = 97
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 5.000000}, 
        {5, 3, 4, 4.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Cf, z = 98
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 4.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Es, z = 99
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 5.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Fm, z = 100
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 6.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Md, z = 101
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 7.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // No, z = 102
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 8.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Lr, z = 103
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 8.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 1.000000}, 
        {7, 0, 1, 2.000000}, 
    },
    { // Rf, z = 104
        {1, 0, 1, 2.000000}, 
        {2, 0, 1, 2.000000}, 
        {2, 1, 1, 2.000000}, 
        {2, 1, 2, 4.000000}, 
        {3, 0, 1, 2.000000}, 
        {3, 1, 1, 2.000000}, 
        {3, 1, 2, 4.000000}, 
        {3, 2, 2, 4.000000}, 
        {3, 2, 3, 6.000000}, 
        {4, 0, 1, 2.000000}, 
        {4, 1, 1, 2.000000}, 
        {4, 1, 2, 4.000000}, 
        {4, 2, 2, 4.000000}, 
        {4, 2, 3, 6.000000}, 
        {4, 3, 3, 6.000000}, 
        {4, 3, 4, 8.000000}, 
        {5, 0, 1, 2.000000}, 
        {5, 1, 1, 2.000000}, 
        {5, 1, 2, 4.000000}, 
        {5, 2, 2, 4.000000}, 
        {5, 2, 3, 6.000000}, 
        {5, 3, 3, 6.000000}, 
        {5, 3, 4, 8.000000}, 
        {6, 0, 1, 2.000000}, 
        {6, 1, 1, 2.000000}, 
        {6, 1, 2, 4.000000}, 
        {6, 2, 2, 2.000000}, 
        {7, 0, 1, 2.000000}, 
    },
};

const std::vector<double> atomic_energy_NIST_LDA = {
      -0.4456710,   -2.8348360,   -7.3351950,  -14.4472090,  -24.3441980,  -37.4257490,  -54.0250160,  -74.4730770,  -99.0996480, -128.2334810, -161.4400600, -199.1394060, -241.3155730, -288.1983970, -339.9462190, -396.7160810, -458.6641790, -525.9461950, -598.2005900, -675.7422830, -758.6792750, -847.2772160, -941.6789040, -1042.0302380, -1148.4493720, -1261.0930560, -1380.0912640, -1505.5801970, -1637.7858610, -1776.5738500, -1921.8464560, -2073.8073320, -2232.5349780, -2398.1114400, -2570.6207000, -2750.1479400, -2936.3372930, -3129.4531610, -3329.5206040, -3536.7377510, -3751.1961750, -3973.0132350, -4202.1888570, -4438.9812280, -4683.3010310, -4935.3684060, -5195.0312150, -5462.3909820, -5737.3090640, -6019.9533530, -6310.3762680, -6608.6314130, -6914.7730920, -7228.8561070, -7550.5577100, -7880.1115780, -8217.5752300, -8563.3602850, -8917.6643690, -9280.3110370, -9651.4841340, -10031.2590900, -10419.7107750, -10816.6538770, -11222.9419750, -11637.8696640, -12061.7705490, -12494.7183040, -12936.7864940, -13388.0485940, -13848.2303750, -14317.4937200, -14795.8842020, -15283.4488220, -15780.2360240, -16286.2954080, -16801.6774710, -17326.5763770, -17860.7909430, -18404.2742200, -18956.9576270, -19518.9931450, -20090.4144490, -20671.2565390, -21261.5552150, -21861.3468690, -22470.3196550, -23088.6880830, -23716.4969520, -24353.8322310, -25001.2913820, -25658.4178890,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000,    0.0000000
};

#endif
