# -*- coding: utf-8 -*-
# HQ XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
# HQ X
# HQ X   quippy: Python interface to QUIP atomistic simulation library
# HQ X
# HQ X   Copyright James Kermode 2010
# HQ X
# HQ X   These portions of the source code are released under the GNU General
# HQ X   Public License, version 2, http://www.gnu.org/copyleft/gpl.html
# HQ X
# HQ X   If you would like to license the source code under different terms,
# HQ X   please contact James Kermode, james.kermode@gmail.com
# HQ X
# HQ X   When using this software, please cite the following reference:
# HQ X
# HQ X   http://www.jrkermode.co.uk/quippy
# HQ X
# HQ XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

#
# quippy documentation build configuration file, created by
# sphinx-quickstart on Wed Sep  2 14:17:01 2009.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import glob
import os
import sys

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

sys.path.insert(1, os.path.abspath('..'))
sys.path.insert(1, os.path.abspath('.'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
needs_sphinx = '1.4'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.mathjax',
    'sphinx.ext.autosummary',
    'sphinx.ext.intersphinx',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'nbsphinx',
#    'modcontents',
    'numpydoc',
    'video']

# This list was generated by grep as a workaround to
# https://github.com/sphinx-doc/sphinx/issues/2485
autosummary_generate = True

nbsphinx_allow_errors = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ['.rst', '.ipynb']

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'quippy'
copyright = u'2008-2020, James Kermode'
author= u'James Kermode'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
import os
version=os.popen('cat ../GIT_VERSON 2> /dev/null|| '
                 'git describe --always --tags --dirty=+ 2> /dev/null || '
                 'echo ').read().strip()
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store', '**.ipynb_checkpoints']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
modindex_common_prefix = ['quippy.']


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
}

html_logo = 'hybrid.png'
html_favicon = 'favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Fix for RTD tables
html_context = {
    'css_files': [
        '_static/theme_overrides.css',
    ],
}

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'quippydoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'quippy.tex', u'quippy Documentation',
     u'James Kermode', 'manual'),
]

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'quippy', u'quippy Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'quippy', u'quippy Documentation',
     author, 'quippy', 'One line description of project.',
     'Miscellaneous'),
]


intersphinx_mapping = {'python': ('https://docs.python.org/', None),
                       'ase': ('https://wiki.fysik.dtu.dk/ase/', None),
                       'numpy': ('https://docs.scipy.org/doc/numpy/', None),
                       'matplotlib': ('https://matplotlib.org/', None)}

###
### sphinx-quickstart output ends here
###

# classnames = [v.__name__ for v in FortranDerivedTypes.values()]
# classname_re = re.compile('(^|\s+)((``)?)('+'|'.join([v.__name__ for v in FortranDerivedTypes.values()])+r')\2(?=[\s\W]+)')
# method_or_attr_re = re.compile('(^|\s+)((``)?)('+'|'.join([v.__name__+'\.([a-zA-Z][a-zA-Z0-9_]*)' for v in FortranDerivedTypes.values()])+r')\2(?=[\s\W]+)')

# doc_subs = [(classname_re, r'\1:class:`~.\4`'),
#             (method_or_attr_re, r'\1:meth:`.\4`')]

global_options = None

def process_docstring(app, what, name, obj, options, lines):
    global global_options
    global_options = options

def process_signature(app, what, name, obj, options, signature, return_annotation):
    return (signature, return_annotation)

#def maybe_skip_member(app, what, name, obj, skip, options):
#    if hasattr(FortranDerivedType, name) and options.inherited_members:
#        return True
#    return skip

from docutils import nodes, utils
from docutils.parsers.rst.roles import set_classes

def get_github_url(view, path):
    return 'https://github.com/{project}/{view}/{branch}/{path}'.format(
        project='libAtoms/QUIP',
        view=view,
        branch='public',
        path=path)

def github_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    if text[-1] == '>':
        i = text.index('<')
        name = text[:i - 1]
        text = text[i + 1:-1]
    else:
        name = text
    ref = get_github_url('blob', name)
    set_classes(options)
    node = nodes.reference(rawtext, name, refuri=ref, **options)
    return [node], []

def mol_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    n = []
    t = ''
    while text:
        if text[0] == '_':
            n.append(nodes.Text(t))
            t = ''
            n.append(nodes.subscript(text=text[1]))
            text = text[2:]
        else:
            t += text[0]
            text = text[1:]
    n.append(nodes.Text(t))
    return n, []

def setup(app):
    app.connect('autodoc-process-docstring', process_docstring)
    app.connect('autodoc-process-signature', process_signature)
    #app.connect('autodoc-skip-member', maybe_skip_member)

    app.add_role('git', github_role)
    app.add_role('mol', mol_role)


autodoc_member_order = 'groupwise'
#autoclass_content = 'both'

def add_line(self, line, source, *lineno):
    """Append one line of generated reST to the output."""
    sys.stdout.write(self.indent + line + '\n')
    self.directive.result.append(self.indent + line, source, *lineno)

# Uncomment two lines below to debug autodoc rst output

#import sphinx.ext.autodoc
#sphinx.ext.autodoc.Documenter.add_line = add_line

# Monkey patch numpydoc to exclude methods and attributes inherited
# from base classes, and to include attributes wrapped by Python
# properties

numpydoc_show_class_members = True

import inspect
import pydoc
import numpydoc
import numpydoc.docscrape

@property
def methods(self):
    if self._cls is None:
        return []
    do_inherited = False
    if global_options is not None and hasattr(global_options, 'inherited_members'):
        do_inherited = global_options.inherited_members

    return [name for name,func in inspect.getmembers(self._cls)
            if not name.startswith('_') and callable(func) and
            (do_inherited or not any(hasattr(base, name) for base in self._cls.__bases__)) and
            pydoc.getdoc(getattr(self._cls, name))]

@property
def properties(self):
    if self._cls is None:
        return []
    do_inherited = False
    if global_options is not None and hasattr(global_options, 'inherited_members'):
        do_inherited = global_options.inherited_members
    return [name for name,func in inspect.getmembers(self._cls) if not name.startswith('_') and
            (do_inherited or not any(hasattr(base, name) for base in self._cls.__bases__)) and
            (func is None or isinstance(getattr(self._cls, name), property)) and
            pydoc.getdoc(getattr(self._cls, name))]

numpydoc.docscrape.ClassDoc.methods = methods
numpydoc.docscrape.ClassDoc.properties = properties

# generate .rst versions of any .ipynb notebooks under Examples/
# Superseded by nbsphinx extension
# for notebook in glob.glob(os.path.join('Examples/*.ipynb')):
    # cmd = 'jupyter nbconvert --to rst {0}'.format(notebook)
    # print cmd
    # os.system(cmd)
