# HQ XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
# HQ X
# HQ X   quippy: Python interface to QUIP atomistic simulation library
# HQ X
# HQ X   Copyright James Kermode 2010
# HQ X
# HQ X   These portions of the source code are released under the GNU General
# HQ X   Public License, version 2, http://www.gnu.org/copyleft/gpl.html
# HQ X
# HQ X   If you would like to license the source code under different terms,
# HQ X   please contact James Kermode, james.kermode@gmail.com
# HQ X
# HQ X   When using this software, please cite the following reference:
# HQ X
# HQ X   http://www.jrkermode.co.uk/quippy
# HQ X
# HQ XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

from quippy import *
import unittest, quippy
import numpy as np
from quippytest import *

if hasattr(quippy, 'Potential'):

   class TestMDIonImplant(QuippyTestCase):
       def setUp(self):

          verbosity_push(PRINT_SILENT)

          self.pot = Potential('IP Brenner', param_str="""<Brenner_params n_types="1" label="graphene">
 <!-- 2nd set of parameters from Brenner (1990), with Re scaled to
  give graphene lattice constant of 1.42 A and delta and shift modified
  to match ab initio graphene elastic constants, as described in Arroyo
  et al, Phys. Rev. B. 69 115415 (2004).
  Gives Poission ratio 0.149, Youngs modulus in plane 342 J/m^2 and
  bending modulus 3.9 eV A^2 per atom, in very good agreement with
  Kudin et al, Phys. Rev. B. 64 235406 (2001) -->

  <per_type_data type="1" atomic_num="6" />
  <per_pair_data atnum_i="6" atnum_j="6" R1="1.7" R2="2.0" De="6.0" S="1.22"
     beta="2.1" delta="0.95" Re="1.360" shift="0.03" />
  <per_triplet_data atnum_c="6" atnum_j="6" atnum_k="6"
     a0="0.00020813" c0="330.0" d0="3.5" />
</Brenner_params>""")
           
          at = Atoms("""64
Lattice="7.12 0 0 0 7.12 0 0 0 7.12" Properties=Z:I:1:pos:R:3:velo:R:3
6 0 0 0 0.415235 0.61453 0.0
6 0 1.78 1.78 0.000582817358074157 0.00711434237220994 -0.00700331753800338
6 1.78 0 1.78 0.000691051967098114 0.00911786524377025 0.00404808356821055
6 1.78 1.78 0 0.00541240283361818 0.00290837758821486 -0.00788969171584108
6 0.89 0.89 0.89 0.000749694574792776 -0.00226058389488437 -0.00971224580098319
6 0.89 2.67 2.67 0.00251567336477376 0.00965608099009072 0.000656877031548979
6 2.67 0.89 2.67 -0.000398645946031071 0.00540062824865786 0.00840680057629011
6 2.67 2.67 0.89 -0.00727055346889471 0.00108125023976499 -0.0067801143187229
6 0 0 3.56 0.00235416851652825 -0.0092764872267075 0.00289908180783497
6 0 1.78 5.34 -0.00795992494903086 0.00472033680766267 -0.00378919717460323
6 1.78 0 5.34 0.00244126768674709 -0.00126777291523774 0.00961420635918712
6 1.78 1.78 3.56 0.00403228062791218 0.00679639153063546 -0.00612778712914138
6 0.89 0.89 4.45 -0.00280471737685911 -0.00636340308907936 0.00718614371981523
6 0.89 2.67 6.23 0.0098776194799066 -0.000106258458750824 -0.00155606637072897
6 2.67 0.89 6.23 0.000571778883477875 0.00566016437058379 0.00822408707434343
6 2.67 2.67 4.45 0.00736657993533068 -0.0015503399326447 0.00658254860594516
6 0 3.56 0 0.0077182163359258 0.00168852946911158 0.00613009011547057
6 0 5.34 1.78 -0.00475387158053442 0.00742363478845529 0.00472126588145844
6 1.78 3.56 1.78 -0.00226702763569842 0.00399158108566776 -0.00888413564369202
6 1.78 5.34 0 -0.00319468672341559 0.00947520481244332 0.000120293397504439
6 0.89 4.45 0.89 -0.00431891255746487 -0.00849355185078958 -0.00303423322750925
6 0.89 6.23 2.67 -0.000468031984564935 0.00607034206254805 0.0079329624545364
6 2.67 4.45 2.67 -0.00634296982660629 -0.00770644115291309 -0.000614409094536994
6 2.67 6.23 0.89 -0.00892019276495729 -0.00430390117592737 0.00138079531569838
6 0 3.56 3.56 -0.00377992934719245 0.009225802933909 -0.000772459937413849
6 0 5.34 5.34 0.00846485113497382 -0.00417103714505493 -0.0033088886952124
6 1.78 3.56 5.34 0.00564592032300588 -0.00143428287996107 0.00812812501912463
6 1.78 5.34 3.56 -0.00285588789180515 -0.00797801825872644 -0.00530990856916277
6 0.89 4.45 4.45 0.00734194804243505 0.00425119186301066 -0.0052936912155939
6 0.89 6.23 6.23 0.00874835735755321 -0.000241335200336796 -0.00483818156600422
6 2.67 4.45 6.23 -0.005442223096089 -0.00259956316529145 0.00797649541603675
6 2.67 6.23 4.45 0.00727931452901534 0.00103907332575777 0.00677730821280579
6 3.56 0 0 0.00211420858150929 0.00879153879561974 0.00427071044195055
6 3.56 1.78 1.78 0.0093897261812777 -0.00340768754745186 0.00046979550824754
6 5.34 0 1.78 -0.00162144288636289 -0.00393749278604932 0.00904804252455042
6 5.34 1.78 0 -0.00909610548667998 -0.00362675953864004 0.0020266919410887
6 4.45 0.89 0.89 0.00658988954959562 -0.00680186041933854 0.00321061529304994
6 4.45 2.67 2.67 0.0065012893953224 -0.0035254447297442 -0.00673085994920317
6 6.23 0.89 2.67 -0.00448869019378356 0.00744689453500237 0.00493917221088545
6 6.23 2.67 0.89 -0.000448352720396697 0.00217545330663632 -0.00975019911328779
6 3.56 0 3.56 -0.0049644059342509 0.00845507455998892 0.00196631327743129
6 3.56 1.78 5.34 0.00934289830274702 -0.00315581638110768 -0.00165863626912574
6 5.34 0 5.34 -0.00878461502661844 -0.00181983231857224 -0.00441800284816449
6 5.34 1.78 3.56 -0.00147167005243527 -0.00970539609169646 -0.00190774053792653
6 4.45 0.89 4.45 0.00334008992816498 0.000815864092480208 -0.00939032294728846
6 4.45 2.67 6.23 -0.00772510638017523 0.00634608489423106 -0.000223467962330837
6 6.23 0.89 6.23 -0.000497827408624023 0.00896600824690109 0.00440032544111505
6 6.23 2.67 4.45 0.00495334071376607 0.00595827892087733 0.00632165548526463
6 3.56 3.56 0 0.00199675073928175 -0.00942443820125607 0.00268196776190225
6 3.56 5.34 1.78 -7.1814845506717e-05 0.00740137614902591 0.00672417085807575
6 5.34 3.56 1.78 -0.00617894933881039 0.00780910388866579 0.000915686367944549
6 5.34 5.34 0 0.0089053893337024 -0.00399792266478582 -0.00217040438203836
6 4.45 4.45 0.89 0.00118534590656567 -0.00796780465682525 -0.00592528851892141
6 4.45 6.23 2.67 -0.00649113958444054 0.0060603644978977 -0.00459750900466006
6 6.23 4.45 2.67 -0.00433209204529156 0.00727077163128063 0.00532624242753617
6 6.23 6.23 0.89 0.00503426626667666 0.000627481721582709 -0.00861756519240099
6 3.56 3.56 3.56 -0.00465417907869825 -0.00528819107506711 0.00709743983820843
6 3.56 5.34 5.34 0.0025558178373565 0.000917635402958432 -0.00962422674553585
6 5.34 3.56 5.34 -0.00445817971615035 0.00670571020771072 -0.0059294252865442
6 5.34 5.34 3.56 0.00784683153254821 0.00526403263894811 -0.00327371276624816
6 4.45 4.45 4.45 0.00543094622197639 -0.001823116009368 0.00819640598984619
6 4.45 6.23 6.23 0.00378477599894336 -0.00216223975692277 -0.0090000105484052
6 6.23 4.45 6.23 -0.00924378031234806 0.000428670913396328 0.00379061562085293
6 6.23 6.23 4.45 -0.0098571449499882 0.000171478590631485 -0.0016754965018994""", format='string')
          self.ds = DynamicalSystem(at)
          self.ds.atoms.set_cutoff(self.pot.cutoff(), cutoff_skin=1.0)
          self.ds.atoms.calc_connect()
          self.ds.run(self.pot, dt=0.05, n_steps=1000, hook=lambda:None, hook_interval=1000)

          self.ref_at = Atoms("""64
Lattice="7.120000 0.000000 0.000000 0.000000 7.120000 0.000000 0.000000 0.000000 7.120000" Properties=Z:I:1:pos:R:3:velo:R:3
6               1.26840931     -2.32821105      0.46991304       -0.03608236     -0.04302404     -0.03869805   
6              -0.22400122      2.09843545      1.04885766       -0.04546542     -0.01157335     -0.05436839   
6               2.46147711      1.10028966      1.84827352        0.03369534     -0.00458499      0.00577820   
6              -1.91624083      1.50910764     -0.69094047        0.04454445      0.00432515     -0.11056071   
6               0.78952632      1.40142051      1.63000392       -0.07763986     -0.03914861      0.08153434   
6               1.16271570      3.51258102      2.20224749       -0.00695291      0.02683916      0.04623817   
6               3.16556085      2.12577768      2.71751379        0.00288113      0.03836328     -0.01333970   
6               2.91285117      3.30348287      0.60671967        0.06029720      0.06981579      0.04420135   
6               0.82411606      0.98669969      3.02738820        0.04779816      0.04865544     -0.10799351   
6               0.08778232      2.77934298     -1.43292064        0.05948836     -0.01147778      0.01102725   
6               2.53696254     -0.27036305     -1.56833847       -0.01406345      0.02453723      0.02277390   
6               2.43678850      1.44353767     -2.73832363        0.00407009     -0.02580241      0.05741171   
6               0.96018251      1.12363546     -2.72232696        0.07764401     -0.03245139      0.10193700   
6               0.92053554     -3.00236324     -3.30655724       -0.00523295      0.07624580      0.02045037   
6               2.59708594      2.29834868     -0.52686076       -0.05134949     -0.02928492      0.09899273   
6               2.40519167      2.85352164     -3.00933102       -0.04366822     -0.01782237     -0.03842623   
6              -0.86894106     -3.30907403      0.12463316       -0.00450876      0.09922256      0.07199627   
6               0.45605521     -1.34028310      0.72723159        0.02650917     -0.04203256     -0.01353725   
6               2.20567187      3.43029531      1.87929192       -0.07986286      0.10235575      0.01142152   
6               2.26390484     -2.72779064     -0.52253290       -0.03674536      0.03079538      0.02421947   
6               1.22532304     -1.19751416      2.86876798        0.01530669     -0.00747511      0.04238487   
6               1.66086335     -0.11944627      3.09919463       -0.00812186      0.04374606      0.00123521   
6               2.92559330     -2.27542800      2.10983131        0.01459024     -0.01765640     -0.01450467   
6               3.06297681      0.03837777      0.97969405        0.02539296     -0.11250668     -0.03190858   
6               0.28924453     -1.65787098      3.24340337       -0.04627861      0.01083560     -0.00424064   
6               0.56030872     -0.17073195     -2.17696778        0.00105925      0.07545190     -0.02864812   
6               1.53819460      2.76946762     -1.52066048        0.01891902      0.03856486     -0.03195807   
6               2.56036112     -2.25460302     -2.51181117        0.00308932      0.00757184      0.01355107   
6               0.58811825     -2.22908432     -2.04645831       -0.00036927     -0.02488962      0.04632157   
6               0.36155133     -1.04167346     -1.02426112       -0.02098245     -0.06617168     -0.06277505   
6              -3.36940533     -2.51869295     -1.80652877        0.07572598      0.09652475     -0.06054878   
6               3.26015291     -0.62864037     -2.49440011        0.02583390      0.03396200     -0.05565609   
6               2.51864584     -0.43950415     -0.15416756       -0.01485090     -0.01324857     -0.01258171   
6              -2.69755172      1.54065727      1.88281574        0.05176309     -0.07619375     -0.00935009   
6              -1.25493133      0.10914524      2.25709576       -0.02685073     -0.00003769     -0.00205571   
6               1.00605341      0.71997525     -0.55090494       -0.07361465      0.02703958      0.02389241   
6              -2.86407663      0.68742714      0.20027493        0.02665348      0.00914255      0.01877482   
6              -2.52574802      3.49468135      2.47000453        0.08849526      0.09766030      0.01073731   
6              -0.79842819      1.21117144      3.05793445        0.03255716      0.05075650      0.00815202   
6              -1.66502278      1.69689930      1.37136552        0.01641313     -0.08917251      0.00845427   
6              -3.45229954     -0.28317349      3.39164260       -0.03172855     -0.04444343     -0.03324873   
6               3.54763076      2.14227197     -1.39996334        0.00843172      0.06039688     -0.06709431   
6              -2.06486804      0.41080253     -2.30832006        0.02576730     -0.03049802     -0.00097628   
6              -1.72290580      2.29199836     -3.35080145       -0.03706279      0.06029197     -0.00034876   
6              -2.98576010      1.98814357     -2.52261295        0.01859763      0.03512061      0.00573362   
6              -1.61420226      2.69578241      0.58665249       -0.00452992     -0.04432901      0.00328930   
6               0.26046797      1.89872005     -0.27685541        0.00664285      0.01738966     -0.01497712   
6              -1.08447357      2.93634382     -2.51267648        0.00068533      0.04650694     -0.03042816   
6              -2.57673940      3.44112000      1.23121718        0.09768451      0.02199706      0.06253780   
6              -3.59560071     -1.50965843      1.58506646       -0.01475048      0.07918682      0.03330348   
6              -0.91565362     -3.43678455      2.37567732        0.05871838      0.01088496      0.02859452   
6              -1.30422325     -0.69038945     -0.20204898        0.00184778      0.02745385      0.01602225   
6              -2.93686757     -1.94688412      0.47265423        0.04930805      0.01411614     -0.01525945   
6              -2.40124721     -0.31577328      2.60739637        0.05596466      0.02606004     -0.01603662   
6              -0.55804405     -2.08674729      2.38741544        0.05700433      0.05848857      0.05104911   
6              -0.79189952     -0.31276130      0.98925116       -0.06790968     -0.01646740      0.02428109   
6               3.17138015     -3.18719313      3.50730577       -0.07401168     -0.00156759     -0.00621164   
6              -2.23156429     -1.67402092     -1.65240051        0.07325447     -0.00465169      0.00567454   
6              -1.18343377     -2.86320805     -2.23755852       -0.04522934      0.03677359      0.02775649   
6              -1.68750929     -1.54377723      3.14997711       -0.01412870      0.01838607     -0.04789355   
6              -2.05972724     -2.83542425     -3.33285085        0.00118283      0.02669478     -0.05749274   
6              -2.35584073     -1.19264229     -0.44034865        0.04072683     -0.09859978     -0.01931290   
6              -0.85750354     -2.64123103     -0.95812296        0.07405903      0.02704590     -0.03010984   
6              -1.24510108     -0.62023568     -2.86966893       -0.00977441      0.00327167      0.00317724""",format='string')
          self.ref_at.map_into_cell()

       def tearDown(self):
          verbosity_pop()

       def test_final_state(self):
	  self.ds.atoms.set_map_shift()
          self.assertArrayAlmostEqual(self.ds.atoms.pos+np.dot(self.ds.atoms.lattice, self.ds.atoms.map_shift), self.ref_at.pos)
          self.assertArrayAlmostEqual(self.ds.atoms.velo, self.ref_at.velo)

           
if __name__ == '__main__':
   unittest.main()

