#!/bin/bash

test -e

if [ -z $QUIP_ROOT ]; then
   echo "$0: Need QUIP_ROOT defined"
   exit 1
fi
if [ -z $QUIP_ARCH ]; then
   echo "$0: Need QUIP_ARCH defined"
   exit 1
fi

mydir=`dirname $0`
bindir=$mydir/../build/$QUIP_ARCH

if [ ! -x $bindir/md ]; then
   (cd $QUIP_ROOT && make Programs) || exit 2
fi

TEST=test_md.sh

cat<<EOF > ${TEST}.in.xyz
8
Lattice="5.428835          0.000000          0.000000          0.000000          5.428835          0.000000          0.000000          0.000000          5.428835" Properties=species:S:1:pos:R:3
  Si      0.1000000      0.0000000      0.0000000
  Si      2.7144176      2.6144176      0.0000000
  Si      2.7144176      0.0000000      2.7144176
  Si      0.0000000      2.7144176      2.7144176
  Si      1.3572088      1.3572088      1.3572088
  Si      4.0716264      4.0716264      1.3572088
  Si      4.0716264      1.3572088      4.0716264
  Si      1.3572088      4.0716264      4.0716264
EOF

cat<<EOF2 > ${TEST}.traj_ref.xyz
Si 0.0950480908 0.0015295518 -0.0189411140
Si 2.7048749771 2.6311280035 0.0199746034
Si 2.7248334653 -0.0074628139 2.7298934623
Si 0.0306004845 2.7089328501 2.6801617625
Si 1.3545184589 1.3545295683 1.3545528448
Si 4.0990578499 4.0589760821 1.3301846866
Si 4.0959053233 1.3752202183 4.0672757132
Si 1.3571697229 4.0675027854 4.0499129601
EOF2

cat<<EOF3 > ${TEST}.out_ref
STAT        0.00      0.0000      0.0000    0.00E+00      0.00000000E+00      0.00000000E+00      0.00000000E+00     -0.34502725E+02     -0.34502725E+02
STAT        1.00      3.8651      0.0385    0.28E+01      0.00000000E+00      0.00000000E+00      0.39968626E-02     -0.34500324E+02     -0.34500324E+02
STAT        2.00     23.1251      0.2682    0.16E+02      0.00000000E+00      0.00000000E+00      0.23913364E-01     -0.34475903E+02     -0.34475903E+02
STAT        3.00     60.9994      0.8725    0.25E+02      0.00000000E+00      0.00000000E+00      0.63078646E-01     -0.34436118E+02     -0.34436118E+02
STAT        4.00    111.7438      1.9756    0.25E+02      0.00000000E+00      0.00000000E+00      0.11555273E+00     -0.34385531E+02     -0.34385531E+02
STAT        5.00    161.2547      3.5605    0.31E+02      0.00000000E+00      0.00000000E+00      0.16675127E+00     -0.34339608E+02     -0.34339608E+02
STAT        6.00    187.6318      5.3920    0.39E+02      0.00000000E+00      0.00000000E+00      0.19402744E+00     -0.34318263E+02     -0.34318263E+02
STAT        7.00    221.2635      7.5400    0.48E+02      0.00000000E+00      0.00000000E+00      0.22880557E+00     -0.34288323E+02     -0.34288323E+02
STAT        8.00    259.0812     10.0429    0.56E+02      0.00000000E+00      0.00000000E+00      0.26791226E+00     -0.34251149E+02     -0.34251149E+02
STAT        9.00    291.0607     12.8390    0.52E+02      0.00000000E+00      0.00000000E+00      0.30098185E+00     -0.34217134E+02     -0.34217134E+02
STAT       10.00    320.1768     15.8971    0.48E+02      0.00000000E+00      0.00000000E+00      0.33109042E+00     -0.34190241E+02     -0.34190241E+02
STAT       10.00    320.1768     15.8971    0.48E+02      0.00000000E+00      0.00000000E+00      0.33109042E+00     -0.34190241E+02     -0.34190241E+02
EOF3
# originally the test used rng_seed=1
# after the change in commit 8facdc861fa3e26f87ccb38bad4e64267bd9a8a3 this needed changing
# rng_seed=2065775975 gives 1 after 100 iterations
${MPIRUN} $bindir/md pot_init_args='{IP SW}' params_in_file=$QUIP_ROOT/share/Parameters/ip.parms.SW.xml trajectory_out_file=${TEST}.traj.xyz T=1500.0 dt=1.0 N_steps=10 rng_seed=2065775975 atoms_in_file=${TEST}.in.xyz > ${TEST}.out.raw
egrep '^ST' ${TEST}.out.raw > ${TEST}.out
tail -8 ${TEST}.traj.xyz | awk '{print $1" "$2" "$3" "$4}' > ${TEST}.traj_pos.xyz

diff=diff
which ndiff > /dev/null && diff=ndiff

error=0
echo -n "$0: "
nr=`wc -l < ${TEST}.traj_ref.xyz`
nt=`wc -l < ${TEST}.traj_pos.xyz`
if [[ $nr != $nt ]]; then
   echo -n "final pos line number mismatch $nr $nt "
else
   if $diff ${TEST}.traj_ref.xyz ${TEST}.traj_pos.xyz  > /dev/null 2>&1; then
      echo -n "final pos OK "
   else
      echo -n "final pos differs "
      error=1
   fi
fi

nr=`wc -l < ${TEST}.out`
nt=`wc -l < ${TEST}.out_ref`
if [[ $nr != $nt ]]; then
   echo -n "output line number mismatch $nr $nt"
else
   if $diff ${TEST}.out_ref ${TEST}.out > /dev/null 2>&1; then
      echo -n "E/T OK"
   else
      echo -n "E/T differs"
      error=1
   fi
fi

echo ""

[[ $error == 0 ]] && rm -f ${TEST}.*
exit $error
