&DFT
  @IF ( ${BECKE_ACTIVE} == TRUE )
    @include becke_qs.inc
  @ENDIF
  @IF ( ${BECKE_ACTIVE} == FALSE )
    &QS
      METHOD GPW
      EPS_DEFAULT 1.0E-12
      MAP_CONSISTENT
      EXTRAPOLATION ASPC
      EXTRAPOLATION_ORDER 4
    &END QS
  @ENDIF
  BASIS_SET_FILE_NAME BASIS_MOLOPT
  POTENTIAL_FILE_NAME POTENTIAL
  @IF ( ${RESTART} == TRUE )
      WFN_RESTART_FILE_NAME ${WFN_FILE}
  @ENDIF
  LSD
  &MGRID
    CUTOFF ${PW_CUTOFF}
    NGRIDS 5
    REL_CUTOFF ${PW_REL_CUTOFF}
  &END MGRID
  &POISSON
    PERIODIC NONE
    POISSON_SOLVER WAVELET
    &MT
      ALPHA 7.0
      REL_CUTOFF 2
    &END MT
  &END POISSON
  &SCF
    @IF ( ${RESTART} == TRUE )
      SCF_GUESS RESTART
    @ENDIF
    @IF ( ${RESTART} == FALSE )
      SCF_GUESS ATOMIC
    @ENDIF
    EPS_SCF 1.0E-6
    CHOLESKY INVERSE_DBCSR
    MAX_SCF 20
    &OT ON
      MINIMIZER DIIS
      PRECONDITIONER FULL_ALL
      ALGORITHM IRAC
    &END OT
    &OUTER_SCF ON
      EPS_SCF 1.0E-6
      MAX_SCF 5
    &END
    &PRINT
      &RESTART ON
        FILENAME ./${NAME}
        BACKUP_COPIES 2
        COMMON_ITERATION_LEVELS 1
        &EACH
          JUST_ENERGY 1
          QS_SCF 0
        &END EACH
      &END RESTART
      &RESTART_HISTORY OFF
      &END RESTART_HISTORY
    &END PRINT
  &END SCF

  &XC
    &XC_FUNCTIONAL PBE
    &END XC_FUNCTIONAL
    &VDW_POTENTIAL
       POTENTIAL_TYPE PAIR_POTENTIAL
       &PAIR_POTENTIAL
         TYPE DFTD3(BJ)
         CALCULATE_C9_TERM .TRUE.
         REFERENCE_C9_TERM .TRUE.
         LONG_RANGE_CORRECTION .TRUE.
         PARAMETER_FILE_NAME dftd3.dat
         REFERENCE_FUNCTIONAL PBE
       &END PAIR_POTENTIAL
    &END VDW_POTENTIAL
  &END XC
  &PRINT
    &MULLIKEN ON
    &END MULLIKEN
    &LOWDIN ON
    &END LOWDIN
    @IF ( ${SAVE_CUBE} == TRUE )
      &E_DENSITY_CUBE ON
        ! Note the stride must be 1 1 1
        STRIDE 1 1 1
      &END E_DENSITY_CUBE
    @ENDIF
  &END PRINT
&END DFT
&PRINT
  &FORCES OFF
  &END
  &GRID_INFORMATION
  &END
&END