&QS
  METHOD GPW
  EPS_DEFAULT 1.0E-12
  MAP_CONSISTENT
  EXTRAPOLATION ASPC
  EXTRAPOLATION_ORDER 4
  &CDFT
    TYPE_OF_CONSTRAINT BECKE
    &OUTER_SCF ON
      EPS_SCF 1.0E-3
      MAX_SCF 10
      TYPE BECKE_CONSTRAINT
      EXTRAPOLATION_ORDER 2
      OPTIMIZER NEWTON_LS
      MAX_LS 5
      CONTINUE_LS
      FACTOR_LS 0.5
      STEP_SIZE -1.0
      JACOBIAN_STEP 1.0E-2
      JACOBIAN_FREQ 1 1
      JACOBIAN_TYPE FD1
      JACOBIAN_RESTART FALSE
    &END
  &END CDFT
  &BECKE_CONSTRAINT
    @IF ( ${BECKE_USE_RADII} == FALSE )
      ADJUST_SIZE     FALSE
    @ENDIF
    @IF ( ${BECKE_USE_RADII} == TRUE )
      ADJUST_SIZE     TRUE
      ! O H covalent radii (Pyykkö & Atsumi)
      ATOMIC_RADII    0.63 0.32
    @ENDIF
    ATOMIC_CHARGES  TRUE
    STRENGTH        ${BECKE_STR}
    TARGET          ${BECKE_TARGET}
    CUTOFF_TYPE     ELEMENT
    ELEMENT_CUTOFF  7.0 7.0
    IN_MEMORY       TRUE
    CAVITY_CONFINE  TRUE
    EPS_CAVITY      1.0E-7
    CAVITY_SHAPE    VDW
    SHOULD_SKIP     TRUE
    CAVITY_PRINT    FALSE
    &ATOM_GROUP
      ATOMS 1..3
      COEFF 1 1 1
      CONSTRAINT_TYPE CHARGE
      FRAGMENT_CONSTRAINT ${BECKE_FRAG_CONSTRAINT}
    &END ATOM_GROUP
    FRAGMENT_A_FILE      ${BECKE_FRAG_A}
    FRAGMENT_A_SPIN_FILE ${BECKE_FRAG_A_SPIN}
    FRAGMENT_B_FILE      ${BECKE_FRAG_B}
    FRAGMENT_B_SPIN_FILE ${BECKE_FRAG_B_SPIN}
    &DUMMY_ATOMS
      ATOMS 4..6
    &END DUMMY_ATOMS
    &PROGRAM_RUN_INFO ON
      &EACH
        QS_SCF 1
      &END EACH
      COMMON_ITERATION_LEVELS 2
      ADD_LAST NUMERIC
      FILENAME ./${NAME}
    &END PROGRAM_RUN_INFO
  &END BECKE_CONSTRAINT
&END QS
