&QS
  METHOD GPW
  EPS_DEFAULT 1.0E-12
  MAP_CONSISTENT
  EXTRAPOLATION ASPC
  EXTRAPOLATION_ORDER 4
  @IF ( ${CONSTR_ACTIVE} == TRUE )
    &CDFT
      TYPE_OF_CONSTRAINT HIRSHFELD
      ATOMIC_CHARGES  TRUE
      STRENGTH        ${CONSTR_STR}
      TARGET          ${CONSTR_TARGET}
      &ATOM_GROUP
        ATOMS 1
        COEFF 1
        CONSTRAINT_TYPE CHARGE
      &END ATOM_GROUP
      &DUMMY_ATOMS
        ATOMS 2
      &END DUMMY_ATOMS
      &OUTER_SCF ON
        TYPE CDFT_CONSTRAINT
        EXTRAPOLATION_ORDER 2
        MAX_SCF 10
        EPS_SCF 1.0E-3
        OPTIMIZER NEWTON_LS
        STEP_SIZE -2.0
        &CDFT_OPT ON
          MAX_LS 5
          CONTINUE_LS
          FACTOR_LS 0.5
          JACOBIAN_STEP 1.0E-2
          JACOBIAN_FREQ 1 1
          JACOBIAN_TYPE FD1
          JACOBIAN_RESTART FALSE
        &END CDFT_OPT
      &END
      &HIRSHFELD_CONSTRAINT
        SHAPE_FUNCTION ${HIRSHFELD_SHAPEFN}
        GAUSSIAN_SHAPE ${GAUSSIAN_SHAPE}
      &END HIRSHFELD_CONSTRAINT
      &PROGRAM_RUN_INFO ON
        &EACH
          QS_SCF 1
        &END EACH
        COMMON_ITERATION_LEVELS 2
        ADD_LAST NUMERIC
        FILENAME ./${NAME}
      &END PROGRAM_RUN_INFO
    &END CDFT
  @ENDIF
&END QS
