&QS
  METHOD GPW
  EPS_DEFAULT 1.0E-12
  MAP_CONSISTENT
  EXTRAPOLATION ASPC
  EXTRAPOLATION_ORDER 4
  @IF ( ${BECKE_ACTIVE} == TRUE )
    &CDFT
      TYPE_OF_CONSTRAINT BECKE
      ATOMIC_CHARGES  TRUE
      STRENGTH        ${BECKE_STR}
      TARGET          ${BECKE_TARGET}
      &ATOM_GROUP
        ATOMS ${BECKE_ATOM}
        COEFF 1
        CONSTRAINT_TYPE CHARGE
        FRAGMENT_CONSTRAINT ${BECKE_FRAG_CONSTRAINT}
      &END ATOM_GROUP
      FRAGMENT_A_FILE      ${BECKE_FRAG_A}
      FRAGMENT_A_SPIN_FILE ${BECKE_FRAG_A_SPIN}
      FRAGMENT_B_FILE      ${BECKE_FRAG_B}
      FRAGMENT_B_SPIN_FILE ${BECKE_FRAG_B_SPIN}
      &DUMMY_ATOMS
        ATOMS ${BECKE_DUMMY_ATOM}
      &END DUMMY_ATOMS
      &OUTER_SCF ON
        TYPE CDFT_CONSTRAINT
        EXTRAPOLATION_ORDER 2
        MAX_SCF 10
        EPS_SCF 1.0E-3
        OPTIMIZER NEWTON_LS
        STEP_SIZE -1.0
        &CDFT_OPT ON
          MAX_LS 5
          CONTINUE_LS
          FACTOR_LS 0.5
          JACOBIAN_STEP 1.0E-2
          JACOBIAN_FREQ 1 1
          JACOBIAN_TYPE FD1
          JACOBIAN_RESTART FALSE
        &END CDFT_OPT
      &END
      &BECKE_CONSTRAINT
        ADJUST_SIZE     FALSE
        CUTOFF_TYPE     ELEMENT
        ELEMENT_CUTOFF  7.0
        CAVITY_CONFINE  TRUE
        CAVITY_SHAPE    VDW
        EPS_CAVITY      1.0E-7
        IN_MEMORY       TRUE
        SHOULD_SKIP     TRUE
      &END BECKE_CONSTRAINT
      &PROGRAM_RUN_INFO ON
        &EACH
          QS_SCF 1
        &END EACH
        COMMON_ITERATION_LEVELS 2
        ADD_LAST NUMERIC
        FILENAME ./${NAME}
      &END PROGRAM_RUN_INFO
    &END CDFT
  @ENDIF
&END QS
