#!/usr/bin/gnuplot
f(x)=k*(x-x0)*(x-x0)+e0         # definition of the function to be fitted
delta = 0.002                   #
e0=0.06                         # initial value of e0
k = 500                         # initial value of k
x0=1                            # initial value of x0
set xlabel 'd (Angstrom)'       # label of the x-axis
set ylabel 'E (kcal/mol)'       # label of the y-axis
set title "c2h2 triple bond"    # main title

fit f(x) 'curve.amber.c2h2' u ($1):(($2)*627) via k,x0,e0
# fitting procedure
#    ^ function to be fitted
#             ^ take data from the file curve.a.c2h2
#               and use the first column as X and the second one
#               ax Y (all values of the second column are multiplied by 627. 1 Hartree = 627 kcal/mol)
#                                               ^ k, x0, e0 - are parameters to be adjusted

plot 'curve.amber.c2h2' u ($1):(($2)*627)-e0 t 'computed AMBER' w lp lw 2 ps 2 pt 7, f(x)-e0 t 'k*(x-x0)^2' w l lw 2
#         ^ take data for the first plot from the file curve.a.c2h2
#                               ^ use the firts column as X and the second as Y
#                                               ^ title of the first plot: computed AMBER
#                                                              ^ draw points and lines
#                                                                ^ line width = 2 
#                                                                      ^ point size = 2
#                                                                           ^ point type = 7 
#                                                                                  ^ plot function f(x)-e0
#                                                                                               ^ title of the second plot: k*(x-x0)^2
#                                                                                                        ^ draw only line
#                                                                                                             ^ line width = 2


pause mouse                     # exit by right-clicking on the plot window
#    EOF
