import argparse
import numpy as np, types
import scipy
from scipy.special import sph_harm
from ase.io import read,write
from ase.neighborlist import NeighborList
from ase.io import read 
from ase.data import covalent_radii ,atomic_numbers
from ase.data.colors import cpk_colors
import sys

####SECTION TO USE numpy cart2spher
####replace "ceval" if numexpr not installed
"""
from numpy import arctan2, sqrt
import numexpr as ne

def cart2sph(x,y,z, ceval=ne.evaluate):
#       x, y, z :  ndarray coordinates
#       ceval: backend to use: 
#             - eval :  pure Numpy
#             - numexpr.evaluate:  Numexpr     
    azimuth = ceval('arctan2(y,x)')
    xy2 = ceval('x**2 + y**2')
    elevation = ceval('arctan2(z, sqrt(xy2))')
    r = eval('sqrt(xy2 + z**2)')
    return azimuth, elevation, r
"""
####END SECTION CART2SPHER


parser = argparse.ArgumentParser(
    description='compute ql for a input geometry')
parser.add_argument(
    'filename',
    type=str,
    help='name of geometry file')

args = parser.parse_args()




geo=read(args.filename)
#print geo.cell
the_cell=[30,30,30]
geo.set_cell(the_cell,scale_atoms=False)
geo.center()
#geo.write("centered.xyz")

#rcut=1.391/2
rcut =float(raw_input("cutoff radius? \n"))
rcut=rcut/2
l =int(raw_input("value of l? \n"))


#cov_radii = [ covalent_radii[a.number] for a in s]
cov_radii = [ rcut for a in geo]
nl = NeighborList(cov_radii, skin=0, bothways = False, self_interaction = False)
nl.update(geo)

#l=4
nbonds=0
qlm=np.zeros(2*l+1)

####THE FOLLOWING CAN BE CONTRACTED AND cart2spher can be inserted
for atom_i in geo:
    nlist=nl.get_neighbors(atom_i.index)[0]
    for theneig in nlist :
        nbonds=nbonds+1
        rij=geo[theneig].position - atom_i.position
        dist=np.linalg.norm(rij)
        theta_ij = np.arctan2(rij[1],rij[0])
        if theta_ij < 0:
            theta_ij += 2*np.pi
        phi_ij   = np.arccos(rij[2]/dist)
        # In a like-oriented coordinate system at j, the spherical coordinates of atom i are:
        if theta_ij <= np.pi:
            theta_ji = theta_ij + np.pi
        elif theta_ij > np.pi:
            theta_ji = theta_ij - np.pi
        if np.absolute(theta_ji-2*np.pi)<0.0001:
            theta_ji=0.0
        phi_ji = np.pi-phi_ij

        qlm=qlm+np.array([sph_harm(m,l,theta_ij,phi_ij) for m in range(-l,l+1)  ] )
qlm=np.real(qlm*np.conj(qlm)/(nbonds*nbonds))
print np.sqrt(np.pi *4 /(2*l+1)*np.sum(qlm))

