&FORCE_EVAL					! This section defines method for calculating energy and forces
  METHOD FIST					! Using Molecular Mechanics
  &MM                                                                
    &FORCEFIELD					! This section specifies forcefield parameters
      parm_file_name ace_ala_nme.pot
! This file contains force field parameters
      parmtype CHM				! forcefield parameters has CHARMM format
      &SPLINE                                   ! This section specifies parameters to set up the splines use
! in the nonboned interactions (both pair body potential and many body potential)
        EMAX_SPLINE 1.0				! Specify the maximum value of the potential up to which splines will be constructed
      &END
    &END FORCEFIELD			
    &POISSON					! This section specifies parameters for the Poisson solver
      &EWALD					! This section specifies parameters for the EWALD summation method (for the electrostatics)
        EWALD_TYPE ewald			! Standard non-fft based ewald method
        ALPHA .36
        GMAX 29					! Number of grid points
      &END EWALD
    &END POISSON
    &PRINT					! This section controls printing options
      &FF_INFO
      &END
      &FF_PARAMETER_FILE
      &END
    &END
  &END MM
  &SUBSYS					! This section defines the syste
    &CELL					!  Unit cell set up
      ABC 50.0 50.0 50.0			! Lengths of the cell vectors A, B, and C
    &END CELL
    &TOPOLOGY
      CONN_FILE_NAME ace_ala_nme.psf
! File which contains the connectivity information
      CONNECTIVITY psf				! Format of the connectivity file is PSF
      COORD_FILE_NAME ini.b.pdb
! File which contains atom's coordinates of the system
      COORDINATE PDB				! Coordinates are in the PDB format
    &END TOPOLOGY
  &END SUBSYS
&END FORCE_EVAL

&GLOBAL						! Section with general information regarding which kind of simu lation to perform an parameters for the whole PROGRAM
  PRINT_LEVEL LOW				! Global print level
  PROJECT b_opt					! Name of the project. This word will appear as part of a name of all ouput files (except main ouput file, specified with -o option)
  RUN_TYPE GEO_OPT				! Run type is a geometry optimization
&END GLOBAL
&MOTION						! This section specifies a set of tool connected with the motion of the nuclei
 &PRINT						! This section controls the printing properties during an optimization or MD run
   &TRAJECTORY
    FORMAT PDB					! Format of  the ouput trajectory is PDB
    ADD_LAST NUMERIC				! (Wiki) If the last iteration should be added, and if it should be marked symbolically (with l) or with the iteration number.Not every iteration level is able to identify the last iteration early enough to be able to output. When this keyword is activated all iteration levels are checked for the last iteration step. 
    &EACH 
     GEO_OPT 100				! Print one frame every 100 iteration
    &END
   &END
 &END
 &GEO_OPT					! This section specifies optimizer options
    OPTIMIZER CG				! Type of the optimizer
    MAX_ITER 5000				! Maximum number of optimization steps
 &END
&END
