#!/usr/local/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Version 4.6 patchlevel 3    last modified 2013-04-12 
#    	Build System: Linux x86_64
#    
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2013
#    	Thomas Williams, Colin Kelley and many others
#    
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
#set terminal postscript enhanced color solid "Times-Roman" 16
#set output "c2h4.c2h2.eps"
set pm3d interpolate 1,1 flush begin noftriangles nohidden3d corners2color mean # defining drawing parameters
kcal=627				# coefficient of conversion from Hartree to kCal/mol
f(x)=k*(x-x0)*(x-x0)+e0			# definition of the function to be fitted
GNUTERM = "x11"
delta = 0.002				# 
k = 1.2					# initial value of k
x0=1.2					# initial value of x0
e0=-11					# initial value of e0
set title "c2h2 triple bond"		# main title
set xlabel 'd (Angstrom)'		# label of the x-axis
set ylabel 'E (kcal/mol)'		# label of the y-axis
set key bottom right			# 
fit f(x) 'curve.c2h2' u ($1):($2) via k,x0,e0
# fitting procedure
#    ^ function to be fitted
#	      ^ take data from the file curve.a.c2h2
#		and use the first column as X and the second one
#		ax Y 
#					^ k, x0, e0 - are parameters to be adjusted
plot 'curve.c2h2' u ($1):($2-e0)*kcal t 'computed DFT' w lp lw 2 ps 2 pt 7, (f(x)-e0)*kcal t 'k*(x-x0)^2' w l lw 2 
#	  ^ take data for the first plot from the file curve.c2h2
#				^ use the firts column as X and the second as Y
#						^ title of the first plot: computed DFT
#							^ draw points and lines
#							     ^ line width = 2 
#								 ^ point size = 2
#								       ^ point type = 7 
#										   ^ plot function (f(x)-e0)*kcal
#												^ title of the second plot: k*(x-x0)^2
#													   ^ draw only line
#													      ^ line width = 2
pause mouse				# continue by right-clicking on the plot window
g(x)=ka*(x-x0a)*(x-x0a)+e0a		# definition of the function to be fitted
delta = 0.002				
ka = 0.8				# initial value of ka
e0a=-12					# initial value of e0a
x0a=1.32				# initial value of x0a
set xlabel 'd (Angstrom)'		# label of the x-axis
set ylabel 'E (kcal/mol)'		# label of the y-axis
set title "c2h4 double bond"		# main title
fit g(x) 'curve.c2h4' u ($1):(($2)) via ka,x0a,e0a
# fitting procedure
#    ^ function to be fitted
#	      ^ take data from the file curve.a.c2h2
#		and use the first column as X and the second one
#		ax Y 
#					^ ka, x0a, e0a - are the parameters to be adjusted
plot 'curve.c2h4' u ($1):($2-e0a)*kcal t 'computed DFT' w lp lw 2 ps 2 pt 7, (g(x)-e0a)*kcal t 'ka*(x-x0a)^2' w l lw 2 
#	  ^ take data for the first plot from the file curve.c2h4
#				^ use the firts column as X and the second as Y
#						^ title of the first plot: computed DFT
#							^ draw points and lines
#							     ^ line width = 2 
#								   ^ point size = 2
#								       ^ point type = 7 
#										   ^ plot function (g(x)-e0a)*kcal
#												^ title of the second plot: ka*(x-x0)^2
#														^ draw only line
#														    ^ line width = 2
pause mouse				# continue by right-clicking on the plot window
set title "c2h2 vs. c2h4"		# main title
set xlabel 'd-d0 (Angstrom)'		# label of the x-axis

print " "
print " "
print " "
print "c2h2: k= ",k*kcal," kcal/mol/A^2  x0= ",x0," Angstrom"
print "c2h4: k= ",ka*kcal," kcal/mol/A^2  x0= ",x0a," Angstrom"
plot 'curve.c2h4' u ($1-x0a):($2-e0a)*kcal t 'c2h4' w lp lw 2 ps 2 pt 6,  'curve.c2h2' u ($1-x0):($2-e0)*kcal t 'c2h2' w lp lw 2 ps 2 pt 7
#	  ^ take data for the first plot from the file curve.c2h4
#				^ use the firts column as X and the second as Y
#						^ title of the first plot: c2h4
#						       ^ draw points and lines
#							  ^ line width = 2 
#							       ^ point size = 2
#								    ^ point type = 6 
#										 ^ take data for the first plot from the file curve.c2h2
#												^ use the firts column as X and the second as Y
#													        ^ title of the second plot: c2h2
#															  ^ draw points and lines
#													      		     ^ line width = 2
#															          ^ point size = 2
#																	^ point type = 7
#    EOF
pause mouse				# continue by right-clicking on the plot window
